import React, { useEffect, useState } from 'react'
import { NavLink } from 'react-router-dom'
import {useAuthenticatedFetch} from '../hooks'

export function TopBar() {
  let fetch = useAuthenticatedFetch();
  let [storeName,setStoreName] = useState("Istiyal");
  useEffect(() => {
    const fetchData = async () => {
      try {
        let request = await fetch("/api/store/info", {
          method: "GET",
          headers: { "Content-Type": "application/json" }
        });
        let response = await request.json();
        setStoreName(response.data[0].name);
        console.log('response : ', response);
      } catch (error) {
        console.error('Error fetching data:', error);
      }
    };
    fetchData(); 
    return () => {
    };
  }, []);

 
  return (
    <div className='topbar-section'>
        <div className="logo-block">
            <img className='logo' src="../assets/logo.png" alt="logo image" />
            <h1 className='text-bold h4'>{storeName}</h1>
            {/* <NavLink to="/"> Sales </NavLink>
            <NavLink to="/products"> Products </NavLink> */}
        </div>
    </div>
  )
}