import {
  _inheritsLoose
} from "./chunk-JDRVSTJK.js";
import {
  require_react_dom
} from "./chunk-CEMNSV2C.js";
import {
  _objectWithoutPropertiesLoose,
  init_objectWithoutPropertiesLoose,
  require_prop_types
} from "./chunk-IFXYGWWO.js";
import {
  _extends,
  init_extends
} from "./chunk-KVTXF6MW.js";
import {
  require_react
} from "./chunk-JV4D4GUK.js";
import {
  __commonJS,
  __toESM
} from "./chunk-2GTGKKMZ.js";

// ../../node_modules/react-fast-compare/index.js
var require_react_fast_compare = __commonJS({
  "../../node_modules/react-fast-compare/index.js"(exports, module) {
    var hasElementType = typeof Element !== "undefined";
    var hasMap = typeof Map === "function";
    var hasSet = typeof Set === "function";
    var hasArrayBuffer = typeof ArrayBuffer === "function" && !!ArrayBuffer.isView;
    function equal(a, b) {
      if (a === b)
        return true;
      if (a && b && typeof a == "object" && typeof b == "object") {
        if (a.constructor !== b.constructor)
          return false;
        var length, i, keys;
        if (Array.isArray(a)) {
          length = a.length;
          if (length != b.length)
            return false;
          for (i = length; i-- !== 0; )
            if (!equal(a[i], b[i]))
              return false;
          return true;
        }
        var it;
        if (hasMap && a instanceof Map && b instanceof Map) {
          if (a.size !== b.size)
            return false;
          it = a.entries();
          while (!(i = it.next()).done)
            if (!b.has(i.value[0]))
              return false;
          it = a.entries();
          while (!(i = it.next()).done)
            if (!equal(i.value[1], b.get(i.value[0])))
              return false;
          return true;
        }
        if (hasSet && a instanceof Set && b instanceof Set) {
          if (a.size !== b.size)
            return false;
          it = a.entries();
          while (!(i = it.next()).done)
            if (!b.has(i.value[0]))
              return false;
          return true;
        }
        if (hasArrayBuffer && ArrayBuffer.isView(a) && ArrayBuffer.isView(b)) {
          length = a.length;
          if (length != b.length)
            return false;
          for (i = length; i-- !== 0; )
            if (a[i] !== b[i])
              return false;
          return true;
        }
        if (a.constructor === RegExp)
          return a.source === b.source && a.flags === b.flags;
        if (a.valueOf !== Object.prototype.valueOf && typeof a.valueOf === "function" && typeof b.valueOf === "function")
          return a.valueOf() === b.valueOf();
        if (a.toString !== Object.prototype.toString && typeof a.toString === "function" && typeof b.toString === "function")
          return a.toString() === b.toString();
        keys = Object.keys(a);
        length = keys.length;
        if (length !== Object.keys(b).length)
          return false;
        for (i = length; i-- !== 0; )
          if (!Object.prototype.hasOwnProperty.call(b, keys[i]))
            return false;
        if (hasElementType && a instanceof Element)
          return false;
        for (i = length; i-- !== 0; ) {
          if ((keys[i] === "_owner" || keys[i] === "__v" || keys[i] === "__o") && a.$$typeof) {
            continue;
          }
          if (!equal(a[keys[i]], b[keys[i]]))
            return false;
        }
        return true;
      }
      return a !== a && b !== b;
    }
    module.exports = function isEqual4(a, b) {
      try {
        return equal(a, b);
      } catch (error) {
        if ((error.message || "").match(/stack|recursion/i)) {
          console.warn("react-fast-compare cannot handle circular refs");
          return false;
        }
        throw error;
      }
    };
  }
});

// ../node_modules/@shopify/polaris/build/esm/configure.js
if (typeof window !== "undefined") {
  window.Polaris = window.Polaris || {};
  window.Polaris.VERSION = "10.50.1";
}
var DEFAULT_LOCALE = "en";
var SUPPORTED_LOCALES = ["cs", "da", "de", "en", "es", "fi", "fr", "it", "ja", "ko", "nb", "nl", "pl", "pt-BR", "pt-PT", "sv", "th", "tr", "vi", "zh-CN", "zh-TW"];

// ../node_modules/@shopify/polaris/build/esm/types.js
var Key;
(function(Key2) {
  Key2[Key2["Backspace"] = 8] = "Backspace";
  Key2[Key2["Tab"] = 9] = "Tab";
  Key2[Key2["Enter"] = 13] = "Enter";
  Key2[Key2["Shift"] = 16] = "Shift";
  Key2[Key2["Ctrl"] = 17] = "Ctrl";
  Key2[Key2["Alt"] = 18] = "Alt";
  Key2[Key2["Pause"] = 19] = "Pause";
  Key2[Key2["CapsLock"] = 20] = "CapsLock";
  Key2[Key2["Escape"] = 27] = "Escape";
  Key2[Key2["Space"] = 32] = "Space";
  Key2[Key2["PageUp"] = 33] = "PageUp";
  Key2[Key2["PageDown"] = 34] = "PageDown";
  Key2[Key2["End"] = 35] = "End";
  Key2[Key2["Home"] = 36] = "Home";
  Key2[Key2["LeftArrow"] = 37] = "LeftArrow";
  Key2[Key2["UpArrow"] = 38] = "UpArrow";
  Key2[Key2["RightArrow"] = 39] = "RightArrow";
  Key2[Key2["DownArrow"] = 40] = "DownArrow";
  Key2[Key2["Insert"] = 45] = "Insert";
  Key2[Key2["Delete"] = 46] = "Delete";
  Key2[Key2["Key0"] = 48] = "Key0";
  Key2[Key2["Key1"] = 49] = "Key1";
  Key2[Key2["Key2"] = 50] = "Key2";
  Key2[Key2["Key3"] = 51] = "Key3";
  Key2[Key2["Key4"] = 52] = "Key4";
  Key2[Key2["Key5"] = 53] = "Key5";
  Key2[Key2["Key6"] = 54] = "Key6";
  Key2[Key2["Key7"] = 55] = "Key7";
  Key2[Key2["Key8"] = 56] = "Key8";
  Key2[Key2["Key9"] = 57] = "Key9";
  Key2[Key2["KeyA"] = 65] = "KeyA";
  Key2[Key2["KeyB"] = 66] = "KeyB";
  Key2[Key2["KeyC"] = 67] = "KeyC";
  Key2[Key2["KeyD"] = 68] = "KeyD";
  Key2[Key2["KeyE"] = 69] = "KeyE";
  Key2[Key2["KeyF"] = 70] = "KeyF";
  Key2[Key2["KeyG"] = 71] = "KeyG";
  Key2[Key2["KeyH"] = 72] = "KeyH";
  Key2[Key2["KeyI"] = 73] = "KeyI";
  Key2[Key2["KeyJ"] = 74] = "KeyJ";
  Key2[Key2["KeyK"] = 75] = "KeyK";
  Key2[Key2["KeyL"] = 76] = "KeyL";
  Key2[Key2["KeyM"] = 77] = "KeyM";
  Key2[Key2["KeyN"] = 78] = "KeyN";
  Key2[Key2["KeyO"] = 79] = "KeyO";
  Key2[Key2["KeyP"] = 80] = "KeyP";
  Key2[Key2["KeyQ"] = 81] = "KeyQ";
  Key2[Key2["KeyR"] = 82] = "KeyR";
  Key2[Key2["KeyS"] = 83] = "KeyS";
  Key2[Key2["KeyT"] = 84] = "KeyT";
  Key2[Key2["KeyU"] = 85] = "KeyU";
  Key2[Key2["KeyV"] = 86] = "KeyV";
  Key2[Key2["KeyW"] = 87] = "KeyW";
  Key2[Key2["KeyX"] = 88] = "KeyX";
  Key2[Key2["KeyY"] = 89] = "KeyY";
  Key2[Key2["KeyZ"] = 90] = "KeyZ";
  Key2[Key2["LeftMeta"] = 91] = "LeftMeta";
  Key2[Key2["RightMeta"] = 92] = "RightMeta";
  Key2[Key2["Select"] = 93] = "Select";
  Key2[Key2["Numpad0"] = 96] = "Numpad0";
  Key2[Key2["Numpad1"] = 97] = "Numpad1";
  Key2[Key2["Numpad2"] = 98] = "Numpad2";
  Key2[Key2["Numpad3"] = 99] = "Numpad3";
  Key2[Key2["Numpad4"] = 100] = "Numpad4";
  Key2[Key2["Numpad5"] = 101] = "Numpad5";
  Key2[Key2["Numpad6"] = 102] = "Numpad6";
  Key2[Key2["Numpad7"] = 103] = "Numpad7";
  Key2[Key2["Numpad8"] = 104] = "Numpad8";
  Key2[Key2["Numpad9"] = 105] = "Numpad9";
  Key2[Key2["Multiply"] = 106] = "Multiply";
  Key2[Key2["Add"] = 107] = "Add";
  Key2[Key2["Subtract"] = 109] = "Subtract";
  Key2[Key2["Decimal"] = 110] = "Decimal";
  Key2[Key2["Divide"] = 111] = "Divide";
  Key2[Key2["F1"] = 112] = "F1";
  Key2[Key2["F2"] = 113] = "F2";
  Key2[Key2["F3"] = 114] = "F3";
  Key2[Key2["F4"] = 115] = "F4";
  Key2[Key2["F5"] = 116] = "F5";
  Key2[Key2["F6"] = 117] = "F6";
  Key2[Key2["F7"] = 118] = "F7";
  Key2[Key2["F8"] = 119] = "F8";
  Key2[Key2["F9"] = 120] = "F9";
  Key2[Key2["F10"] = 121] = "F10";
  Key2[Key2["F11"] = 122] = "F11";
  Key2[Key2["F12"] = 123] = "F12";
  Key2[Key2["NumLock"] = 144] = "NumLock";
  Key2[Key2["ScrollLock"] = 145] = "ScrollLock";
  Key2[Key2["Semicolon"] = 186] = "Semicolon";
  Key2[Key2["Equals"] = 187] = "Equals";
  Key2[Key2["Comma"] = 188] = "Comma";
  Key2[Key2["Dash"] = 189] = "Dash";
  Key2[Key2["Period"] = 190] = "Period";
  Key2[Key2["ForwardSlash"] = 191] = "ForwardSlash";
  Key2[Key2["GraveAccent"] = 192] = "GraveAccent";
  Key2[Key2["OpenBracket"] = 219] = "OpenBracket";
  Key2[Key2["BackSlash"] = 220] = "BackSlash";
  Key2[Key2["CloseBracket"] = 221] = "CloseBracket";
  Key2[Key2["SingleQuote"] = 222] = "SingleQuote";
})(Key || (Key = {}));

// ../node_modules/@shopify/polaris/build/esm/components/shared.js
var scrollable = {
  props: {
    "data-polaris-scrollable": true
  },
  selector: "[data-polaris-scrollable]"
};
var overlay = {
  props: {
    "data-polaris-overlay": true
  },
  selector: "[data-polaris-overlay]"
};
var layer = {
  props: {
    "data-polaris-layer": true
  },
  selector: "[data-polaris-layer]"
};
var unstyled = {
  props: {
    "data-polaris-unstyled": true
  },
  selector: "[data-polaris-unstyled]"
};
var dataPolarisTopBar = {
  props: {
    "data-polaris-top-bar": true
  },
  selector: "[data-polaris-top-bar]"
};
var headerCell = {
  props: {
    "data-polaris-header-cell": true
  },
  selector: "[data-polaris-header-cell]"
};
var portal = {
  props: ["data-portal-id"],
  selector: "[data-portal-id]"
};
var DATA_ATTRIBUTE = {
  overlay,
  layer
};

// ../node_modules/@shopify/polaris/build/esm/utilities/clamp.js
function clamp(number, min, max) {
  if (number < min)
    return min;
  if (number > max)
    return max;
  return number;
}

// ../node_modules/@shopify/polaris/build/esm/utilities/roundNumberToDecimalPlaces.js
function roundNumberToDecimalPlaces(value, decimals) {
  const exponent = Number(`${value}e${decimals}`);
  const roundedExponent = Math.round(exponent);
  const numberWithDecimalPlaces = Number(`${roundedExponent}e-${decimals}`);
  return numberWithDecimalPlaces;
}

// ../node_modules/@shopify/polaris/build/esm/utilities/color-transformers.js
function rgbString(color2) {
  const {
    red: red2,
    green: green2,
    blue: blue2
  } = color2;
  if ("alpha" in color2) {
    return `rgba(${red2}, ${green2}, ${blue2}, ${color2.alpha})`;
  } else {
    return `rgb(${red2}, ${green2}, ${blue2})`;
  }
}
var rgbaString = rgbString;
function rgbToHex({
  red: red2,
  green: green2,
  blue: blue2
}) {
  return `#${componentToHex(red2)}${componentToHex(green2)}${componentToHex(blue2)}`;
}
function componentToHex(component) {
  const hex = component.toString(16);
  return hex.length === 1 ? `0${hex}` : hex;
}
function hsbToHex(color2) {
  return rgbToHex(hsbToRgb(color2));
}
function rgbFromHueAndChroma(hue, chroma) {
  const huePrime = hue / 60;
  const hueDelta = 1 - Math.abs(huePrime % 2 - 1);
  const intermediateValue = chroma * hueDelta;
  let red2 = 0;
  let green2 = 0;
  let blue2 = 0;
  if (huePrime >= 0 && huePrime <= 1) {
    red2 = chroma;
    green2 = intermediateValue;
    blue2 = 0;
  }
  if (huePrime >= 1 && huePrime <= 2) {
    red2 = intermediateValue;
    green2 = chroma;
    blue2 = 0;
  }
  if (huePrime >= 2 && huePrime <= 3) {
    red2 = 0;
    green2 = chroma;
    blue2 = intermediateValue;
  }
  if (huePrime >= 3 && huePrime <= 4) {
    red2 = 0;
    green2 = intermediateValue;
    blue2 = chroma;
  }
  if (huePrime >= 4 && huePrime <= 5) {
    red2 = intermediateValue;
    green2 = 0;
    blue2 = chroma;
  }
  if (huePrime >= 5 && huePrime <= 6) {
    red2 = chroma;
    green2 = 0;
    blue2 = intermediateValue;
  }
  return {
    red: red2,
    green: green2,
    blue: blue2
  };
}
function hsbToRgb(color2) {
  const {
    hue,
    saturation,
    brightness,
    alpha = 1
  } = color2;
  const chroma = brightness * saturation;
  let {
    red: red2,
    green: green2,
    blue: blue2
  } = rgbFromHueAndChroma(hue, chroma);
  const chromaBrightnessDelta = brightness - chroma;
  red2 += chromaBrightnessDelta;
  green2 += chromaBrightnessDelta;
  blue2 += chromaBrightnessDelta;
  return {
    red: Math.round(red2 * 255),
    green: Math.round(green2 * 255),
    blue: Math.round(blue2 * 255),
    alpha
  };
}
function hslToRgb(color2) {
  const {
    hue,
    saturation,
    lightness,
    alpha = 1
  } = color2;
  const chroma = (1 - Math.abs(2 * (lightness / 100) - 1)) * (saturation / 100);
  let {
    red: red2,
    green: green2,
    blue: blue2
  } = rgbFromHueAndChroma(hue, chroma);
  const lightnessVal = lightness / 100 - chroma / 2;
  red2 += lightnessVal;
  green2 += lightnessVal;
  blue2 += lightnessVal;
  return {
    red: Math.round(red2 * 255),
    green: Math.round(green2 * 255),
    blue: Math.round(blue2 * 255),
    alpha
  };
}
function rgbToHsbl(color2, type = "b") {
  const {
    alpha = 1
  } = color2;
  const red2 = color2.red / 255;
  const green2 = color2.green / 255;
  const blue2 = color2.blue / 255;
  const largestComponent = Math.max(red2, green2, blue2);
  const smallestComponent = Math.min(red2, green2, blue2);
  const delta = largestComponent - smallestComponent;
  const lightness = (largestComponent + smallestComponent) / 2;
  let saturation = 0;
  if (largestComponent === 0) {
    saturation = 0;
  } else if (type === "b") {
    saturation = delta / largestComponent;
  } else if (type === "l") {
    const baseSaturation = lightness > 0.5 ? delta / (2 - largestComponent - smallestComponent) : delta / (largestComponent + smallestComponent);
    saturation = isNaN(baseSaturation) ? 0 : baseSaturation;
  }
  let huePercentage = 0;
  switch (largestComponent) {
    case red2:
      huePercentage = (green2 - blue2) / delta + (green2 < blue2 ? 6 : 0);
      break;
    case green2:
      huePercentage = (blue2 - red2) / delta + 2;
      break;
    case blue2:
      huePercentage = (red2 - green2) / delta + 4;
  }
  const hue = huePercentage / 6 * 360;
  const clampedHue = clamp(hue, 0, 360);
  return {
    hue: clampedHue ? roundNumberToDecimalPlaces(clampedHue, 2) : 0,
    saturation: roundNumberToDecimalPlaces(clamp(saturation, 0, 1), 4),
    brightness: roundNumberToDecimalPlaces(clamp(largestComponent, 0, 1), 4),
    lightness: roundNumberToDecimalPlaces(lightness, 4),
    alpha: roundNumberToDecimalPlaces(alpha, 4)
  };
}
function rgbToHsb(color2) {
  const {
    hue,
    saturation,
    brightness,
    alpha = 1
  } = rgbToHsbl(color2, "b");
  return {
    hue,
    saturation,
    brightness,
    alpha
  };
}
function rgbToHsl(color2) {
  const {
    hue,
    saturation: rawSaturation,
    lightness: rawLightness,
    alpha = 1
  } = rgbToHsbl(color2, "l");
  const saturation = roundNumberToDecimalPlaces(rawSaturation * 100, 2);
  const lightness = roundNumberToDecimalPlaces(rawLightness * 100, 2);
  return {
    hue,
    saturation,
    lightness,
    alpha
  };
}
function hexToRgb(color2) {
  if (color2.length === 4) {
    const repeatHex = (hex1, hex2) => color2.slice(hex1, hex2).repeat(2);
    const red3 = parseInt(repeatHex(1, 2), 16);
    const green3 = parseInt(repeatHex(2, 3), 16);
    const blue3 = parseInt(repeatHex(3, 4), 16);
    return {
      red: red3,
      green: green3,
      blue: blue3
    };
  }
  const red2 = parseInt(color2.slice(1, 3), 16);
  const green2 = parseInt(color2.slice(3, 5), 16);
  const blue2 = parseInt(color2.slice(5, 7), 16);
  return {
    red: red2,
    green: green2,
    blue: blue2
  };
}

// ../node_modules/@shopify/polaris/build/esm/utilities/within-content-context.js
var import_react = __toESM(require_react());
var WithinContentContext = (0, import_react.createContext)(false);

// ../node_modules/@shopify/polaris/build/esm/utilities/use-event-listener.js
var import_react3 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/use-isomorphic-layout-effect.js
var import_react2 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/target.js
var isServer = typeof window === "undefined" || typeof document === "undefined";

// ../node_modules/@shopify/polaris/build/esm/utilities/use-isomorphic-layout-effect.js
var useIsomorphicLayoutEffect = isServer ? import_react2.useEffect : import_react2.useLayoutEffect;

// ../node_modules/@shopify/polaris/build/esm/utilities/use-event-listener.js
function useEventListener(eventName, handler, target, options) {
  const handlerRef = (0, import_react3.useRef)(handler);
  const optionsRef = (0, import_react3.useRef)(options);
  useIsomorphicLayoutEffect(() => {
    handlerRef.current = handler;
  }, [handler]);
  useIsomorphicLayoutEffect(() => {
    optionsRef.current = options;
  }, [options]);
  (0, import_react3.useEffect)(() => {
    if (!(typeof eventName === "string" && target !== null))
      return;
    let targetElement;
    if (typeof target === "undefined") {
      targetElement = window;
    } else if ("current" in target) {
      if (target.current === null)
        return;
      targetElement = target.current;
    } else {
      targetElement = target;
    }
    const eventOptions = optionsRef.current;
    const eventListener = (event) => handlerRef.current(event);
    targetElement.addEventListener(eventName, eventListener, eventOptions);
    return () => {
      targetElement.removeEventListener(eventName, eventListener, eventOptions);
    };
  }, [eventName, target]);
}

// ../node_modules/@shopify/polaris/build/esm/utilities/use-index-resource-state.js
var import_react4 = __toESM(require_react());
var SelectionType;
(function(SelectionType3) {
  SelectionType3["All"] = "all";
  SelectionType3["Page"] = "page";
  SelectionType3["Multi"] = "multi";
  SelectionType3["Single"] = "single";
})(SelectionType || (SelectionType = {}));
function defaultResourceIDResolver(resource) {
  if ("id" in resource) {
    return resource.id;
  }
  throw new Error("Your resource does not directly contain an `id`. Pass a `resourceIDResolver` to `useIndexResourceState`");
}
function useIndexResourceState(resources, {
  selectedResources: initSelectedResources = [],
  allResourcesSelected: initAllResourcesSelected = false,
  resourceIDResolver = defaultResourceIDResolver,
  resourceFilter = void 0
} = {
  selectedResources: [],
  allResourcesSelected: false,
  resourceIDResolver: defaultResourceIDResolver,
  resourceFilter: void 0
}) {
  const [selectedResources, setSelectedResources] = (0, import_react4.useState)(initSelectedResources);
  const [allResourcesSelected, setAllResourcesSelected] = (0, import_react4.useState)(initAllResourcesSelected);
  const handleSelectionChange = (0, import_react4.useCallback)((selectionType, isSelecting, selection) => {
    if (selectionType === SelectionType.All) {
      setAllResourcesSelected(isSelecting);
    } else if (allResourcesSelected) {
      setAllResourcesSelected(false);
    }
    switch (selectionType) {
      case SelectionType.Single:
        setSelectedResources((newSelectedResources) => isSelecting ? [...newSelectedResources, selection] : newSelectedResources.filter((id) => id !== selection));
        break;
      case SelectionType.All:
      case SelectionType.Page:
        if (resourceFilter) {
          const filteredResources = resources.filter(resourceFilter);
          setSelectedResources(isSelecting && selectedResources.length < filteredResources.length ? filteredResources.map(resourceIDResolver) : []);
        } else {
          setSelectedResources(isSelecting ? resources.map(resourceIDResolver) : []);
        }
        break;
      case SelectionType.Multi:
        if (!selection)
          break;
        setSelectedResources((newSelectedResources) => {
          const ids = [];
          const filteredResources = resourceFilter ? resources.filter(resourceFilter) : resources;
          for (let i = selection[0]; i <= selection[1]; i++) {
            if (filteredResources.includes(resources[i])) {
              const id = resourceIDResolver(resources[i]);
              if (isSelecting && !newSelectedResources.includes(id) || !isSelecting && newSelectedResources.includes(id)) {
                ids.push(id);
              }
            }
          }
          return isSelecting ? [...newSelectedResources, ...ids] : newSelectedResources.filter((id) => !ids.includes(id));
        });
        break;
    }
  }, [allResourcesSelected, resourceFilter, selectedResources.length, resources, resourceIDResolver]);
  const clearSelection = (0, import_react4.useCallback)(() => {
    setSelectedResources([]);
    setAllResourcesSelected(false);
  }, []);
  const removeSelectedResources = (0, import_react4.useCallback)((removeResources) => {
    const selectedResourcesCopy = [...selectedResources];
    const newSelectedResources = selectedResourcesCopy.filter((resource) => !removeResources.includes(resource));
    setSelectedResources(newSelectedResources);
    if (newSelectedResources.length === 0) {
      setAllResourcesSelected(false);
    }
  }, [selectedResources]);
  return {
    selectedResources,
    allResourcesSelected,
    handleSelectionChange,
    clearSelection,
    removeSelectedResources
  };
}

// ../node_modules/@shopify/polaris/build/esm/utilities/breakpoints.js
var import_react5 = __toESM(require_react());

// ../node_modules/@shopify/polaris-tokens/dist/esm/_virtual/_rollupPluginBabelHelpers.mjs
function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread2(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = null != arguments[i] ? arguments[i] : {};
    i % 2 ? ownKeys(Object(source), true).forEach(function(key) {
      _defineProperty(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _taggedTemplateLiteral(strings, raw) {
  if (!raw) {
    raw = strings.slice(0);
  }
  return Object.freeze(Object.defineProperties(strings, {
    raw: {
      value: Object.freeze(raw)
    }
  }));
}
function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
}
function _arrayWithHoles(arr) {
  if (Array.isArray(arr))
    return arr;
}
function _iterableToArrayLimit(arr, i) {
  var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];
  if (_i == null)
    return;
  var _arr = [];
  var _n = true;
  var _d = false;
  var _s, _e;
  try {
    for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);
      if (i && _arr.length === i)
        break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null)
        _i["return"]();
    } finally {
      if (_d)
        throw _e;
    }
  }
  return _arr;
}
function _unsupportedIterableToArray(o, minLen) {
  if (!o)
    return;
  if (typeof o === "string")
    return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor)
    n = o.constructor.name;
  if (n === "Map" || n === "Set")
    return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
    return _arrayLikeToArray(o, minLen);
}
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length)
    len = arr.length;
  for (var i = 0, arr2 = new Array(len); i < len; i++)
    arr2[i] = arr[i];
  return arr2;
}
function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

// ../node_modules/@shopify/polaris-tokens/dist/esm/src/utilities.mjs
var _templateObject;
var BASE_FONT_SIZE = 16;
var UNIT_PX = "px";
var UNIT_EM = "em";
var UNIT_REM = "rem";
var DIGIT_REGEX = new RegExp(String.raw(_templateObject || (_templateObject = _taggedTemplateLiteral(["-?d+(?:.d+|d*)"], ["-?\\d+(?:\\.\\d+|\\d*)"]))));
var UNIT_REGEX = new RegExp("".concat(UNIT_PX, "|").concat(UNIT_EM, "|").concat(UNIT_REM));
function getUnit() {
  var value = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : "";
  var unit = value.match(new RegExp("".concat(DIGIT_REGEX.source, "(").concat(UNIT_REGEX.source, ")")));
  return unit && unit[1];
}
function toPx() {
  var value = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : "";
  var unit = getUnit(value);
  if (!unit)
    return value;
  if (unit === UNIT_PX) {
    return value;
  }
  if (unit === UNIT_EM || unit === UNIT_REM) {
    return "".concat(parseFloat(value) * BASE_FONT_SIZE).concat(UNIT_PX);
  }
}
function toEm() {
  var value = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : "";
  var fontSize = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : BASE_FONT_SIZE;
  var unit = getUnit(value);
  if (!unit)
    return value;
  if (unit === UNIT_EM) {
    return value;
  }
  if (unit === UNIT_PX) {
    return "".concat(parseFloat(value) / fontSize).concat(UNIT_EM);
  }
  if (unit === UNIT_REM) {
    return "".concat(parseFloat(value) * BASE_FONT_SIZE / fontSize).concat(UNIT_EM);
  }
}
function toRem() {
  var value = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : "";
  var unit = getUnit(value);
  if (!unit)
    return value;
  if (unit === UNIT_REM) {
    return value;
  }
  if (unit === UNIT_EM) {
    return "".concat(parseFloat(value)).concat(UNIT_REM);
  }
  if (unit === UNIT_PX) {
    return "".concat(parseFloat(value) / BASE_FONT_SIZE).concat(UNIT_REM);
  }
}
function rem(value) {
  return value.replace(new RegExp("".concat(DIGIT_REGEX.source, "(").concat(UNIT_PX, ")"), "g"), function(px) {
    var _toRem;
    return (_toRem = toRem(px)) !== null && _toRem !== void 0 ? _toRem : px;
  });
}
function tokensToRems(tokenGroup) {
  return Object.fromEntries(
    Object.entries(tokenGroup).map(function(_ref) {
      var _ref2 = _slicedToArray(_ref, 2), token = _ref2[0], properties = _ref2[1];
      return [token, _objectSpread2(_objectSpread2({}, properties), {}, {
        value: rem(properties.value)
      })];
    })
    // We loose the `tokenGroup` inference after transforming the object with
    // `Object.fromEntries()` and `Object.entries()`. Thus, we cast the result
    // back to `T` since we are simply converting the `value` from px to rem.
  );
}
function getMediaConditions(breakpoints3) {
  var breakpointEntries = Object.entries(breakpoints3);
  var lastBreakpointIndex = breakpointEntries.length - 1;
  return Object.fromEntries(breakpointEntries.map(function(entry, index) {
    var _ref7 = entry, _ref8 = _slicedToArray(_ref7, 2), breakpointsTokenName = _ref8[0], breakpoint = _ref8[1];
    var upMediaCondition = getUpMediaCondition(breakpoint);
    var downMediaCondition = getDownMediaCondition(breakpoint);
    var onlyMediaCondition = index === lastBreakpointIndex ? upMediaCondition : "".concat(upMediaCondition, " and ").concat(getDownMediaCondition(breakpointEntries[index + 1][1]));
    return [breakpointsTokenName, {
      // Media condition for the current breakpoint and up
      up: upMediaCondition,
      // Media condition for current breakpoint and down
      down: downMediaCondition,
      // Media condition for only the current breakpoint
      only: onlyMediaCondition
    }];
  }));
}
function getUpMediaCondition(breakpoint) {
  return "(min-width: ".concat(toEm(breakpoint), ")");
}
function getDownMediaCondition(breakpoint) {
  var _toPx;
  var offsetBreakpoint = parseFloat((_toPx = toPx(breakpoint)) !== null && _toPx !== void 0 ? _toPx : "") - 0.04;
  return "(max-width: ".concat(toEm("".concat(offsetBreakpoint, "px")), ")");
}

// ../node_modules/@shopify/polaris-tokens/dist/esm/src/token-groups/breakpoints.mjs
var breakpoints = {
  "breakpoints-xs": {
    value: "0px",
    description: "Commonly used for sizing containers (e.g. max-width). See below for media query usage."
  },
  "breakpoints-sm": {
    value: "490px",
    description: "Commonly used for sizing containers (e.g. max-width). See below for media query usage."
  },
  "breakpoints-md": {
    value: "768px",
    description: "Commonly used for sizing containers (e.g. max-width). See below for media query usage."
  },
  "breakpoints-lg": {
    value: "1040px",
    description: "Commonly used for sizing containers (e.g. max-width). See below for media query usage."
  },
  "breakpoints-xl": {
    value: "1440px",
    description: "Commonly used for sizing containers (e.g. max-width). See below for media query usage."
  }
};

// ../node_modules/@shopify/polaris-tokens/dist/esm/src/token-groups/border.mjs
var border = {
  "border-radius-05": {
    value: "2px"
  },
  "border-radius-1": {
    value: "4px"
  },
  "border-radius-2": {
    value: "8px"
  },
  "border-radius-3": {
    value: "12px"
  },
  "border-radius-4": {
    value: "16px"
  },
  "border-radius-5": {
    value: "20px"
  },
  "border-radius-6": {
    value: "30px"
  },
  "border-radius-full": {
    value: "9999px"
  },
  "border-width-1": {
    value: "1px"
  },
  "border-width-2": {
    value: "2px"
  },
  "border-width-3": {
    value: "3px"
  },
  "border-width-4": {
    value: "4px"
  },
  "border-width-5": {
    value: "5px"
  }
};

// ../node_modules/@shopify/polaris-tokens/dist/esm/src/token-groups/depth.mjs
var depth = {
  "shadow-transparent": {
    value: "0 0 0 0 transparent"
  },
  "shadow-faint": {
    value: "0 1px 0 0 rgba(22, 29, 37, 0.05)"
  },
  "shadow-base": {
    value: "0 0 0 1px rgba(63, 63, 68, 0.05), 0 1px 3px 0 rgba(63, 63, 68, 0.15)"
  },
  "shadow-deep": {
    value: "0 0 0 1px rgba(6, 44, 82, 0.1), 0 2px 16px rgba(33, 43, 54, 0.08)"
  },
  "shadow-button": {
    value: "0 1px 0 rgba(0, 0, 0, 0.05)"
  },
  "shadow-top-bar": {
    value: "0 2px 2px -1px rgba(0, 0, 0, 0.15)"
  },
  "shadow-card": {
    value: "0 0 5px rgba(23, 24, 24, 0.05), 0 1px 2px rgba(0, 0, 0, 0.15)"
  },
  "shadow-popover": {
    value: "0 3px 6px -3px rgba(23, 24, 24, 0.08), 0 8px 20px -4px rgba(23, 24, 24, 0.12)"
  },
  "shadow-layer": {
    value: "0 31px 41px 0 rgba(32, 42, 53, 0.2), 0 2px 16px 0 rgba(32, 42, 54, 0.08)"
  },
  "shadow-modal": {
    value: "0 26px 80px rgba(0, 0, 0, 0.2), 0 0px 1px rgba(0, 0, 0, 0.2)"
  },
  "shadows-inset-button": {
    value: "inset 0 -1px 0 rgba(0, 0, 0, 0.2)"
  },
  "shadows-inset-button-pressed": {
    value: "inset 0 1px 0 rgba(0, 0, 0, 0.15)"
  }
};

// ../node_modules/@shopify/polaris-tokens/dist/esm/src/token-groups/font.mjs
var font = {
  "font-family-sans": {
    value: "-apple-system, BlinkMacSystemFont, 'San Francisco', 'Segoe UI', Roboto, 'Helvetica Neue', sans-serif"
  },
  "font-family-mono": {
    value: "ui-monospace, SFMono-Regular, 'SF Mono', Consolas, 'Liberation Mono', Menlo, monospace"
  },
  "font-size-75": {
    value: "12px"
  },
  "font-size-100": {
    value: "14px"
  },
  "font-size-200": {
    value: "16px"
  },
  "font-size-300": {
    value: "20px"
  },
  "font-size-400": {
    value: "24px"
  },
  "font-size-500": {
    value: "28px"
  },
  "font-size-600": {
    value: "32px"
  },
  "font-size-700": {
    value: "40px"
  },
  "font-weight-regular": {
    value: "400"
  },
  "font-weight-medium": {
    value: "500"
  },
  "font-weight-semibold": {
    value: "600"
  },
  "font-weight-bold": {
    value: "700"
  },
  "font-line-height-1": {
    value: "16px"
  },
  "font-line-height-2": {
    value: "20px"
  },
  "font-line-height-3": {
    value: "24px"
  },
  "font-line-height-4": {
    value: "28px"
  },
  "font-line-height-5": {
    value: "32px"
  },
  "font-line-height-6": {
    value: "40px"
  },
  "font-line-height-7": {
    value: "48px"
  }
};

// ../node_modules/@shopify/polaris-tokens/dist/esm/src/token-groups/legacy.mjs
var legacy = {
  "override-loading-z-index": {
    value: "514"
  },
  "choice-size": {
    value: "20px"
  },
  "icon-size-small": {
    value: "8px"
  },
  "icon-size-medium": {
    value: "20px"
  },
  "choice-margin": {
    value: "1px"
  },
  "control-border-width": {
    value: "2px"
  },
  "banner-border-default": {
    value: "inset 0 1px 0 0 var(--p-color-border-strong), inset 0 0 0 1px var(--p-color-border-strong)"
  },
  "banner-border-success": {
    value: "inset 0 1px 0 0 var(--p-color-border-success-subdued), inset 0 0 0 1px var(--p-color-border-success-subdued)"
  },
  "banner-border-highlight": {
    value: "inset 0 1px 0 0 var(--p-color-border-info-subdued), inset 0 0 0 1px var(--p-color-border-info-subdued)"
  },
  "banner-border-warning": {
    value: "inset 0 1px 0 0 var(--p-color-border-caution-subdued), inset 0 0 0 1px var(--p-color-border-caution-subdued)"
  },
  "banner-border-critical": {
    value: "inset 0 1px 0 0 var(--p-color-border-critical-subdued), inset 0 0 0 1px var(--p-color-border-critical-subdued)"
  },
  "thin-border-subdued": {
    value: "1px solid var(--p-color-border-subdued)"
  },
  "text-field-spinner-offset": {
    value: "2px"
  },
  "text-field-focus-ring-offset": {
    value: "-4px"
  },
  "button-group-item-spacing": {
    value: "-1px"
  },
  "range-slider-thumb-size-base": {
    value: "16px"
  },
  "range-slider-thumb-size-active": {
    value: "24px"
  },
  "frame-offset": {
    value: "0px"
  }
};

// ../node_modules/@shopify/polaris-tokens/dist/esm/src/colors.mjs
var gray = {
  50: "rgba(255, 255, 255, 1)",
  100: "rgba(249, 250, 251, 1)",
  200: "rgba(241, 242, 244, 1)",
  300: "rgba(235, 236, 239, 1)",
  400: "rgba(221, 224, 228, 1)",
  500: "rgba(202, 206, 211, 1)",
  600: "rgba(171, 177, 186, 1)",
  700: "rgba(135, 144, 155, 1)",
  800: "rgba(97, 106, 117, 1)",
  900: "rgba(31, 33, 36, 1)"
};
var green = {
  50: "rgba(240, 253, 248, 1)",
  100: "rgba(224, 248, 238, 1)",
  200: "rgba(192, 242, 221, 1)",
  300: "rgba(161, 237, 208, 1)",
  400: "rgba(80, 220, 169, 1)",
  500: "rgba(35, 196, 140, 1)",
  600: "rgba(22, 166, 121, 1)",
  700: "rgba(0, 122, 92, 1)",
  800: "rgba(18, 84, 67, 1)",
  900: "rgba(12, 59, 47, 1)"
};
var blue = {
  50: "rgba(240, 245, 253, 1)",
  100: "rgba(232, 240, 253, 1)",
  200: "rgba(187, 212, 247, 1)",
  300: "rgba(147, 186, 241, 1)",
  400: "rgba(102, 153, 225, 1)",
  500: "rgba(62, 125, 213, 1)",
  600: "rgba(36, 99, 188, 1)",
  700: "rgba(20, 73, 149, 1)",
  800: "rgba(14, 53, 108, 1)",
  900: "rgba(16, 41, 76, 1)"
};
var red = {
  50: "rgba(254, 243, 241, 1)",
  100: "rgba(253, 226, 221, 1)",
  200: "rgba(251, 197, 188, 1)",
  300: "rgba(247, 148, 130, 1)",
  400: "rgba(245, 107, 82, 1)",
  500: "rgba(242, 65, 34, 1)",
  600: "rgba(197, 40, 12, 1)",
  700: "rgba(159, 32, 10, 1)",
  800: "rgba(115, 24, 7, 1)",
  900: "rgba(67, 14, 4, 1)"
};
var yellow = {
  50: "rgba(254, 248, 236, 1)",
  100: "rgba(252, 240, 212, 1)",
  200: "rgba(250, 229, 178, 1)",
  300: "rgba(248, 217, 144, 1)",
  400: "rgba(245, 196, 82, 1)",
  500: "rgba(242, 179, 34, 1)",
  600: "rgba(216, 155, 13, 1)",
  700: "rgba(183, 126, 11, 1)",
  800: "rgba(135, 92, 8, 1)",
  900: "rgba(77, 46, 5, 1)"
};
var teal = {
  50: "rgba(238, 250, 251, 1)",
  100: "rgba(222, 245, 247, 1)",
  200: "rgba(184, 233, 239, 1)",
  300: "rgba(147, 222, 231, 1)",
  400: "rgba(109, 211, 222, 1)",
  500: "rgba(59, 195, 211, 1)",
  600: "rgba(42, 172, 187, 1)",
  700: "rgba(32, 130, 141, 1)",
  800: "rgba(23, 92, 100, 1)",
  900: "rgba(16, 65, 71, 1)"
};
var orange = {
  50: "rgba(254, 243, 236, 1)",
  100: "rgba(253, 231, 217, 1)",
  200: "rgba(250, 201, 168, 1)",
  300: "rgba(247, 177, 130, 1)",
  400: "rgba(245, 147, 82, 1)",
  500: "rgba(242, 117, 34, 1)",
  600: "rgba(216, 101, 13, 1)",
  700: "rgba(164, 76, 10, 1)",
  800: "rgba(111, 52, 7, 1)",
  900: "rgba(77, 36, 5, 1)"
};
var purple = {
  50: "rgba(242, 237, 253, 1)",
  100: "rgba(236, 227, 253, 1)",
  200: "rgba(226, 214, 250, 1)",
  300: "rgba(203, 180, 248, 1)",
  400: "rgba(173, 139, 241, 1)",
  500: "rgba(121, 69, 227, 1)",
  600: "rgba(90, 36, 205, 1)",
  700: "rgba(67, 21, 158, 1)",
  800: "rgba(49, 13, 120, 1)",
  900: "rgba(36, 8, 73, 1)"
};

// ../node_modules/@shopify/polaris-tokens/dist/esm/src/token-groups/color.mjs
var color = {
  "color-bg-inverse": {
    value: gray[900],
    description: ""
  },
  "color-bg-inset-strong": {
    value: gray[800],
    description: ""
  },
  "color-bg-inverse-hover": {
    value: gray[800],
    description: ""
  },
  "color-bg-inverse-active": {
    value: gray[700],
    description: ""
  },
  "color-bg-strong-hover": {
    value: gray[500],
    description: ""
  },
  "color-bg-strong-active": {
    value: gray[500],
    description: ""
  },
  "color-bg-strong": {
    value: gray[400],
    description: ""
  },
  "color-bg-subdued-active": {
    value: gray[300],
    description: ""
  },
  "color-bg-disabled": {
    value: gray[300],
    description: ""
  },
  "color-bg-interactive-disabled": {
    value: gray[300],
    description: ""
  },
  "color-bg-app": {
    value: gray[200],
    description: ""
  },
  "color-bg-app-active": {
    value: gray[400],
    description: ""
  },
  "color-bg-app-hover": {
    value: gray[300],
    description: ""
  },
  "color-bg-app-selected": {
    value: gray[300],
    description: ""
  },
  "color-bg-active": {
    value: gray[300],
    description: ""
  },
  "color-bg-subdued-hover": {
    value: gray[200],
    description: ""
  },
  "color-bg-inset": {
    value: gray[200],
    description: ""
  },
  "color-bg-hover": {
    value: gray[200],
    description: ""
  },
  "color-bg-subdued": {
    value: gray[100],
    description: ""
  },
  "color-bg-input": {
    value: gray[50],
    description: ""
  },
  "color-bg": {
    value: gray[50],
    description: ""
  },
  "color-bg-primary-active": {
    value: green[900],
    description: ""
  },
  "color-bg-primary-hover": {
    value: green[800],
    description: ""
  },
  "color-bg-primary": {
    value: green[700],
    description: ""
  },
  "color-bg-success-strong": {
    value: green[600],
    description: ""
  },
  "color-bg-success": {
    value: green[300],
    description: ""
  },
  "color-bg-primary-subdued-active": {
    value: green[200],
    description: ""
  },
  "color-bg-success-subdued-active": {
    value: green[200],
    description: ""
  },
  "color-bg-success-subdued": {
    value: green[100],
    description: ""
  },
  "color-bg-primary-subdued-hover": {
    value: green[100],
    description: ""
  },
  "color-bg-success-subdued-hover": {
    value: green[50],
    description: ""
  },
  "color-bg-primary-subdued": {
    value: green[50],
    description: ""
  },
  "color-bg-primary-subdued-selected": {
    value: green[50],
    description: ""
  },
  "color-bg-critical-strong-active": {
    value: red[800],
    description: ""
  },
  "color-bg-critical-strong-hover": {
    value: red[700],
    description: ""
  },
  "color-bg-critical-strong": {
    value: red[600],
    description: ""
  },
  "color-bg-critical-subdued-active": {
    value: red[200],
    description: ""
  },
  "color-bg-critical": {
    value: red[200],
    description: ""
  },
  "color-bg-critical-subdued": {
    value: red[100],
    description: ""
  },
  "color-bg-critical-subdued-hover": {
    value: red[50],
    description: ""
  },
  "color-bg-caution-strong": {
    value: yellow[600],
    description: ""
  },
  "color-bg-caution": {
    value: yellow[300],
    description: ""
  },
  "color-bg-caution-subdued-active": {
    value: yellow[200],
    description: ""
  },
  "color-bg-caution-subdued": {
    value: yellow[100],
    description: ""
  },
  "color-bg-caution-subdued-hover": {
    value: yellow[50],
    description: ""
  },
  "color-bg-info-strong": {
    value: teal[600],
    description: ""
  },
  "color-bg-info-subdued-active": {
    value: teal[200],
    description: ""
  },
  "color-bg-info": {
    value: teal[200],
    description: ""
  },
  "color-bg-info-subdued": {
    value: teal[100],
    description: ""
  },
  "color-bg-info-subdued-hover": {
    value: teal[50],
    description: ""
  },
  "color-bg-interactive-active": {
    value: blue[800],
    description: ""
  },
  "color-bg-interactive-hover": {
    value: blue[700],
    description: ""
  },
  "color-bg-interactive": {
    value: blue[600],
    description: ""
  },
  "color-bg-interactive-subdued-active": {
    value: blue[200],
    description: ""
  },
  "color-bg-interactive-subdued-hover": {
    value: blue[100],
    description: ""
  },
  "color-bg-interactive-subdued": {
    value: blue[50],
    description: ""
  },
  "color-bg-interactive-selected": {
    value: blue[50],
    description: ""
  },
  "color-bg-warning": {
    value: orange[200],
    description: ""
  },
  "color-bg-magic-strong": {
    value: purple[500],
    description: ""
  },
  "color-bg-magic-hover": {
    value: purple[200],
    description: ""
  },
  "color-bg-magic-active": {
    value: purple[300],
    description: ""
  },
  "color-bg-magic": {
    value: purple[100],
    description: ""
  },
  "color-bg-magic-subdued-hover": {
    value: purple[100],
    description: ""
  },
  "color-bg-magic-subdued-active": {
    value: purple[200],
    description: ""
  },
  "color-bg-magic-subdued": {
    value: purple[50],
    description: ""
  },
  "color-border-input-hover": {
    value: gray[800],
    description: ""
  },
  "color-border-inverse": {
    value: gray[800],
    description: ""
  },
  "color-border-strong-hover": {
    value: gray[700],
    description: ""
  },
  "color-border-input": {
    value: gray[600],
    description: ""
  },
  "color-border-hover": {
    value: gray[600],
    description: ""
  },
  "color-border-strong": {
    value: gray[600],
    description: ""
  },
  "color-border": {
    value: gray[500],
    description: ""
  },
  "color-border-disabled": {
    value: gray[400],
    description: ""
  },
  "color-border-subdued": {
    value: gray[400],
    description: ""
  },
  "color-border-interactive-disabled": {
    value: gray[400],
    description: ""
  },
  "color-border-primary": {
    value: green[700],
    description: ""
  },
  "color-border-success": {
    value: green[600],
    description: ""
  },
  "color-border-success-subdued": {
    value: green[400],
    description: ""
  },
  "color-border-critical-active": {
    value: red[900],
    description: ""
  },
  "color-border-critical-hover": {
    value: red[800],
    description: ""
  },
  "color-border-critical": {
    value: red[600],
    description: ""
  },
  "color-border-critical-subdued": {
    value: red[400],
    description: ""
  },
  "color-border-caution": {
    value: yellow[600],
    description: ""
  },
  "color-border-caution-subdued": {
    value: yellow[400],
    description: ""
  },
  "color-border-info": {
    value: teal[500],
    description: ""
  },
  "color-border-info-subdued": {
    value: teal[400],
    description: ""
  },
  "color-border-interactive-active": {
    value: blue[800],
    description: ""
  },
  "color-border-interactive-hover": {
    value: blue[700],
    description: ""
  },
  "color-border-interactive": {
    value: blue[500],
    description: ""
  },
  "color-border-interactive-focus": {
    value: blue[500],
    description: ""
  },
  "color-border-interactive-subdued": {
    value: blue[200],
    description: ""
  },
  "color-border-magic-strong": {
    value: purple[500],
    description: ""
  },
  "color-border-magic": {
    value: purple[400],
    description: ""
  },
  "color-icon-hover": {
    value: gray[900],
    description: ""
  },
  "color-icon": {
    value: gray[800],
    description: ""
  },
  "color-icon-active": {
    value: gray[900],
    description: ""
  },
  "color-icon-subdued": {
    value: gray[700],
    description: ""
  },
  "color-icon-disabled": {
    value: gray[600],
    description: ""
  },
  "color-icon-interactive-disabled": {
    value: gray[600],
    description: ""
  },
  "color-icon-inverse": {
    value: gray[400],
    description: ""
  },
  "color-icon-on-color": {
    value: gray[50],
    description: ""
  },
  "color-icon-primary": {
    value: green[700],
    description: ""
  },
  "color-icon-success": {
    value: green[600],
    description: ""
  },
  "color-icon-critical": {
    value: red[600],
    description: ""
  },
  "color-icon-caution": {
    value: yellow[700],
    description: ""
  },
  "color-icon-info": {
    value: teal[600],
    description: ""
  },
  "color-icon-warning": {
    value: orange[500],
    description: ""
  },
  "color-icon-interactive-active": {
    value: blue[800],
    description: ""
  },
  "color-icon-interactive-hover": {
    value: blue[700],
    description: ""
  },
  "color-icon-interactive": {
    value: blue[600],
    description: ""
  },
  "color-icon-interactive-inverse": {
    value: blue[400],
    description: ""
  },
  "color-icon-magic": {
    value: purple[500],
    description: ""
  },
  "color-text": {
    value: gray[900],
    description: ""
  },
  "color-text-subdued": {
    value: gray[800],
    description: ""
  },
  "color-text-disabled": {
    value: gray[700],
    description: ""
  },
  "color-text-interactive-disabled": {
    value: gray[700],
    description: ""
  },
  "color-text-inverse-subdued": {
    value: gray[600],
    description: ""
  },
  "color-text-inverse": {
    value: gray[200],
    description: ""
  },
  "color-text-on-color": {
    value: gray[50],
    description: ""
  },
  "color-text-success-strong": {
    value: green[900],
    description: ""
  },
  "color-text-success": {
    value: green[700],
    description: ""
  },
  "color-text-primary": {
    value: green[700],
    description: ""
  },
  "color-text-primary-hover": {
    value: green[800],
    description: ""
  },
  "color-text-critical-strong": {
    value: red[900],
    description: ""
  },
  "color-text-critical-active": {
    value: red[800],
    description: ""
  },
  "color-text-critical": {
    value: red[600],
    description: ""
  },
  "color-text-caution-strong": {
    value: yellow[900],
    description: ""
  },
  "color-text-caution": {
    value: yellow[800],
    description: ""
  },
  "color-text-info-strong": {
    value: teal[900],
    description: ""
  },
  "color-text-info": {
    value: teal[700],
    description: ""
  },
  "color-text-warning-strong": {
    value: orange[900],
    description: ""
  },
  "color-text-interactive-active": {
    value: blue[800],
    description: ""
  },
  "color-text-interactive-hover": {
    value: blue[700],
    description: ""
  },
  "color-text-interactive": {
    value: blue[600],
    description: ""
  },
  "color-text-interactive-inverse": {
    value: blue[400],
    description: ""
  },
  "color-text-magic-strong": {
    value: purple[800],
    description: ""
  },
  "color-text-magic": {
    value: purple[600],
    description: ""
  }
};

// ../node_modules/@shopify/polaris-tokens/dist/esm/src/token-groups/colors.mjs
var colors = {
  background: {
    value: "rgba(246, 246, 247, 1)",
    description: "For use as a background color, in components such as Page and Frame backgrounds."
  },
  "background-hovered": {
    value: "rgba(241, 242, 243, 1)",
    description: "For use when an action or navigation is used on a background."
  },
  "background-pressed": {
    value: "rgba(237, 238, 239, 1)",
    description: "For use when an action or navigation is used on a background."
  },
  "background-selected": {
    value: "rgba(237, 238, 239, 1)",
    description: "For use in the selected item in navigation"
  },
  surface: {
    value: "rgba(255, 255, 255, 1)",
    description: "For use as a background color, in components such as Card, Modal, and Popover."
  },
  "surface-dark": {
    value: "rgba(32, 33, 35, 1)",
    description: "For use as a dark background color, in components such as Card, Modal, and Popover."
  },
  "surface-neutral": {
    value: "rgba(228, 229, 231, 1)",
    description: "For use as a background color in neutral badges."
  },
  "surface-neutral-hovered": {
    value: "rgba(219, 221, 223, 1)",
    description: "For use as a hovered background color in neutral badges."
  },
  "surface-neutral-pressed": {
    value: "rgba(201, 204, 208, 1)",
    description: "For use as a pressed background color in neutral badges."
  },
  "surface-neutral-disabled": {
    value: "rgba(241, 242, 243, 1)",
    description: "For use as a disabled background color in neutral badges."
  },
  "surface-neutral-subdued": {
    value: "rgba(246, 246, 247, 1)",
    description: "For use as a background color in neutral banners."
  },
  "surface-neutral-subdued-dark": {
    value: "rgba(68, 71, 74, 1)",
    description: "For use as a dark background color in neutral banners."
  },
  "surface-subdued": {
    value: "rgba(250, 251, 251, 1)",
    description: "For use as a subdued background color, in components such as Card, Modal, and Popover."
  },
  "surface-disabled": {
    value: "rgba(250, 251, 251, 1)",
    description: "For use as a surface color on disabled interactive elements such as option list items and action list items when in a disabled state."
  },
  "surface-hovered": {
    value: "rgba(246, 246, 247, 1)",
    description: "For use as a surface color on interactive elements such as resource list items and action list items when in a hovered state."
  },
  "surface-hovered-dark": {
    value: "rgba(47, 49, 51, 1)",
    description: "For use as a dark surface color on interactive elements such as resource list items and action list items when in a hovered state."
  },
  "surface-pressed": {
    value: "rgba(241, 242, 243, 1)",
    description: "For use as a surface color on interactive elements such as resource list items and action list items when in a pressed state."
  },
  "surface-pressed-dark": {
    value: "rgba(62, 64, 67, 1)",
    description: "For use as a dark surface color on interactive elements such as resource list items and action list items when in a pressed state."
  },
  "surface-depressed": {
    value: "rgba(237, 238, 239, 1)",
    description: "For use as a surface color on interactive elements such as resource list items and action list items when in a depressed state."
  },
  "surface-search-field": {
    value: "rgba(241, 242, 243, 1)",
    description: "For use as a background color, in components on surface elements such as SearchField"
  },
  "surface-search-field-dark": {
    value: "rgba(47, 49, 51, 1)",
    description: "For use as a dark background color, in components on surface elements such as SearchField"
  },
  backdrop: {
    value: "rgba(0, 0, 0, 0.5)",
    description: "For use as the background color of the backdrop component for navigation and modal. This color has an alpha of `0.5`."
  },
  overlay: {
    value: "rgba(255, 255, 255, 0.5)",
    description: "For use as the background color of elements which lay on top of surfaces to obscure their contents. This color has an alpha of `0.5`."
  },
  "shadow-color-picker": {
    value: "rgba(0, 0, 0, 0.5)"
  },
  "shadow-color-picker-dragger": {
    value: "rgba(33, 43, 54, 0.32)"
  },
  "hint-from-direct-light": {
    value: "rgba(0, 0, 0, 0.15)",
    description: "For use in building shadows scrollables."
  },
  border: {
    value: "rgba(140, 145, 150, 1)",
    description: "For use as the default border on elements."
  },
  "border-on-dark": {
    value: "rgba(80, 83, 86, 1)",
    description: "For use as the default border on dark elements."
  },
  "border-neutral-subdued": {
    value: "rgba(186, 191, 195, 1)",
    description: "For use as the border on banners."
  },
  "border-hovered": {
    value: "rgba(153, 158, 164, 1)",
    description: "Used for borders on hovered interactive elements"
  },
  "border-disabled": {
    value: "rgba(210, 213, 216, 1)",
    description: "Used for disabled borders on interactive elements"
  },
  "border-subdued": {
    value: "rgba(201, 204, 207, 1)",
    description: "For use as a subdued border on elements."
  },
  "border-depressed": {
    value: "rgba(87, 89, 89, 1)",
    description: "For use as a border on depressed elements."
  },
  "border-shadow": {
    value: "rgba(174, 180, 185, 1)",
    description: "For use as an additional bottom border on elements."
  },
  "border-shadow-subdued": {
    value: "rgba(186, 191, 196, 1)",
    description: "For use as an additional, subdued bottom border on elements."
  },
  divider: {
    value: "rgba(225, 227, 229, 1)",
    description: "For use as a divider between elements."
  },
  "divider-dark": {
    value: "rgba(69, 71, 73, 1)",
    description: "For use as a dark divider between elements."
  },
  icon: {
    value: "rgba(92, 95, 98, 1)",
    description: "For use as the fill color of icons."
  },
  "icon-on-dark": {
    value: "rgba(166, 172, 178, 1)",
    description: "For use as the fill color of dark icons."
  },
  "icon-hovered": {
    value: "rgba(26, 28, 29, 1)",
    description: "For use as the fill color of hovered icons."
  },
  "icon-pressed": {
    value: "rgba(68, 71, 74, 1)",
    description: "For use as the fill color of pressed icons."
  },
  "icon-disabled": {
    value: "rgba(186, 190, 195, 1)",
    description: "For use as the fill color of disabled icons."
  },
  "icon-subdued": {
    value: "rgba(140, 145, 150, 1)",
    description: "For use as the fill color of subdued icons."
  },
  text: {
    value: "rgba(32, 34, 35, 1)",
    description: "For use as a text color."
  },
  "text-on-dark": {
    value: "rgba(227, 229, 231, 1)",
    description: "For use as a text color on dark elements."
  },
  "text-disabled": {
    value: "rgba(140, 145, 150, 1)",
    description: "For use as a disabled text color and as a placeholder text color."
  },
  "text-subdued": {
    value: "rgba(109, 113, 117, 1)",
    description: "For use as a subdued text color."
  },
  "text-subdued-on-dark": {
    value: "rgba(153, 159, 164, 1)",
    description: "For use as a subdued text color on dark elements."
  },
  interactive: {
    value: "rgba(44, 110, 203, 1)",
    description: "Used for links, plain buttons, and as the fill color for selected checkboxes and radio buttons."
  },
  "interactive-on-dark": {
    value: "rgba(54, 163, 255, 1)",
    description: "Used for links, plain buttons, and as the fill color for selected checkboxes and radio buttons when on a dark element."
  },
  "interactive-disabled": {
    value: "rgba(189, 193, 204, 1)",
    description: "Used for disabled links and plain buttons."
  },
  "interactive-hovered": {
    value: "rgba(31, 81, 153, 1)",
    description: "Used for hovered links and plain buttons."
  },
  "interactive-pressed": {
    value: "rgba(16, 50, 98, 1)",
    description: "Used for pressed links and plain buttons."
  },
  "interactive-pressed-on-dark": {
    value: "rgba(136, 188, 255, 1)",
    description: "Used for pressed links and plain buttons on dark elements."
  },
  focused: {
    value: "rgba(69, 143, 255, 1)",
    description: "For use in the focus ring on interactive elements."
  },
  "surface-selected": {
    value: "rgba(242, 247, 254, 1)",
    description: "For use as a surface color in selected interactive elements, in components such as action list and resource list."
  },
  "surface-selected-hovered": {
    value: "rgba(237, 244, 254, 1)",
    description: "For use as a surface color in selected interactive elements that are hovered, in components such as action list and resource list."
  },
  "surface-selected-pressed": {
    value: "rgba(229, 239, 253, 1)",
    description: "For use as a surface color in selected interactive elements that are pressed, in components such as action list and resource list."
  },
  "icon-on-interactive": {
    value: "rgba(255, 255, 255, 1)",
    description: "For use as a fill color for icons on interactive elements."
  },
  "text-on-interactive": {
    value: "rgba(255, 255, 255, 1)",
    description: "For use as a text color on interactive elements."
  },
  "action-secondary": {
    value: "rgba(255, 255, 255, 1)",
    description: "Used for secondary buttons and tertiary buttons, as well as in form elements as a background color and pontentially other secondary surfaces."
  },
  "action-secondary-disabled": {
    value: "rgba(255, 255, 255, 1)",
    description: "Used as a disabled state for secondary buttons"
  },
  "action-secondary-hovered": {
    value: "rgba(246, 246, 247, 1)",
    description: "Used as a hovered state for secondary buttons"
  },
  "action-secondary-hovered-dark": {
    value: "rgba(84, 87, 91, 1)",
    description: "Used as a dark hovered state for secondary buttons"
  },
  "action-secondary-pressed": {
    value: "rgba(241, 242, 243, 1)",
    description: "Used as a pressed state for secondary buttons"
  },
  "action-secondary-pressed-dark": {
    value: "rgba(96, 100, 103, 1)",
    description: "Used as a dark pressed state for secondary buttons"
  },
  "action-secondary-depressed": {
    value: "rgba(109, 113, 117, 1)",
    description: "Used as a depressed state for secondary buttons"
  },
  "action-primary": {
    value: "rgba(0, 128, 96, 1)",
    description: "Used as the background color for primary actions, and as the fill color for icons and the text color in navigation and tabs to communicate interaction states."
  },
  "action-primary-disabled": {
    value: "rgba(241, 241, 241, 1)",
    description: "Used as the background color for disabled primary actions, and as the fill color for icons and the text color in navigation and tabs to communicate interaction states."
  },
  "action-primary-hovered": {
    value: "rgba(0, 110, 82, 1)",
    description: "Used as the background color for hovered primary actions, and as the fill color for icons and the text color in navigation and tabs to communicate interaction states."
  },
  "action-primary-pressed": {
    value: "rgba(0, 94, 70, 1)",
    description: "Used as the background color for pressed primary actions, and as the fill color for icons and the text color in navigation and tabs to communicate interaction states."
  },
  "action-primary-depressed": {
    value: "rgba(0, 61, 44, 1)",
    description: "Used as the background color for pressed primary actions, and as the fill color for icons and the text color in navigation and tabs to communicate interaction states."
  },
  "icon-on-primary": {
    value: "rgba(255, 255, 255, 1)",
    description: "For use as a fill color for icons on primary actions. Not for use in icons on navigation and tabs."
  },
  "text-on-primary": {
    value: "rgba(255, 255, 255, 1)",
    description: "For use as a text color on primary actions. Not for use in text on navigation and tabs."
  },
  "text-primary": {
    value: "rgba(0, 123, 92, 1)",
    description: "For use as primary text color on background. For use in text in components such as Navigation."
  },
  "text-primary-hovered": {
    value: "rgba(0, 108, 80, 1)",
    description: "For use as primary hovered text color on background. For use in text in components such as Navigation."
  },
  "text-primary-pressed": {
    value: "rgba(0, 92, 68, 1)",
    description: "For use as primary pressed text color on background. For use in text in components such as Navigation."
  },
  "surface-primary-selected": {
    value: "rgba(241, 248, 245, 1)",
    description: "Used as a surface color to indicate selected interactive states in navigation and tabs."
  },
  "surface-primary-selected-hovered": {
    value: "rgba(179, 208, 195, 1)",
    description: "Used as a surface color to indicate selected interactive states that are hovered in navigation and tabs."
  },
  "surface-primary-selected-pressed": {
    value: "rgba(162, 188, 176, 1)",
    description: "Used as a surface color to indicate selected interactive states that are pressed in navigation and tabs."
  },
  "border-critical": {
    value: "rgba(253, 87, 73, 1)",
    description: "For use as a border on critical components such as an outline on interactive elements in an error state."
  },
  "border-critical-subdued": {
    value: "rgba(224, 179, 178, 1)",
    description: "For use as a border on critical components such as banners."
  },
  "border-critical-disabled": {
    value: "rgba(255, 167, 163, 1)",
    description: "For use as a disabled border on critical components such as banners, and as an outline on interactive elements in an error state."
  },
  "icon-critical": {
    value: "rgba(215, 44, 13, 1)",
    description: "For use as an icon fill color on top of critical elements."
  },
  "surface-critical": {
    value: "rgba(254, 211, 209, 1)",
    description: "For use as a surface color on critical elements including badges."
  },
  "surface-critical-subdued": {
    value: "rgba(255, 244, 244, 1)",
    description: "For use as a subdued surface color on critical elements including banners."
  },
  "surface-critical-subdued-hovered": {
    value: "rgba(255, 240, 240, 1)",
    description: "For use as a surface color on critical interactive elements including action list items in a hovered state."
  },
  "surface-critical-subdued-pressed": {
    value: "rgba(255, 233, 232, 1)",
    description: "For use as a surface color on critical interactive elements including action list items in a pressed state."
  },
  "surface-critical-subdued-depressed": {
    value: "rgba(254, 188, 185, 1)",
    description: "For use as a surface color on critical interactive elements including action list items in a depressed state."
  },
  "text-critical": {
    value: "rgba(215, 44, 13, 1)",
    description: "For use as a text color in inert critical elements such as exception list. Not for use as a text color on banners and badges."
  },
  "action-critical": {
    value: "rgba(216, 44, 13, 1)",
    description: "For use as the background color for destructive buttons, and as the background color for error toast messages."
  },
  "action-critical-disabled": {
    value: "rgba(241, 241, 241, 1)",
    description: "For use as the background color for disabled destructive buttons, and as the background color for error toast messages."
  },
  "action-critical-hovered": {
    value: "rgba(188, 34, 0, 1)",
    description: "For use as the background color for hovered destructive buttons, and as the background color for error toast messages."
  },
  "action-critical-pressed": {
    value: "rgba(162, 27, 0, 1)",
    description: "For use as the background color for pressed destructive buttons, and as the background color for error toast messages."
  },
  "action-critical-depressed": {
    value: "rgba(108, 15, 0, 1)",
    description: "For use as the background color for depressed destructive buttons, and as the background color for error toast messages."
  },
  "icon-on-critical": {
    value: "rgba(255, 255, 255, 1)",
    description: "For use as a fill color for icons on critical actions."
  },
  "text-on-critical": {
    value: "rgba(255, 255, 255, 1)",
    description: "For use as a text color on critical actions."
  },
  "interactive-critical": {
    value: "rgba(216, 44, 13, 1)",
    description: "For use as the text color for destructive interactive elements: links, plain buttons, error state of selected checkboxes and radio buttons, as well as a text color on destructive action list items. Not for use on critical banners and badges."
  },
  "interactive-critical-disabled": {
    value: "rgba(253, 147, 141, 1)",
    description: "For use as a text color in disabled destructive plain buttons, as well as a text color on destructive action list items. Not for use on critical banners and badges."
  },
  "interactive-critical-hovered": {
    value: "rgba(205, 41, 12, 1)",
    description: "For use as a text color in hovered destructive plain buttons, as well as a text color on destructive action list items. Not for use on critical banners and badges."
  },
  "interactive-critical-pressed": {
    value: "rgba(103, 15, 3, 1)",
    description: "For use as a text color in pressed destructive plain buttons, as well as a text color on destructive action list items. Not for use on critical banners and badges."
  },
  "border-warning": {
    value: "rgba(185, 137, 0, 1)",
    description: "For use as a border on warning components such as..."
  },
  "border-warning-subdued": {
    value: "rgba(225, 184, 120, 1)",
    description: "For use as a border on warning components such as banners."
  },
  "icon-warning": {
    value: "rgba(185, 137, 0, 1)",
    description: "For use as an icon fill color on top of warning elements."
  },
  "surface-warning": {
    value: "rgba(255, 215, 157, 1)",
    description: "For use as a surface color on warning elements including badges."
  },
  "surface-warning-subdued": {
    value: "rgba(255, 245, 234, 1)",
    description: "For use as a subdued surface color on warning elements including banners."
  },
  "surface-warning-subdued-hovered": {
    value: "rgba(255, 242, 226, 1)",
    description: "For use as a subdued surface color on warning elements including banners."
  },
  "surface-warning-subdued-pressed": {
    value: "rgba(255, 235, 211, 1)",
    description: "For use as a subdued surface color on warning elements including banners."
  },
  "text-warning": {
    value: "rgba(145, 106, 0, 1)",
    description: "For use as a text color in inert critical elements such as exception list. Not for use as a text color on banners and badges."
  },
  "border-highlight": {
    value: "rgba(68, 157, 167, 1)",
    description: "For use as a border on informational components such as..."
  },
  "border-highlight-subdued": {
    value: "rgba(152, 198, 205, 1)",
    description: "For use as a border on informational components such as banners."
  },
  "icon-highlight": {
    value: "rgba(0, 160, 172, 1)",
    description: "For use as an icon fill color on top of informational elements."
  },
  "surface-highlight": {
    value: "rgba(164, 232, 242, 1)",
    description: "For use as a surface color on information elements including badges."
  },
  "surface-highlight-subdued": {
    value: "rgba(235, 249, 252, 1)",
    description: "For use as a surface color on information elements including banners."
  },
  "surface-highlight-subdued-hovered": {
    value: "rgba(228, 247, 250, 1)",
    description: "For use as a surface color on information elements including banners."
  },
  "surface-highlight-subdued-pressed": {
    value: "rgba(213, 243, 248, 1)",
    description: "For use as a surface color on information elements including banners."
  },
  "text-highlight": {
    value: "rgba(52, 124, 132, 1)",
    description: "For use as a text color in inert informational elements. Not for use as a text color on banners and badges."
  },
  "border-success": {
    value: "rgba(0, 164, 124, 1)",
    description: "For use as a border on success components such as text inputs."
  },
  "border-success-subdued": {
    value: "rgba(149, 201, 180, 1)",
    description: "For use as a border on success components such as banners."
  },
  "icon-success": {
    value: "rgba(0, 127, 95, 1)",
    description: "For use as an icon fill color on top of success elements."
  },
  "surface-success": {
    value: "rgba(174, 233, 209, 1)",
    description: "For use as a surface color on success elements including badges."
  },
  "surface-success-subdued": {
    value: "rgba(241, 248, 245, 1)",
    description: "For use as a surface color on information elements including banners."
  },
  "surface-success-subdued-hovered": {
    value: "rgba(236, 246, 241, 1)",
    description: "For use as a surface color on information elements including banners."
  },
  "surface-success-subdued-pressed": {
    value: "rgba(226, 241, 234, 1)",
    description: "For use as a surface color on information elements including banners."
  },
  "text-success": {
    value: "rgba(0, 128, 96, 1)",
    description: "For use as a text color in inert success elements. Not for use as a text color on banners and badges."
  },
  "icon-attention": {
    value: "rgba(138, 97, 22, 1)"
  },
  "surface-attention": {
    value: "rgba(255, 234, 138, 1)"
  },
  "decorative-one-icon": {
    value: "rgba(126, 87, 0, 1)",
    description: "For use as a decorative icon color that is applied on a decorative surface."
  },
  "decorative-one-surface": {
    value: "rgba(255, 201, 107, 1)",
    description: "For use as a decorative surface color."
  },
  "decorative-one-text": {
    value: "rgba(61, 40, 0, 1)",
    description: "For use as a decorative text color that is applied on a decorative surface."
  },
  "decorative-two-icon": {
    value: "rgba(175, 41, 78, 1)",
    description: "For use as a decorative icon color that is applied on a decorative surface."
  },
  "decorative-two-surface": {
    value: "rgba(255, 196, 176, 1)",
    description: "For use as a decorative surface color."
  },
  "decorative-two-text": {
    value: "rgba(73, 11, 28, 1)",
    description: "For use as a decorative text color that is applied on a decorative surface."
  },
  "decorative-three-icon": {
    value: "rgba(0, 109, 65, 1)",
    description: "For use as a decorative icon color that is applied on a decorative surface."
  },
  "decorative-three-surface": {
    value: "rgba(146, 230, 181, 1)",
    description: "For use as a decorative surface color."
  },
  "decorative-three-text": {
    value: "rgba(0, 47, 25, 1)",
    description: "For use as a decorative text color that is applied on a decorative surface."
  },
  "decorative-four-icon": {
    value: "rgba(0, 106, 104, 1)",
    description: "For use as a decorative icon color that is applied on a decorative surface."
  },
  "decorative-four-surface": {
    value: "rgba(145, 224, 214, 1)",
    description: "For use as a decorative surface color."
  },
  "decorative-four-text": {
    value: "rgba(0, 45, 45, 1)",
    description: "For use as a decorative text color that is applied on a decorative surface."
  },
  "decorative-five-icon": {
    value: "rgba(174, 43, 76, 1)",
    description: "For use as a decorative icon color that is applied on a decorative surface."
  },
  "decorative-five-surface": {
    value: "rgba(253, 201, 208, 1)",
    description: "For use as a decorative surface color."
  },
  "decorative-five-text": {
    value: "rgba(79, 14, 31, 1)",
    description: "For use as a decorative text color that is applied on a decorative surface."
  }
};

// ../node_modules/@shopify/polaris-tokens/dist/esm/src/token-groups/motion.mjs
var motion = {
  "duration-0": {
    value: "0ms"
  },
  "duration-50": {
    value: "50ms"
  },
  "duration-100": {
    value: "100ms"
  },
  "duration-150": {
    value: "150ms"
  },
  "duration-200": {
    value: "200ms"
  },
  "duration-250": {
    value: "250ms"
  },
  "duration-300": {
    value: "300ms"
  },
  "duration-350": {
    value: "350ms"
  },
  "duration-400": {
    value: "400ms"
  },
  "duration-450": {
    value: "450ms"
  },
  "duration-500": {
    value: "500ms"
  },
  "duration-5000": {
    value: "5000ms"
  },
  ease: {
    value: "cubic-bezier(0.25, 0.1, 0.25, 1)",
    description: "Responds quickly and finishes with control. A great default for any user interaction."
  },
  "ease-in": {
    value: "cubic-bezier(0.42, 0, 1, 1)",
    description: "Starts slowly and finishes at top speed. Use sparingly."
  },
  "ease-out": {
    value: "cubic-bezier(0, 0, 0.58, 1)",
    description: "Starts at top speed and finishes slowly. Use sparingly."
  },
  "ease-in-out": {
    value: "cubic-bezier(0.42, 0, 0.58, 1)",
    description: "Starts and finishes with equal speed. A good default for transitions triggered by the system."
  },
  linear: {
    value: "cubic-bezier(0, 0, 1, 1)",
    description: "Moves with constant speed. Use for continuous and mechanical animations, such as rotating spinners."
  },
  "keyframes-bounce": {
    value: "{ from, 65%, 85% { transform: scale(1) } 75% { transform: scale(0.85) } 82.5% { transform: scale(1.05) } }"
  },
  "keyframes-fade-in": {
    value: "{ to { opacity: 1 } }"
  },
  "keyframes-pulse": {
    value: "{ from, 75% { transform: scale(0.85); opacity: 1; } to { transform: scale(2.5); opacity: 0; } }"
  },
  "keyframes-spin": {
    value: "{ to { transform: rotate(1turn) } }"
  },
  "keyframes-appear-above": {
    value: "{ from { transform: translateY(var(--p-space-1)); opacity: 0; } to { transform: none; opacity: 1; } }"
  },
  "keyframes-appear-below": {
    value: "{ from { transform: translateY(calc(var(--p-space-1) * -1)); opacity: 0; } to { transform: none; opacity: 1; } }"
  },
  "motion-duration-0": {
    value: "0ms"
  },
  "motion-duration-50": {
    value: "50ms"
  },
  "motion-duration-100": {
    value: "100ms"
  },
  "motion-duration-150": {
    value: "150ms"
  },
  "motion-duration-200": {
    value: "200ms"
  },
  "motion-duration-250": {
    value: "250ms"
  },
  "motion-duration-300": {
    value: "300ms"
  },
  "motion-duration-350": {
    value: "350ms"
  },
  "motion-duration-400": {
    value: "400ms"
  },
  "motion-duration-450": {
    value: "450ms"
  },
  "motion-duration-500": {
    value: "500ms"
  },
  "motion-duration-5000": {
    value: "5000ms"
  },
  "motion-ease": {
    value: "cubic-bezier(0.25, 0.1, 0.25, 1)",
    description: "Responds quickly and finishes with control. A great default for any user interaction."
  },
  "motion-ease-in": {
    value: "cubic-bezier(0.42, 0, 1, 1)",
    description: "Starts slowly and finishes at top speed. Use sparingly."
  },
  "motion-ease-out": {
    value: "cubic-bezier(0, 0, 0.58, 1)",
    description: "Starts at top speed and finishes slowly. Use sparingly."
  },
  "motion-ease-in-out": {
    value: "cubic-bezier(0.42, 0, 0.58, 1)",
    description: "Starts and finishes with equal speed. A good default for transitions triggered by the system."
  },
  "motion-linear": {
    value: "cubic-bezier(0, 0, 1, 1)",
    description: "Moves with constant speed. Use for continuous and mechanical animations, such as rotating spinners."
  },
  "motion-keyframes-bounce": {
    value: "{ from, 65%, 85% { transform: scale(1) } 75% { transform: scale(0.85) } 82.5% { transform: scale(1.05) } }"
  },
  "motion-keyframes-fade-in": {
    value: "{ to { opacity: 1 } }"
  },
  "motion-keyframes-pulse": {
    value: "{ from, 75% { transform: scale(0.85); opacity: 1; } to { transform: scale(2.5); opacity: 0; } }"
  },
  "motion-keyframes-spin": {
    value: "{ to { transform: rotate(1turn) } }"
  },
  "motion-keyframes-appear-above": {
    value: "{ from { transform: translateY(var(--p-space-1)); opacity: 0; } to { transform: none; opacity: 1; } }"
  },
  "motion-keyframes-appear-below": {
    value: "{ from { transform: translateY(calc(var(--p-space-1) * -1)); opacity: 0; } to { transform: none; opacity: 1; } }"
  }
};

// ../node_modules/@shopify/polaris-tokens/dist/esm/src/token-groups/shadow.mjs
var shadow = {
  "shadow-inset-lg": {
    value: "inset 0px 0px 7px 2px rgba(31, 33, 36, 0.18)"
  },
  "shadow-inset-md": {
    value: "inset 0px 2px 4px rgba(31, 33, 36, 0.32)"
  },
  "shadow-inset-sm": {
    value: "inset 0px 0px 3px rgba(31, 33, 36, 0.56)"
  },
  "shadow-none": {
    value: "none"
  },
  "shadow-xs": {
    value: "0px 0px 2px rgba(31, 33, 36, 0.24)"
  },
  "shadow-sm": {
    value: "0px 1px 1px rgba(31, 33, 36, 0.1)"
  },
  "shadow-md": {
    value: "0px 2px 4px rgba(31, 33, 36, 0.1), 0px 1px 6px rgba(31, 33, 36, 0.05)"
  },
  "shadow-lg": {
    value: "0px 4px 12px rgba(31, 33, 36, 0.2), 0px 2px 6px rgba(31, 33, 36, 0.05)"
  },
  "shadow-xl": {
    value: "0px 4px 18px -2px rgba(31, 33, 36, 0.08), 0px 12px 18px -2px rgba(31, 33, 36, 0.15)"
  },
  "shadow-2xl": {
    value: "0px 32px 32px rgba(31, 33, 36, 0.15), 0px 32px 56px -2px rgba(31, 33, 36, 0.16)"
  }
};

// ../node_modules/@shopify/polaris-tokens/dist/esm/src/token-groups/shape.mjs
var shape = {
  "border-radius-05": {
    value: "2px"
  },
  "border-radius-1": {
    value: "4px"
  },
  "border-radius-2": {
    value: "8px"
  },
  "border-radius-3": {
    value: "12px"
  },
  "border-radius-4": {
    value: "16px"
  },
  "border-radius-5": {
    value: "20px"
  },
  "border-radius-6": {
    value: "30px"
  },
  "border-radius-full": {
    value: "9999px"
  },
  "border-radius-base": {
    value: "3px"
  },
  "border-radius-large": {
    value: "6px"
  },
  "border-radius-half": {
    value: "50%"
  },
  "border-width-1": {
    value: "1px"
  },
  "border-width-2": {
    value: "2px"
  },
  "border-width-3": {
    value: "3px"
  },
  "border-width-4": {
    value: "4px"
  },
  "border-width-5": {
    value: "5px"
  },
  "border-base": {
    value: "var(--p-border-width-1) solid var(--p-color-border-subdued)"
  },
  "border-dark": {
    value: "var(--p-border-width-1) solid var(--p-color-border)"
  },
  "border-transparent": {
    value: "var(--p-border-width-1) solid transparent"
  },
  "border-divider": {
    value: "var(--p-border-width-1) solid var(--p-color-border-subdued)"
  },
  "border-divider-on-dark": {
    value: "var(--p-border-width-1) solid var(--p-color-border-inverse)"
  }
};

// ../node_modules/@shopify/polaris-tokens/dist/esm/src/token-groups/spacing.mjs
var spacing = {
  "space-0": {
    value: "0"
  },
  "space-025": {
    value: "1px"
  },
  "space-05": {
    value: "2px"
  },
  "space-1": {
    value: "4px"
  },
  "space-2": {
    value: "8px"
  },
  "space-3": {
    value: "12px"
  },
  "space-4": {
    value: "16px"
  },
  "space-5": {
    value: "20px"
  },
  "space-6": {
    value: "24px"
  },
  "space-8": {
    value: "32px"
  },
  "space-10": {
    value: "40px"
  },
  "space-12": {
    value: "48px"
  },
  "space-16": {
    value: "64px"
  },
  "space-20": {
    value: "80px"
  },
  "space-24": {
    value: "96px"
  },
  "space-28": {
    value: "112px"
  },
  "space-32": {
    value: "128px"
  }
};

// ../node_modules/@shopify/polaris-tokens/dist/esm/src/token-groups/space.mjs
var space = {
  "space-0": {
    value: "0"
  },
  "space-025": {
    value: "1px"
  },
  "space-05": {
    value: "2px"
  },
  "space-1": {
    value: "4px"
  },
  "space-2": {
    value: "8px"
  },
  "space-3": {
    value: "12px"
  },
  "space-4": {
    value: "16px"
  },
  "space-5": {
    value: "20px"
  },
  "space-6": {
    value: "24px"
  },
  "space-8": {
    value: "32px"
  },
  "space-10": {
    value: "40px"
  },
  "space-12": {
    value: "48px"
  },
  "space-16": {
    value: "64px"
  },
  "space-20": {
    value: "80px"
  },
  "space-24": {
    value: "96px"
  },
  "space-28": {
    value: "112px"
  },
  "space-32": {
    value: "128px"
  }
};

// ../node_modules/@shopify/polaris-tokens/dist/esm/src/token-groups/zIndex.mjs
var zIndex = {
  "z-index-1": {
    value: "100"
  },
  "z-index-2": {
    value: "400"
  },
  "z-index-3": {
    value: "510"
  },
  "z-index-4": {
    value: "512"
  },
  "z-index-5": {
    value: "513"
  },
  "z-index-6": {
    value: "514"
  },
  "z-index-7": {
    value: "515"
  },
  "z-index-8": {
    value: "516"
  },
  "z-index-9": {
    value: "517"
  },
  "z-index-10": {
    value: "518"
  },
  "z-index-11": {
    value: "519"
  },
  "z-index-12": {
    value: "520"
  },
  "z-1": {
    value: "100"
  },
  "z-2": {
    value: "400"
  },
  "z-3": {
    value: "510"
  },
  "z-4": {
    value: "512"
  },
  "z-5": {
    value: "513"
  },
  "z-6": {
    value: "514"
  },
  "z-7": {
    value: "515"
  },
  "z-8": {
    value: "516"
  },
  "z-9": {
    value: "517"
  },
  "z-10": {
    value: "518"
  },
  "z-11": {
    value: "519"
  },
  "z-12": {
    value: "520"
  }
};

// ../node_modules/@shopify/polaris-tokens/dist/esm/src/metadata.mjs
var metadata = createMetadata({
  breakpoints: tokensToRems(breakpoints),
  border: tokensToRems(border),
  color,
  colors,
  depth,
  font: tokensToRems(font),
  legacy: tokensToRems(legacy),
  motion,
  shadow: tokensToRems(shadow),
  shape: tokensToRems(shape),
  spacing: tokensToRems(spacing),
  space: tokensToRems(space),
  zIndex
});
function createMetadata(metadata2) {
  return metadata2;
}

// ../node_modules/@shopify/polaris-tokens/dist/esm/build/index.mjs
var breakpoints2 = {
  "breakpoints-xs": "0rem",
  "breakpoints-sm": "30.625rem",
  "breakpoints-md": "48rem",
  "breakpoints-lg": "65rem",
  "breakpoints-xl": "90rem"
};
var motion2 = {
  "duration-0": "0ms",
  "duration-50": "50ms",
  "duration-100": "100ms",
  "duration-150": "150ms",
  "duration-200": "200ms",
  "duration-250": "250ms",
  "duration-300": "300ms",
  "duration-350": "350ms",
  "duration-400": "400ms",
  "duration-450": "450ms",
  "duration-500": "500ms",
  "duration-5000": "5000ms",
  "ease": "cubic-bezier(0.25, 0.1, 0.25, 1)",
  "ease-in": "cubic-bezier(0.42, 0, 1, 1)",
  "ease-out": "cubic-bezier(0, 0, 0.58, 1)",
  "ease-in-out": "cubic-bezier(0.42, 0, 0.58, 1)",
  "linear": "cubic-bezier(0, 0, 1, 1)",
  "keyframes-bounce": "{ from, 65%, 85% { transform: scale(1) } 75% { transform: scale(0.85) } 82.5% { transform: scale(1.05) } }",
  "keyframes-fade-in": "{ to { opacity: 1 } }",
  "keyframes-pulse": "{ from, 75% { transform: scale(0.85); opacity: 1; } to { transform: scale(2.5); opacity: 0; } }",
  "keyframes-spin": "{ to { transform: rotate(1turn) } }",
  "keyframes-appear-above": "{ from { transform: translateY(var(--p-space-1)); opacity: 0; } to { transform: none; opacity: 1; } }",
  "keyframes-appear-below": "{ from { transform: translateY(calc(var(--p-space-1) * -1)); opacity: 0; } to { transform: none; opacity: 1; } }",
  "motion-duration-0": "0ms",
  "motion-duration-50": "50ms",
  "motion-duration-100": "100ms",
  "motion-duration-150": "150ms",
  "motion-duration-200": "200ms",
  "motion-duration-250": "250ms",
  "motion-duration-300": "300ms",
  "motion-duration-350": "350ms",
  "motion-duration-400": "400ms",
  "motion-duration-450": "450ms",
  "motion-duration-500": "500ms",
  "motion-duration-5000": "5000ms",
  "motion-ease": "cubic-bezier(0.25, 0.1, 0.25, 1)",
  "motion-ease-in": "cubic-bezier(0.42, 0, 1, 1)",
  "motion-ease-out": "cubic-bezier(0, 0, 0.58, 1)",
  "motion-ease-in-out": "cubic-bezier(0.42, 0, 0.58, 1)",
  "motion-linear": "cubic-bezier(0, 0, 1, 1)",
  "motion-keyframes-bounce": "{ from, 65%, 85% { transform: scale(1) } 75% { transform: scale(0.85) } 82.5% { transform: scale(1.05) } }",
  "motion-keyframes-fade-in": "{ to { opacity: 1 } }",
  "motion-keyframes-pulse": "{ from, 75% { transform: scale(0.85); opacity: 1; } to { transform: scale(2.5); opacity: 0; } }",
  "motion-keyframes-spin": "{ to { transform: rotate(1turn) } }",
  "motion-keyframes-appear-above": "{ from { transform: translateY(var(--p-space-1)); opacity: 0; } to { transform: none; opacity: 1; } }",
  "motion-keyframes-appear-below": "{ from { transform: translateY(calc(var(--p-space-1) * -1)); opacity: 0; } to { transform: none; opacity: 1; } }"
};
var space2 = {
  "space-0": "0",
  "space-025": "0.0625rem",
  "space-05": "0.125rem",
  "space-1": "0.25rem",
  "space-2": "0.5rem",
  "space-3": "0.75rem",
  "space-4": "1rem",
  "space-5": "1.25rem",
  "space-6": "1.5rem",
  "space-8": "2rem",
  "space-10": "2.5rem",
  "space-12": "3rem",
  "space-16": "4rem",
  "space-20": "5rem",
  "space-24": "6rem",
  "space-28": "7rem",
  "space-32": "8rem"
};
var zIndex2 = {
  "z-index-1": "100",
  "z-index-2": "400",
  "z-index-3": "510",
  "z-index-4": "512",
  "z-index-5": "513",
  "z-index-6": "514",
  "z-index-7": "515",
  "z-index-8": "516",
  "z-index-9": "517",
  "z-index-10": "518",
  "z-index-11": "519",
  "z-index-12": "520",
  "z-1": "100",
  "z-2": "400",
  "z-3": "510",
  "z-4": "512",
  "z-5": "513",
  "z-6": "514",
  "z-7": "515",
  "z-8": "516",
  "z-9": "517",
  "z-10": "518",
  "z-11": "519",
  "z-12": "520"
};
var tokens = {
  "breakpoints": {
    "breakpoints-xs": "0rem",
    "breakpoints-sm": "30.625rem",
    "breakpoints-md": "48rem",
    "breakpoints-lg": "65rem",
    "breakpoints-xl": "90rem"
  },
  "border": {
    "border-radius-05": "0.125rem",
    "border-radius-1": "0.25rem",
    "border-radius-2": "0.5rem",
    "border-radius-3": "0.75rem",
    "border-radius-4": "1rem",
    "border-radius-5": "1.25rem",
    "border-radius-6": "1.875rem",
    "border-radius-full": "624.9375rem",
    "border-width-1": "0.0625rem",
    "border-width-2": "0.125rem",
    "border-width-3": "0.1875rem",
    "border-width-4": "0.25rem",
    "border-width-5": "0.3125rem"
  },
  "color": {
    "color-bg-inverse": "rgba(31, 33, 36, 1)",
    "color-bg-inset-strong": "rgba(97, 106, 117, 1)",
    "color-bg-inverse-hover": "rgba(97, 106, 117, 1)",
    "color-bg-inverse-active": "rgba(135, 144, 155, 1)",
    "color-bg-strong-hover": "rgba(202, 206, 211, 1)",
    "color-bg-strong-active": "rgba(202, 206, 211, 1)",
    "color-bg-strong": "rgba(221, 224, 228, 1)",
    "color-bg-subdued-active": "rgba(235, 236, 239, 1)",
    "color-bg-disabled": "rgba(235, 236, 239, 1)",
    "color-bg-interactive-disabled": "rgba(235, 236, 239, 1)",
    "color-bg-app": "rgba(241, 242, 244, 1)",
    "color-bg-app-active": "rgba(221, 224, 228, 1)",
    "color-bg-app-hover": "rgba(235, 236, 239, 1)",
    "color-bg-app-selected": "rgba(235, 236, 239, 1)",
    "color-bg-active": "rgba(235, 236, 239, 1)",
    "color-bg-subdued-hover": "rgba(241, 242, 244, 1)",
    "color-bg-inset": "rgba(241, 242, 244, 1)",
    "color-bg-hover": "rgba(241, 242, 244, 1)",
    "color-bg-subdued": "rgba(249, 250, 251, 1)",
    "color-bg-input": "rgba(255, 255, 255, 1)",
    "color-bg": "rgba(255, 255, 255, 1)",
    "color-bg-primary-active": "rgba(12, 59, 47, 1)",
    "color-bg-primary-hover": "rgba(18, 84, 67, 1)",
    "color-bg-primary": "rgba(0, 122, 92, 1)",
    "color-bg-success-strong": "rgba(22, 166, 121, 1)",
    "color-bg-success": "rgba(161, 237, 208, 1)",
    "color-bg-primary-subdued-active": "rgba(192, 242, 221, 1)",
    "color-bg-success-subdued-active": "rgba(192, 242, 221, 1)",
    "color-bg-success-subdued": "rgba(224, 248, 238, 1)",
    "color-bg-primary-subdued-hover": "rgba(224, 248, 238, 1)",
    "color-bg-success-subdued-hover": "rgba(240, 253, 248, 1)",
    "color-bg-primary-subdued": "rgba(240, 253, 248, 1)",
    "color-bg-primary-subdued-selected": "rgba(240, 253, 248, 1)",
    "color-bg-critical-strong-active": "rgba(115, 24, 7, 1)",
    "color-bg-critical-strong-hover": "rgba(159, 32, 10, 1)",
    "color-bg-critical-strong": "rgba(197, 40, 12, 1)",
    "color-bg-critical-subdued-active": "rgba(251, 197, 188, 1)",
    "color-bg-critical": "rgba(251, 197, 188, 1)",
    "color-bg-critical-subdued": "rgba(253, 226, 221, 1)",
    "color-bg-critical-subdued-hover": "rgba(254, 243, 241, 1)",
    "color-bg-caution-strong": "rgba(216, 155, 13, 1)",
    "color-bg-caution": "rgba(248, 217, 144, 1)",
    "color-bg-caution-subdued-active": "rgba(250, 229, 178, 1)",
    "color-bg-caution-subdued": "rgba(252, 240, 212, 1)",
    "color-bg-caution-subdued-hover": "rgba(254, 248, 236, 1)",
    "color-bg-info-strong": "rgba(42, 172, 187, 1)",
    "color-bg-info-subdued-active": "rgba(184, 233, 239, 1)",
    "color-bg-info": "rgba(184, 233, 239, 1)",
    "color-bg-info-subdued": "rgba(222, 245, 247, 1)",
    "color-bg-info-subdued-hover": "rgba(238, 250, 251, 1)",
    "color-bg-interactive-active": "rgba(14, 53, 108, 1)",
    "color-bg-interactive-hover": "rgba(20, 73, 149, 1)",
    "color-bg-interactive": "rgba(36, 99, 188, 1)",
    "color-bg-interactive-subdued-active": "rgba(187, 212, 247, 1)",
    "color-bg-interactive-subdued-hover": "rgba(232, 240, 253, 1)",
    "color-bg-interactive-subdued": "rgba(240, 245, 253, 1)",
    "color-bg-interactive-selected": "rgba(240, 245, 253, 1)",
    "color-bg-warning": "rgba(250, 201, 168, 1)",
    "color-bg-magic-strong": "rgba(121, 69, 227, 1)",
    "color-bg-magic-hover": "rgba(226, 214, 250, 1)",
    "color-bg-magic-active": "rgba(203, 180, 248, 1)",
    "color-bg-magic": "rgba(236, 227, 253, 1)",
    "color-bg-magic-subdued-hover": "rgba(236, 227, 253, 1)",
    "color-bg-magic-subdued-active": "rgba(226, 214, 250, 1)",
    "color-bg-magic-subdued": "rgba(242, 237, 253, 1)",
    "color-border-input-hover": "rgba(97, 106, 117, 1)",
    "color-border-inverse": "rgba(97, 106, 117, 1)",
    "color-border-strong-hover": "rgba(135, 144, 155, 1)",
    "color-border-input": "rgba(171, 177, 186, 1)",
    "color-border-hover": "rgba(171, 177, 186, 1)",
    "color-border-strong": "rgba(171, 177, 186, 1)",
    "color-border": "rgba(202, 206, 211, 1)",
    "color-border-disabled": "rgba(221, 224, 228, 1)",
    "color-border-subdued": "rgba(221, 224, 228, 1)",
    "color-border-interactive-disabled": "rgba(221, 224, 228, 1)",
    "color-border-primary": "rgba(0, 122, 92, 1)",
    "color-border-success": "rgba(22, 166, 121, 1)",
    "color-border-success-subdued": "rgba(80, 220, 169, 1)",
    "color-border-critical-active": "rgba(67, 14, 4, 1)",
    "color-border-critical-hover": "rgba(115, 24, 7, 1)",
    "color-border-critical": "rgba(197, 40, 12, 1)",
    "color-border-critical-subdued": "rgba(245, 107, 82, 1)",
    "color-border-caution": "rgba(216, 155, 13, 1)",
    "color-border-caution-subdued": "rgba(245, 196, 82, 1)",
    "color-border-info": "rgba(59, 195, 211, 1)",
    "color-border-info-subdued": "rgba(109, 211, 222, 1)",
    "color-border-interactive-active": "rgba(14, 53, 108, 1)",
    "color-border-interactive-hover": "rgba(20, 73, 149, 1)",
    "color-border-interactive": "rgba(62, 125, 213, 1)",
    "color-border-interactive-focus": "rgba(62, 125, 213, 1)",
    "color-border-interactive-subdued": "rgba(187, 212, 247, 1)",
    "color-border-magic-strong": "rgba(121, 69, 227, 1)",
    "color-border-magic": "rgba(173, 139, 241, 1)",
    "color-icon-hover": "rgba(31, 33, 36, 1)",
    "color-icon": "rgba(97, 106, 117, 1)",
    "color-icon-active": "rgba(31, 33, 36, 1)",
    "color-icon-subdued": "rgba(135, 144, 155, 1)",
    "color-icon-disabled": "rgba(171, 177, 186, 1)",
    "color-icon-interactive-disabled": "rgba(171, 177, 186, 1)",
    "color-icon-inverse": "rgba(221, 224, 228, 1)",
    "color-icon-on-color": "rgba(255, 255, 255, 1)",
    "color-icon-primary": "rgba(0, 122, 92, 1)",
    "color-icon-success": "rgba(22, 166, 121, 1)",
    "color-icon-critical": "rgba(197, 40, 12, 1)",
    "color-icon-caution": "rgba(183, 126, 11, 1)",
    "color-icon-info": "rgba(42, 172, 187, 1)",
    "color-icon-warning": "rgba(242, 117, 34, 1)",
    "color-icon-interactive-active": "rgba(14, 53, 108, 1)",
    "color-icon-interactive-hover": "rgba(20, 73, 149, 1)",
    "color-icon-interactive": "rgba(36, 99, 188, 1)",
    "color-icon-interactive-inverse": "rgba(102, 153, 225, 1)",
    "color-icon-magic": "rgba(121, 69, 227, 1)",
    "color-text": "rgba(31, 33, 36, 1)",
    "color-text-subdued": "rgba(97, 106, 117, 1)",
    "color-text-disabled": "rgba(135, 144, 155, 1)",
    "color-text-interactive-disabled": "rgba(135, 144, 155, 1)",
    "color-text-inverse-subdued": "rgba(171, 177, 186, 1)",
    "color-text-inverse": "rgba(241, 242, 244, 1)",
    "color-text-on-color": "rgba(255, 255, 255, 1)",
    "color-text-success-strong": "rgba(12, 59, 47, 1)",
    "color-text-success": "rgba(0, 122, 92, 1)",
    "color-text-primary": "rgba(0, 122, 92, 1)",
    "color-text-primary-hover": "rgba(18, 84, 67, 1)",
    "color-text-critical-strong": "rgba(67, 14, 4, 1)",
    "color-text-critical-active": "rgba(115, 24, 7, 1)",
    "color-text-critical": "rgba(197, 40, 12, 1)",
    "color-text-caution-strong": "rgba(77, 46, 5, 1)",
    "color-text-caution": "rgba(135, 92, 8, 1)",
    "color-text-info-strong": "rgba(16, 65, 71, 1)",
    "color-text-info": "rgba(32, 130, 141, 1)",
    "color-text-warning-strong": "rgba(77, 36, 5, 1)",
    "color-text-interactive-active": "rgba(14, 53, 108, 1)",
    "color-text-interactive-hover": "rgba(20, 73, 149, 1)",
    "color-text-interactive": "rgba(36, 99, 188, 1)",
    "color-text-interactive-inverse": "rgba(102, 153, 225, 1)",
    "color-text-magic-strong": "rgba(49, 13, 120, 1)",
    "color-text-magic": "rgba(90, 36, 205, 1)"
  },
  "colors": {
    "background": "rgba(246, 246, 247, 1)",
    "background-hovered": "rgba(241, 242, 243, 1)",
    "background-pressed": "rgba(237, 238, 239, 1)",
    "background-selected": "rgba(237, 238, 239, 1)",
    "surface": "rgba(255, 255, 255, 1)",
    "surface-dark": "rgba(32, 33, 35, 1)",
    "surface-neutral": "rgba(228, 229, 231, 1)",
    "surface-neutral-hovered": "rgba(219, 221, 223, 1)",
    "surface-neutral-pressed": "rgba(201, 204, 208, 1)",
    "surface-neutral-disabled": "rgba(241, 242, 243, 1)",
    "surface-neutral-subdued": "rgba(246, 246, 247, 1)",
    "surface-neutral-subdued-dark": "rgba(68, 71, 74, 1)",
    "surface-subdued": "rgba(250, 251, 251, 1)",
    "surface-disabled": "rgba(250, 251, 251, 1)",
    "surface-hovered": "rgba(246, 246, 247, 1)",
    "surface-hovered-dark": "rgba(47, 49, 51, 1)",
    "surface-pressed": "rgba(241, 242, 243, 1)",
    "surface-pressed-dark": "rgba(62, 64, 67, 1)",
    "surface-depressed": "rgba(237, 238, 239, 1)",
    "surface-search-field": "rgba(241, 242, 243, 1)",
    "surface-search-field-dark": "rgba(47, 49, 51, 1)",
    "backdrop": "rgba(0, 0, 0, 0.5)",
    "overlay": "rgba(255, 255, 255, 0.5)",
    "shadow-color-picker": "rgba(0, 0, 0, 0.5)",
    "shadow-color-picker-dragger": "rgba(33, 43, 54, 0.32)",
    "hint-from-direct-light": "rgba(0, 0, 0, 0.15)",
    "border": "rgba(140, 145, 150, 1)",
    "border-on-dark": "rgba(80, 83, 86, 1)",
    "border-neutral-subdued": "rgba(186, 191, 195, 1)",
    "border-hovered": "rgba(153, 158, 164, 1)",
    "border-disabled": "rgba(210, 213, 216, 1)",
    "border-subdued": "rgba(201, 204, 207, 1)",
    "border-depressed": "rgba(87, 89, 89, 1)",
    "border-shadow": "rgba(174, 180, 185, 1)",
    "border-shadow-subdued": "rgba(186, 191, 196, 1)",
    "divider": "rgba(225, 227, 229, 1)",
    "divider-dark": "rgba(69, 71, 73, 1)",
    "icon": "rgba(92, 95, 98, 1)",
    "icon-on-dark": "rgba(166, 172, 178, 1)",
    "icon-hovered": "rgba(26, 28, 29, 1)",
    "icon-pressed": "rgba(68, 71, 74, 1)",
    "icon-disabled": "rgba(186, 190, 195, 1)",
    "icon-subdued": "rgba(140, 145, 150, 1)",
    "text": "rgba(32, 34, 35, 1)",
    "text-on-dark": "rgba(227, 229, 231, 1)",
    "text-disabled": "rgba(140, 145, 150, 1)",
    "text-subdued": "rgba(109, 113, 117, 1)",
    "text-subdued-on-dark": "rgba(153, 159, 164, 1)",
    "interactive": "rgba(44, 110, 203, 1)",
    "interactive-on-dark": "rgba(54, 163, 255, 1)",
    "interactive-disabled": "rgba(189, 193, 204, 1)",
    "interactive-hovered": "rgba(31, 81, 153, 1)",
    "interactive-pressed": "rgba(16, 50, 98, 1)",
    "interactive-pressed-on-dark": "rgba(136, 188, 255, 1)",
    "focused": "rgba(69, 143, 255, 1)",
    "surface-selected": "rgba(242, 247, 254, 1)",
    "surface-selected-hovered": "rgba(237, 244, 254, 1)",
    "surface-selected-pressed": "rgba(229, 239, 253, 1)",
    "icon-on-interactive": "rgba(255, 255, 255, 1)",
    "text-on-interactive": "rgba(255, 255, 255, 1)",
    "action-secondary": "rgba(255, 255, 255, 1)",
    "action-secondary-disabled": "rgba(255, 255, 255, 1)",
    "action-secondary-hovered": "rgba(246, 246, 247, 1)",
    "action-secondary-hovered-dark": "rgba(84, 87, 91, 1)",
    "action-secondary-pressed": "rgba(241, 242, 243, 1)",
    "action-secondary-pressed-dark": "rgba(96, 100, 103, 1)",
    "action-secondary-depressed": "rgba(109, 113, 117, 1)",
    "action-primary": "rgba(0, 128, 96, 1)",
    "action-primary-disabled": "rgba(241, 241, 241, 1)",
    "action-primary-hovered": "rgba(0, 110, 82, 1)",
    "action-primary-pressed": "rgba(0, 94, 70, 1)",
    "action-primary-depressed": "rgba(0, 61, 44, 1)",
    "icon-on-primary": "rgba(255, 255, 255, 1)",
    "text-on-primary": "rgba(255, 255, 255, 1)",
    "text-primary": "rgba(0, 123, 92, 1)",
    "text-primary-hovered": "rgba(0, 108, 80, 1)",
    "text-primary-pressed": "rgba(0, 92, 68, 1)",
    "surface-primary-selected": "rgba(241, 248, 245, 1)",
    "surface-primary-selected-hovered": "rgba(179, 208, 195, 1)",
    "surface-primary-selected-pressed": "rgba(162, 188, 176, 1)",
    "border-critical": "rgba(253, 87, 73, 1)",
    "border-critical-subdued": "rgba(224, 179, 178, 1)",
    "border-critical-disabled": "rgba(255, 167, 163, 1)",
    "icon-critical": "rgba(215, 44, 13, 1)",
    "surface-critical": "rgba(254, 211, 209, 1)",
    "surface-critical-subdued": "rgba(255, 244, 244, 1)",
    "surface-critical-subdued-hovered": "rgba(255, 240, 240, 1)",
    "surface-critical-subdued-pressed": "rgba(255, 233, 232, 1)",
    "surface-critical-subdued-depressed": "rgba(254, 188, 185, 1)",
    "text-critical": "rgba(215, 44, 13, 1)",
    "action-critical": "rgba(216, 44, 13, 1)",
    "action-critical-disabled": "rgba(241, 241, 241, 1)",
    "action-critical-hovered": "rgba(188, 34, 0, 1)",
    "action-critical-pressed": "rgba(162, 27, 0, 1)",
    "action-critical-depressed": "rgba(108, 15, 0, 1)",
    "icon-on-critical": "rgba(255, 255, 255, 1)",
    "text-on-critical": "rgba(255, 255, 255, 1)",
    "interactive-critical": "rgba(216, 44, 13, 1)",
    "interactive-critical-disabled": "rgba(253, 147, 141, 1)",
    "interactive-critical-hovered": "rgba(205, 41, 12, 1)",
    "interactive-critical-pressed": "rgba(103, 15, 3, 1)",
    "border-warning": "rgba(185, 137, 0, 1)",
    "border-warning-subdued": "rgba(225, 184, 120, 1)",
    "icon-warning": "rgba(185, 137, 0, 1)",
    "surface-warning": "rgba(255, 215, 157, 1)",
    "surface-warning-subdued": "rgba(255, 245, 234, 1)",
    "surface-warning-subdued-hovered": "rgba(255, 242, 226, 1)",
    "surface-warning-subdued-pressed": "rgba(255, 235, 211, 1)",
    "text-warning": "rgba(145, 106, 0, 1)",
    "border-highlight": "rgba(68, 157, 167, 1)",
    "border-highlight-subdued": "rgba(152, 198, 205, 1)",
    "icon-highlight": "rgba(0, 160, 172, 1)",
    "surface-highlight": "rgba(164, 232, 242, 1)",
    "surface-highlight-subdued": "rgba(235, 249, 252, 1)",
    "surface-highlight-subdued-hovered": "rgba(228, 247, 250, 1)",
    "surface-highlight-subdued-pressed": "rgba(213, 243, 248, 1)",
    "text-highlight": "rgba(52, 124, 132, 1)",
    "border-success": "rgba(0, 164, 124, 1)",
    "border-success-subdued": "rgba(149, 201, 180, 1)",
    "icon-success": "rgba(0, 127, 95, 1)",
    "surface-success": "rgba(174, 233, 209, 1)",
    "surface-success-subdued": "rgba(241, 248, 245, 1)",
    "surface-success-subdued-hovered": "rgba(236, 246, 241, 1)",
    "surface-success-subdued-pressed": "rgba(226, 241, 234, 1)",
    "text-success": "rgba(0, 128, 96, 1)",
    "icon-attention": "rgba(138, 97, 22, 1)",
    "surface-attention": "rgba(255, 234, 138, 1)",
    "decorative-one-icon": "rgba(126, 87, 0, 1)",
    "decorative-one-surface": "rgba(255, 201, 107, 1)",
    "decorative-one-text": "rgba(61, 40, 0, 1)",
    "decorative-two-icon": "rgba(175, 41, 78, 1)",
    "decorative-two-surface": "rgba(255, 196, 176, 1)",
    "decorative-two-text": "rgba(73, 11, 28, 1)",
    "decorative-three-icon": "rgba(0, 109, 65, 1)",
    "decorative-three-surface": "rgba(146, 230, 181, 1)",
    "decorative-three-text": "rgba(0, 47, 25, 1)",
    "decorative-four-icon": "rgba(0, 106, 104, 1)",
    "decorative-four-surface": "rgba(145, 224, 214, 1)",
    "decorative-four-text": "rgba(0, 45, 45, 1)",
    "decorative-five-icon": "rgba(174, 43, 76, 1)",
    "decorative-five-surface": "rgba(253, 201, 208, 1)",
    "decorative-five-text": "rgba(79, 14, 31, 1)"
  },
  "depth": {
    "shadow-transparent": "0 0 0 0 transparent",
    "shadow-faint": "0 1px 0 0 rgba(22, 29, 37, 0.05)",
    "shadow-base": "0 0 0 1px rgba(63, 63, 68, 0.05), 0 1px 3px 0 rgba(63, 63, 68, 0.15)",
    "shadow-deep": "0 0 0 1px rgba(6, 44, 82, 0.1), 0 2px 16px rgba(33, 43, 54, 0.08)",
    "shadow-button": "0 1px 0 rgba(0, 0, 0, 0.05)",
    "shadow-top-bar": "0 2px 2px -1px rgba(0, 0, 0, 0.15)",
    "shadow-card": "0 0 5px rgba(23, 24, 24, 0.05), 0 1px 2px rgba(0, 0, 0, 0.15)",
    "shadow-popover": "0 3px 6px -3px rgba(23, 24, 24, 0.08), 0 8px 20px -4px rgba(23, 24, 24, 0.12)",
    "shadow-layer": "0 31px 41px 0 rgba(32, 42, 53, 0.2), 0 2px 16px 0 rgba(32, 42, 54, 0.08)",
    "shadow-modal": "0 26px 80px rgba(0, 0, 0, 0.2), 0 0px 1px rgba(0, 0, 0, 0.2)",
    "shadows-inset-button": "inset 0 -1px 0 rgba(0, 0, 0, 0.2)",
    "shadows-inset-button-pressed": "inset 0 1px 0 rgba(0, 0, 0, 0.15)"
  },
  "font": {
    "font-family-sans": "-apple-system, BlinkMacSystemFont, 'San Francisco', 'Segoe UI', Roboto, 'Helvetica Neue', sans-serif",
    "font-family-mono": "ui-monospace, SFMono-Regular, 'SF Mono', Consolas, 'Liberation Mono', Menlo, monospace",
    "font-size-75": "0.75rem",
    "font-size-100": "0.875rem",
    "font-size-200": "1rem",
    "font-size-300": "1.25rem",
    "font-size-400": "1.5rem",
    "font-size-500": "1.75rem",
    "font-size-600": "2rem",
    "font-size-700": "2.5rem",
    "font-weight-regular": "400",
    "font-weight-medium": "500",
    "font-weight-semibold": "600",
    "font-weight-bold": "700",
    "font-line-height-1": "1rem",
    "font-line-height-2": "1.25rem",
    "font-line-height-3": "1.5rem",
    "font-line-height-4": "1.75rem",
    "font-line-height-5": "2rem",
    "font-line-height-6": "2.5rem",
    "font-line-height-7": "3rem"
  },
  "legacy": {
    "override-loading-z-index": "514",
    "choice-size": "1.25rem",
    "icon-size-small": "0.5rem",
    "icon-size-medium": "1.25rem",
    "choice-margin": "0.0625rem",
    "control-border-width": "0.125rem",
    "banner-border-default": "inset 0 0.0625rem 0 0 var(--p-color-border-strong), inset 0 0 0 0.0625rem var(--p-color-border-strong)",
    "banner-border-success": "inset 0 0.0625rem 0 0 var(--p-color-border-success-subdued), inset 0 0 0 0.0625rem var(--p-color-border-success-subdued)",
    "banner-border-highlight": "inset 0 0.0625rem 0 0 var(--p-color-border-info-subdued), inset 0 0 0 0.0625rem var(--p-color-border-info-subdued)",
    "banner-border-warning": "inset 0 0.0625rem 0 0 var(--p-color-border-caution-subdued), inset 0 0 0 0.0625rem var(--p-color-border-caution-subdued)",
    "banner-border-critical": "inset 0 0.0625rem 0 0 var(--p-color-border-critical-subdued), inset 0 0 0 0.0625rem var(--p-color-border-critical-subdued)",
    "thin-border-subdued": "0.0625rem solid var(--p-color-border-subdued)",
    "text-field-spinner-offset": "0.125rem",
    "text-field-focus-ring-offset": "-0.25rem",
    "button-group-item-spacing": "-0.0625rem",
    "range-slider-thumb-size-base": "1rem",
    "range-slider-thumb-size-active": "1.5rem",
    "frame-offset": "0rem"
  },
  "motion": {
    "duration-0": "0ms",
    "duration-50": "50ms",
    "duration-100": "100ms",
    "duration-150": "150ms",
    "duration-200": "200ms",
    "duration-250": "250ms",
    "duration-300": "300ms",
    "duration-350": "350ms",
    "duration-400": "400ms",
    "duration-450": "450ms",
    "duration-500": "500ms",
    "duration-5000": "5000ms",
    "ease": "cubic-bezier(0.25, 0.1, 0.25, 1)",
    "ease-in": "cubic-bezier(0.42, 0, 1, 1)",
    "ease-out": "cubic-bezier(0, 0, 0.58, 1)",
    "ease-in-out": "cubic-bezier(0.42, 0, 0.58, 1)",
    "linear": "cubic-bezier(0, 0, 1, 1)",
    "keyframes-bounce": "{ from, 65%, 85% { transform: scale(1) } 75% { transform: scale(0.85) } 82.5% { transform: scale(1.05) } }",
    "keyframes-fade-in": "{ to { opacity: 1 } }",
    "keyframes-pulse": "{ from, 75% { transform: scale(0.85); opacity: 1; } to { transform: scale(2.5); opacity: 0; } }",
    "keyframes-spin": "{ to { transform: rotate(1turn) } }",
    "keyframes-appear-above": "{ from { transform: translateY(var(--p-space-1)); opacity: 0; } to { transform: none; opacity: 1; } }",
    "keyframes-appear-below": "{ from { transform: translateY(calc(var(--p-space-1) * -1)); opacity: 0; } to { transform: none; opacity: 1; } }",
    "motion-duration-0": "0ms",
    "motion-duration-50": "50ms",
    "motion-duration-100": "100ms",
    "motion-duration-150": "150ms",
    "motion-duration-200": "200ms",
    "motion-duration-250": "250ms",
    "motion-duration-300": "300ms",
    "motion-duration-350": "350ms",
    "motion-duration-400": "400ms",
    "motion-duration-450": "450ms",
    "motion-duration-500": "500ms",
    "motion-duration-5000": "5000ms",
    "motion-ease": "cubic-bezier(0.25, 0.1, 0.25, 1)",
    "motion-ease-in": "cubic-bezier(0.42, 0, 1, 1)",
    "motion-ease-out": "cubic-bezier(0, 0, 0.58, 1)",
    "motion-ease-in-out": "cubic-bezier(0.42, 0, 0.58, 1)",
    "motion-linear": "cubic-bezier(0, 0, 1, 1)",
    "motion-keyframes-bounce": "{ from, 65%, 85% { transform: scale(1) } 75% { transform: scale(0.85) } 82.5% { transform: scale(1.05) } }",
    "motion-keyframes-fade-in": "{ to { opacity: 1 } }",
    "motion-keyframes-pulse": "{ from, 75% { transform: scale(0.85); opacity: 1; } to { transform: scale(2.5); opacity: 0; } }",
    "motion-keyframes-spin": "{ to { transform: rotate(1turn) } }",
    "motion-keyframes-appear-above": "{ from { transform: translateY(var(--p-space-1)); opacity: 0; } to { transform: none; opacity: 1; } }",
    "motion-keyframes-appear-below": "{ from { transform: translateY(calc(var(--p-space-1) * -1)); opacity: 0; } to { transform: none; opacity: 1; } }"
  },
  "shadow": {
    "shadow-inset-lg": "inset 0rem 0rem 0.4375rem 0.125rem rgba(31, 33, 36, 0.18)",
    "shadow-inset-md": "inset 0rem 0.125rem 0.25rem rgba(31, 33, 36, 0.32)",
    "shadow-inset-sm": "inset 0rem 0rem 0.1875rem rgba(31, 33, 36, 0.56)",
    "shadow-none": "none",
    "shadow-xs": "0rem 0rem 0.125rem rgba(31, 33, 36, 0.24)",
    "shadow-sm": "0rem 0.0625rem 0.0625rem rgba(31, 33, 36, 0.1)",
    "shadow-md": "0rem 0.125rem 0.25rem rgba(31, 33, 36, 0.1), 0rem 0.0625rem 0.375rem rgba(31, 33, 36, 0.05)",
    "shadow-lg": "0rem 0.25rem 0.75rem rgba(31, 33, 36, 0.2), 0rem 0.125rem 0.375rem rgba(31, 33, 36, 0.05)",
    "shadow-xl": "0rem 0.25rem 1.125rem -0.125rem rgba(31, 33, 36, 0.08), 0rem 0.75rem 1.125rem -0.125rem rgba(31, 33, 36, 0.15)",
    "shadow-2xl": "0rem 2rem 2rem rgba(31, 33, 36, 0.15), 0rem 2rem 3.5rem -0.125rem rgba(31, 33, 36, 0.16)"
  },
  "shape": {
    "border-radius-05": "0.125rem",
    "border-radius-1": "0.25rem",
    "border-radius-2": "0.5rem",
    "border-radius-3": "0.75rem",
    "border-radius-4": "1rem",
    "border-radius-5": "1.25rem",
    "border-radius-6": "1.875rem",
    "border-radius-full": "624.9375rem",
    "border-radius-base": "0.1875rem",
    "border-radius-large": "0.375rem",
    "border-radius-half": "50%",
    "border-width-1": "0.0625rem",
    "border-width-2": "0.125rem",
    "border-width-3": "0.1875rem",
    "border-width-4": "0.25rem",
    "border-width-5": "0.3125rem",
    "border-base": "var(--p-border-width-1) solid var(--p-color-border-subdued)",
    "border-dark": "var(--p-border-width-1) solid var(--p-color-border)",
    "border-transparent": "var(--p-border-width-1) solid transparent",
    "border-divider": "var(--p-border-width-1) solid var(--p-color-border-subdued)",
    "border-divider-on-dark": "var(--p-border-width-1) solid var(--p-color-border-inverse)"
  },
  "spacing": {
    "space-0": "0",
    "space-025": "0.0625rem",
    "space-05": "0.125rem",
    "space-1": "0.25rem",
    "space-2": "0.5rem",
    "space-3": "0.75rem",
    "space-4": "1rem",
    "space-5": "1.25rem",
    "space-6": "1.5rem",
    "space-8": "2rem",
    "space-10": "2.5rem",
    "space-12": "3rem",
    "space-16": "4rem",
    "space-20": "5rem",
    "space-24": "6rem",
    "space-28": "7rem",
    "space-32": "8rem"
  },
  "space": {
    "space-0": "0",
    "space-025": "0.0625rem",
    "space-05": "0.125rem",
    "space-1": "0.25rem",
    "space-2": "0.5rem",
    "space-3": "0.75rem",
    "space-4": "1rem",
    "space-5": "1.25rem",
    "space-6": "1.5rem",
    "space-8": "2rem",
    "space-10": "2.5rem",
    "space-12": "3rem",
    "space-16": "4rem",
    "space-20": "5rem",
    "space-24": "6rem",
    "space-28": "7rem",
    "space-32": "8rem"
  },
  "zIndex": {
    "z-index-1": "100",
    "z-index-2": "400",
    "z-index-3": "510",
    "z-index-4": "512",
    "z-index-5": "513",
    "z-index-6": "514",
    "z-index-7": "515",
    "z-index-8": "516",
    "z-index-9": "517",
    "z-index-10": "518",
    "z-index-11": "519",
    "z-index-12": "520",
    "z-1": "100",
    "z-2": "400",
    "z-3": "510",
    "z-4": "512",
    "z-5": "513",
    "z-6": "514",
    "z-7": "515",
    "z-8": "516",
    "z-9": "517",
    "z-10": "518",
    "z-11": "519",
    "z-12": "520"
  }
};

// ../node_modules/@shopify/polaris/build/esm/utilities/breakpoints.js
var Breakpoints = {
  // TODO: Update to smDown
  navigationBarCollapsed: "767.95px",
  // TODO: Update to lgDown
  stackedContent: "1039.95px"
};
var noWindowMatches = {
  media: "",
  addListener: noop,
  removeListener: noop,
  matches: false,
  onchange: noop,
  addEventListener: noop,
  removeEventListener: noop,
  dispatchEvent: (_) => true
};
function noop() {
}
function navigationBarCollapsed() {
  return typeof window === "undefined" ? noWindowMatches : window.matchMedia(`(max-width: ${Breakpoints.navigationBarCollapsed})`);
}
function stackedContent() {
  return typeof window === "undefined" ? noWindowMatches : window.matchMedia(`(max-width: ${Breakpoints.stackedContent})`);
}
var breakpointsQueryEntries = getBreakpointsQueryEntries(breakpoints2);
function getMatches(defaults) {
  if (!isServer) {
    return Object.fromEntries(breakpointsQueryEntries.map(([directionAlias, query]) => [directionAlias, window.matchMedia(query).matches]));
  }
  if (typeof defaults === "object" && defaults !== null) {
    return Object.fromEntries(breakpointsQueryEntries.map(([directionAlias]) => {
      var _defaults$directionAl;
      return [directionAlias, (_defaults$directionAl = defaults[directionAlias]) !== null && _defaults$directionAl !== void 0 ? _defaults$directionAl : false];
    }));
  }
  return Object.fromEntries(breakpointsQueryEntries.map(([directionAlias]) => [directionAlias, defaults !== null && defaults !== void 0 ? defaults : false]));
}
function useBreakpoints(options) {
  const [breakpoints3, setBreakpoints] = (0, import_react5.useState)(getMatches(options === null || options === void 0 ? void 0 : options.defaults));
  useIsomorphicLayoutEffect(() => {
    const mediaQueryLists = breakpointsQueryEntries.map(([_, query]) => window.matchMedia(query));
    const handler = () => setBreakpoints(getMatches());
    mediaQueryLists.forEach((mql) => {
      if (mql.addListener) {
        mql.addListener(handler);
      } else {
        mql.addEventListener("change", handler);
      }
    });
    return () => {
      mediaQueryLists.forEach((mql) => {
        if (mql.removeListener) {
          mql.removeListener(handler);
        } else {
          mql.removeEventListener("change", handler);
        }
      });
    };
  }, []);
  return breakpoints3;
}
function getBreakpointsQueryEntries(breakpoints3) {
  const mediaConditionEntries = Object.entries(getMediaConditions(breakpoints3));
  return mediaConditionEntries.map(([breakpointsToken, mediaConditions]) => Object.entries(mediaConditions).map(([direction, mediaCondition]) => {
    const breakpointsAlias = breakpointsToken.split("-")[1];
    const directionAlias = `${breakpointsAlias}${capitalize(direction)}`;
    return [directionAlias, mediaCondition];
  })).flat();
}
function capitalize(str) {
  return str.charAt(0).toUpperCase() + str.slice(1);
}

// ../node_modules/@shopify/polaris/build/esm/components/AppProvider/AppProvider.js
var import_react23 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/debounce.js
function debounce(func, waitArg, options) {
  let lastArgs;
  let lastThis;
  let maxWait;
  let result;
  let timerId;
  let lastCallTime;
  let lastInvokeTime = 0;
  let leading = false;
  let maxing = false;
  let trailing = true;
  const useRAF = !waitArg && waitArg !== 0;
  if (typeof func !== "function") {
    throw new TypeError("Expected a function");
  }
  const wait = waitArg || 0;
  if (typeof options === "object") {
    leading = Boolean(options.leading);
    maxing = "maxWait" in options;
    maxWait = maxing ? Math.max(Number(options.maxWait) || 0, wait) : void 0;
    trailing = "trailing" in options ? Boolean(options.trailing) : trailing;
  }
  function invokeFunc(time) {
    const args = lastArgs;
    const thisArg = lastThis;
    lastArgs = void 0;
    lastThis = void 0;
    lastInvokeTime = time;
    result = func.apply(thisArg, args);
    return result;
  }
  function startTimer(pendingFunc, wait2) {
    if (useRAF) {
      cancelAnimationFrame(timerId);
      return requestAnimationFrame(pendingFunc);
    }
    return setTimeout(pendingFunc, wait2);
  }
  function cancelTimer(id) {
    if (useRAF) {
      return cancelAnimationFrame(id);
    }
    clearTimeout(id);
  }
  function leadingEdge(time) {
    lastInvokeTime = time;
    timerId = startTimer(timerExpired, wait);
    return leading ? invokeFunc(time) : result;
  }
  function remainingWait(time) {
    const timeSinceLastCall = time - lastCallTime;
    const timeSinceLastInvoke = time - lastInvokeTime;
    const timeWaiting = wait - timeSinceLastCall;
    return maxing && maxWait ? Math.min(timeWaiting, maxWait - timeSinceLastInvoke) : timeWaiting;
  }
  function shouldInvoke(time) {
    const timeSinceLastCall = time - lastCallTime;
    const timeSinceLastInvoke = time - lastInvokeTime;
    return lastCallTime === void 0 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && maxWait && timeSinceLastInvoke >= maxWait;
  }
  function timerExpired() {
    const time = Date.now();
    if (shouldInvoke(time)) {
      return trailingEdge(time);
    }
    timerId = startTimer(timerExpired, remainingWait(time));
  }
  function trailingEdge(time) {
    timerId = void 0;
    if (trailing && lastArgs) {
      return invokeFunc(time);
    }
    lastArgs = lastThis = void 0;
    return result;
  }
  function cancel() {
    if (timerId !== void 0) {
      cancelTimer(timerId);
    }
    lastInvokeTime = 0;
    lastArgs = lastCallTime = lastThis = timerId = void 0;
  }
  function flush() {
    return timerId === void 0 ? result : trailingEdge(Date.now());
  }
  function pending() {
    return timerId !== void 0;
  }
  function debounced(...args) {
    const time = Date.now();
    const isInvoking = shouldInvoke(time);
    lastArgs = args;
    lastThis = this;
    lastCallTime = time;
    if (isInvoking) {
      if (timerId === void 0) {
        return leadingEdge(lastCallTime);
      }
      if (maxing) {
        timerId = startTimer(timerExpired, wait);
        return invokeFunc(lastCallTime);
      }
    }
    if (timerId === void 0) {
      timerId = startTimer(timerExpired, wait);
    }
    return result;
  }
  debounced.cancel = cancel;
  debounced.flush = flush;
  debounced.pending = pending;
  return debounced;
}

// ../node_modules/@shopify/polaris/build/esm/utilities/geometry.js
var Rect = class _Rect {
  static get zero() {
    return new _Rect();
  }
  constructor({
    top = 0,
    left = 0,
    width = 0,
    height = 0
  } = {}) {
    this.top = void 0;
    this.left = void 0;
    this.width = void 0;
    this.height = void 0;
    this.top = top;
    this.left = left;
    this.width = width;
    this.height = height;
  }
  get center() {
    return {
      x: this.left + this.width / 2,
      y: this.top + this.height / 2
    };
  }
};
function getRectForNode(node) {
  if (!(node instanceof Element)) {
    return new Rect({
      width: window.innerWidth,
      height: window.innerHeight
    });
  }
  const rect = node.getBoundingClientRect();
  return new Rect({
    top: rect.top,
    left: rect.left,
    width: rect.width,
    height: rect.height
  });
}

// ../node_modules/@shopify/polaris/build/esm/utilities/sticky-manager/sticky-manager.js
var SIXTY_FPS = 1e3 / 60;
var StickyManager = class {
  constructor(container) {
    this.stickyItems = [];
    this.stuckItems = [];
    this.container = null;
    this.topBarOffset = 0;
    this.handleResize = debounce(() => {
      this.manageStickyItems();
    }, SIXTY_FPS, {
      leading: true,
      trailing: true,
      maxWait: SIXTY_FPS
    });
    this.handleScroll = debounce(() => {
      this.manageStickyItems();
    }, SIXTY_FPS, {
      leading: true,
      trailing: true,
      maxWait: SIXTY_FPS
    });
    if (container) {
      this.setContainer(container);
    }
  }
  registerStickyItem(stickyItem) {
    this.stickyItems.push(stickyItem);
  }
  unregisterStickyItem(nodeToRemove) {
    const nodeIndex = this.stickyItems.findIndex(({
      stickyNode
    }) => nodeToRemove === stickyNode);
    this.stickyItems.splice(nodeIndex, 1);
  }
  setContainer(el) {
    this.container = el;
    if (isDocument(el)) {
      this.setTopBarOffset(el);
    }
    this.container.addEventListener("scroll", this.handleScroll);
    window.addEventListener("resize", this.handleResize);
    this.manageStickyItems();
  }
  removeScrollListener() {
    if (this.container) {
      this.container.removeEventListener("scroll", this.handleScroll);
      window.removeEventListener("resize", this.handleResize);
    }
  }
  manageStickyItems() {
    if (this.stickyItems.length <= 0) {
      return;
    }
    const scrollTop = this.container ? scrollTopFor(this.container) : 0;
    const containerTop = getRectForNode(this.container).top + this.topBarOffset;
    this.stickyItems.forEach((stickyItem) => {
      const {
        handlePositioning
      } = stickyItem;
      const {
        sticky,
        top,
        left,
        width
      } = this.evaluateStickyItem(stickyItem, scrollTop, containerTop);
      this.updateStuckItems(stickyItem, sticky);
      handlePositioning(sticky, top, left, width);
    });
  }
  evaluateStickyItem(stickyItem, scrollTop, containerTop) {
    const {
      stickyNode,
      placeHolderNode,
      boundingElement,
      offset,
      disableWhenStacked
    } = stickyItem;
    if (disableWhenStacked && stackedContent().matches) {
      return {
        sticky: false,
        top: 0,
        left: 0,
        width: "auto"
      };
    }
    const stickyOffset = offset ? this.getOffset(stickyNode) + parseInt(space2["space-5"], 10) : this.getOffset(stickyNode);
    const scrollPosition2 = scrollTop + stickyOffset;
    const placeHolderNodeCurrentTop = placeHolderNode.getBoundingClientRect().top - containerTop + scrollTop;
    const top = containerTop + stickyOffset;
    const width = placeHolderNode.getBoundingClientRect().width;
    const left = placeHolderNode.getBoundingClientRect().left;
    let sticky;
    if (boundingElement == null) {
      sticky = scrollPosition2 >= placeHolderNodeCurrentTop;
    } else {
      var _stickyNode$firstElem;
      const stickyItemHeight = stickyNode.getBoundingClientRect().height || ((_stickyNode$firstElem = stickyNode.firstElementChild) === null || _stickyNode$firstElem === void 0 ? void 0 : _stickyNode$firstElem.getBoundingClientRect().height) || 0;
      const stickyItemBottomPosition = boundingElement.getBoundingClientRect().bottom - stickyItemHeight + scrollTop - containerTop;
      sticky = scrollPosition2 >= placeHolderNodeCurrentTop && scrollPosition2 < stickyItemBottomPosition;
    }
    return {
      sticky,
      top,
      left,
      width
    };
  }
  updateStuckItems(item, sticky) {
    const {
      stickyNode
    } = item;
    if (sticky && !this.isNodeStuck(stickyNode)) {
      this.addStuckItem(item);
    } else if (!sticky && this.isNodeStuck(stickyNode)) {
      this.removeStuckItem(item);
    }
  }
  addStuckItem(stickyItem) {
    this.stuckItems.push(stickyItem);
  }
  removeStuckItem(stickyItem) {
    const {
      stickyNode: nodeToRemove
    } = stickyItem;
    const nodeIndex = this.stuckItems.findIndex(({
      stickyNode
    }) => nodeToRemove === stickyNode);
    this.stuckItems.splice(nodeIndex, 1);
  }
  getOffset(node) {
    if (this.stuckItems.length === 0) {
      return 0;
    }
    let offset = 0;
    let count = 0;
    const stuckNodesLength = this.stuckItems.length;
    const nodeRect = getRectForNode(node);
    while (count < stuckNodesLength) {
      const stuckNode = this.stuckItems[count].stickyNode;
      if (stuckNode !== node) {
        const stuckNodeRect = getRectForNode(stuckNode);
        if (!horizontallyOverlaps(nodeRect, stuckNodeRect)) {
          offset += getRectForNode(stuckNode).height;
        }
      } else {
        break;
      }
      count++;
    }
    return offset;
  }
  isNodeStuck(node) {
    const nodeFound = this.stuckItems.findIndex(({
      stickyNode
    }) => node === stickyNode);
    return nodeFound >= 0;
  }
  setTopBarOffset(container) {
    const topbarElement = container.querySelector(`:not(${scrollable.selector}) ${dataPolarisTopBar.selector}`);
    this.topBarOffset = topbarElement ? topbarElement.clientHeight : 0;
  }
};
function isDocument(node) {
  return node === document;
}
function scrollTopFor(container) {
  return isDocument(container) ? document.body.scrollTop || document.documentElement.scrollTop : container.scrollTop;
}
function horizontallyOverlaps(rect1, rect2) {
  const rect1Left = rect1.left;
  const rect1Right = rect1.left + rect1.width;
  const rect2Left = rect2.left;
  const rect2Right = rect2.left + rect2.width;
  return rect2Right < rect1Left || rect1Right < rect2Left;
}

// ../node_modules/@shopify/polaris/build/esm/utilities/scroll-lock-manager/scroll-lock-manager.js
var SCROLL_LOCKING_ATTRIBUTE = "data-lock-scrolling";
var SCROLL_LOCKING_HIDDEN_ATTRIBUTE = "data-lock-scrolling-hidden";
var SCROLL_LOCKING_WRAPPER_ATTRIBUTE = "data-lock-scrolling-wrapper";
var scrollPosition = 0;
function isScrollBarVisible() {
  const {
    body
  } = document;
  return body.scrollHeight > body.clientHeight;
}
var ScrollLockManager = class {
  constructor() {
    this.scrollLocks = 0;
    this.locked = false;
  }
  registerScrollLock() {
    this.scrollLocks += 1;
    this.handleScrollLocking();
  }
  unregisterScrollLock() {
    this.scrollLocks -= 1;
    this.handleScrollLocking();
  }
  handleScrollLocking() {
    if (isServer)
      return;
    const {
      scrollLocks
    } = this;
    const {
      body
    } = document;
    const wrapper = body.firstElementChild;
    if (scrollLocks === 0) {
      body.removeAttribute(SCROLL_LOCKING_ATTRIBUTE);
      body.removeAttribute(SCROLL_LOCKING_HIDDEN_ATTRIBUTE);
      if (wrapper) {
        wrapper.removeAttribute(SCROLL_LOCKING_WRAPPER_ATTRIBUTE);
      }
      window.scroll(0, scrollPosition);
      this.locked = false;
    } else if (scrollLocks > 0 && !this.locked) {
      scrollPosition = window.pageYOffset;
      body.setAttribute(SCROLL_LOCKING_ATTRIBUTE, "");
      if (!isScrollBarVisible()) {
        body.setAttribute(SCROLL_LOCKING_HIDDEN_ATTRIBUTE, "");
      }
      if (wrapper) {
        wrapper.setAttribute(SCROLL_LOCKING_WRAPPER_ATTRIBUTE, "");
        wrapper.scrollTop = scrollPosition;
      }
      this.locked = true;
    }
  }
  resetScrollPosition() {
    scrollPosition = 0;
  }
};

// ../node_modules/@shopify/polaris/build/esm/utilities/unique-id/unique-id-factory.js
var UniqueIdFactory = class {
  constructor(idGeneratorFactory) {
    this.idGeneratorFactory = void 0;
    this.idGenerators = {};
    this.idGeneratorFactory = idGeneratorFactory;
  }
  nextId(prefix) {
    if (!this.idGenerators[prefix]) {
      this.idGenerators[prefix] = this.idGeneratorFactory(prefix);
    }
    return this.idGenerators[prefix]();
  }
};
function globalIdGeneratorFactory(prefix = "") {
  let index = 1;
  return () => `Polaris${prefix}${index++}`;
}

// ../node_modules/@shopify/polaris/build/esm/utilities/get.js
var OBJECT_NOTATION_MATCHER = /\[(.*?)\]|(\w+)/g;
function get(obj, keypath, defaultValue) {
  if (obj == null)
    return void 0;
  const keys = Array.isArray(keypath) ? keypath : getKeypath(keypath);
  let acc = obj;
  for (let i = 0; i < keys.length; i++) {
    const val = acc[keys[i]];
    if (val === void 0)
      return defaultValue;
    acc = val;
  }
  return acc;
}
function getKeypath(str) {
  const path = [];
  let result;
  while (result = OBJECT_NOTATION_MATCHER.exec(str)) {
    const [, first, second] = result;
    path.push(first || second);
  }
  return path;
}

// ../node_modules/@shopify/polaris/build/esm/utilities/merge.js
function merge(...objs) {
  let final = {};
  for (const obj of objs) {
    final = mergeRecursively(final, obj);
  }
  return final;
}
function mergeRecursively(inputObjA, objB) {
  const objA = Array.isArray(inputObjA) ? [...inputObjA] : {
    ...inputObjA
  };
  for (const key in objB) {
    if (!Object.prototype.hasOwnProperty.call(objB, key)) {
      continue;
    } else if (isMergeableValue(objB[key]) && isMergeableValue(objA[key])) {
      objA[key] = mergeRecursively(objA[key], objB[key]);
    } else {
      objA[key] = objB[key];
    }
  }
  return objA;
}
function isMergeableValue(value) {
  return value !== null && typeof value === "object";
}

// ../node_modules/@shopify/polaris/build/esm/utilities/i18n/I18n.js
var REPLACE_REGEX = /{([^}]*)}/g;
var I18n = class {
  /**
   * @param translation A locale object or array of locale objects that overrides default translations. If specifying an array then your desired language dictionary should come first, followed by your fallback language dictionaries
   */
  constructor(translation) {
    this.translation = {};
    this.translation = Array.isArray(translation) ? merge(...translation.slice().reverse()) : translation;
  }
  translate(id, replacements) {
    const text = get(this.translation, id, "");
    if (!text) {
      return "";
    }
    if (replacements) {
      return text.replace(REPLACE_REGEX, (match) => {
        const replacement = match.substring(1, match.length - 1);
        if (replacements[replacement] === void 0) {
          const replacementData = JSON.stringify(replacements);
          throw new Error(`Error in translation for key '${id}'. No replacement found for key '${replacement}'. The following replacements were passed: '${replacementData}'`);
        }
        return replacements[replacement];
      });
    }
    return text;
  }
  translationKeyExists(path) {
    return Boolean(get(this.translation, path));
  }
};

// ../node_modules/@shopify/polaris/build/esm/utilities/features/context.js
var import_react6 = __toESM(require_react());
var FeaturesContext = (0, import_react6.createContext)(void 0);

// ../node_modules/@shopify/polaris/build/esm/utilities/i18n/context.js
var import_react7 = __toESM(require_react());
var I18nContext = (0, import_react7.createContext)(void 0);

// ../node_modules/@shopify/polaris/build/esm/utilities/scroll-lock-manager/context.js
var import_react8 = __toESM(require_react());
var ScrollLockManagerContext = (0, import_react8.createContext)(void 0);

// ../node_modules/@shopify/polaris/build/esm/utilities/sticky-manager/context.js
var import_react9 = __toESM(require_react());
var StickyManagerContext = (0, import_react9.createContext)(void 0);

// ../node_modules/@shopify/polaris/build/esm/utilities/unique-id/context.js
var import_react10 = __toESM(require_react());
var UniqueIdFactoryContext = (0, import_react10.createContext)(void 0);

// ../node_modules/@shopify/polaris/build/esm/utilities/link/context.js
var import_react11 = __toESM(require_react());
var LinkContext = (0, import_react11.createContext)(void 0);

// ../node_modules/@shopify/polaris/build/esm/components/MediaQueryProvider/MediaQueryProvider.js
var import_react14 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/media-query/context.js
var import_react12 = __toESM(require_react());
var MediaQueryContext = (0, import_react12.createContext)(void 0);

// ../node_modules/@shopify/polaris/build/esm/components/EventListener/EventListener.js
var import_react13 = __toESM(require_react());
var EventListener = class extends import_react13.PureComponent {
  componentDidMount() {
    this.attachListener();
  }
  componentDidUpdate({
    passive,
    ...detachProps
  }) {
    this.detachListener(detachProps);
    this.attachListener();
  }
  componentWillUnmount() {
    this.detachListener();
  }
  render() {
    return null;
  }
  attachListener() {
    const {
      event,
      handler,
      capture,
      passive
    } = this.props;
    window.addEventListener(event, handler, {
      capture,
      passive
    });
  }
  detachListener(prevProps) {
    const {
      event,
      handler,
      capture
    } = prevProps || this.props;
    window.removeEventListener(event, handler, capture);
  }
};

// ../node_modules/@shopify/polaris/build/esm/components/MediaQueryProvider/MediaQueryProvider.js
var MediaQueryProvider = function MediaQueryProvider2({
  children: children2
}) {
  const [isNavigationCollapsed, setIsNavigationCollapsed] = (0, import_react14.useState)(navigationBarCollapsed().matches);
  const handleResize = (0, import_react14.useCallback)(debounce(() => {
    if (isNavigationCollapsed !== navigationBarCollapsed().matches) {
      setIsNavigationCollapsed(!isNavigationCollapsed);
    }
  }, 40, {
    trailing: true,
    leading: true,
    maxWait: 40
  }), [isNavigationCollapsed]);
  (0, import_react14.useEffect)(() => {
    setIsNavigationCollapsed(navigationBarCollapsed().matches);
  }, []);
  const context = (0, import_react14.useMemo)(() => ({
    isNavigationCollapsed
  }), [isNavigationCollapsed]);
  return import_react14.default.createElement(MediaQueryContext.Provider, {
    value: context
  }, import_react14.default.createElement(EventListener, {
    event: "resize",
    handler: handleResize
  }), children2);
};

// ../node_modules/@shopify/polaris/build/esm/components/PortalsManager/PortalsManager.js
var import_react18 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/use-is-after-initial-mount.js
var import_react15 = __toESM(require_react());
function useIsAfterInitialMount() {
  const [isAfterInitialMount, setIsAfterInitialMount] = (0, import_react15.useState)(false);
  (0, import_react15.useEffect)(() => {
    setIsAfterInitialMount(true);
  }, []);
  return isAfterInitialMount;
}

// ../node_modules/@shopify/polaris/build/esm/utilities/portals/context.js
var import_react16 = __toESM(require_react());
var PortalsManagerContext = (0, import_react16.createContext)(void 0);

// ../node_modules/@shopify/polaris/build/esm/components/PortalsManager/components/PortalsContainer/PortalsContainer.js
var import_react17 = __toESM(require_react());
function PortalsContainerComponent(_props, ref) {
  return import_react17.default.createElement("div", {
    id: "PolarisPortalsContainer",
    ref
  });
}
var PortalsContainer = (0, import_react17.forwardRef)(PortalsContainerComponent);

// ../node_modules/@shopify/polaris/build/esm/components/PortalsManager/PortalsManager.js
function PortalsManager({
  children: children2,
  container
}) {
  const isMounted = useIsAfterInitialMount();
  const ref = (0, import_react18.useRef)(null);
  const contextValue = (0, import_react18.useMemo)(() => {
    if (container) {
      return {
        container
      };
    } else if (isMounted) {
      return {
        container: ref.current
      };
    } else {
      return {
        container: null
      };
    }
  }, [container, isMounted]);
  return import_react18.default.createElement(PortalsManagerContext.Provider, {
    value: contextValue
  }, children2, container ? null : import_react18.default.createElement(PortalsContainer, {
    ref
  }));
}

// ../node_modules/@shopify/polaris/build/esm/components/FocusManager/FocusManager.js
var import_react20 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/focus-manager/context.js
var import_react19 = __toESM(require_react());
var FocusManagerContext = (0, import_react19.createContext)(void 0);

// ../node_modules/@shopify/polaris/build/esm/components/FocusManager/FocusManager.js
function FocusManager({
  children: children2
}) {
  const [trapFocusList, setTrapFocusList] = (0, import_react20.useState)([]);
  const add = (0, import_react20.useCallback)((id) => {
    setTrapFocusList((list) => [...list, id]);
  }, []);
  const remove = (0, import_react20.useCallback)((id) => {
    let removed = true;
    setTrapFocusList((list) => {
      const clone = [...list];
      const index = clone.indexOf(id);
      if (index === -1) {
        removed = false;
      } else {
        clone.splice(index, 1);
      }
      return clone;
    });
    return removed;
  }, []);
  const value = (0, import_react20.useMemo)(() => ({
    trapFocusList,
    add,
    remove
  }), [add, trapFocusList, remove]);
  return import_react20.default.createElement(FocusManagerContext.Provider, {
    value
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/EphemeralPresenceManager/EphemeralPresenceManager.js
var import_react22 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/ephemeral-presence-manager/context.js
var import_react21 = __toESM(require_react());
var EphemeralPresenceManagerContext = (0, import_react21.createContext)(void 0);

// ../node_modules/@shopify/polaris/build/esm/components/EphemeralPresenceManager/EphemeralPresenceManager.js
var defaultState = {
  tooltip: 0
};
function EphemeralPresenceManager({
  children: children2
}) {
  const [presenceCounter, setPresenceCounter] = (0, import_react22.useState)(defaultState);
  const addPresence = (0, import_react22.useCallback)((key) => {
    setPresenceCounter((prevList) => ({
      ...prevList,
      [key]: prevList[key] + 1
    }));
  }, []);
  const removePresence = (0, import_react22.useCallback)((key) => {
    setPresenceCounter((prevList) => ({
      ...prevList,
      [key]: prevList[key] - 1
    }));
  }, []);
  const value = (0, import_react22.useMemo)(() => ({
    presenceList: Object.entries(presenceCounter).reduce((previousValue, currentValue) => {
      const [key, value2] = currentValue;
      return {
        ...previousValue,
        [key]: value2 >= 1
      };
    }, {}),
    presenceCounter,
    addPresence,
    removePresence
  }), [addPresence, removePresence, presenceCounter]);
  return import_react22.default.createElement(EphemeralPresenceManagerContext.Provider, {
    value
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/AppProvider/AppProvider.js
var AppProvider = class extends import_react23.Component {
  constructor(props) {
    super(props);
    this.stickyManager = void 0;
    this.scrollLockManager = void 0;
    this.uniqueIdFactory = void 0;
    this.setBodyStyles = () => {
      document.body.style.backgroundColor = "var(--p-color-bg-app)";
      document.body.style.color = "var(--p-color-text)";
    };
    this.stickyManager = new StickyManager();
    this.scrollLockManager = new ScrollLockManager();
    this.uniqueIdFactory = new UniqueIdFactory(globalIdGeneratorFactory);
    const {
      i18n,
      linkComponent
    } = this.props;
    this.state = {
      link: linkComponent,
      intl: new I18n(i18n)
    };
  }
  componentDidMount() {
    if (document != null) {
      this.stickyManager.setContainer(document);
      this.setBodyStyles();
    }
  }
  componentDidUpdate({
    i18n: prevI18n,
    linkComponent: prevLinkComponent
  }) {
    const {
      i18n,
      linkComponent
    } = this.props;
    if (i18n === prevI18n && linkComponent === prevLinkComponent) {
      return;
    }
    this.setState({
      link: linkComponent,
      intl: new I18n(i18n)
    });
  }
  render() {
    const {
      children: children2,
      features = {}
    } = this.props;
    const {
      intl,
      link
    } = this.state;
    return import_react23.default.createElement(FeaturesContext.Provider, {
      value: features
    }, import_react23.default.createElement(I18nContext.Provider, {
      value: intl
    }, import_react23.default.createElement(ScrollLockManagerContext.Provider, {
      value: this.scrollLockManager
    }, import_react23.default.createElement(StickyManagerContext.Provider, {
      value: this.stickyManager
    }, import_react23.default.createElement(UniqueIdFactoryContext.Provider, {
      value: this.uniqueIdFactory
    }, import_react23.default.createElement(LinkContext.Provider, {
      value: link
    }, import_react23.default.createElement(MediaQueryProvider, null, import_react23.default.createElement(PortalsManager, null, import_react23.default.createElement(FocusManager, null, import_react23.default.createElement(EphemeralPresenceManager, null, children2))))))))));
  }
};

// ../node_modules/@shopify/polaris/build/esm/components/AccountConnection/AccountConnection.js
var import_react559 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Button/utils.js
var import_react553 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Button/Button.js
var import_react552 = __toESM(require_react());

// ../node_modules/@shopify/polaris-icons/dist/icons/AbandonedCartMajor.svg.mjs
var import_react24 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AccessibilityMajor.svg.mjs
var import_react25 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ActivitiesMajor.svg.mjs
var import_react26 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AddCodeMajor.svg.mjs
var import_react27 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AddImageMajor.svg.mjs
var import_react28 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AddMajor.svg.mjs
var import_react29 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AddNoteMajor.svg.mjs
var import_react30 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AddProductMajor.svg.mjs
var import_react31 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AdjustMinor.svg.mjs
var import_react32 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AffiliateMajor.svg.mjs
var import_react33 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AlertMinor.svg.mjs
var import_react34 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AnalyticsBarHorizontalMinor.svg.mjs
var import_react35 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AnalyticsBarStackedMinor.svg.mjs
var import_react36 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AnalyticsCohortMinor.svg.mjs
var import_react37 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AnalyticsDonutMinor.svg.mjs
var import_react38 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AnalyticsFunnelMinor.svg.mjs
var import_react39 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AnalyticsLineMinor.svg.mjs
var import_react40 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AnalyticsMajor.svg.mjs
var import_react41 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AnalyticsMinor.svg.mjs
var import_react42 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AnalyticsTableMinor.svg.mjs
var import_react43 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AnyClickModelMinor.svg.mjs
var import_react44 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AppExtensionMinor.svg.mjs
var import_react45 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AppsMajor.svg.mjs
var import_react46 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AppsMinor.svg.mjs
var import_react47 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ArchiveMajor.svg.mjs
var import_react48 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ArchiveMinor.svg.mjs
var import_react49 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ArrowDownMinor.svg.mjs
var import_react50 = __toESM(require_react(), 1);
var SvgArrowDownMinor = function SvgArrowDownMinor2(props) {
  return import_react50.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react50.default.createElement("path", {
    d: "m10.707 17.707 5-5a.999.999 0 1 0-1.414-1.414l-3.293 3.293v-11.586a1 1 0 1 0-2 0v11.586l-3.293-3.293a.999.999 0 1 0-1.414 1.414l5 5a.999.999 0 0 0 1.414 0z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/ArrowLeftMinor.svg.mjs
var import_react51 = __toESM(require_react(), 1);
var SvgArrowLeftMinor = function SvgArrowLeftMinor2(props) {
  return import_react51.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react51.default.createElement("path", {
    d: "M17 9h-11.586l3.293-3.293a.999.999 0 1 0-1.414-1.414l-5 5a.999.999 0 0 0 0 1.414l5 5a.997.997 0 0 0 1.414 0 .999.999 0 0 0 0-1.414l-3.293-3.293h11.586a1 1 0 1 0 0-2z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/ArrowRightMinor.svg.mjs
var import_react52 = __toESM(require_react(), 1);
var SvgArrowRightMinor = function SvgArrowRightMinor2(props) {
  return import_react52.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react52.default.createElement("path", {
    d: "m17.707 9.293-5-5a.999.999 0 1 0-1.414 1.414l3.293 3.293h-11.586a1 1 0 1 0 0 2h11.586l-3.293 3.293a.999.999 0 1 0 1.414 1.414l5-5a.999.999 0 0 0 0-1.414z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/ArrowUpMinor.svg.mjs
var import_react53 = __toESM(require_react(), 1);
var SvgArrowUpMinor = function SvgArrowUpMinor2(props) {
  return import_react53.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react53.default.createElement("path", {
    d: "M11 17v-11.586l3.293 3.293a.999.999 0 1 0 1.414-1.414l-5-5a.999.999 0 0 0-1.414 0l-5 5a.997.997 0 0 0 0 1.414.999.999 0 0 0 1.414 0l3.293-3.293v11.586a1 1 0 1 0 2 0z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/AttachmentMajor.svg.mjs
var import_react54 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/AutomationMajor.svg.mjs
var import_react55 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BackspaceMajor.svg.mjs
var import_react56 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BalanceMajor.svg.mjs
var import_react57 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BankMajor.svg.mjs
var import_react58 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BarcodeMajor.svg.mjs
var import_react59 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BehaviorMajor.svg.mjs
var import_react60 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BehaviorMinor.svg.mjs
var import_react61 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BillingStatementDollarMajor.svg.mjs
var import_react62 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BillingStatementEuroMajor.svg.mjs
var import_react63 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BillingStatementPoundMajor.svg.mjs
var import_react64 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BillingStatementRupeeMajor.svg.mjs
var import_react65 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BillingStatementYenMajor.svg.mjs
var import_react66 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BlockMinor.svg.mjs
var import_react67 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BlockquoteMajor.svg.mjs
var import_react68 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BlogMajor.svg.mjs
var import_react69 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BugMajor.svg.mjs
var import_react70 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ButtonCornerPillMajor.svg.mjs
var import_react71 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ButtonCornerRoundedMajor.svg.mjs
var import_react72 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ButtonCornerSquareMajor.svg.mjs
var import_react73 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ButtonMinor.svg.mjs
var import_react74 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BuyButtonButtonLayoutMajor.svg.mjs
var import_react75 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BuyButtonHorizontalLayoutMajor.svg.mjs
var import_react76 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BuyButtonMajor.svg.mjs
var import_react77 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/BuyButtonVerticalLayoutMajor.svg.mjs
var import_react78 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CalendarMajor.svg.mjs
var import_react79 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CalendarMinor.svg.mjs
var import_react80 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CalendarTickMajor.svg.mjs
var import_react81 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CalendarTimeMinor.svg.mjs
var import_react82 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CameraMajor.svg.mjs
var import_react83 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CancelMajor.svg.mjs
var import_react84 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CancelMinor.svg.mjs
var import_react85 = __toESM(require_react(), 1);
var SvgCancelMinor = function SvgCancelMinor2(props) {
  return import_react85.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react85.default.createElement("path", {
    d: "M6.707 5.293a1 1 0 0 0-1.414 1.414l3.293 3.293-3.293 3.293a1 1 0 1 0 1.414 1.414l3.293-3.293 3.293 3.293a1 1 0 0 0 1.414-1.414l-3.293-3.293 3.293-3.293a1 1 0 0 0-1.414-1.414l-3.293 3.293-3.293-3.293Z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/CancelSmallMinor.svg.mjs
var import_react86 = __toESM(require_react(), 1);
var SvgCancelSmallMinor = function SvgCancelSmallMinor2(props) {
  return import_react86.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react86.default.createElement("path", {
    d: "M6.707 5.293a1 1 0 0 0-1.414 1.414l3.293 3.293-3.293 3.293a1 1 0 1 0 1.414 1.414l3.293-3.293 3.293 3.293a1 1 0 0 0 1.414-1.414l-3.293-3.293 3.293-3.293a1 1 0 0 0-1.414-1.414l-3.293 3.293-3.293-3.293Z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/CapitalMajor.svg.mjs
var import_react87 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CapturePaymentMinor.svg.mjs
var import_react88 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CardReaderChipMajor.svg.mjs
var import_react89 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CardReaderMajor.svg.mjs
var import_react90 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CardReaderTapMajor.svg.mjs
var import_react91 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CaretDownMinor.svg.mjs
var import_react92 = __toESM(require_react(), 1);
var SvgCaretDownMinor = function SvgCaretDownMinor2(props) {
  return import_react92.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react92.default.createElement("path", {
    d: "M13.098 8h-6.196c-.751 0-1.172.754-.708 1.268l3.098 3.432c.36.399 1.055.399 1.416 0l3.098-3.433c.464-.513.043-1.267-.708-1.267Z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/CaretUpMinor.svg.mjs
var import_react93 = __toESM(require_react(), 1);
var SvgCaretUpMinor = function SvgCaretUpMinor2(props) {
  return import_react93.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react93.default.createElement("path", {
    d: "M6.902 12h6.196c.751 0 1.172-.754.708-1.268l-3.098-3.432c-.36-.399-1.055-.399-1.416 0l-3.098 3.433c-.464.513-.043 1.267.708 1.267Z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/CartDownMajor.svg.mjs
var import_react94 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CartMajor.svg.mjs
var import_react95 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CartUpMajor.svg.mjs
var import_react96 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CashDollarMajor.svg.mjs
var import_react97 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CashDollarMinor.svg.mjs
var import_react98 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CashEuroMajor.svg.mjs
var import_react99 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CashPoundMajor.svg.mjs
var import_react100 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CashRupeeMajor.svg.mjs
var import_react101 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CashYenMajor.svg.mjs
var import_react102 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CategoriesMajor.svg.mjs
var import_react103 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ChannelsMajor.svg.mjs
var import_react104 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ChatMajor.svg.mjs
var import_react105 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ChecklistAlternateMajor.svg.mjs
var import_react106 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ChecklistMajor.svg.mjs
var import_react107 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CheckoutMajor.svg.mjs
var import_react108 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ChevronDownMinor.svg.mjs
var import_react109 = __toESM(require_react(), 1);
var SvgChevronDownMinor = function SvgChevronDownMinor2(props) {
  return import_react109.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react109.default.createElement("path", {
    d: "M10 14a.997.997 0 0 1-.707-.293l-5-5a.999.999 0 1 1 1.414-1.414l4.293 4.293 4.293-4.293a.999.999 0 1 1 1.414 1.414l-5 5a.997.997 0 0 1-.707.293z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/ChevronLeftMinor.svg.mjs
var import_react110 = __toESM(require_react(), 1);
var SvgChevronLeftMinor = function SvgChevronLeftMinor2(props) {
  return import_react110.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react110.default.createElement("path", {
    d: "M12 16a.997.997 0 0 1-.707-.293l-5-5a.999.999 0 0 1 0-1.414l5-5a.999.999 0 1 1 1.414 1.414l-4.293 4.293 4.293 4.293a.999.999 0 0 1-.707 1.707z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/ChevronRightMinor.svg.mjs
var import_react111 = __toESM(require_react(), 1);
var SvgChevronRightMinor = function SvgChevronRightMinor2(props) {
  return import_react111.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react111.default.createElement("path", {
    d: "M8 16a.999.999 0 0 1-.707-1.707l4.293-4.293-4.293-4.293a.999.999 0 1 1 1.414-1.414l5 5a.999.999 0 0 1 0 1.414l-5 5a.997.997 0 0 1-.707.293z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/ChevronUpMinor.svg.mjs
var import_react112 = __toESM(require_react(), 1);
var SvgChevronUpMinor = function SvgChevronUpMinor2(props) {
  return import_react112.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react112.default.createElement("path", {
    d: "M15 13a.997.997 0 0 1-.707-.293l-4.293-4.293-4.293 4.293a.999.999 0 1 1-1.414-1.414l5-5a.999.999 0 0 1 1.414 0l5 5a.999.999 0 0 1-.707 1.707z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleAlertMajor.svg.mjs
var import_react113 = __toESM(require_react(), 1);
var SvgCircleAlertMajor = function SvgCircleAlertMajor2(props) {
  return import_react113.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react113.default.createElement("path", {
    fillRule: "evenodd",
    d: "M10 0c-5.514 0-10 4.486-10 10s4.486 10 10 10 10-4.486 10-10-4.486-10-10-10zm-1 6a1 1 0 1 1 2 0v4a1 1 0 1 1-2 0v-4zm1 9a1 1 0 1 0 0-2 1 1 0 0 0 0 2z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleCancelMajor.svg.mjs
var import_react114 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleCancelMinor.svg.mjs
var import_react115 = __toESM(require_react(), 1);
var SvgCircleCancelMinor = function SvgCircleCancelMinor2(props) {
  return import_react115.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react115.default.createElement("path", {
    fillRule: "evenodd",
    d: "M10 2a8 8 0 1 0 0 16 8 8 0 0 0 0-16zm-2.293 4.293a1 1 0 0 0-1.414 1.414l2.293 2.293-2.293 2.293a1 1 0 1 0 1.414 1.414l2.293-2.293 2.293 2.293a1 1 0 1 0 1.414-1.414l-2.293-2.293 2.293-2.293a1 1 0 0 0-1.414-1.414l-2.293 2.293-2.293-2.293z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleChevronDownMinor.svg.mjs
var import_react116 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleChevronLeftMinor.svg.mjs
var import_react117 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleChevronRightMinor.svg.mjs
var import_react118 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleChevronUpMinor.svg.mjs
var import_react119 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleDisableMinor.svg.mjs
var import_react120 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleDisabledMajor.svg.mjs
var import_react121 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleDotsMajor.svg.mjs
var import_react122 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleDownMajor.svg.mjs
var import_react123 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleInformationMajor.svg.mjs
var import_react124 = __toESM(require_react(), 1);
var SvgCircleInformationMajor = function SvgCircleInformationMajor2(props) {
  return import_react124.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react124.default.createElement("path", {
    fillRule: "evenodd",
    d: "M10 20c5.514 0 10-4.486 10-10s-4.486-10-10-10-10 4.486-10 10 4.486 10 10 10zm1-6a1 1 0 1 1-2 0v-4a1 1 0 1 1 2 0v4zm-1-9a1 1 0 1 0 0 2 1 1 0 0 0 0-2z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleLeftMajor.svg.mjs
var import_react125 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleMinusMajor.svg.mjs
var import_react126 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleMinusMinor.svg.mjs
var import_react127 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleMinusOutlineMinor.svg.mjs
var import_react128 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CirclePlusMajor.svg.mjs
var import_react129 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CirclePlusMinor.svg.mjs
var import_react130 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CirclePlusOutlineMinor.svg.mjs
var import_react131 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleRightMajor.svg.mjs
var import_react132 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleTickMajor.svg.mjs
var import_react133 = __toESM(require_react(), 1);
var SvgCircleTickMajor = function SvgCircleTickMajor2(props) {
  return import_react133.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react133.default.createElement("path", {
    fillRule: "evenodd",
    d: "M0 10a10 10 0 1 0 20 0 10 10 0 0 0-20 0zm15.2-1.8a1 1 0 0 0-1.4-1.4l-4.8 4.8-2.3-2.3a1 1 0 0 0-1.4 1.4l3 3c.4.4 1 .4 1.4 0l5.5-5.5z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleTickMinor.svg.mjs
var import_react134 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleTickOutlineMinor.svg.mjs
var import_react135 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CircleUpMajor.svg.mjs
var import_react136 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ClipboardMinor.svg.mjs
var import_react137 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ClockMajor.svg.mjs
var import_react138 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ClockMinor.svg.mjs
var import_react139 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CodeMajor.svg.mjs
var import_react140 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CodeMinor.svg.mjs
var import_react141 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CollectionReferenceMinor.svg.mjs
var import_react142 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CollectionsMajor.svg.mjs
var import_react143 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ColorNoneMinor.svg.mjs
var import_react144 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ColorsMajor.svg.mjs
var import_react145 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/Column1Major.svg.mjs
var import_react146 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ColumnWithTextMajor.svg.mjs
var import_react147 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/Columns2Major.svg.mjs
var import_react148 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/Columns3Major.svg.mjs
var import_react149 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/Columns3Minor.svg.mjs
var import_react150 = __toESM(require_react(), 1);
var SvgColumns3Minor = function SvgColumns3Minor2(props) {
  return import_react150.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react150.default.createElement("path", {
    fillRule: "evenodd",
    d: "M16 2a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2h-12a2 2 0 0 1-2-2v-12a2 2 0 0 1 2-2h12Zm-2.667 2h2.667v12h-2.667v-12Zm-4.666 0h2.666v12h-2.666v-12Zm-2 0h-2.667v12h2.667v-12Z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/ComposeMajor.svg.mjs
var import_react151 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ConfettiMajor.svg.mjs
var import_react152 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ConnectMinor.svg.mjs
var import_react153 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ContentMinor.svg.mjs
var import_react154 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ConversationMinor.svg.mjs
var import_react155 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CreditCardCancelMajor.svg.mjs
var import_react156 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CreditCardMajor.svg.mjs
var import_react157 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CreditCardPercentMajor.svg.mjs
var import_react158 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CreditCardSecureMajor.svg.mjs
var import_react159 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CurrencyConvertMinor.svg.mjs
var import_react160 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CustomerMinusMajor.svg.mjs
var import_react161 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CustomerPlusMajor.svg.mjs
var import_react162 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CustomersMajor.svg.mjs
var import_react163 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/CustomersMinor.svg.mjs
var import_react164 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DataDrivenModelMinor.svg.mjs
var import_react165 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DataVisualizationMajor.svg.mjs
var import_react166 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DecimalMinor.svg.mjs
var import_react167 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DeleteMajor.svg.mjs
var import_react168 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DeleteMinor.svg.mjs
var import_react169 = __toESM(require_react(), 1);
var SvgDeleteMinor = function SvgDeleteMinor2(props) {
  return import_react169.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react169.default.createElement("path", {
    d: "M8 3.994c0-1.101.895-1.994 2-1.994s2 .893 2 1.994h4c.552 0 1 .446 1 .997a1 1 0 0 1-1 .997h-12c-.552 0-1-.447-1-.997s.448-.997 1-.997h4zm-3 10.514v-6.508h2v6.508a.5.5 0 0 0 .5.498h1.5v-7.006h2v7.006h1.5a.5.5 0 0 0 .5-.498v-6.508h2v6.508a2.496 2.496 0 0 1-2.5 2.492h-5c-1.38 0-2.5-1.116-2.5-2.492z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/DesktopMajor.svg.mjs
var import_react170 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DetailedPopUpMajor.svg.mjs
var import_react171 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DiamondAlertMajor.svg.mjs
var import_react172 = __toESM(require_react(), 1);
var SvgDiamondAlertMajor = function SvgDiamondAlertMajor2(props) {
  return import_react172.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react172.default.createElement("path", {
    d: "M11.768.768a2.5 2.5 0 0 0-3.536 0l-7.464 7.464a2.5 2.5 0 0 0 0 3.536l7.464 7.464a2.5 2.5 0 0 0 3.536 0l7.464-7.464a2.5 2.5 0 0 0 0-3.536l-7.464-7.464zm-2.768 5.232a1 1 0 1 1 2 0v4a1 1 0 1 1-2 0v-4zm2 8a1 1 0 1 1-2 0 1 1 0 0 1 2 0z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/DiamondAlertMinor.svg.mjs
var import_react173 = __toESM(require_react(), 1);
var SvgDiamondAlertMinor = function SvgDiamondAlertMinor2(props) {
  return import_react173.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react173.default.createElement("path", {
    fillRule: "evenodd",
    d: "M11.42 2.588a2.007 2.007 0 0 0-2.84 0l-5.992 5.993a2.007 2.007 0 0 0 0 2.838l5.993 5.993a2.007 2.007 0 0 0 2.838 0l5.993-5.993a2.007 2.007 0 0 0 0-2.838l-5.993-5.993Zm-2.223 4.2a.803.803 0 1 1 1.606 0v3.212a.803.803 0 1 1-1.606 0v-3.211Zm1.606 6.423a.803.803 0 1 1-1.606 0 .803.803 0 0 1 1.606 0Z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/DigitalMediaReceiverMajor.svg.mjs
var import_react174 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DiscountAutomaticMajor.svg.mjs
var import_react175 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DiscountCodeMajor.svg.mjs
var import_react176 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DiscountsMajor.svg.mjs
var import_react177 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DiscountsMinor.svg.mjs
var import_react178 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DisputeMinor.svg.mjs
var import_react179 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DnsSettingsMajor.svg.mjs
var import_react180 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DockFloatingMajor.svg.mjs
var import_react181 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DockSideMajor.svg.mjs
var import_react182 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DomainNewMajor.svg.mjs
var import_react183 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DomainRedirectMinor.svg.mjs
var import_react184 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DomainsMajor.svg.mjs
var import_react185 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DraftOrdersMajor.svg.mjs
var import_react186 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DragDropMajor.svg.mjs
var import_react187 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DragHandleMinor.svg.mjs
var import_react188 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DropdownMinor.svg.mjs
var import_react189 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DuplicateMinor.svg.mjs
var import_react190 = __toESM(require_react(), 1);
var SvgDuplicateMinor = function SvgDuplicateMinor2(props) {
  return import_react190.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react190.default.createElement("path", {
    d: "M7.5 2a1.5 1.5 0 0 0-1.5 1.5v9.5a1 1 0 0 0 1 1h9.5a1.5 1.5 0 0 0 1.5-1.5v-9a1.5 1.5 0 0 0-1.5-1.5h-9zm-4 4h.5v10h10v.5a1.5 1.5 0 0 1-1.5 1.5h-9a1.5 1.5 0 0 1-1.5-1.5v-9a1.5 1.5 0 0 1 1.5-1.5z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/DynamicSourceMajor.svg.mjs
var import_react191 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/DynamicSourceMinor.svg.mjs
var import_react192 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/EditMajor.svg.mjs
var import_react193 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/EditMinor.svg.mjs
var import_react194 = __toESM(require_react(), 1);
var SvgEditMinor = function SvgEditMinor2(props) {
  return import_react194.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react194.default.createElement("path", {
    d: "m13.877 3.123 3.001 3.002.5-.5a2.123 2.123 0 1 0-3.002-3.002l-.5.5zm1.623 4.377-3.002-3.002-9.524 9.525-.974 3.976 3.976-.974 9.524-9.525z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/EmailMajor.svg.mjs
var import_react195 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/EmailNewsletterMajor.svg.mjs
var import_react196 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/EmbedMinor.svg.mjs
var import_react197 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/EnableSelectionMinor.svg.mjs
var import_react198 = __toESM(require_react(), 1);
var SvgEnableSelectionMinor = function SvgEnableSelectionMinor2(props) {
  return import_react198.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react198.default.createElement("path", {
    fillRule: "evenodd",
    d: "M4.5 3a1.5 1.5 0 0 0-1.5 1.5v11a1.5 1.5 0 0 0 1.5 1.5h11a1.5 1.5 0 0 0 1.5-1.5v-11a1.5 1.5 0 0 0-1.5-1.5h-11zm9.207 5.707a1 1 0 0 0-1.414-1.414l-3.293 3.293-1.293-1.293a1 1 0 0 0-1.414 1.414l2 2a1 1 0 0 0 1.414 0l4-4z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/EnterMajor.svg.mjs
var import_react199 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/EnvelopeMajor.svg.mjs
var import_react200 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ExchangeMajor.svg.mjs
var import_react201 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ExistingInventoryMajor.svg.mjs
var import_react202 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ExitMajor.svg.mjs
var import_react203 = __toESM(require_react(), 1);
var SvgExitMajor = function SvgExitMajor2(props) {
  return import_react203.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react203.default.createElement("path", {
    d: "M7.703 13.707a.997.997 0 0 0 0-1.414l-1.294-1.293h6.589a1 1 0 1 0 0-2h-6.589l1.294-1.293a1 1 0 1 0-1.415-1.414l-3.001 3a.994.994 0 0 0-.198.298c-.013.027-.021.054-.03.082a.944.944 0 0 0-.054.269l-.001.027a.937.937 0 0 0 .062.398l.003.012v.004c.048.112.117.208.197.294l.01.015.01.015 3.002 3a1 1 0 0 0 1.415 0z"
  }), import_react203.default.createElement("path", {
    d: "M2 16.5a1.5 1.5 0 0 0 1.5 1.5h13a1.5 1.5 0 0 0 1.5-1.5v-13a1.5 1.5 0 0 0-1.5-1.5h-13a1.5 1.5 0 0 0-1.5 1.5v1.5a1 1 0 1 0 2 0v-1h12v12h-12v-1a1 1 0 1 0-2 0v1.5z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/ExploreImagesMajor.svg.mjs
var import_react204 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ExportMinor.svg.mjs
var import_react205 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ExtendMajor.svg.mjs
var import_react206 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ExtendMinor.svg.mjs
var import_react207 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ExternalMinor.svg.mjs
var import_react208 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ExternalSmallMinor.svg.mjs
var import_react209 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/EyeDropperMinor.svg.mjs
var import_react210 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FaviconMajor.svg.mjs
var import_react211 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FavoriteMajor.svg.mjs
var import_react212 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FeaturedCollectionMajor.svg.mjs
var import_react213 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FeaturedContentMajor.svg.mjs
var import_react214 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FileMinor.svg.mjs
var import_react215 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FilterMajor.svg.mjs
var import_react216 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FilterMinor.svg.mjs
var import_react217 = __toESM(require_react(), 1);
var SvgFilterMinor = function SvgFilterMinor2(props) {
  return import_react217.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react217.default.createElement("path", {
    d: "M2 6a1 1 0 0 1 1-1h14a1 1 0 1 1 0 2h-14a1 1 0 0 1-1-1zm3 4a1 1 0 0 1 1-1h8a1 1 0 1 1 0 2h-8a1 1 0 0 1-1-1zm3 3a1 1 0 1 0 0 2h4a1 1 0 1 0 0-2h-4z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/FinancesMajor.svg.mjs
var import_react218 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FinancesMinor.svg.mjs
var import_react219 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FirstClickModelMinor.svg.mjs
var import_react220 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FirstOrderMajor.svg.mjs
var import_react221 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FirstVisitMajor.svg.mjs
var import_react222 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FlagMajor.svg.mjs
var import_react223 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FlipCameraMajor.svg.mjs
var import_react224 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FolderDownMajor.svg.mjs
var import_react225 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FolderMajor.svg.mjs
var import_react226 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FolderMinusMajor.svg.mjs
var import_react227 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FolderPlusMajor.svg.mjs
var import_react228 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FolderUpMajor.svg.mjs
var import_react229 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FollowUpEmailMajor.svg.mjs
var import_react230 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FoodMajor.svg.mjs
var import_react231 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FooterMajor.svg.mjs
var import_react232 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FormsMajor.svg.mjs
var import_react233 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FraudProtectMajor.svg.mjs
var import_react234 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FraudProtectMinor.svg.mjs
var import_react235 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FraudProtectPendingMajor.svg.mjs
var import_react236 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FraudProtectPendingMinor.svg.mjs
var import_react237 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FraudProtectUnprotectedMajor.svg.mjs
var import_react238 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FraudProtectUnprotectedMinor.svg.mjs
var import_react239 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FulfillmentFulfilledMajor.svg.mjs
var import_react240 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/FulfillmentOnHoldMajor.svg.mjs
var import_react241 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/GamesConsoleMajor.svg.mjs
var import_react242 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/GiftCardMajor.svg.mjs
var import_react243 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/GiftCardMinor.svg.mjs
var import_react244 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/GlobeMajor.svg.mjs
var import_react245 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/GlobeMinor.svg.mjs
var import_react246 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/GrammarMajor.svg.mjs
var import_react247 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/HashtagMajor.svg.mjs
var import_react248 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/HashtagMinor.svg.mjs
var import_react249 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/HeaderMajor.svg.mjs
var import_react250 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/HeartMajor.svg.mjs
var import_react251 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/HideKeyboardMajor.svg.mjs
var import_react252 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/HideMinor.svg.mjs
var import_react253 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/HintMajor.svg.mjs
var import_react254 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/HomeMajor.svg.mjs
var import_react255 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/HomeMinor.svg.mjs
var import_react256 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/HorizontalDotsMinor.svg.mjs
var import_react257 = __toESM(require_react(), 1);
var SvgHorizontalDotsMinor = function SvgHorizontalDotsMinor2(props) {
  return import_react257.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react257.default.createElement("path", {
    d: "M6 10a2 2 0 1 1-4.001-.001 2 2 0 0 1 4.001.001zm6 0a2 2 0 1 1-4.001-.001 2 2 0 0 1 4.001.001zm6 0a2 2 0 1 1-4.001-.001 2 2 0 0 1 4.001.001z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/IconsMajor.svg.mjs
var import_react258 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/IdentityCardMajor.svg.mjs
var import_react259 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/IllustrationMajor.svg.mjs
var import_react260 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ImageAltMajor.svg.mjs
var import_react261 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ImageAltMinor.svg.mjs
var import_react262 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ImageMajor.svg.mjs
var import_react263 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ImageWithTextMajor.svg.mjs
var import_react264 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ImageWithTextOverlayMajor.svg.mjs
var import_react265 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ImagesMajor.svg.mjs
var import_react266 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ImportMinor.svg.mjs
var import_react267 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ImportStoreMajor.svg.mjs
var import_react268 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/InactiveLocationMajor.svg.mjs
var import_react269 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/InactiveLocationMinor.svg.mjs
var import_react270 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/IncomingMajor.svg.mjs
var import_react271 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/InfoMinor.svg.mjs
var import_react272 = __toESM(require_react(), 1);
var SvgInfoMinor = function SvgInfoMinor2(props) {
  return import_react272.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react272.default.createElement("path", {
    fillRule: "evenodd",
    d: "M18 10a8 8 0 1 0-16 0 8 8 0 0 0 16 0zm-9 3a1 1 0 1 0 2 0v-2a1 1 0 1 0-2 0v2zm0-6a1 1 0 1 0 2 0 1 1 0 0 0-2 0z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/InsertDynamicSourceMajor.svg.mjs
var import_react273 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/InsertDynamicSourceMinor.svg.mjs
var import_react274 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/InstallMinor.svg.mjs
var import_react275 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/InventoryMajor.svg.mjs
var import_react276 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/InviteMinor.svg.mjs
var import_react277 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/IqMajor.svg.mjs
var import_react278 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/JobsMajor.svg.mjs
var import_react279 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/KeyMajor.svg.mjs
var import_react280 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/KeyboardMajor.svg.mjs
var import_react281 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/KeyboardMinor.svg.mjs
var import_react282 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/LabelPrinterMajor.svg.mjs
var import_react283 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/LandingPageMajor.svg.mjs
var import_react284 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/LanguageMinor.svg.mjs
var import_react285 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/LastClickModelMinor.svg.mjs
var import_react286 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/LastNonDirectClickModelMinor.svg.mjs
var import_react287 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/LegalMajor.svg.mjs
var import_react288 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/LinearModelMinor.svg.mjs
var import_react289 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/LinkMinor.svg.mjs
var import_react290 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ListMajor.svg.mjs
var import_react291 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ListMinor.svg.mjs
var import_react292 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/LiveViewMajor.svg.mjs
var import_react293 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/LocationMajor.svg.mjs
var import_react294 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/LocationsMinor.svg.mjs
var import_react295 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/LockMajor.svg.mjs
var import_react296 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/LockMinor.svg.mjs
var import_react297 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/LogOutMinor.svg.mjs
var import_react298 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/LogoBlockMajor.svg.mjs
var import_react299 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MagicMajor.svg.mjs
var import_react300 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MagicMinor.svg.mjs
var import_react301 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ManagedStoreMajor.svg.mjs
var import_react302 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MarkFulfilledMinor.svg.mjs
var import_react303 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MarkPaidMinor.svg.mjs
var import_react304 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MarketingMajor.svg.mjs
var import_react305 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MarketingMinor.svg.mjs
var import_react306 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MarketsMajor.svg.mjs
var import_react307 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MaximizeMajor.svg.mjs
var import_react308 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MaximizeMinor.svg.mjs
var import_react309 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MeasurementMinor.svg.mjs
var import_react310 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MentionMajor.svg.mjs
var import_react311 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MergeMinor.svg.mjs
var import_react312 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MetafieldsMajor.svg.mjs
var import_react313 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MetafieldsMinor.svg.mjs
var import_react314 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MetaobjectMinor.svg.mjs
var import_react315 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MetaobjectReferenceMinor.svg.mjs
var import_react316 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MicrophoneMajor.svg.mjs
var import_react317 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MinimizeMajor.svg.mjs
var import_react318 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MinimizeMinor.svg.mjs
var import_react319 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MinusMajor.svg.mjs
var import_react320 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MinusMinor.svg.mjs
var import_react321 = __toESM(require_react(), 1);
var SvgMinusMinor = function SvgMinusMinor2(props) {
  return import_react321.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react321.default.createElement("path", {
    d: "M14.167 9h-8.334c-.46 0-.833.448-.833 1s.372 1 .833 1h8.334c.46 0 .833-.448.833-1s-.373-1-.833-1"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/MobileAcceptMajor.svg.mjs
var import_react322 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MobileBackArrowMajor.svg.mjs
var import_react323 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MobileCancelMajor.svg.mjs
var import_react324 = __toESM(require_react(), 1);
var SvgMobileCancelMajor = function SvgMobileCancelMajor2(props) {
  return import_react324.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react324.default.createElement("path", {
    d: "m11.414 10 6.293-6.293a1 1 0 1 0-1.414-1.414l-6.293 6.293-6.293-6.293a1 1 0 0 0-1.414 1.414l6.293 6.293-6.293 6.293a1 1 0 1 0 1.414 1.414l6.293-6.293 6.293 6.293a.998.998 0 0 0 1.707-.707.999.999 0 0 0-.293-.707l-6.293-6.293z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/MobileChevronMajor.svg.mjs
var import_react325 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MobileHamburgerMajor.svg.mjs
var import_react326 = __toESM(require_react(), 1);
var SvgMobileHamburgerMajor = function SvgMobileHamburgerMajor2(props) {
  return import_react326.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react326.default.createElement("path", {
    d: "M19 11h-18a1 1 0 0 1 0-2h18a1 1 0 1 1 0 2zm0-7h-18a1 1 0 0 1 0-2h18a1 1 0 1 1 0 2zm0 14h-18a1 1 0 0 1 0-2h18a1 1 0 0 1 0 2z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/MobileHorizontalDotsMajor.svg.mjs
var import_react327 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MobileMajor.svg.mjs
var import_react328 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MobilePlusMajor.svg.mjs
var import_react329 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MobileVerticalDotsMajor.svg.mjs
var import_react330 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MonerisMajor.svg.mjs
var import_react331 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/MoneyMinor.svg.mjs
var import_react332 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/NatureMajor.svg.mjs
var import_react333 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/NavigationMajor.svg.mjs
var import_react334 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/NoteMajor.svg.mjs
var import_react335 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/NoteMinor.svg.mjs
var import_react336 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/NotificationMajor.svg.mjs
var import_react337 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/OnlineStoreMajor.svg.mjs
var import_react338 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/OnlineStoreMinor.svg.mjs
var import_react339 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/OrderStatusMinor.svg.mjs
var import_react340 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/OrdersMajor.svg.mjs
var import_react341 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/OrdersMinor.svg.mjs
var import_react342 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/OrganizationMajor.svg.mjs
var import_react343 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/OutgoingMajor.svg.mjs
var import_react344 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PackageMajor.svg.mjs
var import_react345 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PageDownMajor.svg.mjs
var import_react346 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PageMajor.svg.mjs
var import_react347 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PageMinusMajor.svg.mjs
var import_react348 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PagePlusMajor.svg.mjs
var import_react349 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PageReferenceMinor.svg.mjs
var import_react350 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PageUpMajor.svg.mjs
var import_react351 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PaginationEndMinor.svg.mjs
var import_react352 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PaginationStartMinor.svg.mjs
var import_react353 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PaintBrushMajor.svg.mjs
var import_react354 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PaperCheckMajor.svg.mjs
var import_react355 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PaperCheckMinor.svg.mjs
var import_react356 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PasskeyMajor.svg.mjs
var import_react357 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PasskeyMinor.svg.mjs
var import_react358 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PauseCircleMajor.svg.mjs
var import_react359 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PauseMajor.svg.mjs
var import_react360 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PauseMinor.svg.mjs
var import_react361 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PaymentsMajor.svg.mjs
var import_react362 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PersonalizedTextMajor.svg.mjs
var import_react363 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PhoneInMajor.svg.mjs
var import_react364 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PhoneMajor.svg.mjs
var import_react365 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PhoneOutMajor.svg.mjs
var import_react366 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PinMajor.svg.mjs
var import_react367 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PinMinor.svg.mjs
var import_react368 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PinUnfilledMajor.svg.mjs
var import_react369 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PinUnfilledMinor.svg.mjs
var import_react370 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PlanMajor.svg.mjs
var import_react371 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PlanMinor.svg.mjs
var import_react372 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PlayCircleMajor.svg.mjs
var import_react373 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PlayMajor.svg.mjs
var import_react374 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PlayMinor.svg.mjs
var import_react375 = __toESM(require_react(), 1);
var SvgPlayMinor = function SvgPlayMinor2(props) {
  return import_react375.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react375.default.createElement("path", {
    d: "M16 10a.997.997 0 0 1-.485.857l-10 6a1.004 1.004 0 0 1-1.008.013 1.001 1.001 0 0 1-.507-.87v-12a1.001 1.001 0 0 1 1.515-.857l10 6c.301.18.485.505.485.857z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/PlusMinor.svg.mjs
var import_react376 = __toESM(require_react(), 1);
var SvgPlusMinor = function SvgPlusMinor2(props) {
  return import_react376.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react376.default.createElement("path", {
    d: "M10 4a1 1 0 0 0-1 1v4h-4a1 1 0 1 0 0 2h4v4a1 1 0 1 0 2 0v-4h4a1 1 0 1 0 0-2h-4v-4a1 1 0 0 0-1-1Z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/PointOfSaleMajor.svg.mjs
var import_react377 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PopularMajor.svg.mjs
var import_react378 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PositionBasedModelMinor.svg.mjs
var import_react379 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PriceLookupMinor.svg.mjs
var import_react380 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PrintMajor.svg.mjs
var import_react381 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PrintMinor.svg.mjs
var import_react382 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ProductCostMajor.svg.mjs
var import_react383 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ProductReferenceMinor.svg.mjs
var import_react384 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ProductReturnsMinor.svg.mjs
var import_react385 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ProductsMajor.svg.mjs
var import_react386 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ProductsMinor.svg.mjs
var import_react387 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ProfileMajor.svg.mjs
var import_react388 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ProfileMinor.svg.mjs
var import_react389 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/PromoteMinor.svg.mjs
var import_react390 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/QuestionMarkInverseMajor.svg.mjs
var import_react391 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/QuestionMarkInverseMinor.svg.mjs
var import_react392 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/QuestionMarkMajor.svg.mjs
var import_react393 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/QuestionMarkMinor.svg.mjs
var import_react394 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/QuickSaleMajor.svg.mjs
var import_react395 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ReadTimeMinor.svg.mjs
var import_react396 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ReceiptMajor.svg.mjs
var import_react397 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/RecentSearchesMajor.svg.mjs
var import_react398 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/RedoMajor.svg.mjs
var import_react399 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ReferralCodeMajor.svg.mjs
var import_react400 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ReferralMajor.svg.mjs
var import_react401 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/RefreshMajor.svg.mjs
var import_react402 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/RefreshMinor.svg.mjs
var import_react403 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/RefundMajor.svg.mjs
var import_react404 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/RefundMinor.svg.mjs
var import_react405 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/RemoveProductMajor.svg.mjs
var import_react406 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/RepeatOrderMajor.svg.mjs
var import_react407 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ReplaceMajor.svg.mjs
var import_react408 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ReplayMinor.svg.mjs
var import_react409 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ReportMinor.svg.mjs
var import_react410 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ReportsMajor.svg.mjs
var import_react411 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ResetMinor.svg.mjs
var import_react412 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ResourcesMajor.svg.mjs
var import_react413 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ReturnMinor.svg.mjs
var import_react414 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ReturnsMajor.svg.mjs
var import_react415 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/RichTextMinor.svg.mjs
var import_react416 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/RiskMajor.svg.mjs
var import_react417 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/RiskMinor.svg.mjs
var import_react418 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/Rows2Major.svg.mjs
var import_react419 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SandboxMajor.svg.mjs
var import_react420 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SaveMinor.svg.mjs
var import_react421 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SearchMajor.svg.mjs
var import_react422 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SearchMinor.svg.mjs
var import_react423 = __toESM(require_react(), 1);
var SvgSearchMinor = function SvgSearchMinor2(props) {
  return import_react423.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react423.default.createElement("path", {
    d: "M8 12a4 4 0 1 1 0-8 4 4 0 0 1 0 8zm9.707 4.293-4.82-4.82a5.968 5.968 0 0 0 1.113-3.473 6 6 0 0 0-12 0 6 6 0 0 0 6 6 5.968 5.968 0 0 0 3.473-1.113l4.82 4.82a.997.997 0 0 0 1.414 0 .999.999 0 0 0 0-1.414z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/SectionMajor.svg.mjs
var import_react424 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SecureMajor.svg.mjs
var import_react425 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SelectMinor.svg.mjs
var import_react426 = __toESM(require_react(), 1);
var SvgSelectMinor = function SvgSelectMinor2(props) {
  return import_react426.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react426.default.createElement("path", {
    d: "M7.676 9h4.648c.563 0 .879-.603.53-1.014l-2.323-2.746a.708.708 0 0 0-1.062 0l-2.324 2.746c-.347.411-.032 1.014.531 1.014Zm4.648 2h-4.648c-.563 0-.878.603-.53 1.014l2.323 2.746c.27.32.792.32 1.062 0l2.323-2.746c.349-.411.033-1.014-.53-1.014Z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/SendMajor.svg.mjs
var import_react427 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SettingsMajor.svg.mjs
var import_react428 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SettingsMinor.svg.mjs
var import_react429 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ShareIosMinor.svg.mjs
var import_react430 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ShareMinor.svg.mjs
var import_react431 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ShipmentMajor.svg.mjs
var import_react432 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ShopcodesMajor.svg.mjs
var import_react433 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SidebarLeftMajor.svg.mjs
var import_react434 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SidebarRightMajor.svg.mjs
var import_react435 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SimplifyMajor.svg.mjs
var import_react436 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SimplifyMinor.svg.mjs
var import_react437 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SlideshowMajor.svg.mjs
var import_react438 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SmileyHappyMajor.svg.mjs
var import_react439 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SmileyJoyMajor.svg.mjs
var import_react440 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SmileyNeutralMajor.svg.mjs
var import_react441 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SmileySadMajor.svg.mjs
var import_react442 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SocialAdMajor.svg.mjs
var import_react443 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SocialPostMajor.svg.mjs
var import_react444 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SoftPackMajor.svg.mjs
var import_react445 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/SortAscendingMajor.svg.mjs
var import_react446 = __toESM(require_react(), 1);
var SvgSortAscendingMajor = function SvgSortAscendingMajor2(props) {
  return import_react446.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react446.default.createElement("path", {
    d: "M12.324 9h-4.648c-.563 0-.878-.603-.53-1.014l2.323-2.746a.708.708 0 0 1 1.062 0l2.323 2.746c.349.411.033 1.014-.53 1.014Z"
  }), import_react446.default.createElement("path", {
    d: "M7.676 11h4.648c.563 0 .879.603.53 1.014l-2.323 2.746a.708.708 0 0 1-1.062 0l-2.324-2.746c-.347-.411-.032-1.014.531-1.014Z",
    fillOpacity: 0.5
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/SortDescendingMajor.svg.mjs
var import_react447 = __toESM(require_react(), 1);
var SvgSortDescendingMajor = function SvgSortDescendingMajor2(props) {
  return import_react447.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react447.default.createElement("path", {
    d: "M12.324 9h-4.648c-.563 0-.878-.603-.53-1.014l2.323-2.746a.708.708 0 0 1 1.062 0l2.323 2.746c.349.411.033 1.014-.53 1.014Z",
    fillOpacity: 0.5
  }), import_react447.default.createElement("path", {
    d: "M7.676 11h4.648c.563 0 .879.603.53 1.014l-2.323 2.746a.708.708 0 0 1-1.062 0l-2.324-2.746c-.347-.411-.032-1.014.531-1.014Z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/SortMinor.svg.mjs
var import_react448 = __toESM(require_react(), 1);
var SvgSortMinor = function SvgSortMinor2(props) {
  return import_react448.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react448.default.createElement("path", {
    d: "M5.293 2.293a.997.997 0 0 1 1.414 0l3 3a1 1 0 0 1-1.414 1.414l-1.293-1.293v7.586a1 1 0 1 1-2 0v-7.586l-1.293 1.293a1 1 0 0 1-1.414-1.414l3-3zm7.707 4.707a1 1 0 0 1 2 0v7.585l1.293-1.292a.999.999 0 1 1 1.414 1.414l-3 3a.997.997 0 0 1-1.414 0l-3-3a.997.997 0 0 1 0-1.414.999.999 0 0 1 1.414 0l1.293 1.292v-7.585z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/SoundMajor.svg.mjs
var import_react449 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/StarFilledMinor.svg.mjs
var import_react450 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/StarOutlineMinor.svg.mjs
var import_react451 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/StatusActiveMajor.svg.mjs
var import_react452 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/StoreMajor.svg.mjs
var import_react453 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/StoreMinor.svg.mjs
var import_react454 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/StoreStatusMajor.svg.mjs
var import_react455 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TabletMajor.svg.mjs
var import_react456 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TapChipMajor.svg.mjs
var import_react457 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TaxMajor.svg.mjs
var import_react458 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TeamMajor.svg.mjs
var import_react459 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TemplateMajor.svg.mjs
var import_react460 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TemplateMinor.svg.mjs
var import_react461 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TextAlignmentCenterMajor.svg.mjs
var import_react462 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TextAlignmentLeftMajor.svg.mjs
var import_react463 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TextAlignmentRightMajor.svg.mjs
var import_react464 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TextBlockMajor.svg.mjs
var import_react465 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TextMajor.svg.mjs
var import_react466 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ThemeEditMajor.svg.mjs
var import_react467 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ThemeStoreMajor.svg.mjs
var import_react468 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ThemesMajor.svg.mjs
var import_react469 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ThumbsDownMajor.svg.mjs
var import_react470 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ThumbsDownMinor.svg.mjs
var import_react471 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ThumbsUpMajor.svg.mjs
var import_react472 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ThumbsUpMinor.svg.mjs
var import_react473 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TickMinor.svg.mjs
var import_react474 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TickSmallMinor.svg.mjs
var import_react475 = __toESM(require_react(), 1);
var SvgTickSmallMinor = function SvgTickSmallMinor2(props) {
  return import_react475.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react475.default.createElement("path", {
    d: "M14.723 6.237a.94.94 0 0 1 .053 1.277l-5.366 6.193a.834.834 0 0 1-.611.293.83.83 0 0 1-.622-.264l-2.927-3.097a.94.94 0 0 1 0-1.278.82.82 0 0 1 1.207 0l2.297 2.43 4.763-5.498a.821.821 0 0 1 1.206-.056Z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/TimeDecayModelMinor.svg.mjs
var import_react476 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TimelineAttachmentMajor.svg.mjs
var import_react477 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TipsMajor.svg.mjs
var import_react478 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TitleMinor.svg.mjs
var import_react479 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ToggleMinor.svg.mjs
var import_react480 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ToolsMajor.svg.mjs
var import_react481 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TransactionFeeDollarMajor.svg.mjs
var import_react482 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TransactionFeeEuroMajor.svg.mjs
var import_react483 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TransactionFeePoundMajor.svg.mjs
var import_react484 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TransactionFeeRupeeMajor.svg.mjs
var import_react485 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TransactionFeeYenMajor.svg.mjs
var import_react486 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TransactionMajor.svg.mjs
var import_react487 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TransferInMajor.svg.mjs
var import_react488 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TransferMajor.svg.mjs
var import_react489 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TransferOutMajor.svg.mjs
var import_react490 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TransferWithinShopifyMajor.svg.mjs
var import_react491 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TransportMajor.svg.mjs
var import_react492 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TroubleshootMajor.svg.mjs
var import_react493 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TypeMajor.svg.mjs
var import_react494 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/TypeMinor.svg.mjs
var import_react495 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/UndoMajor.svg.mjs
var import_react496 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/UnfulfilledMajor.svg.mjs
var import_react497 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/UnknownDeviceMajor.svg.mjs
var import_react498 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/UpdateInventoryMajor.svg.mjs
var import_react499 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/UploadMajor.svg.mjs
var import_react500 = __toESM(require_react(), 1);
var SvgUploadMajor = function SvgUploadMajor2(props) {
  return import_react500.default.createElement("svg", Object.assign({
    viewBox: "0 0 20 20"
  }, props), import_react500.default.createElement("path", {
    fillRule: "evenodd",
    d: "M20 10c0 5.523-4.477 10-10 10s-10-4.477-10-10 4.477-10 10-10 10 4.477 10 10zm-14.707-1.707 4-4a1 1 0 0 1 1.414 0l4 4a1 1 0 0 1-1.414 1.414l-2.293-2.293v7.586a1 1 0 1 1-2 0v-7.586l-2.293 2.293a1 1 0 0 1-1.414-1.414z"
  }));
};

// ../node_modules/@shopify/polaris-icons/dist/icons/VariantMajor.svg.mjs
var import_react501 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ViewMajor.svg.mjs
var import_react502 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ViewMinor.svg.mjs
var import_react503 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ViewportNarrowMajor.svg.mjs
var import_react504 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ViewportShortMajor.svg.mjs
var import_react505 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ViewportTallMajor.svg.mjs
var import_react506 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/ViewportWideMajor.svg.mjs
var import_react507 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/VocabularyMajor.svg.mjs
var import_react508 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/VolumeMinor.svg.mjs
var import_react509 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/WandMajor.svg.mjs
var import_react510 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/WandMinor.svg.mjs
var import_react511 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/WearableMajor.svg.mjs
var import_react512 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/WeightMinor.svg.mjs
var import_react513 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/WholesaleMajor.svg.mjs
var import_react514 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/icons/WifiMajor.svg.mjs
var import_react515 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris-icons/dist/index.mjs
var import_react516 = __toESM(require_react(), 1);

// ../node_modules/@shopify/polaris/build/esm/utilities/css.js
function classNames(...classes) {
  return classes.filter(Boolean).join(" ");
}
function variationName(name, value) {
  return `${name}${value.charAt(0).toUpperCase()}${value.slice(1)}`;
}
function sanitizeCustomProperties(styles142) {
  const nonNullValues = Object.entries(styles142).filter(([_, value]) => value != null);
  return nonNullValues.length ? Object.fromEntries(nonNullValues) : void 0;
}
function getResponsiveProps(componentName, componentProp, tokenSubgroup, responsiveProp) {
  if (!responsiveProp)
    return {};
  if (typeof responsiveProp === "string") {
    return {
      [`--pc-${componentName}-${componentProp}-xs`]: `var(--p-${tokenSubgroup}-${responsiveProp})`
    };
  }
  return Object.fromEntries(Object.entries(responsiveProp).map(([breakpointAlias, aliasOrScale]) => [`--pc-${componentName}-${componentProp}-${breakpointAlias}`, `var(--p-${tokenSubgroup}-${aliasOrScale})`]));
}
function getResponsiveValue(componentName, componentProp, responsiveProp) {
  if (!responsiveProp)
    return {};
  if (typeof responsiveProp === "string") {
    return {
      [`--pc-${componentName}-${componentProp}-xs`]: responsiveProp
    };
  }
  return Object.fromEntries(Object.entries(responsiveProp).map(([breakpointAlias, responsiveValue]) => [`--pc-${componentName}-${componentProp}-${breakpointAlias}`, responsiveValue]));
}

// ../node_modules/@shopify/polaris/build/esm/utilities/is-element-in-viewport.js
function isElementInViewport(element) {
  const {
    top,
    left,
    bottom,
    right
  } = element.getBoundingClientRect();
  return top >= 0 && right <= window.innerWidth && bottom <= window.innerHeight && left >= 0;
}

// ../node_modules/@shopify/polaris/build/esm/utilities/focus.js
var FOCUSABLE_SELECTOR = 'a,frame,iframe,input:not([type=hidden]):not(:disabled),select:not(:disabled),textarea:not(:disabled),button:not([aria-disabled="true"]):not([tabindex="-1"]):not(:disabled),*[tabindex]';
var KEYBOARD_FOCUSABLE_SELECTORS = 'a,frame,iframe,input:not([type=hidden]):not(:disabled),select:not(:disabled),textarea:not(:disabled),button:not([aria-disabled="true"]):not([tabindex="-1"]):not(:disabled),*[tabindex]:not([tabindex="-1"])';
var MENUITEM_FOCUSABLE_SELECTORS = 'a[role="menuitem"],frame[role="menuitem"],iframe[role="menuitem"],input[role="menuitem"]:not([type=hidden]):not(:disabled),select[role="menuitem"]:not(:disabled),textarea[role="menuitem"]:not(:disabled),button[role="menuitem"]:not(:disabled),*[tabindex]:not([tabindex="-1"])';
var handleMouseUpByBlurring = ({
  currentTarget
}) => currentTarget.blur();
function nextFocusableNode(node, filter) {
  const allFocusableElements = [...document.querySelectorAll(FOCUSABLE_SELECTOR)];
  const sliceLocation = allFocusableElements.indexOf(node) + 1;
  const focusableElementsAfterNode = allFocusableElements.slice(sliceLocation);
  for (const focusableElement of focusableElementsAfterNode) {
    if (isElementInViewport(focusableElement) && (!filter || filter && filter(focusableElement))) {
      return focusableElement;
    }
  }
  return null;
}
function findFirstFocusableNode(element, onlyDescendants = true) {
  if (!onlyDescendants && matches(element, FOCUSABLE_SELECTOR)) {
    return element;
  }
  return element.querySelector(FOCUSABLE_SELECTOR);
}
function findFirstFocusableNodeIncludingDisabled(element) {
  const focusableSelector = `a,button,frame,iframe,input:not([type=hidden]),select,textarea,*[tabindex]`;
  if (matches(element, focusableSelector)) {
    return element;
  }
  return element.querySelector(focusableSelector);
}
function focusFirstFocusableNode(element, onlyDescendants = true) {
  var _findFirstFocusableNo;
  (_findFirstFocusableNo = findFirstFocusableNode(element, onlyDescendants)) === null || _findFirstFocusableNo === void 0 ? void 0 : _findFirstFocusableNo.focus();
}
function focusNextFocusableNode(node, filter) {
  const nextFocusable = nextFocusableNode(node, filter);
  if (nextFocusable && nextFocusable instanceof HTMLElement) {
    nextFocusable.focus();
    return true;
  }
  return false;
}
function findFirstKeyboardFocusableNode(element, onlyDescendants = true) {
  if (!onlyDescendants && matches(element, KEYBOARD_FOCUSABLE_SELECTORS)) {
    return element;
  }
  return element.querySelector(KEYBOARD_FOCUSABLE_SELECTORS);
}
function focusFirstKeyboardFocusableNode(element, onlyDescendants = true) {
  const firstFocusable = findFirstKeyboardFocusableNode(element, onlyDescendants);
  if (firstFocusable) {
    firstFocusable.focus();
    return true;
  }
  return false;
}
function findLastKeyboardFocusableNode(element, onlyDescendants = true) {
  if (!onlyDescendants && matches(element, KEYBOARD_FOCUSABLE_SELECTORS)) {
    return element;
  }
  const allFocusable = element.querySelectorAll(KEYBOARD_FOCUSABLE_SELECTORS);
  return allFocusable[allFocusable.length - 1];
}
function focusLastKeyboardFocusableNode(element, onlyDescendants = true) {
  const lastFocusable = findLastKeyboardFocusableNode(element, onlyDescendants);
  if (lastFocusable) {
    lastFocusable.focus();
    return true;
  }
  return false;
}
function wrapFocusPreviousFocusableMenuItem(parentElement, currentFocusedElement) {
  const allFocusableChildren = getMenuFocusableDescendants(parentElement);
  const currentItemIdx = getCurrentFocusedElementIndex(allFocusableChildren, currentFocusedElement);
  if (currentItemIdx === -1) {
    allFocusableChildren[0].focus();
  } else {
    allFocusableChildren[(currentItemIdx - 1 + allFocusableChildren.length) % allFocusableChildren.length].focus();
  }
}
function wrapFocusNextFocusableMenuItem(parentElement, currentFocusedElement) {
  const allFocusableChildren = getMenuFocusableDescendants(parentElement);
  const currentItemIdx = getCurrentFocusedElementIndex(allFocusableChildren, currentFocusedElement);
  if (currentItemIdx === -1) {
    allFocusableChildren[0].focus();
  } else {
    allFocusableChildren[(currentItemIdx + 1) % allFocusableChildren.length].focus();
  }
}
function getMenuFocusableDescendants(element) {
  return element.querySelectorAll(MENUITEM_FOCUSABLE_SELECTORS);
}
function getCurrentFocusedElementIndex(allFocusableChildren, currentFocusedElement) {
  let currentItemIdx = 0;
  for (const focusableChild of allFocusableChildren) {
    if (focusableChild === currentFocusedElement) {
      break;
    }
    currentItemIdx++;
  }
  return currentItemIdx === allFocusableChildren.length ? -1 : currentItemIdx;
}
function matches(node, selector) {
  if (node.matches) {
    return node.matches(selector);
  }
  const matches2 = (node.ownerDocument || document).querySelectorAll(selector);
  let i = matches2.length;
  while (--i >= 0 && matches2.item(i) !== node)
    return i > -1;
}

// ../node_modules/@shopify/polaris/build/esm/utilities/use-disable-interaction.js
var import_react517 = __toESM(require_react());
function useDisableClick(disabled, handleClick) {
  const handleClickWrapper = (0, import_react517.useCallback)((event) => {
    if (disabled) {
      event.preventDefault();
      event.stopPropagation();
    }
  }, [disabled]);
  if (!disabled) {
    return handleClick;
  }
  return handleClickWrapper;
}

// ../node_modules/@shopify/polaris/build/esm/components/Button/Button.scss.js
var styles = {
  "Button": "Polaris-Button",
  "pressed": "Polaris-Button--pressed",
  "disabled": "Polaris-Button--disabled",
  "connectedDisclosure": "Polaris-Button--connectedDisclosure",
  "Content": "Polaris-Button__Content",
  "plain": "Polaris-Button--plain",
  "textAlignLeft": "Polaris-Button--textAlignLeft",
  "textAlignStart": "Polaris-Button--textAlignStart",
  "textAlignCenter": "Polaris-Button--textAlignCenter",
  "textAlignRight": "Polaris-Button--textAlignRight",
  "textAlignEnd": "Polaris-Button--textAlignEnd",
  "Icon": "Polaris-Button__Icon",
  "fullWidth": "Polaris-Button--fullWidth",
  "hidden": "Polaris-Button--hidden",
  "Spinner": "Polaris-Button__Spinner",
  "primary": "Polaris-Button--primary",
  "destructive": "Polaris-Button--destructive",
  "primaryPlain": "Polaris-Button--primaryPlain",
  "outline": "Polaris-Button--outline",
  "loading": "Polaris-Button--loading",
  "removeUnderline": "Polaris-Button--removeUnderline",
  "iconOnly": "Polaris-Button--iconOnly",
  "sizeSlim": "Polaris-Button--sizeSlim",
  "sizeLarge": "Polaris-Button--sizeLarge",
  "sizeMicro": "Polaris-Button--sizeMicro",
  "monochrome": "Polaris-Button--monochrome",
  "Text": "Polaris-Button__Text",
  "ConnectedDisclosureWrapper": "Polaris-Button__ConnectedDisclosureWrapper",
  "ConnectedDisclosure": "Polaris-Button__ConnectedDisclosure"
};

// ../node_modules/@shopify/polaris/build/esm/components/Spinner/Spinner.js
var import_react519 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Spinner/Spinner.scss.js
var styles2 = {
  "Spinner": "Polaris-Spinner",
  "sizeSmall": "Polaris-Spinner--sizeSmall",
  "sizeLarge": "Polaris-Spinner--sizeLarge"
};

// ../node_modules/@shopify/polaris/build/esm/components/Text/Text.js
var import_react518 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Text/Text.scss.js
var styles3 = {
  "root": "Polaris-Text--root",
  "block": "Polaris-Text--block",
  "truncate": "Polaris-Text--truncate",
  "visuallyHidden": "Polaris-Text--visuallyHidden",
  "start": "Polaris-Text--start",
  "center": "Polaris-Text--center",
  "end": "Polaris-Text--end",
  "justify": "Polaris-Text--justify",
  "success": "Polaris-Text--success",
  "critical": "Polaris-Text--critical",
  "warning": "Polaris-Text--warning",
  "subdued": "Polaris-Text--subdued",
  "text-inverse": "Polaris-Text__text--inverse",
  "headingXs": "Polaris-Text--headingXs",
  "headingSm": "Polaris-Text--headingSm",
  "headingMd": "Polaris-Text--headingMd",
  "headingLg": "Polaris-Text--headingLg",
  "headingXl": "Polaris-Text--headingXl",
  "heading2xl": "Polaris-Text--heading2xl",
  "heading3xl": "Polaris-Text--heading3xl",
  "heading4xl": "Polaris-Text--heading4xl",
  "bodySm": "Polaris-Text--bodySm",
  "bodyMd": "Polaris-Text--bodyMd",
  "bodyLg": "Polaris-Text--bodyLg",
  "regular": "Polaris-Text--regular",
  "medium": "Polaris-Text--medium",
  "semibold": "Polaris-Text--semibold",
  "bold": "Polaris-Text--bold",
  "break": "Polaris-Text--break",
  "numeric": "Polaris-Text--numeric"
};

// ../node_modules/@shopify/polaris/build/esm/components/Text/Text.js
var Text = ({
  alignment,
  as,
  breakWord,
  children: children2,
  color: color2,
  fontWeight,
  id,
  numeric = false,
  truncate = false,
  variant,
  visuallyHidden = false
}) => {
  const Component9 = as || (visuallyHidden ? "span" : "p");
  const className = classNames(styles3.root, variant && styles3[variant], fontWeight && styles3[fontWeight], (alignment || truncate) && styles3.block, alignment && styles3[alignment], breakWord && styles3.break, color2 && styles3[color2], numeric && styles3.numeric, truncate && styles3.truncate, visuallyHidden && styles3.visuallyHidden);
  return import_react518.default.createElement(Component9, Object.assign({
    className
  }, id && {
    id
  }), children2);
};

// ../node_modules/@shopify/polaris/build/esm/components/Spinner/Spinner.js
function Spinner({
  size = "large",
  accessibilityLabel,
  hasFocusableParent
}) {
  const isAfterInitialMount = useIsAfterInitialMount();
  const className = classNames(styles2.Spinner, size && styles2[variationName("size", size)]);
  const spinnerSVGMarkup = size === "large" ? import_react519.default.createElement("svg", {
    viewBox: "0 0 44 44",
    xmlns: "http://www.w3.org/2000/svg"
  }, import_react519.default.createElement("path", {
    d: "M15.542 1.487A21.507 21.507 0 00.5 22c0 11.874 9.626 21.5 21.5 21.5 9.847 0 18.364-6.675 20.809-16.072a1.5 1.5 0 00-2.904-.756C37.803 34.755 30.473 40.5 22 40.5 11.783 40.5 3.5 32.217 3.5 22c0-8.137 5.3-15.247 12.942-17.65a1.5 1.5 0 10-.9-2.863z"
  })) : import_react519.default.createElement("svg", {
    viewBox: "0 0 20 20",
    xmlns: "http://www.w3.org/2000/svg"
  }, import_react519.default.createElement("path", {
    d: "M7.229 1.173a9.25 9.25 0 1011.655 11.412 1.25 1.25 0 10-2.4-.698 6.75 6.75 0 11-8.506-8.329 1.25 1.25 0 10-.75-2.385z"
  }));
  const spanAttributes = {
    ...!hasFocusableParent && {
      role: "status"
    }
  };
  const accessibilityLabelMarkup = (isAfterInitialMount || !hasFocusableParent) && import_react519.default.createElement(Text, {
    as: "span",
    visuallyHidden: true
  }, accessibilityLabel);
  return import_react519.default.createElement(import_react519.default.Fragment, null, import_react519.default.createElement("span", {
    className
  }, spinnerSVGMarkup), import_react519.default.createElement("span", spanAttributes, accessibilityLabelMarkup));
}

// ../node_modules/@shopify/polaris/build/esm/components/Popover/Popover.js
var import_react535 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Popover/set-activator-attributes.js
function setActivatorAttributes(activator, {
  id,
  active = false,
  ariaHaspopup,
  activatorDisabled = false
}) {
  if (!activatorDisabled) {
    activator.tabIndex = activator.tabIndex || 0;
  }
  activator.setAttribute("aria-controls", id);
  activator.setAttribute("aria-owns", id);
  activator.setAttribute("aria-expanded", String(active));
  if (ariaHaspopup != null) {
    activator.setAttribute("aria-haspopup", String(ariaHaspopup));
  }
}

// ../node_modules/@shopify/polaris/build/esm/components/Portal/Portal.js
var import_react522 = __toESM(require_react());
var import_react_dom = __toESM(require_react_dom());

// ../node_modules/@shopify/polaris/build/esm/utilities/portals/hooks.js
var import_react520 = __toESM(require_react());
function usePortalsManager() {
  const portalsManager = (0, import_react520.useContext)(PortalsManagerContext);
  if (!portalsManager) {
    throw new Error("No portals manager was provided. Your application must be wrapped in an <AppProvider> component. See https://polaris.shopify.com/components/app-provider for implementation instructions.");
  }
  return portalsManager;
}

// ../node_modules/@shopify/polaris/build/esm/utilities/unique-id/hooks.js
var import_react521 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/errors.js
var MissingAppProviderError = class extends Error {
  constructor(message = "") {
    super(`${message ? `${message} ` : message}Your application must be wrapped in an <AppProvider> component. See https://polaris.shopify.com/components/app-provider for implementation instructions.`);
    this.name = "MissingAppProviderError";
  }
};

// ../node_modules/@shopify/polaris/build/esm/utilities/unique-id/hooks.js
function useUniqueId(prefix = "", overrideId = "") {
  const idFactory = (0, import_react521.useContext)(UniqueIdFactoryContext);
  const uniqueIdRef = (0, import_react521.useRef)(null);
  if (!idFactory) {
    throw new MissingAppProviderError("No UniqueIdFactory was provided.");
  }
  if (overrideId) {
    return overrideId;
  }
  if (!uniqueIdRef.current) {
    uniqueIdRef.current = idFactory.nextId(prefix);
  }
  return uniqueIdRef.current;
}

// ../node_modules/@shopify/polaris/build/esm/components/Portal/Portal.js
function Portal({
  children: children2,
  idPrefix = "",
  onPortalCreated = noop2
}) {
  const {
    container
  } = usePortalsManager();
  const uniqueId = useUniqueId("portal");
  const portalId = idPrefix !== "" ? `${idPrefix}-${uniqueId}` : uniqueId;
  (0, import_react522.useEffect)(() => {
    onPortalCreated();
  }, [onPortalCreated]);
  return container ? (0, import_react_dom.createPortal)(import_react522.default.createElement("div", {
    "data-portal-id": portalId
  }, children2), container) : null;
}
function noop2() {
}

// ../node_modules/@shopify/polaris/build/esm/components/Popover/components/PopoverOverlay/PopoverOverlay.js
var import_react534 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/components.js
var import_react523 = __toESM(require_react());
function wrapWithComponent(element, Component9, props) {
  if (element == null) {
    return null;
  }
  return isElementOfType(element, Component9) ? element : import_react523.default.createElement(Component9, props, element);
}
var isComponent = true ? hotReloadComponentCheck : (AComponent, AnotherComponent) => AComponent === AnotherComponent;
function isElementOfType(element, Component9) {
  var _element$props;
  if (element == null || !(0, import_react523.isValidElement)(element) || typeof element.type === "string") {
    return false;
  }
  const {
    type: defaultType
  } = element;
  const overrideType = (_element$props = element.props) === null || _element$props === void 0 ? void 0 : _element$props.__type__;
  const type = overrideType || defaultType;
  const Components = Array.isArray(Component9) ? Component9 : [Component9];
  return Components.some((AComponent) => typeof type !== "string" && isComponent(AComponent, type));
}
function elementChildren(children2, predicate = () => true) {
  return import_react523.Children.toArray(children2).filter((child) => (0, import_react523.isValidElement)(child) && predicate(child));
}
function ConditionalWrapper({
  condition,
  wrapper,
  children: children2
}) {
  return condition ? wrapper(children2) : children2;
}
function ConditionalRender({
  condition,
  children: children2
}) {
  return condition ? children2 : null;
}
function hotReloadComponentCheck(AComponent, AnotherComponent) {
  const componentName = AComponent.name;
  const anotherComponentName = AnotherComponent.displayName;
  return AComponent === AnotherComponent || Boolean(componentName) && componentName === anotherComponentName;
}

// ../node_modules/@shopify/polaris/build/esm/components/Popover/Popover.scss.js
var styles4 = {
  "Popover": "Polaris-Popover",
  "PopoverOverlay": "Polaris-Popover__PopoverOverlay",
  "PopoverOverlay-entering": "Polaris-Popover__PopoverOverlay--entering",
  "PopoverOverlay-open": "Polaris-Popover__PopoverOverlay--open",
  "measuring": "Polaris-Popover--measuring",
  "PopoverOverlay-exiting": "Polaris-Popover__PopoverOverlay--exiting",
  "fullWidth": "Polaris-Popover--fullWidth",
  "Content": "Polaris-Popover__Content",
  "positionedAbove": "Polaris-Popover--positionedAbove",
  "Content-fullHeight": "Polaris-Popover__Content--fullHeight",
  "Content-fluidContent": "Polaris-Popover__Content--fluidContent",
  "Pane": "Polaris-Popover__Pane",
  "Pane-fixed": "Polaris-Popover__Pane--fixed",
  "Pane-captureOverscroll": "Polaris-Popover__Pane--captureOverscroll",
  "Section": "Polaris-Popover__Section",
  "FocusTracker": "Polaris-Popover__FocusTracker",
  "PopoverOverlay-hideOnPrint": "Polaris-Popover__PopoverOverlay--hideOnPrint"
};

// ../node_modules/@shopify/polaris/build/esm/components/KeypressListener/KeypressListener.js
var import_react524 = __toESM(require_react());
function KeypressListener({
  keyCode,
  handler,
  keyEvent = "keyup",
  options,
  useCapture
}) {
  const tracked = (0, import_react524.useRef)({
    handler,
    keyCode
  });
  useIsomorphicLayoutEffect(() => {
    tracked.current = {
      handler,
      keyCode
    };
  }, [handler, keyCode]);
  const handleKeyEvent = (0, import_react524.useCallback)((event) => {
    const {
      handler: handler2,
      keyCode: keyCode2
    } = tracked.current;
    if (event.keyCode === keyCode2) {
      handler2(event);
    }
  }, []);
  (0, import_react524.useEffect)(() => {
    document.addEventListener(keyEvent, handleKeyEvent, useCapture || options);
    return () => {
      document.removeEventListener(keyEvent, handleKeyEvent, useCapture || options);
    };
  }, [keyEvent, handleKeyEvent, useCapture, options]);
  return null;
}

// ../node_modules/@shopify/polaris/build/esm/components/PositionedOverlay/PositionedOverlay.js
var import_react530 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/PositionedOverlay/utilities/math.js
function calculateVerticalPosition(activatorRect, overlayRect, overlayMargins, scrollableContainerRect, containerRect, preferredPosition, fixed, topBarOffset = 0) {
  const activatorTop = activatorRect.top;
  const activatorBottom = activatorTop + activatorRect.height;
  const spaceAbove = activatorRect.top - topBarOffset;
  const spaceBelow = containerRect.height - activatorRect.top - activatorRect.height;
  const desiredHeight = overlayRect.height;
  const verticalMargins = overlayMargins.activator + overlayMargins.container;
  const minimumSpaceToScroll = overlayMargins.container;
  const distanceToTopScroll = activatorRect.top - Math.max(scrollableContainerRect.top, 0);
  const distanceToBottomScroll = containerRect.top + Math.min(containerRect.height, scrollableContainerRect.top + scrollableContainerRect.height) - (activatorRect.top + activatorRect.height);
  const enoughSpaceFromTopScroll = distanceToTopScroll >= minimumSpaceToScroll;
  const enoughSpaceFromBottomScroll = distanceToBottomScroll >= minimumSpaceToScroll;
  const heightIfBelow = Math.min(spaceBelow, desiredHeight);
  const heightIfAbove = Math.min(spaceAbove, desiredHeight);
  const containerRectTop = fixed ? 0 : containerRect.top;
  const positionIfAbove = {
    height: heightIfAbove - verticalMargins,
    top: activatorTop + containerRectTop - heightIfAbove,
    positioning: "above"
  };
  const positionIfBelow = {
    height: heightIfBelow - verticalMargins,
    top: activatorBottom + containerRectTop,
    positioning: "below"
  };
  if (preferredPosition === "above") {
    return (enoughSpaceFromTopScroll || distanceToTopScroll >= distanceToBottomScroll && !enoughSpaceFromBottomScroll) && (spaceAbove > desiredHeight || spaceAbove > spaceBelow) ? positionIfAbove : positionIfBelow;
  }
  if (preferredPosition === "below") {
    return (enoughSpaceFromBottomScroll || distanceToBottomScroll >= distanceToTopScroll && !enoughSpaceFromTopScroll) && (spaceBelow > desiredHeight || spaceBelow > spaceAbove) ? positionIfBelow : positionIfAbove;
  }
  if (enoughSpaceFromTopScroll && enoughSpaceFromBottomScroll) {
    return spaceAbove > spaceBelow ? positionIfAbove : positionIfBelow;
  }
  return distanceToTopScroll > minimumSpaceToScroll ? positionIfAbove : positionIfBelow;
}
function calculateHorizontalPosition(activatorRect, overlayRect, containerRect, overlayMargins, preferredAlignment) {
  const maximum = containerRect.width - overlayRect.width;
  if (preferredAlignment === "left") {
    return Math.min(maximum, Math.max(0, activatorRect.left - overlayMargins.horizontal));
  } else if (preferredAlignment === "right") {
    const activatorRight = containerRect.width - (activatorRect.left + activatorRect.width);
    return Math.min(maximum, Math.max(0, activatorRight - overlayMargins.horizontal));
  }
  return Math.min(maximum, Math.max(0, activatorRect.center.x - overlayRect.width / 2));
}
function rectIsOutsideOfRect(inner, outer) {
  const {
    center
  } = inner;
  return center.y < outer.top || center.y > outer.top + outer.height;
}
function intersectionWithViewport(rect, viewport = windowRect()) {
  const top = Math.max(rect.top, 0);
  const left = Math.max(rect.left, 0);
  const bottom = Math.min(rect.top + rect.height, viewport.height);
  const right = Math.min(rect.left + rect.width, viewport.width);
  return new Rect({
    top,
    left,
    height: bottom - top,
    width: right - left
  });
}
function windowRect() {
  return new Rect({
    top: window.scrollY,
    left: window.scrollX,
    height: window.innerHeight,
    width: document.body.clientWidth
  });
}

// ../node_modules/@shopify/polaris/build/esm/components/PositionedOverlay/PositionedOverlay.scss.js
var styles5 = {
  "PositionedOverlay": "Polaris-PositionedOverlay",
  "fixed": "Polaris-PositionedOverlay--fixed",
  "calculating": "Polaris-PositionedOverlay--calculating",
  "preventInteraction": "Polaris-PositionedOverlay--preventInteraction"
};

// ../node_modules/@shopify/polaris/build/esm/components/Scrollable/Scrollable.js
var import_react529 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/use-lazy-ref.js
var import_react525 = __toESM(require_react());
var UNIQUE_IDENTIFIER = Symbol("unique_identifier");
function useLazyRef(initialValue) {
  const lazyRef = (0, import_react525.useRef)(UNIQUE_IDENTIFIER);
  if (lazyRef.current === UNIQUE_IDENTIFIER) {
    lazyRef.current = initialValue();
  }
  return lazyRef;
}

// ../node_modules/@shopify/polaris/build/esm/utilities/use-component-did-mount.js
var import_react526 = __toESM(require_react());
function useComponentDidMount(callback) {
  const isAfterInitialMount = useIsAfterInitialMount();
  const hasInvokedLifeCycle = (0, import_react526.useRef)(false);
  if (isAfterInitialMount && !hasInvokedLifeCycle.current) {
    hasInvokedLifeCycle.current = true;
    return callback();
  }
}

// ../node_modules/@shopify/polaris/build/esm/components/Scrollable/context.js
var import_react527 = __toESM(require_react());
var ScrollableContext = (0, import_react527.createContext)(void 0);

// ../node_modules/@shopify/polaris/build/esm/components/Scrollable/Scrollable.scss.js
var styles6 = {
  "Scrollable": "Polaris-Scrollable",
  "horizontal": "Polaris-Scrollable--horizontal",
  "vertical": "Polaris-Scrollable--vertical",
  "hasTopShadow": "Polaris-Scrollable--hasTopShadow",
  "hasBottomShadow": "Polaris-Scrollable--hasBottomShadow"
};

// ../node_modules/@shopify/polaris/build/esm/components/Scrollable/components/ScrollTo/ScrollTo.js
var import_react528 = __toESM(require_react());
function ScrollTo() {
  const anchorNode = (0, import_react528.useRef)(null);
  const scrollToPosition = (0, import_react528.useContext)(ScrollableContext);
  (0, import_react528.useEffect)(() => {
    if (!scrollToPosition || !anchorNode.current) {
      return;
    }
    scrollToPosition(anchorNode.current.offsetTop);
  }, [scrollToPosition]);
  const id = useUniqueId(`ScrollTo`);
  return import_react528.default.createElement("a", {
    id,
    ref: anchorNode
  });
}

// ../node_modules/@shopify/polaris/build/esm/components/Scrollable/Scrollable.js
var MAX_SCROLL_HINT_DISTANCE = 100;
var LOW_RES_BUFFER = 2;
var ScrollableComponent = (0, import_react529.forwardRef)(({
  children: children2,
  className,
  horizontal = true,
  vertical = true,
  shadow: shadow2,
  hint,
  focusable,
  onScrolledToBottom,
  ...rest
}, forwardedRef) => {
  const [topShadow, setTopShadow] = (0, import_react529.useState)(false);
  const [bottomShadow, setBottomShadow] = (0, import_react529.useState)(false);
  const stickyManager = useLazyRef(() => new StickyManager());
  const scrollArea = (0, import_react529.useRef)(null);
  const scrollTo = (0, import_react529.useCallback)((scrollY, options = {}) => {
    var _scrollArea$current;
    const optionsBehavior = options.behavior || "smooth";
    const behavior = prefersReducedMotion() ? "auto" : optionsBehavior;
    (_scrollArea$current = scrollArea.current) === null || _scrollArea$current === void 0 ? void 0 : _scrollArea$current.scrollTo({
      top: scrollY,
      behavior
    });
  }, []);
  const defaultRef = (0, import_react529.useRef)();
  (0, import_react529.useImperativeHandle)(forwardedRef || defaultRef, () => ({
    scrollTo
  }));
  const handleScroll = (0, import_react529.useCallback)(() => {
    const currentScrollArea = scrollArea.current;
    if (!currentScrollArea) {
      return;
    }
    requestAnimationFrame(() => {
      const {
        scrollTop,
        clientHeight,
        scrollHeight
      } = currentScrollArea;
      const canScroll = Boolean(scrollHeight > clientHeight);
      const isBelowTopOfScroll = Boolean(scrollTop > 0);
      const isAtBottomOfScroll = Boolean(scrollTop + clientHeight >= scrollHeight - LOW_RES_BUFFER);
      setTopShadow(isBelowTopOfScroll);
      setBottomShadow(!isAtBottomOfScroll);
      if (canScroll && isAtBottomOfScroll && onScrolledToBottom) {
        onScrolledToBottom();
      }
    });
  }, [onScrolledToBottom]);
  useComponentDidMount(() => {
    handleScroll();
    if (hint) {
      requestAnimationFrame(() => performScrollHint(scrollArea.current));
    }
  });
  (0, import_react529.useEffect)(() => {
    var _stickyManager$curren;
    const currentScrollArea = scrollArea.current;
    if (!currentScrollArea) {
      return;
    }
    const handleResize = debounce(handleScroll, 50, {
      trailing: true
    });
    (_stickyManager$curren = stickyManager.current) === null || _stickyManager$curren === void 0 ? void 0 : _stickyManager$curren.setContainer(currentScrollArea);
    currentScrollArea.addEventListener("scroll", handleScroll);
    globalThis.addEventListener("resize", handleResize);
    return () => {
      currentScrollArea.removeEventListener("scroll", handleScroll);
      globalThis.removeEventListener("resize", handleResize);
    };
  }, [stickyManager, handleScroll]);
  const finalClassName = classNames(className, styles6.Scrollable, vertical && styles6.vertical, horizontal && styles6.horizontal, shadow2 && topShadow && styles6.hasTopShadow, shadow2 && bottomShadow && styles6.hasBottomShadow);
  return import_react529.default.createElement(ScrollableContext.Provider, {
    value: scrollTo
  }, import_react529.default.createElement(StickyManagerContext.Provider, {
    value: stickyManager.current
  }, import_react529.default.createElement("div", Object.assign({
    className: finalClassName
  }, scrollable.props, rest, {
    ref: scrollArea,
    tabIndex: focusable ? 0 : void 0
  }), children2)));
});
ScrollableComponent.displayName = "Scrollable";
function prefersReducedMotion() {
  try {
    return window.matchMedia("(prefers-reduced-motion: reduce)").matches;
  } catch (err) {
    return false;
  }
}
function performScrollHint(elem) {
  if (!elem || prefersReducedMotion()) {
    return;
  }
  const scrollableDistance = elem.scrollHeight - elem.clientHeight;
  const distanceToPeek = Math.min(MAX_SCROLL_HINT_DISTANCE, scrollableDistance) - LOW_RES_BUFFER;
  const goBackToTop = () => {
    requestAnimationFrame(() => {
      if (elem.scrollTop >= distanceToPeek) {
        elem.removeEventListener("scroll", goBackToTop);
        elem.scrollTo({
          top: 0,
          behavior: "smooth"
        });
      }
    });
  };
  elem.addEventListener("scroll", goBackToTop);
  elem.scrollTo({
    top: MAX_SCROLL_HINT_DISTANCE,
    behavior: "smooth"
  });
}
var forNode = (node) => {
  const closestElement = node.closest(scrollable.selector);
  return closestElement instanceof HTMLElement ? closestElement : document;
};
var Scrollable = ScrollableComponent;
Scrollable.ScrollTo = ScrollTo;
Scrollable.forNode = forNode;

// ../node_modules/@shopify/polaris/build/esm/components/PositionedOverlay/PositionedOverlay.js
var OBSERVER_CONFIG = {
  childList: true,
  subtree: true,
  characterData: true,
  attributeFilter: ["style"]
};
var PositionedOverlay = class extends import_react530.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      measuring: true,
      activatorRect: getRectForNode(this.props.activator),
      right: void 0,
      left: void 0,
      top: 0,
      height: 0,
      width: null,
      positioning: "below",
      zIndex: null,
      outsideScrollableContainer: false,
      lockPosition: false,
      chevronOffset: 0
    };
    this.overlay = null;
    this.scrollableContainers = [];
    this.observer = void 0;
    this.overlayDetails = () => {
      const {
        measuring,
        left,
        right,
        positioning,
        height,
        activatorRect,
        chevronOffset
      } = this.state;
      return {
        measuring,
        left,
        right,
        desiredHeight: height,
        positioning,
        activatorRect,
        chevronOffset
      };
    };
    this.setOverlay = (node) => {
      this.overlay = node;
    };
    this.setScrollableContainers = () => {
      const containers = [];
      let scrollableContainer = Scrollable.forNode(this.props.activator);
      if (scrollableContainer) {
        containers.push(scrollableContainer);
        while ((_scrollableContainer = scrollableContainer) !== null && _scrollableContainer !== void 0 && _scrollableContainer.parentElement) {
          var _scrollableContainer;
          scrollableContainer = Scrollable.forNode(scrollableContainer.parentElement);
          containers.push(scrollableContainer);
        }
      }
      this.scrollableContainers = containers;
    };
    this.registerScrollHandlers = () => {
      this.scrollableContainers.forEach((node) => {
        node.addEventListener("scroll", this.handleMeasurement);
      });
    };
    this.unregisterScrollHandlers = () => {
      this.scrollableContainers.forEach((node) => {
        node.removeEventListener("scroll", this.handleMeasurement);
      });
    };
    this.handleMeasurement = () => {
      const {
        lockPosition,
        top
      } = this.state;
      this.observer.disconnect();
      this.setState(({
        left,
        top: top2,
        right
      }) => ({
        left,
        right,
        top: top2,
        height: 0,
        positioning: "below",
        measuring: true
      }), () => {
        if (this.overlay == null || this.firstScrollableContainer == null) {
          return;
        }
        const {
          activator,
          preferredPosition = "below",
          preferredAlignment = "center",
          onScrollOut,
          fullWidth,
          fixed,
          preferInputActivator = true
        } = this.props;
        const preferredActivator = preferInputActivator ? activator.querySelector("input") || activator : activator;
        const activatorRect = getRectForNode(preferredActivator);
        const currentOverlayRect = getRectForNode(this.overlay);
        const scrollableElement = isDocument2(this.firstScrollableContainer) ? document.body : this.firstScrollableContainer;
        const scrollableContainerRect = getRectForNode(scrollableElement);
        const overlayRect = fullWidth ? new Rect({
          ...currentOverlayRect,
          width: activatorRect.width
        }) : currentOverlayRect;
        if (scrollableElement === document.body) {
          scrollableContainerRect.height = document.body.scrollHeight;
        }
        let topBarOffset = 0;
        const topBarElement = scrollableElement.querySelector(`${dataPolarisTopBar.selector}`);
        if (topBarElement) {
          topBarOffset = topBarElement.clientHeight;
        }
        const overlayMargins = this.overlay.firstElementChild && this.overlay.firstChild instanceof HTMLElement ? getMarginsForNode(this.overlay.firstElementChild) : {
          activator: 0,
          container: 0,
          horizontal: 0
        };
        const containerRect = windowRect();
        const zIndexForLayer = getZIndexForLayerFromNode(activator);
        const zIndex3 = zIndexForLayer == null ? zIndexForLayer : zIndexForLayer + 1;
        const verticalPosition = calculateVerticalPosition(activatorRect, overlayRect, overlayMargins, scrollableContainerRect, containerRect, preferredPosition, fixed, topBarOffset);
        const horizontalPosition = calculateHorizontalPosition(activatorRect, overlayRect, containerRect, overlayMargins, preferredAlignment);
        const chevronOffset = activatorRect.center.x - horizontalPosition;
        this.setState({
          measuring: false,
          activatorRect: getRectForNode(activator),
          left: preferredAlignment !== "right" ? horizontalPosition : void 0,
          right: preferredAlignment === "right" ? horizontalPosition : void 0,
          top: lockPosition ? top : verticalPosition.top,
          lockPosition: Boolean(fixed),
          height: verticalPosition.height || 0,
          width: fullWidth ? overlayRect.width : null,
          positioning: verticalPosition.positioning,
          outsideScrollableContainer: onScrollOut != null && rectIsOutsideOfRect(activatorRect, intersectionWithViewport(scrollableContainerRect)),
          zIndex: zIndex3,
          chevronOffset
        }, () => {
          if (!this.overlay)
            return;
          this.observer.observe(this.overlay, OBSERVER_CONFIG);
          this.observer.observe(activator, OBSERVER_CONFIG);
        });
      });
    };
    this.observer = new MutationObserver(this.handleMeasurement);
  }
  componentDidMount() {
    this.setScrollableContainers();
    if (this.scrollableContainers.length && !this.props.fixed) {
      this.registerScrollHandlers();
    }
    this.handleMeasurement();
  }
  componentWillUnmount() {
    this.observer.disconnect();
    if (this.scrollableContainers.length && !this.props.fixed) {
      this.unregisterScrollHandlers();
    }
  }
  componentDidUpdate() {
    const {
      outsideScrollableContainer,
      top
    } = this.state;
    const {
      onScrollOut,
      active
    } = this.props;
    if (active && onScrollOut != null && top !== 0 && outsideScrollableContainer) {
      onScrollOut();
    }
  }
  render() {
    const {
      left,
      right,
      top,
      zIndex: zIndex3,
      width
    } = this.state;
    const {
      render,
      fixed,
      preventInteraction,
      classNames: propClassNames,
      zIndexOverride
    } = this.props;
    const style = {
      top: top == null || isNaN(top) ? void 0 : top,
      left: left == null || isNaN(left) ? void 0 : left,
      right: right == null || isNaN(right) ? void 0 : right,
      width: width == null || isNaN(width) ? void 0 : width,
      zIndex: zIndexOverride || zIndex3 || void 0
    };
    const className = classNames(styles5.PositionedOverlay, fixed && styles5.fixed, preventInteraction && styles5.preventInteraction, propClassNames);
    return import_react530.default.createElement("div", {
      className,
      style,
      ref: this.setOverlay
    }, import_react530.default.createElement(EventListener, {
      event: "resize",
      handler: this.handleMeasurement
    }), render(this.overlayDetails()));
  }
  get firstScrollableContainer() {
    var _this$scrollableConta;
    return (_this$scrollableConta = this.scrollableContainers[0]) !== null && _this$scrollableConta !== void 0 ? _this$scrollableConta : null;
  }
  forceUpdatePosition() {
    requestAnimationFrame(this.handleMeasurement);
  }
};
function getMarginsForNode(node) {
  const nodeStyles = window.getComputedStyle(node);
  return {
    activator: parseFloat(nodeStyles.marginTop || "0"),
    container: parseFloat(nodeStyles.marginBottom || "0"),
    horizontal: parseFloat(nodeStyles.marginLeft || "0")
  };
}
function getZIndexForLayerFromNode(node) {
  const layerNode = node.closest(layer.selector) || document.body;
  const zIndex3 = layerNode === document.body ? "auto" : parseInt(window.getComputedStyle(layerNode).zIndex || "0", 10);
  return zIndex3 === "auto" || isNaN(zIndex3) ? null : zIndex3;
}
function isDocument2(node) {
  return node === document;
}

// ../node_modules/@shopify/polaris/build/esm/components/Popover/components/Pane/Pane.js
var import_react533 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Popover/components/Section/Section.js
var import_react532 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Box/Box.js
var import_react531 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Box/Box.scss.js
var styles7 = {
  "listReset": "Polaris-Box--listReset",
  "Box": "Polaris-Box",
  "visuallyHidden": "Polaris-Box--visuallyHidden",
  "printHidden": "Polaris-Box--printHidden"
};

// ../node_modules/@shopify/polaris/build/esm/components/Box/Box.js
var Box = (0, import_react531.forwardRef)(({
  as = "div",
  background,
  borderColor,
  borderStyle,
  borderWidth,
  borderBlockStartWidth,
  borderBlockEndWidth,
  borderInlineStartWidth,
  borderInlineEndWidth,
  borderRadius,
  borderRadiusEndStart,
  borderRadiusEndEnd,
  borderRadiusStartStart,
  borderRadiusStartEnd,
  children: children2,
  color: color2,
  id,
  minHeight,
  minWidth,
  maxWidth,
  overflowX,
  overflowY,
  outlineColor,
  outlineStyle,
  outlineWidth,
  padding,
  paddingBlockStart,
  paddingBlockEnd,
  paddingInlineStart,
  paddingInlineEnd,
  role,
  shadow: shadow2,
  tabIndex,
  width,
  printHidden,
  visuallyHidden,
  position,
  insetBlockStart,
  insetBlockEnd,
  insetInlineStart,
  insetInlineEnd,
  zIndex: zIndex3,
  opacity,
  ...restProps
}, ref) => {
  const borderStyleValue = borderStyle ? borderStyle : borderColor || borderWidth || borderBlockStartWidth || borderBlockEndWidth || borderInlineStartWidth || borderInlineEndWidth ? "solid" : void 0;
  const outlineStyleValue = outlineStyle ? outlineStyle : outlineColor || outlineWidth ? "solid" : void 0;
  const style = {
    "--pc-box-color": color2 ? `var(--p-color-${color2})` : void 0,
    "--pc-box-background": background ? `var(--p-color-${background})` : void 0,
    // eslint-disable-next-line no-nested-ternary
    "--pc-box-border-color": borderColor ? borderColor === "transparent" ? "transparent" : `var(--p-color-${borderColor})` : void 0,
    "--pc-box-border-style": borderStyleValue,
    "--pc-box-border-radius": borderRadius ? `var(--p-border-radius-${borderRadius})` : void 0,
    "--pc-box-border-radius-end-start": borderRadiusEndStart ? `var(--p-border-radius-${borderRadiusEndStart})` : void 0,
    "--pc-box-border-radius-end-end": borderRadiusEndEnd ? `var(--p-border-radius-${borderRadiusEndEnd})` : void 0,
    "--pc-box-border-radius-start-start": borderRadiusStartStart ? `var(--p-border-radius-${borderRadiusStartStart})` : void 0,
    "--pc-box-border-radius-start-end": borderRadiusStartEnd ? `var(--p-border-radius-${borderRadiusStartEnd})` : void 0,
    "--pc-box-border-width": borderWidth ? `var(--p-border-width-${borderWidth})` : void 0,
    "--pc-box-border-block-start-width": borderBlockStartWidth ? `var(--p-border-width-${borderBlockStartWidth})` : void 0,
    "--pc-box-border-block-end-width": borderBlockEndWidth ? `var(--p-border-width-${borderBlockEndWidth})` : void 0,
    "--pc-box-border-inline-start-width": borderInlineStartWidth ? `var(--p-border-width-${borderInlineStartWidth})` : void 0,
    "--pc-box-border-inline-end-width": borderInlineEndWidth ? `var(--p-border-width-${borderInlineEndWidth})` : void 0,
    "--pc-box-min-height": minHeight,
    "--pc-box-min-width": minWidth,
    "--pc-box-max-width": maxWidth,
    "--pc-box-outline-color": outlineColor ? `var(--p-color-${outlineColor})` : void 0,
    "--pc-box-outline-style": outlineStyleValue,
    "--pc-box-outline-width": outlineWidth ? `var(--p-border-width-${outlineWidth})` : void 0,
    "--pc-box-overflow-x": overflowX,
    "--pc-box-overflow-y": overflowY,
    ...getResponsiveProps("box", "padding-block-end", "space", paddingBlockEnd || padding),
    ...getResponsiveProps("box", "padding-block-start", "space", paddingBlockStart || padding),
    ...getResponsiveProps("box", "padding-inline-start", "space", paddingInlineStart || padding),
    ...getResponsiveProps("box", "padding-inline-end", "space", paddingInlineEnd || padding),
    "--pc-box-shadow": shadow2 ? `var(--p-shadow-${shadow2})` : void 0,
    "--pc-box-width": width,
    position,
    "--pc-box-inset-block-start": insetBlockStart ? `var(--p-space-${insetBlockStart})` : void 0,
    "--pc-box-inset-block-end": insetBlockEnd ? `var(--p-space-${insetBlockEnd})` : void 0,
    "--pc-box-inset-inline-start": insetInlineStart ? `var(--p-space-${insetInlineStart})` : void 0,
    "--pc-box-inset-inline-end": insetInlineEnd ? `var(--p-space-${insetInlineEnd})` : void 0,
    zIndex: zIndex3,
    opacity
  };
  const className = classNames(styles7.Box, visuallyHidden && styles7.visuallyHidden, printHidden && styles7.printHidden, as === "ul" && styles7.listReset);
  return import_react531.default.createElement(as, {
    className,
    id,
    ref,
    style: sanitizeCustomProperties(style),
    role,
    tabIndex,
    ...restProps
  }, children2);
});
Box.displayName = "Box";

// ../node_modules/@shopify/polaris/build/esm/components/Popover/components/Section/Section.js
function Section({
  children: children2
}) {
  return import_react532.default.createElement("div", {
    className: styles4.Section
  }, import_react532.default.createElement(Box, {
    padding: "4"
  }, children2));
}

// ../node_modules/@shopify/polaris/build/esm/components/Popover/components/Pane/Pane.js
function Pane({
  captureOverscroll = false,
  fixed,
  sectioned,
  children: children2,
  height,
  onScrolledToBottom
}) {
  const className = classNames(styles4.Pane, fixed && styles4["Pane-fixed"], captureOverscroll && styles4["Pane-captureOverscroll"]);
  const content = sectioned ? wrapWithComponent(children2, Section, {}) : children2;
  const style = height ? {
    height,
    maxHeight: height,
    minHeight: height
  } : void 0;
  return fixed ? import_react533.default.createElement("div", {
    style,
    className
  }, content) : import_react533.default.createElement(Scrollable, {
    shadow: true,
    className,
    style,
    onScrolledToBottom
  }, content);
}

// ../node_modules/@shopify/polaris/build/esm/components/Popover/components/PopoverOverlay/PopoverOverlay.js
var PopoverCloseSource;
(function(PopoverCloseSource2) {
  PopoverCloseSource2[PopoverCloseSource2["Click"] = 0] = "Click";
  PopoverCloseSource2[PopoverCloseSource2["EscapeKeypress"] = 1] = "EscapeKeypress";
  PopoverCloseSource2[PopoverCloseSource2["FocusOut"] = 2] = "FocusOut";
  PopoverCloseSource2[PopoverCloseSource2["ScrollOut"] = 3] = "ScrollOut";
})(PopoverCloseSource || (PopoverCloseSource = {}));
var TransitionStatus;
(function(TransitionStatus3) {
  TransitionStatus3["Entering"] = "entering";
  TransitionStatus3["Entered"] = "entered";
  TransitionStatus3["Exiting"] = "exiting";
  TransitionStatus3["Exited"] = "exited";
})(TransitionStatus || (TransitionStatus = {}));
var PopoverOverlay = class extends import_react534.PureComponent {
  constructor(props) {
    super(props);
    this.context = void 0;
    this.state = {
      transitionStatus: this.props.active ? TransitionStatus.Entering : TransitionStatus.Exited
    };
    this.contentNode = (0, import_react534.createRef)();
    this.enteringTimer = void 0;
    this.overlayRef = void 0;
    this.renderPopover = (overlayDetails) => {
      const {
        measuring,
        desiredHeight,
        positioning
      } = overlayDetails;
      const {
        id,
        children: children2,
        sectioned,
        fullWidth,
        fullHeight,
        fluidContent,
        hideOnPrint,
        autofocusTarget,
        captureOverscroll
      } = this.props;
      const className = classNames(styles4.Popover, positioning === "above" && styles4.positionedAbove, fullWidth && styles4.fullWidth, measuring && styles4.measuring, hideOnPrint && styles4["PopoverOverlay-hideOnPrint"]);
      const contentStyles = measuring ? void 0 : {
        height: desiredHeight
      };
      const contentClassNames = classNames(styles4.Content, fullHeight && styles4["Content-fullHeight"], fluidContent && styles4["Content-fluidContent"]);
      const content = import_react534.default.createElement("div", {
        id,
        tabIndex: autofocusTarget === "none" ? void 0 : -1,
        className: contentClassNames,
        style: contentStyles,
        ref: this.contentNode
      }, renderPopoverContent(children2, {
        captureOverscroll,
        sectioned
      }));
      return import_react534.default.createElement("div", Object.assign({
        className
      }, overlay.props), import_react534.default.createElement(EventListener, {
        event: "click",
        handler: this.handleClick
      }), import_react534.default.createElement(EventListener, {
        event: "touchstart",
        handler: this.handleClick
      }), import_react534.default.createElement(KeypressListener, {
        keyCode: Key.Escape,
        handler: this.handleEscape
      }), import_react534.default.createElement("div", {
        className: styles4.FocusTracker,
        tabIndex: 0,
        onFocus: this.handleFocusFirstItem
      }), import_react534.default.createElement(Box, {
        position: "relative",
        overflowX: "hidden",
        overflowY: "hidden",
        background: "bg",
        borderRadius: "2"
      }, content), import_react534.default.createElement("div", {
        className: styles4.FocusTracker,
        tabIndex: 0,
        onFocus: this.handleFocusLastItem
      }));
    };
    this.handleClick = (event) => {
      const target = event.target;
      const {
        contentNode,
        props: {
          activator,
          onClose,
          preventCloseOnChildOverlayClick
        }
      } = this;
      const composedPath = event.composedPath();
      const wasDescendant = preventCloseOnChildOverlayClick ? wasPolarisPortalDescendant(composedPath, this.context.container) : wasContentNodeDescendant(composedPath, contentNode);
      const isActivatorDescendant = nodeContainsDescendant(activator, target);
      if (wasDescendant || isActivatorDescendant || this.state.transitionStatus !== TransitionStatus.Entered) {
        return;
      }
      onClose(PopoverCloseSource.Click);
    };
    this.handleScrollOut = () => {
      this.props.onClose(PopoverCloseSource.ScrollOut);
    };
    this.handleEscape = (event) => {
      const target = event.target;
      const {
        contentNode,
        props: {
          activator
        }
      } = this;
      const composedPath = event.composedPath();
      const wasDescendant = wasContentNodeDescendant(composedPath, contentNode);
      const isActivatorDescendant = nodeContainsDescendant(activator, target);
      if (wasDescendant || isActivatorDescendant) {
        this.props.onClose(PopoverCloseSource.EscapeKeypress);
      }
    };
    this.handleFocusFirstItem = () => {
      this.props.onClose(PopoverCloseSource.FocusOut);
    };
    this.handleFocusLastItem = () => {
      this.props.onClose(PopoverCloseSource.FocusOut);
    };
    this.overlayRef = (0, import_react534.createRef)();
  }
  forceUpdatePosition() {
    var _this$overlayRef$curr;
    (_this$overlayRef$curr = this.overlayRef.current) === null || _this$overlayRef$curr === void 0 ? void 0 : _this$overlayRef$curr.forceUpdatePosition();
  }
  changeTransitionStatus(transitionStatus, cb) {
    this.setState({
      transitionStatus
    }, cb);
    this.contentNode.current && this.contentNode.current.getBoundingClientRect();
  }
  componentDidMount() {
    if (this.props.active) {
      this.focusContent();
      this.changeTransitionStatus(TransitionStatus.Entered);
    }
  }
  componentDidUpdate(oldProps) {
    if (this.props.active && !oldProps.active) {
      this.focusContent();
      this.changeTransitionStatus(TransitionStatus.Entering, () => {
        this.clearTransitionTimeout();
        this.enteringTimer = window.setTimeout(() => {
          this.setState({
            transitionStatus: TransitionStatus.Entered
          });
        }, parseInt(motion2["duration-100"], 10));
      });
    }
    if (!this.props.active && oldProps.active) {
      this.clearTransitionTimeout();
      this.setState({
        transitionStatus: TransitionStatus.Exited
      });
    }
  }
  componentWillUnmount() {
    this.clearTransitionTimeout();
  }
  render() {
    const {
      active,
      activator,
      fullWidth,
      preferredPosition = "below",
      preferredAlignment = "center",
      preferInputActivator = true,
      fixed,
      zIndexOverride
    } = this.props;
    const {
      transitionStatus
    } = this.state;
    if (transitionStatus === TransitionStatus.Exited && !active)
      return null;
    const className = classNames(styles4.PopoverOverlay, transitionStatus === TransitionStatus.Entering && styles4["PopoverOverlay-entering"], transitionStatus === TransitionStatus.Entered && styles4["PopoverOverlay-open"], transitionStatus === TransitionStatus.Exiting && styles4["PopoverOverlay-exiting"]);
    return import_react534.default.createElement(PositionedOverlay, {
      ref: this.overlayRef,
      fullWidth,
      active,
      activator,
      preferInputActivator,
      preferredPosition,
      preferredAlignment,
      render: this.renderPopover.bind(this),
      fixed,
      onScrollOut: this.handleScrollOut,
      classNames: className,
      zIndexOverride
    });
  }
  clearTransitionTimeout() {
    if (this.enteringTimer) {
      window.clearTimeout(this.enteringTimer);
    }
  }
  focusContent() {
    const {
      autofocusTarget = "container"
    } = this.props;
    if (autofocusTarget === "none" || this.contentNode == null) {
      return;
    }
    requestAnimationFrame(() => {
      if (this.contentNode.current == null) {
        return;
      }
      const focusableChild = findFirstKeyboardFocusableNode(this.contentNode.current);
      if (focusableChild && autofocusTarget === "first-node") {
        focusableChild.focus({
          preventScroll: true
        });
      } else {
        this.contentNode.current.focus({
          preventScroll: true
        });
      }
    });
  }
  // eslint-disable-next-line @shopify/react-no-multiple-render-methods
};
PopoverOverlay.contextType = PortalsManagerContext;
function renderPopoverContent(children2, props) {
  const childrenArray = import_react534.Children.toArray(children2);
  if (isElementOfType(childrenArray[0], Pane)) {
    return childrenArray;
  }
  return wrapWithComponent(childrenArray, Pane, props);
}
function nodeContainsDescendant(rootNode, descendant) {
  if (rootNode === descendant) {
    return true;
  }
  let parent = descendant.parentNode;
  while (parent != null) {
    if (parent === rootNode) {
      return true;
    }
    parent = parent.parentNode;
  }
  return false;
}
function wasContentNodeDescendant(composedPath, contentNode) {
  return contentNode.current != null && composedPath.includes(contentNode.current);
}
function wasPolarisPortalDescendant(composedPath, portalsContainerElement) {
  return composedPath.some((eventTarget) => eventTarget instanceof Node && (portalsContainerElement === null || portalsContainerElement === void 0 ? void 0 : portalsContainerElement.contains(eventTarget)));
}

// ../node_modules/@shopify/polaris/build/esm/components/Popover/Popover.js
var PopoverComponent = (0, import_react535.forwardRef)(function Popover({
  activatorWrapper = "div",
  children: children2,
  onClose,
  activator,
  preventFocusOnClose,
  active,
  fixed,
  ariaHaspopup,
  preferInputActivator = true,
  zIndexOverride,
  ...rest
}, ref) {
  const [activatorNode, setActivatorNode] = (0, import_react535.useState)();
  const overlayRef = (0, import_react535.useRef)(null);
  const activatorContainer = (0, import_react535.useRef)(null);
  const WrapperComponent = activatorWrapper;
  const id = useUniqueId("popover");
  function forceUpdatePosition() {
    var _overlayRef$current;
    (_overlayRef$current = overlayRef.current) === null || _overlayRef$current === void 0 ? void 0 : _overlayRef$current.forceUpdatePosition();
  }
  (0, import_react535.useImperativeHandle)(ref, () => {
    return {
      forceUpdatePosition
    };
  });
  const setAccessibilityAttributes = (0, import_react535.useCallback)(() => {
    if (activatorContainer.current == null) {
      return;
    }
    const firstFocusable = findFirstFocusableNodeIncludingDisabled(activatorContainer.current);
    const focusableActivator = firstFocusable || activatorContainer.current;
    const activatorDisabled = "disabled" in focusableActivator && Boolean(focusableActivator.disabled);
    setActivatorAttributes(focusableActivator, {
      id,
      active,
      ariaHaspopup,
      activatorDisabled
    });
  }, [id, active, ariaHaspopup]);
  const handleClose = (source) => {
    onClose(source);
    if (activatorContainer.current == null || preventFocusOnClose) {
      return;
    }
    if (source === PopoverCloseSource.FocusOut && activatorNode) {
      const focusableActivator = findFirstFocusableNodeIncludingDisabled(activatorNode) || findFirstFocusableNodeIncludingDisabled(activatorContainer.current) || activatorContainer.current;
      if (!focusNextFocusableNode(focusableActivator, isInPortal)) {
        focusableActivator.focus();
      }
    } else if (source === PopoverCloseSource.EscapeKeypress && activatorNode) {
      const focusableActivator = findFirstFocusableNodeIncludingDisabled(activatorNode) || findFirstFocusableNodeIncludingDisabled(activatorContainer.current) || activatorContainer.current;
      if (focusableActivator) {
        focusableActivator.focus();
      } else {
        focusNextFocusableNode(focusableActivator, isInPortal);
      }
    }
  };
  (0, import_react535.useEffect)(() => {
    if (!activatorNode && activatorContainer.current) {
      setActivatorNode(activatorContainer.current.firstElementChild);
    } else if (activatorNode && activatorContainer.current && !activatorContainer.current.contains(activatorNode)) {
      setActivatorNode(activatorContainer.current.firstElementChild);
    }
    setAccessibilityAttributes();
  }, [activatorNode, setAccessibilityAttributes]);
  (0, import_react535.useEffect)(() => {
    if (activatorNode && activatorContainer.current) {
      setActivatorNode(activatorContainer.current.firstElementChild);
    }
    setAccessibilityAttributes();
  }, [activatorNode, setAccessibilityAttributes]);
  const portal2 = activatorNode ? import_react535.default.createElement(Portal, {
    idPrefix: "popover"
  }, import_react535.default.createElement(PopoverOverlay, Object.assign({
    ref: overlayRef,
    id,
    activator: activatorNode,
    preferInputActivator,
    onClose: handleClose,
    active,
    fixed,
    zIndexOverride
  }, rest), children2)) : null;
  return import_react535.default.createElement(WrapperComponent, {
    ref: activatorContainer
  }, import_react535.Children.only(activator), portal2);
});
function isInPortal(element) {
  let parentElement = element.parentElement;
  while (parentElement) {
    if (parentElement.matches(portal.selector))
      return false;
    parentElement = parentElement.parentElement;
  }
  return true;
}
var Popover2 = Object.assign(PopoverComponent, {
  Pane,
  Section
});

// ../node_modules/@shopify/polaris/build/esm/components/ActionList/ActionList.js
var import_react550 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/ActionList/components/Section/Section.js
var import_react549 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/ActionList/components/Item/Item.js
var import_react548 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/ActionList/ActionList.scss.js
var styles8 = {
  "Item": "Polaris-ActionList__Item",
  "active": "Polaris-ActionList--active",
  "destructive": "Polaris-ActionList--destructive",
  "disabled": "Polaris-ActionList--disabled",
  "Prefix": "Polaris-ActionList__Prefix",
  "Suffix": "Polaris-ActionList__Suffix",
  "Text": "Polaris-ActionList__Text"
};

// ../node_modules/@shopify/polaris/build/esm/components/Badge/Badge.js
var import_react540 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/within-filter-context.js
var import_react536 = __toESM(require_react());
var WithinFilterContext = (0, import_react536.createContext)(false);

// ../node_modules/@shopify/polaris/build/esm/components/Badge/Badge.scss.js
var styles9 = {
  "Badge": "Polaris-Badge",
  "statusSuccess": "Polaris-Badge--statusSuccess",
  "statusInfo": "Polaris-Badge--statusInfo",
  "statusAttention": "Polaris-Badge--statusAttention",
  "statusWarning": "Polaris-Badge--statusWarning",
  "statusCritical": "Polaris-Badge--statusCritical",
  "statusNew": "Polaris-Badge--statusNew",
  "withinFilter": "Polaris-Badge--withinFilter",
  "Icon": "Polaris-Badge__Icon",
  "PipContainer": "Polaris-Badge__PipContainer"
};

// ../node_modules/@shopify/polaris/build/esm/components/Badge/types.js
var StatusValue;
(function(StatusValue2) {
  StatusValue2["Info"] = "info";
  StatusValue2["Success"] = "success";
  StatusValue2["Warning"] = "warning";
  StatusValue2["Critical"] = "critical";
  StatusValue2["Attention"] = "attention";
  StatusValue2["New"] = "new";
})(StatusValue || (StatusValue = {}));
var ProgressValue;
(function(ProgressValue2) {
  ProgressValue2["Incomplete"] = "incomplete";
  ProgressValue2["PartiallyComplete"] = "partiallyComplete";
  ProgressValue2["Complete"] = "complete";
})(ProgressValue || (ProgressValue = {}));

// ../node_modules/@shopify/polaris/build/esm/components/Badge/utils.js
function getDefaultAccessibilityLabel(i18n, progress, status) {
  let progressLabel = "";
  let statusLabel = "";
  if (!progress && !status) {
    return "";
  }
  switch (progress) {
    case ProgressValue.Incomplete:
      progressLabel = i18n.translate("Polaris.Badge.PROGRESS_LABELS.incomplete");
      break;
    case ProgressValue.PartiallyComplete:
      progressLabel = i18n.translate("Polaris.Badge.PROGRESS_LABELS.partiallyComplete");
      break;
    case ProgressValue.Complete:
      progressLabel = i18n.translate("Polaris.Badge.PROGRESS_LABELS.complete");
      break;
  }
  switch (status) {
    case StatusValue.Info:
      statusLabel = i18n.translate("Polaris.Badge.STATUS_LABELS.info");
      break;
    case StatusValue.Success:
      statusLabel = i18n.translate("Polaris.Badge.STATUS_LABELS.success");
      break;
    case StatusValue.Warning:
      statusLabel = i18n.translate("Polaris.Badge.STATUS_LABELS.warning");
      break;
    case StatusValue.Critical:
      statusLabel = i18n.translate("Polaris.Badge.STATUS_LABELS.critical");
      break;
    case StatusValue.Attention:
      statusLabel = i18n.translate("Polaris.Badge.STATUS_LABELS.attention");
      break;
    case StatusValue.New:
      statusLabel = i18n.translate("Polaris.Badge.STATUS_LABELS.new");
      break;
  }
  if (!status && progress) {
    return progressLabel;
  } else if (status && !progress) {
    return statusLabel;
  } else {
    return i18n.translate("Polaris.Badge.progressAndStatus", {
      progressLabel,
      statusLabel
    });
  }
}

// ../node_modules/@shopify/polaris/build/esm/components/Badge/components/Pip/Pip.js
var import_react538 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Badge/components/Pip/Pip.scss.js
var styles10 = {
  "Pip": "Polaris-Badge-Pip",
  "statusInfo": "Polaris-Badge-Pip--statusInfo",
  "statusSuccess": "Polaris-Badge-Pip--statusSuccess",
  "statusNew": "Polaris-Badge-Pip--statusNew",
  "statusAttention": "Polaris-Badge-Pip--statusAttention",
  "statusWarning": "Polaris-Badge-Pip--statusWarning",
  "statusCritical": "Polaris-Badge-Pip--statusCritical",
  "progressIncomplete": "Polaris-Badge-Pip--progressIncomplete",
  "progressPartiallyComplete": "Polaris-Badge-Pip--progressPartiallyComplete",
  "progressComplete": "Polaris-Badge-Pip--progressComplete"
};

// ../node_modules/@shopify/polaris/build/esm/utilities/i18n/hooks.js
var import_react537 = __toESM(require_react());
function useI18n() {
  const i18n = (0, import_react537.useContext)(I18nContext);
  if (!i18n) {
    throw new MissingAppProviderError("No i18n was provided.");
  }
  return i18n;
}

// ../node_modules/@shopify/polaris/build/esm/components/Badge/components/Pip/Pip.js
function Pip({
  status,
  progress = "complete",
  accessibilityLabelOverride
}) {
  const i18n = useI18n();
  const className = classNames(styles10.Pip, status && styles10[variationName("status", status)], progress && styles10[variationName("progress", progress)]);
  const accessibilityLabel = accessibilityLabelOverride ? accessibilityLabelOverride : getDefaultAccessibilityLabel(i18n, progress, status);
  return import_react538.default.createElement("span", {
    className
  }, import_react538.default.createElement(Text, {
    as: "span",
    visuallyHidden: true
  }, accessibilityLabel));
}

// ../node_modules/@shopify/polaris/build/esm/components/Icon/Icon.js
var import_react539 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Icon/Icon.scss.js
var styles11 = {
  "Icon": "Polaris-Icon",
  "applyColor": "Polaris-Icon--applyColor",
  "hasBackdrop": "Polaris-Icon--hasBackdrop",
  "colorBase": "Polaris-Icon--colorBase",
  "colorSubdued": "Polaris-Icon--colorSubdued",
  "colorCritical": "Polaris-Icon--colorCritical",
  "colorInteractive": "Polaris-Icon--colorInteractive",
  "colorWarning": "Polaris-Icon--colorWarning",
  "colorHighlight": "Polaris-Icon--colorHighlight",
  "colorSuccess": "Polaris-Icon--colorSuccess",
  "colorPrimary": "Polaris-Icon--colorPrimary",
  "colorMagic": "Polaris-Icon--colorMagic",
  "Svg": "Polaris-Icon__Svg",
  "Img": "Polaris-Icon__Img",
  "Placeholder": "Polaris-Icon__Placeholder"
};

// ../node_modules/@shopify/polaris/build/esm/components/Icon/Icon.js
var COLORS_WITH_BACKDROPS = ["base", "critical", "highlight", "success", "warning"];
function Icon({
  source,
  color: color2,
  backdrop,
  accessibilityLabel
}) {
  let sourceType;
  if (typeof source === "function") {
    sourceType = "function";
  } else if (source === "placeholder") {
    sourceType = "placeholder";
  } else {
    sourceType = "external";
  }
  if (color2 && sourceType === "external" && true) {
    console.warn("Recoloring external SVGs is not supported. Set the intended color on your SVG instead.");
  }
  if (backdrop && color2 && !COLORS_WITH_BACKDROPS.includes(color2) && true) {
    console.warn(`The ${color2} variant does not have a supported backdrop color`);
  }
  const className = classNames(styles11.Icon, color2 && styles11[variationName("color", color2)], color2 && styles11.applyColor, backdrop && styles11.hasBackdrop);
  const SourceComponent = source;
  const contentMarkup = {
    function: import_react539.default.createElement(SourceComponent, {
      className: styles11.Svg,
      focusable: "false",
      "aria-hidden": "true"
    }),
    placeholder: import_react539.default.createElement("div", {
      className: styles11.Placeholder
    }),
    external: import_react539.default.createElement("img", {
      className: styles11.Img,
      src: `data:image/svg+xml;utf8,${source}`,
      alt: "",
      "aria-hidden": "true"
    })
  };
  return import_react539.default.createElement("span", {
    className
  }, import_react539.default.createElement(Text, {
    as: "span",
    visuallyHidden: true
  }, accessibilityLabel), contentMarkup[sourceType]);
}

// ../node_modules/@shopify/polaris/build/esm/components/Badge/Badge.js
var DEFAULT_SIZE = "medium";
function Badge({
  children: children2,
  status,
  progress,
  icon,
  size = DEFAULT_SIZE,
  statusAndProgressLabelOverride
}) {
  const i18n = useI18n();
  const withinFilter = (0, import_react540.useContext)(WithinFilterContext);
  const className = classNames(
    styles9.Badge,
    status && styles9[variationName("status", status)],
    icon && styles9.icon,
    // TODO: remove support for the size prop in the next major release
    size && size !== DEFAULT_SIZE && styles9[variationName("size", size)],
    withinFilter && styles9.withinFilter
  );
  const accessibilityLabel = statusAndProgressLabelOverride ? statusAndProgressLabelOverride : getDefaultAccessibilityLabel(i18n, progress, status);
  let accessibilityMarkup = Boolean(accessibilityLabel) && import_react540.default.createElement(Text, {
    as: "span",
    visuallyHidden: true
  }, accessibilityLabel);
  if (progress && !icon) {
    accessibilityMarkup = import_react540.default.createElement("span", {
      className: styles9.PipContainer
    }, import_react540.default.createElement(Pip, {
      progress,
      status,
      accessibilityLabelOverride: accessibilityLabel
    }));
  }
  return import_react540.default.createElement("span", {
    className
  }, accessibilityMarkup, icon && import_react540.default.createElement("span", {
    className: styles9.Icon
  }, import_react540.default.createElement(Icon, {
    source: icon
  })), children2 && import_react540.default.createElement(Text, {
    as: "span",
    variant: "bodySm",
    fontWeight: status === "new" ? "medium" : void 0
  }, children2));
}
Badge.Pip = Pip;

// ../node_modules/@shopify/polaris/build/esm/components/Tooltip/Tooltip.js
var import_react544 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/use-toggle.js
var import_react541 = __toESM(require_react());
function useToggle(initialState) {
  const [value, setState] = (0, import_react541.useState)(initialState);
  return {
    value,
    toggle: (0, import_react541.useCallback)(() => setState((state) => !state), []),
    setTrue: (0, import_react541.useCallback)(() => setState(true), []),
    setFalse: (0, import_react541.useCallback)(() => setState(false), [])
  };
}

// ../node_modules/@shopify/polaris/build/esm/components/Tooltip/Tooltip.scss.js
var styles12 = {
  "TooltipContainer": "Polaris-Tooltip__TooltipContainer",
  "HasUnderline": "Polaris-Tooltip__HasUnderline"
};

// ../node_modules/@shopify/polaris/build/esm/utilities/ephemeral-presence-manager/hooks.js
var import_react542 = __toESM(require_react());
function useEphemeralPresenceManager() {
  const ephemeralPresenceManager = (0, import_react542.useContext)(EphemeralPresenceManagerContext);
  if (!ephemeralPresenceManager) {
    throw new Error("No ephemeral presence manager was provided. Your application must be wrapped in an <AppProvider> component. See https://polaris.shopify.com/components/app-provider for implementation instructions.");
  }
  return ephemeralPresenceManager;
}
function useReadOnlyEphemeralPresenceManager() {
  const {
    presenceList,
    presenceCounter
  } = useEphemeralPresenceManager();
  return {
    presenceList,
    presenceCounter
  };
}

// ../node_modules/@shopify/polaris/build/esm/components/Tooltip/components/TooltipOverlay/TooltipOverlay.js
var import_react543 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Tooltip/components/TooltipOverlay/TooltipOverlay.scss.js
var styles13 = {
  "TooltipOverlay": "Polaris-Tooltip-TooltipOverlay",
  "positionedAbove": "Polaris-Tooltip-TooltipOverlay--positionedAbove",
  "measuring": "Polaris-Tooltip-TooltipOverlay--measuring",
  "measured": "Polaris-Tooltip-TooltipOverlay--measured",
  "instant": "Polaris-Tooltip-TooltipOverlay--instant",
  "Content": "Polaris-Tooltip-TooltipOverlay__Content",
  "default": "Polaris-Tooltip-TooltipOverlay--default",
  "wide": "Polaris-Tooltip-TooltipOverlay--wide"
};

// ../node_modules/@shopify/polaris/build/esm/components/Tooltip/components/TooltipOverlay/TooltipOverlay.js
function TooltipOverlay({
  active,
  activator,
  preferredPosition = "above",
  preventInteraction,
  id,
  children: children2,
  accessibilityLabel,
  width,
  padding,
  borderRadius,
  zIndexOverride,
  instant
}) {
  const i18n = useI18n();
  const markup = active ? import_react543.default.createElement(PositionedOverlay, {
    active,
    activator,
    preferredPosition,
    preventInteraction,
    render: renderTooltip,
    zIndexOverride
  }) : null;
  return markup;
  function renderTooltip(overlayDetails) {
    const {
      measuring,
      desiredHeight,
      positioning,
      chevronOffset
    } = overlayDetails;
    const containerClassName = classNames(styles13.TooltipOverlay, measuring && styles13.measuring, !measuring && styles13.measured, instant && styles13.instant, positioning === "above" && styles13.positionedAbove);
    const contentClassName = classNames(styles13.Content, width && styles13[width]);
    const contentStyles = measuring ? void 0 : {
      minHeight: desiredHeight
    };
    const style = {
      "--pc-tooltip-chevron-x-pos": `${chevronOffset}px`,
      "--pc-tooltip-border-radius": borderRadius ? `var(--p-border-radius-${borderRadius})` : void 0,
      "--pc-tooltip-padding": padding && padding === "default" ? "var(--p-space-1) var(--p-space-2)" : `var(--p-space-${padding})`
    };
    return import_react543.default.createElement("div", Object.assign({
      style,
      className: containerClassName
    }, layer.props), import_react543.default.createElement("div", {
      id,
      role: "tooltip",
      className: contentClassName,
      style: {
        ...contentStyles,
        ...style
      },
      "aria-label": accessibilityLabel ? i18n.translate("Polaris.TooltipOverlay.accessibilityLabel", {
        label: accessibilityLabel
      }) : void 0
    }, children2));
  }
}

// ../node_modules/@shopify/polaris/build/esm/components/Tooltip/Tooltip.js
var HOVER_OUT_TIMEOUT = 150;
function Tooltip({
  children: children2,
  content,
  dismissOnMouseOut,
  active: originalActive,
  hoverDelay,
  preferredPosition = "above",
  activatorWrapper = "span",
  accessibilityLabel,
  width = "default",
  padding = "default",
  borderRadius = "1",
  zIndexOverride,
  hasUnderline,
  persistOnClick,
  onOpen,
  onClose
}) {
  const WrapperComponent = activatorWrapper;
  const {
    value: active,
    setTrue: setActiveTrue,
    setFalse: handleBlur
  } = useToggle(Boolean(originalActive));
  const {
    value: persist,
    toggle: togglePersisting
  } = useToggle(Boolean(originalActive) && Boolean(persistOnClick));
  const [activatorNode, setActivatorNode] = (0, import_react544.useState)(null);
  const {
    presenceList,
    addPresence,
    removePresence
  } = useEphemeralPresenceManager();
  const id = useUniqueId("TooltipContent");
  const activatorContainer = (0, import_react544.useRef)(null);
  const mouseEntered = (0, import_react544.useRef)(false);
  const [shouldAnimate, setShouldAnimate] = (0, import_react544.useState)(Boolean(!originalActive));
  const hoverDelayTimeout = (0, import_react544.useRef)(null);
  const hoverOutTimeout = (0, import_react544.useRef)(null);
  const handleFocus = (0, import_react544.useCallback)(() => {
    if (originalActive !== false) {
      setActiveTrue();
    }
  }, [originalActive, setActiveTrue]);
  (0, import_react544.useEffect)(() => {
    const firstFocusable = activatorContainer.current ? findFirstFocusableNode(activatorContainer.current) : null;
    const accessibilityNode = firstFocusable || activatorContainer.current;
    if (!accessibilityNode)
      return;
    accessibilityNode.tabIndex = 0;
    accessibilityNode.setAttribute("aria-describedby", id);
    accessibilityNode.setAttribute("data-polaris-tooltip-activator", "true");
  }, [id, children2]);
  (0, import_react544.useEffect)(() => {
    return () => {
      if (hoverDelayTimeout.current) {
        clearTimeout(hoverDelayTimeout.current);
      }
      if (hoverOutTimeout.current) {
        clearTimeout(hoverOutTimeout.current);
      }
    };
  }, []);
  const handleOpen = (0, import_react544.useCallback)(() => {
    setShouldAnimate(!presenceList.tooltip && !active);
    onOpen === null || onOpen === void 0 ? void 0 : onOpen();
    addPresence("tooltip");
  }, [addPresence, presenceList.tooltip, onOpen, active]);
  const handleClose = (0, import_react544.useCallback)(() => {
    onClose === null || onClose === void 0 ? void 0 : onClose();
    setShouldAnimate(false);
    hoverOutTimeout.current = setTimeout(() => {
      removePresence("tooltip");
    }, HOVER_OUT_TIMEOUT);
  }, [removePresence, onClose]);
  const handleKeyUp = (0, import_react544.useCallback)((event) => {
    if (event.key !== "Escape")
      return;
    handleClose === null || handleClose === void 0 ? void 0 : handleClose();
    handleBlur();
    persistOnClick && togglePersisting();
  }, [handleBlur, handleClose, persistOnClick, togglePersisting]);
  const portal2 = activatorNode ? import_react544.default.createElement(Portal, {
    idPrefix: "tooltip"
  }, import_react544.default.createElement(TooltipOverlay, {
    id,
    preferredPosition,
    activator: activatorNode,
    active,
    accessibilityLabel,
    onClose: noop3,
    preventInteraction: dismissOnMouseOut,
    width,
    padding,
    borderRadius,
    zIndexOverride,
    instant: !shouldAnimate
  }, content)) : null;
  const wrapperClassNames = classNames(activatorWrapper === "div" && styles12.TooltipContainer, hasUnderline && styles12.HasUnderline);
  return import_react544.default.createElement(WrapperComponent, {
    onFocus: () => {
      handleOpen();
      handleFocus();
    },
    onBlur: () => {
      handleClose();
      handleBlur();
      if (persistOnClick) {
        togglePersisting();
      }
    },
    onMouseLeave: handleMouseLeave,
    onMouseOver: handleMouseEnterFix,
    onMouseDown: persistOnClick ? togglePersisting : void 0,
    ref: setActivator,
    onKeyUp: handleKeyUp,
    className: wrapperClassNames
  }, children2, portal2);
  function setActivator(node) {
    const activatorContainerRef = activatorContainer;
    if (node == null) {
      activatorContainerRef.current = null;
      setActivatorNode(null);
      return;
    }
    node.firstElementChild instanceof HTMLElement && setActivatorNode(node.firstElementChild);
    activatorContainerRef.current = node;
  }
  function handleMouseEnter() {
    mouseEntered.current = true;
    if (hoverDelay && !presenceList.tooltip) {
      hoverDelayTimeout.current = setTimeout(() => {
        handleOpen();
        handleFocus();
      }, hoverDelay);
    } else {
      handleOpen();
      handleFocus();
    }
  }
  function handleMouseLeave() {
    if (hoverDelayTimeout.current) {
      clearTimeout(hoverDelayTimeout.current);
      hoverDelayTimeout.current = null;
    }
    mouseEntered.current = false;
    handleClose();
    if (!persist) {
      handleBlur();
    }
  }
  function handleMouseEnterFix() {
    !mouseEntered.current && handleMouseEnter();
  }
}
function noop3() {
}

// ../node_modules/@shopify/polaris/build/esm/components/UnstyledLink/UnstyledLink.js
var import_react546 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/link/hooks.js
var import_react545 = __toESM(require_react());
function useLink() {
  return (0, import_react545.useContext)(LinkContext);
}

// ../node_modules/@shopify/polaris/build/esm/components/UnstyledLink/UnstyledLink.js
var UnstyledLink = (0, import_react546.memo)((0, import_react546.forwardRef)(function UnstyledLink2(props, _ref) {
  const LinkComponent = useLink();
  if (LinkComponent) {
    return import_react546.default.createElement(LinkComponent, Object.assign({}, unstyled.props, props));
  }
  const {
    external,
    url,
    target: targetProp,
    ...rest
  } = props;
  let target;
  if (external) {
    target = "_blank";
  } else {
    target = targetProp !== null && targetProp !== void 0 ? targetProp : void 0;
  }
  const rel = target === "_blank" ? "noopener noreferrer" : void 0;
  return import_react546.default.createElement("a", Object.assign({
    target
  }, rest, {
    href: url,
    rel
  }, unstyled.props));
}));

// ../node_modules/@shopify/polaris/build/esm/components/HorizontalStack/HorizontalStack.js
var import_react547 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/HorizontalStack/HorizontalStack.scss.js
var styles14 = {
  "HorizontalStack": "Polaris-HorizontalStack"
};

// ../node_modules/@shopify/polaris/build/esm/components/HorizontalStack/HorizontalStack.js
var HorizontalStack = function HorizontalStack2({
  align,
  blockAlign,
  gap,
  wrap = true,
  children: children2
}) {
  const style = {
    "--pc-horizontal-stack-align": align,
    "--pc-horizontal-stack-block-align": blockAlign,
    "--pc-horizontal-stack-wrap": wrap ? "wrap" : "nowrap",
    ...getResponsiveProps("horizontal-stack", "gap", "space", gap)
  };
  return import_react547.default.createElement("div", {
    className: styles14.HorizontalStack,
    style
  }, children2);
};

// ../node_modules/@shopify/polaris/build/esm/components/ActionList/components/Item/Item.js
function Item({
  id,
  badge,
  content,
  accessibilityLabel,
  helpText,
  url,
  onAction,
  onMouseEnter,
  icon,
  image,
  prefix,
  suffix,
  disabled,
  external,
  destructive,
  ellipsis,
  truncate,
  active,
  role
}) {
  const className = classNames(styles8.Item, disabled && styles8.disabled, destructive && styles8.destructive, active && styles8.active);
  let prefixMarkup = null;
  if (prefix) {
    prefixMarkup = import_react548.default.createElement("span", {
      className: styles8.Prefix
    }, prefix);
  } else if (icon) {
    prefixMarkup = import_react548.default.createElement("span", {
      className: styles8.Prefix
    }, import_react548.default.createElement(Icon, {
      source: icon
    }));
  } else if (image) {
    prefixMarkup = import_react548.default.createElement("span", {
      role: "presentation",
      className: styles8.Prefix,
      style: {
        backgroundImage: `url(${image}`
      }
    });
  }
  let contentText = content || "";
  if (truncate && content) {
    contentText = import_react548.default.createElement(TruncateText, null, content);
  } else if (ellipsis) {
    contentText = `${content}…`;
  }
  const contentMarkup = helpText ? import_react548.default.createElement(import_react548.default.Fragment, null, import_react548.default.createElement(Box, null, contentText), import_react548.default.createElement(Text, {
    color: "subdued",
    as: "span"
  }, helpText)) : contentText;
  const badgeMarkup = badge && import_react548.default.createElement("span", {
    className: styles8.Suffix
  }, import_react548.default.createElement(Badge, {
    status: badge.status
  }, badge.content));
  const suffixMarkup = suffix && import_react548.default.createElement(Box, null, import_react548.default.createElement("span", {
    className: styles8.Suffix
  }, suffix));
  const textMarkup = import_react548.default.createElement("span", {
    className: styles8.Text
  }, contentMarkup);
  const contentElement = import_react548.default.createElement(HorizontalStack, {
    blockAlign: "center",
    gap: "4",
    wrap: !truncate
  }, prefixMarkup, textMarkup, badgeMarkup, suffixMarkup);
  const scrollMarkup = active ? import_react548.default.createElement(Scrollable.ScrollTo, null) : null;
  const control = url ? import_react548.default.createElement(UnstyledLink, {
    id,
    url: disabled ? null : url,
    className,
    external,
    "aria-label": accessibilityLabel,
    onClick: disabled ? null : onAction,
    role
  }, contentElement) : import_react548.default.createElement("button", {
    id,
    type: "button",
    className,
    disabled,
    "aria-label": accessibilityLabel,
    onClick: onAction,
    onMouseUp: handleMouseUpByBlurring,
    role,
    onMouseEnter
  }, contentElement);
  return import_react548.default.createElement(import_react548.default.Fragment, null, scrollMarkup, control);
}
var TruncateText = ({
  children: children2
}) => {
  const textRef = (0, import_react548.useRef)(null);
  const [isOverflowing, setIsOverflowing] = (0, import_react548.useState)(false);
  useIsomorphicLayoutEffect(() => {
    if (textRef.current) {
      setIsOverflowing(textRef.current.scrollWidth > textRef.current.offsetWidth);
    }
  }, [children2]);
  const text = import_react548.default.createElement(Text, {
    as: "span",
    truncate: true
  }, import_react548.default.createElement(Box, {
    width: "100%",
    ref: textRef
  }, children2));
  return isOverflowing ? import_react548.default.createElement(Tooltip, {
    zIndexOverride: Number(zIndex2["z-6"]),
    preferredPosition: "above",
    hoverDelay: 1e3,
    content: children2
  }, import_react548.default.createElement(Text, {
    as: "span",
    truncate: true
  }, children2)) : text;
};

// ../node_modules/@shopify/polaris/build/esm/components/ActionList/components/Section/Section.js
function Section2({
  section,
  hasMultipleSections,
  isFirst,
  actionRole,
  onActionAnyItem
}) {
  const handleAction = (itemOnAction) => {
    return () => {
      if (itemOnAction) {
        itemOnAction();
      }
      if (onActionAnyItem) {
        onActionAnyItem();
      }
    };
  };
  const actionMarkup = section.items.map(({
    content,
    helpText,
    onAction,
    ...item
  }, index) => {
    return import_react549.default.createElement("li", {
      key: `${content}-${index}`,
      role: actionRole === "menuitem" ? "presentation" : void 0
    }, import_react549.default.createElement(Item, Object.assign({
      content,
      helpText,
      role: actionRole,
      onAction: handleAction(onAction)
    }, item)));
  });
  let titleMarkup = null;
  if (section.title) {
    titleMarkup = typeof section.title === "string" ? import_react549.default.createElement(Box, {
      paddingBlockStart: "4",
      paddingInlineStart: "4",
      paddingBlockEnd: "2",
      paddingInlineEnd: "4"
    }, import_react549.default.createElement(Text, {
      as: "p",
      variant: "headingXs"
    }, section.title)) : import_react549.default.createElement(Box, {
      padding: "2"
    }, section.title);
  }
  let sectionRole;
  switch (actionRole) {
    case "option":
      sectionRole = "presentation";
      break;
    case "menuitem":
      sectionRole = !hasMultipleSections ? "menu" : "presentation";
      break;
    default:
      sectionRole = void 0;
      break;
  }
  const sectionMarkup = import_react549.default.createElement(import_react549.default.Fragment, null, titleMarkup, import_react549.default.createElement(Box, Object.assign({
    as: "ul",
    padding: "2"
  }, hasMultipleSections && {
    paddingBlockStart: "0"
  }, sectionRole && {
    role: sectionRole
  }, {
    tabIndex: !hasMultipleSections ? -1 : void 0
  }), actionMarkup));
  return hasMultipleSections ? import_react549.default.createElement(Box, Object.assign({
    as: "li",
    role: "presentation",
    borderColor: "border-subdued"
  }, !isFirst && {
    borderBlockStartWidth: "1"
  }, !section.title && {
    paddingBlockStart: "2"
  }), sectionMarkup) : sectionMarkup;
}

// ../node_modules/@shopify/polaris/build/esm/components/ActionList/ActionList.js
function ActionList({
  items,
  sections = [],
  actionRole,
  onActionAnyItem
}) {
  let finalSections = [];
  const actionListRef = (0, import_react550.useRef)(null);
  if (items) {
    finalSections = [{
      items
    }, ...sections];
  } else if (sections) {
    finalSections = sections;
  }
  const hasMultipleSections = finalSections.length > 1;
  const elementRole = hasMultipleSections && actionRole === "menuitem" ? "menu" : void 0;
  const elementTabIndex = hasMultipleSections && actionRole === "menuitem" ? -1 : void 0;
  const sectionMarkup = finalSections.map((section, index) => {
    return section.items.length > 0 ? import_react550.default.createElement(Section2, {
      key: typeof section.title === "string" ? section.title : index,
      section,
      hasMultipleSections,
      actionRole,
      onActionAnyItem,
      isFirst: index === 0
    }) : null;
  });
  const handleFocusPreviousItem = (evt) => {
    evt.preventDefault();
    if (actionListRef.current && evt.target) {
      if (actionListRef.current.contains(evt.target)) {
        wrapFocusPreviousFocusableMenuItem(actionListRef.current, evt.target);
      }
    }
  };
  const handleFocusNextItem = (evt) => {
    evt.preventDefault();
    if (actionListRef.current && evt.target) {
      if (actionListRef.current.contains(evt.target)) {
        wrapFocusNextFocusableMenuItem(actionListRef.current, evt.target);
      }
    }
  };
  const listeners = actionRole === "menuitem" ? import_react550.default.createElement(import_react550.default.Fragment, null, import_react550.default.createElement(KeypressListener, {
    keyEvent: "keydown",
    keyCode: Key.DownArrow,
    handler: handleFocusNextItem
  }), import_react550.default.createElement(KeypressListener, {
    keyEvent: "keydown",
    keyCode: Key.UpArrow,
    handler: handleFocusPreviousItem
  })) : null;
  return import_react550.default.createElement(Box, {
    as: hasMultipleSections ? "ul" : "div",
    ref: actionListRef,
    role: elementRole,
    tabIndex: elementTabIndex
  }, listeners, sectionMarkup);
}
ActionList.Item = Item;

// ../node_modules/@shopify/polaris/build/esm/components/UnstyledButton/UnstyledButton.js
var import_react551 = __toESM(require_react());
function UnstyledButton({
  id,
  children: children2,
  className,
  url,
  external,
  target,
  download,
  submit,
  disabled,
  loading,
  pressed,
  accessibilityLabel,
  role,
  ariaControls,
  ariaExpanded,
  ariaDescribedBy,
  ariaChecked,
  onClick,
  onFocus,
  onBlur,
  onKeyDown,
  onKeyPress,
  onKeyUp,
  onMouseEnter,
  onTouchStart,
  ...rest
}) {
  let buttonMarkup;
  const commonProps = {
    id,
    className,
    "aria-label": accessibilityLabel
  };
  const interactiveProps = {
    ...commonProps,
    role,
    onClick,
    onFocus,
    onBlur,
    onMouseUp: handleMouseUpByBlurring,
    onMouseEnter,
    onTouchStart
  };
  const handleClick = useDisableClick(disabled, onClick);
  if (url) {
    buttonMarkup = disabled ? (
      // Render an `<a>` so toggling disabled/enabled state changes only the
      // `href` attribute instead of replacing the whole element.
      import_react551.default.createElement("a", commonProps, children2)
    ) : import_react551.default.createElement(UnstyledLink, Object.assign({}, interactiveProps, {
      url,
      external,
      target,
      download
    }, rest), children2);
  } else {
    buttonMarkup = import_react551.default.createElement("button", Object.assign({}, interactiveProps, {
      "aria-disabled": disabled,
      type: submit ? "submit" : "button",
      "aria-busy": loading ? true : void 0,
      "aria-controls": ariaControls,
      "aria-expanded": ariaExpanded,
      "aria-describedby": ariaDescribedBy,
      "aria-checked": ariaChecked,
      "aria-pressed": pressed,
      onKeyDown,
      onKeyUp,
      onKeyPress,
      onClick: handleClick,
      tabIndex: disabled ? -1 : void 0
    }, rest), children2);
  }
  return buttonMarkup;
}

// ../node_modules/@shopify/polaris/build/esm/components/Button/Button.js
var DEFAULT_SIZE2 = "medium";
function Button({
  id,
  children: children2,
  url,
  disabled,
  external,
  download,
  target,
  submit,
  loading,
  pressed,
  accessibilityLabel,
  role,
  ariaControls,
  ariaExpanded,
  ariaDescribedBy,
  ariaChecked,
  onClick,
  onFocus,
  onBlur,
  onKeyDown,
  onKeyPress,
  onKeyUp,
  onMouseEnter,
  onTouchStart,
  onPointerDown,
  icon,
  primary,
  outline,
  destructive,
  disclosure,
  plain,
  monochrome,
  removeUnderline,
  size = DEFAULT_SIZE2,
  textAlign,
  fullWidth,
  connectedDisclosure,
  dataPrimaryLink
}) {
  const i18n = useI18n();
  const isDisabled = disabled || loading;
  const className = classNames(styles.Button, primary && styles.primary, outline && styles.outline, destructive && styles.destructive, primary && plain && styles.primaryPlain, isDisabled && styles.disabled, loading && styles.loading, plain && !primary && styles.plain, pressed && !disabled && !url && styles.pressed, monochrome && styles.monochrome, size && size !== DEFAULT_SIZE2 && styles[variationName("size", size)], textAlign && styles[variationName("textAlign", textAlign)], fullWidth && styles.fullWidth, icon && children2 == null && styles.iconOnly, connectedDisclosure && styles.connectedDisclosure, removeUnderline && styles.removeUnderline);
  const disclosureMarkup = disclosure ? import_react552.default.createElement("span", {
    className: styles.Icon
  }, import_react552.default.createElement("div", {
    className: classNames(styles.DisclosureIcon, loading && styles.hidden)
  }, import_react552.default.createElement(Icon, {
    source: loading ? "placeholder" : getDisclosureIconSource(disclosure)
  }))) : null;
  const iconSource = isIconSource(icon) ? import_react552.default.createElement(Icon, {
    source: loading ? "placeholder" : icon
  }) : icon;
  const iconMarkup = iconSource ? import_react552.default.createElement("span", {
    className: classNames(styles.Icon, loading && styles.hidden)
  }, iconSource) : null;
  const childMarkup = children2 ? import_react552.default.createElement("span", {
    className: classNames(styles.Text, removeUnderline && styles.removeUnderline),
    key: disabled ? "text-disabled" : "text"
  }, children2) : null;
  const spinnerSVGMarkup = loading ? import_react552.default.createElement("span", {
    className: styles.Spinner
  }, import_react552.default.createElement(Spinner, {
    size: "small",
    accessibilityLabel: i18n.translate("Polaris.Button.spinnerAccessibilityLabel")
  })) : null;
  const [disclosureActive, setDisclosureActive] = (0, import_react552.useState)(false);
  const toggleDisclosureActive = (0, import_react552.useCallback)(() => {
    setDisclosureActive((disclosureActive2) => !disclosureActive2);
  }, []);
  const handleClick = useDisableClick(disabled, toggleDisclosureActive);
  let connectedDisclosureMarkup;
  if (connectedDisclosure) {
    const connectedDisclosureClassName = classNames(styles.Button, primary && styles.primary, outline && styles.outline, size && size !== DEFAULT_SIZE2 && styles[variationName("size", size)], textAlign && styles[variationName("textAlign", textAlign)], destructive && styles.destructive, connectedDisclosure.disabled && styles.disabled, styles.iconOnly, styles.ConnectedDisclosure, monochrome && styles.monochrome);
    const defaultLabel = i18n.translate("Polaris.Button.connectedDisclosureAccessibilityLabel");
    const {
      disabled: disabled2,
      accessibilityLabel: disclosureLabel = defaultLabel
    } = connectedDisclosure;
    const connectedDisclosureActivator = import_react552.default.createElement("button", {
      type: "button",
      className: connectedDisclosureClassName,
      "aria-disabled": disabled2,
      "aria-label": disclosureLabel,
      "aria-describedby": ariaDescribedBy,
      "aria-checked": ariaChecked,
      onClick: handleClick,
      onMouseUp: handleMouseUpByBlurring,
      tabIndex: disabled2 ? -1 : void 0
    }, import_react552.default.createElement("span", {
      className: styles.Icon
    }, import_react552.default.createElement(Icon, {
      source: SvgCaretDownMinor
    })));
    connectedDisclosureMarkup = import_react552.default.createElement(Popover2, {
      active: disclosureActive,
      onClose: toggleDisclosureActive,
      activator: connectedDisclosureActivator,
      preferredAlignment: "right"
    }, import_react552.default.createElement(ActionList, {
      items: connectedDisclosure.actions,
      onActionAnyItem: toggleDisclosureActive
    }));
  }
  const commonProps = {
    id,
    className,
    accessibilityLabel,
    ariaDescribedBy,
    role,
    onClick,
    onFocus,
    onBlur,
    onMouseUp: handleMouseUpByBlurring,
    onMouseEnter,
    onTouchStart,
    "data-primary-link": dataPrimaryLink
  };
  const linkProps = {
    url,
    external,
    download,
    target
  };
  const actionProps = {
    submit,
    disabled: isDisabled,
    loading,
    ariaControls,
    ariaExpanded,
    ariaChecked,
    pressed,
    onKeyDown,
    onKeyUp,
    onKeyPress,
    onPointerDown
  };
  const buttonMarkup = import_react552.default.createElement(UnstyledButton, Object.assign({}, commonProps, linkProps, actionProps), import_react552.default.createElement("span", {
    className: styles.Content
  }, spinnerSVGMarkup, iconMarkup, childMarkup, disclosureMarkup));
  return connectedDisclosureMarkup ? import_react552.default.createElement("div", {
    className: styles.ConnectedDisclosureWrapper
  }, buttonMarkup, connectedDisclosureMarkup) : buttonMarkup;
}
function isIconSource(x) {
  return typeof x === "string" || typeof x === "object" && x.body || typeof x === "function";
}
function getDisclosureIconSource(disclosure) {
  if (disclosure === "select") {
    return SvgSelectMinor;
  }
  return disclosure === "up" ? SvgCaretUpMinor : SvgCaretDownMinor;
}

// ../node_modules/@shopify/polaris/build/esm/components/Button/utils.js
function buttonsFrom(actions, overrides = {}) {
  if (Array.isArray(actions)) {
    return actions.map((action, index) => buttonFrom(action, overrides, index));
  } else {
    const action = actions;
    return buttonFrom(action, overrides);
  }
}
function buttonFrom({
  content,
  onAction,
  ...action
}, overrides, key) {
  return import_react553.default.createElement(Button, Object.assign({
    key,
    onClick: onAction
  }, action, overrides), content);
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaCard/AlphaCard.js
var import_react554 = __toESM(require_react());
var AlphaCard = ({
  children: children2,
  background = "bg",
  padding = {
    xs: "4",
    sm: "5"
  },
  roundedAbove
}) => {
  const breakpoints3 = useBreakpoints();
  const defaultBorderRadius = "2";
  let hasBorderRadius = !roundedAbove;
  if (roundedAbove && breakpoints3[`${roundedAbove}Up`]) {
    hasBorderRadius = true;
  }
  return import_react554.default.createElement(Box, {
    background,
    padding,
    shadow: "md",
    borderRadius: hasBorderRadius ? defaultBorderRadius : void 0,
    overflowX: "hidden",
    overflowY: "hidden"
  }, children2);
};

// ../node_modules/@shopify/polaris/build/esm/components/SettingAction/SettingAction.js
var import_react555 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/SettingAction/SettingAction.scss.js
var styles15 = {
  "SettingAction": "Polaris-SettingAction",
  "Setting": "Polaris-SettingAction__Setting",
  "Action": "Polaris-SettingAction__Action"
};

// ../node_modules/@shopify/polaris/build/esm/components/SettingAction/SettingAction.js
function SettingAction({
  action,
  children: children2
}) {
  return import_react555.default.createElement("div", {
    className: styles15.SettingAction
  }, import_react555.default.createElement("div", {
    className: styles15.Setting
  }, children2), import_react555.default.createElement("div", {
    className: styles15.Action
  }, action));
}

// ../node_modules/@shopify/polaris/build/esm/components/VerticalStack/VerticalStack.js
var import_react556 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/VerticalStack/VerticalStack.scss.js
var styles16 = {
  "VerticalStack": "Polaris-VerticalStack",
  "listReset": "Polaris-VerticalStack--listReset",
  "fieldsetReset": "Polaris-VerticalStack--fieldsetReset"
};

// ../node_modules/@shopify/polaris/build/esm/components/VerticalStack/VerticalStack.js
var VerticalStack = ({
  as = "div",
  children: children2,
  align,
  inlineAlign,
  gap,
  id,
  reverseOrder = false,
  ...restProps
}) => {
  const className = classNames(styles16.VerticalStack, (as === "ul" || as === "ol") && styles16.listReset, as === "fieldset" && styles16.fieldsetReset);
  const style = {
    "--pc-vertical-stack-align": align ? `${align}` : "",
    "--pc-vertical-stack-inline-align": inlineAlign ? `${inlineAlign}` : "",
    "--pc-vertical-stack-order": reverseOrder ? "column-reverse" : "column",
    ...getResponsiveProps("vertical-stack", "gap", "space", gap)
  };
  return import_react556.default.createElement(as, {
    className,
    style: sanitizeCustomProperties(style),
    ...restProps
  }, children2);
};

// ../node_modules/@shopify/polaris/build/esm/components/Avatar/Avatar.js
var import_react558 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Avatar/Avatar.scss.js
var styles17 = {
  "Avatar": "Polaris-Avatar",
  "Text": "Polaris-Avatar__Text",
  "long": "Polaris-Avatar--long",
  "shapeRound": "Polaris-Avatar--shapeRound",
  "shapeSquare": "Polaris-Avatar--shapeSquare",
  "hidden": "Polaris-Avatar--hidden",
  "sizeExtraSmall": "Polaris-Avatar--sizeExtraSmall",
  "sizeSmall": "Polaris-Avatar--sizeSmall",
  "sizeMedium": "Polaris-Avatar--sizeMedium",
  "sizeLarge": "Polaris-Avatar--sizeLarge",
  "styleOne": "Polaris-Avatar--styleOne",
  "styleTwo": "Polaris-Avatar--styleTwo",
  "styleThree": "Polaris-Avatar--styleThree",
  "styleFour": "Polaris-Avatar--styleFour",
  "styleFive": "Polaris-Avatar--styleFive",
  "imageHasLoaded": "Polaris-Avatar--imageHasLoaded",
  "Image": "Polaris-Avatar__Image",
  "Initials": "Polaris-Avatar__Initials",
  "Svg": "Polaris-Avatar__Svg"
};

// ../node_modules/@shopify/polaris/build/esm/components/Image/Image.js
var import_react557 = __toESM(require_react());
function Image({
  alt,
  sourceSet,
  source,
  crossOrigin,
  onLoad,
  className,
  ...rest
}) {
  const finalSourceSet = sourceSet ? sourceSet.map(({
    source: subSource,
    descriptor
  }) => `${subSource} ${descriptor}`).join(",") : null;
  const handleLoad = (0, import_react557.useCallback)(() => {
    if (onLoad)
      onLoad();
  }, [onLoad]);
  return import_react557.default.createElement("img", Object.assign({
    alt,
    src: source,
    crossOrigin,
    className,
    onLoad: handleLoad
  }, finalSourceSet ? {
    srcSet: finalSourceSet
  } : {}, rest));
}

// ../node_modules/@shopify/polaris/build/esm/components/Avatar/Avatar.js
var Status;
(function(Status2) {
  Status2["Pending"] = "PENDING";
  Status2["Loaded"] = "LOADED";
  Status2["Errored"] = "ERRORED";
})(Status || (Status = {}));
var STYLE_CLASSES = ["one", "two", "three", "four", "five"];
function xorHash(str) {
  let hash = 0;
  for (const char of str) {
    hash ^= char.charCodeAt(0);
  }
  return hash;
}
function styleClass(name) {
  return name ? STYLE_CLASSES[xorHash(name) % STYLE_CLASSES.length] : STYLE_CLASSES[0];
}
function Avatar({
  name,
  source,
  onError,
  initials,
  customer,
  size = "medium",
  shape: shape2 = "round",
  accessibilityLabel
}) {
  const i18n = useI18n();
  const isAfterInitialMount = useIsAfterInitialMount();
  const [status, setStatus] = (0, import_react558.useState)(Status.Pending);
  (0, import_react558.useEffect)(() => {
    setStatus(Status.Pending);
  }, [source]);
  const handleError = (0, import_react558.useCallback)(() => {
    setStatus(Status.Errored);
    if (onError) {
      onError();
    }
  }, [onError]);
  const handleLoad = (0, import_react558.useCallback)(() => {
    setStatus(Status.Loaded);
  }, []);
  const hasImage = source && status !== Status.Errored;
  const nameString = name || initials;
  let label;
  if (accessibilityLabel) {
    label = accessibilityLabel;
  } else if (name) {
    label = name;
  } else if (initials) {
    const splitInitials = initials.split("").join(" ");
    label = i18n.translate("Polaris.Avatar.labelWithInitials", {
      initials: splitInitials
    });
  } else {
    label = i18n.translate("Polaris.Avatar.label");
  }
  const className = classNames(styles17.Avatar, size && styles17[variationName("size", size)], hasImage && status === Status.Loaded && styles17.imageHasLoaded, shape2 && styles17[variationName("shape", shape2)], !customer && !source && styles17[variationName("style", styleClass(nameString))]);
  const textClassName = classNames(styles17.Text, ((initials === null || initials === void 0 ? void 0 : initials.length) || 0) > 2 && styles17.long);
  const imageClassName = classNames(styles17.Image, status !== Status.Loaded && styles17.hidden);
  const imageMarkUp = source && isAfterInitialMount && status !== Status.Errored ? import_react558.default.createElement(Image, {
    className: imageClassName,
    source,
    alt: "",
    role: "presentation",
    onLoad: handleLoad,
    onError: handleError
  }) : null;
  const verticalOffset = "0.35em";
  const avatarBody = customer || !initials ? import_react558.default.createElement("path", {
    fill: "currentColor",
    d: "M8.28 27.5A14.95 14.95 0 0120 21.8c4.76 0 8.97 2.24 11.72 5.7a14.02 14.02 0 01-8.25 5.91 14.82 14.82 0 01-6.94 0 14.02 14.02 0 01-8.25-5.9zM13.99 12.78a6.02 6.02 0 1112.03 0 6.02 6.02 0 01-12.03 0z"
  }) : import_react558.default.createElement("text", {
    className: textClassName,
    x: "50%",
    y: "50%",
    dy: verticalOffset,
    fill: "currentColor",
    textAnchor: "middle"
  }, initials);
  const svgMarkup = hasImage ? null : import_react558.default.createElement("span", {
    className: styles17.Initials
  }, import_react558.default.createElement("svg", {
    className: styles17.Svg,
    viewBox: "0 0 40 40"
  }, avatarBody));
  return import_react558.default.createElement("span", {
    "aria-label": label,
    role: "img",
    className
  }, svgMarkup, imageMarkUp);
}

// ../node_modules/@shopify/polaris/build/esm/components/AccountConnection/AccountConnection.js
function AccountConnection({
  connected = false,
  action,
  avatarUrl,
  accountName = "",
  title,
  details,
  termsOfService
}) {
  const initials = accountName ? accountName.split(/\s+/).map((name) => name[0]).join("") : void 0;
  const avatarMarkup = connected ? import_react559.default.createElement(Avatar, {
    accessibilityLabel: "",
    name: accountName,
    initials,
    source: avatarUrl
  }) : null;
  const titleMarkup = title ? title : accountName;
  const detailsMarkup = details ? import_react559.default.createElement(Text, {
    as: "span",
    color: "subdued"
  }, details) : null;
  const termsOfServiceMarkup = termsOfService ? import_react559.default.createElement(Box, {
    paddingBlockStart: "5"
  }, termsOfService) : null;
  const actionElement = action ? buttonFrom(action, {
    primary: !connected
  }) : null;
  return import_react559.default.createElement(AlphaCard, null, import_react559.default.createElement(SettingAction, {
    action: actionElement
  }, import_react559.default.createElement(HorizontalStack, {
    gap: "4"
  }, avatarMarkup, import_react559.default.createElement(VerticalStack, {
    gap: "2"
  }, titleMarkup, detailsMarkup))), termsOfServiceMarkup);
}

// ../node_modules/@shopify/polaris/build/esm/components/ActionMenu/ActionMenu.js
var import_react566 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/ActionMenu/ActionMenu.scss.js
var styles18 = {
  "ActionMenu": "Polaris-ActionMenu"
};

// ../node_modules/@shopify/polaris/build/esm/components/ActionMenu/components/RollupActions/RollupActions.js
var import_react560 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/ActionMenu/components/RollupActions/RollupActions.scss.js
var styles19 = {
  "RollupActivator": "Polaris-ActionMenu-RollupActions__RollupActivator"
};

// ../node_modules/@shopify/polaris/build/esm/components/ActionMenu/components/RollupActions/RollupActions.js
function RollupActions({
  accessibilityLabel,
  items = [],
  sections = []
}) {
  const i18n = useI18n();
  const {
    value: rollupOpen,
    toggle: toggleRollupOpen
  } = useToggle(false);
  if (items.length === 0 && sections.length === 0) {
    return null;
  }
  const activatorMarkup = import_react560.default.createElement("div", {
    className: styles19.RollupActivator
  }, import_react560.default.createElement(Button, {
    outline: true,
    icon: SvgHorizontalDotsMinor,
    accessibilityLabel: accessibilityLabel || i18n.translate("Polaris.ActionMenu.RollupActions.rollupButton"),
    onClick: toggleRollupOpen
  }));
  return import_react560.default.createElement(Popover2, {
    active: rollupOpen,
    activator: activatorMarkup,
    preferredAlignment: "right",
    onClose: toggleRollupOpen,
    hideOnPrint: true
  }, import_react560.default.createElement(ActionList, {
    items,
    sections,
    onActionAnyItem: toggleRollupOpen
  }));
}

// ../node_modules/@shopify/polaris/build/esm/components/ActionMenu/components/Actions/Actions.js
var import_react565 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/ActionMenu/components/Actions/Actions.scss.js
var styles20 = {
  "ActionsLayout": "Polaris-ActionMenu-Actions__ActionsLayout"
};

// ../node_modules/@shopify/polaris/build/esm/components/ActionMenu/components/MenuGroup/MenuGroup.js
var import_react562 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/ActionMenu/components/MenuGroup/MenuGroup.scss.js
var styles21 = {
  "Details": "Polaris-ActionMenu-MenuGroup__Details"
};

// ../node_modules/@shopify/polaris/build/esm/components/ActionMenu/components/SecondaryAction/SecondaryAction.js
var import_react561 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/ActionMenu/components/SecondaryAction/SecondaryAction.scss.js
var styles22 = {
  "SecondaryAction": "Polaris-ActionMenu-SecondaryAction",
  "destructive": "Polaris-ActionMenu-SecondaryAction--destructive"
};

// ../node_modules/@shopify/polaris/build/esm/components/ActionMenu/components/SecondaryAction/SecondaryAction.js
function SecondaryAction({
  children: children2,
  destructive,
  helpText,
  onAction,
  getOffsetWidth,
  ...rest
}) {
  const secondaryActionsRef = (0, import_react561.useRef)(null);
  (0, import_react561.useEffect)(() => {
    var _secondaryActionsRef$;
    if (!getOffsetWidth || !secondaryActionsRef.current)
      return;
    getOffsetWidth((_secondaryActionsRef$ = secondaryActionsRef.current) === null || _secondaryActionsRef$ === void 0 ? void 0 : _secondaryActionsRef$.offsetWidth);
  }, [getOffsetWidth]);
  const buttonMarkup = import_react561.default.createElement(Button, Object.assign({
    onClick: onAction
  }, rest), children2);
  const actionMarkup = helpText ? import_react561.default.createElement(Tooltip, {
    content: helpText
  }, buttonMarkup) : buttonMarkup;
  return import_react561.default.createElement("span", {
    className: classNames(styles22.SecondaryAction, destructive && styles22.destructive),
    ref: secondaryActionsRef
  }, actionMarkup);
}

// ../node_modules/@shopify/polaris/build/esm/components/ActionMenu/components/MenuGroup/MenuGroup.js
function MenuGroup({
  accessibilityLabel,
  active,
  actions,
  details,
  title,
  icon,
  disabled,
  onClick,
  onClose,
  onOpen,
  getOffsetWidth,
  sections
}) {
  const handleClose = (0, import_react562.useCallback)(() => {
    onClose(title);
  }, [onClose, title]);
  const handleOpen = (0, import_react562.useCallback)(() => {
    onOpen(title);
  }, [onOpen, title]);
  const handleClick = (0, import_react562.useCallback)(() => {
    if (onClick) {
      onClick(handleOpen);
    } else {
      handleOpen();
    }
  }, [onClick, handleOpen]);
  const handleOffsetWidth = (0, import_react562.useCallback)((width) => {
    if (!getOffsetWidth)
      return;
    getOffsetWidth(width);
  }, [getOffsetWidth]);
  const popoverActivator = import_react562.default.createElement(SecondaryAction, {
    disclosure: true,
    disabled,
    icon,
    accessibilityLabel,
    onClick: handleClick,
    getOffsetWidth: handleOffsetWidth
  }, title);
  return import_react562.default.createElement(Popover2, {
    active: Boolean(active),
    activator: popoverActivator,
    preferredAlignment: "left",
    onClose: handleClose,
    hideOnPrint: true
  }, import_react562.default.createElement(ActionList, {
    items: actions,
    sections,
    onActionAnyItem: handleClose
  }), details && import_react562.default.createElement("div", {
    className: styles21.Details
  }, details));
}

// ../node_modules/@shopify/polaris/build/esm/components/ButtonGroup/ButtonGroup.js
var import_react564 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/ButtonGroup/ButtonGroup.scss.js
var styles23 = {
  "ButtonGroup": "Polaris-ButtonGroup",
  "Item": "Polaris-ButtonGroup__Item",
  "Item-plain": "Polaris-ButtonGroup__Item--plain",
  "segmented": "Polaris-ButtonGroup--segmented",
  "Item-focused": "Polaris-ButtonGroup__Item--focused",
  "fullWidth": "Polaris-ButtonGroup--fullWidth",
  "extraTight": "Polaris-ButtonGroup--extraTight",
  "tight": "Polaris-ButtonGroup--tight",
  "loose": "Polaris-ButtonGroup--loose",
  "noWrap": "Polaris-ButtonGroup--noWrap"
};

// ../node_modules/@shopify/polaris/build/esm/components/ButtonGroup/components/Item/Item.js
var import_react563 = __toESM(require_react());
function Item2({
  button
}) {
  const {
    value: focused,
    setTrue: forceTrueFocused,
    setFalse: forceFalseFocused
  } = useToggle(false);
  const className = classNames(styles23.Item, focused && styles23["Item-focused"], button.props.plain && styles23["Item-plain"]);
  return import_react563.default.createElement("div", {
    className,
    onFocus: forceTrueFocused,
    onBlur: forceFalseFocused
  }, button);
}

// ../node_modules/@shopify/polaris/build/esm/components/ButtonGroup/ButtonGroup.js
function ButtonGroup({
  children: children2,
  spacing: spacing2,
  segmented,
  fullWidth,
  connectedTop,
  noWrap
}) {
  const className = classNames(styles23.ButtonGroup, spacing2 && styles23[spacing2], segmented && styles23.segmented, fullWidth && styles23.fullWidth, noWrap && styles23.noWrap);
  const contents = elementChildren(children2).map((child, index) => import_react564.default.createElement(Item2, {
    button: child,
    key: index
  }));
  return import_react564.default.createElement("div", {
    className,
    "data-buttongroup-segmented": segmented,
    "data-buttongroup-connected-top": connectedTop,
    "data-buttongroup-full-width": fullWidth,
    "data-buttongroup-no-wrap": noWrap
  }, contents);
}

// ../node_modules/@shopify/polaris/build/esm/components/ActionMenu/components/Actions/Actions.js
var ACTION_SPACING = 8;
function Actions({
  actions = [],
  groups = [],
  onActionRollup
}) {
  const i18n = useI18n();
  const actionsLayoutRef = (0, import_react565.useRef)(null);
  const menuGroupWidthRef = (0, import_react565.useRef)(0);
  const availableWidthRef = (0, import_react565.useRef)(0);
  const actionsAndGroupsLengthRef = (0, import_react565.useRef)(0);
  const timesMeasured = (0, import_react565.useRef)(0);
  const actionWidthsRef = (0, import_react565.useRef)([]);
  const rollupActiveRef = (0, import_react565.useRef)(null);
  const [activeMenuGroup, setActiveMenuGroup] = (0, import_react565.useState)(void 0);
  const [measuredActions, setMeasuredActions] = (0, import_react565.useState)({
    showable: [],
    rolledUp: []
  });
  const defaultRollupGroup = {
    title: i18n.translate("Polaris.ActionMenu.Actions.moreActions"),
    actions: []
  };
  const lastMenuGroup = [...groups].pop();
  const lastMenuGroupWidth = [...actionWidthsRef.current].pop() || 0;
  const handleActionsOffsetWidth = (0, import_react565.useCallback)((width) => {
    actionWidthsRef.current = [...actionWidthsRef.current, width];
  }, []);
  const handleMenuGroupToggle = (0, import_react565.useCallback)((group) => setActiveMenuGroup(activeMenuGroup ? void 0 : group), [activeMenuGroup]);
  const handleMenuGroupClose = (0, import_react565.useCallback)(() => setActiveMenuGroup(void 0), []);
  const updateActions = (0, import_react565.useCallback)(() => {
    let actionsAndGroups = [...actions, ...groups];
    if (groups.length > 0) {
      actionsAndGroups = [...actionsAndGroups].slice(0, actionsAndGroups.length - 1);
    }
    setMeasuredActions((currentMeasuredActions) => {
      const showable = actionsAndGroups.slice(0, currentMeasuredActions.showable.length);
      const rolledUp = actionsAndGroups.slice(currentMeasuredActions.showable.length, actionsAndGroups.length);
      return {
        showable,
        rolledUp
      };
    });
  }, [actions, groups]);
  const measureActions = (0, import_react565.useCallback)(() => {
    if (actionWidthsRef.current.length === 0 || availableWidthRef.current === 0) {
      return;
    }
    const actionsAndGroups = [...actions, ...groups];
    if (actionsAndGroups.length === 1) {
      setMeasuredActions({
        showable: actionsAndGroups,
        rolledUp: []
      });
      return;
    }
    let currentAvailableWidth = availableWidthRef.current;
    let newShowableActions = [];
    let newRolledUpActions = [];
    actionsAndGroups.forEach((action, index) => {
      const canFitAction = actionWidthsRef.current[index] + menuGroupWidthRef.current + ACTION_SPACING + lastMenuGroupWidth <= currentAvailableWidth;
      if (canFitAction) {
        currentAvailableWidth -= actionWidthsRef.current[index] + ACTION_SPACING * 2;
        newShowableActions = [...newShowableActions, action];
      } else {
        currentAvailableWidth = 0;
        if (action === lastMenuGroup)
          return;
        newRolledUpActions = [...newRolledUpActions, action];
      }
    });
    if (onActionRollup) {
      const isRollupActive = newShowableActions.length < actionsAndGroups.length - 1;
      if (rollupActiveRef.current !== isRollupActive) {
        onActionRollup(isRollupActive);
        rollupActiveRef.current = isRollupActive;
      }
    }
    setMeasuredActions({
      showable: newShowableActions,
      rolledUp: newRolledUpActions
    });
    timesMeasured.current += 1;
    actionsAndGroupsLengthRef.current = actionsAndGroups.length;
  }, [actions, groups, lastMenuGroup, lastMenuGroupWidth, onActionRollup]);
  const handleResize = (0, import_react565.useMemo)(() => debounce(() => {
    if (!actionsLayoutRef.current)
      return;
    availableWidthRef.current = actionsLayoutRef.current.offsetWidth;
    timesMeasured.current = 0;
    measureActions();
  }, 50, {
    leading: false,
    trailing: true
  }), [measureActions]);
  useEventListener("resize", handleResize);
  useIsomorphicLayoutEffect(() => {
    if (!actionsLayoutRef.current)
      return;
    availableWidthRef.current = actionsLayoutRef.current.offsetWidth;
    if (
      // Allow measuring twice
      // This accounts for the initial paint and re-flow
      timesMeasured.current >= 2 && [...actions, ...groups].length === actionsAndGroupsLengthRef.current
    ) {
      updateActions();
      return;
    }
    measureActions();
  }, [actions, groups, measureActions, updateActions]);
  const actionsMarkup = actions.map((action) => {
    if (measuredActions.showable.length > 0 || measuredActions.rolledUp.includes(action))
      return null;
    const {
      content,
      onAction,
      ...rest
    } = action;
    return import_react565.default.createElement(SecondaryAction, Object.assign({
      key: content,
      onClick: onAction
    }, rest, {
      getOffsetWidth: handleActionsOffsetWidth
    }), content);
  });
  const rollUppableActionsMarkup = measuredActions.showable.length > 0 ? measuredActions.showable.map((action) => action.content && import_react565.default.createElement(SecondaryAction, Object.assign({
    key: action.content
  }, action, {
    getOffsetWidth: handleActionsOffsetWidth
  }), action.content)) : null;
  const filteredGroups = [...groups, defaultRollupGroup].filter((group) => {
    return groups.length === 0 ? group : group === lastMenuGroup || !measuredActions.rolledUp.some((rolledUpGroup) => isMenuGroup(rolledUpGroup) && rolledUpGroup.title === group.title);
  });
  const groupsMarkup = filteredGroups.map((group) => {
    const {
      title,
      actions: groupActions,
      ...rest
    } = group;
    const isDefaultGroup = group === defaultRollupGroup;
    const isLastMenuGroup = group === lastMenuGroup;
    const [finalRolledUpActions, finalRolledUpSectionGroups] = measuredActions.rolledUp.reduce(([actions2, sections], action) => {
      if (isMenuGroup(action)) {
        sections.push({
          title: action.title,
          items: action.actions.map((sectionAction) => ({
            ...sectionAction,
            disabled: action.disabled || sectionAction.disabled
          }))
        });
      } else {
        actions2.push(action);
      }
      return [actions2, sections];
    }, [[], []]);
    if (!isDefaultGroup && !isLastMenuGroup) {
      return import_react565.default.createElement(MenuGroup, Object.assign({
        key: title,
        title,
        active: title === activeMenuGroup,
        actions: groupActions
      }, rest, {
        onOpen: handleMenuGroupToggle,
        onClose: handleMenuGroupClose,
        getOffsetWidth: handleActionsOffsetWidth
      }));
    } else if (!isDefaultGroup && isLastMenuGroup) {
      return import_react565.default.createElement(MenuGroup, Object.assign({
        key: title,
        title,
        active: title === activeMenuGroup,
        actions: [...finalRolledUpActions, ...groupActions],
        sections: finalRolledUpSectionGroups
      }, rest, {
        onOpen: handleMenuGroupToggle,
        onClose: handleMenuGroupClose,
        getOffsetWidth: handleActionsOffsetWidth
      }));
    } else if (isDefaultGroup && groups.length === 0 && finalRolledUpActions.length) {
      return import_react565.default.createElement(MenuGroup, Object.assign({
        key: title,
        title,
        active: title === activeMenuGroup,
        actions: finalRolledUpActions,
        sections: finalRolledUpSectionGroups
      }, rest, {
        onOpen: handleMenuGroupToggle,
        onClose: handleMenuGroupClose,
        getOffsetWidth: handleActionsOffsetWidth
      }));
    }
  });
  const groupedActionsMarkup = import_react565.default.createElement(ButtonGroup, {
    spacing: "extraTight"
  }, rollUppableActionsMarkup, actionsMarkup, groupsMarkup);
  return import_react565.default.createElement("div", {
    className: styles20.ActionsLayout,
    ref: actionsLayoutRef
  }, groupedActionsMarkup);
}
function isMenuGroup(actionOrMenuGroup) {
  return "title" in actionOrMenuGroup;
}

// ../node_modules/@shopify/polaris/build/esm/components/ActionMenu/ActionMenu.js
function ActionMenu({
  actions = [],
  groups = [],
  rollup,
  rollupActionsLabel,
  onActionRollup
}) {
  if (actions.length === 0 && groups.length === 0) {
    return null;
  }
  const actionMenuClassNames = classNames(styles18.ActionMenu, rollup && styles18.rollup);
  const rollupSections = groups.map((group) => convertGroupToSection(group));
  return import_react566.default.createElement("div", {
    className: actionMenuClassNames
  }, rollup ? import_react566.default.createElement(RollupActions, {
    accessibilityLabel: rollupActionsLabel,
    items: actions,
    sections: rollupSections
  }) : import_react566.default.createElement(Actions, {
    actions,
    groups,
    onActionRollup
  }));
}
function hasGroupsWithActions(groups = []) {
  return groups.length === 0 ? false : groups.some((group) => group.actions.length > 0);
}
function convertGroupToSection({
  title,
  actions,
  disabled
}) {
  return {
    title,
    items: actions.map((action) => ({
      ...action,
      disabled: disabled || action.disabled
    }))
  };
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaFilters/AlphaFilters.js
var import_react577 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/AlphaFilters/AlphaFilters.scss.js
var styles24 = {
  "Container": "Polaris-AlphaFilters__Container",
  "SearchField": "Polaris-AlphaFilters__SearchField",
  "Spinner": "Polaris-AlphaFilters__Spinner",
  "FiltersWrapper": "Polaris-AlphaFilters__FiltersWrapper",
  "hideQueryField": "Polaris-AlphaFilters--hideQueryField",
  "FiltersInner": "Polaris-AlphaFilters__FiltersInner",
  "AddFilter": "Polaris-AlphaFilters__AddFilter",
  "FiltersWrapperWithAddButton": "Polaris-AlphaFilters__FiltersWrapperWithAddButton",
  "AddFilterActivatorMultiple": "Polaris-AlphaFilters__AddFilterActivatorMultiple",
  "FiltersStickyArea": "Polaris-AlphaFilters__FiltersStickyArea",
  "ClearAll": "Polaris-AlphaFilters__ClearAll",
  "MultiplePinnedFilterClearAll": "Polaris-AlphaFilters__MultiplePinnedFilterClearAll"
};

// ../node_modules/@shopify/polaris/build/esm/components/AlphaFilters/components/SearchField/SearchField.js
var import_react575 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/TextField/TextField.js
var import_react574 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/TextField/TextField.scss.js
var styles25 = {
  "TextField": "Polaris-TextField",
  "ClearButton": "Polaris-TextField__ClearButton",
  "multiline": "Polaris-TextField--multiline",
  "Input": "Polaris-TextField__Input",
  "hasValue": "Polaris-TextField--hasValue",
  "focus": "Polaris-TextField--focus",
  "VerticalContent": "Polaris-TextField__VerticalContent",
  "Backdrop": "Polaris-TextField__Backdrop",
  "error": "Polaris-TextField--error",
  "readOnly": "Polaris-TextField--readOnly",
  "disabled": "Polaris-TextField--disabled",
  "Prefix": "Polaris-TextField__Prefix",
  "suggestion": "Polaris-TextField--suggestion",
  "borderless": "Polaris-TextField--borderless",
  "Input-hasClearButton": "Polaris-TextField__Input--hasClearButton",
  "Input-suffixed": "Polaris-TextField__Input--suffixed",
  "Input-alignRight": "Polaris-TextField__Input--alignRight",
  "Input-alignLeft": "Polaris-TextField__Input--alignLeft",
  "Input-alignCenter": "Polaris-TextField__Input--alignCenter",
  "Suffix": "Polaris-TextField__Suffix",
  "CharacterCount": "Polaris-TextField__CharacterCount",
  "AlignFieldBottom": "Polaris-TextField__AlignFieldBottom",
  "Spinner": "Polaris-TextField__Spinner",
  "SpinnerIcon": "Polaris-TextField__SpinnerIcon",
  "Resizer": "Polaris-TextField__Resizer",
  "DummyInput": "Polaris-TextField__DummyInput",
  "Segment": "Polaris-TextField__Segment",
  "monospaced": "Polaris-TextField--monospaced"
};

// ../node_modules/@shopify/polaris/build/esm/components/TextField/components/Spinner/Spinner.js
var import_react567 = __toESM(require_react());
var Spinner2 = import_react567.default.forwardRef(function Spinner3({
  onChange,
  onClick,
  onMouseDown,
  onMouseUp,
  onBlur
}, ref) {
  function handleStep(step) {
    return () => onChange(step);
  }
  function handleMouseDown(onChange2) {
    return (event) => {
      if (event.button !== 0)
        return;
      onMouseDown(onChange2);
    };
  }
  return import_react567.default.createElement("div", {
    className: styles25.Spinner,
    onClick,
    "aria-hidden": true,
    ref
  }, import_react567.default.createElement("div", {
    role: "button",
    className: styles25.Segment,
    tabIndex: -1,
    onClick: handleStep(1),
    onMouseDown: handleMouseDown(handleStep(1)),
    onMouseUp,
    onBlur
  }, import_react567.default.createElement("div", {
    className: styles25.SpinnerIcon
  }, import_react567.default.createElement(Icon, {
    source: SvgCaretUpMinor
  }))), import_react567.default.createElement("div", {
    role: "button",
    className: styles25.Segment,
    tabIndex: -1,
    onClick: handleStep(-1),
    onMouseDown: handleMouseDown(handleStep(-1)),
    onMouseUp,
    onBlur
  }, import_react567.default.createElement("div", {
    className: styles25.SpinnerIcon
  }, import_react567.default.createElement(Icon, {
    source: SvgCaretDownMinor
  }))));
});

// ../node_modules/@shopify/polaris/build/esm/components/Labelled/Labelled.js
var import_react570 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Labelled/Labelled.scss.js
var styles26 = {
  "hidden": "Polaris-Labelled--hidden",
  "LabelWrapper": "Polaris-Labelled__LabelWrapper",
  "HelpText": "Polaris-Labelled__HelpText",
  "Error": "Polaris-Labelled__Error",
  "Action": "Polaris-Labelled__Action"
};

// ../node_modules/@shopify/polaris/build/esm/components/InlineError/InlineError.js
var import_react568 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/InlineError/InlineError.scss.js
var styles27 = {
  "InlineError": "Polaris-InlineError",
  "Icon": "Polaris-InlineError__Icon"
};

// ../node_modules/@shopify/polaris/build/esm/components/InlineError/InlineError.js
function InlineError({
  message,
  fieldID
}) {
  if (!message) {
    return null;
  }
  return import_react568.default.createElement("div", {
    id: errorTextID(fieldID),
    className: styles27.InlineError
  }, import_react568.default.createElement("div", {
    className: styles27.Icon
  }, import_react568.default.createElement(Icon, {
    source: SvgDiamondAlertMinor
  })), message);
}
function errorTextID(id) {
  return `${id}Error`;
}

// ../node_modules/@shopify/polaris/build/esm/components/Label/Label.js
var import_react569 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Label/Label.scss.js
var styles28 = {
  "Label": "Polaris-Label",
  "hidden": "Polaris-Label--hidden",
  "Text": "Polaris-Label__Text",
  "RequiredIndicator": "Polaris-Label__RequiredIndicator"
};

// ../node_modules/@shopify/polaris/build/esm/components/Label/Label.js
function labelID(id) {
  return `${id}Label`;
}
function Label({
  children: children2,
  id,
  hidden,
  requiredIndicator
}) {
  const className = classNames(styles28.Label, hidden && styles28.hidden);
  return import_react569.default.createElement("div", {
    className
  }, import_react569.default.createElement("label", {
    id: labelID(id),
    htmlFor: id,
    className: classNames(styles28.Text, requiredIndicator && styles28.RequiredIndicator)
  }, children2));
}

// ../node_modules/@shopify/polaris/build/esm/components/Labelled/Labelled.js
function Labelled({
  id,
  label,
  error,
  action,
  helpText,
  children: children2,
  labelHidden,
  requiredIndicator,
  ...rest
}) {
  const className = classNames(labelHidden && styles26.hidden);
  const actionMarkup = action ? import_react570.default.createElement("div", {
    className: styles26.Action
  }, buttonFrom(action, {
    plain: true
  })) : null;
  const helpTextMarkup = helpText ? import_react570.default.createElement("div", {
    className: styles26.HelpText,
    id: helpTextID(id)
  }, import_react570.default.createElement(Text, {
    as: "span",
    color: "subdued",
    breakWord: true
  }, helpText)) : null;
  const errorMarkup = error && typeof error !== "boolean" && import_react570.default.createElement("div", {
    className: styles26.Error
  }, import_react570.default.createElement(InlineError, {
    message: error,
    fieldID: id
  }));
  const labelMarkup = label ? import_react570.default.createElement("div", {
    className: styles26.LabelWrapper
  }, import_react570.default.createElement(Label, Object.assign({
    id,
    requiredIndicator
  }, rest, {
    hidden: false
  }), label), actionMarkup) : null;
  return import_react570.default.createElement("div", {
    className
  }, labelMarkup, children2, errorMarkup, helpTextMarkup);
}
function helpTextID(id) {
  return `${id}HelpText`;
}

// ../node_modules/@shopify/polaris/build/esm/components/Connected/Connected.js
var import_react572 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Connected/Connected.scss.js
var styles29 = {
  "Connected": "Polaris-Connected",
  "Item": "Polaris-Connected__Item",
  "Item-primary": "Polaris-Connected__Item--primary",
  "Item-focused": "Polaris-Connected__Item--focused"
};

// ../node_modules/@shopify/polaris/build/esm/components/Connected/components/Item/Item.js
var import_react571 = __toESM(require_react());
function Item3({
  children: children2,
  position
}) {
  const {
    value: focused,
    setTrue: forceTrueFocused,
    setFalse: forceFalseFocused
  } = useToggle(false);
  const className = classNames(styles29.Item, focused && styles29["Item-focused"], position === "primary" ? styles29["Item-primary"] : styles29["Item-connection"]);
  return import_react571.default.createElement("div", {
    onBlur: forceFalseFocused,
    onFocus: forceTrueFocused,
    className
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/Connected/Connected.js
function Connected({
  children: children2,
  left,
  right
}) {
  const leftConnectionMarkup = left ? import_react572.default.createElement(Item3, {
    position: "left"
  }, left) : null;
  const rightConnectionMarkup = right ? import_react572.default.createElement(Item3, {
    position: "right"
  }, right) : null;
  return import_react572.default.createElement("div", {
    className: styles29.Connected
  }, leftConnectionMarkup, import_react572.default.createElement(Item3, {
    position: "primary"
  }, children2), rightConnectionMarkup);
}

// ../node_modules/@shopify/polaris/build/esm/components/TextField/components/Resizer/Resizer.js
var import_react573 = __toESM(require_react());
function Resizer({
  contents,
  currentHeight: currentHeightProp = null,
  minimumLines,
  onHeightChange
}) {
  const contentNode = (0, import_react573.useRef)(null);
  const minimumLinesNode = (0, import_react573.useRef)(null);
  const animationFrame = (0, import_react573.useRef)();
  const currentHeight = (0, import_react573.useRef)(currentHeightProp);
  if (currentHeightProp !== currentHeight.current) {
    currentHeight.current = currentHeightProp;
  }
  (0, import_react573.useEffect)(() => {
    return () => {
      if (animationFrame.current) {
        cancelAnimationFrame(animationFrame.current);
      }
    };
  }, []);
  const minimumLinesMarkup = minimumLines ? import_react573.default.createElement("div", {
    ref: minimumLinesNode,
    className: styles25.DummyInput,
    dangerouslySetInnerHTML: {
      __html: getContentsForMinimumLines(minimumLines)
    }
  }) : null;
  const handleHeightCheck = (0, import_react573.useCallback)(() => {
    if (animationFrame.current) {
      cancelAnimationFrame(animationFrame.current);
    }
    animationFrame.current = requestAnimationFrame(() => {
      if (!contentNode.current || !minimumLinesNode.current) {
        return;
      }
      const newHeight = Math.max(contentNode.current.offsetHeight, minimumLinesNode.current.offsetHeight);
      if (newHeight !== currentHeight.current) {
        onHeightChange(newHeight);
      }
    });
  }, [onHeightChange]);
  useIsomorphicLayoutEffect(() => {
    handleHeightCheck();
  });
  return import_react573.default.createElement("div", {
    "aria-hidden": true,
    className: styles25.Resizer
  }, import_react573.default.createElement(EventListener, {
    event: "resize",
    handler: handleHeightCheck
  }), import_react573.default.createElement("div", {
    ref: contentNode,
    className: styles25.DummyInput,
    dangerouslySetInnerHTML: {
      __html: getFinalContents(contents)
    }
  }), minimumLinesMarkup);
}
var ENTITIES_TO_REPLACE = {
  "&": "&amp;",
  "<": "&lt;",
  ">": "&gt;",
  "\n": "<br>",
  "\r": ""
};
var REPLACE_REGEX2 = new RegExp(`[${Object.keys(ENTITIES_TO_REPLACE).join()}]`, "g");
function replaceEntity(entity) {
  return ENTITIES_TO_REPLACE[entity];
}
function getContentsForMinimumLines(minimumLines) {
  let content = "";
  for (let line = 0; line < minimumLines; line++) {
    content += "<br>";
  }
  return content;
}
function getFinalContents(contents) {
  return contents ? `${contents.replace(REPLACE_REGEX2, replaceEntity)}<br>` : "<br>";
}

// ../node_modules/@shopify/polaris/build/esm/components/TextField/TextField.js
function TextField({
  prefix,
  suffix,
  verticalContent,
  placeholder,
  value = "",
  helpText,
  label,
  labelAction,
  labelHidden,
  disabled,
  clearButton,
  readOnly,
  autoFocus,
  focused,
  multiline,
  error,
  connectedRight,
  connectedLeft,
  type = "text",
  name,
  id: idProp,
  role,
  step,
  largeStep,
  autoComplete,
  max,
  maxLength,
  maxHeight,
  min,
  minLength,
  pattern,
  inputMode,
  spellCheck,
  ariaOwns,
  ariaControls,
  ariaExpanded,
  ariaActiveDescendant,
  ariaAutocomplete,
  showCharacterCount,
  align,
  requiredIndicator,
  monospaced,
  selectTextOnFocus,
  suggestion,
  onClearButtonClick,
  onChange,
  onSpinnerChange,
  onFocus,
  onBlur,
  borderless
}) {
  const i18n = useI18n();
  const [height, setHeight] = (0, import_react574.useState)(null);
  const [focus, setFocus] = (0, import_react574.useState)(Boolean(focused));
  const isAfterInitial = useIsAfterInitialMount();
  const id = useUniqueId("TextField", idProp);
  const inputRef = (0, import_react574.useRef)(null);
  const textAreaRef = (0, import_react574.useRef)(null);
  const prefixRef = (0, import_react574.useRef)(null);
  const suffixRef = (0, import_react574.useRef)(null);
  const verticalContentRef = (0, import_react574.useRef)(null);
  const buttonPressTimer = (0, import_react574.useRef)();
  const spinnerRef = (0, import_react574.useRef)(null);
  (0, import_react574.useEffect)(() => {
    const input2 = multiline ? textAreaRef.current : inputRef.current;
    if (!input2 || focused === void 0)
      return;
    focused ? input2.focus() : input2.blur();
  }, [focused, verticalContent, multiline]);
  (0, import_react574.useEffect)(() => {
    const input2 = inputRef.current;
    const isSupportedInputType = type === "text" || type === "tel" || type === "search" || type === "url" || type === "password";
    if (!input2 || !isSupportedInputType || !suggestion) {
      return;
    }
    input2.setSelectionRange(value.length, suggestion.length);
  }, [focus, value, type, suggestion]);
  const normalizedValue = suggestion ? suggestion : value;
  const normalizedStep = step != null ? step : 1;
  const normalizedMax = max != null ? max : Infinity;
  const normalizedMin = min != null ? min : -Infinity;
  const className = classNames(styles25.TextField, Boolean(normalizedValue) && styles25.hasValue, disabled && styles25.disabled, readOnly && styles25.readOnly, error && styles25.error, multiline && styles25.multiline, focus && styles25.focus, borderless && styles25.borderless);
  const inputType = type === "currency" ? "text" : type;
  const isNumericType = type === "number" || type === "integer";
  const prefixMarkup = prefix ? import_react574.default.createElement("div", {
    className: styles25.Prefix,
    id: `${id}-Prefix`,
    ref: prefixRef
  }, prefix) : null;
  const suffixMarkup = suffix ? import_react574.default.createElement("div", {
    className: styles25.Suffix,
    id: `${id}-Suffix`,
    ref: suffixRef
  }, suffix) : null;
  let characterCountMarkup = null;
  if (showCharacterCount) {
    const characterCount = normalizedValue.length;
    const characterCountLabel = maxLength ? i18n.translate("Polaris.TextField.characterCountWithMaxLength", {
      count: characterCount,
      limit: maxLength
    }) : i18n.translate("Polaris.TextField.characterCount", {
      count: characterCount
    });
    const characterCountClassName = classNames(styles25.CharacterCount, multiline && styles25.AlignFieldBottom);
    const characterCountText = !maxLength ? characterCount : `${characterCount}/${maxLength}`;
    characterCountMarkup = import_react574.default.createElement("div", {
      id: `${id}-CharacterCounter`,
      className: characterCountClassName,
      "aria-label": characterCountLabel,
      "aria-live": focus ? "polite" : "off",
      "aria-atomic": "true",
      onClick: handleClickChild
    }, characterCountText);
  }
  const clearButtonVisible = normalizedValue !== "";
  const clearButtonMarkup = clearButton && clearButtonVisible ? import_react574.default.createElement("button", {
    type: "button",
    className: styles25.ClearButton,
    onClick: handleClearButtonPress,
    disabled
  }, import_react574.default.createElement(Text, {
    as: "span",
    visuallyHidden: true
  }, i18n.translate("Polaris.Common.clear")), import_react574.default.createElement(Icon, {
    source: SvgCircleCancelMinor,
    color: "base"
  })) : null;
  const handleNumberChange = (0, import_react574.useCallback)((steps, stepAmount = normalizedStep) => {
    if (onChange == null && onSpinnerChange == null) {
      return;
    }
    const dpl = (num) => (num.toString().split(".")[1] || []).length;
    const numericValue = value ? parseFloat(value) : 0;
    if (isNaN(numericValue)) {
      return;
    }
    const decimalPlaces = type === "integer" ? 0 : Math.max(dpl(numericValue), dpl(stepAmount));
    const newValue = Math.min(Number(normalizedMax), Math.max(numericValue + steps * stepAmount, Number(normalizedMin)));
    if (onSpinnerChange != null) {
      onSpinnerChange(String(newValue.toFixed(decimalPlaces)), id);
    } else if (onChange != null) {
      onChange(String(newValue.toFixed(decimalPlaces)), id);
    }
  }, [id, normalizedMax, normalizedMin, onChange, onSpinnerChange, normalizedStep, type, value]);
  const handleButtonRelease = (0, import_react574.useCallback)(() => {
    clearTimeout(buttonPressTimer.current);
  }, []);
  const handleButtonPress = (0, import_react574.useCallback)((onChange2) => {
    const minInterval = 50;
    const decrementBy = 10;
    let interval = 200;
    const onChangeInterval = () => {
      if (interval > minInterval)
        interval -= decrementBy;
      onChange2(0);
      buttonPressTimer.current = window.setTimeout(onChangeInterval, interval);
    };
    buttonPressTimer.current = window.setTimeout(onChangeInterval, interval);
    document.addEventListener("mouseup", handleButtonRelease, {
      once: true
    });
  }, [handleButtonRelease]);
  const spinnerMarkup = isNumericType && step !== 0 && !disabled && !readOnly ? import_react574.default.createElement(Spinner2, {
    onClick: handleClickChild,
    onChange: handleNumberChange,
    onMouseDown: handleButtonPress,
    onMouseUp: handleButtonRelease,
    ref: spinnerRef,
    onBlur: handleOnBlur
  }) : null;
  const style = multiline && height ? {
    height,
    maxHeight
  } : null;
  const handleExpandingResize = (0, import_react574.useCallback)((height2) => {
    setHeight(height2);
  }, []);
  const resizer = multiline && isAfterInitial ? import_react574.default.createElement(Resizer, {
    contents: normalizedValue || placeholder,
    currentHeight: height,
    minimumLines: typeof multiline === "number" ? multiline : 1,
    onHeightChange: handleExpandingResize
  }) : null;
  const describedBy = [];
  if (error) {
    describedBy.push(`${id}Error`);
  }
  if (helpText) {
    describedBy.push(helpTextID(id));
  }
  if (showCharacterCount) {
    describedBy.push(`${id}-CharacterCounter`);
  }
  const labelledBy = [];
  if (prefix) {
    labelledBy.push(`${id}-Prefix`);
  }
  if (suffix) {
    labelledBy.push(`${id}-Suffix`);
  }
  if (verticalContent) {
    labelledBy.push(`${id}-VerticalContent`);
  }
  labelledBy.unshift(labelID(id));
  const inputClassName = classNames(styles25.Input, align && styles25[variationName("Input-align", align)], suffix && styles25["Input-suffixed"], clearButton && styles25["Input-hasClearButton"], monospaced && styles25.monospaced, suggestion && styles25.suggestion);
  const handleOnFocus = (event) => {
    setFocus(true);
    if (selectTextOnFocus && !suggestion) {
      const input2 = multiline ? textAreaRef.current : inputRef.current;
      input2 === null || input2 === void 0 ? void 0 : input2.select();
    }
    if (onFocus) {
      onFocus(event);
    }
  };
  useEventListener("wheel", handleOnWheel, inputRef);
  function handleOnWheel(event) {
    if (document.activeElement === event.target && isNumericType) {
      event.stopPropagation();
    }
  }
  const input = (0, import_react574.createElement)(multiline ? "textarea" : "input", {
    name,
    id,
    disabled,
    readOnly,
    role,
    autoFocus,
    value: normalizedValue,
    placeholder,
    style,
    autoComplete,
    className: inputClassName,
    ref: multiline ? textAreaRef : inputRef,
    min,
    max,
    step,
    minLength,
    maxLength,
    spellCheck,
    pattern,
    inputMode,
    type: inputType,
    rows: getRows(multiline),
    "aria-describedby": describedBy.length ? describedBy.join(" ") : void 0,
    "aria-labelledby": labelledBy.join(" "),
    "aria-invalid": Boolean(error),
    "aria-owns": ariaOwns,
    "aria-activedescendant": ariaActiveDescendant,
    "aria-autocomplete": ariaAutocomplete,
    "aria-controls": ariaControls,
    "aria-expanded": ariaExpanded,
    "aria-required": requiredIndicator,
    ...normalizeAriaMultiline(multiline),
    onFocus: handleOnFocus,
    onBlur: handleOnBlur,
    onClick: handleClickChild,
    onKeyPress: handleKeyPress,
    onKeyDown: handleKeyDown7,
    onChange: !suggestion ? handleChange : void 0,
    onInput: suggestion ? handleChange : void 0
  });
  const inputWithVerticalContentMarkup = verticalContent ? import_react574.default.createElement("div", {
    className: styles25.VerticalContent,
    id: `${id}-VerticalContent`,
    ref: verticalContentRef,
    onClick: handleClickChild
  }, verticalContent, input) : null;
  const inputMarkup = verticalContent ? inputWithVerticalContentMarkup : input;
  const backdropMarkup = import_react574.default.createElement("div", {
    className: classNames(styles25.Backdrop, connectedLeft && styles25["Backdrop-connectedLeft"], connectedRight && styles25["Backdrop-connectedRight"])
  });
  return import_react574.default.createElement(Labelled, {
    label,
    id,
    error,
    action: labelAction,
    labelHidden,
    helpText,
    requiredIndicator
  }, import_react574.default.createElement(Connected, {
    left: connectedLeft,
    right: connectedRight
  }, import_react574.default.createElement("div", {
    className,
    onClick: handleClick
  }, prefixMarkup, inputMarkup, suffixMarkup, characterCountMarkup, clearButtonMarkup, spinnerMarkup, backdropMarkup, resizer)));
  function handleChange(event) {
    onChange && onChange(event.currentTarget.value, id);
  }
  function handleClick(event) {
    var _inputRef$current, _inputRef$current3;
    const {
      target
    } = event;
    const inputRefRole = inputRef === null || inputRef === void 0 ? void 0 : (_inputRef$current = inputRef.current) === null || _inputRef$current === void 0 ? void 0 : _inputRef$current.getAttribute("role");
    if (target === inputRef.current && inputRefRole === "combobox") {
      var _inputRef$current2;
      (_inputRef$current2 = inputRef.current) === null || _inputRef$current2 === void 0 ? void 0 : _inputRef$current2.focus();
      handleOnFocus(event);
      return;
    }
    if (isPrefixOrSuffix(target) || isVerticalContent(target) || isInput(target) || isSpinner(target) || focus) {
      return;
    }
    (_inputRef$current3 = inputRef.current) === null || _inputRef$current3 === void 0 ? void 0 : _inputRef$current3.focus();
  }
  function handleClickChild(event) {
    if (!isSpinner(event.target) && !isInput(event.target)) {
      event.stopPropagation();
    }
    if (isPrefixOrSuffix(event.target) || isVerticalContent(event.target) || isInput(event.target) || focus) {
      return;
    }
    setFocus(true);
  }
  function handleClearButtonPress() {
    onClearButtonClick && onClearButtonClick(id);
  }
  function handleKeyPress(event) {
    const {
      key,
      which
    } = event;
    const numbersSpec = /[\d.,eE+-]$/;
    const integerSpec = /[\deE+-]$/;
    if (!isNumericType || which === Key.Enter || type === "number" && numbersSpec.test(key) || type === "integer" && integerSpec.test(key)) {
      return;
    }
    event.preventDefault();
  }
  function handleKeyDown7(event) {
    if (!isNumericType) {
      return;
    }
    const {
      key,
      which
    } = event;
    if ((which === Key.Home || key === "Home") && min !== void 0) {
      if (onSpinnerChange != null) {
        onSpinnerChange(String(min), id);
      } else if (onChange != null) {
        onChange(String(min), id);
      }
    }
    if ((which === Key.End || key === "End") && max !== void 0) {
      if (onSpinnerChange != null) {
        onSpinnerChange(String(max), id);
      } else if (onChange != null) {
        onChange(String(max), id);
      }
    }
    if ((which === Key.PageUp || key === "PageUp") && largeStep !== void 0) {
      handleNumberChange(1, largeStep);
    }
    if ((which === Key.PageDown || key === "PageDown") && largeStep !== void 0) {
      handleNumberChange(-1, largeStep);
    }
  }
  function handleOnBlur(event) {
    setFocus(false);
    if (onBlur) {
      onBlur(event);
    }
  }
  function isInput(target) {
    return target instanceof HTMLElement && inputRef.current && (inputRef.current.contains(target) || inputRef.current.contains(document.activeElement));
  }
  function isPrefixOrSuffix(target) {
    return target instanceof Element && (prefixRef.current && prefixRef.current.contains(target) || suffixRef.current && suffixRef.current.contains(target));
  }
  function isSpinner(target) {
    return target instanceof Element && spinnerRef.current && spinnerRef.current.contains(target);
  }
  function isVerticalContent(target) {
    return target instanceof Element && verticalContentRef.current && (verticalContentRef.current.contains(target) || verticalContentRef.current.contains(document.activeElement));
  }
}
function getRows(multiline) {
  if (!multiline)
    return void 0;
  return typeof multiline === "number" ? multiline : 1;
}
function normalizeAriaMultiline(multiline) {
  if (!multiline)
    return void 0;
  return Boolean(multiline) || typeof multiline === "number" && multiline > 0 ? {
    "aria-multiline": true
  } : void 0;
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaFilters/components/SearchField/SearchField.js
function SearchField({
  onChange,
  onClear,
  onFocus,
  onBlur,
  focused,
  value,
  placeholder,
  disabled,
  borderlessQueryField
}) {
  function handleChange(value2) {
    onChange(value2);
  }
  function handleClear() {
    if (onClear) {
      onClear();
    } else {
      onChange("");
    }
  }
  return import_react575.default.createElement(TextField, {
    value,
    onChange: handleChange,
    onFocus,
    onBlur,
    label: placeholder,
    labelHidden: true,
    autoComplete: "off",
    focused,
    placeholder,
    clearButton: true,
    onClearButtonClick: handleClear,
    disabled,
    borderless: borderlessQueryField
  });
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaFilters/components/FilterPill/FilterPill.js
var import_react576 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/AlphaFilters/components/FilterPill/FilterPill.scss.js
var styles30 = {
  "FilterButton": "Polaris-AlphaFilters-FilterPill__FilterButton",
  "focusedFilterButton": "Polaris-AlphaFilters-FilterPill--focusedFilterButton",
  "disabledFilterButton": "Polaris-AlphaFilters-FilterPill--disabledFilterButton",
  "ActiveFilterButton": "Polaris-AlphaFilters-FilterPill__ActiveFilterButton",
  "PlainButton": "Polaris-AlphaFilters-FilterPill__PlainButton",
  "ToggleButton": "Polaris-AlphaFilters-FilterPill__ToggleButton",
  "Label": "Polaris-AlphaFilters-FilterPill__Label",
  "clearButton": "Polaris-AlphaFilters-FilterPill--clearButton",
  "IconWrapper": "Polaris-AlphaFilters-FilterPill__IconWrapper",
  "PopoverWrapper": "Polaris-AlphaFilters-FilterPill__PopoverWrapper"
};

// ../node_modules/@shopify/polaris/build/esm/components/AlphaFilters/components/FilterPill/FilterPill.js
function FilterPill({
  filterKey,
  label,
  filter,
  disabled,
  hideClearButton,
  selected,
  initialActive,
  closeOnChildOverlayClick,
  onRemove,
  onClick
}) {
  const i18n = useI18n();
  const {
    mdDown
  } = useBreakpoints();
  const elementRef = (0, import_react576.useRef)(null);
  const {
    value: focused,
    setTrue: setFocusedTrue,
    setFalse: setFocusedFalse
  } = useToggle(false);
  const [popoverActive, setPopoverActive] = (0, import_react576.useState)(initialActive);
  (0, import_react576.useEffect)(() => {
    var _node$parentElement, _parent$scroll;
    const node = elementRef.current;
    if (!node || !popoverActive) {
      return;
    }
    const parent = (_node$parentElement = node.parentElement) === null || _node$parentElement === void 0 ? void 0 : _node$parentElement.parentElement;
    if (!parent) {
      return;
    }
    (_parent$scroll = parent.scroll) === null || _parent$scroll === void 0 ? void 0 : _parent$scroll.call(parent, {
      left: node.offsetLeft
    });
  }, [elementRef, popoverActive]);
  const togglePopoverActive = () => {
    if (filter) {
      setPopoverActive((popoverActive2) => !popoverActive2);
    }
    if (onClick) {
      onClick(filterKey);
    }
  };
  const handleClear = () => {
    if (onRemove)
      onRemove(filterKey);
    setPopoverActive(false);
  };
  const buttonClasses = classNames(styles30.FilterButton, selected && styles30.ActiveFilterButton, popoverActive && styles30.FocusFilterButton, focused && styles30.focusedFilterButton, disabled && styles30.disabledFilterButton);
  const clearButtonClassNames = classNames(styles30.PlainButton, styles30.clearButton);
  const toggleButtonClassNames = classNames(styles30.PlainButton, styles30.ToggleButton);
  const wrappedLabel = import_react576.default.createElement("div", {
    className: styles30.Label
  }, import_react576.default.createElement(Text, {
    variant: mdDown ? "bodyMd" : "bodySm",
    as: "span"
  }, label));
  const activator = import_react576.default.createElement("div", {
    className: buttonClasses
  }, import_react576.default.createElement(HorizontalStack, {
    gap: "0",
    wrap: false
  }, import_react576.default.createElement(UnstyledButton, {
    onFocus: setFocusedTrue,
    onBlur: setFocusedFalse,
    onClick: togglePopoverActive,
    className: toggleButtonClassNames,
    type: "button",
    disabled
  }, import_react576.default.createElement(HorizontalStack, {
    wrap: false,
    align: "center",
    blockAlign: "center",
    gap: "0"
  }, selected ? import_react576.default.createElement(import_react576.default.Fragment, null, wrappedLabel) : import_react576.default.createElement(import_react576.default.Fragment, null, wrappedLabel, import_react576.default.createElement("div", {
    className: styles30.IconWrapper
  }, import_react576.default.createElement(Icon, {
    source: SvgCaretDownMinor,
    color: "base"
  }))))), selected ? import_react576.default.createElement(UnstyledButton, {
    onClick: handleClear,
    className: clearButtonClassNames,
    type: "button",
    "aria-label": i18n.translate("Polaris.FilterPill.clear"),
    disabled
  }, import_react576.default.createElement("div", {
    className: styles30.IconWrapper
  }, import_react576.default.createElement(Icon, {
    source: SvgCancelSmallMinor,
    color: "base"
  }))) : null));
  const clearButtonMarkup = !hideClearButton && import_react576.default.createElement(Button, {
    onClick: handleClear,
    plain: true,
    disabled: !selected,
    textAlign: "left"
  }, i18n.translate("Polaris.FilterPill.clear"));
  if (disabled) {
    return null;
  }
  return import_react576.default.createElement("div", {
    ref: elementRef
  }, import_react576.default.createElement(Popover2, {
    active: popoverActive && !disabled,
    activator,
    key: filterKey,
    onClose: togglePopoverActive,
    preferredAlignment: "left",
    preventCloseOnChildOverlayClick: !closeOnChildOverlayClick
  }, import_react576.default.createElement("div", {
    className: styles30.PopoverWrapper
  }, import_react576.default.createElement(Popover2.Section, null, import_react576.default.createElement(VerticalStack, {
    gap: "1"
  }, filter, clearButtonMarkup)))));
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaFilters/AlphaFilters.js
var TRANSITION_DURATION = "var(--p-motion-duration-150)";
var TRANSITION_MARGIN = "-36px";
var defaultStyle = {
  transition: `opacity ${TRANSITION_DURATION} var(--p-motion-ease)`,
  opacity: 0
};
var transitionStyles = {
  entering: {
    opacity: 1
  },
  entered: {
    opacity: 1
  },
  exiting: {
    opacity: 0
  },
  exited: {
    opacity: 0
  },
  unmounted: {
    opacity: 0
  }
};
var defaultFilterStyles = {
  transition: `opacity ${TRANSITION_DURATION} var(--p-motion-ease), margin ${TRANSITION_DURATION} var(--p-motion-ease)`,
  opacity: 0,
  marginTop: TRANSITION_MARGIN
};
var transitionFilterStyles = {
  entering: {
    opacity: 1,
    marginTop: 0
  },
  entered: {
    opacity: 1,
    marginTop: 0
  },
  exiting: {
    opacity: 0,
    marginTop: TRANSITION_MARGIN
  },
  exited: {
    opacity: 0,
    marginTop: TRANSITION_MARGIN
  },
  unmounted: {
    opacity: 0,
    marginTop: TRANSITION_MARGIN
  }
};
function AlphaFilters({
  queryValue,
  queryPlaceholder,
  focused,
  filters,
  appliedFilters,
  onQueryChange,
  onQueryClear,
  onQueryBlur,
  onQueryFocus,
  onClearAll,
  children: children2,
  disabled,
  hideFilters,
  hideQueryField,
  disableQueryField,
  borderlessQueryField,
  loading,
  disableFilters,
  mountedState,
  onAddFilterClick
}) {
  const i18n = useI18n();
  const [popoverActive, setPopoverActive] = (0, import_react577.useState)(false);
  const [localPinnedFilters, setLocalPinnedFilters] = (0, import_react577.useState)([]);
  const hasMounted = (0, import_react577.useRef)(false);
  (0, import_react577.useEffect)(() => {
    hasMounted.current = true;
  });
  const togglePopoverActive = () => setPopoverActive((popoverActive2) => !popoverActive2);
  const handleAddFilterClick = () => {
    onAddFilterClick === null || onAddFilterClick === void 0 ? void 0 : onAddFilterClick();
    togglePopoverActive();
  };
  const appliedFilterKeys = appliedFilters === null || appliedFilters === void 0 ? void 0 : appliedFilters.map(({
    key
  }) => key);
  const pinnedFiltersFromPropsAndAppliedFilters = filters.filter(({
    pinned,
    key
  }) => (Boolean(pinned) || (appliedFilterKeys === null || appliedFilterKeys === void 0 ? void 0 : appliedFilterKeys.includes(key))) && // Filters that are pinned in local state display at the end of our list
  !localPinnedFilters.find((filterKey) => filterKey === key));
  const pinnedFiltersFromLocalState = localPinnedFilters.map((key) => filters.find((filter) => filter.key === key)).reduce((acc, filter) => filter ? [...acc, filter] : acc, []);
  const pinnedFilters = [...pinnedFiltersFromPropsAndAppliedFilters, ...pinnedFiltersFromLocalState];
  const onFilterClick = ({
    key,
    onAction
  }) => () => {
    setTimeout(() => {
      setLocalPinnedFilters((currentLocalPinnedFilters) => [.../* @__PURE__ */ new Set([...currentLocalPinnedFilters, key])]);
      onAction === null || onAction === void 0 ? void 0 : onAction();
      togglePopoverActive();
    }, 0);
  };
  const filterToActionItem = (filter) => ({
    ...filter,
    content: filter.label,
    onAction: onFilterClick(filter)
  });
  const unpinnedFilters = filters.filter((filter) => !pinnedFilters.some(({
    key
  }) => key === filter.key));
  const unsectionedFilters = unpinnedFilters.filter((filter) => !filter.section).map(filterToActionItem);
  const sectionedFilters = unpinnedFilters.filter((filter) => filter.section).reduce((acc, filter) => {
    const filterActionItem = filterToActionItem(filter);
    const sectionIndex = acc.findIndex((section) => section.title === filter.section);
    if (sectionIndex === -1) {
      acc.push({
        title: filter.section,
        items: [filterActionItem]
      });
    } else {
      acc[sectionIndex].items.push(filterActionItem);
    }
    return acc;
  }, []);
  const hasOneOrMorePinnedFilters = pinnedFilters.length >= 1;
  const addFilterActivator = import_react577.default.createElement("div", null, import_react577.default.createElement(Text, {
    variant: "bodySm",
    as: "p"
  }, import_react577.default.createElement(UnstyledButton, {
    type: "button",
    className: styles24.AddFilter,
    onClick: handleAddFilterClick,
    "aria-label": i18n.translate("Polaris.Filters.addFilter"),
    disabled: disabled || unsectionedFilters.length === 0 && sectionedFilters.length === 0 || disableFilters
  }, import_react577.default.createElement("span", null, i18n.translate("Polaris.Filters.addFilter")), import_react577.default.createElement(SvgPlusMinor, null))));
  const handleClearAllFilters = () => {
    setLocalPinnedFilters([]);
    onClearAll === null || onClearAll === void 0 ? void 0 : onClearAll();
  };
  const shouldShowAddButton = filters.some((filter) => !filter.pinned);
  const additionalContent = (0, import_react577.useMemo)(() => {
    return import_react577.default.createElement(import_react577.default.Fragment, null, import_react577.default.createElement("div", {
      className: styles24.Spinner
    }, loading ? import_react577.default.createElement(Spinner, {
      size: "small"
    }) : null), children2);
  }, [loading, children2]);
  const queryFieldMarkup = hideQueryField ? null : import_react577.default.createElement("div", {
    className: styles24.Container
  }, import_react577.default.createElement(Box, {
    paddingBlockStart: {
      xs: "3",
      md: "2"
    },
    paddingBlockEnd: {
      xs: "3",
      md: "2"
    },
    paddingInlineStart: "2",
    paddingInlineEnd: {
      xs: "4",
      md: "3"
    }
  }, import_react577.default.createElement(HorizontalStack, {
    align: "start",
    blockAlign: "center",
    gap: {
      xs: "4",
      md: "3"
    }
  }, import_react577.default.createElement("div", {
    className: styles24.SearchField,
    style: mountedState ? {
      ...defaultStyle,
      ...transitionStyles[mountedState]
    } : void 0
  }, import_react577.default.createElement(SearchField, {
    onChange: onQueryChange,
    onFocus: onQueryFocus,
    onBlur: onQueryBlur,
    onClear: onQueryClear,
    value: queryValue,
    placeholder: queryPlaceholder,
    focused,
    disabled: disabled || disableQueryField,
    borderlessQueryField
  })), additionalContent)));
  const mountedStateStyles = mountedState && !hideQueryField ? {
    ...defaultFilterStyles,
    ...transitionFilterStyles[mountedState]
  } : void 0;
  const pinnedFiltersMarkup = pinnedFilters.map(({
    key: filterKey,
    ...pinnedFilter
  }) => {
    const appliedFilter = appliedFilters === null || appliedFilters === void 0 ? void 0 : appliedFilters.find(({
      key
    }) => key === filterKey);
    const handleFilterPillRemove = () => {
      setLocalPinnedFilters((currentLocalPinnedFilters) => currentLocalPinnedFilters.filter((key) => key !== filterKey));
      appliedFilter === null || appliedFilter === void 0 ? void 0 : appliedFilter.onRemove(filterKey);
    };
    return import_react577.default.createElement(FilterPill, Object.assign({
      key: filterKey
    }, pinnedFilter, {
      initialActive: hasMounted.current && !pinnedFilter.pinned && !appliedFilter,
      label: (appliedFilter === null || appliedFilter === void 0 ? void 0 : appliedFilter.label) || pinnedFilter.label,
      filterKey,
      selected: appliedFilterKeys === null || appliedFilterKeys === void 0 ? void 0 : appliedFilterKeys.includes(filterKey),
      onRemove: handleFilterPillRemove,
      disabled: pinnedFilter.disabled || disableFilters
    }));
  });
  const addButton = shouldShowAddButton ? import_react577.default.createElement("div", {
    className: classNames(styles24.AddFilterActivator, hasOneOrMorePinnedFilters && styles24.AddFilterActivatorMultiple)
  }, import_react577.default.createElement(Popover2, {
    active: popoverActive && !disabled,
    activator: addFilterActivator,
    onClose: togglePopoverActive
  }, import_react577.default.createElement(ActionList, {
    actionRole: "menuitem",
    items: unsectionedFilters,
    sections: sectionedFilters
  }))) : null;
  const clearAllMarkup = appliedFilters !== null && appliedFilters !== void 0 && appliedFilters.length || localPinnedFilters.length ? import_react577.default.createElement("div", {
    className: classNames(styles24.ClearAll, hasOneOrMorePinnedFilters && shouldShowAddButton && styles24.MultiplePinnedFilterClearAll)
  }, import_react577.default.createElement(Button, {
    size: "micro",
    plain: true,
    onClick: handleClearAllFilters,
    removeUnderline: true
  }, i18n.translate("Polaris.Filters.clearFilters"))) : null;
  const filtersMarkup = hideFilters || filters.length === 0 ? null : import_react577.default.createElement("div", {
    className: classNames(styles24.FiltersWrapper, shouldShowAddButton && hasOneOrMorePinnedFilters && styles24.FiltersWrapperWithAddButton),
    "aria-live": "polite",
    style: mountedStateStyles
  }, import_react577.default.createElement("div", {
    className: classNames(styles24.FiltersInner)
  }, import_react577.default.createElement("div", {
    className: classNames(styles24.FiltersStickyArea)
  }, pinnedFiltersMarkup, addButton, clearAllMarkup)), hideQueryField ? import_react577.default.createElement(Box, {
    paddingInlineEnd: "3",
    paddingBlockStart: "2",
    paddingBlockEnd: "2"
  }, import_react577.default.createElement(HorizontalStack, {
    align: "start",
    blockAlign: "center",
    gap: {
      xs: "4",
      md: "3"
    }
  }, additionalContent)) : null);
  return import_react577.default.createElement("div", {
    className: classNames(styles24.Filters, hideQueryField && styles24.hideQueryField)
  }, queryFieldMarkup, filtersMarkup);
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaTabs/AlphaTabs.js
var import_react612 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/use-previous.js
var import_react578 = __toESM(require_react());
function usePrevious(value) {
  const ref = (0, import_react578.useRef)();
  (0, import_react578.useEffect)(() => {
    ref.current = value;
  }, [value]);
  return ref.current;
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaTabs/utilities.js
function getVisibleAndHiddenTabIndices(tabs, selected, disclosureWidth, tabWidths, containerWidth) {
  const sumTabWidths = tabWidths.reduce((sum, width) => sum + width, 0);
  const arrayOfTabIndices = tabs.map((_, index) => {
    return index;
  });
  const visibleTabs = [];
  const hiddenTabs = [];
  if (containerWidth > sumTabWidths) {
    visibleTabs.push(...arrayOfTabIndices);
  } else {
    visibleTabs.push(selected);
    let tabListWidth = tabWidths[selected];
    arrayOfTabIndices.forEach((currentTabIndex) => {
      if (currentTabIndex !== selected) {
        const currentTabWidth = tabWidths[currentTabIndex];
        if (tabListWidth + currentTabWidth >= containerWidth - disclosureWidth) {
          hiddenTabs.push(currentTabIndex);
          return;
        }
        visibleTabs.push(currentTabIndex);
        tabListWidth += currentTabWidth;
      }
    });
  }
  return {
    visibleTabs,
    hiddenTabs
  };
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaTabs/AlphaTabs.scss.js
var styles31 = {
  "Outer": "Polaris-AlphaTabs__Outer",
  "Wrapper": "Polaris-AlphaTabs__Wrapper",
  "WrapperWithNewButton": "Polaris-AlphaTabs__WrapperWithNewButton",
  "ButtonWrapper": "Polaris-AlphaTabs__ButtonWrapper",
  "AlphaTabs": "Polaris-AlphaTabs",
  "Tab": "Polaris-AlphaTabs__Tab",
  "Tab-active": "Polaris-AlphaTabs__Tab--active",
  "Tab-hasActions": "Polaris-AlphaTabs__Tab--hasActions",
  "Tab-iconOnly": "Polaris-AlphaTabs__Tab--iconOnly",
  "fillSpace": "Polaris-AlphaTabs--fillSpace",
  "TabContainer": "Polaris-AlphaTabs__TabContainer",
  "fitted": "Polaris-AlphaTabs--fitted",
  "titleWithIcon": "Polaris-AlphaTabs--titleWithIcon",
  "List": "Polaris-AlphaTabs__List",
  "Item": "Polaris-AlphaTabs__Item",
  "DisclosureTab": "Polaris-AlphaTabs__DisclosureTab",
  "DisclosureTab-visible": "Polaris-AlphaTabs__DisclosureTab--visible",
  "DisclosureActivator": "Polaris-AlphaTabs__DisclosureActivator",
  "TabsMeasurer": "Polaris-AlphaTabs__TabsMeasurer",
  "NewTab": "Polaris-AlphaTabs__NewTab",
  "ActionListWrap": "Polaris-AlphaTabs__ActionListWrap",
  "Panel": "Polaris-AlphaTabs__Panel",
  "Panel-hidden": "Polaris-AlphaTabs__Panel--hidden"
};

// ../node_modules/@shopify/polaris/build/esm/components/AlphaTabs/components/Tab/Tab.js
var import_react605 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/AlphaTabs/components/Tab/components/DuplicateModal/DuplicateModal.js
var import_react603 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Modal/Modal.js
var import_react598 = __toESM(require_react());

// ../../node_modules/react-transition-group/esm/CSSTransition.js
init_extends();
init_objectWithoutPropertiesLoose();
var import_prop_types3 = __toESM(require_prop_types());

// ../../node_modules/dom-helpers/esm/hasClass.js
function hasClass(element, className) {
  if (element.classList)
    return !!className && element.classList.contains(className);
  return (" " + (element.className.baseVal || element.className) + " ").indexOf(" " + className + " ") !== -1;
}

// ../../node_modules/dom-helpers/esm/addClass.js
function addClass(element, className) {
  if (element.classList)
    element.classList.add(className);
  else if (!hasClass(element, className))
    if (typeof element.className === "string")
      element.className = element.className + " " + className;
    else
      element.setAttribute("class", (element.className && element.className.baseVal || "") + " " + className);
}

// ../../node_modules/dom-helpers/esm/removeClass.js
function replaceClassName(origClass, classToRemove) {
  return origClass.replace(new RegExp("(^|\\s)" + classToRemove + "(?:\\s|$)", "g"), "$1").replace(/\s+/g, " ").replace(/^\s*|\s*$/g, "");
}
function removeClass(element, className) {
  if (element.classList) {
    element.classList.remove(className);
  } else if (typeof element.className === "string") {
    element.className = replaceClassName(element.className, className);
  } else {
    element.setAttribute("class", replaceClassName(element.className && element.className.baseVal || "", className));
  }
}

// ../../node_modules/react-transition-group/esm/CSSTransition.js
var import_react581 = __toESM(require_react());

// ../../node_modules/react-transition-group/esm/Transition.js
init_objectWithoutPropertiesLoose();
var import_prop_types2 = __toESM(require_prop_types());
var import_react580 = __toESM(require_react());
var import_react_dom2 = __toESM(require_react_dom());

// ../../node_modules/react-transition-group/esm/config.js
var config_default = {
  disabled: false
};

// ../../node_modules/react-transition-group/esm/utils/PropTypes.js
var import_prop_types = __toESM(require_prop_types());
var timeoutsShape = true ? import_prop_types.default.oneOfType([import_prop_types.default.number, import_prop_types.default.shape({
  enter: import_prop_types.default.number,
  exit: import_prop_types.default.number,
  appear: import_prop_types.default.number
}).isRequired]) : null;
var classNamesShape = true ? import_prop_types.default.oneOfType([import_prop_types.default.string, import_prop_types.default.shape({
  enter: import_prop_types.default.string,
  exit: import_prop_types.default.string,
  active: import_prop_types.default.string
}), import_prop_types.default.shape({
  enter: import_prop_types.default.string,
  enterDone: import_prop_types.default.string,
  enterActive: import_prop_types.default.string,
  exit: import_prop_types.default.string,
  exitDone: import_prop_types.default.string,
  exitActive: import_prop_types.default.string
})]) : null;

// ../../node_modules/react-transition-group/esm/TransitionGroupContext.js
var import_react579 = __toESM(require_react());
var TransitionGroupContext_default = import_react579.default.createContext(null);

// ../../node_modules/react-transition-group/esm/utils/reflow.js
var forceReflow = function forceReflow2(node) {
  return node.scrollTop;
};

// ../../node_modules/react-transition-group/esm/Transition.js
var UNMOUNTED = "unmounted";
var EXITED = "exited";
var ENTERING = "entering";
var ENTERED = "entered";
var EXITING = "exiting";
var Transition = function(_React$Component) {
  _inheritsLoose(Transition2, _React$Component);
  function Transition2(props, context) {
    var _this;
    _this = _React$Component.call(this, props, context) || this;
    var parentGroup = context;
    var appear = parentGroup && !parentGroup.isMounting ? props.enter : props.appear;
    var initialStatus;
    _this.appearStatus = null;
    if (props.in) {
      if (appear) {
        initialStatus = EXITED;
        _this.appearStatus = ENTERING;
      } else {
        initialStatus = ENTERED;
      }
    } else {
      if (props.unmountOnExit || props.mountOnEnter) {
        initialStatus = UNMOUNTED;
      } else {
        initialStatus = EXITED;
      }
    }
    _this.state = {
      status: initialStatus
    };
    _this.nextCallback = null;
    return _this;
  }
  Transition2.getDerivedStateFromProps = function getDerivedStateFromProps(_ref, prevState) {
    var nextIn = _ref.in;
    if (nextIn && prevState.status === UNMOUNTED) {
      return {
        status: EXITED
      };
    }
    return null;
  };
  var _proto = Transition2.prototype;
  _proto.componentDidMount = function componentDidMount() {
    this.updateStatus(true, this.appearStatus);
  };
  _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
    var nextStatus = null;
    if (prevProps !== this.props) {
      var status = this.state.status;
      if (this.props.in) {
        if (status !== ENTERING && status !== ENTERED) {
          nextStatus = ENTERING;
        }
      } else {
        if (status === ENTERING || status === ENTERED) {
          nextStatus = EXITING;
        }
      }
    }
    this.updateStatus(false, nextStatus);
  };
  _proto.componentWillUnmount = function componentWillUnmount() {
    this.cancelNextCallback();
  };
  _proto.getTimeouts = function getTimeouts() {
    var timeout2 = this.props.timeout;
    var exit, enter, appear;
    exit = enter = appear = timeout2;
    if (timeout2 != null && typeof timeout2 !== "number") {
      exit = timeout2.exit;
      enter = timeout2.enter;
      appear = timeout2.appear !== void 0 ? timeout2.appear : enter;
    }
    return {
      exit,
      enter,
      appear
    };
  };
  _proto.updateStatus = function updateStatus(mounting, nextStatus) {
    if (mounting === void 0) {
      mounting = false;
    }
    if (nextStatus !== null) {
      this.cancelNextCallback();
      if (nextStatus === ENTERING) {
        if (this.props.unmountOnExit || this.props.mountOnEnter) {
          var node = this.props.nodeRef ? this.props.nodeRef.current : import_react_dom2.default.findDOMNode(this);
          if (node)
            forceReflow(node);
        }
        this.performEnter(mounting);
      } else {
        this.performExit();
      }
    } else if (this.props.unmountOnExit && this.state.status === EXITED) {
      this.setState({
        status: UNMOUNTED
      });
    }
  };
  _proto.performEnter = function performEnter(mounting) {
    var _this2 = this;
    var enter = this.props.enter;
    var appearing = this.context ? this.context.isMounting : mounting;
    var _ref2 = this.props.nodeRef ? [appearing] : [import_react_dom2.default.findDOMNode(this), appearing], maybeNode = _ref2[0], maybeAppearing = _ref2[1];
    var timeouts = this.getTimeouts();
    var enterTimeout = appearing ? timeouts.appear : timeouts.enter;
    if (!mounting && !enter || config_default.disabled) {
      this.safeSetState({
        status: ENTERED
      }, function() {
        _this2.props.onEntered(maybeNode);
      });
      return;
    }
    this.props.onEnter(maybeNode, maybeAppearing);
    this.safeSetState({
      status: ENTERING
    }, function() {
      _this2.props.onEntering(maybeNode, maybeAppearing);
      _this2.onTransitionEnd(enterTimeout, function() {
        _this2.safeSetState({
          status: ENTERED
        }, function() {
          _this2.props.onEntered(maybeNode, maybeAppearing);
        });
      });
    });
  };
  _proto.performExit = function performExit() {
    var _this3 = this;
    var exit = this.props.exit;
    var timeouts = this.getTimeouts();
    var maybeNode = this.props.nodeRef ? void 0 : import_react_dom2.default.findDOMNode(this);
    if (!exit || config_default.disabled) {
      this.safeSetState({
        status: EXITED
      }, function() {
        _this3.props.onExited(maybeNode);
      });
      return;
    }
    this.props.onExit(maybeNode);
    this.safeSetState({
      status: EXITING
    }, function() {
      _this3.props.onExiting(maybeNode);
      _this3.onTransitionEnd(timeouts.exit, function() {
        _this3.safeSetState({
          status: EXITED
        }, function() {
          _this3.props.onExited(maybeNode);
        });
      });
    });
  };
  _proto.cancelNextCallback = function cancelNextCallback() {
    if (this.nextCallback !== null) {
      this.nextCallback.cancel();
      this.nextCallback = null;
    }
  };
  _proto.safeSetState = function safeSetState(nextState, callback) {
    callback = this.setNextCallback(callback);
    this.setState(nextState, callback);
  };
  _proto.setNextCallback = function setNextCallback(callback) {
    var _this4 = this;
    var active = true;
    this.nextCallback = function(event) {
      if (active) {
        active = false;
        _this4.nextCallback = null;
        callback(event);
      }
    };
    this.nextCallback.cancel = function() {
      active = false;
    };
    return this.nextCallback;
  };
  _proto.onTransitionEnd = function onTransitionEnd(timeout2, handler) {
    this.setNextCallback(handler);
    var node = this.props.nodeRef ? this.props.nodeRef.current : import_react_dom2.default.findDOMNode(this);
    var doesNotHaveTimeoutOrListener = timeout2 == null && !this.props.addEndListener;
    if (!node || doesNotHaveTimeoutOrListener) {
      setTimeout(this.nextCallback, 0);
      return;
    }
    if (this.props.addEndListener) {
      var _ref3 = this.props.nodeRef ? [this.nextCallback] : [node, this.nextCallback], maybeNode = _ref3[0], maybeNextCallback = _ref3[1];
      this.props.addEndListener(maybeNode, maybeNextCallback);
    }
    if (timeout2 != null) {
      setTimeout(this.nextCallback, timeout2);
    }
  };
  _proto.render = function render() {
    var status = this.state.status;
    if (status === UNMOUNTED) {
      return null;
    }
    var _this$props = this.props, children2 = _this$props.children, _in = _this$props.in, _mountOnEnter = _this$props.mountOnEnter, _unmountOnExit = _this$props.unmountOnExit, _appear = _this$props.appear, _enter = _this$props.enter, _exit = _this$props.exit, _timeout = _this$props.timeout, _addEndListener = _this$props.addEndListener, _onEnter = _this$props.onEnter, _onEntering = _this$props.onEntering, _onEntered = _this$props.onEntered, _onExit = _this$props.onExit, _onExiting = _this$props.onExiting, _onExited = _this$props.onExited, _nodeRef = _this$props.nodeRef, childProps = _objectWithoutPropertiesLoose(_this$props, ["children", "in", "mountOnEnter", "unmountOnExit", "appear", "enter", "exit", "timeout", "addEndListener", "onEnter", "onEntering", "onEntered", "onExit", "onExiting", "onExited", "nodeRef"]);
    return (
      // allows for nested Transitions
      import_react580.default.createElement(TransitionGroupContext_default.Provider, {
        value: null
      }, typeof children2 === "function" ? children2(status, childProps) : import_react580.default.cloneElement(import_react580.default.Children.only(children2), childProps))
    );
  };
  return Transition2;
}(import_react580.default.Component);
Transition.contextType = TransitionGroupContext_default;
Transition.propTypes = true ? {
  /**
   * A React reference to DOM element that need to transition:
   * https://stackoverflow.com/a/51127130/4671932
   *
   *   - When `nodeRef` prop is used, `node` is not passed to callback functions
   *      (e.g. `onEnter`) because user already has direct access to the node.
   *   - When changing `key` prop of `Transition` in a `TransitionGroup` a new
   *     `nodeRef` need to be provided to `Transition` with changed `key` prop
   *     (see
   *     [test/CSSTransition-test.js](https://github.com/reactjs/react-transition-group/blob/13435f897b3ab71f6e19d724f145596f5910581c/test/CSSTransition-test.js#L362-L437)).
   */
  nodeRef: import_prop_types2.default.shape({
    current: typeof Element === "undefined" ? import_prop_types2.default.any : function(propValue, key, componentName, location, propFullName, secret) {
      var value = propValue[key];
      return import_prop_types2.default.instanceOf(value && "ownerDocument" in value ? value.ownerDocument.defaultView.Element : Element)(propValue, key, componentName, location, propFullName, secret);
    }
  }),
  /**
   * A `function` child can be used instead of a React element. This function is
   * called with the current transition status (`'entering'`, `'entered'`,
   * `'exiting'`, `'exited'`), which can be used to apply context
   * specific props to a component.
   *
   * ```jsx
   * <Transition in={this.state.in} timeout={150}>
   *   {state => (
   *     <MyComponent className={`fade fade-${state}`} />
   *   )}
   * </Transition>
   * ```
   */
  children: import_prop_types2.default.oneOfType([import_prop_types2.default.func.isRequired, import_prop_types2.default.element.isRequired]).isRequired,
  /**
   * Show the component; triggers the enter or exit states
   */
  in: import_prop_types2.default.bool,
  /**
   * By default the child component is mounted immediately along with
   * the parent `Transition` component. If you want to "lazy mount" the component on the
   * first `in={true}` you can set `mountOnEnter`. After the first enter transition the component will stay
   * mounted, even on "exited", unless you also specify `unmountOnExit`.
   */
  mountOnEnter: import_prop_types2.default.bool,
  /**
   * By default the child component stays mounted after it reaches the `'exited'` state.
   * Set `unmountOnExit` if you'd prefer to unmount the component after it finishes exiting.
   */
  unmountOnExit: import_prop_types2.default.bool,
  /**
   * By default the child component does not perform the enter transition when
   * it first mounts, regardless of the value of `in`. If you want this
   * behavior, set both `appear` and `in` to `true`.
   *
   * > **Note**: there are no special appear states like `appearing`/`appeared`, this prop
   * > only adds an additional enter transition. However, in the
   * > `<CSSTransition>` component that first enter transition does result in
   * > additional `.appear-*` classes, that way you can choose to style it
   * > differently.
   */
  appear: import_prop_types2.default.bool,
  /**
   * Enable or disable enter transitions.
   */
  enter: import_prop_types2.default.bool,
  /**
   * Enable or disable exit transitions.
   */
  exit: import_prop_types2.default.bool,
  /**
   * The duration of the transition, in milliseconds.
   * Required unless `addEndListener` is provided.
   *
   * You may specify a single timeout for all transitions:
   *
   * ```jsx
   * timeout={500}
   * ```
   *
   * or individually:
   *
   * ```jsx
   * timeout={{
   *  appear: 500,
   *  enter: 300,
   *  exit: 500,
   * }}
   * ```
   *
   * - `appear` defaults to the value of `enter`
   * - `enter` defaults to `0`
   * - `exit` defaults to `0`
   *
   * @type {number | { enter?: number, exit?: number, appear?: number }}
   */
  timeout: function timeout(props) {
    var pt = timeoutsShape;
    if (!props.addEndListener)
      pt = pt.isRequired;
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }
    return pt.apply(void 0, [props].concat(args));
  },
  /**
   * Add a custom transition end trigger. Called with the transitioning
   * DOM node and a `done` callback. Allows for more fine grained transition end
   * logic. Timeouts are still used as a fallback if provided.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * ```jsx
   * addEndListener={(node, done) => {
   *   // use the css transitionend event to mark the finish of a transition
   *   node.addEventListener('transitionend', done, false);
   * }}
   * ```
   */
  addEndListener: import_prop_types2.default.func,
  /**
   * Callback fired before the "entering" status is applied. An extra parameter
   * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * @type Function(node: HtmlElement, isAppearing: bool) -> void
   */
  onEnter: import_prop_types2.default.func,
  /**
   * Callback fired after the "entering" status is applied. An extra parameter
   * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * @type Function(node: HtmlElement, isAppearing: bool)
   */
  onEntering: import_prop_types2.default.func,
  /**
   * Callback fired after the "entered" status is applied. An extra parameter
   * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * @type Function(node: HtmlElement, isAppearing: bool) -> void
   */
  onEntered: import_prop_types2.default.func,
  /**
   * Callback fired before the "exiting" status is applied.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * @type Function(node: HtmlElement) -> void
   */
  onExit: import_prop_types2.default.func,
  /**
   * Callback fired after the "exiting" status is applied.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * @type Function(node: HtmlElement) -> void
   */
  onExiting: import_prop_types2.default.func,
  /**
   * Callback fired after the "exited" status is applied.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed
   *
   * @type Function(node: HtmlElement) -> void
   */
  onExited: import_prop_types2.default.func
} : {};
function noop4() {
}
Transition.defaultProps = {
  in: false,
  mountOnEnter: false,
  unmountOnExit: false,
  appear: false,
  enter: true,
  exit: true,
  onEnter: noop4,
  onEntering: noop4,
  onEntered: noop4,
  onExit: noop4,
  onExiting: noop4,
  onExited: noop4
};
Transition.UNMOUNTED = UNMOUNTED;
Transition.EXITED = EXITED;
Transition.ENTERING = ENTERING;
Transition.ENTERED = ENTERED;
Transition.EXITING = EXITING;
var Transition_default = Transition;

// ../../node_modules/react-transition-group/esm/CSSTransition.js
var _addClass = function addClass2(node, classes) {
  return node && classes && classes.split(" ").forEach(function(c) {
    return addClass(node, c);
  });
};
var removeClass2 = function removeClass3(node, classes) {
  return node && classes && classes.split(" ").forEach(function(c) {
    return removeClass(node, c);
  });
};
var CSSTransition = function(_React$Component) {
  _inheritsLoose(CSSTransition2, _React$Component);
  function CSSTransition2() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;
    _this.appliedClasses = {
      appear: {},
      enter: {},
      exit: {}
    };
    _this.onEnter = function(maybeNode, maybeAppearing) {
      var _this$resolveArgument = _this.resolveArguments(maybeNode, maybeAppearing), node = _this$resolveArgument[0], appearing = _this$resolveArgument[1];
      _this.removeClasses(node, "exit");
      _this.addClass(node, appearing ? "appear" : "enter", "base");
      if (_this.props.onEnter) {
        _this.props.onEnter(maybeNode, maybeAppearing);
      }
    };
    _this.onEntering = function(maybeNode, maybeAppearing) {
      var _this$resolveArgument2 = _this.resolveArguments(maybeNode, maybeAppearing), node = _this$resolveArgument2[0], appearing = _this$resolveArgument2[1];
      var type = appearing ? "appear" : "enter";
      _this.addClass(node, type, "active");
      if (_this.props.onEntering) {
        _this.props.onEntering(maybeNode, maybeAppearing);
      }
    };
    _this.onEntered = function(maybeNode, maybeAppearing) {
      var _this$resolveArgument3 = _this.resolveArguments(maybeNode, maybeAppearing), node = _this$resolveArgument3[0], appearing = _this$resolveArgument3[1];
      var type = appearing ? "appear" : "enter";
      _this.removeClasses(node, type);
      _this.addClass(node, type, "done");
      if (_this.props.onEntered) {
        _this.props.onEntered(maybeNode, maybeAppearing);
      }
    };
    _this.onExit = function(maybeNode) {
      var _this$resolveArgument4 = _this.resolveArguments(maybeNode), node = _this$resolveArgument4[0];
      _this.removeClasses(node, "appear");
      _this.removeClasses(node, "enter");
      _this.addClass(node, "exit", "base");
      if (_this.props.onExit) {
        _this.props.onExit(maybeNode);
      }
    };
    _this.onExiting = function(maybeNode) {
      var _this$resolveArgument5 = _this.resolveArguments(maybeNode), node = _this$resolveArgument5[0];
      _this.addClass(node, "exit", "active");
      if (_this.props.onExiting) {
        _this.props.onExiting(maybeNode);
      }
    };
    _this.onExited = function(maybeNode) {
      var _this$resolveArgument6 = _this.resolveArguments(maybeNode), node = _this$resolveArgument6[0];
      _this.removeClasses(node, "exit");
      _this.addClass(node, "exit", "done");
      if (_this.props.onExited) {
        _this.props.onExited(maybeNode);
      }
    };
    _this.resolveArguments = function(maybeNode, maybeAppearing) {
      return _this.props.nodeRef ? [_this.props.nodeRef.current, maybeNode] : [maybeNode, maybeAppearing];
    };
    _this.getClassNames = function(type) {
      var classNames2 = _this.props.classNames;
      var isStringClassNames = typeof classNames2 === "string";
      var prefix = isStringClassNames && classNames2 ? classNames2 + "-" : "";
      var baseClassName = isStringClassNames ? "" + prefix + type : classNames2[type];
      var activeClassName = isStringClassNames ? baseClassName + "-active" : classNames2[type + "Active"];
      var doneClassName = isStringClassNames ? baseClassName + "-done" : classNames2[type + "Done"];
      return {
        baseClassName,
        activeClassName,
        doneClassName
      };
    };
    return _this;
  }
  var _proto = CSSTransition2.prototype;
  _proto.addClass = function addClass3(node, type, phase) {
    var className = this.getClassNames(type)[phase + "ClassName"];
    var _this$getClassNames = this.getClassNames("enter"), doneClassName = _this$getClassNames.doneClassName;
    if (type === "appear" && phase === "done" && doneClassName) {
      className += " " + doneClassName;
    }
    if (phase === "active") {
      if (node)
        forceReflow(node);
    }
    if (className) {
      this.appliedClasses[type][phase] = className;
      _addClass(node, className);
    }
  };
  _proto.removeClasses = function removeClasses(node, type) {
    var _this$appliedClasses$ = this.appliedClasses[type], baseClassName = _this$appliedClasses$.base, activeClassName = _this$appliedClasses$.active, doneClassName = _this$appliedClasses$.done;
    this.appliedClasses[type] = {};
    if (baseClassName) {
      removeClass2(node, baseClassName);
    }
    if (activeClassName) {
      removeClass2(node, activeClassName);
    }
    if (doneClassName) {
      removeClass2(node, doneClassName);
    }
  };
  _proto.render = function render() {
    var _this$props = this.props, _ = _this$props.classNames, props = _objectWithoutPropertiesLoose(_this$props, ["classNames"]);
    return import_react581.default.createElement(Transition_default, _extends({}, props, {
      onEnter: this.onEnter,
      onEntered: this.onEntered,
      onEntering: this.onEntering,
      onExit: this.onExit,
      onExiting: this.onExiting,
      onExited: this.onExited
    }));
  };
  return CSSTransition2;
}(import_react581.default.Component);
CSSTransition.defaultProps = {
  classNames: ""
};
CSSTransition.propTypes = true ? _extends({}, Transition_default.propTypes, {
  /**
   * The animation classNames applied to the component as it appears, enters,
   * exits or has finished the transition. A single name can be provided, which
   * will be suffixed for each stage, e.g. `classNames="fade"` applies:
   *
   * - `fade-appear`, `fade-appear-active`, `fade-appear-done`
   * - `fade-enter`, `fade-enter-active`, `fade-enter-done`
   * - `fade-exit`, `fade-exit-active`, `fade-exit-done`
   *
   * A few details to note about how these classes are applied:
   *
   * 1. They are _joined_ with the ones that are already defined on the child
   *    component, so if you want to add some base styles, you can use
   *    `className` without worrying that it will be overridden.
   *
   * 2. If the transition component mounts with `in={false}`, no classes are
   *    applied yet. You might be expecting `*-exit-done`, but if you think
   *    about it, a component cannot finish exiting if it hasn't entered yet.
   *
   * 2. `fade-appear-done` and `fade-enter-done` will _both_ be applied. This
   *    allows you to define different behavior for when appearing is done and
   *    when regular entering is done, using selectors like
   *    `.fade-enter-done:not(.fade-appear-done)`. For example, you could apply
   *    an epic entrance animation when element first appears in the DOM using
   *    [Animate.css](https://daneden.github.io/animate.css/). Otherwise you can
   *    simply use `fade-enter-done` for defining both cases.
   *
   * Each individual classNames can also be specified independently like:
   *
   * ```js
   * classNames={{
   *  appear: 'my-appear',
   *  appearActive: 'my-active-appear',
   *  appearDone: 'my-done-appear',
   *  enter: 'my-enter',
   *  enterActive: 'my-active-enter',
   *  enterDone: 'my-done-enter',
   *  exit: 'my-exit',
   *  exitActive: 'my-active-exit',
   *  exitDone: 'my-done-exit',
   * }}
   * ```
   *
   * If you want to set these classes using CSS Modules:
   *
   * ```js
   * import styles from './styles.css';
   * ```
   *
   * you might want to use camelCase in your CSS file, that way could simply
   * spread them instead of listing them one by one:
   *
   * ```js
   * classNames={{ ...styles }}
   * ```
   *
   * @type {string | {
   *  appear?: string,
   *  appearActive?: string,
   *  appearDone?: string,
   *  enter?: string,
   *  enterActive?: string,
   *  enterDone?: string,
   *  exit?: string,
   *  exitActive?: string,
   *  exitDone?: string,
   * }}
   */
  classNames: classNamesShape,
  /**
   * A `<Transition>` callback fired immediately after the 'enter' or 'appear' class is
   * applied.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * @type Function(node: HtmlElement, isAppearing: bool)
   */
  onEnter: import_prop_types3.default.func,
  /**
   * A `<Transition>` callback fired immediately after the 'enter-active' or
   * 'appear-active' class is applied.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * @type Function(node: HtmlElement, isAppearing: bool)
   */
  onEntering: import_prop_types3.default.func,
  /**
   * A `<Transition>` callback fired immediately after the 'enter' or
   * 'appear' classes are **removed** and the `done` class is added to the DOM node.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed.
   *
   * @type Function(node: HtmlElement, isAppearing: bool)
   */
  onEntered: import_prop_types3.default.func,
  /**
   * A `<Transition>` callback fired immediately after the 'exit' class is
   * applied.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed
   *
   * @type Function(node: HtmlElement)
   */
  onExit: import_prop_types3.default.func,
  /**
   * A `<Transition>` callback fired immediately after the 'exit-active' is applied.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed
   *
   * @type Function(node: HtmlElement)
   */
  onExiting: import_prop_types3.default.func,
  /**
   * A `<Transition>` callback fired immediately after the 'exit' classes
   * are **removed** and the `exit-done` class is added to the DOM node.
   *
   * **Note**: when `nodeRef` prop is passed, `node` is not passed
   *
   * @type Function(node: HtmlElement)
   */
  onExited: import_prop_types3.default.func
}) : {};
var CSSTransition_default = CSSTransition;

// ../../node_modules/react-transition-group/esm/ReplaceTransition.js
init_objectWithoutPropertiesLoose();
var import_prop_types5 = __toESM(require_prop_types());
var import_react584 = __toESM(require_react());
var import_react_dom3 = __toESM(require_react_dom());

// ../../node_modules/react-transition-group/esm/TransitionGroup.js
init_objectWithoutPropertiesLoose();
init_extends();

// ../../node_modules/@babel/runtime/helpers/esm/assertThisInitialized.js
function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self;
}

// ../../node_modules/react-transition-group/esm/TransitionGroup.js
var import_prop_types4 = __toESM(require_prop_types());
var import_react583 = __toESM(require_react());

// ../../node_modules/react-transition-group/esm/utils/ChildMapping.js
var import_react582 = __toESM(require_react());
function getChildMapping(children2, mapFn) {
  var mapper = function mapper2(child) {
    return mapFn && (0, import_react582.isValidElement)(child) ? mapFn(child) : child;
  };
  var result = /* @__PURE__ */ Object.create(null);
  if (children2)
    import_react582.Children.map(children2, function(c) {
      return c;
    }).forEach(function(child) {
      result[child.key] = mapper(child);
    });
  return result;
}
function mergeChildMappings(prev, next) {
  prev = prev || {};
  next = next || {};
  function getValueForKey(key) {
    return key in next ? next[key] : prev[key];
  }
  var nextKeysPending = /* @__PURE__ */ Object.create(null);
  var pendingKeys = [];
  for (var prevKey in prev) {
    if (prevKey in next) {
      if (pendingKeys.length) {
        nextKeysPending[prevKey] = pendingKeys;
        pendingKeys = [];
      }
    } else {
      pendingKeys.push(prevKey);
    }
  }
  var i;
  var childMapping = {};
  for (var nextKey in next) {
    if (nextKeysPending[nextKey]) {
      for (i = 0; i < nextKeysPending[nextKey].length; i++) {
        var pendingNextKey = nextKeysPending[nextKey][i];
        childMapping[nextKeysPending[nextKey][i]] = getValueForKey(pendingNextKey);
      }
    }
    childMapping[nextKey] = getValueForKey(nextKey);
  }
  for (i = 0; i < pendingKeys.length; i++) {
    childMapping[pendingKeys[i]] = getValueForKey(pendingKeys[i]);
  }
  return childMapping;
}
function getProp(child, prop, props) {
  return props[prop] != null ? props[prop] : child.props[prop];
}
function getInitialChildMapping(props, onExited) {
  return getChildMapping(props.children, function(child) {
    return (0, import_react582.cloneElement)(child, {
      onExited: onExited.bind(null, child),
      in: true,
      appear: getProp(child, "appear", props),
      enter: getProp(child, "enter", props),
      exit: getProp(child, "exit", props)
    });
  });
}
function getNextChildMapping(nextProps, prevChildMapping, onExited) {
  var nextChildMapping = getChildMapping(nextProps.children);
  var children2 = mergeChildMappings(prevChildMapping, nextChildMapping);
  Object.keys(children2).forEach(function(key) {
    var child = children2[key];
    if (!(0, import_react582.isValidElement)(child))
      return;
    var hasPrev = key in prevChildMapping;
    var hasNext = key in nextChildMapping;
    var prevChild = prevChildMapping[key];
    var isLeaving = (0, import_react582.isValidElement)(prevChild) && !prevChild.props.in;
    if (hasNext && (!hasPrev || isLeaving)) {
      children2[key] = (0, import_react582.cloneElement)(child, {
        onExited: onExited.bind(null, child),
        in: true,
        exit: getProp(child, "exit", nextProps),
        enter: getProp(child, "enter", nextProps)
      });
    } else if (!hasNext && hasPrev && !isLeaving) {
      children2[key] = (0, import_react582.cloneElement)(child, {
        in: false
      });
    } else if (hasNext && hasPrev && (0, import_react582.isValidElement)(prevChild)) {
      children2[key] = (0, import_react582.cloneElement)(child, {
        onExited: onExited.bind(null, child),
        in: prevChild.props.in,
        exit: getProp(child, "exit", nextProps),
        enter: getProp(child, "enter", nextProps)
      });
    }
  });
  return children2;
}

// ../../node_modules/react-transition-group/esm/TransitionGroup.js
var values = Object.values || function(obj) {
  return Object.keys(obj).map(function(k) {
    return obj[k];
  });
};
var defaultProps = {
  component: "div",
  childFactory: function childFactory(child) {
    return child;
  }
};
var TransitionGroup = function(_React$Component) {
  _inheritsLoose(TransitionGroup2, _React$Component);
  function TransitionGroup2(props, context) {
    var _this;
    _this = _React$Component.call(this, props, context) || this;
    var handleExited = _this.handleExited.bind(_assertThisInitialized(_this));
    _this.state = {
      contextValue: {
        isMounting: true
      },
      handleExited,
      firstRender: true
    };
    return _this;
  }
  var _proto = TransitionGroup2.prototype;
  _proto.componentDidMount = function componentDidMount() {
    this.mounted = true;
    this.setState({
      contextValue: {
        isMounting: false
      }
    });
  };
  _proto.componentWillUnmount = function componentWillUnmount() {
    this.mounted = false;
  };
  TransitionGroup2.getDerivedStateFromProps = function getDerivedStateFromProps(nextProps, _ref) {
    var prevChildMapping = _ref.children, handleExited = _ref.handleExited, firstRender = _ref.firstRender;
    return {
      children: firstRender ? getInitialChildMapping(nextProps, handleExited) : getNextChildMapping(nextProps, prevChildMapping, handleExited),
      firstRender: false
    };
  };
  _proto.handleExited = function handleExited(child, node) {
    var currentChildMapping = getChildMapping(this.props.children);
    if (child.key in currentChildMapping)
      return;
    if (child.props.onExited) {
      child.props.onExited(node);
    }
    if (this.mounted) {
      this.setState(function(state) {
        var children2 = _extends({}, state.children);
        delete children2[child.key];
        return {
          children: children2
        };
      });
    }
  };
  _proto.render = function render() {
    var _this$props = this.props, Component9 = _this$props.component, childFactory2 = _this$props.childFactory, props = _objectWithoutPropertiesLoose(_this$props, ["component", "childFactory"]);
    var contextValue = this.state.contextValue;
    var children2 = values(this.state.children).map(childFactory2);
    delete props.appear;
    delete props.enter;
    delete props.exit;
    if (Component9 === null) {
      return import_react583.default.createElement(TransitionGroupContext_default.Provider, {
        value: contextValue
      }, children2);
    }
    return import_react583.default.createElement(TransitionGroupContext_default.Provider, {
      value: contextValue
    }, import_react583.default.createElement(Component9, props, children2));
  };
  return TransitionGroup2;
}(import_react583.default.Component);
TransitionGroup.propTypes = true ? {
  /**
   * `<TransitionGroup>` renders a `<div>` by default. You can change this
   * behavior by providing a `component` prop.
   * If you use React v16+ and would like to avoid a wrapping `<div>` element
   * you can pass in `component={null}`. This is useful if the wrapping div
   * borks your css styles.
   */
  component: import_prop_types4.default.any,
  /**
   * A set of `<Transition>` components, that are toggled `in` and out as they
   * leave. the `<TransitionGroup>` will inject specific transition props, so
   * remember to spread them through if you are wrapping the `<Transition>` as
   * with our `<Fade>` example.
   *
   * While this component is meant for multiple `Transition` or `CSSTransition`
   * children, sometimes you may want to have a single transition child with
   * content that you want to be transitioned out and in when you change it
   * (e.g. routes, images etc.) In that case you can change the `key` prop of
   * the transition child as you change its content, this will cause
   * `TransitionGroup` to transition the child out and back in.
   */
  children: import_prop_types4.default.node,
  /**
   * A convenience prop that enables or disables appear animations
   * for all children. Note that specifying this will override any defaults set
   * on individual children Transitions.
   */
  appear: import_prop_types4.default.bool,
  /**
   * A convenience prop that enables or disables enter animations
   * for all children. Note that specifying this will override any defaults set
   * on individual children Transitions.
   */
  enter: import_prop_types4.default.bool,
  /**
   * A convenience prop that enables or disables exit animations
   * for all children. Note that specifying this will override any defaults set
   * on individual children Transitions.
   */
  exit: import_prop_types4.default.bool,
  /**
   * You may need to apply reactive updates to a child as it is exiting.
   * This is generally done by using `cloneElement` however in the case of an exiting
   * child the element has already been removed and not accessible to the consumer.
   *
   * If you do need to update a child as it leaves you can provide a `childFactory`
   * to wrap every child, even the ones that are leaving.
   *
   * @type Function(child: ReactElement) -> ReactElement
   */
  childFactory: import_prop_types4.default.func
} : {};
TransitionGroup.defaultProps = defaultProps;
var TransitionGroup_default = TransitionGroup;

// ../../node_modules/react-transition-group/esm/ReplaceTransition.js
var ReplaceTransition = function(_React$Component) {
  _inheritsLoose(ReplaceTransition2, _React$Component);
  function ReplaceTransition2() {
    var _this;
    for (var _len = arguments.length, _args = new Array(_len), _key = 0; _key < _len; _key++) {
      _args[_key] = arguments[_key];
    }
    _this = _React$Component.call.apply(_React$Component, [this].concat(_args)) || this;
    _this.handleEnter = function() {
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }
      return _this.handleLifecycle("onEnter", 0, args);
    };
    _this.handleEntering = function() {
      for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        args[_key3] = arguments[_key3];
      }
      return _this.handleLifecycle("onEntering", 0, args);
    };
    _this.handleEntered = function() {
      for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
        args[_key4] = arguments[_key4];
      }
      return _this.handleLifecycle("onEntered", 0, args);
    };
    _this.handleExit = function() {
      for (var _len5 = arguments.length, args = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
        args[_key5] = arguments[_key5];
      }
      return _this.handleLifecycle("onExit", 1, args);
    };
    _this.handleExiting = function() {
      for (var _len6 = arguments.length, args = new Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
        args[_key6] = arguments[_key6];
      }
      return _this.handleLifecycle("onExiting", 1, args);
    };
    _this.handleExited = function() {
      for (var _len7 = arguments.length, args = new Array(_len7), _key7 = 0; _key7 < _len7; _key7++) {
        args[_key7] = arguments[_key7];
      }
      return _this.handleLifecycle("onExited", 1, args);
    };
    return _this;
  }
  var _proto = ReplaceTransition2.prototype;
  _proto.handleLifecycle = function handleLifecycle(handler, idx, originalArgs) {
    var _child$props;
    var children2 = this.props.children;
    var child = import_react584.default.Children.toArray(children2)[idx];
    if (child.props[handler])
      (_child$props = child.props)[handler].apply(_child$props, originalArgs);
    if (this.props[handler]) {
      var maybeNode = child.props.nodeRef ? void 0 : import_react_dom3.default.findDOMNode(this);
      this.props[handler](maybeNode);
    }
  };
  _proto.render = function render() {
    var _this$props = this.props, children2 = _this$props.children, inProp = _this$props.in, props = _objectWithoutPropertiesLoose(_this$props, ["children", "in"]);
    var _React$Children$toArr = import_react584.default.Children.toArray(children2), first = _React$Children$toArr[0], second = _React$Children$toArr[1];
    delete props.onEnter;
    delete props.onEntering;
    delete props.onEntered;
    delete props.onExit;
    delete props.onExiting;
    delete props.onExited;
    return import_react584.default.createElement(TransitionGroup_default, props, inProp ? import_react584.default.cloneElement(first, {
      key: "first",
      onEnter: this.handleEnter,
      onEntering: this.handleEntering,
      onEntered: this.handleEntered
    }) : import_react584.default.cloneElement(second, {
      key: "second",
      onEnter: this.handleExit,
      onEntering: this.handleExiting,
      onEntered: this.handleExited
    }));
  };
  return ReplaceTransition2;
}(import_react584.default.Component);
ReplaceTransition.propTypes = true ? {
  in: import_prop_types5.default.bool.isRequired,
  children: function children(props, propName) {
    if (import_react584.default.Children.count(props[propName]) !== 2)
      return new Error('"' + propName + '" must be exactly two transition components.');
    return null;
  }
} : {};

// ../../node_modules/react-transition-group/esm/SwitchTransition.js
var import_react585 = __toESM(require_react());
var import_prop_types6 = __toESM(require_prop_types());
var _leaveRenders;
var _enterRenders;
function areChildrenDifferent(oldChildren, newChildren) {
  if (oldChildren === newChildren)
    return false;
  if (import_react585.default.isValidElement(oldChildren) && import_react585.default.isValidElement(newChildren) && oldChildren.key != null && oldChildren.key === newChildren.key) {
    return false;
  }
  return true;
}
var modes = {
  out: "out-in",
  in: "in-out"
};
var callHook = function callHook2(element, name, cb) {
  return function() {
    var _element$props;
    element.props[name] && (_element$props = element.props)[name].apply(_element$props, arguments);
    cb();
  };
};
var leaveRenders = (_leaveRenders = {}, _leaveRenders[modes.out] = function(_ref) {
  var current = _ref.current, changeState = _ref.changeState;
  return import_react585.default.cloneElement(current, {
    in: false,
    onExited: callHook(current, "onExited", function() {
      changeState(ENTERING, null);
    })
  });
}, _leaveRenders[modes.in] = function(_ref2) {
  var current = _ref2.current, changeState = _ref2.changeState, children2 = _ref2.children;
  return [current, import_react585.default.cloneElement(children2, {
    in: true,
    onEntered: callHook(children2, "onEntered", function() {
      changeState(ENTERING);
    })
  })];
}, _leaveRenders);
var enterRenders = (_enterRenders = {}, _enterRenders[modes.out] = function(_ref3) {
  var children2 = _ref3.children, changeState = _ref3.changeState;
  return import_react585.default.cloneElement(children2, {
    in: true,
    onEntered: callHook(children2, "onEntered", function() {
      changeState(ENTERED, import_react585.default.cloneElement(children2, {
        in: true
      }));
    })
  });
}, _enterRenders[modes.in] = function(_ref4) {
  var current = _ref4.current, children2 = _ref4.children, changeState = _ref4.changeState;
  return [import_react585.default.cloneElement(current, {
    in: false,
    onExited: callHook(current, "onExited", function() {
      changeState(ENTERED, import_react585.default.cloneElement(children2, {
        in: true
      }));
    })
  }), import_react585.default.cloneElement(children2, {
    in: true
  })];
}, _enterRenders);
var SwitchTransition = function(_React$Component) {
  _inheritsLoose(SwitchTransition2, _React$Component);
  function SwitchTransition2() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;
    _this.state = {
      status: ENTERED,
      current: null
    };
    _this.appeared = false;
    _this.changeState = function(status, current) {
      if (current === void 0) {
        current = _this.state.current;
      }
      _this.setState({
        status,
        current
      });
    };
    return _this;
  }
  var _proto = SwitchTransition2.prototype;
  _proto.componentDidMount = function componentDidMount() {
    this.appeared = true;
  };
  SwitchTransition2.getDerivedStateFromProps = function getDerivedStateFromProps(props, state) {
    if (props.children == null) {
      return {
        current: null
      };
    }
    if (state.status === ENTERING && props.mode === modes.in) {
      return {
        status: ENTERING
      };
    }
    if (state.current && areChildrenDifferent(state.current, props.children)) {
      return {
        status: EXITING
      };
    }
    return {
      current: import_react585.default.cloneElement(props.children, {
        in: true
      })
    };
  };
  _proto.render = function render() {
    var _this$props = this.props, children2 = _this$props.children, mode = _this$props.mode, _this$state = this.state, status = _this$state.status, current = _this$state.current;
    var data = {
      children: children2,
      current,
      changeState: this.changeState,
      status
    };
    var component;
    switch (status) {
      case ENTERING:
        component = enterRenders[mode](data);
        break;
      case EXITING:
        component = leaveRenders[mode](data);
        break;
      case ENTERED:
        component = current;
    }
    return import_react585.default.createElement(TransitionGroupContext_default.Provider, {
      value: {
        isMounting: !this.appeared
      }
    }, component);
  };
  return SwitchTransition2;
}(import_react585.default.Component);
SwitchTransition.propTypes = true ? {
  /**
   * Transition modes.
   * `out-in`: Current element transitions out first, then when complete, the new element transitions in.
   * `in-out`: New element transitions in first, then when complete, the current element transitions out.
   *
   * @type {'out-in'|'in-out'}
   */
  mode: import_prop_types6.default.oneOf([modes.in, modes.out]),
  /**
   * Any `Transition` or `CSSTransition` component.
   */
  children: import_prop_types6.default.oneOfType([import_prop_types6.default.element.isRequired])
} : {};
SwitchTransition.defaultProps = {
  mode: modes.out
};

// ../node_modules/@shopify/polaris/build/esm/components/Modal/Modal.scss.js
var styles32 = {
  "Body": "Polaris-Modal__Body",
  "IFrame": "Polaris-Modal__IFrame"
};

// ../node_modules/@shopify/polaris/build/esm/components/Modal/components/Section/Section.js
var import_react586 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Modal/components/Section/Section.scss.js
var styles33 = {
  "Section": "Polaris-Modal-Section",
  "titleHidden": "Polaris-Modal-Section--titleHidden"
};

// ../node_modules/@shopify/polaris/build/esm/components/Modal/components/Section/Section.js
function Section3({
  children: children2,
  flush = false,
  subdued = false,
  titleHidden = false
}) {
  const className = classNames(styles33.Section, titleHidden && styles33.titleHidden);
  return import_react586.default.createElement("div", {
    className
  }, import_react586.default.createElement(Box, Object.assign({
    as: "section",
    padding: flush ? "0" : "5"
  }, titleHidden && {
    paddingInlineEnd: "0"
  }, subdued && {
    background: "bg-subdued"
  }), children2));
}

// ../node_modules/@shopify/polaris/build/esm/components/Modal/components/Dialog/Dialog.js
var import_react590 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Modal/components/Dialog/Dialog.scss.js
var styles34 = {
  "Container": "Polaris-Modal-Dialog__Container",
  "Dialog": "Polaris-Modal-Dialog",
  "Modal": "Polaris-Modal-Dialog__Modal",
  "limitHeight": "Polaris-Modal-Dialog--limitHeight",
  "sizeSmall": "Polaris-Modal-Dialog--sizeSmall",
  "sizeLarge": "Polaris-Modal-Dialog--sizeLarge",
  "fullScreen": "Polaris-Modal-Dialog--fullScreen",
  "animateFadeUp": "Polaris-Modal-Dialog--animateFadeUp",
  "entering": "Polaris-Modal-Dialog--entering",
  "exiting": "Polaris-Modal-Dialog--exiting",
  "exited": "Polaris-Modal-Dialog--exited",
  "entered": "Polaris-Modal-Dialog--entered"
};

// ../node_modules/@shopify/polaris/build/esm/components/TrapFocus/TrapFocus.js
var import_react589 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/focus-manager/hooks.js
var import_react587 = __toESM(require_react());
function useFocusManager({
  trapping
}) {
  const focusManager = (0, import_react587.useContext)(FocusManagerContext);
  const id = useUniqueId();
  if (!focusManager) {
    throw new MissingAppProviderError("No FocusManager was provided.");
  }
  const {
    trapFocusList,
    add: addFocusItem,
    remove: removeFocusItem
  } = focusManager;
  const canSafelyFocus = trapFocusList[0] === id;
  const value = (0, import_react587.useMemo)(() => ({
    canSafelyFocus
  }), [canSafelyFocus]);
  (0, import_react587.useEffect)(() => {
    if (!trapping)
      return;
    addFocusItem(id);
    return () => {
      removeFocusItem(id);
    };
  }, [addFocusItem, id, removeFocusItem, trapping]);
  return value;
}

// ../node_modules/@shopify/polaris/build/esm/components/Focus/Focus.js
var import_react588 = __toESM(require_react());
var Focus = (0, import_react588.memo)(function Focus2({
  children: children2,
  disabled,
  root
}) {
  (0, import_react588.useEffect)(() => {
    if (disabled || !root) {
      return;
    }
    const node = isRef(root) ? root.current : root;
    if (!node || node.querySelector("[autofocus]")) {
      return;
    }
    focusFirstFocusableNode(node, false);
  }, [disabled, root]);
  return import_react588.default.createElement(import_react588.default.Fragment, null, children2);
});
function isRef(ref) {
  return ref.current !== void 0;
}

// ../node_modules/@shopify/polaris/build/esm/components/TrapFocus/TrapFocus.js
function TrapFocus({
  trapping = true,
  children: children2
}) {
  const {
    canSafelyFocus
  } = useFocusManager({
    trapping
  });
  const focusTrapWrapper = (0, import_react589.useRef)(null);
  const [disableFocus, setDisableFocus] = (0, import_react589.useState)(true);
  (0, import_react589.useEffect)(() => {
    const disable = canSafelyFocus && !(focusTrapWrapper.current && focusTrapWrapper.current.contains(document.activeElement)) ? !trapping : true;
    setDisableFocus(disable);
  }, [canSafelyFocus, trapping]);
  const handleFocusIn = (event) => {
    const containerContentsHaveFocus = focusTrapWrapper.current && focusTrapWrapper.current.contains(document.activeElement);
    if (trapping === false || !focusTrapWrapper.current || containerContentsHaveFocus || event.target instanceof Element && event.target.matches(`${portal.selector} *`)) {
      return;
    }
    if (canSafelyFocus && event.target instanceof HTMLElement && focusTrapWrapper.current !== event.target && !focusTrapWrapper.current.contains(event.target)) {
      focusFirstFocusableNode(focusTrapWrapper.current);
    }
  };
  const handleTab = (event) => {
    if (trapping === false || !focusTrapWrapper.current) {
      return;
    }
    const firstFocusableNode = findFirstKeyboardFocusableNode(focusTrapWrapper.current);
    const lastFocusableNode = findLastKeyboardFocusableNode(focusTrapWrapper.current);
    if (event.target === lastFocusableNode && !event.shiftKey) {
      event.preventDefault();
      focusFirstKeyboardFocusableNode(focusTrapWrapper.current);
    }
    if (event.target === firstFocusableNode && event.shiftKey) {
      event.preventDefault();
      focusLastKeyboardFocusableNode(focusTrapWrapper.current);
    }
  };
  return import_react589.default.createElement(Focus, {
    disabled: disableFocus,
    root: focusTrapWrapper.current
  }, import_react589.default.createElement("div", {
    ref: focusTrapWrapper
  }, import_react589.default.createElement(EventListener, {
    event: "focusin",
    handler: handleFocusIn
  }), import_react589.default.createElement(KeypressListener, {
    keyCode: Key.Tab,
    keyEvent: "keydown",
    handler: handleTab
  }), children2));
}

// ../node_modules/@shopify/polaris/build/esm/components/Modal/components/Dialog/Dialog.js
function Dialog({
  instant,
  labelledBy,
  children: children2,
  onClose,
  onExited,
  onEntered,
  large,
  small,
  limitHeight,
  fullScreen,
  setClosing,
  ...props
}) {
  const containerNode = (0, import_react590.useRef)(null);
  const classes = classNames(styles34.Modal, small && styles34.sizeSmall, large && styles34.sizeLarge, limitHeight && styles34.limitHeight, fullScreen && styles34.fullScreen);
  const TransitionChild = instant ? Transition_default : FadeUp;
  (0, import_react590.useEffect)(() => {
    containerNode.current && !containerNode.current.contains(document.activeElement) && focusFirstFocusableNode(containerNode.current);
  }, []);
  const handleKeyDown7 = () => {
    if (setClosing) {
      setClosing(true);
    }
  };
  const handleKeyUp = () => {
    if (setClosing) {
      setClosing(false);
    }
    onClose();
  };
  return import_react590.default.createElement(TransitionChild, Object.assign({}, props, {
    nodeRef: containerNode,
    mountOnEnter: true,
    unmountOnExit: true,
    timeout: parseInt(motion2["duration-200"], 10),
    onEntered,
    onExited
  }), import_react590.default.createElement("div", {
    className: styles34.Container,
    "data-polaris-layer": true,
    "data-polaris-overlay": true,
    ref: containerNode
  }, import_react590.default.createElement(TrapFocus, null, import_react590.default.createElement("div", {
    role: "dialog",
    "aria-modal": true,
    "aria-label": labelledBy,
    "aria-labelledby": labelledBy,
    tabIndex: -1,
    className: styles34.Dialog
  }, import_react590.default.createElement("div", {
    className: classes
  }, import_react590.default.createElement(KeypressListener, {
    keyCode: Key.Escape,
    keyEvent: "keydown",
    handler: handleKeyDown7
  }), import_react590.default.createElement(KeypressListener, {
    keyCode: Key.Escape,
    handler: handleKeyUp
  }), children2)))));
}
var fadeUpClasses = {
  appear: classNames(styles34.animateFadeUp, styles34.entering),
  appearActive: classNames(styles34.animateFadeUp, styles34.entered),
  enter: classNames(styles34.animateFadeUp, styles34.entering),
  enterActive: classNames(styles34.animateFadeUp, styles34.entered),
  exit: classNames(styles34.animateFadeUp, styles34.exiting),
  exitActive: classNames(styles34.animateFadeUp, styles34.exited)
};
function FadeUp({
  children: children2,
  ...props
}) {
  return import_react590.default.createElement(CSSTransition_default, Object.assign({}, props, {
    classNames: fadeUpClasses
  }), children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/Modal/components/Header/Header.js
var import_react593 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/HorizontalGrid/HorizontalGrid.js
var import_react591 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/HorizontalGrid/HorizontalGrid.scss.js
var styles35 = {
  "HorizontalGrid": "Polaris-HorizontalGrid"
};

// ../node_modules/@shopify/polaris/build/esm/components/HorizontalGrid/HorizontalGrid.js
function HorizontalGrid({
  children: children2,
  columns,
  gap,
  alignItems
}) {
  const style = {
    ...getResponsiveValue("horizontal-grid", "grid-template-columns", formatHorizontalGrid(columns)),
    ...getResponsiveProps("horizontal-grid", "gap", "space", gap),
    "--pc-horizontal-grid-align-items": alignItems
  };
  return import_react591.default.createElement("div", {
    className: styles35.HorizontalGrid,
    style: sanitizeCustomProperties(style)
  }, children2);
}
function formatHorizontalGrid(columns) {
  if (typeof columns === "object" && columns !== null && !Array.isArray(columns)) {
    return Object.fromEntries(Object.entries(columns).map(([breakpointAlias, breakpointHorizontalGrid]) => [breakpointAlias, getColumnValue(breakpointHorizontalGrid)]));
  }
  return getColumnValue(columns);
}
function getColumnValue(columns) {
  if (!columns)
    return void 0;
  if (typeof columns === "number" || !isNaN(Number(columns))) {
    return `repeat(${Number(columns)}, minmax(0, 1fr))`;
  }
  if (typeof columns === "string")
    return columns;
  return columns.map((column) => {
    switch (column) {
      case "oneThird":
        return "minmax(0, 1fr)";
      case "oneHalf":
        return "minmax(0, 1fr)";
      case "twoThirds":
        return "minmax(0, 2fr)";
    }
  }).join(" ");
}

// ../node_modules/@shopify/polaris/build/esm/components/Modal/components/CloseButton/CloseButton.js
var import_react592 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Modal/components/CloseButton/CloseButton.scss.js
var styles36 = {
  "CloseButton": "Polaris-Modal-CloseButton",
  "pressed": "Polaris-Modal-CloseButton--pressed",
  "titleHidden": "Polaris-Modal-CloseButton--titleHidden"
};

// ../node_modules/@shopify/polaris/build/esm/components/Modal/components/CloseButton/CloseButton.js
function CloseButton({
  pressed,
  titleHidden = false,
  onClick
}) {
  const i18n = useI18n();
  return import_react592.default.createElement("button", {
    onClick,
    className: classNames(styles36.CloseButton, titleHidden && styles36.titleHidden, pressed && styles36.pressed),
    "aria-label": i18n.translate("Polaris.Common.close")
  }, import_react592.default.createElement(Icon, {
    source: SvgMobileCancelMajor,
    color: "base"
  }));
}

// ../node_modules/@shopify/polaris/build/esm/components/Modal/components/Header/Header.js
function Header({
  id,
  children: children2,
  closing,
  titleHidden,
  onClose
}) {
  const titleHiddenMarkup = import_react593.default.createElement(Box, {
    position: "absolute",
    insetInlineEnd: "0",
    zIndex: "1"
  }, import_react593.default.createElement(HorizontalStack, {
    gap: "4",
    align: "end",
    blockAlign: "center"
  }, import_react593.default.createElement(CloseButton, {
    titleHidden,
    onClick: onClose
  })));
  if (titleHidden || !children2) {
    return titleHiddenMarkup;
  }
  return import_react593.default.createElement(Box, {
    paddingBlockStart: "4",
    paddingBlockEnd: "4",
    paddingInlineStart: "5",
    paddingInlineEnd: "5",
    borderBlockEndWidth: "1",
    borderColor: "border-subdued"
  }, import_react593.default.createElement(HorizontalGrid, {
    columns: {
      xs: "1fr auto"
    },
    gap: "4"
  }, import_react593.default.createElement(HorizontalStack, {
    gap: "4",
    blockAlign: "center"
  }, import_react593.default.createElement(Text, {
    id,
    as: "h2",
    variant: "headingLg",
    breakWord: true
  }, children2)), import_react593.default.createElement(CloseButton, {
    pressed: closing,
    titleHidden,
    onClick: onClose
  })));
}

// ../node_modules/@shopify/polaris/build/esm/components/Backdrop/Backdrop.js
var import_react596 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Backdrop/Backdrop.scss.js
var styles37 = {
  "Backdrop": "Polaris-Backdrop",
  "transparent": "Polaris-Backdrop--transparent",
  "belowNavigation": "Polaris-Backdrop--belowNavigation"
};

// ../node_modules/@shopify/polaris/build/esm/components/ScrollLock/ScrollLock.js
var import_react595 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/scroll-lock-manager/hooks.js
var import_react594 = __toESM(require_react());
function useScrollLockManager() {
  const scrollLockManager = (0, import_react594.useContext)(ScrollLockManagerContext);
  if (!scrollLockManager) {
    throw new MissingAppProviderError("No ScrollLockManager was provided.");
  }
  return scrollLockManager;
}

// ../node_modules/@shopify/polaris/build/esm/components/ScrollLock/ScrollLock.js
function ScrollLock(_) {
  const scrollLockManager = useScrollLockManager();
  (0, import_react595.useEffect)(() => {
    scrollLockManager.registerScrollLock();
    return () => {
      scrollLockManager.unregisterScrollLock();
    };
  }, [scrollLockManager]);
  return null;
}

// ../node_modules/@shopify/polaris/build/esm/components/Backdrop/Backdrop.js
function Backdrop(props) {
  const {
    onClick,
    onTouchStart,
    belowNavigation,
    transparent,
    setClosing
  } = props;
  const className = classNames(styles37.Backdrop, belowNavigation && styles37.belowNavigation, transparent && styles37.transparent);
  const handleMouseDown = () => {
    if (setClosing) {
      setClosing(true);
    }
  };
  const handleClick = () => {
    if (setClosing) {
      setClosing(false);
    }
    if (onClick) {
      onClick();
    }
  };
  return import_react596.default.createElement(import_react596.default.Fragment, null, import_react596.default.createElement(ScrollLock, null), import_react596.default.createElement("div", {
    className,
    onClick: handleClick,
    onTouchStart,
    onMouseDown: handleMouseDown
  }));
}

// ../node_modules/@shopify/polaris/build/esm/components/Modal/components/Footer/Footer.js
var import_react597 = __toESM(require_react());
function Footer({
  primaryAction,
  secondaryActions,
  children: children2
}) {
  const primaryActionButton = primaryAction && buttonsFrom(primaryAction, {
    primary: true
  }) || null;
  const secondaryActionButtons = secondaryActions && buttonsFrom(secondaryActions) || null;
  const actions = primaryActionButton || secondaryActionButtons ? import_react597.default.createElement(HorizontalStack, {
    gap: "2"
  }, secondaryActionButtons, primaryActionButton) : null;
  return import_react597.default.createElement(HorizontalStack, {
    gap: "4",
    blockAlign: "center"
  }, import_react597.default.createElement(Box, {
    borderColor: "border-subdued",
    borderBlockStartWidth: "1",
    minHeight: "var(--p-space-16)",
    padding: "4",
    width: "100%"
  }, import_react597.default.createElement(HorizontalStack, {
    gap: "4",
    blockAlign: "center",
    align: "space-between"
  }, import_react597.default.createElement(Box, null, children2), actions)));
}

// ../node_modules/@shopify/polaris/build/esm/components/Modal/Modal.js
var IFRAME_LOADING_HEIGHT = 200;
var DEFAULT_IFRAME_CONTENT_HEIGHT = 400;
var Modal = function Modal2({
  children: children2,
  title,
  titleHidden = false,
  src,
  iFrameName,
  open,
  instant,
  sectioned,
  loading,
  large,
  small,
  limitHeight,
  footer,
  primaryAction,
  secondaryActions,
  onScrolledToBottom,
  activator,
  onClose,
  onIFrameLoad,
  onTransitionEnd,
  noScroll,
  fullScreen
}) {
  const [iframeHeight, setIframeHeight] = (0, import_react598.useState)(IFRAME_LOADING_HEIGHT);
  const [closing, setClosing] = (0, import_react598.useState)(false);
  const headerId = useUniqueId("modal-header");
  const activatorRef = (0, import_react598.useRef)(null);
  const i18n = useI18n();
  const iframeTitle = i18n.translate("Polaris.Modal.iFrameTitle");
  let dialog;
  let backdrop;
  const handleEntered = (0, import_react598.useCallback)(() => {
    if (onTransitionEnd) {
      onTransitionEnd();
    }
  }, [onTransitionEnd]);
  const handleExited = (0, import_react598.useCallback)(() => {
    setIframeHeight(IFRAME_LOADING_HEIGHT);
    const activatorElement = activator && isRef2(activator) ? activator && activator.current : activatorRef.current;
    if (activatorElement) {
      requestAnimationFrame(() => focusFirstFocusableNode(activatorElement));
    }
  }, [activator]);
  const handleIFrameLoad = (0, import_react598.useCallback)((evt) => {
    const iframe = evt.target;
    if (iframe && iframe.contentWindow) {
      try {
        setIframeHeight(iframe.contentWindow.document.body.scrollHeight);
      } catch (_error) {
        setIframeHeight(DEFAULT_IFRAME_CONTENT_HEIGHT);
      }
    }
    if (onIFrameLoad != null) {
      onIFrameLoad(evt);
    }
  }, [onIFrameLoad]);
  if (open) {
    const footerMarkup = !footer && !primaryAction && !secondaryActions ? null : import_react598.default.createElement(Footer, {
      primaryAction,
      secondaryActions
    }, footer);
    const content = sectioned ? wrapWithComponent(children2, Section3, {
      titleHidden
    }) : children2;
    const body = loading ? import_react598.default.createElement(Box, {
      padding: "4"
    }, import_react598.default.createElement(HorizontalStack, {
      gap: "4",
      align: "center",
      blockAlign: "center"
    }, import_react598.default.createElement(Spinner, null))) : content;
    const scrollContainerMarkup = noScroll ? import_react598.default.createElement(Box, {
      width: "100%",
      overflowX: "hidden"
    }, body) : import_react598.default.createElement(Scrollable, {
      shadow: true,
      className: styles32.Body,
      onScrolledToBottom
    }, body);
    const bodyMarkup = src ? import_react598.default.createElement("iframe", {
      name: iFrameName,
      title: iframeTitle,
      src,
      className: styles32.IFrame,
      onLoad: handleIFrameLoad,
      style: {
        height: `${iframeHeight}px`
      }
    }) : scrollContainerMarkup;
    dialog = import_react598.default.createElement(Dialog, {
      instant,
      labelledBy: headerId,
      onClose,
      onEntered: handleEntered,
      onExited: handleExited,
      large,
      small,
      limitHeight,
      fullScreen,
      setClosing
    }, import_react598.default.createElement(Header, {
      titleHidden,
      id: headerId,
      closing,
      onClose
    }, title), bodyMarkup, footerMarkup);
    backdrop = import_react598.default.createElement(Backdrop, {
      setClosing,
      onClick: onClose
    });
  }
  const animated = !instant;
  const activatorMarkup = activator && !isRef2(activator) ? import_react598.default.createElement(Box, {
    ref: activatorRef
  }, activator) : null;
  return import_react598.default.createElement(WithinContentContext.Provider, {
    value: true
  }, activatorMarkup, import_react598.default.createElement(Portal, {
    idPrefix: "modal"
  }, import_react598.default.createElement(TransitionGroup_default, {
    appear: animated,
    enter: animated,
    exit: animated
  }, dialog), backdrop));
};
function isRef2(ref) {
  return Object.prototype.hasOwnProperty.call(ref, "current");
}
Modal.Section = Section3;

// ../node_modules/@shopify/polaris/build/esm/components/Form/Form.js
var import_react599 = __toESM(require_react());
function Form({
  acceptCharset,
  action,
  autoComplete,
  children: children2,
  encType,
  implicitSubmit = true,
  method = "post",
  name,
  noValidate,
  preventDefault: preventDefault2 = true,
  target,
  onSubmit
}) {
  const i18n = useI18n();
  const handleSubmit = (0, import_react599.useCallback)((event) => {
    if (!preventDefault2) {
      return;
    }
    event.preventDefault();
    onSubmit(event);
  }, [onSubmit, preventDefault2]);
  const autoCompleteInputs = normalizeAutoComplete(autoComplete);
  const submitMarkup = implicitSubmit ? import_react599.default.createElement(Text, {
    as: "span",
    visuallyHidden: true
  }, import_react599.default.createElement("button", {
    type: "submit",
    "aria-hidden": "true",
    tabIndex: -1
  }, i18n.translate("Polaris.Common.submit"))) : null;
  return import_react599.default.createElement("form", {
    acceptCharset,
    action,
    autoComplete: autoCompleteInputs,
    encType,
    method,
    name,
    noValidate,
    target,
    onSubmit: handleSubmit
  }, submitMarkup, children2);
}
function normalizeAutoComplete(autoComplete) {
  if (autoComplete == null) {
    return autoComplete;
  }
  return autoComplete ? "on" : "off";
}

// ../node_modules/@shopify/polaris/build/esm/components/FormLayout/FormLayout.js
var import_react602 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/FormLayout/FormLayout.scss.js
var styles38 = {
  "FormLayout": "Polaris-FormLayout",
  "Title": "Polaris-FormLayout__Title",
  "Items": "Polaris-FormLayout__Items",
  "Item": "Polaris-FormLayout__Item",
  "grouped": "Polaris-FormLayout--grouped",
  "condensed": "Polaris-FormLayout--condensed"
};

// ../node_modules/@shopify/polaris/build/esm/components/FormLayout/components/Group/Group.js
var import_react601 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/FormLayout/components/Item/Item.js
var import_react600 = __toESM(require_react());
function Item4({
  children: children2
}) {
  return children2 ? import_react600.default.createElement("div", {
    className: styles38.Item
  }, children2) : null;
}

// ../node_modules/@shopify/polaris/build/esm/components/FormLayout/components/Group/Group.js
function Group({
  children: children2,
  condensed,
  title,
  helpText
}) {
  const className = classNames(condensed ? styles38.condensed : styles38.grouped);
  const id = useUniqueId("FormLayoutGroup");
  let helpTextElement = null;
  let helpTextID3;
  let titleElement = null;
  let titleID;
  if (helpText) {
    helpTextID3 = `${id}HelpText`;
    helpTextElement = import_react601.default.createElement(Box, {
      id: helpTextID3,
      paddingBlockStart: "2",
      paddingInlineStart: "5",
      paddingBlockEnd: "0",
      paddingInlineEnd: "5",
      color: "text-subdued"
    }, helpText);
  }
  if (title) {
    titleID = `${id}Title`;
    titleElement = import_react601.default.createElement("div", {
      id: titleID,
      className: styles38.Title
    }, title);
  }
  const itemsMarkup = import_react601.Children.map(children2, (child) => wrapWithComponent(child, Item4, {}));
  return import_react601.default.createElement("div", {
    role: "group",
    className,
    "aria-labelledby": titleID,
    "aria-describedby": helpTextID3
  }, titleElement, import_react601.default.createElement("div", {
    className: styles38.Items
  }, itemsMarkup), helpTextElement);
}

// ../node_modules/@shopify/polaris/build/esm/components/FormLayout/FormLayout.js
var FormLayout = (0, import_react602.memo)(function FormLayout2({
  children: children2
}) {
  return import_react602.default.createElement("div", {
    className: styles38.FormLayout
  }, import_react602.Children.map(children2, wrapChildren));
});
FormLayout.Group = Group;
function wrapChildren(child, index) {
  if (isElementOfType(child, Group)) {
    return child;
  }
  const props = {
    key: index
  };
  return wrapWithComponent(child, Item4, props);
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaTabs/components/Tab/components/DuplicateModal/DuplicateModal.js
var MAX_VIEW_NAME_LENGTH = 40;
function DuplicateModal({
  open,
  isModalLoading,
  name,
  onClose,
  onClickPrimaryAction,
  onClickSecondaryAction,
  helpText,
  viewNames
}) {
  const i18n = useI18n();
  const [value, setValue] = (0, import_react603.useState)(name);
  const container = (0, import_react603.useRef)(null);
  const hasSameNameError = viewNames === null || viewNames === void 0 ? void 0 : viewNames.some((viewName) => viewName.trim().toLowerCase() === value.trim().toLowerCase());
  const isPrimaryActionDisabled = isModalLoading || hasSameNameError || !value || value.length > MAX_VIEW_NAME_LENGTH;
  (0, import_react603.useEffect)(() => {
    if (!container.current)
      return;
    if (open) {
      focusFirstFocusableNode(container.current);
    }
  }, [open]);
  (0, import_react603.useEffect)(() => {
    if (open) {
      setValue(name.slice(0, MAX_VIEW_NAME_LENGTH));
    }
  }, [name, open]);
  const handleChange = (0, import_react603.useCallback)((newValue) => {
    setValue(newValue);
  }, []);
  async function handlePrimaryAction() {
    if (isPrimaryActionDisabled) {
      return;
    }
    await onClickPrimaryAction(value);
    setValue("");
    onClose();
  }
  function handleSecondaryAction() {
    onClickSecondaryAction === null || onClickSecondaryAction === void 0 ? void 0 : onClickSecondaryAction();
    setValue(name);
    onClose();
  }
  return import_react603.default.createElement(Modal, {
    open,
    onClose,
    title: i18n.translate("Polaris.Tabs.DuplicateModal.title"),
    primaryAction: {
      content: i18n.translate("Polaris.Tabs.DuplicateModal.create"),
      onAction: handlePrimaryAction,
      disabled: isPrimaryActionDisabled
    },
    secondaryActions: [{
      content: i18n.translate("Polaris.Tabs.DuplicateModal.cancel"),
      onAction: handleSecondaryAction
    }],
    instant: true
  }, import_react603.default.createElement(Modal.Section, null, import_react603.default.createElement(Form, {
    onSubmit: handlePrimaryAction
  }, import_react603.default.createElement(FormLayout, null, import_react603.default.createElement("div", {
    ref: container
  }, import_react603.default.createElement(TextField, {
    label: i18n.translate("Polaris.Tabs.DuplicateModal.label"),
    value,
    onChange: handleChange,
    autoComplete: "off",
    helpText,
    maxLength: MAX_VIEW_NAME_LENGTH,
    showCharacterCount: true,
    error: hasSameNameError ? i18n.translate("Polaris.Tabs.DuplicateModal.errors.sameName", {
      name: value
    }) : void 0
  }))))));
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaTabs/components/Tab/components/RenameModal/RenameModal.js
var import_react604 = __toESM(require_react());
function RenameModal({
  open,
  isModalLoading,
  name,
  onClose,
  onClickPrimaryAction,
  onClickSecondaryAction,
  helpText,
  viewNames
}) {
  const i18n = useI18n();
  const [value, setValue] = (0, import_react604.useState)(name);
  const container = (0, import_react604.useRef)(null);
  const hasSameNameError = viewNames === null || viewNames === void 0 ? void 0 : viewNames.filter((viewName) => viewName !== name).some((viewName) => viewName.trim().toLowerCase() === value.trim().toLowerCase());
  const isPrimaryActionDisabled = isModalLoading || hasSameNameError || value === name || !value;
  (0, import_react604.useEffect)(() => {
    if (!container.current)
      return;
    if (open) {
      focusFirstFocusableNode(container.current);
    }
  }, [open]);
  (0, import_react604.useEffect)(() => {
    if (open) {
      setValue(name);
    }
  }, [name, open]);
  const handleChange = (0, import_react604.useCallback)((newValue) => {
    setValue(newValue);
  }, []);
  async function handlePrimaryAction() {
    if (isPrimaryActionDisabled) {
      return;
    }
    await onClickPrimaryAction(value);
    setValue("");
    onClose();
  }
  function handleSecondaryAction() {
    onClickSecondaryAction === null || onClickSecondaryAction === void 0 ? void 0 : onClickSecondaryAction();
    setValue(name);
    onClose();
  }
  return import_react604.default.createElement(Modal, {
    open,
    onClose,
    title: i18n.translate("Polaris.Tabs.RenameModal.title"),
    primaryAction: {
      content: i18n.translate("Polaris.Tabs.RenameModal.create"),
      onAction: handlePrimaryAction,
      disabled: isPrimaryActionDisabled
    },
    secondaryActions: [{
      content: i18n.translate("Polaris.Tabs.RenameModal.cancel"),
      onAction: handleSecondaryAction
    }],
    instant: true
  }, import_react604.default.createElement(Modal.Section, null, import_react604.default.createElement(Form, {
    onSubmit: handlePrimaryAction
  }, import_react604.default.createElement(FormLayout, null, import_react604.default.createElement("div", {
    ref: container
  }, import_react604.default.createElement(TextField, {
    label: i18n.translate("Polaris.Tabs.RenameModal.label"),
    value,
    onChange: handleChange,
    autoComplete: "off",
    helpText,
    maxLength: 40,
    showCharacterCount: true,
    error: hasSameNameError ? i18n.translate("Polaris.Tabs.RenameModal.errors.sameName", {
      name: value
    }) : void 0
  }))))));
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaTabs/components/Tab/Tab.js
var Tab = (0, import_react605.forwardRef)(({
  content,
  accessibilityLabel,
  badge,
  id,
  panelID,
  url,
  onAction,
  actions,
  disabled,
  isModalLoading,
  icon,
  siblingTabHasFocus,
  measuring,
  focused,
  selected,
  onToggleModal,
  onTogglePopover,
  viewNames,
  tabIndexOverride,
  onFocus
}, ref) => {
  const i18n = useI18n();
  const [popoverActive, setPopoverActive] = (0, import_react605.useState)(false);
  const [activeModalType, setActiveModalType] = (0, import_react605.useState)(null);
  const {
    mdDown
  } = useBreakpoints();
  const wasSelected = (0, import_react605.useRef)(selected);
  const panelFocused = (0, import_react605.useRef)(false);
  const node = (0, import_react605.useRef)(null);
  (0, import_react605.useEffect)(() => {
    onTogglePopover(popoverActive);
  }, [popoverActive, onTogglePopover]);
  (0, import_react605.useEffect)(() => {
    onToggleModal(Boolean(activeModalType));
  }, [activeModalType, onToggleModal]);
  (0, import_react605.useEffect)(() => {
    return () => {
      onToggleModal(false);
      onTogglePopover(false);
    };
  }, [onToggleModal, onTogglePopover]);
  (0, import_react605.useEffect)(() => {
    if (measuring) {
      return;
    }
    const itemHadFocus = focused || document.activeElement && document.activeElement.id === id;
    if (itemHadFocus && selected && panelID != null && !panelFocused.current) {
      focusPanelID(panelID);
      panelFocused.current = true;
    }
    if (selected && !wasSelected.current && panelID != null) {
      focusPanelID(panelID);
    } else if (focused && node.current != null && activeModalType == null && !disabled) {
      focusFirstFocusableNode(node.current);
    }
    wasSelected.current = selected;
  }, [focused, id, content, measuring, panelID, selected, activeModalType, disabled]);
  let tabIndex;
  if (selected && !siblingTabHasFocus && !measuring) {
    tabIndex = 0;
  } else if (focused && !measuring) {
    tabIndex = 0;
  } else {
    tabIndex = -1;
  }
  if (tabIndexOverride != null) {
    tabIndex = tabIndexOverride;
  }
  const renameAction = actions === null || actions === void 0 ? void 0 : actions.find((action) => action.type === "rename");
  const duplicateAction = actions === null || actions === void 0 ? void 0 : actions.find((action) => action.type === "duplicate");
  const deleteAction = actions === null || actions === void 0 ? void 0 : actions.find((action) => action.type === "delete");
  const togglePopoverActive = (0, import_react605.useCallback)(() => {
    if (!(actions !== null && actions !== void 0 && actions.length)) {
      return;
    }
    setPopoverActive((popoverActive2) => !popoverActive2);
  }, [actions]);
  const handleClick = (0, import_react605.useCallback)(() => {
    if (disabled) {
      return;
    }
    if (selected) {
      togglePopoverActive();
    } else {
      onAction === null || onAction === void 0 ? void 0 : onAction();
    }
  }, [selected, onAction, togglePopoverActive, disabled]);
  const handleModalOpen = (type) => {
    setActiveModalType(type);
  };
  const handleModalClose = () => {
    setActiveModalType(null);
  };
  const handleSaveRenameModal = (0, import_react605.useCallback)(async (value) => {
    var _renameAction$onPrima;
    await (renameAction === null || renameAction === void 0 ? void 0 : (_renameAction$onPrima = renameAction.onPrimaryAction) === null || _renameAction$onPrima === void 0 ? void 0 : _renameAction$onPrima.call(renameAction, value));
    setTimeout(() => {
      if (node.current) {
        focusFirstFocusableNode(node.current);
      }
    }, 250);
  }, [renameAction]);
  const handleConfirmDeleteView = (0, import_react605.useCallback)(async () => {
    var _deleteAction$onPrima;
    await (deleteAction === null || deleteAction === void 0 ? void 0 : (_deleteAction$onPrima = deleteAction.onPrimaryAction) === null || _deleteAction$onPrima === void 0 ? void 0 : _deleteAction$onPrima.call(deleteAction, content));
    handleModalClose();
  }, [deleteAction, content]);
  const handleSaveDuplicateModal = (0, import_react605.useCallback)(async (duplicateName) => {
    var _duplicateAction$onPr;
    await (duplicateAction === null || duplicateAction === void 0 ? void 0 : (_duplicateAction$onPr = duplicateAction.onPrimaryAction) === null || _duplicateAction$onPr === void 0 ? void 0 : _duplicateAction$onPr.call(duplicateAction, duplicateName));
  }, [duplicateAction]);
  const actionContent = {
    rename: {
      icon: SvgInfoMinor,
      content: i18n.translate("Polaris.Tabs.Tab.rename")
    },
    duplicate: {
      icon: SvgDuplicateMinor,
      content: i18n.translate("Polaris.Tabs.Tab.duplicate")
    },
    edit: {
      icon: SvgEditMinor,
      content: i18n.translate("Polaris.Tabs.Tab.edit")
    },
    "edit-columns": {
      icon: SvgColumns3Minor,
      content: i18n.translate("Polaris.Tabs.Tab.editColumns")
    },
    delete: {
      icon: SvgDeleteMinor,
      content: i18n.translate("Polaris.Tabs.Tab.delete"),
      destructive: true
    }
  };
  const formattedActions = actions === null || actions === void 0 ? void 0 : actions.map(({
    type,
    onAction: onAction2,
    onPrimaryAction,
    ...additionalOptions
  }) => {
    const isModalActivator = !type.includes("edit");
    return {
      ...actionContent[type],
      ...additionalOptions,
      onAction: () => {
        onAction2 === null || onAction2 === void 0 ? void 0 : onAction2(content);
        togglePopoverActive();
        if (isModalActivator) {
          handleModalOpen(type);
        }
      }
    };
  });
  const handleKeyDown7 = (0, import_react605.useCallback)((event) => {
    if (event.key === " ") {
      event.preventDefault();
      handleClick();
    }
  }, [handleClick]);
  const tabContainerClassNames = classNames(styles31.TabContainer, selected && styles31.Underline);
  const urlIfNotDisabledOrSelected = disabled || selected ? void 0 : url;
  const BaseComponent = urlIfNotDisabledOrSelected ? UnstyledLink : UnstyledButton;
  const tabClassName = classNames(styles31.Tab, icon && styles31["Tab-iconOnly"], popoverActive && styles31["Tab-popoverActive"], selected && styles31["Tab-active"], selected && (actions === null || actions === void 0 ? void 0 : actions.length) && styles31["Tab-hasActions"]);
  const badgeMarkup = badge ? import_react605.default.createElement(Badge, {
    status: selected ? "success" : "new"
  }, badge) : null;
  const disclosureMarkup = selected && actions !== null && actions !== void 0 && actions.length ? import_react605.default.createElement("div", {
    className: classNames(styles31.IconWrap)
  }, import_react605.default.createElement(Icon, {
    source: SvgCaretDownMinor
  })) : null;
  const activator = import_react605.default.createElement(BaseComponent, {
    id,
    className: tabClassName,
    tabIndex,
    "aria-selected": selected,
    "aria-controls": panelID,
    "aria-label": accessibilityLabel,
    role: tabIndexOverride == null ? "tab" : void 0,
    disabled,
    url: urlIfNotDisabledOrSelected,
    onFocus,
    onMouseUp: handleMouseUpByBlurring,
    onClick: handleClick,
    onKeyDown: handleKeyDown7
  }, import_react605.default.createElement(HorizontalStack, {
    gap: "2",
    align: "center",
    blockAlign: "center",
    wrap: false
  }, import_react605.default.createElement(Text, {
    as: "span",
    variant: mdDown ? "bodyMd" : "bodySm",
    fontWeight: "semibold"
  }, icon !== null && icon !== void 0 ? icon : content), badgeMarkup), disclosureMarkup);
  const isPlainButton = !selected || !(actions !== null && actions !== void 0 && actions.length);
  const renameModal = renameAction ? import_react605.default.createElement(RenameModal, {
    name: content,
    open: activeModalType === "rename",
    onClose: handleModalClose,
    onClickPrimaryAction: handleSaveRenameModal,
    isModalLoading,
    viewNames
  }) : null;
  const duplicateModal = duplicateAction ? import_react605.default.createElement(DuplicateModal, {
    open: activeModalType === "duplicate",
    name: i18n.translate("Polaris.Tabs.Tab.copy", {
      name: content
    }),
    onClose: handleModalClose,
    onClickPrimaryAction: handleSaveDuplicateModal,
    isModalLoading,
    viewNames: viewNames || []
  }) : null;
  const deleteModal = deleteAction ? import_react605.default.createElement(Modal, {
    open: activeModalType === "delete",
    onClose: handleModalClose,
    primaryAction: {
      content: i18n.translate("Polaris.Tabs.Tab.deleteModal.delete"),
      onAction: handleConfirmDeleteView,
      destructive: true,
      disabled: isModalLoading
    },
    secondaryActions: [{
      content: i18n.translate("Polaris.Tabs.Tab.deleteModal.cancel"),
      onAction: handleModalClose
    }],
    title: i18n.translate("Polaris.Tabs.Tab.deleteModal.title"),
    instant: true
  }, import_react605.default.createElement(Modal.Section, null, i18n.translate("Polaris.Tabs.Tab.deleteModal.description", {
    viewName: content
  }))) : null;
  const markup = isPlainButton || disabled ? activator : import_react605.default.createElement(import_react605.default.Fragment, null, import_react605.default.createElement(Popover2, {
    active: popoverActive,
    activator,
    autofocusTarget: "first-node",
    onClose: togglePopoverActive
  }, import_react605.default.createElement("div", {
    className: styles31.ActionListWrap
  }, import_react605.default.createElement(ActionList, {
    actionRole: "menuitem",
    items: formattedActions
  }))), renameModal, duplicateModal, deleteModal);
  if (icon) {
    return markup;
  }
  return import_react605.default.createElement("li", {
    className: tabContainerClassNames,
    ref: mergeRefs([node, ref]),
    role: "presentation"
  }, markup);
});
Tab.displayName = "Tab";
function focusPanelID(panelID) {
  const panel = document.getElementById(panelID);
  if (panel) {
    panel.focus({
      preventScroll: true
    });
  }
}
function mergeRefs(refs) {
  return (node) => {
    for (const ref of refs) {
      if (ref != null) {
        ref.current = node;
      }
    }
  };
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaTabs/components/TabMeasurer/TabMeasurer.js
var import_react606 = __toESM(require_react());
var TabMeasurer = (0, import_react606.memo)(function TabMeasurer2({
  selected,
  tabs,
  activator,
  tabToFocus,
  siblingTabHasFocus,
  handleMeasurement: handleMeasurementProp
}) {
  const containerNode = (0, import_react606.useRef)(null);
  const animationFrame = (0, import_react606.useRef)(null);
  const handleMeasurement = (0, import_react606.useCallback)(() => {
    if (animationFrame.current) {
      cancelAnimationFrame(animationFrame.current);
    }
    animationFrame.current = requestAnimationFrame(() => {
      if (!containerNode.current) {
        return;
      }
      const containerWidth = containerNode.current.offsetWidth - 20 - 28;
      const hiddenTabNodes = containerNode.current.children;
      const hiddenTabNodesArray = Array.from(hiddenTabNodes);
      const hiddenTabWidths = hiddenTabNodesArray.map((node) => {
        const buttonWidth = Math.ceil(node.getBoundingClientRect().width);
        return buttonWidth + 4;
      });
      const disclosureWidth = hiddenTabWidths.pop() || 0;
      handleMeasurementProp({
        containerWidth,
        disclosureWidth,
        hiddenTabWidths
      });
    });
  }, [handleMeasurementProp]);
  (0, import_react606.useEffect)(() => {
    handleMeasurement();
  }, [handleMeasurement, tabs]);
  useComponentDidMount(() => {
    if (true) {
      setTimeout(handleMeasurement, 0);
    }
  });
  const tabsMarkup = tabs.map((tab, index) => {
    return import_react606.default.createElement(Tab, {
      measuring: true,
      key: `$${tab.id}Hidden`,
      id: `${tab.id}Measurer`,
      siblingTabHasFocus,
      focused: index === tabToFocus,
      selected: index === selected,
      url: tab.url,
      content: tab.content,
      onTogglePopover: noop5,
      onToggleModal: noop5
    });
  });
  const classname = classNames(styles31.AlphaTabs, styles31.TabsMeasurer);
  useEventListener("resize", handleMeasurement);
  return import_react606.default.createElement("div", {
    className: classname,
    ref: containerNode
  }, tabsMarkup, activator);
});
function noop5() {
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaTabs/components/Panel/Panel.js
var import_react607 = __toESM(require_react());
function Panel({
  hidden,
  id,
  tabID,
  children: children2
}) {
  const className = classNames(styles31.Panel, hidden && styles31["Panel-hidden"]);
  return import_react607.default.createElement("div", {
    className,
    id,
    role: "tabpanel",
    "aria-labelledby": tabID,
    tabIndex: -1
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaTabs/components/List/List.js
var import_react609 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/AlphaTabs/components/Item/Item.js
var import_react608 = __toESM(require_react());
var Item5 = (0, import_react608.memo)(function Item6({
  id,
  focused,
  children: children2,
  url,
  accessibilityLabel,
  onClick = noop6
}) {
  const focusedNode = (0, import_react608.useRef)(null);
  (0, import_react608.useEffect)(() => {
    if (focusedNode.current && focusedNode.current instanceof HTMLElement && focused) {
      focusedNode.current.focus();
    }
  }, [focusedNode, focused]);
  const classname = classNames(styles31.Item);
  const sharedProps = {
    id,
    ref: focusedNode,
    onClick,
    className: classname,
    "aria-selected": false,
    "aria-label": accessibilityLabel
  };
  const markup = url ? import_react608.default.createElement(UnstyledLink, Object.assign({}, sharedProps, {
    url
  }), children2) : import_react608.default.createElement("button", Object.assign({}, sharedProps, {
    ref: focusedNode,
    type: "button"
  }), children2);
  return import_react608.default.createElement("li", null, markup);
});
function noop6() {
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaTabs/components/List/List.js
function List({
  focusIndex,
  disclosureTabs,
  onClick = noop7,
  onKeyPress = noop7
}) {
  const tabs = disclosureTabs.map(({
    id,
    content,
    ...tabProps
  }, index) => {
    return import_react609.default.createElement(Item5, Object.assign({
      key: id
    }, tabProps, {
      id,
      focused: index === focusIndex,
      onClick: onClick.bind(null, id)
    }), content);
  });
  return import_react609.default.createElement("ul", {
    className: styles31.List,
    onKeyDown: handleKeyDown,
    onKeyUp: onKeyPress
  }, tabs);
}
function noop7() {
}
function handleKeyDown(event) {
  const {
    key
  } = event;
  if (key === "ArrowLeft" || key === "ArrowRight") {
    event.preventDefault();
    event.stopPropagation();
  }
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaTabs/components/CreateViewModal/CreateViewModal.js
var import_react611 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/use-is-touch-device.js
var import_react610 = __toESM(require_react());
function useIsTouchDevice() {
  const [isTouchDevice, setIsTouchDevice] = (0, import_react610.useState)(false);
  const handleTouchStart = (0, import_react610.useCallback)(() => setIsTouchDevice(true), []);
  useEventListener("touchstart", handleTouchStart);
  return isTouchDevice;
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaTabs/components/CreateViewModal/CreateViewModal.js
var MAX_VIEW_NAME_LENGTH2 = 40;
function CreateViewModal({
  activator,
  open,
  onClose,
  onClickPrimaryAction,
  onClickSecondaryAction,
  viewNames
}) {
  const i18n = useI18n();
  const [value, setValue] = (0, import_react611.useState)("");
  const [loading, setLoading] = (0, import_react611.useState)(false);
  const container = (0, import_react611.useRef)(null);
  const isTouchDevice = useIsTouchDevice();
  const hasSameNameError = viewNames.some((viewName) => viewName.trim().toLowerCase() === value.trim().toLowerCase());
  const isPrimaryActionDisabled = !value || hasSameNameError || loading || value.length > MAX_VIEW_NAME_LENGTH2;
  (0, import_react611.useEffect)(() => {
    if (!container.current || isTouchDevice)
      return;
    if (open) {
      focusFirstFocusableNode(container.current);
      const timeout2 = setTimeout(() => {
        if (!container.current)
          return;
        focusFirstFocusableNode(container.current);
      }, 50);
      return () => clearTimeout(timeout2);
    }
  }, [open, isTouchDevice]);
  const handleChange = (0, import_react611.useCallback)((newValue) => {
    setValue(newValue);
  }, []);
  async function handlePrimaryAction() {
    if (hasSameNameError || isPrimaryActionDisabled) {
      return;
    }
    setLoading(true);
    await onClickPrimaryAction(value);
    setLoading(false);
    setValue("");
    onClose();
  }
  function handleSecondaryAction() {
    onClickSecondaryAction === null || onClickSecondaryAction === void 0 ? void 0 : onClickSecondaryAction();
    setValue("");
    onClose();
  }
  return import_react611.default.createElement(Modal, {
    activator,
    open,
    onClose,
    title: i18n.translate("Polaris.Tabs.CreateViewModal.title"),
    primaryAction: {
      content: i18n.translate("Polaris.Tabs.CreateViewModal.create"),
      onAction: handlePrimaryAction,
      disabled: isPrimaryActionDisabled
    },
    secondaryActions: [{
      content: i18n.translate("Polaris.Tabs.CreateViewModal.cancel"),
      onAction: handleSecondaryAction
    }]
  }, import_react611.default.createElement(Modal.Section, null, import_react611.default.createElement(Form, {
    onSubmit: handlePrimaryAction
  }, import_react611.default.createElement(FormLayout, null, import_react611.default.createElement("div", {
    ref: container
  }, import_react611.default.createElement(TextField, {
    label: i18n.translate("Polaris.Tabs.CreateViewModal.label"),
    value,
    onChange: handleChange,
    autoComplete: "off",
    maxLength: MAX_VIEW_NAME_LENGTH2,
    showCharacterCount: true,
    error: hasSameNameError ? i18n.translate("Polaris.Tabs.CreateViewModal.errors.sameName", {
      name: value
    }) : void 0
  }))))));
}

// ../node_modules/@shopify/polaris/build/esm/components/AlphaTabs/AlphaTabs.js
var CREATE_NEW_VIEW_ID = "create-new-view";
var AlphaTabs = ({
  tabs,
  children: children2,
  selected,
  newViewAccessibilityLabel,
  canCreateNewView,
  disabled,
  onCreateNewView,
  onSelect,
  fitted,
  disclosureText
}) => {
  const i18n = useI18n();
  const {
    mdDown
  } = useBreakpoints();
  const scrollRef = (0, import_react612.useRef)(null);
  const wrapRef = (0, import_react612.useRef)(null);
  const selectedTabRef = (0, import_react612.useRef)(null);
  const [state, setState] = (0, import_react612.useReducer)((data, partialData) => {
    return {
      ...data,
      ...partialData
    };
  }, {
    disclosureWidth: 0,
    containerWidth: Infinity,
    tabWidths: [],
    visibleTabs: [],
    hiddenTabs: [],
    showDisclosure: false,
    tabToFocus: -1,
    isNewViewModalActive: false,
    modalSubmitted: false,
    isTabsFocused: false,
    isTabPopoverOpen: false,
    isTabModalOpen: false
  });
  const {
    tabToFocus,
    visibleTabs,
    hiddenTabs,
    showDisclosure,
    isNewViewModalActive,
    modalSubmitted,
    disclosureWidth,
    tabWidths,
    containerWidth,
    isTabsFocused,
    isTabModalOpen,
    isTabPopoverOpen
  } = state;
  const prevModalOpen = usePrevious(isTabModalOpen);
  const prevPopoverOpen = usePrevious(isTabPopoverOpen);
  (0, import_react612.useEffect)(() => {
    const hasModalClosed = prevModalOpen && !isTabModalOpen;
    const hasPopoverClosed = prevPopoverOpen && !isTabPopoverOpen;
    if (hasModalClosed) {
      setState({
        isTabsFocused: true,
        tabToFocus: selected
      });
    } else if (hasPopoverClosed && !isTabModalOpen) {
      setState({
        isTabsFocused: true,
        tabToFocus: selected
      });
    }
  }, [prevPopoverOpen, isTabPopoverOpen, prevModalOpen, isTabModalOpen, selected, tabToFocus]);
  const handleTogglePopover = (0, import_react612.useCallback)((isOpen) => setState({
    isTabPopoverOpen: isOpen
  }), []);
  const handleToggleModal = (0, import_react612.useCallback)((isOpen) => setState({
    isTabModalOpen: isOpen
  }), []);
  const handleCloseNewViewModal = () => {
    setState({
      isNewViewModalActive: false
    });
  };
  const handleSaveNewViewModal = async (value) => {
    if (!onCreateNewView) {
      return false;
    }
    const hasExecuted = await (onCreateNewView === null || onCreateNewView === void 0 ? void 0 : onCreateNewView(value));
    if (hasExecuted) {
      setState({
        modalSubmitted: true
      });
    }
    return hasExecuted;
  };
  const handleClickNewTab = () => {
    setState({
      isNewViewModalActive: true
    });
  };
  const handleTabClick = (0, import_react612.useCallback)((id) => {
    const tab = tabs.find((aTab) => aTab.id === id);
    if (tab == null) {
      return null;
    }
    const selectedIndex = tabs.indexOf(tab);
    onSelect === null || onSelect === void 0 ? void 0 : onSelect(selectedIndex);
  }, [tabs, onSelect]);
  const renderTabMarkup = (0, import_react612.useCallback)((tab, index) => {
    const handleClick = () => {
      var _tab$onAction;
      handleTabClick(tab.id);
      (_tab$onAction = tab.onAction) === null || _tab$onAction === void 0 ? void 0 : _tab$onAction.call(tab);
    };
    const viewNames2 = tabs.map(({
      content
    }) => content);
    const tabPanelID = tab.panelID || `${tab.id}-panel`;
    return import_react612.default.createElement(Tab, Object.assign({}, tab, {
      key: `${index}-${tab.id}`,
      id: tab.id,
      panelID: children2 ? tabPanelID : void 0,
      disabled,
      siblingTabHasFocus: tabToFocus > -1,
      focused: index === tabToFocus,
      selected: index === selected,
      onAction: handleClick,
      accessibilityLabel: tab.accessibilityLabel,
      url: tab.url,
      content: tab.content,
      onToggleModal: handleToggleModal,
      onTogglePopover: handleTogglePopover,
      viewNames: viewNames2,
      ref: index === selected ? selectedTabRef : null
    }));
  }, [disabled, handleTabClick, tabs, children2, selected, tabToFocus, handleToggleModal, handleTogglePopover]);
  const handleFocus = (0, import_react612.useCallback)((event) => {
    const target = event.target;
    const isItem = target.classList.contains(styles31.Item);
    const isInNaturalDOMOrder = target.closest(`[data-tabs-focus-catchment]`) || isItem;
    const isDisclosureActivator = target.classList.contains(styles31.DisclosureActivator);
    if (isDisclosureActivator || !isInNaturalDOMOrder) {
      return;
    }
    setState({
      isTabsFocused: true
    });
  }, []);
  const handleBlur = (0, import_react612.useCallback)((event) => {
    var _relatedTarget$closes, _target$classList, _target$classList$con;
    const target = event.target;
    const relatedTarget = event.relatedTarget;
    const isInNaturalDOMOrder = relatedTarget === null || relatedTarget === void 0 ? void 0 : (_relatedTarget$closes = relatedTarget.closest) === null || _relatedTarget$closes === void 0 ? void 0 : _relatedTarget$closes.call(relatedTarget, `.${styles31.AlphaTabs}`);
    const targetIsATab = target === null || target === void 0 ? void 0 : (_target$classList = target.classList) === null || _target$classList === void 0 ? void 0 : (_target$classList$con = _target$classList.contains) === null || _target$classList$con === void 0 ? void 0 : _target$classList$con.call(_target$classList, styles31.Tab);
    const focusReceiverIsAnItem = relatedTarget === null || relatedTarget === void 0 ? void 0 : relatedTarget.classList.contains(styles31.Item);
    if (!relatedTarget && !isTabModalOpen && !targetIsATab && !focusReceiverIsAnItem) {
      setState({
        tabToFocus: -1
      });
      return;
    }
    if (!isInNaturalDOMOrder && !isTabModalOpen && !targetIsATab && !focusReceiverIsAnItem) {
      setState({
        tabToFocus: -1
      });
      return;
    }
    setState({
      isTabsFocused: false
    });
  }, [isTabModalOpen]);
  const handleKeyDown7 = (event) => {
    if (isTabPopoverOpen || isTabModalOpen || isNewViewModalActive) {
      return;
    }
    const {
      key
    } = event;
    if (key === "ArrowLeft" || key === "ArrowRight") {
      event.preventDefault();
      event.stopPropagation();
    }
  };
  (0, import_react612.useEffect)(() => {
    const {
      visibleTabs: visibleTabs2,
      hiddenTabs: hiddenTabs2
    } = getVisibleAndHiddenTabIndices(tabs, selected, disclosureWidth, tabWidths, containerWidth);
    setState({
      visibleTabs: visibleTabs2,
      hiddenTabs: hiddenTabs2
    });
  }, [containerWidth, disclosureWidth, tabs, selected, tabWidths, setState]);
  const moveToSelectedTab = (0, import_react612.useCallback)(() => {
    var _selectedTabRef$curre;
    const activeButton = (_selectedTabRef$curre = selectedTabRef.current) === null || _selectedTabRef$curre === void 0 ? void 0 : _selectedTabRef$curre.querySelector(`.${styles31["Tab-active"]}`);
    if (activeButton) {
      moveToActiveTab(activeButton.offsetLeft);
    }
  }, []);
  (0, import_react612.useEffect)(() => {
    if (mdDown) {
      moveToSelectedTab();
    }
  }, [moveToSelectedTab, selected, mdDown]);
  (0, import_react612.useEffect)(() => {
    if (isTabsFocused && !showDisclosure) {
      const tabToFocus2 = selected;
      setState({
        tabToFocus: tabToFocus2
      });
    }
  }, [isTabsFocused, selected, setState, showDisclosure]);
  const handleKeyPress = (event) => {
    const {
      showDisclosure: showDisclosure2,
      visibleTabs: visibleTabs2,
      hiddenTabs: hiddenTabs2,
      tabToFocus: tabToFocus2,
      isNewViewModalActive: isNewViewModalActive2
    } = state;
    if (isTabModalOpen || isTabPopoverOpen || isNewViewModalActive2) {
      return;
    }
    const key = event.key;
    const tabsArrayInOrder = showDisclosure2 || mdDown ? visibleTabs2.concat(hiddenTabs2) : [...visibleTabs2];
    let newFocus = tabsArrayInOrder.indexOf(tabToFocus2);
    if (key === "ArrowRight") {
      newFocus += 1;
      if (newFocus === tabsArrayInOrder.length) {
        newFocus = 0;
      }
    }
    if (key === "ArrowLeft") {
      if (newFocus === -1 || newFocus === 0) {
        newFocus = tabsArrayInOrder.length - 1;
      } else {
        newFocus -= 1;
      }
    }
    const buttonToFocus = tabsArrayInOrder[newFocus];
    if (buttonToFocus != null) {
      setState({
        tabToFocus: buttonToFocus
      });
    }
  };
  const handleDisclosureActivatorClick = () => {
    setState({
      showDisclosure: !showDisclosure,
      tabToFocus: hiddenTabs[0]
    });
  };
  const handleClose = () => {
    setState({
      showDisclosure: false
    });
  };
  const handleMeasurement = (0, import_react612.useCallback)((measurements) => {
    const {
      hiddenTabWidths: tabWidths2,
      containerWidth: containerWidth2,
      disclosureWidth: disclosureWidth2
    } = measurements;
    const {
      visibleTabs: visibleTabs2,
      hiddenTabs: hiddenTabs2
    } = getVisibleAndHiddenTabIndices(tabs, selected, disclosureWidth2, tabWidths2, containerWidth2);
    setState({
      visibleTabs: visibleTabs2,
      hiddenTabs: hiddenTabs2,
      disclosureWidth: disclosureWidth2,
      containerWidth: containerWidth2,
      tabWidths: tabWidths2
    });
  }, [tabs, selected, setState]);
  const handleListTabClick = (id) => {
    handleTabClick(id);
    handleClose();
    setState({
      isTabsFocused: true
    });
  };
  const moveToActiveTab = (offsetLeft) => {
    setTimeout(() => {
      if (scrollRef.current && typeof scrollRef.current.scroll === "function") {
        var _wrapRef$current, _scrollRef$current;
        const scrollRefOffset = (wrapRef === null || wrapRef === void 0 ? void 0 : (_wrapRef$current = wrapRef.current) === null || _wrapRef$current === void 0 ? void 0 : _wrapRef$current.offsetLeft) || 0;
        scrollRef === null || scrollRef === void 0 ? void 0 : (_scrollRef$current = scrollRef.current) === null || _scrollRef$current === void 0 ? void 0 : _scrollRef$current.scroll({
          left: offsetLeft - scrollRefOffset
        });
      }
    }, 0);
  };
  const createViewA11yLabel = newViewAccessibilityLabel || i18n.translate("Polaris.Tabs.newViewAccessibilityLabel");
  const tabsToShow = mdDown ? [...visibleTabs, ...hiddenTabs] : visibleTabs;
  const tabsMarkup = tabsToShow.sort((tabA, tabB) => tabA - tabB).filter((tabIndex) => tabs[tabIndex]).map((tabIndex) => renderTabMarkup(tabs[tabIndex], tabIndex));
  const disclosureActivatorVisible = visibleTabs.length < tabs.length && !mdDown;
  const classname = classNames(styles31.AlphaTabs, fitted && styles31.fitted, disclosureActivatorVisible && styles31.fillSpace);
  const wrapperClassNames = classNames(styles31.Wrapper, canCreateNewView && styles31.WrapperWithNewButton);
  const disclosureTabClassName = classNames(styles31.DisclosureTab, disclosureActivatorVisible && styles31["DisclosureTab-visible"]);
  const disclosureButtonClassName = classNames(styles31.DisclosureActivator);
  const disclosureButtonContent = import_react612.default.createElement(import_react612.default.Fragment, null, import_react612.default.createElement(Text, {
    as: "span",
    variant: "bodySm",
    fontWeight: "semibold"
  }, disclosureText !== null && disclosureText !== void 0 ? disclosureText : i18n.translate("Polaris.Tabs.toggleTabsLabel")), import_react612.default.createElement("div", {
    className: classNames(styles31.IconWrap, disclosureActivatorVisible && showDisclosure && styles31["IconWrap-open"])
  }, import_react612.default.createElement(Icon, {
    source: SvgCaretDownMinor,
    color: "subdued"
  })));
  const disclosureButton = import_react612.default.createElement(UnstyledButton, {
    type: "button",
    className: disclosureButtonClassName,
    onClick: handleDisclosureActivatorClick,
    "aria-label": disclosureText !== null && disclosureText !== void 0 ? disclosureText : i18n.translate("Polaris.Tabs.toggleTabsLabel"),
    disabled
  }, disclosureButtonContent);
  const activator = disclosureButton;
  const disclosureTabs = hiddenTabs.map((tabIndex) => tabs[tabIndex]);
  const viewNames = tabs.map(({
    content
  }) => content);
  const tabMeasurer = import_react612.default.createElement(TabMeasurer, {
    tabToFocus,
    activator,
    selected,
    tabs,
    siblingTabHasFocus: tabToFocus > -1,
    handleMeasurement
  });
  const newTab = import_react612.default.createElement(Tab, {
    id: CREATE_NEW_VIEW_ID,
    content: createViewA11yLabel,
    actions: [],
    onAction: handleClickNewTab,
    onFocus: () => {
      if (modalSubmitted) {
        setState({
          tabToFocus: selected,
          modalSubmitted: false
        });
      }
    },
    icon: import_react612.default.createElement(Icon, {
      source: SvgPlusMinor,
      accessibilityLabel: createViewA11yLabel
    }),
    disabled,
    onTogglePopover: handleTogglePopover,
    onToggleModal: handleToggleModal,
    tabIndexOverride: 0
  });
  const panelMarkup = children2 ? tabs.map((_tab, index) => {
    return selected === index ? import_react612.default.createElement(Panel, {
      id: tabs[index].panelID || `${tabs[index].id}-panel`,
      tabID: tabs[index].id,
      key: tabs[index].id
    }, children2) : import_react612.default.createElement(Panel, {
      id: tabs[index].panelID || `${tabs[index].id}-panel`,
      tabID: tabs[index].id,
      key: tabs[index].id,
      hidden: true
    });
  }) : null;
  return import_react612.default.createElement("div", {
    className: styles31.Outer
  }, import_react612.default.createElement(Box, {
    padding: {
      md: "2"
    },
    background: "bg",
    borderColor: "border-subdued",
    borderBlockEndWidth: "1",
    borderRadiusStartEnd: "2",
    borderRadiusStartStart: "2"
  }, tabMeasurer, import_react612.default.createElement("div", {
    className: wrapperClassNames,
    ref: scrollRef
  }, import_react612.default.createElement("div", {
    className: styles31.ButtonWrapper,
    ref: wrapRef
  }, import_react612.default.createElement("ul", {
    role: tabsMarkup.length > 0 ? "tablist" : void 0,
    className: classname,
    onFocus: handleFocus,
    onBlur: handleBlur,
    onKeyDown: handleKeyDown7,
    onKeyUp: handleKeyPress,
    "data-tabs-focus-catchment": true
  }, tabsMarkup, mdDown || tabsToShow.length === 0 ? null : import_react612.default.createElement("li", {
    className: disclosureTabClassName,
    role: "presentation"
  }, import_react612.default.createElement(Popover2, {
    preferredPosition: "below",
    activator,
    active: disclosureActivatorVisible && showDisclosure,
    onClose: handleClose,
    autofocusTarget: "first-node"
  }, import_react612.default.createElement(List, {
    focusIndex: hiddenTabs.indexOf(tabToFocus),
    disclosureTabs,
    onClick: handleListTabClick,
    onKeyPress: handleKeyPress
  })))), canCreateNewView && tabsToShow.length > 0 ? import_react612.default.createElement("div", {
    className: styles31.NewTab
  }, import_react612.default.createElement(CreateViewModal, {
    open: isNewViewModalActive,
    onClose: handleCloseNewViewModal,
    onClickPrimaryAction: handleSaveNewViewModal,
    viewNames,
    activator: disabled ? newTab : import_react612.default.createElement(Tooltip, {
      content: i18n.translate("Polaris.Tabs.newViewTooltip"),
      preferredPosition: "above",
      hoverDelay: 400
    }, newTab)
  })) : null))), panelMarkup);
};

// ../node_modules/@shopify/polaris/build/esm/components/Autocomplete/Autocomplete.js
var import_react633 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/options.js
function isSection(arr) {
  return typeof arr[0] === "object" && Object.prototype.hasOwnProperty.call(arr[0], "options");
}

// ../node_modules/@shopify/polaris/build/esm/components/Autocomplete/Autocomplete.scss.js
var styles39 = {
  "Loading": "Polaris-Autocomplete__Loading",
  "SectionWrapper": "Polaris-Autocomplete__SectionWrapper"
};

// ../node_modules/@shopify/polaris/build/esm/components/Autocomplete/components/MappedOption/MappedOption.js
var import_react629 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Autocomplete/components/MappedOption/MappedOption.scss.js
var styles40 = {
  "Content": "Polaris-Autocomplete-MappedOption__Content",
  "Media": "Polaris-Autocomplete-MappedOption__Media",
  "singleSelectionMedia": "Polaris-Autocomplete-MappedOption--singleSelectionMedia",
  "disabledMedia": "Polaris-Autocomplete-MappedOption--disabledMedia"
};

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/Listbox.js
var import_react628 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/Listbox.scss.js
var styles41 = {
  "Listbox": "Polaris-Listbox"
};

// ../node_modules/@shopify/polaris/build/esm/utilities/combobox/hooks.js
var import_react614 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/combobox/context.js
var import_react613 = __toESM(require_react());
var ComboboxTextFieldContext = (0, import_react613.createContext)(void 0);
var ComboboxListboxContext = (0, import_react613.createContext)({});
var ComboboxListboxOptionContext = (0, import_react613.createContext)({});

// ../node_modules/@shopify/polaris/build/esm/utilities/combobox/hooks.js
function useComboboxTextField() {
  const context = (0, import_react614.useContext)(ComboboxTextFieldContext);
  if (!context) {
    throw new Error("No Combobox was provided. Your component must be wrapped in a <Combobox> component.");
  }
  return context;
}
function useComboboxListbox() {
  const context = (0, import_react614.useContext)(ComboboxListboxContext);
  return context;
}

// ../node_modules/@shopify/polaris/build/esm/utilities/listbox/utilities.js
function scrollOptionIntoView(option, scrollable2) {
  const listTop = scrollable2.scrollTop;
  const listBottom = listTop + scrollable2.clientHeight;
  const {
    offsetHeight: optionHeight
  } = option;
  const {
    offsetTop: optionTop
  } = option;
  const optionBottom = optionTop + optionHeight;
  const isVisible = optionTop > listTop && optionBottom < listBottom;
  if (!isVisible) {
    let top = 0;
    if (optionBottom > listBottom) {
      top = optionBottom + optionHeight * 0.85 - listBottom;
    } else if (optionTop < listTop) {
      top = optionTop - optionHeight * 0.15 - listTop;
    }
    requestAnimationFrame(() => {
      scrollable2.scrollBy({
        top,
        behavior: "auto"
      });
    });
  }
}

// ../node_modules/@shopify/polaris/build/esm/utilities/listbox/context.js
var import_react615 = __toESM(require_react());
var ListboxContext = (0, import_react615.createContext)(void 0);
var WithinListboxContext = (0, import_react615.createContext)(false);
var ActionContext = (0, import_react615.createContext)(false);

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/TextOption/TextOption.js
var import_react618 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/TextOption/TextOption.scss.js
var styles42 = {
  "TextOption": "Polaris-Listbox-TextOption",
  "allowMultiple": "Polaris-Listbox-TextOption--allowMultiple",
  "isAction": "Polaris-Listbox-TextOption--isAction",
  "selected": "Polaris-Listbox-TextOption--selected",
  "disabled": "Polaris-Listbox-TextOption--disabled",
  "Content": "Polaris-Listbox-TextOption__Content",
  "Checkbox": "Polaris-Listbox-TextOption__Checkbox"
};

// ../node_modules/@shopify/polaris/build/esm/components/Checkbox/Checkbox.js
var import_react617 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Checkbox/Checkbox.scss.js
var styles43 = {
  "Checkbox": "Polaris-Checkbox",
  "Input": "Polaris-Checkbox__Input",
  "Backdrop": "Polaris-Checkbox__Backdrop",
  "Input-indeterminate": "Polaris-Checkbox__Input--indeterminate",
  "Icon": "Polaris-Checkbox__Icon",
  "hover": "Polaris-Checkbox--hover",
  "error": "Polaris-Checkbox--error"
};

// ../node_modules/@shopify/polaris/build/esm/components/Choice/Choice.js
var import_react616 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Choice/Choice.scss.js
var styles44 = {
  "Choice": "Polaris-Choice",
  "labelHidden": "Polaris-Choice--labelHidden",
  "Label": "Polaris-Choice__Label",
  "Control": "Polaris-Choice__Control",
  "disabled": "Polaris-Choice--disabled",
  "Descriptions": "Polaris-Choice__Descriptions",
  "HelpText": "Polaris-Choice__HelpText"
};

// ../node_modules/@shopify/polaris/build/esm/components/Choice/Choice.js
function Choice({
  id,
  label,
  disabled,
  error,
  children: children2,
  labelHidden,
  helpText,
  onClick,
  onMouseOut,
  onMouseOver
}) {
  const className = classNames(styles44.Choice, labelHidden && styles44.labelHidden, disabled && styles44.disabled);
  const labelMarkup = import_react616.default.createElement("label", {
    className,
    htmlFor: id,
    onClick,
    onMouseOver,
    onMouseOut
  }, import_react616.default.createElement("span", {
    className: styles44.Control
  }, children2), import_react616.default.createElement("span", {
    className: styles44.Label
  }, import_react616.default.createElement("span", null, label)));
  const helpTextMarkup = helpText ? import_react616.default.createElement("div", {
    className: styles44.HelpText,
    id: helpTextID2(id)
  }, import_react616.default.createElement(Text, {
    as: "span",
    color: "subdued"
  }, helpText)) : null;
  const errorMarkup = error && typeof error !== "boolean" && import_react616.default.createElement("div", {
    className: styles44.Error
  }, import_react616.default.createElement(InlineError, {
    message: error,
    fieldID: id
  }));
  const descriptionMarkup = helpTextMarkup || errorMarkup ? import_react616.default.createElement("div", {
    className: styles44.Descriptions
  }, errorMarkup, helpTextMarkup) : null;
  return descriptionMarkup ? import_react616.default.createElement("div", null, labelMarkup, descriptionMarkup) : labelMarkup;
}
function helpTextID2(id) {
  return `${id}HelpText`;
}

// ../node_modules/@shopify/polaris/build/esm/components/Checkbox/Checkbox.js
var Checkbox = (0, import_react617.forwardRef)(function Checkbox2({
  ariaControls,
  ariaDescribedBy: ariaDescribedByProp,
  label,
  labelHidden,
  checked = false,
  helpText,
  disabled,
  id: idProp,
  name,
  value,
  error,
  onChange,
  onFocus,
  onBlur
}, ref) {
  const inputNode = (0, import_react617.useRef)(null);
  const id = useUniqueId("Checkbox", idProp);
  const {
    value: mouseOver,
    setTrue: handleMouseOver,
    setFalse: handleMouseOut
  } = useToggle(false);
  const isWithinListbox = (0, import_react617.useContext)(WithinListboxContext);
  (0, import_react617.useImperativeHandle)(ref, () => ({
    focus: () => {
      if (inputNode.current) {
        inputNode.current.focus();
      }
    }
  }));
  const handleBlur = () => {
    onBlur && onBlur();
  };
  const handleOnClick = () => {
    if (onChange == null || inputNode.current == null || disabled) {
      return;
    }
    onChange(inputNode.current.checked, id);
    inputNode.current.focus();
  };
  const describedBy = [];
  if (error && typeof error !== "boolean") {
    describedBy.push(errorTextID(id));
  }
  if (helpText) {
    describedBy.push(helpTextID2(id));
  }
  if (ariaDescribedByProp) {
    describedBy.push(ariaDescribedByProp);
  }
  const ariaDescribedBy = describedBy.length ? describedBy.join(" ") : void 0;
  const wrapperClassName = classNames(styles43.Checkbox, error && styles43.error);
  const backdropClassName = classNames(styles43.Backdrop, mouseOver && styles43.hover);
  const isIndeterminate = checked === "indeterminate";
  const isChecked = !isIndeterminate && Boolean(checked);
  const indeterminateAttributes = isIndeterminate ? {
    indeterminate: "true",
    "aria-checked": "mixed"
  } : {
    "aria-checked": isChecked
  };
  const iconSource = isIndeterminate ? SvgMinusMinor : SvgTickSmallMinor;
  const inputClassName = classNames(styles43.Input, isIndeterminate && styles43["Input-indeterminate"]);
  return import_react617.default.createElement(Choice, {
    id,
    label,
    labelHidden,
    helpText,
    error,
    disabled,
    onMouseOver: handleMouseOver,
    onMouseOut: handleMouseOut
  }, import_react617.default.createElement("span", {
    className: wrapperClassName
  }, import_react617.default.createElement("input", Object.assign({
    ref: inputNode,
    id,
    name,
    value,
    type: "checkbox",
    checked: isChecked,
    disabled,
    className: inputClassName,
    onBlur: handleBlur,
    onChange: noop8,
    onClick: handleOnClick,
    onFocus,
    "aria-invalid": error != null,
    "aria-controls": ariaControls,
    "aria-describedby": ariaDescribedBy,
    role: isWithinListbox ? "presentation" : "checkbox"
  }, indeterminateAttributes)), import_react617.default.createElement("span", {
    className: backdropClassName,
    onClick: stopPropagation,
    onKeyUp: stopPropagation
  }), import_react617.default.createElement("span", {
    className: styles43.Icon
  }, import_react617.default.createElement(Icon, {
    source: iconSource
  }))));
});
function noop8() {
}
function stopPropagation(event) {
  event.stopPropagation();
}

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/TextOption/TextOption.js
var TextOption = (0, import_react618.memo)(function TextOption2({
  children: children2,
  selected,
  disabled
}) {
  const {
    allowMultiple
  } = (0, import_react618.useContext)(ComboboxListboxOptionContext);
  const isAction = (0, import_react618.useContext)(ActionContext);
  const textOptionClassName = classNames(styles42.TextOption, selected && !allowMultiple && styles42.selected, disabled && styles42.disabled, allowMultiple && styles42.allowMultiple, isAction && styles42.isAction);
  return import_react618.default.createElement("div", {
    className: textOptionClassName
  }, import_react618.default.createElement("div", {
    className: styles42.Content
  }, allowMultiple && !isAction ? import_react618.default.createElement("div", {
    className: styles42.Checkbox
  }, import_react618.default.createElement(Checkbox, {
    disabled,
    checked: selected,
    label: children2
  })) : children2));
});

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/Loading/Loading.js
var import_react620 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/Loading/Loading.scss.js
var styles45 = {
  "ListItem": "Polaris-Listbox-Loading__ListItem",
  "Loading": "Polaris-Listbox-Loading"
};

// ../node_modules/@shopify/polaris/build/esm/utilities/listbox/hooks.js
var import_react619 = __toESM(require_react());
function useListbox() {
  const listbox = (0, import_react619.useContext)(ListboxContext);
  if (!listbox) {
    throw new Error("No Listbox was provided. Listbox components must be wrapped in a Listbox");
  }
  return listbox;
}

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/Loading/Loading.js
var Loading = (0, import_react620.memo)(function LoadingOption({
  children: children2,
  accessibilityLabel: label
}) {
  const {
    setLoading
  } = useListbox();
  (0, import_react620.useEffect)(() => {
    setLoading(label);
    return () => {
      setLoading(void 0);
    };
  }, [label, setLoading]);
  return import_react620.default.createElement("li", {
    className: styles45.ListItem,
    role: "presentation"
  }, children2 ? children2 : import_react620.default.createElement("div", {
    className: styles45.Loading
  }, import_react620.default.createElement(Spinner, {
    size: "small",
    accessibilityLabel: label
  })));
});

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/Section/Section.js
var import_react622 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/Section/selectors.js
var listboxSectionDataSelector = {
  props: {
    "data-polaris-listbox-section-item": true
  },
  selector: "[data-polaris-listbox-section-item]"
};
var listboxWithinSectionDataSelector = {
  attribute: "data-polaris-listbox-within-section-item"
};

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/Section/context.js
var import_react621 = __toESM(require_react());
var SectionContext = (0, import_react621.createContext)(null);

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/Section/Section.scss.js
var styles46 = {
  "SectionGroup": "Polaris-Listbox-Section__SectionGroup",
  "noDivider": "Polaris-Listbox-Section--noDivider"
};

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/Section/Section.js
function Section4({
  children: children2,
  divider = true,
  title
}) {
  const sectionId = useUniqueId("ListboxSection");
  return import_react622.default.createElement(SectionContext.Provider, {
    value: sectionId
  }, import_react622.default.createElement("li", Object.assign({
    role: "presentation"
  }, listboxSectionDataSelector.props), title, import_react622.default.createElement("ul", {
    role: "group",
    "aria-labelledby": sectionId,
    className: classNames(styles46.SectionGroup, !divider && styles46.noDivider)
  }, children2)));
}

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/Header/Header.js
var import_react624 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/Section/hooks.js
var import_react623 = __toESM(require_react());
function useSection() {
  const context = (0, import_react623.useContext)(SectionContext);
  return context;
}

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/Header/Header.js
function Header2({
  children: children2
}) {
  const sectionId = useSection() || "";
  const content = typeof children2 === "string" ? import_react624.default.createElement(Box, {
    paddingBlockStart: "2",
    paddingInlineStart: "4",
    paddingBlockEnd: "2",
    paddingInlineEnd: "4"
  }, import_react624.default.createElement(Text, {
    as: "span",
    variant: "headingXs",
    color: "subdued"
  }, children2)) : children2;
  return import_react624.default.createElement("div", {
    "aria-hidden": true,
    id: sectionId
  }, content);
}

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/Action/Action.js
var import_react627 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/Action/Action.scss.js
var styles47 = {
  "Action": "Polaris-Listbox-Action",
  "ActionDivider": "Polaris-Listbox-Action__ActionDivider",
  "Icon": "Polaris-Listbox-Action__Icon"
};

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/Option/Option.js
var import_react626 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/Option/Option.scss.js
var styles48 = {
  "Option": "Polaris-Listbox-Option",
  "divider": "Polaris-Listbox-Option--divider"
};

// ../node_modules/@shopify/polaris/build/esm/utilities/autocomplete/context.js
var import_react625 = __toESM(require_react());
var MappedActionContext = (0, import_react625.createContext)({});

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/Option/Option.js
var Option = (0, import_react626.memo)(function Option2({
  value,
  children: children2,
  selected,
  disabled = false,
  accessibilityLabel,
  divider
}) {
  const {
    onOptionSelect
  } = useListbox();
  const isAction = (0, import_react626.useContext)(ActionContext);
  const {
    role,
    url,
    external,
    onAction,
    destructive
  } = (0, import_react626.useContext)(MappedActionContext);
  const listItemRef = (0, import_react626.useRef)(null);
  const domId = useUniqueId("ListboxOption");
  const sectionId = useSection();
  const isWithinSection = Boolean(sectionId);
  const handleOptionSelect = (0, import_react626.useCallback)((event) => {
    event.preventDefault();
    event.stopPropagation();
    onAction && onAction();
    if (listItemRef.current && !onAction) {
      onOptionSelect({
        domId,
        value,
        element: listItemRef.current,
        disabled
      });
    }
  }, [domId, onOptionSelect, value, disabled, onAction]);
  const handleMouseDown = (event) => {
    event.preventDefault();
  };
  const content = typeof children2 === "string" ? import_react626.default.createElement(TextOption, {
    selected,
    disabled
  }, children2) : children2;
  const sectionAttributes = {
    [listboxWithinSectionDataSelector.attribute]: isWithinSection
  };
  const legacyRoleSupport = role || "option";
  const contentMarkup = url ? import_react626.default.createElement(UnstyledLink, {
    url,
    external
  }, content) : content;
  return import_react626.default.createElement("li", Object.assign({}, sectionAttributes, {
    "data-listbox-option": true,
    "data-listbox-option-action": isAction,
    "data-listbox-option-value": value,
    "data-listbox-option-destructive": destructive,
    "data-within-section": isWithinSection,
    className: classNames(styles48.Option, divider && styles48.divider),
    id: domId,
    ref: listItemRef,
    tabIndex: -1,
    role: legacyRoleSupport,
    "aria-label": accessibilityLabel,
    "aria-selected": selected,
    "aria-disabled": disabled,
    onClick: disabled ? void 0 : handleOptionSelect,
    onKeyDown: disabled ? void 0 : handleOptionSelect,
    onMouseDown: handleMouseDown
  }), contentMarkup);
});

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/components/Action/Action.js
function Action(props) {
  const {
    selected,
    disabled,
    children: children2,
    icon,
    divider
  } = props;
  const iconMarkup = icon && import_react627.default.createElement("div", {
    className: styles47.Icon
  }, import_react627.default.createElement(Icon, {
    color: "subdued",
    source: icon
  }));
  const className = classNames(styles47.Action, divider && styles47.ActionDivider);
  return import_react627.default.createElement(ActionContext.Provider, {
    value: true
  }, import_react627.default.createElement(Option, props, import_react627.default.createElement("div", {
    className
  }, import_react627.default.createElement(TextOption, {
    selected,
    disabled
  }, iconMarkup, children2))));
}

// ../node_modules/@shopify/polaris/build/esm/components/Listbox/Listbox.js
var AutoSelection;
(function(AutoSelection2) {
  AutoSelection2["FirstSelected"] = "FIRST_SELECTED";
  AutoSelection2["First"] = "FIRST";
  AutoSelection2["None"] = "NONE";
})(AutoSelection || (AutoSelection = {}));
var OPTION_SELECTOR = "[data-listbox-option]";
var OPTION_VALUE_ATTRIBUTE = "data-listbox-option-value";
var OPTION_ACTION_ATTRIBUTE = "data-listbox-option-action";
var OPTION_FOCUS_ATTRIBUTE = "data-focused";
function Listbox({
  children: children2,
  autoSelection = AutoSelection.FirstSelected,
  enableKeyboardControl,
  accessibilityLabel,
  customListId,
  onSelect,
  onActiveOptionChange
}) {
  const [loading, setLoading] = (0, import_react628.useState)();
  const [activeOption, setActiveOption] = (0, import_react628.useState)();
  const [lazyLoading, setLazyLoading] = (0, import_react628.useState)(false);
  const [currentOptions, setCurrentOptions] = (0, import_react628.useState)([]);
  const {
    value: keyboardEventsEnabled,
    setTrue: enableKeyboardEvents,
    setFalse: disableKeyboardEvents
  } = useToggle(Boolean(enableKeyboardControl));
  const uniqueId = useUniqueId("Listbox");
  const listId = customListId || uniqueId;
  const scrollableRef = (0, import_react628.useRef)(null);
  const listboxRef = (0, import_react628.useRef)(null);
  const {
    listboxId,
    textFieldLabelId,
    textFieldFocused,
    willLoadMoreOptions,
    setActiveOptionId,
    setListboxId,
    onOptionSelected,
    onKeyToBottom
  } = useComboboxListbox();
  const inCombobox = Boolean(setActiveOptionId);
  (0, import_react628.useEffect)(() => {
    if (setListboxId && !listboxId) {
      setListboxId(listId);
    }
  }, [setListboxId, listboxId, listId]);
  const getNavigableOptions = (0, import_react628.useCallback)(() => {
    if (!listboxRef.current) {
      return [];
    }
    return [...new Set(listboxRef.current.querySelectorAll(OPTION_SELECTOR))];
  }, []);
  const getFirstNavigableOption = (0, import_react628.useCallback)((currentOptions2) => {
    const hasSelectedOptions = currentOptions2.some((option) => option.getAttribute("aria-selected") === "true");
    let elementIndex = 0;
    const element = currentOptions2.find((option, index) => {
      const isInteractable = option.getAttribute("aria-disabled") !== "true";
      let isFirstNavigableOption;
      if (hasSelectedOptions && autoSelection === AutoSelection.FirstSelected) {
        const isSelected2 = option.getAttribute("aria-selected") === "true";
        isFirstNavigableOption = isSelected2 && isInteractable;
      } else {
        isFirstNavigableOption = isInteractable;
      }
      if (isFirstNavigableOption)
        elementIndex = index;
      return isFirstNavigableOption;
    });
    if (!element)
      return;
    return {
      element,
      index: elementIndex
    };
  }, [autoSelection]);
  const handleScrollIntoView = (0, import_react628.useCallback)((option) => {
    const {
      current: scrollable2
    } = scrollableRef;
    if (scrollable2) {
      scrollOptionIntoView(option.element, scrollable2);
    }
  }, []);
  const handleScrollIntoViewDebounced = debounce(handleScrollIntoView, 50);
  const handleKeyToBottom = (0, import_react628.useCallback)(() => {
    if (onKeyToBottom) {
      setLazyLoading(true);
      return Promise.resolve(onKeyToBottom());
    }
  }, [onKeyToBottom]);
  const handleChangeActiveOption = (0, import_react628.useCallback)((nextOption) => {
    if (!nextOption)
      return setActiveOption(void 0);
    activeOption === null || activeOption === void 0 ? void 0 : activeOption.element.removeAttribute(OPTION_FOCUS_ATTRIBUTE);
    nextOption.element.setAttribute(OPTION_FOCUS_ATTRIBUTE, "true");
    handleScrollIntoViewDebounced(nextOption);
    setActiveOption(nextOption);
    setActiveOptionId === null || setActiveOptionId === void 0 ? void 0 : setActiveOptionId(nextOption.domId);
    onActiveOptionChange === null || onActiveOptionChange === void 0 ? void 0 : onActiveOptionChange(nextOption.value, nextOption.domId);
  }, [activeOption, setActiveOptionId, onActiveOptionChange, handleScrollIntoViewDebounced]);
  const getFormattedOption = (0, import_react628.useCallback)((element, index) => {
    return {
      element,
      index,
      domId: element.id,
      value: element.getAttribute(OPTION_VALUE_ATTRIBUTE) || "",
      disabled: element.getAttribute("aria-disabled") === "true",
      isAction: element.getAttribute(OPTION_ACTION_ATTRIBUTE) === "true"
    };
  }, []);
  const resetActiveOption = (0, import_react628.useCallback)(() => {
    var _nextOption, _nextOption2, _nextOption3;
    let nextOption;
    const nextOptions = getNavigableOptions();
    const nextActiveOption = getFirstNavigableOption(nextOptions);
    if (nextOptions.length === 0 && currentOptions.length > 0) {
      setCurrentOptions(nextOptions);
      handleChangeActiveOption();
      return;
    }
    if (nextActiveOption) {
      const {
        element,
        index
      } = nextActiveOption;
      nextOption = getFormattedOption(element, index);
    }
    const optionIsAlreadyActive = activeOption !== void 0 && ((_nextOption = nextOption) === null || _nextOption === void 0 ? void 0 : _nextOption.domId) === (activeOption === null || activeOption === void 0 ? void 0 : activeOption.domId);
    const actionContentHasUpdated = (activeOption === null || activeOption === void 0 ? void 0 : activeOption.isAction) && ((_nextOption2 = nextOption) === null || _nextOption2 === void 0 ? void 0 : _nextOption2.isAction) && ((_nextOption3 = nextOption) === null || _nextOption3 === void 0 ? void 0 : _nextOption3.value) !== (activeOption === null || activeOption === void 0 ? void 0 : activeOption.value);
    const currentValues = currentOptions.map((option) => option.getAttribute(OPTION_VALUE_ATTRIBUTE));
    const nextValues = nextOptions.map((option) => option.getAttribute(OPTION_VALUE_ATTRIBUTE));
    const listIsUnchanged = nextValues.length === currentValues.length && nextValues.every((value, index) => {
      return currentValues[index] === value;
    });
    const listIsAppended = currentValues.length !== 0 && nextValues.length > currentValues.length && currentValues.every((value, index) => {
      return nextValues[index] === value;
    });
    if (listIsUnchanged) {
      if (optionIsAlreadyActive && actionContentHasUpdated) {
        setCurrentOptions(nextOptions);
        handleChangeActiveOption(nextOption);
      }
      return;
    }
    if (listIsAppended) {
      setCurrentOptions(nextOptions);
      return;
    }
    setCurrentOptions(nextOptions);
    if (lazyLoading) {
      setLazyLoading(false);
      return;
    }
    handleChangeActiveOption(nextOption);
  }, [lazyLoading, currentOptions, activeOption, getFirstNavigableOption, getNavigableOptions, getFormattedOption, handleChangeActiveOption]);
  (0, import_react628.useEffect)(() => {
    if (autoSelection !== AutoSelection.None && !loading && children2 && import_react628.Children.count(children2) > 0) {
      resetActiveOption();
    }
  }, [children2, autoSelection, activeOption, loading, resetActiveOption]);
  (0, import_react628.useEffect)(() => {
    if (listboxRef.current) {
      scrollableRef.current = listboxRef.current.closest(scrollable.selector);
    }
  }, []);
  (0, import_react628.useEffect)(() => {
    if (enableKeyboardControl && !keyboardEventsEnabled) {
      enableKeyboardEvents();
    }
  }, [enableKeyboardControl, keyboardEventsEnabled, enableKeyboardEvents]);
  const onOptionSelect = (0, import_react628.useCallback)((option) => {
    handleChangeActiveOption(option);
    if (onOptionSelected)
      onOptionSelected();
    if (onSelect)
      onSelect(option.value);
  }, [handleChangeActiveOption, onSelect, onOptionSelected]);
  const getNextIndex = (0, import_react628.useCallback)((currentIndex, lastIndex, direction) => {
    let nextIndex;
    if (direction === "down") {
      if (currentIndex === lastIndex) {
        nextIndex = willLoadMoreOptions ? currentIndex + 1 : 0;
      } else {
        nextIndex = currentIndex + 1;
      }
    } else {
      nextIndex = currentIndex === 0 ? lastIndex : currentIndex - 1;
    }
    return nextIndex;
  }, [willLoadMoreOptions]);
  const getNextValidOption = (0, import_react628.useCallback)(async (key) => {
    const lastIndex = currentOptions.length - 1;
    let currentIndex = (activeOption === null || activeOption === void 0 ? void 0 : activeOption.index) || 0;
    let nextIndex = 0;
    let element = activeOption === null || activeOption === void 0 ? void 0 : activeOption.element;
    let totalOptions = -1;
    if (!activeOption && autoSelection === AutoSelection.None) {
      const nextOptions = getNavigableOptions();
      const nextActiveOption = getFirstNavigableOption(nextOptions);
      setCurrentOptions(nextOptions);
      return {
        element: nextActiveOption === null || nextActiveOption === void 0 ? void 0 : nextActiveOption.element,
        nextIndex: (nextActiveOption === null || nextActiveOption === void 0 ? void 0 : nextActiveOption.index) || 0
      };
    }
    while (totalOptions++ < lastIndex) {
      var _element;
      nextIndex = getNextIndex(currentIndex, lastIndex, key);
      element = currentOptions[nextIndex];
      const triggerLazyLoad = nextIndex >= lastIndex;
      const isDisabled = ((_element = element) === null || _element === void 0 ? void 0 : _element.getAttribute("aria-disabled")) === "true";
      if (triggerLazyLoad && willLoadMoreOptions) {
        await handleKeyToBottom();
      }
      if (isDisabled) {
        currentIndex = nextIndex;
        element = void 0;
        continue;
      }
      break;
    }
    return {
      element,
      nextIndex
    };
  }, [autoSelection, currentOptions, activeOption, willLoadMoreOptions, getNextIndex, handleKeyToBottom, getFirstNavigableOption, getNavigableOptions]);
  const handleArrow = (0, import_react628.useCallback)(async (type, event) => {
    event.preventDefault();
    const {
      element,
      nextIndex
    } = await getNextValidOption(type);
    if (!element)
      return;
    const nextOption = getFormattedOption(element, nextIndex);
    handleChangeActiveOption(nextOption);
  }, [getFormattedOption, getNextValidOption, handleChangeActiveOption]);
  const handleDownArrow = (0, import_react628.useCallback)((event) => {
    handleArrow("down", event);
  }, [handleArrow]);
  const handleUpArrow = (0, import_react628.useCallback)((event) => {
    handleArrow("up", event);
  }, [handleArrow]);
  const handleEnter = (0, import_react628.useCallback)((event) => {
    event.preventDefault();
    event.stopPropagation();
    if (activeOption) {
      onOptionSelect(activeOption);
    }
  }, [activeOption, onOptionSelect]);
  const handleFocus = (0, import_react628.useCallback)(() => {
    if (enableKeyboardControl)
      return;
    enableKeyboardEvents();
  }, [enableKeyboardControl, enableKeyboardEvents]);
  const handleBlur = (0, import_react628.useCallback)((event) => {
    event.stopPropagation();
    if (keyboardEventsEnabled) {
      const nextActiveOption = getFirstNavigableOption(currentOptions);
      if (nextActiveOption) {
        const {
          element,
          index
        } = nextActiveOption;
        const nextOption = getFormattedOption(element, index);
        handleChangeActiveOption(nextOption);
      }
    }
    if (enableKeyboardControl)
      return;
    disableKeyboardEvents();
  }, [enableKeyboardControl, currentOptions, keyboardEventsEnabled, disableKeyboardEvents, getFirstNavigableOption, getFormattedOption, handleChangeActiveOption]);
  const listeners = keyboardEventsEnabled || textFieldFocused ? import_react628.default.createElement(import_react628.default.Fragment, null, import_react628.default.createElement(KeypressListener, {
    keyEvent: "keydown",
    keyCode: Key.DownArrow,
    handler: handleDownArrow
  }), import_react628.default.createElement(KeypressListener, {
    keyEvent: "keydown",
    keyCode: Key.UpArrow,
    handler: handleUpArrow
  }), import_react628.default.createElement(KeypressListener, {
    keyEvent: "keydown",
    keyCode: Key.Enter,
    handler: handleEnter
  })) : null;
  const listboxContext = (0, import_react628.useMemo)(() => ({
    onOptionSelect,
    setLoading
  }), [onOptionSelect]);
  return import_react628.default.createElement(import_react628.default.Fragment, null, listeners, import_react628.default.createElement(Text, {
    as: "span",
    visuallyHidden: true
  }, import_react628.default.createElement("div", {
    "aria-live": "polite"
  }, loading ? loading : null)), import_react628.default.createElement(ListboxContext.Provider, {
    value: listboxContext
  }, import_react628.default.createElement(WithinListboxContext.Provider, {
    value: true
  }, children2 ? import_react628.default.createElement("ul", {
    tabIndex: 0,
    role: "listbox",
    className: styles41.Listbox,
    "aria-label": inCombobox ? void 0 : accessibilityLabel,
    "aria-labelledby": textFieldLabelId,
    "aria-busy": Boolean(loading),
    "aria-activedescendant": activeOption && activeOption.domId,
    id: listId,
    onFocus: inCombobox ? void 0 : handleFocus,
    onBlur: inCombobox ? void 0 : handleBlur,
    ref: listboxRef
  }, children2) : null)));
}
Listbox.Option = Option;
Listbox.TextOption = TextOption;
Listbox.Loading = Loading;
Listbox.Section = Section4;
Listbox.Header = Header2;
Listbox.Action = Action;

// ../node_modules/@shopify/polaris/build/esm/components/Autocomplete/components/MappedOption/MappedOption.js
var MappedOption = (0, import_react629.memo)(function MappedOption2({
  label,
  value,
  disabled,
  media,
  selected,
  singleSelection
}) {
  const mediaClassNames = classNames(styles40.Media, disabled && styles40.disabledMedia, singleSelection && styles40.singleSelectionMedia);
  const mediaMarkup = media ? import_react629.default.createElement("div", {
    className: mediaClassNames
  }, media) : null;
  const accessibilityLabel = typeof label === "string" ? label : void 0;
  return import_react629.default.createElement(Listbox.Option, {
    accessibilityLabel,
    key: value,
    selected,
    value,
    disabled
  }, import_react629.default.createElement(Listbox.TextOption, {
    selected,
    disabled
  }, import_react629.default.createElement("div", {
    className: styles40.Content
  }, mediaMarkup, label)));
});

// ../node_modules/@shopify/polaris/build/esm/components/Combobox/Combobox.js
var import_react631 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Combobox/Combobox.scss.js
var styles49 = {
  "Listbox": "Polaris-Combobox__Listbox"
};

// ../node_modules/@shopify/polaris/build/esm/components/Combobox/components/TextField/TextField.js
var import_react630 = __toESM(require_react());
function TextField2({
  value,
  id: idProp,
  type = "text",
  ariaAutocomplete = "list",
  onFocus,
  onBlur,
  onChange,
  ...rest
}) {
  const comboboxTextFieldContext = useComboboxTextField();
  const {
    activeOptionId,
    listboxId,
    expanded,
    setTextFieldFocused,
    setTextFieldLabelId,
    onTextFieldFocus,
    onTextFieldChange,
    onTextFieldBlur
  } = comboboxTextFieldContext;
  const uniqueId = useUniqueId("ComboboxTextField");
  const textFieldId = (0, import_react630.useMemo)(() => idProp || uniqueId, [uniqueId, idProp]);
  const labelId = (0, import_react630.useMemo)(() => labelID(idProp || uniqueId), [uniqueId, idProp]);
  (0, import_react630.useEffect)(() => {
    if (setTextFieldLabelId)
      setTextFieldLabelId(labelId);
  }, [labelId, setTextFieldLabelId]);
  const handleFocus = (0, import_react630.useCallback)((event) => {
    if (onFocus)
      onFocus(event);
    if (onTextFieldFocus)
      onTextFieldFocus();
    if (setTextFieldFocused)
      setTextFieldFocused(true);
  }, [onFocus, onTextFieldFocus, setTextFieldFocused]);
  const handleBlur = (0, import_react630.useCallback)((event) => {
    if (onBlur)
      onBlur(event);
    if (onTextFieldBlur)
      onTextFieldBlur();
    if (setTextFieldFocused)
      setTextFieldFocused(false);
  }, [onBlur, onTextFieldBlur, setTextFieldFocused]);
  const handleChange = (0, import_react630.useCallback)((value2, id) => {
    if (onChange)
      onChange(value2, id);
    if (onTextFieldChange)
      onTextFieldChange(value2);
  }, [onChange, onTextFieldChange]);
  return import_react630.default.createElement(TextField, Object.assign({}, rest, {
    value,
    id: textFieldId,
    type,
    ariaAutocomplete,
    "aria-haspopup": "listbox",
    ariaActiveDescendant: activeOptionId,
    ariaControls: listboxId,
    role: "combobox",
    ariaExpanded: expanded,
    onFocus: handleFocus,
    onBlur: handleBlur,
    onChange: handleChange
  }));
}

// ../node_modules/@shopify/polaris/build/esm/components/Combobox/Combobox.js
function Combobox({
  activator,
  allowMultiple,
  children: children2,
  preferredPosition = "below",
  willLoadMoreOptions,
  height,
  onScrolledToBottom,
  onClose
}) {
  const [popoverActive, setPopoverActive] = (0, import_react631.useState)(false);
  const [activeOptionId, setActiveOptionId] = (0, import_react631.useState)();
  const [textFieldLabelId, setTextFieldLabelId] = (0, import_react631.useState)();
  const [listboxId, setListboxId] = (0, import_react631.useState)();
  const [textFieldFocused, setTextFieldFocused] = (0, import_react631.useState)(false);
  const shouldOpen = Boolean(!popoverActive && import_react631.Children.count(children2) > 0);
  const ref = (0, import_react631.useRef)(null);
  const handleClose = (0, import_react631.useCallback)(() => {
    setPopoverActive(false);
    onClose === null || onClose === void 0 ? void 0 : onClose();
    setActiveOptionId(void 0);
  }, [onClose]);
  const handleOpen = (0, import_react631.useCallback)(() => {
    setPopoverActive(true);
    setActiveOptionId(void 0);
  }, []);
  const onOptionSelected = (0, import_react631.useCallback)(() => {
    var _ref$current;
    if (!allowMultiple) {
      handleClose();
      setActiveOptionId(void 0);
      return;
    }
    (_ref$current = ref.current) === null || _ref$current === void 0 ? void 0 : _ref$current.forceUpdatePosition();
  }, [allowMultiple, handleClose]);
  const handleFocus = (0, import_react631.useCallback)(() => {
    if (shouldOpen) {
      handleOpen();
    }
  }, [shouldOpen, handleOpen]);
  const handleChange = (0, import_react631.useCallback)(() => {
    if (shouldOpen) {
      handleOpen();
    }
  }, [shouldOpen, handleOpen]);
  const handleBlur = (0, import_react631.useCallback)(() => {
    if (popoverActive) {
      handleClose();
    }
  }, [popoverActive, handleClose]);
  const textFieldContextValue = (0, import_react631.useMemo)(() => ({
    activeOptionId,
    expanded: popoverActive,
    listboxId,
    setTextFieldFocused,
    setTextFieldLabelId,
    onTextFieldFocus: handleFocus,
    onTextFieldChange: handleChange,
    onTextFieldBlur: handleBlur
  }), [activeOptionId, popoverActive, listboxId, setTextFieldFocused, setTextFieldLabelId, handleFocus, handleChange, handleBlur]);
  const listboxOptionContextValue = (0, import_react631.useMemo)(() => ({
    allowMultiple
  }), [allowMultiple]);
  const listboxContextValue = (0, import_react631.useMemo)(() => ({
    listboxId,
    textFieldLabelId,
    textFieldFocused,
    willLoadMoreOptions,
    onOptionSelected,
    setActiveOptionId,
    setListboxId,
    onKeyToBottom: onScrolledToBottom
  }), [listboxId, textFieldLabelId, textFieldFocused, willLoadMoreOptions, onOptionSelected, setActiveOptionId, setListboxId, onScrolledToBottom]);
  return import_react631.default.createElement(Popover2, {
    ref,
    active: popoverActive,
    activator: import_react631.default.createElement(ComboboxTextFieldContext.Provider, {
      value: textFieldContextValue
    }, activator),
    autofocusTarget: "none",
    preventFocusOnClose: true,
    fullWidth: true,
    preferInputActivator: false,
    preferredPosition,
    onClose: handleClose
  }, import_react631.Children.count(children2) > 0 ? import_react631.default.createElement(Popover2.Pane, {
    onScrolledToBottom,
    height
  }, import_react631.default.createElement(ComboboxListboxContext.Provider, {
    value: listboxContextValue
  }, import_react631.default.createElement(ComboboxListboxOptionContext.Provider, {
    value: listboxOptionContextValue
  }, import_react631.default.createElement("div", {
    className: styles49.Listbox
  }, children2)))) : null);
}
Combobox.TextField = TextField2;

// ../node_modules/@shopify/polaris/build/esm/components/Autocomplete/components/MappedAction/MappedAction.js
var import_react632 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Autocomplete/components/MappedAction/MappedAction.scss.js
var styles50 = {
  "ActionContainer": "Polaris-Autocomplete-MappedAction__ActionContainer",
  "Action": "Polaris-Autocomplete-MappedAction__Action",
  "destructive": "Polaris-Autocomplete-MappedAction--destructive",
  "selected": "Polaris-Autocomplete-MappedAction--selected",
  "disabled": "Polaris-Autocomplete-MappedAction--disabled",
  "Prefix": "Polaris-Autocomplete-MappedAction__Prefix",
  "Suffix": "Polaris-Autocomplete-MappedAction__Suffix",
  "Content": "Polaris-Autocomplete-MappedAction__Content",
  "Text": "Polaris-Autocomplete-MappedAction__Text",
  "ContentWrap": "Polaris-Autocomplete-MappedAction__ContentWrap"
};

// ../node_modules/@shopify/polaris/build/esm/components/Autocomplete/components/MappedAction/MappedAction.js
function MappedAction({
  active,
  content,
  disabled,
  icon,
  image,
  prefix,
  suffix,
  ellipsis,
  role,
  url,
  external,
  onAction,
  destructive,
  badge,
  helpText,
  wrapOverflow = false
}) {
  const i18n = useI18n();
  let prefixMarkup = null;
  const contentOverflowStyle = wrapOverflow ? styles50.ContentWrap : void 0;
  if (prefix) {
    prefixMarkup = import_react632.default.createElement("div", {
      className: styles50.Prefix
    }, prefix);
  } else if (icon) {
    prefixMarkup = import_react632.default.createElement("div", {
      className: styles50.Prefix
    }, import_react632.default.createElement(Icon, {
      source: icon
    }));
  } else if (image) {
    prefixMarkup = import_react632.default.createElement("div", {
      role: "presentation",
      className: styles50.Prefix,
      style: {
        backgroundImage: `url(${image}`
      }
    });
  }
  const badgeMarkup = badge && import_react632.default.createElement("span", {
    className: styles50.Suffix
  }, import_react632.default.createElement(Badge, {
    status: badge.status
  }, badge.content));
  const suffixMarkup = suffix && import_react632.default.createElement("span", {
    className: styles50.Suffix
  }, suffix);
  const contentText = ellipsis && content ? i18n.translate("Polaris.Autocomplete.ellipsis", {
    content
  }) : content;
  const contentMarkup = import_react632.default.createElement("div", {
    className: styles50.Text
  }, import_react632.default.createElement("div", {
    className: contentOverflowStyle
  }, contentText), helpText ? import_react632.default.createElement(Text, {
    color: "subdued",
    as: "span"
  }, helpText) : null);
  const context = (0, import_react632.useMemo)(() => ({
    role,
    url,
    external,
    onAction,
    destructive
  }), [role, url, external, onAction, destructive]);
  const actionClassNames = classNames(styles50.Action, disabled && styles50.disabled, destructive && styles50.destructive, active && styles50.selected);
  return import_react632.default.createElement(MappedActionContext.Provider, {
    value: context
  }, import_react632.default.createElement("div", {
    className: styles50.ActionContainer
  }, import_react632.default.createElement(Listbox.Action, {
    selected: active,
    disabled,
    value: content || ""
  }, import_react632.default.createElement("div", {
    className: actionClassNames
  }, import_react632.default.createElement("div", {
    className: styles50.Content
  }, prefixMarkup, contentMarkup, badgeMarkup, suffixMarkup)))));
}

// ../node_modules/@shopify/polaris/build/esm/components/Autocomplete/Autocomplete.js
var Autocomplete = function Autocomplete2({
  options,
  selected,
  textField,
  preferredPosition,
  listTitle,
  allowMultiple,
  loading,
  actionBefore,
  willLoadMoreResults,
  emptyState,
  onSelect,
  onLoadMoreResults
}) {
  const i18n = useI18n();
  const buildMappedOptionFromOption = (0, import_react633.useCallback)((options2) => {
    return options2.map((option) => import_react633.default.createElement(MappedOption, Object.assign({
      key: option.id || option.value
    }, option, {
      selected: selected.includes(option.value),
      singleSelection: !allowMultiple
    })));
  }, [selected, allowMultiple]);
  const optionsMarkup = (0, import_react633.useMemo)(() => {
    const conditionalOptions = loading && !willLoadMoreResults ? [] : options;
    if (isSection(conditionalOptions)) {
      const noOptionsAvailable = conditionalOptions.every(({
        options: options2
      }) => options2.length === 0);
      if (noOptionsAvailable) {
        return null;
      }
      const optionsMarkup2 = conditionalOptions.map(({
        options: options2,
        title
      }) => {
        if (options2.length === 0) {
          return null;
        }
        const optionMarkup = buildMappedOptionFromOption(options2);
        return import_react633.default.createElement(Listbox.Section, {
          divider: false,
          title: import_react633.default.createElement(Listbox.Header, null, title),
          key: title
        }, optionMarkup);
      });
      return import_react633.default.createElement("div", {
        className: styles39.SectionWrapper
      }, optionsMarkup2);
    }
    const optionList = conditionalOptions.length > 0 ? buildMappedOptionFromOption(conditionalOptions) : null;
    if (listTitle) {
      return import_react633.default.createElement(Listbox.Section, {
        divider: false,
        title: import_react633.default.createElement(Listbox.Header, null, listTitle)
      }, optionList);
    }
    return optionList;
  }, [listTitle, loading, options, willLoadMoreResults, buildMappedOptionFromOption]);
  const loadingMarkup = loading ? import_react633.default.createElement(Listbox.Loading, {
    accessibilityLabel: i18n.translate("Polaris.Autocomplete.spinnerAccessibilityLabel")
  }) : null;
  const updateSelection = (0, import_react633.useCallback)((newSelection) => {
    if (actionBefore && newSelection === actionBefore.content) {
      actionBefore.onAction && actionBefore.onAction();
      return;
    }
    if (allowMultiple) {
      if (selected.includes(newSelection)) {
        onSelect(selected.filter((option) => option !== newSelection));
      } else {
        onSelect([...selected, newSelection]);
      }
    } else {
      onSelect([newSelection]);
    }
  }, [allowMultiple, onSelect, selected, actionBefore]);
  const actionMarkup = actionBefore && import_react633.default.createElement(MappedAction, actionBefore);
  const emptyStateMarkup = emptyState && options.length < 1 && !loading && import_react633.default.createElement("div", {
    role: "status"
  }, emptyState);
  const autoSelection = actionBefore ? AutoSelection.First : void 0;
  return import_react633.default.createElement(Combobox, {
    activator: textField,
    allowMultiple,
    onScrolledToBottom: onLoadMoreResults,
    preferredPosition,
    willLoadMoreOptions: willLoadMoreResults
  }, actionMarkup || optionsMarkup || loadingMarkup || emptyStateMarkup ? import_react633.default.createElement(Listbox, {
    autoSelection,
    onSelect: updateSelection
  }, actionMarkup, optionsMarkup && (!loading || willLoadMoreResults) ? optionsMarkup : null, loadingMarkup, emptyStateMarkup) : null);
};
Autocomplete.TextField = Combobox.TextField;

// ../node_modules/@shopify/polaris/build/esm/components/Banner/Banner.js
var import_react636 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/banner-context.js
var import_react634 = __toESM(require_react());
var BannerContext = (0, import_react634.createContext)(false);

// ../node_modules/@shopify/polaris/build/esm/components/Banner/Banner.scss.js
var styles51 = {
  "Banner": "Polaris-Banner",
  "statusCritical": "Polaris-Banner--statusCritical",
  "PrimaryAction": "Polaris-Banner__PrimaryAction",
  "Button": "Polaris-Banner__Button",
  "statusWarning": "Polaris-Banner--statusWarning",
  "statusInfo": "Polaris-Banner--statusInfo",
  "statusSuccess": "Polaris-Banner--statusSuccess",
  "ContentWrapper": "Polaris-Banner__ContentWrapper",
  "withinContentContainer": "Polaris-Banner--withinContentContainer",
  "Dismiss": "Polaris-Banner__Dismiss",
  "keyFocused": "Polaris-Banner--keyFocused",
  "withinPage": "Polaris-Banner--withinPage",
  "Ribbon": "Polaris-Banner__Ribbon",
  "hasDismiss": "Polaris-Banner--hasDismiss",
  "SecondaryAction": "Polaris-Banner__SecondaryAction",
  "Text": "Polaris-Banner__Text",
  "pressed": "Polaris-Banner--pressed",
  "loading": "Polaris-Banner--loading",
  "Spinner": "Polaris-Banner__Spinner"
};

// ../node_modules/@shopify/polaris/build/esm/components/UnstyledButton/utils.js
var import_react635 = __toESM(require_react());
function unstyledButtonFrom({
  content,
  onAction,
  ...action
}, overrides, key) {
  return import_react635.default.createElement(UnstyledButton, Object.assign({
    key,
    onClick: onAction
  }, action, overrides), content);
}

// ../node_modules/@shopify/polaris/build/esm/components/Banner/Banner.js
var Banner = (0, import_react636.forwardRef)(function Banner2({
  icon,
  action,
  secondaryAction,
  title,
  children: children2,
  status,
  onDismiss,
  stopAnnouncements,
  hideIcon
}, bannerRef) {
  const withinContentContainer = (0, import_react636.useContext)(WithinContentContext);
  const i18n = useI18n();
  const {
    wrapperRef,
    handleKeyUp,
    handleBlur,
    handleMouseUp,
    shouldShowFocus
  } = useBannerFocus(bannerRef);
  const {
    defaultIcon,
    iconColor,
    ariaRoleType
  } = useBannerAttributes(status);
  const iconName = icon || defaultIcon;
  const className = classNames(styles51.Banner, status && styles51[variationName("status", status)], onDismiss && styles51.hasDismiss, shouldShowFocus && styles51.keyFocused, withinContentContainer ? styles51.withinContentContainer : styles51.withinPage);
  let headingMarkup = null;
  if (title) {
    headingMarkup = import_react636.default.createElement(Text, {
      as: "h2",
      variant: "headingMd",
      breakWord: true
    }, title);
  }
  const spinnerMarkup = action !== null && action !== void 0 && action.loading ? import_react636.default.createElement("button", {
    disabled: true,
    "aria-busy": true,
    className: classNames(styles51.Button, styles51.loading)
  }, import_react636.default.createElement("span", {
    className: styles51.Spinner
  }, import_react636.default.createElement(Spinner, {
    size: "small",
    accessibilityLabel: i18n.translate("Polaris.Button.spinnerAccessibilityLabel")
  })), action.content) : null;
  const primaryActionMarkup = action ? import_react636.default.createElement(Box, {
    paddingInlineEnd: "2"
  }, action.loading ? spinnerMarkup : unstyledButtonFrom(action, {
    className: `${styles51.Button} ${styles51.PrimaryAction}`
  })) : null;
  const secondaryActionMarkup = secondaryAction ? import_react636.default.createElement(SecondaryActionFrom, {
    action: secondaryAction
  }) : null;
  const actionMarkup = action || secondaryAction ? import_react636.default.createElement(Box, {
    paddingBlockStart: withinContentContainer ? "3" : "4",
    paddingBlockEnd: withinContentContainer ? "1" : void 0
  }, import_react636.default.createElement(ButtonGroup, null, primaryActionMarkup, secondaryActionMarkup)) : null;
  let contentMarkup = null;
  if (children2 || actionMarkup) {
    contentMarkup = import_react636.default.createElement(Box, {
      paddingBlockStart: "05",
      paddingBlockEnd: "05"
    }, children2, actionMarkup);
  }
  const dismissButton = onDismiss && import_react636.default.createElement("div", {
    className: styles51.Dismiss
  }, import_react636.default.createElement(Button, {
    plain: true,
    icon: SvgCancelSmallMinor,
    onClick: onDismiss,
    accessibilityLabel: "Dismiss notification"
  }));
  return import_react636.default.createElement(BannerContext.Provider, {
    value: true
  }, import_react636.default.createElement("div", {
    className,
    tabIndex: 0,
    ref: wrapperRef,
    role: ariaRoleType,
    "aria-live": stopAnnouncements ? "off" : "polite",
    onMouseUp: handleMouseUp,
    onKeyUp: handleKeyUp,
    onBlur: handleBlur
  }, dismissButton, hideIcon ? null : import_react636.default.createElement(Box, {
    paddingInlineEnd: "4"
  }, import_react636.default.createElement(Icon, {
    source: iconName,
    color: iconColor
  })), import_react636.default.createElement("div", {
    className: styles51.ContentWrapper
  }, headingMarkup, contentMarkup)));
});
function SecondaryActionFrom({
  action
}) {
  if (action.url) {
    return import_react636.default.createElement(UnstyledLink, {
      className: styles51.SecondaryAction,
      url: action.url,
      external: action.external,
      target: action.target
    }, import_react636.default.createElement("span", {
      className: styles51.Text
    }, action.content));
  }
  return import_react636.default.createElement(UnstyledButton, {
    className: styles51.SecondaryAction,
    onClick: action.onAction
  }, import_react636.default.createElement("span", {
    className: styles51.Text
  }, action.content));
}
function useBannerAttributes(status) {
  switch (status) {
    case "success":
      return {
        defaultIcon: SvgCircleTickMajor,
        iconColor: "success",
        ariaRoleType: "status"
      };
    case "info":
      return {
        defaultIcon: SvgCircleInformationMajor,
        iconColor: "highlight",
        ariaRoleType: "status"
      };
    case "warning":
      return {
        defaultIcon: SvgCircleAlertMajor,
        iconColor: "warning",
        ariaRoleType: "alert"
      };
    case "critical":
      return {
        defaultIcon: SvgDiamondAlertMajor,
        iconColor: "critical",
        ariaRoleType: "alert"
      };
    default:
      return {
        defaultIcon: SvgCircleInformationMajor,
        iconColor: "base",
        ariaRoleType: "status"
      };
  }
}
function useBannerFocus(bannerRef) {
  const wrapperRef = (0, import_react636.useRef)(null);
  const [shouldShowFocus, setShouldShowFocus] = (0, import_react636.useState)(false);
  (0, import_react636.useImperativeHandle)(bannerRef, () => ({
    focus: () => {
      var _wrapperRef$current;
      (_wrapperRef$current = wrapperRef.current) === null || _wrapperRef$current === void 0 ? void 0 : _wrapperRef$current.focus();
      setShouldShowFocus(true);
    }
  }), []);
  const handleKeyUp = (event) => {
    if (event.target === wrapperRef.current) {
      setShouldShowFocus(true);
    }
  };
  const handleBlur = () => setShouldShowFocus(false);
  const handleMouseUp = (event) => {
    event.currentTarget.blur();
    setShouldShowFocus(false);
  };
  return {
    wrapperRef,
    handleKeyUp,
    handleBlur,
    handleMouseUp,
    shouldShowFocus
  };
}

// ../node_modules/@shopify/polaris/build/esm/components/Bleed/Bleed.js
var import_react637 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Bleed/Bleed.scss.js
var styles52 = {
  "Bleed": "Polaris-Bleed"
};

// ../node_modules/@shopify/polaris/build/esm/components/Bleed/Bleed.js
var Bleed = ({
  marginInline,
  marginBlock,
  marginBlockStart,
  marginBlockEnd,
  marginInlineStart,
  marginInlineEnd,
  children: children2
}) => {
  const getNegativeMargins = (direction) => {
    const xAxis = ["marginInlineStart", "marginInlineEnd"];
    const yAxis = ["marginBlockStart", "marginBlockEnd"];
    const directionValues = {
      marginBlockStart,
      marginBlockEnd,
      marginInlineStart,
      marginInlineEnd,
      marginInline,
      marginBlock
    };
    if (directionValues[direction]) {
      return directionValues[direction];
    } else if (xAxis.includes(direction) && marginInline) {
      return directionValues.marginInline;
    } else if (yAxis.includes(direction) && marginBlock) {
      return directionValues.marginBlock;
    }
  };
  const negativeMarginBlockStart = getNegativeMargins("marginBlockStart");
  const negativeMarginBlockEnd = getNegativeMargins("marginBlockEnd");
  const negativeMarginInlineStart = getNegativeMargins("marginInlineStart");
  const negativeMarginInlineEnd = getNegativeMargins("marginInlineEnd");
  const style = {
    ...getResponsiveProps("bleed", "margin-block-start", "space", negativeMarginBlockStart),
    ...getResponsiveProps("bleed", "margin-block-end", "space", negativeMarginBlockEnd),
    ...getResponsiveProps("bleed", "margin-inline-start", "space", negativeMarginInlineStart),
    ...getResponsiveProps("bleed", "margin-inline-end", "space", negativeMarginInlineEnd)
  };
  return import_react637.default.createElement("div", {
    className: styles52.Bleed,
    style: sanitizeCustomProperties(style)
  }, children2);
};

// ../node_modules/@shopify/polaris/build/esm/components/Breadcrumbs/Breadcrumbs.js
var import_react638 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Breadcrumbs/Breadcrumbs.scss.js
var styles53 = {
  "Breadcrumb": "Polaris-Breadcrumbs__Breadcrumb",
  "Icon": "Polaris-Breadcrumbs__Icon",
  "Content": "Polaris-Breadcrumbs__Content"
};

// ../node_modules/@shopify/polaris/build/esm/components/Breadcrumbs/Breadcrumbs.js
function Breadcrumbs({
  breadcrumbs,
  backAction
}) {
  const breadcrumb = backAction !== null && backAction !== void 0 ? backAction : Array.isArray(breadcrumbs) ? breadcrumbs[breadcrumbs.length - 1] : breadcrumbs;
  if (breadcrumb == null) {
    if (true) {
      console.warn("Please provide a value to backAction, it will become required in the next major release.");
    }
    return null;
  }
  const {
    content
  } = breadcrumb;
  const contentMarkup = import_react638.default.createElement(import_react638.default.Fragment, null, import_react638.default.createElement("span", {
    className: styles53.Icon
  }, import_react638.default.createElement(Icon, {
    source: SvgArrowLeftMinor
  })), import_react638.default.createElement(Text, {
    as: "span",
    visuallyHidden: true
  }, content));
  const breadcrumbMarkup = "url" in breadcrumb ? import_react638.default.createElement(UnstyledLink, {
    key: content,
    url: breadcrumb.url,
    className: styles53.Breadcrumb,
    onMouseUp: handleMouseUpByBlurring,
    "aria-label": breadcrumb.accessibilityLabel
  }, contentMarkup) : import_react638.default.createElement("button", {
    key: content,
    className: styles53.Breadcrumb,
    onClick: breadcrumb.onAction,
    onMouseUp: handleMouseUpByBlurring,
    type: "button",
    "aria-label": breadcrumb.accessibilityLabel
  }, contentMarkup);
  return import_react638.default.createElement("nav", {
    role: "navigation"
  }, breadcrumbMarkup);
}

// ../node_modules/@shopify/polaris/build/esm/components/BulkActions/BulkActions.js
var import_react642 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/BulkActions/BulkActions.scss.js
var styles54 = {
  "Group": "Polaris-BulkActions__Group",
  "Group-not-sticky": "Polaris-BulkActions--groupNotSticky",
  "Group-entering": "Polaris-BulkActions__Group--entering",
  "Group-exiting": "Polaris-BulkActions__Group--exiting",
  "Group-entered": "Polaris-BulkActions__Group--entered",
  "Group-exited": "Polaris-BulkActions__Group--exited",
  "Group-measuring": "Polaris-BulkActions__Group--measuring",
  "ButtonGroupWrapper": "Polaris-BulkActions__ButtonGroupWrapper",
  "BulkActionButton": "Polaris-BulkActions__BulkActionButton",
  "disabled": "Polaris-BulkActions--disabled"
};

// ../node_modules/@shopify/polaris/build/esm/components/BulkActions/components/BulkActionMenu/BulkActionMenu.js
var import_react641 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/BulkActions/components/BulkActionButton/BulkActionButton.js
var import_react640 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Indicator/Indicator.js
var import_react639 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Indicator/Indicator.scss.js
var styles55 = {
  "Indicator": "Polaris-Indicator",
  "pulseIndicator": "Polaris-Indicator--pulseIndicator"
};

// ../node_modules/@shopify/polaris/build/esm/components/Indicator/Indicator.js
function Indicator({
  pulse = true
}) {
  const className = classNames(styles55.Indicator, pulse && styles55.pulseIndicator);
  return import_react639.default.createElement("span", {
    className
  });
}

// ../node_modules/@shopify/polaris/build/esm/components/BulkActions/components/BulkActionButton/BulkActionButton.js
function BulkActionButton({
  handleMeasurement,
  url,
  external,
  onAction,
  content,
  disclosure,
  accessibilityLabel,
  disabled,
  indicator,
  showContentInButton
}) {
  const bulkActionButton = (0, import_react640.useRef)(null);
  useComponentDidMount(() => {
    if (handleMeasurement && bulkActionButton.current) {
      const width = bulkActionButton.current.getBoundingClientRect().width;
      handleMeasurement(width);
    }
  });
  const isActivatorForMoreActionsPopover = disclosure && !showContentInButton;
  const buttonContent = isActivatorForMoreActionsPopover ? void 0 : content;
  const buttonMarkup = import_react640.default.createElement(Button, {
    external,
    url,
    accessibilityLabel: isActivatorForMoreActionsPopover ? content : accessibilityLabel,
    disclosure: disclosure && showContentInButton,
    onClick: onAction,
    disabled,
    size: "slim",
    icon: isActivatorForMoreActionsPopover ? import_react640.default.createElement(Icon, {
      source: SvgHorizontalDotsMinor,
      color: "base"
    }) : void 0
  }, buttonContent);
  return import_react640.default.createElement("div", {
    className: styles54.BulkActionButton,
    ref: bulkActionButton
  }, isActivatorForMoreActionsPopover ? import_react640.default.createElement(Tooltip, {
    content,
    preferredPosition: "above"
  }, buttonMarkup) : buttonMarkup, indicator && import_react640.default.createElement(Indicator, null));
}

// ../node_modules/@shopify/polaris/build/esm/components/BulkActions/components/BulkActionMenu/BulkActionMenu.js
function BulkActionMenu({
  title,
  actions,
  isNewBadgeInBadgeActions
}) {
  const {
    value: isVisible,
    toggle: toggleMenuVisibility
  } = useToggle(false);
  return import_react641.default.createElement(import_react641.default.Fragment, null, import_react641.default.createElement(Popover2, {
    active: isVisible,
    activator: import_react641.default.createElement(BulkActionButton, {
      disclosure: true,
      showContentInButton: true,
      onAction: toggleMenuVisibility,
      content: title,
      indicator: isNewBadgeInBadgeActions
    }),
    onClose: toggleMenuVisibility,
    preferInputActivator: true
  }, import_react641.default.createElement(ActionList, {
    items: actions,
    onActionAnyItem: toggleMenuVisibility
  })));
}

// ../node_modules/@shopify/polaris/build/esm/components/BulkActions/BulkActions.js
var MAX_PROMOTED_ACTIONS = 2;
var BUTTONS_NODE_ADDITIONAL_WIDTH = 64;
var BulkActionsInner = class extends import_react642.PureComponent {
  constructor(...args) {
    super(...args);
    this.state = {
      popoverVisible: false,
      containerWidth: 0,
      measuring: true
    };
    this.containerNode = null;
    this.buttonsNode = null;
    this.moreActionsNode = null;
    this.groupNode = (0, import_react642.createRef)();
    this.promotedActionsWidths = [];
    this.bulkActionsWidth = 0;
    this.addedMoreActionsWidthForMeasuring = 0;
    this.handleResize = debounce(() => {
      const {
        popoverVisible
      } = this.state;
      if (this.containerNode) {
        const containerWidth = this.containerNode.getBoundingClientRect().width;
        if (containerWidth > 0) {
          this.setState({
            containerWidth
          });
        }
      }
      if (popoverVisible) {
        this.setState({
          popoverVisible: false
        });
      }
    }, 50, {
      trailing: true
    });
    this.setButtonsNode = (node) => {
      this.buttonsNode = node;
    };
    this.setContainerNode = (node) => {
      this.containerNode = node;
    };
    this.setMoreActionsNode = (node) => {
      this.moreActionsNode = node;
    };
    this.togglePopover = () => {
      if (this.props.onMoreActionPopoverToggle) {
        this.props.onMoreActionPopoverToggle(this.state.popoverVisible);
      }
      this.setState(({
        popoverVisible
      }) => ({
        popoverVisible: !popoverVisible
      }));
    };
    this.handleMeasurement = (width) => {
      const {
        measuring
      } = this.state;
      if (measuring) {
        this.promotedActionsWidths.push(width);
      }
    };
  }
  numberOfPromotedActionsToRender() {
    const {
      promotedActions
    } = this.props;
    const {
      containerWidth,
      measuring
    } = this.state;
    if (!promotedActions) {
      return 0;
    }
    const containerWidthMinusAdditionalWidth = Math.max(0, containerWidth - BUTTONS_NODE_ADDITIONAL_WIDTH);
    if (containerWidthMinusAdditionalWidth >= this.bulkActionsWidth || measuring) {
      return promotedActions.length;
    }
    let sufficientSpace = false;
    let counter = promotedActions.length - 1;
    let totalWidth = 0;
    while (!sufficientSpace && counter >= 0) {
      totalWidth += this.promotedActionsWidths[counter];
      const widthWithRemovedAction = this.bulkActionsWidth - totalWidth + this.addedMoreActionsWidthForMeasuring;
      if (containerWidthMinusAdditionalWidth >= widthWithRemovedAction) {
        sufficientSpace = true;
      } else {
        counter--;
      }
    }
    return clamp(counter, 0, promotedActions.length);
  }
  actionSections() {
    const {
      actions
    } = this.props;
    if (!actions || actions.length === 0) {
      return;
    }
    if (instanceOfBulkActionListSectionArray(actions)) {
      return actions;
    }
    if (instanceOfBulkActionArray(actions)) {
      return [{
        items: actions
      }];
    }
  }
  rolledInPromotedActions() {
    const {
      promotedActions
    } = this.props;
    const numberOfPromotedActionsToRender = this.numberOfPromotedActionsToRender();
    if (!promotedActions || promotedActions.length === 0 || numberOfPromotedActionsToRender >= promotedActions.length) {
      return [];
    }
    const rolledInPromotedActions = promotedActions.map((action) => {
      if (instanceOfMenuGroupDescriptor(action)) {
        return {
          items: [...action.actions]
        };
      }
      return {
        items: [action]
      };
    });
    return rolledInPromotedActions.slice(numberOfPromotedActionsToRender);
  }
  // eslint-disable-next-line @typescript-eslint/member-ordering
  componentDidMount() {
    const {
      actions,
      promotedActions
    } = this.props;
    if (promotedActions && !actions && this.moreActionsNode) {
      this.addedMoreActionsWidthForMeasuring = this.moreActionsNode.getBoundingClientRect().width;
    }
    this.bulkActionsWidth = this.buttonsNode ? this.buttonsNode.getBoundingClientRect().width - this.addedMoreActionsWidthForMeasuring : 0;
    if (this.containerNode) {
      this.setState({
        containerWidth: this.containerNode.getBoundingClientRect().width,
        measuring: false
      });
    }
  }
  // eslint-disable-next-line @typescript-eslint/member-ordering
  render() {
    const {
      selectMode,
      disabled,
      promotedActions,
      i18n,
      isSticky,
      width
    } = this.props;
    const actionSections = this.actionSections();
    if (promotedActions && promotedActions.length > MAX_PROMOTED_ACTIONS && true) {
      console.warn(i18n.translate("Polaris.ResourceList.BulkActions.warningMessage", {
        maxPromotedActions: MAX_PROMOTED_ACTIONS
      }));
    }
    const {
      popoverVisible,
      measuring
    } = this.state;
    const numberOfPromotedActionsToRender = this.numberOfPromotedActionsToRender();
    const promotedActionsMarkup = promotedActions && numberOfPromotedActionsToRender > 0 ? [...promotedActions].slice(0, numberOfPromotedActionsToRender).map((action, index) => {
      if (instanceOfMenuGroupDescriptor(action)) {
        return import_react642.default.createElement(BulkActionMenu, Object.assign({
          key: index
        }, action, {
          isNewBadgeInBadgeActions: this.isNewBadgeInBadgeActions()
        }));
      }
      return import_react642.default.createElement(BulkActionButton, Object.assign({
        key: index,
        disabled
      }, action, {
        handleMeasurement: this.handleMeasurement
      }));
    }) : null;
    const rolledInPromotedActions = this.rolledInPromotedActions();
    const activatorLabel = !promotedActions || promotedActions && numberOfPromotedActionsToRender === 0 && !measuring ? i18n.translate("Polaris.ResourceList.BulkActions.actionsActivatorLabel") : i18n.translate("Polaris.ResourceList.BulkActions.moreActionsActivatorLabel");
    let combinedActions = [];
    if (actionSections && rolledInPromotedActions.length > 0) {
      combinedActions = [...rolledInPromotedActions, ...actionSections];
    } else if (actionSections) {
      combinedActions = actionSections;
    } else if (rolledInPromotedActions.length > 0) {
      combinedActions = [...rolledInPromotedActions];
    }
    const actionsPopover = actionSections || rolledInPromotedActions.length > 0 || measuring ? import_react642.default.createElement("div", {
      className: styles54.Popover,
      ref: this.setMoreActionsNode
    }, import_react642.default.createElement(Popover2, {
      active: popoverVisible,
      activator: import_react642.default.createElement(BulkActionButton, {
        disclosure: true,
        showContentInButton: !promotedActionsMarkup,
        onAction: this.togglePopover,
        content: activatorLabel,
        disabled,
        indicator: this.isNewBadgeInBadgeActions()
      }),
      preferredAlignment: "right",
      onClose: this.togglePopover
    }, import_react642.default.createElement(ActionList, {
      sections: combinedActions,
      onActionAnyItem: this.togglePopover
    }))) : null;
    const groupContent = promotedActionsMarkup || actionsPopover ? import_react642.default.createElement(HorizontalStack, {
      gap: "3"
    }, promotedActionsMarkup, actionsPopover) : null;
    if (!groupContent) {
      return null;
    }
    const group = import_react642.default.createElement(Transition_default, {
      timeout: 100,
      in: selectMode,
      key: "group",
      nodeRef: this.groupNode
    }, (status) => {
      const groupClassName = classNames(styles54.Group, !isSticky && styles54["Group-not-sticky"], !measuring && isSticky && styles54[`Group-${status}`], measuring && styles54["Group-measuring"]);
      return import_react642.default.createElement("div", {
        className: groupClassName,
        ref: this.groupNode,
        style: {
          width
        }
      }, import_react642.default.createElement(EventListener, {
        event: "resize",
        handler: this.handleResize
      }), import_react642.default.createElement("div", {
        className: styles54.ButtonGroupWrapper,
        ref: this.setButtonsNode
      }, import_react642.default.createElement("div", {
        className: styles54.ButtonGroupInner
      }, groupContent)));
    });
    return import_react642.default.createElement("div", {
      ref: this.setContainerNode
    }, group);
  }
  isNewBadgeInBadgeActions() {
    const actions = this.actionSections();
    if (!actions)
      return false;
    for (const action of actions) {
      for (const item of action.items) {
        var _item$badge;
        if (((_item$badge = item.badge) === null || _item$badge === void 0 ? void 0 : _item$badge.status) === "new")
          return true;
      }
    }
    return false;
  }
};
function instanceOfBulkActionListSectionArray(actions) {
  const validList = actions.filter((action) => {
    return action.items;
  });
  return actions.length === validList.length;
}
function instanceOfBulkActionArray(actions) {
  const validList = actions.filter((action) => {
    return !action.items;
  });
  return actions.length === validList.length;
}
function instanceOfMenuGroupDescriptor(action) {
  return "title" in action;
}
function BulkActions(props) {
  const i18n = useI18n();
  return import_react642.default.createElement(BulkActionsInner, Object.assign({}, props, {
    i18n
  }));
}

// ../node_modules/@shopify/polaris/build/esm/components/CalloutCard/CalloutCard.js
var import_react650 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/CalloutCard/CalloutCard.scss.js
var styles56 = {
  "CalloutCard": "Polaris-CalloutCard",
  "Image": "Polaris-CalloutCard__Image",
  "DismissImage": "Polaris-CalloutCard__DismissImage",
  "Content": "Polaris-CalloutCard__Content",
  "Title": "Polaris-CalloutCard__Title",
  "Buttons": "Polaris-CalloutCard__Buttons",
  "Container": "Polaris-CalloutCard__Container",
  "Dismiss": "Polaris-CalloutCard__Dismiss",
  "hasDismiss": "Polaris-CalloutCard--hasDismiss"
};

// ../node_modules/@shopify/polaris/build/esm/components/LegacyCard/LegacyCard.js
var import_react648 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/LegacyCard/LegacyCard.scss.js
var styles57 = {
  "LegacyCard": "Polaris-LegacyCard",
  "subdued": "Polaris-LegacyCard--subdued",
  "Section-hideOnPrint": "Polaris-LegacyCard__Section--hideOnPrint",
  "hideOnPrint": "Polaris-LegacyCard--hideOnPrint",
  "Header": "Polaris-LegacyCard__Header",
  "Section": "Polaris-LegacyCard__Section",
  "Section-fullWidth": "Polaris-LegacyCard__Section--fullWidth",
  "Section-flush": "Polaris-LegacyCard__Section--flush",
  "Section-subdued": "Polaris-LegacyCard__Section--subdued",
  "SectionHeader": "Polaris-LegacyCard__SectionHeader",
  "Subsection": "Polaris-LegacyCard__Subsection",
  "Footer": "Polaris-LegacyCard__Footer",
  "LeftJustified": "Polaris-LegacyCard__LeftJustified"
};

// ../node_modules/@shopify/polaris/build/esm/components/LegacyCard/components/Header/Header.js
var import_react645 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/LegacyStack/LegacyStack.js
var import_react644 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/LegacyStack/LegacyStack.scss.js
var styles58 = {
  "LegacyStack": "Polaris-LegacyStack",
  "Item": "Polaris-LegacyStack__Item",
  "noWrap": "Polaris-LegacyStack--noWrap",
  "spacingNone": "Polaris-LegacyStack--spacingNone",
  "spacingExtraTight": "Polaris-LegacyStack--spacingExtraTight",
  "spacingTight": "Polaris-LegacyStack--spacingTight",
  "spacingBaseTight": "Polaris-LegacyStack--spacingBaseTight",
  "spacingLoose": "Polaris-LegacyStack--spacingLoose",
  "spacingExtraLoose": "Polaris-LegacyStack--spacingExtraLoose",
  "distributionLeading": "Polaris-LegacyStack--distributionLeading",
  "distributionTrailing": "Polaris-LegacyStack--distributionTrailing",
  "distributionCenter": "Polaris-LegacyStack--distributionCenter",
  "distributionEqualSpacing": "Polaris-LegacyStack--distributionEqualSpacing",
  "distributionFill": "Polaris-LegacyStack--distributionFill",
  "distributionFillEvenly": "Polaris-LegacyStack--distributionFillEvenly",
  "alignmentLeading": "Polaris-LegacyStack--alignmentLeading",
  "alignmentTrailing": "Polaris-LegacyStack--alignmentTrailing",
  "alignmentCenter": "Polaris-LegacyStack--alignmentCenter",
  "alignmentFill": "Polaris-LegacyStack--alignmentFill",
  "alignmentBaseline": "Polaris-LegacyStack--alignmentBaseline",
  "vertical": "Polaris-LegacyStack--vertical",
  "Item-fill": "Polaris-LegacyStack__Item--fill"
};

// ../node_modules/@shopify/polaris/build/esm/components/LegacyStack/components/Item/Item.js
var import_react643 = __toESM(require_react());
function Item7({
  children: children2,
  fill
}) {
  const className = classNames(styles58.Item, fill && styles58["Item-fill"]);
  return import_react643.default.createElement("div", {
    className
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/LegacyStack/LegacyStack.js
var LegacyStack = (0, import_react644.memo)(function Stack({
  children: children2,
  vertical,
  spacing: spacing2,
  distribution,
  alignment,
  wrap
}) {
  const className = classNames(styles58.LegacyStack, vertical && styles58.vertical, spacing2 && styles58[variationName("spacing", spacing2)], distribution && styles58[variationName("distribution", distribution)], alignment && styles58[variationName("alignment", alignment)], wrap === false && styles58.noWrap);
  const itemMarkup = elementChildren(children2).map((child, index) => {
    const props = {
      key: index
    };
    return wrapWithComponent(child, Item7, props);
  });
  return import_react644.default.createElement("div", {
    className
  }, itemMarkup);
});
LegacyStack.Item = Item7;

// ../node_modules/@shopify/polaris/build/esm/components/LegacyCard/components/Header/Header.js
function Header3({
  children: children2,
  title,
  actions
}) {
  const actionMarkup = actions ? import_react645.default.createElement(ButtonGroup, null, buttonsFrom(actions, {
    plain: true
  })) : null;
  const titleMarkup = (0, import_react645.isValidElement)(title) ? title : import_react645.default.createElement(Text, {
    variant: "headingMd",
    as: "h2"
  }, title);
  const headingMarkup = actionMarkup || children2 ? import_react645.default.createElement(LegacyStack, {
    alignment: "baseline"
  }, import_react645.default.createElement(LegacyStack.Item, {
    fill: true
  }, titleMarkup), actionMarkup, children2) : titleMarkup;
  return import_react645.default.createElement("div", {
    className: styles57.Header
  }, headingMarkup);
}

// ../node_modules/@shopify/polaris/build/esm/components/LegacyCard/components/Section/Section.js
var import_react646 = __toESM(require_react());
function Section5({
  children: children2,
  title,
  subdued,
  flush,
  fullWidth,
  actions,
  hideOnPrint
}) {
  const className = classNames(styles57.Section, flush && styles57["Section-flush"], subdued && styles57["Section-subdued"], fullWidth && styles57["Section-fullWidth"], hideOnPrint && styles57["Section-hideOnPrint"]);
  const actionMarkup = actions ? import_react646.default.createElement(ButtonGroup, null, buttonsFrom(actions, {
    plain: true
  })) : null;
  const titleMarkup = typeof title === "string" ? import_react646.default.createElement(Text, {
    variant: "headingSm",
    as: "h3"
  }, title) : title;
  const titleAreaMarkup = titleMarkup || actionMarkup ? import_react646.default.createElement("div", {
    className: styles57.SectionHeader
  }, actionMarkup ? import_react646.default.createElement(LegacyStack, {
    alignment: "baseline"
  }, import_react646.default.createElement(LegacyStack.Item, {
    fill: true
  }, titleMarkup), actionMarkup) : titleMarkup) : null;
  return import_react646.default.createElement("div", {
    className
  }, titleAreaMarkup, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/LegacyCard/components/Subsection/Subsection.js
var import_react647 = __toESM(require_react());
function Subsection({
  children: children2
}) {
  return import_react647.default.createElement("div", {
    className: styles57.Subsection
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/LegacyCard/LegacyCard.js
var LegacyCard = function LegacyCard2({
  children: children2,
  hideOnPrint,
  title,
  subdued,
  sectioned,
  actions,
  primaryFooterAction,
  secondaryFooterActions,
  secondaryFooterActionsDisclosureText,
  footerActionAlignment = "right"
}) {
  const i18n = useI18n();
  const {
    value: secondaryActionsPopoverOpen,
    toggle: toggleSecondaryActionsPopoverOpen
  } = useToggle(false);
  const className = classNames(styles57.LegacyCard, subdued && styles57.subdued, hideOnPrint && styles57.hideOnPrint);
  const headerMarkup = title || actions ? import_react648.default.createElement(Header3, {
    actions,
    title
  }) : null;
  const content = sectioned ? import_react648.default.createElement(Section5, null, children2) : children2;
  const primaryFooterActionMarkup = primaryFooterAction ? buttonFrom(primaryFooterAction, {
    primary: true
  }) : null;
  let secondaryFooterActionsMarkup = null;
  if (secondaryFooterActions && secondaryFooterActions.length) {
    if (secondaryFooterActions.length === 1) {
      secondaryFooterActionsMarkup = buttonFrom(secondaryFooterActions[0]);
    } else {
      secondaryFooterActionsMarkup = import_react648.default.createElement(import_react648.default.Fragment, null, import_react648.default.createElement(Popover2, {
        active: secondaryActionsPopoverOpen,
        activator: import_react648.default.createElement(Button, {
          disclosure: true,
          onClick: toggleSecondaryActionsPopoverOpen
        }, secondaryFooterActionsDisclosureText || i18n.translate("Polaris.Common.more")),
        onClose: toggleSecondaryActionsPopoverOpen
      }, import_react648.default.createElement(ActionList, {
        items: secondaryFooterActions
      })));
    }
  }
  const footerMarkup = primaryFooterActionMarkup || secondaryFooterActionsMarkup ? import_react648.default.createElement("div", {
    className: classNames(styles57.Footer, footerActionAlignment === "left" && styles57.LeftJustified)
  }, footerActionAlignment === "right" ? import_react648.default.createElement(ButtonGroup, null, secondaryFooterActionsMarkup, primaryFooterActionMarkup) : import_react648.default.createElement(ButtonGroup, null, primaryFooterActionMarkup, secondaryFooterActionsMarkup)) : null;
  return import_react648.default.createElement(WithinContentContext.Provider, {
    value: true
  }, import_react648.default.createElement("div", {
    className
  }, headerMarkup, content, footerMarkup));
};
LegacyCard.Header = Header3;
LegacyCard.Section = Section5;
LegacyCard.Subsection = Subsection;

// ../node_modules/@shopify/polaris/build/esm/components/TextContainer/TextContainer.js
var import_react649 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/TextContainer/TextContainer.scss.js
var styles59 = {
  "TextContainer": "Polaris-TextContainer",
  "spacingTight": "Polaris-TextContainer--spacingTight",
  "spacingLoose": "Polaris-TextContainer--spacingLoose"
};

// ../node_modules/@shopify/polaris/build/esm/components/TextContainer/TextContainer.js
function TextContainer({
  spacing: spacing2,
  children: children2
}) {
  const className = classNames(styles59.TextContainer, spacing2 && styles59[variationName("spacing", spacing2)]);
  return import_react649.default.createElement("div", {
    className
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/CalloutCard/CalloutCard.js
function CalloutCard({
  title,
  children: children2,
  illustration,
  primaryAction,
  secondaryAction,
  onDismiss
}) {
  const primaryActionMarkup = buttonFrom(primaryAction);
  const secondaryActionMarkup = secondaryAction ? buttonFrom(secondaryAction, {
    plain: true
  }) : null;
  const buttonMarkup = secondaryActionMarkup ? import_react650.default.createElement(ButtonGroup, null, primaryActionMarkup, secondaryActionMarkup) : primaryActionMarkup;
  const dismissButton = onDismiss ? import_react650.default.createElement("div", {
    className: styles56.Dismiss
  }, import_react650.default.createElement(Button, {
    plain: true,
    icon: SvgCancelSmallMinor,
    onClick: onDismiss,
    accessibilityLabel: "Dismiss card"
  })) : null;
  const imageClassName = classNames(styles56.Image, onDismiss && styles56.DismissImage);
  const containerClassName = classNames(styles56.Container, onDismiss && styles56.hasDismiss);
  return import_react650.default.createElement(LegacyCard, null, import_react650.default.createElement("div", {
    className: containerClassName
  }, dismissButton, import_react650.default.createElement(LegacyCard.Section, null, import_react650.default.createElement("div", {
    className: styles56.CalloutCard
  }, import_react650.default.createElement("div", {
    className: styles56.Content
  }, import_react650.default.createElement("div", {
    className: styles56.Title
  }, import_react650.default.createElement(Text, {
    variant: "headingMd",
    as: "h2"
  }, title)), import_react650.default.createElement(TextContainer, null, children2), import_react650.default.createElement("div", {
    className: styles56.Buttons
  }, buttonMarkup)), import_react650.default.createElement(Image, {
    alt: "",
    className: imageClassName,
    source: illustration
  })))));
}

// ../node_modules/@shopify/polaris/build/esm/components/Caption/Caption.js
var import_react651 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Caption/Caption.scss.js
var styles60 = {
  "Caption": "Polaris-Caption"
};

// ../node_modules/@shopify/polaris/build/esm/components/Caption/Caption.js
function Caption({
  children: children2
}) {
  return import_react651.default.createElement("p", {
    className: styles60.Caption
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/Card/Card.js
var import_react655 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Card/Card.scss.js
var styles61 = {
  "Card": "Polaris-Card",
  "subdued": "Polaris-Card--subdued",
  "Section-hideOnPrint": "Polaris-Card__Section--hideOnPrint",
  "hideOnPrint": "Polaris-Card--hideOnPrint",
  "Header": "Polaris-Card__Header",
  "Section": "Polaris-Card__Section",
  "Section-fullWidth": "Polaris-Card__Section--fullWidth",
  "Section-flush": "Polaris-Card__Section--flush",
  "Section-subdued": "Polaris-Card__Section--subdued",
  "SectionHeader": "Polaris-Card__SectionHeader",
  "Subsection": "Polaris-Card__Subsection",
  "Footer": "Polaris-Card__Footer",
  "LeftJustified": "Polaris-Card__LeftJustified"
};

// ../node_modules/@shopify/polaris/build/esm/components/Card/components/Header/Header.js
var import_react652 = __toESM(require_react());
function Header4({
  children: children2,
  title,
  actions
}) {
  if (true) {
    console.warn("Deprecation: <Card /> is deprecated. This component will be removed in a future major version of Polaris. Use <LegacyCard /> or <AlphaCard /> instead.");
  }
  const actionMarkup = actions ? import_react652.default.createElement(ButtonGroup, null, buttonsFrom(actions, {
    plain: true
  })) : null;
  const titleMarkup = (0, import_react652.isValidElement)(title) ? title : import_react652.default.createElement(Text, {
    variant: "headingMd",
    as: "h2"
  }, title);
  const headingMarkup = actionMarkup || children2 ? import_react652.default.createElement(LegacyStack, {
    alignment: "baseline"
  }, import_react652.default.createElement(LegacyStack.Item, {
    fill: true
  }, titleMarkup), actionMarkup, children2) : titleMarkup;
  return import_react652.default.createElement("div", {
    className: styles61.Header
  }, headingMarkup);
}

// ../node_modules/@shopify/polaris/build/esm/components/Card/components/Section/Section.js
var import_react653 = __toESM(require_react());
function Section6({
  children: children2,
  title,
  subdued,
  flush,
  fullWidth,
  actions,
  hideOnPrint
}) {
  if (true) {
    console.warn("Deprecation: <Card /> is deprecated. This component will be removed in a future major version of Polaris. Use <LegacyCard /> or <AlphaCard /> instead.");
  }
  const className = classNames(styles61.Section, flush && styles61["Section-flush"], subdued && styles61["Section-subdued"], fullWidth && styles61["Section-fullWidth"], hideOnPrint && styles61["Section-hideOnPrint"]);
  const actionMarkup = actions ? import_react653.default.createElement(ButtonGroup, null, buttonsFrom(actions, {
    plain: true
  })) : null;
  const titleMarkup = typeof title === "string" ? import_react653.default.createElement(Text, {
    variant: "headingSm",
    as: "h3"
  }, title) : title;
  const titleAreaMarkup = titleMarkup || actionMarkup ? import_react653.default.createElement("div", {
    className: styles61.SectionHeader
  }, actionMarkup ? import_react653.default.createElement(LegacyStack, {
    alignment: "baseline"
  }, import_react653.default.createElement(LegacyStack.Item, {
    fill: true
  }, titleMarkup), actionMarkup) : titleMarkup) : null;
  return import_react653.default.createElement("div", {
    className
  }, titleAreaMarkup, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/Card/components/Subsection/Subsection.js
var import_react654 = __toESM(require_react());
function Subsection2({
  children: children2
}) {
  if (true) {
    console.warn("Deprecation: <Card /> is deprecated. This component will be removed in a future major version of Polaris. Use <LegacyCard /> or <AlphaCard /> instead.");
  }
  return import_react654.default.createElement("div", {
    className: styles61.Subsection
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/Card/Card.js
var Card = function Card2({
  children: children2,
  hideOnPrint,
  title,
  subdued,
  sectioned,
  actions,
  primaryFooterAction,
  secondaryFooterActions,
  secondaryFooterActionsDisclosureText,
  footerActionAlignment = "right"
}) {
  if (true) {
    console.warn("Deprecation: <Card /> is deprecated. This component will be removed in a future major version of Polaris. Use <LegacyCard /> or <AlphaCard /> instead.");
  }
  const i18n = useI18n();
  const {
    value: secondaryActionsPopoverOpen,
    toggle: toggleSecondaryActionsPopoverOpen
  } = useToggle(false);
  const className = classNames(styles61.Card, subdued && styles61.subdued, hideOnPrint && styles61.hideOnPrint);
  const headerMarkup = title || actions ? import_react655.default.createElement(Header4, {
    actions,
    title
  }) : null;
  const content = sectioned ? import_react655.default.createElement(Section6, null, children2) : children2;
  const primaryFooterActionMarkup = primaryFooterAction ? buttonFrom(primaryFooterAction, {
    primary: true
  }) : null;
  let secondaryFooterActionsMarkup = null;
  if (secondaryFooterActions && secondaryFooterActions.length) {
    if (secondaryFooterActions.length === 1) {
      secondaryFooterActionsMarkup = buttonFrom(secondaryFooterActions[0]);
    } else {
      secondaryFooterActionsMarkup = import_react655.default.createElement(import_react655.default.Fragment, null, import_react655.default.createElement(Popover2, {
        active: secondaryActionsPopoverOpen,
        activator: import_react655.default.createElement(Button, {
          disclosure: true,
          onClick: toggleSecondaryActionsPopoverOpen
        }, secondaryFooterActionsDisclosureText || i18n.translate("Polaris.Common.more")),
        onClose: toggleSecondaryActionsPopoverOpen
      }, import_react655.default.createElement(ActionList, {
        items: secondaryFooterActions
      })));
    }
  }
  const footerMarkup = primaryFooterActionMarkup || secondaryFooterActionsMarkup ? import_react655.default.createElement("div", {
    className: classNames(styles61.Footer, footerActionAlignment === "left" && styles61.LeftJustified)
  }, footerActionAlignment === "right" ? import_react655.default.createElement(ButtonGroup, null, secondaryFooterActionsMarkup, primaryFooterActionMarkup) : import_react655.default.createElement(ButtonGroup, null, primaryFooterActionMarkup, secondaryFooterActionsMarkup)) : null;
  return import_react655.default.createElement(WithinContentContext.Provider, {
    value: true
  }, import_react655.default.createElement("div", {
    className
  }, headerMarkup, content, footerMarkup));
};
Card.Header = Header4;
Card.Section = Section6;
Card.Subsection = Subsection2;

// ../node_modules/@shopify/polaris/build/esm/components/ChoiceList/ChoiceList.js
var import_react657 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/ChoiceList/ChoiceList.scss.js
var styles62 = {
  "ChoiceChildren": "Polaris-ChoiceList__ChoiceChildren"
};

// ../node_modules/@shopify/polaris/build/esm/components/RadioButton/RadioButton.js
var import_react656 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/RadioButton/RadioButton.scss.js
var styles63 = {
  "RadioButton": "Polaris-RadioButton",
  "Input": "Polaris-RadioButton__Input",
  "Backdrop": "Polaris-RadioButton__Backdrop",
  "hover": "Polaris-RadioButton--hover"
};

// ../node_modules/@shopify/polaris/build/esm/components/RadioButton/RadioButton.js
function RadioButton({
  ariaDescribedBy: ariaDescribedByProp,
  label,
  labelHidden,
  helpText,
  checked,
  disabled,
  onChange,
  onFocus,
  onBlur,
  id: idProp,
  name: nameProp,
  value
}) {
  const id = useUniqueId("RadioButton", idProp);
  const name = nameProp || id;
  const inputNode = (0, import_react656.useRef)(null);
  const {
    value: mouseOver,
    setTrue: handleMouseOver,
    setFalse: handleMouseOut
  } = useToggle(false);
  const handleBlur = () => {
    onBlur && onBlur();
  };
  function handleChange({
    currentTarget
  }) {
    onChange && onChange(currentTarget.checked, id);
  }
  const describedBy = [];
  if (helpText) {
    describedBy.push(helpTextID2(id));
  }
  if (ariaDescribedByProp) {
    describedBy.push(ariaDescribedByProp);
  }
  const ariaDescribedBy = describedBy.length ? describedBy.join(" ") : void 0;
  const inputClassName = classNames(styles63.Input);
  const backdropClassName = classNames(styles63.Backdrop, mouseOver && styles63.hover);
  return import_react656.default.createElement(Choice, {
    label,
    labelHidden,
    disabled,
    id,
    helpText,
    onMouseOver: handleMouseOver,
    onMouseOut: handleMouseOut
  }, import_react656.default.createElement("span", {
    className: styles63.RadioButton
  }, import_react656.default.createElement("input", {
    id,
    name,
    value,
    type: "radio",
    checked,
    disabled,
    className: inputClassName,
    onChange: handleChange,
    onFocus,
    onBlur: handleBlur,
    "aria-describedby": ariaDescribedBy,
    ref: inputNode
  }), import_react656.default.createElement("span", {
    className: backdropClassName
  })));
}

// ../node_modules/@shopify/polaris/build/esm/components/ChoiceList/ChoiceList.js
function ChoiceList({
  title,
  titleHidden,
  allowMultiple,
  choices,
  selected,
  onChange = noop9,
  error,
  disabled = false,
  name: nameProp
}) {
  const ControlComponent = allowMultiple ? Checkbox : RadioButton;
  const name = useUniqueId("ChoiceList", nameProp);
  const finalName = allowMultiple ? `${name}[]` : name;
  const titleMarkup = title ? import_react657.default.createElement(Box, {
    as: "legend",
    paddingBlockEnd: {
      xs: "5",
      md: "1"
    },
    visuallyHidden: titleHidden
  }, title) : null;
  const choicesMarkup = choices.map((choice) => {
    const {
      value,
      id,
      label,
      helpText,
      disabled: choiceDisabled,
      describedByError
    } = choice;
    function handleChange(checked) {
      onChange(updateSelectedChoices(choice, checked, selected, allowMultiple), name);
    }
    const isSelected2 = choiceIsSelected(choice, selected);
    const renderedChildren = choice.renderChildren ? choice.renderChildren(isSelected2) : null;
    const children2 = renderedChildren ? import_react657.default.createElement("div", {
      className: styles62.ChoiceChildren
    }, import_react657.default.createElement(Box, {
      paddingBlockStart: {
        xs: "4",
        md: "0"
      }
    }, renderedChildren)) : null;
    return import_react657.default.createElement("li", {
      key: value
    }, import_react657.default.createElement(Bleed, {
      marginBlockEnd: helpText ? {
        xs: "1",
        md: "0"
      } : {
        xs: "0"
      }
    }, import_react657.default.createElement(ControlComponent, {
      name: finalName,
      value,
      id,
      label,
      disabled: choiceDisabled || disabled,
      checked: choiceIsSelected(choice, selected),
      helpText,
      onChange: handleChange,
      ariaDescribedBy: error && describedByError ? errorTextID(finalName) : null
    }), children2));
  });
  const errorMarkup = error && import_react657.default.createElement(Box, {
    paddingBlockStart: {
      xs: "0",
      md: "1"
    },
    paddingBlockEnd: "2"
  }, import_react657.default.createElement(InlineError, {
    message: error,
    fieldID: finalName
  }));
  return import_react657.default.createElement(VerticalStack, {
    as: "fieldset",
    gap: {
      xs: "4",
      md: "0"
    },
    "aria-invalid": error != null,
    id: finalName
  }, titleMarkup, import_react657.default.createElement(VerticalStack, {
    as: "ul",
    gap: {
      xs: "4",
      md: "0"
    }
  }, choicesMarkup), errorMarkup);
}
function noop9() {
}
function choiceIsSelected({
  value
}, selected) {
  return selected.includes(value);
}
function updateSelectedChoices({
  value
}, checked, selected, allowMultiple = false) {
  if (checked) {
    return allowMultiple ? [...selected, value] : [value];
  }
  return selected.filter((selectedChoice) => selectedChoice !== value);
}

// ../node_modules/@shopify/polaris/build/esm/components/Collapsible/Collapsible.js
var import_react658 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Collapsible/Collapsible.scss.js
var styles64 = {
  "Collapsible": "Polaris-Collapsible",
  "isFullyClosed": "Polaris-Collapsible--isFullyClosed",
  "expandOnPrint": "Polaris-Collapsible--expandOnPrint"
};

// ../node_modules/@shopify/polaris/build/esm/components/Collapsible/Collapsible.js
function Collapsible({
  id,
  expandOnPrint,
  open,
  transition = true,
  preventMeasuringOnChildrenUpdate: _preventMeasuringOnChildrenUpdate,
  children: children2,
  onAnimationEnd
}) {
  const [height, setHeight] = (0, import_react658.useState)(0);
  const [isOpen, setIsOpen] = (0, import_react658.useState)(open);
  const [animationState, setAnimationState] = (0, import_react658.useState)("idle");
  const collapsibleContainer = (0, import_react658.useRef)(null);
  const isFullyOpen = animationState === "idle" && open && isOpen;
  const isFullyClosed = animationState === "idle" && !open && !isOpen;
  const content = expandOnPrint || !isFullyClosed ? children2 : null;
  const wrapperClassName = classNames(styles64.Collapsible, isFullyClosed && styles64.isFullyClosed, expandOnPrint && styles64.expandOnPrint);
  const transitionDisabled = isTransitionDisabled(transition);
  const transitionStyles3 = typeof transition === "object" && {
    transitionDuration: transition.duration,
    transitionTimingFunction: transition.timingFunction
  };
  const collapsibleStyles = {
    ...transitionStyles3,
    ...{
      maxHeight: isFullyOpen ? "none" : `${height}px`,
      overflow: isFullyOpen ? "visible" : "hidden"
    }
  };
  const handleCompleteAnimation = (0, import_react658.useCallback)(({
    target
  }) => {
    if (target === collapsibleContainer.current) {
      setAnimationState("idle");
      setIsOpen(open);
      onAnimationEnd && onAnimationEnd();
    }
  }, [onAnimationEnd, open]);
  const startAnimation = (0, import_react658.useCallback)(() => {
    if (transitionDisabled) {
      setIsOpen(open);
      setAnimationState("idle");
      if (open && collapsibleContainer.current) {
        setHeight(collapsibleContainer.current.scrollHeight);
      } else {
        setHeight(0);
      }
    } else {
      setAnimationState("measuring");
    }
  }, [open, transitionDisabled]);
  (0, import_react658.useEffect)(() => {
    if (open !== isOpen) {
      startAnimation();
    }
  }, [open, isOpen]);
  (0, import_react658.useEffect)(() => {
    if (!open || !collapsibleContainer.current)
      return;
    setHeight(collapsibleContainer.current.scrollHeight);
  }, []);
  (0, import_react658.useEffect)(() => {
    if (!collapsibleContainer.current)
      return;
    switch (animationState) {
      case "idle":
        break;
      case "measuring":
        setHeight(collapsibleContainer.current.scrollHeight);
        setAnimationState("animating");
        break;
      case "animating":
        setHeight(open ? collapsibleContainer.current.scrollHeight : 0);
    }
  }, [animationState, open, isOpen]);
  return import_react658.default.createElement("div", {
    id,
    style: collapsibleStyles,
    ref: collapsibleContainer,
    className: wrapperClassName,
    onTransitionEnd: handleCompleteAnimation,
    "aria-hidden": !open
  }, content);
}
var zeroDurationRegex = /^0(ms|s)$/;
function isTransitionDisabled(transitionProp) {
  if (typeof transitionProp === "boolean") {
    return !transitionProp;
  }
  const {
    duration
  } = transitionProp;
  if (duration && zeroDurationRegex.test(duration.trim())) {
    return true;
  }
  return false;
}

// ../node_modules/@shopify/polaris/build/esm/components/ColorPicker/ColorPicker.js
var import_react662 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/ColorPicker/ColorPicker.scss.js
var styles65 = {
  "ColorPicker": "Polaris-ColorPicker",
  "MainColor": "Polaris-ColorPicker__MainColor",
  "fullWidth": "Polaris-ColorPicker--fullWidth",
  "Dragger": "Polaris-ColorPicker__Dragger",
  "ColorLayer": "Polaris-ColorPicker__ColorLayer",
  "HuePicker": "Polaris-ColorPicker__HuePicker",
  "AlphaPicker": "Polaris-ColorPicker__AlphaPicker",
  "Slidable": "Polaris-ColorPicker__Slidable"
};

// ../node_modules/@shopify/polaris/build/esm/components/ColorPicker/components/AlphaPicker/AlphaPicker.js
var import_react660 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/ColorPicker/components/AlphaPicker/utilities.js
var VERTICAL_PADDING = 13;
function calculateDraggerY(alpha, sliderHeight, draggerHeight) {
  const offset = offsetForAlpha(alpha, sliderHeight, draggerHeight);
  return clamp(offset, 0, sliderHeight);
}
function alphaForDraggerY(y, sliderHeight) {
  const offsetY = clamp(y, 0, sliderHeight);
  return alphaForOffset(offsetY, sliderHeight);
}
function alphaForOffset(offset, sliderHeight) {
  const selectionHeight = offset - VERTICAL_PADDING;
  const slidableArea = sliderHeight - VERTICAL_PADDING * 2;
  return clamp(1 - selectionHeight / slidableArea, 0, 1);
}
function offsetForAlpha(alpha, sliderHeight, draggerHeight) {
  const slidableArea = sliderHeight - (draggerHeight + VERTICAL_PADDING);
  return clamp((1 - alpha) * slidableArea + VERTICAL_PADDING, 0, sliderHeight - draggerHeight);
}

// ../node_modules/@shopify/polaris/build/esm/components/ColorPicker/components/Slidable/Slidable.js
var import_react659 = __toESM(require_react());
var isDragging = false;
if (!isServer) {
  window.addEventListener("touchmove", (event) => {
    if (!isDragging) {
      return;
    }
    event.preventDefault();
  }, {
    passive: false
  });
}
var Slidable = class extends import_react659.PureComponent {
  constructor(...args) {
    super(...args);
    this.state = {
      dragging: false
    };
    this.node = null;
    this.draggerNode = null;
    this.setDraggerNode = (node) => {
      this.draggerNode = node;
    };
    this.setNode = (node) => {
      this.node = node;
    };
    this.startDrag = (event) => {
      if (isMouseDownEvent(event)) {
        this.handleDraggerMove(event.clientX, event.clientY);
      }
      isDragging = true;
      this.setState({
        dragging: true
      });
    };
    this.handleDragEnd = () => {
      isDragging = false;
      this.setState({
        dragging: false
      });
    };
    this.handleMove = (event) => {
      event.stopImmediatePropagation();
      event.stopPropagation();
      if (event.cancelable) {
        event.preventDefault();
      }
      if (isMouseMoveEvent(event)) {
        this.handleDraggerMove(event.clientX, event.clientY);
        return;
      }
      this.handleDraggerMove(event.touches[0].clientX, event.touches[0].clientY);
    };
    this.handleDraggerMove = (x, y) => {
      if (this.node == null) {
        return;
      }
      const {
        onChange
      } = this.props;
      const rect = this.node.getBoundingClientRect();
      const offsetX = x - rect.left;
      const offsetY = y - rect.top;
      onChange({
        x: offsetX,
        y: offsetY
      });
    };
  }
  componentDidMount() {
    const {
      onDraggerHeight
    } = this.props;
    if (onDraggerHeight == null) {
      return;
    }
    const {
      draggerNode
    } = this;
    if (draggerNode == null) {
      return;
    }
    onDraggerHeight(draggerNode.clientWidth);
    if (true) {
      setTimeout(() => {
        onDraggerHeight(draggerNode.clientWidth);
      }, 0);
    }
  }
  render() {
    const {
      dragging
    } = this.state;
    const {
      draggerX = 0,
      draggerY = 0
    } = this.props;
    const draggerPositioning = {
      transform: `translate3d(${draggerX}px, ${draggerY}px, 0)`
    };
    const moveListener = dragging ? import_react659.default.createElement(EventListener, {
      event: "mousemove",
      handler: this.handleMove,
      passive: false
    }) : null;
    const touchMoveListener = dragging ? import_react659.default.createElement(EventListener, {
      event: "touchmove",
      handler: this.handleMove,
      passive: false
    }) : null;
    const endDragListener = dragging ? import_react659.default.createElement(EventListener, {
      event: "mouseup",
      handler: this.handleDragEnd
    }) : null;
    const touchEndListener = dragging ? import_react659.default.createElement(EventListener, {
      event: "touchend",
      handler: this.handleDragEnd
    }) : null;
    const touchCancelListener = dragging ? import_react659.default.createElement(EventListener, {
      event: "touchcancel",
      handler: this.handleDragEnd
    }) : null;
    return import_react659.default.createElement("div", {
      ref: this.setNode,
      className: styles65.Slidable,
      onMouseDown: this.startDrag,
      onTouchStart: this.startDrag
    }, endDragListener, moveListener, touchMoveListener, touchEndListener, touchCancelListener, import_react659.default.createElement("div", {
      style: draggerPositioning,
      className: styles65.Dragger,
      ref: this.setDraggerNode
    }));
  }
};
function isMouseMoveEvent(event) {
  return event.type === "mousemove";
}
function isMouseDownEvent(event) {
  return event.type === "mousedown";
}

// ../node_modules/@shopify/polaris/build/esm/components/ColorPicker/components/AlphaPicker/AlphaPicker.js
var AlphaPicker = class extends import_react660.PureComponent {
  constructor(...args) {
    super(...args);
    this.state = {
      sliderHeight: 0,
      draggerHeight: 0
    };
    this.setSliderHeight = (node) => {
      if (node == null) {
        return;
      }
      this.setState({
        sliderHeight: node.clientHeight
      });
      if (true) {
        setTimeout(() => {
          this.setState({
            sliderHeight: node.clientHeight
          });
        }, 0);
      }
    };
    this.setDraggerHeight = (height) => {
      this.setState({
        draggerHeight: height
      });
    };
    this.handleChange = ({
      y
    }) => {
      const {
        onChange
      } = this.props;
      const {
        sliderHeight
      } = this.state;
      const alpha = alphaForDraggerY(y, sliderHeight);
      onChange(alpha);
    };
  }
  render() {
    const {
      color: color2,
      alpha
    } = this.props;
    const {
      sliderHeight,
      draggerHeight
    } = this.state;
    const draggerY = calculateDraggerY(alpha, sliderHeight, draggerHeight);
    const background = alphaGradientForColor(color2);
    return import_react660.default.createElement("div", {
      className: styles65.AlphaPicker,
      ref: this.setSliderHeight
    }, import_react660.default.createElement("div", {
      className: styles65.ColorLayer,
      style: {
        background
      }
    }), import_react660.default.createElement(Slidable, {
      draggerY,
      draggerX: 0,
      onChange: this.handleChange,
      onDraggerHeight: this.setDraggerHeight
    }));
  }
};
function alphaGradientForColor(color2) {
  const {
    red: red2,
    green: green2,
    blue: blue2
  } = hsbToRgb(color2);
  const rgb = `${red2}, ${green2}, ${blue2}`;
  return `linear-gradient(to top, rgba(${rgb}, 0) 18px, rgba(${rgb}, 1) calc(100% - 18px))`;
}

// ../node_modules/@shopify/polaris/build/esm/components/ColorPicker/components/HuePicker/HuePicker.js
var import_react661 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/ColorPicker/components/HuePicker/utilities.js
var VERTICAL_PADDING2 = 13;
function calculateDraggerY2(hue, sliderHeight, draggerHeight) {
  const offset = offsetForHue(hue, sliderHeight, draggerHeight);
  return clamp(offset, 0, sliderHeight);
}
function hueForDraggerY(y, sliderHeight) {
  const offsetY = clamp(y, 0, sliderHeight);
  return hueForOffset(offsetY, sliderHeight);
}
function hueForOffset(offset, sliderHeight) {
  const selectionHeight = offset - VERTICAL_PADDING2;
  const slidableArea = sliderHeight - VERTICAL_PADDING2 * 2;
  return clamp(selectionHeight / slidableArea * 360, 0, 360);
}
function offsetForHue(hue, sliderHeight, draggerHeight) {
  const slidableArea = sliderHeight - (draggerHeight + VERTICAL_PADDING2);
  return clamp(hue / 360 * slidableArea + VERTICAL_PADDING2, 0, sliderHeight - draggerHeight);
}

// ../node_modules/@shopify/polaris/build/esm/components/ColorPicker/components/HuePicker/HuePicker.js
var HuePicker = class extends import_react661.PureComponent {
  constructor(...args) {
    super(...args);
    this.state = {
      sliderHeight: 0,
      draggerHeight: 0
    };
    this.setSliderHeight = (node) => {
      if (node == null) {
        return;
      }
      this.setState({
        sliderHeight: node.clientHeight
      });
      if (true) {
        setTimeout(() => {
          this.setState({
            sliderHeight: node.clientHeight
          });
        }, 0);
      }
    };
    this.setDraggerHeight = (height) => {
      this.setState({
        draggerHeight: height
      });
    };
    this.handleChange = ({
      y
    }) => {
      const {
        onChange
      } = this.props;
      const {
        sliderHeight
      } = this.state;
      const hue = hueForDraggerY(y, sliderHeight);
      onChange(hue);
    };
  }
  render() {
    const {
      hue
    } = this.props;
    const {
      sliderHeight,
      draggerHeight
    } = this.state;
    const draggerY = calculateDraggerY2(hue, sliderHeight, draggerHeight);
    return import_react661.default.createElement("div", {
      className: styles65.HuePicker,
      ref: this.setSliderHeight
    }, import_react661.default.createElement(Slidable, {
      draggerY,
      draggerX: 0,
      onChange: this.handleChange,
      onDraggerHeight: this.setDraggerHeight
    }));
  }
};

// ../node_modules/@shopify/polaris/build/esm/components/ColorPicker/ColorPicker.js
var RESIZE_DEBOUNCE_TIME_MS = 200;
var ColorPicker = class extends import_react662.PureComponent {
  constructor(...args) {
    super(...args);
    this.state = {
      pickerSize: {
        width: 0,
        height: 0
      }
    };
    this.colorNode = null;
    this.handleResize = debounce(() => {
      const {
        colorNode
      } = this;
      if (colorNode == null) {
        return;
      }
      this.setState({
        pickerSize: {
          width: colorNode.clientWidth,
          height: colorNode.clientHeight
        }
      });
    }, RESIZE_DEBOUNCE_TIME_MS, {
      leading: true,
      trailing: true,
      maxWait: RESIZE_DEBOUNCE_TIME_MS
    });
    this.setColorNode = (node) => {
      this.colorNode = node;
    };
    this.handleHueChange = (hue) => {
      const {
        color: {
          brightness,
          saturation,
          alpha = 1
        },
        onChange
      } = this.props;
      onChange({
        hue,
        brightness,
        saturation,
        alpha
      });
    };
    this.handleAlphaChange = (alpha) => {
      const {
        color: {
          hue,
          brightness,
          saturation
        },
        onChange
      } = this.props;
      onChange({
        hue,
        brightness,
        saturation,
        alpha
      });
    };
    this.handleDraggerMove = ({
      x,
      y
    }) => {
      const {
        pickerSize
      } = this.state;
      const {
        color: {
          hue,
          alpha = 1
        },
        onChange
      } = this.props;
      const saturation = clamp(x / pickerSize.width, 0, 1);
      const brightness = clamp(1 - y / pickerSize.height, 0, 1);
      onChange({
        hue,
        saturation,
        brightness,
        alpha
      });
    };
    this.handlePickerDrag = (event) => {
      event.preventDefault();
    };
  }
  componentDidMount() {
    const {
      colorNode
    } = this;
    if (colorNode == null) {
      return;
    }
    this.setState({
      pickerSize: {
        width: colorNode.clientWidth,
        height: colorNode.clientHeight
      }
    });
    if (true) {
      setTimeout(() => {
        this.setState({
          pickerSize: {
            width: colorNode.clientWidth,
            height: colorNode.clientHeight
          }
        });
      }, 0);
    }
  }
  render() {
    const {
      id,
      color: color2,
      allowAlpha,
      fullWidth
    } = this.props;
    const {
      hue,
      saturation,
      brightness,
      alpha: providedAlpha
    } = color2;
    const {
      pickerSize
    } = this.state;
    const alpha = providedAlpha != null && allowAlpha ? providedAlpha : 1;
    const {
      red: red2,
      green: green2,
      blue: blue2
    } = hsbToRgb({
      hue,
      saturation: 1,
      brightness: 1
    });
    const colorString = `rgba(${red2}, ${green2}, ${blue2}, ${alpha})`;
    const draggerX = clamp(saturation * pickerSize.width, 0, pickerSize.width);
    const draggerY = clamp(pickerSize.height - brightness * pickerSize.height, 0, pickerSize.height);
    const alphaSliderMarkup = allowAlpha ? import_react662.default.createElement(AlphaPicker, {
      alpha,
      color: color2,
      onChange: this.handleAlphaChange
    }) : null;
    const className = classNames(styles65.ColorPicker, fullWidth && styles65.fullWidth);
    return import_react662.default.createElement("div", {
      className,
      id,
      onMouseDown: this.handlePickerDrag
    }, import_react662.default.createElement("div", {
      ref: this.setColorNode,
      className: styles65.MainColor
    }, import_react662.default.createElement("div", {
      className: styles65.ColorLayer,
      style: {
        backgroundColor: colorString
      }
    }), import_react662.default.createElement(Slidable, {
      onChange: this.handleDraggerMove,
      draggerX,
      draggerY
    })), import_react662.default.createElement(HuePicker, {
      hue,
      onChange: this.handleHueChange
    }), alphaSliderMarkup, import_react662.default.createElement(EventListener, {
      event: "resize",
      handler: this.handleResize
    }));
  }
};

// ../node_modules/@shopify/polaris/build/esm/components/ContextualSaveBar/ContextualSaveBar.js
var import_react665 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/frame/hooks.js
var import_react664 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/frame/context.js
var import_react663 = __toESM(require_react());
var FrameContext = (0, import_react663.createContext)(void 0);

// ../node_modules/@shopify/polaris/build/esm/utilities/frame/hooks.js
function useFrame() {
  const frame = (0, import_react664.useContext)(FrameContext);
  if (!frame) {
    throw new Error("No Frame context was provided. Your component must be wrapped in a <Frame> component. See https://polaris.shopify.com/components/frame for implementation instructions.");
  }
  return frame;
}

// ../node_modules/@shopify/polaris/build/esm/components/ContextualSaveBar/ContextualSaveBar.js
var ContextualSaveBar = (0, import_react665.memo)(function ContextualSaveBar2({
  message,
  saveAction,
  discardAction,
  alignContentFlush,
  fullWidth,
  contextControl,
  secondaryMenu
}) {
  const {
    setContextualSaveBar,
    removeContextualSaveBar
  } = useFrame();
  (0, import_react665.useEffect)(() => {
    setContextualSaveBar({
      message,
      saveAction,
      discardAction,
      alignContentFlush,
      fullWidth,
      contextControl,
      secondaryMenu
    });
  }, [message, saveAction, discardAction, alignContentFlush, setContextualSaveBar, fullWidth, contextControl, secondaryMenu]);
  (0, import_react665.useEffect)(() => {
    return removeContextualSaveBar;
  }, [removeContextualSaveBar]);
  return null;
});

// ../node_modules/@shopify/polaris/build/esm/components/DataTable/DataTable.js
var import_react671 = __toESM(require_react());
var import_react_fast_compare = __toESM(require_react_fast_compare());

// ../node_modules/@shopify/polaris/build/esm/components/DataTable/utilities.js
function measureColumn(tableData) {
  return function(column, index) {
    const {
      firstVisibleColumnIndex,
      tableLeftVisibleEdge: tableStart,
      tableRightVisibleEdge: tableEnd
    } = tableData;
    const leftEdge = column.offsetLeft;
    const rightEdge = leftEdge + column.offsetWidth;
    const isVisibleLeft = isEdgeVisible(leftEdge, tableStart, tableEnd, "left");
    const isVisibleRight = isEdgeVisible(rightEdge, tableStart, tableEnd, "right");
    const isVisible = isVisibleLeft || isVisibleRight;
    const width = column.offsetWidth;
    if (isVisible) {
      tableData.firstVisibleColumnIndex = Math.min(firstVisibleColumnIndex, index);
    }
    return {
      leftEdge,
      rightEdge,
      isVisible,
      width,
      index
    };
  };
}
function isEdgeVisible(position, start, end, edgeType) {
  const minVisiblePixels = 30;
  return position >= start + (edgeType === "left" ? 0 : minVisiblePixels) && position <= end - minVisiblePixels;
}
function getPrevAndCurrentColumns(tableData, columnData) {
  const {
    firstVisibleColumnIndex
  } = tableData;
  const previousColumnIndex = Math.max(firstVisibleColumnIndex - 1, 0);
  const previousColumn = columnData[previousColumnIndex];
  const currentColumn = columnData[firstVisibleColumnIndex];
  return {
    previousColumn,
    currentColumn
  };
}

// ../node_modules/@shopify/polaris/build/esm/components/DataTable/DataTable.scss.js
var styles66 = {
  "DataTable": "Polaris-DataTable",
  "condensed": "Polaris-DataTable--condensed",
  "Navigation": "Polaris-DataTable__Navigation",
  "IncreasedTableDensity": "Polaris-DataTable__IncreasedTableDensity",
  "Pip": "Polaris-DataTable__Pip",
  "Pip-visible": "Polaris-DataTable__Pip--visible",
  "ScrollContainer": "Polaris-DataTable__ScrollContainer",
  "Table": "Polaris-DataTable__Table",
  "TableRow": "Polaris-DataTable__TableRow",
  "Cell": "Polaris-DataTable__Cell",
  "ZebraStripingOnData": "Polaris-DataTable__ZebraStripingOnData",
  "RowCountIsEven": "Polaris-DataTable__RowCountIsEven",
  "ShowTotalsInFooter": "Polaris-DataTable__ShowTotalsInFooter",
  "Cell-separate": "Polaris-DataTable__Cell--separate",
  "Cell-firstColumn": "Polaris-DataTable__Cell--firstColumn",
  "Cell-numeric": "Polaris-DataTable__Cell--numeric",
  "Cell-truncated": "Polaris-DataTable__Cell--truncated",
  "Cell-header": "Polaris-DataTable__Cell--header",
  "Cell-sortable": "Polaris-DataTable__Cell--sortable",
  "Heading-left": "Polaris-DataTable__Heading--left",
  "Cell-verticalAlignTop": "Polaris-DataTable__Cell--verticalAlignTop",
  "Cell-verticalAlignBottom": "Polaris-DataTable__Cell--verticalAlignBottom",
  "Cell-verticalAlignMiddle": "Polaris-DataTable__Cell--verticalAlignMiddle",
  "Cell-verticalAlignBaseline": "Polaris-DataTable__Cell--verticalAlignBaseline",
  "hoverable": "Polaris-DataTable--hoverable",
  "Cell-hovered": "Polaris-DataTable__Cell--hovered",
  "Icon": "Polaris-DataTable__Icon",
  "Heading": "Polaris-DataTable__Heading",
  "StickyHeaderEnabled": "Polaris-DataTable__StickyHeaderEnabled",
  "StickyHeaderWrapper": "Polaris-DataTable__StickyHeaderWrapper",
  "Cell-sorted": "Polaris-DataTable__Cell--sorted",
  "Cell-total": "Polaris-DataTable__Cell--total",
  "ShowTotals": "Polaris-DataTable__ShowTotals",
  "Cell-total-footer": "Polaris-DataTable--cellTotalFooter",
  "Footer": "Polaris-DataTable__Footer",
  "StickyHeaderInner": "Polaris-DataTable__StickyHeaderInner",
  "StickyHeaderInner-isSticky": "Polaris-DataTable__StickyHeaderInner--isSticky",
  "StickyHeaderTable": "Polaris-DataTable__StickyHeaderTable",
  "FixedFirstColumn": "Polaris-DataTable__FixedFirstColumn",
  "StickyTableHeadingsRow": "Polaris-DataTable__StickyTableHeadingsRow",
  "TooltipContent": "Polaris-DataTable__TooltipContent"
};

// ../node_modules/@shopify/polaris/build/esm/components/DataTable/components/Cell/Cell.js
var import_react666 = __toESM(require_react());
function Cell({
  content,
  contentType,
  nthColumn,
  firstColumn,
  truncate,
  header,
  total,
  totalInFooter,
  sorted,
  sortable,
  sortDirection,
  inFixedNthColumn,
  verticalAlign = "top",
  defaultSortDirection = "ascending",
  onSort,
  colSpan,
  setRef = () => {
  },
  stickyHeadingCell = false,
  stickyCellWidth,
  hovered = false,
  handleFocus = () => {
  },
  hasFixedNthColumn = false,
  fixedCellVisible = false,
  firstColumnMinWidth,
  style,
  lastFixedFirstColumn
}) {
  const i18n = useI18n();
  const numeric = contentType === "numeric";
  const className = classNames(styles66.Cell, styles66[`Cell-${variationName("verticalAlign", verticalAlign)}`], firstColumn && styles66["Cell-firstColumn"], truncate && styles66["Cell-truncated"], header && styles66["Cell-header"], total && styles66["Cell-total"], totalInFooter && styles66["Cell-total-footer"], numeric && styles66["Cell-numeric"], sortable && styles66["Cell-sortable"], sorted && styles66["Cell-sorted"], stickyHeadingCell && styles66.StickyHeaderCell, hovered && styles66["Cell-hovered"], lastFixedFirstColumn && inFixedNthColumn && fixedCellVisible && styles66["Cell-separate"], nthColumn && inFixedNthColumn && stickyHeadingCell && styles66.FixedFirstColumn);
  const headerClassName = classNames(header && styles66.Heading, header && contentType === "text" && styles66["Heading-left"]);
  const iconClassName = classNames(sortable && styles66.Icon);
  const direction = sorted && sortDirection ? sortDirection : defaultSortDirection;
  const source = direction === "descending" ? SvgSortDescendingMajor : SvgSortAscendingMajor;
  const oppositeDirection = sortDirection === "ascending" ? "descending" : "ascending";
  const sortAccessibilityLabel = i18n.translate("Polaris.DataTable.sortAccessibilityLabel", {
    direction: sorted ? oppositeDirection : direction
  });
  const iconMarkup = import_react666.default.createElement("span", {
    className: iconClassName
  }, import_react666.default.createElement(Icon, {
    source,
    accessibilityLabel: sortAccessibilityLabel
  }));
  const focusable = !(stickyHeadingCell && hasFixedNthColumn && nthColumn && !inFixedNthColumn);
  const sortableHeadingContent = import_react666.default.createElement("button", {
    className: headerClassName,
    onClick: onSort,
    onFocus: handleFocus,
    tabIndex: focusable ? 0 : -1
  }, iconMarkup, content);
  const columnHeadingContent = sortable ? sortableHeadingContent : content;
  const colSpanProp = colSpan && colSpan > 1 ? {
    colSpan
  } : {};
  const minWidthStyles = nthColumn && firstColumnMinWidth ? {
    minWidth: firstColumnMinWidth
  } : {
    minWidth: stickyCellWidth
  };
  const stickyHeading = import_react666.default.createElement("th", Object.assign({
    ref: setRef
  }, headerCell.props, colSpanProp, {
    className,
    "aria-sort": sortDirection,
    style: {
      ...style,
      ...minWidthStyles
    },
    "data-index-table-sticky-heading": true
  }), columnHeadingContent);
  const headingMarkup = header ? import_react666.default.createElement("th", Object.assign({}, headerCell.props, {
    "aria-sort": sortDirection
  }, colSpanProp, {
    ref: setRef,
    className,
    scope: "col",
    style: {
      ...minWidthStyles
    }
  }), columnHeadingContent) : import_react666.default.createElement("th", Object.assign({}, colSpanProp, {
    ref: setRef,
    className,
    scope: "row",
    style: {
      ...minWidthStyles
    }
  }), truncate ? import_react666.default.createElement(TruncatedText, {
    className: styles66.TooltipContent
  }, content) : content);
  const cellMarkup = header || firstColumn || nthColumn ? headingMarkup : import_react666.default.createElement("td", Object.assign({
    className
  }, colSpanProp), content);
  return stickyHeadingCell ? stickyHeading : cellMarkup;
}
var TruncatedText = ({
  children: children2,
  className = ""
}) => {
  const textRef = (0, import_react666.useRef)(null);
  const {
    current
  } = textRef;
  const text = import_react666.default.createElement("span", {
    ref: textRef,
    className
  }, children2);
  return (current === null || current === void 0 ? void 0 : current.scrollWidth) > (current === null || current === void 0 ? void 0 : current.offsetWidth) ? import_react666.default.createElement(Tooltip, {
    content: textRef.current.innerText
  }, text) : text;
};

// ../node_modules/@shopify/polaris/build/esm/components/AfterInitialMount/AfterInitialMount.js
var import_react667 = __toESM(require_react());
function AfterInitialMount({
  children: children2,
  onMount,
  fallback = null
}) {
  const isMounted = useIsAfterInitialMount();
  const content = isMounted ? children2 : fallback;
  (0, import_react667.useEffect)(() => {
    if (isMounted && onMount) {
      onMount();
    }
  }, [isMounted, onMount]);
  return import_react667.default.createElement(import_react667.default.Fragment, null, content);
}

// ../node_modules/@shopify/polaris/build/esm/components/Sticky/Sticky.js
var import_react669 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/sticky-manager/hooks.js
var import_react668 = __toESM(require_react());
function useStickyManager() {
  const stickyManager = (0, import_react668.useContext)(StickyManagerContext);
  if (!stickyManager) {
    throw new MissingAppProviderError("No StickyManager was provided.");
  }
  return stickyManager;
}

// ../node_modules/@shopify/polaris/build/esm/components/Sticky/Sticky.js
var StickyInner = class extends import_react669.Component {
  constructor(...args) {
    super(...args);
    this.state = {
      isSticky: false,
      style: {}
    };
    this.placeHolderNode = null;
    this.stickyNode = null;
    this.setPlaceHolderNode = (node) => {
      this.placeHolderNode = node;
    };
    this.setStickyNode = (node) => {
      this.stickyNode = node;
    };
    this.handlePositioning = (stick, top = 0, left = 0, width = 0) => {
      const {
        isSticky
      } = this.state;
      if (stick && !isSticky || !stick && isSticky) {
        this.adjustPlaceHolderNode(stick);
        this.setState({
          isSticky: !isSticky
        }, () => {
          if (this.props.onStickyChange == null) {
            return null;
          }
          this.props.onStickyChange(!isSticky);
          if (this.props.boundingElement == null) {
            return null;
          }
          this.props.boundingElement.toggleAttribute("data-sticky-active");
        });
      }
      const style = stick ? {
        position: "fixed",
        top,
        left,
        width
      } : {};
      this.setState({
        style
      });
    };
    this.adjustPlaceHolderNode = (add) => {
      if (this.placeHolderNode && this.stickyNode) {
        this.placeHolderNode.style.paddingBottom = add ? `${getRectForNode(this.stickyNode).height}px` : "0px";
      }
    };
  }
  componentDidMount() {
    const {
      boundingElement,
      offset = false,
      disableWhenStacked = false,
      stickyManager
    } = this.props;
    if (!this.stickyNode || !this.placeHolderNode)
      return;
    stickyManager.registerStickyItem({
      stickyNode: this.stickyNode,
      placeHolderNode: this.placeHolderNode,
      handlePositioning: this.handlePositioning,
      offset,
      boundingElement,
      disableWhenStacked
    });
  }
  componentWillUnmount() {
    const {
      stickyManager
    } = this.props;
    if (!this.stickyNode)
      return;
    stickyManager.unregisterStickyItem(this.stickyNode);
  }
  render() {
    const {
      style,
      isSticky
    } = this.state;
    const {
      children: children2
    } = this.props;
    const childrenContent = isFunction(children2) ? children2(isSticky) : children2;
    return import_react669.default.createElement("div", null, import_react669.default.createElement("div", {
      ref: this.setPlaceHolderNode
    }), import_react669.default.createElement("div", {
      ref: this.setStickyNode,
      style
    }, childrenContent));
  }
};
function isFunction(arg) {
  return typeof arg === "function";
}
function Sticky(props) {
  const stickyManager = useStickyManager();
  return import_react669.default.createElement(StickyInner, Object.assign({}, props, {
    stickyManager
  }));
}

// ../node_modules/@shopify/polaris/build/esm/components/DataTable/components/Navigation/Navigation.js
var import_react670 = __toESM(require_react());
function Navigation({
  columnVisibilityData,
  isScrolledFarthestLeft,
  isScrolledFarthestRight,
  navigateTableLeft,
  navigateTableRight,
  fixedFirstColumns,
  setRef = () => {
  }
}) {
  const i18n = useI18n();
  const pipMarkup = columnVisibilityData.map((column, index) => {
    if (index < fixedFirstColumns)
      return;
    const className = classNames(styles66.Pip, column.isVisible && styles66["Pip-visible"]);
    return import_react670.default.createElement("div", {
      className,
      key: `pip-${index}`
    });
  });
  const leftA11yLabel = i18n.translate("Polaris.DataTable.navAccessibilityLabel", {
    direction: "left"
  });
  const rightA11yLabel = i18n.translate("Polaris.DataTable.navAccessibilityLabel", {
    direction: "right"
  });
  return import_react670.default.createElement("div", {
    className: styles66.Navigation,
    ref: setRef
  }, import_react670.default.createElement(Button, {
    plain: true,
    icon: SvgChevronLeftMinor,
    disabled: isScrolledFarthestLeft,
    accessibilityLabel: leftA11yLabel,
    onClick: navigateTableLeft
  }), pipMarkup, import_react670.default.createElement(Button, {
    plain: true,
    icon: SvgChevronRightMinor,
    disabled: isScrolledFarthestRight,
    accessibilityLabel: rightA11yLabel,
    onClick: navigateTableRight
  }));
}

// ../node_modules/@shopify/polaris/build/esm/components/DataTable/DataTable.js
var getRowClientHeights = (rows) => {
  const heights = [];
  if (!rows) {
    return heights;
  }
  rows.forEach((row) => {
    heights.push(row.clientHeight);
  });
  return heights;
};
var DataTableInner = class extends import_react671.PureComponent {
  constructor(...args) {
    super(...args);
    this.state = {
      condensed: false,
      columnVisibilityData: [],
      isScrolledFarthestLeft: true,
      isScrolledFarthestRight: false,
      rowHovered: void 0
    };
    this.dataTable = (0, import_react671.createRef)();
    this.scrollContainer = (0, import_react671.createRef)();
    this.table = (0, import_react671.createRef)();
    this.stickyTable = (0, import_react671.createRef)();
    this.stickyNav = null;
    this.headerNav = null;
    this.tableHeadings = [];
    this.stickyHeadings = [];
    this.tableHeadingWidths = [];
    this.stickyHeaderActive = false;
    this.scrollStopTimer = null;
    this.handleResize = debounce(() => {
      const {
        table: {
          current: table
        },
        scrollContainer: {
          current: scrollContainer
        }
      } = this;
      let condensed = false;
      if (table && scrollContainer) {
        condensed = table.scrollWidth > scrollContainer.clientWidth + 1;
      }
      this.setState({
        condensed,
        ...this.calculateColumnVisibilityData(condensed)
      });
    });
    this.setCellRef = ({
      ref,
      index,
      inStickyHeader
    }) => {
      if (ref == null) {
        return;
      }
      if (inStickyHeader) {
        this.stickyHeadings[index] = ref;
        const button = ref.querySelector("button");
        if (button == null) {
          return;
        }
        button.addEventListener("focus", this.handleHeaderButtonFocus);
      } else {
        this.tableHeadings[index] = ref;
        this.tableHeadingWidths[index] = ref.clientWidth;
      }
    };
    this.changeHeadingFocus = () => {
      const {
        tableHeadings,
        stickyHeadings,
        stickyNav,
        headerNav
      } = this;
      const stickyFocusedItemIndex = stickyHeadings.findIndex((item) => {
        var _document$activeEleme;
        return item === ((_document$activeEleme = document.activeElement) === null || _document$activeEleme === void 0 ? void 0 : _document$activeEleme.parentElement);
      });
      const tableFocusedItemIndex = tableHeadings.findIndex((item) => {
        var _document$activeEleme2;
        return item === ((_document$activeEleme2 = document.activeElement) === null || _document$activeEleme2 === void 0 ? void 0 : _document$activeEleme2.parentElement);
      });
      const arrowsInStickyNav = stickyNav === null || stickyNav === void 0 ? void 0 : stickyNav.querySelectorAll("button");
      const arrowsInHeaderNav = headerNav === null || headerNav === void 0 ? void 0 : headerNav.querySelectorAll("button");
      let stickyFocusedNavIndex = -1;
      arrowsInStickyNav === null || arrowsInStickyNav === void 0 ? void 0 : arrowsInStickyNav.forEach((item, index) => {
        if (item === document.activeElement) {
          stickyFocusedNavIndex = index;
        }
      });
      let headerFocusedNavIndex = -1;
      arrowsInHeaderNav === null || arrowsInHeaderNav === void 0 ? void 0 : arrowsInHeaderNav.forEach((item, index) => {
        if (item === document.activeElement) {
          headerFocusedNavIndex = index;
        }
      });
      if (stickyFocusedItemIndex < 0 && tableFocusedItemIndex < 0 && stickyFocusedNavIndex < 0 && headerFocusedNavIndex < 0) {
        return null;
      }
      let button;
      if (stickyFocusedItemIndex >= 0) {
        button = tableHeadings[stickyFocusedItemIndex].querySelector("button");
      } else if (tableFocusedItemIndex >= 0) {
        button = stickyHeadings[tableFocusedItemIndex].querySelector("button");
      }
      if (stickyFocusedNavIndex >= 0) {
        button = arrowsInHeaderNav === null || arrowsInHeaderNav === void 0 ? void 0 : arrowsInHeaderNav[stickyFocusedNavIndex];
      } else if (headerFocusedNavIndex >= 0) {
        button = arrowsInStickyNav === null || arrowsInStickyNav === void 0 ? void 0 : arrowsInStickyNav[headerFocusedNavIndex];
      }
      if (button == null) {
        return null;
      }
      button.style.visibility = "visible";
      button.focus();
      button.style.removeProperty("visibility");
    };
    this.calculateColumnVisibilityData = (condensed) => {
      const fixedFirstColumns = this.fixedFirstColumns();
      const {
        table: {
          current: table
        },
        scrollContainer: {
          current: scrollContainer
        },
        dataTable: {
          current: dataTable
        }
      } = this;
      const {
        stickyHeader
      } = this.props;
      if ((stickyHeader || condensed) && table && scrollContainer && dataTable) {
        const headerCells = table.querySelectorAll(headerCell.selector);
        const rightMostHeader = headerCells[fixedFirstColumns - 1];
        const nthColumnWidth = fixedFirstColumns ? rightMostHeader.offsetLeft + rightMostHeader.offsetWidth : 0;
        if (headerCells.length > 0) {
          const firstVisibleColumnIndex = headerCells.length - 1;
          const tableLeftVisibleEdge = scrollContainer.scrollLeft + nthColumnWidth;
          const tableRightVisibleEdge = scrollContainer.scrollLeft + dataTable.offsetWidth;
          const tableData = {
            firstVisibleColumnIndex,
            tableLeftVisibleEdge,
            tableRightVisibleEdge
          };
          const columnVisibilityData = [...headerCells].map(measureColumn(tableData));
          const lastColumn = columnVisibilityData[columnVisibilityData.length - 1];
          const isScrolledFarthestLeft = fixedFirstColumns ? tableLeftVisibleEdge === nthColumnWidth : tableLeftVisibleEdge === 0;
          return {
            columnVisibilityData,
            ...getPrevAndCurrentColumns(tableData, columnVisibilityData),
            isScrolledFarthestLeft,
            isScrolledFarthestRight: lastColumn.rightEdge <= tableRightVisibleEdge
          };
        }
      }
      return {
        columnVisibilityData: [],
        previousColumn: void 0,
        currentColumn: void 0
      };
    };
    this.handleHeaderButtonFocus = (event) => {
      var _this$state$columnVis;
      const fixedFirstColumns = this.fixedFirstColumns();
      if (this.scrollContainer.current == null || event.target == null || this.state.columnVisibilityData.length === 0) {
        return;
      }
      const target = event.target;
      const currentCell = target.parentNode;
      const tableScrollLeft = this.scrollContainer.current.scrollLeft;
      const tableViewableWidth = this.scrollContainer.current.offsetWidth;
      const tableRightEdge = tableScrollLeft + tableViewableWidth;
      const nthColumnWidth = this.state.columnVisibilityData.length > 0 ? (_this$state$columnVis = this.state.columnVisibilityData[fixedFirstColumns]) === null || _this$state$columnVis === void 0 ? void 0 : _this$state$columnVis.rightEdge : 0;
      const currentColumnLeftEdge = currentCell.offsetLeft;
      const currentColumnRightEdge = currentCell.offsetLeft + currentCell.offsetWidth;
      if (tableScrollLeft > currentColumnLeftEdge - nthColumnWidth) {
        this.scrollContainer.current.scrollLeft = currentColumnLeftEdge - nthColumnWidth;
      }
      if (currentColumnRightEdge > tableRightEdge) {
        this.scrollContainer.current.scrollLeft = currentColumnRightEdge - tableViewableWidth;
      }
    };
    this.stickyHeaderScrolling = () => {
      const {
        current: stickyTable
      } = this.stickyTable;
      const {
        current: scrollContainer
      } = this.scrollContainer;
      if (stickyTable == null || scrollContainer == null) {
        return;
      }
      stickyTable.scrollLeft = scrollContainer.scrollLeft;
    };
    this.scrollListener = () => {
      var _this$scrollContainer;
      if (this.scrollStopTimer) {
        clearTimeout(this.scrollStopTimer);
      }
      this.scrollStopTimer = setTimeout(() => {
        this.setState((prevState) => ({
          ...this.calculateColumnVisibilityData(prevState.condensed)
        }));
      }, 100);
      this.setState({
        isScrolledFarthestLeft: ((_this$scrollContainer = this.scrollContainer.current) === null || _this$scrollContainer === void 0 ? void 0 : _this$scrollContainer.scrollLeft) === 0
      });
      if (this.props.stickyHeader && this.stickyHeaderActive) {
        this.stickyHeaderScrolling();
      }
    };
    this.handleHover = (row) => () => {
      this.setState({
        rowHovered: row
      });
    };
    this.handleFocus = (event) => {
      var _this$state$columnVis2;
      const fixedFirstColumns = this.fixedFirstColumns();
      if (this.scrollContainer.current == null || event.target == null) {
        return;
      }
      const currentCell = event.target.parentNode;
      const fixedNthColumn = this.props;
      const nthColumnWidth = fixedNthColumn ? (_this$state$columnVis2 = this.state.columnVisibilityData[fixedFirstColumns]) === null || _this$state$columnVis2 === void 0 ? void 0 : _this$state$columnVis2.rightEdge : 0;
      const currentColumnLeftEdge = currentCell.offsetLeft;
      const desiredScrollLeft = currentColumnLeftEdge - nthColumnWidth;
      if (this.scrollContainer.current.scrollLeft > desiredScrollLeft) {
        this.scrollContainer.current.scrollLeft = desiredScrollLeft;
      }
    };
    this.navigateTable = (direction) => {
      var _this$state$columnVis3;
      const fixedFirstColumns = this.fixedFirstColumns();
      const {
        currentColumn,
        previousColumn
      } = this.state;
      const nthColumnWidth = (_this$state$columnVis3 = this.state.columnVisibilityData[fixedFirstColumns - 1]) === null || _this$state$columnVis3 === void 0 ? void 0 : _this$state$columnVis3.rightEdge;
      if (!currentColumn || !previousColumn) {
        return;
      }
      let prevWidths = 0;
      for (let index = 0; index < currentColumn.index; index++) {
        prevWidths += this.state.columnVisibilityData[index].width;
      }
      const {
        current: scrollContainer
      } = this.scrollContainer;
      const handleScroll = () => {
        let newScrollLeft = 0;
        if (fixedFirstColumns) {
          newScrollLeft = direction === "right" ? prevWidths - nthColumnWidth + currentColumn.width : prevWidths - previousColumn.width - nthColumnWidth;
        } else {
          newScrollLeft = direction === "right" ? currentColumn.rightEdge : previousColumn.leftEdge;
        }
        if (scrollContainer) {
          scrollContainer.scrollLeft = newScrollLeft;
          requestAnimationFrame(() => {
            this.setState((prevState) => ({
              ...this.calculateColumnVisibilityData(prevState.condensed)
            }));
          });
        }
      };
      return handleScroll;
    };
    this.renderHeading = ({
      heading,
      headingIndex,
      inFixedNthColumn,
      inStickyHeader
    }) => {
      const {
        sortable,
        truncate = false,
        columnContentTypes,
        defaultSortDirection,
        initialSortColumnIndex = 0,
        verticalAlign,
        firstColumnMinWidth
      } = this.props;
      const fixedFirstColumns = this.fixedFirstColumns();
      const {
        sortDirection = defaultSortDirection,
        sortedColumnIndex = initialSortColumnIndex,
        isScrolledFarthestLeft
      } = this.state;
      let sortableHeadingProps;
      const headingCellId = `heading-cell-${headingIndex}`;
      const stickyHeaderId = `stickyheader-${headingIndex}`;
      const id = inStickyHeader ? stickyHeaderId : headingCellId;
      if (sortable) {
        const isSortable = sortable[headingIndex];
        const isSorted = isSortable && sortedColumnIndex === headingIndex;
        const direction = isSorted ? sortDirection : "none";
        sortableHeadingProps = {
          defaultSortDirection,
          sorted: isSorted,
          sortable: isSortable,
          sortDirection: direction,
          onSort: this.defaultOnSort(headingIndex),
          fixedNthColumn: fixedFirstColumns,
          inFixedNthColumn: fixedFirstColumns
        };
      }
      const stickyCellWidth = inStickyHeader ? this.tableHeadingWidths[headingIndex] : void 0;
      const fixedCellVisible = !isScrolledFarthestLeft;
      const cellProps = {
        header: true,
        stickyHeadingCell: inStickyHeader,
        content: heading,
        contentType: columnContentTypes[headingIndex],
        nthColumn: headingIndex < fixedFirstColumns,
        fixedFirstColumns,
        truncate,
        headingIndex,
        ...sortableHeadingProps,
        verticalAlign,
        handleFocus: this.handleFocus,
        stickyCellWidth,
        fixedCellVisible,
        firstColumnMinWidth
      };
      if (inFixedNthColumn && inStickyHeader) {
        var _this$state$columnVis4;
        return [import_react671.default.createElement(Cell, Object.assign({
          key: id
        }, cellProps, {
          setRef: (ref) => {
            this.setCellRef({
              ref,
              index: headingIndex,
              inStickyHeader
            });
          },
          inFixedNthColumn: false
        })), import_react671.default.createElement(Cell, Object.assign({
          key: `${id}-sticky`
        }, cellProps, {
          setRef: (ref) => {
            this.setCellRef({
              ref,
              index: headingIndex,
              inStickyHeader
            });
          },
          inFixedNthColumn: Boolean(fixedFirstColumns),
          lastFixedFirstColumn: headingIndex === fixedFirstColumns - 1,
          style: {
            left: (_this$state$columnVis4 = this.state.columnVisibilityData[headingIndex]) === null || _this$state$columnVis4 === void 0 ? void 0 : _this$state$columnVis4.leftEdge
          }
        }))];
      }
      return import_react671.default.createElement(Cell, Object.assign({
        key: id
      }, cellProps, {
        setRef: (ref) => {
          this.setCellRef({
            ref,
            index: headingIndex,
            inStickyHeader
          });
        },
        lastFixedFirstColumn: headingIndex === fixedFirstColumns - 1,
        inFixedNthColumn
      }));
    };
    this.totalsRowHeading = () => {
      const {
        i18n,
        totals,
        totalsName
      } = this.props;
      const totalsLabel = totalsName ? totalsName : {
        singular: i18n.translate("Polaris.DataTable.totalRowHeading"),
        plural: i18n.translate("Polaris.DataTable.totalsRowHeading")
      };
      return totals && totals.filter((total) => total !== "").length > 1 ? totalsLabel.plural : totalsLabel.singular;
    };
    this.renderTotals = ({
      total,
      index
    }) => {
      const fixedFirstColumns = this.fixedFirstColumns();
      const id = `totals-cell-${index}`;
      const {
        truncate = false,
        verticalAlign,
        columnContentTypes
      } = this.props;
      let content;
      let contentType;
      if (index === 0) {
        content = this.totalsRowHeading();
      }
      if (total !== "" && index > 0) {
        contentType = columnContentTypes[index];
        content = total;
      }
      const totalInFooter = this.props.showTotalsInFooter;
      return import_react671.default.createElement(Cell, {
        total: true,
        totalInFooter,
        nthColumn: index <= fixedFirstColumns - 1,
        firstColumn: index === 0,
        key: id,
        content,
        contentType,
        truncate,
        verticalAlign
      });
    };
    this.getColSpan = (rowLength, headingsLength, contentTypesLength, cellIndex) => {
      const fixedFirstColumns = this.fixedFirstColumns();
      if (fixedFirstColumns) {
        return 1;
      }
      const rowLen = rowLength ? rowLength : 1;
      const colLen = headingsLength ? headingsLength : contentTypesLength;
      const colSpan = Math.floor(colLen / rowLen);
      const remainder = colLen % rowLen;
      return cellIndex === 0 ? colSpan + remainder : colSpan;
    };
    this.defaultRenderRow = ({
      row,
      index,
      inFixedNthColumn,
      rowHeights
    }) => {
      const {
        columnContentTypes,
        truncate = false,
        verticalAlign,
        hoverable = true,
        headings
      } = this.props;
      const {
        condensed
      } = this.state;
      const fixedFirstColumns = this.fixedFirstColumns();
      const className = classNames(styles66.TableRow, hoverable && styles66.hoverable);
      return import_react671.default.createElement("tr", {
        key: `row-${index}`,
        className,
        onMouseEnter: this.handleHover(index),
        onMouseLeave: this.handleHover()
      }, row.map((content, cellIndex) => {
        const hovered = index === this.state.rowHovered;
        const id = `cell-${cellIndex}-row-${index}`;
        const colSpan = this.getColSpan(row.length, headings.length, columnContentTypes.length, cellIndex);
        return import_react671.default.createElement(Cell, {
          key: id,
          content,
          contentType: columnContentTypes[cellIndex],
          nthColumn: cellIndex <= fixedFirstColumns - 1,
          firstColumn: cellIndex === 0,
          truncate,
          verticalAlign,
          colSpan,
          hovered,
          style: rowHeights ? {
            height: `${rowHeights[index]}px`
          } : {},
          inFixedNthColumn: condensed && inFixedNthColumn
        });
      }));
    };
    this.defaultOnSort = (headingIndex) => {
      const {
        onSort,
        defaultSortDirection = "ascending",
        initialSortColumnIndex
      } = this.props;
      const {
        sortDirection = defaultSortDirection,
        sortedColumnIndex = initialSortColumnIndex
      } = this.state;
      let newSortDirection = defaultSortDirection;
      if (sortedColumnIndex === headingIndex) {
        newSortDirection = sortDirection === "ascending" ? "descending" : "ascending";
      }
      const handleSort = () => {
        this.setState({
          sortDirection: newSortDirection,
          sortedColumnIndex: headingIndex
        }, () => {
          if (onSort) {
            onSort(headingIndex, newSortDirection);
          }
        });
      };
      return handleSort;
    };
  }
  componentDidMount() {
    if (true) {
      setTimeout(() => {
        this.handleResize();
      }, 10);
    } else {
      this.handleResize();
    }
  }
  componentDidUpdate(prevProps) {
    if ((0, import_react_fast_compare.default)(prevProps, this.props)) {
      return;
    }
    this.handleResize();
  }
  componentWillUnmount() {
    this.handleResize.cancel();
  }
  render() {
    var _this$table$current, _this$table$current2, _columnVisibilityData;
    const {
      headings,
      totals,
      showTotalsInFooter,
      rows,
      footerContent,
      hideScrollIndicator = false,
      increasedTableDensity = false,
      hasZebraStripingOnData = false,
      stickyHeader = false,
      hasFixedFirstColumn: fixedFirstColumn = false
    } = this.props;
    const {
      condensed,
      columnVisibilityData,
      isScrolledFarthestLeft,
      isScrolledFarthestRight
    } = this.state;
    if (fixedFirstColumn && true) {
      console.warn("Deprecation: The `hasFixedFirstColumn` prop on the `DataTable` has been deprecated. Use fixedFirstColumns={n} instead.");
    }
    const fixedFirstColumns = this.fixedFirstColumns();
    const rowCountIsEven = rows.length % 2 === 0;
    const className = classNames(styles66.DataTable, condensed && styles66.condensed, totals && styles66.ShowTotals, showTotalsInFooter && styles66.ShowTotalsInFooter, hasZebraStripingOnData && styles66.ZebraStripingOnData, hasZebraStripingOnData && rowCountIsEven && styles66.RowCountIsEven);
    const wrapperClassName = classNames(styles66.TableWrapper, condensed && styles66.condensed, increasedTableDensity && styles66.IncreasedTableDensity, stickyHeader && styles66.StickyHeaderEnabled);
    const headingMarkup = import_react671.default.createElement("tr", null, headings.map((heading, index) => this.renderHeading({
      heading,
      headingIndex: index,
      inFixedNthColumn: false,
      inStickyHeader: false
    })));
    const totalsMarkup = totals ? import_react671.default.createElement("tr", null, totals.map((total, index) => this.renderTotals({
      total,
      index
    }))) : null;
    const nthColumns = rows.map((row) => row.slice(0, fixedFirstColumns));
    const nthHeadings = headings.slice(0, fixedFirstColumns);
    const nthTotals = totals === null || totals === void 0 ? void 0 : totals.slice(0, fixedFirstColumns);
    const tableHeaderRows = (_this$table$current = this.table.current) === null || _this$table$current === void 0 ? void 0 : _this$table$current.children[0].childNodes;
    const tableBodyRows = (_this$table$current2 = this.table.current) === null || _this$table$current2 === void 0 ? void 0 : _this$table$current2.children[1].childNodes;
    const headerRowHeights = getRowClientHeights(tableHeaderRows);
    const bodyRowHeights = getRowClientHeights(tableBodyRows);
    const fixedNthColumnMarkup = condensed && fixedFirstColumns !== 0 && import_react671.default.createElement("table", {
      className: classNames(styles66.FixedFirstColumn, !isScrolledFarthestLeft && styles66.separate),
      style: {
        width: `${(_columnVisibilityData = columnVisibilityData[fixedFirstColumns - 1]) === null || _columnVisibilityData === void 0 ? void 0 : _columnVisibilityData.rightEdge}px`
      }
    }, import_react671.default.createElement("thead", null, import_react671.default.createElement("tr", {
      style: {
        height: `${headerRowHeights[0]}px`
      }
    }, nthHeadings.map((heading, index) => this.renderHeading({
      heading,
      headingIndex: index,
      inFixedNthColumn: true,
      inStickyHeader: false
    }))), totals && !showTotalsInFooter && import_react671.default.createElement("tr", {
      style: {
        height: `${headerRowHeights[1]}px`
      }
    }, nthTotals === null || nthTotals === void 0 ? void 0 : nthTotals.map((total, index) => this.renderTotals({
      total,
      index
    })))), import_react671.default.createElement("tbody", null, nthColumns.map((row, index) => this.defaultRenderRow({
      row,
      index,
      inFixedNthColumn: true,
      rowHeights: bodyRowHeights
    }))), totals && showTotalsInFooter && import_react671.default.createElement("tfoot", null, import_react671.default.createElement("tr", null, nthTotals === null || nthTotals === void 0 ? void 0 : nthTotals.map((total, index) => this.renderTotals({
      total,
      index
    })))));
    const bodyMarkup = rows.map((row, index) => this.defaultRenderRow({
      row,
      index,
      inFixedNthColumn: false
    }));
    const footerMarkup = footerContent ? import_react671.default.createElement("div", {
      className: styles66.Footer
    }, footerContent) : null;
    const headerTotalsMarkup = !showTotalsInFooter ? totalsMarkup : null;
    const footerTotalsMarkup = showTotalsInFooter ? import_react671.default.createElement("tfoot", null, totalsMarkup) : null;
    const navigationMarkup = (location) => hideScrollIndicator ? null : import_react671.default.createElement(Navigation, {
      columnVisibilityData,
      isScrolledFarthestLeft,
      isScrolledFarthestRight,
      navigateTableLeft: this.navigateTable("left"),
      navigateTableRight: this.navigateTable("right"),
      fixedFirstColumns,
      setRef: (ref) => {
        if (location === "header") {
          this.headerNav = ref;
        } else if (location === "sticky") {
          this.stickyNav = ref;
        }
      }
    });
    const stickyHeaderMarkup = stickyHeader ? import_react671.default.createElement(AfterInitialMount, null, import_react671.default.createElement("div", {
      className: styles66.StickyHeaderWrapper,
      role: "presentation"
    }, import_react671.default.createElement(Sticky, {
      boundingElement: this.dataTable.current,
      onStickyChange: (isSticky) => {
        this.changeHeadingFocus();
        this.stickyHeaderActive = isSticky;
      }
    }, (isSticky) => {
      const stickyHeaderInnerClassNames = classNames(styles66.StickyHeaderInner, isSticky && styles66["StickyHeaderInner-isSticky"]);
      const stickyHeaderTableClassNames = classNames(styles66.StickyHeaderTable, !isScrolledFarthestLeft && styles66.separate);
      return import_react671.default.createElement("div", {
        className: stickyHeaderInnerClassNames
      }, import_react671.default.createElement("div", null, navigationMarkup("sticky")), import_react671.default.createElement("table", {
        className: stickyHeaderTableClassNames,
        ref: this.stickyTable
      }, import_react671.default.createElement("thead", null, import_react671.default.createElement("tr", {
        className: styles66.StickyTableHeadingsRow
      }, headings.map((heading, index) => {
        return this.renderHeading({
          heading,
          headingIndex: index,
          inFixedNthColumn: Boolean(index <= fixedFirstColumns - 1 && fixedFirstColumns),
          inStickyHeader: true
        });
      })))));
    }))) : null;
    return import_react671.default.createElement("div", {
      className: wrapperClassName,
      ref: this.dataTable
    }, stickyHeaderMarkup, navigationMarkup("header"), import_react671.default.createElement("div", {
      className
    }, import_react671.default.createElement("div", {
      className: styles66.ScrollContainer,
      ref: this.scrollContainer
    }, import_react671.default.createElement(EventListener, {
      event: "resize",
      handler: this.handleResize
    }), import_react671.default.createElement(EventListener, {
      capture: true,
      passive: true,
      event: "scroll",
      handler: this.scrollListener
    }), fixedNthColumnMarkup, import_react671.default.createElement("table", {
      className: styles66.Table,
      ref: this.table
    }, import_react671.default.createElement("thead", null, headingMarkup, headerTotalsMarkup), import_react671.default.createElement("tbody", null, bodyMarkup), footerTotalsMarkup)), footerMarkup));
  }
  fixedFirstColumns() {
    const {
      hasFixedFirstColumn,
      fixedFirstColumns = 0,
      headings
    } = this.props;
    const numberOfFixedFirstColumns = hasFixedFirstColumn && !fixedFirstColumns ? 1 : fixedFirstColumns;
    if (numberOfFixedFirstColumns >= headings.length) {
      return 0;
    }
    return numberOfFixedFirstColumns;
  }
};
function DataTable(props) {
  const i18n = useI18n();
  return import_react671.default.createElement(DataTableInner, Object.assign({}, props, {
    i18n
  }));
}

// ../node_modules/@shopify/polaris/build/esm/components/DatePicker/DatePicker.js
var import_react675 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/dates.js
var WEEK_LENGTH = 7;
function getWeeksForMonth(month, year, weekStartsOn = 0) {
  const firstOfMonth = new Date(year, month, 1);
  const firstDayOfWeek = firstOfMonth.getDay();
  const weeks = [[]];
  let currentWeek = weeks[0];
  let currentDate = firstOfMonth;
  const orderedWeekday = getOrderedWeekdays(weekStartsOn);
  for (let i = 0; i < orderedWeekday.indexOf(firstDayOfWeek); i++) {
    currentWeek.push(null);
  }
  while (currentDate.getMonth() === month) {
    if (currentWeek.length === WEEK_LENGTH) {
      currentWeek = [];
      weeks.push(currentWeek);
    }
    currentWeek.push(currentDate);
    currentDate = new Date(year, month, currentDate.getDate() + 1);
  }
  while (currentWeek.length < 7) {
    currentWeek.push(null);
  }
  return weeks;
}
function dateIsInRange(day, range) {
  if (day == null) {
    return false;
  }
  const {
    start,
    end
  } = range;
  return Boolean(start && day > start && end && day < end);
}
function dateIsSelected(day, range) {
  if (day == null) {
    return false;
  }
  const {
    start,
    end
  } = range;
  return Boolean(start && isSameDay(start, day) || end && isSameDay(end, day));
}
function isSameDay(day1, day2) {
  return day1.getDate() === day2.getDate() && day1.getMonth() === day2.getMonth() && day1.getFullYear() === day2.getFullYear();
}
function getNewRange(range, selected) {
  if (range == null) {
    return {
      start: selected,
      end: selected
    };
  }
  const {
    start,
    end
  } = range;
  if (end && (isDateAfter(start, end) || isDateBefore(start, end))) {
    return {
      start: selected,
      end: selected
    };
  }
  if (start) {
    if (isDateBefore(selected, start)) {
      return {
        start: selected,
        end: selected
      };
    }
    return {
      start,
      end: selected
    };
  }
  if (end) {
    if (isDateBefore(selected, end)) {
      return {
        start: selected,
        end
      };
    }
    return {
      start: start || end,
      end: selected
    };
  }
  return {
    start: selected,
    end: selected
  };
}
function getNextDisplayMonth(month) {
  if (month === 11) {
    return 0;
  }
  return month + 1;
}
function getNextDisplayYear(month, year) {
  if (month === 11) {
    return year + 1;
  }
  return year;
}
function getPreviousDisplayMonth(month) {
  if (month === 0) {
    return 11;
  }
  return month - 1;
}
function getPreviousDisplayYear(month, year) {
  if (month === 0) {
    return year - 1;
  }
  return year;
}
function isDateAfter(date, dateToCompare) {
  return date.getTime() > dateToCompare.getTime();
}
function isDateBefore(date, dateToCompare) {
  return date.getTime() < dateToCompare.getTime();
}
function isDateDisabled(date, datesToCompare) {
  return datesToCompare.some((dateToCompare) => {
    return date.getTime() === dateToCompare.getTime();
  });
}
var WEEKDAYS = [0, 1, 2, 3, 4, 5, 6];
function getOrderedWeekdays(weekStartsOn) {
  const weekDays = [...WEEKDAYS];
  const restOfDays = weekDays.splice(weekStartsOn);
  return [...restOfDays, ...weekDays];
}

// ../node_modules/@shopify/polaris/build/esm/components/DatePicker/utilities.js
function monthName(month) {
  switch (month) {
    case 0:
      return "january";
    case 1:
      return "february";
    case 2:
      return "march";
    case 3:
      return "april";
    case 4:
      return "may";
    case 5:
      return "june";
    case 6:
      return "july";
    case 7:
      return "august";
    case 8:
      return "september";
    case 9:
      return "october";
    case 10:
      return "november";
    case 11:
      return "december";
  }
}
function weekdayName(weekday) {
  switch (weekday) {
    case 0:
      return "sunday";
    case 1:
      return "monday";
    case 2:
      return "tuesday";
    case 3:
      return "wednesday";
    case 4:
      return "thursday";
    case 5:
      return "friday";
    case 6:
      return "saturday";
  }
}

// ../node_modules/@shopify/polaris/build/esm/components/DatePicker/DatePicker.scss.js
var styles67 = {
  "DatePicker": "Polaris-DatePicker",
  "MonthLayout": "Polaris-DatePicker__MonthLayout",
  "MonthContainer": "Polaris-DatePicker__MonthContainer",
  "Month": "Polaris-DatePicker__Month",
  "Month-current": "Polaris-DatePicker__Month--current",
  "DayCell": "Polaris-DatePicker__DayCell",
  "DayCell-inRange": "Polaris-DatePicker__DayCell--inRange",
  "Day": "Polaris-DatePicker__Day",
  "Day-today": "Polaris-DatePicker__Day--today",
  "Day-inRange": "Polaris-DatePicker__Day--inRange",
  "Day-selected": "Polaris-DatePicker__Day--selected",
  "Day-disabled": "Polaris-DatePicker__Day--disabled",
  "EmptyDayCell": "Polaris-DatePicker__EmptyDayCell",
  "Weekday": "Polaris-DatePicker__Weekday",
  "Weekday-current": "Polaris-DatePicker__Weekday--current",
  "Header": "Polaris-DatePicker__Header",
  "Title": "Polaris-DatePicker__Title",
  "Day-firstInRange": "Polaris-DatePicker__Day--firstInRange",
  "Day-hasRange": "Polaris-DatePicker__Day--hasRange",
  "Day-hoverRight": "Polaris-DatePicker__Day--hoverRight",
  "Day-lastInRange": "Polaris-DatePicker__Day--lastInRange",
  "Week": "Polaris-DatePicker__Week"
};

// ../node_modules/@shopify/polaris/build/esm/components/DatePicker/components/Month/Month.js
var import_react674 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/DatePicker/components/Weekday/Weekday.js
var import_react672 = __toESM(require_react());
var Weekday = (0, import_react672.memo)(function Weekday2({
  label,
  title,
  current
}) {
  const className = classNames(styles67.Weekday, current && styles67["Weekday-current"]);
  return import_react672.default.createElement("th", {
    "aria-label": label,
    scope: "col",
    className
  }, title);
});

// ../node_modules/@shopify/polaris/build/esm/components/DatePicker/components/Day/Day.js
var import_react673 = __toESM(require_react());
var Day = (0, import_react673.memo)(function Day2({
  day,
  focused,
  onClick,
  onHover = noop10,
  onFocus = noop10,
  selected,
  inRange,
  inHoveringRange,
  disabled,
  lastDayOfMonth,
  isLastSelectedDay,
  isFirstSelectedDay,
  isHoveringRight,
  rangeIsDifferent,
  weekday,
  selectedAccessibilityLabelPrefix
}) {
  const i18n = useI18n();
  const dayNode = (0, import_react673.useRef)(null);
  const hoverValue = lastDayOfMonth || day;
  (0, import_react673.useEffect)(() => {
    if (focused && dayNode.current) {
      dayNode.current.focus();
    }
  }, [focused]);
  if (!day) {
    return import_react673.default.createElement("td", {
      className: styles67.EmptyDayCell,
      onMouseOver: () => onHover(hoverValue)
    });
  }
  const handleClick = onClick && !disabled ? onClick.bind(null, day) : noop10;
  const today = isSameDay(/* @__PURE__ */ new Date(), day);
  const dayCellClassName = classNames(styles67.DayCell, selected && styles67["DayCell-selected"], (inRange || inHoveringRange) && !disabled && styles67["DayCell-inRange"], isLastSelectedDay && styles67["DayCell-lastInRange"], isFirstSelectedDay && styles67["DayCell-firstInRange"], isHoveringRight && styles67["DayCell-hoverRight"], rangeIsDifferent && styles67["DayCell-hasRange"]);
  const dayClassName = classNames(styles67.Day, selected && styles67["Day-selected"], disabled && styles67["Day-disabled"], today && styles67["Day-today"], (inRange || inHoveringRange) && !disabled && styles67["Day-inRange"], isLastSelectedDay && styles67["Day-lastInRange"], isFirstSelectedDay && styles67["Day-firstInRange"], isHoveringRight && styles67["Day-hoverRight"], rangeIsDifferent && styles67["Day-hasRange"]);
  const date = day.getDate();
  const tabIndex = (focused || selected || today || date === 1) && !disabled ? 0 : -1;
  const ariaLabel = [selected && selectedAccessibilityLabelPrefix ? `${selectedAccessibilityLabelPrefix} ` : "", `${today ? i18n.translate("Polaris.DatePicker.today") : ""}`, `${weekday ? weekday : ""} `, `${i18n.translate(`Polaris.DatePicker.months.${monthName(day.getMonth())}`)} `, `${date} `, `${day.getFullYear()}`].join("");
  return import_react673.default.createElement("td", {
    className: dayCellClassName
  }, import_react673.default.createElement("button", {
    onFocus: () => onFocus(day),
    type: "button",
    ref: dayNode,
    tabIndex,
    className: dayClassName,
    onMouseOver: () => onHover(hoverValue),
    onClick: handleClick,
    "aria-label": ariaLabel,
    "aria-disabled": disabled,
    "aria-pressed": selected
  }, date));
});
function noop10() {
}

// ../node_modules/@shopify/polaris/build/esm/components/DatePicker/components/Month/Month.js
function Month({
  focusedDate,
  selected,
  hoverDate,
  disableDatesBefore,
  disableDatesAfter,
  disableSpecificDates,
  allowRange,
  onChange = noop11,
  onHover = noop11,
  onFocus = noop11,
  month,
  year,
  weekStartsOn,
  accessibilityLabelPrefixes
}) {
  const i18n = useI18n();
  const isInHoveringRange = allowRange ? hoveringDateIsInRange : () => false;
  const now = /* @__PURE__ */ new Date();
  const current = now.getMonth() === month && now.getFullYear() === year;
  const className = classNames(styles67.Title, current && styles67["Month-current"]);
  const weeks = (0, import_react674.useMemo)(() => getWeeksForMonth(month, year, weekStartsOn), [month, weekStartsOn, year]);
  const weekdays = getOrderedWeekdays(weekStartsOn).map((weekday) => import_react674.default.createElement(Weekday, {
    key: weekday,
    title: i18n.translate(`Polaris.DatePicker.daysAbbreviated.${weekdayName(weekday)}`),
    label: weekdayLabel(weekday),
    current: current && (/* @__PURE__ */ new Date()).getDay() === weekday
  }));
  const handleDateClick = (0, import_react674.useCallback)((selectedDate) => {
    onChange(getNewRange(allowRange ? selected : void 0, selectedDate));
  }, [allowRange, onChange, selected]);
  const lastDayOfMonth = (0, import_react674.useMemo)(() => new Date(year, month + 1, 0), [month, year]);
  function renderWeek(day, dayIndex) {
    if (day == null) {
      return import_react674.default.createElement(Day, {
        key: dayIndex,
        onHover,
        lastDayOfMonth
      });
    }
    const disabled = disableDatesBefore && isDateBefore(day, disableDatesBefore) || disableDatesAfter && isDateAfter(day, disableDatesAfter) || disableSpecificDates && isDateDisabled(day, disableSpecificDates);
    const isFirstSelectedDay = allowRange && selected && isDateStart(day, selected);
    const isLastSelectedDay = allowRange && selected && (!isSameDay(selected.start, selected.end) && isDateEnd(day, selected) || hoverDate && isSameDay(selected.start, selected.end) && isDateAfter(hoverDate, selected.start) && isSameDay(day, hoverDate) && !isFirstSelectedDay);
    const rangeIsDifferent = !(selected && isSameDay(selected.start, selected.end));
    const isHoveringRight = hoverDate && isDateBefore(day, hoverDate);
    const [firstAccessibilityLabelPrefix, lastAccessibilityLabelPrefix] = accessibilityLabelPrefixes;
    let accessibilityLabelPrefix;
    if (allowRange && isFirstSelectedDay || !allowRange && firstAccessibilityLabelPrefix) {
      accessibilityLabelPrefix = firstAccessibilityLabelPrefix;
    } else if (allowRange && isLastSelectedDay) {
      accessibilityLabelPrefix = lastAccessibilityLabelPrefix;
    }
    return import_react674.default.createElement(Day, {
      selectedAccessibilityLabelPrefix: accessibilityLabelPrefix,
      weekday: weekdayLabel(dayIndex),
      focused: focusedDate != null && isSameDay(day, focusedDate),
      day,
      key: dayIndex,
      onFocus,
      onClick: handleDateClick,
      onHover,
      selected: selected != null && dateIsSelected(day, selected),
      inRange: selected != null && dateIsInRange(day, selected),
      disabled,
      inHoveringRange: selected != null && hoverDate != null && isInHoveringRange(day, selected, hoverDate),
      isLastSelectedDay,
      isFirstSelectedDay,
      isHoveringRight,
      rangeIsDifferent
    });
  }
  const weeksMarkup = weeks.map((week, index) => import_react674.default.createElement("tr", {
    className: styles67.Week,
    key: index
  }, week.map(renderWeek)));
  return import_react674.default.createElement("div", {
    className: styles67.MonthContainer
  }, import_react674.default.createElement("table", {
    role: "grid",
    className: styles67.Month
  }, import_react674.default.createElement("caption", {
    className
  }, i18n.translate(`Polaris.DatePicker.months.${monthName(month)}`), " ", year), import_react674.default.createElement("thead", null, import_react674.default.createElement("tr", {
    className: styles67.WeekHeadings
  }, weekdays)), import_react674.default.createElement("tbody", null, weeksMarkup)));
  function weekdayLabel(weekday) {
    return i18n.translate(`Polaris.DatePicker.days.${weekdayName(weekday)}`);
  }
}
function noop11() {
}
function hoveringDateIsInRange(day, range, hoverEndDate) {
  if (day == null) {
    return false;
  }
  const {
    start,
    end
  } = range;
  return Boolean(isSameDay(start, end) && day > start && day <= hoverEndDate);
}
function isDateEnd(day, range) {
  if (day == null)
    return false;
  const {
    end
  } = range;
  return Boolean(end && isSameDay(end, day));
}
function isDateStart(day, range) {
  if (day == null)
    return false;
  const {
    start
  } = range;
  return Boolean(start && isSameDay(start, day));
}

// ../node_modules/@shopify/polaris/build/esm/components/DatePicker/DatePicker.js
function DatePicker({
  id,
  selected,
  month,
  year,
  allowRange,
  multiMonth,
  disableDatesBefore,
  disableDatesAfter,
  disableSpecificDates,
  weekStartsOn = 0,
  dayAccessibilityLabelPrefix,
  onMonthChange,
  onChange = noop12
}) {
  const i18n = useI18n();
  const [hoverDate, setHoverDate] = (0, import_react675.useState)(void 0);
  const [focusDate, setFocusDate] = (0, import_react675.useState)(void 0);
  (0, import_react675.useEffect)(() => {
    setFocusDate(void 0);
  }, [selected]);
  const handleFocus = (0, import_react675.useCallback)((date) => {
    setFocusDate(date);
  }, []);
  const setFocusDateAndHandleMonthChange = (0, import_react675.useCallback)((date) => {
    if (onMonthChange) {
      onMonthChange(date.getMonth(), date.getFullYear());
    }
    setHoverDate(date);
    setFocusDate(date);
  }, [onMonthChange]);
  const handleDateSelection = (0, import_react675.useCallback)((range) => {
    const {
      end
    } = range;
    setHoverDate(end);
    setFocusDate(new Date(end));
    onChange(range);
  }, [onChange]);
  const handleMonthChangeClick = (0, import_react675.useCallback)((month2, year2) => {
    if (!onMonthChange) {
      return;
    }
    setFocusDate(void 0);
    onMonthChange(month2, year2);
  }, [onMonthChange]);
  const handleHover = (0, import_react675.useCallback)((date) => {
    setHoverDate(date);
  }, []);
  const handleKeyUp = (0, import_react675.useCallback)((event) => {
    const {
      key
    } = event;
    const range = deriveRange(selected);
    const focusedDate = focusDate || range && range.start;
    if (focusedDate == null) {
      return;
    }
    if (key === "ArrowUp") {
      const previousWeek = new Date(focusedDate);
      previousWeek.setDate(focusedDate.getDate() - 7);
      if (!(disableDatesBefore && isDateBefore(previousWeek, disableDatesBefore) || disableSpecificDates && isDateDisabled(previousWeek, disableSpecificDates))) {
        setFocusDateAndHandleMonthChange(previousWeek);
      }
    }
    if (key === "ArrowDown") {
      const nextWeek = new Date(focusedDate);
      nextWeek.setDate(focusedDate.getDate() + 7);
      if (!(disableDatesAfter && isDateAfter(nextWeek, disableDatesAfter) || disableSpecificDates && isDateDisabled(nextWeek, disableSpecificDates))) {
        setFocusDateAndHandleMonthChange(nextWeek);
      }
    }
    if (key === "ArrowRight") {
      const tomorrow = new Date(focusedDate);
      tomorrow.setDate(focusedDate.getDate() + 1);
      if (!(disableDatesAfter && isDateAfter(tomorrow, disableDatesAfter) || disableSpecificDates && isDateDisabled(tomorrow, disableSpecificDates))) {
        setFocusDateAndHandleMonthChange(tomorrow);
      }
    }
    if (key === "ArrowLeft") {
      const yesterday = new Date(focusedDate);
      yesterday.setDate(focusedDate.getDate() - 1);
      if (!(disableDatesBefore && isDateBefore(yesterday, disableDatesBefore) || disableSpecificDates && isDateDisabled(yesterday, disableSpecificDates))) {
        setFocusDateAndHandleMonthChange(yesterday);
      }
    }
  }, [disableDatesAfter, disableDatesBefore, disableSpecificDates, focusDate, selected, setFocusDateAndHandleMonthChange]);
  const showNextYear = getNextDisplayYear(month, year);
  const showNextMonth = getNextDisplayMonth(month);
  const showNextToNextYear = getNextDisplayYear(showNextMonth, showNextYear);
  const showNextToNextMonth = getNextDisplayMonth(showNextMonth);
  const showPreviousYear = getPreviousDisplayYear(month, year);
  const showPreviousMonth = getPreviousDisplayMonth(month);
  const previousMonthName = i18n.translate(`Polaris.DatePicker.months.${monthName(showPreviousMonth)}`);
  const nextMonth = multiMonth ? i18n.translate(`Polaris.DatePicker.months.${monthName(showNextToNextMonth)}`) : i18n.translate(`Polaris.DatePicker.months.${monthName(showNextMonth)}`);
  const nextYear = multiMonth ? showNextToNextYear : showNextYear;
  const monthIsSelected = (0, import_react675.useMemo)(() => deriveRange(selected), [selected]);
  const firstDatePickerAccessibilityLabelPrefix = allowRange ? i18n.translate(`Polaris.DatePicker.start`) : dayAccessibilityLabelPrefix;
  const secondDatePickerAccessibilityLabelPrefix = i18n.translate(`Polaris.DatePicker.end`);
  const accessibilityLabelPrefixes = [firstDatePickerAccessibilityLabelPrefix, secondDatePickerAccessibilityLabelPrefix];
  const secondDatePicker = multiMonth ? import_react675.default.createElement(Month, {
    onFocus: handleFocus,
    focusedDate: focusDate,
    month: showNextMonth,
    year: showNextYear,
    selected: monthIsSelected,
    hoverDate,
    onChange: handleDateSelection,
    onHover: handleHover,
    disableDatesBefore,
    disableDatesAfter,
    disableSpecificDates,
    allowRange,
    weekStartsOn,
    accessibilityLabelPrefixes
  }) : null;
  const datePickerClassName = classNames(styles67.DatePicker);
  return import_react675.default.createElement("div", {
    id,
    className: datePickerClassName,
    onKeyDown: handleKeyDown2,
    onKeyUp: handleKeyUp
  }, import_react675.default.createElement("div", {
    className: styles67.Header
  }, import_react675.default.createElement(Button, {
    plain: true,
    icon: SvgArrowLeftMinor,
    accessibilityLabel: i18n.translate("Polaris.DatePicker.previousMonth", {
      previousMonthName,
      showPreviousYear
    }),
    onClick: () => handleMonthChangeClick(showPreviousMonth, showPreviousYear)
  }), import_react675.default.createElement(Button, {
    plain: true,
    icon: SvgArrowRightMinor,
    accessibilityLabel: i18n.translate("Polaris.DatePicker.nextMonth", {
      nextMonth,
      nextYear
    }),
    onClick: () => handleMonthChangeClick(showNextMonth, showNextYear)
  })), import_react675.default.createElement("div", {
    className: styles67.MonthLayout
  }, import_react675.default.createElement(Month, {
    onFocus: handleFocus,
    focusedDate: focusDate,
    month,
    year,
    selected: deriveRange(selected),
    hoverDate,
    onChange: handleDateSelection,
    onHover: handleHover,
    disableDatesBefore,
    disableDatesAfter,
    disableSpecificDates,
    allowRange,
    weekStartsOn,
    accessibilityLabelPrefixes
  }), secondDatePicker));
}
function noop12() {
}
function handleKeyDown2(event) {
  const {
    key
  } = event;
  if (key === "ArrowUp" || key === "ArrowDown" || key === "ArrowLeft" || key === "ArrowRight") {
    event.preventDefault();
    event.stopPropagation();
  }
}
function deriveRange(selected) {
  return selected instanceof Date ? {
    start: selected,
    end: selected
  } : selected;
}

// ../node_modules/@shopify/polaris/build/esm/components/DescriptionList/DescriptionList.js
var import_react676 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/DescriptionList/DescriptionList.scss.js
var styles68 = {
  "DescriptionList": "Polaris-DescriptionList",
  "Term": "Polaris-DescriptionList__Term",
  "spacingTight": "Polaris-DescriptionList--spacingTight",
  "Description": "Polaris-DescriptionList__Description"
};

// ../node_modules/@shopify/polaris/build/esm/components/DescriptionList/DescriptionList.js
function DescriptionList({
  items,
  spacing: spacing2 = "loose"
}) {
  const terms = items.reduce((allTerms, {
    term,
    description
  }, index) => [...allTerms, import_react676.default.createElement("dt", {
    key: `dt${index}`,
    className: styles68.Term
  }, import_react676.default.createElement(Text, {
    as: "span",
    variant: "headingSm"
  }, term)), import_react676.default.createElement("dd", {
    key: `dd${index}`,
    className: styles68.Description
  }, description)], []);
  const className = classNames(styles68.DescriptionList, spacing2 === "tight" && styles68.spacingTight);
  return import_react676.default.createElement("dl", {
    className
  }, terms);
}

// ../node_modules/@shopify/polaris/build/esm/components/DisplayText/DisplayText.js
var import_react677 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/DisplayText/DisplayText.scss.js
var styles69 = {
  "DisplayText": "Polaris-DisplayText",
  "sizeSmall": "Polaris-DisplayText--sizeSmall",
  "sizeMedium": "Polaris-DisplayText--sizeMedium",
  "sizeLarge": "Polaris-DisplayText--sizeLarge",
  "sizeExtraLarge": "Polaris-DisplayText--sizeExtraLarge"
};

// ../node_modules/@shopify/polaris/build/esm/components/DisplayText/DisplayText.js
function DisplayText({
  element: Element2 = "p",
  children: children2,
  size = "medium"
}) {
  const className = classNames(styles69.DisplayText, size && styles69[variationName("size", size)]);
  return import_react677.default.createElement(Element2, {
    className
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/Divider/Divider.js
var import_react678 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Divider/Divider.scss.js
var styles70 = {
  "Divider": "Polaris-Divider"
};

// ../node_modules/@shopify/polaris/build/esm/components/Divider/Divider.js
var Divider = ({
  borderColor = "border-subdued",
  borderWidth = "1"
}) => {
  const borderColorValue = borderColor === "transparent" ? borderColor : `var(--p-color-${borderColor})`;
  return import_react678.default.createElement("hr", {
    className: styles70.Divider,
    style: {
      borderBlockStart: `var(--p-border-width-${borderWidth}) solid ${borderColorValue}`
    }
  });
};

// ../node_modules/@shopify/polaris/build/esm/components/DropZone/DropZone.js
var import_react681 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/capitalize.js
function capitalize2(word = "") {
  const wordLower = word.toLowerCase();
  return wordLower.charAt(0).toUpperCase() + wordLower.slice(1);
}

// ../node_modules/@shopify/polaris/build/esm/components/DropZone/context.js
var import_react679 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/DropZone/utils/index.js
var dragEvents = ["dragover", "dragenter", "drop"];
function fileAccepted(file, accept) {
  return file.type === "application/x-moz-file" || accepts(file, accept);
}
function getDataTransferFiles(event) {
  if (isDragEvent(event) && event.dataTransfer) {
    const dt = event.dataTransfer;
    if (dt.files && dt.files.length) {
      return Array.from(dt.files);
    } else if (dt.items && dt.items.length) {
      return Array.from(dt.items);
    }
  } else if (isChangeEvent(event) && event.target.files) {
    return Array.from(event.target.files);
  }
  return [];
}
function accepts(file, acceptedFiles) {
  if (file && acceptedFiles) {
    const fileName = file.name || "";
    const mimeType = file.type || "";
    const baseMimeType = mimeType.replace(/\/.*$/, "");
    const acceptedFilesArray = Array.isArray(acceptedFiles) ? acceptedFiles : acceptedFiles.split(",");
    return acceptedFilesArray.some((type) => {
      const validType = type.trim();
      if (validType.startsWith(".")) {
        return fileName.toLowerCase().endsWith(validType.toLowerCase());
      } else if (validType.endsWith("/*")) {
        return baseMimeType === validType.replace(/\/.*$/, "");
      }
      return mimeType === validType;
    });
  }
  return true;
}
function isDragEvent(event) {
  return dragEvents.indexOf(event.type) > 0;
}
function isChangeEvent(event) {
  return Object.prototype.hasOwnProperty.call(event, "target");
}
var defaultAllowMultiple = true;
function createAllowMultipleKey(allowMultiple) {
  return allowMultiple ? "allowMultiple" : "single";
}

// ../node_modules/@shopify/polaris/build/esm/components/DropZone/context.js
var DropZoneContext = (0, import_react679.createContext)({
  disabled: false,
  focused: false,
  size: "extraLarge",
  type: "file",
  measuring: false,
  allowMultiple: defaultAllowMultiple
});

// ../node_modules/@shopify/polaris/build/esm/components/DropZone/DropZone.scss.js
var styles71 = {
  "DropZone": "Polaris-DropZone",
  "focused": "Polaris-DropZone--focused",
  "hasOutline": "Polaris-DropZone--hasOutline",
  "isDisabled": "Polaris-DropZone--isDisabled",
  "isDragging": "Polaris-DropZone--isDragging",
  "sizeLarge": "Polaris-DropZone--sizeLarge",
  "sizeMedium": "Polaris-DropZone--sizeMedium",
  "sizeSmall": "Polaris-DropZone--sizeSmall",
  "measuring": "Polaris-DropZone--measuring",
  "Container": "Polaris-DropZone__Container",
  "Overlay": "Polaris-DropZone__Overlay",
  "hasError": "Polaris-DropZone--hasError"
};

// ../node_modules/@shopify/polaris/build/esm/components/DropZone/components/FileUpload/FileUpload.js
var import_react680 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/DropZone/components/FileUpload/FileUpload.scss.js
var styles72 = {
  "FileUpload": "Polaris-DropZone-FileUpload",
  "large": "Polaris-DropZone-FileUpload--large",
  "small": "Polaris-DropZone-FileUpload--small",
  "Action": "Polaris-DropZone-FileUpload__Action",
  "disabled": "Polaris-DropZone-FileUpload--disabled",
  "ActionTitle": "Polaris-DropZone-FileUpload__ActionTitle",
  "ActionTitle-disabled": "Polaris-DropZone-FileUpload__ActionTitle--disabled",
  "ActionTitle-focused": "Polaris-DropZone-FileUpload__ActionTitle--focused"
};

// ../node_modules/@shopify/polaris/build/esm/components/DropZone/images/upload-arrow.svg.js
var img = "data:image/svg+xml,%3csvg fill='none' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20'%3e%3cpath fill-rule='evenodd' clip-rule='evenodd' d='M20 10a10 10 0 11-20 0 10 10 0 0120 0zM5.3 8.3l4-4a1 1 0 011.4 0l4 4a1 1 0 01-1.4 1.4L11 7.4V15a1 1 0 11-2 0V7.4L6.7 9.7a1 1 0 01-1.4-1.4z' fill='%235C5F62'/%3e%3c/svg%3e";
var uploadArrow = img;

// ../node_modules/@shopify/polaris/build/esm/components/DropZone/components/FileUpload/FileUpload.js
function FileUpload(props) {
  const i18n = useI18n();
  const {
    size,
    measuring,
    type,
    disabled,
    allowMultiple
  } = (0, import_react680.useContext)(DropZoneContext);
  const typeSuffix = capitalize2(type);
  const allowMultipleKey = createAllowMultipleKey(allowMultiple);
  const {
    actionTitle = i18n.translate(`Polaris.DropZone.${allowMultipleKey}.actionTitle${typeSuffix}`),
    actionHint
  } = props;
  const actionClassNames = classNames(styles72.Action, disabled && styles72.disabled);
  const actionMarkup = import_react680.default.createElement("div", {
    className: actionClassNames
  }, actionTitle);
  const fileUploadClassName = classNames(styles72.FileUpload, measuring && styles72.measuring, size === "large" && styles72.large, size === "small" && styles72.small);
  const actionHintMarkup = actionHint && import_react680.default.createElement(Text, {
    variant: "bodySm",
    as: "p",
    color: "subdued"
  }, actionHint);
  let viewMarkup;
  switch (size) {
    case "large":
      viewMarkup = import_react680.default.createElement(VerticalStack, {
        inlineAlign: "center",
        gap: "2"
      }, actionMarkup, actionHintMarkup);
      break;
    case "medium":
      viewMarkup = import_react680.default.createElement(VerticalStack, {
        inlineAlign: "center",
        gap: "2"
      }, actionMarkup, actionHintMarkup);
      break;
    case "small":
      viewMarkup = import_react680.default.createElement("img", {
        width: "20",
        src: uploadArrow,
        alt: ""
      });
      break;
  }
  return import_react680.default.createElement("div", {
    className: fileUploadClassName
  }, viewMarkup);
}

// ../node_modules/@shopify/polaris/build/esm/components/DropZone/DropZone.js
var DropZone = function DropZone2({
  dropOnPage,
  label,
  labelAction,
  labelHidden,
  children: children2,
  disabled = false,
  outline = true,
  accept,
  active,
  overlay: overlay2 = true,
  allowMultiple = defaultAllowMultiple,
  overlayText,
  errorOverlayText,
  id: idProp,
  type = "file",
  onClick,
  error,
  openFileDialog,
  variableHeight,
  onFileDialogClose,
  customValidator,
  onDrop,
  onDropAccepted,
  onDropRejected,
  onDragEnter,
  onDragOver,
  onDragLeave
}) {
  const node = (0, import_react681.useRef)(null);
  const inputRef = (0, import_react681.useRef)(null);
  const dragTargets = (0, import_react681.useRef)([]);
  const adjustSize = (0, import_react681.useCallback)(debounce(() => {
    if (!node.current) {
      return;
    }
    if (variableHeight) {
      setMeasuring(false);
      return;
    }
    let size2 = "large";
    const width = node.current.getBoundingClientRect().width;
    if (width < 100) {
      size2 = "small";
    } else if (width < 160) {
      size2 = "medium";
    }
    setSize(size2);
    measuring && setMeasuring(false);
  }, 50, {
    trailing: true
  }), []);
  const [dragging, setDragging] = (0, import_react681.useState)(false);
  const [internalError, setInternalError] = (0, import_react681.useState)(false);
  const {
    value: focused,
    setTrue: handleFocus,
    setFalse: handleBlur
  } = useToggle(false);
  const [size, setSize] = (0, import_react681.useState)("large");
  const [measuring, setMeasuring] = (0, import_react681.useState)(true);
  const i18n = useI18n();
  const getValidatedFiles = (0, import_react681.useCallback)((files) => {
    const acceptedFiles = [];
    const rejectedFiles = [];
    Array.from(files).forEach((file) => {
      !fileAccepted(file, accept) || customValidator && !customValidator(file) ? rejectedFiles.push(file) : acceptedFiles.push(file);
    });
    if (!allowMultiple) {
      acceptedFiles.splice(1, acceptedFiles.length);
      rejectedFiles.push(...acceptedFiles.slice(1));
    }
    return {
      files,
      acceptedFiles,
      rejectedFiles
    };
  }, [accept, allowMultiple, customValidator]);
  const handleDrop = (0, import_react681.useCallback)((event) => {
    stopEvent(event);
    if (disabled)
      return;
    const fileList = getDataTransferFiles(event);
    const {
      files,
      acceptedFiles,
      rejectedFiles
    } = getValidatedFiles(fileList);
    dragTargets.current = [];
    setDragging(false);
    setInternalError(rejectedFiles.length > 0);
    onDrop && onDrop(files, acceptedFiles, rejectedFiles);
    onDropAccepted && acceptedFiles.length && onDropAccepted(acceptedFiles);
    onDropRejected && rejectedFiles.length && onDropRejected(rejectedFiles);
    if (!(event.target && "value" in event.target))
      return;
    event.target.value = "";
  }, [disabled, getValidatedFiles, onDrop, onDropAccepted, onDropRejected]);
  const handleDragEnter = (0, import_react681.useCallback)((event) => {
    stopEvent(event);
    if (disabled)
      return;
    const fileList = getDataTransferFiles(event);
    if (event.target && !dragTargets.current.includes(event.target)) {
      dragTargets.current.push(event.target);
    }
    if (dragging)
      return;
    const {
      rejectedFiles
    } = getValidatedFiles(fileList);
    setDragging(true);
    setInternalError(rejectedFiles.length > 0);
    onDragEnter && onDragEnter();
  }, [disabled, dragging, getValidatedFiles, onDragEnter]);
  const handleDragOver = (0, import_react681.useCallback)((event) => {
    stopEvent(event);
    if (disabled)
      return;
    onDragOver && onDragOver();
  }, [disabled, onDragOver]);
  const handleDragLeave = (0, import_react681.useCallback)((event) => {
    event.preventDefault();
    if (disabled)
      return;
    dragTargets.current = dragTargets.current.filter((el) => {
      const compareNode = dropOnPage && !isServer ? document : node.current;
      return el !== event.target && compareNode && compareNode.contains(el);
    });
    if (dragTargets.current.length > 0)
      return;
    setDragging(false);
    setInternalError(false);
    onDragLeave && onDragLeave();
  }, [dropOnPage, disabled, onDragLeave]);
  const dropNode = dropOnPage && !isServer ? document : node.current;
  useEventListener("drop", handleDrop, dropNode);
  useEventListener("dragover", handleDragOver, dropNode);
  useEventListener("dragenter", handleDragEnter, dropNode);
  useEventListener("dragleave", handleDragLeave, dropNode);
  useEventListener("resize", adjustSize, isServer ? null : window);
  useComponentDidMount(() => {
    adjustSize();
  });
  const id = useUniqueId("DropZone", idProp);
  const typeSuffix = capitalize2(type);
  const allowMultipleKey = createAllowMultipleKey(allowMultiple);
  const overlayTextWithDefault = overlayText === void 0 ? i18n.translate(`Polaris.DropZone.${allowMultipleKey}.overlayText${typeSuffix}`) : overlayText;
  const errorOverlayTextWithDefault = errorOverlayText === void 0 ? i18n.translate(`Polaris.DropZone.errorOverlayText${typeSuffix}`) : errorOverlayText;
  const labelValue = label || i18n.translate(`Polaris.DropZone.${allowMultipleKey}.label${typeSuffix}`);
  const labelHiddenValue = label ? labelHidden : true;
  const classes = classNames(styles71.DropZone, outline && styles71.hasOutline, focused && styles71.focused, (active || dragging) && styles71.isDragging, disabled && styles71.isDisabled, (internalError || error) && styles71.hasError, !variableHeight && styles71[variationName("size", size)], measuring && styles71.measuring);
  const dragOverlay = (active || dragging) && !internalError && !error && overlay2 && overlayMarkup(SvgUploadMajor, "interactive", overlayTextWithDefault);
  const dragErrorOverlay = dragging && (internalError || error) && overlayMarkup(SvgCircleAlertMajor, "critical", errorOverlayTextWithDefault);
  const context = (0, import_react681.useMemo)(() => ({
    disabled,
    focused,
    size,
    type: type || "file",
    measuring,
    allowMultiple
  }), [disabled, focused, measuring, size, type, allowMultiple]);
  const open = (0, import_react681.useCallback)(() => {
    if (!inputRef.current)
      return;
    inputRef.current.click();
  }, [inputRef]);
  const triggerFileDialog = (0, import_react681.useCallback)(() => {
    open();
    onFileDialogClose === null || onFileDialogClose === void 0 ? void 0 : onFileDialogClose();
  }, [open, onFileDialogClose]);
  function overlayMarkup(icon, color2, text) {
    return import_react681.default.createElement("div", {
      className: styles71.Overlay
    }, import_react681.default.createElement(VerticalStack, {
      gap: "2",
      inlineAlign: "center"
    }, size === "small" && import_react681.default.createElement(Icon, {
      source: icon,
      color: color2
    }), (size === "medium" || size === "large") && import_react681.default.createElement(Text, {
      variant: "bodySm",
      as: "p",
      fontWeight: "bold"
    }, text)));
  }
  function handleClick(event) {
    if (disabled)
      return;
    return onClick ? onClick(event) : open();
  }
  (0, import_react681.useEffect)(() => {
    if (openFileDialog)
      triggerFileDialog();
  }, [openFileDialog, triggerFileDialog]);
  return import_react681.default.createElement(DropZoneContext.Provider, {
    value: context
  }, import_react681.default.createElement(Labelled, {
    id,
    label: labelValue,
    action: labelAction,
    labelHidden: labelHiddenValue
  }, import_react681.default.createElement("div", {
    ref: node,
    className: classes,
    "aria-disabled": disabled,
    onClick: handleClick,
    onDragStart: stopEvent
  }, dragOverlay, dragErrorOverlay, import_react681.default.createElement(Text, {
    variant: "bodySm",
    as: "span",
    visuallyHidden: true
  }, import_react681.default.createElement("input", {
    id,
    accept,
    disabled,
    multiple: allowMultiple,
    onChange: handleDrop,
    onFocus: handleFocus,
    onBlur: handleBlur,
    type: "file",
    ref: inputRef,
    autoComplete: "off"
  })), import_react681.default.createElement("div", {
    className: styles71.Container
  }, children2))));
};
function stopEvent(event) {
  event.preventDefault();
  event.stopPropagation();
}
DropZone.FileUpload = FileUpload;

// ../node_modules/@shopify/polaris/build/esm/components/EmptySearchResult/EmptySearchResult.js
var import_react682 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/EmptySearchResult/illustrations/empty-search.svg.js
var img2 = "data:image/svg+xml,%3csvg width='60' height='60' fill='none' xmlns='http://www.w3.org/2000/svg'%3e%3cpath fill-rule='evenodd' clip-rule='evenodd' d='M41.87 24a17.87 17.87 0 11-35.74 0 17.87 17.87 0 0135.74 0zm-3.15 18.96a24 24 0 114.24-4.24L59.04 54.8a3 3 0 11-4.24 4.24L38.72 42.96z' fill='%238C9196'/%3e%3c/svg%3e";
var emptySearch = img2;

// ../node_modules/@shopify/polaris/build/esm/components/EmptySearchResult/EmptySearchResult.js
function EmptySearchResult({
  title,
  description,
  withIllustration
}) {
  const i18n = useI18n();
  const altText = i18n.translate("Polaris.EmptySearchResult.altText");
  const descriptionMarkup = description ? import_react682.default.createElement("p", null, description) : null;
  const illustrationMarkup = withIllustration ? import_react682.default.createElement(Image, {
    alt: altText,
    source: emptySearch,
    draggable: false
  }) : null;
  return import_react682.default.createElement(LegacyStack, {
    alignment: "center",
    vertical: true
  }, illustrationMarkup, import_react682.default.createElement(Text, {
    variant: "headingLg",
    as: "p"
  }, title), import_react682.default.createElement(Text, {
    color: "subdued",
    as: "span"
  }, descriptionMarkup));
}

// ../node_modules/@shopify/polaris/build/esm/components/EmptyState/EmptyState.js
var import_react683 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/EmptyState/EmptyState.scss.js
var styles73 = {
  "imageContained": "Polaris-EmptyState--imageContained"
};

// ../node_modules/@shopify/polaris/build/esm/components/EmptyState/EmptyState.js
function EmptyState({
  children: children2,
  heading,
  image,
  largeImage,
  imageContained,
  fullWidth = false,
  action,
  secondaryAction,
  footerContent
}) {
  const withinContentContainer = (0, import_react683.useContext)(WithinContentContext);
  const imageContainedClass = classNames(imageContained && styles73.imageContained);
  const imageMarkup = largeImage ? import_react683.default.createElement(Image, {
    alt: "",
    role: "presentation",
    source: largeImage,
    className: imageContainedClass,
    sourceSet: [{
      source: image,
      descriptor: "568w"
    }, {
      source: largeImage,
      descriptor: "1136w"
    }],
    sizes: "(max-width: 568px) 60vw"
  }) : import_react683.default.createElement(Image, {
    className: imageContainedClass,
    role: "presentation",
    alt: "",
    source: image
  });
  const secondaryActionMarkup = secondaryAction ? buttonFrom(secondaryAction, {}) : null;
  const footerContentMarkup = footerContent ? import_react683.default.createElement(Box, {
    paddingBlockStart: "4"
  }, import_react683.default.createElement(Text, {
    as: "span",
    color: "subdued",
    alignment: "center"
  }, footerContent)) : null;
  const headingSize = withinContentContainer ? "headingLg" : "headingXl";
  const primaryActionMarkup = action ? buttonFrom(action, {
    primary: true,
    size: "medium"
  }) : null;
  const headingMarkup = heading ? import_react683.default.createElement(Box, {
    paddingBlockEnd: "4"
  }, import_react683.default.createElement(Text, {
    variant: headingSize,
    as: "p",
    alignment: "center"
  }, heading)) : null;
  const childrenMarkup = children2 ? import_react683.default.createElement(Text, {
    as: "span",
    color: "subdued",
    alignment: "center"
  }, children2) : null;
  const textContentMarkup = headingMarkup || children2 ? import_react683.default.createElement(Box, {
    paddingBlockEnd: "6"
  }, headingMarkup, childrenMarkup) : null;
  const actionsMarkup = primaryActionMarkup || secondaryActionMarkup ? import_react683.default.createElement(HorizontalStack, {
    align: "center",
    gap: "2"
  }, secondaryActionMarkup, primaryActionMarkup) : null;
  const detailsMarkup = textContentMarkup || actionsMarkup || footerContentMarkup ? import_react683.default.createElement(Box, {
    maxWidth: fullWidth ? "100%" : "400px"
  }, import_react683.default.createElement(VerticalStack, {
    inlineAlign: "center"
  }, textContentMarkup, actionsMarkup, footerContentMarkup)) : null;
  return import_react683.default.createElement(Box, {
    paddingInlineStart: "0",
    paddingInlineEnd: "0",
    paddingBlockStart: "5",
    paddingBlockEnd: "16"
  }, import_react683.default.createElement(VerticalStack, {
    inlineAlign: "center"
  }, imageMarkup, detailsMarkup));
}

// ../node_modules/@shopify/polaris/build/esm/components/ExceptionList/ExceptionList.js
var import_react685 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/ExceptionList/ExceptionList.scss.js
var styles74 = {
  "ExceptionList": "Polaris-ExceptionList",
  "Item": "Polaris-ExceptionList__Item",
  "Icon": "Polaris-ExceptionList__Icon",
  "statusWarning": "Polaris-ExceptionList--statusWarning",
  "statusCritical": "Polaris-ExceptionList--statusCritical",
  "Bullet": "Polaris-ExceptionList__Bullet",
  "Title": "Polaris-ExceptionList__Title",
  "Description": "Polaris-ExceptionList__Description"
};

// ../node_modules/@shopify/polaris/build/esm/components/Truncate/Truncate.js
var import_react684 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Truncate/Truncate.scss.js
var styles75 = {
  "Truncate": "Polaris-Truncate"
};

// ../node_modules/@shopify/polaris/build/esm/components/Truncate/Truncate.js
function Truncate({
  children: children2
}) {
  return import_react684.default.createElement("span", {
    className: styles75.Truncate
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/ExceptionList/ExceptionList.js
function ExceptionList({
  items: itemsList
}) {
  const items = itemsList.map((item, index) => {
    const {
      status,
      icon,
      title,
      description,
      truncate = false
    } = item;
    const itemClasses = classNames(styles74.Item, status && styles74[variationName("status", status)]);
    const iconMarkup = icon ? import_react685.default.createElement(Icon, {
      source: icon
    }) : import_react685.default.createElement("span", {
      className: styles74.Bullet
    });
    const titleMarkup = title && import_react685.default.createElement("span", {
      className: styles74.Title
    }, title);
    const descriptionMarkup = description && import_react685.default.createElement("span", {
      className: styles74.Description
    }, description);
    const Element2 = truncate ? Truncate : import_react685.Fragment;
    return import_react685.default.createElement("li", {
      className: itemClasses,
      key: index
    }, import_react685.default.createElement("span", {
      className: styles74.Icon
    }, iconMarkup), import_react685.default.createElement(Element2, null, titleMarkup, descriptionMarkup));
  });
  return import_react685.default.createElement("ul", {
    className: styles74.ExceptionList
  }, items);
}

// ../node_modules/@shopify/polaris/build/esm/components/Filters/Filters.js
var import_react693 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Filters/Filters.scss.js
var styles76 = {
  "Filters": "Polaris-Filters",
  "FiltersContainer": "Polaris-Filters__FiltersContainer",
  "FiltersContainerHeader": "Polaris-Filters__FiltersContainerHeader",
  "FiltersDesktopContainerContent": "Polaris-Filters__FiltersDesktopContainerContent",
  "FiltersMobileContainerContent": "Polaris-Filters__FiltersMobileContainerContent",
  "FiltersContainerFooter": "Polaris-Filters__FiltersContainerFooter",
  "FiltersMobileContainerFooter": "Polaris-Filters__FiltersMobileContainerFooter",
  "EmptyFooterState": "Polaris-Filters__EmptyFooterState",
  "FilterTriggerContainer": "Polaris-Filters__FilterTriggerContainer",
  "FilterTrigger": "Polaris-Filters__FilterTrigger",
  "FilterTriggerTitle": "Polaris-Filters__FilterTriggerTitle",
  "AppliedFilterBadgeContainer": "Polaris-Filters__AppliedFilterBadgeContainer",
  "open": "Polaris-Filters--open",
  "FilterTriggerLabelContainer": "Polaris-Filters__FilterTriggerLabelContainer",
  "first": "Polaris-Filters--first",
  "last": "Polaris-Filters--last",
  "FilterNodeContainer": "Polaris-Filters__FilterNodeContainer",
  "SearchIcon": "Polaris-Filters__SearchIcon",
  "Backdrop": "Polaris-Filters__Backdrop",
  "HelpText": "Polaris-Filters__HelpText",
  "TagsContainer": "Polaris-Filters__TagsContainer"
};

// ../node_modules/@shopify/polaris/build/esm/utilities/resource-list/context.js
var import_react686 = __toESM(require_react());
var ResourceListContext = (0, import_react686.createContext)({});

// ../node_modules/@shopify/polaris/build/esm/components/Filters/components/ConnectedFilterControl/ConnectedFilterControl.js
var import_react688 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Filters/components/ConnectedFilterControl/ConnectedFilterControl.scss.js
var styles77 = {
  "ConnectedFilterControl": "Polaris-Filters-ConnectedFilterControl",
  "CenterContainer": "Polaris-Filters-ConnectedFilterControl__CenterContainer",
  "right": "Polaris-Filters-ConnectedFilterControl--right",
  "Item": "Polaris-Filters-ConnectedFilterControl__Item",
  "Item-focused": "Polaris-Filters-ConnectedFilterControl__Item--focused",
  "ProxyButtonContainer": "Polaris-Filters-ConnectedFilterControl__ProxyButtonContainer",
  "RightContainer": "Polaris-Filters-ConnectedFilterControl__RightContainer",
  "MoreFiltersButtonContainer": "Polaris-Filters-ConnectedFilterControl__MoreFiltersButtonContainer",
  "queryFieldHidden": "Polaris-Filters-ConnectedFilterControl--queryFieldHidden",
  "RightContainerWithoutMoreFilters": "Polaris-Filters-ConnectedFilterControl__RightContainerWithoutMoreFilters",
  "onlyButtonVisible": "Polaris-Filters-ConnectedFilterControl--onlyButtonVisible",
  "Wrapper": "Polaris-Filters-ConnectedFilterControl__Wrapper",
  "AuxiliaryContainer": "Polaris-Filters-ConnectedFilterControl__AuxiliaryContainer"
};

// ../node_modules/@shopify/polaris/build/esm/components/Filters/components/ConnectedFilterControl/components/Item/Item.js
var import_react687 = __toESM(require_react());
function Item8({
  children: children2
}) {
  const {
    value: focused,
    setTrue: forceTrueFocused,
    setFalse: forceFalseFocused
  } = useToggle(false);
  const className = classNames(styles77.Item, focused && styles77["Item-focused"]);
  return import_react687.default.createElement("div", {
    onBlur: forceFalseFocused,
    onFocus: forceTrueFocused,
    className
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/Filters/components/ConnectedFilterControl/ConnectedFilterControl.js
var FILTER_FIELD_MIN_WIDTH = 150;
var ConnectedFilterControl = class extends import_react688.Component {
  constructor(...args) {
    super(...args);
    this.state = {
      availableWidth: 0,
      proxyButtonsWidth: {}
    };
    this.container = (0, import_react688.createRef)();
    this.proxyButtonContainer = (0, import_react688.createRef)();
    this.moreFiltersButtonContainer = (0, import_react688.createRef)();
    this.handleResize = debounce(() => {
      this.measureProxyButtons();
      this.measureAvailableWidth();
    }, 40, {
      leading: true,
      trailing: true,
      maxWait: 40
    });
  }
  componentDidMount() {
    this.handleResize();
  }
  render() {
    const {
      children: children2,
      rightPopoverableActions,
      rightAction,
      auxiliary,
      forceShowMorefiltersButton = true,
      queryFieldHidden
    } = this.props;
    const actionsToRender = rightPopoverableActions != null ? this.getActionsToRender(rightPopoverableActions) : [];
    const className = classNames(styles77.ConnectedFilterControl, rightPopoverableActions && styles77.right);
    const shouldRenderMoreFiltersButton = forceShowMorefiltersButton || rightPopoverableActions && rightPopoverableActions.length !== actionsToRender.length;
    const RightContainerClassName = classNames(styles77.RightContainer, !shouldRenderMoreFiltersButton && styles77.RightContainerWithoutMoreFilters, queryFieldHidden && styles77.queryFieldHidden);
    const rightMarkup = actionsToRender.length > 0 ? import_react688.default.createElement("div", {
      className: RightContainerClassName
    }, this.popoverFrom(actionsToRender)) : null;
    const moreFiltersButtonContainerClassname = classNames(styles77.MoreFiltersButtonContainer, actionsToRender.length === 0 && styles77.onlyButtonVisible);
    const rightActionMarkup = rightAction ? import_react688.default.createElement("div", {
      ref: this.moreFiltersButtonContainer,
      className: moreFiltersButtonContainerClassname
    }, shouldRenderMoreFiltersButton && import_react688.default.createElement(Item8, null, rightAction)) : null;
    const proxyButtonMarkup = rightPopoverableActions ? import_react688.default.createElement("div", {
      className: styles77.ProxyButtonContainer,
      ref: this.proxyButtonContainer,
      "aria-hidden": true
    }, rightPopoverableActions.map((action) => import_react688.default.createElement("div", {
      key: action.key,
      "data-key": action.key
    }, this.activatorButtonFrom(action, {
      proxy: true
    })))) : null;
    const auxMarkup = auxiliary ? import_react688.default.createElement("div", {
      className: styles77.AuxiliaryContainer
    }, auxiliary) : null;
    return import_react688.default.createElement(import_react688.default.Fragment, null, proxyButtonMarkup, import_react688.default.createElement("div", {
      className: styles77.Wrapper
    }, import_react688.default.createElement("div", {
      className,
      ref: this.container
    }, children2 ? import_react688.default.createElement("div", {
      className: styles77.CenterContainer
    }, import_react688.default.createElement(Item8, null, children2)) : null, rightMarkup, rightActionMarkup, import_react688.default.createElement(EventListener, {
      event: "resize",
      handler: this.handleResize
    })), auxMarkup));
  }
  measureProxyButtons() {
    if (this.proxyButtonContainer.current) {
      const proxyButtonsWidth = {};
      const tolerance = 78;
      if (this.proxyButtonContainer.current) {
        Array.from(this.proxyButtonContainer.current.children).forEach((element) => {
          const buttonWidth = element.getBoundingClientRect().width + tolerance;
          const buttonKey = element instanceof HTMLElement && element.dataset.key;
          if (buttonKey) {
            proxyButtonsWidth[buttonKey] = buttonWidth;
          }
        });
      }
      this.setState({
        proxyButtonsWidth
      });
    }
  }
  measureAvailableWidth() {
    if (this.container.current && this.moreFiltersButtonContainer.current) {
      const containerWidth = this.container.current.getBoundingClientRect().width;
      const moreFiltersButtonWidth = this.moreFiltersButtonContainer.current.getBoundingClientRect().width;
      const filtersActionWidth = 0;
      const filterFieldMinWidth = this.props.queryFieldHidden ? 0 : FILTER_FIELD_MIN_WIDTH;
      const availableWidth = containerWidth - filterFieldMinWidth - moreFiltersButtonWidth - filtersActionWidth;
      this.setState({
        availableWidth
      });
    }
  }
  getActionsToRender(actions) {
    let remainingWidth = this.state.availableWidth;
    const actionsToReturn = [];
    for (let i = 0; remainingWidth > 0 && i < actions.length; i++) {
      const action = actions[i];
      const actionWidth = this.state.proxyButtonsWidth[action.key];
      if (actionWidth <= remainingWidth) {
        actionsToReturn.push(action);
        remainingWidth -= actionWidth;
      } else {
        break;
      }
    }
    return actionsToReturn;
  }
  activatorButtonFrom(action, options) {
    const id = options !== null && options !== void 0 && options.proxy ? void 0 : `Activator-${action.key}`;
    return import_react688.default.createElement(Button, {
      onClick: action.onAction,
      disclosure: true,
      disabled: this.props.disabled || action.disabled,
      id
    }, action.content);
  }
  popoverFrom(actions) {
    return actions.map((action) => {
      return import_react688.default.createElement(Item8, {
        key: action.key
      }, import_react688.default.createElement(Popover2, {
        active: action.popoverOpen,
        activator: this.activatorButtonFrom(action),
        onClose: action.onAction,
        preferredAlignment: "left",
        sectioned: true
      }, action.popoverContent));
    });
  }
};

// ../node_modules/@shopify/polaris/build/esm/components/Filters/components/TagsWrapper/TagsWrapper.js
var import_react689 = __toESM(require_react());
function TagsWrapper({
  children: children2,
  hidden
}) {
  if (hidden) {
    return import_react689.default.createElement(Text, {
      as: "span",
      visuallyHidden: true
    }, children2);
  }
  return import_react689.default.createElement(import_react689.default.Fragment, null, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/Tag/Tag.js
var import_react690 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Tag/Tag.scss.js
var styles78 = {
  "Tag": "Polaris-Tag",
  "disabled": "Polaris-Tag--disabled",
  "clickable": "Polaris-Tag--clickable",
  "removable": "Polaris-Tag--removable",
  "linkable": "Polaris-Tag--linkable",
  "TagText": "Polaris-Tag__TagText",
  "Button": "Polaris-Tag__Button",
  "segmented": "Polaris-Tag--segmented",
  "Link": "Polaris-Tag__Link",
  "LinkText": "Polaris-Tag__LinkText"
};

// ../node_modules/@shopify/polaris/build/esm/components/Tag/Tag.js
function Tag({
  children: children2,
  disabled = false,
  onClick,
  onRemove,
  accessibilityLabel,
  url
}) {
  const i18n = useI18n();
  const segmented = onRemove && url;
  const className = classNames(styles78.Tag, disabled && styles78.disabled, onClick && styles78.clickable, onRemove && styles78.removable, url && !disabled && styles78.linkable, segmented && styles78.segmented);
  if (onClick) {
    return import_react690.default.createElement("button", {
      type: "button",
      disabled,
      className,
      onClick
    }, children2);
  }
  let tagTitle = accessibilityLabel;
  if (!tagTitle) {
    tagTitle = typeof children2 === "string" ? children2 : void 0;
  }
  const ariaLabel = i18n.translate("Polaris.Tag.ariaLabel", {
    children: tagTitle || ""
  });
  const removeButton = onRemove ? import_react690.default.createElement("button", {
    type: "button",
    "aria-label": ariaLabel,
    className: classNames(styles78.Button, segmented && styles78.segmented),
    onClick: onRemove,
    onMouseUp: handleMouseUpByBlurring,
    disabled
  }, import_react690.default.createElement(Icon, {
    source: SvgCancelSmallMinor
  })) : null;
  const tagContent = url && !disabled ? import_react690.default.createElement("a", {
    className: classNames(styles78.Link, segmented && styles78.segmented),
    href: url
  }, import_react690.default.createElement("span", {
    title: tagTitle,
    className: styles78.LinkText
  }, children2)) : import_react690.default.createElement("span", {
    title: tagTitle,
    className: styles78.TagText
  }, children2);
  return import_react690.default.createElement("span", {
    className
  }, tagContent, removeButton);
}

// ../node_modules/@shopify/polaris/build/esm/components/Sheet/Sheet.js
var import_react692 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Sheet/Sheet.scss.js
var styles79 = {
  "Sheet": "Polaris-Sheet",
  "Container": "Polaris-Sheet__Container",
  "Bottom": "Polaris-Sheet__Bottom",
  "enterBottom": "Polaris-Sheet--enterBottom",
  "enterBottomActive": "Polaris-Sheet--enterBottomActive",
  "exitBottom": "Polaris-Sheet--exitBottom",
  "exitBottomActive": "Polaris-Sheet--exitBottomActive",
  "Right": "Polaris-Sheet__Right",
  "enterRight": "Polaris-Sheet--enterRight",
  "enterRightActive": "Polaris-Sheet--enterRightActive",
  "exitRight": "Polaris-Sheet--exitRight",
  "exitRightActive": "Polaris-Sheet--exitRightActive"
};

// ../node_modules/@shopify/polaris/build/esm/utilities/media-query/hooks.js
var import_react691 = __toESM(require_react());
function useMediaQuery() {
  const mediaQuery = (0, import_react691.useContext)(MediaQueryContext);
  if (!mediaQuery) {
    throw new Error("No mediaQuery was provided. Your application must be wrapped in an <AppProvider> component. See https://polaris.shopify.com/components/app-provider for implementation instructions.");
  }
  return mediaQuery;
}

// ../node_modules/@shopify/polaris/build/esm/components/Sheet/Sheet.js
var BOTTOM_CLASS_NAMES = {
  enter: classNames(styles79.Bottom, styles79.enterBottom),
  enterActive: classNames(styles79.Bottom, styles79.enterBottomActive),
  exit: classNames(styles79.Bottom, styles79.exitBottom),
  exitActive: classNames(styles79.Bottom, styles79.exitBottomActive)
};
var RIGHT_CLASS_NAMES = {
  enter: classNames(styles79.Right, styles79.enterRight),
  enterActive: classNames(styles79.Right, styles79.enterRightActive),
  exit: classNames(styles79.Right, styles79.exitRight),
  exitActive: classNames(styles79.Right, styles79.exitRightActive)
};
function Sheet({
  children: children2,
  open,
  onClose,
  onEntered,
  onExit,
  accessibilityLabel,
  activator
}) {
  const {
    isNavigationCollapsed
  } = useMediaQuery();
  const container = (0, import_react692.useRef)(null);
  const activatorRef = (0, import_react692.useRef)(null);
  const handleClose = (0, import_react692.useCallback)(() => {
    onClose();
    const activatorElement = activator && isRef3(activator) ? activator && activator.current : activatorRef.current;
    if (activatorElement) {
      requestAnimationFrame(() => focusFirstFocusableNode(activatorElement));
    }
  }, [activator, onClose]);
  (0, import_react692.useEffect)(() => {
    if (true) {
      console.warn("Deprecation: <Sheet /> is deprecated. This component might be removed in a future major version of Polaris. Use <Modal /> instead or avoid modal patterns all together.");
    }
  }, []);
  const activatorMarkup = activator && !isRef3(activator) ? import_react692.default.createElement("div", {
    ref: activatorRef
  }, activator) : null;
  return import_react692.default.createElement(import_react692.default.Fragment, null, activatorMarkup, import_react692.default.createElement(Portal, {
    idPrefix: "sheet"
  }, import_react692.default.createElement(CSSTransition_default, {
    nodeRef: container,
    classNames: isNavigationCollapsed ? BOTTOM_CLASS_NAMES : RIGHT_CLASS_NAMES,
    timeout: parseInt(motion2["duration-300"], 10),
    in: open,
    mountOnEnter: true,
    unmountOnExit: true,
    onEntered,
    onExit
  }, import_react692.default.createElement("div", Object.assign({
    className: styles79.Container
  }, layer.props, overlay.props, {
    ref: container
  }), import_react692.default.createElement(TrapFocus, {
    trapping: open
  }, import_react692.default.createElement("div", {
    role: "dialog",
    "aria-modal": true,
    tabIndex: -1,
    className: styles79.Sheet,
    "aria-label": accessibilityLabel
  }, children2)))), import_react692.default.createElement(KeypressListener, {
    keyCode: Key.Escape,
    handler: handleClose
  }), open && import_react692.default.createElement(Backdrop, {
    transparent: true,
    onClick: handleClose
  })));
}
function isRef3(ref) {
  return Object.prototype.hasOwnProperty.call(ref, "current");
}

// ../node_modules/@shopify/polaris/build/esm/components/Filters/Filters.js
var Suffix;
(function(Suffix3) {
  Suffix3["Filter"] = "Filter";
  Suffix3["Shortcut"] = "Shortcut";
})(Suffix || (Suffix = {}));
var FiltersInner = class extends import_react693.Component {
  constructor(...args) {
    super(...args);
    this.context = void 0;
    this.state = {
      open: false,
      readyForFocus: false
    };
    this.moreFiltersButtonContainer = (0, import_react693.createRef)();
    this.moreFiltersDoneButtonContainer = (0, import_react693.createRef)();
    this.focusNode = (0, import_react693.createRef)();
    this.closeFilters = () => {
      this.setState({
        open: false
      }, () => {
        if (this.moreFiltersButtonContainer.current) {
          focusFirstFocusableNode(this.moreFiltersButtonContainer.current, false);
        }
      });
    };
    this.toggleFilters = () => {
      if (this.state.open === true) {
        this.closeFilters();
      } else {
        this.openFilters();
      }
    };
    this.setReadyForFocus = (newState) => () => {
      this.setState({
        readyForFocus: newState
      });
    };
    this.handleClearAll = () => {
      this.props.onClearAll();
      this.moreFiltersDoneButtonContainer.current && focusFirstFocusableNode(this.moreFiltersDoneButtonContainer.current, false);
    };
  }
  render() {
    const {
      filters,
      queryValue,
      onQueryBlur,
      onQueryChange,
      onQueryFocus,
      focused,
      onClearAll,
      appliedFilters,
      onQueryClear,
      queryPlaceholder,
      children: children2,
      disabled = false,
      helpText,
      hideTags,
      hideQueryField,
      disableQueryField = false,
      i18n,
      mediaQuery: {
        isNavigationCollapsed
      }
    } = this.props;
    const {
      resourceName
    } = this.context;
    const {
      open,
      readyForFocus
    } = this.state;
    const backdropMarkup = open ? import_react693.default.createElement(import_react693.default.Fragment, null, import_react693.default.createElement(ScrollLock, null), import_react693.default.createElement("div", {
      className: styles76.Backdrop,
      onClick: this.closeFilters
    })) : null;
    const filtersContentMarkup = filters.map((filter, index) => {
      const filterIsOpen = this.state[`${filter.key}${Suffix.Filter}`] === true;
      const icon = filterIsOpen ? SvgChevronUpMinor : SvgChevronDownMinor;
      const className = classNames(styles76.FilterTriggerContainer, filterIsOpen && styles76.open, index === 0 && styles76.first, filters.length !== 1 && index === filters.length - 1 && styles76.last);
      const appliedFilterContent = this.getAppliedFilterContent(filter.key);
      const appliedFilterBadgeMarkup = appliedFilterContent ? import_react693.default.createElement("div", {
        className: styles76.AppliedFilterBadgeContainer
      }, import_react693.default.createElement(Badge, {
        status: "new"
      }, appliedFilterContent)) : null;
      const collapsibleID = `${filter.key}Collapsible`;
      const buttonClassName = classNames(styles76.FilterTrigger);
      return import_react693.default.createElement("div", {
        key: filter.key,
        className
      }, import_react693.default.createElement("button", {
        onClick: () => this.toggleFilter(filter.key),
        className: buttonClassName,
        id: `${filter.key}ToggleButton`,
        type: "button",
        "aria-controls": collapsibleID,
        "aria-expanded": filterIsOpen
      }, import_react693.default.createElement("div", {
        className: styles76.FilterTriggerLabelContainer
      }, import_react693.default.createElement("h3", {
        className: styles76.FilterTriggerTitle
      }, import_react693.default.createElement(Text, {
        as: "span",
        color: this.props.disabled || filter.disabled ? "subdued" : void 0
      }, filter.label)), import_react693.default.createElement("span", {
        className: styles76.FilterTriggerIcon
      }, import_react693.default.createElement(Icon, {
        source: icon,
        color: "base"
      }))), appliedFilterBadgeMarkup), import_react693.default.createElement(Collapsible, {
        id: collapsibleID,
        open: filterIsOpen,
        onAnimationEnd: this.setReadyForFocus(true)
      }, import_react693.default.createElement("div", {
        className: styles76.FilterNodeContainer
      }, import_react693.default.createElement(Focus, {
        disabled: !filterIsOpen || !readyForFocus || !open,
        root: this.focusNode
      }, this.generateFilterMarkup(filter)))));
    });
    const appliedFiltersCount = appliedFilters ? appliedFilters.length : 0;
    const moreFiltersLabel = hideTags && appliedFiltersCount > 0 ? i18n.translate("Polaris.Filters.moreFiltersWithCount", {
      count: appliedFiltersCount
    }) : i18n.translate("Polaris.Filters.moreFilters");
    const rightActionMarkup = filters.length ? import_react693.default.createElement("div", {
      ref: this.moreFiltersButtonContainer
    }, import_react693.default.createElement(Button, {
      onClick: this.toggleFilters,
      disabled
    }, moreFiltersLabel)) : null;
    const filterResourceName = resourceName || {
      singular: i18n.translate("Polaris.ResourceList.defaultItemSingular"),
      plural: i18n.translate("Polaris.ResourceList.defaultItemPlural")
    };
    const transformedFilters = this.transformFilters(filters);
    const filtersControlMarkup = import_react693.default.createElement(ConnectedFilterControl, {
      rightPopoverableActions: transformedFilters,
      rightAction: rightActionMarkup,
      auxiliary: children2,
      disabled,
      forceShowMorefiltersButton: filters.length > transformedFilters.length,
      queryFieldHidden: hideQueryField
    }, hideQueryField ? null : import_react693.default.createElement(TextField, {
      placeholder: queryPlaceholder || i18n.translate("Polaris.Filters.filter", {
        resourceName: filterResourceName.plural
      }),
      onChange: onQueryChange,
      onBlur: onQueryBlur,
      onFocus: onQueryFocus,
      value: queryValue,
      focused,
      label: queryPlaceholder || i18n.translate("Polaris.Filters.filter", {
        resourceName: filterResourceName.plural
      }),
      labelHidden: true,
      prefix: import_react693.default.createElement("span", {
        className: styles76.SearchIcon
      }, import_react693.default.createElement(Icon, {
        source: SvgSearchMinor
      })),
      clearButton: true,
      onClearButtonClick: onQueryClear,
      disabled: disabled || disableQueryField,
      autoComplete: "off"
    }));
    const filtersContainerHeaderClassname = classNames(styles76.FiltersContainerHeader);
    const filtersDesktopHeaderMarkup = import_react693.default.createElement("div", {
      className: filtersContainerHeaderClassname
    }, import_react693.default.createElement(Text, {
      variant: "headingLg",
      as: "h3"
    }, moreFiltersLabel), import_react693.default.createElement(Button, {
      icon: SvgCancelSmallMinor,
      plain: true,
      accessibilityLabel: i18n.translate("Polaris.Filters.cancel"),
      onClick: this.closeFilters
    }));
    const filtersMobileHeaderMarkup = import_react693.default.createElement("div", {
      className: filtersContainerHeaderClassname
    }, import_react693.default.createElement(Button, {
      icon: SvgCancelSmallMinor,
      plain: true,
      accessibilityLabel: i18n.translate("Polaris.Filters.cancel"),
      onClick: this.closeFilters
    }), import_react693.default.createElement(Text, {
      variant: "headingLg",
      as: "h3"
    }, moreFiltersLabel), import_react693.default.createElement(Button, {
      onClick: this.closeFilters,
      primary: true
    }, i18n.translate("Polaris.Filters.done")));
    const filtersDesktopFooterClassname = classNames(styles76.FiltersContainerFooter);
    const filtersDesktopFooterMarkup = import_react693.default.createElement("div", {
      className: filtersDesktopFooterClassname
    }, import_react693.default.createElement(Button, {
      onClick: this.handleClearAll,
      disabled: !this.hasAppliedFilters()
    }, i18n.translate("Polaris.Filters.clearAllFilters")), import_react693.default.createElement("div", {
      ref: this.moreFiltersDoneButtonContainer
    }, import_react693.default.createElement(Button, {
      onClick: this.closeFilters,
      primary: true
    }, i18n.translate("Polaris.Filters.done"))));
    const filtersMobileFooterMarkup = import_react693.default.createElement("div", {
      className: styles76.FiltersMobileContainerFooter
    }, this.hasAppliedFilters() ? import_react693.default.createElement(Button, {
      onClick: onClearAll,
      fullWidth: true
    }, i18n.translate("Polaris.Filters.clearAllFilters")) : import_react693.default.createElement("div", {
      className: styles76.EmptyFooterState
    }, import_react693.default.createElement(Text, {
      color: "subdued",
      as: "span"
    }, import_react693.default.createElement("p", null, i18n.translate("Polaris.Filters.noFiltersApplied")))));
    const shouldHideTagsContainer = !appliedFilters || appliedFilters.length < 1;
    const tagsMarkup = !hideTags ? import_react693.default.createElement(TagsWrapper, {
      hidden: shouldHideTagsContainer
    }, import_react693.default.createElement("div", {
      className: styles76.TagsContainer,
      "aria-live": "polite"
    }, (appliedFilters || []).map((filter) => {
      return import_react693.default.createElement(Tag, {
        key: filter.key,
        onRemove: () => {
          filter.onRemove(filter.key);
        },
        disabled
      }, filter.label);
    }))) : null;
    const filtersMobileContainerContentClassName = classNames(styles76.FiltersMobileContainerContent);
    const filtersDesktopContainerContentClassName = classNames(styles76.FiltersDesktopContainerContent);
    const filtersContainerMarkup = isNavigationCollapsed ? import_react693.default.createElement(Sheet, {
      accessibilityLabel: moreFiltersLabel,
      open,
      onClose: this.closeFilters,
      onEntered: this.setReadyForFocus(true),
      onExit: this.setReadyForFocus(false)
    }, filtersMobileHeaderMarkup, import_react693.default.createElement(Scrollable, {
      className: filtersMobileContainerContentClassName,
      shadow: true
    }, filtersContentMarkup, filtersMobileFooterMarkup)) : import_react693.default.createElement(Sheet, {
      accessibilityLabel: moreFiltersLabel,
      open,
      onClose: this.closeFilters,
      onEntered: this.setReadyForFocus(true),
      onExit: this.setReadyForFocus(false)
    }, import_react693.default.createElement("div", {
      className: styles76.FiltersContainer
    }, filtersDesktopHeaderMarkup, import_react693.default.createElement(Scrollable, {
      className: filtersDesktopContainerContentClassName,
      shadow: true
    }, filtersContentMarkup), filtersDesktopFooterMarkup));
    const helpTextMarkup = helpText ? import_react693.default.createElement("div", {
      id: "FiltersHelpText",
      className: styles76.HelpText
    }, import_react693.default.createElement(Text, {
      color: "subdued",
      as: "span"
    }, helpText)) : null;
    return import_react693.default.createElement(WithinFilterContext.Provider, {
      value: true
    }, import_react693.default.createElement("div", {
      className: styles76.Filters
    }, filtersControlMarkup, filtersContainerMarkup, tagsMarkup, helpTextMarkup, backdropMarkup, import_react693.default.createElement(KeypressListener, {
      keyCode: Key.Escape,
      handler: this.closeFilters
    })));
  }
  hasAppliedFilters() {
    const {
      appliedFilters,
      queryValue
    } = this.props;
    const filtersApplied = Boolean(appliedFilters && appliedFilters.length > 0);
    const queryApplied = Boolean(queryValue && queryValue !== "");
    return filtersApplied || queryApplied;
  }
  getAppliedFilterContent(key) {
    const {
      appliedFilters
    } = this.props;
    if (!appliedFilters) {
      return void 0;
    }
    const filter = appliedFilters.find((filter2) => filter2.key === key);
    return filter == null ? void 0 : filter.label;
  }
  getAppliedFilterRemoveHandler(key) {
    const {
      appliedFilters
    } = this.props;
    if (!appliedFilters) {
      return void 0;
    }
    const filter = appliedFilters.find((filter2) => filter2.key === key);
    return filter == null ? void 0 : filter.onRemove;
  }
  openFilters() {
    this.setState({
      open: true
    });
  }
  toggleFilter(key) {
    if (this.state[`${key}${Suffix.Filter}`] === true) {
      this.setState({
        readyForFocus: false,
        [`${key}${Suffix.Filter}`]: false
      });
    } else {
      this.setState({
        readyForFocus: false,
        [`${key}${Suffix.Filter}`]: true
      });
    }
  }
  openFilterShortcut(key) {
    this.setState({
      [`${key}${Suffix.Shortcut}`]: true
    });
  }
  closeFilterShortcut(key) {
    this.setState({
      [`${key}${Suffix.Shortcut}`]: false
    });
  }
  toggleFilterShortcut(key) {
    if (this.state[`${key}${Suffix.Shortcut}`] === true) {
      this.closeFilterShortcut(key);
    } else {
      this.openFilterShortcut(key);
    }
  }
  transformFilters(filters) {
    const transformedActions = [];
    getShortcutFilters(filters).forEach((filter) => {
      const {
        key,
        label,
        disabled
      } = filter;
      transformedActions.push({
        popoverContent: this.generateFilterMarkup(filter),
        popoverOpen: Boolean(this.state[`${key}${Suffix.Shortcut}`]),
        key,
        content: label,
        disabled,
        onAction: () => this.toggleFilterShortcut(key)
      });
    });
    return transformedActions;
  }
  generateFilterMarkup(filter) {
    const i18n = this.props.i18n;
    const removeCallback = this.getAppliedFilterRemoveHandler(filter.key);
    const removeHandler = removeCallback == null ? void 0 : () => {
      removeCallback(filter.key);
    };
    const clearButtonMarkup = !filter.hideClearButton && import_react693.default.createElement(Button, {
      plain: true,
      disabled: removeHandler == null,
      onClick: removeHandler,
      accessibilityLabel: i18n.translate("Polaris.Filters.clearLabel", {
        filterName: filter.label
      })
    }, i18n.translate("Polaris.Filters.clear"));
    return import_react693.default.createElement("div", {
      ref: this.focusNode
    }, import_react693.default.createElement(LegacyStack, {
      vertical: true,
      spacing: "tight"
    }, filter.filter, clearButtonMarkup));
  }
};
FiltersInner.contextType = ResourceListContext;
function getShortcutFilters(filters) {
  return filters.filter((filter) => filter.shortcut === true);
}
function Filters(props) {
  const i18n = useI18n();
  const mediaQuery = useMediaQuery();
  return import_react693.default.createElement(FiltersInner, Object.assign({}, props, {
    i18n,
    mediaQuery
  }));
}

// ../node_modules/@shopify/polaris/build/esm/components/FooterHelp/FooterHelp.js
var import_react694 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/FooterHelp/FooterHelp.scss.js
var styles80 = {
  "FooterHelp": "Polaris-FooterHelp",
  "Text": "Polaris-FooterHelp__Text"
};

// ../node_modules/@shopify/polaris/build/esm/components/FooterHelp/FooterHelp.js
function FooterHelp({
  children: children2
}) {
  return import_react694.default.createElement("div", {
    className: styles80.FooterHelp
  }, import_react694.default.createElement("div", {
    className: styles80.Text
  }, children2));
}

// ../node_modules/@shopify/polaris/build/esm/components/Frame/Frame.js
var import_react705 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/set-root-property.js
function setRootProperty(name, value, node) {
  if (!document)
    return;
  const element = node || document.documentElement;
  element.style.setProperty(name, value);
}

// ../node_modules/@shopify/polaris/build/esm/components/Frame/Frame.scss.js
var styles81 = {
  "Frame": "Polaris-Frame",
  "Navigation": "Polaris-Frame__Navigation",
  "hasTopBar": "Polaris-Frame--hasTopBar",
  "Navigation-enter": "Polaris-Frame__Navigation--enter",
  "Navigation-enterActive": "Polaris-Frame__Navigation--enterActive",
  "Navigation-exit": "Polaris-Frame__Navigation--exit",
  "Navigation-exitActive": "Polaris-Frame__Navigation--exitActive",
  "NavigationDismiss": "Polaris-Frame__NavigationDismiss",
  "Navigation-visible": "Polaris-Frame__Navigation--visible",
  "TopBar": "Polaris-Frame__TopBar",
  "ContextualSaveBar": "Polaris-Frame__ContextualSaveBar",
  "Main": "Polaris-Frame__Main",
  "hasNav": "Polaris-Frame--hasNav",
  "Content": "Polaris-Frame__Content",
  "GlobalRibbonContainer": "Polaris-Frame__GlobalRibbonContainer",
  "LoadingBar": "Polaris-Frame__LoadingBar",
  "Skip": "Polaris-Frame__Skip",
  "focused": "Polaris-Frame--focused",
  "pressed": "Polaris-Frame--pressed"
};

// ../node_modules/@shopify/polaris/build/esm/components/Frame/components/Loading/Loading.js
var import_react696 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/use-is-mounted-ref.js
var import_react695 = __toESM(require_react());
function useIsMountedRef() {
  const isMounted = (0, import_react695.useRef)(false);
  (0, import_react695.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);
  return isMounted;
}

// ../node_modules/@shopify/polaris/build/esm/components/Frame/components/Loading/Loading.scss.js
var styles82 = {
  "Loading": "Polaris-Frame-Loading",
  "Level": "Polaris-Frame-Loading__Level"
};

// ../node_modules/@shopify/polaris/build/esm/components/Frame/components/Loading/Loading.js
var STUCK_THRESHOLD = 99;
function Loading2() {
  const i18n = useI18n();
  const isMountedRef = useIsMountedRef();
  const [progress, setProgress] = (0, import_react696.useState)(0);
  const [animating, setAnimating] = (0, import_react696.useState)(false);
  (0, import_react696.useEffect)(() => {
    if (progress >= STUCK_THRESHOLD || animating) {
      return;
    }
    requestAnimationFrame(() => {
      if (!isMountedRef.current)
        return;
      const step = Math.max((STUCK_THRESHOLD - progress) / 10, 1);
      setAnimating(true);
      setProgress(progress + step);
    });
  }, [progress, animating, isMountedRef]);
  const customStyles = {
    transform: `scaleX(${Math.floor(progress) / 100})`
  };
  return import_react696.default.createElement("div", {
    className: styles82.Loading,
    "aria-valuenow": progress,
    "aria-valuemin": 0,
    "aria-valuemax": 100,
    role: "progressbar",
    "aria-label": i18n.translate("Polaris.Loading.label")
  }, import_react696.default.createElement("div", {
    className: styles82.Level,
    style: customStyles,
    onTransitionEnd: () => setAnimating(false)
  }));
}

// ../node_modules/@shopify/polaris/build/esm/components/Frame/components/CSSAnimation/CSSAnimation.js
var import_react697 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Frame/components/CSSAnimation/CSSAnimation.scss.js
var styles83 = {
  "startFade": "Polaris-Frame-CSSAnimation--startFade",
  "endFade": "Polaris-Frame-CSSAnimation--endFade"
};

// ../node_modules/@shopify/polaris/build/esm/components/Frame/components/CSSAnimation/CSSAnimation.js
var TransitionStatus2;
(function(TransitionStatus3) {
  TransitionStatus3["Entering"] = "entering";
  TransitionStatus3["Entered"] = "entered";
  TransitionStatus3["Exiting"] = "exiting";
  TransitionStatus3["Exited"] = "exited";
})(TransitionStatus2 || (TransitionStatus2 = {}));
function CSSAnimation({
  in: inProp,
  className,
  type,
  children: children2
}) {
  const [transitionStatus, setTransitionStatus] = (0, import_react697.useState)(inProp ? TransitionStatus2.Entering : TransitionStatus2.Exited);
  const isMounted = (0, import_react697.useRef)(false);
  const node = (0, import_react697.useRef)(null);
  (0, import_react697.useEffect)(() => {
    if (!isMounted.current)
      return;
    transitionStatus === TransitionStatus2.Entering && changeTransitionStatus(TransitionStatus2.Entered);
  }, [transitionStatus]);
  (0, import_react697.useEffect)(() => {
    if (!isMounted.current)
      return;
    inProp && changeTransitionStatus(TransitionStatus2.Entering);
    !inProp && changeTransitionStatus(TransitionStatus2.Exiting);
  }, [inProp]);
  (0, import_react697.useEffect)(() => {
    isMounted.current = true;
  }, []);
  const wrapperClassName = classNames(className, styles83[variationName("start", type)], inProp && styles83[variationName("end", type)]);
  const content = transitionStatus === TransitionStatus2.Exited && !inProp ? null : children2;
  return import_react697.default.createElement("div", {
    className: wrapperClassName,
    ref: node,
    onTransitionEnd: handleTransitionEnd
  }, content);
  function handleTransitionEnd() {
    transitionStatus === TransitionStatus2.Exiting && changeTransitionStatus(TransitionStatus2.Exited);
  }
  function changeTransitionStatus(transitionStatus2) {
    setTransitionStatus(transitionStatus2);
    if (transitionStatus2 === TransitionStatus2.Entering)
      node.current && node.current.getBoundingClientRect();
  }
}

// ../node_modules/@shopify/polaris/build/esm/components/Frame/components/ContextualSaveBar/ContextualSaveBar.js
var import_react699 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/is-object.js
function isObject(value) {
  const type = typeof value;
  return value != null && (type === "object" || type === "function");
}

// ../node_modules/@shopify/polaris/build/esm/utilities/pluck-deep.js
function pluckDeep(obj, key) {
  if (!obj) {
    return null;
  }
  const keys = Object.keys(obj);
  for (const currKey of keys) {
    if (currKey === key) {
      return obj[key];
    }
    if (isObject(obj[currKey])) {
      const plucked = pluckDeep(obj[currKey], key);
      if (plucked) {
        return plucked;
      }
    }
  }
  return null;
}

// ../node_modules/@shopify/polaris/build/esm/utilities/get-width.js
function getWidth(value = {}, defaultWidth = 0, key = "width") {
  const width = typeof value === "number" ? value : pluckDeep(value, key);
  return width ? `${width}px` : `${defaultWidth}px`;
}

// ../node_modules/@shopify/polaris/build/esm/components/Frame/components/ContextualSaveBar/ContextualSaveBar.scss.js
var styles84 = {
  "ContextualSaveBar": "Polaris-Frame-ContextualSaveBar",
  "LogoContainer": "Polaris-Frame-ContextualSaveBar__LogoContainer",
  "ContextControl": "Polaris-Frame-ContextualSaveBar__ContextControl",
  "Contents": "Polaris-Frame-ContextualSaveBar__Contents",
  "fullWidth": "Polaris-Frame-ContextualSaveBar--fullWidth",
  "ActionContainer": "Polaris-Frame-ContextualSaveBar__ActionContainer",
  "Action": "Polaris-Frame-ContextualSaveBar__Action"
};

// ../node_modules/@shopify/polaris/build/esm/components/Frame/components/ContextualSaveBar/components/DiscardConfirmationModal/DiscardConfirmationModal.js
var import_react698 = __toESM(require_react());
function DiscardConfirmationModal({
  open,
  onDiscard,
  onCancel
}) {
  const i18n = useI18n();
  return import_react698.default.createElement(Modal, {
    title: i18n.translate("Polaris.DiscardConfirmationModal.title"),
    open,
    onClose: onCancel,
    primaryAction: {
      content: i18n.translate("Polaris.DiscardConfirmationModal.primaryAction"),
      destructive: true,
      onAction: onDiscard
    },
    secondaryActions: [{
      content: i18n.translate("Polaris.DiscardConfirmationModal.secondaryAction"),
      onAction: onCancel
    }],
    sectioned: true
  }, i18n.translate("Polaris.DiscardConfirmationModal.message"));
}

// ../node_modules/@shopify/polaris/build/esm/components/Frame/components/ContextualSaveBar/ContextualSaveBar.js
function ContextualSaveBar3({
  alignContentFlush,
  message,
  saveAction,
  discardAction,
  fullWidth,
  contextControl,
  secondaryMenu
}) {
  const i18n = useI18n();
  const {
    logo
  } = useFrame();
  const {
    value: discardConfirmationModalVisible,
    toggle: toggleDiscardConfirmationModal,
    setFalse: closeDiscardConfirmationModal
  } = useToggle(false);
  const handleDiscardAction = (0, import_react699.useCallback)(() => {
    if (discardAction && discardAction.onAction) {
      discardAction.onAction();
    }
    closeDiscardConfirmationModal();
  }, [closeDiscardConfirmationModal, discardAction]);
  const discardActionContent = discardAction && discardAction.content ? discardAction.content : i18n.translate("Polaris.ContextualSaveBar.discard");
  let discardActionHandler;
  if (discardAction && discardAction.discardConfirmationModal) {
    discardActionHandler = toggleDiscardConfirmationModal;
  } else if (discardAction) {
    discardActionHandler = discardAction.onAction;
  }
  const discardConfirmationModalMarkup = discardAction && discardAction.onAction && discardAction.discardConfirmationModal && import_react699.default.createElement(DiscardConfirmationModal, {
    open: discardConfirmationModalVisible,
    onCancel: toggleDiscardConfirmationModal,
    onDiscard: handleDiscardAction
  });
  const discardActionMarkup = discardAction && import_react699.default.createElement(Button, {
    url: discardAction.url,
    onClick: discardActionHandler,
    loading: discardAction.loading,
    disabled: discardAction.disabled,
    accessibilityLabel: discardAction.content
  }, discardActionContent);
  const saveActionContent = saveAction && saveAction.content ? saveAction.content : i18n.translate("Polaris.ContextualSaveBar.save");
  const saveActionMarkup = saveAction && import_react699.default.createElement(Button, {
    primary: true,
    url: saveAction.url,
    onClick: saveAction.onAction,
    loading: saveAction.loading,
    disabled: saveAction.disabled,
    accessibilityLabel: saveAction.content
  }, saveActionContent);
  const width = getWidth(logo, 104);
  const imageMarkup = logo && import_react699.default.createElement(Image, {
    style: {
      width
    },
    source: logo.contextualSaveBarSource || "",
    alt: ""
  });
  const logoMarkup = alignContentFlush || contextControl ? null : import_react699.default.createElement("div", {
    className: styles84.LogoContainer,
    style: {
      width
    }
  }, imageMarkup);
  const contextControlMarkup = contextControl ? import_react699.default.createElement("div", {
    className: styles84.ContextControl
  }, contextControl) : null;
  const contentsClassName = classNames(styles84.Contents, fullWidth && styles84.fullWidth);
  return import_react699.default.createElement(import_react699.default.Fragment, null, import_react699.default.createElement("div", {
    className: styles84.ContextualSaveBar
  }, contextControlMarkup, logoMarkup, import_react699.default.createElement("div", {
    className: contentsClassName
  }, message && import_react699.default.createElement(Text, {
    as: "h2",
    variant: "headingMd",
    color: "text-inverse",
    truncate: true
  }, message), import_react699.default.createElement("div", {
    className: styles84.ActionContainer
  }, import_react699.default.createElement(LegacyStack, {
    spacing: "tight",
    wrap: false
  }, secondaryMenu, discardActionMarkup, saveActionMarkup)))), discardConfirmationModalMarkup);
}

// ../node_modules/@shopify/polaris/build/esm/components/Frame/components/ToastManager/ToastManager.js
var import_react704 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/use-deep-effect.js
var import_react701 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/use-deep-compare-ref.js
var import_react700 = __toESM(require_react());
var import_react_fast_compare2 = __toESM(require_react_fast_compare());
function useDeepCompareRef(dependencies, comparator = import_react_fast_compare2.default) {
  const dependencyList = (0, import_react700.useRef)(dependencies);
  if (!comparator(dependencyList.current, dependencies)) {
    dependencyList.current = dependencies;
  }
  return dependencyList.current;
}

// ../node_modules/@shopify/polaris/build/esm/utilities/use-deep-effect.js
function useDeepEffect(callback, dependencies, customCompare) {
  (0, import_react701.useEffect)(callback, useDeepCompareRef(dependencies, customCompare));
}

// ../node_modules/@shopify/polaris/build/esm/utilities/use-deep-callback.js
var import_react702 = __toESM(require_react());
function useDeepCallback(callback, dependencies, customCompare) {
  return (0, import_react702.useCallback)(callback, useDeepCompareRef(dependencies, customCompare));
}

// ../node_modules/@shopify/polaris/build/esm/components/Frame/components/ToastManager/ToastManager.scss.js
var styles85 = {
  "ToastManager": "Polaris-Frame-ToastManager",
  "ToastWrapper": "Polaris-Frame-ToastManager__ToastWrapper",
  "ToastWrapper-enter": "Polaris-Frame-ToastManager__ToastWrapper--enter",
  "ToastWrapper-exit": "Polaris-Frame-ToastManager__ToastWrapper--exit",
  "ToastWrapper-enter-done": "Polaris-Frame-ToastManager--toastWrapperEnterDone"
};

// ../node_modules/@shopify/polaris/build/esm/components/Frame/components/Toast/Toast.js
var import_react703 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Frame/components/Toast/Toast.scss.js
var styles86 = {
  "Toast": "Polaris-Frame-Toast",
  "Action": "Polaris-Frame-Toast__Action",
  "error": "Polaris-Frame-Toast--error",
  "CloseButton": "Polaris-Frame-Toast__CloseButton",
  "LeadingIcon": "Polaris-Frame-Toast__LeadingIcon"
};

// ../node_modules/@shopify/polaris/build/esm/components/Frame/components/Toast/Toast.js
var DEFAULT_TOAST_DURATION = 5e3;
var DEFAULT_TOAST_DURATION_WITH_ACTION = 1e4;
function Toast({
  content,
  onDismiss,
  duration,
  error,
  action
}) {
  (0, import_react703.useEffect)(() => {
    let timeoutDuration = duration || DEFAULT_TOAST_DURATION;
    if (action && !duration) {
      timeoutDuration = DEFAULT_TOAST_DURATION_WITH_ACTION;
    } else if (action && duration && duration < DEFAULT_TOAST_DURATION_WITH_ACTION) {
      console.log("Toast with action should persist for at least 10,000 milliseconds to give the merchant enough time to act on it.");
    }
    const timer = setTimeout(onDismiss, timeoutDuration);
    return () => {
      clearTimeout(timer);
    };
  }, [action, duration, onDismiss]);
  const dismissMarkup = import_react703.default.createElement("button", {
    type: "button",
    className: styles86.CloseButton,
    onClick: onDismiss
  }, import_react703.default.createElement(Icon, {
    source: SvgCancelSmallMinor
  }));
  const actionMarkup = action ? import_react703.default.createElement("div", {
    className: styles86.Action
  }, import_react703.default.createElement(Button, {
    plain: true,
    monochrome: true,
    size: "slim",
    onClick: action.onAction
  }, action.content)) : null;
  const leadingIconMarkup = error ? import_react703.default.createElement("div", {
    className: styles86.LeadingIcon
  }, import_react703.default.createElement(Icon, {
    source: SvgDiamondAlertMinor,
    color: "base"
  })) : null;
  const className = classNames(styles86.Toast, error && styles86.error);
  return import_react703.default.createElement("div", {
    className
  }, import_react703.default.createElement(KeypressListener, {
    keyCode: Key.Escape,
    handler: onDismiss
  }), leadingIconMarkup, import_react703.default.createElement(HorizontalStack, {
    gap: "4",
    blockAlign: "center"
  }, import_react703.default.createElement(Text, {
    as: "span",
    fontWeight: "medium"
  }, content)), actionMarkup, dismissMarkup);
}

// ../node_modules/@shopify/polaris/build/esm/components/Frame/components/ToastManager/ToastManager.js
var ToastManager = (0, import_react704.memo)(function ToastManager2({
  toastMessages
}) {
  const toastNodes = [];
  const updateToasts = useDeepCallback(() => {
    let targetInPos = 0;
    toastMessages.forEach((_, index) => {
      const currentToast = toastNodes[index];
      if (!currentToast.current)
        return;
      targetInPos += currentToast.current.clientHeight;
      currentToast.current.style.setProperty("--pc-toast-manager-translate-y-in", `-${targetInPos}px`);
      currentToast.current.style.setProperty("--pc-toast-manager-translate-y-out", `${-targetInPos + 150}px`);
    });
  }, [toastMessages, toastNodes]);
  useDeepEffect(() => {
    updateToasts();
  }, [toastMessages]);
  const toastsMarkup = toastMessages.map((toast, index) => {
    const toastNode = (0, import_react704.createRef)();
    toastNodes[index] = toastNode;
    return import_react704.default.createElement(CSSTransition_default, {
      nodeRef: toastNodes[index],
      key: toast.id,
      timeout: {
        enter: 0,
        exit: 400
      },
      classNames: toastClasses
    }, import_react704.default.createElement("div", {
      ref: toastNode
    }, import_react704.default.createElement(Toast, toast)));
  });
  return import_react704.default.createElement(Portal, null, import_react704.default.createElement(EventListener, {
    event: "resize",
    handler: updateToasts
  }), import_react704.default.createElement("div", {
    className: styles85.ToastManager,
    "aria-live": "assertive"
  }, import_react704.default.createElement(TransitionGroup_default, {
    component: null
  }, toastsMarkup)));
});
var toastClasses = {
  enter: classNames(styles85.ToastWrapper, styles85["ToastWrapper-enter"]),
  enterDone: classNames(styles85.ToastWrapper, styles85["ToastWrapper-enter-done"]),
  exit: classNames(styles85.ToastWrapper, styles85["ToastWrapper-exit"])
};

// ../node_modules/@shopify/polaris/build/esm/components/Frame/Frame.js
var APP_FRAME_MAIN = "AppFrameMain";
var APP_FRAME_NAV = "AppFrameNav";
var APP_FRAME_TOP_BAR = "AppFrameTopBar";
var APP_FRAME_LOADING_BAR = "AppFrameLoadingBar";
var FrameInner = class extends import_react705.PureComponent {
  constructor(...args) {
    super(...args);
    this.state = {
      skipFocused: false,
      globalRibbonHeight: 0,
      loadingStack: 0,
      toastMessages: [],
      showContextualSaveBar: false
    };
    this.contextualSaveBar = null;
    this.globalRibbonContainer = null;
    this.navigationNode = (0, import_react705.createRef)();
    this.setGlobalRibbonHeight = () => {
      const {
        globalRibbonContainer
      } = this;
      if (globalRibbonContainer) {
        this.setState({
          globalRibbonHeight: globalRibbonContainer.offsetHeight
        }, this.setGlobalRibbonRootProperty);
      }
    };
    this.setOffset = () => {
      const {
        offset = "0px"
      } = this.props;
      setRootProperty("--pc-frame-offset", offset);
    };
    this.setGlobalRibbonRootProperty = () => {
      const {
        globalRibbonHeight
      } = this.state;
      setRootProperty("--pc-frame-global-ribbon-height", `${globalRibbonHeight}px`);
    };
    this.showToast = (toast) => {
      this.setState(({
        toastMessages
      }) => {
        const hasToastById = toastMessages.find(({
          id
        }) => id === toast.id) != null;
        return {
          toastMessages: hasToastById ? toastMessages : [...toastMessages, toast]
        };
      });
    };
    this.hideToast = ({
      id
    }) => {
      this.setState(({
        toastMessages
      }) => {
        return {
          toastMessages: toastMessages.filter(({
            id: toastId
          }) => id !== toastId)
        };
      });
    };
    this.setContextualSaveBar = (props) => {
      const {
        showContextualSaveBar
      } = this.state;
      this.contextualSaveBar = {
        ...props
      };
      if (showContextualSaveBar === true) {
        this.forceUpdate();
      } else {
        this.setState({
          showContextualSaveBar: true
        });
      }
    };
    this.removeContextualSaveBar = () => {
      this.contextualSaveBar = null;
      this.setState({
        showContextualSaveBar: false
      });
    };
    this.startLoading = () => {
      this.setState(({
        loadingStack
      }) => ({
        loadingStack: loadingStack + 1
      }));
    };
    this.stopLoading = () => {
      this.setState(({
        loadingStack
      }) => ({
        loadingStack: Math.max(0, loadingStack - 1)
      }));
    };
    this.handleResize = () => {
      if (this.props.globalRibbon) {
        this.setGlobalRibbonHeight();
      }
    };
    this.handleFocus = () => {
      this.setState({
        skipFocused: true
      });
    };
    this.handleBlur = () => {
      this.setState({
        skipFocused: false
      });
    };
    this.handleClick = (event) => {
      const {
        skipToContentTarget
      } = this.props;
      if (skipToContentTarget && skipToContentTarget.current) {
        skipToContentTarget.current.focus();
        event === null || event === void 0 ? void 0 : event.preventDefault();
      }
    };
    this.handleNavigationDismiss = () => {
      const {
        onNavigationDismiss
      } = this.props;
      if (onNavigationDismiss != null) {
        onNavigationDismiss();
      }
    };
    this.setGlobalRibbonContainer = (node) => {
      this.globalRibbonContainer = node;
    };
    this.handleNavKeydown = (event) => {
      const {
        key
      } = event;
      const {
        mediaQuery: {
          isNavigationCollapsed
        },
        showMobileNavigation
      } = this.props;
      const mobileNavShowing = isNavigationCollapsed && showMobileNavigation;
      if (mobileNavShowing && key === "Escape") {
        this.handleNavigationDismiss();
      }
    };
  }
  componentDidMount() {
    this.handleResize();
    if (this.props.globalRibbon) {
      return;
    }
    this.setGlobalRibbonRootProperty();
    this.setOffset();
  }
  componentDidUpdate(prevProps) {
    if (this.props.globalRibbon !== prevProps.globalRibbon) {
      this.setGlobalRibbonHeight();
    }
    this.setOffset();
  }
  render() {
    const {
      skipFocused,
      loadingStack,
      toastMessages,
      showContextualSaveBar
    } = this.state;
    const {
      logo,
      children: children2,
      navigation,
      topBar,
      globalRibbon,
      showMobileNavigation = false,
      skipToContentTarget,
      i18n,
      mediaQuery: {
        isNavigationCollapsed
      }
    } = this.props;
    const navClassName = classNames(styles81.Navigation, showMobileNavigation && styles81["Navigation-visible"]);
    const mobileNavHidden = isNavigationCollapsed && !showMobileNavigation;
    const mobileNavShowing = isNavigationCollapsed && showMobileNavigation;
    const tabIndex = mobileNavShowing ? 0 : -1;
    const mobileNavAttributes = {
      ...mobileNavShowing && {
        "aria-modal": true,
        role: "dialog"
      }
    };
    const navigationMarkup = navigation ? import_react705.default.createElement(TrapFocus, {
      trapping: mobileNavShowing
    }, import_react705.default.createElement(CSSTransition_default, {
      nodeRef: this.navigationNode,
      appear: isNavigationCollapsed,
      exit: isNavigationCollapsed,
      in: showMobileNavigation,
      timeout: parseInt(motion2["duration-300"], 10),
      classNames: navTransitionClasses
    }, import_react705.default.createElement("div", Object.assign({
      key: "NavContent"
    }, mobileNavAttributes, {
      "aria-label": i18n.translate("Polaris.Frame.navigationLabel"),
      ref: this.navigationNode,
      className: navClassName,
      onKeyDown: this.handleNavKeydown,
      id: APP_FRAME_NAV,
      hidden: mobileNavHidden
    }), navigation, import_react705.default.createElement("button", {
      type: "button",
      className: styles81.NavigationDismiss,
      onClick: this.handleNavigationDismiss,
      "aria-hidden": mobileNavHidden || !isNavigationCollapsed && !showMobileNavigation,
      "aria-label": i18n.translate("Polaris.Frame.Navigation.closeMobileNavigationLabel"),
      tabIndex
    }, import_react705.default.createElement(Icon, {
      source: SvgMobileCancelMajor
    }))))) : null;
    const loadingMarkup = loadingStack > 0 ? import_react705.default.createElement("div", {
      className: styles81.LoadingBar,
      id: APP_FRAME_LOADING_BAR
    }, import_react705.default.createElement(Loading2, null)) : null;
    const contextualSaveBarMarkup = import_react705.default.createElement(CSSAnimation, {
      in: showContextualSaveBar,
      className: styles81.ContextualSaveBar,
      type: "fade"
    }, import_react705.default.createElement(ContextualSaveBar3, this.contextualSaveBar));
    const topBarMarkup = topBar ? import_react705.default.createElement("div", Object.assign({
      className: styles81.TopBar
    }, layer.props, dataPolarisTopBar.props, {
      id: APP_FRAME_TOP_BAR
    }), topBar) : null;
    const globalRibbonMarkup = globalRibbon ? import_react705.default.createElement("div", {
      className: styles81.GlobalRibbonContainer,
      ref: this.setGlobalRibbonContainer
    }, globalRibbon) : null;
    const skipClassName = classNames(styles81.Skip, skipFocused && styles81.focused);
    const skipTarget = skipToContentTarget !== null && skipToContentTarget !== void 0 && skipToContentTarget.current ? skipToContentTarget.current.id : APP_FRAME_MAIN;
    const skipMarkup = import_react705.default.createElement("div", {
      className: skipClassName
    }, import_react705.default.createElement("a", {
      href: `#${skipTarget}`,
      onFocus: this.handleFocus,
      onBlur: this.handleBlur,
      onClick: this.handleClick
    }, i18n.translate("Polaris.Frame.skipToContent")));
    const navigationAttributes = navigation ? {
      "data-has-navigation": true
    } : {};
    const frameClassName = classNames(styles81.Frame, navigation && styles81.hasNav, topBar && styles81.hasTopBar);
    const navigationOverlayMarkup = showMobileNavigation && isNavigationCollapsed ? import_react705.default.createElement(Backdrop, {
      belowNavigation: true,
      onClick: this.handleNavigationDismiss,
      onTouchStart: this.handleNavigationDismiss
    }) : null;
    const context = {
      logo,
      showToast: this.showToast,
      hideToast: this.hideToast,
      startLoading: this.startLoading,
      stopLoading: this.stopLoading,
      setContextualSaveBar: this.setContextualSaveBar,
      removeContextualSaveBar: this.removeContextualSaveBar
    };
    return import_react705.default.createElement(FrameContext.Provider, {
      value: context
    }, import_react705.default.createElement("div", Object.assign({
      className: frameClassName
    }, layer.props, navigationAttributes), skipMarkup, topBarMarkup, navigationMarkup, contextualSaveBarMarkup, loadingMarkup, navigationOverlayMarkup, import_react705.default.createElement("main", {
      className: styles81.Main,
      id: APP_FRAME_MAIN,
      "data-has-global-ribbon": Boolean(globalRibbon)
    }, import_react705.default.createElement("div", {
      className: styles81.Content
    }, children2)), import_react705.default.createElement(ToastManager, {
      toastMessages
    }), globalRibbonMarkup, import_react705.default.createElement(EventListener, {
      event: "resize",
      handler: this.handleResize
    })));
  }
};
var navTransitionClasses = {
  enter: classNames(styles81["Navigation-enter"]),
  enterActive: classNames(styles81["Navigation-enterActive"]),
  enterDone: classNames(styles81["Navigation-enterActive"]),
  exit: classNames(styles81["Navigation-exit"]),
  exitActive: classNames(styles81["Navigation-exitActive"])
};
function Frame(props) {
  const i18n = useI18n();
  const mediaQuery = useMediaQuery();
  return import_react705.default.createElement(FrameInner, Object.assign({}, props, {
    i18n,
    mediaQuery
  }));
}

// ../node_modules/@shopify/polaris/build/esm/components/FullscreenBar/FullscreenBar.js
var import_react706 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/FullscreenBar/FullscreenBar.scss.js
var styles87 = {
  "FullscreenBar": "Polaris-FullscreenBar",
  "BackAction": "Polaris-FullscreenBar__BackAction"
};

// ../node_modules/@shopify/polaris/build/esm/components/FullscreenBar/FullscreenBar.js
function FullscreenBar({
  onAction,
  children: children2
}) {
  const i18n = useI18n();
  return import_react706.default.createElement("div", {
    className: styles87.FullscreenBar
  }, import_react706.default.createElement("button", {
    className: styles87.BackAction,
    onClick: onAction,
    "aria-label": i18n.translate("Polaris.FullscreenBar.accessibilityLabel")
  }, import_react706.default.createElement(Icon, {
    source: SvgExitMajor
  }), i18n.translate("Polaris.FullscreenBar.back")), children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/Grid/Grid.js
var import_react708 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Grid/Grid.scss.js
var styles88 = {
  "Grid": "Polaris-Grid"
};

// ../node_modules/@shopify/polaris/build/esm/components/Grid/components/Cell/Cell.js
var import_react707 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Grid/components/Cell/Cell.scss.js
var styles89 = {
  "Cell": "Polaris-Grid-Cell",
  "Cell-1-column-xs": "Polaris-Grid-Cell--cell_1ColumnXs",
  "Cell-2-column-xs": "Polaris-Grid-Cell--cell_2ColumnXs",
  "Cell-3-column-xs": "Polaris-Grid-Cell--cell_3ColumnXs",
  "Cell-4-column-xs": "Polaris-Grid-Cell--cell_4ColumnXs",
  "Cell-5-column-xs": "Polaris-Grid-Cell--cell_5ColumnXs",
  "Cell-6-column-xs": "Polaris-Grid-Cell--cell_6ColumnXs",
  "Cell-1-column-sm": "Polaris-Grid-Cell--cell_1ColumnSm",
  "Cell-2-column-sm": "Polaris-Grid-Cell--cell_2ColumnSm",
  "Cell-3-column-sm": "Polaris-Grid-Cell--cell_3ColumnSm",
  "Cell-4-column-sm": "Polaris-Grid-Cell--cell_4ColumnSm",
  "Cell-5-column-sm": "Polaris-Grid-Cell--cell_5ColumnSm",
  "Cell-6-column-sm": "Polaris-Grid-Cell--cell_6ColumnSm",
  "Cell-1-column-md": "Polaris-Grid-Cell--cell_1ColumnMd",
  "Cell-2-column-md": "Polaris-Grid-Cell--cell_2ColumnMd",
  "Cell-3-column-md": "Polaris-Grid-Cell--cell_3ColumnMd",
  "Cell-4-column-md": "Polaris-Grid-Cell--cell_4ColumnMd",
  "Cell-5-column-md": "Polaris-Grid-Cell--cell_5ColumnMd",
  "Cell-6-column-md": "Polaris-Grid-Cell--cell_6ColumnMd",
  "Cell-1-column-lg": "Polaris-Grid-Cell--cell_1ColumnLg",
  "Cell-2-column-lg": "Polaris-Grid-Cell--cell_2ColumnLg",
  "Cell-3-column-lg": "Polaris-Grid-Cell--cell_3ColumnLg",
  "Cell-4-column-lg": "Polaris-Grid-Cell--cell_4ColumnLg",
  "Cell-5-column-lg": "Polaris-Grid-Cell--cell_5ColumnLg",
  "Cell-6-column-lg": "Polaris-Grid-Cell--cell_6ColumnLg",
  "Cell-7-column-lg": "Polaris-Grid-Cell--cell_7ColumnLg",
  "Cell-8-column-lg": "Polaris-Grid-Cell--cell_8ColumnLg",
  "Cell-9-column-lg": "Polaris-Grid-Cell--cell_9ColumnLg",
  "Cell-10-column-lg": "Polaris-Grid-Cell--cell_10ColumnLg",
  "Cell-11-column-lg": "Polaris-Grid-Cell--cell_11ColumnLg",
  "Cell-12-column-lg": "Polaris-Grid-Cell--cell_12ColumnLg",
  "Cell-1-column-xl": "Polaris-Grid-Cell--cell_1ColumnXl",
  "Cell-2-column-xl": "Polaris-Grid-Cell--cell_2ColumnXl",
  "Cell-3-column-xl": "Polaris-Grid-Cell--cell_3ColumnXl",
  "Cell-4-column-xl": "Polaris-Grid-Cell--cell_4ColumnXl",
  "Cell-5-column-xl": "Polaris-Grid-Cell--cell_5ColumnXl",
  "Cell-6-column-xl": "Polaris-Grid-Cell--cell_6ColumnXl",
  "Cell-7-column-xl": "Polaris-Grid-Cell--cell_7ColumnXl",
  "Cell-8-column-xl": "Polaris-Grid-Cell--cell_8ColumnXl",
  "Cell-9-column-xl": "Polaris-Grid-Cell--cell_9ColumnXl",
  "Cell-10-column-xl": "Polaris-Grid-Cell--cell_10ColumnXl",
  "Cell-11-column-xl": "Polaris-Grid-Cell--cell_11ColumnXl",
  "Cell-12-column-xl": "Polaris-Grid-Cell--cell_12ColumnXl"
};

// ../node_modules/@shopify/polaris/build/esm/components/Grid/components/Cell/Cell.js
function Cell2({
  area: gridArea,
  column,
  columnSpan,
  row,
  children: children2
}) {
  const className = classNames(styles89.Cell, (columnSpan === null || columnSpan === void 0 ? void 0 : columnSpan.xs) && styles89[`Cell-${columnSpan.xs}-column-xs`], (columnSpan === null || columnSpan === void 0 ? void 0 : columnSpan.sm) && styles89[`Cell-${columnSpan.sm}-column-sm`], (columnSpan === null || columnSpan === void 0 ? void 0 : columnSpan.md) && styles89[`Cell-${columnSpan.md}-column-md`], (columnSpan === null || columnSpan === void 0 ? void 0 : columnSpan.lg) && styles89[`Cell-${columnSpan.lg}-column-lg`], (columnSpan === null || columnSpan === void 0 ? void 0 : columnSpan.xl) && styles89[`Cell-${columnSpan.xl}-column-xl`]);
  const style = {
    gridArea,
    "--pc-column-xs": column === null || column === void 0 ? void 0 : column.xs,
    "--pc-column-sm": column === null || column === void 0 ? void 0 : column.sm,
    "--pc-column-md": column === null || column === void 0 ? void 0 : column.md,
    "--pc-column-lg": column === null || column === void 0 ? void 0 : column.lg,
    "--pc-column-xl": column === null || column === void 0 ? void 0 : column.xl,
    "--pc-row-xs": row === null || row === void 0 ? void 0 : row.xs,
    "--pc-row-sm": row === null || row === void 0 ? void 0 : row.sm,
    "--pc-row-md": row === null || row === void 0 ? void 0 : row.md,
    "--pc-row-lg": row === null || row === void 0 ? void 0 : row.lg,
    "--pc-row-xl": row === null || row === void 0 ? void 0 : row.xl
  };
  return import_react707.default.createElement("div", {
    className,
    style
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/Grid/Grid.js
var Grid = function Grid2({
  gap,
  areas,
  children: children2,
  columns
}) {
  const style = {
    "--pc-grid-gap-xs": gap === null || gap === void 0 ? void 0 : gap.xs,
    "--pc-grid-gap-sm": gap === null || gap === void 0 ? void 0 : gap.sm,
    "--pc-grid-gap-md": gap === null || gap === void 0 ? void 0 : gap.md,
    "--pc-grid-gap-lg": gap === null || gap === void 0 ? void 0 : gap.lg,
    "--pc-grid-gap-xl": gap === null || gap === void 0 ? void 0 : gap.xl,
    "--pc-grid-columns-xs": columns === null || columns === void 0 ? void 0 : columns.xs,
    "--pc-grid-columns-sm": columns === null || columns === void 0 ? void 0 : columns.sm,
    "--pc-grid-columns-md": columns === null || columns === void 0 ? void 0 : columns.md,
    "--pc-grid-columns-lg": columns === null || columns === void 0 ? void 0 : columns.lg,
    "--pc-grid-columns-xl": columns === null || columns === void 0 ? void 0 : columns.xl,
    "--pc-grid-areas-xs": formatAreas(areas === null || areas === void 0 ? void 0 : areas.xs),
    "--pc-grid-areas-sm": formatAreas(areas === null || areas === void 0 ? void 0 : areas.sm),
    "--pc-grid-areas-md": formatAreas(areas === null || areas === void 0 ? void 0 : areas.md),
    "--pc-grid-areas-lg": formatAreas(areas === null || areas === void 0 ? void 0 : areas.lg),
    "--pc-grid-areas-xl": formatAreas(areas === null || areas === void 0 ? void 0 : areas.xl)
  };
  return import_react708.default.createElement("div", {
    className: styles88.Grid,
    style
  }, children2);
};
function formatAreas(areas) {
  if (!areas)
    return;
  return `'${areas === null || areas === void 0 ? void 0 : areas.join(`' '`)}'`;
}
Grid.Cell = Cell2;

// ../node_modules/@shopify/polaris/build/esm/components/Heading/Heading.js
var import_react709 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Heading/Heading.scss.js
var styles90 = {
  "Heading": "Polaris-Heading"
};

// ../node_modules/@shopify/polaris/build/esm/components/Heading/Heading.js
function Heading({
  element: Element2 = "h2",
  children: children2,
  id
}) {
  return import_react709.default.createElement(Element2, {
    className: styles90.Heading,
    id
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/IndexFilters.js
var import_react718 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/use-on-value-change.js
var import_react710 = __toESM(require_react());
function useOnValueChange(value, onChange) {
  const tracked = import_react710.default.useRef(value);
  (0, import_react710.useEffect)(() => {
    const oldValue = tracked.current;
    if (value !== tracked.current) {
      tracked.current = value;
      onChange(value, oldValue);
    }
  }, [value, onChange]);
}

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/types.js
var IndexFiltersMode;
(function(IndexFiltersMode2) {
  IndexFiltersMode2["Default"] = "DEFAULT";
  IndexFiltersMode2["Filtering"] = "FILTERING";
  IndexFiltersMode2["EditingColumns"] = "EDITING_COLUMNS";
})(IndexFiltersMode || (IndexFiltersMode = {}));

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/IndexFilters.scss.js
var styles91 = {
  "IndexFiltersWrapper": "Polaris-IndexFilters__IndexFiltersWrapper",
  "IndexFilters": "Polaris-IndexFilters",
  "IndexFiltersSticky": "Polaris-IndexFilters__IndexFiltersSticky",
  "IndexFiltersStickyFlush": "Polaris-IndexFilters__IndexFiltersStickyFlush",
  "TabsWrapper": "Polaris-IndexFilters__TabsWrapper",
  "SmallScreenTabsWrapper": "Polaris-IndexFilters__SmallScreenTabsWrapper",
  "TabsWrapperLoading": "Polaris-IndexFilters__TabsWrapperLoading",
  "TabsLoading": "Polaris-IndexFilters__TabsLoading",
  "ActionWrap": "Polaris-IndexFilters__ActionWrap",
  "Spinner": "Polaris-IndexFilters__Spinner"
};

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/hooks/useIsSticky/useIsSticky.js
var import_react711 = __toESM(require_react());
var DEBOUNCE_PERIOD = 250;
function useIsSticky(mode, disabled, isFlushWhenSticky) {
  const hasIOSupport = typeof window !== "undefined" && Boolean(window.IntersectionObserver);
  const options = {
    root: null,
    rootMargin: `${isFlushWhenSticky ? "0px" : "-56px"} 0px 0px 0px`,
    threshold: 0
  };
  const [indexFilteringHeight, setIndexFiltersHeight] = (0, import_react711.useState)(0);
  const [isSticky, setIsSticky] = (0, import_react711.useState)(false);
  const measurerRef = (0, import_react711.useRef)(null);
  const intersectionRef = (0, import_react711.useRef)(null);
  const handleIntersect = (entries) => {
    entries.forEach((entry) => {
      setIsSticky(!entry.isIntersecting);
    });
  };
  const observerRef = (0, import_react711.useRef)(hasIOSupport ? new IntersectionObserver(handleIntersect, options) : null);
  (0, import_react711.useEffect)(() => {
    function computeDimensions() {
      const node = measurerRef.current;
      if (!node) {
        return {
          height: 0
        };
      }
      const box = node.getBoundingClientRect();
      const height = box.height;
      setIndexFiltersHeight(height);
    }
    computeDimensions();
    const debouncedComputeDimensions = debounce(computeDimensions, DEBOUNCE_PERIOD, {
      trailing: true
    });
    window.addEventListener("resize", debouncedComputeDimensions);
    return () => window.removeEventListener("resize", debouncedComputeDimensions);
  }, [measurerRef, mode]);
  (0, import_react711.useEffect)(() => {
    const observer = observerRef.current;
    if (!observer) {
      return;
    }
    const node = intersectionRef.current;
    if (node) {
      observer.observe(node);
    }
    return () => {
      observer === null || observer === void 0 ? void 0 : observer.disconnect();
    };
  }, [intersectionRef]);
  return {
    intersectionRef,
    measurerRef,
    isSticky: isSticky && !disabled,
    indexFilteringHeight
  };
}

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/components/UpdateButtons/UpdateButtons.js
var import_react712 = __toESM(require_react());
var MAX_VIEW_NAME_LENGTH3 = 40;
function UpdateButtons({
  primaryAction,
  cancelAction,
  viewNames,
  disabled
}) {
  const i18n = useI18n();
  const [savedViewName, setSavedViewName] = (0, import_react712.useState)("");
  const [savedViewModalOpen, setSavedViewModalOpen] = (0, import_react712.useState)(false);
  const container = (0, import_react712.useRef)(null);
  const isTouchDevice = useIsTouchDevice();
  (0, import_react712.useEffect)(() => {
    if (!container.current || isTouchDevice)
      return;
    if (savedViewModalOpen) {
      focusFirstFocusableNode(container.current);
    }
  }, [savedViewModalOpen, isTouchDevice]);
  async function handleClickSaveButton() {
    if ((primaryAction === null || primaryAction === void 0 ? void 0 : primaryAction.type) === "save-as") {
      handleOpenModal();
    } else {
      await (primaryAction === null || primaryAction === void 0 ? void 0 : primaryAction.onAction(""));
    }
  }
  function handleOpenModal() {
    setSavedViewModalOpen(true);
  }
  function handleCloseModal() {
    setSavedViewModalOpen(false);
  }
  function handleChange(value) {
    setSavedViewName(value);
  }
  async function handlePrimaryAction() {
    if (isPrimaryActionDisabled)
      return;
    await (primaryAction === null || primaryAction === void 0 ? void 0 : primaryAction.onAction(savedViewName));
    handleCloseModal();
  }
  const buttonText = (0, import_react712.useMemo)(() => {
    switch (primaryAction === null || primaryAction === void 0 ? void 0 : primaryAction.type) {
      case "save":
        return i18n.translate("Polaris.IndexFilters.UpdateButtons.save");
      case "save-as":
      default:
        return i18n.translate("Polaris.IndexFilters.UpdateButtons.saveAs");
    }
  }, [primaryAction === null || primaryAction === void 0 ? void 0 : primaryAction.type, i18n]);
  const saveButton = import_react712.default.createElement(Button, {
    size: "micro",
    primary: true,
    plain: true,
    onClick: handleClickSaveButton,
    disabled: (primaryAction === null || primaryAction === void 0 ? void 0 : primaryAction.disabled) || disabled
  }, buttonText);
  const hasSameNameError = viewNames.some((name) => name.trim().toLowerCase() === savedViewName.trim().toLowerCase());
  const isPrimaryActionDisabled = hasSameNameError || !savedViewName || (primaryAction === null || primaryAction === void 0 ? void 0 : primaryAction.loading) || savedViewName.length > MAX_VIEW_NAME_LENGTH3;
  const cancelButtonMarkup = import_react712.default.createElement(Button, {
    plain: true,
    size: "micro",
    onClick: cancelAction.onAction,
    disabled
  }, i18n.translate("Polaris.IndexFilters.UpdateButtons.cancel"));
  if (!primaryAction) {
    return cancelButtonMarkup;
  }
  return import_react712.default.createElement(HorizontalStack, {
    align: "start",
    blockAlign: "center",
    gap: "2"
  }, cancelButtonMarkup, primaryAction.type === "save-as" ? import_react712.default.createElement(Modal, {
    activator: import_react712.default.createElement(HorizontalStack, null, saveButton),
    open: savedViewModalOpen,
    title: i18n.translate("Polaris.IndexFilters.UpdateButtons.modal.title"),
    onClose: handleCloseModal,
    primaryAction: {
      onAction: handlePrimaryAction,
      content: i18n.translate("Polaris.IndexFilters.UpdateButtons.modal.save"),
      disabled: isPrimaryActionDisabled
    },
    secondaryActions: [{
      onAction: handleCloseModal,
      content: i18n.translate("Polaris.IndexFilters.UpdateButtons.modal.cancel")
    }]
  }, import_react712.default.createElement(Modal.Section, null, import_react712.default.createElement(Form, {
    onSubmit: handlePrimaryAction
  }, import_react712.default.createElement(FormLayout, null, import_react712.default.createElement("div", {
    ref: container
  }, import_react712.default.createElement(TextField, {
    label: i18n.translate("Polaris.IndexFilters.UpdateButtons.modal.label"),
    value: savedViewName,
    onChange: handleChange,
    autoComplete: "off",
    maxLength: MAX_VIEW_NAME_LENGTH3,
    showCharacterCount: true,
    error: hasSameNameError ? i18n.translate("Polaris.IndexFilters.UpdateButtons.modal.sameName", {
      name: savedViewName
    }) : void 0
  })))))) : saveButton);
}

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/components/SortButton/SortButton.js
var import_react715 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/components/FilterButton/FilterButton.js
var import_react713 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/components/FilterButton/FilterButton.scss.js
var styles92 = {
  "FilterButton": "Polaris-IndexFilters-FilterButton",
  "pressed": "Polaris-IndexFilters-FilterButton--pressed",
  "Disabled": "Polaris-IndexFilters-FilterButton__Disabled"
};

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/components/FilterButton/FilterButton.js
function FilterButton({
  onClick,
  "aria-label": ariaLabel,
  children: children2,
  disabled
}) {
  const classes = classNames(styles92.FilterButton, disabled && styles92.Disabled);
  return import_react713.default.createElement(UnstyledButton, {
    className: classes,
    onClick,
    "aria-label": ariaLabel,
    disabled
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/components/SortButton/components/DirectionButton/DirectionButton.js
var import_react714 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/components/SortButton/components/DirectionButton/DirectionButton.scss.js
var styles93 = {
  "DirectionButton": "Polaris-SortButton-DirectionButton",
  "DirectionButton-active": "Polaris-SortButton-DirectionButton__DirectionButton--active",
  "Label": "Polaris-SortButton-DirectionButton__Label"
};

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/components/SortButton/components/DirectionButton/DirectionButton.js
function DirectionButton({
  onClick,
  active,
  children: children2,
  direction,
  value
}) {
  const classes = classNames(styles93.DirectionButton, active && styles93["DirectionButton-active"]);
  function handleClick() {
    onClick([value]);
  }
  return import_react714.default.createElement(UnstyledButton, {
    className: classes,
    onClick: handleClick
  }, import_react714.default.createElement(Icon, {
    source: direction === "asc" ? SvgArrowUpMinor : SvgArrowDownMinor,
    color: active ? "interactive" : "base"
  }), import_react714.default.createElement("span", {
    className: styles93.Label
  }, children2));
}

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/components/SortButton/SortButton.js
var SortButtonDirection;
(function(SortButtonDirection2) {
  SortButtonDirection2["Asc"] = "asc";
  SortButtonDirection2["Desc"] = "desc";
})(SortButtonDirection || (SortButtonDirection = {}));
function SortButton({
  choices,
  selected,
  onChange,
  disabled,
  onChangeKey,
  onChangeDirection
}) {
  var _selectedChoices$, _selectedChoices$2, _selectedChoices$3, _selectedChoices$4;
  const i18n = useI18n();
  const [active, setActive] = (0, import_react715.useState)(false);
  const [selectedValueKey, selectedDirection] = selected[0].split(" ");
  function handleClick() {
    setActive((pastActive) => !pastActive);
  }
  function handleClose() {
    setActive(false);
  }
  function handleChangeChoiceList(sel) {
    if (onChangeKey) {
      const [key] = sel[0].split(" ");
      onChangeKey(key);
    } else {
      onChange(sel);
    }
  }
  function handleChangeDirection(sel) {
    if (onChangeDirection) {
      const [, direction] = sel[0].split(" ");
      onChangeDirection(direction);
    } else {
      onChange(sel);
    }
  }
  const choiceListChoices = (0, import_react715.useMemo)(() => {
    const choiceCategories = choices.reduce((acc, curr) => {
      const alreadyExists = acc.some((option) => option.label === curr.label);
      const [, currentValueDirection] = curr.value.split(" ");
      const isSameDirection = currentValueDirection === selectedDirection;
      if (!alreadyExists) {
        return [...acc, curr];
      }
      if (isSameDirection) {
        return acc.map((option) => {
          if (option.label === curr.label) {
            return curr;
          }
          return option;
        });
      }
      return acc;
    }, []);
    return choiceCategories;
  }, [choices, selectedDirection]);
  const selectedChoices = choices.filter((choice) => {
    const [currentKey] = choice.value.split(" ");
    return currentKey === selectedValueKey;
  });
  const sortButton = import_react715.default.createElement(Tooltip, {
    content: i18n.translate("Polaris.IndexFilters.SortButton.tooltip"),
    preferredPosition: "above",
    hoverDelay: 400
  }, import_react715.default.createElement(FilterButton, {
    onClick: handleClick,
    "aria-label": i18n.translate("Polaris.IndexFilters.SortButton.ariaLabel"),
    disabled
  }, import_react715.default.createElement(Icon, {
    source: SvgSortMinor,
    color: "base"
  })));
  return import_react715.default.createElement(Popover2, {
    active: active && !disabled,
    activator: sortButton,
    autofocusTarget: "first-node",
    onClose: handleClose,
    fluidContent: true
  }, import_react715.default.createElement(Box, {
    minWidth: "148px",
    padding: "4",
    borderBlockEndWidth: "1",
    borderColor: "border-subdued"
  }, import_react715.default.createElement(ChoiceList, {
    title: i18n.translate("Polaris.IndexFilters.SortButton.title"),
    choices: choiceListChoices,
    selected,
    onChange: handleChangeChoiceList
  })), import_react715.default.createElement(Box, {
    padding: "4"
  }, import_react715.default.createElement(DirectionButton, {
    direction: "asc",
    active: selectedDirection === SortButtonDirection.Asc,
    onClick: handleChangeDirection,
    value: selectedChoices === null || selectedChoices === void 0 ? void 0 : (_selectedChoices$ = selectedChoices[0]) === null || _selectedChoices$ === void 0 ? void 0 : _selectedChoices$.value
  }, selectedChoices === null || selectedChoices === void 0 ? void 0 : (_selectedChoices$2 = selectedChoices[0]) === null || _selectedChoices$2 === void 0 ? void 0 : _selectedChoices$2.directionLabel), import_react715.default.createElement(DirectionButton, {
    direction: "desc",
    active: selectedDirection === SortButtonDirection.Desc,
    onClick: handleChangeDirection,
    value: selectedChoices === null || selectedChoices === void 0 ? void 0 : (_selectedChoices$3 = selectedChoices[1]) === null || _selectedChoices$3 === void 0 ? void 0 : _selectedChoices$3.value
  }, selectedChoices === null || selectedChoices === void 0 ? void 0 : (_selectedChoices$4 = selectedChoices[1]) === null || _selectedChoices$4 === void 0 ? void 0 : _selectedChoices$4.directionLabel)));
}

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/components/Container/Container.js
var import_react716 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/components/Container/Container.scss.js
var styles94 = {
  "Container": "Polaris-IndexFilters-Container"
};

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/components/Container/Container.js
var Container = ({
  children: children2
}) => {
  return import_react716.default.createElement("div", {
    className: styles94.Container
  }, children2);
};

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/components/SearchFilterButton/SearchFilterButton.js
var import_react717 = __toESM(require_react());
function SearchFilterButton({
  onClick,
  "aria-label": ariaLabel,
  disabled,
  tooltipContent,
  style,
  hideFilters,
  hideQueryField
}) {
  const activator = import_react717.default.createElement("div", {
    style
  }, import_react717.default.createElement(FilterButton, {
    onClick,
    "aria-label": ariaLabel,
    disabled
  }, import_react717.default.createElement(HorizontalStack, {
    gap: "0"
  }, hideQueryField ? null : import_react717.default.createElement(Icon, {
    source: SvgSearchMinor,
    color: "base"
  }), hideFilters ? null : import_react717.default.createElement(Icon, {
    source: SvgFilterMinor,
    color: "base"
  }))));
  const content = import_react717.default.createElement(Text, {
    as: "span",
    variant: "bodyMd",
    alignment: "center"
  }, tooltipContent);
  return import_react717.default.createElement(Tooltip, {
    content,
    preferredPosition: "above",
    hoverDelay: 400
  }, activator);
}

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/IndexFilters.js
var DEFAULT_IGNORED_TAGS = ["INPUT", "SELECT", "TEXTAREA"];
var TRANSITION_DURATION2 = 150;
var defaultStyle2 = {
  transition: `opacity ${TRANSITION_DURATION2}ms var(--p-motion-ease)`,
  opacity: 0
};
var transitionStyles2 = {
  entering: {
    opacity: 1
  },
  entered: {
    opacity: 1
  },
  exiting: {
    opacity: 0
  },
  exited: {
    opacity: 0
  },
  unmounted: {
    opacity: 0
  }
};
function IndexFilters({
  tabs,
  selected,
  onSelect,
  onSort,
  onSortKeyChange,
  onSortDirectionChange,
  sortOptions,
  sortSelected,
  queryValue = "",
  queryPlaceholder,
  primaryAction,
  cancelAction,
  filters,
  appliedFilters,
  onClearAll,
  onQueryChange,
  onQueryFocus,
  onQueryClear,
  onEditStart,
  disabled,
  disableQueryField,
  hideFilters,
  loading,
  mode,
  setMode,
  disableStickyMode,
  isFlushWhenSticky = false,
  canCreateNewView = true,
  onCreateNewView,
  filteringAccessibilityLabel,
  filteringAccessibilityTooltip,
  hideQueryField
}) {
  const i18n = useI18n();
  const {
    mdDown
  } = useBreakpoints();
  const defaultRef = (0, import_react718.useRef)(null);
  const filteringRef = (0, import_react718.useRef)(null);
  const {
    value: filtersFocused,
    setFalse: setFiltersUnFocused,
    setTrue: setFiltersFocused
  } = useToggle(false);
  useOnValueChange(mode, (newMode) => {
    if (newMode === IndexFiltersMode.Filtering) {
      setFiltersFocused();
    } else {
      setFiltersUnFocused();
    }
  });
  useEventListener("keydown", (event) => {
    var _document, _document$activeEleme;
    const {
      key
    } = event;
    const tag = (_document = document) === null || _document === void 0 ? void 0 : (_document$activeEleme = _document.activeElement) === null || _document$activeEleme === void 0 ? void 0 : _document$activeEleme.tagName;
    if (mode !== IndexFiltersMode.Default && event.key === "Escape") {
      onPressEscape();
    }
    if (key === "f" && mode === IndexFiltersMode.Default) {
      if (tag && DEFAULT_IGNORED_TAGS.includes(tag)) {
        return;
      }
      onPressF();
      event.preventDefault();
    }
  });
  const {
    intersectionRef,
    measurerRef,
    indexFilteringHeight,
    isSticky
  } = useIsSticky(mode, Boolean(disableStickyMode), isFlushWhenSticky);
  const viewNames = tabs.map(({
    content
  }) => content);
  const handleChangeSortButton = (0, import_react718.useCallback)((value) => {
    onSort === null || onSort === void 0 ? void 0 : onSort(value);
  }, [onSort]);
  const handleChangeSearch = (0, import_react718.useCallback)((value) => {
    onQueryChange(value);
  }, [onQueryChange]);
  const useExecutedCallback = (action, afterEffect) => (0, import_react718.useCallback)(async (name) => {
    const hasExecuted = await (action === null || action === void 0 ? void 0 : action(name));
    if (hasExecuted) {
      setMode(IndexFiltersMode.Default);
      afterEffect === null || afterEffect === void 0 ? void 0 : afterEffect();
    }
  }, [action, afterEffect]);
  const onExecutedPrimaryAction = useExecutedCallback(primaryAction === null || primaryAction === void 0 ? void 0 : primaryAction.onAction);
  const onExecutedCancelAction = (0, import_react718.useCallback)(() => {
    var _cancelAction$onActio;
    (_cancelAction$onActio = cancelAction.onAction) === null || _cancelAction$onActio === void 0 ? void 0 : _cancelAction$onActio.call(cancelAction);
    setMode(IndexFiltersMode.Default);
  }, [cancelAction, setMode]);
  const enhancedPrimaryAction = (0, import_react718.useMemo)(() => {
    return primaryAction ? {
      ...primaryAction,
      onAction: onExecutedPrimaryAction
    } : void 0;
  }, [onExecutedPrimaryAction, primaryAction]);
  const enhancedCancelAction = (0, import_react718.useMemo)(() => {
    return {
      ...cancelAction,
      onAction: onExecutedCancelAction
    };
  }, [cancelAction, onExecutedCancelAction]);
  const beginEdit = (0, import_react718.useCallback)(() => {
    setMode(IndexFiltersMode.Filtering);
    onEditStart === null || onEditStart === void 0 ? void 0 : onEditStart();
  }, [onEditStart, setMode]);
  const updateButtonsMarkup = (0, import_react718.useMemo)(() => import_react718.default.createElement(UpdateButtons, {
    primaryAction: enhancedPrimaryAction,
    cancelAction: enhancedCancelAction,
    viewNames,
    disabled
  }), [enhancedPrimaryAction, enhancedCancelAction, disabled, viewNames]);
  const sortMarkup = (0, import_react718.useMemo)(() => {
    if (!(sortOptions !== null && sortOptions !== void 0 && sortOptions.length)) {
      return null;
    }
    return import_react718.default.createElement(SortButton, {
      choices: sortOptions,
      selected: sortSelected,
      onChange: handleChangeSortButton,
      onChangeKey: onSortKeyChange,
      onChangeDirection: onSortDirectionChange,
      disabled
    });
  }, [handleChangeSortButton, onSortDirectionChange, onSortKeyChange, sortOptions, sortSelected, disabled]);
  const isActionLoading = (primaryAction === null || primaryAction === void 0 ? void 0 : primaryAction.loading) || (cancelAction === null || cancelAction === void 0 ? void 0 : cancelAction.loading);
  function handleClickFilterButton() {
    beginEdit();
  }
  const searchFilterTooltip = filteringAccessibilityTooltip || i18n.translate("Polaris.IndexFilters.searchFilterTooltip");
  const searchFilterAriaLabel = filteringAccessibilityLabel || i18n.translate("Polaris.IndexFilters.searchFilterAccessibilityLabel");
  const isLoading = loading || isActionLoading;
  function onPressEscape() {
    cancelAction === null || cancelAction === void 0 ? void 0 : cancelAction.onAction();
    setMode(IndexFiltersMode.Default);
  }
  function handleClearSearch() {
    onQueryClear === null || onQueryClear === void 0 ? void 0 : onQueryClear();
  }
  function handleQueryBlur() {
    setFiltersUnFocused();
  }
  function handleQueryFocus() {
    setFiltersFocused();
    onQueryFocus === null || onQueryFocus === void 0 ? void 0 : onQueryFocus();
  }
  function onPressF() {
    if (mode !== IndexFiltersMode.Default) {
      return;
    }
    beginEdit();
  }
  return import_react718.default.createElement("div", {
    className: styles91.IndexFiltersWrapper,
    style: {
      height: indexFilteringHeight
    }
  }, import_react718.default.createElement("div", {
    ref: intersectionRef
  }), import_react718.default.createElement("div", {
    className: classNames(styles91.IndexFilters, isSticky && styles91.IndexFiltersSticky, isSticky && isFlushWhenSticky && styles91.IndexFiltersStickyFlush),
    ref: measurerRef
  }, import_react718.default.createElement(Transition_default, {
    nodeRef: defaultRef,
    in: mode !== IndexFiltersMode.Filtering,
    timeout: TRANSITION_DURATION2
  }, (state) => import_react718.default.createElement("div", {
    ref: defaultRef
  }, mode !== IndexFiltersMode.Filtering ? import_react718.default.createElement(Container, null, import_react718.default.createElement(HorizontalStack, {
    align: "start",
    blockAlign: "center",
    gap: {
      xs: "0",
      md: "2"
    }
  }, import_react718.default.createElement("div", {
    className: classNames(styles91.TabsWrapper, mdDown && styles91.SmallScreenTabsWrapper, isLoading && styles91.TabsWrapperLoading)
  }, import_react718.default.createElement("div", {
    className: styles91.TabsInner,
    style: {
      ...defaultStyle2,
      ...transitionStyles2[state]
    }
  }, import_react718.default.createElement(AlphaTabs, {
    tabs,
    selected,
    onSelect,
    disabled: Boolean(mode !== IndexFiltersMode.Default || disabled),
    canCreateNewView,
    onCreateNewView
  })), isLoading && mdDown && import_react718.default.createElement("div", {
    className: styles91.TabsLoading
  }, import_react718.default.createElement(Spinner, {
    size: "small"
  }))), import_react718.default.createElement("div", {
    className: styles91.ActionWrap
  }, isLoading && !mdDown && import_react718.default.createElement(Spinner, {
    size: "small"
  }), mode === IndexFiltersMode.Default ? import_react718.default.createElement(import_react718.default.Fragment, null, hideFilters && hideQueryField ? null : import_react718.default.createElement(SearchFilterButton, {
    onClick: handleClickFilterButton,
    "aria-label": searchFilterAriaLabel,
    tooltipContent: searchFilterTooltip,
    disabled,
    hideFilters,
    hideQueryField,
    style: {
      ...defaultStyle2,
      ...transitionStyles2[state]
    }
  }), sortMarkup) : null, mode === IndexFiltersMode.EditingColumns ? updateButtonsMarkup : null))) : null)), import_react718.default.createElement(Transition_default, {
    nodeRef: filteringRef,
    in: mode === IndexFiltersMode.Filtering,
    timeout: TRANSITION_DURATION2
  }, (state) => import_react718.default.createElement("div", {
    ref: filteringRef
  }, mode === IndexFiltersMode.Filtering ? import_react718.default.createElement(AlphaFilters, {
    queryValue,
    queryPlaceholder,
    onQueryChange: handleChangeSearch,
    onQueryClear: handleClearSearch,
    onQueryFocus: handleQueryFocus,
    onQueryBlur: handleQueryBlur,
    filters,
    appliedFilters,
    onClearAll,
    disableFilters: disabled,
    hideFilters,
    hideQueryField,
    disableQueryField: disabled || disableQueryField,
    loading: loading || isActionLoading,
    focused: filtersFocused,
    mountedState: mdDown ? void 0 : state,
    borderlessQueryField: true
  }, import_react718.default.createElement(HorizontalStack, {
    gap: "3",
    align: "start",
    blockAlign: "center"
  }, import_react718.default.createElement("div", {
    style: {
      ...defaultStyle2,
      ...transitionStyles2[state]
    }
  }, updateButtonsMarkup), sortMarkup)) : null))));
}

// ../node_modules/@shopify/polaris/build/esm/components/IndexFilters/hooks/useSetIndexFiltersMode/useSetIndexFiltersMode.js
var import_react719 = __toESM(require_react());
function useSetIndexFiltersMode(defaultMode = IndexFiltersMode.Default) {
  const [mode, setMode] = (0, import_react719.useState)(defaultMode);
  return {
    mode,
    setMode
  };
}

// ../node_modules/@shopify/polaris/build/esm/components/IndexTable/IndexTable.js
var import_react731 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/IndexTable/IndexTable.scss.js
var styles95 = {
  "IndexTable": "Polaris-IndexTable",
  "IndexTableWrapper": "Polaris-IndexTable__IndexTableWrapper",
  "IndexTableWrapperWithBulkActions": "Polaris-IndexTable__IndexTableWrapperWithBulkActions",
  "LoadingContainer-enter": "Polaris-IndexTable__LoadingContainer--enter",
  "LoadingContainer-enter-active": "Polaris-IndexTable--loadingContainerEnterActive",
  "LoadingContainer-exit": "Polaris-IndexTable__LoadingContainer--exit",
  "LoadingContainer-exit-active": "Polaris-IndexTable--loadingContainerExitActive",
  "LoadingPanel": "Polaris-IndexTable__LoadingPanel",
  "LoadingPanelRow": "Polaris-IndexTable__LoadingPanelRow",
  "LoadingPanelText": "Polaris-IndexTable__LoadingPanelText",
  "Table": "Polaris-IndexTable__Table",
  "Table-scrolling": "Polaris-IndexTable__Table--scrolling",
  "TableCell-first": "Polaris-IndexTable__TableCell--first",
  "TableCell": "Polaris-IndexTable__TableCell",
  "TableHeading-first": "Polaris-IndexTable__TableHeading--first",
  "TableHeading-second": "Polaris-IndexTable__TableHeading--second",
  "Table-sticky": "Polaris-IndexTable__Table--sticky",
  "Table-unselectable": "Polaris-IndexTable__Table--unselectable",
  "TableRow": "Polaris-IndexTable__TableRow",
  "TableRow-unclickable": "Polaris-IndexTable__TableRow--unclickable",
  "statusSuccess": "Polaris-IndexTable--statusSuccess",
  "statusSubdued": "Polaris-IndexTable--statusSubdued",
  "TableRow-hovered": "Polaris-IndexTable__TableRow--hovered",
  "TableRow-selected": "Polaris-IndexTable__TableRow--selected",
  "TableRow-subdued": "Polaris-IndexTable__TableRow--subdued",
  "TableRow-disabled": "Polaris-IndexTable__TableRow--disabled",
  "ZebraStriping": "Polaris-IndexTable__ZebraStriping",
  "TableHeading": "Polaris-IndexTable__TableHeading",
  "TableHeading-align-center": "Polaris-IndexTable--tableHeadingAlignCenter",
  "TableHeading-align-end": "Polaris-IndexTable--tableHeadingAlignEnd",
  "TableHeading-sortable": "Polaris-IndexTable__TableHeading--sortable",
  "TableHeading-flush": "Polaris-IndexTable__TableHeading--flush",
  "TableHeadingSortButton": "Polaris-IndexTable__TableHeadingSortButton",
  "TableHeadingSortIcon": "Polaris-IndexTable__TableHeadingSortIcon",
  "TableHeadingSortButton-heading-align-end": "Polaris-IndexTable--tableHeadingSortButtonHeadingAlignEnd",
  "TableHeadingSortButton-heading-align-end-currently-sorted": "Polaris-IndexTable--tableHeadingSortButtonHeadingAlignEndCurrentlySorted",
  "TableHeadingSortIcon-heading-align-end": "Polaris-IndexTable--tableHeadingSortIconHeadingAlignEnd",
  "TableHeadingSortButton-heading-align-end-previously-sorted": "Polaris-IndexTable--tableHeadingSortButtonHeadingAlignEndPreviouslySorted",
  "right-aligned-sort-button-slide-out": "Polaris-IndexTable--rightAlignedSortButtonSlideOut",
  "reveal-right-aligned-sort-button-icon": "Polaris-IndexTable--revealRightAlignedSortButtonIcon",
  "TableHeadingUnderline": "Polaris-IndexTable__TableHeadingUnderline",
  "TableHeadingTooltipUnderlinePlaceholder": "Polaris-IndexTable__TableHeadingTooltipUnderlinePlaceholder",
  "TableHeadingSortIcon-visible": "Polaris-IndexTable__TableHeadingSortIcon--visible",
  "TableHeadingSortSvg": "Polaris-IndexTable__TableHeadingSortSvg",
  "SortableTableHeadingWithCustomMarkup": "Polaris-IndexTable__SortableTableHeadingWithCustomMarkup",
  "SortableTableHeaderWrapper": "Polaris-IndexTable__SortableTableHeaderWrapper",
  "ColumnHeaderCheckboxWrapper": "Polaris-IndexTable__ColumnHeaderCheckboxWrapper",
  "FirstStickyHeaderElement": "Polaris-IndexTable__FirstStickyHeaderElement",
  "TableHeading-unselectable": "Polaris-IndexTable__TableHeading--unselectable",
  "TableCell-flush": "Polaris-IndexTable__TableCell--flush",
  "Table-sticky-scrolling": "Polaris-IndexTable--tableStickyScrolling",
  "TableHeading-last": "Polaris-IndexTable__TableHeading--last",
  "Table-sticky-last": "Polaris-IndexTable--tableStickyLast",
  "Table-sortable": "Polaris-IndexTable__Table--sortable",
  "StickyTable": "Polaris-IndexTable__StickyTable",
  "StickyTableHeader": "Polaris-IndexTable__StickyTableHeader",
  "StickyTableHeader-isSticky": "Polaris-IndexTable__StickyTableHeader--isSticky",
  "StickyTableColumnHeader": "Polaris-IndexTable__StickyTableColumnHeader",
  "StickyTableHeadings": "Polaris-IndexTable__StickyTableHeadings",
  "StickyTableHeading-second": "Polaris-IndexTable__StickyTableHeading--second",
  "unselectable": "Polaris-IndexTable--unselectable",
  "StickyTableHeading-second-scrolling": "Polaris-IndexTable--stickyTableHeadingSecondScrolling",
  "ScrollLeft": "Polaris-IndexTable__ScrollLeft",
  "ScrollRight": "Polaris-IndexTable__ScrollRight",
  "ScrollRight-onboarding": "Polaris-IndexTable__ScrollRight--onboarding",
  "BulkActionsWrapper": "Polaris-IndexTable__BulkActionsWrapper",
  "BulkActionsWrapperSticky": "Polaris-IndexTable__BulkActionsWrapperSticky",
  "SelectAllActionsWrapper": "Polaris-IndexTable__SelectAllActionsWrapper",
  "StickyTableHeader-condensed": "Polaris-IndexTable__StickyTableHeader--condensed",
  "ScrollBarContainer": "Polaris-IndexTable__ScrollBarContainer",
  "scrollBarContainerCondensed": "Polaris-IndexTable--scrollBarContainerCondensed",
  "scrollBarContainerHidden": "Polaris-IndexTable--scrollBarContainerHidden",
  "ScrollBar": "Polaris-IndexTable__ScrollBar",
  "disableTextSelection": "Polaris-IndexTable--disableTextSelection",
  "selectMode": "Polaris-IndexTable--selectMode",
  "EmptySearchResultWrapper": "Polaris-IndexTable__EmptySearchResultWrapper",
  "condensedRow": "Polaris-IndexTable--condensedRow",
  "CondensedList": "Polaris-IndexTable__CondensedList",
  "HeaderWrapper": "Polaris-IndexTable__HeaderWrapper",
  "StickyTable-condensed": "Polaris-IndexTable__StickyTable--condensed",
  "ScrollBarContent": "Polaris-IndexTable__ScrollBarContent"
};

// ../node_modules/@shopify/polaris/build/esm/components/IndexProvider/IndexProvider.js
var import_react722 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/index-provider/hooks.js
var import_react721 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/index-provider/types.js
var SELECT_ALL_ITEMS = "All";
var SelectionType2;
(function(SelectionType3) {
  SelectionType3["All"] = "all";
  SelectionType3["Page"] = "page";
  SelectionType3["Multi"] = "multi";
  SelectionType3["Single"] = "single";
})(SelectionType2 || (SelectionType2 = {}));

// ../node_modules/@shopify/polaris/build/esm/utilities/index-provider/context.js
var import_react720 = __toESM(require_react());
var IndexContext = (0, import_react720.createContext)(void 0);
var IndexSelectionChangeContext = (0, import_react720.createContext)(void 0);
var IndexRowContext = (0, import_react720.createContext)(void 0);

// ../node_modules/@shopify/polaris/build/esm/utilities/index-provider/hooks.js
function useIndexSelectionChange() {
  const onSelectionChange = (0, import_react721.useContext)(IndexSelectionChangeContext);
  if (!onSelectionChange) {
    throw new Error(`Missing IndexProvider context`);
  }
  return onSelectionChange;
}
function useIndexRow() {
  const indexRow = (0, import_react721.useContext)(IndexRowContext);
  if (!indexRow) {
    throw new Error(`Missing IndexProvider context`);
  }
  return indexRow;
}
function useIndexValue() {
  const index = (0, import_react721.useContext)(IndexContext);
  if (!index) {
    throw new Error(`Missing IndexProvider context`);
  }
  return index;
}
function useBulkSelectionData({
  selectedItemsCount,
  itemCount,
  hasMoreItems,
  resourceName: passedResourceName
}) {
  const i18n = useI18n();
  const selectable = Boolean(selectedItemsCount);
  const selectMode = selectedItemsCount === "All" || selectedItemsCount > 0;
  const defaultResourceName = {
    singular: i18n.translate("Polaris.IndexProvider.defaultItemSingular"),
    plural: i18n.translate("Polaris.IndexProvider.defaultItemPlural")
  };
  const resourceName = passedResourceName ? passedResourceName : defaultResourceName;
  const paginatedSelectAllText = getPaginatedSelectAllText();
  const bulkActionsLabel = getBulkActionsLabel();
  const bulkActionsAccessibilityLabel = getBulkActionsAccessibilityLabel();
  let bulkSelectState = "indeterminate";
  if (!selectedItemsCount || selectedItemsCount === 0) {
    bulkSelectState = void 0;
  } else if (selectedItemsCount === SELECT_ALL_ITEMS || selectedItemsCount === itemCount) {
    bulkSelectState = true;
  }
  return {
    paginatedSelectAllText,
    bulkActionsLabel,
    bulkActionsAccessibilityLabel,
    resourceName,
    selectMode,
    bulkSelectState,
    selectable
  };
  function getPaginatedSelectAllText() {
    if (!selectable || !hasMoreItems) {
      return;
    }
    if (selectedItemsCount === SELECT_ALL_ITEMS) {
      return i18n.translate("Polaris.IndexProvider.allItemsSelected", {
        itemsLength: itemCount,
        resourceNamePlural: resourceName.plural.toLocaleLowerCase()
      });
    }
  }
  function getBulkActionsLabel() {
    const selectedItemsCountLabel = selectedItemsCount === SELECT_ALL_ITEMS ? `${itemCount}+` : selectedItemsCount;
    return i18n.translate("Polaris.IndexProvider.selected", {
      selectedItemsCount: selectedItemsCountLabel
    });
  }
  function getBulkActionsAccessibilityLabel() {
    const totalItemsCount = itemCount;
    const allSelected = selectedItemsCount === totalItemsCount;
    if (totalItemsCount === 1 && allSelected) {
      return i18n.translate("Polaris.IndexProvider.a11yCheckboxDeselectAllSingle", {
        resourceNameSingular: resourceName.singular
      });
    } else if (totalItemsCount === 1) {
      return i18n.translate("Polaris.IndexProvider.a11yCheckboxSelectAllSingle", {
        resourceNameSingular: resourceName.singular
      });
    } else if (allSelected) {
      return i18n.translate("Polaris.IndexProvider.a11yCheckboxDeselectAllMultiple", {
        itemsLength: itemCount,
        resourceNamePlural: resourceName.plural
      });
    } else {
      return i18n.translate("Polaris.IndexProvider.a11yCheckboxSelectAllMultiple", {
        itemsLength: itemCount,
        resourceNamePlural: resourceName.plural
      });
    }
  }
}
function useHandleBulkSelection({
  onSelectionChange = () => {
  }
}) {
  const lastSelected = (0, import_react721.useRef)(null);
  const handleSelectionChange = (0, import_react721.useCallback)((selectionType, toggleType, selection, sortOrder) => {
    const prevSelected = lastSelected.current;
    if (SelectionType2.Multi && typeof sortOrder === "number") {
      lastSelected.current = sortOrder;
    }
    if (selectionType === SelectionType2.Single || selectionType === SelectionType2.Multi && (typeof prevSelected !== "number" || typeof sortOrder !== "number")) {
      onSelectionChange(SelectionType2.Single, toggleType, selection);
    } else if (selectionType === SelectionType2.Multi) {
      const min = Math.min(prevSelected, sortOrder);
      const max = Math.max(prevSelected, sortOrder);
      onSelectionChange(selectionType, toggleType, [min, max]);
    } else if (selectionType === SelectionType2.Page || selectionType === SelectionType2.All) {
      onSelectionChange(selectionType, toggleType);
    }
  }, [onSelectionChange]);
  return handleSelectionChange;
}

// ../node_modules/@shopify/polaris/build/esm/components/IndexProvider/IndexProvider.js
function IndexProvider({
  children: children2,
  resourceName: passedResourceName,
  loading,
  onSelectionChange,
  selectedItemsCount = 0,
  itemCount,
  hasMoreItems,
  condensed,
  selectable: isSelectableIndex = true
}) {
  const {
    paginatedSelectAllText,
    bulkActionsLabel,
    bulkActionsAccessibilityLabel,
    resourceName,
    selectMode,
    bulkSelectState
  } = useBulkSelectionData({
    selectedItemsCount,
    itemCount,
    hasMoreItems,
    resourceName: passedResourceName
  });
  const handleSelectionChange = useHandleBulkSelection({
    onSelectionChange
  });
  const contextValue = (0, import_react722.useMemo)(() => ({
    itemCount,
    selectMode: selectMode && isSelectableIndex,
    selectable: isSelectableIndex,
    resourceName,
    loading,
    paginatedSelectAllText,
    hasMoreItems,
    bulkActionsLabel,
    bulkActionsAccessibilityLabel,
    bulkSelectState,
    selectedItemsCount,
    condensed
  }), [itemCount, selectMode, isSelectableIndex, resourceName, loading, paginatedSelectAllText, hasMoreItems, bulkActionsLabel, bulkActionsAccessibilityLabel, bulkSelectState, selectedItemsCount, condensed]);
  const rowContextValue = (0, import_react722.useMemo)(() => ({
    selectable: isSelectableIndex,
    selectMode: selectMode && isSelectableIndex,
    condensed
  }), [condensed, selectMode, isSelectableIndex]);
  return import_react722.default.createElement(IndexContext.Provider, {
    value: contextValue
  }, import_react722.default.createElement(IndexRowContext.Provider, {
    value: rowContextValue
  }, import_react722.default.createElement(IndexSelectionChangeContext.Provider, {
    value: handleSelectionChange
  }, children2)));
}

// ../node_modules/@shopify/polaris/build/esm/components/IndexTable/components/Cell/Cell.js
var import_react723 = __toESM(require_react());
var Cell3 = (0, import_react723.memo)(function Cell4({
  children: children2,
  className,
  flush
}) {
  const cellClassName = classNames(className, styles95.TableCell, flush && styles95["TableCell-flush"]);
  return import_react723.default.createElement("td", {
    className: cellClassName
  }, children2);
});

// ../node_modules/@shopify/polaris/build/esm/components/IndexTable/components/Row/Row.js
var import_react726 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/IndexTable/components/Checkbox/Checkbox.js
var import_react725 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/IndexTable/components/Checkbox/Checkbox.scss.js
var styles96 = {
  "TableCellContentContainer": "Polaris-IndexTable-Checkbox__TableCellContentContainer",
  "Wrapper": "Polaris-IndexTable-Checkbox__Wrapper",
  "expanded": "Polaris-IndexTable-Checkbox--expanded",
  "condensed": "Polaris-IndexTable-Checkbox--condensed"
};

// ../node_modules/@shopify/polaris/build/esm/utilities/index-table/context.js
var import_react724 = __toESM(require_react());
var RowContext = (0, import_react724.createContext)({});
var RowHoveredContext = (0, import_react724.createContext)(void 0);
var scrollDefaultContext = {
  scrollableContainer: null,
  canScrollLeft: false,
  canScrollRight: false
};
var ScrollContext = (0, import_react724.createContext)(scrollDefaultContext);

// ../node_modules/@shopify/polaris/build/esm/components/IndexTable/components/Checkbox/Checkbox.js
var Checkbox3 = (0, import_react725.memo)(function Checkbox4() {
  const i18n = useI18n();
  const {
    resourceName,
    condensed
  } = useIndexValue();
  const {
    itemId,
    selected,
    disabled,
    onInteraction
  } = (0, import_react725.useContext)(RowContext);
  const wrapperClassName = classNames(styles96.Wrapper, condensed ? styles96.condensed : styles96.expanded);
  const Wrapper = condensed ? import_react725.Fragment : CheckboxWrapper;
  return import_react725.default.createElement(Wrapper, null, import_react725.default.createElement("div", {
    className: styles96.TableCellContentContainer
  }, import_react725.default.createElement("div", {
    className: wrapperClassName,
    onClick: onInteraction,
    onKeyUp: noop13
  }, import_react725.default.createElement(Checkbox, {
    id: itemId,
    label: i18n.translate("Polaris.IndexTable.selectItem", {
      resourceName: resourceName.singular
    }),
    labelHidden: true,
    checked: selected,
    disabled
  }))));
});
function CheckboxWrapper({
  children: children2
}) {
  const {
    position
  } = (0, import_react725.useContext)(RowContext);
  const checkboxNode = (0, import_react725.useRef)(null);
  const handleResize = (0, import_react725.useCallback)(debounce(() => {
    if (position !== 0 || !checkboxNode.current)
      return;
    const {
      width
    } = checkboxNode.current.getBoundingClientRect();
    setRootProperty("--pc-checkbox-offset", `${width}px`);
  }), [position]);
  (0, import_react725.useEffect)(() => {
    handleResize();
  }, [handleResize]);
  (0, import_react725.useEffect)(() => {
    if (!checkboxNode.current)
      return;
    window.addEventListener("resize", handleResize);
    return () => {
      window.removeEventListener("resize", handleResize);
    };
  }, [handleResize]);
  const checkboxClassName = classNames(styles95.TableCell, styles95["TableCell-first"]);
  return import_react725.default.createElement("td", {
    className: checkboxClassName,
    ref: checkboxNode
  }, children2);
}
function noop13() {
}

// ../node_modules/@shopify/polaris/build/esm/components/IndexTable/components/Row/Row.js
var Row = (0, import_react726.memo)(function Row2({
  children: children2,
  selected,
  id,
  position,
  subdued,
  status,
  disabled,
  onNavigation,
  onClick
}) {
  const {
    selectable,
    selectMode,
    condensed
  } = useIndexRow();
  const onSelectionChange = useIndexSelectionChange();
  const {
    value: hovered,
    setTrue: setHoverIn,
    setFalse: setHoverOut
  } = useToggle(false);
  const handleInteraction = (0, import_react726.useCallback)((event) => {
    event.stopPropagation();
    if ("key" in event && event.key !== " " || !onSelectionChange)
      return;
    const selectionType = event.nativeEvent.shiftKey ? SelectionType2.Multi : SelectionType2.Single;
    onSelectionChange(selectionType, !selected, id, position);
  }, [id, onSelectionChange, position, selected]);
  const contextValue = (0, import_react726.useMemo)(() => ({
    itemId: id,
    selected,
    position,
    onInteraction: handleInteraction,
    disabled
  }), [id, selected, disabled, position, handleInteraction]);
  const primaryLinkElement = (0, import_react726.useRef)(null);
  const isNavigating = (0, import_react726.useRef)(false);
  const tableRowRef = (0, import_react726.useRef)(null);
  const tableRowCallbackRef = (0, import_react726.useCallback)((node) => {
    tableRowRef.current = node;
    const el = node === null || node === void 0 ? void 0 : node.querySelector("[data-primary-link]");
    if (el) {
      primaryLinkElement.current = el;
    }
  }, []);
  const rowClassName = classNames(styles95.TableRow, selectable && condensed && styles95.condensedRow, selected && styles95["TableRow-selected"], subdued && styles95["TableRow-subdued"], hovered && !condensed && styles95["TableRow-hovered"], disabled && styles95["TableRow-disabled"], status && styles95[variationName("status", status)], !selectable && !primaryLinkElement.current && styles95["TableRow-unclickable"]);
  let handleRowClick;
  if (!disabled && selectable || primaryLinkElement.current) {
    handleRowClick = (event) => {
      if (!tableRowRef.current || isNavigating.current) {
        return;
      }
      event.stopPropagation();
      event.preventDefault();
      if (onClick) {
        onClick();
        return;
      }
      if (primaryLinkElement.current && !selectMode) {
        isNavigating.current = true;
        const {
          ctrlKey,
          metaKey
        } = event.nativeEvent;
        if (onNavigation) {
          onNavigation(id);
        }
        if ((ctrlKey || metaKey) && primaryLinkElement.current instanceof HTMLAnchorElement) {
          isNavigating.current = false;
          window.open(primaryLinkElement.current.href, "_blank");
          return;
        }
        primaryLinkElement.current.dispatchEvent(new MouseEvent(event.type, event.nativeEvent));
      } else {
        isNavigating.current = false;
        handleInteraction(event);
      }
    };
  }
  const RowWrapper = condensed ? "li" : "tr";
  const checkboxMarkup = selectable ? import_react726.default.createElement(Checkbox3, null) : null;
  return import_react726.default.createElement(RowContext.Provider, {
    value: contextValue
  }, import_react726.default.createElement(RowHoveredContext.Provider, {
    value: hovered
  }, import_react726.default.createElement(RowWrapper, {
    key: id,
    className: rowClassName,
    onMouseEnter: setHoverIn,
    onMouseLeave: setHoverOut,
    onClick: handleRowClick,
    ref: tableRowCallbackRef
  }, checkboxMarkup, children2)));
});

// ../node_modules/@shopify/polaris/build/esm/components/BulkActions/hooks/use-is-bulk-actions-sticky.js
var import_react727 = __toESM(require_react());
var DEBOUNCE_PERIOD2 = 250;
var PADDING_IN_SELECT_MODE = 92;
function useIsBulkActionsSticky(selectMode) {
  const hasIOSupport = typeof window !== "undefined" && Boolean(window.IntersectionObserver);
  const [isBulkActionsSticky, setIsSticky] = (0, import_react727.useState)(false);
  const [bulkActionsAbsoluteOffset, setBulkActionsAbsoluteOffset] = (0, import_react727.useState)(0);
  const [bulkActionsMaxWidth, setBulkActionsMaxWidth] = (0, import_react727.useState)(0);
  const [bulkActionsOffsetLeft, setBulkActionsOffsetLeft] = (0, import_react727.useState)(0);
  const bulkActionsIntersectionRef = (0, import_react727.useRef)(null);
  const tableMeasurerRef = (0, import_react727.useRef)(null);
  const handleIntersect = (entries) => {
    entries.forEach((entry) => {
      setIsSticky(!entry.isIntersecting);
    });
  };
  const options = {
    root: null,
    rootMargin: "-12px",
    threshold: 0
  };
  const observerRef = (0, import_react727.useRef)(hasIOSupport ? new IntersectionObserver(handleIntersect, options) : null);
  const computeTableDimensions = (0, import_react727.useCallback)(() => {
    const node = tableMeasurerRef.current;
    if (!node) {
      return {
        maxWidth: 0,
        offsetHeight: 0,
        offsetLeft: 0
      };
    }
    const box = node.getBoundingClientRect();
    const paddingHeight = selectMode ? PADDING_IN_SELECT_MODE : 0;
    const offsetHeight = box.height - paddingHeight;
    const maxWidth = box.width;
    const offsetLeft = box.left;
    setBulkActionsAbsoluteOffset(offsetHeight);
    setBulkActionsMaxWidth(maxWidth);
    setBulkActionsOffsetLeft(offsetLeft);
  }, [selectMode]);
  (0, import_react727.useEffect)(() => {
    computeTableDimensions();
    const debouncedComputeTableHeight = debounce(computeTableDimensions, DEBOUNCE_PERIOD2, {
      trailing: true
    });
    window.addEventListener("resize", debouncedComputeTableHeight);
    return () => window.removeEventListener("resize", debouncedComputeTableHeight);
  }, [computeTableDimensions]);
  (0, import_react727.useEffect)(() => {
    const observer = observerRef.current;
    if (!observer) {
      return;
    }
    const node = bulkActionsIntersectionRef.current;
    if (node) {
      observer.observe(node);
    }
    return () => {
      observer === null || observer === void 0 ? void 0 : observer.disconnect();
    };
  }, [bulkActionsIntersectionRef]);
  return {
    bulkActionsIntersectionRef,
    tableMeasurerRef,
    isBulkActionsSticky,
    bulkActionsAbsoluteOffset,
    bulkActionsMaxWidth,
    bulkActionsOffsetLeft,
    computeTableDimensions
  };
}

// ../node_modules/@shopify/polaris/build/esm/components/IndexTable/utilities/utilities.js
function getTableHeadingsBySelector(wrapperElement, selector) {
  return wrapperElement ? Array.from(wrapperElement.querySelectorAll(selector)) : [];
}

// ../node_modules/@shopify/polaris/build/esm/components/IndexTable/components/ScrollContainer/ScrollContainer.js
var import_react728 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/IndexTable/components/ScrollContainer/ScrollContainer.scss.js
var styles97 = {
  "ScrollContainer": "Polaris-IndexTable-ScrollContainer"
};

// ../node_modules/@shopify/polaris/build/esm/components/IndexTable/components/ScrollContainer/ScrollContainer.js
function ScrollContainer({
  children: children2,
  scrollableContainerRef,
  onScroll
}) {
  (0, import_react728.useEffect)(() => {
    if (!scrollableContainerRef.current)
      return;
    scrollableContainerRef.current.dispatchEvent(new Event("scroll"));
  }, [scrollableContainerRef]);
  const [containerScroll, setContainerScroll] = (0, import_react728.useState)(scrollDefaultContext);
  const handleScroll = (0, import_react728.useCallback)(debounce(() => {
    if (!scrollableContainerRef.current) {
      return;
    }
    const availableScrollAmount = scrollableContainerRef.current.scrollWidth - scrollableContainerRef.current.offsetWidth;
    const canScrollLeft = scrollableContainerRef.current.scrollLeft > 0;
    const canScrollRight = scrollableContainerRef.current.scrollLeft < availableScrollAmount;
    onScroll(canScrollLeft, canScrollRight);
    setContainerScroll({
      scrollableContainer: scrollableContainerRef.current,
      canScrollLeft,
      canScrollRight
    });
  }, 40, {
    trailing: true,
    leading: true,
    maxWait: 40
  }), [onScroll, scrollableContainerRef]);
  return import_react728.default.createElement(ScrollContext.Provider, {
    value: containerScroll
  }, import_react728.default.createElement("div", {
    className: styles97.ScrollContainer,
    ref: scrollableContainerRef,
    onScroll: handleScroll
  }, children2));
}

// ../node_modules/@shopify/polaris/build/esm/components/SelectAllActions/SelectAllActions.js
var import_react730 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/SelectAllActions/SelectAllActions.scss.js
var styles98 = {
  "SelectAllActions": "Polaris-SelectAllActions",
  "SelectAllActions-entering": "Polaris-SelectAllActions__SelectAllActions--entering",
  "SelectAllActions-exiting": "Polaris-SelectAllActions__SelectAllActions--exiting",
  "SelectAllActions-entered": "Polaris-SelectAllActions__SelectAllActions--entered",
  "SelectAllActions-exited": "Polaris-SelectAllActions__SelectAllActions--exited",
  "PaginatedSelectAll": "Polaris-SelectAllActions__PaginatedSelectAll",
  "AllAction": "Polaris-SelectAllActions__AllAction"
};

// ../node_modules/@shopify/polaris/build/esm/components/CheckableButton/CheckableButton.js
var import_react729 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/CheckableButton/CheckableButton.scss.js
var styles99 = {
  "CheckableButton": "Polaris-CheckableButton",
  "Checkbox": "Polaris-CheckableButton__Checkbox",
  "Label": "Polaris-CheckableButton__Label"
};

// ../node_modules/@shopify/polaris/build/esm/components/CheckableButton/CheckableButton.js
var CheckableButton = (0, import_react729.forwardRef)(function CheckableButton2({
  accessibilityLabel,
  label = "",
  onToggleAll,
  selected,
  disabled,
  ariaLive
}, ref) {
  const checkBoxRef = (0, import_react729.useRef)(null);
  function focus() {
    var _checkBoxRef$current;
    checkBoxRef === null || checkBoxRef === void 0 ? void 0 : (_checkBoxRef$current = checkBoxRef.current) === null || _checkBoxRef$current === void 0 ? void 0 : _checkBoxRef$current.focus();
  }
  (0, import_react729.useImperativeHandle)(ref, () => {
    return {
      focus
    };
  });
  const className = classNames(styles99.CheckableButton);
  return import_react729.default.createElement("div", {
    className,
    onClick: onToggleAll
  }, import_react729.default.createElement("div", {
    className: styles99.Checkbox
  }, import_react729.default.createElement(Checkbox, {
    label: accessibilityLabel,
    labelHidden: true,
    checked: selected,
    disabled,
    onChange: onToggleAll,
    ref: checkBoxRef
  })), import_react729.default.createElement("span", {
    className: styles99.Label,
    "aria-live": ariaLive
  }, label));
});

// ../node_modules/@shopify/polaris/build/esm/components/SelectAllActions/SelectAllActions.js
var SelectAllActions = (0, import_react730.forwardRef)(function SelectAllActions2({
  accessibilityLabel,
  label,
  selected,
  selectMode,
  paginatedSelectAllText,
  paginatedSelectAllAction,
  disabled,
  onToggleAll
}, ref) {
  const paginatedSelectAllActionMarkup = paginatedSelectAllAction ? import_react730.default.createElement(UnstyledButton, {
    className: styles98.AllAction,
    onClick: paginatedSelectAllAction.onAction,
    size: "slim",
    disabled
  }, paginatedSelectAllAction.content) : null;
  const hasTextAndAction = paginatedSelectAllText && paginatedSelectAllAction;
  const paginatedSelectAllMarkup = paginatedSelectAllActionMarkup ? import_react730.default.createElement("div", {
    className: styles98.PaginatedSelectAll
  }, paginatedSelectAllActionMarkup) : null;
  const ariaLive = hasTextAndAction ? "polite" : void 0;
  const checkableButtonProps = {
    accessibilityLabel,
    label: hasTextAndAction ? paginatedSelectAllText : label,
    selected,
    onToggleAll,
    disabled,
    ariaLive,
    ref
  };
  const markup = import_react730.default.createElement(Transition_default, {
    timeout: 0,
    in: selectMode,
    key: "markup"
  }, (status) => {
    const wrapperClasses = classNames(styles98.SelectAllActions, styles98[`SelectAllActions-${status}`]);
    return import_react730.default.createElement("div", {
      className: wrapperClasses
    }, import_react730.default.createElement(CheckableButton, checkableButtonProps), paginatedSelectAllMarkup);
  });
  return markup;
});

// ../node_modules/@shopify/polaris/build/esm/components/IndexTable/IndexTable.js
var SCROLL_BAR_PADDING = 4;
var SCROLL_BAR_DEBOUNCE_PERIOD = 300;
function IndexTableBase({
  headings,
  bulkActions = [],
  promotedBulkActions = [],
  children: children2,
  emptyState,
  sort,
  paginatedSelectAllActionText,
  lastColumnSticky = false,
  sortable,
  sortDirection,
  defaultSortDirection = "descending",
  sortColumnIndex,
  onSort,
  sortToggleLabels,
  hasZebraStriping,
  ...restProps
}) {
  const {
    loading,
    bulkSelectState,
    resourceName,
    bulkActionsAccessibilityLabel,
    selectMode,
    selectable = restProps.selectable,
    paginatedSelectAllText,
    itemCount,
    hasMoreItems,
    selectedItemsCount,
    condensed
  } = useIndexValue();
  const handleSelectionChange = useIndexSelectionChange();
  const i18n = useI18n();
  const {
    value: hasMoreLeftColumns,
    toggle: toggleHasMoreLeftColumns
  } = useToggle(false);
  const tablePosition = (0, import_react731.useRef)({
    top: 0,
    left: 0
  });
  const tableHeadingRects = (0, import_react731.useRef)([]);
  const scrollableContainerElement = (0, import_react731.useRef)(null);
  const tableElement = (0, import_react731.useRef)(null);
  const condensedListElement = (0, import_react731.useRef)(null);
  const loadingElement = (0, import_react731.useRef)(null);
  const [tableInitialized, setTableInitialized] = (0, import_react731.useState)(false);
  const [stickyWrapper, setStickyWrapper] = (0, import_react731.useState)(null);
  const [hideScrollContainer, setHideScrollContainer] = (0, import_react731.useState)(false);
  const tableHeadings = (0, import_react731.useRef)([]);
  const stickyTableHeadings = (0, import_react731.useRef)([]);
  const stickyHeaderWrapperElement = (0, import_react731.useRef)(null);
  const firstStickyHeaderElement = (0, import_react731.useRef)(null);
  const stickyHeaderElement = (0, import_react731.useRef)(null);
  const scrollBarElement = (0, import_react731.useRef)(null);
  const scrollContainerElement = (0, import_react731.useRef)(null);
  const scrollingWithBar = (0, import_react731.useRef)(false);
  const scrollingContainer = (0, import_react731.useRef)(false);
  const lastSortedColumnIndex = (0, import_react731.useRef)(sortColumnIndex);
  const renderAfterSelectEvent = (0, import_react731.useRef)(false);
  const lastSelectedItemsCount = (0, import_react731.useRef)(0);
  const hasSelected = (0, import_react731.useRef)(false);
  if (selectedItemsCount !== lastSelectedItemsCount.current) {
    renderAfterSelectEvent.current = true;
    lastSelectedItemsCount.current = selectedItemsCount;
  }
  if (!hasSelected.current && selectedItemsCount !== 0) {
    hasSelected.current = true;
  }
  const {
    bulkActionsIntersectionRef,
    tableMeasurerRef,
    isBulkActionsSticky,
    bulkActionsAbsoluteOffset,
    bulkActionsMaxWidth,
    bulkActionsOffsetLeft,
    computeTableDimensions
  } = useIsBulkActionsSticky(selectMode);
  (0, import_react731.useEffect)(() => {
    computeTableDimensions();
  }, [computeTableDimensions, itemCount]);
  const tableBodyRef = (0, import_react731.useCallback)((node) => {
    if (node !== null && !tableInitialized) {
      setTableInitialized(true);
    }
  }, [tableInitialized]);
  const handleSelectAllItemsInStore = (0, import_react731.useCallback)(() => {
    handleSelectionChange(selectedItemsCount === SELECT_ALL_ITEMS ? SelectionType2.Page : SelectionType2.All, true);
  }, [handleSelectionChange, selectedItemsCount]);
  const calculateFirstHeaderOffset = (0, import_react731.useCallback)(() => {
    if (!selectable) {
      return tableHeadingRects.current[0].offsetWidth;
    }
    return condensed ? tableHeadingRects.current[0].offsetWidth : tableHeadingRects.current[0].offsetWidth + tableHeadingRects.current[1].offsetWidth;
  }, [condensed, selectable]);
  const resizeTableHeadings = (0, import_react731.useMemo)(() => debounce(() => {
    if (!tableElement.current || !scrollableContainerElement.current) {
      return;
    }
    const boundingRect = scrollableContainerElement.current.getBoundingClientRect();
    tablePosition.current = {
      top: boundingRect.top,
      left: boundingRect.left
    };
    tableHeadingRects.current = tableHeadings.current.map((heading) => ({
      offsetWidth: heading.offsetWidth || 0,
      offsetLeft: heading.offsetLeft || 0
    }));
    if (tableHeadings.current.length === 0) {
      return;
    }
    if (selectable && tableHeadings.current.length > 1)
      tableHeadings.current[1].style.left = `${tableHeadingRects.current[0].offsetWidth}px`;
    if (selectable && firstStickyHeaderElement !== null && firstStickyHeaderElement !== void 0 && firstStickyHeaderElement.current) {
      const elementStyle = getComputedStyle(tableHeadings.current[0]);
      const boxWidth = tableHeadings.current[0].offsetWidth;
      firstStickyHeaderElement.current.style.minWidth = `calc(${boxWidth}px - ${elementStyle.paddingLeft} - ${elementStyle.paddingRight} + 2px)`;
    }
    stickyTableHeadings.current.forEach((heading, index) => {
      let minWidth = 0;
      if (index === 0 && (!isBreakpointsXS() || !selectable)) {
        minWidth = calculateFirstHeaderOffset();
      } else if (selectable && tableHeadingRects.current.length > index) {
        var _tableHeadingRects$cu;
        minWidth = ((_tableHeadingRects$cu = tableHeadingRects.current[index]) === null || _tableHeadingRects$cu === void 0 ? void 0 : _tableHeadingRects$cu.offsetWidth) || 0;
      } else if (!selectable && tableHeadingRects.current.length >= index) {
        var _tableHeadingRects$cu2;
        minWidth = ((_tableHeadingRects$cu2 = tableHeadingRects.current[index - 1]) === null || _tableHeadingRects$cu2 === void 0 ? void 0 : _tableHeadingRects$cu2.offsetWidth) || 0;
      }
      heading.style.minWidth = `${minWidth}px`;
    });
  }), [calculateFirstHeaderOffset, selectable]);
  const resizeTableScrollBar = (0, import_react731.useCallback)(() => {
    if (scrollBarElement.current && tableElement.current && tableInitialized) {
      var _scrollContainerEleme, _tableElement$current;
      scrollBarElement.current.style.setProperty("--pc-index-table-scroll-bar-content-width", `${tableElement.current.offsetWidth - SCROLL_BAR_PADDING}px`);
      setHideScrollContainer(((_scrollContainerEleme = scrollContainerElement.current) === null || _scrollContainerEleme === void 0 ? void 0 : _scrollContainerEleme.offsetWidth) === ((_tableElement$current = tableElement.current) === null || _tableElement$current === void 0 ? void 0 : _tableElement$current.offsetWidth));
    }
  }, [tableInitialized]);
  const debounceResizeTableScrollbar = (0, import_react731.useCallback)(debounce(resizeTableScrollBar, SCROLL_BAR_DEBOUNCE_PERIOD, {
    trailing: true
  }), [resizeTableScrollBar]);
  const [canScrollRight, setCanScrollRight] = (0, import_react731.useState)(true);
  const handleCanScrollRight = (0, import_react731.useCallback)(debounce(() => {
    if (!lastColumnSticky || !tableElement.current || !scrollableContainerElement.current) {
      return;
    }
    const tableRect = tableElement.current.getBoundingClientRect();
    const scrollableRect = scrollableContainerElement.current.getBoundingClientRect();
    setCanScrollRight(tableRect.width > scrollableRect.width);
  }), [lastColumnSticky]);
  (0, import_react731.useEffect)(() => {
    handleCanScrollRight();
  }, [handleCanScrollRight]);
  const [canFitStickyColumn, setCanFitStickyColumn] = (0, import_react731.useState)(true);
  const handleCanFitStickyColumn = (0, import_react731.useCallback)(() => {
    if (!scrollableContainerElement.current || !tableHeadings.current.length) {
      return;
    }
    const scrollableRect = scrollableContainerElement.current.getBoundingClientRect();
    const checkboxColumnWidth = selectable ? tableHeadings.current[0].getBoundingClientRect().width : 0;
    const firstStickyColumnWidth = tableHeadings.current[selectable ? 1 : 0].getBoundingClientRect().width;
    const lastColumnIsNotTheFirst = selectable ? tableHeadings.current.length > 2 : 1;
    const lastStickyColumnWidth = lastColumnSticky && lastColumnIsNotTheFirst ? tableHeadings.current[tableHeadings.current.length - 1].getBoundingClientRect().width : 0;
    const restOfContentMinWidth = 100;
    setCanFitStickyColumn(scrollableRect.width > firstStickyColumnWidth + checkboxColumnWidth + lastStickyColumnWidth + restOfContentMinWidth);
  }, [lastColumnSticky, selectable]);
  (0, import_react731.useEffect)(() => {
    if (tableInitialized) {
      handleCanFitStickyColumn();
    }
  }, [handleCanFitStickyColumn, tableInitialized]);
  const handleResize = (0, import_react731.useCallback)(() => {
    var _scrollBarElement$cur;
    (_scrollBarElement$cur = scrollBarElement.current) === null || _scrollBarElement$cur === void 0 ? void 0 : _scrollBarElement$cur.style.setProperty("--pc-index-table-scroll-bar-content-width", `0px`);
    resizeTableHeadings();
    debounceResizeTableScrollbar();
    handleCanScrollRight();
    handleCanFitStickyColumn();
  }, [resizeTableHeadings, debounceResizeTableScrollbar, handleCanScrollRight, handleCanFitStickyColumn]);
  const handleScrollContainerScroll = (0, import_react731.useCallback)((canScrollLeft, canScrollRight2) => {
    if (!scrollableContainerElement.current || !scrollBarElement.current) {
      return;
    }
    if (!scrollingWithBar.current) {
      scrollingContainer.current = true;
      scrollBarElement.current.scrollLeft = scrollableContainerElement.current.scrollLeft;
    }
    scrollingWithBar.current = false;
    if (stickyHeaderElement.current) {
      stickyHeaderElement.current.scrollLeft = scrollableContainerElement.current.scrollLeft;
    }
    if (canScrollLeft && !hasMoreLeftColumns || !canScrollLeft && hasMoreLeftColumns) {
      toggleHasMoreLeftColumns();
    }
    setCanScrollRight(canScrollRight2);
  }, [hasMoreLeftColumns, toggleHasMoreLeftColumns]);
  const handleScrollBarScroll = (0, import_react731.useCallback)(() => {
    if (!scrollableContainerElement.current || !scrollBarElement.current) {
      return;
    }
    if (!scrollingContainer.current) {
      scrollingWithBar.current = true;
      scrollableContainerElement.current.scrollLeft = scrollBarElement.current.scrollLeft;
    }
    scrollingContainer.current = false;
  }, []);
  useIsomorphicLayoutEffect(() => {
    tableHeadings.current = getTableHeadingsBySelector(tableElement.current, "[data-index-table-heading]");
    stickyTableHeadings.current = getTableHeadingsBySelector(stickyHeaderWrapperElement.current, "[data-index-table-sticky-heading]");
    resizeTableHeadings();
  }, [headings, resizeTableHeadings, firstStickyHeaderElement, tableInitialized]);
  (0, import_react731.useEffect)(() => {
    resizeTableScrollBar();
    setStickyWrapper(condensed ? condensedListElement.current : tableElement.current);
  }, [tableInitialized, resizeTableScrollBar, condensed]);
  const hasBulkActions = Boolean(promotedBulkActions && promotedBulkActions.length > 0 || bulkActions && bulkActions.length > 0);
  const headingsMarkup = headings.map(renderHeading).reduce((acc, heading) => acc.concat(heading), []);
  const bulkActionsSelectable = Boolean(promotedBulkActions.length > 0 || bulkActions.length > 0);
  const stickyColumnHeaderStyle = tableHeadingRects.current && tableHeadingRects.current.length > 0 ? {
    minWidth: calculateFirstHeaderOffset()
  } : void 0;
  const stickyColumnHeader = import_react731.default.createElement("div", {
    className: styles95.TableHeading,
    key: getHeadingKey(headings[0]),
    style: stickyColumnHeaderStyle,
    "data-index-table-sticky-heading": true
  }, import_react731.default.createElement(LegacyStack, {
    spacing: "none",
    wrap: false,
    alignment: "center"
  }, selectable && import_react731.default.createElement("div", {
    className: styles95.FirstStickyHeaderElement,
    ref: firstStickyHeaderElement
  }, renderCheckboxContent()), selectable && import_react731.default.createElement("div", {
    className: styles95["StickyTableHeading-second-scrolling"]
  }, renderHeadingContent(headings[0], 0)), !selectable && import_react731.default.createElement("div", {
    className: styles95.FirstStickyHeaderElement,
    ref: firstStickyHeaderElement
  }, renderHeadingContent(headings[0], 0))));
  const stickyHeadingsMarkup = headings.map(renderStickyHeading);
  const selectedItemsCountLabel = selectedItemsCount === SELECT_ALL_ITEMS ? `${itemCount}+` : selectedItemsCount;
  const handleTogglePage = (0, import_react731.useCallback)(() => {
    handleSelectionChange(SelectionType2.Page, Boolean(!bulkSelectState || bulkSelectState === "indeterminate"));
  }, [bulkSelectState, handleSelectionChange]);
  const paginatedSelectAllAction = getPaginatedSelectAllAction();
  const loadingTransitionClassNames = {
    enter: styles95["LoadingContainer-enter"],
    enterActive: styles95["LoadingContainer-enter-active"],
    exit: styles95["LoadingContainer-exit"],
    exitActive: styles95["LoadingContainer-exit-active"]
  };
  const loadingMarkup = import_react731.default.createElement(CSSTransition_default, {
    in: loading,
    classNames: loadingTransitionClassNames,
    timeout: parseInt(motion2["duration-100"], 10),
    nodeRef: loadingElement,
    appear: true,
    unmountOnExit: true
  }, import_react731.default.createElement("div", {
    className: styles95.LoadingPanel,
    ref: loadingElement
  }, import_react731.default.createElement("div", {
    className: styles95.LoadingPanelRow
  }, import_react731.default.createElement(Spinner, {
    size: "small"
  }), import_react731.default.createElement("span", {
    className: styles95.LoadingPanelText
  }, i18n.translate("Polaris.IndexTable.resourceLoadingAccessibilityLabel", {
    resourceNamePlural: resourceName.plural.toLocaleLowerCase()
  })))));
  const stickyTableClassNames = classNames(styles95.StickyTable, condensed && styles95["StickyTable-condensed"]);
  const shouldShowBulkActions = bulkActionsSelectable && selectedItemsCount;
  const bulkActionClassNames = classNames(styles95.BulkActionsWrapper, isBulkActionsSticky && styles95.BulkActionsWrapperSticky);
  const shouldShowActions = !condensed || selectedItemsCount;
  const promotedActions = shouldShowActions ? promotedBulkActions : [];
  const actions = shouldShowActions ? bulkActions : [];
  const bulkActionsMarkup = shouldShowBulkActions && !condensed ? import_react731.default.createElement("div", {
    className: bulkActionClassNames,
    style: {
      insetBlockStart: isBulkActionsSticky ? void 0 : bulkActionsAbsoluteOffset,
      width: bulkActionsMaxWidth,
      insetInlineStart: isBulkActionsSticky ? bulkActionsOffsetLeft : void 0
    }
  }, import_react731.default.createElement(BulkActions, {
    selectMode,
    promotedActions,
    actions,
    onSelectModeToggle: condensed ? handleSelectModeToggle : void 0,
    isSticky: isBulkActionsSticky,
    width: bulkActionsMaxWidth
  })) : null;
  const stickyHeaderMarkup = import_react731.default.createElement("div", {
    className: stickyTableClassNames,
    role: "presentation"
  }, import_react731.default.createElement(Sticky, {
    boundingElement: stickyWrapper
  }, (isSticky) => {
    const stickyHeaderClassNames = classNames(styles95.StickyTableHeader, isSticky && styles95["StickyTableHeader-isSticky"]);
    const selectAllActionsClassName = classNames(styles95.SelectAllActionsWrapper, condensed && styles95["StickyTableHeader-condensed"], isSticky && styles95["StickyTableHeader-isSticky"]);
    const selectAllActionsMarkup = shouldShowBulkActions && !condensed ? import_react731.default.createElement("div", {
      className: selectAllActionsClassName
    }, import_react731.default.createElement(SelectAllActions, {
      label: i18n.translate("Polaris.IndexTable.selected", {
        selectedItemsCount: selectedItemsCountLabel
      }),
      accessibilityLabel: bulkActionsAccessibilityLabel,
      selected: bulkSelectState,
      selectMode,
      onToggleAll: handleTogglePage,
      paginatedSelectAllText,
      paginatedSelectAllAction
    }), loadingMarkup) : null;
    const headerMarkup = condensed ? import_react731.default.createElement("div", {
      className: classNames(styles95.HeaderWrapper, (!selectable || condensed) && styles95.unselectable)
    }, loadingMarkup, sort) : import_react731.default.createElement("div", {
      className: stickyHeaderClassNames,
      ref: stickyHeaderWrapperElement
    }, loadingMarkup, import_react731.default.createElement("div", {
      className: styles95.StickyTableColumnHeader
    }, stickyColumnHeader), import_react731.default.createElement("div", {
      className: styles95.StickyTableHeadings,
      ref: stickyHeaderElement
    }, stickyHeadingsMarkup));
    const stickyContent = selectAllActionsMarkup !== null && selectAllActionsMarkup !== void 0 ? selectAllActionsMarkup : headerMarkup;
    return stickyContent;
  }), bulkActionsMarkup);
  const scrollBarWrapperClassNames = classNames(styles95.ScrollBarContainer, condensed && styles95.scrollBarContainerCondensed, hideScrollContainer && styles95.scrollBarContainerHidden);
  const scrollBarClassNames = classNames(tableElement.current && tableInitialized && styles95.ScrollBarContent);
  const scrollBarMarkup = itemCount > 0 ? import_react731.default.createElement(AfterInitialMount, {
    onMount: resizeTableScrollBar
  }, import_react731.default.createElement("div", {
    className: scrollBarWrapperClassNames,
    ref: scrollContainerElement
  }, import_react731.default.createElement("div", {
    onScroll: handleScrollBarScroll,
    className: styles95.ScrollBar,
    ref: scrollBarElement
  }, import_react731.default.createElement("div", {
    className: scrollBarClassNames
  })))) : null;
  const isSortable = sortable === null || sortable === void 0 ? void 0 : sortable.some((value) => value);
  const tableClassNames = classNames(styles95.Table, hasMoreLeftColumns && styles95["Table-scrolling"], selectMode && styles95.disableTextSelection, selectMode && shouldShowBulkActions && styles95.selectMode, !selectable && styles95["Table-unselectable"], canFitStickyColumn && styles95["Table-sticky"], isSortable && styles95["Table-sortable"], canFitStickyColumn && lastColumnSticky && styles95["Table-sticky-last"], canFitStickyColumn && lastColumnSticky && canScrollRight && styles95["Table-sticky-scrolling"], hasZebraStriping && styles95.ZebraStriping);
  const emptyStateMarkup = emptyState ? emptyState : import_react731.default.createElement(EmptySearchResult, {
    title: i18n.translate("Polaris.IndexTable.emptySearchTitle", {
      resourceNamePlural: resourceName.plural
    }),
    description: i18n.translate("Polaris.IndexTable.emptySearchDescription"),
    withIllustration: true
  });
  const sharedMarkup = import_react731.default.createElement(import_react731.default.Fragment, null, import_react731.default.createElement(EventListener, {
    event: "resize",
    handler: handleResize
  }), import_react731.default.createElement(AfterInitialMount, null, stickyHeaderMarkup));
  const condensedClassNames = classNames(styles95.CondensedList, hasZebraStriping && styles95.ZebraStriping);
  const bodyMarkup = condensed ? import_react731.default.createElement(import_react731.default.Fragment, null, sharedMarkup, import_react731.default.createElement("ul", {
    "data-selectmode": Boolean(selectMode),
    className: condensedClassNames,
    ref: condensedListElement
  }, children2)) : import_react731.default.createElement(import_react731.default.Fragment, null, sharedMarkup, import_react731.default.createElement(ScrollContainer, {
    scrollableContainerRef: scrollableContainerElement,
    onScroll: handleScrollContainerScroll
  }, import_react731.default.createElement("table", {
    ref: tableElement,
    className: tableClassNames
  }, import_react731.default.createElement("thead", null, import_react731.default.createElement("tr", {
    className: styles95.HeadingRow
  }, headingsMarkup)), import_react731.default.createElement("tbody", {
    ref: tableBodyRef
  }, children2))));
  const tableContentMarkup = itemCount > 0 ? bodyMarkup : import_react731.default.createElement("div", {
    className: styles95.EmptySearchResultWrapper
  }, emptyStateMarkup);
  const tableWrapperClassNames = classNames(styles95.IndexTableWrapper, Boolean(bulkActionsMarkup) && selectMode && styles95.IndexTableWrapperWithBulkActions);
  return import_react731.default.createElement(import_react731.default.Fragment, null, import_react731.default.createElement("div", {
    className: styles95.IndexTable
  }, import_react731.default.createElement("div", {
    className: tableWrapperClassNames,
    ref: tableMeasurerRef
  }, !shouldShowBulkActions && !condensed && loadingMarkup, tableContentMarkup), import_react731.default.createElement("div", {
    ref: bulkActionsIntersectionRef
  })), scrollBarMarkup);
  function renderHeading(heading, index) {
    const isSecond = index === 0;
    const isLast = index === headings.length - 1;
    const hasSortable = sortable === null || sortable === void 0 ? void 0 : sortable.some((value) => value === true);
    const headingAlignment = heading.alignment || "start";
    const headingContentClassName = classNames(styles95.TableHeading, headingAlignment === "center" && styles95["TableHeading-align-center"], headingAlignment === "end" && styles95["TableHeading-align-end"], hasSortable && styles95["TableHeading-sortable"], isSecond && styles95["TableHeading-second"], isLast && !heading.hidden && styles95["TableHeading-last"], !selectable && styles95["TableHeading-unselectable"], heading.flush && styles95["TableHeading-flush"]);
    const stickyPositioningStyle = selectable !== false && isSecond && tableHeadingRects.current && tableHeadingRects.current.length > 0 ? {
      left: tableHeadingRects.current[0].offsetWidth
    } : void 0;
    const headingContent = import_react731.default.createElement("th", {
      className: headingContentClassName,
      key: getHeadingKey(heading),
      "data-index-table-heading": true,
      style: stickyPositioningStyle
    }, renderHeadingContent(heading, index));
    if (index !== 0 || !selectable) {
      return headingContent;
    }
    const checkboxClassName = classNames(styles95.TableHeading, hasSortable && styles95["TableHeading-sortable"], index === 0 && styles95["TableHeading-first"]);
    const checkboxContent = import_react731.default.createElement("th", {
      className: checkboxClassName,
      key: `${heading}-${index}`,
      "data-index-table-heading": true
    }, renderCheckboxContent());
    return [checkboxContent, headingContent];
  }
  function renderCheckboxContent() {
    return import_react731.default.createElement("div", {
      className: styles95.ColumnHeaderCheckboxWrapper
    }, import_react731.default.createElement(Checkbox, {
      label: i18n.translate("Polaris.IndexTable.selectAllLabel", {
        resourceNamePlural: resourceName.plural
      }),
      labelHidden: true,
      onChange: handleSelectPage,
      checked: bulkSelectState
    }));
  }
  function handleSortHeadingClick(index, direction) {
    renderAfterSelectEvent.current = false;
    hasSelected.current = false;
    lastSortedColumnIndex.current = sortColumnIndex;
    onSort === null || onSort === void 0 ? void 0 : onSort(index, direction);
  }
  function renderHeadingContent(heading, index) {
    var _heading$tooltipWidth;
    let headingContent;
    const defaultTooltipProps = {
      width: (_heading$tooltipWidth = heading.tooltipWidth) !== null && _heading$tooltipWidth !== void 0 ? _heading$tooltipWidth : "default",
      activatorWrapper: "div",
      dismissOnMouseOut: true,
      persistOnClick: heading.tooltipPersistsOnClick
    };
    const defaultHeaderTooltipProps = {
      ...defaultTooltipProps,
      padding: "4",
      borderRadius: "2",
      content: heading.tooltipContent,
      preferredPosition: "above"
    };
    if (heading.new) {
      headingContent = import_react731.default.createElement(LegacyStack, {
        wrap: false,
        alignment: "center"
      }, import_react731.default.createElement("span", null, heading.title), import_react731.default.createElement(Badge, {
        status: "new"
      }, i18n.translate("Polaris.IndexTable.onboardingBadgeText")));
    } else if (heading.hidden) {
      headingContent = import_react731.default.createElement(Text, {
        as: "span",
        visuallyHidden: true
      }, heading.title);
    } else {
      headingContent = heading.title;
    }
    if (sortable !== null && sortable !== void 0 && sortable[index]) {
      var _heading$defaultSortD;
      const isCurrentlySorted = index === sortColumnIndex;
      const isPreviouslySorted = !isCurrentlySorted && index === lastSortedColumnIndex.current;
      const isRenderAfterSelectEvent = renderAfterSelectEvent.current || !hasSelected.current && selectedItemsCount !== 0;
      const isAscending = sortDirection === "ascending";
      let newDirection = (_heading$defaultSortD = heading.defaultSortDirection) !== null && _heading$defaultSortD !== void 0 ? _heading$defaultSortD : defaultSortDirection;
      let SourceComponent = newDirection === "ascending" ? SvgSortAscendingMajor : SvgSortDescendingMajor;
      if (isCurrentlySorted) {
        newDirection = isAscending ? "descending" : "ascending";
        SourceComponent = sortDirection === "ascending" ? SvgSortAscendingMajor : SvgSortDescendingMajor;
      }
      const iconMarkup = import_react731.default.createElement("span", {
        className: classNames(styles95.TableHeadingSortIcon, (heading === null || heading === void 0 ? void 0 : heading.alignment) === "end" && styles95["TableHeadingSortIcon-heading-align-end"], isCurrentlySorted && styles95["TableHeadingSortIcon-visible"])
      }, import_react731.default.createElement(SourceComponent, {
        focusable: "false",
        "aria-hidden": "true",
        className: styles95.TableHeadingSortSvg
      }));
      const defaultSortButtonProps = {
        onClick: () => handleSortHeadingClick(index, newDirection),
        className: classNames(styles95.TableHeadingSortButton, !isCurrentlySorted && (heading === null || heading === void 0 ? void 0 : heading.alignment) === "end" && styles95["TableHeadingSortButton-heading-align-end"], isCurrentlySorted && (heading === null || heading === void 0 ? void 0 : heading.alignment) === "end" && styles95["TableHeadingSortButton-heading-align-end-currently-sorted"], isPreviouslySorted && !isRenderAfterSelectEvent && (heading === null || heading === void 0 ? void 0 : heading.alignment) === "end" && styles95["TableHeadingSortButton-heading-align-end-previously-sorted"]),
        tabIndex: selectMode ? -1 : 0
      };
      const sortMarkup = import_react731.default.createElement(UnstyledButton, defaultSortButtonProps, iconMarkup, import_react731.default.createElement("span", {
        className: classNames(sortToggleLabels && selectMode && heading.tooltipContent && styles95.TableHeadingTooltipUnderlinePlaceholder)
      }, headingContent));
      if (!sortToggleLabels || selectMode) {
        return import_react731.default.createElement("div", {
          className: styles95.SortableTableHeadingWithCustomMarkup
        }, sortMarkup);
      }
      const tooltipDirection = isCurrentlySorted ? sortDirection : newDirection;
      const sortTooltipContent = sortToggleLabels[index][tooltipDirection];
      if (!heading.tooltipContent) {
        return (
          // Regular header with sort icon and sort direction tooltip
          import_react731.default.createElement(Tooltip, Object.assign({}, defaultTooltipProps, {
            content: sortTooltipContent,
            preferredPosition: "above"
          }), sortMarkup)
        );
      }
      if (heading.tooltipContent) {
        return (
          // Header text and sort icon have separate tooltips
          import_react731.default.createElement("div", {
            className: styles95.SortableTableHeadingWithCustomMarkup
          }, import_react731.default.createElement(UnstyledButton, defaultSortButtonProps, import_react731.default.createElement(Tooltip, defaultHeaderTooltipProps, import_react731.default.createElement("span", {
            className: styles95.TableHeadingUnderline
          }, headingContent)), import_react731.default.createElement(Tooltip, Object.assign({}, defaultTooltipProps, {
            content: sortTooltipContent,
            preferredPosition: "above"
          }), iconMarkup)))
        );
      }
    }
    if (heading.tooltipContent) {
      return (
        // Non-sortable header with tooltip
        import_react731.default.createElement(Tooltip, Object.assign({}, defaultHeaderTooltipProps, {
          activatorWrapper: "span"
        }), import_react731.default.createElement("span", {
          className: classNames(styles95.TableHeadingUnderline, styles95.SortableTableHeaderWrapper)
        }, headingContent))
      );
    }
    return headingContent;
  }
  function handleSelectPage(checked) {
    handleSelectionChange(SelectionType2.Page, checked);
  }
  function renderStickyHeading(heading, index) {
    const position = index + 1;
    const headingStyle = tableHeadingRects.current && tableHeadingRects.current.length > position ? {
      minWidth: tableHeadingRects.current[position].offsetWidth
    } : void 0;
    const headingAlignment = heading.alignment || "start";
    const headingContent = renderHeadingContent(heading, index);
    const stickyHeadingClassName = classNames(styles95.TableHeading, headingAlignment === "center" && styles95["TableHeading-align-center"], headingAlignment === "end" && styles95["TableHeading-align-end"], index === 0 && styles95["StickyTableHeading-second"], index === 0 && !selectable && styles95.unselectable);
    return import_react731.default.createElement("div", {
      className: stickyHeadingClassName,
      key: getHeadingKey(heading),
      style: headingStyle,
      "data-index-table-sticky-heading": true
    }, headingContent);
  }
  function getPaginatedSelectAllAction() {
    if (!selectable || !hasBulkActions || !hasMoreItems) {
      return;
    }
    const customActionText = paginatedSelectAllActionText !== null && paginatedSelectAllActionText !== void 0 ? paginatedSelectAllActionText : i18n.translate("Polaris.IndexTable.selectAllItems", {
      itemsLength: itemCount,
      resourceNamePlural: resourceName.plural.toLocaleLowerCase()
    });
    const actionText = selectedItemsCount === SELECT_ALL_ITEMS ? i18n.translate("Polaris.IndexTable.undo") : customActionText;
    return {
      content: actionText,
      onAction: handleSelectAllItemsInStore
    };
  }
  function handleSelectModeToggle() {
    handleSelectionChange(SelectionType2.All, false);
  }
}
var isBreakpointsXS = () => {
  var _toPx;
  return typeof window === "undefined" ? false : window.innerWidth < parseFloat((_toPx = toPx(tokens.breakpoints["breakpoints-sm"])) !== null && _toPx !== void 0 ? _toPx : "");
};
function getHeadingKey(heading) {
  if ("id" in heading && heading.id) {
    return heading.id;
  }
  if (typeof heading.title === "string") {
    return heading.title;
  }
  return "";
}
function IndexTable({
  children: children2,
  selectable = true,
  itemCount,
  selectedItemsCount = 0,
  resourceName: passedResourceName,
  loading,
  hasMoreItems,
  condensed,
  onSelectionChange,
  ...indexTableBaseProps
}) {
  return import_react731.default.createElement(IndexProvider, {
    selectable: selectable && !condensed,
    itemCount,
    selectedItemsCount,
    resourceName: passedResourceName,
    loading,
    hasMoreItems,
    condensed,
    onSelectionChange
  }, import_react731.default.createElement(IndexTableBase, indexTableBaseProps, children2));
}
IndexTable.Cell = Cell3;
IndexTable.Row = Row;

// ../node_modules/@shopify/polaris/build/esm/components/InlineCode/InlineCode.js
var import_react732 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/InlineCode/InlineCode.scss.js
var styles100 = {
  "Code": "Polaris-InlineCode__Code"
};

// ../node_modules/@shopify/polaris/build/esm/components/InlineCode/InlineCode.js
var InlineCode = ({
  children: children2
}) => import_react732.default.createElement("code", {
  className: styles100.Code
}, children2);

// ../node_modules/@shopify/polaris/build/esm/components/KeyboardKey/KeyboardKey.js
var import_react733 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/KeyboardKey/KeyboardKey.scss.js
var styles101 = {
  "KeyboardKey": "Polaris-KeyboardKey",
  "small": "Polaris-KeyboardKey--small"
};

// ../node_modules/@shopify/polaris/build/esm/components/KeyboardKey/KeyboardKey.js
function KeyboardKey({
  children: children2 = "",
  size
}) {
  const key = !size && children2.length > 1 ? children2.toLowerCase() : children2.toUpperCase();
  const className = classNames(styles101.KeyboardKey, size && styles101[size]);
  return import_react733.default.createElement("kbd", {
    className
  }, key);
}

// ../node_modules/@shopify/polaris/build/esm/components/KonamiCode/KonamiCode.js
var import_react734 = __toESM(require_react());
var KONAMI_CODE = [Key.UpArrow, Key.UpArrow, Key.DownArrow, Key.DownArrow, Key.LeftArrow, Key.RightArrow, Key.LeftArrow, Key.RightArrow, Key.KeyB, Key.KeyA];
function KonamiCode({
  handler
}) {
  const keyEvent = "keydown";
  const position = (0, import_react734.useRef)(0);
  const handleKeyEvent = (event) => {
    const key = event.keyCode;
    const requiredKey = KONAMI_CODE[position.current];
    if (key === requiredKey) {
      if (position.current === KONAMI_CODE.length - 1) {
        handler(event);
        position.current = 0;
      } else {
        position.current++;
      }
    } else {
      position.current = 0;
    }
  };
  (0, import_react734.useEffect)(() => {
    document.addEventListener(keyEvent, handleKeyEvent);
    return () => {
      document.removeEventListener(keyEvent, handleKeyEvent);
    };
  });
  return null;
}

// ../node_modules/@shopify/polaris/build/esm/components/Layout/Layout.js
var import_react737 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Layout/Layout.scss.js
var styles102 = {
  "Layout": "Polaris-Layout",
  "Section": "Polaris-Layout__Section",
  "Section-secondary": "Polaris-Layout__Section--secondary",
  "Section-fullWidth": "Polaris-Layout__Section--fullWidth",
  "Section-oneHalf": "Polaris-Layout__Section--oneHalf",
  "Section-oneThird": "Polaris-Layout__Section--oneThird",
  "AnnotatedSection": "Polaris-Layout__AnnotatedSection",
  "AnnotationWrapper": "Polaris-Layout__AnnotationWrapper",
  "AnnotationContent": "Polaris-Layout__AnnotationContent",
  "Annotation": "Polaris-Layout__Annotation"
};

// ../node_modules/@shopify/polaris/build/esm/components/Layout/components/AnnotatedSection/AnnotatedSection.js
var import_react735 = __toESM(require_react());
function AnnotatedSection({
  children: children2,
  title,
  description,
  id
}) {
  const descriptionMarkup = typeof description === "string" ? import_react735.default.createElement("p", null, description) : description;
  return import_react735.default.createElement("div", {
    className: styles102.AnnotatedSection
  }, import_react735.default.createElement("div", {
    className: styles102.AnnotationWrapper
  }, import_react735.default.createElement("div", {
    className: styles102.Annotation
  }, import_react735.default.createElement(TextContainer, null, import_react735.default.createElement(Text, {
    id,
    variant: "headingMd",
    as: "h2"
  }, title), descriptionMarkup && import_react735.default.createElement(Box, {
    color: "text-subdued"
  }, descriptionMarkup))), import_react735.default.createElement("div", {
    className: styles102.AnnotationContent
  }, children2)));
}

// ../node_modules/@shopify/polaris/build/esm/components/Layout/components/Section/Section.js
var import_react736 = __toESM(require_react());
function Section7({
  children: children2,
  secondary,
  fullWidth,
  oneHalf,
  oneThird
}) {
  const className = classNames(styles102.Section, secondary && styles102["Section-secondary"], fullWidth && styles102["Section-fullWidth"], oneHalf && styles102["Section-oneHalf"], oneThird && styles102["Section-oneThird"]);
  return import_react736.default.createElement("div", {
    className
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/Layout/Layout.js
var Layout = function Layout2({
  sectioned,
  children: children2
}) {
  const content = sectioned ? import_react737.default.createElement(Section7, null, children2) : children2;
  return import_react737.default.createElement("div", {
    className: styles102.Layout
  }, content);
};
Layout.AnnotatedSection = AnnotatedSection;
Layout.Section = Section7;

// ../node_modules/@shopify/polaris/build/esm/components/LegacyFilters/LegacyFilters.js
var import_react741 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/LegacyFilters/LegacyFilters.scss.js
var styles103 = {
  "LegacyFilters": "Polaris-LegacyFilters",
  "LegacyFiltersContainer": "Polaris-LegacyFilters__LegacyFiltersContainer",
  "LegacyFiltersContainerHeader": "Polaris-LegacyFilters__LegacyFiltersContainerHeader",
  "LegacyFiltersDesktopContainerContent": "Polaris-LegacyFilters__LegacyFiltersDesktopContainerContent",
  "LegacyFiltersMobileContainerContent": "Polaris-LegacyFilters__LegacyFiltersMobileContainerContent",
  "LegacyFiltersContainerFooter": "Polaris-LegacyFilters__LegacyFiltersContainerFooter",
  "LegacyFiltersMobileContainerFooter": "Polaris-LegacyFilters__LegacyFiltersMobileContainerFooter",
  "EmptyFooterState": "Polaris-LegacyFilters__EmptyFooterState",
  "FilterTriggerContainer": "Polaris-LegacyFilters__FilterTriggerContainer",
  "FilterTrigger": "Polaris-LegacyFilters__FilterTrigger",
  "FilterTriggerTitle": "Polaris-LegacyFilters__FilterTriggerTitle",
  "AppliedFilterBadgeContainer": "Polaris-LegacyFilters__AppliedFilterBadgeContainer",
  "open": "Polaris-LegacyFilters--open",
  "FilterTriggerLabelContainer": "Polaris-LegacyFilters__FilterTriggerLabelContainer",
  "first": "Polaris-LegacyFilters--first",
  "last": "Polaris-LegacyFilters--last",
  "FilterNodeContainer": "Polaris-LegacyFilters__FilterNodeContainer",
  "SearchIcon": "Polaris-LegacyFilters__SearchIcon",
  "Backdrop": "Polaris-LegacyFilters__Backdrop",
  "HelpText": "Polaris-LegacyFilters__HelpText",
  "TagsContainer": "Polaris-LegacyFilters__TagsContainer"
};

// ../node_modules/@shopify/polaris/build/esm/components/LegacyFilters/components/ConnectedFilterControl/ConnectedFilterControl.js
var import_react739 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/LegacyFilters/components/ConnectedFilterControl/ConnectedFilterControl.scss.js
var styles104 = {
  "ConnectedFilterControl": "Polaris-LegacyFilters-ConnectedFilterControl",
  "CenterContainer": "Polaris-LegacyFilters-ConnectedFilterControl__CenterContainer",
  "right": "Polaris-LegacyFilters-ConnectedFilterControl--right",
  "Item": "Polaris-LegacyFilters-ConnectedFilterControl__Item",
  "Item-focused": "Polaris-LegacyFilters-ConnectedFilterControl__Item--focused",
  "ProxyButtonContainer": "Polaris-LegacyFilters-ConnectedFilterControl__ProxyButtonContainer",
  "RightContainer": "Polaris-LegacyFilters-ConnectedFilterControl__RightContainer",
  "MoreFiltersButtonContainer": "Polaris-LegacyFilters-ConnectedFilterControl__MoreFiltersButtonContainer",
  "queryFieldHidden": "Polaris-LegacyFilters-ConnectedFilterControl--queryFieldHidden",
  "RightContainerWithoutMoreFilters": "Polaris-LegacyFilters-ConnectedFilterControl__RightContainerWithoutMoreFilters",
  "onlyButtonVisible": "Polaris-LegacyFilters-ConnectedFilterControl--onlyButtonVisible",
  "Wrapper": "Polaris-LegacyFilters-ConnectedFilterControl__Wrapper",
  "AuxiliaryContainer": "Polaris-LegacyFilters-ConnectedFilterControl__AuxiliaryContainer"
};

// ../node_modules/@shopify/polaris/build/esm/components/LegacyFilters/components/ConnectedFilterControl/components/Item/Item.js
var import_react738 = __toESM(require_react());
function Item9({
  children: children2
}) {
  const {
    value: focused,
    setTrue: forceTrueFocused,
    setFalse: forceFalseFocused
  } = useToggle(false);
  const className = classNames(styles104.Item, focused && styles104["Item-focused"]);
  return import_react738.default.createElement("div", {
    onBlur: forceFalseFocused,
    onFocus: forceTrueFocused,
    className
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/LegacyFilters/components/ConnectedFilterControl/ConnectedFilterControl.js
var FILTER_FIELD_MIN_WIDTH2 = 150;
var ConnectedFilterControl2 = class extends import_react739.Component {
  constructor(...args) {
    super(...args);
    this.state = {
      availableWidth: 0,
      proxyButtonsWidth: {}
    };
    this.container = (0, import_react739.createRef)();
    this.proxyButtonContainer = (0, import_react739.createRef)();
    this.moreFiltersButtonContainer = (0, import_react739.createRef)();
    this.handleResize = debounce(() => {
      this.measureProxyButtons();
      this.measureAvailableWidth();
    }, 40, {
      leading: true,
      trailing: true,
      maxWait: 40
    });
  }
  componentDidMount() {
    this.handleResize();
  }
  render() {
    const {
      children: children2,
      rightPopoverableActions,
      rightAction,
      auxiliary,
      forceShowMorefiltersButton = true,
      queryFieldHidden
    } = this.props;
    const actionsToRender = rightPopoverableActions != null ? this.getActionsToRender(rightPopoverableActions) : [];
    const className = classNames(styles104.ConnectedFilterControl, rightPopoverableActions && styles104.right);
    const shouldRenderMoreFiltersButton = forceShowMorefiltersButton || rightPopoverableActions && rightPopoverableActions.length !== actionsToRender.length;
    const RightContainerClassName = classNames(styles104.RightContainer, !shouldRenderMoreFiltersButton && styles104.RightContainerWithoutMoreFilters, queryFieldHidden && styles104.queryFieldHidden);
    const rightMarkup = actionsToRender.length > 0 ? import_react739.default.createElement("div", {
      className: RightContainerClassName
    }, this.popoverFrom(actionsToRender)) : null;
    const moreFiltersButtonContainerClassname = classNames(styles104.MoreFiltersButtonContainer, actionsToRender.length === 0 && styles104.onlyButtonVisible);
    const rightActionMarkup = rightAction ? import_react739.default.createElement("div", {
      ref: this.moreFiltersButtonContainer,
      className: moreFiltersButtonContainerClassname
    }, shouldRenderMoreFiltersButton && import_react739.default.createElement(Item9, null, rightAction)) : null;
    const proxyButtonMarkup = rightPopoverableActions ? import_react739.default.createElement("div", {
      className: styles104.ProxyButtonContainer,
      ref: this.proxyButtonContainer,
      "aria-hidden": true
    }, rightPopoverableActions.map((action) => import_react739.default.createElement("div", {
      key: action.key,
      "data-key": action.key
    }, this.activatorButtonFrom(action, {
      proxy: true
    })))) : null;
    const auxMarkup = auxiliary ? import_react739.default.createElement("div", {
      className: styles104.AuxiliaryContainer
    }, auxiliary) : null;
    return import_react739.default.createElement(import_react739.default.Fragment, null, proxyButtonMarkup, import_react739.default.createElement("div", {
      className: styles104.Wrapper
    }, import_react739.default.createElement("div", {
      className,
      ref: this.container
    }, children2 ? import_react739.default.createElement("div", {
      className: styles104.CenterContainer
    }, import_react739.default.createElement(Item9, null, children2)) : null, rightMarkup, rightActionMarkup, import_react739.default.createElement(EventListener, {
      event: "resize",
      handler: this.handleResize
    })), auxMarkup));
  }
  measureProxyButtons() {
    if (this.proxyButtonContainer.current) {
      const proxyButtonsWidth = {};
      const tolerance = 78;
      if (this.proxyButtonContainer.current) {
        Array.from(this.proxyButtonContainer.current.children).forEach((element) => {
          const buttonWidth = element.getBoundingClientRect().width + tolerance;
          const buttonKey = element instanceof HTMLElement && element.dataset.key;
          if (buttonKey) {
            proxyButtonsWidth[buttonKey] = buttonWidth;
          }
        });
      }
      this.setState({
        proxyButtonsWidth
      });
    }
  }
  measureAvailableWidth() {
    if (this.container.current && this.moreFiltersButtonContainer.current) {
      const containerWidth = this.container.current.getBoundingClientRect().width;
      const moreFiltersButtonWidth = this.moreFiltersButtonContainer.current.getBoundingClientRect().width;
      const filtersActionWidth = 0;
      const filterFieldMinWidth = this.props.queryFieldHidden ? 0 : FILTER_FIELD_MIN_WIDTH2;
      const availableWidth = containerWidth - filterFieldMinWidth - moreFiltersButtonWidth - filtersActionWidth;
      this.setState({
        availableWidth
      });
    }
  }
  getActionsToRender(actions) {
    let remainingWidth = this.state.availableWidth;
    const actionsToReturn = [];
    for (let i = 0; remainingWidth > 0 && i < actions.length; i++) {
      const action = actions[i];
      const actionWidth = this.state.proxyButtonsWidth[action.key];
      if (actionWidth <= remainingWidth) {
        actionsToReturn.push(action);
        remainingWidth -= actionWidth;
      } else {
        break;
      }
    }
    return actionsToReturn;
  }
  activatorButtonFrom(action, options) {
    const id = options !== null && options !== void 0 && options.proxy ? void 0 : `Activator-${action.key}`;
    return import_react739.default.createElement(Button, {
      onClick: action.onAction,
      disclosure: true,
      disabled: this.props.disabled || action.disabled,
      id
    }, action.content);
  }
  popoverFrom(actions) {
    return actions.map((action) => {
      return import_react739.default.createElement(Item9, {
        key: action.key
      }, import_react739.default.createElement(Popover2, {
        active: action.popoverOpen,
        activator: this.activatorButtonFrom(action),
        onClose: action.onAction,
        preferredAlignment: "left",
        sectioned: true
      }, action.popoverContent));
    });
  }
};

// ../node_modules/@shopify/polaris/build/esm/components/LegacyFilters/components/TagsWrapper/TagsWrapper.js
var import_react740 = __toESM(require_react());
function TagsWrapper2({
  children: children2,
  hidden
}) {
  if (hidden) {
    return import_react740.default.createElement(Text, {
      as: "span",
      visuallyHidden: true
    }, children2);
  }
  return import_react740.default.createElement(import_react740.default.Fragment, null, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/LegacyFilters/LegacyFilters.js
var Suffix2;
(function(Suffix3) {
  Suffix3["Filter"] = "Filter";
  Suffix3["Shortcut"] = "Shortcut";
})(Suffix2 || (Suffix2 = {}));
var LegacyFiltersInner = class extends import_react741.Component {
  constructor(...args) {
    super(...args);
    this.context = void 0;
    this.state = {
      open: false,
      readyForFocus: false
    };
    this.moreFiltersButtonContainer = (0, import_react741.createRef)();
    this.moreFiltersDoneButtonContainer = (0, import_react741.createRef)();
    this.focusNode = (0, import_react741.createRef)();
    this.closeFilters = () => {
      this.setState({
        open: false
      }, () => {
        if (this.moreFiltersButtonContainer.current) {
          focusFirstFocusableNode(this.moreFiltersButtonContainer.current, false);
        }
      });
    };
    this.toggleFilters = () => {
      if (this.state.open === true) {
        this.closeFilters();
      } else {
        this.openFilters();
      }
    };
    this.setReadyForFocus = (newState) => () => {
      this.setState({
        readyForFocus: newState
      });
    };
    this.handleClearAll = () => {
      this.props.onClearAll();
      this.moreFiltersDoneButtonContainer.current && focusFirstFocusableNode(this.moreFiltersDoneButtonContainer.current, false);
    };
  }
  render() {
    const {
      filters,
      queryValue,
      onQueryBlur,
      onQueryChange,
      onQueryFocus,
      focused,
      onClearAll,
      appliedFilters,
      onQueryClear,
      queryPlaceholder,
      children: children2,
      disabled = false,
      helpText,
      hideTags,
      hideQueryField,
      disableQueryField = false,
      i18n,
      mediaQuery: {
        isNavigationCollapsed
      }
    } = this.props;
    const {
      resourceName
    } = this.context;
    const {
      open,
      readyForFocus
    } = this.state;
    const backdropMarkup = open ? import_react741.default.createElement(import_react741.default.Fragment, null, import_react741.default.createElement(ScrollLock, null), import_react741.default.createElement("div", {
      className: styles103.Backdrop,
      onClick: this.closeFilters
    })) : null;
    const filtersContentMarkup = filters.map((filter, index) => {
      const filterIsOpen = this.state[`${filter.key}${Suffix2.Filter}`] === true;
      const icon = filterIsOpen ? SvgChevronUpMinor : SvgChevronDownMinor;
      const className = classNames(styles103.FilterTriggerContainer, filterIsOpen && styles103.open, index === 0 && styles103.first, filters.length !== 1 && index === filters.length - 1 && styles103.last);
      const appliedFilterContent = this.getAppliedFilterContent(filter.key);
      const appliedFilterBadgeMarkup = appliedFilterContent ? import_react741.default.createElement("div", {
        className: styles103.AppliedFilterBadgeContainer
      }, import_react741.default.createElement(Badge, {
        status: "new"
      }, appliedFilterContent)) : null;
      const collapsibleID = `${filter.key}Collapsible`;
      const buttonClassName = classNames(styles103.FilterTrigger);
      return import_react741.default.createElement("div", {
        key: filter.key,
        className
      }, import_react741.default.createElement("button", {
        onClick: () => this.toggleFilter(filter.key),
        className: buttonClassName,
        id: `${filter.key}ToggleButton`,
        type: "button",
        "aria-controls": collapsibleID,
        "aria-expanded": filterIsOpen
      }, import_react741.default.createElement("div", {
        className: styles103.FilterTriggerLabelContainer
      }, import_react741.default.createElement("h3", {
        className: styles103.FilterTriggerTitle
      }, import_react741.default.createElement(Text, {
        as: "span",
        color: this.props.disabled || filter.disabled ? "subdued" : void 0
      }, filter.label)), import_react741.default.createElement("span", {
        className: styles103.FilterTriggerIcon
      }, import_react741.default.createElement(Icon, {
        source: icon,
        color: "base"
      }))), appliedFilterBadgeMarkup), import_react741.default.createElement(Collapsible, {
        id: collapsibleID,
        open: filterIsOpen,
        onAnimationEnd: this.setReadyForFocus(true)
      }, import_react741.default.createElement("div", {
        className: styles103.FilterNodeContainer
      }, import_react741.default.createElement(Focus, {
        disabled: !filterIsOpen || !readyForFocus || !open,
        root: this.focusNode
      }, this.generateFilterMarkup(filter)))));
    });
    const appliedFiltersCount = appliedFilters ? appliedFilters.length : 0;
    const moreFiltersLabel = hideTags && appliedFiltersCount > 0 ? i18n.translate("Polaris.Filters.moreFiltersWithCount", {
      count: appliedFiltersCount
    }) : i18n.translate("Polaris.Filters.moreFilters");
    const rightActionMarkup = filters.length ? import_react741.default.createElement("div", {
      ref: this.moreFiltersButtonContainer
    }, import_react741.default.createElement(Button, {
      onClick: this.toggleFilters,
      disabled
    }, moreFiltersLabel)) : null;
    const filterResourceName = resourceName || {
      singular: i18n.translate("Polaris.ResourceList.defaultItemSingular"),
      plural: i18n.translate("Polaris.ResourceList.defaultItemPlural")
    };
    const transformedFilters = this.transformFilters(filters);
    const filtersControlMarkup = import_react741.default.createElement(ConnectedFilterControl2, {
      rightPopoverableActions: transformedFilters,
      rightAction: rightActionMarkup,
      auxiliary: children2,
      disabled,
      forceShowMorefiltersButton: filters.length > transformedFilters.length,
      queryFieldHidden: hideQueryField
    }, hideQueryField ? null : import_react741.default.createElement(TextField, {
      placeholder: queryPlaceholder || i18n.translate("Polaris.Filters.filter", {
        resourceName: filterResourceName.plural
      }),
      onChange: onQueryChange,
      onBlur: onQueryBlur,
      onFocus: onQueryFocus,
      value: queryValue,
      focused,
      label: queryPlaceholder || i18n.translate("Polaris.Filters.filter", {
        resourceName: filterResourceName.plural
      }),
      labelHidden: true,
      prefix: import_react741.default.createElement("span", {
        className: styles103.SearchIcon
      }, import_react741.default.createElement(Icon, {
        source: SvgSearchMinor
      })),
      clearButton: true,
      onClearButtonClick: onQueryClear,
      disabled: disabled || disableQueryField,
      autoComplete: "off"
    }));
    const filtersContainerHeaderClassname = classNames(styles103.LegacyFiltersContainerHeader);
    const filtersDesktopHeaderMarkup = import_react741.default.createElement("div", {
      className: filtersContainerHeaderClassname
    }, import_react741.default.createElement(Text, {
      variant: "headingLg",
      as: "h3"
    }, moreFiltersLabel), import_react741.default.createElement(Button, {
      icon: SvgCancelSmallMinor,
      plain: true,
      accessibilityLabel: i18n.translate("Polaris.Filters.cancel"),
      onClick: this.closeFilters
    }));
    const filtersMobileHeaderMarkup = import_react741.default.createElement("div", {
      className: filtersContainerHeaderClassname
    }, import_react741.default.createElement(Button, {
      icon: SvgCancelSmallMinor,
      plain: true,
      accessibilityLabel: i18n.translate("Polaris.Filters.cancel"),
      onClick: this.closeFilters
    }), import_react741.default.createElement(Text, {
      variant: "headingLg",
      as: "h3"
    }, moreFiltersLabel), import_react741.default.createElement(Button, {
      onClick: this.closeFilters,
      primary: true
    }, i18n.translate("Polaris.Filters.done")));
    const filtersDesktopFooterClassname = classNames(styles103.LegacyFiltersContainerFooter);
    const filtersDesktopFooterMarkup = import_react741.default.createElement("div", {
      className: filtersDesktopFooterClassname
    }, import_react741.default.createElement(Button, {
      onClick: this.handleClearAll,
      disabled: !this.hasAppliedFilters()
    }, i18n.translate("Polaris.Filters.clearAllFilters")), import_react741.default.createElement("div", {
      ref: this.moreFiltersDoneButtonContainer
    }, import_react741.default.createElement(Button, {
      onClick: this.closeFilters,
      primary: true
    }, i18n.translate("Polaris.Filters.done"))));
    const filtersMobileFooterMarkup = import_react741.default.createElement("div", {
      className: styles103.LegacyFiltersMobileContainerFooter
    }, this.hasAppliedFilters() ? import_react741.default.createElement(Button, {
      onClick: onClearAll,
      fullWidth: true
    }, i18n.translate("Polaris.Filters.clearAllFilters")) : import_react741.default.createElement("div", {
      className: styles103.EmptyFooterState
    }, import_react741.default.createElement(Text, {
      color: "subdued",
      as: "span"
    }, import_react741.default.createElement("p", null, i18n.translate("Polaris.Filters.noFiltersApplied")))));
    const shouldHideTagsContainer = !appliedFilters || appliedFilters.length < 1;
    const tagsMarkup = !hideTags ? import_react741.default.createElement(TagsWrapper2, {
      hidden: shouldHideTagsContainer
    }, import_react741.default.createElement("div", {
      className: styles103.TagsContainer,
      "aria-live": "polite"
    }, (appliedFilters || []).map((filter) => {
      return import_react741.default.createElement(Tag, {
        key: filter.key,
        onRemove: () => {
          filter.onRemove(filter.key);
        },
        disabled
      }, filter.label);
    }))) : null;
    const filtersMobileContainerContentClassName = classNames(styles103.LegacyFiltersMobileContainerContent);
    const filtersDesktopContainerContentClassName = classNames(styles103.LegacyFiltersDesktopContainerContent);
    const filtersContainerMarkup = isNavigationCollapsed ? import_react741.default.createElement(Sheet, {
      accessibilityLabel: moreFiltersLabel,
      open,
      onClose: this.closeFilters,
      onEntered: this.setReadyForFocus(true),
      onExit: this.setReadyForFocus(false)
    }, filtersMobileHeaderMarkup, import_react741.default.createElement(Scrollable, {
      className: filtersMobileContainerContentClassName,
      shadow: true
    }, filtersContentMarkup, filtersMobileFooterMarkup)) : import_react741.default.createElement(Sheet, {
      accessibilityLabel: moreFiltersLabel,
      open,
      onClose: this.closeFilters,
      onEntered: this.setReadyForFocus(true),
      onExit: this.setReadyForFocus(false)
    }, import_react741.default.createElement("div", {
      className: styles103.LegacyFiltersContainer
    }, filtersDesktopHeaderMarkup, import_react741.default.createElement(Scrollable, {
      className: filtersDesktopContainerContentClassName,
      shadow: true
    }, filtersContentMarkup), filtersDesktopFooterMarkup));
    const helpTextMarkup = helpText ? import_react741.default.createElement("div", {
      id: "FiltersHelpText",
      className: styles103.HelpText
    }, import_react741.default.createElement(Text, {
      color: "subdued",
      as: "span"
    }, helpText)) : null;
    return import_react741.default.createElement(WithinFilterContext.Provider, {
      value: true
    }, import_react741.default.createElement("div", {
      className: styles103.LegacyFilters
    }, filtersControlMarkup, filtersContainerMarkup, tagsMarkup, helpTextMarkup, backdropMarkup, import_react741.default.createElement(KeypressListener, {
      keyCode: Key.Escape,
      handler: this.closeFilters
    })));
  }
  hasAppliedFilters() {
    const {
      appliedFilters,
      queryValue
    } = this.props;
    const filtersApplied = Boolean(appliedFilters && appliedFilters.length > 0);
    const queryApplied = Boolean(queryValue && queryValue !== "");
    return filtersApplied || queryApplied;
  }
  getAppliedFilterContent(key) {
    const {
      appliedFilters
    } = this.props;
    if (!appliedFilters) {
      return void 0;
    }
    const filter = appliedFilters.find((filter2) => filter2.key === key);
    return filter == null ? void 0 : filter.label;
  }
  getAppliedFilterRemoveHandler(key) {
    const {
      appliedFilters
    } = this.props;
    if (!appliedFilters) {
      return void 0;
    }
    const filter = appliedFilters.find((filter2) => filter2.key === key);
    return filter == null ? void 0 : filter.onRemove;
  }
  openFilters() {
    this.setState({
      open: true
    });
  }
  toggleFilter(key) {
    if (this.state[`${key}${Suffix2.Filter}`] === true) {
      this.setState({
        readyForFocus: false,
        [`${key}${Suffix2.Filter}`]: false
      });
    } else {
      this.setState({
        readyForFocus: false,
        [`${key}${Suffix2.Filter}`]: true
      });
    }
  }
  openFilterShortcut(key) {
    this.setState({
      [`${key}${Suffix2.Shortcut}`]: true
    });
  }
  closeFilterShortcut(key) {
    this.setState({
      [`${key}${Suffix2.Shortcut}`]: false
    });
  }
  toggleFilterShortcut(key) {
    if (this.state[`${key}${Suffix2.Shortcut}`] === true) {
      this.closeFilterShortcut(key);
    } else {
      this.openFilterShortcut(key);
    }
  }
  transformFilters(filters) {
    const transformedActions = [];
    getShortcutFilters2(filters).forEach((filter) => {
      const {
        key,
        label,
        disabled
      } = filter;
      transformedActions.push({
        popoverContent: this.generateFilterMarkup(filter),
        popoverOpen: Boolean(this.state[`${key}${Suffix2.Shortcut}`]),
        key,
        content: label,
        disabled,
        onAction: () => this.toggleFilterShortcut(key)
      });
    });
    return transformedActions;
  }
  generateFilterMarkup(filter) {
    const i18n = this.props.i18n;
    const removeCallback = this.getAppliedFilterRemoveHandler(filter.key);
    const removeHandler = removeCallback == null ? void 0 : () => {
      removeCallback(filter.key);
    };
    const clearButtonMarkup = !filter.hideClearButton && import_react741.default.createElement(Button, {
      plain: true,
      disabled: removeHandler == null,
      onClick: removeHandler,
      accessibilityLabel: i18n.translate("Polaris.Filters.clearLabel", {
        filterName: filter.label
      })
    }, i18n.translate("Polaris.Filters.clear"));
    return import_react741.default.createElement("div", {
      ref: this.focusNode
    }, import_react741.default.createElement(LegacyStack, {
      vertical: true,
      spacing: "tight"
    }, filter.filter, clearButtonMarkup));
  }
};
LegacyFiltersInner.contextType = ResourceListContext;
function getShortcutFilters2(filters) {
  return filters.filter((filter) => filter.shortcut === true);
}
function LegacyFilters(props) {
  const i18n = useI18n();
  const mediaQuery = useMediaQuery();
  return import_react741.default.createElement(LegacyFiltersInner, Object.assign({}, props, {
    i18n,
    mediaQuery
  }));
}

// ../node_modules/@shopify/polaris/build/esm/components/LegacyTabs/LegacyTabs.js
var import_react747 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/LegacyTabs/utilities.js
function getVisibleAndHiddenTabIndices2(tabs, selected, disclosureWidth, tabWidths, containerWidth) {
  const sumTabWidths = tabWidths.reduce((sum, width) => sum + width, 0);
  const arrayOfTabIndices = tabs.map((_, index) => {
    return index;
  });
  const visibleTabs = [];
  const hiddenTabs = [];
  if (containerWidth > sumTabWidths) {
    visibleTabs.push(...arrayOfTabIndices);
  } else {
    visibleTabs.push(selected);
    let tabListWidth = tabWidths[selected];
    arrayOfTabIndices.forEach((currentTabIndex) => {
      if (currentTabIndex !== selected) {
        const currentTabWidth = tabWidths[currentTabIndex];
        if (tabListWidth + currentTabWidth >= containerWidth - disclosureWidth) {
          hiddenTabs.push(currentTabIndex);
          return;
        }
        visibleTabs.push(currentTabIndex);
        tabListWidth += currentTabWidth;
      }
    });
  }
  return {
    visibleTabs,
    hiddenTabs
  };
}

// ../node_modules/@shopify/polaris/build/esm/components/LegacyTabs/LegacyTabs.scss.js
var styles105 = {
  "LegacyTabs": "Polaris-LegacyTabs",
  "fitted": "Polaris-LegacyTabs--fitted",
  "TabContainer": "Polaris-LegacyTabs__TabContainer",
  "Title": "Polaris-LegacyTabs__Title",
  "fillSpace": "Polaris-LegacyTabs--fillSpace",
  "Tab": "Polaris-LegacyTabs__Tab",
  "Tab-selected": "Polaris-LegacyTabs__Tab--selected",
  "titleWithIcon": "Polaris-LegacyTabs--titleWithIcon",
  "Panel": "Polaris-LegacyTabs__Panel",
  "Panel-hidden": "Polaris-LegacyTabs__Panel--hidden",
  "Item": "Polaris-LegacyTabs__Item",
  "DisclosureTab": "Polaris-LegacyTabs__DisclosureTab",
  "DisclosureTab-visible": "Polaris-LegacyTabs__DisclosureTab--visible",
  "DisclosureActivator": "Polaris-LegacyTabs__DisclosureActivator",
  "TabMeasurer": "Polaris-LegacyTabs__TabMeasurer"
};

// ../node_modules/@shopify/polaris/build/esm/components/LegacyTabs/components/Panel/Panel.js
var import_react742 = __toESM(require_react());
function Panel2({
  hidden,
  id,
  tabID,
  children: children2
}) {
  const className = classNames(styles105.Panel, hidden && styles105["Panel-hidden"]);
  return import_react742.default.createElement("div", {
    className,
    id,
    role: "tabpanel",
    "aria-labelledby": tabID,
    tabIndex: -1
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/LegacyTabs/components/TabMeasurer/TabMeasurer.js
var import_react744 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/LegacyTabs/components/Tab/Tab.js
var import_react743 = __toESM(require_react());
function Tab2({
  id,
  focused,
  siblingTabHasFocus,
  children: children2,
  onClick,
  selected,
  url,
  panelID,
  measuring,
  accessibilityLabel
}) {
  const wasSelected = (0, import_react743.useRef)(selected);
  const panelFocused = (0, import_react743.useRef)(false);
  const node = (0, import_react743.useRef)(null);
  (0, import_react743.useEffect)(() => {
    if (measuring) {
      return;
    }
    const itemHadFocus = focused || document.activeElement && document.activeElement.id === id;
    if (itemHadFocus && selected && panelID != null && !panelFocused.current) {
      focusPanelID2(panelID);
      panelFocused.current = true;
    }
    if (selected && !wasSelected.current && panelID != null) {
      focusPanelID2(panelID);
    } else if (focused && node.current != null) {
      focusFirstFocusableNode(node.current);
    }
    wasSelected.current = selected;
  }, [focused, id, measuring, panelID, selected]);
  const handleClick = onClick && onClick.bind(null, id);
  const className = classNames(styles105.Tab, selected && styles105["Tab-selected"]);
  let tabIndex;
  if (selected && !siblingTabHasFocus && !measuring) {
    tabIndex = 0;
  } else if (focused && !measuring) {
    tabIndex = 0;
  } else {
    tabIndex = -1;
  }
  const tabContainerClassNames = classNames(styles105.TabContainer, selected && styles105.Underline);
  const markup = url ? import_react743.default.createElement(UnstyledLink, {
    id,
    url,
    role: "tab",
    tabIndex,
    onClick: handleClick,
    className,
    "aria-selected": selected,
    "aria-controls": panelID,
    "aria-label": accessibilityLabel,
    onMouseUp: handleMouseUpByBlurring
  }, import_react743.default.createElement("span", {
    className: styles105.Title
  }, children2)) : import_react743.default.createElement("button", {
    id,
    role: "tab",
    type: "button",
    tabIndex,
    className,
    onClick: handleClick,
    "aria-selected": selected,
    "aria-controls": panelID,
    "aria-label": accessibilityLabel,
    onMouseUp: handleMouseUpByBlurring
  }, import_react743.default.createElement("span", {
    className: styles105.Title
  }, children2));
  return import_react743.default.createElement("li", {
    className: tabContainerClassNames,
    ref: node,
    role: "presentation"
  }, markup);
}
function focusPanelID2(panelID) {
  const panel = document.getElementById(panelID);
  if (panel) {
    panel.focus({
      preventScroll: true
    });
  }
}

// ../node_modules/@shopify/polaris/build/esm/components/LegacyTabs/components/TabMeasurer/TabMeasurer.js
var TabMeasurer3 = (0, import_react744.memo)(function TabMeasurer4({
  selected,
  tabs,
  activator,
  tabToFocus,
  siblingTabHasFocus,
  handleMeasurement: handleMeasurementProp
}) {
  const containerNode = (0, import_react744.useRef)(null);
  const animationFrame = (0, import_react744.useRef)(null);
  const handleMeasurement = (0, import_react744.useCallback)(() => {
    if (animationFrame.current) {
      cancelAnimationFrame(animationFrame.current);
    }
    animationFrame.current = requestAnimationFrame(() => {
      if (!containerNode.current) {
        return;
      }
      const containerWidth = containerNode.current.offsetWidth;
      const hiddenTabNodes = containerNode.current.children;
      const hiddenTabNodesArray = Array.from(hiddenTabNodes);
      const hiddenTabWidths = hiddenTabNodesArray.map((node) => {
        return Math.ceil(node.getBoundingClientRect().width);
      });
      const disclosureWidth = hiddenTabWidths.pop() || 0;
      handleMeasurementProp({
        containerWidth,
        disclosureWidth,
        hiddenTabWidths
      });
    });
  }, [handleMeasurementProp]);
  (0, import_react744.useEffect)(() => {
    handleMeasurement();
  }, [handleMeasurement, tabs]);
  useComponentDidMount(() => {
    if (true) {
      setTimeout(handleMeasurement, 0);
    }
  });
  const tabsMarkup = tabs.map((tab, index) => {
    return import_react744.default.createElement(Tab2, {
      measuring: true,
      key: `${index}${tab.id}Hidden`,
      id: `${tab.id}Measurer`,
      siblingTabHasFocus,
      focused: index === tabToFocus,
      selected: index === selected,
      onClick: noop14,
      url: tab.url
    }, tab.content);
  });
  const classname = classNames(styles105.LegacyTabs, styles105.TabMeasurer);
  return import_react744.default.createElement("div", {
    className: classname,
    ref: containerNode
  }, import_react744.default.createElement(EventListener, {
    event: "resize",
    handler: handleMeasurement
  }), tabsMarkup, activator);
});
function noop14() {
}

// ../node_modules/@shopify/polaris/build/esm/components/LegacyTabs/components/List/List.js
var import_react746 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/LegacyTabs/components/Item/Item.js
var import_react745 = __toESM(require_react());
var Item10 = class extends import_react745.PureComponent {
  constructor(...args) {
    super(...args);
    this.context = void 0;
    this.focusedNode = null;
    this.setFocusedNode = (node) => {
      this.focusedNode = node;
    };
  }
  componentDidMount() {
    const {
      focusedNode
    } = this;
    const {
      focused
    } = this.props;
    if (focusedNode && focusedNode instanceof HTMLElement && focused) {
      focusedNode.focus();
    }
  }
  componentDidUpdate() {
    const {
      focusedNode
    } = this;
    const {
      focused
    } = this.props;
    if (focusedNode && focusedNode instanceof HTMLElement && focused) {
      focusedNode.focus();
    }
  }
  render() {
    const {
      id,
      panelID,
      children: children2,
      url,
      accessibilityLabel,
      onClick = noop15
    } = this.props;
    const classname = classNames(styles105.Item);
    const sharedProps = {
      id,
      ref: this.setFocusedNode,
      onClick,
      className: classname,
      "aria-controls": panelID,
      "aria-selected": false,
      "aria-label": accessibilityLabel
    };
    const markup = url ? import_react745.default.createElement(UnstyledLink, Object.assign({}, sharedProps, {
      url
    }), children2) : import_react745.default.createElement("button", Object.assign({}, sharedProps, {
      type: "button"
    }), children2);
    return import_react745.default.createElement("li", null, markup);
  }
};
Item10.contextType = FeaturesContext;
function noop15() {
}

// ../node_modules/@shopify/polaris/build/esm/components/LegacyTabs/components/List/List.js
function List2({
  focusIndex,
  disclosureTabs,
  onClick = noop16,
  onKeyPress = noop16
}) {
  const tabs = disclosureTabs.map(({
    id,
    content,
    ...tabProps
  }, index) => {
    return import_react746.default.createElement(Item10, Object.assign({
      key: id
    }, tabProps, {
      id,
      focused: index === focusIndex,
      onClick: onClick.bind(null, id)
    }), content);
  });
  return import_react746.default.createElement("div", {
    onKeyDown: handleKeyDown3,
    onKeyUp: onKeyPress
  }, import_react746.default.createElement(Box, {
    as: "ul",
    padding: "2"
  }, tabs));
}
function noop16() {
}
function handleKeyDown3(event) {
  const {
    key
  } = event;
  if (key === "ArrowLeft" || key === "ArrowRight") {
    event.preventDefault();
    event.stopPropagation();
  }
}

// ../node_modules/@shopify/polaris/build/esm/components/LegacyTabs/LegacyTabs.js
var TabsInner = class extends import_react747.PureComponent {
  constructor(...args) {
    super(...args);
    this.state = {
      disclosureWidth: 0,
      containerWidth: Infinity,
      tabWidths: [],
      visibleTabs: [],
      hiddenTabs: [],
      showDisclosure: false,
      tabToFocus: -1
    };
    this.handleKeyPress = (event) => {
      const {
        tabToFocus,
        visibleTabs,
        hiddenTabs,
        showDisclosure
      } = this.state;
      const key = event.key;
      const tabsArrayInOrder = showDisclosure ? visibleTabs.concat(hiddenTabs) : [...visibleTabs];
      let newFocus = tabsArrayInOrder.indexOf(tabToFocus);
      if (key === "ArrowRight") {
        newFocus += 1;
        if (newFocus === tabsArrayInOrder.length) {
          newFocus = 0;
        }
      }
      if (key === "ArrowLeft") {
        if (newFocus === -1 || newFocus === 0) {
          newFocus = tabsArrayInOrder.length - 1;
        } else {
          newFocus -= 1;
        }
      }
      this.setState({
        tabToFocus: tabsArrayInOrder[newFocus]
      });
    };
    this.renderTabMarkup = (tab, index) => {
      const {
        selected,
        children: children2
      } = this.props;
      const {
        tabToFocus
      } = this.state;
      const tabPanelID = tab.panelID || `${tab.id}-panel`;
      return import_react747.default.createElement(Tab2, {
        key: `${index}-${tab.id}`,
        id: tab.id,
        siblingTabHasFocus: tabToFocus > -1,
        focused: index === tabToFocus,
        selected: index === selected,
        onClick: this.handleTabClick,
        panelID: children2 ? tabPanelID : void 0,
        accessibilityLabel: tab.accessibilityLabel,
        url: tab.url
      }, tab.content);
    };
    this.handleFocus = (event) => {
      const {
        selected,
        tabs
      } = this.props;
      const target = event.target;
      if (target.classList.contains(styles105.Tab) || target.classList.contains(styles105.Item)) {
        let tabToFocus = -1;
        tabs.every((tab, index) => {
          if (tab.id === target.id) {
            tabToFocus = index;
            return false;
          }
          return true;
        });
        this.setState({
          tabToFocus
        });
        return;
      }
      if (target.classList.contains(styles105.DisclosureActivator)) {
        return;
      }
      if (!event.relatedTarget) {
        this.setState({
          tabToFocus: selected
        });
        return;
      }
      const relatedTarget = event.relatedTarget;
      if (relatedTarget instanceof HTMLElement && !relatedTarget.classList.contains(styles105.Tab) && !relatedTarget.classList.contains(styles105.Item) && !relatedTarget.classList.contains(styles105.DisclosureActivator)) {
        this.setState({
          tabToFocus: selected
        });
      }
    };
    this.handleBlur = (event) => {
      if (event.relatedTarget == null) {
        this.setState({
          tabToFocus: -1
        });
        return;
      }
      const target = event.relatedTarget;
      if (target instanceof HTMLElement && !target.classList.contains(styles105.Tab) && !target.classList.contains(styles105.Item)) {
        this.setState({
          tabToFocus: -1
        });
      }
    };
    this.handleDisclosureActivatorClick = () => {
      this.setState(({
        showDisclosure
      }) => ({
        showDisclosure: !showDisclosure
      }));
    };
    this.handleClose = () => {
      this.setState({
        showDisclosure: false
      });
    };
    this.handleMeasurement = (measurements) => {
      const {
        tabs,
        selected
      } = this.props;
      const {
        tabToFocus
      } = this.state;
      const {
        hiddenTabWidths: tabWidths,
        containerWidth,
        disclosureWidth
      } = measurements;
      const {
        visibleTabs,
        hiddenTabs
      } = getVisibleAndHiddenTabIndices2(tabs, selected, disclosureWidth, tabWidths, containerWidth);
      this.setState({
        tabToFocus: tabToFocus === -1 ? -1 : selected,
        visibleTabs,
        hiddenTabs,
        disclosureWidth,
        containerWidth,
        tabWidths
      });
    };
    this.handleTabClick = (id) => {
      const {
        tabs,
        onSelect = noop17
      } = this.props;
      const tab = tabs.find((aTab) => aTab.id === id);
      if (tab == null) {
        return;
      }
      const selectedIndex = tabs.indexOf(tab);
      onSelect(selectedIndex);
    };
  }
  static getDerivedStateFromProps(nextProps, prevState) {
    const {
      disclosureWidth,
      tabWidths,
      containerWidth
    } = prevState;
    const {
      visibleTabs,
      hiddenTabs
    } = getVisibleAndHiddenTabIndices2(nextProps.tabs, nextProps.selected, disclosureWidth, tabWidths, containerWidth);
    return {
      visibleTabs,
      hiddenTabs,
      selected: nextProps.selected
    };
  }
  render() {
    const {
      tabs,
      selected,
      fitted,
      children: children2,
      i18n,
      disclosureText
    } = this.props;
    const {
      tabToFocus,
      visibleTabs,
      hiddenTabs,
      showDisclosure
    } = this.state;
    const disclosureTabs = hiddenTabs.map((tabIndex) => tabs[tabIndex]);
    const panelMarkup = children2 ? tabs.map((_tab, index) => {
      return selected === index ? import_react747.default.createElement(Panel2, {
        id: tabs[index].panelID || `${tabs[index].id}-panel`,
        tabID: tabs[index].id,
        key: tabs[index].id
      }, children2) : import_react747.default.createElement(Panel2, {
        id: tabs[index].panelID || `${tabs[index].id}-panel`,
        tabID: tabs[index].id,
        key: tabs[index].id,
        hidden: true
      });
    }) : null;
    const tabsMarkup = visibleTabs.sort((tabA, tabB) => tabA - tabB).map((tabIndex) => this.renderTabMarkup(tabs[tabIndex], tabIndex));
    const disclosureActivatorVisible = visibleTabs.length < tabs.length;
    const hasCustomDisclosure = Boolean(disclosureText);
    const classname = classNames(styles105.LegacyTabs, fitted && styles105.fitted, disclosureActivatorVisible && styles105.fillSpace);
    const disclosureTabClassName = classNames(styles105.DisclosureTab, disclosureActivatorVisible && styles105["DisclosureTab-visible"]);
    const disclosureButtonClassName = classNames(styles105.DisclosureActivator, hasCustomDisclosure && styles105.Tab);
    const disclosureButtonContentWrapperClassName = classNames(styles105.Title, hasCustomDisclosure && styles105.titleWithIcon);
    const disclosureButtonContent = hasCustomDisclosure ? import_react747.default.createElement(import_react747.default.Fragment, null, disclosureText, import_react747.default.createElement(Icon, {
      source: SvgCaretDownMinor,
      color: "subdued"
    })) : import_react747.default.createElement(Icon, {
      source: SvgHorizontalDotsMinor,
      color: "subdued"
    });
    const disclosureButton = import_react747.default.createElement("button", {
      type: "button",
      className: disclosureButtonClassName,
      onClick: this.handleDisclosureActivatorClick,
      "aria-label": i18n.translate("Polaris.Tabs.toggleTabsLabel")
    }, import_react747.default.createElement("span", {
      className: disclosureButtonContentWrapperClassName
    }, disclosureButtonContent));
    const activator = disclosureText ? import_react747.default.createElement("div", {
      className: styles105.TabContainer
    }, disclosureButton) : disclosureButton;
    return import_react747.default.createElement("div", null, import_react747.default.createElement(Box, {
      borderBlockEndWidth: "1",
      borderColor: "border-subdued",
      paddingInlineStart: "2",
      paddingInlineEnd: "2"
    }, import_react747.default.createElement(TabMeasurer3, {
      tabToFocus,
      activator,
      selected,
      tabs,
      siblingTabHasFocus: tabToFocus > -1,
      handleMeasurement: this.handleMeasurement
    }), import_react747.default.createElement("ul", {
      role: "tablist",
      className: classname,
      onFocus: this.handleFocus,
      onBlur: this.handleBlur,
      onKeyDown: handleKeyDown4,
      onKeyUp: this.handleKeyPress
    }, tabsMarkup, import_react747.default.createElement("li", {
      className: disclosureTabClassName,
      role: "presentation"
    }, import_react747.default.createElement(Popover2, {
      preferredPosition: "below",
      activator,
      active: disclosureActivatorVisible && showDisclosure,
      onClose: this.handleClose,
      autofocusTarget: "first-node"
    }, import_react747.default.createElement(List2, {
      focusIndex: hiddenTabs.indexOf(tabToFocus),
      disclosureTabs,
      onClick: this.handleTabClick,
      onKeyPress: this.handleKeyPress
    }))))), panelMarkup);
  }
};
function noop17() {
}
function handleKeyDown4(event) {
  const {
    key
  } = event;
  if (key === "ArrowLeft" || key === "ArrowRight") {
    event.preventDefault();
    event.stopPropagation();
  }
}
function LegacyTabs(props) {
  const i18n = useI18n();
  return import_react747.default.createElement(TabsInner, Object.assign({}, props, {
    i18n
  }));
}

// ../node_modules/@shopify/polaris/build/esm/components/Link/Link.js
var import_react748 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Link/Link.scss.js
var styles106 = {
  "Link": "Polaris-Link",
  "monochrome": "Polaris-Link--monochrome",
  "removeUnderline": "Polaris-Link--removeUnderline"
};

// ../node_modules/@shopify/polaris/build/esm/components/Link/Link.js
function Link({
  url,
  children: children2,
  onClick,
  external,
  target,
  id,
  monochrome,
  removeUnderline,
  accessibilityLabel,
  dataPrimaryLink
}) {
  return import_react748.default.createElement(BannerContext.Consumer, null, (BannerContext2) => {
    const shouldBeMonochrome = monochrome || BannerContext2;
    const className = classNames(styles106.Link, shouldBeMonochrome && styles106.monochrome, removeUnderline && styles106.removeUnderline);
    return url ? import_react748.default.createElement(UnstyledLink, {
      onClick,
      className,
      url,
      external,
      target,
      id,
      "aria-label": accessibilityLabel,
      "data-primary-link": dataPrimaryLink
    }, children2) : import_react748.default.createElement("button", {
      type: "button",
      onClick,
      className,
      id,
      "aria-label": accessibilityLabel,
      "data-primary-link": dataPrimaryLink
    }, children2);
  });
}

// ../node_modules/@shopify/polaris/build/esm/components/List/List.js
var import_react750 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/List/List.scss.js
var styles107 = {
  "List": "Polaris-List",
  "typeNumber": "Polaris-List--typeNumber",
  "Item": "Polaris-List__Item",
  "spacingLoose": "Polaris-List--spacingLoose"
};

// ../node_modules/@shopify/polaris/build/esm/components/List/components/Item/Item.js
var import_react749 = __toESM(require_react());
function Item11({
  children: children2
}) {
  return import_react749.default.createElement("li", {
    className: styles107.Item
  }, children2);
}

// ../node_modules/@shopify/polaris/build/esm/components/List/List.js
var List3 = function List4({
  children: children2,
  spacing: spacing2 = "loose",
  type = "bullet"
}) {
  const className = classNames(styles107.List, spacing2 && styles107[variationName("spacing", spacing2)], type && styles107[variationName("type", type)]);
  const ListElement = type === "bullet" ? "ul" : "ol";
  return import_react750.default.createElement(ListElement, {
    className
  }, children2);
};
List3.Item = Item11;

// ../node_modules/@shopify/polaris/build/esm/components/Loading/Loading.js
var import_react751 = __toESM(require_react());
var Loading3 = (0, import_react751.memo)(function Loading4() {
  const {
    startLoading,
    stopLoading
  } = useFrame();
  (0, import_react751.useEffect)(() => {
    startLoading();
    return () => {
      stopLoading();
    };
  }, [startLoading, stopLoading]);
  return null;
});

// ../node_modules/@shopify/polaris/build/esm/components/MediaCard/MediaCard.js
var import_react752 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/MediaCard/MediaCard.scss.js
var styles108 = {
  "MediaCard": "Polaris-MediaCard",
  "portrait": "Polaris-MediaCard--portrait",
  "MediaContainer": "Polaris-MediaCard__MediaContainer",
  "sizeSmall": "Polaris-MediaCard--sizeSmall",
  "InfoContainer": "Polaris-MediaCard__InfoContainer",
  "Heading": "Polaris-MediaCard__Heading",
  "PrimaryAction": "Polaris-MediaCard__PrimaryAction",
  "SecondaryAction": "Polaris-MediaCard__SecondaryAction",
  "ActionContainer": "Polaris-MediaCard__ActionContainer"
};

// ../node_modules/@shopify/polaris/build/esm/components/MediaCard/MediaCard.js
function MediaCard({
  title,
  children: children2,
  primaryAction,
  secondaryAction,
  description,
  popoverActions = [],
  portrait = false,
  size = "medium",
  onDismiss
}) {
  const i18n = useI18n();
  const {
    value: popoverActive,
    toggle: togglePopoverActive
  } = useToggle(false);
  let headerMarkup = null;
  if (title) {
    const headerContent = typeof title === "string" ? import_react752.default.createElement(Text, {
      variant: "headingMd",
      as: "h2"
    }, title) : title;
    headerMarkup = import_react752.default.createElement("div", {
      className: styles108.Heading
    }, headerContent);
  }
  const dismissButtonMarkup = onDismiss ? import_react752.default.createElement(Button, {
    icon: SvgCancelMinor,
    onClick: onDismiss,
    size: "slim",
    plain: true,
    accessibilityLabel: i18n.translate("Polaris.MediaCard.dismissButton")
  }) : null;
  const popoverActivator = import_react752.default.createElement(HorizontalStack, {
    blockAlign: "center"
  }, import_react752.default.createElement(Button, {
    icon: SvgHorizontalDotsMinor,
    onClick: togglePopoverActive,
    size: "slim",
    plain: true,
    accessibilityLabel: i18n.translate("Polaris.MediaCard.popoverButton")
  }));
  const popoverActionsMarkup = popoverActions.length > 0 ? import_react752.default.createElement(Popover2, {
    active: popoverActive,
    activator: popoverActivator,
    onClose: togglePopoverActive,
    preferredAlignment: "left",
    preferredPosition: "below"
  }, import_react752.default.createElement(ActionList, {
    items: popoverActions,
    onActionAnyItem: togglePopoverActive
  })) : null;
  const primaryActionMarkup = primaryAction ? import_react752.default.createElement("div", {
    className: styles108.PrimaryAction
  }, buttonFrom(primaryAction)) : null;
  const secondaryActionMarkup = secondaryAction ? import_react752.default.createElement("div", {
    className: styles108.SecondaryAction
  }, buttonFrom(secondaryAction, {
    plain: true
  })) : null;
  const actionClassName = classNames(styles108.ActionContainer, portrait && styles108.portrait);
  const actionMarkup = primaryActionMarkup || secondaryActionMarkup ? import_react752.default.createElement("div", {
    className: actionClassName
  }, import_react752.default.createElement(ButtonGroup, null, primaryActionMarkup, secondaryActionMarkup)) : null;
  const mediaCardClassName = classNames(styles108.MediaCard, portrait && styles108.portrait);
  const mediaContainerClassName = classNames(styles108.MediaContainer, portrait && styles108.portrait, size === "small" && styles108.sizeSmall);
  const infoContainerClassName = classNames(styles108.InfoContainer, portrait && styles108.portrait, size === "small" && styles108.sizeSmall);
  const popoverOrDismissMarkup = popoverActionsMarkup || dismissButtonMarkup ? import_react752.default.createElement(Box, {
    position: "absolute",
    insetBlockStart: "4",
    insetInlineEnd: "5",
    zIndex: "var(--p-z-index-2)"
  }, import_react752.default.createElement(HorizontalStack, {
    gap: "1"
  }, popoverActionsMarkup, dismissButtonMarkup)) : null;
  return import_react752.default.createElement(LegacyCard, null, import_react752.default.createElement("div", {
    className: mediaCardClassName
  }, import_react752.default.createElement("div", {
    className: mediaContainerClassName
  }, children2), import_react752.default.createElement("div", {
    className: infoContainerClassName
  }, import_react752.default.createElement(LegacyCard.Section, null, popoverOrDismissMarkup, import_react752.default.createElement(LegacyStack, {
    vertical: true,
    spacing: "tight"
  }, headerMarkup, import_react752.default.createElement("p", {
    className: styles108.Description
  }, description), actionMarkup)))));
}

// ../node_modules/@shopify/polaris/build/esm/components/Navigation/Navigation.js
var import_react757 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Navigation/context.js
var import_react753 = __toESM(require_react());
var NavigationContext = (0, import_react753.createContext)({
  location: ""
});

// ../node_modules/@shopify/polaris/build/esm/components/Navigation/Navigation.scss.js
var styles109 = {
  "Navigation": "Polaris-Navigation",
  "UserMenu": "Polaris-Navigation__UserMenu",
  "ContextControl": "Polaris-Navigation__ContextControl",
  "PrimaryNavigation": "Polaris-Navigation__PrimaryNavigation",
  "LogoContainer": "Polaris-Navigation__LogoContainer",
  "hasLogoSuffix": "Polaris-Navigation--hasLogoSuffix",
  "Logo": "Polaris-Navigation__Logo",
  "LogoLink": "Polaris-Navigation__LogoLink",
  "Item": "Polaris-Navigation__Item",
  "Icon-resized": "Polaris-Navigation__Icon--resized",
  "ItemInnerWrapper": "Polaris-Navigation__ItemInnerWrapper",
  "Item-selected": "Polaris-Navigation__Item--selected",
  "Item-disabled": "Polaris-Navigation__Item--disabled",
  "Icon": "Polaris-Navigation__Icon",
  "Badge": "Polaris-Navigation__Badge",
  "ListItem-hasAction": "Polaris-Navigation__ListItem--hasAction",
  "subNavigationActive": "Polaris-Navigation--subNavigationActive",
  "Item-child-active": "Polaris-Navigation--itemChildActive",
  "ListItem": "Polaris-Navigation__ListItem",
  "RollupSection": "Polaris-Navigation__RollupSection",
  "SecondaryNavigation": "Polaris-Navigation__SecondaryNavigation",
  "ItemWrapper": "Polaris-Navigation__ItemWrapper",
  "ItemInnerDisabled": "Polaris-Navigation__ItemInnerDisabled",
  "ItemInnerWrapper-selected": "Polaris-Navigation__ItemInnerWrapper--selected",
  "Text": "Polaris-Navigation__Text",
  "Text-truncated": "Polaris-Navigation__Text--truncated",
  "SecondaryActions": "Polaris-Navigation__SecondaryActions",
  "ItemWithFloatingActions": "Polaris-Navigation__ItemWithFloatingActions",
  "ItemInnerWrapper-display-actions-on-hover": "Polaris-Navigation--itemInnerWrapperDisplayActionsOnHover",
  "SecondaryAction": "Polaris-Navigation__SecondaryAction",
  "List": "Polaris-Navigation__List",
  "SecondaryNavigation-noIcon": "Polaris-Navigation__SecondaryNavigation--noIcon",
  "Section": "Polaris-Navigation__Section",
  "Section-fill": "Polaris-Navigation__Section--fill",
  "Section-withSeparator": "Polaris-Navigation__Section--withSeparator",
  "SectionHeading": "Polaris-Navigation__SectionHeading",
  "Action": "Polaris-Navigation__Action",
  "RollupToggle": "Polaris-Navigation__RollupToggle",
  "Indicator": "Polaris-Navigation__Indicator"
};

// ../node_modules/@shopify/polaris/build/esm/components/Navigation/components/Section/Section.js
var import_react756 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Navigation/components/Item/Item.js
var import_react755 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Navigation/components/Item/components/Secondary/Secondary.js
var import_react754 = __toESM(require_react());
function Secondary({
  id,
  children: children2,
  expanded
}) {
  const uid = useUniqueId("SecondaryNavigation");
  return import_react754.default.createElement(Collapsible, {
    id: id || uid,
    open: expanded,
    transition: false
  }, import_react754.default.createElement("ul", {
    className: styles109.List
  }, children2));
}

// ../node_modules/@shopify/polaris/build/esm/components/Navigation/components/Item/Item.js
var MAX_SECONDARY_ACTIONS = 2;
var TOOLTIP_HOVER_DELAY = 1e3;
var MatchState;
(function(MatchState2) {
  MatchState2[MatchState2["MatchForced"] = 0] = "MatchForced";
  MatchState2[MatchState2["MatchUrl"] = 1] = "MatchUrl";
  MatchState2[MatchState2["MatchPaths"] = 2] = "MatchPaths";
  MatchState2[MatchState2["Excluded"] = 3] = "Excluded";
  MatchState2[MatchState2["NoMatch"] = 4] = "NoMatch";
})(MatchState || (MatchState = {}));
function Item12({
  url,
  icon,
  label,
  subNavigationItems = [],
  secondaryAction,
  secondaryActions,
  displayActionsOnHover,
  disabled,
  onClick,
  accessibilityLabel,
  selected: selectedOverride,
  badge,
  new: isNew,
  matches: matches2,
  exactMatch,
  matchPaths,
  excludePaths,
  external,
  onToggleExpandedState,
  expanded,
  shouldResizeIcon,
  truncateText
}) {
  const i18n = useI18n();
  const {
    isNavigationCollapsed
  } = useMediaQuery();
  const secondaryNavigationId = useUniqueId("SecondaryNavigation");
  const {
    location,
    onNavigationDismiss
  } = (0, import_react755.useContext)(NavigationContext);
  const navTextRef = (0, import_react755.useRef)(null);
  const [isTruncated, setIsTruncated] = (0, import_react755.useState)(false);
  (0, import_react755.useEffect)(() => {
    if (!isNavigationCollapsed && expanded) {
      onToggleExpandedState === null || onToggleExpandedState === void 0 ? void 0 : onToggleExpandedState();
    }
  }, [expanded, isNavigationCollapsed, onToggleExpandedState]);
  useIsomorphicLayoutEffect(() => {
    const navTextNode = navTextRef.current;
    if (truncateText && navTextNode) {
      setIsTruncated(navTextNode.scrollHeight > navTextNode.clientHeight);
    }
  }, [truncateText]);
  const tabIndex = disabled ? -1 : 0;
  const hasNewChild = subNavigationItems.filter((subNavigationItem) => subNavigationItem.new).length > 0;
  const indicatorMarkup = hasNewChild ? import_react755.default.createElement("span", {
    className: styles109.Indicator
  }, import_react755.default.createElement(Indicator, {
    pulse: true
  })) : null;
  const iconMarkup = icon ? import_react755.default.createElement("div", {
    className: classNames(styles109.Icon, shouldResizeIcon && styles109["Icon-resized"])
  }, import_react755.default.createElement(Icon, {
    source: icon
  })) : null;
  let badgeMarkup = null;
  if (isNew) {
    badgeMarkup = import_react755.default.createElement(Badge, {
      status: "new"
    }, i18n.translate("Polaris.Badge.STATUS_LABELS.new"));
  } else if (typeof badge === "string") {
    badgeMarkup = import_react755.default.createElement(Badge, {
      status: "new"
    }, badge);
  } else {
    badgeMarkup = badge;
  }
  const wrappedBadgeMarkup = badgeMarkup == null ? null : import_react755.default.createElement("div", {
    className: styles109.Badge
  }, badgeMarkup);
  const itemLabelMarkup = import_react755.default.createElement("span", {
    className: classNames(styles109.Text, truncateText && styles109["Text-truncated"]),
    ref: navTextRef
  }, label, indicatorMarkup);
  if (url == null) {
    const className2 = classNames(styles109.Item, disabled && styles109["Item-disabled"], selectedOverride && styles109["Item-selected"]);
    return import_react755.default.createElement("li", {
      className: styles109.ListItem
    }, import_react755.default.createElement("div", {
      className: styles109.ItemWrapper
    }, import_react755.default.createElement("div", {
      className: classNames(styles109.ItemInnerWrapper, disabled && styles109.ItemInnerDisabled)
    }, import_react755.default.createElement("button", {
      type: "button",
      className: className2,
      disabled,
      "aria-disabled": disabled,
      "aria-label": accessibilityLabel,
      onClick: getClickHandler(onClick)
    }, iconMarkup, itemLabelMarkup, wrappedBadgeMarkup))));
  }
  if (secondaryAction && true) {
    console.warn("Deprecation: The `secondaryAction` prop on the `Navigation.Item` has been deprecated. Use `secondaryActions` instead.");
  }
  const actions = secondaryActions || secondaryAction && [secondaryAction];
  if (actions && actions.length > MAX_SECONDARY_ACTIONS) {
    actions.length = MAX_SECONDARY_ACTIONS;
    if (true) {
      console.warn(`secondaryActions must have a maximum of ${MAX_SECONDARY_ACTIONS} actions. Only the first ${MAX_SECONDARY_ACTIONS} actions will be rendered.`);
    }
  }
  const secondaryActionMarkup = actions !== null && actions !== void 0 && actions.length ? import_react755.default.createElement("span", {
    className: styles109.SecondaryActions
  }, actions.map((action) => import_react755.default.createElement(ItemSecondaryAction, Object.assign({
    key: action.accessibilityLabel
  }, action, {
    tabIndex,
    disabled
  })))) : null;
  const itemContentMarkup = import_react755.default.createElement(import_react755.default.Fragment, null, iconMarkup, itemLabelMarkup, secondaryActionMarkup ? null : wrappedBadgeMarkup);
  const outerContentMarkup = import_react755.default.createElement(import_react755.default.Fragment, null, secondaryActionMarkup ? wrappedBadgeMarkup : null);
  const matchState = matchStateForItem({
    url,
    matches: matches2,
    exactMatch,
    matchPaths,
    excludePaths
  }, location);
  const matchingSubNavigationItems = subNavigationItems.filter((item) => {
    const subMatchState = matchStateForItem(item, location);
    return subMatchState === MatchState.MatchForced || subMatchState === MatchState.MatchUrl || subMatchState === MatchState.MatchPaths;
  });
  const childIsActive = matchingSubNavigationItems.length > 0;
  const selected = selectedOverride == null ? matchState === MatchState.MatchForced || matchState === MatchState.MatchUrl || matchState === MatchState.MatchPaths : selectedOverride;
  const showExpanded = selected || expanded || childIsActive;
  const canBeActive = subNavigationItems.length === 0 || !childIsActive;
  const itemClassName = classNames(styles109.Item, disabled && styles109["Item-disabled"], selected && canBeActive && styles109["Item-selected"], showExpanded && styles109.subNavigationActive, childIsActive && styles109["Item-child-active"]);
  let secondaryNavigationMarkup = null;
  if (subNavigationItems.length > 0) {
    const longestMatch = matchingSubNavigationItems.sort(({
      url: firstUrl
    }, {
      url: secondUrl
    }) => secondUrl.length - firstUrl.length)[0];
    const SecondaryNavigationClassName = classNames(styles109.SecondaryNavigation, !icon && styles109["SecondaryNavigation-noIcon"]);
    secondaryNavigationMarkup = import_react755.default.createElement("div", {
      className: SecondaryNavigationClassName
    }, import_react755.default.createElement(Secondary, {
      expanded: showExpanded,
      id: secondaryNavigationId
    }, subNavigationItems.map((item) => {
      const {
        label: label2,
        ...rest
      } = item;
      const onClick2 = () => {
        if (onNavigationDismiss) {
          onNavigationDismiss();
        }
        if (item.onClick && item.onClick !== onNavigationDismiss) {
          item.onClick();
        }
      };
      return import_react755.default.createElement(Item12, Object.assign({
        key: label2
      }, rest, {
        label: label2,
        matches: item === longestMatch,
        onClick: onClick2,
        truncateText
      }));
    })));
  }
  const className = classNames(styles109.ListItem, Boolean(actions && actions.length) && styles109["ListItem-hasAction"]);
  const itemLinkMarkup = () => {
    const linkMarkup = import_react755.default.createElement(UnstyledLink, Object.assign({
      url,
      className: itemClassName,
      external,
      tabIndex,
      "aria-disabled": disabled,
      "aria-label": accessibilityLabel,
      onClick: getClickHandler(onClick)
    }, normalizeAriaAttributes(secondaryNavigationId, subNavigationItems.length > 0, showExpanded)), itemContentMarkup);
    return isTruncated ? import_react755.default.createElement(Tooltip, {
      hoverDelay: TOOLTIP_HOVER_DELAY,
      content: label,
      preferredPosition: "above"
    }, linkMarkup) : linkMarkup;
  };
  return import_react755.default.createElement("li", {
    className
  }, import_react755.default.createElement("div", {
    className: styles109.ItemWrapper
  }, import_react755.default.createElement("div", {
    className: classNames(styles109.ItemInnerWrapper, selected && canBeActive && styles109["ItemInnerWrapper-selected"], displayActionsOnHover && styles109["ItemInnerWrapper-display-actions-on-hover"], disabled && styles109.ItemInnerDisabled)
  }, displayActionsOnHover && secondaryActionMarkup && wrappedBadgeMarkup ? import_react755.default.createElement("span", {
    className: styles109.ItemWithFloatingActions
  }, itemLinkMarkup(), secondaryActionMarkup) : import_react755.default.createElement(import_react755.default.Fragment, null, itemLinkMarkup(), secondaryActionMarkup), outerContentMarkup)), secondaryNavigationMarkup);
  function getClickHandler(onClick2) {
    return (event) => {
      const {
        currentTarget
      } = event;
      if (currentTarget.getAttribute("href") === location) {
        event.preventDefault();
      }
      if (subNavigationItems && subNavigationItems.length > 0 && isNavigationCollapsed) {
        event.preventDefault();
        onToggleExpandedState === null || onToggleExpandedState === void 0 ? void 0 : onToggleExpandedState();
      } else if (onNavigationDismiss) {
        onNavigationDismiss();
        if (onClick2 && onClick2 !== onNavigationDismiss) {
          onClick2();
        }
        return;
      }
      if (onClick2) {
        onClick2();
      }
    };
  }
}
function ItemSecondaryAction({
  url,
  icon,
  accessibilityLabel,
  tooltip,
  onClick,
  disabled,
  tabIndex
}) {
  const markup = url ? import_react755.default.createElement(UnstyledLink, {
    external: true,
    url,
    className: styles109.SecondaryAction,
    tabIndex,
    "aria-disabled": disabled,
    "aria-label": accessibilityLabel,
    onClick
  }, import_react755.default.createElement(Icon, {
    source: icon
  })) : import_react755.default.createElement(UnstyledButton, {
    className: styles109.SecondaryAction,
    tabIndex,
    disabled,
    accessibilityLabel,
    onClick
  }, import_react755.default.createElement(Icon, {
    source: icon
  }));
  return tooltip ? import_react755.default.createElement(Tooltip, tooltip, " ", markup, " ") : markup;
}
function isNavigationItemActive(navigationItem, currentPath) {
  const matchState = matchStateForItem(navigationItem, currentPath);
  const matchingSubNavigationItems = navigationItem.subNavigationItems && navigationItem.subNavigationItems.filter((item) => {
    const subMatchState = matchStateForItem(item, currentPath);
    return subMatchState === MatchState.MatchForced || subMatchState === MatchState.MatchUrl || subMatchState === MatchState.MatchPaths;
  });
  const childIsActive = matchingSubNavigationItems && matchingSubNavigationItems.length > 0;
  const selected = matchState === MatchState.MatchForced || matchState === MatchState.MatchUrl || matchState === MatchState.MatchPaths;
  return selected || childIsActive;
}
function normalizePathname(pathname) {
  const barePathname = pathname.split("?")[0].split("#")[0];
  return barePathname.endsWith("/") ? barePathname : `${barePathname}/`;
}
function safeEqual(location, path) {
  return normalizePathname(location) === normalizePathname(path);
}
function safeStartsWith(location, path) {
  return normalizePathname(location).startsWith(normalizePathname(path));
}
function matchStateForItem({
  url,
  matches: matches2,
  exactMatch,
  matchPaths,
  excludePaths
}, location) {
  if (url == null) {
    return MatchState.NoMatch;
  }
  if (matches2) {
    return MatchState.MatchForced;
  }
  if (matches2 === false || excludePaths && excludePaths.some((path) => safeStartsWith(location, path))) {
    return MatchState.Excluded;
  }
  if (matchPaths && matchPaths.some((path) => safeStartsWith(location, path))) {
    return MatchState.MatchPaths;
  }
  const matchesUrl = exactMatch ? safeEqual(location, url) : safeStartsWith(location, url);
  return matchesUrl ? MatchState.MatchUrl : MatchState.NoMatch;
}
function normalizeAriaAttributes(controlId, hasSubMenu, expanded) {
  return hasSubMenu ? {
    "aria-expanded": expanded,
    "aria-controls": controlId
  } : void 0;
}

// ../node_modules/@shopify/polaris/build/esm/components/Navigation/components/Section/Section.js
function Section8({
  title,
  fill,
  action,
  items,
  rollup,
  separator
}) {
  const {
    value: expanded,
    toggle: toggleExpanded,
    setFalse: setExpandedFalse
  } = useToggle(false);
  const animationFrame = (0, import_react756.useRef)(null);
  const {
    isNavigationCollapsed
  } = useMediaQuery();
  const [expandedIndex, setExpandedIndex] = (0, import_react756.useState)();
  const handleClick = (onClick, hasSubNavItems) => {
    return () => {
      if (onClick) {
        onClick();
      }
      if (animationFrame.current) {
        cancelAnimationFrame(animationFrame.current);
      }
      if (!hasSubNavItems || !isNavigationCollapsed) {
        animationFrame.current = requestAnimationFrame(setExpandedFalse);
      }
    };
  };
  (0, import_react756.useEffect)(() => {
    return () => {
      animationFrame.current && cancelAnimationFrame(animationFrame.current);
    };
  });
  const className = classNames(styles109.Section, separator && styles109["Section-withSeparator"], fill && styles109["Section-fill"]);
  const buttonMarkup = action && import_react756.default.createElement("button", {
    type: "button",
    className: styles109.Action,
    "aria-label": action.accessibilityLabel,
    onClick: action.onClick
  }, import_react756.default.createElement(Icon, {
    source: action.icon
  }));
  const actionMarkup = action && (action.tooltip ? import_react756.default.createElement(Tooltip, action.tooltip, buttonMarkup) : buttonMarkup);
  const sectionHeadingMarkup = title && import_react756.default.createElement("li", {
    className: styles109.SectionHeading
  }, import_react756.default.createElement(Text, {
    as: "span",
    variant: "headingXs",
    color: "subdued"
  }, title), actionMarkup);
  const itemsMarkup = items.map((item, index) => {
    const {
      onClick,
      label,
      subNavigationItems,
      ...rest
    } = item;
    const hasSubNavItems = subNavigationItems != null && subNavigationItems.length > 0;
    const handleToggleExpandedState = () => {
      if (expandedIndex === index) {
        setExpandedIndex(-1);
      } else {
        setExpandedIndex(index);
      }
    };
    return import_react756.default.createElement(Item12, Object.assign({
      key: label
    }, rest, {
      label,
      subNavigationItems,
      onClick: handleClick(onClick, hasSubNavItems),
      onToggleExpandedState: handleToggleExpandedState,
      expanded: expandedIndex === index
    }));
  });
  const toggleClassName = classNames(styles109.Item, styles109.RollupToggle);
  const ariaLabel = rollup && (expanded ? rollup.hide : rollup.view);
  const toggleRollup = rollup && items.length > rollup.after && import_react756.default.createElement("div", {
    className: styles109.ListItem,
    key: "List Item"
  }, import_react756.default.createElement("div", {
    className: styles109.ItemWrapper
  }, import_react756.default.createElement("div", {
    className: styles109.ItemInnerWrapper
  }, import_react756.default.createElement("button", {
    type: "button",
    className: toggleClassName,
    onClick: toggleExpanded,
    "aria-label": ariaLabel
  }, import_react756.default.createElement("span", {
    className: styles109.Icon
  }, import_react756.default.createElement(Icon, {
    source: SvgHorizontalDotsMinor
  }))))));
  const activeItemIndex = items.findIndex((item) => {
    if (!rollup) {
      return false;
    }
    return rollup.activePath === item.url || item.url && rollup.activePath.startsWith(item.url) || (item.subNavigationItems ? item.subNavigationItems.some(({
      url: itemUrl
    }) => rollup.activePath.startsWith(itemUrl)) : false);
  });
  const sectionItems = rollup ? itemsMarkup.slice(0, rollup.after) : itemsMarkup;
  const additionalItems = rollup ? itemsMarkup.slice(rollup.after) : [];
  if (rollup && activeItemIndex !== -1 && activeItemIndex > rollup.after - 1) {
    sectionItems.push(...additionalItems.splice(activeItemIndex - rollup.after, 1));
  }
  const additionalItemsId = useUniqueId("AdditionalItems");
  const activeItemsMarkup = rollup && additionalItems.length > 0 && import_react756.default.createElement("li", {
    className: styles109.RollupSection
  }, import_react756.default.createElement(Collapsible, {
    id: additionalItemsId,
    open: expanded
  }, import_react756.default.createElement("ul", {
    className: styles109.List
  }, additionalItems)), toggleRollup);
  return import_react756.default.createElement("ul", {
    className
  }, sectionHeadingMarkup, sectionItems, activeItemsMarkup);
}

// ../node_modules/@shopify/polaris/build/esm/components/Navigation/Navigation.js
var Navigation2 = function Navigation3({
  children: children2,
  contextControl,
  location,
  onDismiss,
  ariaLabelledBy,
  logoSuffix
}) {
  const {
    logo
  } = useFrame();
  const width = getWidth(logo, 104);
  const logoMarkup = logo ? import_react757.default.createElement("div", {
    className: classNames(styles109.LogoContainer, logoSuffix && styles109.hasLogoSuffix)
  }, import_react757.default.createElement(UnstyledLink, {
    url: logo.url || "",
    className: styles109.LogoLink,
    style: {
      width
    }
  }, import_react757.default.createElement(Image, {
    source: logo.topBarSource || "",
    alt: logo.accessibilityLabel || "",
    className: styles109.Logo,
    style: {
      width
    }
  })), logoSuffix) : null;
  const mediaMarkup = contextControl ? import_react757.default.createElement("div", {
    className: styles109.ContextControl
  }, contextControl) : logoMarkup;
  const context = (0, import_react757.useMemo)(() => ({
    location,
    onNavigationDismiss: onDismiss
  }), [location, onDismiss]);
  return import_react757.default.createElement(NavigationContext.Provider, {
    value: context
  }, import_react757.default.createElement(WithinContentContext.Provider, {
    value: true
  }, import_react757.default.createElement("nav", {
    className: styles109.Navigation,
    "aria-labelledby": ariaLabelledBy
  }, mediaMarkup, import_react757.default.createElement(Scrollable, {
    className: styles109.PrimaryNavigation
  }, children2))));
};
Navigation2.Item = Item12;
Navigation2.Section = Section8;

// ../node_modules/@shopify/polaris/build/esm/components/OptionList/OptionList.js
var import_react760 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/arrays.js
function arraysAreEqual(firstArray, secondArray, comparator) {
  if (firstArray.length !== secondArray.length) {
    return false;
  }
  return firstArray.every((firstItem, index) => {
    const secondItem = secondArray[index];
    if (comparator != null) {
      return comparator(firstItem, secondItem);
    }
    return firstItem === secondItem;
  });
}

// ../node_modules/@shopify/polaris/build/esm/components/OptionList/components/Option/Option.js
var import_react759 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/OptionList/components/Option/Option.scss.js
var styles110 = {
  "Option": "Polaris-OptionList-Option",
  "SingleSelectOption": "Polaris-OptionList-Option__SingleSelectOption",
  "focused": "Polaris-OptionList-Option--focused",
  "active": "Polaris-OptionList-Option--active",
  "select": "Polaris-OptionList-Option--select",
  "disabled": "Polaris-OptionList-Option--disabled",
  "Media": "Polaris-OptionList-Option__Media",
  "Label": "Polaris-OptionList-Option__Label",
  "Checkbox": "Polaris-OptionList-Option__Checkbox",
  "verticalAlignTop": "Polaris-OptionList-Option--verticalAlignTop",
  "verticalAlignCenter": "Polaris-OptionList-Option--verticalAlignCenter",
  "verticalAlignBottom": "Polaris-OptionList-Option--verticalAlignBottom"
};

// ../node_modules/@shopify/polaris/build/esm/components/OptionList/components/Checkbox/Checkbox.js
var import_react758 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/OptionList/components/Checkbox/Checkbox.scss.js
var styles111 = {
  "Checkbox": "Polaris-OptionList-Checkbox",
  "active": "Polaris-OptionList-Checkbox--active",
  "Backdrop": "Polaris-OptionList-Checkbox__Backdrop",
  "Input": "Polaris-OptionList-Checkbox__Input",
  "Input-indeterminate": "Polaris-OptionList-Checkbox__Input--indeterminate",
  "Icon": "Polaris-OptionList-Checkbox__Icon",
  "hover": "Polaris-OptionList-Checkbox--hover"
};

// ../node_modules/@shopify/polaris/build/esm/components/OptionList/components/Checkbox/Checkbox.js
function Checkbox5({
  id: idProp,
  checked = false,
  disabled,
  active,
  onChange,
  name,
  value,
  role
}) {
  const id = useUniqueId("Checkbox", idProp);
  const className = classNames(styles111.Checkbox, active && styles111.active);
  const inputClassName = classNames(styles111.Input);
  return import_react758.default.createElement("div", {
    className
  }, import_react758.default.createElement("input", {
    id,
    name,
    value,
    type: "checkbox",
    checked,
    disabled,
    className: inputClassName,
    "aria-checked": checked,
    onChange,
    role
  }), import_react758.default.createElement("div", {
    className: styles111.Backdrop
  }), import_react758.default.createElement("div", {
    className: styles111.Icon
  }, import_react758.default.createElement(Icon, {
    source: SvgTickSmallMinor
  })));
}

// ../node_modules/@shopify/polaris/build/esm/components/OptionList/components/Option/Option.js
function Option3({
  label,
  value,
  id,
  select,
  active,
  allowMultiple,
  disabled,
  role,
  media,
  onClick,
  section,
  index,
  verticalAlign,
  onPointerEnter,
  onFocus
}) {
  const {
    value: focused,
    toggle: toggleFocused
  } = useToggle(false);
  const handleClick = (0, import_react759.useCallback)(() => {
    if (disabled) {
      return;
    }
    onClick(section, index);
  }, [disabled, index, onClick, section]);
  const handlePointerEnter = (0, import_react759.useCallback)(() => {
    if (disabled) {
      return;
    }
    onPointerEnter(section, index);
  }, [disabled, onPointerEnter, section, index]);
  const handleFocus = (0, import_react759.useCallback)(() => {
    toggleFocused();
    onFocus(section, index);
  }, [toggleFocused, onFocus, section, index]);
  const mediaMarkup = media ? import_react759.default.createElement("div", {
    className: styles110.Media
  }, media) : null;
  const singleSelectClassName = classNames(styles110.SingleSelectOption, focused && styles110.focused, disabled && styles110.disabled, select && styles110.select, active && styles110.active, verticalAlign && styles110[variationName("verticalAlign", verticalAlign)]);
  const multiSelectClassName = classNames(styles110.Label, disabled && styles110.disabled, active && styles110.active, select && styles110.select, verticalAlign && styles110[variationName("verticalAlign", verticalAlign)]);
  const checkBoxRole = role === "option" ? "presentation" : void 0;
  const optionMarkup = allowMultiple ? import_react759.default.createElement("label", {
    htmlFor: id,
    className: multiSelectClassName
  }, import_react759.default.createElement("div", {
    className: styles110.Checkbox
  }, import_react759.default.createElement(Checkbox5, {
    id,
    value,
    checked: select,
    active,
    disabled,
    onChange: handleClick,
    role: checkBoxRole
  })), mediaMarkup, label) : import_react759.default.createElement("button", {
    id,
    type: "button",
    className: singleSelectClassName,
    onClick: handleClick,
    disabled,
    onFocus: handleFocus,
    onBlur: toggleFocused,
    "aria-pressed": active
  }, mediaMarkup, label);
  const scrollMarkup = active ? import_react759.default.createElement(Scrollable.ScrollTo, null) : null;
  return import_react759.default.createElement("li", {
    key: id,
    className: styles110.Option,
    tabIndex: -1,
    onPointerEnter: handlePointerEnter
  }, scrollMarkup, optionMarkup);
}

// ../node_modules/@shopify/polaris/build/esm/components/OptionList/OptionList.js
function OptionList({
  options,
  sections,
  title,
  selected,
  allowMultiple,
  role,
  optionRole,
  verticalAlign,
  onChange,
  id: idProp,
  onPointerEnterOption,
  onFocusOption
}) {
  const [normalizedOptions, setNormalizedOptions] = (0, import_react760.useState)(createNormalizedOptions(options, sections, title));
  const id = useUniqueId("OptionList", idProp);
  useDeepEffect(() => {
    setNormalizedOptions(createNormalizedOptions(options || [], sections || [], title));
  }, [options, sections, title], optionArraysAreEqual);
  const handleClick = (0, import_react760.useCallback)((sectionIndex, optionIndex) => {
    const selectedValue = normalizedOptions[sectionIndex].options[optionIndex].value;
    const foundIndex = selected.indexOf(selectedValue);
    if (allowMultiple) {
      const newSelection = foundIndex === -1 ? [selectedValue, ...selected] : [...selected.slice(0, foundIndex), ...selected.slice(foundIndex + 1, selected.length)];
      onChange(newSelection);
      return;
    }
    onChange([selectedValue]);
  }, [normalizedOptions, selected, allowMultiple, onChange]);
  const handlePointerEnter = (0, import_react760.useCallback)((sectionIndex, optionIndex) => {
    if (!onPointerEnterOption)
      return;
    const selectedValue = normalizedOptions[sectionIndex].options[optionIndex].value;
    onPointerEnterOption(selectedValue);
  }, [normalizedOptions, onPointerEnterOption]);
  const handleFocus = (0, import_react760.useCallback)((sectionIndex, optionIndex) => {
    if (!onFocusOption)
      return;
    const selectedValue = normalizedOptions[sectionIndex].options[optionIndex].value;
    onFocusOption(selectedValue);
  }, [normalizedOptions, onFocusOption]);
  const optionsExist = normalizedOptions.length > 0;
  const optionsMarkup = optionsExist ? normalizedOptions.map(({
    title: title2,
    options: options2
  }, sectionIndex) => {
    const isFirstOption = sectionIndex === 0;
    const titleMarkup = title2 ? import_react760.default.createElement(Box, {
      paddingBlockStart: isFirstOption ? "2" : "4",
      paddingInlineStart: "2",
      paddingBlockEnd: "2",
      paddingInlineEnd: "2",
      borderColor: "border-subdued",
      borderBlockStartWidth: !isFirstOption ? "1" : void 0
    }, import_react760.default.createElement(Text, {
      as: "p",
      variant: "headingXs"
    }, title2)) : null;
    const optionsMarkup2 = options2 && options2.map((option, optionIndex) => {
      const isSelected2 = selected.includes(option.value);
      const optionId = option.id || `${id}-${sectionIndex}-${optionIndex}`;
      return import_react760.default.createElement(Option3, Object.assign({
        key: optionId
      }, option, {
        id: optionId,
        section: sectionIndex,
        index: optionIndex,
        onClick: handleClick,
        select: isSelected2,
        allowMultiple,
        verticalAlign,
        role: optionRole,
        onPointerEnter: handlePointerEnter,
        onFocus: handleFocus
      }));
    });
    return import_react760.default.createElement(Box, {
      key: title2 || `noTitle-${sectionIndex}`,
      as: "li",
      paddingBlockStart: isFirstOption ? void 0 : "2"
    }, titleMarkup, import_react760.default.createElement(Bleed, {
      marginBlockStart: title2 ? void 0 : "05"
    }, import_react760.default.createElement(Box, {
      as: "ul",
      id: `${id}-${sectionIndex}`,
      role
    }, optionsMarkup2)));
  }) : null;
  return import_react760.default.createElement(Box, {
    as: "ul",
    role,
    padding: "2"
  }, optionsMarkup);
}
function createNormalizedOptions(options, sections, title) {
  if (options == null) {
    const section = {
      options: [],
      title
    };
    return sections == null ? [] : [section, ...sections];
  }
  if (sections == null) {
    return [{
      title,
      options
    }];
  }
  return [{
    title,
    options
  }, ...sections];
}
function optionArraysAreEqual(firstArray, secondArray) {
  if (isSection(firstArray) && isSection(secondArray)) {
    return arraysAreEqual(firstArray, secondArray, testSectionsPropEquality);
  }
  return arraysAreEqual(firstArray, secondArray);
}
function testSectionsPropEquality(previousSection, currentSection) {
  const {
    options: previousOptions
  } = previousSection;
  const {
    options: currentOptions
  } = currentSection;
  const optionsAreEqual = arraysAreEqual(previousOptions, currentOptions);
  const titlesAreEqual = previousSection.title === currentSection.title;
  return optionsAreEqual && titlesAreEqual;
}

// ../node_modules/@shopify/polaris/build/esm/components/Page/Page.js
var import_react766 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/is-interface.js
var import_react761 = __toESM(require_react());
function isInterface(x) {
  return !(0, import_react761.isValidElement)(x) && x !== void 0;
}

// ../node_modules/@shopify/polaris/build/esm/utilities/is-react-element.js
var import_react762 = __toESM(require_react());
function isReactElement(x) {
  return (0, import_react762.isValidElement)(x) && x !== void 0;
}

// ../node_modules/@shopify/polaris/build/esm/components/Page/Page.scss.js
var styles112 = {
  "Page": "Polaris-Page",
  "fullWidth": "Polaris-Page--fullWidth",
  "narrowWidth": "Polaris-Page--narrowWidth",
  "Content": "Polaris-Page__Content",
  "divider": "Polaris-Page--divider"
};

// ../node_modules/@shopify/polaris/build/esm/components/Page/components/Header/Header.js
var import_react765 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Page/components/Header/Header.scss.js
var styles113 = {
  "TitleWrapper": "Polaris-Page-Header__TitleWrapper",
  "BreadcrumbWrapper": "Polaris-Page-Header__BreadcrumbWrapper",
  "PaginationWrapper": "Polaris-Page-Header__PaginationWrapper",
  "PrimaryActionWrapper": "Polaris-Page-Header__PrimaryActionWrapper",
  "Row": "Polaris-Page-Header__Row",
  "mobileView": "Polaris-Page-Header--mobileView",
  "RightAlign": "Polaris-Page-Header__RightAlign",
  "noBreadcrumbs": "Polaris-Page-Header--noBreadcrumbs",
  "AdditionalMetaData": "Polaris-Page-Header__AdditionalMetaData",
  "Actions": "Polaris-Page-Header__Actions",
  "longTitle": "Polaris-Page-Header--longTitle",
  "mediumTitle": "Polaris-Page-Header--mediumTitle",
  "isSingleRow": "Polaris-Page-Header--isSingleRow"
};

// ../node_modules/@shopify/polaris/build/esm/components/Pagination/Pagination.js
var import_react763 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/utilities/is-input-focused.js
var EditableTarget;
(function(EditableTarget2) {
  EditableTarget2["Input"] = "INPUT";
  EditableTarget2["Textarea"] = "TEXTAREA";
  EditableTarget2["Select"] = "SELECT";
  EditableTarget2["ContentEditable"] = "contenteditable";
})(EditableTarget || (EditableTarget = {}));
function isInputFocused() {
  if (document == null || document.activeElement == null) {
    return false;
  }
  const {
    tagName
  } = document.activeElement;
  return tagName === EditableTarget.Input || tagName === EditableTarget.Textarea || tagName === EditableTarget.Select || document.activeElement.hasAttribute(EditableTarget.ContentEditable);
}

// ../node_modules/@shopify/polaris/build/esm/components/Pagination/Pagination.js
function Pagination({
  hasNext,
  hasPrevious,
  nextURL,
  previousURL,
  onNext,
  onPrevious,
  nextTooltip,
  previousTooltip,
  nextKeys,
  previousKeys,
  accessibilityLabel,
  accessibilityLabels,
  label
}) {
  const i18n = useI18n();
  const node = (0, import_react763.createRef)();
  const navLabel = accessibilityLabel || i18n.translate("Polaris.Pagination.pagination");
  const previousLabel = (accessibilityLabels === null || accessibilityLabels === void 0 ? void 0 : accessibilityLabels.previous) || i18n.translate("Polaris.Pagination.previous");
  const nextLabel = (accessibilityLabels === null || accessibilityLabels === void 0 ? void 0 : accessibilityLabels.next) || i18n.translate("Polaris.Pagination.next");
  const prev = import_react763.default.createElement(Button, {
    outline: true,
    icon: SvgChevronLeftMinor,
    accessibilityLabel: previousLabel,
    url: previousURL,
    onClick: onPrevious,
    disabled: !hasPrevious,
    id: "previousURL"
  });
  const constructedPrevious = previousTooltip && hasPrevious ? import_react763.default.createElement(Tooltip, {
    activatorWrapper: "span",
    content: previousTooltip
  }, prev) : prev;
  const next = import_react763.default.createElement(Button, {
    outline: true,
    icon: SvgChevronRightMinor,
    accessibilityLabel: nextLabel,
    url: nextURL,
    onClick: onNext,
    disabled: !hasNext,
    id: "nextURL"
  });
  const constructedNext = nextTooltip && hasNext ? import_react763.default.createElement(Tooltip, {
    activatorWrapper: "span",
    content: nextTooltip
  }, next) : next;
  const previousHandler = onPrevious || noop18;
  const previousButtonEvents = previousKeys && (previousURL || onPrevious) && hasPrevious && previousKeys.map((key) => import_react763.default.createElement(KeypressListener, {
    key,
    keyCode: key,
    handler: previousURL ? handleCallback(clickPaginationLink("previousURL", node)) : handleCallback(previousHandler)
  }));
  const nextHandler = onNext || noop18;
  const nextButtonEvents = nextKeys && (nextURL || onNext) && hasNext && nextKeys.map((key) => import_react763.default.createElement(KeypressListener, {
    key,
    keyCode: key,
    handler: nextURL ? handleCallback(clickPaginationLink("nextURL", node)) : handleCallback(nextHandler)
  }));
  const labelTextMarkup = hasNext && hasPrevious ? import_react763.default.createElement("span", null, label) : import_react763.default.createElement(Text, {
    color: "subdued",
    as: "span"
  }, label);
  const labelMarkup = label ? import_react763.default.createElement("div", {
    "aria-live": "polite"
  }, labelTextMarkup) : null;
  return import_react763.default.createElement("nav", {
    "aria-label": navLabel,
    ref: node
  }, previousButtonEvents, nextButtonEvents, import_react763.default.createElement(ButtonGroup, {
    segmented: !label
  }, constructedPrevious, labelMarkup, constructedNext));
}
function clickPaginationLink(id, node) {
  return () => {
    if (node.current == null) {
      return;
    }
    const link = node.current.querySelector(`#${id}`);
    if (link) {
      link.click();
    }
  };
}
function handleCallback(fn) {
  return () => {
    if (isInputFocused()) {
      return;
    }
    fn();
  };
}
function noop18() {
}

// ../node_modules/@shopify/polaris/build/esm/components/Page/components/Header/components/Title/Title.js
var import_react764 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/Page/components/Header/components/Title/Title.scss.js
var styles114 = {
  "Title": "Polaris-Header-Title",
  "TitleWithSubtitle": "Polaris-Header-Title__TitleWithSubtitle",
  "SubTitle": "Polaris-Header-Title__SubTitle",
  "SubtitleCompact": "Polaris-Header-Title__SubtitleCompact",
  "TitleWithMetadataWrapper": "Polaris-Header-Title__TitleWithMetadataWrapper",
  "TitleMetadata": "Polaris-Header-Title__TitleMetadata"
};

// ../node_modules/@shopify/polaris/build/esm/components/Page/components/Header/components/Title/Title.js
function Title({
  title,
  subtitle,
  titleMetadata,
  compactTitle
}) {
  const className = classNames(styles114.Title, subtitle && styles114.TitleWithSubtitle);
  const titleMarkup = title ? import_react764.default.createElement("h1", {
    className
  }, title) : null;
  const titleMetadataMarkup = titleMetadata ? import_react764.default.createElement("div", {
    className: styles114.TitleMetadata
  }, titleMetadata) : null;
  const wrappedTitleMarkup = titleMetadata ? import_react764.default.createElement("div", {
    className: styles114.TitleWithMetadataWrapper
  }, titleMarkup, titleMetadataMarkup) : titleMarkup;
  const subtitleMarkup = subtitle ? import_react764.default.createElement("div", {
    className: classNames(styles114.SubTitle, compactTitle && styles114.SubtitleCompact)
  }, import_react764.default.createElement("p", null, subtitle)) : null;
  return import_react764.default.createElement(import_react764.default.Fragment, null, wrappedTitleMarkup, subtitleMarkup);
}

// ../node_modules/@shopify/polaris/build/esm/components/Page/components/Header/Header.js
var SHORT_TITLE = 20;
var REALLY_SHORT_TITLE = 8;
var LONG_TITLE = 34;
function Header5({
  title,
  subtitle,
  titleMetadata,
  additionalMetadata,
  titleHidden = false,
  primaryAction,
  pagination,
  additionalNavigation,
  breadcrumbs,
  backAction,
  secondaryActions = [],
  actionGroups = [],
  compactTitle = false,
  onActionRollup
}) {
  const i18n = useI18n();
  const {
    isNavigationCollapsed
  } = useMediaQuery();
  if (additionalNavigation && true) {
    console.warn("Deprecation: The `additionalNavigation` on Page is deprecated and will be removed in the next major version.");
  }
  if (breadcrumbs && true) {
    console.warn("Deprecation: The `breadcrumbs` prop on Page is deprecated and will be removed in the next major version. Please replace with a single `backAction`.");
  }
  const isSingleRow = !primaryAction && !pagination && (isInterface(secondaryActions) && !secondaryActions.length || isReactElement(secondaryActions)) && !actionGroups.length;
  let breadcrumbMarkup = null;
  if (backAction) {
    breadcrumbMarkup = import_react765.default.createElement("div", {
      className: styles113.BreadcrumbWrapper
    }, import_react765.default.createElement(Box, {
      maxWidth: "100%",
      paddingInlineEnd: "4",
      printHidden: true
    }, import_react765.default.createElement(Breadcrumbs, {
      backAction
    })));
  } else if (Array.isArray(breadcrumbs) && breadcrumbs.length > 0 || !Array.isArray(breadcrumbs) && breadcrumbs) {
    breadcrumbMarkup = import_react765.default.createElement("div", {
      className: styles113.BreadcrumbWrapper
    }, import_react765.default.createElement(Box, {
      maxWidth: "100%",
      paddingInlineEnd: "4",
      printHidden: true
    }, import_react765.default.createElement(Breadcrumbs, {
      breadcrumbs
    })));
  }
  const paginationMarkup = pagination && !isNavigationCollapsed ? import_react765.default.createElement("div", {
    className: styles113.PaginationWrapper
  }, import_react765.default.createElement(Box, {
    printHidden: true
  }, import_react765.default.createElement(Pagination, pagination))) : null;
  const additionalNavigationMarkup = additionalNavigation ? import_react765.default.createElement(HorizontalStack, {
    gap: "4",
    align: "end"
  }, import_react765.default.createElement(Box, {
    printHidden: true
  }, additionalNavigation)) : null;
  const pageTitleMarkup = import_react765.default.createElement("div", {
    className: styles113.TitleWrapper
  }, import_react765.default.createElement(Title, {
    title,
    subtitle,
    titleMetadata,
    compactTitle
  }));
  const primaryActionMarkup = primaryAction ? import_react765.default.createElement(PrimaryActionMarkup, {
    primaryAction
  }) : null;
  let actionMenuMarkup = null;
  if (isInterface(secondaryActions) && (secondaryActions.length > 0 || hasGroupsWithActions(actionGroups))) {
    actionMenuMarkup = import_react765.default.createElement(ActionMenu, {
      actions: secondaryActions,
      groups: actionGroups,
      rollup: isNavigationCollapsed,
      rollupActionsLabel: title ? i18n.translate("Polaris.Page.Header.rollupActionsLabel", {
        title
      }) : void 0,
      onActionRollup
    });
  } else if (isReactElement(secondaryActions)) {
    actionMenuMarkup = import_react765.default.createElement(import_react765.default.Fragment, null, secondaryActions);
  }
  const navigationMarkup = breadcrumbMarkup || paginationMarkup || additionalNavigationMarkup ? import_react765.default.createElement(Box, {
    printHidden: true,
    paddingBlockEnd: "1",
    paddingInlineEnd: actionMenuMarkup && isNavigationCollapsed ? "10" : void 0
  }, import_react765.default.createElement(HorizontalStack, {
    gap: "4",
    align: "space-between",
    blockAlign: "center"
  }, breadcrumbMarkup, additionalNavigationMarkup, paginationMarkup)) : null;
  const additionalMetadataMarkup = additionalMetadata ? import_react765.default.createElement("div", {
    className: styles113.AdditionalMetaData
  }, import_react765.default.createElement(Text, {
    color: "subdued",
    as: "span"
  }, additionalMetadata)) : null;
  const headerClassNames = classNames(isSingleRow && styles113.isSingleRow, navigationMarkup && styles113.hasNavigation, actionMenuMarkup && styles113.hasActionMenu, isNavigationCollapsed && styles113.mobileView, !breadcrumbMarkup && styles113.noBreadcrumbs, title && title.length < LONG_TITLE && styles113.mediumTitle, title && title.length > LONG_TITLE && styles113.longTitle);
  const {
    slot1,
    slot2,
    slot3,
    slot4,
    slot5,
    slot6
  } = determineLayout({
    actionMenuMarkup,
    additionalMetadataMarkup,
    additionalNavigationMarkup,
    breadcrumbMarkup,
    isNavigationCollapsed,
    pageTitleMarkup,
    paginationMarkup,
    primaryActionMarkup,
    title
  });
  return import_react765.default.createElement(Box, {
    position: "relative",
    paddingBlockStart: {
      xs: "4",
      md: "5"
    },
    paddingBlockEnd: {
      xs: "4",
      md: "5"
    },
    paddingInlineStart: {
      xs: "4",
      sm: "0"
    },
    paddingInlineEnd: {
      xs: "4",
      sm: "0"
    },
    visuallyHidden: titleHidden
  }, import_react765.default.createElement("div", {
    className: headerClassNames
  }, import_react765.default.createElement(ConditionalRender, {
    condition: [slot1, slot2, slot3, slot4].some(notNull)
  }, import_react765.default.createElement("div", {
    className: styles113.Row
  }, slot1, slot2, import_react765.default.createElement(ConditionalRender, {
    condition: [slot3, slot4].some(notNull)
  }, import_react765.default.createElement("div", {
    className: styles113.RightAlign
  }, import_react765.default.createElement(ConditionalWrapper, {
    condition: [slot3, slot4].every(notNull),
    wrapper: (children2) => import_react765.default.createElement("div", {
      className: styles113.Actions
    }, children2)
  }, slot3, slot4))))), import_react765.default.createElement(ConditionalRender, {
    condition: [slot5, slot6].some(notNull)
  }, import_react765.default.createElement("div", {
    className: styles113.Row
  }, import_react765.default.createElement(HorizontalStack, {
    gap: "4"
  }, slot5), import_react765.default.createElement(ConditionalRender, {
    condition: slot6 != null
  }, import_react765.default.createElement("div", {
    className: styles113.RightAlign
  }, slot6))))));
}
function PrimaryActionMarkup({
  primaryAction
}) {
  const {
    isNavigationCollapsed
  } = useMediaQuery();
  let actionMarkup;
  if (isInterface(primaryAction)) {
    const {
      primary: isPrimary,
      helpText
    } = primaryAction;
    const primary = isPrimary === void 0 ? true : isPrimary;
    const content = buttonFrom(shouldShowIconOnly(isNavigationCollapsed, primaryAction), {
      primary
    });
    actionMarkup = helpText ? import_react765.default.createElement(Tooltip, {
      content: helpText
    }, content) : content;
  } else {
    actionMarkup = primaryAction;
  }
  return import_react765.default.createElement("div", {
    className: styles113.PrimaryActionWrapper
  }, import_react765.default.createElement(Box, {
    printHidden: true
  }, actionMarkup));
}
function shouldShowIconOnly(isMobile, action) {
  let {
    content,
    accessibilityLabel,
    icon
  } = action;
  if (icon == null)
    return {
      ...action,
      icon: void 0
    };
  if (isMobile) {
    accessibilityLabel = accessibilityLabel || content;
    content = void 0;
  } else {
    icon = void 0;
  }
  return {
    ...action,
    content,
    accessibilityLabel,
    icon
  };
}
function notNull(value) {
  return value != null;
}
function determineLayout({
  actionMenuMarkup,
  additionalMetadataMarkup,
  additionalNavigationMarkup,
  breadcrumbMarkup,
  isNavigationCollapsed,
  pageTitleMarkup,
  paginationMarkup,
  primaryActionMarkup,
  title
}) {
  const layouts = {
    mobileCompact: {
      slots: {
        slot1: null,
        slot2: pageTitleMarkup,
        slot3: actionMenuMarkup,
        slot4: primaryActionMarkup,
        slot5: additionalMetadataMarkup,
        slot6: additionalNavigationMarkup
      },
      condition: isNavigationCollapsed && breadcrumbMarkup == null && title != null && title.length <= REALLY_SHORT_TITLE
    },
    mobileDefault: {
      slots: {
        slot1: breadcrumbMarkup,
        slot2: pageTitleMarkup,
        slot3: actionMenuMarkup,
        slot4: primaryActionMarkup,
        slot5: additionalMetadataMarkup,
        slot6: additionalNavigationMarkup
      },
      condition: isNavigationCollapsed
    },
    desktopCompact: {
      slots: {
        slot1: breadcrumbMarkup,
        slot2: pageTitleMarkup,
        slot3: actionMenuMarkup,
        slot4: primaryActionMarkup,
        slot5: additionalMetadataMarkup,
        slot6: additionalNavigationMarkup
      },
      condition: !isNavigationCollapsed && paginationMarkup == null && actionMenuMarkup == null && title != null && title.length <= SHORT_TITLE
    },
    desktopDefault: {
      slots: {
        slot1: breadcrumbMarkup,
        slot2: pageTitleMarkup,
        slot3: import_react765.default.createElement(import_react765.default.Fragment, null, actionMenuMarkup, primaryActionMarkup),
        slot4: paginationMarkup,
        slot5: additionalMetadataMarkup,
        slot6: additionalNavigationMarkup
      },
      condition: !isNavigationCollapsed
    }
  };
  const layout = Object.values(layouts).find((layout2) => layout2.condition) || layouts.desktopDefault;
  return layout.slots;
}

// ../node_modules/@shopify/polaris/build/esm/components/Page/Page.js
function Page({
  children: children2,
  fullWidth,
  narrowWidth,
  divider,
  ...rest
}) {
  const pageClassName = classNames(styles112.Page, fullWidth && styles112.fullWidth, narrowWidth && styles112.narrowWidth);
  const hasHeaderContent = rest.title != null && rest.title !== "" || rest.subtitle != null && rest.subtitle !== "" || rest.primaryAction != null || rest.secondaryActions != null && (isInterface(rest.secondaryActions) && rest.secondaryActions.length > 0 || isReactElement(rest.secondaryActions)) || rest.actionGroups != null && rest.actionGroups.length > 0 || rest.breadcrumbs != null && Array.isArray(rest.breadcrumbs) && rest.breadcrumbs.length > 0 || rest.breadcrumbs != null || rest.backAction != null;
  const contentClassName = classNames(!hasHeaderContent && styles112.Content, divider && hasHeaderContent && styles112.divider);
  const headerMarkup = hasHeaderContent ? import_react766.default.createElement(Header5, rest) : null;
  return import_react766.default.createElement("div", {
    className: pageClassName
  }, headerMarkup, import_react766.default.createElement("div", {
    className: contentClassName
  }, children2));
}

// ../node_modules/@shopify/polaris/build/esm/components/PageActions/PageActions.js
var import_react767 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/PageActions/PageActions.scss.js
var styles115 = {
  "PageActions": "Polaris-PageActions"
};

// ../node_modules/@shopify/polaris/build/esm/components/PageActions/PageActions.js
function PageActions({
  primaryAction,
  secondaryActions
}) {
  let primaryActionMarkup = null;
  if (isReactElement(primaryAction)) {
    primaryActionMarkup = import_react767.default.createElement(import_react767.default.Fragment, null, primaryAction);
  } else if (primaryAction) {
    primaryActionMarkup = buttonsFrom(primaryAction, {
      primary: true
    });
  }
  let secondaryActionsMarkup = null;
  if (isInterface(secondaryActions) && secondaryActions.length > 0) {
    secondaryActionsMarkup = import_react767.default.createElement(ButtonGroup, null, buttonsFrom(secondaryActions));
  } else if (isReactElement(secondaryActions)) {
    secondaryActionsMarkup = import_react767.default.createElement(import_react767.default.Fragment, null, secondaryActions);
  }
  return import_react767.default.createElement("div", {
    className: styles115.PageActions
  }, import_react767.default.createElement(LegacyStack, {
    distribution: "trailing",
    spacing: "tight"
  }, secondaryActionsMarkup, primaryActionMarkup));
}

// ../node_modules/@shopify/polaris/build/esm/components/PolarisTestProvider/PolarisTestProvider.js
var import_react768 = __toESM(require_react());
var defaultMediaQuery = {
  isNavigationCollapsed: false
};
function PolarisTestProvider({
  strict,
  children: children2,
  i18n,
  link,
  mediaQuery,
  features = {},
  frame
}) {
  const Wrapper = strict ? import_react768.StrictMode : import_react768.Fragment;
  const intl = (0, import_react768.useMemo)(() => new I18n(i18n || {}), [i18n]);
  const scrollLockManager = (0, import_react768.useMemo)(() => new ScrollLockManager(), []);
  const stickyManager = (0, import_react768.useMemo)(() => new StickyManager(), []);
  const uniqueIdFactory = (0, import_react768.useMemo)(() => new UniqueIdFactory(globalIdGeneratorFactory), []);
  const mergedFrame = createFrameContext(frame);
  const mergedMediaQuery = merge(defaultMediaQuery, mediaQuery);
  return import_react768.default.createElement(Wrapper, null, import_react768.default.createElement(FeaturesContext.Provider, {
    value: features
  }, import_react768.default.createElement(I18nContext.Provider, {
    value: intl
  }, import_react768.default.createElement(ScrollLockManagerContext.Provider, {
    value: scrollLockManager
  }, import_react768.default.createElement(StickyManagerContext.Provider, {
    value: stickyManager
  }, import_react768.default.createElement(UniqueIdFactoryContext.Provider, {
    value: uniqueIdFactory
  }, import_react768.default.createElement(LinkContext.Provider, {
    value: link
  }, import_react768.default.createElement(MediaQueryContext.Provider, {
    value: mergedMediaQuery
  }, import_react768.default.createElement(PortalsManager, null, import_react768.default.createElement(FocusManager, null, import_react768.default.createElement(EphemeralPresenceManager, null, import_react768.default.createElement(FrameContext.Provider, {
    value: mergedFrame
  }, children2))))))))))));
}
function noop19() {
}
function createFrameContext({
  logo = void 0,
  showToast = noop19,
  hideToast = noop19,
  setContextualSaveBar = noop19,
  removeContextualSaveBar = noop19,
  startLoading = noop19,
  stopLoading = noop19
} = {}) {
  return {
    logo,
    showToast,
    hideToast,
    setContextualSaveBar,
    removeContextualSaveBar,
    startLoading,
    stopLoading
  };
}

// ../node_modules/@shopify/polaris/build/esm/components/ProgressBar/ProgressBar.js
var import_react769 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/ProgressBar/ProgressBar.scss.js
var styles116 = {
  "ProgressBar": "Polaris-ProgressBar",
  "sizeSmall": "Polaris-ProgressBar--sizeSmall",
  "sizeMedium": "Polaris-ProgressBar--sizeMedium",
  "sizeLarge": "Polaris-ProgressBar--sizeLarge",
  "colorHighlight": "Polaris-ProgressBar--colorHighlight",
  "colorPrimary": "Polaris-ProgressBar--colorPrimary",
  "colorSuccess": "Polaris-ProgressBar--colorSuccess",
  "colorCritical": "Polaris-ProgressBar--colorCritical",
  "Indicator": "Polaris-ProgressBar__Indicator",
  "IndicatorAppearActive": "Polaris-ProgressBar__IndicatorAppearActive",
  "IndicatorAppearDone": "Polaris-ProgressBar__IndicatorAppearDone",
  "Progress": "Polaris-ProgressBar__Progress",
  "Label": "Polaris-ProgressBar__Label"
};

// ../node_modules/@shopify/polaris/build/esm/components/ProgressBar/ProgressBar.js
function ProgressBar({
  progress = 0,
  size = "medium",
  color: color2 = "highlight",
  animated: hasAppearAnimation = true,
  ariaLabelledBy
}) {
  const i18n = useI18n();
  const indicatorRef = (0, import_react769.useRef)(null);
  const className = classNames(styles116.ProgressBar, size && styles116[variationName("size", size)], color2 && styles116[variationName("color", color2)]);
  const warningMessage = i18n.translate(progress < 0 ? "Polaris.ProgressBar.negativeWarningMessage" : "Polaris.ProgressBar.exceedWarningMessage", {
    progress
  });
  const parsedProgress = parseProgress(progress, warningMessage);
  const progressBarDuration = hasAppearAnimation ? motion2["duration-500"] : motion2["duration-0"];
  return import_react769.default.createElement("div", {
    className
  }, import_react769.default.createElement("progress", {
    "aria-labelledby": ariaLabelledBy,
    className: styles116.Progress,
    value: parsedProgress,
    max: "100"
  }), import_react769.default.createElement(CSSTransition_default, {
    in: true,
    appear: true,
    timeout: parseInt(progressBarDuration, 10),
    nodeRef: indicatorRef,
    classNames: {
      appearActive: styles116.IndicatorAppearActive,
      appearDone: styles116.IndicatorAppearDone
    }
  }, import_react769.default.createElement("div", {
    ref: indicatorRef,
    className: styles116.Indicator,
    style: {
      "--pc-progress-bar-duration": progressBarDuration,
      "--pc-progress-bar-percent": parsedProgress / 100
    }
  }, import_react769.default.createElement("span", {
    className: styles116.Label
  }, parsedProgress, "%"))));
}
function parseProgress(progress, warningMessage) {
  let progressWidth;
  if (progress < 0) {
    if (true) {
      console.warn(warningMessage);
    }
    progressWidth = 0;
  } else if (progress > 100) {
    if (true) {
      console.warn(warningMessage);
    }
    progressWidth = 100;
  } else {
    progressWidth = progress;
  }
  return progressWidth;
}

// ../node_modules/@shopify/polaris/build/esm/components/RangeSlider/RangeSlider.js
var import_react772 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/RangeSlider/components/DualThumb/DualThumb.js
var import_react770 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/RangeSlider/RangeSlider.scss.js
var sharedStyles = {
  "RangeSlider": "Polaris-RangeSlider"
};

// ../node_modules/@shopify/polaris/build/esm/components/RangeSlider/components/DualThumb/DualThumb.scss.js
var styles117 = {
  "RangeSlider": "Polaris-RangeSlider-DualThumb__RangeSlider",
  "DualThumb": "Polaris-RangeSlider-DualThumb",
  "TrackWrapper": "Polaris-RangeSlider-DualThumb__TrackWrapper",
  "disabled": "Polaris-RangeSlider-DualThumb--disabled",
  "Track": "Polaris-RangeSlider-DualThumb__Track",
  "error": "Polaris-RangeSlider-DualThumb--error",
  "Track--dashed": "Polaris-RangeSlider-DualThumb--trackDashed",
  "Thumbs": "Polaris-RangeSlider-DualThumb__Thumbs",
  "Prefix": "Polaris-RangeSlider-DualThumb__Prefix",
  "Suffix": "Polaris-RangeSlider-DualThumb__Suffix",
  "Output": "Polaris-RangeSlider-DualThumb__Output",
  "OutputBubble": "Polaris-RangeSlider-DualThumb__OutputBubble"
};

// ../node_modules/@shopify/polaris/build/esm/components/RangeSlider/components/DualThumb/DualThumb.js
var Control;
(function(Control2) {
  Control2[Control2["Lower"] = 0] = "Lower";
  Control2[Control2["Upper"] = 1] = "Upper";
})(Control || (Control = {}));
var DualThumb = class extends import_react770.Component {
  constructor(...args) {
    super(...args);
    this.context = void 0;
    this.state = {
      value: sanitizeValue(this.props.value, this.props.min, this.props.max, this.props.step),
      trackWidth: 0,
      trackLeft: 0
    };
    this.track = (0, import_react770.createRef)();
    this.trackWrapper = (0, import_react770.createRef)();
    this.thumbLower = (0, import_react770.createRef)();
    this.thumbUpper = (0, import_react770.createRef)();
    this.setTrackPosition = debounce(() => {
      if (this.track.current) {
        const thumbSize = 16;
        const {
          width,
          left
        } = this.track.current.getBoundingClientRect();
        const adjustedTrackWidth = width - thumbSize;
        const adjustedTrackLeft = left + thumbSize / 2;
        const range = this.props.max - this.props.min;
        const minValuePosition = this.props.min / range * adjustedTrackWidth;
        this.setState({
          trackWidth: adjustedTrackWidth,
          trackLeft: adjustedTrackLeft - minValuePosition
        });
      }
    }, 40, {
      leading: true,
      trailing: true,
      maxWait: 40
    });
    this.handleMouseDownThumbLower = (event) => {
      if (event.button !== 0 || this.props.disabled)
        return;
      registerMouseMoveHandler(this.handleMouseMoveThumbLower);
      event.stopPropagation();
    };
    this.handleMouseMoveThumbLower = (event) => {
      const valueUpper = this.state.value[1];
      this.setValue([this.actualXPosition(event.clientX), valueUpper], Control.Upper);
    };
    this.handleTouchStartThumbLower = (event) => {
      if (this.props.disabled)
        return;
      registerTouchMoveHandler(this.handleTouchMoveThumbLower);
      event.stopPropagation();
    };
    this.handleTouchMoveThumbLower = (event) => {
      event.preventDefault();
      const valueUpper = this.state.value[1];
      this.setValue([this.actualXPosition(event.touches[0].clientX), valueUpper], Control.Upper);
    };
    this.handleMouseDownThumbUpper = (event) => {
      if (event.button !== 0 || this.props.disabled)
        return;
      registerMouseMoveHandler(this.handleMouseMoveThumbUpper);
      event.stopPropagation();
    };
    this.handleMouseMoveThumbUpper = (event) => {
      const valueLower = this.state.value[0];
      this.setValue([valueLower, this.actualXPosition(event.clientX)], Control.Lower);
    };
    this.handleTouchStartThumbUpper = (event) => {
      if (this.props.disabled)
        return;
      registerTouchMoveHandler(this.handleTouchMoveThumbUpper);
      event.stopPropagation();
    };
    this.handleTouchMoveThumbUpper = (event) => {
      event.preventDefault();
      const valueLower = this.state.value[0];
      this.setValue([valueLower, this.actualXPosition(event.touches[0].clientX)], Control.Lower);
    };
    this.handleKeypressLower = (event) => {
      if (this.props.disabled)
        return;
      const {
        incrementValueLower,
        decrementValueLower
      } = this;
      const handlerMap = {
        [Key.UpArrow]: incrementValueLower,
        [Key.RightArrow]: incrementValueLower,
        [Key.DownArrow]: decrementValueLower,
        [Key.LeftArrow]: decrementValueLower
      };
      const handler = handlerMap[event.keyCode];
      if (handler != null) {
        event.preventDefault();
        event.stopPropagation();
        handler();
      }
    };
    this.handleKeypressUpper = (event) => {
      if (this.props.disabled)
        return;
      const {
        incrementValueUpper,
        decrementValueUpper
      } = this;
      const handlerMap = {
        [Key.UpArrow]: incrementValueUpper,
        [Key.RightArrow]: incrementValueUpper,
        [Key.DownArrow]: decrementValueUpper,
        [Key.LeftArrow]: decrementValueUpper
      };
      const handler = handlerMap[event.keyCode];
      if (handler != null) {
        event.preventDefault();
        event.stopPropagation();
        handler();
      }
    };
    this.incrementValueLower = () => {
      this.setValue([this.state.value[0] + this.props.step, this.state.value[1]], Control.Upper);
    };
    this.decrementValueLower = () => {
      this.setValue([this.state.value[0] - this.props.step, this.state.value[1]], Control.Upper);
    };
    this.incrementValueUpper = () => {
      this.setValue([this.state.value[0], this.state.value[1] + this.props.step], Control.Lower);
    };
    this.decrementValueUpper = () => {
      this.setValue([this.state.value[0], this.state.value[1] - this.props.step], Control.Lower);
    };
    this.dispatchValue = () => {
      const {
        onChange,
        id
      } = this.props;
      const {
        value
      } = this.state;
      onChange(value, id);
    };
    this.setValue = (dirtyValue, control) => {
      const {
        props: {
          min,
          max,
          step
        },
        state: {
          value
        }
      } = this;
      const sanitizedValue = sanitizeValue(dirtyValue, min, max, step, control);
      if (isTupleEqual(sanitizedValue, value) === false) {
        this.setState({
          value: sanitizedValue
        }, this.dispatchValue);
      }
    };
    this.handleMouseDownTrack = (event) => {
      if (event.button !== 0 || this.props.disabled)
        return;
      event.preventDefault();
      const clickXPosition = this.actualXPosition(event.clientX);
      const {
        value
      } = this.state;
      const distanceFromLowerThumb = Math.abs(value[0] - clickXPosition);
      const distanceFromUpperThumb = Math.abs(value[1] - clickXPosition);
      if (distanceFromLowerThumb <= distanceFromUpperThumb) {
        this.setValue([clickXPosition, value[1]], Control.Upper);
        registerMouseMoveHandler(this.handleMouseMoveThumbLower);
        if (this.thumbLower.current != null) {
          this.thumbLower.current.focus();
        }
      } else {
        this.setValue([value[0], clickXPosition], Control.Lower);
        registerMouseMoveHandler(this.handleMouseMoveThumbUpper);
        if (this.thumbUpper.current != null) {
          this.thumbUpper.current.focus();
        }
      }
    };
    this.handleTouchStartTrack = (event) => {
      if (this.props.disabled)
        return;
      event.preventDefault();
      const clickXPosition = this.actualXPosition(event.touches[0].clientX);
      const {
        value
      } = this.state;
      const distanceFromLowerThumb = Math.abs(value[0] - clickXPosition);
      const distanceFromUpperThumb = Math.abs(value[1] - clickXPosition);
      if (distanceFromLowerThumb <= distanceFromUpperThumb) {
        this.setValue([clickXPosition, value[1]], Control.Upper);
        registerTouchMoveHandler(this.handleTouchMoveThumbLower);
        if (this.thumbLower.current != null) {
          this.thumbLower.current.focus();
        }
      } else {
        this.setValue([value[0], clickXPosition], Control.Lower);
        registerTouchMoveHandler(this.handleTouchMoveThumbUpper);
        if (this.thumbUpper.current != null) {
          this.thumbUpper.current.focus();
        }
      }
    };
    this.actualXPosition = (dirtyXPosition) => {
      if (this.track.current) {
        const {
          min,
          max
        } = this.props;
        const {
          trackLeft,
          trackWidth
        } = this.state;
        const relativeX = dirtyXPosition - trackLeft;
        const percentageOfTrack = relativeX / trackWidth;
        return percentageOfTrack * (max - min);
      } else {
        return 0;
      }
    };
  }
  static getDerivedStateFromProps(props, state) {
    const {
      min,
      step,
      max,
      value,
      onChange,
      id
    } = props;
    const {
      prevValue
    } = state;
    if (isTupleEqual(prevValue, value)) {
      return null;
    }
    const sanitizedValue = sanitizeValue(value, min, max, step);
    if (!isTupleEqual(value, sanitizedValue)) {
      onChange(sanitizedValue, id);
    }
    return {
      prevValue: value,
      value: sanitizedValue
    };
  }
  componentDidMount() {
    this.setTrackPosition();
    if (this.trackWrapper.current != null) {
      this.trackWrapper.current.addEventListener("touchstart", this.handleTouchStartTrack, {
        passive: false
      });
    }
  }
  componentWillUnmount() {
    if (this.trackWrapper.current != null) {
      this.trackWrapper.current.removeEventListener("touchstart", this.handleTouchStartTrack);
    }
  }
  render() {
    const {
      id,
      min,
      max,
      prefix,
      suffix,
      disabled,
      output,
      error,
      onFocus,
      onBlur,
      label,
      labelAction,
      labelHidden,
      helpText
    } = this.props;
    const {
      value
    } = this.state;
    const idLower = id;
    const idUpper = `${id}Upper`;
    const describedBy = [];
    if (error) {
      describedBy.push(`${id}Error`);
    }
    const ariaDescribedBy = describedBy.length ? describedBy.join(" ") : void 0;
    const trackWrapperClassName = classNames(styles117.TrackWrapper, error && styles117.error, disabled && styles117.disabled);
    const thumbLowerClassName = classNames(styles117.Thumbs, styles117.ThumbLower, disabled && styles117.disabled);
    const thumbUpperClassName = classNames(styles117.Thumbs, styles117.ThumbUpper, disabled && styles117.disabled);
    const trackWidth = this.state.trackWidth;
    const range = max - min;
    const minValuePosition = min / range * trackWidth;
    const leftPositionThumbLower = value[0] / range * trackWidth - minValuePosition;
    const leftPositionThumbUpper = value[1] / range * trackWidth - minValuePosition;
    const outputLowerClassName = classNames(styles117.Output, styles117.OutputLower);
    const outputMarkupLower = !disabled && output ? import_react770.default.createElement("output", {
      htmlFor: idLower,
      className: outputLowerClassName,
      style: {
        left: `${leftPositionThumbLower}px`
      }
    }, import_react770.default.createElement("div", {
      className: styles117.OutputBubble
    }, import_react770.default.createElement(Text, {
      as: "span",
      variant: "headingXs",
      alignment: "center"
    }, value[0]))) : null;
    const outputUpperClassName = classNames(styles117.Output, styles117.OutputUpper);
    const outputMarkupUpper = !disabled && output ? import_react770.default.createElement("output", {
      htmlFor: idUpper,
      className: outputUpperClassName,
      style: {
        left: `${leftPositionThumbUpper}px`
      }
    }, import_react770.default.createElement("div", {
      className: styles117.OutputBubble
    }, import_react770.default.createElement(Text, {
      as: "span",
      variant: "headingXs",
      alignment: "center"
    }, value[1]))) : null;
    const cssVars = {
      "--pc-range-slider-progress-lower": `${leftPositionThumbLower}px`,
      "--pc-range-slider-progress-upper": `${leftPositionThumbUpper}px`
    };
    const prefixMarkup = prefix && import_react770.default.createElement("div", {
      className: styles117.Prefix
    }, prefix);
    const suffixMarkup = suffix && import_react770.default.createElement("div", {
      className: styles117.Suffix
    }, suffix);
    return import_react770.default.createElement(import_react770.default.Fragment, null, import_react770.default.createElement(Labelled, {
      id,
      label,
      error,
      action: labelAction,
      labelHidden,
      helpText
    }, import_react770.default.createElement("div", {
      className: classNames(styles117.DualThumb, sharedStyles.RangeSlider)
    }, prefixMarkup, import_react770.default.createElement("div", {
      className: trackWrapperClassName,
      onMouseDown: this.handleMouseDownTrack,
      ref: this.trackWrapper
    }, import_react770.default.createElement("div", {
      className: styles117.Track,
      style: cssVars,
      ref: this.track
    }), import_react770.default.createElement("div", {
      className: styles117["Track--dashed"]
    }), import_react770.default.createElement("div", {
      id: idLower,
      className: thumbLowerClassName,
      style: {
        left: `${leftPositionThumbLower}px`
      },
      role: "slider",
      "aria-disabled": disabled,
      "aria-valuemin": min,
      "aria-valuemax": max,
      "aria-valuenow": value[0],
      "aria-invalid": Boolean(error),
      "aria-describedby": ariaDescribedBy,
      "aria-labelledby": labelID(id),
      onFocus,
      onBlur,
      tabIndex: 0,
      onKeyDown: this.handleKeypressLower,
      onMouseDown: this.handleMouseDownThumbLower,
      onTouchStart: this.handleTouchStartThumbLower,
      ref: this.thumbLower
    }), outputMarkupLower, import_react770.default.createElement("div", {
      id: idUpper,
      className: thumbUpperClassName,
      style: {
        left: `${leftPositionThumbUpper}px`
      },
      role: "slider",
      "aria-disabled": disabled,
      "aria-valuemin": min,
      "aria-valuemax": max,
      "aria-valuenow": value[1],
      "aria-invalid": Boolean(error),
      "aria-describedby": ariaDescribedBy,
      "aria-labelledby": labelID(id),
      onFocus,
      onBlur,
      tabIndex: 0,
      onKeyDown: this.handleKeypressUpper,
      onMouseDown: this.handleMouseDownThumbUpper,
      onTouchStart: this.handleTouchStartThumbUpper,
      ref: this.thumbUpper
    }), outputMarkupUpper), suffixMarkup)), import_react770.default.createElement(EventListener, {
      event: "resize",
      handler: this.setTrackPosition
    }));
  }
};
DualThumb.contextType = FeaturesContext;
function registerMouseMoveHandler(handler) {
  document.addEventListener("mousemove", handler);
  document.addEventListener("mouseup", () => {
    document.removeEventListener("mousemove", handler);
  }, {
    once: true
  });
}
function registerTouchMoveHandler(handler) {
  const removeHandler = () => {
    document.removeEventListener("touchmove", handler);
    document.removeEventListener("touchend", removeHandler);
    document.removeEventListener("touchcancel", removeHandler);
  };
  document.addEventListener("touchmove", handler, {
    passive: false
  });
  document.addEventListener("touchend", removeHandler, {
    once: true
  });
  document.addEventListener("touchcancel", removeHandler, {
    once: true
  });
}
function sanitizeValue(value, min, max, step, control = Control.Upper) {
  let upperValue = inBoundsUpper(roundedToStep(value[1]));
  let lowerValue = inBoundsLower(roundedToStep(value[0]));
  const maxLowerValue = upperValue - step;
  const minUpperValue = lowerValue + step;
  if (control === Control.Upper && lowerValue > maxLowerValue) {
    lowerValue = maxLowerValue;
  } else if (control === Control.Lower && upperValue < minUpperValue) {
    upperValue = minUpperValue;
  }
  return [lowerValue, upperValue];
  function inBoundsUpper(value2) {
    const lowerMin = min + step;
    if (value2 < lowerMin) {
      return lowerMin;
    } else if (value2 > max) {
      return max;
    } else {
      return value2;
    }
  }
  function inBoundsLower(value2) {
    const upperMax = max - step;
    if (value2 < min) {
      return min;
    } else if (value2 > upperMax) {
      return upperMax;
    } else {
      return value2;
    }
  }
  function roundedToStep(value2) {
    return Math.round(value2 / step) * step;
  }
}
function isTupleEqual(a, b) {
  if (a == null || b == null) {
    return false;
  }
  return a[0] === b[0] && a[1] === b[1];
}

// ../node_modules/@shopify/polaris/build/esm/components/RangeSlider/components/SingleThumb/SingleThumb.js
var import_react771 = __toESM(require_react());

// ../node_modules/@shopify/polaris/build/esm/components/RangeSlider/components/SingleThumb/SingleThumb.scss.js
var styles118 = {
  "RangeSlider": "Polaris-RangeSlider-SingleThumb__RangeSlider",
  "SingleThumb": "Polaris-RangeSlider-SingleThumb",
  "disabled": "Polaris-RangeSlider-SingleThumb--disabled",
  "InputWrapper": "Polaris-RangeSlider-SingleThumb__InputWrapper",
  "Prefix": "Polaris-RangeSlider-SingleThumb__Prefix",
  "Suffix": "Polaris-RangeSlider-SingleThumb__Suffix",
  "Input": "Polaris-RangeSlider-SingleThumb__Input",
  "error": "Polaris-RangeSlider-SingleThumb--error",
  "Output": "Polaris-RangeSlider-SingleThumb__Output",
  "OutputBubble": "Polaris-RangeSlider-SingleThumb__OutputBubble"
};

// ../node_modules/@shopify/polaris/build/esm/components/RangeSlider/utilities/invertNumber.js
function invertNumber(number) {
  if (Math.sign(number) === 1) {
    return -Math.abs(number);
  } else if (Math.sign(number) === -1) {
    return Math.abs(number);
  } else {
    return 0;
  }
}

// ../node_modules/@shopify/polaris/build/esm/components/RangeSlider/components/SingleThumb/SingleThumb.js
function SingleThumb(props) {
  const {
    id,
    error,
    helpText,
    value,
    min,
    max,
    disabled,
    output,
    prefix,
    suffix,
    label,
    labelAction,
    labelHidden,
    step,
    onBlur,
    onFocus
  } = props;
  const clampedValue = clamp(value, min, max);
  const describedBy = [];
  if (error) {
    describedBy.push(`${id}Error`);
  }
  if (helpText) {
    describedBy.push(helpTextID(id));
  }
  const ariaDescribedBy = describedBy.length ? describedBy.join(" ") : void 0;
  const sliderProgress = (clampedValue - min) * 100 / (max - min);
  const outputFactor = invertNumber((sliderProgress - 50) / 100);
  const cssVars = {
    "--pc-range-slider-min": min,
    "--pc-range-slider-max": max,
    "--pc-range-slider-current": clampedValue,
    "--pc-range-slider-progress": `${sliderProgress}%`,
    "--pc-range-slider-output-factor": `${outputFactor}`
  };
  const outputMarkup = !disabled && output && import_react771.default.createElement("output", {
    htmlFor: id,
    className: styles118.Output
  }, import_react771.default.createElement("div", {
    className: styles118.OutputBubble
  }, import_react771.default.createElement(Text, {
    as: "span",
    variant: "headingXs",
    alignment: "center"
  }, clampedValue)));
  const prefixMarkup = prefix && import_react771.default.createElement("div", {
    className: styles118.Prefix
  }, prefix);
  const suffixMarkup = suffix && import_react771.default.createElement("div", {
    className: styles118.Suffix
  }, suffix);
  const className = classNames(styles118.SingleThumb, sharedStyles.RangeSlider, error && styles118.error, disabled && styles118.disabled);
  return import_react771.default.createElement(Labelled, {
    id,
    label,
    error,
    action: labelAction,
    labelHidden,
    helpText
  }, import_react771.default.createElement("div", {
    className,
    style: cssVars
  }, prefixMarkup, import_react771.default.createElement("div", {
    className: styles118.InputWrapper
  }, import_react771.default.createElement("input", {
    type: "range",
    className: styles118.Input,
    id,
    name: id,
    min,
    max,
    step,
    value: clampedValue,
    disabled,
    onChange: handleChange,
    onFocus,
    onBlur,
    "aria-valuemin": min,
    "aria-valuemax": max,
    "aria-valuenow": clampedValue,
    "aria-invalid": Boolean(error),
    "aria-describedby": ariaDescribedBy
  }), outputMarkup), suffixMarkup));
  function handleChange(event) {
    const {
      onChange
    } = props;
    onChange && onChange(parseFloat(event.currentTarget.value), id);
  }
}

// ../node_modules/@shopify/polaris/build/esm/components/RangeSlider/RangeSlider.js
function RangeSlider({
  min = 0,
  max = 100,
  step = 1,
  value,
  ...rest
}) {
  const id = useUniqueId("RangeSlider");
  const sharedProps = {
    id,
    min,
    max,
    step,
    ...rest
  };
  return isDualThumb(value) ? import_react772.default.createElement(DualThumb, Object.assign({
    value
  }, sharedProps)) : import_react772.default.createElement(SingleThumb, Object.assign({
    value
  }, sharedProps));
}
function isDualThumb(value) {
  return Array.isArray(value);
}

// ../node_modules/@shopify/polaris/build/esm/components/ResourceItem/ResourceItem.js
var import_react773 = __toESM(require_react());
var import_react_fast_compare3 = __toESM(require_react_fast_compare());

// ../node_modules/@shopify/polaris/build/esm/components/ResourceItem/ResourceItem.scss.js
var styles119 = {
  "ResourceItem": "Polaris-ResourceItem",
  "Actions": "Polaris-ResourceItem__Actions",
  "ItemWrapper": "Polaris-ResourceItem__ItemWrapper",
  "focusedInner": "Polaris-ResourceItem--focusedInner",
  "focused": "Polaris-ResourceItem--focused",
  "selected": "Polaris-ResourceItem--selected",
  "Link": "Polaris-ResourceItem__Link",
  "Button": "Polaris-ResourceItem__Button",
  "selectable": "Polaris-ResourceItem--selectable",
  "selectMode": "Polaris-ResourceItem--selectMode",
  "ListItem": "Polaris-ResourceItem__ListItem"
};

// ../node_modules/@shopify/polaris/build/esm/utilities/resource-list/types.js
var SELECT_ALL_ITEMS2 = "All";

// ../node_modules/@shopify/polaris/build/esm/components/ResourceItem/ResourceItem.js
var getUniqueCheckboxID = globalIdGeneratorFactory("ResourceListItemCheckbox");
var getUniqueOverlayID = globalIdGeneratorFactory("ResourceListItemOverlay");
var BaseResourceItem = class extends import_react773.Component {
  constructor(...args) {
    super(...args);
    this.state = {
      actionsMenuVisible: false,
      focused: false,
      focusedInner: false,
      selected: isSelected(this.props.id, this.props.context.selectedItems)
    };
    this.node = null;
    this.checkboxId = getUniqueCheckboxID();
    this.overlayId = getUniqueOverlayID();
    this.buttonOverlay = (0, import_react773.createRef)();
    this.setNode = (node) => {
      this.node = node;
    };
    this.handleFocus = (event) => {
      if (event.target === this.buttonOverlay.current || this.node && event.target === this.node.querySelector(`#${this.overlayId}`)) {
        this.setState({
          focused: true,
          focusedInner: false
        });
      } else if (this.node && this.node.contains(event.target)) {
        this.setState({
          focused: true,
          focusedInner: true
        });
      }
    };
    this.handleBlur = ({
      relatedTarget
    }) => {
      if (this.node && relatedTarget instanceof Element && this.node.contains(relatedTarget)) {
        return;
      }
      this.setState({
        focused: false,
        focusedInner: false
      });
    };
    this.handleMouseOut = () => {
      this.state.focused && this.setState({
        focused: false,
        focusedInner: false
      });
    };
    this.handleLargerSelectionArea = (event) => {
      stopPropagation2(event);
      this.handleSelection(!this.state.selected, event.nativeEvent.shiftKey);
    };
    this.handleSelection = (value, shiftKey) => {
      const {
        id,
        sortOrder,
        context: {
          onSelectionChange
        }
      } = this.props;
      if (id == null || onSelectionChange == null) {
        return;
      }
      this.setState({
        focused: value,
        focusedInner: value
      });
      onSelectionChange(value, id, sortOrder, shiftKey);
    };
    this.handleClick = (event) => {
      stopPropagation2(event);
      const {
        id,
        onClick,
        url,
        context: {
          selectMode
        }
      } = this.props;
      const {
        ctrlKey,
        metaKey
      } = event.nativeEvent;
      const anchor = this.node && this.node.querySelector("a");
      if (selectMode) {
        this.handleLargerSelectionArea(event);
        return;
      }
      if (anchor === event.target) {
        return;
      }
      if (onClick) {
        onClick(id);
      }
      if (url && (ctrlKey || metaKey)) {
        window.open(url, "_blank");
        return;
      }
      if (url && anchor) {
        anchor.click();
      }
    };
    this.handleKeyUp = (event) => {
      const {
        onClick = noop20,
        context: {
          selectMode
        }
      } = this.props;
      const {
        key
      } = event;
      if (key === "Enter" && this.props.url && !selectMode) {
        onClick();
      }
    };
    this.handleActionsClick = () => {
      this.setState(({
        actionsMenuVisible
      }) => ({
        actionsMenuVisible: !actionsMenuVisible
      }));
    };
    this.handleCloseRequest = () => {
      this.setState({
        actionsMenuVisible: false
      });
    };
  }
  static getDerivedStateFromProps(nextProps, prevState) {
    const selected = isSelected(nextProps.id, nextProps.context.selectedItems);
    if (prevState.selected === selected) {
      return null;
    }
    return {
      selected
    };
  }
  shouldComponentUpdate(nextProps, nextState) {
    const {
      children: nextChildren,
      context: {
        selectedItems: nextSelectedItems,
        ...restNextContext
      },
      ...restNextProps
    } = nextProps;
    const {
      children: children2,
      context: {
        selectedItems,
        ...restContext
      },
      ...restProps
    } = this.props;
    const nextSelectMode = nextProps.context.selectMode;
    return !(0, import_react_fast_compare3.default)(this.state, nextState) || this.props.context.selectMode !== nextSelectMode || !nextProps.context.selectMode && (!(0, import_react_fast_compare3.default)(restProps, restNextProps) || !(0, import_react_fast_compare3.default)(restContext, restNextContext));
  }
  render() {
    const {
      children: children2,
      url,
      external,
      media,
      shortcutActions,
      ariaControls,
      ariaExpanded,
      persistActions = false,
      accessibilityLabel,
      name,
      context: {
        selectable,
        selectMode,
        hasBulkActions,
        loading,
        resourceName
      },
      i18n,
      verticalAlignment,
      dataHref,
      breakpoints: breakpoints3
    } = this.props;
    const {
      actionsMenuVisible,
      focused,
      focusedInner,
      selected
    } = this.state;
    let ownedMarkup = null;
    let handleMarkup = null;
    if (selectable) {
      const checkboxAccessibilityLabel = name || accessibilityLabel || i18n.translate("Polaris.Common.checkbox");
      handleMarkup = import_react773.default.createElement("div", {
        onClick: this.handleLargerSelectionArea
      }, import_react773.default.createElement(Bleed, {
        marginBlock: "2",
        marginInline: "3"
      }, import_react773.default.createElement(Box, {
        zIndex: "var(--pc-resource-item-content-stacking-order)",
        paddingInlineStart: "3",
        paddingInlineEnd: "3",
        paddingBlockStart: "3",
        paddingBlockEnd: "2"
      }, import_react773.default.createElement("div", {
        onClick: stopPropagation2
      }, import_react773.default.createElement("div", {
        onChange: this.handleLargerSelectionArea
      }, import_react773.default.createElement(Checkbox, {
        id: this.checkboxId,
        label: checkboxAccessibilityLabel,
        labelHidden: true,
        checked: selected,
        disabled: loading
      }))))));
    }
    if (media || selectable) {
      ownedMarkup = import_react773.default.createElement(HorizontalStack, {
        gap: "4",
        blockAlign: media && selectable ? "center" : getAlignment(verticalAlignment)
      }, handleMarkup, media);
    }
    const className = classNames(styles119.ResourceItem, focused && styles119.focused, selectable && styles119.selectable, selected && styles119.selected, selectMode && styles119.selectMode, persistActions && styles119.persistActions, focusedInner && styles119.focusedInner);
    const listItemClassName = classNames(styles119.ListItem, focused && !focusedInner && styles119.focused, hasBulkActions && styles119.hasBulkActions);
    let actionsMarkup = null;
    let disclosureMarkup = null;
    if (shortcutActions && !loading) {
      if (persistActions) {
        actionsMarkup = breakpoints3 !== null && breakpoints3 !== void 0 && breakpoints3.lgUp ? import_react773.default.createElement("div", {
          className: styles119.Actions,
          onClick: stopPropagation2
        }, import_react773.default.createElement(ButtonGroup, null, buttonsFrom(shortcutActions, {
          plain: true
        }))) : null;
        const disclosureAccessibilityLabel = name ? i18n.translate("Polaris.ResourceList.Item.actionsDropdownLabel", {
          accessibilityLabel: name
        }) : i18n.translate("Polaris.ResourceList.Item.actionsDropdown");
        disclosureMarkup = !selectMode && breakpoints3 !== null && breakpoints3 !== void 0 && breakpoints3.lgDown ? import_react773.default.createElement("div", {
          onClick: stopPropagation2
        }, import_react773.default.createElement(Popover2, {
          activator: import_react773.default.createElement(Button, {
            accessibilityLabel: disclosureAccessibilityLabel,
            onClick: this.handleActionsClick,
            plain: true,
            icon: SvgHorizontalDotsMinor
          }),
          onClose: this.handleCloseRequest,
          active: actionsMenuVisible
        }, import_react773.default.createElement(ActionList, {
          items: shortcutActions
        }))) : null;
      } else if (breakpoints3 !== null && breakpoints3 !== void 0 && breakpoints3.lgUp) {
        actionsMarkup = import_react773.default.createElement("div", {
          className: styles119.Actions,
          onClick: stopPropagation2
        }, import_react773.default.createElement(Box, {
          position: "absolute",
          insetBlockStart: "4",
          insetInlineEnd: "5"
        }, import_react773.default.createElement(ButtonGroup, {
          segmented: true
        }, buttonsFrom(shortcutActions, {
          size: "slim"
        }))));
      }
    }
    const containerMarkup = import_react773.default.createElement(Box, {
      id: this.props.id,
      position: "relative",
      padding: "3",
      paddingInlineStart: {
        xs: "4",
        sm: "5"
      },
      paddingInlineEnd: {
        xs: "4",
        sm: "5"
      },
      zIndex: "var(--pc-resource-item-content-stacking-order)"
    }, import_react773.default.createElement(HorizontalGrid, {
      columns: {
        xs: "1fr auto"
      }
    }, import_react773.default.createElement(HorizontalGrid, {
      columns: {
        xs: media || selectable ? "auto 1fr" : "1fr"
      },
      gap: "5"
    }, ownedMarkup, import_react773.default.createElement(HorizontalStack, {
      gap: "4",
      blockAlign: getAlignment(verticalAlignment)
    }, import_react773.default.createElement(Box, {
      