import React, { useEffect, useState } from 'react'
import { Layout, LegacyCard, Page } from "@shopify/polaris";
import { Card, OrderDetails, OrderGraphs } from "../components";
import {useAuthenticatedFetch} from '../hooks'
import Checkout from './Checkout';


export default function HomePage() {


  let fetch = useAuthenticatedFetch();
  let [products,setProducts] = useState(0);
  let [totalOrder,setTotalOrder] = useState(0);
  let [fullfilledOrder,setFullfilledOrder] = useState(0);
  let [remainsOrder,setRemainsOrder] = useState(0);
  let [collections,setCollections] = useState(0);

  useEffect(() => {
    const fetchData = async () => {
      try {
        let request = await fetch("/api/products/count");
        let response = await request.json();
        setProducts(response.count);
      } catch (error) {
        console.error('Error fetching data:', error);
      }
    };
    const fetchCollection = async () => {
      try {
        let request = await fetch("/api/collections/count");
        let response = await request.json();
        setCollections(response.count);
      } catch (error) {
        console.error('Error fetching data:', error);
      }
    };

    const fetchOrders = async () => {
      try {
        // console.log('Token Fetch Order : ',fetch);
        let request = await fetch("/api/orders/all");
        let response = await request.json();
        console.log('Fetch Order : ',response);
        setTotalOrder(response.data.length);
        let fulfill = response.data.filter(item => item.fulfillment_status === 'fulfilled' )
        setFullfilledOrder(fulfill.length) ;
        setRemainsOrder(response.data.length - fulfill.length);
      } catch (error) {
        console.error('Error fetching Order data:', error);
      }
    };

    const fetchCheckoutPage = async () => {
      try {
        let request = await fetch("/api/checkout/find");
        let response = await request.json();
        // console.log('Fetch Checkout : ',response);
       
      } catch (error) {
        console.error('Error fetching data:', error);
      }
    };

    const updateCheckoutPage = async () => {
      try {
        let request = await fetch("/api/checkout/update");
        let response = await request.json();
        // console.log('Update Checkout : ',response);
      } catch (error) {
        console.error('Error Update Checkout data:', error);
      }
    };

    const webhooksAll = async () => {
      try {
        let request = await fetch("/api/webhook/all");
        let response = await request.json();
        // console.log('Web hooksAll : ',response);
       
      } catch (error) {
        console.error('Error webhooksAll data:', error);
      }
    };

    const createWebhooks = async () => {
      try {
        let request = await fetch("/api/webhook/create");
        let response = await request.json();
        console.log('Create Webhooks : ',response);
       
      } catch (error) {
        console.error('Error createWebhooks data:', error);
      }
    };
 

    // createWebhooks();
    webhooksAll();
    updateCheckoutPage();
    fetchCheckoutPage();
    fetchData(); 
    fetchCollection();
    fetchOrders();
    return () => {
    };
  }, []);

  return (
    <Page fullWidth>
      {/* <div className="home-section">
        <div className="graphs-section">
          <OrderGraphs />
        </div>
        <div className="cards-section">
          <Layout>
            <Card title="Total Order" data={totalOrder} />
            <Card title="Fulfilled Order" data={fullfilledOrder} />
            <Card title="Remains Order" data={remainsOrder}/>
            <Card title="Total Products" data={products} />
            <Card title="Total collection" data={collections}/>
          </Layout>
        </div>
        <div className="order-details-section">
          <OrderDetails />
        </div>
      </div> */}
      <Checkout/>
    </Page>
  );
}