import type { MetadataProperties } from '../types';
export declare type MotionDurationScale = '0' | '50' | '100' | '150' | '200' | '250' | '300' | '350' | '400' | '450' | '500' | '5000';
export declare type MotionKeyframesAlias = 'bounce' | 'fade-in' | 'pulse' | 'spin' | 'appear-above' | 'appear-below';
declare type MotionTimingFunctionAlias = 'ease' | 'ease-in' | 'ease-out' | 'ease-in-out' | 'linear';
export declare type MotionTokenName = `duration-${MotionDurationScale}` | `keyframes-${MotionKeyframesAlias}` | MotionTimingFunctionAlias | `motion-duration-${MotionDurationScale}` | `motion-keyframes-${MotionKeyframesAlias}` | `motion-${MotionTimingFunctionAlias}`;
export declare type MotionTokenGroup = {
    [TokenName in MotionTokenName]: string;
};
export declare const motion: {
    [TokenName in MotionTokenName]: MetadataProperties;
};
export {};
//# sourceMappingURL=motion.d.ts.map