'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var css = require('../../utilities/css.js');
var HorizontalStack$1 = require('./HorizontalStack.scss.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const HorizontalStack = function HorizontalStack({
  align,
  blockAlign,
  gap,
  wrap = true,
  children
}) {
  const style = {
    '--pc-horizontal-stack-align': align,
    '--pc-horizontal-stack-block-align': blockAlign,
    '--pc-horizontal-stack-wrap': wrap ? 'wrap' : 'nowrap',
    ...css.getResponsiveProps('horizontal-stack', 'gap', 'space', gap)
  };
  return /*#__PURE__*/React__default["default"].createElement("div", {
    className: HorizontalStack$1["default"].HorizontalStack,
    style: style
  }, children);
};

exports.HorizontalStack = HorizontalStack;
