'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var css = require('../../../../utilities/css.js');
var FilterButton$1 = require('./FilterButton.scss.js');
var UnstyledButton = require('../../../UnstyledButton/UnstyledButton.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function FilterButton({
  onClick,
  'aria-label': ariaLabel,
  children,
  disabled
}) {
  const classes = css.classNames(FilterButton$1["default"].FilterButton, disabled && FilterButton$1["default"].Disabled);
  return /*#__PURE__*/React__default["default"].createElement(UnstyledButton.UnstyledButton, {
    className: classes,
    onClick: onClick,
    "aria-label": ariaLabel,
    disabled: disabled
  }, children);
}

exports.FilterButton = FilterButton;
