'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polarisIcons = require('@shopify/polaris-icons');
var FilterButton = require('../FilterButton/FilterButton.js');
var Tooltip = require('../../../Tooltip/Tooltip.js');
var HorizontalStack = require('../../../HorizontalStack/HorizontalStack.js');
var Icon = require('../../../Icon/Icon.js');
var Text = require('../../../Text/Text.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function SearchFilterButton({
  onClick,
  'aria-label': ariaLabel,
  disabled,
  tooltipContent,
  style,
  hideFilters,
  hideQueryField
}) {
  const activator = /*#__PURE__*/React__default["default"].createElement("div", {
    style: style
  }, /*#__PURE__*/React__default["default"].createElement(FilterButton.FilterButton, {
    onClick: onClick,
    "aria-label": ariaLabel,
    disabled: disabled
  }, /*#__PURE__*/React__default["default"].createElement(HorizontalStack.HorizontalStack, {
    gap: "0"
  }, hideQueryField ? null : /*#__PURE__*/React__default["default"].createElement(Icon.Icon, {
    source: polarisIcons.SearchMinor,
    color: "base"
  }), hideFilters ? null : /*#__PURE__*/React__default["default"].createElement(Icon.Icon, {
    source: polarisIcons.FilterMinor,
    color: "base"
  }))));
  const content = /*#__PURE__*/React__default["default"].createElement(Text.Text, {
    as: "span",
    variant: "bodyMd",
    alignment: "center"
  }, tooltipContent);
  return /*#__PURE__*/React__default["default"].createElement(Tooltip.Tooltip, {
    content: content,
    preferredPosition: "above",
    hoverDelay: 400
  }, activator);
}

exports.SearchFilterButton = SearchFilterButton;
