'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polarisIcons = require('@shopify/polaris-icons');
var FilterButton = require('../FilterButton/FilterButton.js');
var ChoiceList = require('../../../ChoiceList/ChoiceList.js');
var DirectionButton = require('./components/DirectionButton/DirectionButton.js');
var hooks = require('../../../../utilities/i18n/hooks.js');
var Tooltip = require('../../../Tooltip/Tooltip.js');
var Icon = require('../../../Icon/Icon.js');
var Popover = require('../../../Popover/Popover.js');
var Box = require('../../../Box/Box.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

exports.SortButtonDirection = void 0;

(function (SortButtonDirection) {
  SortButtonDirection["Asc"] = "asc";
  SortButtonDirection["Desc"] = "desc";
})(exports.SortButtonDirection || (exports.SortButtonDirection = {}));

function SortButton({
  choices,
  selected,
  onChange,
  disabled,
  onChangeKey,
  onChangeDirection
}) {
  var _selectedChoices$, _selectedChoices$2, _selectedChoices$3, _selectedChoices$4;

  const i18n = hooks.useI18n();
  const [active, setActive] = React.useState(false);
  const [selectedValueKey, selectedDirection] = selected[0].split(' ');

  function handleClick() {
    setActive(pastActive => !pastActive);
  }

  function handleClose() {
    setActive(false);
  }

  function handleChangeChoiceList(sel) {
    if (onChangeKey) {
      const [key] = sel[0].split(' ');
      onChangeKey(key);
    } else {
      onChange(sel);
    }
  }

  function handleChangeDirection(sel) {
    if (onChangeDirection) {
      const [, direction] = sel[0].split(' ');
      onChangeDirection(direction);
    } else {
      onChange(sel);
    }
  }

  const choiceListChoices = React.useMemo(() => {
    const choiceCategories = choices.reduce((acc, curr) => {
      const alreadyExists = acc.some(option => option.label === curr.label);
      const [, currentValueDirection] = curr.value.split(' ');
      const isSameDirection = currentValueDirection === selectedDirection;

      if (!alreadyExists) {
        return [...acc, curr];
      }

      if (isSameDirection) {
        return acc.map(option => {
          if (option.label === curr.label) {
            return curr;
          }

          return option;
        });
      }

      return acc;
    }, []);
    return choiceCategories;
  }, [choices, selectedDirection]);
  const selectedChoices = choices.filter(choice => {
    const [currentKey] = choice.value.split(' ');
    return currentKey === selectedValueKey;
  });
  const sortButton = /*#__PURE__*/React__default["default"].createElement(Tooltip.Tooltip, {
    content: i18n.translate('Polaris.IndexFilters.SortButton.tooltip'),
    preferredPosition: "above",
    hoverDelay: 400
  }, /*#__PURE__*/React__default["default"].createElement(FilterButton.FilterButton, {
    onClick: handleClick,
    "aria-label": i18n.translate('Polaris.IndexFilters.SortButton.ariaLabel'),
    disabled: disabled
  }, /*#__PURE__*/React__default["default"].createElement(Icon.Icon, {
    source: polarisIcons.SortMinor,
    color: "base"
  })));
  return /*#__PURE__*/React__default["default"].createElement(Popover.Popover, {
    active: active && !disabled,
    activator: sortButton,
    autofocusTarget: "first-node",
    onClose: handleClose,
    fluidContent: true
  }, /*#__PURE__*/React__default["default"].createElement(Box.Box, {
    minWidth: "148px",
    padding: "4",
    borderBlockEndWidth: "1",
    borderColor: "border-subdued"
  }, /*#__PURE__*/React__default["default"].createElement(ChoiceList.ChoiceList, {
    title: i18n.translate('Polaris.IndexFilters.SortButton.title'),
    choices: choiceListChoices,
    selected: selected,
    onChange: handleChangeChoiceList
  })), /*#__PURE__*/React__default["default"].createElement(Box.Box, {
    padding: "4"
  }, /*#__PURE__*/React__default["default"].createElement(DirectionButton.DirectionButton, {
    direction: "asc",
    active: selectedDirection === exports.SortButtonDirection.Asc,
    onClick: handleChangeDirection,
    value: selectedChoices === null || selectedChoices === void 0 ? void 0 : (_selectedChoices$ = selectedChoices[0]) === null || _selectedChoices$ === void 0 ? void 0 : _selectedChoices$.value
  }, selectedChoices === null || selectedChoices === void 0 ? void 0 : (_selectedChoices$2 = selectedChoices[0]) === null || _selectedChoices$2 === void 0 ? void 0 : _selectedChoices$2.directionLabel), /*#__PURE__*/React__default["default"].createElement(DirectionButton.DirectionButton, {
    direction: "desc",
    active: selectedDirection === exports.SortButtonDirection.Desc,
    onClick: handleChangeDirection,
    value: selectedChoices === null || selectedChoices === void 0 ? void 0 : (_selectedChoices$3 = selectedChoices[1]) === null || _selectedChoices$3 === void 0 ? void 0 : _selectedChoices$3.value
  }, selectedChoices === null || selectedChoices === void 0 ? void 0 : (_selectedChoices$4 = selectedChoices[1]) === null || _selectedChoices$4 === void 0 ? void 0 : _selectedChoices$4.directionLabel)));
}

exports.SortButton = SortButton;
