'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polarisIcons = require('@shopify/polaris-icons');
var css = require('../../../../../../utilities/css.js');
var DirectionButton$1 = require('./DirectionButton.scss.js');
var UnstyledButton = require('../../../../../UnstyledButton/UnstyledButton.js');
var Icon = require('../../../../../Icon/Icon.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function DirectionButton({
  onClick,
  active,
  children,
  direction,
  value
}) {
  const classes = css.classNames(DirectionButton$1["default"].DirectionButton, active && DirectionButton$1["default"]['DirectionButton-active']);

  function handleClick() {
    onClick([value]);
  }

  return /*#__PURE__*/React__default["default"].createElement(UnstyledButton.UnstyledButton, {
    className: classes,
    onClick: handleClick
  }, /*#__PURE__*/React__default["default"].createElement(Icon.Icon, {
    source: direction === 'asc' ? polarisIcons.ArrowUpMinor : polarisIcons.ArrowDownMinor,
    color: active ? 'interactive' : 'base'
  }), /*#__PURE__*/React__default["default"].createElement("span", {
    className: DirectionButton$1["default"].Label
  }, children));
}

exports.DirectionButton = DirectionButton;
