'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var focus = require('../../../../utilities/focus.js');
var useIsTouchDevice = require('../../../../utilities/use-is-touch-device.js');
var hooks = require('../../../../utilities/i18n/hooks.js');
var Button = require('../../../Button/Button.js');
var HorizontalStack = require('../../../HorizontalStack/HorizontalStack.js');
var Modal = require('../../../Modal/Modal.js');
var Form = require('../../../Form/Form.js');
var FormLayout = require('../../../FormLayout/FormLayout.js');
var TextField = require('../../../TextField/TextField.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const MAX_VIEW_NAME_LENGTH = 40;
function UpdateButtons({
  primaryAction,
  cancelAction,
  viewNames,
  disabled
}) {
  const i18n = hooks.useI18n();
  const [savedViewName, setSavedViewName] = React.useState('');
  const [savedViewModalOpen, setSavedViewModalOpen] = React.useState(false);
  const container = React.useRef(null);
  const isTouchDevice = useIsTouchDevice.useIsTouchDevice();
  React.useEffect(() => {
    if (!container.current || isTouchDevice) return;

    if (savedViewModalOpen) {
      focus.focusFirstFocusableNode(container.current);
    }
  }, [savedViewModalOpen, isTouchDevice]);

  async function handleClickSaveButton() {
    if ((primaryAction === null || primaryAction === void 0 ? void 0 : primaryAction.type) === 'save-as') {
      handleOpenModal();
    } else {
      await (primaryAction === null || primaryAction === void 0 ? void 0 : primaryAction.onAction(''));
    }
  }

  function handleOpenModal() {
    setSavedViewModalOpen(true);
  }

  function handleCloseModal() {
    setSavedViewModalOpen(false);
  }

  function handleChange(value) {
    setSavedViewName(value);
  }

  async function handlePrimaryAction() {
    if (isPrimaryActionDisabled) return;
    await (primaryAction === null || primaryAction === void 0 ? void 0 : primaryAction.onAction(savedViewName));
    handleCloseModal();
  }

  const buttonText = React.useMemo(() => {
    switch (primaryAction === null || primaryAction === void 0 ? void 0 : primaryAction.type) {
      case 'save':
        return i18n.translate('Polaris.IndexFilters.UpdateButtons.save');

      case 'save-as':
      default:
        return i18n.translate('Polaris.IndexFilters.UpdateButtons.saveAs');
    }
  }, [primaryAction === null || primaryAction === void 0 ? void 0 : primaryAction.type, i18n]);
  const saveButton = /*#__PURE__*/React__default["default"].createElement(Button.Button, {
    size: "micro",
    primary: true,
    plain: true,
    onClick: handleClickSaveButton,
    disabled: (primaryAction === null || primaryAction === void 0 ? void 0 : primaryAction.disabled) || disabled
  }, buttonText);
  const hasSameNameError = viewNames.some(name => name.trim().toLowerCase() === savedViewName.trim().toLowerCase());
  const isPrimaryActionDisabled = hasSameNameError || !savedViewName || (primaryAction === null || primaryAction === void 0 ? void 0 : primaryAction.loading) || savedViewName.length > MAX_VIEW_NAME_LENGTH;
  const cancelButtonMarkup = /*#__PURE__*/React__default["default"].createElement(Button.Button, {
    plain: true,
    size: "micro",
    onClick: cancelAction.onAction,
    disabled: disabled
  }, i18n.translate('Polaris.IndexFilters.UpdateButtons.cancel'));

  if (!primaryAction) {
    return cancelButtonMarkup;
  }

  return /*#__PURE__*/React__default["default"].createElement(HorizontalStack.HorizontalStack, {
    align: "start",
    blockAlign: "center",
    gap: "2"
  }, cancelButtonMarkup, primaryAction.type === 'save-as' ? /*#__PURE__*/React__default["default"].createElement(Modal.Modal, {
    activator: /*#__PURE__*/React__default["default"].createElement(HorizontalStack.HorizontalStack, null, saveButton),
    open: savedViewModalOpen,
    title: i18n.translate('Polaris.IndexFilters.UpdateButtons.modal.title'),
    onClose: handleCloseModal,
    primaryAction: {
      onAction: handlePrimaryAction,
      content: i18n.translate('Polaris.IndexFilters.UpdateButtons.modal.save'),
      disabled: isPrimaryActionDisabled
    },
    secondaryActions: [{
      onAction: handleCloseModal,
      content: i18n.translate('Polaris.IndexFilters.UpdateButtons.modal.cancel')
    }]
  }, /*#__PURE__*/React__default["default"].createElement(Modal.Modal.Section, null, /*#__PURE__*/React__default["default"].createElement(Form.Form, {
    onSubmit: handlePrimaryAction
  }, /*#__PURE__*/React__default["default"].createElement(FormLayout.FormLayout, null, /*#__PURE__*/React__default["default"].createElement("div", {
    ref: container
  }, /*#__PURE__*/React__default["default"].createElement(TextField.TextField, {
    label: i18n.translate('Polaris.IndexFilters.UpdateButtons.modal.label'),
    value: savedViewName,
    onChange: handleChange,
    autoComplete: "off",
    maxLength: MAX_VIEW_NAME_LENGTH,
    showCharacterCount: true,
    error: hasSameNameError ? i18n.translate('Polaris.IndexFilters.UpdateButtons.modal.sameName', {
      name: savedViewName
    }) : undefined
  })))))) : saveButton);
}

exports.UpdateButtons = UpdateButtons;
