'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var utils = require('../../../Button/utils.js');
var HorizontalStack = require('../../../HorizontalStack/HorizontalStack.js');
var Box = require('../../../Box/Box.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function Footer({
  primaryAction,
  secondaryActions,
  children
}) {
  const primaryActionButton = primaryAction && utils.buttonsFrom(primaryAction, {
    primary: true
  }) || null;
  const secondaryActionButtons = secondaryActions && utils.buttonsFrom(secondaryActions) || null;
  const actions = primaryActionButton || secondaryActionButtons ? /*#__PURE__*/React__default["default"].createElement(HorizontalStack.HorizontalStack, {
    gap: "2"
  }, secondaryActionButtons, primaryActionButton) : null;
  return /*#__PURE__*/React__default["default"].createElement(HorizontalStack.HorizontalStack, {
    gap: "4",
    blockAlign: "center"
  }, /*#__PURE__*/React__default["default"].createElement(Box.Box, {
    borderColor: "border-subdued",
    borderBlockStartWidth: "1",
    minHeight: "var(--p-space-16)",
    padding: "4",
    width: "100%"
  }, /*#__PURE__*/React__default["default"].createElement(HorizontalStack.HorizontalStack, {
    gap: "4",
    blockAlign: "center",
    align: "space-between"
  }, /*#__PURE__*/React__default["default"].createElement(Box.Box, null, children), actions)));
}

exports.Footer = Footer;
