'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var utils = require('../Button/utils.js');
var LegacyCard = require('../LegacyCard/LegacyCard.js');
var SettingAction = require('../SettingAction/SettingAction.js');
var uniqueIdFactory = require('../../utilities/unique-id/unique-id-factory.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const getUniqueSettingToggleId = uniqueIdFactory.globalIdGeneratorFactory('SettingToggle');
/**
 * @deprecated The SettingToggle component will be removed in v12.0.0.
 * See the "With primitive components" example to learn how to compose
 * setting toggles with layout and typography primitives.
 * https://polaris.shopify.com/components/deprecated/setting-toggle
 */

function SettingToggle({
  enabled,
  action,
  children
}) {
  const id = React.useMemo(getUniqueSettingToggleId, []);

  if (process.env.NODE_ENV === 'development') {
    // eslint-disable-next-line no-console
    console.warn(`Deprecation: <SettingToggle /> is deprecated. This component will be removed in a future major version of Polaris. Use the primitive layout and typography components to compose a setting toggle card.
      See the "With primitive components" example in https://polaris.shopify.com/components/deprecated/setting-toggle`);
  }

  const actionMarkup = action ? utils.buttonFrom(action, {
    role: 'switch',
    id,
    ariaChecked: enabled ? 'true' : 'false',
    size: 'slim'
  }) : null;
  return /*#__PURE__*/React__default["default"].createElement(LegacyCard.LegacyCard, {
    sectioned: true
  }, /*#__PURE__*/React__default["default"].createElement(SettingAction.SettingAction, {
    action: actionMarkup
  }, /*#__PURE__*/React__default["default"].createElement("label", {
    htmlFor: id
  }, children)));
}

exports.SettingToggle = SettingToggle;
