import React from 'react';
import { TextField } from '../../../TextField/TextField.js';

function SearchField({
  onChange,
  onClear,
  onFocus,
  onBlur,
  focused,
  value,
  placeholder,
  disabled,
  borderlessQueryField
}) {
  function handleChange(value) {
    onChange(value);
  }

  function handleClear() {
    if (onClear) {
      onClear();
    } else {
      onChange('');
    }
  }

  return /*#__PURE__*/React.createElement(TextField, {
    value: value,
    onChange: handleChange,
    onFocus: onFocus,
    onBlur: onBlur,
    label: placeholder,
    labelHidden: true,
    autoComplete: "off",
    focused: focused,
    placeholder: placeholder,
    clearButton: true,
    onClearButtonClick: handleClear,
    disabled: disabled,
    borderless: borderlessQueryField
  });
}

export { SearchField };
