import React from 'react';
import { classNames } from '../../../../utilities/css.js';
import styles from '../../AlphaTabs.scss.js';

function Panel({
  hidden,
  id,
  tabID,
  children
}) {
  const className = classNames(styles.Panel, hidden && styles['Panel-hidden']);
  return /*#__PURE__*/React.createElement("div", {
    className: className,
    id: id,
    role: "tabpanel",
    "aria-labelledby": tabID,
    tabIndex: -1
  }, children);
}

export { Panel };
