import React from 'react';
import { useI18n } from '../../../../../../utilities/i18n/hooks.js';
import { Modal } from '../../../../../Modal/Modal.js';

function DiscardConfirmationModal({
  open,
  onDiscard,
  onCancel
}) {
  const i18n = useI18n();
  return /*#__PURE__*/React.createElement(Modal, {
    title: i18n.translate('Polaris.DiscardConfirmationModal.title'),
    open: open,
    onClose: onCancel,
    primaryAction: {
      content: i18n.translate('Polaris.DiscardConfirmationModal.primaryAction'),
      destructive: true,
      onAction: onDiscard
    },
    secondaryActions: [{
      content: i18n.translate('Polaris.DiscardConfirmationModal.secondaryAction'),
      onAction: onCancel
    }],
    sectioned: true
  }, i18n.translate('Polaris.DiscardConfirmationModal.message'));
}

export { DiscardConfirmationModal };
