import React from 'react';
import { buttonsFrom } from '../../../Button/utils.js';
import { HorizontalStack } from '../../../HorizontalStack/HorizontalStack.js';
import { Box } from '../../../Box/Box.js';

function Footer({
  primaryAction,
  secondaryActions,
  children
}) {
  const primaryActionButton = primaryAction && buttonsFrom(primaryAction, {
    primary: true
  }) || null;
  const secondaryActionButtons = secondaryActions && buttonsFrom(secondaryActions) || null;
  const actions = primaryActionButton || secondaryActionButtons ? /*#__PURE__*/React.createElement(HorizontalStack, {
    gap: "2"
  }, secondaryActionButtons, primaryActionButton) : null;
  return /*#__PURE__*/React.createElement(HorizontalStack, {
    gap: "4",
    blockAlign: "center"
  }, /*#__PURE__*/React.createElement(Box, {
    borderColor: "border-subdued",
    borderBlockStartWidth: "1",
    minHeight: "var(--p-space-16)",
    padding: "4",
    width: "100%"
  }, /*#__PURE__*/React.createElement(HorizontalStack, {
    gap: "4",
    blockAlign: "center",
    align: "space-between"
  }, /*#__PURE__*/React.createElement(Box, null, children), actions)));
}

export { Footer };
