import React from 'react';
import { BorderRadiusScale, SpaceScale } from '@shopify/polaris-tokens';
import { TooltipOverlayProps } from './components';
export declare type Width = 'default' | 'wide';
export declare type Padding = 'default' | Extract<SpaceScale, '4'>;
export declare type BorderRadius = Extract<BorderRadiusScale, '1' | '2'>;
export interface TooltipProps {
    /** The element that will activate to tooltip */
    children?: React.ReactNode;
    /** The content to display within the tooltip */
    content: React.ReactNode;
    /** Toggle whether the tooltip is visible */
    active?: boolean;
    /** Delay in milliseconds while hovering over an element before the tooltip is visible */
    hoverDelay?: number;
    /** Dismiss tooltip when not interacting with its children */
    dismissOnMouseOut?: TooltipOverlayProps['preventInteraction'];
    /**
     * The direction the tooltip tries to display
     * @default 'above'
     */
    preferredPosition?: TooltipOverlayProps['preferredPosition'];
    /**
     * The element type to wrap the activator in
     * @default 'span'
     */
    activatorWrapper?: string;
    /** Visually hidden text for screen readers */
    accessibilityLabel?: string;
    /**
     * Width of content
     * @default 'default'
     */
    width?: Width;
    /**
     * Padding of content
     * @default 'default'
     */
    padding?: Padding;
    /**
     * Border radius of the tooltip
     * @default '1'
     */
    borderRadius?: BorderRadius;
    /** Override on the default z-index of 400 */
    zIndexOverride?: number;
    /** Whether to render a dotted underline underneath the tooltip's activator */
    hasUnderline?: boolean;
    /** Whether the tooltip's content remains open after clicking the activator */
    persistOnClick?: boolean;
    onOpen?(): void;
    onClose?(): void;
}
export declare function Tooltip({ children, content, dismissOnMouseOut, active: originalActive, hoverDelay, preferredPosition, activatorWrapper, accessibilityLabel, width, padding, borderRadius, zIndexOverride, hasUnderline, persistOnClick, onOpen, onClose, }: TooltipProps): JSX.Element;
//# sourceMappingURL=Tooltip.d.ts.map
