import type { ReactNode } from 'react';
import type { IconProps } from '../../../Icon';
import type { TooltipProps } from '../../../Tooltip';
export declare const MAX_SECONDARY_ACTIONS = 2;
interface ItemURLDetails {
    url?: string;
    matches?: boolean;
    exactMatch?: boolean;
    matchPaths?: string[];
    excludePaths?: string[];
    external?: boolean;
}
export interface SubNavigationItem extends ItemURLDetails {
    url: string;
    label: string;
    disabled?: boolean;
    new?: boolean;
    onClick?(): void;
}
interface SecondaryAction {
    accessibilityLabel: string;
    icon: IconProps['source'];
    url?: string;
    onClick?(): void;
    tooltip?: TooltipProps;
}
declare type SecondaryActions = [SecondaryAction] | [SecondaryAction, SecondaryAction];
export interface ItemProps extends ItemURLDetails {
    icon?: IconProps['source'];
    badge?: ReactNode;
    label: string;
    disabled?: boolean;
    accessibilityLabel?: string;
    selected?: boolean;
    exactMatch?: boolean;
    new?: boolean;
    subNavigationItems?: SubNavigationItem[];
    /** @deprecated Use secondaryActions instead. */
    secondaryAction?: SecondaryAction;
    secondaryActions?: SecondaryActions;
    displayActionsOnHover?: boolean;
    onClick?(): void;
    onToggleExpandedState?(): void;
    expanded?: boolean;
    shouldResizeIcon?: boolean;
    truncateText?: boolean;
}
export declare function Item({ url, icon, label, subNavigationItems, secondaryAction, secondaryActions, displayActionsOnHover, disabled, onClick, accessibilityLabel, selected: selectedOverride, badge, new: isNew, matches, exactMatch, matchPaths, excludePaths, external, onToggleExpandedState, expanded, shouldResizeIcon, truncateText, }: ItemProps): JSX.Element;
interface ItemSecondaryActionProps extends SecondaryAction {
    tabIndex: number;
    disabled?: boolean;
}
export declare function ItemSecondaryAction({ url, icon, accessibilityLabel, tooltip, onClick, disabled, tabIndex, }: ItemSecondaryActionProps): JSX.Element;
export declare function isNavigationItemActive(navigationItem: ItemProps, currentPath: string): boolean | undefined;
export {};
//# sourceMappingURL=Item.d.ts.map