"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mockRuntimeString = exports.mockFetch = exports.mockConvertHeaders = exports.mockConvertResponse = exports.mockConvertRequest = void 0;
const node_fetch_1 = require("node-fetch");
const http_1 = require("../../runtime/http");
const mock_test_requests_1 = require("./mock_test_requests");
async function mockConvertRequest(adapterArgs) {
    return Promise.resolve(adapterArgs.rawRequest);
}
exports.mockConvertRequest = mockConvertRequest;
async function mockConvertResponse(response, _adapterArgs) {
    return Promise.resolve(response);
}
exports.mockConvertResponse = mockConvertResponse;
async function mockConvertHeaders(headers, _adapterArgs) {
    return Promise.resolve(headers);
}
exports.mockConvertHeaders = mockConvertHeaders;
const mockFetch = async (url, init) => {
    const mockInit = init;
    const request = new node_fetch_1.Request(url, mockInit);
    const headers = Object.fromEntries(new node_fetch_1.Headers(mockInit?.headers).entries());
    mock_test_requests_1.mockTestRequests.requestList.push({
        url: request.url,
        method: request.method,
        headers: (0, http_1.canonicalizeHeaders)(headers),
        body: await request.text(),
    });
    const next = mock_test_requests_1.mockTestRequests.responseList.shift();
    if (!next) {
        throw new Error(`Missing mock for ${request.method} to ${url}, have you queued all required responses?`);
    }
    if (next instanceof Error) {
        throw next;
    }
    const responseHeaders = new node_fetch_1.Headers();
    Object.entries(next.headers ?? {}).forEach(([key, value]) => {
        responseHeaders.set(key, typeof value === 'string' ? value : value.join(', '));
    });
    return new node_fetch_1.Response(next.body, {
        status: next.statusCode,
        statusText: next.statusText,
        headers: responseHeaders,
    });
};
exports.mockFetch = mockFetch;
function mockRuntimeString() {
    return 'Mock adapter';
}
exports.mockRuntimeString = mockRuntimeString;
//# sourceMappingURL=adapter.js.map