"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.logDisabledFutureFlags = void 0;
function logDisabledFutureFlags(config, logger) {
    if (!config._logDisabledFutureFlags) {
        return;
    }
    const logFlag = (flag, message) => logger.info(`Future flag ${flag} is disabled.\n\n  ${message}\n`);
    if (!config.future?.v10_lineItemBilling) {
        logFlag('v10_lineItemBilling', 'Enable this flag to use the new billing API, that supports multiple line items per plan.');
    }
}
exports.logDisabledFutureFlags = logDisabledFutureFlags;
//# sourceMappingURL=flags.js.map