/**
 * A class that represents a set of access token scopes.
 */
declare class AuthScopes {
    static SCOPE_DELIMITER: string;
    private compressedScopes;
    private expandedScopes;
    constructor(scopes: string | string[] | AuthScopes | undefined);
    /**
     * Checks whether the current set of scopes includes the given one.
     */
    has(scope: string | string[] | AuthScopes | undefined): boolean;
    /**
     * Checks whether the current set of scopes equals the given one.
     */
    equals(otherScopes: string | string[] | AuthScopes | undefined): boolean;
    /**
     * Returns a comma-separated string with the current set of scopes.
     */
    toString(): string;
    /**
     * Returns an array with the current set of scopes.
     */
    toArray(): string[];
    private getImpliedScopes;
}
export { AuthScopes };
//# sourceMappingURL=index.d.ts.map