"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateFactory = void 0;
const hmac_validator_1 = require("../utils/hmac-validator");
const types_1 = require("../utils/types");
function validateFactory(config) {
    return async function validate({ rawBody, ...adapterArgs }) {
        return (0, hmac_validator_1.validateHmacFromRequestFactory)(config)({
            type: types_1.HmacValidationType.FulfillmentService,
            rawBody,
            ...adapterArgs,
        });
    };
}
exports.validateFactory = validateFactory;
//# sourceMappingURL=validate.js.map