"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fetchRequestFactory = void 0;
const logger_1 = require("../logger");
const types_1 = require("../types");
const runtime_1 = require("../../runtime");
function fetchRequestFactory(config) {
    return async function fetchRequest(url, options) {
        const log = (0, logger_1.logger)(config);
        const doLog = config.logger.httpRequests && config.logger.level === types_1.LogSeverity.Debug;
        if (doLog) {
            log.debug('Making HTTP request', {
                method: options?.method || 'GET',
                url,
                ...(options?.body && { body: options?.body }),
            });
        }
        const response = await (0, runtime_1.abstractFetch)(url, options);
        if (doLog) {
            log.debug('HTTP request completed', {
                method: options?.method || 'GET',
                url,
                status: response.status,
            });
        }
        return response;
    };
}
exports.fetchRequestFactory = fetchRequestFactory;
//# sourceMappingURL=fetch-request.js.map