"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebhookValidationErrorReason = exports.WebhookOperation = exports.DeliveryMethod = void 0;
const types_1 = require("../utils/types");
var DeliveryMethod;
(function (DeliveryMethod) {
    DeliveryMethod["Http"] = "http";
    DeliveryMethod["EventBridge"] = "eventbridge";
    DeliveryMethod["PubSub"] = "pubsub";
})(DeliveryMethod || (exports.DeliveryMethod = DeliveryMethod = {}));
// eslint-disable-next-line no-warning-comments
// TODO Rethink the wording for this enum - the operations we're doing are actually "subscribing" and "unsubscribing"
// Consider changing the values when releasing v9.0.0 when it can be safely deprecated
var WebhookOperation;
(function (WebhookOperation) {
    WebhookOperation["Create"] = "create";
    WebhookOperation["Update"] = "update";
    WebhookOperation["Delete"] = "delete";
})(WebhookOperation || (exports.WebhookOperation = WebhookOperation = {}));
exports.WebhookValidationErrorReason = {
    ...types_1.ValidationErrorReason,
    MissingHeaders: 'missing_headers',
};
//# sourceMappingURL=types.js.map