"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.AndroidPayKey = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class AndroidPayKey extends base_1.Base {
    static async find({ session, id }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
    static async delete({ session, id }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return response ? response.body : null;
    }
}
exports.AndroidPayKey = AndroidPayKey;
AndroidPayKey.apiVersion = types_1.ApiVersion.October22;
AndroidPayKey.hasOne = {};
AndroidPayKey.hasMany = {};
AndroidPayKey.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["id"], "path": "android_pay_keys/<id>.json" },
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "android_pay_keys/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": [], "path": "android_pay_keys.json" }
];
AndroidPayKey.resourceNames = [
    {
        "singular": "android_pay_key",
        "plural": "android_pay_keys"
    }
];
//# sourceMappingURL=android_pay_key.js.map