"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.CollectionListing = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
const image_1 = require("./image");
class CollectionListing extends base_1.Base {
    static async find({ session, collection_id }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "collection_id": collection_id },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
    static async delete({ session, collection_id }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "collection_id": collection_id },
            params: {},
        });
        return response ? response.body : null;
    }
    static async all({ session, limit = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: {},
            params: { "limit": limit, ...otherArgs },
        });
        return response;
    }
    static async product_ids({ session, collection_id, limit = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "get",
            operation: "product_ids",
            session: session,
            urlIds: { "collection_id": collection_id },
            params: { "limit": limit, ...otherArgs },
            body: {},
            entity: null,
        });
        return response ? response.body : null;
    }
}
exports.CollectionListing = CollectionListing;
CollectionListing.apiVersion = types_1.ApiVersion.October22;
CollectionListing.hasOne = {
    "image": image_1.Image
};
CollectionListing.hasMany = {};
CollectionListing.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["collection_id"], "path": "collection_listings/<collection_id>.json" },
    { "http_method": "get", "operation": "get", "ids": [], "path": "collection_listings.json" },
    { "http_method": "get", "operation": "get", "ids": ["collection_id"], "path": "collection_listings/<collection_id>.json" },
    { "http_method": "get", "operation": "product_ids", "ids": ["collection_id"], "path": "collection_listings/<collection_id>/product_ids.json" },
    { "http_method": "put", "operation": "put", "ids": ["collection_id"], "path": "collection_listings/<collection_id>.json" }
];
CollectionListing.primaryKey = "collection_id";
CollectionListing.resourceNames = [
    {
        "singular": "collection_listing",
        "plural": "collection_listings"
    }
];
//# sourceMappingURL=collection_listing.js.map