"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplePayCertificate = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class ApplePayCertificate extends base_1.Base {
    static async find({ session, id }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
    static async delete({ session, id }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return response ? response.body : null;
    }
    static async csr({ session, id, ...otherArgs }) {
        const response = await this.request({
            http_method: "get",
            operation: "csr",
            session: session,
            urlIds: { "id": id },
            params: { ...otherArgs },
            body: {},
            entity: null,
        });
        return response ? response.body : null;
    }
}
exports.ApplePayCertificate = ApplePayCertificate;
ApplePayCertificate.apiVersion = types_1.ApiVersion.January23;
ApplePayCertificate.hasOne = {};
ApplePayCertificate.hasMany = {};
ApplePayCertificate.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["id"], "path": "apple_pay_certificates/<id>.json" },
    { "http_method": "get", "operation": "csr", "ids": ["id"], "path": "apple_pay_certificates/<id>/csr.json" },
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "apple_pay_certificates/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": [], "path": "apple_pay_certificates.json" },
    { "http_method": "put", "operation": "put", "ids": ["id"], "path": "apple_pay_certificates/<id>.json" }
];
ApplePayCertificate.resourceNames = [
    {
        "singular": "apple_pay_certificate",
        "plural": "apple_pay_certificates"
    }
];
//# sourceMappingURL=apple_pay_certificate.js.map