"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.CarrierService = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class CarrierService extends base_1.Base {
    static async find({ session, id }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
    static async delete({ session, id }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return response ? response.body : null;
    }
    static async all({ session, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: {},
            params: { ...otherArgs },
        });
        return response;
    }
}
exports.CarrierService = CarrierService;
CarrierService.apiVersion = types_1.ApiVersion.January23;
CarrierService.hasOne = {};
CarrierService.hasMany = {};
CarrierService.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["id"], "path": "carrier_services/<id>.json" },
    { "http_method": "get", "operation": "get", "ids": [], "path": "carrier_services.json" },
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "carrier_services/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": [], "path": "carrier_services.json" },
    { "http_method": "put", "operation": "put", "ids": ["id"], "path": "carrier_services/<id>.json" }
];
CarrierService.resourceNames = [
    {
        "singular": "carrier_service",
        "plural": "carrier_services"
    }
];
//# sourceMappingURL=carrier_service.js.map