"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorefrontAccessToken = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class StorefrontAccessToken extends base_1.Base {
    static async delete({ session, id }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return response ? response.body : null;
    }
    static async all({ session, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: {},
            params: { ...otherArgs },
        });
        return response;
    }
}
exports.StorefrontAccessToken = StorefrontAccessToken;
StorefrontAccessToken.apiVersion = types_1.ApiVersion.January23;
StorefrontAccessToken.hasOne = {};
StorefrontAccessToken.hasMany = {};
StorefrontAccessToken.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["id"], "path": "storefront_access_tokens/<id>.json" },
    { "http_method": "get", "operation": "get", "ids": [], "path": "storefront_access_tokens.json" },
    { "http_method": "post", "operation": "post", "ids": [], "path": "storefront_access_tokens.json" }
];
StorefrontAccessToken.resourceNames = [
    {
        "singular": "storefront_access_token",
        "plural": "storefront_access_tokens"
    }
];
//# sourceMappingURL=storefront_access_token.js.map