"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Blog = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
const metafield_1 = require("./metafield");
class Blog extends base_1.Base {
    static async find({ session, id, fields = null }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: { "fields": fields },
        });
        return result.data ? result.data[0] : null;
    }
    static async delete({ session, id }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return response ? response.body : null;
    }
    static async all({ session, limit = null, since_id = null, handle = null, fields = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: {},
            params: { "limit": limit, "since_id": since_id, "handle": handle, "fields": fields, ...otherArgs },
        });
        return response;
    }
    static async count({ session, ...otherArgs }) {
        const response = await this.request({
            http_method: "get",
            operation: "count",
            session: session,
            urlIds: {},
            params: { ...otherArgs },
            body: {},
            entity: null,
        });
        return response ? response.body : null;
    }
}
exports.Blog = Blog;
Blog.apiVersion = types_1.ApiVersion.April23;
Blog.hasOne = {};
Blog.hasMany = {
    "metafields": metafield_1.Metafield
};
Blog.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["id"], "path": "blogs/<id>.json" },
    { "http_method": "get", "operation": "count", "ids": [], "path": "blogs/count.json" },
    { "http_method": "get", "operation": "get", "ids": [], "path": "blogs.json" },
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "blogs/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": [], "path": "blogs.json" },
    { "http_method": "put", "operation": "put", "ids": ["id"], "path": "blogs/<id>.json" }
];
Blog.resourceNames = [
    {
        "singular": "blog",
        "plural": "blogs"
    }
];
//# sourceMappingURL=blog.js.map