"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Refund = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
const transaction_1 = require("./transaction");
class Refund extends base_1.Base {
    static async find({ session, id, order_id = null, fields = null, in_shop_currency = null }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id, "order_id": order_id },
            params: { "fields": fields, "in_shop_currency": in_shop_currency },
        });
        return result.data ? result.data[0] : null;
    }
    static async all({ session, order_id = null, limit = null, fields = null, in_shop_currency = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: { "order_id": order_id },
            params: { "limit": limit, "fields": fields, "in_shop_currency": in_shop_currency, ...otherArgs },
        });
        return response;
    }
    async calculate({ shipping = null, refund_line_items = null, currency = null, body = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "post",
            operation: "calculate",
            session: this.session,
            urlIds: { "order_id": this.order_id },
            params: { "shipping": shipping, "refund_line_items": refund_line_items, "currency": currency, ...otherArgs },
            body: body,
            entity: this,
        });
        return response ? response.body : null;
    }
}
exports.Refund = Refund;
Refund.apiVersion = types_1.ApiVersion.April23;
Refund.hasOne = {};
Refund.hasMany = {
    "transactions": transaction_1.Transaction
};
Refund.paths = [
    { "http_method": "get", "operation": "get", "ids": ["order_id"], "path": "orders/<order_id>/refunds.json" },
    { "http_method": "get", "operation": "get", "ids": ["order_id", "id"], "path": "orders/<order_id>/refunds/<id>.json" },
    { "http_method": "post", "operation": "calculate", "ids": ["order_id"], "path": "orders/<order_id>/refunds/calculate.json" },
    { "http_method": "post", "operation": "post", "ids": ["order_id"], "path": "orders/<order_id>/refunds.json" }
];
Refund.resourceNames = [
    {
        "singular": "refund",
        "plural": "refunds"
    }
];
//# sourceMappingURL=refund.js.map