"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Asset = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class Asset extends base_1.Base {
    static async delete({ session, theme_id = null, asset = null }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "theme_id": theme_id },
            params: { "asset": asset },
        });
        return response ? response.body : null;
    }
    static async all({ session, theme_id = null, fields = null, asset = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: { "theme_id": theme_id },
            params: { "fields": fields, "asset": asset, ...otherArgs },
        });
        return response;
    }
}
exports.Asset = Asset;
Asset.apiVersion = types_1.ApiVersion.July23;
Asset.hasOne = {};
Asset.hasMany = {};
Asset.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["theme_id"], "path": "themes/<theme_id>/assets.json" },
    { "http_method": "get", "operation": "get", "ids": ["theme_id"], "path": "themes/<theme_id>/assets.json" },
    { "http_method": "get", "operation": "get", "ids": ["theme_id"], "path": "themes/<theme_id>/assets.json" },
    { "http_method": "put", "operation": "put", "ids": ["theme_id"], "path": "themes/<theme_id>/assets.json" }
];
Asset.primaryKey = "key";
Asset.resourceNames = [
    {
        "singular": "asset",
        "plural": "assets"
    }
];
//# sourceMappingURL=asset.js.map