"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomerAddress = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class CustomerAddress extends base_1.Base {
    static getJsonBodyName() {
        return "address";
    }
    static async find({ session, id, customer_id = null }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id, "customer_id": customer_id },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
    static async delete({ session, id, customer_id = null }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "id": id, "customer_id": customer_id },
            params: {},
        });
        return response ? response.body : null;
    }
    static async all({ session, customer_id = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: { "customer_id": customer_id },
            params: { ...otherArgs },
        });
        return response;
    }
    async default({ body = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "put",
            operation: "default",
            session: this.session,
            urlIds: { "id": this.id, "customer_id": this.customer_id },
            params: { ...otherArgs },
            body: body,
            entity: this,
        });
        return response ? response.body : null;
    }
    async set({ address_ids = null, operation = null, body = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "put",
            operation: "set",
            session: this.session,
            urlIds: { "customer_id": this.customer_id },
            params: { "address_ids": address_ids, "operation": operation, ...otherArgs },
            body: body,
            entity: this,
        });
        return response ? response.body : null;
    }
}
exports.CustomerAddress = CustomerAddress;
CustomerAddress.apiVersion = types_1.ApiVersion.July23;
CustomerAddress.hasOne = {};
CustomerAddress.hasMany = {};
CustomerAddress.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["customer_id", "id"], "path": "customers/<customer_id>/addresses/<id>.json" },
    { "http_method": "get", "operation": "get", "ids": ["customer_id"], "path": "customers/<customer_id>/addresses.json" },
    { "http_method": "get", "operation": "get", "ids": ["customer_id", "id"], "path": "customers/<customer_id>/addresses/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": ["customer_id"], "path": "customers/<customer_id>/addresses.json" },
    { "http_method": "put", "operation": "default", "ids": ["customer_id", "id"], "path": "customers/<customer_id>/addresses/<id>/default.json" },
    { "http_method": "put", "operation": "put", "ids": ["customer_id", "id"], "path": "customers/<customer_id>/addresses/<id>.json" },
    { "http_method": "put", "operation": "set", "ids": ["customer_id"], "path": "customers/<customer_id>/addresses/set.json" }
];
CustomerAddress.resourceNames = [
    {
        "singular": "customer_address",
        "plural": "customer_addresses"
    },
    {
        "singular": "address",
        "plural": "addresses"
    }
];
//# sourceMappingURL=customer_address.js.map