"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Order = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
const customer_1 = require("./customer");
const discount_code_1 = require("./discount_code");
const fulfillment_1 = require("./fulfillment");
const refund_1 = require("./refund");
class Order extends base_1.Base {
    static async find({ session, id, fields = null }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: { "fields": fields },
        });
        return result.data ? result.data[0] : null;
    }
    static async delete({ session, id }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return response ? response.body : null;
    }
    static async all({ session, ids = null, limit = null, since_id = null, created_at_min = null, created_at_max = null, updated_at_min = null, updated_at_max = null, processed_at_min = null, processed_at_max = null, attribution_app_id = null, status = null, financial_status = null, fulfillment_status = null, fields = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: {},
            params: { "ids": ids, "limit": limit, "since_id": since_id, "created_at_min": created_at_min, "created_at_max": created_at_max, "updated_at_min": updated_at_min, "updated_at_max": updated_at_max, "processed_at_min": processed_at_min, "processed_at_max": processed_at_max, "attribution_app_id": attribution_app_id, "status": status, "financial_status": financial_status, "fulfillment_status": fulfillment_status, "fields": fields, ...otherArgs },
        });
        return response;
    }
    static async count({ session, created_at_min = null, created_at_max = null, updated_at_min = null, updated_at_max = null, status = null, financial_status = null, fulfillment_status = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "get",
            operation: "count",
            session: session,
            urlIds: {},
            params: { "created_at_min": created_at_min, "created_at_max": created_at_max, "updated_at_min": updated_at_min, "updated_at_max": updated_at_max, "status": status, "financial_status": financial_status, "fulfillment_status": fulfillment_status, ...otherArgs },
            body: {},
            entity: null,
        });
        return response ? response.body : null;
    }
    async cancel({ amount = null, currency = null, restock = null, reason = null, email = null, refund = null, body = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "post",
            operation: "cancel",
            session: this.session,
            urlIds: { "id": this.id },
            params: { "amount": amount, "currency": currency, "restock": restock, "reason": reason, "email": email, "refund": refund, ...otherArgs },
            body: body,
            entity: this,
        });
        return response ? response.body : null;
    }
    async close({ body = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "post",
            operation: "close",
            session: this.session,
            urlIds: { "id": this.id },
            params: { ...otherArgs },
            body: body,
            entity: this,
        });
        return response ? response.body : null;
    }
    async open({ body = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "post",
            operation: "open",
            session: this.session,
            urlIds: { "id": this.id },
            params: { ...otherArgs },
            body: body,
            entity: this,
        });
        return response ? response.body : null;
    }
}
exports.Order = Order;
Order.apiVersion = types_1.ApiVersion.July23;
Order.hasOne = {
    "customer": customer_1.Customer
};
Order.hasMany = {
    "discount_codes": discount_code_1.DiscountCode,
    "fulfillments": fulfillment_1.Fulfillment,
    "refunds": refund_1.Refund
};
Order.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["id"], "path": "orders/<id>.json" },
    { "http_method": "get", "operation": "count", "ids": [], "path": "orders/count.json" },
    { "http_method": "get", "operation": "get", "ids": [], "path": "orders.json" },
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "orders/<id>.json" },
    { "http_method": "post", "operation": "cancel", "ids": ["id"], "path": "orders/<id>/cancel.json" },
    { "http_method": "post", "operation": "close", "ids": ["id"], "path": "orders/<id>/close.json" },
    { "http_method": "post", "operation": "open", "ids": ["id"], "path": "orders/<id>/open.json" },
    { "http_method": "post", "operation": "post", "ids": [], "path": "orders.json" },
    { "http_method": "put", "operation": "put", "ids": ["id"], "path": "orders/<id>.json" }
];
Order.resourceNames = [
    {
        "singular": "order",
        "plural": "orders"
    }
];
//# sourceMappingURL=order.js.map