"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Variant = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class Variant extends base_1.Base {
    static async find({ session, id, fields = null }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: { "fields": fields },
        });
        return result.data ? result.data[0] : null;
    }
    static async delete({ session, id, product_id = null }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "id": id, "product_id": product_id },
            params: {},
        });
        return response ? response.body : null;
    }
    static async all({ session, product_id = null, limit = null, presentment_currencies = null, since_id = null, fields = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: { "product_id": product_id },
            params: { "limit": limit, "presentment_currencies": presentment_currencies, "since_id": since_id, "fields": fields, ...otherArgs },
        });
        return response;
    }
    static async count({ session, product_id = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "get",
            operation: "count",
            session: session,
            urlIds: { "product_id": product_id },
            params: { ...otherArgs },
            body: {},
            entity: null,
        });
        return response ? response.body : null;
    }
}
exports.Variant = Variant;
Variant.apiVersion = types_1.ApiVersion.July23;
Variant.hasOne = {};
Variant.hasMany = {};
Variant.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["product_id", "id"], "path": "products/<product_id>/variants/<id>.json" },
    { "http_method": "get", "operation": "count", "ids": ["product_id"], "path": "products/<product_id>/variants/count.json" },
    { "http_method": "get", "operation": "get", "ids": ["product_id"], "path": "products/<product_id>/variants.json" },
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "variants/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": ["product_id"], "path": "products/<product_id>/variants.json" },
    { "http_method": "put", "operation": "put", "ids": ["id"], "path": "variants/<id>.json" }
];
Variant.readOnlyAttributes = [
    "inventory_quantity"
];
Variant.resourceNames = [
    {
        "singular": "variant",
        "plural": "variants"
    }
];
//# sourceMappingURL=variant.js.map