"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Location = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class Location extends base_1.Base {
    static async find({ session, id }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
    static async all({ session, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: {},
            params: { ...otherArgs },
        });
        return response;
    }
    static async count({ session, ...otherArgs }) {
        const response = await this.request({
            http_method: "get",
            operation: "count",
            session: session,
            urlIds: {},
            params: { ...otherArgs },
            body: {},
            entity: null,
        });
        return response ? response.body : null;
    }
    static async inventory_levels({ session, id, ...otherArgs }) {
        const response = await this.request({
            http_method: "get",
            operation: "inventory_levels",
            session: session,
            urlIds: { "id": id },
            params: { ...otherArgs },
            body: {},
            entity: null,
        });
        return response ? response.body : null;
    }
}
exports.Location = Location;
Location.apiVersion = types_1.ApiVersion.October23;
Location.hasOne = {};
Location.hasMany = {};
Location.paths = [
    { "http_method": "get", "operation": "count", "ids": [], "path": "locations/count.json" },
    { "http_method": "get", "operation": "get", "ids": [], "path": "locations.json" },
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "locations/<id>.json" },
    { "http_method": "get", "operation": "inventory_levels", "ids": ["id"], "path": "locations/<id>/inventory_levels.json" }
];
Location.resourceNames = [
    {
        "singular": "location",
        "plural": "locations"
    }
];
//# sourceMappingURL=location.js.map