"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.User = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class User extends base_1.Base {
    static async find({ session, id }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
    static async all({ session, limit = null, page_info = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: {},
            params: { "limit": limit, "page_info": page_info, ...otherArgs },
        });
        return response;
    }
    static async current({ session, ...otherArgs }) {
        const response = await this.request({
            http_method: "get",
            operation: "current",
            session: session,
            urlIds: {},
            params: { ...otherArgs },
            body: {},
            entity: null,
        });
        return response ? response.body : null;
    }
}
exports.User = User;
User.apiVersion = types_1.ApiVersion.October23;
User.hasOne = {};
User.hasMany = {};
User.paths = [
    { "http_method": "get", "operation": "current", "ids": [], "path": "users/current.json" },
    { "http_method": "get", "operation": "get", "ids": [], "path": "users.json" },
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "users/<id>.json" }
];
User.resourceNames = [
    {
        "singular": "user",
        "plural": "users"
    }
];
//# sourceMappingURL=user.js.map