"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Checkout = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
const discount_code_1 = require("./discount_code");
const order_1 = require("./order");
const gift_card_1 = require("./gift_card");
class Checkout extends base_1.Base {
    static async find({ session, token }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "token": token },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
    static async shipping_rates({ session, token, ...otherArgs }) {
        const response = await this.request({
            http_method: "get",
            operation: "shipping_rates",
            session: session,
            urlIds: { "token": token },
            params: { ...otherArgs },
            body: {},
            entity: null,
        });
        return response ? response.body : null;
    }
    async complete({ body = null, ...otherArgs }) {
        const response = await this.request({
            http_method: "post",
            operation: "complete",
            session: this.session,
            urlIds: { "token": this.token },
            params: { ...otherArgs },
            body: body,
            entity: this,
        });
        return response ? response.body : null;
    }
}
exports.Checkout = Checkout;
Checkout.apiVersion = types_1.ApiVersion.January24;
Checkout.hasOne = {
    "discount_code": discount_code_1.DiscountCode,
    "order": order_1.Order
};
Checkout.hasMany = {
    "gift_cards": gift_card_1.GiftCard
};
Checkout.paths = [
    { "http_method": "get", "operation": "get", "ids": ["token"], "path": "checkouts/<token>.json" },
    { "http_method": "get", "operation": "shipping_rates", "ids": ["token"], "path": "checkouts/<token>/shipping_rates.json" },
    { "http_method": "post", "operation": "complete", "ids": ["token"], "path": "checkouts/<token>/complete.json" },
    { "http_method": "post", "operation": "post", "ids": [], "path": "checkouts.json" },
    { "http_method": "put", "operation": "put", "ids": ["token"], "path": "checkouts/<token>.json" }
];
Checkout.primaryKey = "token";
Checkout.resourceNames = [
    {
        "singular": "checkout",
        "plural": "checkouts"
    }
];
//# sourceMappingURL=checkout.js.map