"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.MobilePlatformApplication = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
class MobilePlatformApplication extends base_1.Base {
    static async find({ session, id }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
    static async delete({ session, id }) {
        const response = await this.request({
            http_method: "delete",
            operation: "delete",
            session: session,
            urlIds: { "id": id },
            params: {},
        });
        return response ? response.body : null;
    }
    static async all({ session, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: {},
            params: { ...otherArgs },
        });
        return response;
    }
}
exports.MobilePlatformApplication = MobilePlatformApplication;
MobilePlatformApplication.apiVersion = types_1.ApiVersion.January24;
MobilePlatformApplication.hasOne = {};
MobilePlatformApplication.hasMany = {};
MobilePlatformApplication.paths = [
    { "http_method": "delete", "operation": "delete", "ids": ["id"], "path": "mobile_platform_applications/<id>.json" },
    { "http_method": "get", "operation": "get", "ids": [], "path": "mobile_platform_applications.json" },
    { "http_method": "get", "operation": "get", "ids": ["id"], "path": "mobile_platform_applications/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": [], "path": "mobile_platform_applications.json" },
    { "http_method": "put", "operation": "put", "ids": ["id"], "path": "mobile_platform_applications/<id>.json" }
];
MobilePlatformApplication.resourceNames = [
    {
        "singular": "mobile_platform_application",
        "plural": "mobile_platform_applications"
    }
];
//# sourceMappingURL=mobile_platform_application.js.map