"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.DisputeEvidence = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
const fulfillment_1 = require("./fulfillment");
class DisputeEvidence extends base_1.Base {
    static async find({ session, dispute_id }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "dispute_id": dispute_id },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
}
exports.DisputeEvidence = DisputeEvidence;
DisputeEvidence.apiVersion = types_1.ApiVersion.April24;
DisputeEvidence.hasOne = {};
DisputeEvidence.hasMany = {
    "fulfillments": fulfillment_1.Fulfillment
};
DisputeEvidence.paths = [
    { "http_method": "get", "operation": "get", "ids": ["dispute_id"], "path": "shopify_payments/disputes/<dispute_id>/dispute_evidences.json" },
    { "http_method": "put", "operation": "put", "ids": ["dispute_id"], "path": "shopify_payments/disputes/<dispute_id>/dispute_evidences.json" }
];
DisputeEvidence.primaryKey = "dispute_id";
DisputeEvidence.resourceNames = [
    {
        "singular": "dispute_evidence",
        "plural": "dispute_evidences"
    }
];
//# sourceMappingURL=dispute_evidence.js.map