"use strict";
/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsageCharge = void 0;
const base_1 = require("../../base");
const types_1 = require("../../../lib/types");
const currency_1 = require("./currency");
class UsageCharge extends base_1.Base {
    static async find({ session, id, recurring_application_charge_id = null, fields = null }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "id": id, "recurring_application_charge_id": recurring_application_charge_id },
            params: { "fields": fields },
        });
        return result.data ? result.data[0] : null;
    }
    static async all({ session, recurring_application_charge_id = null, fields = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: { "recurring_application_charge_id": recurring_application_charge_id },
            params: { "fields": fields, ...otherArgs },
        });
        return response;
    }
}
exports.UsageCharge = UsageCharge;
UsageCharge.apiVersion = types_1.ApiVersion.April24;
UsageCharge.hasOne = {
    "currency": currency_1.Currency
};
UsageCharge.hasMany = {};
UsageCharge.paths = [
    { "http_method": "get", "operation": "get", "ids": ["recurring_application_charge_id"], "path": "recurring_application_charges/<recurring_application_charge_id>/usage_charges.json" },
    { "http_method": "get", "operation": "get", "ids": ["recurring_application_charge_id", "id"], "path": "recurring_application_charges/<recurring_application_charge_id>/usage_charges/<id>.json" },
    { "http_method": "post", "operation": "post", "ids": ["recurring_application_charge_id"], "path": "recurring_application_charges/<recurring_application_charge_id>/usage_charges.json" }
];
UsageCharge.resourceNames = [
    {
        "singular": "usage_charge",
        "plural": "usage_charges"
    }
];
//# sourceMappingURL=usage_charge.js.map