import { calendars } from './calendars.generated';
function isSupportedCalendar(item, locale) {
    if (locale === void 0) { locale = 'en'; }
    try {
        var dateTimeFormat = new Intl.DateTimeFormat("".concat(locale, "-u-ca-").concat(item));
        var options = dateTimeFormat.resolvedOptions().calendar;
        if (item !== 'gregory' || options !== 'gregory')
            return true;
    }
    catch (_err) { }
    return false;
}
export function getSupportedCalendars(localePrefix) {
    return calendars.filter(function (calendar) {
        return isSupportedCalendar(calendar, localePrefix);
    });
}
