"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSupportedUnits = void 0;
var units_generated_1 = require("./units.generated");
function isSupported(unit, locale) {
    if (locale === void 0) { locale = 'en'; }
    try {
        var formatter = new Intl.NumberFormat(locale, { style: 'unit', unit: unit });
        return formatter.resolvedOptions().unit === unit;
    }
    catch (_err) { }
    return false;
}
function getSupportedUnits(locale) {
    return units_generated_1.units.filter(function (unit) { return isSupported(unit, locale); });
}
exports.getSupportedUnits = getSupportedUnits;
