/**
 * @mui/material v5.15.14
 *
 * @license MIT
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react'), require('react-dom')) :
  typeof define === 'function' && define.amd ? define(['exports', 'react', 'react-dom'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.MaterialUI = {}, global.React, global.ReactDOM));
})(this, (function (exports, React, ReactDOM) { 'use strict';

  'use client';

  function _interopNamespaceDefault(e) {
    var n = Object.create(null);
    if (e) {
      Object.keys(e).forEach(function (k) {
        if (k !== 'default') {
          var d = Object.getOwnPropertyDescriptor(e, k);
          Object.defineProperty(n, k, d.get ? d : {
            enumerable: true,
            get: function () { return e[k]; }
          });
        }
      });
    }
    n.default = e;
    return Object.freeze(n);
  }

  var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);
  var ReactDOM__namespace = /*#__PURE__*/_interopNamespaceDefault(ReactDOM);

  var common = {
    black: '#000',
    white: '#fff'
  };
  var common$1 = common;

  var red = {
    50: '#ffebee',
    100: '#ffcdd2',
    200: '#ef9a9a',
    300: '#e57373',
    400: '#ef5350',
    500: '#f44336',
    600: '#e53935',
    700: '#d32f2f',
    800: '#c62828',
    900: '#b71c1c',
    A100: '#ff8a80',
    A200: '#ff5252',
    A400: '#ff1744',
    A700: '#d50000'
  };
  var red$1 = red;

  var pink = {
    50: '#fce4ec',
    100: '#f8bbd0',
    200: '#f48fb1',
    300: '#f06292',
    400: '#ec407a',
    500: '#e91e63',
    600: '#d81b60',
    700: '#c2185b',
    800: '#ad1457',
    900: '#880e4f',
    A100: '#ff80ab',
    A200: '#ff4081',
    A400: '#f50057',
    A700: '#c51162'
  };
  var pink$1 = pink;

  var purple = {
    50: '#f3e5f5',
    100: '#e1bee7',
    200: '#ce93d8',
    300: '#ba68c8',
    400: '#ab47bc',
    500: '#9c27b0',
    600: '#8e24aa',
    700: '#7b1fa2',
    800: '#6a1b9a',
    900: '#4a148c',
    A100: '#ea80fc',
    A200: '#e040fb',
    A400: '#d500f9',
    A700: '#aa00ff'
  };
  var purple$1 = purple;

  var deepPurple = {
    50: '#ede7f6',
    100: '#d1c4e9',
    200: '#b39ddb',
    300: '#9575cd',
    400: '#7e57c2',
    500: '#673ab7',
    600: '#5e35b1',
    700: '#512da8',
    800: '#4527a0',
    900: '#311b92',
    A100: '#b388ff',
    A200: '#7c4dff',
    A400: '#651fff',
    A700: '#6200ea'
  };
  var deepPurple$1 = deepPurple;

  var indigo = {
    50: '#e8eaf6',
    100: '#c5cae9',
    200: '#9fa8da',
    300: '#7986cb',
    400: '#5c6bc0',
    500: '#3f51b5',
    600: '#3949ab',
    700: '#303f9f',
    800: '#283593',
    900: '#1a237e',
    A100: '#8c9eff',
    A200: '#536dfe',
    A400: '#3d5afe',
    A700: '#304ffe'
  };
  var indigo$1 = indigo;

  var blue = {
    50: '#e3f2fd',
    100: '#bbdefb',
    200: '#90caf9',
    300: '#64b5f6',
    400: '#42a5f5',
    500: '#2196f3',
    600: '#1e88e5',
    700: '#1976d2',
    800: '#1565c0',
    900: '#0d47a1',
    A100: '#82b1ff',
    A200: '#448aff',
    A400: '#2979ff',
    A700: '#2962ff'
  };
  var blue$1 = blue;

  var lightBlue = {
    50: '#e1f5fe',
    100: '#b3e5fc',
    200: '#81d4fa',
    300: '#4fc3f7',
    400: '#29b6f6',
    500: '#03a9f4',
    600: '#039be5',
    700: '#0288d1',
    800: '#0277bd',
    900: '#01579b',
    A100: '#80d8ff',
    A200: '#40c4ff',
    A400: '#00b0ff',
    A700: '#0091ea'
  };
  var lightBlue$1 = lightBlue;

  var cyan = {
    50: '#e0f7fa',
    100: '#b2ebf2',
    200: '#80deea',
    300: '#4dd0e1',
    400: '#26c6da',
    500: '#00bcd4',
    600: '#00acc1',
    700: '#0097a7',
    800: '#00838f',
    900: '#006064',
    A100: '#84ffff',
    A200: '#18ffff',
    A400: '#00e5ff',
    A700: '#00b8d4'
  };
  var cyan$1 = cyan;

  var teal = {
    50: '#e0f2f1',
    100: '#b2dfdb',
    200: '#80cbc4',
    300: '#4db6ac',
    400: '#26a69a',
    500: '#009688',
    600: '#00897b',
    700: '#00796b',
    800: '#00695c',
    900: '#004d40',
    A100: '#a7ffeb',
    A200: '#64ffda',
    A400: '#1de9b6',
    A700: '#00bfa5'
  };
  var teal$1 = teal;

  var green = {
    50: '#e8f5e9',
    100: '#c8e6c9',
    200: '#a5d6a7',
    300: '#81c784',
    400: '#66bb6a',
    500: '#4caf50',
    600: '#43a047',
    700: '#388e3c',
    800: '#2e7d32',
    900: '#1b5e20',
    A100: '#b9f6ca',
    A200: '#69f0ae',
    A400: '#00e676',
    A700: '#00c853'
  };
  var green$1 = green;

  var lightGreen = {
    50: '#f1f8e9',
    100: '#dcedc8',
    200: '#c5e1a5',
    300: '#aed581',
    400: '#9ccc65',
    500: '#8bc34a',
    600: '#7cb342',
    700: '#689f38',
    800: '#558b2f',
    900: '#33691e',
    A100: '#ccff90',
    A200: '#b2ff59',
    A400: '#76ff03',
    A700: '#64dd17'
  };
  var lightGreen$1 = lightGreen;

  var lime = {
    50: '#f9fbe7',
    100: '#f0f4c3',
    200: '#e6ee9c',
    300: '#dce775',
    400: '#d4e157',
    500: '#cddc39',
    600: '#c0ca33',
    700: '#afb42b',
    800: '#9e9d24',
    900: '#827717',
    A100: '#f4ff81',
    A200: '#eeff41',
    A400: '#c6ff00',
    A700: '#aeea00'
  };
  var lime$1 = lime;

  var yellow = {
    50: '#fffde7',
    100: '#fff9c4',
    200: '#fff59d',
    300: '#fff176',
    400: '#ffee58',
    500: '#ffeb3b',
    600: '#fdd835',
    700: '#fbc02d',
    800: '#f9a825',
    900: '#f57f17',
    A100: '#ffff8d',
    A200: '#ffff00',
    A400: '#ffea00',
    A700: '#ffd600'
  };
  var yellow$1 = yellow;

  var amber = {
    50: '#fff8e1',
    100: '#ffecb3',
    200: '#ffe082',
    300: '#ffd54f',
    400: '#ffca28',
    500: '#ffc107',
    600: '#ffb300',
    700: '#ffa000',
    800: '#ff8f00',
    900: '#ff6f00',
    A100: '#ffe57f',
    A200: '#ffd740',
    A400: '#ffc400',
    A700: '#ffab00'
  };
  var amber$1 = amber;

  var orange = {
    50: '#fff3e0',
    100: '#ffe0b2',
    200: '#ffcc80',
    300: '#ffb74d',
    400: '#ffa726',
    500: '#ff9800',
    600: '#fb8c00',
    700: '#f57c00',
    800: '#ef6c00',
    900: '#e65100',
    A100: '#ffd180',
    A200: '#ffab40',
    A400: '#ff9100',
    A700: '#ff6d00'
  };
  var orange$1 = orange;

  var deepOrange = {
    50: '#fbe9e7',
    100: '#ffccbc',
    200: '#ffab91',
    300: '#ff8a65',
    400: '#ff7043',
    500: '#ff5722',
    600: '#f4511e',
    700: '#e64a19',
    800: '#d84315',
    900: '#bf360c',
    A100: '#ff9e80',
    A200: '#ff6e40',
    A400: '#ff3d00',
    A700: '#dd2c00'
  };
  var deepOrange$1 = deepOrange;

  var brown = {
    50: '#efebe9',
    100: '#d7ccc8',
    200: '#bcaaa4',
    300: '#a1887f',
    400: '#8d6e63',
    500: '#795548',
    600: '#6d4c41',
    700: '#5d4037',
    800: '#4e342e',
    900: '#3e2723',
    A100: '#d7ccc8',
    A200: '#bcaaa4',
    A400: '#8d6e63',
    A700: '#5d4037'
  };
  var brown$1 = brown;

  var grey = {
    50: '#fafafa',
    100: '#f5f5f5',
    200: '#eeeeee',
    300: '#e0e0e0',
    400: '#bdbdbd',
    500: '#9e9e9e',
    600: '#757575',
    700: '#616161',
    800: '#424242',
    900: '#212121',
    A100: '#f5f5f5',
    A200: '#eeeeee',
    A400: '#bdbdbd',
    A700: '#616161'
  };
  var grey$1 = grey;

  var blueGrey = {
    50: '#eceff1',
    100: '#cfd8dc',
    200: '#b0bec5',
    300: '#90a4ae',
    400: '#78909c',
    500: '#607d8b',
    600: '#546e7a',
    700: '#455a64',
    800: '#37474f',
    900: '#263238',
    A100: '#cfd8dc',
    A200: '#b0bec5',
    A400: '#78909c',
    A700: '#455a64'
  };
  var blueGrey$1 = blueGrey;

  var index = /*#__PURE__*/Object.freeze({
    __proto__: null,
    amber: amber$1,
    blue: blue$1,
    blueGrey: blueGrey$1,
    brown: brown$1,
    common: common$1,
    cyan: cyan$1,
    deepOrange: deepOrange$1,
    deepPurple: deepPurple$1,
    green: green$1,
    grey: grey$1,
    indigo: indigo$1,
    lightBlue: lightBlue$1,
    lightGreen: lightGreen$1,
    lime: lime$1,
    orange: orange$1,
    pink: pink$1,
    purple: purple$1,
    red: red$1,
    teal: teal$1,
    yellow: yellow$1
  });

  var global$1 = (typeof global !== "undefined" ? global :
              typeof self !== "undefined" ? self :
              typeof window !== "undefined" ? window : {});

  if (typeof global$1.setTimeout === 'function') ;
  if (typeof global$1.clearTimeout === 'function') ;

  // from https://github.com/kumavis/browser-process-hrtime/blob/master/index.js
  var performance$1 = global$1.performance || {};
  performance$1.now        ||
    performance$1.mozNow     ||
    performance$1.msNow      ||
    performance$1.oNow       ||
    performance$1.webkitNow  ||
    function(){ return (new Date()).getTime() };

  var THEME_ID = '$$material';

  function _typeof(o) {
    "@babel/helpers - typeof";

    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) {
      return typeof o;
    } : function (o) {
      return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
    }, _typeof(o);
  }

  function toPrimitive(t, r) {
    if ("object" != _typeof(t) || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != _typeof(i)) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }

  function toPropertyKey(t) {
    var i = toPrimitive(t, "string");
    return "symbol" == _typeof(i) ? i : String(i);
  }

  function _defineProperty(obj, key, value) {
    key = toPropertyKey(key);
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }

  function _extends() {
    _extends = Object.assign ? Object.assign.bind() : function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];
        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }
      return target;
    };
    return _extends.apply(this, arguments);
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;
    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }
    return target;
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};
    var target = _objectWithoutPropertiesLoose(source, excluded);
    var key, i;
    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }
    return target;
  }

  function memoize$1(fn) {
    var cache = Object.create(null);
    return function (arg) {
      if (cache[arg] === undefined) cache[arg] = fn(arg);
      return cache[arg];
    };
  }

  var reactPropsRegex = /^((children|dangerouslySetInnerHTML|key|ref|autoFocus|defaultValue|defaultChecked|innerHTML|suppressContentEditableWarning|suppressHydrationWarning|valueLink|abbr|accept|acceptCharset|accessKey|action|allow|allowUserMedia|allowPaymentRequest|allowFullScreen|allowTransparency|alt|async|autoComplete|autoPlay|capture|cellPadding|cellSpacing|challenge|charSet|checked|cite|classID|className|cols|colSpan|content|contentEditable|contextMenu|controls|controlsList|coords|crossOrigin|data|dateTime|decoding|default|defer|dir|disabled|disablePictureInPicture|download|draggable|encType|enterKeyHint|form|formAction|formEncType|formMethod|formNoValidate|formTarget|frameBorder|headers|height|hidden|high|href|hrefLang|htmlFor|httpEquiv|id|inputMode|integrity|is|keyParams|keyType|kind|label|lang|list|loading|loop|low|marginHeight|marginWidth|max|maxLength|media|mediaGroup|method|min|minLength|multiple|muted|name|nonce|noValidate|open|optimum|pattern|placeholder|playsInline|poster|preload|profile|radioGroup|readOnly|referrerPolicy|rel|required|reversed|role|rows|rowSpan|sandbox|scope|scoped|scrolling|seamless|selected|shape|size|sizes|slot|span|spellCheck|src|srcDoc|srcLang|srcSet|start|step|style|summary|tabIndex|target|title|translate|type|useMap|value|width|wmode|wrap|about|datatype|inlist|prefix|property|resource|typeof|vocab|autoCapitalize|autoCorrect|autoSave|color|incremental|fallback|inert|itemProp|itemScope|itemType|itemID|itemRef|on|option|results|security|unselectable|accentHeight|accumulate|additive|alignmentBaseline|allowReorder|alphabetic|amplitude|arabicForm|ascent|attributeName|attributeType|autoReverse|azimuth|baseFrequency|baselineShift|baseProfile|bbox|begin|bias|by|calcMode|capHeight|clip|clipPathUnits|clipPath|clipRule|colorInterpolation|colorInterpolationFilters|colorProfile|colorRendering|contentScriptType|contentStyleType|cursor|cx|cy|d|decelerate|descent|diffuseConstant|direction|display|divisor|dominantBaseline|dur|dx|dy|edgeMode|elevation|enableBackground|end|exponent|externalResourcesRequired|fill|fillOpacity|fillRule|filter|filterRes|filterUnits|floodColor|floodOpacity|focusable|fontFamily|fontSize|fontSizeAdjust|fontStretch|fontStyle|fontVariant|fontWeight|format|from|fr|fx|fy|g1|g2|glyphName|glyphOrientationHorizontal|glyphOrientationVertical|glyphRef|gradientTransform|gradientUnits|hanging|horizAdvX|horizOriginX|ideographic|imageRendering|in|in2|intercept|k|k1|k2|k3|k4|kernelMatrix|kernelUnitLength|kerning|keyPoints|keySplines|keyTimes|lengthAdjust|letterSpacing|lightingColor|limitingConeAngle|local|markerEnd|markerMid|markerStart|markerHeight|markerUnits|markerWidth|mask|maskContentUnits|maskUnits|mathematical|mode|numOctaves|offset|opacity|operator|order|orient|orientation|origin|overflow|overlinePosition|overlineThickness|panose1|paintOrder|pathLength|patternContentUnits|patternTransform|patternUnits|pointerEvents|points|pointsAtX|pointsAtY|pointsAtZ|preserveAlpha|preserveAspectRatio|primitiveUnits|r|radius|refX|refY|renderingIntent|repeatCount|repeatDur|requiredExtensions|requiredFeatures|restart|result|rotate|rx|ry|scale|seed|shapeRendering|slope|spacing|specularConstant|specularExponent|speed|spreadMethod|startOffset|stdDeviation|stemh|stemv|stitchTiles|stopColor|stopOpacity|strikethroughPosition|strikethroughThickness|string|stroke|strokeDasharray|strokeDashoffset|strokeLinecap|strokeLinejoin|strokeMiterlimit|strokeOpacity|strokeWidth|surfaceScale|systemLanguage|tableValues|targetX|targetY|textAnchor|textDecoration|textRendering|textLength|to|transform|u1|u2|underlinePosition|underlineThickness|unicode|unicodeBidi|unicodeRange|unitsPerEm|vAlphabetic|vHanging|vIdeographic|vMathematical|values|vectorEffect|version|vertAdvY|vertOriginX|vertOriginY|viewBox|viewTarget|visibility|widths|wordSpacing|writingMode|x|xHeight|x1|x2|xChannelSelector|xlinkActuate|xlinkArcrole|xlinkHref|xlinkRole|xlinkShow|xlinkTitle|xlinkType|xmlBase|xmlns|xmlnsXlink|xmlLang|xmlSpace|y|y1|y2|yChannelSelector|z|zoomAndPan|for|class|autofocus)|(([Dd][Aa][Tt][Aa]|[Aa][Rr][Ii][Aa]|x)-.*))$/; // https://esbench.com/bench/5bfee68a4cd7e6009ef61d23

  var isPropValid = /* #__PURE__ */memoize$1(function (prop) {
    return reactPropsRegex.test(prop) || prop.charCodeAt(0) === 111
    /* o */
    && prop.charCodeAt(1) === 110
    /* n */
    && prop.charCodeAt(2) < 91;
  }
  /* Z+1 */
  );

  /*

  Based off glamor's StyleSheet, thanks Sunil ❤️

  high performance StyleSheet for css-in-js systems

  - uses multiple style tags behind the scenes for millions of rules
  - uses `insertRule` for appending in production for *much* faster performance

  // usage

  import { StyleSheet } from '@emotion/sheet'

  let styleSheet = new StyleSheet({ key: '', container: document.head })

  styleSheet.insert('#box { border: 1px solid red; }')
  - appends a css rule into the stylesheet

  styleSheet.flush()
  - empties the stylesheet of all its contents

  */
  // $FlowFixMe
  function sheetForTag(tag) {
    if (tag.sheet) {
      // $FlowFixMe
      return tag.sheet;
    } // this weirdness brought to you by firefox

    /* istanbul ignore next */


    for (var i = 0; i < document.styleSheets.length; i++) {
      if (document.styleSheets[i].ownerNode === tag) {
        // $FlowFixMe
        return document.styleSheets[i];
      }
    }
  }

  function createStyleElement(options) {
    var tag = document.createElement('style');
    tag.setAttribute('data-emotion', options.key);

    if (options.nonce !== undefined) {
      tag.setAttribute('nonce', options.nonce);
    }

    tag.appendChild(document.createTextNode(''));
    tag.setAttribute('data-s', '');
    return tag;
  }

  var StyleSheet = /*#__PURE__*/function () {
    // Using Node instead of HTMLElement since container may be a ShadowRoot
    function StyleSheet(options) {
      var _this = this;

      this._insertTag = function (tag) {
        var before;

        if (_this.tags.length === 0) {
          if (_this.insertionPoint) {
            before = _this.insertionPoint.nextSibling;
          } else if (_this.prepend) {
            before = _this.container.firstChild;
          } else {
            before = _this.before;
          }
        } else {
          before = _this.tags[_this.tags.length - 1].nextSibling;
        }

        _this.container.insertBefore(tag, before);

        _this.tags.push(tag);
      };

      this.isSpeedy = options.speedy === undefined ? "development" === 'production' : options.speedy;
      this.tags = [];
      this.ctr = 0;
      this.nonce = options.nonce; // key is the value of the data-emotion attribute, it's used to identify different sheets

      this.key = options.key;
      this.container = options.container;
      this.prepend = options.prepend;
      this.insertionPoint = options.insertionPoint;
      this.before = null;
    }

    var _proto = StyleSheet.prototype;

    _proto.hydrate = function hydrate(nodes) {
      nodes.forEach(this._insertTag);
    };

    _proto.insert = function insert(rule) {
      // the max length is how many rules we have per style tag, it's 65000 in speedy mode
      // it's 1 in dev because we insert source maps that map a single rule to a location
      // and you can only have one source map per style tag
      if (this.ctr % (this.isSpeedy ? 65000 : 1) === 0) {
        this._insertTag(createStyleElement(this));
      }

      var tag = this.tags[this.tags.length - 1];

      {
        var isImportRule = rule.charCodeAt(0) === 64 && rule.charCodeAt(1) === 105;

        if (isImportRule && this._alreadyInsertedOrderInsensitiveRule) {
          // this would only cause problem in speedy mode
          // but we don't want enabling speedy to affect the observable behavior
          // so we report this error at all times
          console.error("You're attempting to insert the following rule:\n" + rule + '\n\n`@import` rules must be before all other types of rules in a stylesheet but other rules have already been inserted. Please ensure that `@import` rules are before all other rules.');
        }
        this._alreadyInsertedOrderInsensitiveRule = this._alreadyInsertedOrderInsensitiveRule || !isImportRule;
      }

      if (this.isSpeedy) {
        var sheet = sheetForTag(tag);

        try {
          // this is the ultrafast version, works across browsers
          // the big drawback is that the css won't be editable in devtools
          sheet.insertRule(rule, sheet.cssRules.length);
        } catch (e) {
          if (!/:(-moz-placeholder|-moz-focus-inner|-moz-focusring|-ms-input-placeholder|-moz-read-write|-moz-read-only|-ms-clear|-ms-expand|-ms-reveal){/.test(rule)) {
            console.error("There was a problem inserting the following rule: \"" + rule + "\"", e);
          }
        }
      } else {
        tag.appendChild(document.createTextNode(rule));
      }

      this.ctr++;
    };

    _proto.flush = function flush() {
      // $FlowFixMe
      this.tags.forEach(function (tag) {
        return tag.parentNode && tag.parentNode.removeChild(tag);
      });
      this.tags = [];
      this.ctr = 0;

      {
        this._alreadyInsertedOrderInsensitiveRule = false;
      }
    };

    return StyleSheet;
  }();

  var e="-ms-";var r$1="-moz-";var a="-webkit-";var n="comm";var c="rule";var s="decl";var i="@import";var h="@keyframes";var $="@layer";var g=Math.abs;var k=String.fromCharCode;var m=Object.assign;function x(e,r){return O(e,0)^45?(((r<<2^O(e,0))<<2^O(e,1))<<2^O(e,2))<<2^O(e,3):0}function y(e){return e.trim()}function j(e,r){return (e=r.exec(e))?e[0]:e}function z(e,r,a){return e.replace(r,a)}function C(e,r){return e.indexOf(r)}function O(e,r){return e.charCodeAt(r)|0}function A(e,r,a){return e.slice(r,a)}function M(e){return e.length}function S(e){return e.length}function q(e,r){return r.push(e),e}function B(e,r){return e.map(r).join("")}var D=1;var E=1;var F=0;var G=0;var H=0;var I="";function J(e,r,a,n,c,s,t){return {value:e,root:r,parent:a,type:n,props:c,children:s,line:D,column:E,length:t,return:""}}function K(e,r){return m(J("",null,null,"",null,null,0),e,{length:-e.length},r)}function L(){return H}function N(){H=G>0?O(I,--G):0;if(E--,H===10)E=1,D--;return H}function P(){H=G<F?O(I,G++):0;if(E++,H===10)E=1,D++;return H}function Q(){return O(I,G)}function R(){return G}function T(e,r){return A(I,e,r)}function U(e){switch(e){case 0:case 9:case 10:case 13:case 32:return 5;case 33:case 43:case 44:case 47:case 62:case 64:case 126:case 59:case 123:case 125:return 4;case 58:return 3;case 34:case 39:case 40:case 91:return 2;case 41:case 93:return 1}return 0}function V(e){return D=E=1,F=M(I=e),G=0,[]}function W(e){return I="",e}function X(e){return y(T(G-1,re(e===91?e+2:e===40?e+1:e)))}function Z(e){while(H=Q())if(H<33)P();else break;return U(e)>2||U(H)>3?"":" "}function ee(e,r){while(--r&&P())if(H<48||H>102||H>57&&H<65||H>70&&H<97)break;return T(e,R()+(r<6&&Q()==32&&P()==32))}function re(e){while(P())switch(H){case e:return G;case 34:case 39:if(e!==34&&e!==39)re(H);break;case 40:if(e===41)re(e);break;case 92:P();break}return G}function ae(e,r){while(P())if(e+H===47+10)break;else if(e+H===42+42&&Q()===47)break;return "/*"+T(r,G-1)+"*"+k(e===47?e:P())}function ne(e){while(!U(Q()))P();return T(e,G)}function ce(e){return W(se("",null,null,null,[""],e=V(e),0,[0],e))}function se(e,r,a,n,c,s,t,u,i){var f=0;var o=0;var l=t;var v=0;var p=0;var h=0;var b=1;var w=1;var d=1;var $=0;var g="";var m=c;var x=s;var y=n;var j=g;while(w)switch(h=$,$=P()){case 40:if(h!=108&&O(j,l-1)==58){if(C(j+=z(X($),"&","&\f"),"&\f")!=-1)d=-1;break}case 34:case 39:case 91:j+=X($);break;case 9:case 10:case 13:case 32:j+=Z(h);break;case 92:j+=ee(R()-1,7);continue;case 47:switch(Q()){case 42:case 47:q(ue(ae(P(),R()),r,a),i);break;default:j+="/";}break;case 123*b:u[f++]=M(j)*d;case 125*b:case 59:case 0:switch($){case 0:case 125:w=0;case 59+o:if(d==-1)j=z(j,/\f/g,"");if(p>0&&M(j)-l)q(p>32?ie(j+";",n,a,l-1):ie(z(j," ","")+";",n,a,l-2),i);break;case 59:j+=";";default:q(y=te(j,r,a,f,o,c,u,g,m=[],x=[],l),s);if($===123)if(o===0)se(j,r,y,y,m,s,l,u,x);else switch(v===99&&O(j,3)===110?100:v){case 100:case 108:case 109:case 115:se(e,y,y,n&&q(te(e,y,y,0,0,c,u,g,c,m=[],l),x),c,x,l,u,n?m:x);break;default:se(j,y,y,y,[""],x,0,u,x);}}f=o=p=0,b=d=1,g=j="",l=t;break;case 58:l=1+M(j),p=h;default:if(b<1)if($==123)--b;else if($==125&&b++==0&&N()==125)continue;switch(j+=k($),$*b){case 38:d=o>0?1:(j+="\f",-1);break;case 44:u[f++]=(M(j)-1)*d,d=1;break;case 64:if(Q()===45)j+=X(P());v=Q(),o=l=M(g=j+=ne(R())),$++;break;case 45:if(h===45&&M(j)==2)b=0;}}return s}function te(e,r,a,n,s,t,u,i,f,o,l){var v=s-1;var p=s===0?t:[""];var h=S(p);for(var b=0,w=0,d=0;b<n;++b)for(var $=0,k=A(e,v+1,v=g(w=u[b])),m=e;$<h;++$)if(m=y(w>0?p[$]+" "+k:z(k,/&\f/g,p[$])))f[d++]=m;return J(e,r,a,s===0?c:i,f,o,l)}function ue(e,r,a){return J(e,r,a,n,k(L()),A(e,2,-2),0)}function ie(e,r,a,n){return J(e,r,a,s,A(e,0,n),A(e,n+1,-1),n)}function oe(e,r){var a="";var n=S(e);for(var c=0;c<n;c++)a+=r(e[c],c,e,r)||"";return a}function le(e,r,a,t){switch(e.type){case $:if(e.children.length)break;case i:case s:return e.return=e.return||e.value;case n:return "";case h:return e.return=e.value+"{"+oe(e.children,t)+"}";case c:e.value=e.props.join(",");}return M(a=oe(e.children,t))?e.return=e.value+"{"+a+"}":""}function ve(e){var r=S(e);return function(a,n,c,s){var t="";for(var u=0;u<r;u++)t+=e[u](a,n,c,s)||"";return t}}

  var weakMemoize = function weakMemoize(func) {
    // $FlowFixMe flow doesn't include all non-primitive types as allowed for weakmaps
    var cache = new WeakMap();
    return function (arg) {
      if (cache.has(arg)) {
        // $FlowFixMe
        return cache.get(arg);
      }

      var ret = func(arg);
      cache.set(arg, ret);
      return ret;
    };
  };

  var identifierWithPointTracking = function identifierWithPointTracking(begin, points, index) {
    var previous = 0;
    var character = 0;

    while (true) {
      previous = character;
      character = Q(); // &\f

      if (previous === 38 && character === 12) {
        points[index] = 1;
      }

      if (U(character)) {
        break;
      }

      P();
    }

    return T(begin, G);
  };

  var toRules = function toRules(parsed, points) {
    // pretend we've started with a comma
    var index = -1;
    var character = 44;

    do {
      switch (U(character)) {
        case 0:
          // &\f
          if (character === 38 && Q() === 12) {
            // this is not 100% correct, we don't account for literal sequences here - like for example quoted strings
            // stylis inserts \f after & to know when & where it should replace this sequence with the context selector
            // and when it should just concatenate the outer and inner selectors
            // it's very unlikely for this sequence to actually appear in a different context, so we just leverage this fact here
            points[index] = 1;
          }

          parsed[index] += identifierWithPointTracking(G - 1, points, index);
          break;

        case 2:
          parsed[index] += X(character);
          break;

        case 4:
          // comma
          if (character === 44) {
            // colon
            parsed[++index] = Q() === 58 ? '&\f' : '';
            points[index] = parsed[index].length;
            break;
          }

        // fallthrough

        default:
          parsed[index] += k(character);
      }
    } while (character = P());

    return parsed;
  };

  var getRules = function getRules(value, points) {
    return W(toRules(V(value), points));
  }; // WeakSet would be more appropriate, but only WeakMap is supported in IE11


  var fixedElements = /* #__PURE__ */new WeakMap();
  var compat = function compat(element) {
    if (element.type !== 'rule' || !element.parent || // positive .length indicates that this rule contains pseudo
    // negative .length indicates that this rule has been already prefixed
    element.length < 1) {
      return;
    }

    var value = element.value,
        parent = element.parent;
    var isImplicitRule = element.column === parent.column && element.line === parent.line;

    while (parent.type !== 'rule') {
      parent = parent.parent;
      if (!parent) return;
    } // short-circuit for the simplest case


    if (element.props.length === 1 && value.charCodeAt(0) !== 58
    /* colon */
    && !fixedElements.get(parent)) {
      return;
    } // if this is an implicitly inserted rule (the one eagerly inserted at the each new nested level)
    // then the props has already been manipulated beforehand as they that array is shared between it and its "rule parent"


    if (isImplicitRule) {
      return;
    }

    fixedElements.set(element, true);
    var points = [];
    var rules = getRules(value, points);
    var parentRules = parent.props;

    for (var i = 0, k = 0; i < rules.length; i++) {
      for (var j = 0; j < parentRules.length; j++, k++) {
        element.props[k] = points[i] ? rules[i].replace(/&\f/g, parentRules[j]) : parentRules[j] + " " + rules[i];
      }
    }
  };
  var removeLabel = function removeLabel(element) {
    if (element.type === 'decl') {
      var value = element.value;

      if ( // charcode for l
      value.charCodeAt(0) === 108 && // charcode for b
      value.charCodeAt(2) === 98) {
        // this ignores label
        element["return"] = '';
        element.value = '';
      }
    }
  };
  var ignoreFlag = 'emotion-disable-server-rendering-unsafe-selector-warning-please-do-not-use-this-the-warning-exists-for-a-reason';

  var isIgnoringComment = function isIgnoringComment(element) {
    return element.type === 'comm' && element.children.indexOf(ignoreFlag) > -1;
  };

  var createUnsafeSelectorsAlarm = function createUnsafeSelectorsAlarm(cache) {
    return function (element, index, children) {
      if (element.type !== 'rule' || cache.compat) return;
      var unsafePseudoClasses = element.value.match(/(:first|:nth|:nth-last)-child/g);

      if (unsafePseudoClasses) {
        var isNested = !!element.parent; // in nested rules comments become children of the "auto-inserted" rule and that's always the `element.parent`
        //
        // considering this input:
        // .a {
        //   .b /* comm */ {}
        //   color: hotpink;
        // }
        // we get output corresponding to this:
        // .a {
        //   & {
        //     /* comm */
        //     color: hotpink;
        //   }
        //   .b {}
        // }

        var commentContainer = isNested ? element.parent.children : // global rule at the root level
        children;

        for (var i = commentContainer.length - 1; i >= 0; i--) {
          var node = commentContainer[i];

          if (node.line < element.line) {
            break;
          } // it is quite weird but comments are *usually* put at `column: element.column - 1`
          // so we seek *from the end* for the node that is earlier than the rule's `element` and check that
          // this will also match inputs like this:
          // .a {
          //   /* comm */
          //   .b {}
          // }
          //
          // but that is fine
          //
          // it would be the easiest to change the placement of the comment to be the first child of the rule:
          // .a {
          //   .b { /* comm */ }
          // }
          // with such inputs we wouldn't have to search for the comment at all
          // TODO: consider changing this comment placement in the next major version


          if (node.column < element.column) {
            if (isIgnoringComment(node)) {
              return;
            }

            break;
          }
        }

        unsafePseudoClasses.forEach(function (unsafePseudoClass) {
          console.error("The pseudo class \"" + unsafePseudoClass + "\" is potentially unsafe when doing server-side rendering. Try changing it to \"" + unsafePseudoClass.split('-child')[0] + "-of-type\".");
        });
      }
    };
  };

  var isImportRule = function isImportRule(element) {
    return element.type.charCodeAt(1) === 105 && element.type.charCodeAt(0) === 64;
  };

  var isPrependedWithRegularRules = function isPrependedWithRegularRules(index, children) {
    for (var i = index - 1; i >= 0; i--) {
      if (!isImportRule(children[i])) {
        return true;
      }
    }

    return false;
  }; // use this to remove incorrect elements from further processing
  // so they don't get handed to the `sheet` (or anything else)
  // as that could potentially lead to additional logs which in turn could be overhelming to the user


  var nullifyElement = function nullifyElement(element) {
    element.type = '';
    element.value = '';
    element["return"] = '';
    element.children = '';
    element.props = '';
  };

  var incorrectImportAlarm = function incorrectImportAlarm(element, index, children) {
    if (!isImportRule(element)) {
      return;
    }

    if (element.parent) {
      console.error("`@import` rules can't be nested inside other rules. Please move it to the top level and put it before regular rules. Keep in mind that they can only be used within global styles.");
      nullifyElement(element);
    } else if (isPrependedWithRegularRules(index, children)) {
      console.error("`@import` rules can't be after other rules. Please put your `@import` rules before your other rules.");
      nullifyElement(element);
    }
  };

  /* eslint-disable no-fallthrough */

  function prefix(value, length) {
    switch (x(value, length)) {
      // color-adjust
      case 5103:
        return a + 'print-' + value + value;
      // animation, animation-(delay|direction|duration|fill-mode|iteration-count|name|play-state|timing-function)

      case 5737:
      case 4201:
      case 3177:
      case 3433:
      case 1641:
      case 4457:
      case 2921: // text-decoration, filter, clip-path, backface-visibility, column, box-decoration-break

      case 5572:
      case 6356:
      case 5844:
      case 3191:
      case 6645:
      case 3005: // mask, mask-image, mask-(mode|clip|size), mask-(repeat|origin), mask-position, mask-composite,

      case 6391:
      case 5879:
      case 5623:
      case 6135:
      case 4599:
      case 4855: // background-clip, columns, column-(count|fill|gap|rule|rule-color|rule-style|rule-width|span|width)

      case 4215:
      case 6389:
      case 5109:
      case 5365:
      case 5621:
      case 3829:
        return a + value + value;
      // appearance, user-select, transform, hyphens, text-size-adjust

      case 5349:
      case 4246:
      case 4810:
      case 6968:
      case 2756:
        return a + value + r$1 + value + e + value + value;
      // flex, flex-direction

      case 6828:
      case 4268:
        return a + value + e + value + value;
      // order

      case 6165:
        return a + value + e + 'flex-' + value + value;
      // align-items

      case 5187:
        return a + value + z(value, /(\w+).+(:[^]+)/, a + 'box-$1$2' + e + 'flex-$1$2') + value;
      // align-self

      case 5443:
        return a + value + e + 'flex-item-' + z(value, /flex-|-self/, '') + value;
      // align-content

      case 4675:
        return a + value + e + 'flex-line-pack' + z(value, /align-content|flex-|-self/, '') + value;
      // flex-shrink

      case 5548:
        return a + value + e + z(value, 'shrink', 'negative') + value;
      // flex-basis

      case 5292:
        return a + value + e + z(value, 'basis', 'preferred-size') + value;
      // flex-grow

      case 6060:
        return a + 'box-' + z(value, '-grow', '') + a + value + e + z(value, 'grow', 'positive') + value;
      // transition

      case 4554:
        return a + z(value, /([^-])(transform)/g, '$1' + a + '$2') + value;
      // cursor

      case 6187:
        return z(z(z(value, /(zoom-|grab)/, a + '$1'), /(image-set)/, a + '$1'), value, '') + value;
      // background, background-image

      case 5495:
      case 3959:
        return z(value, /(image-set\([^]*)/, a + '$1' + '$`$1');
      // justify-content

      case 4968:
        return z(z(value, /(.+:)(flex-)?(.*)/, a + 'box-pack:$3' + e + 'flex-pack:$3'), /s.+-b[^;]+/, 'justify') + a + value + value;
      // (margin|padding)-inline-(start|end)

      case 4095:
      case 3583:
      case 4068:
      case 2532:
        return z(value, /(.+)-inline(.+)/, a + '$1$2') + value;
      // (min|max)?(width|height|inline-size|block-size)

      case 8116:
      case 7059:
      case 5753:
      case 5535:
      case 5445:
      case 5701:
      case 4933:
      case 4677:
      case 5533:
      case 5789:
      case 5021:
      case 4765:
        // stretch, max-content, min-content, fill-available
        if (M(value) - 1 - length > 6) switch (O(value, length + 1)) {
          // (m)ax-content, (m)in-content
          case 109:
            // -
            if (O(value, length + 4) !== 45) break;
          // (f)ill-available, (f)it-content

          case 102:
            return z(value, /(.+:)(.+)-([^]+)/, '$1' + a + '$2-$3' + '$1' + r$1 + (O(value, length + 3) == 108 ? '$3' : '$2-$3')) + value;
          // (s)tretch

          case 115:
            return ~C(value, 'stretch') ? prefix(z(value, 'stretch', 'fill-available'), length) + value : value;
        }
        break;
      // position: sticky

      case 4949:
        // (s)ticky?
        if (O(value, length + 1) !== 115) break;
      // display: (flex|inline-flex)

      case 6444:
        switch (O(value, M(value) - 3 - (~C(value, '!important') && 10))) {
          // stic(k)y
          case 107:
            return z(value, ':', ':' + a) + value;
          // (inline-)?fl(e)x

          case 101:
            return z(value, /(.+:)([^;!]+)(;|!.+)?/, '$1' + a + (O(value, 14) === 45 ? 'inline-' : '') + 'box$3' + '$1' + a + '$2$3' + '$1' + e + '$2box$3') + value;
        }

        break;
      // writing-mode

      case 5936:
        switch (O(value, length + 11)) {
          // vertical-l(r)
          case 114:
            return a + value + e + z(value, /[svh]\w+-[tblr]{2}/, 'tb') + value;
          // vertical-r(l)

          case 108:
            return a + value + e + z(value, /[svh]\w+-[tblr]{2}/, 'tb-rl') + value;
          // horizontal(-)tb

          case 45:
            return a + value + e + z(value, /[svh]\w+-[tblr]{2}/, 'lr') + value;
        }

        return a + value + e + value + value;
    }

    return value;
  }

  var prefixer = function prefixer(element, index, children, callback) {
    if (element.length > -1) if (!element["return"]) switch (element.type) {
      case s:
        element["return"] = prefix(element.value, element.length);
        break;

      case h:
        return oe([K(element, {
          value: z(element.value, '@', '@' + a)
        })], callback);

      case c:
        if (element.length) return B(element.props, function (value) {
          switch (j(value, /(::plac\w+|:read-\w+)/)) {
            // :read-(only|write)
            case ':read-only':
            case ':read-write':
              return oe([K(element, {
                props: [z(value, /:(read-\w+)/, ':' + r$1 + '$1')]
              })], callback);
            // :placeholder

            case '::placeholder':
              return oe([K(element, {
                props: [z(value, /:(plac\w+)/, ':' + a + 'input-$1')]
              }), K(element, {
                props: [z(value, /:(plac\w+)/, ':' + r$1 + '$1')]
              }), K(element, {
                props: [z(value, /:(plac\w+)/, e + 'input-$1')]
              })], callback);
          }

          return '';
        });
    }
  };

  var isBrowser$5 = typeof document !== 'undefined';
  var getServerStylisCache = isBrowser$5 ? undefined : weakMemoize(function () {
    return memoize$1(function () {
      var cache = {};
      return function (name) {
        return cache[name];
      };
    });
  });
  var defaultStylisPlugins = [prefixer];

  var createCache = function createCache(options) {
    var key = options.key;

    if (!key) {
      throw new Error("You have to configure `key` for your cache. Please make sure it's unique (and not equal to 'css') as it's used for linking styles to your cache.\n" + "If multiple caches share the same key they might \"fight\" for each other's style elements.");
    }

    if (isBrowser$5 && key === 'css') {
      var ssrStyles = document.querySelectorAll("style[data-emotion]:not([data-s])"); // get SSRed styles out of the way of React's hydration
      // document.head is a safe place to move them to(though note document.head is not necessarily the last place they will be)
      // note this very very intentionally targets all style elements regardless of the key to ensure
      // that creating a cache works inside of render of a React component

      Array.prototype.forEach.call(ssrStyles, function (node) {
        // we want to only move elements which have a space in the data-emotion attribute value
        // because that indicates that it is an Emotion 11 server-side rendered style elements
        // while we will already ignore Emotion 11 client-side inserted styles because of the :not([data-s]) part in the selector
        // Emotion 10 client-side inserted styles did not have data-s (but importantly did not have a space in their data-emotion attributes)
        // so checking for the space ensures that loading Emotion 11 after Emotion 10 has inserted some styles
        // will not result in the Emotion 10 styles being destroyed
        var dataEmotionAttribute = node.getAttribute('data-emotion');

        if (dataEmotionAttribute.indexOf(' ') === -1) {
          return;
        }
        document.head.appendChild(node);
        node.setAttribute('data-s', '');
      });
    }

    var stylisPlugins = options.stylisPlugins || defaultStylisPlugins;

    {
      // $FlowFixMe
      if (/[^a-z-]/.test(key)) {
        throw new Error("Emotion key must only contain lower case alphabetical characters and - but \"" + key + "\" was passed");
      }
    }

    var inserted = {};
    var container;
    var nodesToHydrate = [];

    if (isBrowser$5) {
      container = options.container || document.head;
      Array.prototype.forEach.call( // this means we will ignore elements which don't have a space in them which
      // means that the style elements we're looking at are only Emotion 11 server-rendered style elements
      document.querySelectorAll("style[data-emotion^=\"" + key + " \"]"), function (node) {
        var attrib = node.getAttribute("data-emotion").split(' '); // $FlowFixMe

        for (var i = 1; i < attrib.length; i++) {
          inserted[attrib[i]] = true;
        }

        nodesToHydrate.push(node);
      });
    }

    var _insert;

    var omnipresentPlugins = [compat, removeLabel];

    {
      omnipresentPlugins.push(createUnsafeSelectorsAlarm({
        get compat() {
          return cache.compat;
        }

      }), incorrectImportAlarm);
    }

    if (isBrowser$5) {
      var currentSheet;
      var finalizingPlugins = [le, function (element) {
        if (!element.root) {
          if (element["return"]) {
            currentSheet.insert(element["return"]);
          } else if (element.value && element.type !== n) {
            // insert empty rule in non-production environments
            // so @emotion/jest can grab `key` from the (JS)DOM for caches without any rules inserted yet
            currentSheet.insert(element.value + "{}");
          }
        }
      } ];
      var serializer = ve(omnipresentPlugins.concat(stylisPlugins, finalizingPlugins));

      var stylis = function stylis(styles) {
        return oe(ce(styles), serializer);
      };

      _insert = function insert(selector, serialized, sheet, shouldCache) {
        currentSheet = sheet;

        if (serialized.map !== undefined) {
          currentSheet = {
            insert: function insert(rule) {
              sheet.insert(rule + serialized.map);
            }
          };
        }

        stylis(selector ? selector + "{" + serialized.styles + "}" : serialized.styles);

        if (shouldCache) {
          cache.inserted[serialized.name] = true;
        }
      };
    } else {
      var _finalizingPlugins = [le];

      var _serializer = ve(omnipresentPlugins.concat(stylisPlugins, _finalizingPlugins));

      var _stylis = function _stylis(styles) {
        return oe(ce(styles), _serializer);
      }; // $FlowFixMe


      var serverStylisCache = getServerStylisCache(stylisPlugins)(key);

      var getRules = function getRules(selector, serialized) {
        var name = serialized.name;

        if (serverStylisCache[name] === undefined) {
          serverStylisCache[name] = _stylis(selector ? selector + "{" + serialized.styles + "}" : serialized.styles);
        }

        return serverStylisCache[name];
      };

      _insert = function _insert(selector, serialized, sheet, shouldCache) {
        var name = serialized.name;
        var rules = getRules(selector, serialized);

        if (cache.compat === undefined) {
          // in regular mode, we don't set the styles on the inserted cache
          // since we don't need to and that would be wasting memory
          // we return them so that they are rendered in a style tag
          if (shouldCache) {
            cache.inserted[name] = true;
          }

          if ( // using === development instead of !== production
          // because if people do ssr in tests, the source maps showing up would be annoying
          serialized.map !== undefined) {
            return rules + serialized.map;
          }

          return rules;
        } else {
          // in compat mode, we put the styles on the inserted cache so
          // that emotion-server can pull out the styles
          // except when we don't want to cache it which was in Global but now
          // is nowhere but we don't want to do a major right now
          // and just in case we're going to leave the case here
          // it's also not affecting client side bundle size
          // so it's really not a big deal
          if (shouldCache) {
            cache.inserted[name] = rules;
          } else {
            return rules;
          }
        }
      };
    }

    var cache = {
      key: key,
      sheet: new StyleSheet({
        key: key,
        container: container,
        nonce: options.nonce,
        speedy: options.speedy,
        prepend: options.prepend,
        insertionPoint: options.insertionPoint
      }),
      nonce: options.nonce,
      inserted: inserted,
      registered: {},
      insert: _insert
    };
    cache.sheet.hydrate(nodesToHydrate);
    return cache;
  };

  function unwrapExports (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  function createCommonjsModule(fn, module) {
  	return module = { exports: {} }, fn(module, module.exports), module.exports;
  }

  var reactIs_development$1 = createCommonjsModule(function (module, exports) {



  {
    (function() {

  // The Symbol used to tag the ReactElement-like types. If there is no native Symbol
  // nor polyfill, then a plain number is used for performance.
  var hasSymbol = typeof Symbol === 'function' && Symbol.for;
  var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;
  var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;
  var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;
  var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;
  var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;
  var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;
  var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace; // TODO: We don't use AsyncMode or ConcurrentMode anymore. They were temporary
  // (unstable) APIs that have been removed. Can we remove the symbols?

  var REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for('react.async_mode') : 0xeacf;
  var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;
  var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;
  var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;
  var REACT_SUSPENSE_LIST_TYPE = hasSymbol ? Symbol.for('react.suspense_list') : 0xead8;
  var REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;
  var REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;
  var REACT_BLOCK_TYPE = hasSymbol ? Symbol.for('react.block') : 0xead9;
  var REACT_FUNDAMENTAL_TYPE = hasSymbol ? Symbol.for('react.fundamental') : 0xead5;
  var REACT_RESPONDER_TYPE = hasSymbol ? Symbol.for('react.responder') : 0xead6;
  var REACT_SCOPE_TYPE = hasSymbol ? Symbol.for('react.scope') : 0xead7;

  function isValidElementType(type) {
    return typeof type === 'string' || typeof type === 'function' || // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
    type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || typeof type === 'object' && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_RESPONDER_TYPE || type.$$typeof === REACT_SCOPE_TYPE || type.$$typeof === REACT_BLOCK_TYPE);
  }

  function typeOf(object) {
    if (typeof object === 'object' && object !== null) {
      var $$typeof = object.$$typeof;

      switch ($$typeof) {
        case REACT_ELEMENT_TYPE:
          var type = object.type;

          switch (type) {
            case REACT_ASYNC_MODE_TYPE:
            case REACT_CONCURRENT_MODE_TYPE:
            case REACT_FRAGMENT_TYPE:
            case REACT_PROFILER_TYPE:
            case REACT_STRICT_MODE_TYPE:
            case REACT_SUSPENSE_TYPE:
              return type;

            default:
              var $$typeofType = type && type.$$typeof;

              switch ($$typeofType) {
                case REACT_CONTEXT_TYPE:
                case REACT_FORWARD_REF_TYPE:
                case REACT_LAZY_TYPE:
                case REACT_MEMO_TYPE:
                case REACT_PROVIDER_TYPE:
                  return $$typeofType;

                default:
                  return $$typeof;
              }

          }

        case REACT_PORTAL_TYPE:
          return $$typeof;
      }
    }

    return undefined;
  } // AsyncMode is deprecated along with isAsyncMode

  var AsyncMode = REACT_ASYNC_MODE_TYPE;
  var ConcurrentMode = REACT_CONCURRENT_MODE_TYPE;
  var ContextConsumer = REACT_CONTEXT_TYPE;
  var ContextProvider = REACT_PROVIDER_TYPE;
  var Element = REACT_ELEMENT_TYPE;
  var ForwardRef = REACT_FORWARD_REF_TYPE;
  var Fragment = REACT_FRAGMENT_TYPE;
  var Lazy = REACT_LAZY_TYPE;
  var Memo = REACT_MEMO_TYPE;
  var Portal = REACT_PORTAL_TYPE;
  var Profiler = REACT_PROFILER_TYPE;
  var StrictMode = REACT_STRICT_MODE_TYPE;
  var Suspense = REACT_SUSPENSE_TYPE;
  var hasWarnedAboutDeprecatedIsAsyncMode = false; // AsyncMode should be deprecated

  function isAsyncMode(object) {
    {
      if (!hasWarnedAboutDeprecatedIsAsyncMode) {
        hasWarnedAboutDeprecatedIsAsyncMode = true; // Using console['warn'] to evade Babel and ESLint

        console['warn']('The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 17+. Update your code to use ' + 'ReactIs.isConcurrentMode() instead. It has the exact same API.');
      }
    }

    return isConcurrentMode(object) || typeOf(object) === REACT_ASYNC_MODE_TYPE;
  }
  function isConcurrentMode(object) {
    return typeOf(object) === REACT_CONCURRENT_MODE_TYPE;
  }
  function isContextConsumer(object) {
    return typeOf(object) === REACT_CONTEXT_TYPE;
  }
  function isContextProvider(object) {
    return typeOf(object) === REACT_PROVIDER_TYPE;
  }
  function isElement(object) {
    return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
  }
  function isForwardRef(object) {
    return typeOf(object) === REACT_FORWARD_REF_TYPE;
  }
  function isFragment(object) {
    return typeOf(object) === REACT_FRAGMENT_TYPE;
  }
  function isLazy(object) {
    return typeOf(object) === REACT_LAZY_TYPE;
  }
  function isMemo(object) {
    return typeOf(object) === REACT_MEMO_TYPE;
  }
  function isPortal(object) {
    return typeOf(object) === REACT_PORTAL_TYPE;
  }
  function isProfiler(object) {
    return typeOf(object) === REACT_PROFILER_TYPE;
  }
  function isStrictMode(object) {
    return typeOf(object) === REACT_STRICT_MODE_TYPE;
  }
  function isSuspense(object) {
    return typeOf(object) === REACT_SUSPENSE_TYPE;
  }

  exports.AsyncMode = AsyncMode;
  exports.ConcurrentMode = ConcurrentMode;
  exports.ContextConsumer = ContextConsumer;
  exports.ContextProvider = ContextProvider;
  exports.Element = Element;
  exports.ForwardRef = ForwardRef;
  exports.Fragment = Fragment;
  exports.Lazy = Lazy;
  exports.Memo = Memo;
  exports.Portal = Portal;
  exports.Profiler = Profiler;
  exports.StrictMode = StrictMode;
  exports.Suspense = Suspense;
  exports.isAsyncMode = isAsyncMode;
  exports.isConcurrentMode = isConcurrentMode;
  exports.isContextConsumer = isContextConsumer;
  exports.isContextProvider = isContextProvider;
  exports.isElement = isElement;
  exports.isForwardRef = isForwardRef;
  exports.isFragment = isFragment;
  exports.isLazy = isLazy;
  exports.isMemo = isMemo;
  exports.isPortal = isPortal;
  exports.isProfiler = isProfiler;
  exports.isStrictMode = isStrictMode;
  exports.isSuspense = isSuspense;
  exports.isValidElementType = isValidElementType;
  exports.typeOf = typeOf;
    })();
  }
  });
  reactIs_development$1.AsyncMode;
  reactIs_development$1.ConcurrentMode;
  reactIs_development$1.ContextConsumer;
  reactIs_development$1.ContextProvider;
  reactIs_development$1.Element;
  reactIs_development$1.ForwardRef;
  reactIs_development$1.Fragment;
  reactIs_development$1.Lazy;
  reactIs_development$1.Memo;
  reactIs_development$1.Portal;
  reactIs_development$1.Profiler;
  reactIs_development$1.StrictMode;
  reactIs_development$1.Suspense;
  reactIs_development$1.isAsyncMode;
  reactIs_development$1.isConcurrentMode;
  reactIs_development$1.isContextConsumer;
  reactIs_development$1.isContextProvider;
  reactIs_development$1.isElement;
  reactIs_development$1.isForwardRef;
  reactIs_development$1.isFragment;
  reactIs_development$1.isLazy;
  reactIs_development$1.isMemo;
  reactIs_development$1.isPortal;
  reactIs_development$1.isProfiler;
  reactIs_development$1.isStrictMode;
  reactIs_development$1.isSuspense;
  reactIs_development$1.isValidElementType;
  reactIs_development$1.typeOf;

  var reactIs$1 = createCommonjsModule(function (module) {

  {
    module.exports = reactIs_development$1;
  }
  });

  var FORWARD_REF_STATICS = {
    '$$typeof': true,
    render: true,
    defaultProps: true,
    displayName: true,
    propTypes: true
  };
  var MEMO_STATICS = {
    '$$typeof': true,
    compare: true,
    defaultProps: true,
    displayName: true,
    propTypes: true,
    type: true
  };
  var TYPE_STATICS = {};
  TYPE_STATICS[reactIs$1.ForwardRef] = FORWARD_REF_STATICS;
  TYPE_STATICS[reactIs$1.Memo] = MEMO_STATICS;

  var isBrowser$4 = typeof document !== 'undefined';
  function getRegisteredStyles(registered, registeredStyles, classNames) {
    var rawClassName = '';
    classNames.split(' ').forEach(function (className) {
      if (registered[className] !== undefined) {
        registeredStyles.push(registered[className] + ";");
      } else {
        rawClassName += className + " ";
      }
    });
    return rawClassName;
  }
  var registerStyles = function registerStyles(cache, serialized, isStringTag) {
    var className = cache.key + "-" + serialized.name;

    if ( // we only need to add the styles to the registered cache if the
    // class name could be used further down
    // the tree but if it's a string tag, we know it won't
    // so we don't have to add it to registered cache.
    // this improves memory usage since we can avoid storing the whole style string
    (isStringTag === false || // we need to always store it if we're in compat mode and
    // in node since emotion-server relies on whether a style is in
    // the registered cache to know whether a style is global or not
    // also, note that this check will be dead code eliminated in the browser
    isBrowser$4 === false && cache.compat !== undefined) && cache.registered[className] === undefined) {
      cache.registered[className] = serialized.styles;
    }
  };
  var insertStyles = function insertStyles(cache, serialized, isStringTag) {
    registerStyles(cache, serialized, isStringTag);
    var className = cache.key + "-" + serialized.name;

    if (cache.inserted[serialized.name] === undefined) {
      var stylesForSSR = '';
      var current = serialized;

      do {
        var maybeStyles = cache.insert(serialized === current ? "." + className : '', current, cache.sheet, true);

        if (!isBrowser$4 && maybeStyles !== undefined) {
          stylesForSSR += maybeStyles;
        }

        current = current.next;
      } while (current !== undefined);

      if (!isBrowser$4 && stylesForSSR.length !== 0) {
        return stylesForSSR;
      }
    }
  };

  /* eslint-disable */
  // Inspired by https://github.com/garycourt/murmurhash-js
  // Ported from https://github.com/aappleby/smhasher/blob/61a0530f28277f2e850bfc39600ce61d02b518de/src/MurmurHash2.cpp#L37-L86
  function murmur2(str) {
    // 'm' and 'r' are mixing constants generated offline.
    // They're not really 'magic', they just happen to work well.
    // const m = 0x5bd1e995;
    // const r = 24;
    // Initialize the hash
    var h = 0; // Mix 4 bytes at a time into the hash

    var k,
        i = 0,
        len = str.length;

    for (; len >= 4; ++i, len -= 4) {
      k = str.charCodeAt(i) & 0xff | (str.charCodeAt(++i) & 0xff) << 8 | (str.charCodeAt(++i) & 0xff) << 16 | (str.charCodeAt(++i) & 0xff) << 24;
      k =
      /* Math.imul(k, m): */
      (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16);
      k ^=
      /* k >>> r: */
      k >>> 24;
      h =
      /* Math.imul(k, m): */
      (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16) ^
      /* Math.imul(h, m): */
      (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
    } // Handle the last few bytes of the input array


    switch (len) {
      case 3:
        h ^= (str.charCodeAt(i + 2) & 0xff) << 16;

      case 2:
        h ^= (str.charCodeAt(i + 1) & 0xff) << 8;

      case 1:
        h ^= str.charCodeAt(i) & 0xff;
        h =
        /* Math.imul(h, m): */
        (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
    } // Do a few final mixes of the hash to ensure the last few
    // bytes are well-incorporated.


    h ^= h >>> 13;
    h =
    /* Math.imul(h, m): */
    (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
    return ((h ^ h >>> 15) >>> 0).toString(36);
  }

  var unitlessKeys = {
    animationIterationCount: 1,
    aspectRatio: 1,
    borderImageOutset: 1,
    borderImageSlice: 1,
    borderImageWidth: 1,
    boxFlex: 1,
    boxFlexGroup: 1,
    boxOrdinalGroup: 1,
    columnCount: 1,
    columns: 1,
    flex: 1,
    flexGrow: 1,
    flexPositive: 1,
    flexShrink: 1,
    flexNegative: 1,
    flexOrder: 1,
    gridRow: 1,
    gridRowEnd: 1,
    gridRowSpan: 1,
    gridRowStart: 1,
    gridColumn: 1,
    gridColumnEnd: 1,
    gridColumnSpan: 1,
    gridColumnStart: 1,
    msGridRow: 1,
    msGridRowSpan: 1,
    msGridColumn: 1,
    msGridColumnSpan: 1,
    fontWeight: 1,
    lineHeight: 1,
    opacity: 1,
    order: 1,
    orphans: 1,
    tabSize: 1,
    widows: 1,
    zIndex: 1,
    zoom: 1,
    WebkitLineClamp: 1,
    // SVG-related properties
    fillOpacity: 1,
    floodOpacity: 1,
    stopOpacity: 1,
    strokeDasharray: 1,
    strokeDashoffset: 1,
    strokeMiterlimit: 1,
    strokeOpacity: 1,
    strokeWidth: 1
  };

  var ILLEGAL_ESCAPE_SEQUENCE_ERROR$1 = "You have illegal escape sequence in your template literal, most likely inside content's property value.\nBecause you write your CSS inside a JavaScript string you actually have to do double escaping, so for example \"content: '\\00d7';\" should become \"content: '\\\\00d7';\".\nYou can read more about this here:\nhttps://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals#ES2018_revision_of_illegal_escape_sequences";
  var UNDEFINED_AS_OBJECT_KEY_ERROR = "You have passed in falsy value as style object's key (can happen when in example you pass unexported component as computed key).";
  var hyphenateRegex = /[A-Z]|^ms/g;
  var animationRegex = /_EMO_([^_]+?)_([^]*?)_EMO_/g;

  var isCustomProperty = function isCustomProperty(property) {
    return property.charCodeAt(1) === 45;
  };

  var isProcessableValue = function isProcessableValue(value) {
    return value != null && typeof value !== 'boolean';
  };

  var processStyleName = /* #__PURE__ */memoize$1(function (styleName) {
    return isCustomProperty(styleName) ? styleName : styleName.replace(hyphenateRegex, '-$&').toLowerCase();
  });

  var processStyleValue = function processStyleValue(key, value) {
    switch (key) {
      case 'animation':
      case 'animationName':
        {
          if (typeof value === 'string') {
            return value.replace(animationRegex, function (match, p1, p2) {
              cursor = {
                name: p1,
                styles: p2,
                next: cursor
              };
              return p1;
            });
          }
        }
    }

    if (unitlessKeys[key] !== 1 && !isCustomProperty(key) && typeof value === 'number' && value !== 0) {
      return value + 'px';
    }

    return value;
  };

  {
    var contentValuePattern = /(var|attr|counters?|url|element|(((repeating-)?(linear|radial))|conic)-gradient)\(|(no-)?(open|close)-quote/;
    var contentValues = ['normal', 'none', 'initial', 'inherit', 'unset'];
    var oldProcessStyleValue = processStyleValue;
    var msPattern = /^-ms-/;
    var hyphenPattern = /-(.)/g;
    var hyphenatedCache = {};

    processStyleValue = function processStyleValue(key, value) {
      if (key === 'content') {
        if (typeof value !== 'string' || contentValues.indexOf(value) === -1 && !contentValuePattern.test(value) && (value.charAt(0) !== value.charAt(value.length - 1) || value.charAt(0) !== '"' && value.charAt(0) !== "'")) {
          throw new Error("You seem to be using a value for 'content' without quotes, try replacing it with `content: '\"" + value + "\"'`");
        }
      }

      var processed = oldProcessStyleValue(key, value);

      if (processed !== '' && !isCustomProperty(key) && key.indexOf('-') !== -1 && hyphenatedCache[key] === undefined) {
        hyphenatedCache[key] = true;
        console.error("Using kebab-case for css properties in objects is not supported. Did you mean " + key.replace(msPattern, 'ms-').replace(hyphenPattern, function (str, _char) {
          return _char.toUpperCase();
        }) + "?");
      }

      return processed;
    };
  }

  var noComponentSelectorMessage = 'Component selectors can only be used in conjunction with ' + '@emotion/babel-plugin, the swc Emotion plugin, or another Emotion-aware ' + 'compiler transform.';

  function handleInterpolation(mergedProps, registered, interpolation) {
    if (interpolation == null) {
      return '';
    }

    if (interpolation.__emotion_styles !== undefined) {
      if (interpolation.toString() === 'NO_COMPONENT_SELECTOR') {
        throw new Error(noComponentSelectorMessage);
      }

      return interpolation;
    }

    switch (typeof interpolation) {
      case 'boolean':
        {
          return '';
        }

      case 'object':
        {
          if (interpolation.anim === 1) {
            cursor = {
              name: interpolation.name,
              styles: interpolation.styles,
              next: cursor
            };
            return interpolation.name;
          }

          if (interpolation.styles !== undefined) {
            var next = interpolation.next;

            if (next !== undefined) {
              // not the most efficient thing ever but this is a pretty rare case
              // and there will be very few iterations of this generally
              while (next !== undefined) {
                cursor = {
                  name: next.name,
                  styles: next.styles,
                  next: cursor
                };
                next = next.next;
              }
            }

            var styles = interpolation.styles + ";";

            if (interpolation.map !== undefined) {
              styles += interpolation.map;
            }

            return styles;
          }

          return createStringFromObject(mergedProps, registered, interpolation);
        }

      case 'function':
        {
          if (mergedProps !== undefined) {
            var previousCursor = cursor;
            var result = interpolation(mergedProps);
            cursor = previousCursor;
            return handleInterpolation(mergedProps, registered, result);
          } else {
            console.error('Functions that are interpolated in css calls will be stringified.\n' + 'If you want to have a css call based on props, create a function that returns a css call like this\n' + 'let dynamicStyle = (props) => css`color: ${props.color}`\n' + 'It can be called directly with props or interpolated in a styled call like this\n' + "let SomeComponent = styled('div')`${dynamicStyle}`");
          }

          break;
        }

      case 'string':
        {
          var matched = [];
          var replaced = interpolation.replace(animationRegex, function (match, p1, p2) {
            var fakeVarName = "animation" + matched.length;
            matched.push("const " + fakeVarName + " = keyframes`" + p2.replace(/^@keyframes animation-\w+/, '') + "`");
            return "${" + fakeVarName + "}";
          });

          if (matched.length) {
            console.error('`keyframes` output got interpolated into plain string, please wrap it with `css`.\n\n' + 'Instead of doing this:\n\n' + [].concat(matched, ["`" + replaced + "`"]).join('\n') + '\n\nYou should wrap it with `css` like this:\n\n' + ("css`" + replaced + "`"));
          }
        }

        break;
    } // finalize string values (regular strings and functions interpolated into css calls)


    if (registered == null) {
      return interpolation;
    }

    var cached = registered[interpolation];
    return cached !== undefined ? cached : interpolation;
  }

  function createStringFromObject(mergedProps, registered, obj) {
    var string = '';

    if (Array.isArray(obj)) {
      for (var i = 0; i < obj.length; i++) {
        string += handleInterpolation(mergedProps, registered, obj[i]) + ";";
      }
    } else {
      for (var _key in obj) {
        var value = obj[_key];

        if (typeof value !== 'object') {
          if (registered != null && registered[value] !== undefined) {
            string += _key + "{" + registered[value] + "}";
          } else if (isProcessableValue(value)) {
            string += processStyleName(_key) + ":" + processStyleValue(_key, value) + ";";
          }
        } else {
          if (_key === 'NO_COMPONENT_SELECTOR' && "development" !== 'production') {
            throw new Error(noComponentSelectorMessage);
          }

          if (Array.isArray(value) && typeof value[0] === 'string' && (registered == null || registered[value[0]] === undefined)) {
            for (var _i = 0; _i < value.length; _i++) {
              if (isProcessableValue(value[_i])) {
                string += processStyleName(_key) + ":" + processStyleValue(_key, value[_i]) + ";";
              }
            }
          } else {
            var interpolated = handleInterpolation(mergedProps, registered, value);

            switch (_key) {
              case 'animation':
              case 'animationName':
                {
                  string += processStyleName(_key) + ":" + interpolated + ";";
                  break;
                }

              default:
                {
                  if (_key === 'undefined') {
                    console.error(UNDEFINED_AS_OBJECT_KEY_ERROR);
                  }

                  string += _key + "{" + interpolated + "}";
                }
            }
          }
        }
      }
    }

    return string;
  }

  var labelPattern = /label:\s*([^\s;\n{]+)\s*(;|$)/g;
  var sourceMapPattern;

  {
    sourceMapPattern = /\/\*#\ssourceMappingURL=data:application\/json;\S+\s+\*\//g;
  } // this is the cursor for keyframes
  // keyframes are stored on the SerializedStyles object as a linked list


  var cursor;
  var serializeStyles = function serializeStyles(args, registered, mergedProps) {
    if (args.length === 1 && typeof args[0] === 'object' && args[0] !== null && args[0].styles !== undefined) {
      return args[0];
    }

    var stringMode = true;
    var styles = '';
    cursor = undefined;
    var strings = args[0];

    if (strings == null || strings.raw === undefined) {
      stringMode = false;
      styles += handleInterpolation(mergedProps, registered, strings);
    } else {
      if (strings[0] === undefined) {
        console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR$1);
      }

      styles += strings[0];
    } // we start at 1 since we've already handled the first arg


    for (var i = 1; i < args.length; i++) {
      styles += handleInterpolation(mergedProps, registered, args[i]);

      if (stringMode) {
        if (strings[i] === undefined) {
          console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR$1);
        }

        styles += strings[i];
      }
    }

    var sourceMap;

    {
      styles = styles.replace(sourceMapPattern, function (match) {
        sourceMap = match;
        return '';
      });
    } // using a global regex with .exec is stateful so lastIndex has to be reset each time


    labelPattern.lastIndex = 0;
    var identifierName = '';
    var match; // https://esbench.com/bench/5b809c2cf2949800a0f61fb5

    while ((match = labelPattern.exec(styles)) !== null) {
      identifierName += '-' + // $FlowFixMe we know it's not null
      match[1];
    }

    var name = murmur2(styles) + identifierName;

    {
      // $FlowFixMe SerializedStyles type doesn't have toString property (and we don't want to add it)
      return {
        name: name,
        styles: styles,
        map: sourceMap,
        next: cursor,
        toString: function toString() {
          return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
        }
      };
    }
  };

  var isBrowser$3 = typeof document !== 'undefined';

  var syncFallback = function syncFallback(create) {
    return create();
  };

  var useInsertionEffect = React__namespace['useInsertion' + 'Effect'] ? React__namespace['useInsertion' + 'Effect'] : false;
  var useInsertionEffectAlwaysWithSyncFallback = !isBrowser$3 ? syncFallback : useInsertionEffect || syncFallback;
  var useInsertionEffectWithLayoutFallback = useInsertionEffect || React__namespace.useLayoutEffect;

  var isBrowser$2 = typeof document !== 'undefined';
  var hasOwn = {}.hasOwnProperty;

  var EmotionCacheContext = /* #__PURE__ */React__namespace.createContext( // we're doing this to avoid preconstruct's dead code elimination in this one case
  // because this module is primarily intended for the browser and node
  // but it's also required in react native and similar environments sometimes
  // and we could have a special build just for that
  // but this is much easier and the native packages
  // might use a different theme context in the future anyway
  typeof HTMLElement !== 'undefined' ? /* #__PURE__ */createCache({
    key: 'css'
  }) : null);

  {
    EmotionCacheContext.displayName = 'EmotionCacheContext';
  }

  var CacheProvider = EmotionCacheContext.Provider;

  var withEmotionCache = function withEmotionCache(func) {
    // $FlowFixMe
    return /*#__PURE__*/React.forwardRef(function (props, ref) {
      // the cache will never be null in the browser
      var cache = React.useContext(EmotionCacheContext);
      return func(props, cache, ref);
    });
  };

  if (!isBrowser$2) {
    withEmotionCache = function withEmotionCache(func) {
      return function (props) {
        var cache = React.useContext(EmotionCacheContext);

        if (cache === null) {
          // yes, we're potentially creating this on every render
          // it doesn't actually matter though since it's only on the server
          // so there will only every be a single render
          // that could change in the future because of suspense and etc. but for now,
          // this works and i don't want to optimise for a future thing that we aren't sure about
          cache = createCache({
            key: 'css'
          });
          return /*#__PURE__*/React__namespace.createElement(EmotionCacheContext.Provider, {
            value: cache
          }, func(props, cache));
        } else {
          return func(props, cache);
        }
      };
    };
  }

  var ThemeContext$2 = /* #__PURE__ */React__namespace.createContext({});

  {
    ThemeContext$2.displayName = 'EmotionThemeContext';
  }

  var typePropName = '__EMOTION_TYPE_PLEASE_DO_NOT_USE__';
  var labelPropName = '__EMOTION_LABEL_PLEASE_DO_NOT_USE__';

  var Insertion$2 = function Insertion(_ref) {
    var cache = _ref.cache,
        serialized = _ref.serialized,
        isStringTag = _ref.isStringTag;
    registerStyles(cache, serialized, isStringTag);
    var rules = useInsertionEffectAlwaysWithSyncFallback(function () {
      return insertStyles(cache, serialized, isStringTag);
    });

    if (!isBrowser$2 && rules !== undefined) {
      var _ref2;

      var serializedNames = serialized.name;
      var next = serialized.next;

      while (next !== undefined) {
        serializedNames += ' ' + next.name;
        next = next.next;
      }

      return /*#__PURE__*/React__namespace.createElement("style", (_ref2 = {}, _ref2["data-emotion"] = cache.key + " " + serializedNames, _ref2.dangerouslySetInnerHTML = {
        __html: rules
      }, _ref2.nonce = cache.sheet.nonce, _ref2));
    }

    return null;
  };

  var Emotion = /* #__PURE__ */withEmotionCache(function (props, cache, ref) {
    var cssProp = props.css; // so that using `css` from `emotion` and passing the result to the css prop works
    // not passing the registered cache to serializeStyles because it would
    // make certain babel optimisations not possible

    if (typeof cssProp === 'string' && cache.registered[cssProp] !== undefined) {
      cssProp = cache.registered[cssProp];
    }

    var WrappedComponent = props[typePropName];
    var registeredStyles = [cssProp];
    var className = '';

    if (typeof props.className === 'string') {
      className = getRegisteredStyles(cache.registered, registeredStyles, props.className);
    } else if (props.className != null) {
      className = props.className + " ";
    }

    var serialized = serializeStyles(registeredStyles, undefined, React__namespace.useContext(ThemeContext$2));

    if (serialized.name.indexOf('-') === -1) {
      var labelFromStack = props[labelPropName];

      if (labelFromStack) {
        serialized = serializeStyles([serialized, 'label:' + labelFromStack + ';']);
      }
    }

    className += cache.key + "-" + serialized.name;
    var newProps = {};

    for (var key in props) {
      if (hasOwn.call(props, key) && key !== 'css' && key !== typePropName && (key !== labelPropName)) {
        newProps[key] = props[key];
      }
    }

    newProps.ref = ref;
    newProps.className = className;
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement(Insertion$2, {
      cache: cache,
      serialized: serialized,
      isStringTag: typeof WrappedComponent === 'string'
    }), /*#__PURE__*/React__namespace.createElement(WrappedComponent, newProps));
  });

  {
    Emotion.displayName = 'EmotionCssPropInternal';
  }

  var _extends_1 = createCommonjsModule(function (module) {
  function _extends() {
    module.exports = _extends = Object.assign ? Object.assign.bind() : function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];
        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }
      return target;
    }, module.exports.__esModule = true, module.exports["default"] = module.exports;
    return _extends.apply(this, arguments);
  }
  module.exports = _extends, module.exports.__esModule = true, module.exports["default"] = module.exports;
  });

  unwrapExports(_extends_1);

  var pkg = {
  	name: "@emotion/react",
  	version: "11.11.4",
  	main: "dist/emotion-react.cjs.js",
  	module: "dist/emotion-react.esm.js",
  	browser: {
  		"./dist/emotion-react.esm.js": "./dist/emotion-react.browser.esm.js"
  	},
  	exports: {
  		".": {
  			module: {
  				worker: "./dist/emotion-react.worker.esm.js",
  				browser: "./dist/emotion-react.browser.esm.js",
  				"default": "./dist/emotion-react.esm.js"
  			},
  			"import": "./dist/emotion-react.cjs.mjs",
  			"default": "./dist/emotion-react.cjs.js"
  		},
  		"./jsx-runtime": {
  			module: {
  				worker: "./jsx-runtime/dist/emotion-react-jsx-runtime.worker.esm.js",
  				browser: "./jsx-runtime/dist/emotion-react-jsx-runtime.browser.esm.js",
  				"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.esm.js"
  			},
  			"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.cjs.mjs",
  			"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.cjs.js"
  		},
  		"./_isolated-hnrs": {
  			module: {
  				worker: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.worker.esm.js",
  				browser: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.esm.js",
  				"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.esm.js"
  			},
  			"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.cjs.mjs",
  			"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.cjs.js"
  		},
  		"./jsx-dev-runtime": {
  			module: {
  				worker: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.worker.esm.js",
  				browser: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.browser.esm.js",
  				"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.esm.js"
  			},
  			"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.cjs.mjs",
  			"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.cjs.js"
  		},
  		"./package.json": "./package.json",
  		"./types/css-prop": "./types/css-prop.d.ts",
  		"./macro": {
  			types: {
  				"import": "./macro.d.mts",
  				"default": "./macro.d.ts"
  			},
  			"default": "./macro.js"
  		}
  	},
  	types: "types/index.d.ts",
  	files: [
  		"src",
  		"dist",
  		"jsx-runtime",
  		"jsx-dev-runtime",
  		"_isolated-hnrs",
  		"types/*.d.ts",
  		"macro.*"
  	],
  	sideEffects: false,
  	author: "Emotion Contributors",
  	license: "MIT",
  	scripts: {
  		"test:typescript": "dtslint types"
  	},
  	dependencies: {
  		"@babel/runtime": "^7.18.3",
  		"@emotion/babel-plugin": "^11.11.0",
  		"@emotion/cache": "^11.11.0",
  		"@emotion/serialize": "^1.1.3",
  		"@emotion/use-insertion-effect-with-fallbacks": "^1.0.1",
  		"@emotion/utils": "^1.2.1",
  		"@emotion/weak-memoize": "^0.3.1",
  		"hoist-non-react-statics": "^3.3.1"
  	},
  	peerDependencies: {
  		react: ">=16.8.0"
  	},
  	peerDependenciesMeta: {
  		"@types/react": {
  			optional: true
  		}
  	},
  	devDependencies: {
  		"@definitelytyped/dtslint": "0.0.112",
  		"@emotion/css": "11.11.2",
  		"@emotion/css-prettifier": "1.1.3",
  		"@emotion/server": "11.11.0",
  		"@emotion/styled": "11.11.0",
  		"html-tag-names": "^1.1.2",
  		react: "16.14.0",
  		"svg-tag-names": "^1.1.1",
  		typescript: "^4.5.5"
  	},
  	repository: "https://github.com/emotion-js/emotion/tree/main/packages/react",
  	publishConfig: {
  		access: "public"
  	},
  	"umd:main": "dist/emotion-react.umd.min.js",
  	preconstruct: {
  		entrypoints: [
  			"./index.js",
  			"./jsx-runtime.js",
  			"./jsx-dev-runtime.js",
  			"./_isolated-hnrs.js"
  		],
  		umdName: "emotionReact",
  		exports: {
  			envConditions: [
  				"browser",
  				"worker"
  			],
  			extra: {
  				"./types/css-prop": "./types/css-prop.d.ts",
  				"./macro": {
  					types: {
  						"import": "./macro.d.mts",
  						"default": "./macro.d.ts"
  					},
  					"default": "./macro.js"
  				}
  			}
  		}
  	}
  };

  var warnedAboutCssPropForGlobal = false; // maintain place over rerenders.
  // initial render from browser, insertBefore context.sheet.tags[0] or if a style hasn't been inserted there yet, appendChild
  // initial client-side render from SSR, use place of hydrating tag

  var Global = /* #__PURE__ */withEmotionCache(function (props, cache) {
    if (!warnedAboutCssPropForGlobal && ( // check for className as well since the user is
    // probably using the custom createElement which
    // means it will be turned into a className prop
    // $FlowFixMe I don't really want to add it to the type since it shouldn't be used
    props.className || props.css)) {
      console.error("It looks like you're using the css prop on Global, did you mean to use the styles prop instead?");
      warnedAboutCssPropForGlobal = true;
    }

    var styles = props.styles;
    var serialized = serializeStyles([styles], undefined, React__namespace.useContext(ThemeContext$2));

    if (!isBrowser$2) {
      var _ref;

      var serializedNames = serialized.name;
      var serializedStyles = serialized.styles;
      var next = serialized.next;

      while (next !== undefined) {
        serializedNames += ' ' + next.name;
        serializedStyles += next.styles;
        next = next.next;
      }

      var shouldCache = cache.compat === true;
      var rules = cache.insert("", {
        name: serializedNames,
        styles: serializedStyles
      }, cache.sheet, shouldCache);

      if (shouldCache) {
        return null;
      }

      return /*#__PURE__*/React__namespace.createElement("style", (_ref = {}, _ref["data-emotion"] = cache.key + "-global " + serializedNames, _ref.dangerouslySetInnerHTML = {
        __html: rules
      }, _ref.nonce = cache.sheet.nonce, _ref));
    } // yes, i know these hooks are used conditionally
    // but it is based on a constant that will never change at runtime
    // it's effectively like having two implementations and switching them out
    // so it's not actually breaking anything


    var sheetRef = React__namespace.useRef();
    useInsertionEffectWithLayoutFallback(function () {
      var key = cache.key + "-global"; // use case of https://github.com/emotion-js/emotion/issues/2675

      var sheet = new cache.sheet.constructor({
        key: key,
        nonce: cache.sheet.nonce,
        container: cache.sheet.container,
        speedy: cache.sheet.isSpeedy
      });
      var rehydrating = false; // $FlowFixMe

      var node = document.querySelector("style[data-emotion=\"" + key + " " + serialized.name + "\"]");

      if (cache.sheet.tags.length) {
        sheet.before = cache.sheet.tags[0];
      }

      if (node !== null) {
        rehydrating = true; // clear the hash so this node won't be recognizable as rehydratable by other <Global/>s

        node.setAttribute('data-emotion', key);
        sheet.hydrate([node]);
      }

      sheetRef.current = [sheet, rehydrating];
      return function () {
        sheet.flush();
      };
    }, [cache]);
    useInsertionEffectWithLayoutFallback(function () {
      var sheetRefCurrent = sheetRef.current;
      var sheet = sheetRefCurrent[0],
          rehydrating = sheetRefCurrent[1];

      if (rehydrating) {
        sheetRefCurrent[1] = false;
        return;
      }

      if (serialized.next !== undefined) {
        // insert keyframes
        insertStyles(cache, serialized.next, true);
      }

      if (sheet.tags.length) {
        // if this doesn't exist then it will be null so the style element will be appended
        var element = sheet.tags[sheet.tags.length - 1].nextElementSibling;
        sheet.before = element;
        sheet.flush();
      }

      cache.insert("", serialized, sheet, false);
    }, [cache, serialized.name]);
    return null;
  });

  {
    Global.displayName = 'EmotionGlobal';
  }

  function css() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return serializeStyles(args);
  }

  var keyframes = function keyframes() {
    var insertable = css.apply(void 0, arguments);
    var name = "animation-" + insertable.name; // $FlowFixMe

    return {
      name: name,
      styles: "@keyframes " + name + "{" + insertable.styles + "}",
      anim: 1,
      toString: function toString() {
        return "_EMO_" + this.name + "_" + this.styles + "_EMO_";
      }
    };
  };

  var classnames = function classnames(args) {
    var len = args.length;
    var i = 0;
    var cls = '';

    for (; i < len; i++) {
      var arg = args[i];
      if (arg == null) continue;
      var toAdd = void 0;

      switch (typeof arg) {
        case 'boolean':
          break;

        case 'object':
          {
            if (Array.isArray(arg)) {
              toAdd = classnames(arg);
            } else {
              if (arg.styles !== undefined && arg.name !== undefined) {
                console.error('You have passed styles created with `css` from `@emotion/react` package to the `cx`.\n' + '`cx` is meant to compose class names (strings) so you should convert those styles to a class name by passing them to the `css` received from <ClassNames/> component.');
              }

              toAdd = '';

              for (var k in arg) {
                if (arg[k] && k) {
                  toAdd && (toAdd += ' ');
                  toAdd += k;
                }
              }
            }

            break;
          }

        default:
          {
            toAdd = arg;
          }
      }

      if (toAdd) {
        cls && (cls += ' ');
        cls += toAdd;
      }
    }

    return cls;
  };

  function merge$1(registered, css, className) {
    var registeredStyles = [];
    var rawClassName = getRegisteredStyles(registered, registeredStyles, className);

    if (registeredStyles.length < 2) {
      return className;
    }

    return rawClassName + css(registeredStyles);
  }

  var Insertion$1 = function Insertion(_ref) {
    var cache = _ref.cache,
        serializedArr = _ref.serializedArr;
    var rules = useInsertionEffectAlwaysWithSyncFallback(function () {
      var rules = '';

      for (var i = 0; i < serializedArr.length; i++) {
        var res = insertStyles(cache, serializedArr[i], false);

        if (!isBrowser$2 && res !== undefined) {
          rules += res;
        }
      }

      if (!isBrowser$2) {
        return rules;
      }
    });

    if (!isBrowser$2 && rules.length !== 0) {
      var _ref2;

      return /*#__PURE__*/React__namespace.createElement("style", (_ref2 = {}, _ref2["data-emotion"] = cache.key + " " + serializedArr.map(function (serialized) {
        return serialized.name;
      }).join(' '), _ref2.dangerouslySetInnerHTML = {
        __html: rules
      }, _ref2.nonce = cache.sheet.nonce, _ref2));
    }

    return null;
  };

  var ClassNames = /* #__PURE__ */withEmotionCache(function (props, cache) {
    var hasRendered = false;
    var serializedArr = [];

    var css = function css() {
      if (hasRendered && "development" !== 'production') {
        throw new Error('css can only be used during render');
      }

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      var serialized = serializeStyles(args, cache.registered);
      serializedArr.push(serialized); // registration has to happen here as the result of this might get consumed by `cx`

      registerStyles(cache, serialized, false);
      return cache.key + "-" + serialized.name;
    };

    var cx = function cx() {
      if (hasRendered && "development" !== 'production') {
        throw new Error('cx can only be used during render');
      }

      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      return merge$1(cache.registered, css, classnames(args));
    };

    var content = {
      css: css,
      cx: cx,
      theme: React__namespace.useContext(ThemeContext$2)
    };
    var ele = props.children(content);
    hasRendered = true;
    return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement(Insertion$1, {
      cache: cache,
      serializedArr: serializedArr
    }), ele);
  });

  {
    ClassNames.displayName = 'EmotionClassNames';
  }

  {
    var isBrowser$1 = typeof document !== 'undefined'; // #1727, #2905 for some reason Jest and Vitest evaluate modules twice if some consuming module gets mocked

    var isTestEnv = typeof jest !== 'undefined' || typeof vi !== 'undefined';

    if (isBrowser$1 && !isTestEnv) {
      // globalThis has wide browser support - https://caniuse.com/?search=globalThis, Node.js 12 and later
      var globalContext = // $FlowIgnore
      typeof globalThis !== 'undefined' ? globalThis // eslint-disable-line no-undef
      : isBrowser$1 ? window : global$1;
      var globalKey = "__EMOTION_REACT_" + pkg.version.split('.')[0] + "__";

      if (globalContext[globalKey]) {
        console.warn('You are loading @emotion/react when it is already loaded. Running ' + 'multiple instances may cause problems. This can happen if multiple ' + 'versions are used, or if multiple builds of the same version are ' + 'used.');
      }

      globalContext[globalKey] = true;
    }
  }

  var testOmitPropsOnStringTag = isPropValid;

  var testOmitPropsOnComponent = function testOmitPropsOnComponent(key) {
    return key !== 'theme';
  };

  var getDefaultShouldForwardProp = function getDefaultShouldForwardProp(tag) {
    return typeof tag === 'string' && // 96 is one less than the char code
    // for "a" so this is checking that
    // it's a lowercase character
    tag.charCodeAt(0) > 96 ? testOmitPropsOnStringTag : testOmitPropsOnComponent;
  };
  var composeShouldForwardProps = function composeShouldForwardProps(tag, options, isReal) {
    var shouldForwardProp;

    if (options) {
      var optionsShouldForwardProp = options.shouldForwardProp;
      shouldForwardProp = tag.__emotion_forwardProp && optionsShouldForwardProp ? function (propName) {
        return tag.__emotion_forwardProp(propName) && optionsShouldForwardProp(propName);
      } : optionsShouldForwardProp;
    }

    if (typeof shouldForwardProp !== 'function' && isReal) {
      shouldForwardProp = tag.__emotion_forwardProp;
    }

    return shouldForwardProp;
  };

  var ILLEGAL_ESCAPE_SEQUENCE_ERROR = "You have illegal escape sequence in your template literal, most likely inside content's property value.\nBecause you write your CSS inside a JavaScript string you actually have to do double escaping, so for example \"content: '\\00d7';\" should become \"content: '\\\\00d7';\".\nYou can read more about this here:\nhttps://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals#ES2018_revision_of_illegal_escape_sequences";
  var isBrowser = typeof document !== 'undefined';

  var Insertion = function Insertion(_ref) {
    var cache = _ref.cache,
        serialized = _ref.serialized,
        isStringTag = _ref.isStringTag;
    registerStyles(cache, serialized, isStringTag);
    var rules = useInsertionEffectAlwaysWithSyncFallback(function () {
      return insertStyles(cache, serialized, isStringTag);
    });

    if (!isBrowser && rules !== undefined) {
      var _ref2;

      var serializedNames = serialized.name;
      var next = serialized.next;

      while (next !== undefined) {
        serializedNames += ' ' + next.name;
        next = next.next;
      }

      return /*#__PURE__*/React__namespace.createElement("style", (_ref2 = {}, _ref2["data-emotion"] = cache.key + " " + serializedNames, _ref2.dangerouslySetInnerHTML = {
        __html: rules
      }, _ref2.nonce = cache.sheet.nonce, _ref2));
    }

    return null;
  };

  var createStyled$1 = function createStyled(tag, options) {
    {
      if (tag === undefined) {
        throw new Error('You are trying to create a styled element with an undefined component.\nYou may have forgotten to import it.');
      }
    }

    var isReal = tag.__emotion_real === tag;
    var baseTag = isReal && tag.__emotion_base || tag;
    var identifierName;
    var targetClassName;

    if (options !== undefined) {
      identifierName = options.label;
      targetClassName = options.target;
    }

    var shouldForwardProp = composeShouldForwardProps(tag, options, isReal);
    var defaultShouldForwardProp = shouldForwardProp || getDefaultShouldForwardProp(baseTag);
    var shouldUseAs = !defaultShouldForwardProp('as');
    return function () {
      var args = arguments;
      var styles = isReal && tag.__emotion_styles !== undefined ? tag.__emotion_styles.slice(0) : [];

      if (identifierName !== undefined) {
        styles.push("label:" + identifierName + ";");
      }

      if (args[0] == null || args[0].raw === undefined) {
        styles.push.apply(styles, args);
      } else {
        if (args[0][0] === undefined) {
          console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
        }

        styles.push(args[0][0]);
        var len = args.length;
        var i = 1;

        for (; i < len; i++) {
          if (args[0][i] === undefined) {
            console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
          }

          styles.push(args[i], args[0][i]);
        }
      } // $FlowFixMe: we need to cast StatelessFunctionalComponent to our PrivateStyledComponent class


      var Styled = withEmotionCache(function (props, cache, ref) {
        var FinalTag = shouldUseAs && props.as || baseTag;
        var className = '';
        var classInterpolations = [];
        var mergedProps = props;

        if (props.theme == null) {
          mergedProps = {};

          for (var key in props) {
            mergedProps[key] = props[key];
          }

          mergedProps.theme = React__namespace.useContext(ThemeContext$2);
        }

        if (typeof props.className === 'string') {
          className = getRegisteredStyles(cache.registered, classInterpolations, props.className);
        } else if (props.className != null) {
          className = props.className + " ";
        }

        var serialized = serializeStyles(styles.concat(classInterpolations), cache.registered, mergedProps);
        className += cache.key + "-" + serialized.name;

        if (targetClassName !== undefined) {
          className += " " + targetClassName;
        }

        var finalShouldForwardProp = shouldUseAs && shouldForwardProp === undefined ? getDefaultShouldForwardProp(FinalTag) : defaultShouldForwardProp;
        var newProps = {};

        for (var _key in props) {
          if (shouldUseAs && _key === 'as') continue;

          if ( // $FlowFixMe
          finalShouldForwardProp(_key)) {
            newProps[_key] = props[_key];
          }
        }

        newProps.className = className;
        newProps.ref = ref;
        return /*#__PURE__*/React__namespace.createElement(React__namespace.Fragment, null, /*#__PURE__*/React__namespace.createElement(Insertion, {
          cache: cache,
          serialized: serialized,
          isStringTag: typeof FinalTag === 'string'
        }), /*#__PURE__*/React__namespace.createElement(FinalTag, newProps));
      });
      Styled.displayName = identifierName !== undefined ? identifierName : "Styled(" + (typeof baseTag === 'string' ? baseTag : baseTag.displayName || baseTag.name || 'Component') + ")";
      Styled.defaultProps = tag.defaultProps;
      Styled.__emotion_real = Styled;
      Styled.__emotion_base = baseTag;
      Styled.__emotion_styles = styles;
      Styled.__emotion_forwardProp = shouldForwardProp;
      Object.defineProperty(Styled, 'toString', {
        value: function value() {
          if (targetClassName === undefined && "development" !== 'production') {
            return 'NO_COMPONENT_SELECTOR';
          } // $FlowFixMe: coerce undefined to string


          return "." + targetClassName;
        }
      });

      Styled.withComponent = function (nextTag, nextOptions) {
        return createStyled(nextTag, _extends({}, options, nextOptions, {
          shouldForwardProp: composeShouldForwardProps(Styled, nextOptions, true)
        })).apply(void 0, styles);
      };

      return Styled;
    };
  };

  var tags = ['a', 'abbr', 'address', 'area', 'article', 'aside', 'audio', 'b', 'base', 'bdi', 'bdo', 'big', 'blockquote', 'body', 'br', 'button', 'canvas', 'caption', 'cite', 'code', 'col', 'colgroup', 'data', 'datalist', 'dd', 'del', 'details', 'dfn', 'dialog', 'div', 'dl', 'dt', 'em', 'embed', 'fieldset', 'figcaption', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'head', 'header', 'hgroup', 'hr', 'html', 'i', 'iframe', 'img', 'input', 'ins', 'kbd', 'keygen', 'label', 'legend', 'li', 'link', 'main', 'map', 'mark', 'marquee', 'menu', 'menuitem', 'meta', 'meter', 'nav', 'noscript', 'object', 'ol', 'optgroup', 'option', 'output', 'p', 'param', 'picture', 'pre', 'progress', 'q', 'rp', 'rt', 'ruby', 's', 'samp', 'script', 'section', 'select', 'small', 'source', 'span', 'strong', 'style', 'sub', 'summary', 'sup', 'table', 'tbody', 'td', 'textarea', 'tfoot', 'th', 'thead', 'time', 'title', 'tr', 'track', 'u', 'ul', 'var', 'video', 'wbr', // SVG
  'circle', 'clipPath', 'defs', 'ellipse', 'foreignObject', 'g', 'image', 'line', 'linearGradient', 'mask', 'path', 'pattern', 'polygon', 'polyline', 'radialGradient', 'rect', 'stop', 'svg', 'text', 'tspan'];

  var newStyled = createStyled$1.bind();
  tags.forEach(function (tagName) {
    // $FlowFixMe: we can ignore this because its exposed type is defined by the CreateStyled type
    newStyled[tagName] = newStyled(tagName);
  });

  /*
  object-assign
  (c) Sindre Sorhus
  @license MIT
  */

  /* eslint-disable no-unused-vars */
  var getOwnPropertySymbols = Object.getOwnPropertySymbols;
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var propIsEnumerable = Object.prototype.propertyIsEnumerable;

  function toObject(val) {
  	if (val === null || val === undefined) {
  		throw new TypeError('Object.assign cannot be called with null or undefined');
  	}

  	return Object(val);
  }

  function shouldUseNative() {
  	try {
  		if (!Object.assign) {
  			return false;
  		}

  		// Detect buggy property enumeration order in older V8 versions.

  		// https://bugs.chromium.org/p/v8/issues/detail?id=4118
  		var test1 = new String('abc');  // eslint-disable-line no-new-wrappers
  		test1[5] = 'de';
  		if (Object.getOwnPropertyNames(test1)[0] === '5') {
  			return false;
  		}

  		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
  		var test2 = {};
  		for (var i = 0; i < 10; i++) {
  			test2['_' + String.fromCharCode(i)] = i;
  		}
  		var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
  			return test2[n];
  		});
  		if (order2.join('') !== '0123456789') {
  			return false;
  		}

  		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
  		var test3 = {};
  		'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
  			test3[letter] = letter;
  		});
  		if (Object.keys(Object.assign({}, test3)).join('') !==
  				'abcdefghijklmnopqrst') {
  			return false;
  		}

  		return true;
  	} catch (err) {
  		// We don't expect any of the above to throw, but better to be safe.
  		return false;
  	}
  }

  var objectAssign = shouldUseNative() ? Object.assign : function (target, source) {
  	var from;
  	var to = toObject(target);
  	var symbols;

  	for (var s = 1; s < arguments.length; s++) {
  		from = Object(arguments[s]);

  		for (var key in from) {
  			if (hasOwnProperty.call(from, key)) {
  				to[key] = from[key];
  			}
  		}

  		if (getOwnPropertySymbols) {
  			symbols = getOwnPropertySymbols(from);
  			for (var i = 0; i < symbols.length; i++) {
  				if (propIsEnumerable.call(from, symbols[i])) {
  					to[symbols[i]] = from[symbols[i]];
  				}
  			}
  		}
  	}

  	return to;
  };

  /**
   * Copyright (c) 2013-present, Facebook, Inc.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */


  var ReactPropTypesSecret$1 = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

  var ReactPropTypesSecret_1 = ReactPropTypesSecret$1;

  var has$1 = Function.call.bind(Object.prototype.hasOwnProperty);

  var printWarning$1 = function() {};

  {
    var ReactPropTypesSecret = ReactPropTypesSecret_1;
    var loggedTypeFailures = {};
    var has = has$1;

    printWarning$1 = function(text) {
      var message = 'Warning: ' + text;
      if (typeof console !== 'undefined') {
        console.error(message);
      }
      try {
        // --- Welcome to debugging React ---
        // This error was thrown as a convenience so that you can use this stack
        // to find the callsite that caused this warning to fire.
        throw new Error(message);
      } catch (x) { /**/ }
    };
  }

  /**
   * Assert that the values match with the type specs.
   * Error messages are memorized and will only be shown once.
   *
   * @param {object} typeSpecs Map of name to a ReactPropType
   * @param {object} values Runtime values that need to be type-checked
   * @param {string} location e.g. "prop", "context", "child context"
   * @param {string} componentName Name of the component for error messages.
   * @param {?Function} getStack Returns the component stack.
   * @private
   */
  function checkPropTypes(typeSpecs, values, location, componentName, getStack) {
    {
      for (var typeSpecName in typeSpecs) {
        if (has(typeSpecs, typeSpecName)) {
          var error;
          // Prop type validation may throw. In case they do, we don't want to
          // fail the render phase where it didn't fail before. So we log it.
          // After these have been cleaned up, we'll let them throw.
          try {
            // This is intentionally an invariant that gets caught. It's the same
            // behavior as without this statement except with a better message.
            if (typeof typeSpecs[typeSpecName] !== 'function') {
              var err = Error(
                (componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' +
                'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.' +
                'This often happens because of typos such as `PropTypes.function` instead of `PropTypes.func`.'
              );
              err.name = 'Invariant Violation';
              throw err;
            }
            error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret);
          } catch (ex) {
            error = ex;
          }
          if (error && !(error instanceof Error)) {
            printWarning$1(
              (componentName || 'React class') + ': type specification of ' +
              location + ' `' + typeSpecName + '` is invalid; the type checker ' +
              'function must return `null` or an `Error` but returned a ' + typeof error + '. ' +
              'You may have forgotten to pass an argument to the type checker ' +
              'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' +
              'shape all require an argument).'
            );
          }
          if (error instanceof Error && !(error.message in loggedTypeFailures)) {
            // Only monitor this failure once because there tends to be a lot of the
            // same error.
            loggedTypeFailures[error.message] = true;

            var stack = getStack ? getStack() : '';

            printWarning$1(
              'Failed ' + location + ' type: ' + error.message + (stack != null ? stack : '')
            );
          }
        }
      }
    }
  }

  /**
   * Resets warning cache when testing.
   *
   * @private
   */
  checkPropTypes.resetWarningCache = function() {
    {
      loggedTypeFailures = {};
    }
  };

  var checkPropTypes_1 = checkPropTypes;

  var printWarning = function() {};

  {
    printWarning = function(text) {
      var message = 'Warning: ' + text;
      if (typeof console !== 'undefined') {
        console.error(message);
      }
      try {
        // --- Welcome to debugging React ---
        // This error was thrown as a convenience so that you can use this stack
        // to find the callsite that caused this warning to fire.
        throw new Error(message);
      } catch (x) {}
    };
  }

  function emptyFunctionThatReturnsNull() {
    return null;
  }

  var factoryWithTypeCheckers = function(isValidElement, throwOnDirectAccess) {
    /* global Symbol */
    var ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
    var FAUX_ITERATOR_SYMBOL = '@@iterator'; // Before Symbol spec.

    /**
     * Returns the iterator method function contained on the iterable object.
     *
     * Be sure to invoke the function with the iterable as context:
     *
     *     var iteratorFn = getIteratorFn(myIterable);
     *     if (iteratorFn) {
     *       var iterator = iteratorFn.call(myIterable);
     *       ...
     *     }
     *
     * @param {?object} maybeIterable
     * @return {?function}
     */
    function getIteratorFn(maybeIterable) {
      var iteratorFn = maybeIterable && (ITERATOR_SYMBOL && maybeIterable[ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL]);
      if (typeof iteratorFn === 'function') {
        return iteratorFn;
      }
    }

    /**
     * Collection of methods that allow declaration and validation of props that are
     * supplied to React components. Example usage:
     *
     *   var Props = require('ReactPropTypes');
     *   var MyArticle = React.createClass({
     *     propTypes: {
     *       // An optional string prop named "description".
     *       description: Props.string,
     *
     *       // A required enum prop named "category".
     *       category: Props.oneOf(['News','Photos']).isRequired,
     *
     *       // A prop named "dialog" that requires an instance of Dialog.
     *       dialog: Props.instanceOf(Dialog).isRequired
     *     },
     *     render: function() { ... }
     *   });
     *
     * A more formal specification of how these methods are used:
     *
     *   type := array|bool|func|object|number|string|oneOf([...])|instanceOf(...)
     *   decl := ReactPropTypes.{type}(.isRequired)?
     *
     * Each and every declaration produces a function with the same signature. This
     * allows the creation of custom validation functions. For example:
     *
     *  var MyLink = React.createClass({
     *    propTypes: {
     *      // An optional string or URI prop named "href".
     *      href: function(props, propName, componentName) {
     *        var propValue = props[propName];
     *        if (propValue != null && typeof propValue !== 'string' &&
     *            !(propValue instanceof URI)) {
     *          return new Error(
     *            'Expected a string or an URI for ' + propName + ' in ' +
     *            componentName
     *          );
     *        }
     *      }
     *    },
     *    render: function() {...}
     *  });
     *
     * @internal
     */

    var ANONYMOUS = '<<anonymous>>';

    // Important!
    // Keep this list in sync with production version in `./factoryWithThrowingShims.js`.
    var ReactPropTypes = {
      array: createPrimitiveTypeChecker('array'),
      bigint: createPrimitiveTypeChecker('bigint'),
      bool: createPrimitiveTypeChecker('boolean'),
      func: createPrimitiveTypeChecker('function'),
      number: createPrimitiveTypeChecker('number'),
      object: createPrimitiveTypeChecker('object'),
      string: createPrimitiveTypeChecker('string'),
      symbol: createPrimitiveTypeChecker('symbol'),

      any: createAnyTypeChecker(),
      arrayOf: createArrayOfTypeChecker,
      element: createElementTypeChecker(),
      elementType: createElementTypeTypeChecker(),
      instanceOf: createInstanceTypeChecker,
      node: createNodeChecker(),
      objectOf: createObjectOfTypeChecker,
      oneOf: createEnumTypeChecker,
      oneOfType: createUnionTypeChecker,
      shape: createShapeTypeChecker,
      exact: createStrictShapeTypeChecker,
    };

    /**
     * inlined Object.is polyfill to avoid requiring consumers ship their own
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
     */
    /*eslint-disable no-self-compare*/
    function is(x, y) {
      // SameValue algorithm
      if (x === y) {
        // Steps 1-5, 7-10
        // Steps 6.b-6.e: +0 != -0
        return x !== 0 || 1 / x === 1 / y;
      } else {
        // Step 6.a: NaN == NaN
        return x !== x && y !== y;
      }
    }
    /*eslint-enable no-self-compare*/

    /**
     * We use an Error-like object for backward compatibility as people may call
     * PropTypes directly and inspect their output. However, we don't use real
     * Errors anymore. We don't inspect their stack anyway, and creating them
     * is prohibitively expensive if they are created too often, such as what
     * happens in oneOfType() for any type before the one that matched.
     */
    function PropTypeError(message, data) {
      this.message = message;
      this.data = data && typeof data === 'object' ? data: {};
      this.stack = '';
    }
    // Make `instanceof Error` still work for returned errors.
    PropTypeError.prototype = Error.prototype;

    function createChainableTypeChecker(validate) {
      {
        var manualPropTypeCallCache = {};
        var manualPropTypeWarningCount = 0;
      }
      function checkType(isRequired, props, propName, componentName, location, propFullName, secret) {
        componentName = componentName || ANONYMOUS;
        propFullName = propFullName || propName;

        if (secret !== ReactPropTypesSecret_1) {
          if (throwOnDirectAccess) {
            // New behavior only for users of `prop-types` package
            var err = new Error(
              'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
              'Use `PropTypes.checkPropTypes()` to call them. ' +
              'Read more at http://fb.me/use-check-prop-types'
            );
            err.name = 'Invariant Violation';
            throw err;
          } else if (typeof console !== 'undefined') {
            // Old behavior for people using React.PropTypes
            var cacheKey = componentName + ':' + propName;
            if (
              !manualPropTypeCallCache[cacheKey] &&
              // Avoid spamming the console because they are often not actionable except for lib authors
              manualPropTypeWarningCount < 3
            ) {
              printWarning(
                'You are manually calling a React.PropTypes validation ' +
                'function for the `' + propFullName + '` prop on `' + componentName + '`. This is deprecated ' +
                'and will throw in the standalone `prop-types` package. ' +
                'You may be seeing this warning due to a third-party PropTypes ' +
                'library. See https://fb.me/react-warning-dont-call-proptypes ' + 'for details.'
              );
              manualPropTypeCallCache[cacheKey] = true;
              manualPropTypeWarningCount++;
            }
          }
        }
        if (props[propName] == null) {
          if (isRequired) {
            if (props[propName] === null) {
              return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required ' + ('in `' + componentName + '`, but its value is `null`.'));
            }
            return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required in ' + ('`' + componentName + '`, but its value is `undefined`.'));
          }
          return null;
        } else {
          return validate(props, propName, componentName, location, propFullName);
        }
      }

      var chainedCheckType = checkType.bind(null, false);
      chainedCheckType.isRequired = checkType.bind(null, true);

      return chainedCheckType;
    }

    function createPrimitiveTypeChecker(expectedType) {
      function validate(props, propName, componentName, location, propFullName, secret) {
        var propValue = props[propName];
        var propType = getPropType(propValue);
        if (propType !== expectedType) {
          // `propValue` being instance of, say, date/regexp, pass the 'object'
          // check, but we can offer a more precise error message here rather than
          // 'of type `object`'.
          var preciseType = getPreciseType(propValue);

          return new PropTypeError(
            'Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + preciseType + '` supplied to `' + componentName + '`, expected ') + ('`' + expectedType + '`.'),
            {expectedType: expectedType}
          );
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createAnyTypeChecker() {
      return createChainableTypeChecker(emptyFunctionThatReturnsNull);
    }

    function createArrayOfTypeChecker(typeChecker) {
      function validate(props, propName, componentName, location, propFullName) {
        if (typeof typeChecker !== 'function') {
          return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside arrayOf.');
        }
        var propValue = props[propName];
        if (!Array.isArray(propValue)) {
          var propType = getPropType(propValue);
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an array.'));
        }
        for (var i = 0; i < propValue.length; i++) {
          var error = typeChecker(propValue, i, componentName, location, propFullName + '[' + i + ']', ReactPropTypesSecret_1);
          if (error instanceof Error) {
            return error;
          }
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createElementTypeChecker() {
      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        if (!isValidElement(propValue)) {
          var propType = getPropType(propValue);
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement.'));
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createElementTypeTypeChecker() {
      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        if (!reactIs$1.isValidElementType(propValue)) {
          var propType = getPropType(propValue);
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement type.'));
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createInstanceTypeChecker(expectedClass) {
      function validate(props, propName, componentName, location, propFullName) {
        if (!(props[propName] instanceof expectedClass)) {
          var expectedClassName = expectedClass.name || ANONYMOUS;
          var actualClassName = getClassName(props[propName]);
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + actualClassName + '` supplied to `' + componentName + '`, expected ') + ('instance of `' + expectedClassName + '`.'));
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createEnumTypeChecker(expectedValues) {
      if (!Array.isArray(expectedValues)) {
        {
          if (arguments.length > 1) {
            printWarning(
              'Invalid arguments supplied to oneOf, expected an array, got ' + arguments.length + ' arguments. ' +
              'A common mistake is to write oneOf(x, y, z) instead of oneOf([x, y, z]).'
            );
          } else {
            printWarning('Invalid argument supplied to oneOf, expected an array.');
          }
        }
        return emptyFunctionThatReturnsNull;
      }

      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        for (var i = 0; i < expectedValues.length; i++) {
          if (is(propValue, expectedValues[i])) {
            return null;
          }
        }

        var valuesString = JSON.stringify(expectedValues, function replacer(key, value) {
          var type = getPreciseType(value);
          if (type === 'symbol') {
            return String(value);
          }
          return value;
        });
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of value `' + String(propValue) + '` ' + ('supplied to `' + componentName + '`, expected one of ' + valuesString + '.'));
      }
      return createChainableTypeChecker(validate);
    }

    function createObjectOfTypeChecker(typeChecker) {
      function validate(props, propName, componentName, location, propFullName) {
        if (typeof typeChecker !== 'function') {
          return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside objectOf.');
        }
        var propValue = props[propName];
        var propType = getPropType(propValue);
        if (propType !== 'object') {
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an object.'));
        }
        for (var key in propValue) {
          if (has$1(propValue, key)) {
            var error = typeChecker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
            if (error instanceof Error) {
              return error;
            }
          }
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createUnionTypeChecker(arrayOfTypeCheckers) {
      if (!Array.isArray(arrayOfTypeCheckers)) {
        printWarning('Invalid argument supplied to oneOfType, expected an instance of array.') ;
        return emptyFunctionThatReturnsNull;
      }

      for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
        var checker = arrayOfTypeCheckers[i];
        if (typeof checker !== 'function') {
          printWarning(
            'Invalid argument supplied to oneOfType. Expected an array of check functions, but ' +
            'received ' + getPostfixForTypeWarning(checker) + ' at index ' + i + '.'
          );
          return emptyFunctionThatReturnsNull;
        }
      }

      function validate(props, propName, componentName, location, propFullName) {
        var expectedTypes = [];
        for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
          var checker = arrayOfTypeCheckers[i];
          var checkerResult = checker(props, propName, componentName, location, propFullName, ReactPropTypesSecret_1);
          if (checkerResult == null) {
            return null;
          }
          if (checkerResult.data && has$1(checkerResult.data, 'expectedType')) {
            expectedTypes.push(checkerResult.data.expectedType);
          }
        }
        var expectedTypesMessage = (expectedTypes.length > 0) ? ', expected one of type [' + expectedTypes.join(', ') + ']': '';
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`' + expectedTypesMessage + '.'));
      }
      return createChainableTypeChecker(validate);
    }

    function createNodeChecker() {
      function validate(props, propName, componentName, location, propFullName) {
        if (!isNode(props[propName])) {
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`, expected a ReactNode.'));
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function invalidValidatorError(componentName, location, propFullName, key, type) {
      return new PropTypeError(
        (componentName || 'React class') + ': ' + location + ' type `' + propFullName + '.' + key + '` is invalid; ' +
        'it must be a function, usually from the `prop-types` package, but received `' + type + '`.'
      );
    }

    function createShapeTypeChecker(shapeTypes) {
      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        var propType = getPropType(propValue);
        if (propType !== 'object') {
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
        }
        for (var key in shapeTypes) {
          var checker = shapeTypes[key];
          if (typeof checker !== 'function') {
            return invalidValidatorError(componentName, location, propFullName, key, getPreciseType(checker));
          }
          var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
          if (error) {
            return error;
          }
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createStrictShapeTypeChecker(shapeTypes) {
      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        var propType = getPropType(propValue);
        if (propType !== 'object') {
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
        }
        // We need to check all keys in case some are required but missing from props.
        var allKeys = objectAssign({}, props[propName], shapeTypes);
        for (var key in allKeys) {
          var checker = shapeTypes[key];
          if (has$1(shapeTypes, key) && typeof checker !== 'function') {
            return invalidValidatorError(componentName, location, propFullName, key, getPreciseType(checker));
          }
          if (!checker) {
            return new PropTypeError(
              'Invalid ' + location + ' `' + propFullName + '` key `' + key + '` supplied to `' + componentName + '`.' +
              '\nBad object: ' + JSON.stringify(props[propName], null, '  ') +
              '\nValid keys: ' + JSON.stringify(Object.keys(shapeTypes), null, '  ')
            );
          }
          var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
          if (error) {
            return error;
          }
        }
        return null;
      }

      return createChainableTypeChecker(validate);
    }

    function isNode(propValue) {
      switch (typeof propValue) {
        case 'number':
        case 'string':
        case 'undefined':
          return true;
        case 'boolean':
          return !propValue;
        case 'object':
          if (Array.isArray(propValue)) {
            return propValue.every(isNode);
          }
          if (propValue === null || isValidElement(propValue)) {
            return true;
          }

          var iteratorFn = getIteratorFn(propValue);
          if (iteratorFn) {
            var iterator = iteratorFn.call(propValue);
            var step;
            if (iteratorFn !== propValue.entries) {
              while (!(step = iterator.next()).done) {
                if (!isNode(step.value)) {
                  return false;
                }
              }
            } else {
              // Iterator will provide entry [k,v] tuples rather than values.
              while (!(step = iterator.next()).done) {
                var entry = step.value;
                if (entry) {
                  if (!isNode(entry[1])) {
                    return false;
                  }
                }
              }
            }
          } else {
            return false;
          }

          return true;
        default:
          return false;
      }
    }

    function isSymbol(propType, propValue) {
      // Native Symbol.
      if (propType === 'symbol') {
        return true;
      }

      // falsy value can't be a Symbol
      if (!propValue) {
        return false;
      }

      // 19.4.3.5 Symbol.prototype[@@toStringTag] === 'Symbol'
      if (propValue['@@toStringTag'] === 'Symbol') {
        return true;
      }

      // Fallback for non-spec compliant Symbols which are polyfilled.
      if (typeof Symbol === 'function' && propValue instanceof Symbol) {
        return true;
      }

      return false;
    }

    // Equivalent of `typeof` but with special handling for array and regexp.
    function getPropType(propValue) {
      var propType = typeof propValue;
      if (Array.isArray(propValue)) {
        return 'array';
      }
      if (propValue instanceof RegExp) {
        // Old webkits (at least until Android 4.0) return 'function' rather than
        // 'object' for typeof a RegExp. We'll normalize this here so that /bla/
        // passes PropTypes.object.
        return 'object';
      }
      if (isSymbol(propType, propValue)) {
        return 'symbol';
      }
      return propType;
    }

    // This handles more types than `getPropType`. Only used for error messages.
    // See `createPrimitiveTypeChecker`.
    function getPreciseType(propValue) {
      if (typeof propValue === 'undefined' || propValue === null) {
        return '' + propValue;
      }
      var propType = getPropType(propValue);
      if (propType === 'object') {
        if (propValue instanceof Date) {
          return 'date';
        } else if (propValue instanceof RegExp) {
          return 'regexp';
        }
      }
      return propType;
    }

    // Returns a string that is postfixed to a warning about an invalid type.
    // For example, "undefined" or "of type array"
    function getPostfixForTypeWarning(value) {
      var type = getPreciseType(value);
      switch (type) {
        case 'array':
        case 'object':
          return 'an ' + type;
        case 'boolean':
        case 'date':
        case 'regexp':
          return 'a ' + type;
        default:
          return type;
      }
    }

    // Returns class name of the object, if any.
    function getClassName(propValue) {
      if (!propValue.constructor || !propValue.constructor.name) {
        return ANONYMOUS;
      }
      return propValue.constructor.name;
    }

    ReactPropTypes.checkPropTypes = checkPropTypes_1;
    ReactPropTypes.resetWarningCache = checkPropTypes_1.resetWarningCache;
    ReactPropTypes.PropTypes = ReactPropTypes;

    return ReactPropTypes;
  };

  var propTypes = createCommonjsModule(function (module) {
  /**
   * Copyright (c) 2013-present, Facebook, Inc.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */

  {
    var ReactIs = reactIs$1;

    // By explicitly using `prop-types` you are opting into new development behavior.
    // http://fb.me/prop-types-in-prod
    var throwOnDirectAccess = true;
    module.exports = factoryWithTypeCheckers(ReactIs.isElement, throwOnDirectAccess);
  }
  });

  var PropTypes = propTypes;
  propTypes.elementType;
  propTypes.bool;
  propTypes.func;
  propTypes.object;
  propTypes.oneOfType;
  propTypes.element;

  React.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner;

  var reactJsxRuntime_development = createCommonjsModule(function (module, exports) {

  {
    (function() {

  var React$1 = React;

  // ATTENTION
  // When adding new symbols to this file,
  // Please consider also adding to 'react-devtools-shared/src/backend/ReactSymbols'
  // The Symbol used to tag the ReactElement-like types.
  var REACT_ELEMENT_TYPE = Symbol.for('react.element');
  var REACT_PORTAL_TYPE = Symbol.for('react.portal');
  var REACT_FRAGMENT_TYPE = Symbol.for('react.fragment');
  var REACT_STRICT_MODE_TYPE = Symbol.for('react.strict_mode');
  var REACT_PROFILER_TYPE = Symbol.for('react.profiler');
  var REACT_PROVIDER_TYPE = Symbol.for('react.provider');
  var REACT_CONTEXT_TYPE = Symbol.for('react.context');
  var REACT_FORWARD_REF_TYPE = Symbol.for('react.forward_ref');
  var REACT_SUSPENSE_TYPE = Symbol.for('react.suspense');
  var REACT_SUSPENSE_LIST_TYPE = Symbol.for('react.suspense_list');
  var REACT_MEMO_TYPE = Symbol.for('react.memo');
  var REACT_LAZY_TYPE = Symbol.for('react.lazy');
  var REACT_OFFSCREEN_TYPE = Symbol.for('react.offscreen');
  var MAYBE_ITERATOR_SYMBOL = Symbol.iterator;
  var FAUX_ITERATOR_SYMBOL = '@@iterator';
  function getIteratorFn(maybeIterable) {
    if (maybeIterable === null || typeof maybeIterable !== 'object') {
      return null;
    }

    var maybeIterator = MAYBE_ITERATOR_SYMBOL && maybeIterable[MAYBE_ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL];

    if (typeof maybeIterator === 'function') {
      return maybeIterator;
    }

    return null;
  }

  var ReactSharedInternals = React$1.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED;

  function error(format) {
    {
      {
        for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
          args[_key2 - 1] = arguments[_key2];
        }

        printWarning('error', format, args);
      }
    }
  }

  function printWarning(level, format, args) {
    // When changing this logic, you might want to also
    // update consoleWithStackDev.www.js as well.
    {
      var ReactDebugCurrentFrame = ReactSharedInternals.ReactDebugCurrentFrame;
      var stack = ReactDebugCurrentFrame.getStackAddendum();

      if (stack !== '') {
        format += '%s';
        args = args.concat([stack]);
      } // eslint-disable-next-line react-internal/safe-string-coercion


      var argsWithFormat = args.map(function (item) {
        return String(item);
      }); // Careful: RN currently depends on this prefix

      argsWithFormat.unshift('Warning: ' + format); // We intentionally don't use spread (or .apply) directly because it
      // breaks IE9: https://github.com/facebook/react/issues/13610
      // eslint-disable-next-line react-internal/no-production-logging

      Function.prototype.apply.call(console[level], console, argsWithFormat);
    }
  }

  // -----------------------------------------------------------------------------

  var enableScopeAPI = false; // Experimental Create Event Handle API.
  var enableCacheElement = false;
  var enableTransitionTracing = false; // No known bugs, but needs performance testing

  var enableLegacyHidden = false; // Enables unstable_avoidThisFallback feature in Fiber
  // stuff. Intended to enable React core members to more easily debug scheduling
  // issues in DEV builds.

  var enableDebugTracing = false; // Track which Fiber(s) schedule render work.

  var REACT_MODULE_REFERENCE;

  {
    REACT_MODULE_REFERENCE = Symbol.for('react.module.reference');
  }

  function isValidElementType(type) {
    if (typeof type === 'string' || typeof type === 'function') {
      return true;
    } // Note: typeof might be other than 'symbol' or 'number' (e.g. if it's a polyfill).


    if (type === REACT_FRAGMENT_TYPE || type === REACT_PROFILER_TYPE || enableDebugTracing  || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || enableLegacyHidden  || type === REACT_OFFSCREEN_TYPE || enableScopeAPI  || enableCacheElement  || enableTransitionTracing ) {
      return true;
    }

    if (typeof type === 'object' && type !== null) {
      if (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || // This needs to include all possible module reference object
      // types supported by any Flight configuration anywhere since
      // we don't know which Flight build this will end up being used
      // with.
      type.$$typeof === REACT_MODULE_REFERENCE || type.getModuleId !== undefined) {
        return true;
      }
    }

    return false;
  }

  function getWrappedName(outerType, innerType, wrapperName) {
    var displayName = outerType.displayName;

    if (displayName) {
      return displayName;
    }

    var functionName = innerType.displayName || innerType.name || '';
    return functionName !== '' ? wrapperName + "(" + functionName + ")" : wrapperName;
  } // Keep in sync with react-reconciler/getComponentNameFromFiber


  function getContextName(type) {
    return type.displayName || 'Context';
  } // Note that the reconciler package should generally prefer to use getComponentNameFromFiber() instead.


  function getComponentNameFromType(type) {
    if (type == null) {
      // Host root, text node or just invalid type.
      return null;
    }

    {
      if (typeof type.tag === 'number') {
        error('Received an unexpected object in getComponentNameFromType(). ' + 'This is likely a bug in React. Please file an issue.');
      }
    }

    if (typeof type === 'function') {
      return type.displayName || type.name || null;
    }

    if (typeof type === 'string') {
      return type;
    }

    switch (type) {
      case REACT_FRAGMENT_TYPE:
        return 'Fragment';

      case REACT_PORTAL_TYPE:
        return 'Portal';

      case REACT_PROFILER_TYPE:
        return 'Profiler';

      case REACT_STRICT_MODE_TYPE:
        return 'StrictMode';

      case REACT_SUSPENSE_TYPE:
        return 'Suspense';

      case REACT_SUSPENSE_LIST_TYPE:
        return 'SuspenseList';

    }

    if (typeof type === 'object') {
      switch (type.$$typeof) {
        case REACT_CONTEXT_TYPE:
          var context = type;
          return getContextName(context) + '.Consumer';

        case REACT_PROVIDER_TYPE:
          var provider = type;
          return getContextName(provider._context) + '.Provider';

        case REACT_FORWARD_REF_TYPE:
          return getWrappedName(type, type.render, 'ForwardRef');

        case REACT_MEMO_TYPE:
          var outerName = type.displayName || null;

          if (outerName !== null) {
            return outerName;
          }

          return getComponentNameFromType(type.type) || 'Memo';

        case REACT_LAZY_TYPE:
          {
            var lazyComponent = type;
            var payload = lazyComponent._payload;
            var init = lazyComponent._init;

            try {
              return getComponentNameFromType(init(payload));
            } catch (x) {
              return null;
            }
          }

        // eslint-disable-next-line no-fallthrough
      }
    }

    return null;
  }

  var assign = Object.assign;

  // Helpers to patch console.logs to avoid logging during side-effect free
  // replaying on render function. This currently only patches the object
  // lazily which won't cover if the log function was extracted eagerly.
  // We could also eagerly patch the method.
  var disabledDepth = 0;
  var prevLog;
  var prevInfo;
  var prevWarn;
  var prevError;
  var prevGroup;
  var prevGroupCollapsed;
  var prevGroupEnd;

  function disabledLog() {}

  disabledLog.__reactDisabledLog = true;
  function disableLogs() {
    {
      if (disabledDepth === 0) {
        /* eslint-disable react-internal/no-production-logging */
        prevLog = console.log;
        prevInfo = console.info;
        prevWarn = console.warn;
        prevError = console.error;
        prevGroup = console.group;
        prevGroupCollapsed = console.groupCollapsed;
        prevGroupEnd = console.groupEnd; // https://github.com/facebook/react/issues/19099

        var props = {
          configurable: true,
          enumerable: true,
          value: disabledLog,
          writable: true
        }; // $FlowFixMe Flow thinks console is immutable.

        Object.defineProperties(console, {
          info: props,
          log: props,
          warn: props,
          error: props,
          group: props,
          groupCollapsed: props,
          groupEnd: props
        });
        /* eslint-enable react-internal/no-production-logging */
      }

      disabledDepth++;
    }
  }
  function reenableLogs() {
    {
      disabledDepth--;

      if (disabledDepth === 0) {
        /* eslint-disable react-internal/no-production-logging */
        var props = {
          configurable: true,
          enumerable: true,
          writable: true
        }; // $FlowFixMe Flow thinks console is immutable.

        Object.defineProperties(console, {
          log: assign({}, props, {
            value: prevLog
          }),
          info: assign({}, props, {
            value: prevInfo
          }),
          warn: assign({}, props, {
            value: prevWarn
          }),
          error: assign({}, props, {
            value: prevError
          }),
          group: assign({}, props, {
            value: prevGroup
          }),
          groupCollapsed: assign({}, props, {
            value: prevGroupCollapsed
          }),
          groupEnd: assign({}, props, {
            value: prevGroupEnd
          })
        });
        /* eslint-enable react-internal/no-production-logging */
      }

      if (disabledDepth < 0) {
        error('disabledDepth fell below zero. ' + 'This is a bug in React. Please file an issue.');
      }
    }
  }

  var ReactCurrentDispatcher = ReactSharedInternals.ReactCurrentDispatcher;
  var prefix;
  function describeBuiltInComponentFrame(name, source, ownerFn) {
    {
      if (prefix === undefined) {
        // Extract the VM specific prefix used by each line.
        try {
          throw Error();
        } catch (x) {
          var match = x.stack.trim().match(/\n( *(at )?)/);
          prefix = match && match[1] || '';
        }
      } // We use the prefix to ensure our stacks line up with native stack frames.


      return '\n' + prefix + name;
    }
  }
  var reentry = false;
  var componentFrameCache;

  {
    var PossiblyWeakMap = typeof WeakMap === 'function' ? WeakMap : Map;
    componentFrameCache = new PossiblyWeakMap();
  }

  function describeNativeComponentFrame(fn, construct) {
    // If something asked for a stack inside a fake render, it should get ignored.
    if ( !fn || reentry) {
      return '';
    }

    {
      var frame = componentFrameCache.get(fn);

      if (frame !== undefined) {
        return frame;
      }
    }

    var control;
    reentry = true;
    var previousPrepareStackTrace = Error.prepareStackTrace; // $FlowFixMe It does accept undefined.

    Error.prepareStackTrace = undefined;
    var previousDispatcher;

    {
      previousDispatcher = ReactCurrentDispatcher.current; // Set the dispatcher in DEV because this might be call in the render function
      // for warnings.

      ReactCurrentDispatcher.current = null;
      disableLogs();
    }

    try {
      // This should throw.
      if (construct) {
        // Something should be setting the props in the constructor.
        var Fake = function () {
          throw Error();
        }; // $FlowFixMe


        Object.defineProperty(Fake.prototype, 'props', {
          set: function () {
            // We use a throwing setter instead of frozen or non-writable props
            // because that won't throw in a non-strict mode function.
            throw Error();
          }
        });

        if (typeof Reflect === 'object' && Reflect.construct) {
          // We construct a different control for this case to include any extra
          // frames added by the construct call.
          try {
            Reflect.construct(Fake, []);
          } catch (x) {
            control = x;
          }

          Reflect.construct(fn, [], Fake);
        } else {
          try {
            Fake.call();
          } catch (x) {
            control = x;
          }

          fn.call(Fake.prototype);
        }
      } else {
        try {
          throw Error();
        } catch (x) {
          control = x;
        }

        fn();
      }
    } catch (sample) {
      // This is inlined manually because closure doesn't do it for us.
      if (sample && control && typeof sample.stack === 'string') {
        // This extracts the first frame from the sample that isn't also in the control.
        // Skipping one frame that we assume is the frame that calls the two.
        var sampleLines = sample.stack.split('\n');
        var controlLines = control.stack.split('\n');
        var s = sampleLines.length - 1;
        var c = controlLines.length - 1;

        while (s >= 1 && c >= 0 && sampleLines[s] !== controlLines[c]) {
          // We expect at least one stack frame to be shared.
          // Typically this will be the root most one. However, stack frames may be
          // cut off due to maximum stack limits. In this case, one maybe cut off
          // earlier than the other. We assume that the sample is longer or the same
          // and there for cut off earlier. So we should find the root most frame in
          // the sample somewhere in the control.
          c--;
        }

        for (; s >= 1 && c >= 0; s--, c--) {
          // Next we find the first one that isn't the same which should be the
          // frame that called our sample function and the control.
          if (sampleLines[s] !== controlLines[c]) {
            // In V8, the first line is describing the message but other VMs don't.
            // If we're about to return the first line, and the control is also on the same
            // line, that's a pretty good indicator that our sample threw at same line as
            // the control. I.e. before we entered the sample frame. So we ignore this result.
            // This can happen if you passed a class to function component, or non-function.
            if (s !== 1 || c !== 1) {
              do {
                s--;
                c--; // We may still have similar intermediate frames from the construct call.
                // The next one that isn't the same should be our match though.

                if (c < 0 || sampleLines[s] !== controlLines[c]) {
                  // V8 adds a "new" prefix for native classes. Let's remove it to make it prettier.
                  var _frame = '\n' + sampleLines[s].replace(' at new ', ' at '); // If our component frame is labeled "<anonymous>"
                  // but we have a user-provided "displayName"
                  // splice it in to make the stack more readable.


                  if (fn.displayName && _frame.includes('<anonymous>')) {
                    _frame = _frame.replace('<anonymous>', fn.displayName);
                  }

                  {
                    if (typeof fn === 'function') {
                      componentFrameCache.set(fn, _frame);
                    }
                  } // Return the line we found.


                  return _frame;
                }
              } while (s >= 1 && c >= 0);
            }

            break;
          }
        }
      }
    } finally {
      reentry = false;

      {
        ReactCurrentDispatcher.current = previousDispatcher;
        reenableLogs();
      }

      Error.prepareStackTrace = previousPrepareStackTrace;
    } // Fallback to just using the name if we couldn't make it throw.


    var name = fn ? fn.displayName || fn.name : '';
    var syntheticFrame = name ? describeBuiltInComponentFrame(name) : '';

    {
      if (typeof fn === 'function') {
        componentFrameCache.set(fn, syntheticFrame);
      }
    }

    return syntheticFrame;
  }
  function describeFunctionComponentFrame(fn, source, ownerFn) {
    {
      return describeNativeComponentFrame(fn, false);
    }
  }

  function shouldConstruct(Component) {
    var prototype = Component.prototype;
    return !!(prototype && prototype.isReactComponent);
  }

  function describeUnknownElementTypeFrameInDEV(type, source, ownerFn) {

    if (type == null) {
      return '';
    }

    if (typeof type === 'function') {
      {
        return describeNativeComponentFrame(type, shouldConstruct(type));
      }
    }

    if (typeof type === 'string') {
      return describeBuiltInComponentFrame(type);
    }

    switch (type) {
      case REACT_SUSPENSE_TYPE:
        return describeBuiltInComponentFrame('Suspense');

      case REACT_SUSPENSE_LIST_TYPE:
        return describeBuiltInComponentFrame('SuspenseList');
    }

    if (typeof type === 'object') {
      switch (type.$$typeof) {
        case REACT_FORWARD_REF_TYPE:
          return describeFunctionComponentFrame(type.render);

        case REACT_MEMO_TYPE:
          // Memo may contain any component type so we recursively resolve it.
          return describeUnknownElementTypeFrameInDEV(type.type, source, ownerFn);

        case REACT_LAZY_TYPE:
          {
            var lazyComponent = type;
            var payload = lazyComponent._payload;
            var init = lazyComponent._init;

            try {
              // Lazy may contain any component type so we recursively resolve it.
              return describeUnknownElementTypeFrameInDEV(init(payload), source, ownerFn);
            } catch (x) {}
          }
      }
    }

    return '';
  }

  var hasOwnProperty = Object.prototype.hasOwnProperty;

  var loggedTypeFailures = {};
  var ReactDebugCurrentFrame = ReactSharedInternals.ReactDebugCurrentFrame;

  function setCurrentlyValidatingElement(element) {
    {
      if (element) {
        var owner = element._owner;
        var stack = describeUnknownElementTypeFrameInDEV(element.type, element._source, owner ? owner.type : null);
        ReactDebugCurrentFrame.setExtraStackFrame(stack);
      } else {
        ReactDebugCurrentFrame.setExtraStackFrame(null);
      }
    }
  }

  function checkPropTypes(typeSpecs, values, location, componentName, element) {
    {
      // $FlowFixMe This is okay but Flow doesn't know it.
      var has = Function.call.bind(hasOwnProperty);

      for (var typeSpecName in typeSpecs) {
        if (has(typeSpecs, typeSpecName)) {
          var error$1 = void 0; // Prop type validation may throw. In case they do, we don't want to
          // fail the render phase where it didn't fail before. So we log it.
          // After these have been cleaned up, we'll let them throw.

          try {
            // This is intentionally an invariant that gets caught. It's the same
            // behavior as without this statement except with a better message.
            if (typeof typeSpecs[typeSpecName] !== 'function') {
              // eslint-disable-next-line react-internal/prod-error-codes
              var err = Error((componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' + 'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.' + 'This often happens because of typos such as `PropTypes.function` instead of `PropTypes.func`.');
              err.name = 'Invariant Violation';
              throw err;
            }

            error$1 = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED');
          } catch (ex) {
            error$1 = ex;
          }

          if (error$1 && !(error$1 instanceof Error)) {
            setCurrentlyValidatingElement(element);

            error('%s: type specification of %s' + ' `%s` is invalid; the type checker ' + 'function must return `null` or an `Error` but returned a %s. ' + 'You may have forgotten to pass an argument to the type checker ' + 'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' + 'shape all require an argument).', componentName || 'React class', location, typeSpecName, typeof error$1);

            setCurrentlyValidatingElement(null);
          }

          if (error$1 instanceof Error && !(error$1.message in loggedTypeFailures)) {
            // Only monitor this failure once because there tends to be a lot of the
            // same error.
            loggedTypeFailures[error$1.message] = true;
            setCurrentlyValidatingElement(element);

            error('Failed %s type: %s', location, error$1.message);

            setCurrentlyValidatingElement(null);
          }
        }
      }
    }
  }

  var isArrayImpl = Array.isArray; // eslint-disable-next-line no-redeclare

  function isArray(a) {
    return isArrayImpl(a);
  }

  /*
   * The `'' + value` pattern (used in in perf-sensitive code) throws for Symbol
   * and Temporal.* types. See https://github.com/facebook/react/pull/22064.
   *
   * The functions in this module will throw an easier-to-understand,
   * easier-to-debug exception with a clear errors message message explaining the
   * problem. (Instead of a confusing exception thrown inside the implementation
   * of the `value` object).
   */
  // $FlowFixMe only called in DEV, so void return is not possible.
  function typeName(value) {
    {
      // toStringTag is needed for namespaced types like Temporal.Instant
      var hasToStringTag = typeof Symbol === 'function' && Symbol.toStringTag;
      var type = hasToStringTag && value[Symbol.toStringTag] || value.constructor.name || 'Object';
      return type;
    }
  } // $FlowFixMe only called in DEV, so void return is not possible.


  function willCoercionThrow(value) {
    {
      try {
        testStringCoercion(value);
        return false;
      } catch (e) {
        return true;
      }
    }
  }

  function testStringCoercion(value) {
    // If you ended up here by following an exception call stack, here's what's
    // happened: you supplied an object or symbol value to React (as a prop, key,
    // DOM attribute, CSS property, string ref, etc.) and when React tried to
    // coerce it to a string using `'' + value`, an exception was thrown.
    //
    // The most common types that will cause this exception are `Symbol` instances
    // and Temporal objects like `Temporal.Instant`. But any object that has a
    // `valueOf` or `[Symbol.toPrimitive]` method that throws will also cause this
    // exception. (Library authors do this to prevent users from using built-in
    // numeric operators like `+` or comparison operators like `>=` because custom
    // methods are needed to perform accurate arithmetic or comparison.)
    //
    // To fix the problem, coerce this object or symbol value to a string before
    // passing it to React. The most reliable way is usually `String(value)`.
    //
    // To find which value is throwing, check the browser or debugger console.
    // Before this exception was thrown, there should be `console.error` output
    // that shows the type (Symbol, Temporal.PlainDate, etc.) that caused the
    // problem and how that type was used: key, atrribute, input value prop, etc.
    // In most cases, this console output also shows the component and its
    // ancestor components where the exception happened.
    //
    // eslint-disable-next-line react-internal/safe-string-coercion
    return '' + value;
  }
  function checkKeyStringCoercion(value) {
    {
      if (willCoercionThrow(value)) {
        error('The provided key is an unsupported type %s.' + ' This value must be coerced to a string before before using it here.', typeName(value));

        return testStringCoercion(value); // throw (to help callers find troubleshooting comments)
      }
    }
  }

  var ReactCurrentOwner = ReactSharedInternals.ReactCurrentOwner;
  var RESERVED_PROPS = {
    key: true,
    ref: true,
    __self: true,
    __source: true
  };
  var specialPropKeyWarningShown;
  var specialPropRefWarningShown;
  var didWarnAboutStringRefs;

  {
    didWarnAboutStringRefs = {};
  }

  function hasValidRef(config) {
    {
      if (hasOwnProperty.call(config, 'ref')) {
        var getter = Object.getOwnPropertyDescriptor(config, 'ref').get;

        if (getter && getter.isReactWarning) {
          return false;
        }
      }
    }

    return config.ref !== undefined;
  }

  function hasValidKey(config) {
    {
      if (hasOwnProperty.call(config, 'key')) {
        var getter = Object.getOwnPropertyDescriptor(config, 'key').get;

        if (getter && getter.isReactWarning) {
          return false;
        }
      }
    }

    return config.key !== undefined;
  }

  function warnIfStringRefCannotBeAutoConverted(config, self) {
    {
      if (typeof config.ref === 'string' && ReactCurrentOwner.current && self && ReactCurrentOwner.current.stateNode !== self) {
        var componentName = getComponentNameFromType(ReactCurrentOwner.current.type);

        if (!didWarnAboutStringRefs[componentName]) {
          error('Component "%s" contains the string ref "%s". ' + 'Support for string refs will be removed in a future major release. ' + 'This case cannot be automatically converted to an arrow function. ' + 'We ask you to manually fix this case by using useRef() or createRef() instead. ' + 'Learn more about using refs safely here: ' + 'https://reactjs.org/link/strict-mode-string-ref', getComponentNameFromType(ReactCurrentOwner.current.type), config.ref);

          didWarnAboutStringRefs[componentName] = true;
        }
      }
    }
  }

  function defineKeyPropWarningGetter(props, displayName) {
    {
      var warnAboutAccessingKey = function () {
        if (!specialPropKeyWarningShown) {
          specialPropKeyWarningShown = true;

          error('%s: `key` is not a prop. Trying to access it will result ' + 'in `undefined` being returned. If you need to access the same ' + 'value within the child component, you should pass it as a different ' + 'prop. (https://reactjs.org/link/special-props)', displayName);
        }
      };

      warnAboutAccessingKey.isReactWarning = true;
      Object.defineProperty(props, 'key', {
        get: warnAboutAccessingKey,
        configurable: true
      });
    }
  }

  function defineRefPropWarningGetter(props, displayName) {
    {
      var warnAboutAccessingRef = function () {
        if (!specialPropRefWarningShown) {
          specialPropRefWarningShown = true;

          error('%s: `ref` is not a prop. Trying to access it will result ' + 'in `undefined` being returned. If you need to access the same ' + 'value within the child component, you should pass it as a different ' + 'prop. (https://reactjs.org/link/special-props)', displayName);
        }
      };

      warnAboutAccessingRef.isReactWarning = true;
      Object.defineProperty(props, 'ref', {
        get: warnAboutAccessingRef,
        configurable: true
      });
    }
  }
  /**
   * Factory method to create a new React element. This no longer adheres to
   * the class pattern, so do not use new to call it. Also, instanceof check
   * will not work. Instead test $$typeof field against Symbol.for('react.element') to check
   * if something is a React Element.
   *
   * @param {*} type
   * @param {*} props
   * @param {*} key
   * @param {string|object} ref
   * @param {*} owner
   * @param {*} self A *temporary* helper to detect places where `this` is
   * different from the `owner` when React.createElement is called, so that we
   * can warn. We want to get rid of owner and replace string `ref`s with arrow
   * functions, and as long as `this` and owner are the same, there will be no
   * change in behavior.
   * @param {*} source An annotation object (added by a transpiler or otherwise)
   * indicating filename, line number, and/or other information.
   * @internal
   */


  var ReactElement = function (type, key, ref, self, source, owner, props) {
    var element = {
      // This tag allows us to uniquely identify this as a React Element
      $$typeof: REACT_ELEMENT_TYPE,
      // Built-in properties that belong on the element
      type: type,
      key: key,
      ref: ref,
      props: props,
      // Record the component responsible for creating this element.
      _owner: owner
    };

    {
      // The validation flag is currently mutative. We put it on
      // an external backing store so that we can freeze the whole object.
      // This can be replaced with a WeakMap once they are implemented in
      // commonly used development environments.
      element._store = {}; // To make comparing ReactElements easier for testing purposes, we make
      // the validation flag non-enumerable (where possible, which should
      // include every environment we run tests in), so the test framework
      // ignores it.

      Object.defineProperty(element._store, 'validated', {
        configurable: false,
        enumerable: false,
        writable: true,
        value: false
      }); // self and source are DEV only properties.

      Object.defineProperty(element, '_self', {
        configurable: false,
        enumerable: false,
        writable: false,
        value: self
      }); // Two elements created in two different places should be considered
      // equal for testing purposes and therefore we hide it from enumeration.

      Object.defineProperty(element, '_source', {
        configurable: false,
        enumerable: false,
        writable: false,
        value: source
      });

      if (Object.freeze) {
        Object.freeze(element.props);
        Object.freeze(element);
      }
    }

    return element;
  };
  /**
   * https://github.com/reactjs/rfcs/pull/107
   * @param {*} type
   * @param {object} props
   * @param {string} key
   */

  function jsxDEV(type, config, maybeKey, source, self) {
    {
      var propName; // Reserved names are extracted

      var props = {};
      var key = null;
      var ref = null; // Currently, key can be spread in as a prop. This causes a potential
      // issue if key is also explicitly declared (ie. <div {...props} key="Hi" />
      // or <div key="Hi" {...props} /> ). We want to deprecate key spread,
      // but as an intermediary step, we will use jsxDEV for everything except
      // <div {...props} key="Hi" />, because we aren't currently able to tell if
      // key is explicitly declared to be undefined or not.

      if (maybeKey !== undefined) {
        {
          checkKeyStringCoercion(maybeKey);
        }

        key = '' + maybeKey;
      }

      if (hasValidKey(config)) {
        {
          checkKeyStringCoercion(config.key);
        }

        key = '' + config.key;
      }

      if (hasValidRef(config)) {
        ref = config.ref;
        warnIfStringRefCannotBeAutoConverted(config, self);
      } // Remaining properties are added to a new props object


      for (propName in config) {
        if (hasOwnProperty.call(config, propName) && !RESERVED_PROPS.hasOwnProperty(propName)) {
          props[propName] = config[propName];
        }
      } // Resolve default props


      if (type && type.defaultProps) {
        var defaultProps = type.defaultProps;

        for (propName in defaultProps) {
          if (props[propName] === undefined) {
            props[propName] = defaultProps[propName];
          }
        }
      }

      if (key || ref) {
        var displayName = typeof type === 'function' ? type.displayName || type.name || 'Unknown' : type;

        if (key) {
          defineKeyPropWarningGetter(props, displayName);
        }

        if (ref) {
          defineRefPropWarningGetter(props, displayName);
        }
      }

      return ReactElement(type, key, ref, self, source, ReactCurrentOwner.current, props);
    }
  }

  var ReactCurrentOwner$1 = ReactSharedInternals.ReactCurrentOwner;
  var ReactDebugCurrentFrame$1 = ReactSharedInternals.ReactDebugCurrentFrame;

  function setCurrentlyValidatingElement$1(element) {
    {
      if (element) {
        var owner = element._owner;
        var stack = describeUnknownElementTypeFrameInDEV(element.type, element._source, owner ? owner.type : null);
        ReactDebugCurrentFrame$1.setExtraStackFrame(stack);
      } else {
        ReactDebugCurrentFrame$1.setExtraStackFrame(null);
      }
    }
  }

  var propTypesMisspellWarningShown;

  {
    propTypesMisspellWarningShown = false;
  }
  /**
   * Verifies the object is a ReactElement.
   * See https://reactjs.org/docs/react-api.html#isvalidelement
   * @param {?object} object
   * @return {boolean} True if `object` is a ReactElement.
   * @final
   */


  function isValidElement(object) {
    {
      return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
    }
  }

  function getDeclarationErrorAddendum() {
    {
      if (ReactCurrentOwner$1.current) {
        var name = getComponentNameFromType(ReactCurrentOwner$1.current.type);

        if (name) {
          return '\n\nCheck the render method of `' + name + '`.';
        }
      }

      return '';
    }
  }

  function getSourceInfoErrorAddendum(source) {
    {
      if (source !== undefined) {
        var fileName = source.fileName.replace(/^.*[\\\/]/, '');
        var lineNumber = source.lineNumber;
        return '\n\nCheck your code at ' + fileName + ':' + lineNumber + '.';
      }

      return '';
    }
  }
  /**
   * Warn if there's no key explicitly set on dynamic arrays of children or
   * object keys are not valid. This allows us to keep track of children between
   * updates.
   */


  var ownerHasKeyUseWarning = {};

  function getCurrentComponentErrorInfo(parentType) {
    {
      var info = getDeclarationErrorAddendum();

      if (!info) {
        var parentName = typeof parentType === 'string' ? parentType : parentType.displayName || parentType.name;

        if (parentName) {
          info = "\n\nCheck the top-level render call using <" + parentName + ">.";
        }
      }

      return info;
    }
  }
  /**
   * Warn if the element doesn't have an explicit key assigned to it.
   * This element is in an array. The array could grow and shrink or be
   * reordered. All children that haven't already been validated are required to
   * have a "key" property assigned to it. Error statuses are cached so a warning
   * will only be shown once.
   *
   * @internal
   * @param {ReactElement} element Element that requires a key.
   * @param {*} parentType element's parent's type.
   */


  function validateExplicitKey(element, parentType) {
    {
      if (!element._store || element._store.validated || element.key != null) {
        return;
      }

      element._store.validated = true;
      var currentComponentErrorInfo = getCurrentComponentErrorInfo(parentType);

      if (ownerHasKeyUseWarning[currentComponentErrorInfo]) {
        return;
      }

      ownerHasKeyUseWarning[currentComponentErrorInfo] = true; // Usually the current owner is the offender, but if it accepts children as a
      // property, it may be the creator of the child that's responsible for
      // assigning it a key.

      var childOwner = '';

      if (element && element._owner && element._owner !== ReactCurrentOwner$1.current) {
        // Give the component that originally created this child.
        childOwner = " It was passed a child from " + getComponentNameFromType(element._owner.type) + ".";
      }

      setCurrentlyValidatingElement$1(element);

      error('Each child in a list should have a unique "key" prop.' + '%s%s See https://reactjs.org/link/warning-keys for more information.', currentComponentErrorInfo, childOwner);

      setCurrentlyValidatingElement$1(null);
    }
  }
  /**
   * Ensure that every element either is passed in a static location, in an
   * array with an explicit keys property defined, or in an object literal
   * with valid key property.
   *
   * @internal
   * @param {ReactNode} node Statically passed child of any type.
   * @param {*} parentType node's parent's type.
   */


  function validateChildKeys(node, parentType) {
    {
      if (typeof node !== 'object') {
        return;
      }

      if (isArray(node)) {
        for (var i = 0; i < node.length; i++) {
          var child = node[i];

          if (isValidElement(child)) {
            validateExplicitKey(child, parentType);
          }
        }
      } else if (isValidElement(node)) {
        // This element was passed in a valid location.
        if (node._store) {
          node._store.validated = true;
        }
      } else if (node) {
        var iteratorFn = getIteratorFn(node);

        if (typeof iteratorFn === 'function') {
          // Entry iterators used to provide implicit keys,
          // but now we print a separate warning for them later.
          if (iteratorFn !== node.entries) {
            var iterator = iteratorFn.call(node);
            var step;

            while (!(step = iterator.next()).done) {
              if (isValidElement(step.value)) {
                validateExplicitKey(step.value, parentType);
              }
            }
          }
        }
      }
    }
  }
  /**
   * Given an element, validate that its props follow the propTypes definition,
   * provided by the type.
   *
   * @param {ReactElement} element
   */


  function validatePropTypes(element) {
    {
      var type = element.type;

      if (type === null || type === undefined || typeof type === 'string') {
        return;
      }

      var propTypes;

      if (typeof type === 'function') {
        propTypes = type.propTypes;
      } else if (typeof type === 'object' && (type.$$typeof === REACT_FORWARD_REF_TYPE || // Note: Memo only checks outer props here.
      // Inner props are checked in the reconciler.
      type.$$typeof === REACT_MEMO_TYPE)) {
        propTypes = type.propTypes;
      } else {
        return;
      }

      if (propTypes) {
        // Intentionally inside to avoid triggering lazy initializers:
        var name = getComponentNameFromType(type);
        checkPropTypes(propTypes, element.props, 'prop', name, element);
      } else if (type.PropTypes !== undefined && !propTypesMisspellWarningShown) {
        propTypesMisspellWarningShown = true; // Intentionally inside to avoid triggering lazy initializers:

        var _name = getComponentNameFromType(type);

        error('Component %s declared `PropTypes` instead of `propTypes`. Did you misspell the property assignment?', _name || 'Unknown');
      }

      if (typeof type.getDefaultProps === 'function' && !type.getDefaultProps.isReactClassApproved) {
        error('getDefaultProps is only used on classic React.createClass ' + 'definitions. Use a static property named `defaultProps` instead.');
      }
    }
  }
  /**
   * Given a fragment, validate that it can only be provided with fragment props
   * @param {ReactElement} fragment
   */


  function validateFragmentProps(fragment) {
    {
      var keys = Object.keys(fragment.props);

      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];

        if (key !== 'children' && key !== 'key') {
          setCurrentlyValidatingElement$1(fragment);

          error('Invalid prop `%s` supplied to `React.Fragment`. ' + 'React.Fragment can only have `key` and `children` props.', key);

          setCurrentlyValidatingElement$1(null);
          break;
        }
      }

      if (fragment.ref !== null) {
        setCurrentlyValidatingElement$1(fragment);

        error('Invalid attribute `ref` supplied to `React.Fragment`.');

        setCurrentlyValidatingElement$1(null);
      }
    }
  }

  function jsxWithValidation(type, props, key, isStaticChildren, source, self) {
    {
      var validType = isValidElementType(type); // We warn in this case but don't throw. We expect the element creation to
      // succeed and there will likely be errors in render.

      if (!validType) {
        var info = '';

        if (type === undefined || typeof type === 'object' && type !== null && Object.keys(type).length === 0) {
          info += ' You likely forgot to export your component from the file ' + "it's defined in, or you might have mixed up default and named imports.";
        }

        var sourceInfo = getSourceInfoErrorAddendum(source);

        if (sourceInfo) {
          info += sourceInfo;
        } else {
          info += getDeclarationErrorAddendum();
        }

        var typeString;

        if (type === null) {
          typeString = 'null';
        } else if (isArray(type)) {
          typeString = 'array';
        } else if (type !== undefined && type.$$typeof === REACT_ELEMENT_TYPE) {
          typeString = "<" + (getComponentNameFromType(type.type) || 'Unknown') + " />";
          info = ' Did you accidentally export a JSX literal instead of a component?';
        } else {
          typeString = typeof type;
        }

        error('React.jsx: type is invalid -- expected a string (for ' + 'built-in components) or a class/function (for composite ' + 'components) but got: %s.%s', typeString, info);
      }

      var element = jsxDEV(type, props, key, source, self); // The result can be nullish if a mock or a custom function is used.
      // TODO: Drop this when these are no longer allowed as the type argument.

      if (element == null) {
        return element;
      } // Skip key warning if the type isn't valid since our key validation logic
      // doesn't expect a non-string/function type and can throw confusing errors.
      // We don't want exception behavior to differ between dev and prod.
      // (Rendering will throw with a helpful message and as soon as the type is
      // fixed, the key warnings will appear.)


      if (validType) {
        var children = props.children;

        if (children !== undefined) {
          if (isStaticChildren) {
            if (isArray(children)) {
              for (var i = 0; i < children.length; i++) {
                validateChildKeys(children[i], type);
              }

              if (Object.freeze) {
                Object.freeze(children);
              }
            } else {
              error('React.jsx: Static children should always be an array. ' + 'You are likely explicitly calling React.jsxs or React.jsxDEV. ' + 'Use the Babel transform instead.');
            }
          } else {
            validateChildKeys(children, type);
          }
        }
      }

      if (type === REACT_FRAGMENT_TYPE) {
        validateFragmentProps(element);
      } else {
        validatePropTypes(element);
      }

      return element;
    }
  } // These two functions exist to still get child warnings in dev
  // even with the prod transform. This means that jsxDEV is purely
  // opt-in behavior for better messages but that we won't stop
  // giving you warnings if you use production apis.

  function jsxWithValidationStatic(type, props, key) {
    {
      return jsxWithValidation(type, props, key, true);
    }
  }
  function jsxWithValidationDynamic(type, props, key) {
    {
      return jsxWithValidation(type, props, key, false);
    }
  }

  var jsx =  jsxWithValidationDynamic ; // we may want to special case jsxs internally to take advantage of static children.
  // for now we can ship identical prod functions

  var jsxs =  jsxWithValidationStatic ;

  exports.Fragment = REACT_FRAGMENT_TYPE;
  exports.jsx = jsx;
  exports.jsxs = jsxs;
    })();
  }
  });
  reactJsxRuntime_development.Fragment;
  reactJsxRuntime_development.jsx;
  reactJsxRuntime_development.jsxs;

  var jsxRuntime = createCommonjsModule(function (module) {

  {
    module.exports = reactJsxRuntime_development;
  }
  });
  var jsxRuntime_1 = jsxRuntime.jsx;
  var jsxRuntime_2 = jsxRuntime.jsxs;

  var cache;
  if ((typeof document === "undefined" ? "undefined" : _typeof(document)) === 'object') {
    cache = createCache({
      key: 'css',
      prepend: true
    });
  }
  function StyledEngineProvider(props) {
    var injectFirst = props.injectFirst,
      children = props.children;
    return injectFirst && cache ? /*#__PURE__*/jsxRuntime_1(CacheProvider, {
      value: cache,
      children: children
    }) : children;
  }
  StyledEngineProvider.propTypes = {
    /**
     * Your component tree.
     */
    children: PropTypes.node,
    /**
     * By default, the styles are injected last in the <head> element of the page.
     * As a result, they gain more specificity than any other style sheet.
     * If you want to override MUI's styles, set this prop.
     */
    injectFirst: PropTypes.bool
  } ;

  function isEmpty$3(obj) {
    return obj === undefined || obj === null || Object.keys(obj).length === 0;
  }
  function GlobalStyles$2(props) {
    var styles = props.styles,
      _props$defaultTheme = props.defaultTheme,
      defaultTheme = _props$defaultTheme === void 0 ? {} : _props$defaultTheme;
    var globalStyles = typeof styles === 'function' ? function (themeInput) {
      return styles(isEmpty$3(themeInput) ? defaultTheme : themeInput);
    } : styles;
    return /*#__PURE__*/jsxRuntime_1(Global, {
      styles: globalStyles
    });
  }
  GlobalStyles$2.propTypes = {
    defaultTheme: PropTypes.object,
    styles: PropTypes.oneOfType([PropTypes.array, PropTypes.string, PropTypes.object, PropTypes.func])
  } ;

  function styled$3(tag, options) {
    var stylesFactory = newStyled(tag, options);
    {
      return function () {
        var component = typeof tag === 'string' ? "\"".concat(tag, "\"") : 'component';
        for (var _len = arguments.length, styles = new Array(_len), _key = 0; _key < _len; _key++) {
          styles[_key] = arguments[_key];
        }
        if (styles.length === 0) {
          console.error(["MUI: Seems like you called `styled(".concat(component, ")()` without a `style` argument."), 'You must provide a `styles` argument: `styled("div")(styleYouForgotToPass)`.'].join('\n'));
        } else if (styles.some(function (style) {
          return style === undefined;
        })) {
          console.error("MUI: the styled(".concat(component, ")(...args) API requires all its args to be defined."));
        }
        return stylesFactory.apply(void 0, styles);
      };
    }
  }

  // eslint-disable-next-line @typescript-eslint/naming-convention
  var internal_processStyles = function internal_processStyles(tag, processor) {
    // Emotion attaches all the styles as `__emotion_styles`.
    // Ref: https://github.com/emotion-js/emotion/blob/16d971d0da229596d6bcc39d282ba9753c9ee7cf/packages/styled/src/base.js#L186
    if (Array.isArray(tag.__emotion_styles)) {
      tag.__emotion_styles = processor(tag.__emotion_styles);
    }
  };

  // https://github.com/sindresorhus/is-plain-obj/blob/main/index.js
  function isPlainObject(item) {
    if (_typeof(item) !== 'object' || item === null) {
      return false;
    }
    var prototype = Object.getPrototypeOf(item);
    return (prototype === null || prototype === Object.prototype || Object.getPrototypeOf(prototype) === null) && !(Symbol.toStringTag in item) && !(Symbol.iterator in item);
  }
  function deepClone(source) {
    if (!isPlainObject(source)) {
      return source;
    }
    var output = {};
    Object.keys(source).forEach(function (key) {
      output[key] = deepClone(source[key]);
    });
    return output;
  }
  function deepmerge(target, source) {
    var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {
      clone: true
    };
    var output = options.clone ? _extends({}, target) : target;
    if (isPlainObject(target) && isPlainObject(source)) {
      Object.keys(source).forEach(function (key) {
        // Avoid prototype pollution
        if (key === '__proto__') {
          return;
        }
        if (isPlainObject(source[key]) && key in target && isPlainObject(target[key])) {
          // Since `output` is a clone of `target` and we have narrowed `target` in this block we can cast to the same type.
          output[key] = deepmerge(target[key], source[key], options);
        } else if (options.clone) {
          output[key] = isPlainObject(source[key]) ? deepClone(source[key]) : source[key];
        } else {
          output[key] = source[key];
        }
      });
    }
    return output;
  }

  var sortBreakpointsValues = function sortBreakpointsValues(values) {
    var breakpointsAsArray = Object.keys(values).map(function (key) {
      return {
        key: key,
        val: values[key]
      };
    }) || [];
    // Sort in ascending order
    breakpointsAsArray.sort(function (breakpoint1, breakpoint2) {
      return breakpoint1.val - breakpoint2.val;
    });
    return breakpointsAsArray.reduce(function (acc, obj) {
      return _extends({}, acc, _defineProperty({}, obj.key, obj.val));
    }, {});
  };

  // Keep in mind that @media is inclusive by the CSS specification.
  function createBreakpoints(breakpoints) {
    var _breakpoints$values = breakpoints.values,
      values = _breakpoints$values === void 0 ? {
        xs: 0,
        // phone
        sm: 600,
        // tablet
        md: 900,
        // small laptop
        lg: 1200,
        // desktop
        xl: 1536 // large screen
      } : _breakpoints$values,
      _breakpoints$unit = breakpoints.unit,
      unit = _breakpoints$unit === void 0 ? 'px' : _breakpoints$unit,
      _breakpoints$step = breakpoints.step,
      step = _breakpoints$step === void 0 ? 5 : _breakpoints$step,
      other = _objectWithoutProperties(breakpoints, ["values", "unit", "step"]);
    var sortedValues = sortBreakpointsValues(values);
    var keys = Object.keys(sortedValues);
    function up(key) {
      var value = typeof values[key] === 'number' ? values[key] : key;
      return "@media (min-width:".concat(value).concat(unit, ")");
    }
    function down(key) {
      var value = typeof values[key] === 'number' ? values[key] : key;
      return "@media (max-width:".concat(value - step / 100).concat(unit, ")");
    }
    function between(start, end) {
      var endIndex = keys.indexOf(end);
      return "@media (min-width:".concat(typeof values[start] === 'number' ? values[start] : start).concat(unit, ") and ") + "(max-width:".concat((endIndex !== -1 && typeof values[keys[endIndex]] === 'number' ? values[keys[endIndex]] : end) - step / 100).concat(unit, ")");
    }
    function only(key) {
      if (keys.indexOf(key) + 1 < keys.length) {
        return between(key, keys[keys.indexOf(key) + 1]);
      }
      return up(key);
    }
    function not(key) {
      // handle first and last key separately, for better readability
      var keyIndex = keys.indexOf(key);
      if (keyIndex === 0) {
        return up(keys[1]);
      }
      if (keyIndex === keys.length - 1) {
        return down(keys[keyIndex]);
      }
      return between(key, keys[keys.indexOf(key) + 1]).replace('@media', '@media not all and');
    }
    return _extends({
      keys: keys,
      values: sortedValues,
      up: up,
      down: down,
      between: between,
      only: only,
      not: not,
      unit: unit
    }, other);
  }

  var shape = {
    borderRadius: 4
  };
  var shape$1 = shape;

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _iterableToArrayLimit(r, l) {
    var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"];
    if (null != t) {
      var e,
        n,
        i,
        u,
        a = [],
        f = !0,
        o = !1;
      try {
        if (i = (t = t.call(r)).next, 0 === l) {
          if (Object(t) !== t) return;
          f = !1;
        } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0);
      } catch (r) {
        o = !0, n = r;
      } finally {
        try {
          if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return;
        } finally {
          if (o) throw n;
        }
      }
      return a;
    }
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;
    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
    return arr2;
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
  }

  var responsivePropType = PropTypes.oneOfType([PropTypes.number, PropTypes.string, PropTypes.object, PropTypes.array]) ;
  var responsivePropType$1 = responsivePropType;

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }

  function merge(acc, item) {
    if (!item) {
      return acc;
    }
    return deepmerge(acc, item, {
      clone: false // No need to clone deep, it's way faster.
    });
  }

  // The breakpoint **start** at this value.
  // For instance with the first breakpoint xs: [xs, sm[.
  var values$1 = {
    xs: 0,
    // phone
    sm: 600,
    // tablet
    md: 900,
    // small laptop
    lg: 1200,
    // desktop
    xl: 1536 // large screen
  };
  var defaultBreakpoints = {
    // Sorted ASC by size. That's important.
    // It can't be configured as it's used statically for propTypes.
    keys: ['xs', 'sm', 'md', 'lg', 'xl'],
    up: function up(key) {
      return "@media (min-width:".concat(values$1[key], "px)");
    }
  };
  function handleBreakpoints(props, propValue, styleFromPropValue) {
    var theme = props.theme || {};
    if (Array.isArray(propValue)) {
      var themeBreakpoints = theme.breakpoints || defaultBreakpoints;
      return propValue.reduce(function (acc, item, index) {
        acc[themeBreakpoints.up(themeBreakpoints.keys[index])] = styleFromPropValue(propValue[index]);
        return acc;
      }, {});
    }
    if (_typeof(propValue) === 'object') {
      var _themeBreakpoints = theme.breakpoints || defaultBreakpoints;
      return Object.keys(propValue).reduce(function (acc, breakpoint) {
        // key is breakpoint
        if (Object.keys(_themeBreakpoints.values || values$1).indexOf(breakpoint) !== -1) {
          var mediaKey = _themeBreakpoints.up(breakpoint);
          acc[mediaKey] = styleFromPropValue(propValue[breakpoint], breakpoint);
        } else {
          var cssKey = breakpoint;
          acc[cssKey] = propValue[cssKey];
        }
        return acc;
      }, {});
    }
    var output = styleFromPropValue(propValue);
    return output;
  }
  function createEmptyBreakpointObject() {
    var _breakpointsInput$key;
    var breakpointsInput = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var breakpointsInOrder = (_breakpointsInput$key = breakpointsInput.keys) == null ? void 0 : _breakpointsInput$key.reduce(function (acc, key) {
      var breakpointStyleKey = breakpointsInput.up(key);
      acc[breakpointStyleKey] = {};
      return acc;
    }, {});
    return breakpointsInOrder || {};
  }
  function removeUnusedBreakpoints(breakpointKeys, style) {
    return breakpointKeys.reduce(function (acc, key) {
      var breakpointOutput = acc[key];
      var isBreakpointUnused = !breakpointOutput || Object.keys(breakpointOutput).length === 0;
      if (isBreakpointUnused) {
        delete acc[key];
      }
      return acc;
    }, style);
  }
  function mergeBreakpointsInOrder(breakpointsInput) {
    var emptyBreakpoints = createEmptyBreakpointObject(breakpointsInput);
    for (var _len = arguments.length, styles = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      styles[_key - 1] = arguments[_key];
    }
    var mergedOutput = [emptyBreakpoints].concat(styles).reduce(function (prev, next) {
      return deepmerge(prev, next);
    }, {});
    return removeUnusedBreakpoints(Object.keys(emptyBreakpoints), mergedOutput);
  }

  // compute base for responsive values; e.g.,
  // [1,2,3] => {xs: true, sm: true, md: true}
  // {xs: 1, sm: 2, md: 3} => {xs: true, sm: true, md: true}
  function computeBreakpointsBase(breakpointValues, themeBreakpoints) {
    // fixed value
    if (_typeof(breakpointValues) !== 'object') {
      return {};
    }
    var base = {};
    var breakpointsKeys = Object.keys(themeBreakpoints);
    if (Array.isArray(breakpointValues)) {
      breakpointsKeys.forEach(function (breakpoint, i) {
        if (i < breakpointValues.length) {
          base[breakpoint] = true;
        }
      });
    } else {
      breakpointsKeys.forEach(function (breakpoint) {
        if (breakpointValues[breakpoint] != null) {
          base[breakpoint] = true;
        }
      });
    }
    return base;
  }
  function resolveBreakpointValues(_ref) {
    var breakpointValues = _ref.values,
      themeBreakpoints = _ref.breakpoints,
      customBase = _ref.base;
    var base = customBase || computeBreakpointsBase(breakpointValues, themeBreakpoints);
    var keys = Object.keys(base);
    if (keys.length === 0) {
      return breakpointValues;
    }
    var previous;
    return keys.reduce(function (acc, breakpoint, i) {
      if (Array.isArray(breakpointValues)) {
        acc[breakpoint] = breakpointValues[i] != null ? breakpointValues[i] : breakpointValues[previous];
        previous = i;
      } else if (_typeof(breakpointValues) === 'object') {
        acc[breakpoint] = breakpointValues[breakpoint] != null ? breakpointValues[breakpoint] : breakpointValues[previous];
        previous = breakpoint;
      } else {
        acc[breakpoint] = breakpointValues;
      }
      return acc;
    }, {});
  }

  // It should to be noted that this function isn't equivalent to `text-transform: capitalize`.
  //
  // A strict capitalization should uppercase the first letter of each word in the sentence.
  // We only handle the first word.
  function capitalize(string) {
    if (typeof string !== 'string') {
      throw new Error("MUI: `capitalize(string)` expects a string argument." );
    }
    return string.charAt(0).toUpperCase() + string.slice(1);
  }

  function getPath(obj, path) {
    var checkVars = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    if (!path || typeof path !== 'string') {
      return null;
    }

    // Check if CSS variables are used
    if (obj && obj.vars && checkVars) {
      var val = "vars.".concat(path).split('.').reduce(function (acc, item) {
        return acc && acc[item] ? acc[item] : null;
      }, obj);
      if (val != null) {
        return val;
      }
    }
    return path.split('.').reduce(function (acc, item) {
      if (acc && acc[item] != null) {
        return acc[item];
      }
      return null;
    }, obj);
  }
  function getStyleValue$1(themeMapping, transform, propValueFinal) {
    var userValue = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : propValueFinal;
    var value;
    if (typeof themeMapping === 'function') {
      value = themeMapping(propValueFinal);
    } else if (Array.isArray(themeMapping)) {
      value = themeMapping[propValueFinal] || userValue;
    } else {
      value = getPath(themeMapping, propValueFinal) || userValue;
    }
    if (transform) {
      value = transform(value, userValue, themeMapping);
    }
    return value;
  }
  function style$2(options) {
    var prop = options.prop,
      _options$cssProperty = options.cssProperty,
      cssProperty = _options$cssProperty === void 0 ? options.prop : _options$cssProperty,
      themeKey = options.themeKey,
      transform = options.transform; // false positive
    // eslint-disable-next-line react/function-component-definition
    var fn = function fn(props) {
      if (props[prop] == null) {
        return null;
      }
      var propValue = props[prop];
      var theme = props.theme;
      var themeMapping = getPath(theme, themeKey) || {};
      var styleFromPropValue = function styleFromPropValue(propValueFinal) {
        var value = getStyleValue$1(themeMapping, transform, propValueFinal);
        if (propValueFinal === value && typeof propValueFinal === 'string') {
          // Haven't found value
          value = getStyleValue$1(themeMapping, transform, "".concat(prop).concat(propValueFinal === 'default' ? '' : capitalize(propValueFinal)), propValueFinal);
        }
        if (cssProperty === false) {
          return value;
        }
        return _defineProperty({}, cssProperty, value);
      };
      return handleBreakpoints(props, propValue, styleFromPropValue);
    };
    fn.propTypes = _defineProperty({}, prop, responsivePropType$1) ;
    fn.filterProps = [prop];
    return fn;
  }

  function memoize(fn) {
    var cache = {};
    return function (arg) {
      if (cache[arg] === undefined) {
        cache[arg] = fn(arg);
      }
      return cache[arg];
    };
  }

  var properties = {
    m: 'margin',
    p: 'padding'
  };
  var directions = {
    t: 'Top',
    r: 'Right',
    b: 'Bottom',
    l: 'Left',
    x: ['Left', 'Right'],
    y: ['Top', 'Bottom']
  };
  var aliases = {
    marginX: 'mx',
    marginY: 'my',
    paddingX: 'px',
    paddingY: 'py'
  };

  // memoize() impact:
  // From 300,000 ops/sec
  // To 350,000 ops/sec
  var getCssProperties = memoize(function (prop) {
    // It's not a shorthand notation.
    if (prop.length > 2) {
      if (aliases[prop]) {
        prop = aliases[prop];
      } else {
        return [prop];
      }
    }
    var _prop$split = prop.split(''),
      _prop$split2 = _slicedToArray(_prop$split, 2),
      a = _prop$split2[0],
      b = _prop$split2[1];
    var property = properties[a];
    var direction = directions[b] || '';
    return Array.isArray(direction) ? direction.map(function (dir) {
      return property + dir;
    }) : [property + direction];
  });
  var marginKeys = ['m', 'mt', 'mr', 'mb', 'ml', 'mx', 'my', 'margin', 'marginTop', 'marginRight', 'marginBottom', 'marginLeft', 'marginX', 'marginY', 'marginInline', 'marginInlineStart', 'marginInlineEnd', 'marginBlock', 'marginBlockStart', 'marginBlockEnd'];
  var paddingKeys = ['p', 'pt', 'pr', 'pb', 'pl', 'px', 'py', 'padding', 'paddingTop', 'paddingRight', 'paddingBottom', 'paddingLeft', 'paddingX', 'paddingY', 'paddingInline', 'paddingInlineStart', 'paddingInlineEnd', 'paddingBlock', 'paddingBlockStart', 'paddingBlockEnd'];
  var spacingKeys = [].concat(marginKeys, paddingKeys);
  function createUnaryUnit(theme, themeKey, defaultValue, propName) {
    var _getPath;
    var themeSpacing = (_getPath = getPath(theme, themeKey, false)) != null ? _getPath : defaultValue;
    if (typeof themeSpacing === 'number') {
      return function (abs) {
        if (typeof abs === 'string') {
          return abs;
        }
        {
          if (typeof abs !== 'number') {
            console.error("MUI: Expected ".concat(propName, " argument to be a number or a string, got ").concat(abs, "."));
          }
        }
        return themeSpacing * abs;
      };
    }
    if (Array.isArray(themeSpacing)) {
      return function (abs) {
        if (typeof abs === 'string') {
          return abs;
        }
        {
          if (!Number.isInteger(abs)) {
            console.error(["MUI: The `theme.".concat(themeKey, "` array type cannot be combined with non integer values.") + "You should either use an integer value that can be used as index, or define the `theme.".concat(themeKey, "` as a number.")].join('\n'));
          } else if (abs > themeSpacing.length - 1) {
            console.error(["MUI: The value provided (".concat(abs, ") overflows."), "The supported values are: ".concat(JSON.stringify(themeSpacing), "."), "".concat(abs, " > ").concat(themeSpacing.length - 1, ", you need to add the missing values.")].join('\n'));
          }
        }
        return themeSpacing[abs];
      };
    }
    if (typeof themeSpacing === 'function') {
      return themeSpacing;
    }
    {
      console.error(["MUI: The `theme.".concat(themeKey, "` value (").concat(themeSpacing, ") is invalid."), 'It should be a number, an array or a function.'].join('\n'));
    }
    return function () {
      return undefined;
    };
  }
  function createUnarySpacing(theme) {
    return createUnaryUnit(theme, 'spacing', 8, 'spacing');
  }
  function getValue(transformer, propValue) {
    if (typeof propValue === 'string' || propValue == null) {
      return propValue;
    }
    var abs = Math.abs(propValue);
    var transformed = transformer(abs);
    if (propValue >= 0) {
      return transformed;
    }
    if (typeof transformed === 'number') {
      return -transformed;
    }
    return "-".concat(transformed);
  }
  function getStyleFromPropValue(cssProperties, transformer) {
    return function (propValue) {
      return cssProperties.reduce(function (acc, cssProperty) {
        acc[cssProperty] = getValue(transformer, propValue);
        return acc;
      }, {});
    };
  }
  function resolveCssProperty(props, keys, prop, transformer) {
    // Using a hash computation over an array iteration could be faster, but with only 28 items,
    // it's doesn't worth the bundle size.
    if (keys.indexOf(prop) === -1) {
      return null;
    }
    var cssProperties = getCssProperties(prop);
    var styleFromPropValue = getStyleFromPropValue(cssProperties, transformer);
    var propValue = props[prop];
    return handleBreakpoints(props, propValue, styleFromPropValue);
  }
  function style$1(props, keys) {
    var transformer = createUnarySpacing(props.theme);
    return Object.keys(props).map(function (prop) {
      return resolveCssProperty(props, keys, prop, transformer);
    }).reduce(merge, {});
  }
  function margin(props) {
    return style$1(props, marginKeys);
  }
  margin.propTypes = marginKeys.reduce(function (obj, key) {
    obj[key] = responsivePropType$1;
    return obj;
  }, {}) ;
  margin.filterProps = marginKeys;
  function padding(props) {
    return style$1(props, paddingKeys);
  }
  padding.propTypes = paddingKeys.reduce(function (obj, key) {
    obj[key] = responsivePropType$1;
    return obj;
  }, {}) ;
  padding.filterProps = paddingKeys;
  spacingKeys.reduce(function (obj, key) {
    obj[key] = responsivePropType$1;
    return obj;
  }, {}) ;

  // The different signatures imply different meaning for their arguments that can't be expressed structurally.
  // We express the difference with variable names.

  function createSpacing() {
    var spacingInput = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 8;
    // Already transformed.
    if (spacingInput.mui) {
      return spacingInput;
    }

    // Material Design layouts are visually balanced. Most measurements align to an 8dp grid, which aligns both spacing and the overall layout.
    // Smaller components, such as icons, can align to a 4dp grid.
    // https://m2.material.io/design/layout/understanding-layout.html
    var transform = createUnarySpacing({
      spacing: spacingInput
    });
    var spacing = function spacing() {
      for (var _len = arguments.length, argsInput = new Array(_len), _key = 0; _key < _len; _key++) {
        argsInput[_key] = arguments[_key];
      }
      {
        if (!(argsInput.length <= 4)) {
          console.error("MUI: Too many arguments provided, expected between 0 and 4, got ".concat(argsInput.length));
        }
      }
      var args = argsInput.length === 0 ? [1] : argsInput;
      return args.map(function (argument) {
        var output = transform(argument);
        return typeof output === 'number' ? "".concat(output, "px") : output;
      }).join(' ');
    };
    spacing.mui = true;
    return spacing;
  }

  function compose() {
    for (var _len = arguments.length, styles = new Array(_len), _key = 0; _key < _len; _key++) {
      styles[_key] = arguments[_key];
    }
    var handlers = styles.reduce(function (acc, style) {
      style.filterProps.forEach(function (prop) {
        acc[prop] = style;
      });
      return acc;
    }, {});

    // false positive
    // eslint-disable-next-line react/function-component-definition
    var fn = function fn(props) {
      return Object.keys(props).reduce(function (acc, prop) {
        if (handlers[prop]) {
          return merge(acc, handlers[prop](props));
        }
        return acc;
      }, {});
    };
    fn.propTypes = styles.reduce(function (acc, style) {
      return Object.assign(acc, style.propTypes);
    }, {}) ;
    fn.filterProps = styles.reduce(function (acc, style) {
      return acc.concat(style.filterProps);
    }, []);
    return fn;
  }

  function borderTransform(value) {
    if (typeof value !== 'number') {
      return value;
    }
    return "".concat(value, "px solid");
  }
  function createBorderStyle(prop, transform) {
    return style$2({
      prop: prop,
      themeKey: 'borders',
      transform: transform
    });
  }
  var border = createBorderStyle('border', borderTransform);
  var borderTop = createBorderStyle('borderTop', borderTransform);
  var borderRight = createBorderStyle('borderRight', borderTransform);
  var borderBottom = createBorderStyle('borderBottom', borderTransform);
  var borderLeft = createBorderStyle('borderLeft', borderTransform);
  var borderColor = createBorderStyle('borderColor');
  var borderTopColor = createBorderStyle('borderTopColor');
  var borderRightColor = createBorderStyle('borderRightColor');
  var borderBottomColor = createBorderStyle('borderBottomColor');
  var borderLeftColor = createBorderStyle('borderLeftColor');
  var outline = createBorderStyle('outline', borderTransform);
  var outlineColor = createBorderStyle('outlineColor');

  // false positive
  // eslint-disable-next-line react/function-component-definition
  var borderRadius = function borderRadius(props) {
    if (props.borderRadius !== undefined && props.borderRadius !== null) {
      var transformer = createUnaryUnit(props.theme, 'shape.borderRadius', 4, 'borderRadius');
      var styleFromPropValue = function styleFromPropValue(propValue) {
        return {
          borderRadius: getValue(transformer, propValue)
        };
      };
      return handleBreakpoints(props, props.borderRadius, styleFromPropValue);
    }
    return null;
  };
  borderRadius.propTypes = {
    borderRadius: responsivePropType$1
  } ;
  borderRadius.filterProps = ['borderRadius'];
  compose(border, borderTop, borderRight, borderBottom, borderLeft, borderColor, borderTopColor, borderRightColor, borderBottomColor, borderLeftColor, borderRadius, outline, outlineColor);

  // false positive
  // eslint-disable-next-line react/function-component-definition
  var gap = function gap(props) {
    if (props.gap !== undefined && props.gap !== null) {
      var transformer = createUnaryUnit(props.theme, 'spacing', 8, 'gap');
      var styleFromPropValue = function styleFromPropValue(propValue) {
        return {
          gap: getValue(transformer, propValue)
        };
      };
      return handleBreakpoints(props, props.gap, styleFromPropValue);
    }
    return null;
  };
  gap.propTypes = {
    gap: responsivePropType$1
  } ;
  gap.filterProps = ['gap'];

  // false positive
  // eslint-disable-next-line react/function-component-definition
  var columnGap = function columnGap(props) {
    if (props.columnGap !== undefined && props.columnGap !== null) {
      var transformer = createUnaryUnit(props.theme, 'spacing', 8, 'columnGap');
      var styleFromPropValue = function styleFromPropValue(propValue) {
        return {
          columnGap: getValue(transformer, propValue)
        };
      };
      return handleBreakpoints(props, props.columnGap, styleFromPropValue);
    }
    return null;
  };
  columnGap.propTypes = {
    columnGap: responsivePropType$1
  } ;
  columnGap.filterProps = ['columnGap'];

  // false positive
  // eslint-disable-next-line react/function-component-definition
  var rowGap = function rowGap(props) {
    if (props.rowGap !== undefined && props.rowGap !== null) {
      var transformer = createUnaryUnit(props.theme, 'spacing', 8, 'rowGap');
      var styleFromPropValue = function styleFromPropValue(propValue) {
        return {
          rowGap: getValue(transformer, propValue)
        };
      };
      return handleBreakpoints(props, props.rowGap, styleFromPropValue);
    }
    return null;
  };
  rowGap.propTypes = {
    rowGap: responsivePropType$1
  } ;
  rowGap.filterProps = ['rowGap'];
  var gridColumn = style$2({
    prop: 'gridColumn'
  });
  var gridRow = style$2({
    prop: 'gridRow'
  });
  var gridAutoFlow = style$2({
    prop: 'gridAutoFlow'
  });
  var gridAutoColumns = style$2({
    prop: 'gridAutoColumns'
  });
  var gridAutoRows = style$2({
    prop: 'gridAutoRows'
  });
  var gridTemplateColumns = style$2({
    prop: 'gridTemplateColumns'
  });
  var gridTemplateRows = style$2({
    prop: 'gridTemplateRows'
  });
  var gridTemplateAreas = style$2({
    prop: 'gridTemplateAreas'
  });
  var gridArea = style$2({
    prop: 'gridArea'
  });
  compose(gap, columnGap, rowGap, gridColumn, gridRow, gridAutoFlow, gridAutoColumns, gridAutoRows, gridTemplateColumns, gridTemplateRows, gridTemplateAreas, gridArea);

  function paletteTransform(value, userValue) {
    if (userValue === 'grey') {
      return userValue;
    }
    return value;
  }
  var color = style$2({
    prop: 'color',
    themeKey: 'palette',
    transform: paletteTransform
  });
  var bgcolor = style$2({
    prop: 'bgcolor',
    cssProperty: 'backgroundColor',
    themeKey: 'palette',
    transform: paletteTransform
  });
  var backgroundColor = style$2({
    prop: 'backgroundColor',
    themeKey: 'palette',
    transform: paletteTransform
  });
  compose(color, bgcolor, backgroundColor);

  function sizingTransform(value) {
    return value <= 1 && value !== 0 ? "".concat(value * 100, "%") : value;
  }
  var width = style$2({
    prop: 'width',
    transform: sizingTransform
  });
  var maxWidth = function maxWidth(props) {
    if (props.maxWidth !== undefined && props.maxWidth !== null) {
      var styleFromPropValue = function styleFromPropValue(propValue) {
        var _props$theme, _props$theme2;
        var breakpoint = ((_props$theme = props.theme) == null || (_props$theme = _props$theme.breakpoints) == null || (_props$theme = _props$theme.values) == null ? void 0 : _props$theme[propValue]) || values$1[propValue];
        if (!breakpoint) {
          return {
            maxWidth: sizingTransform(propValue)
          };
        }
        if (((_props$theme2 = props.theme) == null || (_props$theme2 = _props$theme2.breakpoints) == null ? void 0 : _props$theme2.unit) !== 'px') {
          return {
            maxWidth: "".concat(breakpoint).concat(props.theme.breakpoints.unit)
          };
        }
        return {
          maxWidth: breakpoint
        };
      };
      return handleBreakpoints(props, props.maxWidth, styleFromPropValue);
    }
    return null;
  };
  maxWidth.filterProps = ['maxWidth'];
  var minWidth = style$2({
    prop: 'minWidth',
    transform: sizingTransform
  });
  var height = style$2({
    prop: 'height',
    transform: sizingTransform
  });
  var maxHeight = style$2({
    prop: 'maxHeight',
    transform: sizingTransform
  });
  var minHeight = style$2({
    prop: 'minHeight',
    transform: sizingTransform
  });
  style$2({
    prop: 'size',
    cssProperty: 'width',
    transform: sizingTransform
  });
  style$2({
    prop: 'size',
    cssProperty: 'height',
    transform: sizingTransform
  });
  var boxSizing = style$2({
    prop: 'boxSizing'
  });
  compose(width, maxWidth, minWidth, height, maxHeight, minHeight, boxSizing);

  var defaultSxConfig = {
    // borders
    border: {
      themeKey: 'borders',
      transform: borderTransform
    },
    borderTop: {
      themeKey: 'borders',
      transform: borderTransform
    },
    borderRight: {
      themeKey: 'borders',
      transform: borderTransform
    },
    borderBottom: {
      themeKey: 'borders',
      transform: borderTransform
    },
    borderLeft: {
      themeKey: 'borders',
      transform: borderTransform
    },
    borderColor: {
      themeKey: 'palette'
    },
    borderTopColor: {
      themeKey: 'palette'
    },
    borderRightColor: {
      themeKey: 'palette'
    },
    borderBottomColor: {
      themeKey: 'palette'
    },
    borderLeftColor: {
      themeKey: 'palette'
    },
    outline: {
      themeKey: 'borders',
      transform: borderTransform
    },
    outlineColor: {
      themeKey: 'palette'
    },
    borderRadius: {
      themeKey: 'shape.borderRadius',
      style: borderRadius
    },
    // palette
    color: {
      themeKey: 'palette',
      transform: paletteTransform
    },
    bgcolor: {
      themeKey: 'palette',
      cssProperty: 'backgroundColor',
      transform: paletteTransform
    },
    backgroundColor: {
      themeKey: 'palette',
      transform: paletteTransform
    },
    // spacing
    p: {
      style: padding
    },
    pt: {
      style: padding
    },
    pr: {
      style: padding
    },
    pb: {
      style: padding
    },
    pl: {
      style: padding
    },
    px: {
      style: padding
    },
    py: {
      style: padding
    },
    padding: {
      style: padding
    },
    paddingTop: {
      style: padding
    },
    paddingRight: {
      style: padding
    },
    paddingBottom: {
      style: padding
    },
    paddingLeft: {
      style: padding
    },
    paddingX: {
      style: padding
    },
    paddingY: {
      style: padding
    },
    paddingInline: {
      style: padding
    },
    paddingInlineStart: {
      style: padding
    },
    paddingInlineEnd: {
      style: padding
    },
    paddingBlock: {
      style: padding
    },
    paddingBlockStart: {
      style: padding
    },
    paddingBlockEnd: {
      style: padding
    },
    m: {
      style: margin
    },
    mt: {
      style: margin
    },
    mr: {
      style: margin
    },
    mb: {
      style: margin
    },
    ml: {
      style: margin
    },
    mx: {
      style: margin
    },
    my: {
      style: margin
    },
    margin: {
      style: margin
    },
    marginTop: {
      style: margin
    },
    marginRight: {
      style: margin
    },
    marginBottom: {
      style: margin
    },
    marginLeft: {
      style: margin
    },
    marginX: {
      style: margin
    },
    marginY: {
      style: margin
    },
    marginInline: {
      style: margin
    },
    marginInlineStart: {
      style: margin
    },
    marginInlineEnd: {
      style: margin
    },
    marginBlock: {
      style: margin
    },
    marginBlockStart: {
      style: margin
    },
    marginBlockEnd: {
      style: margin
    },
    // display
    displayPrint: {
      cssProperty: false,
      transform: function transform(value) {
        return {
          '@media print': {
            display: value
          }
        };
      }
    },
    display: {},
    overflow: {},
    textOverflow: {},
    visibility: {},
    whiteSpace: {},
    // flexbox
    flexBasis: {},
    flexDirection: {},
    flexWrap: {},
    justifyContent: {},
    alignItems: {},
    alignContent: {},
    order: {},
    flex: {},
    flexGrow: {},
    flexShrink: {},
    alignSelf: {},
    justifyItems: {},
    justifySelf: {},
    // grid
    gap: {
      style: gap
    },
    rowGap: {
      style: rowGap
    },
    columnGap: {
      style: columnGap
    },
    gridColumn: {},
    gridRow: {},
    gridAutoFlow: {},
    gridAutoColumns: {},
    gridAutoRows: {},
    gridTemplateColumns: {},
    gridTemplateRows: {},
    gridTemplateAreas: {},
    gridArea: {},
    // positions
    position: {},
    zIndex: {
      themeKey: 'zIndex'
    },
    top: {},
    right: {},
    bottom: {},
    left: {},
    // shadows
    boxShadow: {
      themeKey: 'shadows'
    },
    // sizing
    width: {
      transform: sizingTransform
    },
    maxWidth: {
      style: maxWidth
    },
    minWidth: {
      transform: sizingTransform
    },
    height: {
      transform: sizingTransform
    },
    maxHeight: {
      transform: sizingTransform
    },
    minHeight: {
      transform: sizingTransform
    },
    boxSizing: {},
    // typography
    fontFamily: {
      themeKey: 'typography'
    },
    fontSize: {
      themeKey: 'typography'
    },
    fontStyle: {
      themeKey: 'typography'
    },
    fontWeight: {
      themeKey: 'typography'
    },
    letterSpacing: {},
    textTransform: {},
    lineHeight: {},
    textAlign: {},
    typography: {
      cssProperty: false,
      themeKey: 'typography'
    }
  };
  var defaultSxConfig$1 = defaultSxConfig;

  function objectsHaveSameKeys() {
    for (var _len = arguments.length, objects = new Array(_len), _key = 0; _key < _len; _key++) {
      objects[_key] = arguments[_key];
    }
    var allKeys = objects.reduce(function (keys, object) {
      return keys.concat(Object.keys(object));
    }, []);
    var union = new Set(allKeys);
    return objects.every(function (object) {
      return union.size === Object.keys(object).length;
    });
  }
  function callIfFn(maybeFn, arg) {
    return typeof maybeFn === 'function' ? maybeFn(arg) : maybeFn;
  }

  // eslint-disable-next-line @typescript-eslint/naming-convention
  function unstable_createStyleFunctionSx() {
    function getThemeValue(prop, val, theme, config) {
      var props = _defineProperty(_defineProperty({}, prop, val), "theme", theme);
      var options = config[prop];
      if (!options) {
        return _defineProperty({}, prop, val);
      }
      var _options$cssProperty = options.cssProperty,
        cssProperty = _options$cssProperty === void 0 ? prop : _options$cssProperty,
        themeKey = options.themeKey,
        transform = options.transform,
        style = options.style;
      if (val == null) {
        return null;
      }

      // TODO v6: remove, see https://github.com/mui/material-ui/pull/38123
      if (themeKey === 'typography' && val === 'inherit') {
        return _defineProperty({}, prop, val);
      }
      var themeMapping = getPath(theme, themeKey) || {};
      if (style) {
        return style(props);
      }
      var styleFromPropValue = function styleFromPropValue(propValueFinal) {
        var value = getStyleValue$1(themeMapping, transform, propValueFinal);
        if (propValueFinal === value && typeof propValueFinal === 'string') {
          // Haven't found value
          value = getStyleValue$1(themeMapping, transform, "".concat(prop).concat(propValueFinal === 'default' ? '' : capitalize(propValueFinal)), propValueFinal);
        }
        if (cssProperty === false) {
          return value;
        }
        return _defineProperty({}, cssProperty, value);
      };
      return handleBreakpoints(props, val, styleFromPropValue);
    }
    function styleFunctionSx(props) {
      var _theme$unstable_sxCon;
      var _ref4 = props || {},
        sx = _ref4.sx,
        _ref4$theme = _ref4.theme,
        theme = _ref4$theme === void 0 ? {} : _ref4$theme;
      if (!sx) {
        return null; // Emotion & styled-components will neglect null
      }
      var config = (_theme$unstable_sxCon = theme.unstable_sxConfig) != null ? _theme$unstable_sxCon : defaultSxConfig$1;

      /*
       * Receive `sxInput` as object or callback
       * and then recursively check keys & values to create media query object styles.
       * (the result will be used in `styled`)
       */
      function traverse(sxInput) {
        var sxObject = sxInput;
        if (typeof sxInput === 'function') {
          sxObject = sxInput(theme);
        } else if (_typeof(sxInput) !== 'object') {
          // value
          return sxInput;
        }
        if (!sxObject) {
          return null;
        }
        var emptyBreakpoints = createEmptyBreakpointObject(theme.breakpoints);
        var breakpointsKeys = Object.keys(emptyBreakpoints);
        var css = emptyBreakpoints;
        Object.keys(sxObject).forEach(function (styleKey) {
          var value = callIfFn(sxObject[styleKey], theme);
          if (value !== null && value !== undefined) {
            if (_typeof(value) === 'object') {
              if (config[styleKey]) {
                css = merge(css, getThemeValue(styleKey, value, theme, config));
              } else {
                var breakpointsValues = handleBreakpoints({
                  theme: theme
                }, value, function (x) {
                  return _defineProperty({}, styleKey, x);
                });
                if (objectsHaveSameKeys(breakpointsValues, value)) {
                  css[styleKey] = styleFunctionSx({
                    sx: value,
                    theme: theme
                  });
                } else {
                  css = merge(css, breakpointsValues);
                }
              }
            } else {
              css = merge(css, getThemeValue(styleKey, value, theme, config));
            }
          }
        });
        return removeUnusedBreakpoints(breakpointsKeys, css);
      }
      return Array.isArray(sx) ? sx.map(traverse) : traverse(sx);
    }
    return styleFunctionSx;
  }
  var styleFunctionSx = unstable_createStyleFunctionSx();
  styleFunctionSx.filterProps = ['sx'];
  var styleFunctionSx$1 = styleFunctionSx;

  /**
   * A universal utility to style components with multiple color modes. Always use it from the theme object.
   * It works with:
   *  - [Basic theme](https://mui.com/material-ui/customization/dark-mode/)
   *  - [CSS theme variables](https://mui.com/material-ui/experimental-api/css-theme-variables/overview/)
   *  - Zero-runtime engine
   *
   * Tips: Use an array over object spread and place `theme.applyStyles()` last.
   *
   * ✅ [{ background: '#e5e5e5' }, theme.applyStyles('dark', { background: '#1c1c1c' })]
   *
   * 🚫 { background: '#e5e5e5', ...theme.applyStyles('dark', { background: '#1c1c1c' })}
   *
   * @example
   * 1. using with `styled`:
   * ```jsx
   *   const Component = styled('div')(({ theme }) => [
   *     { background: '#e5e5e5' },
   *     theme.applyStyles('dark', {
   *       background: '#1c1c1c',
   *       color: '#fff',
   *     }),
   *   ]);
   * ```
   *
   * @example
   * 2. using with `sx` prop:
   * ```jsx
   *   <Box sx={theme => [
   *     { background: '#e5e5e5' },
   *     theme.applyStyles('dark', {
   *        background: '#1c1c1c',
   *        color: '#fff',
   *      }),
   *     ]}
   *   />
   * ```
   *
   * @example
   * 3. theming a component:
   * ```jsx
   *   extendTheme({
   *     components: {
   *       MuiButton: {
   *         styleOverrides: {
   *           root: ({ theme }) => [
   *             { background: '#e5e5e5' },
   *             theme.applyStyles('dark', {
   *               background: '#1c1c1c',
   *               color: '#fff',
   *             }),
   *           ],
   *         },
   *       }
   *     }
   *   })
   *```
   */
  function applyStyles$2(key, styles) {
    // @ts-expect-error this is 'any' type
    var theme = this;
    if (theme.vars && typeof theme.getColorSchemeSelector === 'function') {
      // If CssVarsProvider is used as a provider,
      // returns '* :where([data-mui-color-scheme="light|dark"]) &'
      var selector = theme.getColorSchemeSelector(key).replace(/(\[[^\]]+\])/, '*:where($1)');
      return _defineProperty({}, selector, styles);
    }
    if (theme.palette.mode === key) {
      return styles;
    }
    return {};
  }

  function createTheme$1() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var _options$breakpoints = options.breakpoints,
      breakpointsInput = _options$breakpoints === void 0 ? {} : _options$breakpoints,
      _options$palette = options.palette,
      paletteInput = _options$palette === void 0 ? {} : _options$palette,
      spacingInput = options.spacing,
      _options$shape = options.shape,
      shapeInput = _options$shape === void 0 ? {} : _options$shape,
      other = _objectWithoutProperties(options, ["breakpoints", "palette", "spacing", "shape"]);
    var breakpoints = createBreakpoints(breakpointsInput);
    var spacing = createSpacing(spacingInput);
    var muiTheme = deepmerge({
      breakpoints: breakpoints,
      direction: 'ltr',
      components: {},
      // Inject component definitions.
      palette: _extends({
        mode: 'light'
      }, paletteInput),
      spacing: spacing,
      shape: _extends({}, shape$1, shapeInput)
    }, other);
    muiTheme.applyStyles = applyStyles$2;
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }
    muiTheme = args.reduce(function (acc, argument) {
      return deepmerge(acc, argument);
    }, muiTheme);
    muiTheme.unstable_sxConfig = _extends({}, defaultSxConfig$1, other == null ? void 0 : other.unstable_sxConfig);
    muiTheme.unstable_sx = function sx(props) {
      return styleFunctionSx$1({
        sx: props,
        theme: this
      });
    };
    return muiTheme;
  }

  function isObjectEmpty(obj) {
    return Object.keys(obj).length === 0;
  }
  function useTheme$3() {
    var defaultTheme = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    var contextTheme = React__namespace.useContext(ThemeContext$2);
    return !contextTheme || isObjectEmpty(contextTheme) ? defaultTheme : contextTheme;
  }

  var systemDefaultTheme$1 = createTheme$1();
  function useTheme$2() {
    var defaultTheme = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : systemDefaultTheme$1;
    return useTheme$3(defaultTheme);
  }

  function GlobalStyles$1(_ref) {
    var styles = _ref.styles,
      themeId = _ref.themeId,
      _ref$defaultTheme = _ref.defaultTheme,
      defaultTheme = _ref$defaultTheme === void 0 ? {} : _ref$defaultTheme;
    var upperTheme = useTheme$2(defaultTheme);
    var globalStyles = typeof styles === 'function' ? styles(themeId ? upperTheme[themeId] || upperTheme : upperTheme) : styles;
    return /*#__PURE__*/jsxRuntime_1(GlobalStyles$2, {
      styles: globalStyles
    });
  }
  GlobalStyles$1.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │ To update them, edit the TypeScript types and run `pnpm proptypes`. │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * @ignore
     */
    defaultTheme: PropTypes.object,
    /**
     * @ignore
     */
    styles: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.array, PropTypes.func, PropTypes.number, PropTypes.object, PropTypes.string, PropTypes.bool]),
    /**
     * @ignore
     */
    themeId: PropTypes.string
  } ;

  var splitProps = function splitProps(props) {
    var _props$theme$unstable, _props$theme;
    var result = {
      systemProps: {},
      otherProps: {}
    };
    var config = (_props$theme$unstable = props == null || (_props$theme = props.theme) == null ? void 0 : _props$theme.unstable_sxConfig) != null ? _props$theme$unstable : defaultSxConfig$1;
    Object.keys(props).forEach(function (prop) {
      if (config[prop]) {
        result.systemProps[prop] = props[prop];
      } else {
        result.otherProps[prop] = props[prop];
      }
    });
    return result;
  };
  function extendSxProp(props) {
    var inSx = props.sx,
      other = _objectWithoutProperties(props, ["sx"]);
    var _splitProps = splitProps(other),
      systemProps = _splitProps.systemProps,
      otherProps = _splitProps.otherProps;
    var finalSx;
    if (Array.isArray(inSx)) {
      finalSx = [systemProps].concat(_toConsumableArray(inSx));
    } else if (typeof inSx === 'function') {
      finalSx = function finalSx() {
        var result = inSx.apply(void 0, arguments);
        if (!isPlainObject(result)) {
          return systemProps;
        }
        return _extends({}, systemProps, result);
      };
    } else {
      finalSx = _extends({}, systemProps, inSx);
    }
    return _extends({}, otherProps, {
      sx: finalSx
    });
  }

  var defaultGenerator = function defaultGenerator(componentName) {
    return componentName;
  };
  var createClassNameGenerator = function createClassNameGenerator() {
    var _generate = defaultGenerator;
    return {
      configure: function configure(generator) {
        _generate = generator;
      },
      generate: function generate(componentName) {
        return _generate(componentName);
      },
      reset: function reset() {
        _generate = defaultGenerator;
      }
    };
  };
  var ClassNameGenerator = createClassNameGenerator();
  var ClassNameGenerator$1 = ClassNameGenerator;

  function r(e){var t,f,n="";if("string"==typeof e||"number"==typeof e)n+=e;else if("object"==typeof e)if(Array.isArray(e)){var o=e.length;for(t=0;t<o;t++)e[t]&&(f=r(e[t]))&&(n&&(n+=" "),n+=f);}else for(f in e)e[f]&&(n&&(n+=" "),n+=f);return n}function clsx(){for(var e,t,f=0,n="",o=arguments.length;f<o;f++)(e=arguments[f])&&(t=r(e))&&(n&&(n+=" "),n+=t);return n}

  function createBox() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var themeId = options.themeId,
      defaultTheme = options.defaultTheme,
      _options$defaultClass = options.defaultClassName,
      defaultClassName = _options$defaultClass === void 0 ? 'MuiBox-root' : _options$defaultClass,
      generateClassName = options.generateClassName;
    var BoxRoot = styled$3('div', {
      shouldForwardProp: function shouldForwardProp(prop) {
        return prop !== 'theme' && prop !== 'sx' && prop !== 'as';
      }
    })(styleFunctionSx$1);
    var Box = /*#__PURE__*/React__namespace.forwardRef(function Box(inProps, ref) {
      var theme = useTheme$2(defaultTheme);
      var _extendSxProp = extendSxProp(inProps),
        className = _extendSxProp.className,
        _extendSxProp$compone = _extendSxProp.component,
        component = _extendSxProp$compone === void 0 ? 'div' : _extendSxProp$compone,
        other = _objectWithoutProperties(_extendSxProp, ["className", "component"]);
      return /*#__PURE__*/jsxRuntime_1(BoxRoot, _extends({
        as: component,
        ref: ref,
        className: clsx(className, generateClassName ? generateClassName(defaultClassName) : defaultClassName),
        theme: themeId ? theme[themeId] || theme : theme
      }, other));
    });
    return Box;
  }

  var globalStateClasses = {
    active: 'active',
    checked: 'checked',
    completed: 'completed',
    disabled: 'disabled',
    error: 'error',
    expanded: 'expanded',
    focused: 'focused',
    focusVisible: 'focusVisible',
    open: 'open',
    readOnly: 'readOnly',
    required: 'required',
    selected: 'selected'
  };
  function generateUtilityClass$1(componentName, slot) {
    var globalStatePrefix = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'Mui';
    var globalStateClass = globalStateClasses[slot];
    return globalStateClass ? "".concat(globalStatePrefix, "-").concat(globalStateClass) : "".concat(ClassNameGenerator$1.generate(componentName), "-").concat(slot);
  }

  function generateUtilityClasses$1(componentName, slots) {
    var globalStatePrefix = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'Mui';
    var result = {};
    slots.forEach(function (slot) {
      result[slot] = generateUtilityClass$1(componentName, slot, globalStatePrefix);
    });
    return result;
  }

  var reactIs_development = createCommonjsModule(function (module, exports) {

  {
    (function() {

  // ATTENTION
  // When adding new symbols to this file,
  // Please consider also adding to 'react-devtools-shared/src/backend/ReactSymbols'
  // The Symbol used to tag the ReactElement-like types.
  var REACT_ELEMENT_TYPE = Symbol.for('react.element');
  var REACT_PORTAL_TYPE = Symbol.for('react.portal');
  var REACT_FRAGMENT_TYPE = Symbol.for('react.fragment');
  var REACT_STRICT_MODE_TYPE = Symbol.for('react.strict_mode');
  var REACT_PROFILER_TYPE = Symbol.for('react.profiler');
  var REACT_PROVIDER_TYPE = Symbol.for('react.provider');
  var REACT_CONTEXT_TYPE = Symbol.for('react.context');
  var REACT_SERVER_CONTEXT_TYPE = Symbol.for('react.server_context');
  var REACT_FORWARD_REF_TYPE = Symbol.for('react.forward_ref');
  var REACT_SUSPENSE_TYPE = Symbol.for('react.suspense');
  var REACT_SUSPENSE_LIST_TYPE = Symbol.for('react.suspense_list');
  var REACT_MEMO_TYPE = Symbol.for('react.memo');
  var REACT_LAZY_TYPE = Symbol.for('react.lazy');
  var REACT_OFFSCREEN_TYPE = Symbol.for('react.offscreen');

  // -----------------------------------------------------------------------------

  var enableScopeAPI = false; // Experimental Create Event Handle API.
  var enableCacheElement = false;
  var enableTransitionTracing = false; // No known bugs, but needs performance testing

  var enableLegacyHidden = false; // Enables unstable_avoidThisFallback feature in Fiber
  // stuff. Intended to enable React core members to more easily debug scheduling
  // issues in DEV builds.

  var enableDebugTracing = false; // Track which Fiber(s) schedule render work.

  var REACT_MODULE_REFERENCE;

  {
    REACT_MODULE_REFERENCE = Symbol.for('react.module.reference');
  }

  function isValidElementType(type) {
    if (typeof type === 'string' || typeof type === 'function') {
      return true;
    } // Note: typeof might be other than 'symbol' or 'number' (e.g. if it's a polyfill).


    if (type === REACT_FRAGMENT_TYPE || type === REACT_PROFILER_TYPE || enableDebugTracing  || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || enableLegacyHidden  || type === REACT_OFFSCREEN_TYPE || enableScopeAPI  || enableCacheElement  || enableTransitionTracing ) {
      return true;
    }

    if (typeof type === 'object' && type !== null) {
      if (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || // This needs to include all possible module reference object
      // types supported by any Flight configuration anywhere since
      // we don't know which Flight build this will end up being used
      // with.
      type.$$typeof === REACT_MODULE_REFERENCE || type.getModuleId !== undefined) {
        return true;
      }
    }

    return false;
  }

  function typeOf(object) {
    if (typeof object === 'object' && object !== null) {
      var $$typeof = object.$$typeof;

      switch ($$typeof) {
        case REACT_ELEMENT_TYPE:
          var type = object.type;

          switch (type) {
            case REACT_FRAGMENT_TYPE:
            case REACT_PROFILER_TYPE:
            case REACT_STRICT_MODE_TYPE:
            case REACT_SUSPENSE_TYPE:
            case REACT_SUSPENSE_LIST_TYPE:
              return type;

            default:
              var $$typeofType = type && type.$$typeof;

              switch ($$typeofType) {
                case REACT_SERVER_CONTEXT_TYPE:
                case REACT_CONTEXT_TYPE:
                case REACT_FORWARD_REF_TYPE:
                case REACT_LAZY_TYPE:
                case REACT_MEMO_TYPE:
                case REACT_PROVIDER_TYPE:
                  return $$typeofType;

                default:
                  return $$typeof;
              }

          }

        case REACT_PORTAL_TYPE:
          return $$typeof;
      }
    }

    return undefined;
  }
  var ContextConsumer = REACT_CONTEXT_TYPE;
  var ContextProvider = REACT_PROVIDER_TYPE;
  var Element = REACT_ELEMENT_TYPE;
  var ForwardRef = REACT_FORWARD_REF_TYPE;
  var Fragment = REACT_FRAGMENT_TYPE;
  var Lazy = REACT_LAZY_TYPE;
  var Memo = REACT_MEMO_TYPE;
  var Portal = REACT_PORTAL_TYPE;
  var Profiler = REACT_PROFILER_TYPE;
  var StrictMode = REACT_STRICT_MODE_TYPE;
  var Suspense = REACT_SUSPENSE_TYPE;
  var SuspenseList = REACT_SUSPENSE_LIST_TYPE;
  var hasWarnedAboutDeprecatedIsAsyncMode = false;
  var hasWarnedAboutDeprecatedIsConcurrentMode = false; // AsyncMode should be deprecated

  function isAsyncMode(object) {
    {
      if (!hasWarnedAboutDeprecatedIsAsyncMode) {
        hasWarnedAboutDeprecatedIsAsyncMode = true; // Using console['warn'] to evade Babel and ESLint

        console['warn']('The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 18+.');
      }
    }

    return false;
  }
  function isConcurrentMode(object) {
    {
      if (!hasWarnedAboutDeprecatedIsConcurrentMode) {
        hasWarnedAboutDeprecatedIsConcurrentMode = true; // Using console['warn'] to evade Babel and ESLint

        console['warn']('The ReactIs.isConcurrentMode() alias has been deprecated, ' + 'and will be removed in React 18+.');
      }
    }

    return false;
  }
  function isContextConsumer(object) {
    return typeOf(object) === REACT_CONTEXT_TYPE;
  }
  function isContextProvider(object) {
    return typeOf(object) === REACT_PROVIDER_TYPE;
  }
  function isElement(object) {
    return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
  }
  function isForwardRef(object) {
    return typeOf(object) === REACT_FORWARD_REF_TYPE;
  }
  function isFragment(object) {
    return typeOf(object) === REACT_FRAGMENT_TYPE;
  }
  function isLazy(object) {
    return typeOf(object) === REACT_LAZY_TYPE;
  }
  function isMemo(object) {
    return typeOf(object) === REACT_MEMO_TYPE;
  }
  function isPortal(object) {
    return typeOf(object) === REACT_PORTAL_TYPE;
  }
  function isProfiler(object) {
    return typeOf(object) === REACT_PROFILER_TYPE;
  }
  function isStrictMode(object) {
    return typeOf(object) === REACT_STRICT_MODE_TYPE;
  }
  function isSuspense(object) {
    return typeOf(object) === REACT_SUSPENSE_TYPE;
  }
  function isSuspenseList(object) {
    return typeOf(object) === REACT_SUSPENSE_LIST_TYPE;
  }

  exports.ContextConsumer = ContextConsumer;
  exports.ContextProvider = ContextProvider;
  exports.Element = Element;
  exports.ForwardRef = ForwardRef;
  exports.Fragment = Fragment;
  exports.Lazy = Lazy;
  exports.Memo = Memo;
  exports.Portal = Portal;
  exports.Profiler = Profiler;
  exports.StrictMode = StrictMode;
  exports.Suspense = Suspense;
  exports.SuspenseList = SuspenseList;
  exports.isAsyncMode = isAsyncMode;
  exports.isConcurrentMode = isConcurrentMode;
  exports.isContextConsumer = isContextConsumer;
  exports.isContextProvider = isContextProvider;
  exports.isElement = isElement;
  exports.isForwardRef = isForwardRef;
  exports.isFragment = isFragment;
  exports.isLazy = isLazy;
  exports.isMemo = isMemo;
  exports.isPortal = isPortal;
  exports.isProfiler = isProfiler;
  exports.isStrictMode = isStrictMode;
  exports.isSuspense = isSuspense;
  exports.isSuspenseList = isSuspenseList;
  exports.isValidElementType = isValidElementType;
  exports.typeOf = typeOf;
    })();
  }
  });
  reactIs_development.ContextConsumer;
  reactIs_development.ContextProvider;
  reactIs_development.Element;
  reactIs_development.ForwardRef;
  reactIs_development.Fragment;
  reactIs_development.Lazy;
  reactIs_development.Memo;
  reactIs_development.Portal;
  reactIs_development.Profiler;
  reactIs_development.StrictMode;
  reactIs_development.Suspense;
  reactIs_development.SuspenseList;
  reactIs_development.isAsyncMode;
  reactIs_development.isConcurrentMode;
  reactIs_development.isContextConsumer;
  reactIs_development.isContextProvider;
  reactIs_development.isElement;
  reactIs_development.isForwardRef;
  reactIs_development.isFragment;
  reactIs_development.isLazy;
  reactIs_development.isMemo;
  reactIs_development.isPortal;
  reactIs_development.isProfiler;
  reactIs_development.isStrictMode;
  reactIs_development.isSuspense;
  reactIs_development.isSuspenseList;
  reactIs_development.isValidElementType;
  reactIs_development.typeOf;

  var reactIs = createCommonjsModule(function (module) {

  {
    module.exports = reactIs_development;
  }
  });
  var reactIs_1 = reactIs.ForwardRef;
  var reactIs_2 = reactIs.isFragment;
  reactIs.isLazy;
  reactIs.isMemo;
  var reactIs_5 = reactIs.Memo;
  reactIs.isValidElementType;

  // Simplified polyfill for IE11 support
  // https://github.com/JamesMGreene/Function.name/blob/58b314d4a983110c3682f1228f845d39ccca1817/Function.name.js#L3
  var fnNameMatchRegex = /^\s*function(?:\s|\s*\/\*.*\*\/\s*)+([^(\s/]*)\s*/;
  function getFunctionName(fn) {
    var match = "".concat(fn).match(fnNameMatchRegex);
    var name = match && match[1];
    return name || '';
  }
  function getFunctionComponentName(Component) {
    var fallback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
    return Component.displayName || Component.name || getFunctionName(Component) || fallback;
  }
  function getWrappedName(outerType, innerType, wrapperName) {
    var functionName = getFunctionComponentName(innerType);
    return outerType.displayName || (functionName !== '' ? "".concat(wrapperName, "(").concat(functionName, ")") : wrapperName);
  }

  /**
   * cherry-pick from
   * https://github.com/facebook/react/blob/769b1f270e1251d9dbdce0fcbd9e92e502d059b8/packages/shared/getComponentName.js
   * originally forked from recompose/getDisplayName with added IE11 support
   */
  function getDisplayName(Component) {
    if (Component == null) {
      return undefined;
    }
    if (typeof Component === 'string') {
      return Component;
    }
    if (typeof Component === 'function') {
      return getFunctionComponentName(Component, 'Component');
    }

    // TypeScript can't have components as objects but they exist in the form of `memo` or `Suspense`
    if (_typeof(Component) === 'object') {
      switch (Component.$$typeof) {
        case reactIs_1:
          return getWrappedName(Component, Component.render, 'ForwardRef');
        case reactIs_5:
          return getWrappedName(Component, Component.type, 'memo');
        default:
          return undefined;
      }
    }
    return undefined;
  }

  function isEmpty$2(obj) {
    return Object.keys(obj).length === 0;
  }

  // https://github.com/emotion-js/emotion/blob/26ded6109fcd8ca9875cc2ce4564fee678a3f3c5/packages/styled/src/utils.js#L40
  function isStringTag(tag) {
    return typeof tag === 'string' &&
    // 96 is one less than the char code
    // for "a" so this is checking that
    // it's a lowercase character
    tag.charCodeAt(0) > 96;
  }

  // Update /system/styled/#api in case if this changes
  function shouldForwardProp(prop) {
    return prop !== 'ownerState' && prop !== 'theme' && prop !== 'sx' && prop !== 'as';
  }
  var systemDefaultTheme = createTheme$1();
  var lowercaseFirstLetter = function lowercaseFirstLetter(string) {
    if (!string) {
      return string;
    }
    return string.charAt(0).toLowerCase() + string.slice(1);
  };
  function resolveTheme(_ref) {
    var defaultTheme = _ref.defaultTheme,
      theme = _ref.theme,
      themeId = _ref.themeId;
    return isEmpty$2(theme) ? defaultTheme : theme[themeId] || theme;
  }
  function defaultOverridesResolver(slot) {
    if (!slot) {
      return null;
    }
    return function (props, styles) {
      return styles[slot];
    };
  }
  function processStyleArg(callableStyle, _ref2) {
    var ownerState = _ref2.ownerState,
      props = _objectWithoutProperties(_ref2, ["ownerState"]);
    var resolvedStylesArg = typeof callableStyle === 'function' ? callableStyle(_extends({
      ownerState: ownerState
    }, props)) : callableStyle;
    if (Array.isArray(resolvedStylesArg)) {
      return resolvedStylesArg.flatMap(function (resolvedStyle) {
        return processStyleArg(resolvedStyle, _extends({
          ownerState: ownerState
        }, props));
      });
    }
    if (!!resolvedStylesArg && _typeof(resolvedStylesArg) === 'object' && Array.isArray(resolvedStylesArg.variants)) {
      var _resolvedStylesArg$va = resolvedStylesArg.variants,
        variants = _resolvedStylesArg$va === void 0 ? [] : _resolvedStylesArg$va,
        otherStyles = _objectWithoutProperties(resolvedStylesArg, ["variants"]);
      var result = otherStyles;
      variants.forEach(function (variant) {
        var isMatch = true;
        if (typeof variant.props === 'function') {
          isMatch = variant.props(_extends({
            ownerState: ownerState
          }, props, ownerState));
        } else {
          Object.keys(variant.props).forEach(function (key) {
            if ((ownerState == null ? void 0 : ownerState[key]) !== variant.props[key] && props[key] !== variant.props[key]) {
              isMatch = false;
            }
          });
        }
        if (isMatch) {
          if (!Array.isArray(result)) {
            result = [result];
          }
          result.push(typeof variant.style === 'function' ? variant.style(_extends({
            ownerState: ownerState
          }, props, ownerState)) : variant.style);
        }
      });
      return result;
    }
    return resolvedStylesArg;
  }
  function createStyled() {
    var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var themeId = input.themeId,
      _input$defaultTheme = input.defaultTheme,
      defaultTheme = _input$defaultTheme === void 0 ? systemDefaultTheme : _input$defaultTheme,
      _input$rootShouldForw = input.rootShouldForwardProp,
      rootShouldForwardProp = _input$rootShouldForw === void 0 ? shouldForwardProp : _input$rootShouldForw,
      _input$slotShouldForw = input.slotShouldForwardProp,
      slotShouldForwardProp = _input$slotShouldForw === void 0 ? shouldForwardProp : _input$slotShouldForw;
    var systemSx = function systemSx(props) {
      return styleFunctionSx$1(_extends({}, props, {
        theme: resolveTheme(_extends({}, props, {
          defaultTheme: defaultTheme,
          themeId: themeId
        }))
      }));
    };
    systemSx.__mui_systemSx = true;
    return function (tag) {
      var inputOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      // Filter out the `sx` style function from the previous styled component to prevent unnecessary styles generated by the composite components.
      internal_processStyles(tag, function (styles) {
        return styles.filter(function (style) {
          return !(style != null && style.__mui_systemSx);
        });
      });
      var componentName = inputOptions.name,
        componentSlot = inputOptions.slot,
        inputSkipVariantsResolver = inputOptions.skipVariantsResolver,
        inputSkipSx = inputOptions.skipSx,
        _inputOptions$overrid = inputOptions.overridesResolver,
        overridesResolver = _inputOptions$overrid === void 0 ? defaultOverridesResolver(lowercaseFirstLetter(componentSlot)) : _inputOptions$overrid,
        options = _objectWithoutProperties(inputOptions, ["name", "slot", "skipVariantsResolver", "skipSx", "overridesResolver"]); // if skipVariantsResolver option is defined, take the value, otherwise, true for root and false for other slots.
      var skipVariantsResolver = inputSkipVariantsResolver !== undefined ? inputSkipVariantsResolver :
      // TODO v6: remove `Root` in the next major release
      // For more details: https://github.com/mui/material-ui/pull/37908
      componentSlot && componentSlot !== 'Root' && componentSlot !== 'root' || false;
      var skipSx = inputSkipSx || false;
      var label;
      {
        if (componentName) {
          // TODO v6: remove `lowercaseFirstLetter()` in the next major release
          // For more details: https://github.com/mui/material-ui/pull/37908
          label = "".concat(componentName, "-").concat(lowercaseFirstLetter(componentSlot || 'Root'));
        }
      }
      var shouldForwardPropOption = shouldForwardProp;

      // TODO v6: remove `Root` in the next major release
      // For more details: https://github.com/mui/material-ui/pull/37908
      if (componentSlot === 'Root' || componentSlot === 'root') {
        shouldForwardPropOption = rootShouldForwardProp;
      } else if (componentSlot) {
        // any other slot specified
        shouldForwardPropOption = slotShouldForwardProp;
      } else if (isStringTag(tag)) {
        // for string (html) tag, preserve the behavior in emotion & styled-components.
        shouldForwardPropOption = undefined;
      }
      var defaultStyledResolver = styled$3(tag, _extends({
        shouldForwardProp: shouldForwardPropOption,
        label: label
      }, options));
      var transformStyleArg = function transformStyleArg(stylesArg) {
        // On the server Emotion doesn't use React.forwardRef for creating components, so the created
        // component stays as a function. This condition makes sure that we do not interpolate functions
        // which are basically components used as a selectors.
        if (typeof stylesArg === 'function' && stylesArg.__emotion_real !== stylesArg || isPlainObject(stylesArg)) {
          return function (props) {
            return processStyleArg(stylesArg, _extends({}, props, {
              theme: resolveTheme({
                theme: props.theme,
                defaultTheme: defaultTheme,
                themeId: themeId
              })
            }));
          };
        }
        return stylesArg;
      };
      var muiStyledResolver = function muiStyledResolver(styleArg) {
        var transformedStyleArg = transformStyleArg(styleArg);
        for (var _len = arguments.length, expressions = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          expressions[_key - 1] = arguments[_key];
        }
        var expressionsWithDefaultTheme = expressions ? expressions.map(transformStyleArg) : [];
        if (componentName && overridesResolver) {
          expressionsWithDefaultTheme.push(function (props) {
            var theme = resolveTheme(_extends({}, props, {
              defaultTheme: defaultTheme,
              themeId: themeId
            }));
            if (!theme.components || !theme.components[componentName] || !theme.components[componentName].styleOverrides) {
              return null;
            }
            var styleOverrides = theme.components[componentName].styleOverrides;
            var resolvedStyleOverrides = {};
            // TODO: v7 remove iteration and use `resolveStyleArg(styleOverrides[slot])` directly
            Object.entries(styleOverrides).forEach(function (_ref3) {
              var _ref4 = _slicedToArray(_ref3, 2),
                slotKey = _ref4[0],
                slotStyle = _ref4[1];
              resolvedStyleOverrides[slotKey] = processStyleArg(slotStyle, _extends({}, props, {
                theme: theme
              }));
            });
            return overridesResolver(props, resolvedStyleOverrides);
          });
        }
        if (componentName && !skipVariantsResolver) {
          expressionsWithDefaultTheme.push(function (props) {
            var _theme$components;
            var theme = resolveTheme(_extends({}, props, {
              defaultTheme: defaultTheme,
              themeId: themeId
            }));
            var themeVariants = theme == null || (_theme$components = theme.components) == null || (_theme$components = _theme$components[componentName]) == null ? void 0 : _theme$components.variants;
            return processStyleArg({
              variants: themeVariants
            }, _extends({}, props, {
              theme: theme
            }));
          });
        }
        if (!skipSx) {
          expressionsWithDefaultTheme.push(systemSx);
        }
        var numOfCustomFnsApplied = expressionsWithDefaultTheme.length - expressions.length;
        if (Array.isArray(styleArg) && numOfCustomFnsApplied > 0) {
          var placeholders = new Array(numOfCustomFnsApplied).fill('');
          // If the type is array, than we need to add placeholders in the template for the overrides, variants and the sx styles.
          transformedStyleArg = [].concat(_toConsumableArray(styleArg), _toConsumableArray(placeholders));
          transformedStyleArg.raw = [].concat(_toConsumableArray(styleArg.raw), _toConsumableArray(placeholders));
        }
        var Component = defaultStyledResolver.apply(void 0, [transformedStyleArg].concat(_toConsumableArray(expressionsWithDefaultTheme)));
        {
          var displayName;
          if (componentName) {
            displayName = "".concat(componentName).concat(capitalize(componentSlot || ''));
          }
          if (displayName === undefined) {
            displayName = "Styled(".concat(getDisplayName(tag), ")");
          }
          Component.displayName = displayName;
        }
        if (tag.muiName) {
          Component.muiName = tag.muiName;
        }
        return Component;
      };
      if (defaultStyledResolver.withConfig) {
        muiStyledResolver.withConfig = defaultStyledResolver.withConfig;
      }
      return muiStyledResolver;
    };
  }

  var styled$2 = createStyled();
  var systemStyled = styled$2;

  /**
   * Add keys, values of `defaultProps` that does not exist in `props`
   * @param {object} defaultProps
   * @param {object} props
   * @returns {object} resolved props
   */
  function resolveProps(defaultProps, props) {
    var output = _extends({}, props);
    Object.keys(defaultProps).forEach(function (propName) {
      if (propName.toString().match(/^(components|slots)$/)) {
        output[propName] = _extends({}, defaultProps[propName], output[propName]);
      } else if (propName.toString().match(/^(componentsProps|slotProps)$/)) {
        var defaultSlotProps = defaultProps[propName] || {};
        var slotProps = props[propName];
        output[propName] = {};
        if (!slotProps || !Object.keys(slotProps)) {
          // Reduce the iteration if the slot props is empty
          output[propName] = defaultSlotProps;
        } else if (!defaultSlotProps || !Object.keys(defaultSlotProps)) {
          // Reduce the iteration if the default slot props is empty
          output[propName] = slotProps;
        } else {
          output[propName] = _extends({}, slotProps);
          Object.keys(defaultSlotProps).forEach(function (slotPropName) {
            output[propName][slotPropName] = resolveProps(defaultSlotProps[slotPropName], slotProps[slotPropName]);
          });
        }
      } else if (output[propName] === undefined) {
        output[propName] = defaultProps[propName];
      }
    });
    return output;
  }

  function getThemeProps(params) {
    var theme = params.theme,
      name = params.name,
      props = params.props;
    if (!theme || !theme.components || !theme.components[name] || !theme.components[name].defaultProps) {
      return props;
    }
    return resolveProps(theme.components[name].defaultProps, props);
  }

  function useThemeProps$c(_ref) {
    var props = _ref.props,
      name = _ref.name,
      defaultTheme = _ref.defaultTheme,
      themeId = _ref.themeId;
    var theme = useTheme$2(defaultTheme);
    if (themeId) {
      theme = theme[themeId] || theme;
    }
    var mergedProps = getThemeProps({
      theme: theme,
      name: name,
      props: props
    });
    return mergedProps;
  }

  /**
   * A version of `React.useLayoutEffect` that does not show a warning when server-side rendering.
   * This is useful for effects that are only needed for client-side rendering but not for SSR.
   *
   * Before you use this hook, make sure to read https://gist.github.com/gaearon/e7d97cdf38a2907924ea12e4ebdf3c85
   * and confirm it doesn't apply to your use-case.
   */
  var useEnhancedEffect = typeof window !== 'undefined' ? React__namespace.useLayoutEffect : React__namespace.useEffect;
  var useEnhancedEffect$1 = useEnhancedEffect;

  /**
   * @deprecated Not used internally. Use `MediaQueryListEvent` from lib.dom.d.ts instead.
   */

  /**
   * @deprecated Not used internally. Use `MediaQueryList` from lib.dom.d.ts instead.
   */

  /**
   * @deprecated Not used internally. Use `(event: MediaQueryListEvent) => void` instead.
   */

  function useMediaQueryOld(query, defaultMatches, matchMedia, ssrMatchMedia, noSsr) {
    var _React$useState = React__namespace.useState(function () {
        if (noSsr && matchMedia) {
          return matchMedia(query).matches;
        }
        if (ssrMatchMedia) {
          return ssrMatchMedia(query).matches;
        }

        // Once the component is mounted, we rely on the
        // event listeners to return the correct matches value.
        return defaultMatches;
      }),
      match = _React$useState[0],
      setMatch = _React$useState[1];
    useEnhancedEffect$1(function () {
      var active = true;
      if (!matchMedia) {
        return undefined;
      }
      var queryList = matchMedia(query);
      var updateMatch = function updateMatch() {
        // Workaround Safari wrong implementation of matchMedia
        // TODO can we remove it?
        // https://github.com/mui/material-ui/pull/17315#issuecomment-528286677
        if (active) {
          setMatch(queryList.matches);
        }
      };
      updateMatch();
      // TODO: Use `addEventListener` once support for Safari < 14 is dropped
      queryList.addListener(updateMatch);
      return function () {
        active = false;
        queryList.removeListener(updateMatch);
      };
    }, [query, matchMedia]);
    return match;
  }

  // eslint-disable-next-line no-useless-concat -- Workaround for https://github.com/webpack/webpack/issues/14814
  var maybeReactUseSyncExternalStore = React__namespace['useSyncExternalStore' + ''];
  function useMediaQueryNew(query, defaultMatches, matchMedia, ssrMatchMedia, noSsr) {
    var getDefaultSnapshot = React__namespace.useCallback(function () {
      return defaultMatches;
    }, [defaultMatches]);
    var getServerSnapshot = React__namespace.useMemo(function () {
      if (noSsr && matchMedia) {
        return function () {
          return matchMedia(query).matches;
        };
      }
      if (ssrMatchMedia !== null) {
        var _ssrMatchMedia = ssrMatchMedia(query),
          matches = _ssrMatchMedia.matches;
        return function () {
          return matches;
        };
      }
      return getDefaultSnapshot;
    }, [getDefaultSnapshot, query, ssrMatchMedia, noSsr, matchMedia]);
    var _React$useMemo = React__namespace.useMemo(function () {
        if (matchMedia === null) {
          return [getDefaultSnapshot, function () {
            return function () {};
          }];
        }
        var mediaQueryList = matchMedia(query);
        return [function () {
          return mediaQueryList.matches;
        }, function (notify) {
          // TODO: Use `addEventListener` once support for Safari < 14 is dropped
          mediaQueryList.addListener(notify);
          return function () {
            mediaQueryList.removeListener(notify);
          };
        }];
      }, [getDefaultSnapshot, matchMedia, query]),
      _React$useMemo2 = _slicedToArray(_React$useMemo, 2),
      getSnapshot = _React$useMemo2[0],
      subscribe = _React$useMemo2[1];
    var match = maybeReactUseSyncExternalStore(subscribe, getSnapshot, getServerSnapshot);
    return match;
  }
  function useMediaQuery(queryInput) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var theme = useTheme$3();
    // Wait for jsdom to support the match media feature.
    // All the browsers MUI support have this built-in.
    // This defensive check is here for simplicity.
    // Most of the time, the match media logic isn't central to people tests.
    var supportMatchMedia = typeof window !== 'undefined' && typeof window.matchMedia !== 'undefined';
    var _getThemeProps = getThemeProps({
        name: 'MuiUseMediaQuery',
        props: options,
        theme: theme
      }),
      _getThemeProps$defaul = _getThemeProps.defaultMatches,
      defaultMatches = _getThemeProps$defaul === void 0 ? false : _getThemeProps$defaul,
      _getThemeProps$matchM = _getThemeProps.matchMedia,
      matchMedia = _getThemeProps$matchM === void 0 ? supportMatchMedia ? window.matchMedia : null : _getThemeProps$matchM,
      _getThemeProps$ssrMat = _getThemeProps.ssrMatchMedia,
      ssrMatchMedia = _getThemeProps$ssrMat === void 0 ? null : _getThemeProps$ssrMat,
      _getThemeProps$noSsr = _getThemeProps.noSsr,
      noSsr = _getThemeProps$noSsr === void 0 ? false : _getThemeProps$noSsr;
    {
      if (typeof queryInput === 'function' && theme === null) {
        console.error(['MUI: The `query` argument provided is invalid.', 'You are providing a function without a theme in the context.', 'One of the parent elements needs to use a ThemeProvider.'].join('\n'));
      }
    }
    var query = typeof queryInput === 'function' ? queryInput(theme) : queryInput;
    query = query.replace(/^@media( ?)/m, '');

    // TODO: Drop `useMediaQueryOld` and use  `use-sync-external-store` shim in `useMediaQueryNew` once the package is stable
    var useMediaQueryImplementation = maybeReactUseSyncExternalStore !== undefined ? useMediaQueryNew : useMediaQueryOld;
    var match = useMediaQueryImplementation(query, defaultMatches, matchMedia, ssrMatchMedia, noSsr);
    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__namespace.useDebugValue({
        query: query,
        match: match
      });
    }
    return match;
  }

  function clamp(val) {
    var min = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Number.MIN_SAFE_INTEGER;
    var max = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : Number.MAX_SAFE_INTEGER;
    return Math.max(min, Math.min(val, max));
  }

  /**
   * Returns a number whose value is limited to the given range.
   * @param {number} value The value to be clamped
   * @param {number} min The lower boundary of the output range
   * @param {number} max The upper boundary of the output range
   * @returns {number} A number in the range [min, max]
   */
  function clampWrapper(value) {
    var min = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var max = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
    {
      if (value < min || value > max) {
        console.error("MUI: The value provided ".concat(value, " is out of range [").concat(min, ", ").concat(max, "]."));
      }
    }
    return clamp(value, min, max);
  }

  /**
   * Converts a color from CSS hex format to CSS rgb format.
   * @param {string} color - Hex color, i.e. #nnn or #nnnnnn
   * @returns {string} A CSS rgb color string
   */
  function hexToRgb(color) {
    color = color.slice(1);
    var re = new RegExp(".{1,".concat(color.length >= 6 ? 2 : 1, "}"), 'g');
    var colors = color.match(re);
    if (colors && colors[0].length === 1) {
      colors = colors.map(function (n) {
        return n + n;
      });
    }
    return colors ? "rgb".concat(colors.length === 4 ? 'a' : '', "(").concat(colors.map(function (n, index) {
      return index < 3 ? parseInt(n, 16) : Math.round(parseInt(n, 16) / 255 * 1000) / 1000;
    }).join(', '), ")") : '';
  }
  function intToHex(_int) {
    var hex = _int.toString(16);
    return hex.length === 1 ? "0".concat(hex) : hex;
  }

  /**
   * Returns an object with the type and values of a color.
   *
   * Note: Does not support rgb % values.
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla(), color()
   * @returns {object} - A MUI color object: {type: string, values: number[]}
   */
  function decomposeColor(color) {
    // Idempotent
    if (color.type) {
      return color;
    }
    if (color.charAt(0) === '#') {
      return decomposeColor(hexToRgb(color));
    }
    var marker = color.indexOf('(');
    var type = color.substring(0, marker);
    if (['rgb', 'rgba', 'hsl', 'hsla', 'color'].indexOf(type) === -1) {
      throw new Error("MUI: Unsupported `".concat(color, "` color.\nThe following formats are supported: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla(), color().") );
    }
    var values = color.substring(marker + 1, color.length - 1);
    var colorSpace;
    if (type === 'color') {
      values = values.split(' ');
      colorSpace = values.shift();
      if (values.length === 4 && values[3].charAt(0) === '/') {
        values[3] = values[3].slice(1);
      }
      if (['srgb', 'display-p3', 'a98-rgb', 'prophoto-rgb', 'rec-2020'].indexOf(colorSpace) === -1) {
        throw new Error("MUI: unsupported `".concat(colorSpace, "` color space.\nThe following color spaces are supported: srgb, display-p3, a98-rgb, prophoto-rgb, rec-2020.") );
      }
    } else {
      values = values.split(',');
    }
    values = values.map(function (value) {
      return parseFloat(value);
    });
    return {
      type: type,
      values: values,
      colorSpace: colorSpace
    };
  }

  /**
   * Returns a channel created from the input color.
   *
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla(), color()
   * @returns {string} - The channel for the color, that can be used in rgba or hsla colors
   */
  var colorChannel = function colorChannel(color) {
    var decomposedColor = decomposeColor(color);
    return decomposedColor.values.slice(0, 3).map(function (val, idx) {
      return decomposedColor.type.indexOf('hsl') !== -1 && idx !== 0 ? "".concat(val, "%") : val;
    }).join(' ');
  };
  var private_safeColorChannel = function private_safeColorChannel(color, warning) {
    try {
      return colorChannel(color);
    } catch (error) {
      if (warning && "development" !== 'production') {
        console.warn(warning);
      }
      return color;
    }
  };

  /**
   * Converts a color object with type and values to a string.
   * @param {object} color - Decomposed color
   * @param {string} color.type - One of: 'rgb', 'rgba', 'hsl', 'hsla', 'color'
   * @param {array} color.values - [n,n,n] or [n,n,n,n]
   * @returns {string} A CSS color string
   */
  function recomposeColor(color) {
    var type = color.type,
      colorSpace = color.colorSpace;
    var values = color.values;
    if (type.indexOf('rgb') !== -1) {
      // Only convert the first 3 values to int (i.e. not alpha)
      values = values.map(function (n, i) {
        return i < 3 ? parseInt(n, 10) : n;
      });
    } else if (type.indexOf('hsl') !== -1) {
      values[1] = "".concat(values[1], "%");
      values[2] = "".concat(values[2], "%");
    }
    if (type.indexOf('color') !== -1) {
      values = "".concat(colorSpace, " ").concat(values.join(' '));
    } else {
      values = "".concat(values.join(', '));
    }
    return "".concat(type, "(").concat(values, ")");
  }

  /**
   * Converts a color from CSS rgb format to CSS hex format.
   * @param {string} color - RGB color, i.e. rgb(n, n, n)
   * @returns {string} A CSS rgb color string, i.e. #nnnnnn
   */
  function rgbToHex(color) {
    // Idempotent
    if (color.indexOf('#') === 0) {
      return color;
    }
    var _decomposeColor = decomposeColor(color),
      values = _decomposeColor.values;
    return "#".concat(values.map(function (n, i) {
      return intToHex(i === 3 ? Math.round(255 * n) : n);
    }).join(''));
  }

  /**
   * Converts a color from hsl format to rgb format.
   * @param {string} color - HSL color values
   * @returns {string} rgb color values
   */
  function hslToRgb(color) {
    color = decomposeColor(color);
    var _color = color,
      values = _color.values;
    var h = values[0];
    var s = values[1] / 100;
    var l = values[2] / 100;
    var a = s * Math.min(l, 1 - l);
    var f = function f(n) {
      var k = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : (n + h / 30) % 12;
      return l - a * Math.max(Math.min(k - 3, 9 - k, 1), -1);
    };
    var type = 'rgb';
    var rgb = [Math.round(f(0) * 255), Math.round(f(8) * 255), Math.round(f(4) * 255)];
    if (color.type === 'hsla') {
      type += 'a';
      rgb.push(values[3]);
    }
    return recomposeColor({
      type: type,
      values: rgb
    });
  }
  /**
   * The relative brightness of any point in a color space,
   * normalized to 0 for darkest black and 1 for lightest white.
   *
   * Formula: https://www.w3.org/TR/WCAG20-TECHS/G17.html#G17-tests
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla(), color()
   * @returns {number} The relative brightness of the color in the range 0 - 1
   */
  function getLuminance(color) {
    color = decomposeColor(color);
    var rgb = color.type === 'hsl' || color.type === 'hsla' ? decomposeColor(hslToRgb(color)).values : color.values;
    rgb = rgb.map(function (val) {
      if (color.type !== 'color') {
        val /= 255; // normalized
      }
      return val <= 0.03928 ? val / 12.92 : Math.pow((val + 0.055) / 1.055, 2.4);
    });

    // Truncate at 3 digits
    return Number((0.2126 * rgb[0] + 0.7152 * rgb[1] + 0.0722 * rgb[2]).toFixed(3));
  }

  /**
   * Calculates the contrast ratio between two colors.
   *
   * Formula: https://www.w3.org/TR/WCAG20-TECHS/G17.html#G17-tests
   * @param {string} foreground - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @param {string} background - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @returns {number} A contrast ratio value in the range 0 - 21.
   */
  function getContrastRatio(foreground, background) {
    var lumA = getLuminance(foreground);
    var lumB = getLuminance(background);
    return (Math.max(lumA, lumB) + 0.05) / (Math.min(lumA, lumB) + 0.05);
  }

  /**
   * Sets the absolute transparency of a color.
   * Any existing alpha values are overwritten.
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla(), color()
   * @param {number} value - value to set the alpha channel to in the range 0 - 1
   * @returns {string} A CSS color string. Hex input values are returned as rgb
   */
  function alpha(color, value) {
    color = decomposeColor(color);
    value = clampWrapper(value);
    if (color.type === 'rgb' || color.type === 'hsl') {
      color.type += 'a';
    }
    if (color.type === 'color') {
      color.values[3] = "/".concat(value);
    } else {
      color.values[3] = value;
    }
    return recomposeColor(color);
  }
  function private_safeAlpha(color, value, warning) {
    try {
      return alpha(color, value);
    } catch (error) {
      if (warning && "development" !== 'production') {
        console.warn(warning);
      }
      return color;
    }
  }

  /**
   * Darkens a color.
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla(), color()
   * @param {number} coefficient - multiplier in the range 0 - 1
   * @returns {string} A CSS color string. Hex input values are returned as rgb
   */
  function darken(color, coefficient) {
    color = decomposeColor(color);
    coefficient = clampWrapper(coefficient);
    if (color.type.indexOf('hsl') !== -1) {
      color.values[2] *= 1 - coefficient;
    } else if (color.type.indexOf('rgb') !== -1 || color.type.indexOf('color') !== -1) {
      for (var i = 0; i < 3; i += 1) {
        color.values[i] *= 1 - coefficient;
      }
    }
    return recomposeColor(color);
  }
  function private_safeDarken(color, coefficient, warning) {
    try {
      return darken(color, coefficient);
    } catch (error) {
      if (warning && "development" !== 'production') {
        console.warn(warning);
      }
      return color;
    }
  }

  /**
   * Lightens a color.
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla(), color()
   * @param {number} coefficient - multiplier in the range 0 - 1
   * @returns {string} A CSS color string. Hex input values are returned as rgb
   */
  function lighten(color, coefficient) {
    color = decomposeColor(color);
    coefficient = clampWrapper(coefficient);
    if (color.type.indexOf('hsl') !== -1) {
      color.values[2] += (100 - color.values[2]) * coefficient;
    } else if (color.type.indexOf('rgb') !== -1) {
      for (var i = 0; i < 3; i += 1) {
        color.values[i] += (255 - color.values[i]) * coefficient;
      }
    } else if (color.type.indexOf('color') !== -1) {
      for (var _i = 0; _i < 3; _i += 1) {
        color.values[_i] += (1 - color.values[_i]) * coefficient;
      }
    }
    return recomposeColor(color);
  }
  function private_safeLighten(color, coefficient, warning) {
    try {
      return lighten(color, coefficient);
    } catch (error) {
      if (warning && "development" !== 'production') {
        console.warn(warning);
      }
      return color;
    }
  }

  /**
   * Darken or lighten a color, depending on its luminance.
   * Light colors are darkened, dark colors are lightened.
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla(), color()
   * @param {number} coefficient=0.15 - multiplier in the range 0 - 1
   * @returns {string} A CSS color string. Hex input values are returned as rgb
   */
  function emphasize(color) {
    var coefficient = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0.15;
    return getLuminance(color) > 0.5 ? darken(color, coefficient) : lighten(color, coefficient);
  }
  function private_safeEmphasize(color, coefficient, warning) {
    try {
      return private_safeEmphasize(color, coefficient);
    } catch (error) {
      if (warning && "development" !== 'production') {
        console.warn(warning);
      }
      return color;
    }
  }

  function chainPropTypes(propType1, propType2) {
    return function validate() {
      return propType1.apply(void 0, arguments) || propType2.apply(void 0, arguments);
    };
  }

  function isClassComponent$1(elementType) {
    // elementType.prototype?.isReactComponent
    var _elementType$prototyp = elementType.prototype,
      prototype = _elementType$prototyp === void 0 ? {} : _elementType$prototyp;
    return Boolean(prototype.isReactComponent);
  }
  function acceptingRef(props, propName, componentName, location, propFullName) {
    var element = props[propName];
    var safePropName = propFullName || propName;
    if (element == null ||
    // When server-side rendering React doesn't warn either.
    // This is not an accurate check for SSR.
    // This is only in place for Emotion compat.
    // TODO: Revisit once https://github.com/facebook/react/issues/20047 is resolved.
    typeof window === 'undefined') {
      return null;
    }
    var warningHint;
    var elementType = element.type;
    /**
     * Blacklisting instead of whitelisting
     *
     * Blacklisting will miss some components, such as React.Fragment. Those will at least
     * trigger a warning in React.
     * We can't whitelist because there is no safe way to detect React.forwardRef
     * or class components. "Safe" means there's no public API.
     *
     */
    if (typeof elementType === 'function' && !isClassComponent$1(elementType)) {
      warningHint = 'Did you accidentally use a plain function component for an element instead?';
    }
    if (warningHint !== undefined) {
      return new Error("Invalid ".concat(location, " `").concat(safePropName, "` supplied to `").concat(componentName, "`. ") + "Expected an element that can hold a ref. ".concat(warningHint, " ") + 'For more information see https://mui.com/r/caveat-with-refs-guide');
    }
    return null;
  }
  var elementAcceptingRef = chainPropTypes(PropTypes.element, acceptingRef);
  elementAcceptingRef.isRequired = chainPropTypes(PropTypes.element.isRequired, acceptingRef);
  var elementAcceptingRef$1 = elementAcceptingRef;

  function isClassComponent(elementType) {
    // elementType.prototype?.isReactComponent
    var _elementType$prototyp = elementType.prototype,
      prototype = _elementType$prototyp === void 0 ? {} : _elementType$prototyp;
    return Boolean(prototype.isReactComponent);
  }
  function elementTypeAcceptingRef(props, propName, componentName, location, propFullName) {
    var propValue = props[propName];
    var safePropName = propFullName || propName;
    if (propValue == null ||
    // When server-side rendering React doesn't warn either.
    // This is not an accurate check for SSR.
    // This is only in place for emotion compat.
    // TODO: Revisit once https://github.com/facebook/react/issues/20047 is resolved.
    typeof window === 'undefined') {
      return null;
    }
    var warningHint;

    /**
     * Blacklisting instead of whitelisting
     *
     * Blacklisting will miss some components, such as React.Fragment. Those will at least
     * trigger a warning in React.
     * We can't whitelist because there is no safe way to detect React.forwardRef
     * or class components. "Safe" means there's no public API.
     *
     */
    if (typeof propValue === 'function' && !isClassComponent(propValue)) {
      warningHint = 'Did you accidentally provide a plain function component instead?';
    }
    if (warningHint !== undefined) {
      return new Error("Invalid ".concat(location, " `").concat(safePropName, "` supplied to `").concat(componentName, "`. ") + "Expected an element type that can hold a ref. ".concat(warningHint, " ") + 'For more information see https://mui.com/r/caveat-with-refs-guide');
    }
    return null;
  }
  var elementTypeAcceptingRef$1 = chainPropTypes(PropTypes.elementType, elementTypeAcceptingRef);

  // This module is based on https://github.com/airbnb/prop-types-exact repository.
  // However, in order to reduce the number of dependencies and to remove some extra safe checks
  // the module was forked.

  var specialProperty = "exact-prop: \u200B";
  function exactProp(propTypes) {
    return _extends({}, propTypes, _defineProperty({}, specialProperty, function (props) {
      var unsupportedProps = Object.keys(props).filter(function (prop) {
        return !propTypes.hasOwnProperty(prop);
      });
      if (unsupportedProps.length > 0) {
        return new Error("The following props are not supported: ".concat(unsupportedProps.map(function (prop) {
          return "`".concat(prop, "`");
        }).join(', '), ". Please remove them."));
      }
      return null;
    }));
  }

  function HTMLElementType(props, propName, componentName, location, propFullName) {
    var propValue = props[propName];
    var safePropName = propFullName || propName;
    if (propValue == null) {
      return null;
    }
    if (propValue && propValue.nodeType !== 1) {
      return new Error("Invalid ".concat(location, " `").concat(safePropName, "` supplied to `").concat(componentName, "`. ") + "Expected an HTMLElement.");
    }
    return null;
  }

  var refType = PropTypes.oneOfType([PropTypes.func, PropTypes.object]);
  var refType$1 = refType;

  /**
   * Safe chained function.
   *
   * Will only create a new function if needed,
   * otherwise will pass back existing functions or null.
   */
  function createChainedFunction() {
    for (var _len = arguments.length, funcs = new Array(_len), _key = 0; _key < _len; _key++) {
      funcs[_key] = arguments[_key];
    }
    return funcs.reduce(function (acc, func) {
      if (func == null) {
        return acc;
      }
      return function chainedFunction() {
        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          args[_key2] = arguments[_key2];
        }
        acc.apply(this, args);
        func.apply(this, args);
      };
    }, function () {});
  }

  // Corresponds to 10 frames at 60 Hz.
  // A few bytes payload overhead when lodash/debounce is ~3 kB and debounce ~300 B.
  function debounce$1(func) {
    var wait = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 166;
    var timeout;
    function debounced() {
      var _this = this;
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      var later = function later() {
        // @ts-ignore
        func.apply(_this, args);
      };
      clearTimeout(timeout);
      timeout = setTimeout(later, wait);
    }
    debounced.clear = function () {
      clearTimeout(timeout);
    };
    return debounced;
  }

  function deprecatedPropType(validator, reason) {
    return function (props, propName, componentName, location, propFullName) {
      var componentNameSafe = componentName || '<<anonymous>>';
      var propFullNameSafe = propFullName || propName;
      if (typeof props[propName] !== 'undefined') {
        return new Error("The ".concat(location, " `").concat(propFullNameSafe, "` of ") + "`".concat(componentNameSafe, "` is deprecated. ").concat(reason));
      }
      return null;
    };
  }

  function isMuiElement(element, muiNames) {
    var _muiName, _element$type;
    return /*#__PURE__*/React__namespace.isValidElement(element) && muiNames.indexOf( // For server components `muiName` is avaialble in element.type._payload.value.muiName
    // relevant info - https://github.com/facebook/react/blob/2807d781a08db8e9873687fccc25c0f12b4fb3d4/packages/react/src/ReactLazy.js#L45
    // eslint-disable-next-line no-underscore-dangle
    (_muiName = element.type.muiName) != null ? _muiName : (_element$type = element.type) == null || (_element$type = _element$type._payload) == null || (_element$type = _element$type.value) == null ? void 0 : _element$type.muiName) !== -1;
  }

  function ownerDocument(node) {
    return node && node.ownerDocument || document;
  }

  function ownerWindow(node) {
    var doc = ownerDocument(node);
    return doc.defaultView || window;
  }

  function requirePropFactory(componentNameInError, Component) {

    // eslint-disable-next-line react/forbid-foreign-prop-types
    var prevPropTypes = Component ? _extends({}, Component.propTypes) : null;
    var requireProp = function requireProp(requiredProp) {
      return function (props, propName, componentName, location, propFullName) {
        var propFullNameSafe = propFullName || propName;
        var defaultTypeChecker = prevPropTypes == null ? void 0 : prevPropTypes[propFullNameSafe];
        if (defaultTypeChecker) {
          for (var _len = arguments.length, args = new Array(_len > 5 ? _len - 5 : 0), _key = 5; _key < _len; _key++) {
            args[_key - 5] = arguments[_key];
          }
          var typeCheckerResult = defaultTypeChecker.apply(void 0, [props, propName, componentName, location, propFullName].concat(args));
          if (typeCheckerResult) {
            return typeCheckerResult;
          }
        }
        if (typeof props[propName] !== 'undefined' && !props[requiredProp]) {
          return new Error("The prop `".concat(propFullNameSafe, "` of ") + "`".concat(componentNameInError, "` can only be used together with the `").concat(requiredProp, "` prop."));
        }
        return null;
      };
    };
    return requireProp;
  }

  /**
   * TODO v5: consider making it private
   *
   * passes {value} to {ref}
   *
   * WARNING: Be sure to only call this inside a callback that is passed as a ref.
   * Otherwise, make sure to cleanup the previous {ref} if it changes. See
   * https://github.com/mui/material-ui/issues/13539
   *
   * Useful if you want to expose the ref of an inner component to the public API
   * while still using it inside the component.
   * @param ref A ref callback or ref object. If anything falsy, this is a no-op.
   */
  function setRef(ref, value) {
    if (typeof ref === 'function') {
      ref(value);
    } else if (ref) {
      ref.current = value;
    }
  }

  var globalId = 0;
  function useGlobalId(idOverride) {
    var _React$useState = React__namespace.useState(idOverride),
      defaultId = _React$useState[0],
      setDefaultId = _React$useState[1];
    var id = idOverride || defaultId;
    React__namespace.useEffect(function () {
      if (defaultId == null) {
        // Fallback to this default id when possible.
        // Use the incrementing value for client-side rendering only.
        // We can't use it server-side.
        // If you want to use random values please consider the Birthday Problem: https://en.wikipedia.org/wiki/Birthday_problem
        globalId += 1;
        setDefaultId("mui-".concat(globalId));
      }
    }, [defaultId]);
    return id;
  }

  // downstream bundlers may remove unnecessary concatenation, but won't remove toString call -- Workaround for https://github.com/webpack/webpack/issues/14814
  var maybeReactUseId = React__namespace['useId'.toString()];
  /**
   *
   * @example <div id={useId()} />
   * @param idOverride
   * @returns {string}
   */
  function useId(idOverride) {
    if (maybeReactUseId !== undefined) {
      var reactId = maybeReactUseId();
      return idOverride != null ? idOverride : reactId;
    }
    // eslint-disable-next-line react-hooks/rules-of-hooks -- `React.useId` is invariant at runtime.
    return useGlobalId(idOverride);
  }

  function unsupportedProp(props, propName, componentName, location, propFullName) {
    var propFullNameSafe = propFullName || propName;
    if (typeof props[propName] !== 'undefined') {
      return new Error("The prop `".concat(propFullNameSafe, "` is not supported. Please remove it."));
    }
    return null;
  }

  function useControlled(_ref) {
    var controlled = _ref.controlled,
      defaultProp = _ref["default"],
      name = _ref.name,
      _ref$state = _ref.state,
      state = _ref$state === void 0 ? 'value' : _ref$state;
    // isControlled is ignored in the hook dependency lists as it should never change.
    var _React$useRef = React__namespace.useRef(controlled !== undefined),
      isControlled = _React$useRef.current;
    var _React$useState = React__namespace.useState(defaultProp),
      valueState = _React$useState[0],
      setValue = _React$useState[1];
    var value = isControlled ? controlled : valueState;
    {
      React__namespace.useEffect(function () {
        if (isControlled !== (controlled !== undefined)) {
          console.error(["MUI: A component is changing the ".concat(isControlled ? '' : 'un', "controlled ").concat(state, " state of ").concat(name, " to be ").concat(isControlled ? 'un' : '', "controlled."), 'Elements should not switch from uncontrolled to controlled (or vice versa).', "Decide between using a controlled or uncontrolled ".concat(name, " ") + 'element for the lifetime of the component.', "The nature of the state is determined during the first render. It's considered controlled if the value is not `undefined`.", 'More info: https://fb.me/react-controlled-components'].join('\n'));
        }
      }, [state, name, controlled]);
      var _React$useRef2 = React__namespace.useRef(defaultProp),
        defaultValue = _React$useRef2.current;
      React__namespace.useEffect(function () {
        if (!isControlled && defaultValue !== defaultProp) {
          console.error(["MUI: A component is changing the default ".concat(state, " state of an uncontrolled ").concat(name, " after being initialized. ") + "To suppress this warning opt to use a controlled ".concat(name, ".")].join('\n'));
        }
      }, [JSON.stringify(defaultProp)]);
    }
    var setValueIfUncontrolled = React__namespace.useCallback(function (newValue) {
      if (!isControlled) {
        setValue(newValue);
      }
    }, []);
    return [value, setValueIfUncontrolled];
  }

  /**
   * Inspired by https://github.com/facebook/react/issues/14099#issuecomment-440013892
   * See RFC in https://github.com/reactjs/rfcs/pull/220
   */

  function useEventCallback(fn) {
    var ref = React__namespace.useRef(fn);
    useEnhancedEffect$1(function () {
      ref.current = fn;
    });
    return React__namespace.useRef(function () {
      return (
        // @ts-expect-error hide `this`
        (ref.current).apply(void 0, arguments)
      );
    }).current;
  }

  function useForkRef() {
    for (var _len = arguments.length, refs = new Array(_len), _key = 0; _key < _len; _key++) {
      refs[_key] = arguments[_key];
    }
    /**
     * This will create a new function if the refs passed to this hook change and are all defined.
     * This means react will call the old forkRef with `null` and the new forkRef
     * with the ref. Cleanup naturally emerges from this behavior.
     */
    return React__namespace.useMemo(function () {
      if (refs.every(function (ref) {
        return ref == null;
      })) {
        return null;
      }
      return function (instance) {
        refs.forEach(function (ref) {
          setRef(ref, instance);
        });
      };
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, refs);
  }

  var UNINITIALIZED = {};

  /**
   * A React.useRef() that is initialized lazily with a function. Note that it accepts an optional
   * initialization argument, so the initialization function doesn't need to be an inline closure.
   *
   * @usage
   *   const ref = useLazyRef(sortColumns, columns)
   */
  function useLazyRef(init, initArg) {
    var ref = React__namespace.useRef(UNINITIALIZED);
    if (ref.current === UNINITIALIZED) {
      ref.current = init(initArg);
    }
    return ref;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, toPropertyKey(descriptor.key), descriptor);
    }
  }
  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    Object.defineProperty(Constructor, "prototype", {
      writable: false
    });
    return Constructor;
  }

  var EMPTY = [];

  /**
   * A React.useEffect equivalent that runs once, when the component is mounted.
   */
  function useOnMount(fn) {
    /* eslint-disable react-hooks/exhaustive-deps */
    React__namespace.useEffect(fn, EMPTY);
    /* eslint-enable react-hooks/exhaustive-deps */
  }

  var Timeout = /*#__PURE__*/function () {
    function Timeout() {
      var _this = this;
      _classCallCheck(this, Timeout);
      this.currentId = null;
      this.clear = function () {
        if (_this.currentId !== null) {
          clearTimeout(_this.currentId);
          _this.currentId = null;
        }
      };
      this.disposeEffect = function () {
        return _this.clear;
      };
    }
    _createClass(Timeout, [{
      key: "start",
      value:
      /**
       * Executes `fn` after `delay`, clearing any previously scheduled call.
       */
      function start(delay, fn) {
        var _this2 = this;
        this.clear();
        this.currentId = setTimeout(function () {
          _this2.currentId = null;
          fn();
        }, delay);
      }
    }], [{
      key: "create",
      value: function create() {
        return new Timeout();
      }
    }]);
    return Timeout;
  }();
  function useTimeout() {
    var timeout = useLazyRef(Timeout.create).current;
    useOnMount(timeout.disposeEffect);
    return timeout;
  }

  var hadKeyboardEvent = true;
  var hadFocusVisibleRecently = false;
  var hadFocusVisibleRecentlyTimeout = new Timeout();
  var inputTypesWhitelist = {
    text: true,
    search: true,
    url: true,
    tel: true,
    email: true,
    password: true,
    number: true,
    date: true,
    month: true,
    week: true,
    time: true,
    datetime: true,
    'datetime-local': true
  };

  /**
   * Computes whether the given element should automatically trigger the
   * `focus-visible` class being added, i.e. whether it should always match
   * `:focus-visible` when focused.
   * @param {Element} node
   * @returns {boolean}
   */
  function focusTriggersKeyboardModality(node) {
    var _ref = node,
      type = _ref.type,
      tagName = _ref.tagName;
    if (tagName === 'INPUT' && inputTypesWhitelist[type] && !node.readOnly) {
      return true;
    }
    if (tagName === 'TEXTAREA' && !node.readOnly) {
      return true;
    }
    if (node.isContentEditable) {
      return true;
    }
    return false;
  }

  /**
   * Keep track of our keyboard modality state with `hadKeyboardEvent`.
   * If the most recent user interaction was via the keyboard;
   * and the key press did not include a meta, alt/option, or control key;
   * then the modality is keyboard. Otherwise, the modality is not keyboard.
   * @param {KeyboardEvent} event
   */
  function handleKeyDown(event) {
    if (event.metaKey || event.altKey || event.ctrlKey) {
      return;
    }
    hadKeyboardEvent = true;
  }

  /**
   * If at any point a user clicks with a pointing device, ensure that we change
   * the modality away from keyboard.
   * This avoids the situation where a user presses a key on an already focused
   * element, and then clicks on a different element, focusing it with a
   * pointing device, while we still think we're in keyboard modality.
   */
  function handlePointerDown() {
    hadKeyboardEvent = false;
  }
  function handleVisibilityChange() {
    if (this.visibilityState === 'hidden') {
      // If the tab becomes active again, the browser will handle calling focus
      // on the element (Safari actually calls it twice).
      // If this tab change caused a blur on an element with focus-visible,
      // re-apply the class when the user switches back to the tab.
      if (hadFocusVisibleRecently) {
        hadKeyboardEvent = true;
      }
    }
  }
  function prepare(doc) {
    doc.addEventListener('keydown', handleKeyDown, true);
    doc.addEventListener('mousedown', handlePointerDown, true);
    doc.addEventListener('pointerdown', handlePointerDown, true);
    doc.addEventListener('touchstart', handlePointerDown, true);
    doc.addEventListener('visibilitychange', handleVisibilityChange, true);
  }
  function isFocusVisible(event) {
    var target = event.target;
    try {
      return target.matches(':focus-visible');
    } catch (error) {
      // Browsers not implementing :focus-visible will throw a SyntaxError.
      // We use our own heuristic for those browsers.
      // Rethrow might be better if it's not the expected error but do we really
      // want to crash if focus-visible malfunctioned?
    }

    // No need for validFocusTarget check. The user does that by attaching it to
    // focusable events only.
    return hadKeyboardEvent || focusTriggersKeyboardModality(target);
  }
  function useIsFocusVisible() {
    var ref = React__namespace.useCallback(function (node) {
      if (node != null) {
        prepare(node.ownerDocument);
      }
    }, []);
    var isFocusVisibleRef = React__namespace.useRef(false);

    /**
     * Should be called if a blur event is fired
     */
    function handleBlurVisible() {
      // checking against potential state variable does not suffice if we focus and blur synchronously.
      // React wouldn't have time to trigger a re-render so `focusVisible` would be stale.
      // Ideally we would adjust `isFocusVisible(event)` to look at `relatedTarget` for blur events.
      // This doesn't work in IE11 due to https://github.com/facebook/react/issues/3751
      // TODO: check again if React releases their internal changes to focus event handling (https://github.com/facebook/react/pull/19186).
      if (isFocusVisibleRef.current) {
        // To detect a tab/window switch, we look for a blur event followed
        // rapidly by a visibility change.
        // If we don't see a visibility change within 100ms, it's probably a
        // regular focus change.
        hadFocusVisibleRecently = true;
        hadFocusVisibleRecentlyTimeout.start(100, function () {
          hadFocusVisibleRecently = false;
        });
        isFocusVisibleRef.current = false;
        return true;
      }
      return false;
    }

    /**
     * Should be called if a blur event is fired
     */
    function handleFocusVisible(event) {
      if (isFocusVisible(event)) {
        isFocusVisibleRef.current = true;
        return true;
      }
      return false;
    }
    return {
      isFocusVisibleRef: isFocusVisibleRef,
      onFocus: handleFocusVisible,
      onBlur: handleBlurVisible,
      ref: ref
    };
  }

  // A change of the browser zoom change the scrollbar size.
  // Credit https://github.com/twbs/bootstrap/blob/488fd8afc535ca3a6ad4dc581f5e89217b6a36ac/js/src/util/scrollbar.js#L14-L18
  function getScrollbarSize(doc) {
    // https://developer.mozilla.org/en-US/docs/Web/API/Window/innerWidth#usage_notes
    var documentWidth = doc.documentElement.clientWidth;
    return Math.abs(window.innerWidth - documentWidth);
  }

  // Source from https://github.com/alitaheri/normalize-scroll-left
  var cachedType;

  /**
   * Based on the jquery plugin https://github.com/othree/jquery.rtl-scroll-type
   *
   * Types of scrollLeft, assuming scrollWidth=100 and direction is rtl.
   *
   * Type             | <- Most Left | Most Right -> | Initial
   * ---------------- | ------------ | ------------- | -------
   * default          | 0            | 100           | 100
   * negative (spec*) | -100         | 0             | 0
   * reverse          | 100          | 0             | 0
   *
   * Edge 85: default
   * Safari 14: negative
   * Chrome 85: negative
   * Firefox 81: negative
   * IE11: reverse
   *
   * spec* https://drafts.csswg.org/cssom-view/#dom-window-scroll
   */
  function detectScrollType() {
    if (cachedType) {
      return cachedType;
    }
    var dummy = document.createElement('div');
    var container = document.createElement('div');
    container.style.width = '10px';
    container.style.height = '1px';
    dummy.appendChild(container);
    dummy.dir = 'rtl';
    dummy.style.fontSize = '14px';
    dummy.style.width = '4px';
    dummy.style.height = '1px';
    dummy.style.position = 'absolute';
    dummy.style.top = '-1000px';
    dummy.style.overflow = 'scroll';
    document.body.appendChild(dummy);
    cachedType = 'reverse';
    if (dummy.scrollLeft > 0) {
      cachedType = 'default';
    } else {
      dummy.scrollLeft = 1;
      if (dummy.scrollLeft === 0) {
        cachedType = 'negative';
      }
    }
    document.body.removeChild(dummy);
    return cachedType;
  }

  // Based on https://stackoverflow.com/a/24394376
  function getNormalizedScrollLeft(element, direction) {
    var scrollLeft = element.scrollLeft;

    // Perform the calculations only when direction is rtl to avoid messing up the ltr behavior
    if (direction !== 'rtl') {
      return scrollLeft;
    }
    var type = detectScrollType();
    switch (type) {
      case 'negative':
        return element.scrollWidth - element.clientWidth + scrollLeft;
      case 'reverse':
        return element.scrollWidth - element.clientWidth - scrollLeft;
      default:
        return scrollLeft;
    }
  }

  var usePreviousProps = function usePreviousProps(value) {
    var ref = React__namespace.useRef({});
    React__namespace.useEffect(function () {
      ref.current = value;
    });
    return ref.current;
  };
  var usePreviousProps$1 = usePreviousProps;

  /**
   * Gets only the valid children of a component,
   * and ignores any nullish or falsy child.
   *
   * @param children the children
   */
  function getValidReactChildren(children) {
    return React__namespace.Children.toArray(children).filter(function (child) {
      return /*#__PURE__*/React__namespace.isValidElement(child);
    });
  }

  var visuallyHidden = {
    border: 0,
    clip: 'rect(0 0 0 0)',
    height: '1px',
    margin: '-1px',
    overflow: 'hidden',
    padding: 0,
    position: 'absolute',
    whiteSpace: 'nowrap',
    width: '1px'
  };
  var visuallyHidden$1 = visuallyHidden;

  function getTypeByValue(value) {
    var valueType = _typeof(value);
    switch (valueType) {
      case 'number':
        if (Number.isNaN(value)) {
          return 'NaN';
        }
        if (!Number.isFinite(value)) {
          return 'Infinity';
        }
        if (value !== Math.floor(value)) {
          return 'float';
        }
        return 'number';
      case 'object':
        if (value === null) {
          return 'null';
        }
        return value.constructor.name;
      default:
        return valueType;
    }
  }

  // IE 11 support
  function ponyfillIsInteger(x) {
    // eslint-disable-next-line no-restricted-globals
    return typeof x === 'number' && isFinite(x) && Math.floor(x) === x;
  }
  var isInteger = Number.isInteger || ponyfillIsInteger;
  function requiredInteger(props, propName, componentName, location) {
    var propValue = props[propName];
    if (propValue == null || !isInteger(propValue)) {
      var propType = getTypeByValue(propValue);
      return new RangeError("Invalid ".concat(location, " `").concat(propName, "` of type `").concat(propType, "` supplied to `").concat(componentName, "`, expected `integer`."));
    }
    return null;
  }
  function validator(props, propName) {
    var propValue = props[propName];
    if (propValue === undefined) {
      return null;
    }
    for (var _len = arguments.length, other = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      other[_key - 2] = arguments[_key];
    }
    return requiredInteger.apply(void 0, [props, propName].concat(other));
  }
  function validatorNoop() {
    return null;
  }
  validator.isRequired = requiredInteger;
  validatorNoop.isRequired = validatorNoop;
  var integerPropType = validator;

  function composeClasses(slots, getUtilityClass) {
    var classes = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : undefined;
    var output = {};
    Object.keys(slots).forEach(
    // `Object.keys(slots)` can't be wider than `T` because we infer `T` from `slots`.
    // @ts-expect-error https://github.com/microsoft/TypeScript/pull/12253#issuecomment-263132208
    function (slot) {
      output[slot] = slots[slot].reduce(function (acc, key) {
        if (key) {
          var utilityClass = getUtilityClass(key);
          if (utilityClass !== '') {
            acc.push(utilityClass);
          }
          if (classes && classes[key]) {
            acc.push(classes[key]);
          }
        }
        return acc;
      }, []).join(' ');
    });
    return output;
  }

  var ThemeContext = /*#__PURE__*/React__namespace.createContext(null);
  {
    ThemeContext.displayName = 'ThemeContext';
  }
  var ThemeContext$1 = ThemeContext;

  function useTheme$1() {
    var theme = React__namespace.useContext(ThemeContext$1);
    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__namespace.useDebugValue(theme);
    }
    return theme;
  }

  var hasSymbol = typeof Symbol === 'function' && Symbol["for"];
  var nested = hasSymbol ? Symbol["for"]('mui.nested') : '__THEME_NESTED__';

  function mergeOuterLocalTheme(outerTheme, localTheme) {
    if (typeof localTheme === 'function') {
      var mergedTheme = localTheme(outerTheme);
      {
        if (!mergedTheme) {
          console.error(['MUI: You should return an object from your theme function, i.e.', '<ThemeProvider theme={() => ({})} />'].join('\n'));
        }
      }
      return mergedTheme;
    }
    return _extends({}, outerTheme, localTheme);
  }

  /**
   * This component takes a `theme` prop.
   * It makes the `theme` available down the React tree thanks to React context.
   * This component should preferably be used at **the root of your component tree**.
   */
  function ThemeProvider$2(props) {
    var children = props.children,
      localTheme = props.theme;
    var outerTheme = useTheme$1();
    {
      if (outerTheme === null && typeof localTheme === 'function') {
        console.error(['MUI: You are providing a theme function prop to the ThemeProvider component:', '<ThemeProvider theme={outerTheme => outerTheme} />', '', 'However, no outer theme is present.', 'Make sure a theme is already injected higher in the React tree ' + 'or provide a theme object.'].join('\n'));
      }
    }
    var theme = React__namespace.useMemo(function () {
      var output = outerTheme === null ? localTheme : mergeOuterLocalTheme(outerTheme, localTheme);
      if (output != null) {
        output[nested] = outerTheme !== null;
      }
      return output;
    }, [localTheme, outerTheme]);
    return /*#__PURE__*/jsxRuntime_1(ThemeContext$1.Provider, {
      value: theme,
      children: children
    });
  }
  ThemeProvider$2.propTypes = {
    /**
     * Your component tree.
     */
    children: PropTypes.node,
    /**
     * A theme object. You can provide a function to extend the outer theme.
     */
    theme: PropTypes.oneOfType([PropTypes.object, PropTypes.func]).isRequired
  } ;
  {
    ThemeProvider$2.propTypes = exactProp(ThemeProvider$2.propTypes) ;
  }

  var RtlContext = /*#__PURE__*/React__namespace.createContext();
  function RtlProvider(_ref) {
    var value = _ref.value,
      props = _objectWithoutProperties(_ref, ["value"]);
    return /*#__PURE__*/jsxRuntime_1(RtlContext.Provider, _extends({
      value: value != null ? value : true
    }, props));
  }
  RtlProvider.propTypes = {
    children: PropTypes.node,
    value: PropTypes.bool
  } ;
  var useRtl = function useRtl() {
    var value = React__namespace.useContext(RtlContext);
    return value != null ? value : false;
  };

  var EMPTY_THEME = {};
  function useThemeScoping(themeId, upperTheme, localTheme) {
    var isPrivate = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
    return React__namespace.useMemo(function () {
      var resolvedTheme = themeId ? upperTheme[themeId] || upperTheme : upperTheme;
      if (typeof localTheme === 'function') {
        var mergedTheme = localTheme(resolvedTheme);
        var result = themeId ? _extends({}, upperTheme, _defineProperty({}, themeId, mergedTheme)) : mergedTheme;
        // must return a function for the private theme to NOT merge with the upper theme.
        // see the test case "use provided theme from a callback" in ThemeProvider.test.js
        if (isPrivate) {
          return function () {
            return result;
          };
        }
        return result;
      }
      return themeId ? _extends({}, upperTheme, _defineProperty({}, themeId, localTheme)) : _extends({}, upperTheme, localTheme);
    }, [themeId, upperTheme, localTheme, isPrivate]);
  }

  /**
   * This component makes the `theme` available down the React tree.
   * It should preferably be used at **the root of your component tree**.
   *
   * <ThemeProvider theme={theme}> // existing use case
   * <ThemeProvider theme={{ id: theme }}> // theme scoping
   */
  function ThemeProvider$1(props) {
    var children = props.children,
      localTheme = props.theme,
      themeId = props.themeId;
    var upperTheme = useTheme$3(EMPTY_THEME);
    var upperPrivateTheme = useTheme$1() || EMPTY_THEME;
    {
      if (upperTheme === null && typeof localTheme === 'function' || themeId && upperTheme && !upperTheme[themeId] && typeof localTheme === 'function') {
        console.error(['MUI: You are providing a theme function prop to the ThemeProvider component:', '<ThemeProvider theme={outerTheme => outerTheme} />', '', 'However, no outer theme is present.', 'Make sure a theme is already injected higher in the React tree ' + 'or provide a theme object.'].join('\n'));
      }
    }
    var engineTheme = useThemeScoping(themeId, upperTheme, localTheme);
    var privateTheme = useThemeScoping(themeId, upperPrivateTheme, localTheme, true);
    var rtlValue = engineTheme.direction === 'rtl';
    return /*#__PURE__*/jsxRuntime_1(ThemeProvider$2, {
      theme: privateTheme,
      children: /*#__PURE__*/jsxRuntime_1(ThemeContext$2.Provider, {
        value: engineTheme,
        children: /*#__PURE__*/jsxRuntime_1(RtlProvider, {
          value: rtlValue,
          children: children
        })
      })
    });
  }
  ThemeProvider$1.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * Your component tree.
     */
    children: PropTypes.node,
    /**
     * A theme object. You can provide a function to extend the outer theme.
     */
    theme: PropTypes.oneOfType([PropTypes.func, PropTypes.object]).isRequired,
    /**
     * The design system's unique id for getting the corresponded theme when there are multiple design systems.
     */
    themeId: PropTypes.string
  } ;
  {
    ThemeProvider$1.propTypes = exactProp(ThemeProvider$1.propTypes) ;
  }

  var DEFAULT_MODE_STORAGE_KEY = 'mode';
  var DEFAULT_COLOR_SCHEME_STORAGE_KEY = 'color-scheme';
  var DEFAULT_ATTRIBUTE = 'data-color-scheme';
  function getInitColorSchemeScript$1(options) {
    var _ref = options || {},
      _ref$defaultMode = _ref.defaultMode,
      defaultMode = _ref$defaultMode === void 0 ? 'light' : _ref$defaultMode,
      _ref$defaultLightColo = _ref.defaultLightColorScheme,
      defaultLightColorScheme = _ref$defaultLightColo === void 0 ? 'light' : _ref$defaultLightColo,
      _ref$defaultDarkColor = _ref.defaultDarkColorScheme,
      defaultDarkColorScheme = _ref$defaultDarkColor === void 0 ? 'dark' : _ref$defaultDarkColor,
      _ref$modeStorageKey = _ref.modeStorageKey,
      modeStorageKey = _ref$modeStorageKey === void 0 ? DEFAULT_MODE_STORAGE_KEY : _ref$modeStorageKey,
      _ref$colorSchemeStora = _ref.colorSchemeStorageKey,
      colorSchemeStorageKey = _ref$colorSchemeStora === void 0 ? DEFAULT_COLOR_SCHEME_STORAGE_KEY : _ref$colorSchemeStora,
      _ref$attribute = _ref.attribute,
      attribute = _ref$attribute === void 0 ? DEFAULT_ATTRIBUTE : _ref$attribute,
      _ref$colorSchemeNode = _ref.colorSchemeNode,
      colorSchemeNode = _ref$colorSchemeNode === void 0 ? 'document.documentElement' : _ref$colorSchemeNode;
    return /*#__PURE__*/jsxRuntime_1("script", {
      // eslint-disable-next-line react/no-danger
      dangerouslySetInnerHTML: {
        __html: "(function() {\ntry {\n  var mode = localStorage.getItem('".concat(modeStorageKey, "') || '").concat(defaultMode, "';\n  var colorScheme = '';\n  if (mode === 'system') {\n    // handle system mode\n    var mql = window.matchMedia('(prefers-color-scheme: dark)');\n    if (mql.matches) {\n      colorScheme = localStorage.getItem('").concat(colorSchemeStorageKey, "-dark') || '").concat(defaultDarkColorScheme, "';\n    } else {\n      colorScheme = localStorage.getItem('").concat(colorSchemeStorageKey, "-light') || '").concat(defaultLightColorScheme, "';\n    }\n  }\n  if (mode === 'light') {\n    colorScheme = localStorage.getItem('").concat(colorSchemeStorageKey, "-light') || '").concat(defaultLightColorScheme, "';\n  }\n  if (mode === 'dark') {\n    colorScheme = localStorage.getItem('").concat(colorSchemeStorageKey, "-dark') || '").concat(defaultDarkColorScheme, "';\n  }\n  if (colorScheme) {\n    ").concat(colorSchemeNode, ".setAttribute('").concat(attribute, "', colorScheme);\n  }\n} catch(e){}})();")
      }
    }, "mui-color-scheme-init");
  }

  function getSystemMode(mode) {
    if (typeof window !== 'undefined' && mode === 'system') {
      var mql = window.matchMedia('(prefers-color-scheme: dark)');
      if (mql.matches) {
        return 'dark';
      }
      return 'light';
    }
    return undefined;
  }
  function processState(state, callback) {
    if (state.mode === 'light' || state.mode === 'system' && state.systemMode === 'light') {
      return callback('light');
    }
    if (state.mode === 'dark' || state.mode === 'system' && state.systemMode === 'dark') {
      return callback('dark');
    }
    return undefined;
  }
  function getColorScheme(state) {
    return processState(state, function (mode) {
      if (mode === 'light') {
        return state.lightColorScheme;
      }
      if (mode === 'dark') {
        return state.darkColorScheme;
      }
      return undefined;
    });
  }
  function initializeValue(key, defaultValue) {
    if (typeof window === 'undefined') {
      return undefined;
    }
    var value;
    try {
      value = localStorage.getItem(key) || undefined;
      if (!value) {
        // the first time that user enters the site.
        localStorage.setItem(key, defaultValue);
      }
    } catch (e) {
      // Unsupported
    }
    return value || defaultValue;
  }
  function useCurrentColorScheme(options) {
    var _options$defaultMode = options.defaultMode,
      defaultMode = _options$defaultMode === void 0 ? 'light' : _options$defaultMode,
      defaultLightColorScheme = options.defaultLightColorScheme,
      defaultDarkColorScheme = options.defaultDarkColorScheme,
      _options$supportedCol = options.supportedColorSchemes,
      supportedColorSchemes = _options$supportedCol === void 0 ? [] : _options$supportedCol,
      _options$modeStorageK = options.modeStorageKey,
      modeStorageKey = _options$modeStorageK === void 0 ? DEFAULT_MODE_STORAGE_KEY : _options$modeStorageK,
      _options$colorSchemeS = options.colorSchemeStorageKey,
      colorSchemeStorageKey = _options$colorSchemeS === void 0 ? DEFAULT_COLOR_SCHEME_STORAGE_KEY : _options$colorSchemeS,
      _options$storageWindo = options.storageWindow,
      storageWindow = _options$storageWindo === void 0 ? typeof window === 'undefined' ? undefined : window : _options$storageWindo;
    var joinedColorSchemes = supportedColorSchemes.join(',');
    var _React$useState = React__namespace.useState(function () {
        var initialMode = initializeValue(modeStorageKey, defaultMode);
        var lightColorScheme = initializeValue("".concat(colorSchemeStorageKey, "-light"), defaultLightColorScheme);
        var darkColorScheme = initializeValue("".concat(colorSchemeStorageKey, "-dark"), defaultDarkColorScheme);
        return {
          mode: initialMode,
          systemMode: getSystemMode(initialMode),
          lightColorScheme: lightColorScheme,
          darkColorScheme: darkColorScheme
        };
      }),
      state = _React$useState[0],
      setState = _React$useState[1];
    var colorScheme = getColorScheme(state);
    var setMode = React__namespace.useCallback(function (mode) {
      setState(function (currentState) {
        if (mode === currentState.mode) {
          // do nothing if mode does not change
          return currentState;
        }
        var newMode = mode != null ? mode : defaultMode;
        try {
          localStorage.setItem(modeStorageKey, newMode);
        } catch (e) {
          // Unsupported
        }
        return _extends({}, currentState, {
          mode: newMode,
          systemMode: getSystemMode(newMode)
        });
      });
    }, [modeStorageKey, defaultMode]);
    var setColorScheme = React__namespace.useCallback(function (value) {
      if (!value) {
        setState(function (currentState) {
          try {
            localStorage.setItem("".concat(colorSchemeStorageKey, "-light"), defaultLightColorScheme);
            localStorage.setItem("".concat(colorSchemeStorageKey, "-dark"), defaultDarkColorScheme);
          } catch (e) {
            // Unsupported
          }
          return _extends({}, currentState, {
            lightColorScheme: defaultLightColorScheme,
            darkColorScheme: defaultDarkColorScheme
          });
        });
      } else if (typeof value === 'string') {
        if (value && !joinedColorSchemes.includes(value)) {
          console.error("`".concat(value, "` does not exist in `theme.colorSchemes`."));
        } else {
          setState(function (currentState) {
            var newState = _extends({}, currentState);
            processState(currentState, function (mode) {
              try {
                localStorage.setItem("".concat(colorSchemeStorageKey, "-").concat(mode), value);
              } catch (e) {
                // Unsupported
              }
              if (mode === 'light') {
                newState.lightColorScheme = value;
              }
              if (mode === 'dark') {
                newState.darkColorScheme = value;
              }
            });
            return newState;
          });
        }
      } else {
        setState(function (currentState) {
          var newState = _extends({}, currentState);
          var newLightColorScheme = value.light === null ? defaultLightColorScheme : value.light;
          var newDarkColorScheme = value.dark === null ? defaultDarkColorScheme : value.dark;
          if (newLightColorScheme) {
            if (!joinedColorSchemes.includes(newLightColorScheme)) {
              console.error("`".concat(newLightColorScheme, "` does not exist in `theme.colorSchemes`."));
            } else {
              newState.lightColorScheme = newLightColorScheme;
              try {
                localStorage.setItem("".concat(colorSchemeStorageKey, "-light"), newLightColorScheme);
              } catch (error) {
                // Unsupported
              }
            }
          }
          if (newDarkColorScheme) {
            if (!joinedColorSchemes.includes(newDarkColorScheme)) {
              console.error("`".concat(newDarkColorScheme, "` does not exist in `theme.colorSchemes`."));
            } else {
              newState.darkColorScheme = newDarkColorScheme;
              try {
                localStorage.setItem("".concat(colorSchemeStorageKey, "-dark"), newDarkColorScheme);
              } catch (error) {
                // Unsupported
              }
            }
          }
          return newState;
        });
      }
    }, [joinedColorSchemes, colorSchemeStorageKey, defaultLightColorScheme, defaultDarkColorScheme]);
    var handleMediaQuery = React__namespace.useCallback(function (event) {
      if (state.mode === 'system') {
        setState(function (currentState) {
          var systemMode = event != null && event.matches ? 'dark' : 'light';

          // Early exit, nothing changed.
          if (currentState.systemMode === systemMode) {
            return currentState;
          }
          return _extends({}, currentState, {
            systemMode: systemMode
          });
        });
      }
    }, [state.mode]);

    // Ref hack to avoid adding handleMediaQuery as a dep
    var mediaListener = React__namespace.useRef(handleMediaQuery);
    mediaListener.current = handleMediaQuery;
    React__namespace.useEffect(function () {
      var handler = function handler() {
        return mediaListener.current.apply(mediaListener, arguments);
      };

      // Always listen to System preference
      var media = window.matchMedia('(prefers-color-scheme: dark)');

      // Intentionally use deprecated listener methods to support iOS & old browsers
      media.addListener(handler);
      handler(media);
      return function () {
        media.removeListener(handler);
      };
    }, []);

    // Handle when localStorage has changed
    React__namespace.useEffect(function () {
      if (storageWindow) {
        var handleStorage = function handleStorage(event) {
          var value = event.newValue;
          if (typeof event.key === 'string' && event.key.startsWith(colorSchemeStorageKey) && (!value || joinedColorSchemes.match(value))) {
            // If the key is deleted, value will be null then reset color scheme to the default one.
            if (event.key.endsWith('light')) {
              setColorScheme({
                light: value
              });
            }
            if (event.key.endsWith('dark')) {
              setColorScheme({
                dark: value
              });
            }
          }
          if (event.key === modeStorageKey && (!value || ['light', 'dark', 'system'].includes(value))) {
            setMode(value || defaultMode);
          }
        };
        // For syncing color-scheme changes between iframes
        storageWindow.addEventListener('storage', handleStorage);
        return function () {
          storageWindow.removeEventListener('storage', handleStorage);
        };
      }
      return undefined;
    }, [setColorScheme, setMode, modeStorageKey, colorSchemeStorageKey, joinedColorSchemes, defaultMode, storageWindow]);
    return _extends({}, state, {
      colorScheme: colorScheme,
      setMode: setMode,
      setColorScheme: setColorScheme
    });
  }

  var DISABLE_CSS_TRANSITION = '*{-webkit-transition:none!important;-moz-transition:none!important;-o-transition:none!important;-ms-transition:none!important;transition:none!important}';
  function createCssVarsProvider(options) {
    var themeId = options.themeId,
      _options$theme = options.theme,
      defaultTheme = _options$theme === void 0 ? {} : _options$theme,
      _options$attribute = options.attribute,
      defaultAttribute = _options$attribute === void 0 ? DEFAULT_ATTRIBUTE : _options$attribute,
      _options$modeStorageK = options.modeStorageKey,
      defaultModeStorageKey = _options$modeStorageK === void 0 ? DEFAULT_MODE_STORAGE_KEY : _options$modeStorageK,
      _options$colorSchemeS = options.colorSchemeStorageKey,
      defaultColorSchemeStorageKey = _options$colorSchemeS === void 0 ? DEFAULT_COLOR_SCHEME_STORAGE_KEY : _options$colorSchemeS,
      _options$defaultMode = options.defaultMode,
      designSystemMode = _options$defaultMode === void 0 ? 'light' : _options$defaultMode,
      designSystemColorScheme = options.defaultColorScheme,
      _options$disableTrans = options.disableTransitionOnChange,
      designSystemTransitionOnChange = _options$disableTrans === void 0 ? false : _options$disableTrans,
      resolveTheme = options.resolveTheme,
      excludeVariablesFromRoot = options.excludeVariablesFromRoot;
    if (!defaultTheme.colorSchemes || typeof designSystemColorScheme === 'string' && !defaultTheme.colorSchemes[designSystemColorScheme] || _typeof(designSystemColorScheme) === 'object' && !defaultTheme.colorSchemes[designSystemColorScheme == null ? void 0 : designSystemColorScheme.light] || _typeof(designSystemColorScheme) === 'object' && !defaultTheme.colorSchemes[designSystemColorScheme == null ? void 0 : designSystemColorScheme.dark]) {
      console.error("MUI: `".concat(designSystemColorScheme, "` does not exist in `theme.colorSchemes`."));
    }
    var ColorSchemeContext = /*#__PURE__*/React__namespace.createContext(undefined);
    {
      ColorSchemeContext.displayName = 'ColorSchemeContext';
    }
    var useColorScheme = function useColorScheme() {
      var value = React__namespace.useContext(ColorSchemeContext);
      if (!value) {
        throw new Error("MUI: `useColorScheme` must be called under <CssVarsProvider />" );
      }
      return value;
    };
    function CssVarsProvider(props) {
      var children = props.children,
        _props$theme = props.theme,
        themeProp = _props$theme === void 0 ? defaultTheme : _props$theme,
        _props$modeStorageKey = props.modeStorageKey,
        modeStorageKey = _props$modeStorageKey === void 0 ? defaultModeStorageKey : _props$modeStorageKey,
        _props$colorSchemeSto = props.colorSchemeStorageKey,
        colorSchemeStorageKey = _props$colorSchemeSto === void 0 ? defaultColorSchemeStorageKey : _props$colorSchemeSto,
        _props$attribute = props.attribute,
        attribute = _props$attribute === void 0 ? defaultAttribute : _props$attribute,
        _props$defaultMode = props.defaultMode,
        defaultMode = _props$defaultMode === void 0 ? designSystemMode : _props$defaultMode,
        _props$defaultColorSc = props.defaultColorScheme,
        defaultColorScheme = _props$defaultColorSc === void 0 ? designSystemColorScheme : _props$defaultColorSc,
        _props$disableTransit = props.disableTransitionOnChange,
        disableTransitionOnChange = _props$disableTransit === void 0 ? designSystemTransitionOnChange : _props$disableTransit,
        _props$storageWindow = props.storageWindow,
        storageWindow = _props$storageWindow === void 0 ? typeof window === 'undefined' ? undefined : window : _props$storageWindow,
        _props$documentNode = props.documentNode,
        documentNode = _props$documentNode === void 0 ? typeof document === 'undefined' ? undefined : document : _props$documentNode,
        _props$colorSchemeNod = props.colorSchemeNode,
        colorSchemeNode = _props$colorSchemeNod === void 0 ? typeof document === 'undefined' ? undefined : document.documentElement : _props$colorSchemeNod,
        _props$colorSchemeSel = props.colorSchemeSelector,
        colorSchemeSelector = _props$colorSchemeSel === void 0 ? ':root' : _props$colorSchemeSel,
        _props$disableNestedC = props.disableNestedContext,
        disableNestedContext = _props$disableNestedC === void 0 ? false : _props$disableNestedC,
        _props$disableStyleSh = props.disableStyleSheetGeneration,
        disableStyleSheetGeneration = _props$disableStyleSh === void 0 ? false : _props$disableStyleSh;
      var hasMounted = React__namespace.useRef(false);
      var upperTheme = useTheme$1();
      var ctx = React__namespace.useContext(ColorSchemeContext);
      var nested = !!ctx && !disableNestedContext;
      var scopedTheme = themeProp[themeId];
      var _ref = scopedTheme || themeProp,
        _ref$colorSchemes = _ref.colorSchemes,
        colorSchemes = _ref$colorSchemes === void 0 ? {} : _ref$colorSchemes,
        _ref$components = _ref.components,
        components = _ref$components === void 0 ? {} : _ref$components,
        _ref$generateCssVars = _ref.generateCssVars,
        generateCssVars = _ref$generateCssVars === void 0 ? function () {
          return {
            vars: {},
            css: {}
          };
        } : _ref$generateCssVars,
        cssVarPrefix = _ref.cssVarPrefix,
        restThemeProp = _objectWithoutProperties(_ref, ["colorSchemes", "components", "generateCssVars", "cssVarPrefix"]);
      var allColorSchemes = Object.keys(colorSchemes);
      var defaultLightColorScheme = typeof defaultColorScheme === 'string' ? defaultColorScheme : defaultColorScheme.light;
      var defaultDarkColorScheme = typeof defaultColorScheme === 'string' ? defaultColorScheme : defaultColorScheme.dark;

      // 1. Get the data about the `mode`, `colorScheme`, and setter functions.
      var _useCurrentColorSchem = useCurrentColorScheme({
          supportedColorSchemes: allColorSchemes,
          defaultLightColorScheme: defaultLightColorScheme,
          defaultDarkColorScheme: defaultDarkColorScheme,
          modeStorageKey: modeStorageKey,
          colorSchemeStorageKey: colorSchemeStorageKey,
          defaultMode: defaultMode,
          storageWindow: storageWindow
        }),
        stateMode = _useCurrentColorSchem.mode,
        setMode = _useCurrentColorSchem.setMode,
        systemMode = _useCurrentColorSchem.systemMode,
        lightColorScheme = _useCurrentColorSchem.lightColorScheme,
        darkColorScheme = _useCurrentColorSchem.darkColorScheme,
        stateColorScheme = _useCurrentColorSchem.colorScheme,
        setColorScheme = _useCurrentColorSchem.setColorScheme;
      var mode = stateMode;
      var colorScheme = stateColorScheme;
      if (nested) {
        mode = ctx.mode;
        colorScheme = ctx.colorScheme;
      }
      var calculatedMode = function () {
        if (mode) {
          return mode;
        }
        // This scope occurs on the server
        if (defaultMode === 'system') {
          return designSystemMode;
        }
        return defaultMode;
      }();
      var calculatedColorScheme = function () {
        if (!colorScheme) {
          // This scope occurs on the server
          if (calculatedMode === 'dark') {
            return defaultDarkColorScheme;
          }
          // use light color scheme, if default mode is 'light' | 'system'
          return defaultLightColorScheme;
        }
        return colorScheme;
      }();

      // 2. Create CSS variables and store them in objects (to be generated in stylesheets in the final step)
      var _generateCssVars = generateCssVars(),
        rootCss = _generateCssVars.css,
        rootVars = _generateCssVars.vars; // 3. Start composing the theme object
      var theme = _extends({}, restThemeProp, {
        components: components,
        colorSchemes: colorSchemes,
        cssVarPrefix: cssVarPrefix,
        vars: rootVars,
        getColorSchemeSelector: function getColorSchemeSelector(targetColorScheme) {
          return "[".concat(attribute, "=\"").concat(targetColorScheme, "\"] &");
        }
      });

      // 4. Create color CSS variables and store them in objects (to be generated in stylesheets in the final step)
      //    The default color scheme stylesheet is constructed to have the least CSS specificity.
      //    The other color schemes uses selector, default as data attribute, to increase the CSS specificity so that they can override the default color scheme stylesheet.
      var defaultColorSchemeStyleSheet = {};
      var otherColorSchemesStyleSheet = {};
      Object.entries(colorSchemes).forEach(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
          key = _ref3[0],
          scheme = _ref3[1];
        var _generateCssVars2 = generateCssVars(key),
          css = _generateCssVars2.css,
          vars = _generateCssVars2.vars;
        theme.vars = deepmerge(theme.vars, vars);
        if (key === calculatedColorScheme) {
          // 4.1 Merge the selected color scheme to the theme
          Object.keys(scheme).forEach(function (schemeKey) {
            if (scheme[schemeKey] && _typeof(scheme[schemeKey]) === 'object') {
              // shallow merge the 1st level structure of the theme.
              theme[schemeKey] = _extends({}, theme[schemeKey], scheme[schemeKey]);
            } else {
              theme[schemeKey] = scheme[schemeKey];
            }
          });
          if (theme.palette) {
            theme.palette.colorScheme = key;
          }
        }
        var resolvedDefaultColorScheme = function () {
          if (typeof defaultColorScheme === 'string') {
            return defaultColorScheme;
          }
          if (defaultMode === 'dark') {
            return defaultColorScheme.dark;
          }
          return defaultColorScheme.light;
        }();
        if (key === resolvedDefaultColorScheme) {
          if (excludeVariablesFromRoot) {
            var excludedVariables = {};
            excludeVariablesFromRoot(cssVarPrefix).forEach(function (cssVar) {
              excludedVariables[cssVar] = css[cssVar];
              delete css[cssVar];
            });
            defaultColorSchemeStyleSheet["[".concat(attribute, "=\"").concat(key, "\"]")] = excludedVariables;
          }
          defaultColorSchemeStyleSheet["".concat(colorSchemeSelector, ", [").concat(attribute, "=\"").concat(key, "\"]")] = css;
        } else {
          otherColorSchemesStyleSheet["".concat(colorSchemeSelector === ':root' ? '' : colorSchemeSelector, "[").concat(attribute, "=\"").concat(key, "\"]")] = css;
        }
      });
      theme.vars = deepmerge(theme.vars, rootVars);

      // 5. Declaring effects
      // 5.1 Updates the selector value to use the current color scheme which tells CSS to use the proper stylesheet.
      React__namespace.useEffect(function () {
        if (colorScheme && colorSchemeNode) {
          // attaches attribute to <html> because the css variables are attached to :root (html)
          colorSchemeNode.setAttribute(attribute, colorScheme);
        }
      }, [colorScheme, attribute, colorSchemeNode]);

      // 5.2 Remove the CSS transition when color scheme changes to create instant experience.
      // credit: https://github.com/pacocoursey/next-themes/blob/b5c2bad50de2d61ad7b52a9c5cdc801a78507d7a/index.tsx#L313
      React__namespace.useEffect(function () {
        var timer;
        if (disableTransitionOnChange && hasMounted.current && documentNode) {
          var css = documentNode.createElement('style');
          css.appendChild(documentNode.createTextNode(DISABLE_CSS_TRANSITION));
          documentNode.head.appendChild(css);

          // Force browser repaint
          (function () {
            return window.getComputedStyle(documentNode.body);
          })();
          timer = setTimeout(function () {
            documentNode.head.removeChild(css);
          }, 1);
        }
        return function () {
          clearTimeout(timer);
        };
      }, [colorScheme, disableTransitionOnChange, documentNode]);
      React__namespace.useEffect(function () {
        hasMounted.current = true;
        return function () {
          hasMounted.current = false;
        };
      }, []);
      var contextValue = React__namespace.useMemo(function () {
        return {
          allColorSchemes: allColorSchemes,
          colorScheme: colorScheme,
          darkColorScheme: darkColorScheme,
          lightColorScheme: lightColorScheme,
          mode: mode,
          setColorScheme: setColorScheme,
          setMode: setMode,
          systemMode: systemMode
        };
      }, [allColorSchemes, colorScheme, darkColorScheme, lightColorScheme, mode, setColorScheme, setMode, systemMode]);
      var shouldGenerateStyleSheet = true;
      if (disableStyleSheetGeneration || nested && (upperTheme == null ? void 0 : upperTheme.cssVarPrefix) === cssVarPrefix) {
        shouldGenerateStyleSheet = false;
      }
      var element = /*#__PURE__*/jsxRuntime_2(React__namespace.Fragment, {
        children: [shouldGenerateStyleSheet && /*#__PURE__*/jsxRuntime_2(React__namespace.Fragment, {
          children: [/*#__PURE__*/jsxRuntime_1(GlobalStyles$2, {
            styles: _defineProperty({}, colorSchemeSelector, rootCss)
          }), /*#__PURE__*/jsxRuntime_1(GlobalStyles$2, {
            styles: defaultColorSchemeStyleSheet
          }), /*#__PURE__*/jsxRuntime_1(GlobalStyles$2, {
            styles: otherColorSchemesStyleSheet
          })]
        }), /*#__PURE__*/jsxRuntime_1(ThemeProvider$1, {
          themeId: scopedTheme ? themeId : undefined,
          theme: resolveTheme ? resolveTheme(theme) : theme,
          children: children
        })]
      });
      if (nested) {
        return element;
      }
      return /*#__PURE__*/jsxRuntime_1(ColorSchemeContext.Provider, {
        value: contextValue,
        children: element
      });
    }
    CssVarsProvider.propTypes = {
      /**
       * The body attribute name to attach colorScheme.
       */
      attribute: PropTypes.string,
      /**
       * The component tree.
       */
      children: PropTypes.node,
      /**
       * The node used to attach the color-scheme attribute
       */
      colorSchemeNode: PropTypes.any,
      /**
       * The CSS selector for attaching the generated custom properties
       */
      colorSchemeSelector: PropTypes.string,
      /**
       * localStorage key used to store `colorScheme`
       */
      colorSchemeStorageKey: PropTypes.string,
      /**
       * The initial color scheme used.
       */
      defaultColorScheme: PropTypes.oneOfType([PropTypes.string, PropTypes.object]),
      /**
       * The initial mode used.
       */
      defaultMode: PropTypes.string,
      /**
       * If `true`, the provider creates its own context and generate stylesheet as if it is a root `CssVarsProvider`.
       */
      disableNestedContext: PropTypes.bool,
      /**
       * If `true`, the style sheet won't be generated.
       *
       * This is useful for controlling nested CssVarsProvider behavior.
       */
      disableStyleSheetGeneration: PropTypes.bool,
      /**
       * Disable CSS transitions when switching between modes or color schemes.
       */
      disableTransitionOnChange: PropTypes.bool,
      /**
       * The document to attach the attribute to.
       */
      documentNode: PropTypes.any,
      /**
       * The key in the local storage used to store current color scheme.
       */
      modeStorageKey: PropTypes.string,
      /**
       * The window that attaches the 'storage' event listener.
       * @default window
       */
      storageWindow: PropTypes.any,
      /**
       * The calculated theme object that will be passed through context.
       */
      theme: PropTypes.object
    } ;
    var defaultLightColorScheme = typeof designSystemColorScheme === 'string' ? designSystemColorScheme : designSystemColorScheme.light;
    var defaultDarkColorScheme = typeof designSystemColorScheme === 'string' ? designSystemColorScheme : designSystemColorScheme.dark;
    var getInitColorSchemeScript = function getInitColorSchemeScript(params) {
      return getInitColorSchemeScript$1(_extends({
        attribute: defaultAttribute,
        colorSchemeStorageKey: defaultColorSchemeStorageKey,
        defaultMode: designSystemMode,
        defaultLightColorScheme: defaultLightColorScheme,
        defaultDarkColorScheme: defaultDarkColorScheme,
        modeStorageKey: defaultModeStorageKey
      }, params));
    };
    return {
      CssVarsProvider: CssVarsProvider,
      useColorScheme: useColorScheme,
      getInitColorSchemeScript: getInitColorSchemeScript
    };
  }

  /**
   * The benefit of this function is to help developers get CSS var from theme without specifying the whole variable
   * and they does not need to remember the prefix (defined once).
   */
  function createGetCssVar$1() {
    var prefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
    function appendVar() {
      for (var _len = arguments.length, vars = new Array(_len), _key = 0; _key < _len; _key++) {
        vars[_key] = arguments[_key];
      }
      if (!vars.length) {
        return '';
      }
      var value = vars[0];
      if (typeof value === 'string' && !value.match(/(#|\(|\)|(-?(\d*\.)?\d+)(px|em|%|ex|ch|rem|vw|vh|vmin|vmax|cm|mm|in|pt|pc))|^(-?(\d*\.)?\d+)$|(\d+ \d+ \d+)/)) {
        return ", var(--".concat(prefix ? "".concat(prefix, "-") : '').concat(value).concat(appendVar.apply(void 0, _toConsumableArray(vars.slice(1))), ")");
      }
      return ", ".concat(value);
    }

    // AdditionalVars makes `getCssVar` less strict, so it can be use like this `getCssVar('non-mui-variable')` without type error.
    var getCssVar = function getCssVar(field) {
      for (var _len2 = arguments.length, fallbacks = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        fallbacks[_key2 - 1] = arguments[_key2];
      }
      return "var(--".concat(prefix ? "".concat(prefix, "-") : '').concat(field).concat(appendVar.apply(void 0, fallbacks), ")");
    };
    return getCssVar;
  }

  /**
   * This function create an object from keys, value and then assign to target
   *
   * @param {Object} obj : the target object to be assigned
   * @param {string[]} keys
   * @param {string | number} value
   *
   * @example
   * const source = {}
   * assignNestedKeys(source, ['palette', 'primary'], 'var(--palette-primary)')
   * console.log(source) // { palette: { primary: 'var(--palette-primary)' } }
   *
   * @example
   * const source = { palette: { primary: 'var(--palette-primary)' } }
   * assignNestedKeys(source, ['palette', 'secondary'], 'var(--palette-secondary)')
   * console.log(source) // { palette: { primary: 'var(--palette-primary)', secondary: 'var(--palette-secondary)' } }
   */
  var assignNestedKeys = function assignNestedKeys(obj, keys, value) {
    var arrayKeys = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : [];
    var temp = obj;
    keys.forEach(function (k, index) {
      if (index === keys.length - 1) {
        if (Array.isArray(temp)) {
          temp[Number(k)] = value;
        } else if (temp && _typeof(temp) === 'object') {
          temp[k] = value;
        }
      } else if (temp && _typeof(temp) === 'object') {
        if (!temp[k]) {
          temp[k] = arrayKeys.includes(k) ? [] : {};
        }
        temp = temp[k];
      }
    });
  };

  /**
   *
   * @param {Object} obj : source object
   * @param {Function} callback : a function that will be called when
   *                   - the deepest key in source object is reached
   *                   - the value of the deepest key is NOT `undefined` | `null`
   *
   * @example
   * walkObjectDeep({ palette: { primary: { main: '#000000' } } }, console.log)
   * // ['palette', 'primary', 'main'] '#000000'
   */
  var walkObjectDeep = function walkObjectDeep(obj, callback, shouldSkipPaths) {
    function recurse(object) {
      var parentKeys = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      var arrayKeys = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
      Object.entries(object).forEach(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          key = _ref2[0],
          value = _ref2[1];
        if (!shouldSkipPaths || shouldSkipPaths && !shouldSkipPaths([].concat(_toConsumableArray(parentKeys), [key]))) {
          if (value !== undefined && value !== null) {
            if (_typeof(value) === 'object' && Object.keys(value).length > 0) {
              recurse(value, [].concat(_toConsumableArray(parentKeys), [key]), Array.isArray(value) ? [].concat(_toConsumableArray(arrayKeys), [key]) : arrayKeys);
            } else {
              callback([].concat(_toConsumableArray(parentKeys), [key]), value, arrayKeys);
            }
          }
        }
      });
    }
    recurse(obj);
  };
  var getCssValue = function getCssValue(keys, value) {
    if (typeof value === 'number') {
      if (['lineHeight', 'fontWeight', 'opacity', 'zIndex'].some(function (prop) {
        return keys.includes(prop);
      })) {
        // CSS property that are unitless
        return value;
      }
      var lastKey = keys[keys.length - 1];
      if (lastKey.toLowerCase().indexOf('opacity') >= 0) {
        // opacity values are unitless
        return value;
      }
      return "".concat(value, "px");
    }
    return value;
  };

  /**
   * a function that parse theme and return { css, vars }
   *
   * @param {Object} theme
   * @param {{
   *  prefix?: string,
   *  shouldSkipGeneratingVar?: (objectPathKeys: Array<string>, value: string | number) => boolean
   * }} options.
   *  `prefix`: The prefix of the generated CSS variables. This function does not change the value.
   *
   * @returns {{ css: Object, vars: Object }} `css` is the stylesheet, `vars` is an object to get css variable (same structure as theme).
   *
   * @example
   * const { css, vars } = parser({
   *   fontSize: 12,
   *   lineHeight: 1.2,
   *   palette: { primary: { 500: 'var(--color)' } }
   * }, { prefix: 'foo' })
   *
   * console.log(css) // { '--foo-fontSize': '12px', '--foo-lineHeight': 1.2, '--foo-palette-primary-500': 'var(--color)' }
   * console.log(vars) // { fontSize: 'var(--foo-fontSize)', lineHeight: 'var(--foo-lineHeight)', palette: { primary: { 500: 'var(--foo-palette-primary-500)' } } }
   */
  function cssVarsParser(theme, options) {
    var _ref3 = options || {},
      prefix = _ref3.prefix,
      shouldSkipGeneratingVar = _ref3.shouldSkipGeneratingVar;
    var css = {};
    var vars = {};
    var varsWithDefaults = {};
    walkObjectDeep(theme, function (keys, value, arrayKeys) {
      if (typeof value === 'string' || typeof value === 'number') {
        if (!shouldSkipGeneratingVar || !shouldSkipGeneratingVar(keys, value)) {
          // only create css & var if `shouldSkipGeneratingVar` return false
          var cssVar = "--".concat(prefix ? "".concat(prefix, "-") : '').concat(keys.join('-'));
          Object.assign(css, _defineProperty({}, cssVar, getCssValue(keys, value)));
          assignNestedKeys(vars, keys, "var(".concat(cssVar, ")"), arrayKeys);
          assignNestedKeys(varsWithDefaults, keys, "var(".concat(cssVar, ", ").concat(value, ")"), arrayKeys);
        }
      }
    }, function (keys) {
      return keys[0] === 'vars';
    } // skip 'vars/*' paths
    );
    return {
      css: css,
      vars: vars,
      varsWithDefaults: varsWithDefaults
    };
  }

  function prepareCssVars(theme, parserConfig) {
    // @ts-ignore - ignore components do not exist
    var _theme$colorSchemes = theme.colorSchemes,
      colorSchemes = _theme$colorSchemes === void 0 ? {} : _theme$colorSchemes;
      theme.components;
      var _theme$defaultColorSc = theme.defaultColorScheme,
      defaultColorScheme = _theme$defaultColorSc === void 0 ? 'light' : _theme$defaultColorSc,
      otherTheme = _objectWithoutProperties(theme, ["colorSchemes", "components", "defaultColorScheme"]);
    var _cssVarsParser = cssVarsParser(otherTheme, parserConfig),
      rootVars = _cssVarsParser.vars,
      rootCss = _cssVarsParser.css,
      rootVarsWithDefaults = _cssVarsParser.varsWithDefaults;
    var themeVars = rootVarsWithDefaults;
    var colorSchemesMap = {};
    var light = colorSchemes[defaultColorScheme],
      otherColorSchemes = _objectWithoutProperties(colorSchemes, [defaultColorScheme].map(toPropertyKey));
    Object.entries(otherColorSchemes || {}).forEach(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        key = _ref2[0],
        scheme = _ref2[1];
      var _cssVarsParser2 = cssVarsParser(scheme, parserConfig),
        vars = _cssVarsParser2.vars,
        css = _cssVarsParser2.css,
        varsWithDefaults = _cssVarsParser2.varsWithDefaults;
      themeVars = deepmerge(themeVars, varsWithDefaults);
      colorSchemesMap[key] = {
        css: css,
        vars: vars
      };
    });
    if (light) {
      // default color scheme vars should be merged last to set as default
      var _cssVarsParser3 = cssVarsParser(light, parserConfig),
        _css = _cssVarsParser3.css,
        vars = _cssVarsParser3.vars,
        varsWithDefaults = _cssVarsParser3.varsWithDefaults;
      themeVars = deepmerge(themeVars, varsWithDefaults);
      colorSchemesMap[defaultColorScheme] = {
        css: _css,
        vars: vars
      };
    }
    var generateCssVars = function generateCssVars(colorScheme) {
      var _parserConfig$getSele2;
      if (!colorScheme) {
        var _parserConfig$getSele;
        var _css2 = _extends({}, rootCss);
        return {
          css: _css2,
          vars: rootVars,
          selector: (parserConfig == null || (_parserConfig$getSele = parserConfig.getSelector) == null ? void 0 : _parserConfig$getSele.call(parserConfig, colorScheme, _css2)) || ':root'
        };
      }
      var css = _extends({}, colorSchemesMap[colorScheme].css);
      return {
        css: css,
        vars: colorSchemesMap[colorScheme].vars,
        selector: (parserConfig == null || (_parserConfig$getSele2 = parserConfig.getSelector) == null ? void 0 : _parserConfig$getSele2.call(parserConfig, colorScheme, css)) || ':root'
      };
    };
    return {
      vars: themeVars,
      generateCssVars: generateCssVars
    };
  }

  var defaultTheme$6 = createTheme$1();
  var defaultCreateStyledComponent$2 = systemStyled('div', {
    name: 'MuiContainer',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      return [styles.root, styles["maxWidth".concat(capitalize(String(ownerState.maxWidth)))], ownerState.fixed && styles.fixed, ownerState.disableGutters && styles.disableGutters];
    }
  });
  var useThemePropsDefault$2 = function useThemePropsDefault(inProps) {
    return useThemeProps$c({
      props: inProps,
      name: 'MuiContainer',
      defaultTheme: defaultTheme$6
    });
  };
  var useUtilityClasses$1P = function useUtilityClasses(ownerState, componentName) {
    var getContainerUtilityClass = function getContainerUtilityClass(slot) {
      return generateUtilityClass$1(componentName, slot);
    };
    var classes = ownerState.classes,
      fixed = ownerState.fixed,
      disableGutters = ownerState.disableGutters,
      maxWidth = ownerState.maxWidth;
    var slots = {
      root: ['root', maxWidth && "maxWidth".concat(capitalize(String(maxWidth))), fixed && 'fixed', disableGutters && 'disableGutters']
    };
    return composeClasses(slots, getContainerUtilityClass, classes);
  };
  function createContainer() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var _options$createStyled = options.createStyledComponent,
      createStyledComponent = _options$createStyled === void 0 ? defaultCreateStyledComponent$2 : _options$createStyled,
      _options$useThemeProp = options.useThemeProps,
      useThemeProps = _options$useThemeProp === void 0 ? useThemePropsDefault$2 : _options$useThemeProp,
      _options$componentNam = options.componentName,
      componentName = _options$componentNam === void 0 ? 'MuiContainer' : _options$componentNam;
    var ContainerRoot = createStyledComponent(function (_ref) {
      var theme = _ref.theme,
        ownerState = _ref.ownerState;
      return _extends({
        width: '100%',
        marginLeft: 'auto',
        boxSizing: 'border-box',
        marginRight: 'auto',
        display: 'block'
      }, !ownerState.disableGutters && _defineProperty({
        paddingLeft: theme.spacing(2),
        paddingRight: theme.spacing(2)
      }, theme.breakpoints.up('sm'), {
        paddingLeft: theme.spacing(3),
        paddingRight: theme.spacing(3)
      }));
    }, function (_ref3) {
      var theme = _ref3.theme,
        ownerState = _ref3.ownerState;
      return ownerState.fixed && Object.keys(theme.breakpoints.values).reduce(function (acc, breakpointValueKey) {
        var breakpoint = breakpointValueKey;
        var value = theme.breakpoints.values[breakpoint];
        if (value !== 0) {
          // @ts-ignore
          acc[theme.breakpoints.up(breakpoint)] = {
            maxWidth: "".concat(value).concat(theme.breakpoints.unit)
          };
        }
        return acc;
      }, {});
    }, function (_ref4) {
      var theme = _ref4.theme,
        ownerState = _ref4.ownerState;
      return _extends({}, ownerState.maxWidth === 'xs' && _defineProperty({}, theme.breakpoints.up('xs'), {
        // @ts-ignore module augmentation fails if custom breakpoints are used
        maxWidth: Math.max(theme.breakpoints.values.xs, 444)
      }), ownerState.maxWidth &&
      // @ts-ignore module augmentation fails if custom breakpoints are used
      ownerState.maxWidth !== 'xs' && _defineProperty({}, theme.breakpoints.up(ownerState.maxWidth), {
        // @ts-ignore module augmentation fails if custom breakpoints are used
        maxWidth: "".concat(theme.breakpoints.values[ownerState.maxWidth]).concat(theme.breakpoints.unit)
      }));
    });
    var Container = /*#__PURE__*/React__namespace.forwardRef(function Container(inProps, ref) {
      var props = useThemeProps(inProps);
      var className = props.className,
        _props$component = props.component,
        component = _props$component === void 0 ? 'div' : _props$component,
        _props$disableGutters = props.disableGutters,
        disableGutters = _props$disableGutters === void 0 ? false : _props$disableGutters,
        _props$fixed = props.fixed,
        fixed = _props$fixed === void 0 ? false : _props$fixed,
        _props$maxWidth = props.maxWidth,
        maxWidth = _props$maxWidth === void 0 ? 'lg' : _props$maxWidth;
        props.classes;
        var other = _objectWithoutProperties(props, ["className", "component", "disableGutters", "fixed", "maxWidth", "classes"]);
      var ownerState = _extends({}, props, {
        component: component,
        disableGutters: disableGutters,
        fixed: fixed,
        maxWidth: maxWidth
      });

      // @ts-ignore module augmentation fails if custom breakpoints are used
      var classes = useUtilityClasses$1P(ownerState, componentName);
      return (
        /*#__PURE__*/
        // @ts-ignore theme is injected by the styled util
        jsxRuntime_1(ContainerRoot, _extends({
          as: component
          // @ts-ignore module augmentation fails if custom breakpoints are used
          ,
          ownerState: ownerState,
          className: clsx(classes.root, className),
          ref: ref
        }, other))
      );
    });
    Container.propTypes /* remove-proptypes */ = {
      children: PropTypes.node,
      classes: PropTypes.object,
      className: PropTypes.string,
      component: PropTypes.elementType,
      disableGutters: PropTypes.bool,
      fixed: PropTypes.bool,
      maxWidth: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl', false]), PropTypes.string]),
      sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
    } ;
    return Container;
  }

  var filterBreakpointKeys = function filterBreakpointKeys(breakpointsKeys, responsiveKeys) {
    return breakpointsKeys.filter(function (key) {
      return responsiveKeys.includes(key);
    });
  };
  var traverseBreakpoints = function traverseBreakpoints(breakpoints, responsive, iterator) {
    var smallestBreakpoint = breakpoints.keys[0]; // the keys is sorted from smallest to largest by `createBreakpoints`.

    if (Array.isArray(responsive)) {
      responsive.forEach(function (breakpointValue, index) {
        iterator(function (responsiveStyles, style) {
          if (index <= breakpoints.keys.length - 1) {
            if (index === 0) {
              Object.assign(responsiveStyles, style);
            } else {
              responsiveStyles[breakpoints.up(breakpoints.keys[index])] = style;
            }
          }
        }, breakpointValue);
      });
    } else if (responsive && _typeof(responsive) === 'object') {
      // prevent null
      // responsive could be a very big object, pick the smallest responsive values

      var keys = Object.keys(responsive).length > breakpoints.keys.length ? breakpoints.keys : filterBreakpointKeys(breakpoints.keys, Object.keys(responsive));
      keys.forEach(function (key) {
        if (breakpoints.keys.indexOf(key) !== -1) {
          // @ts-ignore already checked that responsive is an object
          var breakpointValue = responsive[key];
          if (breakpointValue !== undefined) {
            iterator(function (responsiveStyles, style) {
              if (smallestBreakpoint === key) {
                Object.assign(responsiveStyles, style);
              } else {
                responsiveStyles[breakpoints.up(key)] = style;
              }
            }, breakpointValue);
          }
        }
      });
    } else if (typeof responsive === 'number' || typeof responsive === 'string') {
      iterator(function (responsiveStyles, style) {
        Object.assign(responsiveStyles, style);
      }, responsive);
    }
  };

  function appendLevel(level) {
    if (!level) {
      return '';
    }
    return "Level".concat(level);
  }
  function isNestedContainer(ownerState) {
    return ownerState.unstable_level > 0 && ownerState.container;
  }
  function createGetSelfSpacing(ownerState) {
    return function getSelfSpacing(axis) {
      return "var(--Grid-".concat(axis, "Spacing").concat(appendLevel(ownerState.unstable_level), ")");
    };
  }
  function createGetParentSpacing(ownerState) {
    return function getParentSpacing(axis) {
      if (ownerState.unstable_level === 0) {
        return "var(--Grid-".concat(axis, "Spacing)");
      }
      return "var(--Grid-".concat(axis, "Spacing").concat(appendLevel(ownerState.unstable_level - 1), ")");
    };
  }
  function getParentColumns(ownerState) {
    if (ownerState.unstable_level === 0) {
      return "var(--Grid-columns)";
    }
    return "var(--Grid-columns".concat(appendLevel(ownerState.unstable_level - 1), ")");
  }
  var generateGridSizeStyles = function generateGridSizeStyles(_ref) {
    var theme = _ref.theme,
      ownerState = _ref.ownerState;
    var getSelfSpacing = createGetSelfSpacing(ownerState);
    var styles = {};
    traverseBreakpoints(theme.breakpoints, ownerState.gridSize, function (appendStyle, value) {
      var style = {};
      if (value === true) {
        style = {
          flexBasis: 0,
          flexGrow: 1,
          maxWidth: '100%'
        };
      }
      if (value === 'auto') {
        style = {
          flexBasis: 'auto',
          flexGrow: 0,
          flexShrink: 0,
          maxWidth: 'none',
          width: 'auto'
        };
      }
      if (typeof value === 'number') {
        style = {
          flexGrow: 0,
          flexBasis: 'auto',
          width: "calc(100% * ".concat(value, " / ").concat(getParentColumns(ownerState)).concat(isNestedContainer(ownerState) ? " + ".concat(getSelfSpacing('column')) : '', ")")
        };
      }
      appendStyle(styles, style);
    });
    return styles;
  };
  var generateGridOffsetStyles = function generateGridOffsetStyles(_ref2) {
    var theme = _ref2.theme,
      ownerState = _ref2.ownerState;
    var styles = {};
    traverseBreakpoints(theme.breakpoints, ownerState.gridOffset, function (appendStyle, value) {
      var style = {};
      if (value === 'auto') {
        style = {
          marginLeft: 'auto'
        };
      }
      if (typeof value === 'number') {
        style = {
          marginLeft: value === 0 ? '0px' : "calc(100% * ".concat(value, " / ").concat(getParentColumns(ownerState), ")")
        };
      }
      appendStyle(styles, style);
    });
    return styles;
  };
  var generateGridColumnsStyles = function generateGridColumnsStyles(_ref3) {
    var theme = _ref3.theme,
      ownerState = _ref3.ownerState;
    if (!ownerState.container) {
      return {};
    }
    var styles = isNestedContainer(ownerState) ? _defineProperty({}, "--Grid-columns".concat(appendLevel(ownerState.unstable_level)), getParentColumns(ownerState)) : {
      '--Grid-columns': 12
    };
    traverseBreakpoints(theme.breakpoints, ownerState.columns, function (appendStyle, value) {
      appendStyle(styles, _defineProperty({}, "--Grid-columns".concat(appendLevel(ownerState.unstable_level)), value));
    });
    return styles;
  };
  var generateGridRowSpacingStyles = function generateGridRowSpacingStyles(_ref5) {
    var theme = _ref5.theme,
      ownerState = _ref5.ownerState;
    if (!ownerState.container) {
      return {};
    }
    var getParentSpacing = createGetParentSpacing(ownerState);
    var styles = isNestedContainer(ownerState) ? _defineProperty({}, "--Grid-rowSpacing".concat(appendLevel(ownerState.unstable_level)), getParentSpacing('row')) : {};
    traverseBreakpoints(theme.breakpoints, ownerState.rowSpacing, function (appendStyle, value) {
      var _theme$spacing;
      appendStyle(styles, _defineProperty({}, "--Grid-rowSpacing".concat(appendLevel(ownerState.unstable_level)), typeof value === 'string' ? value : (_theme$spacing = theme.spacing) == null ? void 0 : _theme$spacing.call(theme, value)));
    });
    return styles;
  };
  var generateGridColumnSpacingStyles = function generateGridColumnSpacingStyles(_ref7) {
    var theme = _ref7.theme,
      ownerState = _ref7.ownerState;
    if (!ownerState.container) {
      return {};
    }
    var getParentSpacing = createGetParentSpacing(ownerState);
    var styles = isNestedContainer(ownerState) ? _defineProperty({}, "--Grid-columnSpacing".concat(appendLevel(ownerState.unstable_level)), getParentSpacing('column')) : {};
    traverseBreakpoints(theme.breakpoints, ownerState.columnSpacing, function (appendStyle, value) {
      var _theme$spacing2;
      appendStyle(styles, _defineProperty({}, "--Grid-columnSpacing".concat(appendLevel(ownerState.unstable_level)), typeof value === 'string' ? value : (_theme$spacing2 = theme.spacing) == null ? void 0 : _theme$spacing2.call(theme, value)));
    });
    return styles;
  };
  var generateGridDirectionStyles = function generateGridDirectionStyles(_ref9) {
    var theme = _ref9.theme,
      ownerState = _ref9.ownerState;
    if (!ownerState.container) {
      return {};
    }
    var styles = {};
    traverseBreakpoints(theme.breakpoints, ownerState.direction, function (appendStyle, value) {
      appendStyle(styles, {
        flexDirection: value
      });
    });
    return styles;
  };
  var generateGridStyles = function generateGridStyles(_ref10) {
    var ownerState = _ref10.ownerState;
    var getSelfSpacing = createGetSelfSpacing(ownerState);
    var getParentSpacing = createGetParentSpacing(ownerState);
    return _extends({
      minWidth: 0,
      boxSizing: 'border-box'
    }, ownerState.container && _extends({
      display: 'flex',
      flexWrap: 'wrap'
    }, ownerState.wrap && ownerState.wrap !== 'wrap' && {
      flexWrap: ownerState.wrap
    }, {
      margin: "calc(".concat(getSelfSpacing('row'), " / -2) calc(").concat(getSelfSpacing('column'), " / -2)")
    }, ownerState.disableEqualOverflow && {
      margin: "calc(".concat(getSelfSpacing('row'), " * -1) 0px 0px calc(").concat(getSelfSpacing('column'), " * -1)")
    }), (!ownerState.container || isNestedContainer(ownerState)) && _extends({
      padding: "calc(".concat(getParentSpacing('row'), " / 2) calc(").concat(getParentSpacing('column'), " / 2)")
    }, (ownerState.disableEqualOverflow || ownerState.parentDisableEqualOverflow) && {
      padding: "".concat(getParentSpacing('row'), " 0px 0px ").concat(getParentSpacing('column'))
    }));
  };
  var generateSizeClassNames = function generateSizeClassNames(gridSize) {
    var classNames = [];
    Object.entries(gridSize).forEach(function (_ref11) {
      var _ref12 = _slicedToArray(_ref11, 2),
        key = _ref12[0],
        value = _ref12[1];
      if (value !== false && value !== undefined) {
        classNames.push("grid-".concat(key, "-").concat(String(value)));
      }
    });
    return classNames;
  };
  var generateSpacingClassNames = function generateSpacingClassNames(spacing) {
    var smallestBreakpoint = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'xs';
    function isValidSpacing(val) {
      if (val === undefined) {
        return false;
      }
      return typeof val === 'string' && !Number.isNaN(Number(val)) || typeof val === 'number' && val > 0;
    }
    if (isValidSpacing(spacing)) {
      return ["spacing-".concat(smallestBreakpoint, "-").concat(String(spacing))];
    }
    if (_typeof(spacing) === 'object' && !Array.isArray(spacing)) {
      var classNames = [];
      Object.entries(spacing).forEach(function (_ref13) {
        var _ref14 = _slicedToArray(_ref13, 2),
          key = _ref14[0],
          value = _ref14[1];
        if (isValidSpacing(value)) {
          classNames.push("spacing-".concat(key, "-").concat(String(value)));
        }
      });
      return classNames;
    }
    return [];
  };
  var generateDirectionClasses = function generateDirectionClasses(direction) {
    if (direction === undefined) {
      return [];
    }
    if (_typeof(direction) === 'object') {
      return Object.entries(direction).map(function (_ref15) {
        var _ref16 = _slicedToArray(_ref15, 2),
          key = _ref16[0],
          value = _ref16[1];
        return "direction-".concat(key, "-").concat(value);
      });
    }
    return ["direction-xs-".concat(String(direction))];
  };

  var defaultTheme$5 = createTheme$1();

  // widening Theme to any so that the consumer can own the theme structure.
  var defaultCreateStyledComponent$1 = systemStyled('div', {
    name: 'MuiGrid',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.root;
    }
  });
  function useThemePropsDefault$1(props) {
    return useThemeProps$c({
      props: props,
      name: 'MuiGrid',
      defaultTheme: defaultTheme$5
    });
  }
  function createGrid() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var _options$createStyled = options.createStyledComponent,
      createStyledComponent = _options$createStyled === void 0 ? defaultCreateStyledComponent$1 : _options$createStyled,
      _options$useThemeProp = options.useThemeProps,
      useThemeProps = _options$useThemeProp === void 0 ? useThemePropsDefault$1 : _options$useThemeProp,
      _options$componentNam = options.componentName,
      componentName = _options$componentNam === void 0 ? 'MuiGrid' : _options$componentNam;
    var GridOverflowContext = /*#__PURE__*/React__namespace.createContext(undefined);
    {
      GridOverflowContext.displayName = 'GridOverflowContext';
    }
    var useUtilityClasses = function useUtilityClasses(ownerState, theme) {
      var container = ownerState.container,
        direction = ownerState.direction,
        spacing = ownerState.spacing,
        wrap = ownerState.wrap,
        gridSize = ownerState.gridSize;
      var slots = {
        root: ['root', container && 'container', wrap !== 'wrap' && "wrap-xs-".concat(String(wrap))].concat(_toConsumableArray(generateDirectionClasses(direction)), _toConsumableArray(generateSizeClassNames(gridSize)), _toConsumableArray(container ? generateSpacingClassNames(spacing, theme.breakpoints.keys[0]) : []))
      };
      return composeClasses(slots, function (slot) {
        return generateUtilityClass$1(componentName, slot);
      }, {});
    };
    var GridRoot = createStyledComponent(generateGridColumnsStyles, generateGridColumnSpacingStyles, generateGridRowSpacingStyles, generateGridSizeStyles, generateGridDirectionStyles, generateGridStyles, generateGridOffsetStyles);
    var Grid = /*#__PURE__*/React__namespace.forwardRef(function Grid(inProps, ref) {
      var _inProps$columns, _inProps$spacing, _ref3, _inProps$rowSpacing, _ref4, _inProps$columnSpacin, _ref5, _disableEqualOverflow;
      var theme = useTheme$2();
      var themeProps = useThemeProps(inProps);
      var props = extendSxProp(themeProps); // `color` type conflicts with html color attribute.
      var overflow = React__namespace.useContext(GridOverflowContext);
      var className = props.className,
        children = props.children,
        _props$columns = props.columns,
        columnsProp = _props$columns === void 0 ? 12 : _props$columns,
        _props$container = props.container,
        container = _props$container === void 0 ? false : _props$container,
        _props$component = props.component,
        component = _props$component === void 0 ? 'div' : _props$component,
        _props$direction = props.direction,
        direction = _props$direction === void 0 ? 'row' : _props$direction,
        _props$wrap = props.wrap,
        wrap = _props$wrap === void 0 ? 'wrap' : _props$wrap,
        _props$spacing = props.spacing,
        spacingProp = _props$spacing === void 0 ? 0 : _props$spacing,
        _props$rowSpacing = props.rowSpacing,
        rowSpacingProp = _props$rowSpacing === void 0 ? spacingProp : _props$rowSpacing,
        _props$columnSpacing = props.columnSpacing,
        columnSpacingProp = _props$columnSpacing === void 0 ? spacingProp : _props$columnSpacing,
        themeDisableEqualOverflow = props.disableEqualOverflow,
        _props$unstable_level = props.unstable_level,
        level = _props$unstable_level === void 0 ? 0 : _props$unstable_level,
        rest = _objectWithoutProperties(props, ["className", "children", "columns", "container", "component", "direction", "wrap", "spacing", "rowSpacing", "columnSpacing", "disableEqualOverflow", "unstable_level"]); // Because `disableEqualOverflow` can be set from the theme's defaultProps, the **nested** grid should look at the instance props instead.
      var disableEqualOverflow = themeDisableEqualOverflow;
      if (level && themeDisableEqualOverflow !== undefined) {
        disableEqualOverflow = inProps.disableEqualOverflow;
      }
      // collect breakpoints related props because they can be customized from the theme.
      var gridSize = {};
      var gridOffset = {};
      var other = {};
      Object.entries(rest).forEach(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          key = _ref2[0],
          val = _ref2[1];
        if (theme.breakpoints.values[key] !== undefined) {
          gridSize[key] = val;
        } else if (theme.breakpoints.values[key.replace('Offset', '')] !== undefined) {
          gridOffset[key.replace('Offset', '')] = val;
        } else {
          other[key] = val;
        }
      });
      var columns = (_inProps$columns = inProps.columns) != null ? _inProps$columns : level ? undefined : columnsProp;
      var spacing = (_inProps$spacing = inProps.spacing) != null ? _inProps$spacing : level ? undefined : spacingProp;
      var rowSpacing = (_ref3 = (_inProps$rowSpacing = inProps.rowSpacing) != null ? _inProps$rowSpacing : inProps.spacing) != null ? _ref3 : level ? undefined : rowSpacingProp;
      var columnSpacing = (_ref4 = (_inProps$columnSpacin = inProps.columnSpacing) != null ? _inProps$columnSpacin : inProps.spacing) != null ? _ref4 : level ? undefined : columnSpacingProp;
      var ownerState = _extends({}, props, {
        level: level,
        columns: columns,
        container: container,
        direction: direction,
        wrap: wrap,
        spacing: spacing,
        rowSpacing: rowSpacing,
        columnSpacing: columnSpacing,
        gridSize: gridSize,
        gridOffset: gridOffset,
        disableEqualOverflow: (_ref5 = (_disableEqualOverflow = disableEqualOverflow) != null ? _disableEqualOverflow : overflow) != null ? _ref5 : false,
        // use context value if exists.
        parentDisableEqualOverflow: overflow // for nested grid
      });
      var classes = useUtilityClasses(ownerState, theme);
      var result = /*#__PURE__*/jsxRuntime_1(GridRoot, _extends({
        ref: ref,
        as: component,
        ownerState: ownerState,
        className: clsx(classes.root, className)
      }, other, {
        children: React__namespace.Children.map(children, function (child) {
          if ( /*#__PURE__*/React__namespace.isValidElement(child) && isMuiElement(child, ['Grid'])) {
            var _child$props$unstable;
            return /*#__PURE__*/React__namespace.cloneElement(child, {
              unstable_level: (_child$props$unstable = child.props.unstable_level) != null ? _child$props$unstable : level + 1
            });
          }
          return child;
        })
      }));
      if (disableEqualOverflow !== undefined && disableEqualOverflow !== (overflow != null ? overflow : false)) {
        // There are 2 possibilities that should wrap with the GridOverflowContext to communicate with the nested grids:
        // 1. It is the root grid with `disableEqualOverflow`.
        // 2. It is a nested grid with different `disableEqualOverflow` from the context.
        result = /*#__PURE__*/jsxRuntime_1(GridOverflowContext.Provider, {
          value: disableEqualOverflow,
          children: result
        });
      }
      return result;
    });
    Grid.propTypes /* remove-proptypes */ = {
      children: PropTypes.node,
      className: PropTypes.string,
      columns: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.number), PropTypes.number, PropTypes.object]),
      columnSpacing: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.number, PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.string]),
      component: PropTypes.elementType,
      container: PropTypes.bool,
      direction: PropTypes.oneOfType([PropTypes.oneOf(['column-reverse', 'column', 'row-reverse', 'row']), PropTypes.arrayOf(PropTypes.oneOf(['column-reverse', 'column', 'row-reverse', 'row'])), PropTypes.object]),
      disableEqualOverflow: PropTypes.bool,
      lg: PropTypes.oneOfType([PropTypes.oneOf(['auto']), PropTypes.number, PropTypes.bool]),
      lgOffset: PropTypes.oneOfType([PropTypes.oneOf(['auto']), PropTypes.number]),
      md: PropTypes.oneOfType([PropTypes.oneOf(['auto']), PropTypes.number, PropTypes.bool]),
      mdOffset: PropTypes.oneOfType([PropTypes.oneOf(['auto']), PropTypes.number]),
      rowSpacing: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.number, PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.string]),
      sm: PropTypes.oneOfType([PropTypes.oneOf(['auto']), PropTypes.number, PropTypes.bool]),
      smOffset: PropTypes.oneOfType([PropTypes.oneOf(['auto']), PropTypes.number]),
      spacing: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.number, PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.string]),
      sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
      wrap: PropTypes.oneOf(['nowrap', 'wrap-reverse', 'wrap']),
      xl: PropTypes.oneOfType([PropTypes.oneOf(['auto']), PropTypes.number, PropTypes.bool]),
      xlOffset: PropTypes.oneOfType([PropTypes.oneOf(['auto']), PropTypes.number]),
      xs: PropTypes.oneOfType([PropTypes.oneOf(['auto']), PropTypes.number, PropTypes.bool]),
      xsOffset: PropTypes.oneOfType([PropTypes.oneOf(['auto']), PropTypes.number])
    } ;

    // @ts-ignore internal logic for nested grid
    Grid.muiName = 'Grid';
    return Grid;
  }

  var defaultTheme$4 = createTheme$1();
  // widening Theme to any so that the consumer can own the theme structure.
  var defaultCreateStyledComponent = systemStyled('div', {
    name: 'MuiStack',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.root;
    }
  });
  function useThemePropsDefault(props) {
    return useThemeProps$c({
      props: props,
      name: 'MuiStack',
      defaultTheme: defaultTheme$4
    });
  }

  /**
   * Return an array with the separator React element interspersed between
   * each React node of the input children.
   *
   * > joinChildren([1,2,3], 0)
   * [1,0,2,0,3]
   */
  function joinChildren(children, separator) {
    var childrenArray = React__namespace.Children.toArray(children).filter(Boolean);
    return childrenArray.reduce(function (output, child, index) {
      output.push(child);
      if (index < childrenArray.length - 1) {
        output.push( /*#__PURE__*/React__namespace.cloneElement(separator, {
          key: "separator-".concat(index)
        }));
      }
      return output;
    }, []);
  }
  var getSideFromDirection = function getSideFromDirection(direction) {
    return {
      row: 'Left',
      'row-reverse': 'Right',
      column: 'Top',
      'column-reverse': 'Bottom'
    }[direction];
  };
  var style = function style(_ref) {
    var ownerState = _ref.ownerState,
      theme = _ref.theme;
    var styles = _extends({
      display: 'flex',
      flexDirection: 'column'
    }, handleBreakpoints({
      theme: theme
    }, resolveBreakpointValues({
      values: ownerState.direction,
      breakpoints: theme.breakpoints.values
    }), function (propValue) {
      return {
        flexDirection: propValue
      };
    }));
    if (ownerState.spacing) {
      var transformer = createUnarySpacing(theme);
      var base = Object.keys(theme.breakpoints.values).reduce(function (acc, breakpoint) {
        if (_typeof(ownerState.spacing) === 'object' && ownerState.spacing[breakpoint] != null || _typeof(ownerState.direction) === 'object' && ownerState.direction[breakpoint] != null) {
          acc[breakpoint] = true;
        }
        return acc;
      }, {});
      var directionValues = resolveBreakpointValues({
        values: ownerState.direction,
        base: base
      });
      var spacingValues = resolveBreakpointValues({
        values: ownerState.spacing,
        base: base
      });
      if (_typeof(directionValues) === 'object') {
        Object.keys(directionValues).forEach(function (breakpoint, index, breakpoints) {
          var directionValue = directionValues[breakpoint];
          if (!directionValue) {
            var previousDirectionValue = index > 0 ? directionValues[breakpoints[index - 1]] : 'column';
            directionValues[breakpoint] = previousDirectionValue;
          }
        });
      }
      var styleFromPropValue = function styleFromPropValue(propValue, breakpoint) {
        if (ownerState.useFlexGap) {
          return {
            gap: getValue(transformer, propValue)
          };
        }
        return {
          // The useFlexGap={false} implement relies on each child to give up control of the margin.
          // We need to reset the margin to avoid double spacing.
          '& > :not(style):not(style)': {
            margin: 0
          },
          '& > :not(style) ~ :not(style)': _defineProperty({}, "margin".concat(getSideFromDirection(breakpoint ? directionValues[breakpoint] : ownerState.direction)), getValue(transformer, propValue))
        };
      };
      styles = deepmerge(styles, handleBreakpoints({
        theme: theme
      }, spacingValues, styleFromPropValue));
    }
    styles = mergeBreakpointsInOrder(theme.breakpoints, styles);
    return styles;
  };
  function createStack() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var _options$createStyled = options.createStyledComponent,
      createStyledComponent = _options$createStyled === void 0 ? defaultCreateStyledComponent : _options$createStyled,
      _options$useThemeProp = options.useThemeProps,
      useThemeProps = _options$useThemeProp === void 0 ? useThemePropsDefault : _options$useThemeProp,
      _options$componentNam = options.componentName,
      componentName = _options$componentNam === void 0 ? 'MuiStack' : _options$componentNam;
    var useUtilityClasses = function useUtilityClasses() {
      var slots = {
        root: ['root']
      };
      return composeClasses(slots, function (slot) {
        return generateUtilityClass$1(componentName, slot);
      }, {});
    };
    var StackRoot = createStyledComponent(style);
    var Stack = /*#__PURE__*/React__namespace.forwardRef(function Grid(inProps, ref) {
      var themeProps = useThemeProps(inProps);
      var props = extendSxProp(themeProps); // `color` type conflicts with html color attribute.
      var _props$component = props.component,
        component = _props$component === void 0 ? 'div' : _props$component,
        _props$direction = props.direction,
        direction = _props$direction === void 0 ? 'column' : _props$direction,
        _props$spacing = props.spacing,
        spacing = _props$spacing === void 0 ? 0 : _props$spacing,
        divider = props.divider,
        children = props.children,
        className = props.className,
        _props$useFlexGap = props.useFlexGap,
        useFlexGap = _props$useFlexGap === void 0 ? false : _props$useFlexGap,
        other = _objectWithoutProperties(props, ["component", "direction", "spacing", "divider", "children", "className", "useFlexGap"]);
      var ownerState = {
        direction: direction,
        spacing: spacing,
        useFlexGap: useFlexGap
      };
      var classes = useUtilityClasses();
      return /*#__PURE__*/jsxRuntime_1(StackRoot, _extends({
        as: component,
        ownerState: ownerState,
        ref: ref,
        className: clsx(classes.root, className)
      }, other, {
        children: divider ? joinChildren(children, divider) : children
      }));
    });
    Stack.propTypes /* remove-proptypes */ = {
      children: PropTypes.node,
      direction: PropTypes.oneOfType([PropTypes.oneOf(['column-reverse', 'column', 'row-reverse', 'row']), PropTypes.arrayOf(PropTypes.oneOf(['column-reverse', 'column', 'row-reverse', 'row'])), PropTypes.object]),
      divider: PropTypes.node,
      spacing: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.number, PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.string]),
      sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
    } ;
    return Stack;
  }

  function adaptV4Theme(inputTheme) {
    {
      console.warn(['MUI: adaptV4Theme() is deprecated.', 'Follow the upgrade guide on https://mui.com/r/migration-v4#theme.'].join('\n'));
    }
    var _inputTheme$defaultPr = inputTheme.defaultProps,
      defaultProps = _inputTheme$defaultPr === void 0 ? {} : _inputTheme$defaultPr,
      _inputTheme$mixins = inputTheme.mixins,
      mixins = _inputTheme$mixins === void 0 ? {} : _inputTheme$mixins,
      _inputTheme$overrides = inputTheme.overrides,
      overrides = _inputTheme$overrides === void 0 ? {} : _inputTheme$overrides,
      _inputTheme$palette = inputTheme.palette,
      palette = _inputTheme$palette === void 0 ? {} : _inputTheme$palette,
      _inputTheme$props = inputTheme.props,
      props = _inputTheme$props === void 0 ? {} : _inputTheme$props,
      _inputTheme$styleOver = inputTheme.styleOverrides,
      styleOverrides = _inputTheme$styleOver === void 0 ? {} : _inputTheme$styleOver,
      other = _objectWithoutProperties(inputTheme, ["defaultProps", "mixins", "overrides", "palette", "props", "styleOverrides"]);
    var theme = _extends({}, other, {
      components: {}
    });

    // default props
    Object.keys(defaultProps).forEach(function (component) {
      var componentValue = theme.components[component] || {};
      componentValue.defaultProps = defaultProps[component];
      theme.components[component] = componentValue;
    });
    Object.keys(props).forEach(function (component) {
      var componentValue = theme.components[component] || {};
      componentValue.defaultProps = props[component];
      theme.components[component] = componentValue;
    });

    // CSS overrides
    Object.keys(styleOverrides).forEach(function (component) {
      var componentValue = theme.components[component] || {};
      componentValue.styleOverrides = styleOverrides[component];
      theme.components[component] = componentValue;
    });
    Object.keys(overrides).forEach(function (component) {
      var componentValue = theme.components[component] || {};
      componentValue.styleOverrides = overrides[component];
      theme.components[component] = componentValue;
    });

    // theme.spacing
    theme.spacing = createSpacing(inputTheme.spacing);

    // theme.mixins.gutters
    var breakpoints = createBreakpoints(inputTheme.breakpoints || {});
    var spacing = theme.spacing;
    theme.mixins = _extends({
      gutters: function gutters() {
        var styles = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        return _extends({
          paddingLeft: spacing(2),
          paddingRight: spacing(2)
        }, styles, _defineProperty({}, breakpoints.up('sm'), _extends({
          paddingLeft: spacing(3),
          paddingRight: spacing(3)
        }, styles[breakpoints.up('sm')])));
      }
    }, mixins);
    var typeInput = palette.type,
      modeInput = palette.mode,
      paletteRest = _objectWithoutProperties(palette, ["type", "mode"]);
    var finalMode = modeInput || typeInput || 'light';
    theme.palette = _extends({
      // theme.palette.text.hint
      text: {
        hint: finalMode === 'dark' ? 'rgba(255, 255, 255, 0.5)' : 'rgba(0, 0, 0, 0.38)'
      },
      mode: finalMode,
      type: finalMode
    }, paletteRest);
    return theme;
  }

  function createMixins(breakpoints, mixins) {
    return _extends({
      toolbar: _defineProperty(_defineProperty({
        minHeight: 56
      }, breakpoints.up('xs'), {
        '@media (orientation: landscape)': {
          minHeight: 48
        }
      }), breakpoints.up('sm'), {
        minHeight: 64
      })
    }, mixins);
  }

  var light = {
    // The colors used to style the text.
    text: {
      // The most important text.
      primary: 'rgba(0, 0, 0, 0.87)',
      // Secondary text.
      secondary: 'rgba(0, 0, 0, 0.6)',
      // Disabled text have even lower visual prominence.
      disabled: 'rgba(0, 0, 0, 0.38)'
    },
    // The color used to divide different elements.
    divider: 'rgba(0, 0, 0, 0.12)',
    // The background colors used to style the surfaces.
    // Consistency between these values is important.
    background: {
      paper: common$1.white,
      "default": common$1.white
    },
    // The colors used to style the action elements.
    action: {
      // The color of an active action like an icon button.
      active: 'rgba(0, 0, 0, 0.54)',
      // The color of an hovered action.
      hover: 'rgba(0, 0, 0, 0.04)',
      hoverOpacity: 0.04,
      // The color of a selected action.
      selected: 'rgba(0, 0, 0, 0.08)',
      selectedOpacity: 0.08,
      // The color of a disabled action.
      disabled: 'rgba(0, 0, 0, 0.26)',
      // The background color of a disabled action.
      disabledBackground: 'rgba(0, 0, 0, 0.12)',
      disabledOpacity: 0.38,
      focus: 'rgba(0, 0, 0, 0.12)',
      focusOpacity: 0.12,
      activatedOpacity: 0.12
    }
  };
  var dark = {
    text: {
      primary: common$1.white,
      secondary: 'rgba(255, 255, 255, 0.7)',
      disabled: 'rgba(255, 255, 255, 0.5)',
      icon: 'rgba(255, 255, 255, 0.5)'
    },
    divider: 'rgba(255, 255, 255, 0.12)',
    background: {
      paper: '#121212',
      "default": '#121212'
    },
    action: {
      active: common$1.white,
      hover: 'rgba(255, 255, 255, 0.08)',
      hoverOpacity: 0.08,
      selected: 'rgba(255, 255, 255, 0.16)',
      selectedOpacity: 0.16,
      disabled: 'rgba(255, 255, 255, 0.3)',
      disabledBackground: 'rgba(255, 255, 255, 0.12)',
      disabledOpacity: 0.38,
      focus: 'rgba(255, 255, 255, 0.12)',
      focusOpacity: 0.12,
      activatedOpacity: 0.24
    }
  };
  function addLightOrDark(intent, direction, shade, tonalOffset) {
    var tonalOffsetLight = tonalOffset.light || tonalOffset;
    var tonalOffsetDark = tonalOffset.dark || tonalOffset * 1.5;
    if (!intent[direction]) {
      if (intent.hasOwnProperty(shade)) {
        intent[direction] = intent[shade];
      } else if (direction === 'light') {
        intent.light = lighten(intent.main, tonalOffsetLight);
      } else if (direction === 'dark') {
        intent.dark = darken(intent.main, tonalOffsetDark);
      }
    }
  }
  function getDefaultPrimary() {
    var mode = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'light';
    if (mode === 'dark') {
      return {
        main: blue$1[200],
        light: blue$1[50],
        dark: blue$1[400]
      };
    }
    return {
      main: blue$1[700],
      light: blue$1[400],
      dark: blue$1[800]
    };
  }
  function getDefaultSecondary() {
    var mode = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'light';
    if (mode === 'dark') {
      return {
        main: purple$1[200],
        light: purple$1[50],
        dark: purple$1[400]
      };
    }
    return {
      main: purple$1[500],
      light: purple$1[300],
      dark: purple$1[700]
    };
  }
  function getDefaultError() {
    var mode = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'light';
    if (mode === 'dark') {
      return {
        main: red$1[500],
        light: red$1[300],
        dark: red$1[700]
      };
    }
    return {
      main: red$1[700],
      light: red$1[400],
      dark: red$1[800]
    };
  }
  function getDefaultInfo() {
    var mode = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'light';
    if (mode === 'dark') {
      return {
        main: lightBlue$1[400],
        light: lightBlue$1[300],
        dark: lightBlue$1[700]
      };
    }
    return {
      main: lightBlue$1[700],
      light: lightBlue$1[500],
      dark: lightBlue$1[900]
    };
  }
  function getDefaultSuccess() {
    var mode = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'light';
    if (mode === 'dark') {
      return {
        main: green$1[400],
        light: green$1[300],
        dark: green$1[700]
      };
    }
    return {
      main: green$1[800],
      light: green$1[500],
      dark: green$1[900]
    };
  }
  function getDefaultWarning() {
    var mode = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'light';
    if (mode === 'dark') {
      return {
        main: orange$1[400],
        light: orange$1[300],
        dark: orange$1[700]
      };
    }
    return {
      main: '#ed6c02',
      // closest to orange[800] that pass 3:1.
      light: orange$1[500],
      dark: orange$1[900]
    };
  }
  function createPalette(palette) {
    var _palette$mode = palette.mode,
      mode = _palette$mode === void 0 ? 'light' : _palette$mode,
      _palette$contrastThre = palette.contrastThreshold,
      contrastThreshold = _palette$contrastThre === void 0 ? 3 : _palette$contrastThre,
      _palette$tonalOffset = palette.tonalOffset,
      tonalOffset = _palette$tonalOffset === void 0 ? 0.2 : _palette$tonalOffset,
      other = _objectWithoutProperties(palette, ["mode", "contrastThreshold", "tonalOffset"]);
    var primary = palette.primary || getDefaultPrimary(mode);
    var secondary = palette.secondary || getDefaultSecondary(mode);
    var error = palette.error || getDefaultError(mode);
    var info = palette.info || getDefaultInfo(mode);
    var success = palette.success || getDefaultSuccess(mode);
    var warning = palette.warning || getDefaultWarning(mode);

    // Use the same logic as
    // Bootstrap: https://github.com/twbs/bootstrap/blob/1d6e3710dd447de1a200f29e8fa521f8a0908f70/scss/_functions.scss#L59
    // and material-components-web https://github.com/material-components/material-components-web/blob/ac46b8863c4dab9fc22c4c662dc6bd1b65dd652f/packages/mdc-theme/_functions.scss#L54
    function getContrastText(background) {
      var contrastText = getContrastRatio(background, dark.text.primary) >= contrastThreshold ? dark.text.primary : light.text.primary;
      {
        var contrast = getContrastRatio(background, contrastText);
        if (contrast < 3) {
          console.error(["MUI: The contrast ratio of ".concat(contrast, ":1 for ").concat(contrastText, " on ").concat(background), 'falls below the WCAG recommended absolute minimum contrast ratio of 3:1.', 'https://www.w3.org/TR/2008/REC-WCAG20-20081211/#visual-audio-contrast-contrast'].join('\n'));
        }
      }
      return contrastText;
    }
    var augmentColor = function augmentColor(_ref) {
      var color = _ref.color,
        name = _ref.name,
        _ref$mainShade = _ref.mainShade,
        mainShade = _ref$mainShade === void 0 ? 500 : _ref$mainShade,
        _ref$lightShade = _ref.lightShade,
        lightShade = _ref$lightShade === void 0 ? 300 : _ref$lightShade,
        _ref$darkShade = _ref.darkShade,
        darkShade = _ref$darkShade === void 0 ? 700 : _ref$darkShade;
      color = _extends({}, color);
      if (!color.main && color[mainShade]) {
        color.main = color[mainShade];
      }
      if (!color.hasOwnProperty('main')) {
        throw new Error("MUI: The color".concat(name ? " (".concat(name, ")") : '', " provided to augmentColor(color) is invalid.\nThe color object needs to have a `main` property or a `").concat(mainShade, "` property.") );
      }
      if (typeof color.main !== 'string') {
        throw new Error("MUI: The color".concat(name ? " (".concat(name, ")") : '', " provided to augmentColor(color) is invalid.\n`color.main` should be a string, but `").concat(JSON.stringify(color.main), "` was provided instead.\n\nDid you intend to use one of the following approaches?\n\nimport { green } from \"@mui/material/colors\";\n\nconst theme1 = createTheme({ palette: {\n  primary: green,\n} });\n\nconst theme2 = createTheme({ palette: {\n  primary: { main: green[500] },\n} });") );
      }
      addLightOrDark(color, 'light', lightShade, tonalOffset);
      addLightOrDark(color, 'dark', darkShade, tonalOffset);
      if (!color.contrastText) {
        color.contrastText = getContrastText(color.main);
      }
      return color;
    };
    var modes = {
      dark: dark,
      light: light
    };
    {
      if (!modes[mode]) {
        console.error("MUI: The palette mode `".concat(mode, "` is not supported."));
      }
    }
    var paletteOutput = deepmerge(_extends({
      // A collection of common colors.
      common: _extends({}, common$1),
      // prevent mutable object.
      // The palette mode, can be light or dark.
      mode: mode,
      // The colors used to represent primary interface elements for a user.
      primary: augmentColor({
        color: primary,
        name: 'primary'
      }),
      // The colors used to represent secondary interface elements for a user.
      secondary: augmentColor({
        color: secondary,
        name: 'secondary',
        mainShade: 'A400',
        lightShade: 'A200',
        darkShade: 'A700'
      }),
      // The colors used to represent interface elements that the user should be made aware of.
      error: augmentColor({
        color: error,
        name: 'error'
      }),
      // The colors used to represent potentially dangerous actions or important messages.
      warning: augmentColor({
        color: warning,
        name: 'warning'
      }),
      // The colors used to present information to the user that is neutral and not necessarily important.
      info: augmentColor({
        color: info,
        name: 'info'
      }),
      // The colors used to indicate the successful completion of an action that user triggered.
      success: augmentColor({
        color: success,
        name: 'success'
      }),
      // The grey colors.
      grey: grey$1,
      // Used by `getContrastText()` to maximize the contrast between
      // the background and the text.
      contrastThreshold: contrastThreshold,
      // Takes a background color and returns the text color that maximizes the contrast.
      getContrastText: getContrastText,
      // Generate a rich color object.
      augmentColor: augmentColor,
      // Used by the functions below to shift a color's luminance by approximately
      // two indexes within its tonal palette.
      // E.g., shift from Red 500 to Red 300 or Red 700.
      tonalOffset: tonalOffset
    }, modes[mode]), other);
    return paletteOutput;
  }

  function round$2(value) {
    return Math.round(value * 1e5) / 1e5;
  }
  var caseAllCaps = {
    textTransform: 'uppercase'
  };
  var defaultFontFamily = '"Roboto", "Helvetica", "Arial", sans-serif';

  /**
   * @see @link{https://m2.material.io/design/typography/the-type-system.html}
   * @see @link{https://m2.material.io/design/typography/understanding-typography.html}
   */
  function createTypography(palette, typography) {
    var _ref = typeof typography === 'function' ? typography(palette) : typography,
      _ref$fontFamily = _ref.fontFamily,
      fontFamily = _ref$fontFamily === void 0 ? defaultFontFamily : _ref$fontFamily,
      _ref$fontSize = _ref.fontSize,
      fontSize = _ref$fontSize === void 0 ? 14 : _ref$fontSize,
      _ref$fontWeightLight = _ref.fontWeightLight,
      fontWeightLight = _ref$fontWeightLight === void 0 ? 300 : _ref$fontWeightLight,
      _ref$fontWeightRegula = _ref.fontWeightRegular,
      fontWeightRegular = _ref$fontWeightRegula === void 0 ? 400 : _ref$fontWeightRegula,
      _ref$fontWeightMedium = _ref.fontWeightMedium,
      fontWeightMedium = _ref$fontWeightMedium === void 0 ? 500 : _ref$fontWeightMedium,
      _ref$fontWeightBold = _ref.fontWeightBold,
      fontWeightBold = _ref$fontWeightBold === void 0 ? 700 : _ref$fontWeightBold,
      _ref$htmlFontSize = _ref.htmlFontSize,
      htmlFontSize = _ref$htmlFontSize === void 0 ? 16 : _ref$htmlFontSize,
      allVariants = _ref.allVariants,
      pxToRem2 = _ref.pxToRem,
      other = _objectWithoutProperties(_ref, ["fontFamily", "fontSize", "fontWeightLight", "fontWeightRegular", "fontWeightMedium", "fontWeightBold", "htmlFontSize", "allVariants", "pxToRem"]);
    {
      if (typeof fontSize !== 'number') {
        console.error('MUI: `fontSize` is required to be a number.');
      }
      if (typeof htmlFontSize !== 'number') {
        console.error('MUI: `htmlFontSize` is required to be a number.');
      }
    }
    var coef = fontSize / 14;
    var pxToRem = pxToRem2 || function (size) {
      return "".concat(size / htmlFontSize * coef, "rem");
    };
    var buildVariant = function buildVariant(fontWeight, size, lineHeight, letterSpacing, casing) {
      return _extends({
        fontFamily: fontFamily,
        fontWeight: fontWeight,
        fontSize: pxToRem(size),
        // Unitless following https://meyerweb.com/eric/thoughts/2006/02/08/unitless-line-heights/
        lineHeight: lineHeight
      }, fontFamily === defaultFontFamily ? {
        letterSpacing: "".concat(round$2(letterSpacing / size), "em")
      } : {}, casing, allVariants);
    };
    var variants = {
      h1: buildVariant(fontWeightLight, 96, 1.167, -1.5),
      h2: buildVariant(fontWeightLight, 60, 1.2, -0.5),
      h3: buildVariant(fontWeightRegular, 48, 1.167, 0),
      h4: buildVariant(fontWeightRegular, 34, 1.235, 0.25),
      h5: buildVariant(fontWeightRegular, 24, 1.334, 0),
      h6: buildVariant(fontWeightMedium, 20, 1.6, 0.15),
      subtitle1: buildVariant(fontWeightRegular, 16, 1.75, 0.15),
      subtitle2: buildVariant(fontWeightMedium, 14, 1.57, 0.1),
      body1: buildVariant(fontWeightRegular, 16, 1.5, 0.15),
      body2: buildVariant(fontWeightRegular, 14, 1.43, 0.15),
      button: buildVariant(fontWeightMedium, 14, 1.75, 0.4, caseAllCaps),
      caption: buildVariant(fontWeightRegular, 12, 1.66, 0.4),
      overline: buildVariant(fontWeightRegular, 12, 2.66, 1, caseAllCaps),
      // TODO v6: Remove handling of 'inherit' variant from the theme as it is already handled in Material UI's Typography component. Also, remember to remove the associated types.
      inherit: {
        fontFamily: 'inherit',
        fontWeight: 'inherit',
        fontSize: 'inherit',
        lineHeight: 'inherit',
        letterSpacing: 'inherit'
      }
    };
    return deepmerge(_extends({
      htmlFontSize: htmlFontSize,
      pxToRem: pxToRem,
      fontFamily: fontFamily,
      fontSize: fontSize,
      fontWeightLight: fontWeightLight,
      fontWeightRegular: fontWeightRegular,
      fontWeightMedium: fontWeightMedium,
      fontWeightBold: fontWeightBold
    }, variants), other, {
      clone: false // No need to clone deep
    });
  }

  var shadowKeyUmbraOpacity = 0.2;
  var shadowKeyPenumbraOpacity = 0.14;
  var shadowAmbientShadowOpacity = 0.12;
  function createShadow() {
    return ["".concat(arguments.length <= 0 ? undefined : arguments[0], "px ").concat(arguments.length <= 1 ? undefined : arguments[1], "px ").concat(arguments.length <= 2 ? undefined : arguments[2], "px ").concat(arguments.length <= 3 ? undefined : arguments[3], "px rgba(0,0,0,").concat(shadowKeyUmbraOpacity, ")"), "".concat(arguments.length <= 4 ? undefined : arguments[4], "px ").concat(arguments.length <= 5 ? undefined : arguments[5], "px ").concat(arguments.length <= 6 ? undefined : arguments[6], "px ").concat(arguments.length <= 7 ? undefined : arguments[7], "px rgba(0,0,0,").concat(shadowKeyPenumbraOpacity, ")"), "".concat(arguments.length <= 8 ? undefined : arguments[8], "px ").concat(arguments.length <= 9 ? undefined : arguments[9], "px ").concat(arguments.length <= 10 ? undefined : arguments[10], "px ").concat(arguments.length <= 11 ? undefined : arguments[11], "px rgba(0,0,0,").concat(shadowAmbientShadowOpacity, ")")].join(',');
  }

  // Values from https://github.com/material-components/material-components-web/blob/be8747f94574669cb5e7add1a7c54fa41a89cec7/packages/mdc-elevation/_variables.scss
  var shadows = ['none', createShadow(0, 2, 1, -1, 0, 1, 1, 0, 0, 1, 3, 0), createShadow(0, 3, 1, -2, 0, 2, 2, 0, 0, 1, 5, 0), createShadow(0, 3, 3, -2, 0, 3, 4, 0, 0, 1, 8, 0), createShadow(0, 2, 4, -1, 0, 4, 5, 0, 0, 1, 10, 0), createShadow(0, 3, 5, -1, 0, 5, 8, 0, 0, 1, 14, 0), createShadow(0, 3, 5, -1, 0, 6, 10, 0, 0, 1, 18, 0), createShadow(0, 4, 5, -2, 0, 7, 10, 1, 0, 2, 16, 1), createShadow(0, 5, 5, -3, 0, 8, 10, 1, 0, 3, 14, 2), createShadow(0, 5, 6, -3, 0, 9, 12, 1, 0, 3, 16, 2), createShadow(0, 6, 6, -3, 0, 10, 14, 1, 0, 4, 18, 3), createShadow(0, 6, 7, -4, 0, 11, 15, 1, 0, 4, 20, 3), createShadow(0, 7, 8, -4, 0, 12, 17, 2, 0, 5, 22, 4), createShadow(0, 7, 8, -4, 0, 13, 19, 2, 0, 5, 24, 4), createShadow(0, 7, 9, -4, 0, 14, 21, 2, 0, 5, 26, 4), createShadow(0, 8, 9, -5, 0, 15, 22, 2, 0, 6, 28, 5), createShadow(0, 8, 10, -5, 0, 16, 24, 2, 0, 6, 30, 5), createShadow(0, 8, 11, -5, 0, 17, 26, 2, 0, 6, 32, 5), createShadow(0, 9, 11, -5, 0, 18, 28, 2, 0, 7, 34, 6), createShadow(0, 9, 12, -6, 0, 19, 29, 2, 0, 7, 36, 6), createShadow(0, 10, 13, -6, 0, 20, 31, 3, 0, 8, 38, 7), createShadow(0, 10, 13, -6, 0, 21, 33, 3, 0, 8, 40, 7), createShadow(0, 10, 14, -6, 0, 22, 35, 3, 0, 8, 42, 7), createShadow(0, 11, 14, -7, 0, 23, 36, 3, 0, 9, 44, 8), createShadow(0, 11, 15, -7, 0, 24, 38, 3, 0, 9, 46, 8)];
  var shadows$1 = shadows;

  // Follow https://material.google.com/motion/duration-easing.html#duration-easing-natural-easing-curves
  // to learn the context in which each easing should be used.
  var easing = {
    // This is the most common easing curve.
    easeInOut: 'cubic-bezier(0.4, 0, 0.2, 1)',
    // Objects enter the screen at full velocity from off-screen and
    // slowly decelerate to a resting point.
    easeOut: 'cubic-bezier(0.0, 0, 0.2, 1)',
    // Objects leave the screen at full velocity. They do not decelerate when off-screen.
    easeIn: 'cubic-bezier(0.4, 0, 1, 1)',
    // The sharp curve is used by objects that may return to the screen at any time.
    sharp: 'cubic-bezier(0.4, 0, 0.6, 1)'
  };

  // Follow https://m2.material.io/guidelines/motion/duration-easing.html#duration-easing-common-durations
  // to learn when use what timing
  var duration = {
    shortest: 150,
    shorter: 200,
    "short": 250,
    // most basic recommended timing
    standard: 300,
    // this is to be used in complex animations
    complex: 375,
    // recommended when something is entering screen
    enteringScreen: 225,
    // recommended when something is leaving screen
    leavingScreen: 195
  };
  function formatMs(milliseconds) {
    return "".concat(Math.round(milliseconds), "ms");
  }
  function getAutoHeightDuration(height) {
    if (!height) {
      return 0;
    }
    var constant = height / 36;

    // https://www.wolframalpha.com/input/?i=(4+%2B+15+*+(x+%2F+36+)+**+0.25+%2B+(x+%2F+36)+%2F+5)+*+10
    return Math.round((4 + 15 * Math.pow(constant, 0.25) + constant / 5) * 10);
  }
  function createTransitions(inputTransitions) {
    var mergedEasing = _extends({}, easing, inputTransitions.easing);
    var mergedDuration = _extends({}, duration, inputTransitions.duration);
    var create = function create() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : ['all'];
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var _options$duration = options.duration,
        durationOption = _options$duration === void 0 ? mergedDuration.standard : _options$duration,
        _options$easing = options.easing,
        easingOption = _options$easing === void 0 ? mergedEasing.easeInOut : _options$easing,
        _options$delay = options.delay,
        delay = _options$delay === void 0 ? 0 : _options$delay,
        other = _objectWithoutProperties(options, ["duration", "easing", "delay"]);
      {
        var isString = function isString(value) {
          return typeof value === 'string';
        };
        // IE11 support, replace with Number.isNaN
        // eslint-disable-next-line no-restricted-globals
        var isNumber = function isNumber(value) {
          return !isNaN(parseFloat(value));
        };
        if (!isString(props) && !Array.isArray(props)) {
          console.error('MUI: Argument "props" must be a string or Array.');
        }
        if (!isNumber(durationOption) && !isString(durationOption)) {
          console.error("MUI: Argument \"duration\" must be a number or a string but found ".concat(durationOption, "."));
        }
        if (!isString(easingOption)) {
          console.error('MUI: Argument "easing" must be a string.');
        }
        if (!isNumber(delay) && !isString(delay)) {
          console.error('MUI: Argument "delay" must be a number or a string.');
        }
        if (_typeof(options) !== 'object') {
          console.error(['MUI: Secong argument of transition.create must be an object.', "Arguments should be either `create('prop1', options)` or `create(['prop1', 'prop2'], options)`"].join('\n'));
        }
        if (Object.keys(other).length !== 0) {
          console.error("MUI: Unrecognized argument(s) [".concat(Object.keys(other).join(','), "]."));
        }
      }
      return (Array.isArray(props) ? props : [props]).map(function (animatedProp) {
        return "".concat(animatedProp, " ").concat(typeof durationOption === 'string' ? durationOption : formatMs(durationOption), " ").concat(easingOption, " ").concat(typeof delay === 'string' ? delay : formatMs(delay));
      }).join(',');
    };
    return _extends({
      getAutoHeightDuration: getAutoHeightDuration,
      create: create
    }, inputTransitions, {
      easing: mergedEasing,
      duration: mergedDuration
    });
  }

  // We need to centralize the zIndex definitions as they work
  // like global values in the browser.
  var zIndex = {
    mobileStepper: 1000,
    fab: 1050,
    speedDial: 1050,
    appBar: 1100,
    drawer: 1200,
    modal: 1300,
    snackbar: 1400,
    tooltip: 1500
  };
  var zIndex$1 = zIndex;

  function createTheme() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    options.breakpoints;
      var _options$mixins = options.mixins,
      mixinsInput = _options$mixins === void 0 ? {} : _options$mixins;
      options.spacing;
      var _options$palette = options.palette,
      paletteInput = _options$palette === void 0 ? {} : _options$palette,
      _options$transitions = options.transitions,
      transitionsInput = _options$transitions === void 0 ? {} : _options$transitions,
      _options$typography = options.typography,
      typographyInput = _options$typography === void 0 ? {} : _options$typography;
      options.shape;
      var other = _objectWithoutProperties(options, ["breakpoints", "mixins", "spacing", "palette", "transitions", "typography", "shape"]);
    if (options.vars) {
      throw new Error("MUI: `vars` is a private field used for CSS variables support.\nPlease use another name." );
    }
    var palette = createPalette(paletteInput);
    var systemTheme = createTheme$1(options);
    var muiTheme = deepmerge(systemTheme, {
      mixins: createMixins(systemTheme.breakpoints, mixinsInput),
      palette: palette,
      // Don't use [...shadows] until you've verified its transpiled code is not invoking the iterator protocol.
      shadows: shadows$1.slice(),
      typography: createTypography(palette, typographyInput),
      transitions: createTransitions(transitionsInput),
      zIndex: _extends({}, zIndex$1)
    });
    muiTheme = deepmerge(muiTheme, other);
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }
    muiTheme = args.reduce(function (acc, argument) {
      return deepmerge(acc, argument);
    }, muiTheme);
    {
      // TODO v6: Refactor to use globalStateClassesMapping from @mui/utils once `readOnly` state class is used in Rating component.
      var stateClasses = ['active', 'checked', 'completed', 'disabled', 'error', 'expanded', 'focused', 'focusVisible', 'required', 'selected'];
      var traverse = function traverse(node, component) {
        var key;

        // eslint-disable-next-line guard-for-in, no-restricted-syntax
        for (key in node) {
          var child = node[key];
          if (stateClasses.indexOf(key) !== -1 && Object.keys(child).length > 0) {
            {
              var stateClass = generateUtilityClass$1('', key);
              console.error(["MUI: The `".concat(component, "` component increases ") + "the CSS specificity of the `".concat(key, "` internal state."), 'You can not override it like this: ', JSON.stringify(node, null, 2), '', "Instead, you need to use the '&.".concat(stateClass, "' syntax:"), JSON.stringify({
                root: _defineProperty({}, "&.".concat(stateClass), child)
              }, null, 2), '', 'https://mui.com/r/state-classes-guide'].join('\n'));
            }
            // Remove the style to prevent global conflicts.
            node[key] = {};
          }
        }
      };
      Object.keys(muiTheme.components).forEach(function (component) {
        var styleOverrides = muiTheme.components[component].styleOverrides;
        if (styleOverrides && component.indexOf('Mui') === 0) {
          traverse(styleOverrides, component);
        }
      });
    }
    muiTheme.unstable_sxConfig = _extends({}, defaultSxConfig$1, other == null ? void 0 : other.unstable_sxConfig);
    muiTheme.unstable_sx = function sx(props) {
      return styleFunctionSx$1({
        sx: props,
        theme: this
      });
    };
    return muiTheme;
  }
  var warnedOnce$1 = false;
  function createMuiTheme() {
    {
      if (!warnedOnce$1) {
        warnedOnce$1 = true;
        console.error(['MUI: the createMuiTheme function was renamed to createTheme.', '', "You should use `import { createTheme } from '@mui/material/styles'`"].join('\n'));
      }
    }
    return createTheme.apply(void 0, arguments);
  }

  function createMuiStrictModeTheme(options) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }
    return createTheme.apply(void 0, [deepmerge({
      unstable_strictMode: true
    }, options)].concat(args));
  }

  var warnedOnce = false;

  // To remove in v6
  function createStyles(styles) {
    if (!warnedOnce) {
      console.warn(['MUI: createStyles from @mui/material/styles is deprecated.', 'Please use @mui/styles/createStyles'].join('\n'));
      warnedOnce = true;
    }
    return styles;
  }

  function isUnitless(value) {
    return String(parseFloat(value)).length === String(value).length;
  }

  // Ported from Compass
  // https://github.com/Compass/compass/blob/master/core/stylesheets/compass/typography/_units.scss
  // Emulate the sass function "unit"
  function getUnit(input) {
    return String(input).match(/[\d.\-+]*\s*(.*)/)[1] || '';
  }

  // Emulate the sass function "unitless"
  function toUnitless(length) {
    return parseFloat(length);
  }

  // Convert any CSS <length> or <percentage> value to any another.
  // From https://github.com/KyleAMathews/convert-css-length
  function convertLength(baseFontSize) {
    return function (length, toUnit) {
      var fromUnit = getUnit(length);

      // Optimize for cases where `from` and `to` units are accidentally the same.
      if (fromUnit === toUnit) {
        return length;
      }

      // Convert input length to pixels.
      var pxLength = toUnitless(length);
      if (fromUnit !== 'px') {
        if (fromUnit === 'em') {
          pxLength = toUnitless(length) * toUnitless(baseFontSize);
        } else if (fromUnit === 'rem') {
          pxLength = toUnitless(length) * toUnitless(baseFontSize);
        }
      }

      // Convert length in pixels to the output unit
      var outputLength = pxLength;
      if (toUnit !== 'px') {
        if (toUnit === 'em') {
          outputLength = pxLength / toUnitless(baseFontSize);
        } else if (toUnit === 'rem') {
          outputLength = pxLength / toUnitless(baseFontSize);
        } else {
          return length;
        }
      }
      return parseFloat(outputLength.toFixed(5)) + toUnit;
    };
  }
  function alignProperty(_ref) {
    var size = _ref.size,
      grid = _ref.grid;
    var sizeBelow = size - size % grid;
    var sizeAbove = sizeBelow + grid;
    return size - sizeBelow < sizeAbove - size ? sizeBelow : sizeAbove;
  }

  // fontGrid finds a minimal grid (in rem) for the fontSize values so that the
  // lineHeight falls under a x pixels grid, 4px in the case of Material Design,
  // without changing the relative line height
  function fontGrid(_ref2) {
    var lineHeight = _ref2.lineHeight,
      pixels = _ref2.pixels,
      htmlFontSize = _ref2.htmlFontSize;
    return pixels / (lineHeight * htmlFontSize);
  }

  /**
   * generate a responsive version of a given CSS property
   * @example
   * responsiveProperty({
   *   cssProperty: 'fontSize',
   *   min: 15,
   *   max: 20,
   *   unit: 'px',
   *   breakpoints: [300, 600],
   * })
   *
   * // this returns
   *
   * {
   *   fontSize: '15px',
   *   '@media (min-width:300px)': {
   *     fontSize: '17.5px',
   *   },
   *   '@media (min-width:600px)': {
   *     fontSize: '20px',
   *   },
   * }
   * @param {Object} params
   * @param {string} params.cssProperty - The CSS property to be made responsive
   * @param {number} params.min - The smallest value of the CSS property
   * @param {number} params.max - The largest value of the CSS property
   * @param {string} [params.unit] - The unit to be used for the CSS property
   * @param {Array.number} [params.breakpoints]  - An array of breakpoints
   * @param {number} [params.alignStep] - Round scaled value to fall under this grid
   * @returns {Object} responsive styles for {params.cssProperty}
   */
  function responsiveProperty(_ref3) {
    var cssProperty = _ref3.cssProperty,
      min = _ref3.min,
      max = _ref3.max,
      _ref3$unit = _ref3.unit,
      unit = _ref3$unit === void 0 ? 'rem' : _ref3$unit,
      _ref3$breakpoints = _ref3.breakpoints,
      breakpoints = _ref3$breakpoints === void 0 ? [600, 900, 1200] : _ref3$breakpoints,
      _ref3$transform = _ref3.transform,
      transform = _ref3$transform === void 0 ? null : _ref3$transform;
    var output = _defineProperty({}, cssProperty, "".concat(min).concat(unit));
    var factor = (max - min) / breakpoints[breakpoints.length - 1];
    breakpoints.forEach(function (breakpoint) {
      var value = min + factor * breakpoint;
      if (transform !== null) {
        value = transform(value);
      }
      output["@media (min-width:".concat(breakpoint, "px)")] = _defineProperty({}, cssProperty, "".concat(Math.round(value * 10000) / 10000).concat(unit));
    });
    return output;
  }

  function responsiveFontSizes(themeInput) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var _options$breakpoints = options.breakpoints,
      breakpoints = _options$breakpoints === void 0 ? ['sm', 'md', 'lg'] : _options$breakpoints,
      _options$disableAlign = options.disableAlign,
      disableAlign = _options$disableAlign === void 0 ? false : _options$disableAlign,
      _options$factor = options.factor,
      factor = _options$factor === void 0 ? 2 : _options$factor,
      _options$variants = options.variants,
      variants = _options$variants === void 0 ? ['h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'subtitle1', 'subtitle2', 'body1', 'body2', 'caption', 'button', 'overline'] : _options$variants;
    var theme = _extends({}, themeInput);
    theme.typography = _extends({}, theme.typography);
    var typography = theme.typography;

    // Convert between CSS lengths e.g. em->px or px->rem
    // Set the baseFontSize for your project. Defaults to 16px (also the browser default).
    var convert = convertLength(typography.htmlFontSize);
    var breakpointValues = breakpoints.map(function (x) {
      return theme.breakpoints.values[x];
    });
    variants.forEach(function (variant) {
      var style = typography[variant];
      var remFontSize = parseFloat(convert(style.fontSize, 'rem'));
      if (remFontSize <= 1) {
        return;
      }
      var maxFontSize = remFontSize;
      var minFontSize = 1 + (maxFontSize - 1) / factor;
      var lineHeight = style.lineHeight;
      if (!isUnitless(lineHeight) && !disableAlign) {
        throw new Error("MUI: Unsupported non-unitless line height with grid alignment.\nUse unitless line heights instead." );
      }
      if (!isUnitless(lineHeight)) {
        // make it unitless
        lineHeight = parseFloat(convert(lineHeight, 'rem')) / parseFloat(remFontSize);
      }
      var transform = null;
      if (!disableAlign) {
        transform = function transform(value) {
          return alignProperty({
            size: value,
            grid: fontGrid({
              pixels: 4,
              lineHeight: lineHeight,
              htmlFontSize: typography.htmlFontSize
            })
          });
        };
      }
      typography[variant] = _extends({}, style, responsiveProperty({
        cssProperty: 'fontSize',
        min: minFontSize,
        max: maxFontSize,
        unit: 'rem',
        breakpoints: breakpointValues,
        transform: transform
      }));
    });
    return theme;
  }

  var defaultTheme$2 = createTheme();
  var defaultTheme$3 = defaultTheme$2;

  function useTheme() {
    var theme = useTheme$2(defaultTheme$3);
    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__namespace.useDebugValue(theme);
    }
    return theme[THEME_ID] || theme;
  }

  function useThemeProps$b(_ref) {
    var props = _ref.props,
      name = _ref.name;
    return useThemeProps$c({
      props: props,
      name: name,
      defaultTheme: defaultTheme$3,
      themeId: THEME_ID
    });
  }

  // copied from @mui/system/createStyled
  function slotShouldForwardProp(prop) {
    return prop !== 'ownerState' && prop !== 'theme' && prop !== 'sx' && prop !== 'as';
  }

  var rootShouldForwardProp = function rootShouldForwardProp(prop) {
    return slotShouldForwardProp(prop) && prop !== 'classes';
  };
  var rootShouldForwardProp$1 = rootShouldForwardProp;

  var styled = createStyled({
    themeId: THEME_ID,
    defaultTheme: defaultTheme$3,
    rootShouldForwardProp: rootShouldForwardProp$1
  });
  var styled$1 = styled;

  function ThemeProvider(_ref) {
    var themeInput = _ref.theme,
      props = _objectWithoutProperties(_ref, ["theme"]);
    var scopedTheme = themeInput[THEME_ID];
    return /*#__PURE__*/jsxRuntime_1(ThemeProvider$1, _extends({}, props, {
      themeId: scopedTheme ? THEME_ID : undefined,
      theme: scopedTheme || themeInput
    }));
  }
  ThemeProvider.propTypes = {
    /**
     * Your component tree.
     */
    children: PropTypes.node,
    /**
     * A theme object. You can provide a function to extend the outer theme.
     */
    theme: PropTypes.oneOfType([PropTypes.object, PropTypes.func]).isRequired
  } ;

  function makeStyles() {
    throw new Error("MUI: makeStyles is no longer exported from @mui/material/styles.\nYou have to import it from @mui/styles.\nSee https://mui.com/r/migration-v4/#mui-material-styles for more details." );
  }

  function withStyles() {
    throw new Error("MUI: withStyles is no longer exported from @mui/material/styles.\nYou have to import it from @mui/styles.\nSee https://mui.com/r/migration-v4/#mui-material-styles for more details." );
  }

  function withTheme() {
    throw new Error("MUI: withTheme is no longer exported from @mui/material/styles.\nYou have to import it from @mui/styles.\nSee https://mui.com/r/migration-v4/#mui-material-styles for more details." );
  }

  function shouldSkipGeneratingVar(keys) {
    var _keys$;
    return !!keys[0].match(/(cssVarPrefix|typography|mixins|breakpoints|direction|transitions)/) || !!keys[0].match(/sxConfig$/) ||
    // ends with sxConfig
    keys[0] === 'palette' && !!((_keys$ = keys[1]) != null && _keys$.match(/(mode|contrastThreshold|tonalOffset)/));
  }

  // Inspired by https://github.com/material-components/material-components-ios/blob/bca36107405594d5b7b16265a5b0ed698f85a5ee/components/Elevation/src/UIColor%2BMaterialElevation.m#L61
  var getOverlayAlpha = function getOverlayAlpha(elevation) {
    var alphaValue;
    if (elevation < 1) {
      alphaValue = 5.11916 * Math.pow(elevation, 2);
    } else {
      alphaValue = 4.5 * Math.log(elevation + 1) + 2;
    }
    return (alphaValue / 100).toFixed(2);
  };
  var getOverlayAlpha$1 = getOverlayAlpha;

  var defaultDarkOverlays = _toConsumableArray(Array(25)).map(function (_, index) {
    if (index === 0) {
      return undefined;
    }
    var overlay = getOverlayAlpha$1(index);
    return "linear-gradient(rgba(255 255 255 / ".concat(overlay, "), rgba(255 255 255 / ").concat(overlay, "))");
  });
  function assignNode(obj, keys) {
    keys.forEach(function (k) {
      if (!obj[k]) {
        obj[k] = {};
      }
    });
  }
  function setColor(obj, key, defaultValue) {
    if (!obj[key] && defaultValue) {
      obj[key] = defaultValue;
    }
  }
  function toRgb(color) {
    if (!color || !color.startsWith('hsl')) {
      return color;
    }
    return hslToRgb(color);
  }
  function setColorChannel(obj, key) {
    if (!("".concat(key, "Channel") in obj)) {
      // custom channel token is not provided, generate one.
      // if channel token can't be generated, show a warning.
      obj["".concat(key, "Channel")] = private_safeColorChannel(toRgb(obj[key]), "MUI: Can't create `palette.".concat(key, "Channel` because `palette.").concat(key, "` is not one of these formats: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla(), color().") + '\n' + "To suppress this warning, you need to explicitly provide the `palette.".concat(key, "Channel` as a string (in rgb format, for example \"12 12 12\") or undefined if you want to remove the channel token."));
    }
  }
  var silent = function silent(fn) {
    try {
      return fn();
    } catch (error) {
      // ignore error
    }
    return undefined;
  };
  var createGetCssVar = function createGetCssVar() {
    var cssVarPrefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'mui';
    return createGetCssVar$1(cssVarPrefix);
  };
  function extendTheme() {
    var _colorSchemesInput$li, _colorSchemesInput$da, _colorSchemesInput$li2, _colorSchemesInput$li3, _colorSchemesInput$da2, _colorSchemesInput$da3;
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var _options$colorSchemes = options.colorSchemes,
      colorSchemesInput = _options$colorSchemes === void 0 ? {} : _options$colorSchemes,
      _options$cssVarPrefix = options.cssVarPrefix,
      cssVarPrefix = _options$cssVarPrefix === void 0 ? 'mui' : _options$cssVarPrefix,
      _options$shouldSkipGe = options.shouldSkipGeneratingVar,
      shouldSkipGeneratingVar$1 = _options$shouldSkipGe === void 0 ? shouldSkipGeneratingVar : _options$shouldSkipGe,
      input = _objectWithoutProperties(options, ["colorSchemes", "cssVarPrefix", "shouldSkipGeneratingVar"]);
    var getCssVar = createGetCssVar(cssVarPrefix);
    var _createThemeWithoutVa = createTheme(_extends({}, input, colorSchemesInput.light && {
        palette: (_colorSchemesInput$li = colorSchemesInput.light) == null ? void 0 : _colorSchemesInput$li.palette
      })),
      lightPalette = _createThemeWithoutVa.palette,
      muiTheme = _objectWithoutProperties(_createThemeWithoutVa, ["palette"]);
    var _createThemeWithoutVa2 = createTheme({
        palette: _extends({
          mode: 'dark'
        }, (_colorSchemesInput$da = colorSchemesInput.dark) == null ? void 0 : _colorSchemesInput$da.palette)
      }),
      darkPalette = _createThemeWithoutVa2.palette;
    var theme = _extends({}, muiTheme, {
      cssVarPrefix: cssVarPrefix,
      getCssVar: getCssVar,
      colorSchemes: _extends({}, colorSchemesInput, {
        light: _extends({}, colorSchemesInput.light, {
          palette: lightPalette,
          opacity: _extends({
            inputPlaceholder: 0.42,
            inputUnderline: 0.42,
            switchTrackDisabled: 0.12,
            switchTrack: 0.38
          }, (_colorSchemesInput$li2 = colorSchemesInput.light) == null ? void 0 : _colorSchemesInput$li2.opacity),
          overlays: ((_colorSchemesInput$li3 = colorSchemesInput.light) == null ? void 0 : _colorSchemesInput$li3.overlays) || []
        }),
        dark: _extends({}, colorSchemesInput.dark, {
          palette: darkPalette,
          opacity: _extends({
            inputPlaceholder: 0.5,
            inputUnderline: 0.7,
            switchTrackDisabled: 0.2,
            switchTrack: 0.3
          }, (_colorSchemesInput$da2 = colorSchemesInput.dark) == null ? void 0 : _colorSchemesInput$da2.opacity),
          overlays: ((_colorSchemesInput$da3 = colorSchemesInput.dark) == null ? void 0 : _colorSchemesInput$da3.overlays) || defaultDarkOverlays
        })
      })
    });
    Object.keys(theme.colorSchemes).forEach(function (key) {
      var palette = theme.colorSchemes[key].palette;
      var setCssVarColor = function setCssVarColor(cssVar) {
        var tokens = cssVar.split('-');
        var color = tokens[1];
        var colorToken = tokens[2];
        return getCssVar(cssVar, palette[color][colorToken]);
      };

      // attach black & white channels to common node
      if (key === 'light') {
        setColor(palette.common, 'background', '#fff');
        setColor(palette.common, 'onBackground', '#000');
      } else {
        setColor(palette.common, 'background', '#000');
        setColor(palette.common, 'onBackground', '#fff');
      }

      // assign component variables
      assignNode(palette, ['Alert', 'AppBar', 'Avatar', 'Button', 'Chip', 'FilledInput', 'LinearProgress', 'Skeleton', 'Slider', 'SnackbarContent', 'SpeedDialAction', 'StepConnector', 'StepContent', 'Switch', 'TableCell', 'Tooltip']);
      if (key === 'light') {
        setColor(palette.Alert, 'errorColor', private_safeDarken(palette.error.light, 0.6));
        setColor(palette.Alert, 'infoColor', private_safeDarken(palette.info.light, 0.6));
        setColor(palette.Alert, 'successColor', private_safeDarken(palette.success.light, 0.6));
        setColor(palette.Alert, 'warningColor', private_safeDarken(palette.warning.light, 0.6));
        setColor(palette.Alert, 'errorFilledBg', setCssVarColor('palette-error-main'));
        setColor(palette.Alert, 'infoFilledBg', setCssVarColor('palette-info-main'));
        setColor(palette.Alert, 'successFilledBg', setCssVarColor('palette-success-main'));
        setColor(palette.Alert, 'warningFilledBg', setCssVarColor('palette-warning-main'));
        setColor(palette.Alert, 'errorFilledColor', silent(function () {
          return lightPalette.getContrastText(palette.error.main);
        }));
        setColor(palette.Alert, 'infoFilledColor', silent(function () {
          return lightPalette.getContrastText(palette.info.main);
        }));
        setColor(palette.Alert, 'successFilledColor', silent(function () {
          return lightPalette.getContrastText(palette.success.main);
        }));
        setColor(palette.Alert, 'warningFilledColor', silent(function () {
          return lightPalette.getContrastText(palette.warning.main);
        }));
        setColor(palette.Alert, 'errorStandardBg', private_safeLighten(palette.error.light, 0.9));
        setColor(palette.Alert, 'infoStandardBg', private_safeLighten(palette.info.light, 0.9));
        setColor(palette.Alert, 'successStandardBg', private_safeLighten(palette.success.light, 0.9));
        setColor(palette.Alert, 'warningStandardBg', private_safeLighten(palette.warning.light, 0.9));
        setColor(palette.Alert, 'errorIconColor', setCssVarColor('palette-error-main'));
        setColor(palette.Alert, 'infoIconColor', setCssVarColor('palette-info-main'));
        setColor(palette.Alert, 'successIconColor', setCssVarColor('palette-success-main'));
        setColor(palette.Alert, 'warningIconColor', setCssVarColor('palette-warning-main'));
        setColor(palette.AppBar, 'defaultBg', setCssVarColor('palette-grey-100'));
        setColor(palette.Avatar, 'defaultBg', setCssVarColor('palette-grey-400'));
        setColor(palette.Button, 'inheritContainedBg', setCssVarColor('palette-grey-300'));
        setColor(palette.Button, 'inheritContainedHoverBg', setCssVarColor('palette-grey-A100'));
        setColor(palette.Chip, 'defaultBorder', setCssVarColor('palette-grey-400'));
        setColor(palette.Chip, 'defaultAvatarColor', setCssVarColor('palette-grey-700'));
        setColor(palette.Chip, 'defaultIconColor', setCssVarColor('palette-grey-700'));
        setColor(palette.FilledInput, 'bg', 'rgba(0, 0, 0, 0.06)');
        setColor(palette.FilledInput, 'hoverBg', 'rgba(0, 0, 0, 0.09)');
        setColor(palette.FilledInput, 'disabledBg', 'rgba(0, 0, 0, 0.12)');
        setColor(palette.LinearProgress, 'primaryBg', private_safeLighten(palette.primary.main, 0.62));
        setColor(palette.LinearProgress, 'secondaryBg', private_safeLighten(palette.secondary.main, 0.62));
        setColor(palette.LinearProgress, 'errorBg', private_safeLighten(palette.error.main, 0.62));
        setColor(palette.LinearProgress, 'infoBg', private_safeLighten(palette.info.main, 0.62));
        setColor(palette.LinearProgress, 'successBg', private_safeLighten(palette.success.main, 0.62));
        setColor(palette.LinearProgress, 'warningBg', private_safeLighten(palette.warning.main, 0.62));
        setColor(palette.Skeleton, 'bg', "rgba(".concat(setCssVarColor('palette-text-primaryChannel'), " / 0.11)"));
        setColor(palette.Slider, 'primaryTrack', private_safeLighten(palette.primary.main, 0.62));
        setColor(palette.Slider, 'secondaryTrack', private_safeLighten(palette.secondary.main, 0.62));
        setColor(palette.Slider, 'errorTrack', private_safeLighten(palette.error.main, 0.62));
        setColor(palette.Slider, 'infoTrack', private_safeLighten(palette.info.main, 0.62));
        setColor(palette.Slider, 'successTrack', private_safeLighten(palette.success.main, 0.62));
        setColor(palette.Slider, 'warningTrack', private_safeLighten(palette.warning.main, 0.62));
        var snackbarContentBackground = private_safeEmphasize(palette.background["default"], 0.8);
        setColor(palette.SnackbarContent, 'bg', snackbarContentBackground);
        setColor(palette.SnackbarContent, 'color', silent(function () {
          return lightPalette.getContrastText(snackbarContentBackground);
        }));
        setColor(palette.SpeedDialAction, 'fabHoverBg', private_safeEmphasize(palette.background.paper, 0.15));
        setColor(palette.StepConnector, 'border', setCssVarColor('palette-grey-400'));
        setColor(palette.StepContent, 'border', setCssVarColor('palette-grey-400'));
        setColor(palette.Switch, 'defaultColor', setCssVarColor('palette-common-white'));
        setColor(palette.Switch, 'defaultDisabledColor', setCssVarColor('palette-grey-100'));
        setColor(palette.Switch, 'primaryDisabledColor', private_safeLighten(palette.primary.main, 0.62));
        setColor(palette.Switch, 'secondaryDisabledColor', private_safeLighten(palette.secondary.main, 0.62));
        setColor(palette.Switch, 'errorDisabledColor', private_safeLighten(palette.error.main, 0.62));
        setColor(palette.Switch, 'infoDisabledColor', private_safeLighten(palette.info.main, 0.62));
        setColor(palette.Switch, 'successDisabledColor', private_safeLighten(palette.success.main, 0.62));
        setColor(palette.Switch, 'warningDisabledColor', private_safeLighten(palette.warning.main, 0.62));
        setColor(palette.TableCell, 'border', private_safeLighten(private_safeAlpha(palette.divider, 1), 0.88));
        setColor(palette.Tooltip, 'bg', private_safeAlpha(palette.grey[700], 0.92));
      } else {
        setColor(palette.Alert, 'errorColor', private_safeLighten(palette.error.light, 0.6));
        setColor(palette.Alert, 'infoColor', private_safeLighten(palette.info.light, 0.6));
        setColor(palette.Alert, 'successColor', private_safeLighten(palette.success.light, 0.6));
        setColor(palette.Alert, 'warningColor', private_safeLighten(palette.warning.light, 0.6));
        setColor(palette.Alert, 'errorFilledBg', setCssVarColor('palette-error-dark'));
        setColor(palette.Alert, 'infoFilledBg', setCssVarColor('palette-info-dark'));
        setColor(palette.Alert, 'successFilledBg', setCssVarColor('palette-success-dark'));
        setColor(palette.Alert, 'warningFilledBg', setCssVarColor('palette-warning-dark'));
        setColor(palette.Alert, 'errorFilledColor', silent(function () {
          return darkPalette.getContrastText(palette.error.dark);
        }));
        setColor(palette.Alert, 'infoFilledColor', silent(function () {
          return darkPalette.getContrastText(palette.info.dark);
        }));
        setColor(palette.Alert, 'successFilledColor', silent(function () {
          return darkPalette.getContrastText(palette.success.dark);
        }));
        setColor(palette.Alert, 'warningFilledColor', silent(function () {
          return darkPalette.getContrastText(palette.warning.dark);
        }));
        setColor(palette.Alert, 'errorStandardBg', private_safeDarken(palette.error.light, 0.9));
        setColor(palette.Alert, 'infoStandardBg', private_safeDarken(palette.info.light, 0.9));
        setColor(palette.Alert, 'successStandardBg', private_safeDarken(palette.success.light, 0.9));
        setColor(palette.Alert, 'warningStandardBg', private_safeDarken(palette.warning.light, 0.9));
        setColor(palette.Alert, 'errorIconColor', setCssVarColor('palette-error-main'));
        setColor(palette.Alert, 'infoIconColor', setCssVarColor('palette-info-main'));
        setColor(palette.Alert, 'successIconColor', setCssVarColor('palette-success-main'));
        setColor(palette.Alert, 'warningIconColor', setCssVarColor('palette-warning-main'));
        setColor(palette.AppBar, 'defaultBg', setCssVarColor('palette-grey-900'));
        setColor(palette.AppBar, 'darkBg', setCssVarColor('palette-background-paper')); // specific for dark mode
        setColor(palette.AppBar, 'darkColor', setCssVarColor('palette-text-primary')); // specific for dark mode
        setColor(palette.Avatar, 'defaultBg', setCssVarColor('palette-grey-600'));
        setColor(palette.Button, 'inheritContainedBg', setCssVarColor('palette-grey-800'));
        setColor(palette.Button, 'inheritContainedHoverBg', setCssVarColor('palette-grey-700'));
        setColor(palette.Chip, 'defaultBorder', setCssVarColor('palette-grey-700'));
        setColor(palette.Chip, 'defaultAvatarColor', setCssVarColor('palette-grey-300'));
        setColor(palette.Chip, 'defaultIconColor', setCssVarColor('palette-grey-300'));
        setColor(palette.FilledInput, 'bg', 'rgba(255, 255, 255, 0.09)');
        setColor(palette.FilledInput, 'hoverBg', 'rgba(255, 255, 255, 0.13)');
        setColor(palette.FilledInput, 'disabledBg', 'rgba(255, 255, 255, 0.12)');
        setColor(palette.LinearProgress, 'primaryBg', private_safeDarken(palette.primary.main, 0.5));
        setColor(palette.LinearProgress, 'secondaryBg', private_safeDarken(palette.secondary.main, 0.5));
        setColor(palette.LinearProgress, 'errorBg', private_safeDarken(palette.error.main, 0.5));
        setColor(palette.LinearProgress, 'infoBg', private_safeDarken(palette.info.main, 0.5));
        setColor(palette.LinearProgress, 'successBg', private_safeDarken(palette.success.main, 0.5));
        setColor(palette.LinearProgress, 'warningBg', private_safeDarken(palette.warning.main, 0.5));
        setColor(palette.Skeleton, 'bg', "rgba(".concat(setCssVarColor('palette-text-primaryChannel'), " / 0.13)"));
        setColor(palette.Slider, 'primaryTrack', private_safeDarken(palette.primary.main, 0.5));
        setColor(palette.Slider, 'secondaryTrack', private_safeDarken(palette.secondary.main, 0.5));
        setColor(palette.Slider, 'errorTrack', private_safeDarken(palette.error.main, 0.5));
        setColor(palette.Slider, 'infoTrack', private_safeDarken(palette.info.main, 0.5));
        setColor(palette.Slider, 'successTrack', private_safeDarken(palette.success.main, 0.5));
        setColor(palette.Slider, 'warningTrack', private_safeDarken(palette.warning.main, 0.5));
        var _snackbarContentBackground = private_safeEmphasize(palette.background["default"], 0.98);
        setColor(palette.SnackbarContent, 'bg', _snackbarContentBackground);
        setColor(palette.SnackbarContent, 'color', silent(function () {
          return darkPalette.getContrastText(_snackbarContentBackground);
        }));
        setColor(palette.SpeedDialAction, 'fabHoverBg', private_safeEmphasize(palette.background.paper, 0.15));
        setColor(palette.StepConnector, 'border', setCssVarColor('palette-grey-600'));
        setColor(palette.StepContent, 'border', setCssVarColor('palette-grey-600'));
        setColor(palette.Switch, 'defaultColor', setCssVarColor('palette-grey-300'));
        setColor(palette.Switch, 'defaultDisabledColor', setCssVarColor('palette-grey-600'));
        setColor(palette.Switch, 'primaryDisabledColor', private_safeDarken(palette.primary.main, 0.55));
        setColor(palette.Switch, 'secondaryDisabledColor', private_safeDarken(palette.secondary.main, 0.55));
        setColor(palette.Switch, 'errorDisabledColor', private_safeDarken(palette.error.main, 0.55));
        setColor(palette.Switch, 'infoDisabledColor', private_safeDarken(palette.info.main, 0.55));
        setColor(palette.Switch, 'successDisabledColor', private_safeDarken(palette.success.main, 0.55));
        setColor(palette.Switch, 'warningDisabledColor', private_safeDarken(palette.warning.main, 0.55));
        setColor(palette.TableCell, 'border', private_safeDarken(private_safeAlpha(palette.divider, 1), 0.68));
        setColor(palette.Tooltip, 'bg', private_safeAlpha(palette.grey[700], 0.92));
      }

      // MUI X - DataGrid needs this token.
      setColorChannel(palette.background, 'default');

      // added for consistency with the `background.default` token
      setColorChannel(palette.background, 'paper');
      setColorChannel(palette.common, 'background');
      setColorChannel(palette.common, 'onBackground');
      setColorChannel(palette, 'divider');
      Object.keys(palette).forEach(function (color) {
        var colors = palette[color];

        // The default palettes (primary, secondary, error, info, success, and warning) errors are handled by the above `createTheme(...)`.

        if (colors && _typeof(colors) === 'object') {
          // Silent the error for custom palettes.
          if (colors.main) {
            setColor(palette[color], 'mainChannel', private_safeColorChannel(toRgb(colors.main)));
          }
          if (colors.light) {
            setColor(palette[color], 'lightChannel', private_safeColorChannel(toRgb(colors.light)));
          }
          if (colors.dark) {
            setColor(palette[color], 'darkChannel', private_safeColorChannel(toRgb(colors.dark)));
          }
          if (colors.contrastText) {
            setColor(palette[color], 'contrastTextChannel', private_safeColorChannel(toRgb(colors.contrastText)));
          }
          if (color === 'text') {
            // Text colors: text.primary, text.secondary
            setColorChannel(palette[color], 'primary');
            setColorChannel(palette[color], 'secondary');
          }
          if (color === 'action') {
            // Action colors: action.active, action.selected
            if (colors.active) {
              setColorChannel(palette[color], 'active');
            }
            if (colors.selected) {
              setColorChannel(palette[color], 'selected');
            }
          }
        }
      });
    });
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }
    theme = args.reduce(function (acc, argument) {
      return deepmerge(acc, argument);
    }, theme);
    var parserConfig = {
      prefix: cssVarPrefix,
      shouldSkipGeneratingVar: shouldSkipGeneratingVar$1
    };
    var _prepareCssVars = prepareCssVars(theme, parserConfig),
      themeVars = _prepareCssVars.vars,
      generateCssVars = _prepareCssVars.generateCssVars;
    theme.vars = themeVars;
    theme.generateCssVars = generateCssVars;
    theme.shouldSkipGeneratingVar = shouldSkipGeneratingVar$1;
    theme.unstable_sxConfig = _extends({}, defaultSxConfig$1, input == null ? void 0 : input.unstable_sxConfig);
    theme.unstable_sx = function sx(props) {
      return styleFunctionSx$1({
        sx: props,
        theme: this
      });
    };
    return theme;
  }

  /**
   * @internal These variables should not appear in the :root stylesheet when the `defaultMode="dark"`
   */
  var excludeVariablesFromRoot = function excludeVariablesFromRoot(cssVarPrefix) {
    return [].concat(_toConsumableArray(_toConsumableArray(Array(24)).map(function (_, index) {
      return "--".concat(cssVarPrefix ? "".concat(cssVarPrefix, "-") : '', "overlays-").concat(index + 1);
    })), ["--".concat(cssVarPrefix ? "".concat(cssVarPrefix, "-") : '', "palette-AppBar-darkBg"), "--".concat(cssVarPrefix ? "".concat(cssVarPrefix, "-") : '', "palette-AppBar-darkColor")]);
  };
  var excludeVariablesFromRoot$1 = excludeVariablesFromRoot;

  var defaultTheme$1 = extendTheme();
  var _createCssVarsProvide = createCssVarsProvider({
      themeId: THEME_ID,
      theme: defaultTheme$1,
      attribute: 'data-mui-color-scheme',
      modeStorageKey: 'mui-mode',
      colorSchemeStorageKey: 'mui-color-scheme',
      defaultColorScheme: {
        light: 'light',
        dark: 'dark'
      },
      resolveTheme: function resolveTheme(theme) {
        var newTheme = _extends({}, theme, {
          typography: createTypography(theme.palette, theme.typography)
        });
        newTheme.unstable_sx = function sx(props) {
          return styleFunctionSx$1({
            sx: props,
            theme: this
          });
        };
        return newTheme;
      },
      excludeVariablesFromRoot: excludeVariablesFromRoot$1
    }),
    CssVarsProvider = _createCssVarsProvide.CssVarsProvider,
    useColorScheme = _createCssVarsProvide.useColorScheme,
    getInitColorSchemeScript = _createCssVarsProvide.getInitColorSchemeScript;

  // TODO: Remove this function in v6.
  // eslint-disable-next-line @typescript-eslint/naming-convention
  function experimental_sx() {
    throw new Error("MUI: The `experimental_sx` has been moved to `theme.unstable_sx`.For more details, see https://github.com/mui/material-ui/pull/35150." );
  }

  function getSvgIconUtilityClass(slot) {
    return generateUtilityClass$1('MuiSvgIcon', slot);
  }
  var svgIconClasses = generateUtilityClasses$1('MuiSvgIcon', ['root', 'colorPrimary', 'colorSecondary', 'colorAction', 'colorError', 'colorDisabled', 'fontSizeInherit', 'fontSizeSmall', 'fontSizeMedium', 'fontSizeLarge']);
  var svgIconClasses$1 = svgIconClasses;

  var useUtilityClasses$1O = function useUtilityClasses(ownerState) {
    var color = ownerState.color,
      fontSize = ownerState.fontSize,
      classes = ownerState.classes;
    var slots = {
      root: ['root', color !== 'inherit' && "color".concat(capitalize(color)), "fontSize".concat(capitalize(fontSize))]
    };
    return composeClasses(slots, getSvgIconUtilityClass, classes);
  };
  var SvgIconRoot = styled$1('svg', {
    name: 'MuiSvgIcon',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      return [styles.root, ownerState.color !== 'inherit' && styles["color".concat(capitalize(ownerState.color))], styles["fontSize".concat(capitalize(ownerState.fontSize))]];
    }
  })(function (_ref) {
    var _theme$transitions, _theme$transitions$cr, _theme$transitions2, _theme$typography, _theme$typography$pxT, _theme$typography2, _theme$typography2$px, _theme$typography3, _theme$typography3$px, _palette$ownerState$c, _palette, _palette2, _palette3;
    var theme = _ref.theme,
      ownerState = _ref.ownerState;
    return {
      userSelect: 'none',
      width: '1em',
      height: '1em',
      display: 'inline-block',
      // the <svg> will define the property that has `currentColor`
      // for example heroicons uses fill="none" and stroke="currentColor"
      fill: ownerState.hasSvgAsChild ? undefined : 'currentColor',
      flexShrink: 0,
      transition: (_theme$transitions = theme.transitions) == null || (_theme$transitions$cr = _theme$transitions.create) == null ? void 0 : _theme$transitions$cr.call(_theme$transitions, 'fill', {
        duration: (_theme$transitions2 = theme.transitions) == null || (_theme$transitions2 = _theme$transitions2.duration) == null ? void 0 : _theme$transitions2.shorter
      }),
      fontSize: {
        inherit: 'inherit',
        small: ((_theme$typography = theme.typography) == null || (_theme$typography$pxT = _theme$typography.pxToRem) == null ? void 0 : _theme$typography$pxT.call(_theme$typography, 20)) || '1.25rem',
        medium: ((_theme$typography2 = theme.typography) == null || (_theme$typography2$px = _theme$typography2.pxToRem) == null ? void 0 : _theme$typography2$px.call(_theme$typography2, 24)) || '1.5rem',
        large: ((_theme$typography3 = theme.typography) == null || (_theme$typography3$px = _theme$typography3.pxToRem) == null ? void 0 : _theme$typography3$px.call(_theme$typography3, 35)) || '2.1875rem'
      }[ownerState.fontSize],
      // TODO v5 deprecate, v6 remove for sx
      color: (_palette$ownerState$c = (_palette = (theme.vars || theme).palette) == null || (_palette = _palette[ownerState.color]) == null ? void 0 : _palette.main) != null ? _palette$ownerState$c : {
        action: (_palette2 = (theme.vars || theme).palette) == null || (_palette2 = _palette2.action) == null ? void 0 : _palette2.active,
        disabled: (_palette3 = (theme.vars || theme).palette) == null || (_palette3 = _palette3.action) == null ? void 0 : _palette3.disabled,
        inherit: undefined
      }[ownerState.color]
    };
  });
  var SvgIcon = /*#__PURE__*/React__namespace.forwardRef(function SvgIcon(inProps, ref) {
    var props = useThemeProps$b({
      props: inProps,
      name: 'MuiSvgIcon'
    });
    var children = props.children,
      className = props.className,
      _props$color = props.color,
      color = _props$color === void 0 ? 'inherit' : _props$color,
      _props$component = props.component,
      component = _props$component === void 0 ? 'svg' : _props$component,
      _props$fontSize = props.fontSize,
      fontSize = _props$fontSize === void 0 ? 'medium' : _props$fontSize,
      htmlColor = props.htmlColor,
      _props$inheritViewBox = props.inheritViewBox,
      inheritViewBox = _props$inheritViewBox === void 0 ? false : _props$inheritViewBox,
      titleAccess = props.titleAccess,
      _props$viewBox = props.viewBox,
      viewBox = _props$viewBox === void 0 ? '0 0 24 24' : _props$viewBox,
      other = _objectWithoutProperties(props, ["children", "className", "color", "component", "fontSize", "htmlColor", "inheritViewBox", "titleAccess", "viewBox"]);
    var hasSvgAsChild = /*#__PURE__*/React__namespace.isValidElement(children) && children.type === 'svg';
    var ownerState = _extends({}, props, {
      color: color,
      component: component,
      fontSize: fontSize,
      instanceFontSize: inProps.fontSize,
      inheritViewBox: inheritViewBox,
      viewBox: viewBox,
      hasSvgAsChild: hasSvgAsChild
    });
    var more = {};
    if (!inheritViewBox) {
      more.viewBox = viewBox;
    }
    var classes = useUtilityClasses$1O(ownerState);
    return /*#__PURE__*/jsxRuntime_2(SvgIconRoot, _extends({
      as: component,
      className: clsx(classes.root, className),
      focusable: "false",
      color: htmlColor,
      "aria-hidden": titleAccess ? undefined : true,
      role: titleAccess ? 'img' : undefined,
      ref: ref
    }, more, other, hasSvgAsChild && children.props, {
      ownerState: ownerState,
      children: [hasSvgAsChild ? children.props.children : children, titleAccess ? /*#__PURE__*/jsxRuntime_1("title", {
        children: titleAccess
      }) : null]
    }));
  });
  SvgIcon.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * Node passed into the SVG element.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#custom-colors).
     * You can use the `htmlColor` prop to apply a color attribute to the SVG element.
     * @default 'inherit'
     */
    color: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['inherit', 'action', 'disabled', 'primary', 'secondary', 'error', 'info', 'success', 'warning']), PropTypes.string]),
    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,
    /**
     * The fontSize applied to the icon. Defaults to 24px, but can be configure to inherit font size.
     * @default 'medium'
     */
    fontSize: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['inherit', 'large', 'medium', 'small']), PropTypes.string]),
    /**
     * Applies a color attribute to the SVG element.
     */
    htmlColor: PropTypes.string,
    /**
     * If `true`, the root node will inherit the custom `component`'s viewBox and the `viewBox`
     * prop will be ignored.
     * Useful when you want to reference a custom `component` and have `SvgIcon` pass that
     * `component`'s viewBox to the root node.
     * @default false
     */
    inheritViewBox: PropTypes.bool,
    /**
     * The shape-rendering attribute. The behavior of the different options is described on the
     * [MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/shape-rendering).
     * If you are having issues with blurry icons you should investigate this prop.
     */
    shapeRendering: PropTypes.string,
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
    /**
     * Provides a human-readable title for the element that contains it.
     * https://www.w3.org/TR/SVG-access/#Equivalent
     */
    titleAccess: PropTypes.string,
    /**
     * Allows you to redefine what the coordinates without units mean inside an SVG element.
     * For example, if the SVG element is 500 (width) by 200 (height),
     * and you pass viewBox="0 0 50 20",
     * this means that the coordinates inside the SVG will go from the top left corner (0,0)
     * to bottom right (50,20) and each unit will be worth 10px.
     * @default '0 0 24 24'
     */
    viewBox: PropTypes.string
  } ;
  SvgIcon.muiName = 'SvgIcon';
  var SvgIcon$1 = SvgIcon;

  function createSvgIcon(path, displayName) {
    function Component(props, ref) {
      return /*#__PURE__*/jsxRuntime_1(SvgIcon$1, _extends({
        "data-testid": "".concat(displayName, "Icon"),
        ref: ref
      }, props, {
        children: path
      }));
    }
    {
      // Need to set `displayName` on the inner component for React.memo.
      // React prior to 16.14 ignores `displayName` on the wrapper.
      Component.displayName = "".concat(displayName, "Icon");
    }
    Component.muiName = SvgIcon$1.muiName;
    return /*#__PURE__*/React__namespace.memo( /*#__PURE__*/React__namespace.forwardRef(Component));
  }

  // TODO: remove this export once ClassNameGenerator is stable
  // eslint-disable-next-line @typescript-eslint/naming-convention
  var unstable_ClassNameGenerator = {
    configure: function configure(generator) {
      {
        console.warn(['MUI: `ClassNameGenerator` import from `@mui/material/utils` is outdated and might cause unexpected issues.', '', "You should use `import { unstable_ClassNameGenerator } from '@mui/material/className'` instead", '', 'The detail of the issue: https://github.com/mui/material-ui/issues/30011#issuecomment-1024993401', '', 'The updated documentation: https://mui.com/guides/classname-generator/'].join('\n'));
      }
      ClassNameGenerator$1.configure(generator);
    }
  };

  function _toArray(arr) {
    return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest();
  }

  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  function createUseThemeProps(name) {
    return useThemeProps$b;
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };
    return _setPrototypeOf(o, p);
  }

  function _inheritsLoose(subClass, superClass) {
    subClass.prototype = Object.create(superClass.prototype);
    subClass.prototype.constructor = subClass;
    _setPrototypeOf(subClass, superClass);
  }

  var config = {
    disabled: false
  };

  var timeoutsShape = PropTypes.oneOfType([PropTypes.number, PropTypes.shape({
    enter: PropTypes.number,
    exit: PropTypes.number,
    appear: PropTypes.number
  }).isRequired]) ;
  PropTypes.oneOfType([PropTypes.string, PropTypes.shape({
    enter: PropTypes.string,
    exit: PropTypes.string,
    active: PropTypes.string
  }), PropTypes.shape({
    enter: PropTypes.string,
    enterDone: PropTypes.string,
    enterActive: PropTypes.string,
    exit: PropTypes.string,
    exitDone: PropTypes.string,
    exitActive: PropTypes.string
  })]) ;

  var TransitionGroupContext = React.createContext(null);

  var forceReflow = function forceReflow(node) {
    return node.scrollTop;
  };

  var UNMOUNTED = 'unmounted';
  var EXITED = 'exited';
  var ENTERING = 'entering';
  var ENTERED = 'entered';
  var EXITING = 'exiting';
  /**
   * The Transition component lets you describe a transition from one component
   * state to another _over time_ with a simple declarative API. Most commonly
   * it's used to animate the mounting and unmounting of a component, but can also
   * be used to describe in-place transition states as well.
   *
   * ---
   *
   * **Note**: `Transition` is a platform-agnostic base component. If you're using
   * transitions in CSS, you'll probably want to use
   * [`CSSTransition`](https://reactcommunity.org/react-transition-group/css-transition)
   * instead. It inherits all the features of `Transition`, but contains
   * additional features necessary to play nice with CSS transitions (hence the
   * name of the component).
   *
   * ---
   *
   * By default the `Transition` component does not alter the behavior of the
   * component it renders, it only tracks "enter" and "exit" states for the
   * components. It's up to you to give meaning and effect to those states. For
   * example we can add styles to a component when it enters or exits:
   *
   * ```jsx
   * import { Transition } from 'react-transition-group';
   *
   * const duration = 300;
   *
   * const defaultStyle = {
   *   transition: `opacity ${duration}ms ease-in-out`,
   *   opacity: 0,
   * }
   *
   * const transitionStyles = {
   *   entering: { opacity: 1 },
   *   entered:  { opacity: 1 },
   *   exiting:  { opacity: 0 },
   *   exited:  { opacity: 0 },
   * };
   *
   * const Fade = ({ in: inProp }) => (
   *   <Transition in={inProp} timeout={duration}>
   *     {state => (
   *       <div style={{
   *         ...defaultStyle,
   *         ...transitionStyles[state]
   *       }}>
   *         I'm a fade Transition!
   *       </div>
   *     )}
   *   </Transition>
   * );
   * ```
   *
   * There are 4 main states a Transition can be in:
   *  - `'entering'`
   *  - `'entered'`
   *  - `'exiting'`
   *  - `'exited'`
   *
   * Transition state is toggled via the `in` prop. When `true` the component
   * begins the "Enter" stage. During this stage, the component will shift from
   * its current transition state, to `'entering'` for the duration of the
   * transition and then to the `'entered'` stage once it's complete. Let's take
   * the following example (we'll use the
   * [useState](https://reactjs.org/docs/hooks-reference.html#usestate) hook):
   *
   * ```jsx
   * function App() {
   *   const [inProp, setInProp] = useState(false);
   *   return (
   *     <div>
   *       <Transition in={inProp} timeout={500}>
   *         {state => (
   *           // ...
   *         )}
   *       </Transition>
   *       <button onClick={() => setInProp(true)}>
   *         Click to Enter
   *       </button>
   *     </div>
   *   );
   * }
   * ```
   *
   * When the button is clicked the component will shift to the `'entering'` state
   * and stay there for 500ms (the value of `timeout`) before it finally switches
   * to `'entered'`.
   *
   * When `in` is `false` the same thing happens except the state moves from
   * `'exiting'` to `'exited'`.
   */

  var Transition = /*#__PURE__*/function (_React$Component) {
    _inheritsLoose(Transition, _React$Component);

    function Transition(props, context) {
      var _this;

      _this = _React$Component.call(this, props, context) || this;
      var parentGroup = context; // In the context of a TransitionGroup all enters are really appears

      var appear = parentGroup && !parentGroup.isMounting ? props.enter : props.appear;
      var initialStatus;
      _this.appearStatus = null;

      if (props.in) {
        if (appear) {
          initialStatus = EXITED;
          _this.appearStatus = ENTERING;
        } else {
          initialStatus = ENTERED;
        }
      } else {
        if (props.unmountOnExit || props.mountOnEnter) {
          initialStatus = UNMOUNTED;
        } else {
          initialStatus = EXITED;
        }
      }

      _this.state = {
        status: initialStatus
      };
      _this.nextCallback = null;
      return _this;
    }

    Transition.getDerivedStateFromProps = function getDerivedStateFromProps(_ref, prevState) {
      var nextIn = _ref.in;

      if (nextIn && prevState.status === UNMOUNTED) {
        return {
          status: EXITED
        };
      }

      return null;
    } // getSnapshotBeforeUpdate(prevProps) {
    //   let nextStatus = null
    //   if (prevProps !== this.props) {
    //     const { status } = this.state
    //     if (this.props.in) {
    //       if (status !== ENTERING && status !== ENTERED) {
    //         nextStatus = ENTERING
    //       }
    //     } else {
    //       if (status === ENTERING || status === ENTERED) {
    //         nextStatus = EXITING
    //       }
    //     }
    //   }
    //   return { nextStatus }
    // }
    ;

    var _proto = Transition.prototype;

    _proto.componentDidMount = function componentDidMount() {
      this.updateStatus(true, this.appearStatus);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      var nextStatus = null;

      if (prevProps !== this.props) {
        var status = this.state.status;

        if (this.props.in) {
          if (status !== ENTERING && status !== ENTERED) {
            nextStatus = ENTERING;
          }
        } else {
          if (status === ENTERING || status === ENTERED) {
            nextStatus = EXITING;
          }
        }
      }

      this.updateStatus(false, nextStatus);
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      this.cancelNextCallback();
    };

    _proto.getTimeouts = function getTimeouts() {
      var timeout = this.props.timeout;
      var exit, enter, appear;
      exit = enter = appear = timeout;

      if (timeout != null && typeof timeout !== 'number') {
        exit = timeout.exit;
        enter = timeout.enter; // TODO: remove fallback for next major

        appear = timeout.appear !== undefined ? timeout.appear : enter;
      }

      return {
        exit: exit,
        enter: enter,
        appear: appear
      };
    };

    _proto.updateStatus = function updateStatus(mounting, nextStatus) {
      if (mounting === void 0) {
        mounting = false;
      }

      if (nextStatus !== null) {
        // nextStatus will always be ENTERING or EXITING.
        this.cancelNextCallback();

        if (nextStatus === ENTERING) {
          if (this.props.unmountOnExit || this.props.mountOnEnter) {
            var node = this.props.nodeRef ? this.props.nodeRef.current : ReactDOM.findDOMNode(this); // https://github.com/reactjs/react-transition-group/pull/749
            // With unmountOnExit or mountOnEnter, the enter animation should happen at the transition between `exited` and `entering`.
            // To make the animation happen,  we have to separate each rendering and avoid being processed as batched.

            if (node) forceReflow(node);
          }

          this.performEnter(mounting);
        } else {
          this.performExit();
        }
      } else if (this.props.unmountOnExit && this.state.status === EXITED) {
        this.setState({
          status: UNMOUNTED
        });
      }
    };

    _proto.performEnter = function performEnter(mounting) {
      var _this2 = this;

      var enter = this.props.enter;
      var appearing = this.context ? this.context.isMounting : mounting;

      var _ref2 = this.props.nodeRef ? [appearing] : [ReactDOM.findDOMNode(this), appearing],
          maybeNode = _ref2[0],
          maybeAppearing = _ref2[1];

      var timeouts = this.getTimeouts();
      var enterTimeout = appearing ? timeouts.appear : timeouts.enter; // no enter animation skip right to ENTERED
      // if we are mounting and running this it means appear _must_ be set

      if (!mounting && !enter || config.disabled) {
        this.safeSetState({
          status: ENTERED
        }, function () {
          _this2.props.onEntered(maybeNode);
        });
        return;
      }

      this.props.onEnter(maybeNode, maybeAppearing);
      this.safeSetState({
        status: ENTERING
      }, function () {
        _this2.props.onEntering(maybeNode, maybeAppearing);

        _this2.onTransitionEnd(enterTimeout, function () {
          _this2.safeSetState({
            status: ENTERED
          }, function () {
            _this2.props.onEntered(maybeNode, maybeAppearing);
          });
        });
      });
    };

    _proto.performExit = function performExit() {
      var _this3 = this;

      var exit = this.props.exit;
      var timeouts = this.getTimeouts();
      var maybeNode = this.props.nodeRef ? undefined : ReactDOM.findDOMNode(this); // no exit animation skip right to EXITED

      if (!exit || config.disabled) {
        this.safeSetState({
          status: EXITED
        }, function () {
          _this3.props.onExited(maybeNode);
        });
        return;
      }

      this.props.onExit(maybeNode);
      this.safeSetState({
        status: EXITING
      }, function () {
        _this3.props.onExiting(maybeNode);

        _this3.onTransitionEnd(timeouts.exit, function () {
          _this3.safeSetState({
            status: EXITED
          }, function () {
            _this3.props.onExited(maybeNode);
          });
        });
      });
    };

    _proto.cancelNextCallback = function cancelNextCallback() {
      if (this.nextCallback !== null) {
        this.nextCallback.cancel();
        this.nextCallback = null;
      }
    };

    _proto.safeSetState = function safeSetState(nextState, callback) {
      // This shouldn't be necessary, but there are weird race conditions with
      // setState callbacks and unmounting in testing, so always make sure that
      // we can cancel any pending setState callbacks after we unmount.
      callback = this.setNextCallback(callback);
      this.setState(nextState, callback);
    };

    _proto.setNextCallback = function setNextCallback(callback) {
      var _this4 = this;

      var active = true;

      this.nextCallback = function (event) {
        if (active) {
          active = false;
          _this4.nextCallback = null;
          callback(event);
        }
      };

      this.nextCallback.cancel = function () {
        active = false;
      };

      return this.nextCallback;
    };

    _proto.onTransitionEnd = function onTransitionEnd(timeout, handler) {
      this.setNextCallback(handler);
      var node = this.props.nodeRef ? this.props.nodeRef.current : ReactDOM.findDOMNode(this);
      var doesNotHaveTimeoutOrListener = timeout == null && !this.props.addEndListener;

      if (!node || doesNotHaveTimeoutOrListener) {
        setTimeout(this.nextCallback, 0);
        return;
      }

      if (this.props.addEndListener) {
        var _ref3 = this.props.nodeRef ? [this.nextCallback] : [node, this.nextCallback],
            maybeNode = _ref3[0],
            maybeNextCallback = _ref3[1];

        this.props.addEndListener(maybeNode, maybeNextCallback);
      }

      if (timeout != null) {
        setTimeout(this.nextCallback, timeout);
      }
    };

    _proto.render = function render() {
      var status = this.state.status;

      if (status === UNMOUNTED) {
        return null;
      }

      var _this$props = this.props,
          children = _this$props.children;
          _this$props.in;
          _this$props.mountOnEnter;
          _this$props.unmountOnExit;
          _this$props.appear;
          _this$props.enter;
          _this$props.exit;
          _this$props.timeout;
          _this$props.addEndListener;
          _this$props.onEnter;
          _this$props.onEntering;
          _this$props.onEntered;
          _this$props.onExit;
          _this$props.onExiting;
          _this$props.onExited;
          _this$props.nodeRef;
          var childProps = _objectWithoutPropertiesLoose(_this$props, ["children", "in", "mountOnEnter", "unmountOnExit", "appear", "enter", "exit", "timeout", "addEndListener", "onEnter", "onEntering", "onEntered", "onExit", "onExiting", "onExited", "nodeRef"]);

      return (
        /*#__PURE__*/
        // allows for nested Transitions
        React.createElement(TransitionGroupContext.Provider, {
          value: null
        }, typeof children === 'function' ? children(status, childProps) : React.cloneElement(React.Children.only(children), childProps))
      );
    };

    return Transition;
  }(React.Component);

  Transition.contextType = TransitionGroupContext;
  Transition.propTypes = {
    /**
     * A React reference to DOM element that need to transition:
     * https://stackoverflow.com/a/51127130/4671932
     *
     *   - When `nodeRef` prop is used, `node` is not passed to callback functions
     *      (e.g. `onEnter`) because user already has direct access to the node.
     *   - When changing `key` prop of `Transition` in a `TransitionGroup` a new
     *     `nodeRef` need to be provided to `Transition` with changed `key` prop
     *     (see
     *     [test/CSSTransition-test.js](https://github.com/reactjs/react-transition-group/blob/13435f897b3ab71f6e19d724f145596f5910581c/test/CSSTransition-test.js#L362-L437)).
     */
    nodeRef: PropTypes.shape({
      current: typeof Element === 'undefined' ? PropTypes.any : function (propValue, key, componentName, location, propFullName, secret) {
        var value = propValue[key];
        return PropTypes.instanceOf(value && 'ownerDocument' in value ? value.ownerDocument.defaultView.Element : Element)(propValue, key, componentName, location, propFullName, secret);
      }
    }),

    /**
     * A `function` child can be used instead of a React element. This function is
     * called with the current transition status (`'entering'`, `'entered'`,
     * `'exiting'`, `'exited'`), which can be used to apply context
     * specific props to a component.
     *
     * ```jsx
     * <Transition in={this.state.in} timeout={150}>
     *   {state => (
     *     <MyComponent className={`fade fade-${state}`} />
     *   )}
     * </Transition>
     * ```
     */
    children: PropTypes.oneOfType([PropTypes.func.isRequired, PropTypes.element.isRequired]).isRequired,

    /**
     * Show the component; triggers the enter or exit states
     */
    in: PropTypes.bool,

    /**
     * By default the child component is mounted immediately along with
     * the parent `Transition` component. If you want to "lazy mount" the component on the
     * first `in={true}` you can set `mountOnEnter`. After the first enter transition the component will stay
     * mounted, even on "exited", unless you also specify `unmountOnExit`.
     */
    mountOnEnter: PropTypes.bool,

    /**
     * By default the child component stays mounted after it reaches the `'exited'` state.
     * Set `unmountOnExit` if you'd prefer to unmount the component after it finishes exiting.
     */
    unmountOnExit: PropTypes.bool,

    /**
     * By default the child component does not perform the enter transition when
     * it first mounts, regardless of the value of `in`. If you want this
     * behavior, set both `appear` and `in` to `true`.
     *
     * > **Note**: there are no special appear states like `appearing`/`appeared`, this prop
     * > only adds an additional enter transition. However, in the
     * > `<CSSTransition>` component that first enter transition does result in
     * > additional `.appear-*` classes, that way you can choose to style it
     * > differently.
     */
    appear: PropTypes.bool,

    /**
     * Enable or disable enter transitions.
     */
    enter: PropTypes.bool,

    /**
     * Enable or disable exit transitions.
     */
    exit: PropTypes.bool,

    /**
     * The duration of the transition, in milliseconds.
     * Required unless `addEndListener` is provided.
     *
     * You may specify a single timeout for all transitions:
     *
     * ```jsx
     * timeout={500}
     * ```
     *
     * or individually:
     *
     * ```jsx
     * timeout={{
     *  appear: 500,
     *  enter: 300,
     *  exit: 500,
     * }}
     * ```
     *
     * - `appear` defaults to the value of `enter`
     * - `enter` defaults to `0`
     * - `exit` defaults to `0`
     *
     * @type {number | { enter?: number, exit?: number, appear?: number }}
     */
    timeout: function timeout(props) {
      var pt = timeoutsShape;
      if (!props.addEndListener) pt = pt.isRequired;

      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      return pt.apply(void 0, [props].concat(args));
    },

    /**
     * Add a custom transition end trigger. Called with the transitioning
     * DOM node and a `done` callback. Allows for more fine grained transition end
     * logic. Timeouts are still used as a fallback if provided.
     *
     * **Note**: when `nodeRef` prop is passed, `node` is not passed.
     *
     * ```jsx
     * addEndListener={(node, done) => {
     *   // use the css transitionend event to mark the finish of a transition
     *   node.addEventListener('transitionend', done, false);
     * }}
     * ```
     */
    addEndListener: PropTypes.func,

    /**
     * Callback fired before the "entering" status is applied. An extra parameter
     * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
     *
     * **Note**: when `nodeRef` prop is passed, `node` is not passed.
     *
     * @type Function(node: HtmlElement, isAppearing: bool) -> void
     */
    onEnter: PropTypes.func,

    /**
     * Callback fired after the "entering" status is applied. An extra parameter
     * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
     *
     * **Note**: when `nodeRef` prop is passed, `node` is not passed.
     *
     * @type Function(node: HtmlElement, isAppearing: bool)
     */
    onEntering: PropTypes.func,

    /**
     * Callback fired after the "entered" status is applied. An extra parameter
     * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
     *
     * **Note**: when `nodeRef` prop is passed, `node` is not passed.
     *
     * @type Function(node: HtmlElement, isAppearing: bool) -> void
     */
    onEntered: PropTypes.func,

    /**
     * Callback fired before the "exiting" status is applied.
     *
     * **Note**: when `nodeRef` prop is passed, `node` is not passed.
     *
     * @type Function(node: HtmlElement) -> void
     */
    onExit: PropTypes.func,

    /**
     * Callback fired after the "exiting" status is applied.
     *
     * **Note**: when `nodeRef` prop is passed, `node` is not passed.
     *
     * @type Function(node: HtmlElement) -> void
     */
    onExiting: PropTypes.func,

    /**
     * Callback fired after the "exited" status is applied.
     *
     * **Note**: when `nodeRef` prop is passed, `node` is not passed
     *
     * @type Function(node: HtmlElement) -> void
     */
    onExited: PropTypes.func
  } ; // Name the function so it is clearer in the documentation

  function noop() {}

  Transition.defaultProps = {
    in: false,
    mountOnEnter: false,
    unmountOnExit: false,
    appear: false,
    enter: true,
    exit: true,
    onEnter: noop,
    onEntering: noop,
    onEntered: noop,
    onExit: noop,
    onExiting: noop,
    onExited: noop
  };
  Transition.UNMOUNTED = UNMOUNTED;
  Transition.EXITED = EXITED;
  Transition.ENTERING = ENTERING;
  Transition.ENTERED = ENTERED;
  Transition.EXITING = EXITING;
  var Transition$1 = Transition;

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return self;
  }

  /**
   * Given `this.props.children`, return an object mapping key to child.
   *
   * @param {*} children `this.props.children`
   * @return {object} Mapping of key to child
   */

  function getChildMapping(children, mapFn) {
    var mapper = function mapper(child) {
      return mapFn && React.isValidElement(child) ? mapFn(child) : child;
    };

    var result = Object.create(null);
    if (children) React.Children.map(children, function (c) {
      return c;
    }).forEach(function (child) {
      // run the map function here instead so that the key is the computed one
      result[child.key] = mapper(child);
    });
    return result;
  }
  /**
   * When you're adding or removing children some may be added or removed in the
   * same render pass. We want to show *both* since we want to simultaneously
   * animate elements in and out. This function takes a previous set of keys
   * and a new set of keys and merges them with its best guess of the correct
   * ordering. In the future we may expose some of the utilities in
   * ReactMultiChild to make this easy, but for now React itself does not
   * directly have this concept of the union of prevChildren and nextChildren
   * so we implement it here.
   *
   * @param {object} prev prev children as returned from
   * `ReactTransitionChildMapping.getChildMapping()`.
   * @param {object} next next children as returned from
   * `ReactTransitionChildMapping.getChildMapping()`.
   * @return {object} a key set that contains all keys in `prev` and all keys
   * in `next` in a reasonable order.
   */

  function mergeChildMappings(prev, next) {
    prev = prev || {};
    next = next || {};

    function getValueForKey(key) {
      return key in next ? next[key] : prev[key];
    } // For each key of `next`, the list of keys to insert before that key in
    // the combined list


    var nextKeysPending = Object.create(null);
    var pendingKeys = [];

    for (var prevKey in prev) {
      if (prevKey in next) {
        if (pendingKeys.length) {
          nextKeysPending[prevKey] = pendingKeys;
          pendingKeys = [];
        }
      } else {
        pendingKeys.push(prevKey);
      }
    }

    var i;
    var childMapping = {};

    for (var nextKey in next) {
      if (nextKeysPending[nextKey]) {
        for (i = 0; i < nextKeysPending[nextKey].length; i++) {
          var pendingNextKey = nextKeysPending[nextKey][i];
          childMapping[nextKeysPending[nextKey][i]] = getValueForKey(pendingNextKey);
        }
      }

      childMapping[nextKey] = getValueForKey(nextKey);
    } // Finally, add the keys which didn't appear before any key in `next`


    for (i = 0; i < pendingKeys.length; i++) {
      childMapping[pendingKeys[i]] = getValueForKey(pendingKeys[i]);
    }

    return childMapping;
  }

  function getProp(child, prop, props) {
    return props[prop] != null ? props[prop] : child.props[prop];
  }

  function getInitialChildMapping(props, onExited) {
    return getChildMapping(props.children, function (child) {
      return React.cloneElement(child, {
        onExited: onExited.bind(null, child),
        in: true,
        appear: getProp(child, 'appear', props),
        enter: getProp(child, 'enter', props),
        exit: getProp(child, 'exit', props)
      });
    });
  }
  function getNextChildMapping(nextProps, prevChildMapping, onExited) {
    var nextChildMapping = getChildMapping(nextProps.children);
    var children = mergeChildMappings(prevChildMapping, nextChildMapping);
    Object.keys(children).forEach(function (key) {
      var child = children[key];
      if (!React.isValidElement(child)) return;
      var hasPrev = (key in prevChildMapping);
      var hasNext = (key in nextChildMapping);
      var prevChild = prevChildMapping[key];
      var isLeaving = React.isValidElement(prevChild) && !prevChild.props.in; // item is new (entering)

      if (hasNext && (!hasPrev || isLeaving)) {
        // console.log('entering', key)
        children[key] = React.cloneElement(child, {
          onExited: onExited.bind(null, child),
          in: true,
          exit: getProp(child, 'exit', nextProps),
          enter: getProp(child, 'enter', nextProps)
        });
      } else if (!hasNext && hasPrev && !isLeaving) {
        // item is old (exiting)
        // console.log('leaving', key)
        children[key] = React.cloneElement(child, {
          in: false
        });
      } else if (hasNext && hasPrev && React.isValidElement(prevChild)) {
        // item hasn't changed transition states
        // copy over the last transition props;
        // console.log('unchanged', key)
        children[key] = React.cloneElement(child, {
          onExited: onExited.bind(null, child),
          in: prevChild.props.in,
          exit: getProp(child, 'exit', nextProps),
          enter: getProp(child, 'enter', nextProps)
        });
      }
    });
    return children;
  }

  var values = Object.values || function (obj) {
    return Object.keys(obj).map(function (k) {
      return obj[k];
    });
  };

  var defaultProps = {
    component: 'div',
    childFactory: function childFactory(child) {
      return child;
    }
  };
  /**
   * The `<TransitionGroup>` component manages a set of transition components
   * (`<Transition>` and `<CSSTransition>`) in a list. Like with the transition
   * components, `<TransitionGroup>` is a state machine for managing the mounting
   * and unmounting of components over time.
   *
   * Consider the example below. As items are removed or added to the TodoList the
   * `in` prop is toggled automatically by the `<TransitionGroup>`.
   *
   * Note that `<TransitionGroup>`  does not define any animation behavior!
   * Exactly _how_ a list item animates is up to the individual transition
   * component. This means you can mix and match animations across different list
   * items.
   */

  var TransitionGroup = /*#__PURE__*/function (_React$Component) {
    _inheritsLoose(TransitionGroup, _React$Component);

    function TransitionGroup(props, context) {
      var _this;

      _this = _React$Component.call(this, props, context) || this;

      var handleExited = _this.handleExited.bind(_assertThisInitialized(_this)); // Initial children should all be entering, dependent on appear


      _this.state = {
        contextValue: {
          isMounting: true
        },
        handleExited: handleExited,
        firstRender: true
      };
      return _this;
    }

    var _proto = TransitionGroup.prototype;

    _proto.componentDidMount = function componentDidMount() {
      this.mounted = true;
      this.setState({
        contextValue: {
          isMounting: false
        }
      });
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      this.mounted = false;
    };

    TransitionGroup.getDerivedStateFromProps = function getDerivedStateFromProps(nextProps, _ref) {
      var prevChildMapping = _ref.children,
          handleExited = _ref.handleExited,
          firstRender = _ref.firstRender;
      return {
        children: firstRender ? getInitialChildMapping(nextProps, handleExited) : getNextChildMapping(nextProps, prevChildMapping, handleExited),
        firstRender: false
      };
    } // node is `undefined` when user provided `nodeRef` prop
    ;

    _proto.handleExited = function handleExited(child, node) {
      var currentChildMapping = getChildMapping(this.props.children);
      if (child.key in currentChildMapping) return;

      if (child.props.onExited) {
        child.props.onExited(node);
      }

      if (this.mounted) {
        this.setState(function (state) {
          var children = _extends({}, state.children);

          delete children[child.key];
          return {
            children: children
          };
        });
      }
    };

    _proto.render = function render() {
      var _this$props = this.props,
          Component = _this$props.component,
          childFactory = _this$props.childFactory,
          props = _objectWithoutPropertiesLoose(_this$props, ["component", "childFactory"]);

      var contextValue = this.state.contextValue;
      var children = values(this.state.children).map(childFactory);
      delete props.appear;
      delete props.enter;
      delete props.exit;

      if (Component === null) {
        return /*#__PURE__*/React.createElement(TransitionGroupContext.Provider, {
          value: contextValue
        }, children);
      }

      return /*#__PURE__*/React.createElement(TransitionGroupContext.Provider, {
        value: contextValue
      }, /*#__PURE__*/React.createElement(Component, props, children));
    };

    return TransitionGroup;
  }(React.Component);

  TransitionGroup.propTypes = {
    /**
     * `<TransitionGroup>` renders a `<div>` by default. You can change this
     * behavior by providing a `component` prop.
     * If you use React v16+ and would like to avoid a wrapping `<div>` element
     * you can pass in `component={null}`. This is useful if the wrapping div
     * borks your css styles.
     */
    component: PropTypes.any,

    /**
     * A set of `<Transition>` components, that are toggled `in` and out as they
     * leave. the `<TransitionGroup>` will inject specific transition props, so
     * remember to spread them through if you are wrapping the `<Transition>` as
     * with our `<Fade>` example.
     *
     * While this component is meant for multiple `Transition` or `CSSTransition`
     * children, sometimes you may want to have a single transition child with
     * content that you want to be transitioned out and in when you change it
     * (e.g. routes, images etc.) In that case you can change the `key` prop of
     * the transition child as you change its content, this will cause
     * `TransitionGroup` to transition the child out and back in.
     */
    children: PropTypes.node,

    /**
     * A convenience prop that enables or disables appear animations
     * for all children. Note that specifying this will override any defaults set
     * on individual children Transitions.
     */
    appear: PropTypes.bool,

    /**
     * A convenience prop that enables or disables enter animations
     * for all children. Note that specifying this will override any defaults set
     * on individual children Transitions.
     */
    enter: PropTypes.bool,

    /**
     * A convenience prop that enables or disables exit animations
     * for all children. Note that specifying this will override any defaults set
     * on individual children Transitions.
     */
    exit: PropTypes.bool,

    /**
     * You may need to apply reactive updates to a child as it is exiting.
     * This is generally done by using `cloneElement` however in the case of an exiting
     * child the element has already been removed and not accessible to the consumer.
     *
     * If you do need to update a child as it leaves you can provide a `childFactory`
     * to wrap every child, even the ones that are leaving.
     *
     * @type Function(child: ReactElement) -> ReactElement
     */
    childFactory: PropTypes.func
  } ;
  TransitionGroup.defaultProps = defaultProps;
  var TransitionGroup$1 = TransitionGroup;

  var reflow = function reflow(node) {
    return node.scrollTop;
  };
  function getTransitionProps(props, options) {
    var _style$transitionDura, _style$transitionTimi;
    var timeout = props.timeout,
      easing = props.easing,
      _props$style = props.style,
      style = _props$style === void 0 ? {} : _props$style;
    return {
      duration: (_style$transitionDura = style.transitionDuration) != null ? _style$transitionDura : typeof timeout === 'number' ? timeout : timeout[options.mode] || 0,
      easing: (_style$transitionTimi = style.transitionTimingFunction) != null ? _style$transitionTimi : _typeof(easing) === 'object' ? easing[options.mode] : easing,
      delay: style.transitionDelay
    };
  }

  function getCollapseUtilityClass(slot) {
    return generateUtilityClass$1('MuiCollapse', slot);
  }
  var collapseClasses = generateUtilityClasses$1('MuiCollapse', ['root', 'horizontal', 'vertical', 'entered', 'hidden', 'wrapper', 'wrapperInner']);
  var collapseClasses$1 = collapseClasses;

  var useUtilityClasses$1N = function useUtilityClasses(ownerState) {
    var orientation = ownerState.orientation,
      classes = ownerState.classes;
    var slots = {
      root: ['root', "".concat(orientation)],
      entered: ['entered'],
      hidden: ['hidden'],
      wrapper: ['wrapper', "".concat(orientation)],
      wrapperInner: ['wrapperInner', "".concat(orientation)]
    };
    return composeClasses(slots, getCollapseUtilityClass, classes);
  };
  var CollapseRoot = styled$1('div', {
    name: 'MuiCollapse',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      return [styles.root, styles[ownerState.orientation], ownerState.state === 'entered' && styles.entered, ownerState.state === 'exited' && !ownerState["in"] && ownerState.collapsedSize === '0px' && styles.hidden];
    }
  })(function (_ref) {
    var theme = _ref.theme,
      ownerState = _ref.ownerState;
    return _extends({
      height: 0,
      overflow: 'hidden',
      transition: theme.transitions.create('height')
    }, ownerState.orientation === 'horizontal' && {
      height: 'auto',
      width: 0,
      transition: theme.transitions.create('width')
    }, ownerState.state === 'entered' && _extends({
      height: 'auto',
      overflow: 'visible'
    }, ownerState.orientation === 'horizontal' && {
      width: 'auto'
    }), ownerState.state === 'exited' && !ownerState["in"] && ownerState.collapsedSize === '0px' && {
      visibility: 'hidden'
    });
  });
  var CollapseWrapper = styled$1('div', {
    name: 'MuiCollapse',
    slot: 'Wrapper',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.wrapper;
    }
  })(function (_ref2) {
    var ownerState = _ref2.ownerState;
    return _extends({
      // Hack to get children with a negative margin to not falsify the height computation.
      display: 'flex',
      width: '100%'
    }, ownerState.orientation === 'horizontal' && {
      width: 'auto',
      height: '100%'
    });
  });
  var CollapseWrapperInner = styled$1('div', {
    name: 'MuiCollapse',
    slot: 'WrapperInner',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.wrapperInner;
    }
  })(function (_ref3) {
    var ownerState = _ref3.ownerState;
    return _extends({
      width: '100%'
    }, ownerState.orientation === 'horizontal' && {
      width: 'auto',
      height: '100%'
    });
  });

  /**
   * The Collapse transition is used by the
   * [Vertical Stepper](/material-ui/react-stepper/#vertical-stepper) StepContent component.
   * It uses [react-transition-group](https://github.com/reactjs/react-transition-group) internally.
   */
  var Collapse = /*#__PURE__*/React__namespace.forwardRef(function Collapse(inProps, ref) {
    var props = useThemeProps$b({
      props: inProps,
      name: 'MuiCollapse'
    });
    var addEndListener = props.addEndListener,
      _children = props.children,
      className = props.className,
      _props$collapsedSize = props.collapsedSize,
      collapsedSizeProp = _props$collapsedSize === void 0 ? '0px' : _props$collapsedSize,
      component = props.component,
      easing = props.easing,
      inProp = props["in"],
      onEnter = props.onEnter,
      onEntered = props.onEntered,
      onEntering = props.onEntering,
      onExit = props.onExit,
      onExited = props.onExited,
      onExiting = props.onExiting,
      _props$orientation = props.orientation,
      orientation = _props$orientation === void 0 ? 'vertical' : _props$orientation,
      style = props.style,
      _props$timeout = props.timeout,
      timeout = _props$timeout === void 0 ? duration.standard : _props$timeout,
      _props$TransitionComp = props.TransitionComponent,
      TransitionComponent = _props$TransitionComp === void 0 ? Transition$1 : _props$TransitionComp,
      other = _objectWithoutProperties(props, ["addEndListener", "children", "className", "collapsedSize", "component", "easing", "in", "onEnter", "onEntered", "onEntering", "onExit", "onExited", "onExiting", "orientation", "style", "timeout", "TransitionComponent"]);
    var ownerState = _extends({}, props, {
      orientation: orientation,
      collapsedSize: collapsedSizeProp
    });
    var classes = useUtilityClasses$1N(ownerState);
    var theme = useTheme();
    var timer = useTimeout();
    var wrapperRef = React__namespace.useRef(null);
    var autoTransitionDuration = React__namespace.useRef();
    var collapsedSize = typeof collapsedSizeProp === 'number' ? "".concat(collapsedSizeProp, "px") : collapsedSizeProp;
    var isHorizontal = orientation === 'horizontal';
    var size = isHorizontal ? 'width' : 'height';
    var nodeRef = React__namespace.useRef(null);
    var handleRef = useForkRef(ref, nodeRef);
    var normalizedTransitionCallback = function normalizedTransitionCallback(callback) {
      return function (maybeIsAppearing) {
        if (callback) {
          var node = nodeRef.current;

          // onEnterXxx and onExitXxx callbacks have a different arguments.length value.
          if (maybeIsAppearing === undefined) {
            callback(node);
          } else {
            callback(node, maybeIsAppearing);
          }
        }
      };
    };
    var getWrapperSize = function getWrapperSize() {
      return wrapperRef.current ? wrapperRef.current[isHorizontal ? 'clientWidth' : 'clientHeight'] : 0;
    };
    var handleEnter = normalizedTransitionCallback(function (node, isAppearing) {
      if (wrapperRef.current && isHorizontal) {
        // Set absolute position to get the size of collapsed content
        wrapperRef.current.style.position = 'absolute';
      }
      node.style[size] = collapsedSize;
      if (onEnter) {
        onEnter(node, isAppearing);
      }
    });
    var handleEntering = normalizedTransitionCallback(function (node, isAppearing) {
      var wrapperSize = getWrapperSize();
      if (wrapperRef.current && isHorizontal) {
        // After the size is read reset the position back to default
        wrapperRef.current.style.position = '';
      }
      var _getTransitionProps = getTransitionProps({
          style: style,
          timeout: timeout,
          easing: easing
        }, {
          mode: 'enter'
        }),
        transitionDuration = _getTransitionProps.duration,
        transitionTimingFunction = _getTransitionProps.easing;
      if (timeout === 'auto') {
        var duration2 = theme.transitions.getAutoHeightDuration(wrapperSize);
        node.style.transitionDuration = "".concat(duration2, "ms");
        autoTransitionDuration.current = duration2;
      } else {
        node.style.transitionDuration = typeof transitionDuration === 'string' ? transitionDuration : "".concat(transitionDuration, "ms");
      }
      node.style[size] = "".concat(wrapperSize, "px");
      node.style.transitionTimingFunction = transitionTimingFunction;
      if (onEntering) {
        onEntering(node, isAppearing);
      }
    });
    var handleEntered = normalizedTransitionCallback(function (node, isAppearing) {
      node.style[size] = 'auto';
      if (onEntered) {
        onEntered(node, isAppearing);
      }
    });
    var handleExit = normalizedTransitionCallback(function (node) {
      node.style[size] = "".concat(getWrapperSize(), "px");
      if (onExit) {
        onExit(node);
      }
    });
    var handleExited = normalizedTransitionCallback(onExited);
    var handleExiting = normalizedTransitionCallback(function (node) {
      var wrapperSize = getWrapperSize();
      var _getTransitionProps2 = getTransitionProps({
          style: style,
          timeout: timeout,
          easing: easing
        }, {
          mode: 'exit'
        }),
        transitionDuration = _getTransitionProps2.duration,
        transitionTimingFunction = _getTransitionProps2.easing;
      if (timeout === 'auto') {
        // TODO: rename getAutoHeightDuration to something more generic (width support)
        // Actually it just calculates animation duration based on size
        var duration2 = theme.transitions.getAutoHeightDuration(wrapperSize);
        node.style.transitionDuration = "".concat(duration2, "ms");
        autoTransitionDuration.current = duration2;
      } else {
        node.style.transitionDuration = typeof transitionDuration === 'string' ? transitionDuration : "".concat(transitionDuration, "ms");
      }
      node.style[size] = collapsedSize;
      node.style.transitionTimingFunction = transitionTimingFunction;
      if (onExiting) {
        onExiting(node);
      }
    });
    var handleAddEndListener = function handleAddEndListener(next) {
      if (timeout === 'auto') {
        timer.start(autoTransitionDuration.current || 0, next);
      }
      if (addEndListener) {
        // Old call signature before `react-transition-group` implemented `nodeRef`
        addEndListener(nodeRef.current, next);
      }
    };
    return /*#__PURE__*/jsxRuntime_1(TransitionComponent, _extends({
      "in": inProp,
      onEnter: handleEnter,
      onEntered: handleEntered,
      onEntering: handleEntering,
      onExit: handleExit,
      onExited: handleExited,
      onExiting: handleExiting,
      addEndListener: handleAddEndListener,
      nodeRef: nodeRef,
      timeout: timeout === 'auto' ? null : timeout
    }, other, {
      children: function children(state, childProps) {
        return /*#__PURE__*/jsxRuntime_1(CollapseRoot, _extends({
          as: component,
          className: clsx(classes.root, className, {
            'entered': classes.entered,
            'exited': !inProp && collapsedSize === '0px' && classes.hidden
          }[state]),
          style: _extends(_defineProperty({}, isHorizontal ? 'minWidth' : 'minHeight', collapsedSize), style),
          ref: handleRef
        }, childProps, {
          // `ownerState` is set after `childProps` to override any existing `ownerState` property in `childProps`
          // that might have been forwarded from the Transition component.
          ownerState: _extends({}, ownerState, {
            state: state
          }),
          children: /*#__PURE__*/jsxRuntime_1(CollapseWrapper, {
            ownerState: _extends({}, ownerState, {
              state: state
            }),
            className: classes.wrapper,
            ref: wrapperRef,
            children: /*#__PURE__*/jsxRuntime_1(CollapseWrapperInner, {
              ownerState: _extends({}, ownerState, {
                state: state
              }),
              className: classes.wrapperInner,
              children: _children
            })
          })
        }));
      }
    }));
  });
  Collapse.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * Add a custom transition end trigger. Called with the transitioning DOM
     * node and a done callback. Allows for more fine grained transition end
     * logic. Note: Timeouts are still used as a fallback if provided.
     */
    addEndListener: PropTypes.func,
    /**
     * The content node to be collapsed.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The width (horizontal) or height (vertical) of the container when collapsed.
     * @default '0px'
     */
    collapsedSize: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: elementTypeAcceptingRef$1,
    /**
     * The transition timing function.
     * You may specify a single easing or a object containing enter and exit values.
     */
    easing: PropTypes.oneOfType([PropTypes.shape({
      enter: PropTypes.string,
      exit: PropTypes.string
    }), PropTypes.string]),
    /**
     * If `true`, the component will transition in.
     */
    "in": PropTypes.bool,
    /**
     * @ignore
     */
    onEnter: PropTypes.func,
    /**
     * @ignore
     */
    onEntered: PropTypes.func,
    /**
     * @ignore
     */
    onEntering: PropTypes.func,
    /**
     * @ignore
     */
    onExit: PropTypes.func,
    /**
     * @ignore
     */
    onExited: PropTypes.func,
    /**
     * @ignore
     */
    onExiting: PropTypes.func,
    /**
     * The transition orientation.
     * @default 'vertical'
     */
    orientation: PropTypes.oneOf(['horizontal', 'vertical']),
    /**
     * @ignore
     */
    style: PropTypes.object,
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     *
     * Set to 'auto' to automatically calculate transition time based on height.
     * @default duration.standard
     */
    timeout: PropTypes.oneOfType([PropTypes.oneOf(['auto']), PropTypes.number, PropTypes.shape({
      appear: PropTypes.number,
      enter: PropTypes.number,
      exit: PropTypes.number
    })])
  } ;
  Collapse.muiSupportAuto = true;
  var Collapse$1 = Collapse;

  function getPaperUtilityClass(slot) {
    return generateUtilityClass$1('MuiPaper', slot);
  }
  var paperClasses = generateUtilityClasses$1('MuiPaper', ['root', 'rounded', 'outlined', 'elevation', 'elevation0', 'elevation1', 'elevation2', 'elevation3', 'elevation4', 'elevation5', 'elevation6', 'elevation7', 'elevation8', 'elevation9', 'elevation10', 'elevation11', 'elevation12', 'elevation13', 'elevation14', 'elevation15', 'elevation16', 'elevation17', 'elevation18', 'elevation19', 'elevation20', 'elevation21', 'elevation22', 'elevation23', 'elevation24']);
  var paperClasses$1 = paperClasses;

  var useUtilityClasses$1M = function useUtilityClasses(ownerState) {
    var square = ownerState.square,
      elevation = ownerState.elevation,
      variant = ownerState.variant,
      classes = ownerState.classes;
    var slots = {
      root: ['root', variant, !square && 'rounded', variant === 'elevation' && "elevation".concat(elevation)]
    };
    return composeClasses(slots, getPaperUtilityClass, classes);
  };
  var PaperRoot = styled$1('div', {
    name: 'MuiPaper',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      return [styles.root, styles[ownerState.variant], !ownerState.square && styles.rounded, ownerState.variant === 'elevation' && styles["elevation".concat(ownerState.elevation)]];
    }
  })(function (_ref) {
    var _theme$vars$overlays;
    var theme = _ref.theme,
      ownerState = _ref.ownerState;
    return _extends({
      backgroundColor: (theme.vars || theme).palette.background.paper,
      color: (theme.vars || theme).palette.text.primary,
      transition: theme.transitions.create('box-shadow')
    }, !ownerState.square && {
      borderRadius: theme.shape.borderRadius
    }, ownerState.variant === 'outlined' && {
      border: "1px solid ".concat((theme.vars || theme).palette.divider)
    }, ownerState.variant === 'elevation' && _extends({
      boxShadow: (theme.vars || theme).shadows[ownerState.elevation]
    }, !theme.vars && theme.palette.mode === 'dark' && {
      backgroundImage: "linear-gradient(".concat(alpha('#fff', getOverlayAlpha$1(ownerState.elevation)), ", ").concat(alpha('#fff', getOverlayAlpha$1(ownerState.elevation)), ")")
    }, theme.vars && {
      backgroundImage: (_theme$vars$overlays = theme.vars.overlays) == null ? void 0 : _theme$vars$overlays[ownerState.elevation]
    }));
  });
  var Paper = /*#__PURE__*/React__namespace.forwardRef(function Paper(inProps, ref) {
    var props = useThemeProps$b({
      props: inProps,
      name: 'MuiPaper'
    });
    var className = props.className,
      _props$component = props.component,
      component = _props$component === void 0 ? 'div' : _props$component,
      _props$elevation = props.elevation,
      elevation = _props$elevation === void 0 ? 1 : _props$elevation,
      _props$square = props.square,
      square = _props$square === void 0 ? false : _props$square,
      _props$variant = props.variant,
      variant = _props$variant === void 0 ? 'elevation' : _props$variant,
      other = _objectWithoutProperties(props, ["className", "component", "elevation", "square", "variant"]);
    var ownerState = _extends({}, props, {
      component: component,
      elevation: elevation,
      square: square,
      variant: variant
    });
    var classes = useUtilityClasses$1M(ownerState);
    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      var theme = useTheme();
      if (theme.shadows[elevation] === undefined) {
        console.error(["MUI: The elevation provided <Paper elevation={".concat(elevation, "}> is not available in the theme."), "Please make sure that `theme.shadows[".concat(elevation, "]` is defined.")].join('\n'));
      }
    }
    return /*#__PURE__*/jsxRuntime_1(PaperRoot, _extends({
      as: component,
      ownerState: ownerState,
      className: clsx(classes.root, className),
      ref: ref
    }, other));
  });
  Paper.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The content of the component.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,
    /**
     * Shadow depth, corresponds to `dp` in the spec.
     * It accepts values between 0 and 24 inclusive.
     * @default 1
     */
    elevation: chainPropTypes(integerPropType, function (props) {
      var elevation = props.elevation,
        variant = props.variant;
      if (elevation > 0 && variant === 'outlined') {
        return new Error("MUI: Combining `elevation={".concat(elevation, "}` with `variant=\"").concat(variant, "\"` has no effect. Either use `elevation={0}` or use a different `variant`."));
      }
      return null;
    }),
    /**
     * If `true`, rounded corners are disabled.
     * @default false
     */
    square: PropTypes.bool,
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
    /**
     * The variant to use.
     * @default 'elevation'
     */
    variant: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['elevation', 'outlined']), PropTypes.string])
  } ;
  var Paper$1 = Paper;

  /**
   * @ignore - internal component.
   * @type {React.Context<{} | {expanded: boolean, disabled: boolean, toggle: () => void}>}
   */
  var AccordionContext = /*#__PURE__*/React__namespace.createContext({});
  {
    AccordionContext.displayName = 'AccordionContext';
  }
  var AccordionContext$1 = AccordionContext;

  /**
   * Determines if a given element is a DOM element name (i.e. not a React component).
   */
  function isHostComponent(element) {
    return typeof element === 'string';
  }

  /**
   * Type of the ownerState based on the type of an element it applies to.
   * This resolves to the provided OwnerState for React components and `undefined` for host components.
   * Falls back to `OwnerState | undefined` when the exact type can't be determined in development time.
   */

  /**
   * Appends the ownerState object to the props, merging with the existing one if necessary.
   *
   * @param elementType Type of the element that owns the `existingProps`. If the element is a DOM node or undefined, `ownerState` is not applied.
   * @param otherProps Props of the element.
   * @param ownerState
   */
  function appendOwnerState(elementType, otherProps, ownerState) {
    if (elementType === undefined || isHostComponent(elementType)) {
      return otherProps;
    }
    return _extends({}, otherProps, {
      ownerState: _extends({}, otherProps.ownerState, ownerState)
    });
  }

  function areArraysEqual(array1, array2) {
    var itemComparer = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : function (a, b) {
      return a === b;
    };
    return array1.length === array2.length && array1.every(function (value, index) {
      return itemComparer(value, array2[index]);
    });
  }

  var defaultContextValue = {
    disableDefaultClasses: false
  };
  var ClassNameConfiguratorContext = /*#__PURE__*/React__namespace.createContext(defaultContextValue);
  {
    ClassNameConfiguratorContext.displayName = 'ClassNameConfiguratorContext';
  }
  /**
   * @ignore - internal hook.
   *
   * Wraps the `generateUtilityClass` function and controls how the classes are generated.
   * Currently it only affects whether the classes are applied or not.
   *
   * @returns Function to be called with the `generateUtilityClass` function specific to a component to generate the classes.
   */
  function useClassNamesOverride(generateUtilityClass) {
    var _React$useContext = React__namespace.useContext(ClassNameConfiguratorContext),
      disableDefaultClasses = _React$useContext.disableDefaultClasses;
    return function (slot) {
      if (disableDefaultClasses) {
        return '';
      }
      return generateUtilityClass(slot);
    };
  }

  /**
   * Extracts event handlers from a given object.
   * A prop is considered an event handler if it is a function and its name starts with `on`.
   *
   * @param object An object to extract event handlers from.
   * @param excludeKeys An array of keys to exclude from the returned object.
   */
  function extractEventHandlers(object) {
    var excludeKeys = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
    if (object === undefined) {
      return {};
    }
    var result = {};
    Object.keys(object).filter(function (prop) {
      return prop.match(/^on[A-Z]/) && typeof object[prop] === 'function' && !excludeKeys.includes(prop);
    }).forEach(function (prop) {
      result[prop] = object[prop];
    });
    return result;
  }

  /**
   * If `componentProps` is a function, calls it with the provided `ownerState`.
   * Otherwise, just returns `componentProps`.
   */
  function resolveComponentProps(componentProps, ownerState, slotState) {
    if (typeof componentProps === 'function') {
      return componentProps(ownerState, slotState);
    }
    return componentProps;
  }

  /**
   * Removes event handlers from the given object.
   * A field is considered an event handler if it is a function with a name beginning with `on`.
   *
   * @param object Object to remove event handlers from.
   * @returns Object with event handlers removed.
   */
  function omitEventHandlers(object) {
    if (object === undefined) {
      return {};
    }
    var result = {};
    Object.keys(object).filter(function (prop) {
      return !(prop.match(/^on[A-Z]/) && typeof object[prop] === 'function');
    }).forEach(function (prop) {
      result[prop] = object[prop];
    });
    return result;
  }

  /**
   * Merges the slot component internal props (usually coming from a hook)
   * with the externally provided ones.
   *
   * The merge order is (the latter overrides the former):
   * 1. The internal props (specified as a getter function to work with get*Props hook result)
   * 2. Additional props (specified internally on a Base UI component)
   * 3. External props specified on the owner component. These should only be used on a root slot.
   * 4. External props specified in the `slotProps.*` prop.
   * 5. The `className` prop - combined from all the above.
   * @param parameters
   * @returns
   */
  function mergeSlotProps(parameters) {
    var getSlotProps = parameters.getSlotProps,
      additionalProps = parameters.additionalProps,
      externalSlotProps = parameters.externalSlotProps,
      externalForwardedProps = parameters.externalForwardedProps,
      className = parameters.className;
    if (!getSlotProps) {
      // The simpler case - getSlotProps is not defined, so no internal event handlers are defined,
      // so we can simply merge all the props without having to worry about extracting event handlers.
      var _joinedClasses = clsx(additionalProps == null ? void 0 : additionalProps.className, className, externalForwardedProps == null ? void 0 : externalForwardedProps.className, externalSlotProps == null ? void 0 : externalSlotProps.className);
      var _mergedStyle = _extends({}, additionalProps == null ? void 0 : additionalProps.style, externalForwardedProps == null ? void 0 : externalForwardedProps.style, externalSlotProps == null ? void 0 : externalSlotProps.style);
      var _props = _extends({}, additionalProps, externalForwardedProps, externalSlotProps);
      if (_joinedClasses.length > 0) {
        _props.className = _joinedClasses;
      }
      if (Object.keys(_mergedStyle).length > 0) {
        _props.style = _mergedStyle;
      }
      return {
        props: _props,
        internalRef: undefined
      };
    }

    // In this case, getSlotProps is responsible for calling the external event handlers.
    // We don't need to include them in the merged props because of this.

    var eventHandlers = extractEventHandlers(_extends({}, externalForwardedProps, externalSlotProps));
    var componentsPropsWithoutEventHandlers = omitEventHandlers(externalSlotProps);
    var otherPropsWithoutEventHandlers = omitEventHandlers(externalForwardedProps);
    var internalSlotProps = getSlotProps(eventHandlers);

    // The order of classes is important here.
    // Emotion (that we use in libraries consuming Base UI) depends on this order
    // to properly override style. It requires the most important classes to be last
    // (see https://github.com/mui/material-ui/pull/33205) for the related discussion.
    var joinedClasses = clsx(internalSlotProps == null ? void 0 : internalSlotProps.className, additionalProps == null ? void 0 : additionalProps.className, className, externalForwardedProps == null ? void 0 : externalForwardedProps.className, externalSlotProps == null ? void 0 : externalSlotProps.className);
    var mergedStyle = _extends({}, internalSlotProps == null ? void 0 : internalSlotProps.style, additionalProps == null ? void 0 : additionalProps.style, externalForwardedProps == null ? void 0 : externalForwardedProps.style, externalSlotProps == null ? void 0 : externalSlotProps.style);
    var props = _extends({}, internalSlotProps, additionalProps, otherPropsWithoutEventHandlers, componentsPropsWithoutEventHandlers);
    if (joinedClasses.length > 0) {
      props.className = joinedClasses;
    }
    if (Object.keys(mergedStyle).length > 0) {
      props.style = mergedStyle;
    }
    return {
      props: props,
      internalRef: internalSlotProps.ref
    };
  }

  /**
   * @ignore - do not document.
   * Builds the props to be passed into the slot of an unstyled component.
   * It merges the internal props of the component with the ones supplied by the user, allowing to customize the behavior.
   * If the slot component is not a host component, it also merges in the `ownerState`.
   *
   * @param parameters.getSlotProps - A function that returns the props to be passed to the slot component.
   */
  function useSlotProps(parameters) {
    var _parameters$additiona;
    var elementType = parameters.elementType,
      externalSlotProps = parameters.externalSlotProps,
      ownerState = parameters.ownerState,
      _parameters$skipResol = parameters.skipResolvingSlotProps,
      skipResolvingSlotProps = _parameters$skipResol === void 0 ? false : _parameters$skipResol,
      rest = _objectWithoutProperties(parameters, ["elementType", "externalSlotProps", "ownerState", "skipResolvingSlotProps"]);
    var resolvedComponentsProps = skipResolvingSlotProps ? {} : resolveComponentProps(externalSlotProps, ownerState);
    var _mergeSlotProps = mergeSlotProps(_extends({}, rest, {
        externalSlotProps: resolvedComponentsProps
      })),
      mergedProps = _mergeSlotProps.props,
      internalRef = _mergeSlotProps.internalRef;
    var ref = useForkRef(internalRef, resolvedComponentsProps == null ? void 0 : resolvedComponentsProps.ref, (_parameters$additiona = parameters.additionalProps) == null ? void 0 : _parameters$additiona.ref);
    var props = appendOwnerState(elementType, _extends({}, mergedProps, {
      ref: ref
    }), ownerState);
    return props;
  }

  /**
   * An internal function to create a Material UI slot.
   *
   * This is an advanced version of Base UI `useSlotProps` because Material UI allows leaf component to be customized via `component` prop
   * while Base UI does not need to support leaf component customization.
   *
   * @param {string} name: name of the slot
   * @param {object} parameters
   * @returns {[Slot, slotProps]} The slot's React component and the slot's props
   *
   * Note: the returned slot's props
   * - will never contain `component` prop.
   * - might contain `as` prop.
   */
  function useSlot(
  /**
   * The slot's name. All Material UI components should have `root` slot.
   *
   * If the name is `root`, the logic behaves differently from other slots,
   * e.g. the `externalForwardedProps` are spread to `root` slot but not other slots.
   */
  name, parameters) {
    var className = parameters.className,
      initialElementType = parameters.elementType,
      ownerState = parameters.ownerState,
      externalForwardedProps = parameters.externalForwardedProps,
      getSlotOwnerState = parameters.getSlotOwnerState,
      internalForwardedProps = parameters.internalForwardedProps,
      useSlotPropsParams = _objectWithoutProperties(parameters, ["className", "elementType", "ownerState", "externalForwardedProps", "getSlotOwnerState", "internalForwardedProps"]);
    var rootComponent = externalForwardedProps.component,
      _externalForwardedPro = externalForwardedProps.slots,
      slots = _externalForwardedPro === void 0 ? _defineProperty({}, name, undefined) : _externalForwardedPro,
      _externalForwardedPro2 = externalForwardedProps.slotProps,
      slotProps = _externalForwardedPro2 === void 0 ? _defineProperty({}, name, undefined) : _externalForwardedPro2,
      other = _objectWithoutProperties(externalForwardedProps, ["component", "slots", "slotProps"]);
    var elementType = slots[name] || initialElementType;

    // `slotProps[name]` can be a callback that receives the component's ownerState.
    // `resolvedComponentsProps` is always a plain object.
    var resolvedComponentsProps = resolveComponentProps(slotProps[name], ownerState);
    var _mergeSlotProps = mergeSlotProps(_extends({
        className: className
      }, useSlotPropsParams, {
        externalForwardedProps: name === 'root' ? other : undefined,
        externalSlotProps: resolvedComponentsProps
      })),
      _mergeSlotProps$props = _mergeSlotProps.props,
      slotComponent = _mergeSlotProps$props.component,
      mergedProps = _objectWithoutProperties(_mergeSlotProps$props, ["component"]),
      internalRef = _mergeSlotProps.internalRef;
    var ref = useForkRef(internalRef, resolvedComponentsProps == null ? void 0 : resolvedComponentsProps.ref, parameters.ref);
    var slotOwnerState = getSlotOwnerState ? getSlotOwnerState(mergedProps) : {};
    var finalOwnerState = _extends({}, ownerState, slotOwnerState);
    var LeafComponent = name === 'root' ? slotComponent || rootComponent : slotComponent;
    var props = appendOwnerState(elementType, _extends({}, name === 'root' && !rootComponent && !slots[name] && internalForwardedProps, name !== 'root' && !slots[name] && internalForwardedProps, mergedProps, LeafComponent && {
      as: LeafComponent
    }, {
      ref: ref
    }), finalOwnerState);
    Object.keys(slotOwnerState).forEach(function (propName) {
      delete props[propName];
    });
    return [elementType, props];
  }

  function getAccordionUtilityClass(slot) {
    return generateUtilityClass$1('MuiAccordion', slot);
  }
  var accordionClasses = generateUtilityClasses$1('MuiAccordion', ['root', 'rounded', 'expanded', 'disabled', 'gutters', 'region']);
  var accordionClasses$1 = accordionClasses;

  var useThemeProps$a = createUseThemeProps();
  var useUtilityClasses$1L = function useUtilityClasses(ownerState) {
    var classes = ownerState.classes,
      square = ownerState.square,
      expanded = ownerState.expanded,
      disabled = ownerState.disabled,
      disableGutters = ownerState.disableGutters;
    var slots = {
      root: ['root', !square && 'rounded', expanded && 'expanded', disabled && 'disabled', !disableGutters && 'gutters'],
      region: ['region']
    };
    return composeClasses(slots, getAccordionUtilityClass, classes);
  };
  var AccordionRoot = styled$1(Paper$1, {
    name: 'MuiAccordion',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      return [_defineProperty({}, "& .".concat(accordionClasses$1.region), styles.region), styles.root, !ownerState.square && styles.rounded, !ownerState.disableGutters && styles.gutters];
    }
  })(function (_ref2) {
    var theme = _ref2.theme;
    var transition = {
      duration: theme.transitions.duration.shortest
    };
    return _defineProperty(_defineProperty({
      position: 'relative',
      transition: theme.transitions.create(['margin'], transition),
      overflowAnchor: 'none',
      // Keep the same scrolling position
      '&::before': {
        position: 'absolute',
        left: 0,
        top: -1,
        right: 0,
        height: 1,
        content: '""',
        opacity: 1,
        backgroundColor: (theme.vars || theme).palette.divider,
        transition: theme.transitions.create(['opacity', 'background-color'], transition)
      },
      '&:first-of-type': {
        '&::before': {
          display: 'none'
        }
      }
    }, "&.".concat(accordionClasses$1.expanded), {
      '&::before': {
        opacity: 0
      },
      '&:first-of-type': {
        marginTop: 0
      },
      '&:last-of-type': {
        marginBottom: 0
      },
      '& + &': {
        '&::before': {
          display: 'none'
        }
      }
    }), "&.".concat(accordionClasses$1.disabled), {
      backgroundColor: (theme.vars || theme).palette.action.disabledBackground
    });
  }, function (_ref4) {
    var theme = _ref4.theme;
    return {
      variants: [{
        props: function props(_props) {
          return !_props.square;
        },
        style: {
          borderRadius: 0,
          '&:first-of-type': {
            borderTopLeftRadius: (theme.vars || theme).shape.borderRadius,
            borderTopRightRadius: (theme.vars || theme).shape.borderRadius
          },
          '&:last-of-type': {
            borderBottomLeftRadius: (theme.vars || theme).shape.borderRadius,
            borderBottomRightRadius: (theme.vars || theme).shape.borderRadius,
            // Fix a rendering issue on Edge
            '@supports (-ms-ime-align: auto)': {
              borderBottomLeftRadius: 0,
              borderBottomRightRadius: 0
            }
          }
        }
      }, {
        props: function props(_props2) {
          return !_props2.disableGutters;
        },
        style: _defineProperty({}, "&.".concat(accordionClasses$1.expanded), {
          margin: '16px 0'
        })
      }]
    };
  });
  var Accordion = /*#__PURE__*/React__namespace.forwardRef(function Accordion(inProps, ref) {
    var props = useThemeProps$a({
      props: inProps,
      name: 'MuiAccordion'
    });
    var childrenProp = props.children,
      className = props.className,
      _props$defaultExpande = props.defaultExpanded,
      defaultExpanded = _props$defaultExpande === void 0 ? false : _props$defaultExpande,
      _props$disabled = props.disabled,
      disabled = _props$disabled === void 0 ? false : _props$disabled,
      _props$disableGutters = props.disableGutters,
      disableGutters = _props$disableGutters === void 0 ? false : _props$disableGutters,
      expandedProp = props.expanded,
      onChange = props.onChange,
      _props$square = props.square,
      square = _props$square === void 0 ? false : _props$square,
      _props$slots = props.slots,
      slots = _props$slots === void 0 ? {} : _props$slots,
      _props$slotProps = props.slotProps,
      slotProps = _props$slotProps === void 0 ? {} : _props$slotProps,
      TransitionComponentProp = props.TransitionComponent,
      TransitionPropsProp = props.TransitionProps,
      other = _objectWithoutProperties(props, ["children", "className", "defaultExpanded", "disabled", "disableGutters", "expanded", "onChange", "square", "slots", "slotProps", "TransitionComponent", "TransitionProps"]);
    var _useControlled = useControlled({
        controlled: expandedProp,
        "default": defaultExpanded,
        name: 'Accordion',
        state: 'expanded'
      }),
      _useControlled2 = _slicedToArray(_useControlled, 2),
      expanded = _useControlled2[0],
      setExpandedState = _useControlled2[1];
    var handleChange = React__namespace.useCallback(function (event) {
      setExpandedState(!expanded);
      if (onChange) {
        onChange(event, !expanded);
      }
    }, [expanded, onChange, setExpandedState]);
    var _React$Children$toArr = React__namespace.Children.toArray(childrenProp),
      _React$Children$toArr2 = _toArray(_React$Children$toArr),
      summary = _React$Children$toArr2[0],
      children = _React$Children$toArr2.slice(1);
    var contextValue = React__namespace.useMemo(function () {
      return {
        expanded: expanded,
        disabled: disabled,
        disableGutters: disableGutters,
        toggle: handleChange
      };
    }, [expanded, disabled, disableGutters, handleChange]);
    var ownerState = _extends({}, props, {
      square: square,
      disabled: disabled,
      disableGutters: disableGutters,
      expanded: expanded
    });
    var classes = useUtilityClasses$1L(ownerState);
    var backwardCompatibleSlots = _extends({
      transition: TransitionComponentProp
    }, slots);
    var backwardCompatibleSlotProps = _extends({
      transition: TransitionPropsProp
    }, slotProps);
    var _useSlot = useSlot('transition', {
        elementType: Collapse$1,
        externalForwardedProps: {
          slots: backwardCompatibleSlots,
          slotProps: backwardCompatibleSlotProps
        },
        ownerState: ownerState
      }),
      _useSlot2 = _slicedToArray(_useSlot, 2),
      TransitionSlot = _useSlot2[0],
      transitionProps = _useSlot2[1];
    return /*#__PURE__*/jsxRuntime_2(AccordionRoot, _extends({
      className: clsx(classes.root, className),
      ref: ref,
      ownerState: ownerState,
      square: square
    }, other, {
      children: [/*#__PURE__*/jsxRuntime_1(AccordionContext$1.Provider, {
        value: contextValue,
        children: summary
      }), /*#__PURE__*/jsxRuntime_1(TransitionSlot, _extends({
        "in": expanded,
        timeout: "auto"
      }, transitionProps, {
        children: /*#__PURE__*/jsxRuntime_1("div", {
          "aria-labelledby": summary.props.id,
          id: summary.props['aria-controls'],
          role: "region",
          className: classes.region,
          children: children
        })
      }))]
    }));
  });
  Accordion.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The content of the component.
     */
    children: chainPropTypes(PropTypes.node.isRequired, function (props) {
      var summary = React__namespace.Children.toArray(props.children)[0];
      if (reactIs_2(summary)) {
        return new Error("MUI: The Accordion doesn't accept a Fragment as a child. " + 'Consider providing an array instead.');
      }
      if (! /*#__PURE__*/React__namespace.isValidElement(summary)) {
        return new Error('MUI: Expected the first child of Accordion to be a valid element.');
      }
      return null;
    }),
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * If `true`, expands the accordion by default.
     * @default false
     */
    defaultExpanded: PropTypes.bool,
    /**
     * If `true`, the component is disabled.
     * @default false
     */
    disabled: PropTypes.bool,
    /**
     * If `true`, it removes the margin between two expanded accordion items and the increase of height.
     * @default false
     */
    disableGutters: PropTypes.bool,
    /**
     * If `true`, expands the accordion, otherwise collapse it.
     * Setting this prop enables control over the accordion.
     */
    expanded: PropTypes.bool,
    /**
     * Callback fired when the expand/collapse state is changed.
     *
     * @param {React.SyntheticEvent} event The event source of the callback. **Warning**: This is a generic event not a change event.
     * @param {boolean} expanded The `expanded` state of the accordion.
     */
    onChange: PropTypes.func,
    /**
     * The props used for each slot inside.
     * @default {}
     */
    slotProps: PropTypes.shape({
      transition: PropTypes.oneOfType([PropTypes.func, PropTypes.object])
    }),
    /**
     * The components used for each slot inside.
     * @default {}
     */
    slots: PropTypes.shape({
      transition: PropTypes.elementType
    }),
    /**
     * If `true`, rounded corners are disabled.
     * @default false
     */
    square: PropTypes.bool,
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
    /**
     * The component used for the transition.
     * [Follow this guide](/material-ui/transitions/#transitioncomponent-prop) to learn more about the requirements for this component.
     * @deprecated Use `slots.transition` instead. This prop will be removed in v7. [How to migrate](/material-ui/migration/migrating-from-deprecated-apis/).
     */
    TransitionComponent: PropTypes.elementType,
    /**
     * Props applied to the transition element.
     * By default, the element is based on this [`Transition`](https://reactcommunity.org/react-transition-group/transition/) component.
     * @deprecated Use `slotProps.transition` instead. This prop will be removed in v7. [How to migrate](/material-ui/migration/migrating-from-deprecated-apis/).
     */
    TransitionProps: PropTypes.object
  } ;
  var Accordion$1 = Accordion;

  function getAccordionActionsUtilityClass(slot) {
    return generateUtilityClass$1('MuiAccordionActions', slot);
  }
  var accordionActionsClasses = generateUtilityClasses$1('MuiAccordionActions', ['root', 'spacing']);
  var accordionActionsClasses$1 = accordionActionsClasses;

  var useThemeProps$9 = createUseThemeProps();
  var useUtilityClasses$1K = function useUtilityClasses(ownerState) {
    var classes = ownerState.classes,
      disableSpacing = ownerState.disableSpacing;
    var slots = {
      root: ['root', !disableSpacing && 'spacing']
    };
    return composeClasses(slots, getAccordionActionsUtilityClass, classes);
  };
  var AccordionActionsRoot = styled$1('div', {
    name: 'MuiAccordionActions',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      return [styles.root, !ownerState.disableSpacing && styles.spacing];
    }
  })({
    display: 'flex',
    alignItems: 'center',
    padding: 8,
    justifyContent: 'flex-end',
    variants: [{
      props: function props(_props) {
        return !_props.disableSpacing;
      },
      style: {
        '& > :not(style) ~ :not(style)': {
          marginLeft: 8
        }
      }
    }]
  });
  var AccordionActions = /*#__PURE__*/React__namespace.forwardRef(function AccordionActions(inProps, ref) {
    var props = useThemeProps$9({
      props: inProps,
      name: 'MuiAccordionActions'
    });
    var className = props.className,
      _props$disableSpacing = props.disableSpacing,
      disableSpacing = _props$disableSpacing === void 0 ? false : _props$disableSpacing,
      other = _objectWithoutProperties(props, ["className", "disableSpacing"]);
    var ownerState = _extends({}, props, {
      disableSpacing: disableSpacing
    });
    var classes = useUtilityClasses$1K(ownerState);
    return /*#__PURE__*/jsxRuntime_1(AccordionActionsRoot, _extends({
      className: clsx(classes.root, className),
      ref: ref,
      ownerState: ownerState
    }, other));
  });
  AccordionActions.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The content of the component.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * If `true`, the actions do not have additional margin.
     * @default false
     */
    disableSpacing: PropTypes.bool,
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var AccordionActions$1 = AccordionActions;

  function getAccordionDetailsUtilityClass(slot) {
    return generateUtilityClass$1('MuiAccordionDetails', slot);
  }
  var accordionDetailsClasses = generateUtilityClasses$1('MuiAccordionDetails', ['root']);
  var accordionDetailsClasses$1 = accordionDetailsClasses;

  var useThemeProps$8 = createUseThemeProps();
  var useUtilityClasses$1J = function useUtilityClasses(ownerState) {
    var classes = ownerState.classes;
    var slots = {
      root: ['root']
    };
    return composeClasses(slots, getAccordionDetailsUtilityClass, classes);
  };
  var AccordionDetailsRoot = styled$1('div', {
    name: 'MuiAccordionDetails',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.root;
    }
  })(function (_ref) {
    var theme = _ref.theme;
    return {
      padding: theme.spacing(1, 2, 2)
    };
  });
  var AccordionDetails = /*#__PURE__*/React__namespace.forwardRef(function AccordionDetails(inProps, ref) {
    var props = useThemeProps$8({
      props: inProps,
      name: 'MuiAccordionDetails'
    });
    var className = props.className,
      other = _objectWithoutProperties(props, ["className"]);
    var ownerState = props;
    var classes = useUtilityClasses$1J(ownerState);
    return /*#__PURE__*/jsxRuntime_1(AccordionDetailsRoot, _extends({
      className: clsx(classes.root, className),
      ref: ref,
      ownerState: ownerState
    }, other));
  });
  AccordionDetails.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The content of the component.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var AccordionDetails$1 = AccordionDetails;

  function _taggedTemplateLiteral(strings, raw) {
    if (!raw) {
      raw = strings.slice(0);
    }
    return Object.freeze(Object.defineProperties(strings, {
      raw: {
        value: Object.freeze(raw)
      }
    }));
  }

  function Ripple(props) {
    var className = props.className,
      classes = props.classes,
      _props$pulsate = props.pulsate,
      pulsate = _props$pulsate === void 0 ? false : _props$pulsate,
      rippleX = props.rippleX,
      rippleY = props.rippleY,
      rippleSize = props.rippleSize,
      inProp = props["in"],
      onExited = props.onExited,
      timeout = props.timeout;
    var _React$useState = React__namespace.useState(false),
      leaving = _React$useState[0],
      setLeaving = _React$useState[1];
    var rippleClassName = clsx(className, classes.ripple, classes.rippleVisible, pulsate && classes.ripplePulsate);
    var rippleStyles = {
      width: rippleSize,
      height: rippleSize,
      top: -(rippleSize / 2) + rippleY,
      left: -(rippleSize / 2) + rippleX
    };
    var childClassName = clsx(classes.child, leaving && classes.childLeaving, pulsate && classes.childPulsate);
    if (!inProp && !leaving) {
      setLeaving(true);
    }
    React__namespace.useEffect(function () {
      if (!inProp && onExited != null) {
        // react-transition-group#onExited
        var timeoutId = setTimeout(onExited, timeout);
        return function () {
          clearTimeout(timeoutId);
        };
      }
      return undefined;
    }, [onExited, inProp, timeout]);
    return /*#__PURE__*/jsxRuntime_1("span", {
      className: rippleClassName,
      style: rippleStyles,
      children: /*#__PURE__*/jsxRuntime_1("span", {
        className: childClassName
      })
    });
  }
  Ripple.propTypes = {
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object.isRequired,
    className: PropTypes.string,
    /**
     * @ignore - injected from TransitionGroup
     */
    "in": PropTypes.bool,
    /**
     * @ignore - injected from TransitionGroup
     */
    onExited: PropTypes.func,
    /**
     * If `true`, the ripple pulsates, typically indicating the keyboard focus state of an element.
     */
    pulsate: PropTypes.bool,
    /**
     * Diameter of the ripple.
     */
    rippleSize: PropTypes.number,
    /**
     * Horizontal position of the ripple center.
     */
    rippleX: PropTypes.number,
    /**
     * Vertical position of the ripple center.
     */
    rippleY: PropTypes.number,
    /**
     * exit delay
     */
    timeout: PropTypes.number.isRequired
  } ;

  function getTouchRippleUtilityClass(slot) {
    return generateUtilityClass$1('MuiTouchRipple', slot);
  }
  var touchRippleClasses = generateUtilityClasses$1('MuiTouchRipple', ['root', 'ripple', 'rippleVisible', 'ripplePulsate', 'child', 'childLeaving', 'childPulsate']);
  var touchRippleClasses$1 = touchRippleClasses;

  var _templateObject$3, _templateObject2$3, _templateObject3$3, _templateObject4$3;
  var DURATION = 550;
  var DELAY_RIPPLE = 80;
  var enterKeyframe = keyframes(_templateObject$3 || (_templateObject$3 = _taggedTemplateLiteral(["\n  0% {\n    transform: scale(0);\n    opacity: 0.1;\n  }\n\n  100% {\n    transform: scale(1);\n    opacity: 0.3;\n  }\n"])));
  var exitKeyframe = keyframes(_templateObject2$3 || (_templateObject2$3 = _taggedTemplateLiteral(["\n  0% {\n    opacity: 1;\n  }\n\n  100% {\n    opacity: 0;\n  }\n"])));
  var pulsateKeyframe = keyframes(_templateObject3$3 || (_templateObject3$3 = _taggedTemplateLiteral(["\n  0% {\n    transform: scale(1);\n  }\n\n  50% {\n    transform: scale(0.92);\n  }\n\n  100% {\n    transform: scale(1);\n  }\n"])));
  var TouchRippleRoot = styled$1('span', {
    name: 'MuiTouchRipple',
    slot: 'Root'
  })({
    overflow: 'hidden',
    pointerEvents: 'none',
    position: 'absolute',
    zIndex: 0,
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    borderRadius: 'inherit'
  });

  // This `styled()` function invokes keyframes. `styled-components` only supports keyframes
  // in string templates. Do not convert these styles in JS object as it will break.
  var TouchRippleRipple = styled$1(Ripple, {
    name: 'MuiTouchRipple',
    slot: 'Ripple'
  })(_templateObject4$3 || (_templateObject4$3 = _taggedTemplateLiteral(["\n  opacity: 0;\n  position: absolute;\n\n  &.", " {\n    opacity: 0.3;\n    transform: scale(1);\n    animation-name: ", ";\n    animation-duration: ", "ms;\n    animation-timing-function: ", ";\n  }\n\n  &.", " {\n    animation-duration: ", "ms;\n  }\n\n  & .", " {\n    opacity: 1;\n    display: block;\n    width: 100%;\n    height: 100%;\n    border-radius: 50%;\n    background-color: currentColor;\n  }\n\n  & .", " {\n    opacity: 0;\n    animation-name: ", ";\n    animation-duration: ", "ms;\n    animation-timing-function: ", ";\n  }\n\n  & .", " {\n    position: absolute;\n    /* @noflip */\n    left: 0px;\n    top: 0;\n    animation-name: ", ";\n    animation-duration: 2500ms;\n    animation-timing-function: ", ";\n    animation-iteration-count: infinite;\n    animation-delay: 200ms;\n  }\n"])), touchRippleClasses$1.rippleVisible, enterKeyframe, DURATION, function (_ref) {
    var theme = _ref.theme;
    return theme.transitions.easing.easeInOut;
  }, touchRippleClasses$1.ripplePulsate, function (_ref2) {
    var theme = _ref2.theme;
    return theme.transitions.duration.shorter;
  }, touchRippleClasses$1.child, touchRippleClasses$1.childLeaving, exitKeyframe, DURATION, function (_ref3) {
    var theme = _ref3.theme;
    return theme.transitions.easing.easeInOut;
  }, touchRippleClasses$1.childPulsate, pulsateKeyframe, function (_ref4) {
    var theme = _ref4.theme;
    return theme.transitions.easing.easeInOut;
  });

  /**
   * @ignore - internal component.
   *
   * TODO v5: Make private
   */
  var TouchRipple = /*#__PURE__*/React__namespace.forwardRef(function TouchRipple(inProps, ref) {
    var props = useThemeProps$b({
      props: inProps,
      name: 'MuiTouchRipple'
    });
    var _props$center = props.center,
      centerProp = _props$center === void 0 ? false : _props$center,
      _props$classes = props.classes,
      classes = _props$classes === void 0 ? {} : _props$classes,
      className = props.className,
      other = _objectWithoutProperties(props, ["center", "classes", "className"]);
    var _React$useState = React__namespace.useState([]),
      ripples = _React$useState[0],
      setRipples = _React$useState[1];
    var nextKey = React__namespace.useRef(0);
    var rippleCallback = React__namespace.useRef(null);
    React__namespace.useEffect(function () {
      if (rippleCallback.current) {
        rippleCallback.current();
        rippleCallback.current = null;
      }
    }, [ripples]);

    // Used to filter out mouse emulated events on mobile.
    var ignoringMouseDown = React__namespace.useRef(false);
    // We use a timer in order to only show the ripples for touch "click" like events.
    // We don't want to display the ripple for touch scroll events.
    var startTimer = useTimeout();

    // This is the hook called once the previous timeout is ready.
    var startTimerCommit = React__namespace.useRef(null);
    var container = React__namespace.useRef(null);
    var startCommit = React__namespace.useCallback(function (params) {
      var pulsate = params.pulsate,
        rippleX = params.rippleX,
        rippleY = params.rippleY,
        rippleSize = params.rippleSize,
        cb = params.cb;
      setRipples(function (oldRipples) {
        return [].concat(_toConsumableArray(oldRipples), [/*#__PURE__*/jsxRuntime_1(TouchRippleRipple, {
          classes: {
            ripple: clsx(classes.ripple, touchRippleClasses$1.ripple),
            rippleVisible: clsx(classes.rippleVisible, touchRippleClasses$1.rippleVisible),
            ripplePulsate: clsx(classes.ripplePulsate, touchRippleClasses$1.ripplePulsate),
            child: clsx(classes.child, touchRippleClasses$1.child),
            childLeaving: clsx(classes.childLeaving, touchRippleClasses$1.childLeaving),
            childPulsate: clsx(classes.childPulsate, touchRippleClasses$1.childPulsate)
          },
          timeout: DURATION,
          pulsate: pulsate,
          rippleX: rippleX,
          rippleY: rippleY,
          rippleSize: rippleSize
        }, nextKey.current)]);
      });
      nextKey.current += 1;
      rippleCallback.current = cb;
    }, [classes]);
    var start = React__namespace.useCallback(function () {
      var event = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var cb = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : function () {};
      var _options$pulsate = options.pulsate,
        pulsate = _options$pulsate === void 0 ? false : _options$pulsate,
        _options$center = options.center,
        center = _options$center === void 0 ? centerProp || options.pulsate : _options$center,
        _options$fakeElement = options.fakeElement,
        fakeElement = _options$fakeElement === void 0 ? false : _options$fakeElement;
      if ((event == null ? void 0 : event.type) === 'mousedown' && ignoringMouseDown.current) {
        ignoringMouseDown.current = false;
        return;
      }
      if ((event == null ? void 0 : event.type) === 'touchstart') {
        ignoringMouseDown.current = true;
      }
      var element = fakeElement ? null : container.current;
      var rect = element ? element.getBoundingClientRect() : {
        width: 0,
        height: 0,
        left: 0,
        top: 0
      };

      // Get the size of the ripple
      var rippleX;
      var rippleY;
      var rippleSize;
      if (center || event === undefined || event.clientX === 0 && event.clientY === 0 || !event.clientX && !event.touches) {
        rippleX = Math.round(rect.width / 2);
        rippleY = Math.round(rect.height / 2);
      } else {
        var _ref5 = event.touches && event.touches.length > 0 ? event.touches[0] : event,
          clientX = _ref5.clientX,
          clientY = _ref5.clientY;
        rippleX = Math.round(clientX - rect.left);
        rippleY = Math.round(clientY - rect.top);
      }
      if (center) {
        rippleSize = Math.sqrt((2 * Math.pow(rect.width, 2) + Math.pow(rect.height, 2)) / 3);

        // For some reason the animation is broken on Mobile Chrome if the size is even.
        if (rippleSize % 2 === 0) {
          rippleSize += 1;
        }
      } else {
        var sizeX = Math.max(Math.abs((element ? element.clientWidth : 0) - rippleX), rippleX) * 2 + 2;
        var sizeY = Math.max(Math.abs((element ? element.clientHeight : 0) - rippleY), rippleY) * 2 + 2;
        rippleSize = Math.sqrt(Math.pow(sizeX, 2) + Math.pow(sizeY, 2));
      }

      // Touche devices
      if (event != null && event.touches) {
        // check that this isn't another touchstart due to multitouch
        // otherwise we will only clear a single timer when unmounting while two
        // are running
        if (startTimerCommit.current === null) {
          // Prepare the ripple effect.
          startTimerCommit.current = function () {
            startCommit({
              pulsate: pulsate,
              rippleX: rippleX,
              rippleY: rippleY,
              rippleSize: rippleSize,
              cb: cb
            });
          };
          // Delay the execution of the ripple effect.
          // We have to make a tradeoff with this delay value.
          startTimer.start(DELAY_RIPPLE, function () {
            if (startTimerCommit.current) {
              startTimerCommit.current();
              startTimerCommit.current = null;
            }
          });
        }
      } else {
        startCommit({
          pulsate: pulsate,
          rippleX: rippleX,
          rippleY: rippleY,
          rippleSize: rippleSize,
          cb: cb
        });
      }
    }, [centerProp, startCommit, startTimer]);
    var pulsate = React__namespace.useCallback(function () {
      start({}, {
        pulsate: true
      });
    }, [start]);
    var stop = React__namespace.useCallback(function (event, cb) {
      startTimer.clear();

      // The touch interaction occurs too quickly.
      // We still want to show ripple effect.
      if ((event == null ? void 0 : event.type) === 'touchend' && startTimerCommit.current) {
        startTimerCommit.current();
        startTimerCommit.current = null;
        startTimer.start(0, function () {
          stop(event, cb);
        });
        return;
      }
      startTimerCommit.current = null;
      setRipples(function (oldRipples) {
        if (oldRipples.length > 0) {
          return oldRipples.slice(1);
        }
        return oldRipples;
      });
      rippleCallback.current = cb;
    }, [startTimer]);
    React__namespace.useImperativeHandle(ref, function () {
      return {
        pulsate: pulsate,
        start: start,
        stop: stop
      };
    }, [pulsate, start, stop]);
    return /*#__PURE__*/jsxRuntime_1(TouchRippleRoot, _extends({
      className: clsx(touchRippleClasses$1.root, classes.root, className),
      ref: container
    }, other, {
      children: /*#__PURE__*/jsxRuntime_1(TransitionGroup$1, {
        component: null,
        exit: true,
        children: ripples
      })
    }));
  });
  TouchRipple.propTypes = {
    /**
     * If `true`, the ripple starts at the center of the component
     * rather than at the point of interaction.
     */
    center: PropTypes.bool,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string
  } ;
  var TouchRipple$1 = TouchRipple;

  function getButtonBaseUtilityClass(slot) {
    return generateUtilityClass$1('MuiButtonBase', slot);
  }
  var buttonBaseClasses = generateUtilityClasses$1('MuiButtonBase', ['root', 'disabled', 'focusVisible']);
  var buttonBaseClasses$1 = buttonBaseClasses;

  var useUtilityClasses$1I = function useUtilityClasses(ownerState) {
    var disabled = ownerState.disabled,
      focusVisible = ownerState.focusVisible,
      focusVisibleClassName = ownerState.focusVisibleClassName,
      classes = ownerState.classes;
    var slots = {
      root: ['root', disabled && 'disabled', focusVisible && 'focusVisible']
    };
    var composedClasses = composeClasses(slots, getButtonBaseUtilityClass, classes);
    if (focusVisible && focusVisibleClassName) {
      composedClasses.root += " ".concat(focusVisibleClassName);
    }
    return composedClasses;
  };
  var ButtonBaseRoot = styled$1('button', {
    name: 'MuiButtonBase',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.root;
    }
  })(_defineProperty(_defineProperty({
    display: 'inline-flex',
    alignItems: 'center',
    justifyContent: 'center',
    position: 'relative',
    boxSizing: 'border-box',
    WebkitTapHighlightColor: 'transparent',
    backgroundColor: 'transparent',
    // Reset default value
    // We disable the focus ring for mouse, touch and keyboard users.
    outline: 0,
    border: 0,
    margin: 0,
    // Remove the margin in Safari
    borderRadius: 0,
    padding: 0,
    // Remove the padding in Firefox
    cursor: 'pointer',
    userSelect: 'none',
    verticalAlign: 'middle',
    MozAppearance: 'none',
    // Reset
    WebkitAppearance: 'none',
    // Reset
    textDecoration: 'none',
    // So we take precedent over the style of a native <a /> element.
    color: 'inherit',
    '&::-moz-focus-inner': {
      borderStyle: 'none' // Remove Firefox dotted outline.
    }
  }, "&.".concat(buttonBaseClasses$1.disabled), {
    pointerEvents: 'none',
    // Disable link interactions
    cursor: 'default'
  }), '@media print', {
    colorAdjust: 'exact'
  }));

  /**
   * `ButtonBase` contains as few styles as possible.
   * It aims to be a simple building block for creating a button.
   * It contains a load of style reset and some focus/ripple logic.
   */
  var ButtonBase = /*#__PURE__*/React__namespace.forwardRef(function ButtonBase(inProps, ref) {
    var props = useThemeProps$b({
      props: inProps,
      name: 'MuiButtonBase'
    });
    var action = props.action,
      _props$centerRipple = props.centerRipple,
      centerRipple = _props$centerRipple === void 0 ? false : _props$centerRipple,
      children = props.children,
      className = props.className,
      _props$component = props.component,
      component = _props$component === void 0 ? 'button' : _props$component,
      _props$disabled = props.disabled,
      disabled = _props$disabled === void 0 ? false : _props$disabled,
      _props$disableRipple = props.disableRipple,
      disableRipple = _props$disableRipple === void 0 ? false : _props$disableRipple,
      _props$disableTouchRi = props.disableTouchRipple,
      disableTouchRipple = _props$disableTouchRi === void 0 ? false : _props$disableTouchRi,
      _props$focusRipple = props.focusRipple,
      focusRipple = _props$focusRipple === void 0 ? false : _props$focusRipple;
      props.focusVisibleClassName;
      var _props$LinkComponent = props.LinkComponent,
      LinkComponent = _props$LinkComponent === void 0 ? 'a' : _props$LinkComponent,
      onBlur = props.onBlur,
      onClick = props.onClick,
      onContextMenu = props.onContextMenu,
      onDragLeave = props.onDragLeave,
      onFocus = props.onFocus,
      onFocusVisible = props.onFocusVisible,
      onKeyDown = props.onKeyDown,
      onKeyUp = props.onKeyUp,
      onMouseDown = props.onMouseDown,
      onMouseLeave = props.onMouseLeave,
      onMouseUp = props.onMouseUp,
      onTouchEnd = props.onTouchEnd,
      onTouchMove = props.onTouchMove,
      onTouchStart = props.onTouchStart,
      _props$tabIndex = props.tabIndex,
      tabIndex = _props$tabIndex === void 0 ? 0 : _props$tabIndex,
      TouchRippleProps = props.TouchRippleProps,
      touchRippleRef = props.touchRippleRef,
      type = props.type,
      other = _objectWithoutProperties(props, ["action", "centerRipple", "children", "className", "component", "disabled", "disableRipple", "disableTouchRipple", "focusRipple", "focusVisibleClassName", "LinkComponent", "onBlur", "onClick", "onContextMenu", "onDragLeave", "onFocus", "onFocusVisible", "onKeyDown", "onKeyUp", "onMouseDown", "onMouseLeave", "onMouseUp", "onTouchEnd", "onTouchMove", "onTouchStart", "tabIndex", "TouchRippleProps", "touchRippleRef", "type"]);
    var buttonRef = React__namespace.useRef(null);
    var rippleRef = React__namespace.useRef(null);
    var handleRippleRef = useForkRef(rippleRef, touchRippleRef);
    var _useIsFocusVisible = useIsFocusVisible(),
      isFocusVisibleRef = _useIsFocusVisible.isFocusVisibleRef,
      handleFocusVisible = _useIsFocusVisible.onFocus,
      handleBlurVisible = _useIsFocusVisible.onBlur,
      focusVisibleRef = _useIsFocusVisible.ref;
    var _React$useState = React__namespace.useState(false),
      focusVisible = _React$useState[0],
      setFocusVisible = _React$useState[1];
    if (disabled && focusVisible) {
      setFocusVisible(false);
    }
    React__namespace.useImperativeHandle(action, function () {
      return {
        focusVisible: function focusVisible() {
          setFocusVisible(true);
          buttonRef.current.focus();
        }
      };
    }, []);
    var _React$useState2 = React__namespace.useState(false),
      mountedState = _React$useState2[0],
      setMountedState = _React$useState2[1];
    React__namespace.useEffect(function () {
      setMountedState(true);
    }, []);
    var enableTouchRipple = mountedState && !disableRipple && !disabled;
    React__namespace.useEffect(function () {
      if (focusVisible && focusRipple && !disableRipple && mountedState) {
        rippleRef.current.pulsate();
      }
    }, [disableRipple, focusRipple, focusVisible, mountedState]);
    function useRippleHandler(rippleAction, eventCallback) {
      var skipRippleAction = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : disableTouchRipple;
      return useEventCallback(function (event) {
        if (eventCallback) {
          eventCallback(event);
        }
        var ignore = skipRippleAction;
        if (!ignore && rippleRef.current) {
          rippleRef.current[rippleAction](event);
        }
        return true;
      });
    }
    var handleMouseDown = useRippleHandler('start', onMouseDown);
    var handleContextMenu = useRippleHandler('stop', onContextMenu);
    var handleDragLeave = useRippleHandler('stop', onDragLeave);
    var handleMouseUp = useRippleHandler('stop', onMouseUp);
    var handleMouseLeave = useRippleHandler('stop', function (event) {
      if (focusVisible) {
        event.preventDefault();
      }
      if (onMouseLeave) {
        onMouseLeave(event);
      }
    });
    var handleTouchStart = useRippleHandler('start', onTouchStart);
    var handleTouchEnd = useRippleHandler('stop', onTouchEnd);
    var handleTouchMove = useRippleHandler('stop', onTouchMove);
    var handleBlur = useRippleHandler('stop', function (event) {
      handleBlurVisible(event);
      if (isFocusVisibleRef.current === false) {
        setFocusVisible(false);
      }
      if (onBlur) {
        onBlur(event);
      }
    }, false);
    var handleFocus = useEventCallback(function (event) {
      // Fix for https://github.com/facebook/react/issues/7769
      if (!buttonRef.current) {
        buttonRef.current = event.currentTarget;
      }
      handleFocusVisible(event);
      if (isFocusVisibleRef.current === true) {
        setFocusVisible(true);
        if (onFocusVisible) {
          onFocusVisible(event);
        }
      }
      if (onFocus) {
        onFocus(event);
      }
    });
    var isNonNativeButton = function isNonNativeButton() {
      var button = buttonRef.current;
      return component && component !== 'button' && !(button.tagName === 'A' && button.href);
    };

    /**
     * IE11 shim for https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/repeat
     */
    var keydownRef = React__namespace.useRef(false);
    var handleKeyDown = useEventCallback(function (event) {
      // Check if key is already down to avoid repeats being counted as multiple activations
      if (focusRipple && !keydownRef.current && focusVisible && rippleRef.current && event.key === ' ') {
        keydownRef.current = true;
        rippleRef.current.stop(event, function () {
          rippleRef.current.start(event);
        });
      }
      if (event.target === event.currentTarget && isNonNativeButton() && event.key === ' ') {
        event.preventDefault();
      }
      if (onKeyDown) {
        onKeyDown(event);
      }

      // Keyboard accessibility for non interactive elements
      if (event.target === event.currentTarget && isNonNativeButton() && event.key === 'Enter' && !disabled) {
        event.preventDefault();
        if (onClick) {
          onClick(event);
        }
      }
    });
    var handleKeyUp = useEventCallback(function (event) {
      // calling preventDefault in keyUp on a <button> will not dispatch a click event if Space is pressed
      // https://codesandbox.io/p/sandbox/button-keyup-preventdefault-dn7f0
      if (focusRipple && event.key === ' ' && rippleRef.current && focusVisible && !event.defaultPrevented) {
        keydownRef.current = false;
        rippleRef.current.stop(event, function () {
          rippleRef.current.pulsate(event);
        });
      }
      if (onKeyUp) {
        onKeyUp(event);
      }

      // Keyboard accessibility for non interactive elements
      if (onClick && event.target === event.currentTarget && isNonNativeButton() && event.key === ' ' && !event.defaultPrevented) {
        onClick(event);
      }
    });
    var ComponentProp = component;
    if (ComponentProp === 'button' && (other.href || other.to)) {
      ComponentProp = LinkComponent;
    }
    var buttonProps = {};
    if (ComponentProp === 'button') {
      buttonProps.type = type === undefined ? 'button' : type;
      buttonProps.disabled = disabled;
    } else {
      if (!other.href && !other.to) {
        buttonProps.role = 'button';
      }
      if (disabled) {
        buttonProps['aria-disabled'] = disabled;
      }
    }
    var handleRef = useForkRef(ref, focusVisibleRef, buttonRef);
    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__namespace.useEffect(function () {
        if (enableTouchRipple && !rippleRef.current) {
          console.error(['MUI: The `component` prop provided to ButtonBase is invalid.', 'Please make sure the children prop is rendered in this custom component.'].join('\n'));
        }
      }, [enableTouchRipple]);
    }
    var ownerState = _extends({}, props, {
      centerRipple: centerRipple,
      component: component,
      disabled: disabled,
      disableRipple: disableRipple,
      disableTouchRipple: disableTouchRipple,
      focusRipple: focusRipple,
      tabIndex: tabIndex,
      focusVisible: focusVisible
    });
    var classes = useUtilityClasses$1I(ownerState);
    return /*#__PURE__*/jsxRuntime_2(ButtonBaseRoot, _extends({
      as: ComponentProp,
      className: clsx(classes.root, className),
      ownerState: ownerState,
      onBlur: handleBlur,
      onClick: onClick,
      onContextMenu: handleContextMenu,
      onFocus: handleFocus,
      onKeyDown: handleKeyDown,
      onKeyUp: handleKeyUp,
      onMouseDown: handleMouseDown,
      onMouseLeave: handleMouseLeave,
      onMouseUp: handleMouseUp,
      onDragLeave: handleDragLeave,
      onTouchEnd: handleTouchEnd,
      onTouchMove: handleTouchMove,
      onTouchStart: handleTouchStart,
      ref: handleRef,
      tabIndex: disabled ? -1 : tabIndex,
      type: type
    }, buttonProps, other, {
      children: [children, enableTouchRipple ?
      /*#__PURE__*/
      /* TouchRipple is only needed client-side, x2 boost on the server. */
      jsxRuntime_1(TouchRipple$1, _extends({
        ref: handleRippleRef,
        center: centerRipple
      }, TouchRippleProps)) : null]
    }));
  });
  ButtonBase.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * A ref for imperative actions.
     * It currently only supports `focusVisible()` action.
     */
    action: refType$1,
    /**
     * If `true`, the ripples are centered.
     * They won't start at the cursor interaction position.
     * @default false
     */
    centerRipple: PropTypes.bool,
    /**
     * The content of the component.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: elementTypeAcceptingRef$1,
    /**
     * If `true`, the component is disabled.
     * @default false
     */
    disabled: PropTypes.bool,
    /**
     * If `true`, the ripple effect is disabled.
     *
     * ⚠️ Without a ripple there is no styling for :focus-visible by default. Be sure
     * to highlight the element by applying separate styles with the `.Mui-focusVisible` class.
     * @default false
     */
    disableRipple: PropTypes.bool,
    /**
     * If `true`, the touch ripple effect is disabled.
     * @default false
     */
    disableTouchRipple: PropTypes.bool,
    /**
     * If `true`, the base button will have a keyboard focus ripple.
     * @default false
     */
    focusRipple: PropTypes.bool,
    /**
     * This prop can help identify which element has keyboard focus.
     * The class name will be applied when the element gains the focus through keyboard interaction.
     * It's a polyfill for the [CSS :focus-visible selector](https://drafts.csswg.org/selectors-4/#the-focus-visible-pseudo).
     * The rationale for using this feature [is explained here](https://github.com/WICG/focus-visible/blob/HEAD/explainer.md).
     * A [polyfill can be used](https://github.com/WICG/focus-visible) to apply a `focus-visible` class to other components
     * if needed.
     */
    focusVisibleClassName: PropTypes.string,
    /**
     * @ignore
     */
    href: PropTypes /* @typescript-to-proptypes-ignore */.any,
    /**
     * The component used to render a link when the `href` prop is provided.
     * @default 'a'
     */
    LinkComponent: PropTypes.elementType,
    /**
     * @ignore
     */
    onBlur: PropTypes.func,
    /**
     * @ignore
     */
    onClick: PropTypes.func,
    /**
     * @ignore
     */
    onContextMenu: PropTypes.func,
    /**
     * @ignore
     */
    onDragLeave: PropTypes.func,
    /**
     * @ignore
     */
    onFocus: PropTypes.func,
    /**
     * Callback fired when the component is focused with a keyboard.
     * We trigger a `onFocus` callback too.
     */
    onFocusVisible: PropTypes.func,
    /**
     * @ignore
     */
    onKeyDown: PropTypes.func,
    /**
     * @ignore
     */
    onKeyUp: PropTypes.func,
    /**
     * @ignore
     */
    onMouseDown: PropTypes.func,
    /**
     * @ignore
     */
    onMouseLeave: PropTypes.func,
    /**
     * @ignore
     */
    onMouseUp: PropTypes.func,
    /**
     * @ignore
     */
    onTouchEnd: PropTypes.func,
    /**
     * @ignore
     */
    onTouchMove: PropTypes.func,
    /**
     * @ignore
     */
    onTouchStart: PropTypes.func,
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
    /**
     * @default 0
     */
    tabIndex: PropTypes.number,
    /**
     * Props applied to the `TouchRipple` element.
     */
    TouchRippleProps: PropTypes.object,
    /**
     * A ref that points to the `TouchRipple` element.
     */
    touchRippleRef: PropTypes.oneOfType([PropTypes.func, PropTypes.shape({
      current: PropTypes.shape({
        pulsate: PropTypes.func.isRequired,
        start: PropTypes.func.isRequired,
        stop: PropTypes.func.isRequired
      })
    })]),
    /**
     * @ignore
     */
    type: PropTypes.oneOfType([PropTypes.oneOf(['button', 'reset', 'submit']), PropTypes.string])
  } ;
  var ButtonBase$1 = ButtonBase;

  function getAccordionSummaryUtilityClass(slot) {
    return generateUtilityClass$1('MuiAccordionSummary', slot);
  }
  var accordionSummaryClasses = generateUtilityClasses$1('MuiAccordionSummary', ['root', 'expanded', 'focusVisible', 'disabled', 'gutters', 'contentGutters', 'content', 'expandIconWrapper']);
  var accordionSummaryClasses$1 = accordionSummaryClasses;

  var useThemeProps$7 = createUseThemeProps();
  var useUtilityClasses$1H = function useUtilityClasses(ownerState) {
    var classes = ownerState.classes,
      expanded = ownerState.expanded,
      disabled = ownerState.disabled,
      disableGutters = ownerState.disableGutters;
    var slots = {
      root: ['root', expanded && 'expanded', disabled && 'disabled', !disableGutters && 'gutters'],
      focusVisible: ['focusVisible'],
      content: ['content', expanded && 'expanded', !disableGutters && 'contentGutters'],
      expandIconWrapper: ['expandIconWrapper', expanded && 'expanded']
    };
    return composeClasses(slots, getAccordionSummaryUtilityClass, classes);
  };
  var AccordionSummaryRoot = styled$1(ButtonBase$1, {
    name: 'MuiAccordionSummary',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.root;
    }
  })(function (_ref) {
    var theme = _ref.theme;
    var transition = {
      duration: theme.transitions.duration.shortest
    };
    return _defineProperty(_defineProperty(_defineProperty(_defineProperty({
      display: 'flex',
      minHeight: 48,
      padding: theme.spacing(0, 2),
      transition: theme.transitions.create(['min-height', 'background-color'], transition)
    }, "&.".concat(accordionSummaryClasses$1.focusVisible), {
      backgroundColor: (theme.vars || theme).palette.action.focus
    }), "&.".concat(accordionSummaryClasses$1.disabled), {
      opacity: (theme.vars || theme).palette.action.disabledOpacity
    }), "&:hover:not(.".concat(accordionSummaryClasses$1.disabled, ")"), {
      cursor: 'pointer'
    }), "variants", [{
      props: function props(_props) {
        return !_props.disableGutters;
      },
      style: _defineProperty({}, "&.".concat(accordionSummaryClasses$1.expanded), {
        minHeight: 64
      })
    }]);
  });
  var AccordionSummaryContent = styled$1('div', {
    name: 'MuiAccordionSummary',
    slot: 'Content',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.content;
    }
  })(function (_ref3) {
    var theme = _ref3.theme;
    return {
      display: 'flex',
      flexGrow: 1,
      margin: '12px 0',
      variants: [{
        props: function props(_props2) {
          return !_props2.disableGutters;
        },
        style: _defineProperty({
          transition: theme.transitions.create(['margin'], {
            duration: theme.transitions.duration.shortest
          })
        }, "&.".concat(accordionSummaryClasses$1.expanded), {
          margin: '20px 0'
        })
      }]
    };
  });
  var AccordionSummaryExpandIconWrapper = styled$1('div', {
    name: 'MuiAccordionSummary',
    slot: 'ExpandIconWrapper',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.expandIconWrapper;
    }
  })(function (_ref4) {
    var theme = _ref4.theme;
    return _defineProperty({
      display: 'flex',
      color: (theme.vars || theme).palette.action.active,
      transform: 'rotate(0deg)',
      transition: theme.transitions.create('transform', {
        duration: theme.transitions.duration.shortest
      })
    }, "&.".concat(accordionSummaryClasses$1.expanded), {
      transform: 'rotate(180deg)'
    });
  });
  var AccordionSummary = /*#__PURE__*/React__namespace.forwardRef(function AccordionSummary(inProps, ref) {
    var props = useThemeProps$7({
      props: inProps,
      name: 'MuiAccordionSummary'
    });
    var children = props.children,
      className = props.className,
      expandIcon = props.expandIcon,
      focusVisibleClassName = props.focusVisibleClassName,
      onClick = props.onClick,
      other = _objectWithoutProperties(props, ["children", "className", "expandIcon", "focusVisibleClassName", "onClick"]);
    var _React$useContext = React__namespace.useContext(AccordionContext$1),
      _React$useContext$dis = _React$useContext.disabled,
      disabled = _React$useContext$dis === void 0 ? false : _React$useContext$dis,
      disableGutters = _React$useContext.disableGutters,
      expanded = _React$useContext.expanded,
      toggle = _React$useContext.toggle;
    var handleChange = function handleChange(event) {
      if (toggle) {
        toggle(event);
      }
      if (onClick) {
        onClick(event);
      }
    };
    var ownerState = _extends({}, props, {
      expanded: expanded,
      disabled: disabled,
      disableGutters: disableGutters
    });
    var classes = useUtilityClasses$1H(ownerState);
    return /*#__PURE__*/jsxRuntime_2(AccordionSummaryRoot, _extends({
      focusRipple: false,
      disableRipple: true,
      disabled: disabled,
      component: "div",
      "aria-expanded": expanded,
      className: clsx(classes.root, className),
      focusVisibleClassName: clsx(classes.focusVisible, focusVisibleClassName),
      onClick: handleChange,
      ref: ref,
      ownerState: ownerState
    }, other, {
      children: [/*#__PURE__*/jsxRuntime_1(AccordionSummaryContent, {
        className: classes.content,
        ownerState: ownerState,
        children: children
      }), expandIcon && /*#__PURE__*/jsxRuntime_1(AccordionSummaryExpandIconWrapper, {
        className: classes.expandIconWrapper,
        ownerState: ownerState,
        children: expandIcon
      })]
    }));
  });
  AccordionSummary.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The content of the component.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The icon to display as the expand indicator.
     */
    expandIcon: PropTypes.node,
    /**
     * This prop can help identify which element has keyboard focus.
     * The class name will be applied when the element gains the focus through keyboard interaction.
     * It's a polyfill for the [CSS :focus-visible selector](https://drafts.csswg.org/selectors-4/#the-focus-visible-pseudo).
     * The rationale for using this feature [is explained here](https://github.com/WICG/focus-visible/blob/HEAD/explainer.md).
     * A [polyfill can be used](https://github.com/WICG/focus-visible) to apply a `focus-visible` class to other components
     * if needed.
     */
    focusVisibleClassName: PropTypes.string,
    /**
     * @ignore
     */
    onClick: PropTypes.func,
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var AccordionSummary$1 = AccordionSummary;

  function getAlertUtilityClass(slot) {
    return generateUtilityClass$1('MuiAlert', slot);
  }
  var alertClasses = generateUtilityClasses$1('MuiAlert', ['root', 'action', 'icon', 'message', 'filled', 'colorSuccess', 'colorInfo', 'colorWarning', 'colorError', 'filledSuccess', 'filledInfo', 'filledWarning', 'filledError', 'outlined', 'outlinedSuccess', 'outlinedInfo', 'outlinedWarning', 'outlinedError', 'standard', 'standardSuccess', 'standardInfo', 'standardWarning', 'standardError']);
  var alertClasses$1 = alertClasses;

  function getIconButtonUtilityClass(slot) {
    return generateUtilityClass$1('MuiIconButton', slot);
  }
  var iconButtonClasses = generateUtilityClasses$1('MuiIconButton', ['root', 'disabled', 'colorInherit', 'colorPrimary', 'colorSecondary', 'colorError', 'colorInfo', 'colorSuccess', 'colorWarning', 'edgeStart', 'edgeEnd', 'sizeSmall', 'sizeMedium', 'sizeLarge']);
  var iconButtonClasses$1 = iconButtonClasses;

  var useUtilityClasses$1G = function useUtilityClasses(ownerState) {
    var classes = ownerState.classes,
      disabled = ownerState.disabled,
      color = ownerState.color,
      edge = ownerState.edge,
      size = ownerState.size;
    var slots = {
      root: ['root', disabled && 'disabled', color !== 'default' && "color".concat(capitalize(color)), edge && "edge".concat(capitalize(edge)), "size".concat(capitalize(size))]
    };
    return composeClasses(slots, getIconButtonUtilityClass, classes);
  };
  var IconButtonRoot = styled$1(ButtonBase$1, {
    name: 'MuiIconButton',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      return [styles.root, ownerState.color !== 'default' && styles["color".concat(capitalize(ownerState.color))], ownerState.edge && styles["edge".concat(capitalize(ownerState.edge))], styles["size".concat(capitalize(ownerState.size))]];
    }
  })(function (_ref) {
    var theme = _ref.theme,
      ownerState = _ref.ownerState;
    return _extends({
      textAlign: 'center',
      flex: '0 0 auto',
      fontSize: theme.typography.pxToRem(24),
      padding: 8,
      borderRadius: '50%',
      overflow: 'visible',
      // Explicitly set the default value to solve a bug on IE11.
      color: (theme.vars || theme).palette.action.active,
      transition: theme.transitions.create('background-color', {
        duration: theme.transitions.duration.shortest
      })
    }, !ownerState.disableRipple && {
      '&:hover': {
        backgroundColor: theme.vars ? "rgba(".concat(theme.vars.palette.action.activeChannel, " / ").concat(theme.vars.palette.action.hoverOpacity, ")") : alpha(theme.palette.action.active, theme.palette.action.hoverOpacity),
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          backgroundColor: 'transparent'
        }
      }
    }, ownerState.edge === 'start' && {
      marginLeft: ownerState.size === 'small' ? -3 : -12
    }, ownerState.edge === 'end' && {
      marginRight: ownerState.size === 'small' ? -3 : -12
    });
  }, function (_ref2) {
    var _palette;
    var theme = _ref2.theme,
      ownerState = _ref2.ownerState;
    var palette = (_palette = (theme.vars || theme).palette) == null ? void 0 : _palette[ownerState.color];
    return _extends({}, ownerState.color === 'inherit' && {
      color: 'inherit'
    }, ownerState.color !== 'inherit' && ownerState.color !== 'default' && _extends({
      color: palette == null ? void 0 : palette.main
    }, !ownerState.disableRipple && {
      '&:hover': _extends({}, palette && {
        backgroundColor: theme.vars ? "rgba(".concat(palette.mainChannel, " / ").concat(theme.vars.palette.action.hoverOpacity, ")") : alpha(palette.main, theme.palette.action.hoverOpacity)
      }, {
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          backgroundColor: 'transparent'
        }
      })
    }), ownerState.size === 'small' && {
      padding: 5,
      fontSize: theme.typography.pxToRem(18)
    }, ownerState.size === 'large' && {
      padding: 12,
      fontSize: theme.typography.pxToRem(28)
    }, _defineProperty({}, "&.".concat(iconButtonClasses$1.disabled), {
      backgroundColor: 'transparent',
      color: (theme.vars || theme).palette.action.disabled
    }));
  });

  /**
   * Refer to the [Icons](/material-ui/icons/) section of the documentation
   * regarding the available icon options.
   */
  var IconButton = /*#__PURE__*/React__namespace.forwardRef(function IconButton(inProps, ref) {
    var props = useThemeProps$b({
      props: inProps,
      name: 'MuiIconButton'
    });
    var _props$edge = props.edge,
      edge = _props$edge === void 0 ? false : _props$edge,
      children = props.children,
      className = props.className,
      _props$color = props.color,
      color = _props$color === void 0 ? 'default' : _props$color,
      _props$disabled = props.disabled,
      disabled = _props$disabled === void 0 ? false : _props$disabled,
      _props$disableFocusRi = props.disableFocusRipple,
      disableFocusRipple = _props$disableFocusRi === void 0 ? false : _props$disableFocusRi,
      _props$size = props.size,
      size = _props$size === void 0 ? 'medium' : _props$size,
      other = _objectWithoutProperties(props, ["edge", "children", "className", "color", "disabled", "disableFocusRipple", "size"]);
    var ownerState = _extends({}, props, {
      edge: edge,
      color: color,
      disabled: disabled,
      disableFocusRipple: disableFocusRipple,
      size: size
    });
    var classes = useUtilityClasses$1G(ownerState);
    return /*#__PURE__*/jsxRuntime_1(IconButtonRoot, _extends({
      className: clsx(classes.root, className),
      centerRipple: true,
      focusRipple: !disableFocusRipple,
      disabled: disabled,
      ref: ref
    }, other, {
      ownerState: ownerState,
      children: children
    }));
  });
  IconButton.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The icon to display.
     */
    children: chainPropTypes(PropTypes.node, function (props) {
      var found = React__namespace.Children.toArray(props.children).some(function (child) {
        return /*#__PURE__*/React__namespace.isValidElement(child) && child.props.onClick;
      });
      if (found) {
        return new Error(['MUI: You are providing an onClick event listener to a child of a button element.', 'Prefer applying it to the IconButton directly.', 'This guarantees that the whole <button> will be responsive to click events.'].join('\n'));
      }
      return null;
    }),
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#custom-colors).
     * @default 'default'
     */
    color: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['inherit', 'default', 'primary', 'secondary', 'error', 'info', 'success', 'warning']), PropTypes.string]),
    /**
     * If `true`, the component is disabled.
     * @default false
     */
    disabled: PropTypes.bool,
    /**
     * If `true`, the  keyboard focus ripple is disabled.
     * @default false
     */
    disableFocusRipple: PropTypes.bool,
    /**
     * If `true`, the ripple effect is disabled.
     *
     * ⚠️ Without a ripple there is no styling for :focus-visible by default. Be sure
     * to highlight the element by applying separate styles with the `.Mui-focusVisible` class.
     * @default false
     */
    disableRipple: PropTypes.bool,
    /**
     * If given, uses a negative margin to counteract the padding on one
     * side (this is often helpful for aligning the left or right
     * side of the icon with content above or below, without ruining the border
     * size and shape).
     * @default false
     */
    edge: PropTypes.oneOf(['end', 'start', false]),
    /**
     * The size of the component.
     * `small` is equivalent to the dense button styling.
     * @default 'medium'
     */
    size: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['small', 'medium', 'large']), PropTypes.string]),
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var IconButton$1 = IconButton;

  var SuccessOutlinedIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M20,12A8,8 0 0,1 12,20A8,8 0 0,1 4,12A8,8 0 0,1 12,4C12.76,4 13.5,4.11 14.2, 4.31L15.77,2.74C14.61,2.26 13.34,2 12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0, 0 22,12M7.91,10.08L6.5,11.5L11,16L21,6L19.59,4.58L11,13.17L7.91,10.08Z"
  }), 'SuccessOutlined');

  var ReportProblemOutlinedIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M12 5.99L19.53 19H4.47L12 5.99M12 2L1 21h22L12 2zm1 14h-2v2h2v-2zm0-6h-2v4h2v-4z"
  }), 'ReportProblemOutlined');

  var ErrorOutlineIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M11 15h2v2h-2zm0-8h2v6h-2zm.99-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"
  }), 'ErrorOutline');

  var InfoOutlinedIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M11,9H13V7H11M12,20C7.59,20 4,16.41 4,12C4,7.59 7.59,4 12,4C16.41,4 20,7.59 20, 12C20,16.41 16.41,20 12,20M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10, 10 0 0,0 12,2M11,17H13V11H11V17Z"
  }), 'InfoOutlined');

  var ClearIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"
  }), 'Close');

  var useThemeProps$6 = createUseThemeProps();
  var useUtilityClasses$1F = function useUtilityClasses(ownerState) {
    var variant = ownerState.variant,
      color = ownerState.color,
      severity = ownerState.severity,
      classes = ownerState.classes;
    var slots = {
      root: ['root', "color".concat(capitalize(color || severity)), "".concat(variant).concat(capitalize(color || severity)), "".concat(variant)],
      icon: ['icon'],
      message: ['message'],
      action: ['action']
    };
    return composeClasses(slots, getAlertUtilityClass, classes);
  };
  var AlertRoot = styled$1(Paper$1, {
    name: 'MuiAlert',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      return [styles.root, styles[ownerState.variant], styles["".concat(ownerState.variant).concat(capitalize(ownerState.color || ownerState.severity))]];
    }
  })(function (_ref) {
    var theme = _ref.theme;
    var getColor = theme.palette.mode === 'light' ? darken : lighten;
    var getBackgroundColor = theme.palette.mode === 'light' ? lighten : darken;
    return _extends({}, theme.typography.body2, {
      backgroundColor: 'transparent',
      display: 'flex',
      padding: '6px 16px',
      variants: [].concat(_toConsumableArray(Object.entries(theme.palette).filter(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
          value = _ref3[1];
        return value.main && value.light;
      }).map(function (_ref4) {
        var _ref5 = _slicedToArray(_ref4, 1),
          color = _ref5[0];
        return {
          props: {
            colorSeverity: color,
            variant: 'standard'
          },
          style: _defineProperty({
            color: theme.vars ? theme.vars.palette.Alert["".concat(color, "Color")] : getColor(theme.palette[color].light, 0.6),
            backgroundColor: theme.vars ? theme.vars.palette.Alert["".concat(color, "StandardBg")] : getBackgroundColor(theme.palette[color].light, 0.9)
          }, "& .".concat(alertClasses$1.icon), theme.vars ? {
            color: theme.vars.palette.Alert["".concat(color, "IconColor")]
          } : {
            color: theme.palette[color].main
          })
        };
      })), _toConsumableArray(Object.entries(theme.palette).filter(function (_ref6) {
        var _ref7 = _slicedToArray(_ref6, 2),
          value = _ref7[1];
        return value.main && value.light;
      }).map(function (_ref8) {
        var _ref9 = _slicedToArray(_ref8, 1),
          color = _ref9[0];
        return {
          props: {
            colorSeverity: color,
            variant: 'outlined'
          },
          style: _defineProperty({
            color: theme.vars ? theme.vars.palette.Alert["".concat(color, "Color")] : getColor(theme.palette[color].light, 0.6),
            border: "1px solid ".concat((theme.vars || theme).palette[color].light)
          }, "& .".concat(alertClasses$1.icon), theme.vars ? {
            color: theme.vars.palette.Alert["".concat(color, "IconColor")]
          } : {
            color: theme.palette[color].main
          })
        };
      })), _toConsumableArray(Object.entries(theme.palette).filter(function (_ref10) {
        var _ref11 = _slicedToArray(_ref10, 2),
          value = _ref11[1];
        return value.main && value.dark;
      }).map(function (_ref12) {
        var _ref13 = _slicedToArray(_ref12, 1),
          color = _ref13[0];
        return {
          props: {
            colorSeverity: color,
            variant: 'filled'
          },
          style: _extends({
            fontWeight: theme.typography.fontWeightMedium
          }, theme.vars ? {
            color: theme.vars.palette.Alert["".concat(color, "FilledColor")],
            backgroundColor: theme.vars.palette.Alert["".concat(color, "FilledBg")]
          } : {
            backgroundColor: theme.palette.mode === 'dark' ? theme.palette[color].dark : theme.palette[color].main,
            color: theme.palette.getContrastText(theme.palette[color].main)
          })
        };
      })))
    });
  });
  var AlertIcon = styled$1('div', {
    name: 'MuiAlert',
    slot: 'Icon',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.icon;
    }
  })({
    marginRight: 12,
    padding: '7px 0',
    display: 'flex',
    fontSize: 22,
    opacity: 0.9
  });
  var AlertMessage = styled$1('div', {
    name: 'MuiAlert',
    slot: 'Message',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.message;
    }
  })({
    padding: '8px 0',
    minWidth: 0,
    overflow: 'auto'
  });
  var AlertAction = styled$1('div', {
    name: 'MuiAlert',
    slot: 'Action',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.action;
    }
  })({
    display: 'flex',
    alignItems: 'flex-start',
    padding: '4px 0 0 16px',
    marginLeft: 'auto',
    marginRight: -8
  });
  var defaultIconMapping = {
    success: /*#__PURE__*/jsxRuntime_1(SuccessOutlinedIcon, {
      fontSize: "inherit"
    }),
    warning: /*#__PURE__*/jsxRuntime_1(ReportProblemOutlinedIcon, {
      fontSize: "inherit"
    }),
    error: /*#__PURE__*/jsxRuntime_1(ErrorOutlineIcon, {
      fontSize: "inherit"
    }),
    info: /*#__PURE__*/jsxRuntime_1(InfoOutlinedIcon, {
      fontSize: "inherit"
    })
  };
  var Alert = /*#__PURE__*/React__namespace.forwardRef(function Alert(inProps, ref) {
    var props = useThemeProps$6({
      props: inProps,
      name: 'MuiAlert'
    });
    var action = props.action,
      children = props.children,
      className = props.className,
      _props$closeText = props.closeText,
      closeText = _props$closeText === void 0 ? 'Close' : _props$closeText,
      color = props.color,
      _props$components = props.components,
      components = _props$components === void 0 ? {} : _props$components,
      _props$componentsProp = props.componentsProps,
      componentsProps = _props$componentsProp === void 0 ? {} : _props$componentsProp,
      icon = props.icon,
      _props$iconMapping = props.iconMapping,
      iconMapping = _props$iconMapping === void 0 ? defaultIconMapping : _props$iconMapping,
      onClose = props.onClose,
      _props$role = props.role,
      role = _props$role === void 0 ? 'alert' : _props$role,
      _props$severity = props.severity,
      severity = _props$severity === void 0 ? 'success' : _props$severity,
      _props$slotProps = props.slotProps,
      slotProps = _props$slotProps === void 0 ? {} : _props$slotProps,
      _props$slots = props.slots,
      slots = _props$slots === void 0 ? {} : _props$slots,
      _props$variant = props.variant,
      variant = _props$variant === void 0 ? 'standard' : _props$variant,
      other = _objectWithoutProperties(props, ["action", "children", "className", "closeText", "color", "components", "componentsProps", "icon", "iconMapping", "onClose", "role", "severity", "slotProps", "slots", "variant"]);
    var ownerState = _extends({}, props, {
      color: color,
      severity: severity,
      variant: variant,
      colorSeverity: color || severity
    });
    var classes = useUtilityClasses$1F(ownerState);
    var externalForwardedProps = {
      slots: _extends({
        closeButton: components.CloseButton,
        closeIcon: components.CloseIcon
      }, slots),
      slotProps: _extends({}, componentsProps, slotProps)
    };
    var _useSlot = useSlot('closeButton', {
        elementType: IconButton$1,
        externalForwardedProps: externalForwardedProps,
        ownerState: ownerState
      }),
      _useSlot2 = _slicedToArray(_useSlot, 2),
      CloseButtonSlot = _useSlot2[0],
      closeButtonProps = _useSlot2[1];
    var _useSlot3 = useSlot('closeIcon', {
        elementType: ClearIcon,
        externalForwardedProps: externalForwardedProps,
        ownerState: ownerState
      }),
      _useSlot4 = _slicedToArray(_useSlot3, 2),
      CloseIconSlot = _useSlot4[0],
      closeIconProps = _useSlot4[1];
    return /*#__PURE__*/jsxRuntime_2(AlertRoot, _extends({
      role: role,
      elevation: 0,
      ownerState: ownerState,
      className: clsx(classes.root, className),
      ref: ref
    }, other, {
      children: [icon !== false ? /*#__PURE__*/jsxRuntime_1(AlertIcon, {
        ownerState: ownerState,
        className: classes.icon,
        children: icon || iconMapping[severity] || defaultIconMapping[severity]
      }) : null, /*#__PURE__*/jsxRuntime_1(AlertMessage, {
        ownerState: ownerState,
        className: classes.message,
        children: children
      }), action != null ? /*#__PURE__*/jsxRuntime_1(AlertAction, {
        ownerState: ownerState,
        className: classes.action,
        children: action
      }) : null, action == null && onClose ? /*#__PURE__*/jsxRuntime_1(AlertAction, {
        ownerState: ownerState,
        className: classes.action,
        children: /*#__PURE__*/jsxRuntime_1(CloseButtonSlot, _extends({
          size: "small",
          "aria-label": closeText,
          title: closeText,
          color: "inherit",
          onClick: onClose
        }, closeButtonProps, {
          children: /*#__PURE__*/jsxRuntime_1(CloseIconSlot, _extends({
            fontSize: "small"
          }, closeIconProps))
        }))
      }) : null]
    }));
  });
  Alert.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The action to display. It renders after the message, at the end of the alert.
     */
    action: PropTypes.node,
    /**
     * The content of the component.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * Override the default label for the *close popup* icon button.
     *
     * For localization purposes, you can use the provided [translations](/material-ui/guides/localization/).
     * @default 'Close'
     */
    closeText: PropTypes.string,
    /**
     * The color of the component. Unless provided, the value is taken from the `severity` prop.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#custom-colors).
     */
    color: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['error', 'info', 'success', 'warning']), PropTypes.string]),
    /**
     * The components used for each slot inside.
     *
     * @deprecated use the `slots` prop instead. This prop will be removed in v7. [How to migrate](/material-ui/migration/migrating-from-deprecated-apis/).
     *
     * @default {}
     */
    components: PropTypes.shape({
      CloseButton: PropTypes.elementType,
      CloseIcon: PropTypes.elementType
    }),
    /**
     * The extra props for the slot components.
     * You can override the existing props or add new ones.
     *
     * @deprecated use the `slotProps` prop instead. This prop will be removed in v7. [How to migrate](/material-ui/migration/migrating-from-deprecated-apis/).
     *
     * @default {}
     */
    componentsProps: PropTypes.shape({
      closeButton: PropTypes.object,
      closeIcon: PropTypes.object
    }),
    /**
     * Override the icon displayed before the children.
     * Unless provided, the icon is mapped to the value of the `severity` prop.
     * Set to `false` to remove the `icon`.
     */
    icon: PropTypes.node,
    /**
     * The component maps the `severity` prop to a range of different icons,
     * for instance success to `<SuccessOutlined>`.
     * If you wish to change this mapping, you can provide your own.
     * Alternatively, you can use the `icon` prop to override the icon displayed.
     */
    iconMapping: PropTypes.shape({
      error: PropTypes.node,
      info: PropTypes.node,
      success: PropTypes.node,
      warning: PropTypes.node
    }),
    /**
     * Callback fired when the component requests to be closed.
     * When provided and no `action` prop is set, a close icon button is displayed that triggers the callback when clicked.
     * @param {React.SyntheticEvent} event The event source of the callback.
     */
    onClose: PropTypes.func,
    /**
     * The ARIA role attribute of the element.
     * @default 'alert'
     */
    role: PropTypes.string,
    /**
     * The severity of the alert. This defines the color and icon used.
     * @default 'success'
     */
    severity: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['error', 'info', 'success', 'warning']), PropTypes.string]),
    /**
     * The props used for each slot inside.
     * @default {}
     */
    slotProps: PropTypes.shape({
      closeButton: PropTypes.oneOfType([PropTypes.func, PropTypes.object]),
      closeIcon: PropTypes.oneOfType([PropTypes.func, PropTypes.object])
    }),
    /**
     * The components used for each slot inside.
     * @default {}
     */
    slots: PropTypes.shape({
      closeButton: PropTypes.elementType,
      closeIcon: PropTypes.elementType
    }),
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
    /**
     * The variant to use.
     * @default 'standard'
     */
    variant: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['filled', 'outlined', 'standard']), PropTypes.string])
  } ;
  var Alert$1 = Alert;

  function getTypographyUtilityClass(slot) {
    return generateUtilityClass$1('MuiTypography', slot);
  }
  var typographyClasses = generateUtilityClasses$1('MuiTypography', ['root', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'subtitle1', 'subtitle2', 'body1', 'body2', 'inherit', 'button', 'caption', 'overline', 'alignLeft', 'alignRight', 'alignCenter', 'alignJustify', 'noWrap', 'gutterBottom', 'paragraph']);
  var typographyClasses$1 = typographyClasses;

  var useUtilityClasses$1E = function useUtilityClasses(ownerState) {
    var align = ownerState.align,
      gutterBottom = ownerState.gutterBottom,
      noWrap = ownerState.noWrap,
      paragraph = ownerState.paragraph,
      variant = ownerState.variant,
      classes = ownerState.classes;
    var slots = {
      root: ['root', variant, ownerState.align !== 'inherit' && "align".concat(capitalize(align)), gutterBottom && 'gutterBottom', noWrap && 'noWrap', paragraph && 'paragraph']
    };
    return composeClasses(slots, getTypographyUtilityClass, classes);
  };
  var TypographyRoot = styled$1('span', {
    name: 'MuiTypography',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      return [styles.root, ownerState.variant && styles[ownerState.variant], ownerState.align !== 'inherit' && styles["align".concat(capitalize(ownerState.align))], ownerState.noWrap && styles.noWrap, ownerState.gutterBottom && styles.gutterBottom, ownerState.paragraph && styles.paragraph];
    }
  })(function (_ref) {
    var theme = _ref.theme,
      ownerState = _ref.ownerState;
    return _extends({
      margin: 0
    }, ownerState.variant === 'inherit' && {
      // Some elements, like <button> on Chrome have default font that doesn't inherit, reset this.
      font: 'inherit'
    }, ownerState.variant !== 'inherit' && theme.typography[ownerState.variant], ownerState.align !== 'inherit' && {
      textAlign: ownerState.align
    }, ownerState.noWrap && {
      overflow: 'hidden',
      textOverflow: 'ellipsis',
      whiteSpace: 'nowrap'
    }, ownerState.gutterBottom && {
      marginBottom: '0.35em'
    }, ownerState.paragraph && {
      marginBottom: 16
    });
  });
  var defaultVariantMapping = {
    h1: 'h1',
    h2: 'h2',
    h3: 'h3',
    h4: 'h4',
    h5: 'h5',
    h6: 'h6',
    subtitle1: 'h6',
    subtitle2: 'h6',
    body1: 'p',
    body2: 'p',
    inherit: 'p'
  };

  // TODO v6: deprecate these color values in v5.x and remove the transformation in v6
  var colorTransformations$1 = {
    primary: 'primary.main',
    textPrimary: 'text.primary',
    secondary: 'secondary.main',
    textSecondary: 'text.secondary',
    error: 'error.main'
  };
  var transformDeprecatedColors$1 = function transformDeprecatedColors(color) {
    return colorTransformations$1[color] || color;
  };
  var Typography = /*#__PURE__*/React__namespace.forwardRef(function Typography(inProps, ref) {
    var themeProps = useThemeProps$b({
      props: inProps,
      name: 'MuiTypography'
    });
    var color = transformDeprecatedColors$1(themeProps.color);
    var props = extendSxProp(_extends({}, themeProps, {
      color: color
    }));
    var _props$align = props.align,
      align = _props$align === void 0 ? 'inherit' : _props$align,
      className = props.className,
      component = props.component,
      _props$gutterBottom = props.gutterBottom,
      gutterBottom = _props$gutterBottom === void 0 ? false : _props$gutterBottom,
      _props$noWrap = props.noWrap,
      noWrap = _props$noWrap === void 0 ? false : _props$noWrap,
      _props$paragraph = props.paragraph,
      paragraph = _props$paragraph === void 0 ? false : _props$paragraph,
      _props$variant = props.variant,
      variant = _props$variant === void 0 ? 'body1' : _props$variant,
      _props$variantMapping = props.variantMapping,
      variantMapping = _props$variantMapping === void 0 ? defaultVariantMapping : _props$variantMapping,
      other = _objectWithoutProperties(props, ["align", "className", "component", "gutterBottom", "noWrap", "paragraph", "variant", "variantMapping"]);
    var ownerState = _extends({}, props, {
      align: align,
      color: color,
      className: className,
      component: component,
      gutterBottom: gutterBottom,
      noWrap: noWrap,
      paragraph: paragraph,
      variant: variant,
      variantMapping: variantMapping
    });
    var Component = component || (paragraph ? 'p' : variantMapping[variant] || defaultVariantMapping[variant]) || 'span';
    var classes = useUtilityClasses$1E(ownerState);
    return /*#__PURE__*/jsxRuntime_1(TypographyRoot, _extends({
      as: Component,
      ref: ref,
      ownerState: ownerState,
      className: clsx(classes.root, className)
    }, other));
  });
  Typography.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * Set the text-align on the component.
     * @default 'inherit'
     */
    align: PropTypes.oneOf(['center', 'inherit', 'justify', 'left', 'right']),
    /**
     * The content of the component.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,
    /**
     * If `true`, the text will have a bottom margin.
     * @default false
     */
    gutterBottom: PropTypes.bool,
    /**
     * If `true`, the text will not wrap, but instead will truncate with a text overflow ellipsis.
     *
     * Note that text overflow can only happen with block or inline-block level elements
     * (the element needs to have a width in order to overflow).
     * @default false
     */
    noWrap: PropTypes.bool,
    /**
     * If `true`, the element will be a paragraph element.
     * @default false
     */
    paragraph: PropTypes.bool,
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
    /**
     * Applies the theme typography styles.
     * @default 'body1'
     */
    variant: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['body1', 'body2', 'button', 'caption', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'inherit', 'overline', 'subtitle1', 'subtitle2']), PropTypes.string]),
    /**
     * The component maps the variant prop to a range of different HTML element types.
     * For instance, subtitle1 to `<h6>`.
     * If you wish to change that mapping, you can provide your own.
     * Alternatively, you can use the `component` prop.
     * @default {
     *   h1: 'h1',
     *   h2: 'h2',
     *   h3: 'h3',
     *   h4: 'h4',
     *   h5: 'h5',
     *   h6: 'h6',
     *   subtitle1: 'h6',
     *   subtitle2: 'h6',
     *   body1: 'p',
     *   body2: 'p',
     *   inherit: 'p',
     * }
     */
    variantMapping: PropTypes /* @typescript-to-proptypes-ignore */.object
  } ;
  var Typography$1 = Typography;

  function getAlertTitleUtilityClass(slot) {
    return generateUtilityClass$1('MuiAlertTitle', slot);
  }
  var alertTitleClasses = generateUtilityClasses$1('MuiAlertTitle', ['root']);
  var alertTitleClasses$1 = alertTitleClasses;

  var useThemeProps$5 = createUseThemeProps();
  var useUtilityClasses$1D = function useUtilityClasses(ownerState) {
    var classes = ownerState.classes;
    var slots = {
      root: ['root']
    };
    return composeClasses(slots, getAlertTitleUtilityClass, classes);
  };
  var AlertTitleRoot = styled$1(Typography$1, {
    name: 'MuiAlertTitle',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.root;
    }
  })(function (_ref) {
    var theme = _ref.theme;
    return {
      fontWeight: theme.typography.fontWeightMedium,
      marginTop: -2
    };
  });
  var AlertTitle = /*#__PURE__*/React__namespace.forwardRef(function AlertTitle(inProps, ref) {
    var props = useThemeProps$5({
      props: inProps,
      name: 'MuiAlertTitle'
    });
    var className = props.className,
      other = _objectWithoutProperties(props, ["className"]);
    var ownerState = props;
    var classes = useUtilityClasses$1D(ownerState);
    return /*#__PURE__*/jsxRuntime_1(AlertTitleRoot, _extends({
      gutterBottom: true,
      component: "div",
      ownerState: ownerState,
      ref: ref,
      className: clsx(classes.root, className)
    }, other));
  });
  AlertTitle.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The content of the component.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var AlertTitle$1 = AlertTitle;

  function getAppBarUtilityClass(slot) {
    return generateUtilityClass$1('MuiAppBar', slot);
  }
  var appBarClasses = generateUtilityClasses$1('MuiAppBar', ['root', 'positionFixed', 'positionAbsolute', 'positionSticky', 'positionStatic', 'positionRelative', 'colorDefault', 'colorPrimary', 'colorSecondary', 'colorInherit', 'colorTransparent', 'colorError', 'colorInfo', 'colorSuccess', 'colorWarning']);
  var appBarClasses$1 = appBarClasses;

  var useUtilityClasses$1C = function useUtilityClasses(ownerState) {
    var color = ownerState.color,
      position = ownerState.position,
      classes = ownerState.classes;
    var slots = {
      root: ['root', "color".concat(capitalize(color)), "position".concat(capitalize(position))]
    };
    return composeClasses(slots, getAppBarUtilityClass, classes);
  };

  // var2 is the fallback.
  // Ex. var1: 'var(--a)', var2: 'var(--b)'; return: 'var(--a, var(--b))'
  var joinVars = function joinVars(var1, var2) {
    return var1 ? "".concat(var1 == null ? void 0 : var1.replace(')', ''), ", ").concat(var2, ")") : var2;
  };
  var AppBarRoot = styled$1(Paper$1, {
    name: 'MuiAppBar',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      return [styles.root, styles["position".concat(capitalize(ownerState.position))], styles["color".concat(capitalize(ownerState.color))]];
    }
  })(function (_ref) {
    var theme = _ref.theme,
      ownerState = _ref.ownerState;
    var backgroundColorDefault = theme.palette.mode === 'light' ? theme.palette.grey[100] : theme.palette.grey[900];
    return _extends({
      display: 'flex',
      flexDirection: 'column',
      width: '100%',
      boxSizing: 'border-box',
      // Prevent padding issue with the Modal and fixed positioned AppBar.
      flexShrink: 0
    }, ownerState.position === 'fixed' && {
      position: 'fixed',
      zIndex: (theme.vars || theme).zIndex.appBar,
      top: 0,
      left: 'auto',
      right: 0,
      '@media print': {
        // Prevent the app bar to be visible on each printed page.
        position: 'absolute'
      }
    }, ownerState.position === 'absolute' && {
      position: 'absolute',
      zIndex: (theme.vars || theme).zIndex.appBar,
      top: 0,
      left: 'auto',
      right: 0
    }, ownerState.position === 'sticky' && {
      // ⚠️ sticky is not supported by IE11.
      position: 'sticky',
      zIndex: (theme.vars || theme).zIndex.appBar,
      top: 0,
      left: 'auto',
      right: 0
    }, ownerState.position === 'static' && {
      position: 'static'
    }, ownerState.position === 'relative' && {
      position: 'relative'
    }, !theme.vars && _extends({}, ownerState.color === 'default' && {
      backgroundColor: backgroundColorDefault,
      color: theme.palette.getContrastText(backgroundColorDefault)
    }, ownerState.color && ownerState.color !== 'default' && ownerState.color !== 'inherit' && ownerState.color !== 'transparent' && {
      backgroundColor: theme.palette[ownerState.color].main,
      color: theme.palette[ownerState.color].contrastText
    }, ownerState.color === 'inherit' && {
      color: 'inherit'
    }, theme.palette.mode === 'dark' && !ownerState.enableColorOnDark && {
      backgroundColor: null,
      color: null
    }, ownerState.color === 'transparent' && _extends({
      backgroundColor: 'transparent',
      color: 'inherit'
    }, theme.palette.mode === 'dark' && {
      backgroundImage: 'none'
    })), theme.vars && _extends({}, ownerState.color === 'default' && {
      '--AppBar-background': ownerState.enableColorOnDark ? theme.vars.palette.AppBar.defaultBg : joinVars(theme.vars.palette.AppBar.darkBg, theme.vars.palette.AppBar.defaultBg),
      '--AppBar-color': ownerState.enableColorOnDark ? theme.vars.palette.text.primary : joinVars(theme.vars.palette.AppBar.darkColor, theme.vars.palette.text.primary)
    }, ownerState.color && !ownerState.color.match(/^(default|inherit|transparent)$/) && {
      '--AppBar-background': ownerState.enableColorOnDark ? theme.vars.palette[ownerState.color].main : joinVars(theme.vars.palette.AppBar.darkBg, theme.vars.palette[ownerState.color].main),
      '--AppBar-color': ownerState.enableColorOnDark ? theme.vars.palette[ownerState.color].contrastText : joinVars(theme.vars.palette.AppBar.darkColor, theme.vars.palette[ownerState.color].contrastText)
    }, {
      backgroundColor: 'var(--AppBar-background)',
      color: ownerState.color === 'inherit' ? 'inherit' : 'var(--AppBar-color)'
    }, ownerState.color === 'transparent' && {
      backgroundImage: 'none',
      backgroundColor: 'transparent',
      color: 'inherit'
    }));
  });
  var AppBar = /*#__PURE__*/React__namespace.forwardRef(function AppBar(inProps, ref) {
    var props = useThemeProps$b({
      props: inProps,
      name: 'MuiAppBar'
    });
    var className = props.className,
      _props$color = props.color,
      color = _props$color === void 0 ? 'primary' : _props$color,
      _props$enableColorOnD = props.enableColorOnDark,
      enableColorOnDark = _props$enableColorOnD === void 0 ? false : _props$enableColorOnD,
      _props$position = props.position,
      position = _props$position === void 0 ? 'fixed' : _props$position,
      other = _objectWithoutProperties(props, ["className", "color", "enableColorOnDark", "position"]);
    var ownerState = _extends({}, props, {
      color: color,
      position: position,
      enableColorOnDark: enableColorOnDark
    });
    var classes = useUtilityClasses$1C(ownerState);
    return /*#__PURE__*/jsxRuntime_1(AppBarRoot, _extends({
      square: true,
      component: "header",
      ownerState: ownerState,
      elevation: 4,
      className: clsx(classes.root, className, position === 'fixed' && 'mui-fixed'),
      ref: ref
    }, other));
  });
  AppBar.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The content of the component.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#custom-colors).
     * @default 'primary'
     */
    color: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['default', 'inherit', 'primary', 'secondary', 'transparent', 'error', 'info', 'success', 'warning']), PropTypes.string]),
    /**
     * If true, the `color` prop is applied in dark mode.
     * @default false
     */
    enableColorOnDark: PropTypes.bool,
    /**
     * The positioning type. The behavior of the different options is described
     * [in the MDN web docs](https://developer.mozilla.org/en-US/docs/Learn/CSS/CSS_layout/Positioning).
     * Note: `sticky` is not universally supported and will fall back to `static` when unavailable.
     * @default 'fixed'
     */
    position: PropTypes.oneOf(['absolute', 'fixed', 'relative', 'static', 'sticky']),
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var AppBar$1 = AppBar;

  /**
   *
   * Demos:
   *
   * - [Badge](https://mui.com/base-ui/react-badge/#hook)
   *
   * API:
   *
   * - [useBadge API](https://mui.com/base-ui/react-badge/hooks-api/#use-badge)
   */
  function useBadge(parameters) {
    var badgeContentProp = parameters.badgeContent,
      _parameters$invisible = parameters.invisible,
      invisibleProp = _parameters$invisible === void 0 ? false : _parameters$invisible,
      _parameters$max = parameters.max,
      maxProp = _parameters$max === void 0 ? 99 : _parameters$max,
      _parameters$showZero = parameters.showZero,
      showZero = _parameters$showZero === void 0 ? false : _parameters$showZero;
    var prevProps = usePreviousProps$1({
      badgeContent: badgeContentProp,
      max: maxProp
    });
    var invisible = invisibleProp;
    if (invisibleProp === false && badgeContentProp === 0 && !showZero) {
      invisible = true;
    }
    var _ref = invisible ? prevProps : parameters,
      badgeContent = _ref.badgeContent,
      _ref$max = _ref.max,
      max = _ref$max === void 0 ? maxProp : _ref$max;
    var displayValue = badgeContent && Number(badgeContent) > max ? "".concat(max, "+") : badgeContent;
    return {
      badgeContent: badgeContent,
      invisible: invisible,
      max: max,
      displayValue: displayValue
    };
  }

  var GLOBAL_CLASS_PREFIX = 'base';
  function buildStateClass(state) {
    return "".concat(GLOBAL_CLASS_PREFIX, "--").concat(state);
  }
  function buildSlotClass(componentName, slot) {
    return "".concat(GLOBAL_CLASS_PREFIX, "-").concat(componentName, "-").concat(slot);
  }
  function generateUtilityClass(componentName, slot) {
    var globalStateClass = globalStateClasses[slot];
    return globalStateClass ? buildStateClass(globalStateClass) : buildSlotClass(componentName, slot);
  }

  function generateUtilityClasses(componentName, slots) {
    var result = {};
    slots.forEach(function (slot) {
      result[slot] = generateUtilityClass(componentName, slot);
    });
    return result;
  }

  function mapEventPropToEvent(eventProp) {
    return eventProp.substring(2).toLowerCase();
  }
  function clickedRootScrollbar(event, doc) {
    return doc.documentElement.clientWidth < event.clientX || doc.documentElement.clientHeight < event.clientY;
  }
  /**
   * Listen for click events that occur somewhere in the document, outside of the element itself.
   * For instance, if you need to hide a menu when people click anywhere else on your page.
   *
   * Demos:
   *
   * - [Click-Away Listener](https://mui.com/base-ui/react-click-away-listener/)
   *
   * API:
   *
   * - [ClickAwayListener API](https://mui.com/base-ui/react-click-away-listener/components-api/#click-away-listener)
   */
  function ClickAwayListener(props) {
    var children = props.children,
      _props$disableReactTr = props.disableReactTree,
      disableReactTree = _props$disableReactTr === void 0 ? false : _props$disableReactTr,
      _props$mouseEvent = props.mouseEvent,
      mouseEvent = _props$mouseEvent === void 0 ? 'onClick' : _props$mouseEvent,
      onClickAway = props.onClickAway,
      _props$touchEvent = props.touchEvent,
      touchEvent = _props$touchEvent === void 0 ? 'onTouchEnd' : _props$touchEvent;
    var movedRef = React__namespace.useRef(false);
    var nodeRef = React__namespace.useRef(null);
    var activatedRef = React__namespace.useRef(false);
    var syntheticEventRef = React__namespace.useRef(false);
    React__namespace.useEffect(function () {
      // Ensure that this component is not "activated" synchronously.
      // https://github.com/facebook/react/issues/20074
      setTimeout(function () {
        activatedRef.current = true;
      }, 0);
      return function () {
        activatedRef.current = false;
      };
    }, []);
    var handleRef = useForkRef(
    // @ts-expect-error TODO upstream fix
    children.ref, nodeRef);

    // The handler doesn't take event.defaultPrevented into account:
    //
    // event.preventDefault() is meant to stop default behaviors like
    // clicking a checkbox to check it, hitting a button to submit a form,
    // and hitting left arrow to move the cursor in a text input etc.
    // Only special HTML elements have these default behaviors.
    var handleClickAway = useEventCallback(function (event) {
      // Given developers can stop the propagation of the synthetic event,
      // we can only be confident with a positive value.
      var insideReactTree = syntheticEventRef.current;
      syntheticEventRef.current = false;
      var doc = ownerDocument(nodeRef.current);

      // 1. IE11 support, which trigger the handleClickAway even after the unbind
      // 2. The child might render null.
      // 3. Behave like a blur listener.
      if (!activatedRef.current || !nodeRef.current || 'clientX' in event && clickedRootScrollbar(event, doc)) {
        return;
      }

      // Do not act if user performed touchmove
      if (movedRef.current) {
        movedRef.current = false;
        return;
      }
      var insideDOM;

      // If not enough, can use https://github.com/DieterHolvoet/event-propagation-path/blob/master/propagationPath.js
      if (event.composedPath) {
        insideDOM = event.composedPath().indexOf(nodeRef.current) > -1;
      } else {
        insideDOM = !doc.documentElement.contains(
        // @ts-expect-error returns `false` as intended when not dispatched from a Node
        event.target) || nodeRef.current.contains(
        // @ts-expect-error returns `false` as intended when not dispatched from a Node
        event.target);
      }
      if (!insideDOM && (disableReactTree || !insideReactTree)) {
        onClickAway(event);
      }
    });

    // Keep track of mouse/touch events that bubbled up through the portal.
    var createHandleSynthetic = function createHandleSynthetic(handlerName) {
      return function (event) {
        syntheticEventRef.current = true;
        var childrenPropsHandler = children.props[handlerName];
        if (childrenPropsHandler) {
          childrenPropsHandler(event);
        }
      };
    };
    var childrenProps = {
      ref: handleRef
    };
    if (touchEvent !== false) {
      childrenProps[touchEvent] = createHandleSynthetic(touchEvent);
    }
    React__namespace.useEffect(function () {
      if (touchEvent !== false) {
        var mappedTouchEvent = mapEventPropToEvent(touchEvent);
        var doc = ownerDocument(nodeRef.current);
        var handleTouchMove = function handleTouchMove() {
          movedRef.current = true;
        };
        doc.addEventListener(mappedTouchEvent, handleClickAway);
        doc.addEventListener('touchmove', handleTouchMove);
        return function () {
          doc.removeEventListener(mappedTouchEvent, handleClickAway);
          doc.removeEventListener('touchmove', handleTouchMove);
        };
      }
      return undefined;
    }, [handleClickAway, touchEvent]);
    if (mouseEvent !== false) {
      childrenProps[mouseEvent] = createHandleSynthetic(mouseEvent);
    }
    React__namespace.useEffect(function () {
      if (mouseEvent !== false) {
        var mappedMouseEvent = mapEventPropToEvent(mouseEvent);
        var doc = ownerDocument(nodeRef.current);
        doc.addEventListener(mappedMouseEvent, handleClickAway);
        return function () {
          doc.removeEventListener(mappedMouseEvent, handleClickAway);
        };
      }
      return undefined;
    }, [handleClickAway, mouseEvent]);
    return /*#__PURE__*/jsxRuntime_1(React__namespace.Fragment, {
      children: /*#__PURE__*/React__namespace.cloneElement(children, childrenProps)
    });
  }
  ClickAwayListener.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │ To update them, edit the TypeScript types and run `pnpm proptypes`. │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The wrapped element.
     */
    children: elementAcceptingRef$1.isRequired,
    /**
     * If `true`, the React tree is ignored and only the DOM tree is considered.
     * This prop changes how portaled elements are handled.
     * @default false
     */
    disableReactTree: PropTypes.bool,
    /**
     * The mouse event to listen to. You can disable the listener by providing `false`.
     * @default 'onClick'
     */
    mouseEvent: PropTypes.oneOf(['onClick', 'onMouseDown', 'onMouseUp', 'onPointerDown', 'onPointerUp', false]),
    /**
     * Callback fired when a "click away" event is detected.
     */
    onClickAway: PropTypes.func.isRequired,
    /**
     * The touch event to listen to. You can disable the listener by providing `false`.
     * @default 'onTouchEnd'
     */
    touchEvent: PropTypes.oneOf(['onTouchEnd', 'onTouchStart', false])
  } ;
  {
    // eslint-disable-next-line
    ClickAwayListener['propTypes' + ''] = exactProp(ClickAwayListener.propTypes);
  }

  // Inspired by https://github.com/focus-trap/tabbable
  var candidatesSelector = ['input', 'select', 'textarea', 'a[href]', 'button', '[tabindex]', 'audio[controls]', 'video[controls]', '[contenteditable]:not([contenteditable="false"])'].join(',');
  function getTabIndex(node) {
    var tabindexAttr = parseInt(node.getAttribute('tabindex') || '', 10);
    if (!Number.isNaN(tabindexAttr)) {
      return tabindexAttr;
    }

    // Browsers do not return `tabIndex` correctly for contentEditable nodes;
    // https://bugs.chromium.org/p/chromium/issues/detail?id=661108&q=contenteditable%20tabindex&can=2
    // so if they don't have a tabindex attribute specifically set, assume it's 0.
    // in Chrome, <details/>, <audio controls/> and <video controls/> elements get a default
    //  `tabIndex` of -1 when the 'tabindex' attribute isn't specified in the DOM,
    //  yet they are still part of the regular tab order; in FF, they get a default
    //  `tabIndex` of 0; since Chrome still puts those elements in the regular tab
    //  order, consider their tab index to be 0.
    if (node.contentEditable === 'true' || (node.nodeName === 'AUDIO' || node.nodeName === 'VIDEO' || node.nodeName === 'DETAILS') && node.getAttribute('tabindex') === null) {
      return 0;
    }
    return node.tabIndex;
  }
  function isNonTabbableRadio(node) {
    if (node.tagName !== 'INPUT' || node.type !== 'radio') {
      return false;
    }
    if (!node.name) {
      return false;
    }
    var getRadio = function getRadio(selector) {
      return node.ownerDocument.querySelector("input[type=\"radio\"]".concat(selector));
    };
    var roving = getRadio("[name=\"".concat(node.name, "\"]:checked"));
    if (!roving) {
      roving = getRadio("[name=\"".concat(node.name, "\"]"));
    }
    return roving !== node;
  }
  function isNodeMatchingSelectorFocusable(node) {
    if (node.disabled || node.tagName === 'INPUT' && node.type === 'hidden' || isNonTabbableRadio(node)) {
      return false;
    }
    return true;
  }
  function defaultGetTabbable(root) {
    var regularTabNodes = [];
    var orderedTabNodes = [];
    Array.from(root.querySelectorAll(candidatesSelector)).forEach(function (node, i) {
      var nodeTabIndex = getTabIndex(node);
      if (nodeTabIndex === -1 || !isNodeMatchingSelectorFocusable(node)) {
        return;
      }
      if (nodeTabIndex === 0) {
        regularTabNodes.push(node);
      } else {
        orderedTabNodes.push({
          documentOrder: i,
          tabIndex: nodeTabIndex,
          node: node
        });
      }
    });
    return orderedTabNodes.sort(function (a, b) {
      return a.tabIndex === b.tabIndex ? a.documentOrder - b.documentOrder : a.tabIndex - b.tabIndex;
    }).map(function (a) {
      return a.node;
    }).concat(regularTabNodes);
  }
  function defaultIsEnabled() {
    return true;
  }

  /**
   * Utility component that locks focus inside the component.
   *
   * Demos:
   *
   * - [Focus Trap](https://mui.com/base-ui/react-focus-trap/)
   *
   * API:
   *
   * - [FocusTrap API](https://mui.com/base-ui/react-focus-trap/components-api/#focus-trap)
   */
  function FocusTrap(props) {
    var children = props.children,
      _props$disableAutoFoc = props.disableAutoFocus,
      disableAutoFocus = _props$disableAutoFoc === void 0 ? false : _props$disableAutoFoc,
      _props$disableEnforce = props.disableEnforceFocus,
      disableEnforceFocus = _props$disableEnforce === void 0 ? false : _props$disableEnforce,
      _props$disableRestore = props.disableRestoreFocus,
      disableRestoreFocus = _props$disableRestore === void 0 ? false : _props$disableRestore,
      _props$getTabbable = props.getTabbable,
      getTabbable = _props$getTabbable === void 0 ? defaultGetTabbable : _props$getTabbable,
      _props$isEnabled = props.isEnabled,
      isEnabled = _props$isEnabled === void 0 ? defaultIsEnabled : _props$isEnabled,
      open = props.open;
    var ignoreNextEnforceFocus = React__namespace.useRef(false);
    var sentinelStart = React__namespace.useRef(null);
    var sentinelEnd = React__namespace.useRef(null);
    var nodeToRestore = React__namespace.useRef(null);
    var reactFocusEventTarget = React__namespace.useRef(null);
    // This variable is useful when disableAutoFocus is true.
    // It waits for the active element to move into the component to activate.
    var activated = React__namespace.useRef(false);
    var rootRef = React__namespace.useRef(null);
    // @ts-expect-error TODO upstream fix
    var handleRef = useForkRef(children.ref, rootRef);
    var lastKeydown = React__namespace.useRef(null);
    React__namespace.useEffect(function () {
      // We might render an empty child.
      if (!open || !rootRef.current) {
        return;
      }
      activated.current = !disableAutoFocus;
    }, [disableAutoFocus, open]);
    React__namespace.useEffect(function () {
      // We might render an empty child.
      if (!open || !rootRef.current) {
        return;
      }
      var doc = ownerDocument(rootRef.current);
      if (!rootRef.current.contains(doc.activeElement)) {
        if (!rootRef.current.hasAttribute('tabIndex')) {
          {
            console.error(['MUI: The modal content node does not accept focus.', 'For the benefit of assistive technologies, ' + 'the tabIndex of the node is being set to "-1".'].join('\n'));
          }
          rootRef.current.setAttribute('tabIndex', '-1');
        }
        if (activated.current) {
          rootRef.current.focus();
        }
      }
      return function () {
        // restoreLastFocus()
        if (!disableRestoreFocus) {
          // In IE11 it is possible for document.activeElement to be null resulting
          // in nodeToRestore.current being null.
          // Not all elements in IE11 have a focus method.
          // Once IE11 support is dropped the focus() call can be unconditional.
          if (nodeToRestore.current && nodeToRestore.current.focus) {
            ignoreNextEnforceFocus.current = true;
            nodeToRestore.current.focus();
          }
          nodeToRestore.current = null;
        }
      };
      // Missing `disableRestoreFocus` which is fine.
      // We don't support changing that prop on an open FocusTrap
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [open]);
    React__namespace.useEffect(function () {
      // We might render an empty child.
      if (!open || !rootRef.current) {
        return;
      }
      var doc = ownerDocument(rootRef.current);
      var loopFocus = function loopFocus(nativeEvent) {
        lastKeydown.current = nativeEvent;
        if (disableEnforceFocus || !isEnabled() || nativeEvent.key !== 'Tab') {
          return;
        }

        // Make sure the next tab starts from the right place.
        // doc.activeElement refers to the origin.
        if (doc.activeElement === rootRef.current && nativeEvent.shiftKey) {
          // We need to ignore the next contain as
          // it will try to move the focus back to the rootRef element.
          ignoreNextEnforceFocus.current = true;
          if (sentinelEnd.current) {
            sentinelEnd.current.focus();
          }
        }
      };
      var contain = function contain() {
        var rootElement = rootRef.current;

        // Cleanup functions are executed lazily in React 17.
        // Contain can be called between the component being unmounted and its cleanup function being run.
        if (rootElement === null) {
          return;
        }
        if (!doc.hasFocus() || !isEnabled() || ignoreNextEnforceFocus.current) {
          ignoreNextEnforceFocus.current = false;
          return;
        }

        // The focus is already inside
        if (rootElement.contains(doc.activeElement)) {
          return;
        }

        // The disableEnforceFocus is set and the focus is outside of the focus trap (and sentinel nodes)
        if (disableEnforceFocus && doc.activeElement !== sentinelStart.current && doc.activeElement !== sentinelEnd.current) {
          return;
        }

        // if the focus event is not coming from inside the children's react tree, reset the refs
        if (doc.activeElement !== reactFocusEventTarget.current) {
          reactFocusEventTarget.current = null;
        } else if (reactFocusEventTarget.current !== null) {
          return;
        }
        if (!activated.current) {
          return;
        }
        var tabbable = [];
        if (doc.activeElement === sentinelStart.current || doc.activeElement === sentinelEnd.current) {
          tabbable = getTabbable(rootRef.current);
        }

        // one of the sentinel nodes was focused, so move the focus
        // to the first/last tabbable element inside the focus trap
        if (tabbable.length > 0) {
          var _lastKeydown$current, _lastKeydown$current2;
          var isShiftTab = Boolean(((_lastKeydown$current = lastKeydown.current) == null ? void 0 : _lastKeydown$current.shiftKey) && ((_lastKeydown$current2 = lastKeydown.current) == null ? void 0 : _lastKeydown$current2.key) === 'Tab');
          var focusNext = tabbable[0];
          var focusPrevious = tabbable[tabbable.length - 1];
          if (typeof focusNext !== 'string' && typeof focusPrevious !== 'string') {
            if (isShiftTab) {
              focusPrevious.focus();
            } else {
              focusNext.focus();
            }
          }
          // no tabbable elements in the trap focus or the focus was outside of the focus trap
        } else {
          rootElement.focus();
        }
      };
      doc.addEventListener('focusin', contain);
      doc.addEventListener('keydown', loopFocus, true);

      // With Edge, Safari and Firefox, no focus related events are fired when the focused area stops being a focused area.
      // for example https://bugzilla.mozilla.org/show_bug.cgi?id=559561.
      // Instead, we can look if the active element was restored on the BODY element.
      //
      // The whatwg spec defines how the browser should behave but does not explicitly mention any events:
      // https://html.spec.whatwg.org/multipage/interaction.html#focus-fixup-rule.
      var interval = setInterval(function () {
        if (doc.activeElement && doc.activeElement.tagName === 'BODY') {
          contain();
        }
      }, 50);
      return function () {
        clearInterval(interval);
        doc.removeEventListener('focusin', contain);
        doc.removeEventListener('keydown', loopFocus, true);
      };
    }, [disableAutoFocus, disableEnforceFocus, disableRestoreFocus, isEnabled, open, getTabbable]);
    var onFocus = function onFocus(event) {
      if (nodeToRestore.current === null) {
        nodeToRestore.current = event.relatedTarget;
      }
      activated.current = true;
      reactFocusEventTarget.current = event.target;
      var childrenPropsHandler = children.props.onFocus;
      if (childrenPropsHandler) {
        childrenPropsHandler(event);
      }
    };
    var handleFocusSentinel = function handleFocusSentinel(event) {
      if (nodeToRestore.current === null) {
        nodeToRestore.current = event.relatedTarget;
      }
      activated.current = true;
    };
    return /*#__PURE__*/jsxRuntime_2(React__namespace.Fragment, {
      children: [/*#__PURE__*/jsxRuntime_1("div", {
        tabIndex: open ? 0 : -1,
        onFocus: handleFocusSentinel,
        ref: sentinelStart,
        "data-testid": "sentinelStart"
      }), /*#__PURE__*/React__namespace.cloneElement(children, {
        ref: handleRef,
        onFocus: onFocus
      }), /*#__PURE__*/jsxRuntime_1("div", {
        tabIndex: open ? 0 : -1,
        onFocus: handleFocusSentinel,
        ref: sentinelEnd,
        "data-testid": "sentinelEnd"
      })]
    });
  }
  FocusTrap.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │ To update them, edit the TypeScript types and run `pnpm proptypes`. │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * A single child content element.
     */
    children: elementAcceptingRef$1,
    /**
     * If `true`, the focus trap will not automatically shift focus to itself when it opens, and
     * replace it to the last focused element when it closes.
     * This also works correctly with any focus trap children that have the `disableAutoFocus` prop.
     *
     * Generally this should never be set to `true` as it makes the focus trap less
     * accessible to assistive technologies, like screen readers.
     * @default false
     */
    disableAutoFocus: PropTypes.bool,
    /**
     * If `true`, the focus trap will not prevent focus from leaving the focus trap while open.
     *
     * Generally this should never be set to `true` as it makes the focus trap less
     * accessible to assistive technologies, like screen readers.
     * @default false
     */
    disableEnforceFocus: PropTypes.bool,
    /**
     * If `true`, the focus trap will not restore focus to previously focused element once
     * focus trap is hidden or unmounted.
     * @default false
     */
    disableRestoreFocus: PropTypes.bool,
    /**
     * Returns an array of ordered tabbable nodes (i.e. in tab order) within the root.
     * For instance, you can provide the "tabbable" npm dependency.
     * @param {HTMLElement} root
     */
    getTabbable: PropTypes.func,
    /**
     * This prop extends the `open` prop.
     * It allows to toggle the open state without having to wait for a rerender when changing the `open` prop.
     * This prop should be memoized.
     * It can be used to support multiple focus trap mounted at the same time.
     * @default function defaultIsEnabled(): boolean {
     *   return true;
     * }
     */
    isEnabled: PropTypes.func,
    /**
     * If `true`, focus is locked.
     */
    open: PropTypes.bool.isRequired
  } ;
  {
    // eslint-disable-next-line
    FocusTrap['propTypes' + ''] = exactProp(FocusTrap.propTypes);
  }

  function getContainer$1(container) {
    return typeof container === 'function' ? container() : container;
  }

  /**
   * Portals provide a first-class way to render children into a DOM node
   * that exists outside the DOM hierarchy of the parent component.
   *
   * Demos:
   *
   * - [Portal](https://mui.com/base-ui/react-portal/)
   *
   * API:
   *
   * - [Portal API](https://mui.com/base-ui/react-portal/components-api/#portal)
   */
  var Portal = /*#__PURE__*/React__namespace.forwardRef(function Portal(props, forwardedRef) {
    var children = props.children,
      container = props.container,
      _props$disablePortal = props.disablePortal,
      disablePortal = _props$disablePortal === void 0 ? false : _props$disablePortal;
    var _React$useState = React__namespace.useState(null),
      mountNode = _React$useState[0],
      setMountNode = _React$useState[1]; // @ts-expect-error TODO upstream fix
    var handleRef = useForkRef( /*#__PURE__*/React__namespace.isValidElement(children) ? children.ref : null, forwardedRef);
    useEnhancedEffect$1(function () {
      if (!disablePortal) {
        setMountNode(getContainer$1(container) || document.body);
      }
    }, [container, disablePortal]);
    useEnhancedEffect$1(function () {
      if (mountNode && !disablePortal) {
        setRef(forwardedRef, mountNode);
        return function () {
          setRef(forwardedRef, null);
        };
      }
      return undefined;
    }, [forwardedRef, mountNode, disablePortal]);
    if (disablePortal) {
      if ( /*#__PURE__*/React__namespace.isValidElement(children)) {
        var newProps = {
          ref: handleRef
        };
        return /*#__PURE__*/React__namespace.cloneElement(children, newProps);
      }
      return /*#__PURE__*/jsxRuntime_1(React__namespace.Fragment, {
        children: children
      });
    }
    return /*#__PURE__*/jsxRuntime_1(React__namespace.Fragment, {
      children: mountNode ? /*#__PURE__*/ReactDOM__namespace.createPortal(children, mountNode) : mountNode
    });
  });
  Portal.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │ To update them, edit the TypeScript types and run `pnpm proptypes`. │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The children to render into the `container`.
     */
    children: PropTypes.node,
    /**
     * An HTML element or function that returns one.
     * The `container` will have the portal children appended to it.
     *
     * You can also provide a callback, which is called in a React layout effect.
     * This lets you set the container from a ref, and also makes server-side rendering possible.
     *
     * By default, it uses the body of the top-level document object,
     * so it's simply `document.body` most of the time.
     */
    container: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([HTMLElementType, PropTypes.func]),
    /**
     * The `children` will be under the DOM hierarchy of the parent component.
     * @default false
     */
    disablePortal: PropTypes.bool
  } ;
  {
    // eslint-disable-next-line
    Portal['propTypes' + ''] = exactProp(Portal.propTypes);
  }

  // Is a vertical scrollbar displayed?
  function isOverflowing(container) {
    var doc = ownerDocument(container);
    if (doc.body === container) {
      return ownerWindow(container).innerWidth > doc.documentElement.clientWidth;
    }
    return container.scrollHeight > container.clientHeight;
  }
  function ariaHidden(element, show) {
    if (show) {
      element.setAttribute('aria-hidden', 'true');
    } else {
      element.removeAttribute('aria-hidden');
    }
  }
  function getPaddingRight(element) {
    return parseInt(ownerWindow(element).getComputedStyle(element).paddingRight, 10) || 0;
  }
  function isAriaHiddenForbiddenOnElement(element) {
    // The forbidden HTML tags are the ones from ARIA specification that
    // can be children of body and can't have aria-hidden attribute.
    // cf. https://www.w3.org/TR/html-aria/#docconformance
    var forbiddenTagNames = ['TEMPLATE', 'SCRIPT', 'STYLE', 'LINK', 'MAP', 'META', 'NOSCRIPT', 'PICTURE', 'COL', 'COLGROUP', 'PARAM', 'SLOT', 'SOURCE', 'TRACK'];
    var isForbiddenTagName = forbiddenTagNames.indexOf(element.tagName) !== -1;
    var isInputHidden = element.tagName === 'INPUT' && element.getAttribute('type') === 'hidden';
    return isForbiddenTagName || isInputHidden;
  }
  function ariaHiddenSiblings(container, mountElement, currentElement, elementsToExclude, show) {
    var blacklist = [mountElement, currentElement].concat(_toConsumableArray(elementsToExclude));
    [].forEach.call(container.children, function (element) {
      var isNotExcludedElement = blacklist.indexOf(element) === -1;
      var isNotForbiddenElement = !isAriaHiddenForbiddenOnElement(element);
      if (isNotExcludedElement && isNotForbiddenElement) {
        ariaHidden(element, show);
      }
    });
  }
  function findIndexOf(items, callback) {
    var idx = -1;
    items.some(function (item, index) {
      if (callback(item)) {
        idx = index;
        return true;
      }
      return false;
    });
    return idx;
  }
  function handleContainer(containerInfo, props) {
    var restoreStyle = [];
    var container = containerInfo.container;
    if (!props.disableScrollLock) {
      if (isOverflowing(container)) {
        // Compute the size before applying overflow hidden to avoid any scroll jumps.
        var scrollbarSize = getScrollbarSize(ownerDocument(container));
        restoreStyle.push({
          value: container.style.paddingRight,
          property: 'padding-right',
          el: container
        });
        // Use computed style, here to get the real padding to add our scrollbar width.
        container.style.paddingRight = "".concat(getPaddingRight(container) + scrollbarSize, "px");

        // .mui-fixed is a global helper.
        var fixedElements = ownerDocument(container).querySelectorAll('.mui-fixed');
        [].forEach.call(fixedElements, function (element) {
          restoreStyle.push({
            value: element.style.paddingRight,
            property: 'padding-right',
            el: element
          });
          element.style.paddingRight = "".concat(getPaddingRight(element) + scrollbarSize, "px");
        });
      }
      var scrollContainer;
      if (container.parentNode instanceof DocumentFragment) {
        scrollContainer = ownerDocument(container).body;
      } else {
        // Support html overflow-y: auto for scroll stability between pages
        // https://css-tricks.com/snippets/css/force-vertical-scrollbar/
        var parent = container.parentElement;
        var containerWindow = ownerWindow(container);
        scrollContainer = (parent == null ? void 0 : parent.nodeName) === 'HTML' && containerWindow.getComputedStyle(parent).overflowY === 'scroll' ? parent : container;
      }

      // Block the scroll even if no scrollbar is visible to account for mobile keyboard
      // screensize shrink.
      restoreStyle.push({
        value: scrollContainer.style.overflow,
        property: 'overflow',
        el: scrollContainer
      }, {
        value: scrollContainer.style.overflowX,
        property: 'overflow-x',
        el: scrollContainer
      }, {
        value: scrollContainer.style.overflowY,
        property: 'overflow-y',
        el: scrollContainer
      });
      scrollContainer.style.overflow = 'hidden';
    }
    var restore = function restore() {
      restoreStyle.forEach(function (_ref) {
        var value = _ref.value,
          el = _ref.el,
          property = _ref.property;
        if (value) {
          el.style.setProperty(property, value);
        } else {
          el.style.removeProperty(property);
        }
      });
    };
    return restore;
  }
  function getHiddenSiblings(container) {
    var hiddenSiblings = [];
    [].forEach.call(container.children, function (element) {
      if (element.getAttribute('aria-hidden') === 'true') {
        hiddenSiblings.push(element);
      }
    });
    return hiddenSiblings;
  }
  /**
   * @ignore - do not document.
   *
   * Proper state management for containers and the modals in those containers.
   * Simplified, but inspired by react-overlay's ModalManager class.
   * Used by the Modal to ensure proper styling of containers.
   */
  var ModalManager = /*#__PURE__*/function () {
    function ModalManager() {
      _classCallCheck(this, ModalManager);
      this.containers = void 0;
      this.modals = void 0;
      this.modals = [];
      this.containers = [];
    }
    _createClass(ModalManager, [{
      key: "add",
      value: function add(modal, container) {
        var modalIndex = this.modals.indexOf(modal);
        if (modalIndex !== -1) {
          return modalIndex;
        }
        modalIndex = this.modals.length;
        this.modals.push(modal);

        // If the modal we are adding is already in the DOM.
        if (modal.modalRef) {
          ariaHidden(modal.modalRef, false);
        }
        var hiddenSiblings = getHiddenSiblings(container);
        ariaHiddenSiblings(container, modal.mount, modal.modalRef, hiddenSiblings, true);
        var containerIndex = findIndexOf(this.containers, function (item) {
          return item.container === container;
        });
        if (containerIndex !== -1) {
          this.containers[containerIndex].modals.push(modal);
          return modalIndex;
        }
        this.containers.push({
          modals: [modal],
          container: container,
          restore: null,
          hiddenSiblings: hiddenSiblings
        });
        return modalIndex;
      }
    }, {
      key: "mount",
      value: function mount(modal, props) {
        var containerIndex = findIndexOf(this.containers, function (item) {
          return item.modals.indexOf(modal) !== -1;
        });
        var containerInfo = this.containers[containerIndex];
        if (!containerInfo.restore) {
          containerInfo.restore = handleContainer(containerInfo, props);
        }
      }
    }, {
      key: "remove",
      value: function remove(modal) {
        var ariaHiddenState = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
        var modalIndex = this.modals.indexOf(modal);
        if (modalIndex === -1) {
          return modalIndex;
        }
        var containerIndex = findIndexOf(this.containers, function (item) {
          return item.modals.indexOf(modal) !== -1;
        });
        var containerInfo = this.containers[containerIndex];
        containerInfo.modals.splice(containerInfo.modals.indexOf(modal), 1);
        this.modals.splice(modalIndex, 1);

        // If that was the last modal in a container, clean up the container.
        if (containerInfo.modals.length === 0) {
          // The modal might be closed before it had the chance to be mounted in the DOM.
          if (containerInfo.restore) {
            containerInfo.restore();
          }
          if (modal.modalRef) {
            // In case the modal wasn't in the DOM yet.
            ariaHidden(modal.modalRef, ariaHiddenState);
          }
          ariaHiddenSiblings(containerInfo.container, modal.mount, modal.modalRef, containerInfo.hiddenSiblings, false);
          this.containers.splice(containerIndex, 1);
        } else {
          // Otherwise make sure the next top modal is visible to a screen reader.
          var nextTop = containerInfo.modals[containerInfo.modals.length - 1];
          // as soon as a modal is adding its modalRef is undefined. it can't set
          // aria-hidden because the dom element doesn't exist either
          // when modal was unmounted before modalRef gets null
          if (nextTop.modalRef) {
            ariaHidden(nextTop.modalRef, false);
          }
        }
        return modalIndex;
      }
    }, {
      key: "isTopModal",
      value: function isTopModal(modal) {
        return this.modals.length > 0 && this.modals[this.modals.length - 1] === modal;
      }
    }]);
    return ModalManager;
  }();

  function getContainer(container) {
    return typeof container === 'function' ? container() : container;
  }
  function getHasTransition(children) {
    return children ? children.props.hasOwnProperty('in') : false;
  }

  // A modal manager used to track and manage the state of open Modals.
  // Modals don't open on the server so this won't conflict with concurrent requests.
  var defaultManager = new ModalManager();
  /**
   *
   * Demos:
   *
   * - [Modal](https://mui.com/base-ui/react-modal/#hook)
   *
   * API:
   *
   * - [useModal API](https://mui.com/base-ui/react-modal/hooks-api/#use-modal)
   */
  function useModal(parameters) {
    var container = parameters.container,
      _parameters$disableEs = parameters.disableEscapeKeyDown,
      disableEscapeKeyDown = _parameters$disableEs === void 0 ? false : _parameters$disableEs,
      _parameters$disableSc = parameters.disableScrollLock,
      disableScrollLock = _parameters$disableSc === void 0 ? false : _parameters$disableSc,
      _parameters$manager = parameters.manager,
      manager = _parameters$manager === void 0 ? defaultManager : _parameters$manager,
      _parameters$closeAfte = parameters.closeAfterTransition,
      closeAfterTransition = _parameters$closeAfte === void 0 ? false : _parameters$closeAfte,
      onTransitionEnter = parameters.onTransitionEnter,
      onTransitionExited = parameters.onTransitionExited,
      children = parameters.children,
      onClose = parameters.onClose,
      open = parameters.open,
      rootRef = parameters.rootRef; // @ts-ignore internal logic
    var modal = React__namespace.useRef({});
    var mountNodeRef = React__namespace.useRef(null);
    var modalRef = React__namespace.useRef(null);
    var handleRef = useForkRef(modalRef, rootRef);
    var _React$useState = React__namespace.useState(!open),
      exited = _React$useState[0],
      setExited = _React$useState[1];
    var hasTransition = getHasTransition(children);
    var ariaHiddenProp = true;
    if (parameters['aria-hidden'] === 'false' || parameters['aria-hidden'] === false) {
      ariaHiddenProp = false;
    }
    var getDoc = function getDoc() {
      return ownerDocument(mountNodeRef.current);
    };
    var getModal = function getModal() {
      modal.current.modalRef = modalRef.current;
      modal.current.mount = mountNodeRef.current;
      return modal.current;
    };
    var handleMounted = function handleMounted() {
      manager.mount(getModal(), {
        disableScrollLock: disableScrollLock
      });

      // Fix a bug on Chrome where the scroll isn't initially 0.
      if (modalRef.current) {
        modalRef.current.scrollTop = 0;
      }
    };
    var handleOpen = useEventCallback(function () {
      var resolvedContainer = getContainer(container) || getDoc().body;
      manager.add(getModal(), resolvedContainer);

      // The element was already mounted.
      if (modalRef.current) {
        handleMounted();
      }
    });
    var isTopModal = React__namespace.useCallback(function () {
      return manager.isTopModal(getModal());
    }, [manager]);
    var handlePortalRef = useEventCallback(function (node) {
      mountNodeRef.current = node;
      if (!node) {
        return;
      }
      if (open && isTopModal()) {
        handleMounted();
      } else if (modalRef.current) {
        ariaHidden(modalRef.current, ariaHiddenProp);
      }
    });
    var handleClose = React__namespace.useCallback(function () {
      manager.remove(getModal(), ariaHiddenProp);
    }, [ariaHiddenProp, manager]);
    React__namespace.useEffect(function () {
      return function () {
        handleClose();
      };
    }, [handleClose]);
    React__namespace.useEffect(function () {
      if (open) {
        handleOpen();
      } else if (!hasTransition || !closeAfterTransition) {
        handleClose();
      }
    }, [open, handleClose, hasTransition, closeAfterTransition, handleOpen]);
    var createHandleKeyDown = function createHandleKeyDown(otherHandlers) {
      return function (event) {
        var _otherHandlers$onKeyD;
        (_otherHandlers$onKeyD = otherHandlers.onKeyDown) == null || _otherHandlers$onKeyD.call(otherHandlers, event);

        // The handler doesn't take event.defaultPrevented into account:
        //
        // event.preventDefault() is meant to stop default behaviors like
        // clicking a checkbox to check it, hitting a button to submit a form,
        // and hitting left arrow to move the cursor in a text input etc.
        // Only special HTML elements have these default behaviors.
        if (event.key !== 'Escape' || event.which === 229 ||
        // Wait until IME is settled.
        !isTopModal()) {
          return;
        }
        if (!disableEscapeKeyDown) {
          // Swallow the event, in case someone is listening for the escape key on the body.
          event.stopPropagation();
          if (onClose) {
            onClose(event, 'escapeKeyDown');
          }
        }
      };
    };
    var createHandleBackdropClick = function createHandleBackdropClick(otherHandlers) {
      return function (event) {
        var _otherHandlers$onClic;
        (_otherHandlers$onClic = otherHandlers.onClick) == null || _otherHandlers$onClic.call(otherHandlers, event);
        if (event.target !== event.currentTarget) {
          return;
        }
        if (onClose) {
          onClose(event, 'backdropClick');
        }
      };
    };
    var getRootProps = function getRootProps() {
      var otherHandlers = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var propsEventHandlers = extractEventHandlers(parameters);

      // The custom event handlers shouldn't be spread on the root element
      delete propsEventHandlers.onTransitionEnter;
      delete propsEventHandlers.onTransitionExited;
      var externalEventHandlers = _extends({}, propsEventHandlers, otherHandlers);
      return _extends({
        role: 'presentation'
      }, externalEventHandlers, {
        onKeyDown: createHandleKeyDown(externalEventHandlers),
        ref: handleRef
      });
    };
    var getBackdropProps = function getBackdropProps() {
      var otherHandlers = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var externalEventHandlers = otherHandlers;
      return _extends({
        'aria-hidden': true
      }, externalEventHandlers, {
        onClick: createHandleBackdropClick(externalEventHandlers),
        open: open
      });
    };
    var getTransitionProps = function getTransitionProps() {
      var handleEnter = function handleEnter() {
        setExited(false);
        if (onTransitionEnter) {
          onTransitionEnter();
        }
      };
      var handleExited = function handleExited() {
        setExited(true);
        if (onTransitionExited) {
          onTransitionExited();
        }
        if (closeAfterTransition) {
          handleClose();
        }
      };
      return {
        onEnter: createChainedFunction(handleEnter, children == null ? void 0 : children.props.onEnter),
        onExited: createChainedFunction(handleExited, children == null ? void 0 : children.props.onExited)
      };
    };
    return {
      getRootProps: getRootProps,
      getBackdropProps: getBackdropProps,
      getTransitionProps: getTransitionProps,
      rootRef: handleRef,
      portalRef: handlePortalRef,
      isTopModal: isTopModal,
      exited: exited,
      hasTransition: hasTransition
    };
  }

  /**
   * NoSsr purposely removes components from the subject of Server Side Rendering (SSR).
   *
   * This component can be useful in a variety of situations:
   *
   * *   Escape hatch for broken dependencies not supporting SSR.
   * *   Improve the time-to-first paint on the client by only rendering above the fold.
   * *   Reduce the rendering time on the server.
   * *   Under too heavy server load, you can turn on service degradation.
   *
   * Demos:
   *
   * - [No SSR](https://mui.com/base-ui/react-no-ssr/)
   *
   * API:
   *
   * - [NoSsr API](https://mui.com/base-ui/react-no-ssr/components-api/#no-ssr)
   */
  function NoSsr(props) {
    var children = props.children,
      _props$defer = props.defer,
      defer = _props$defer === void 0 ? false : _props$defer,
      _props$fallback = props.fallback,
      fallback = _props$fallback === void 0 ? null : _props$fallback;
    var _React$useState = React__namespace.useState(false),
      mountedState = _React$useState[0],
      setMountedState = _React$useState[1];
    useEnhancedEffect$1(function () {
      if (!defer) {
        setMountedState(true);
      }
    }, [defer]);
    React__namespace.useEffect(function () {
      if (defer) {
        setMountedState(true);
      }
    }, [defer]);

    // We need the Fragment here to force react-docgen to recognise NoSsr as a component.
    return /*#__PURE__*/jsxRuntime_1(React__namespace.Fragment, {
      children: mountedState ? children : fallback
    });
  }
  NoSsr.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │ To update them, edit the TypeScript types and run `pnpm proptypes`. │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * You can wrap a node.
     */
    children: PropTypes.node,
    /**
     * If `true`, the component will not only prevent server-side rendering.
     * It will also defer the rendering of the children into a different screen frame.
     * @default false
     */
    defer: PropTypes.bool,
    /**
     * The fallback content to display.
     * @default null
     */
    fallback: PropTypes.node
  } ;
  {
    // eslint-disable-next-line
    NoSsr['propTypes' + ''] = exactProp(NoSsr.propTypes);
  }

  var top = 'top';
  var bottom = 'bottom';
  var right = 'right';
  var left = 'left';
  var auto = 'auto';
  var basePlacements = [top, bottom, right, left];
  var start = 'start';
  var end = 'end';
  var clippingParents = 'clippingParents';
  var viewport = 'viewport';
  var popper = 'popper';
  var reference = 'reference';
  var variationPlacements = /*#__PURE__*/basePlacements.reduce(function (acc, placement) {
    return acc.concat([placement + "-" + start, placement + "-" + end]);
  }, []);
  var placements = /*#__PURE__*/[].concat(basePlacements, [auto]).reduce(function (acc, placement) {
    return acc.concat([placement, placement + "-" + start, placement + "-" + end]);
  }, []); // modifiers that need to read the DOM

  var beforeRead = 'beforeRead';
  var read = 'read';
  var afterRead = 'afterRead'; // pure-logic modifiers

  var beforeMain = 'beforeMain';
  var main = 'main';
  var afterMain = 'afterMain'; // modifier with the purpose to write to the DOM (or write into a framework state)

  var beforeWrite = 'beforeWrite';
  var write = 'write';
  var afterWrite = 'afterWrite';
  var modifierPhases = [beforeRead, read, afterRead, beforeMain, main, afterMain, beforeWrite, write, afterWrite];

  function getNodeName(element) {
    return element ? (element.nodeName || '').toLowerCase() : null;
  }

  function getWindow(node) {
    if (node == null) {
      return window;
    }

    if (node.toString() !== '[object Window]') {
      var ownerDocument = node.ownerDocument;
      return ownerDocument ? ownerDocument.defaultView || window : window;
    }

    return node;
  }

  function isElement(node) {
    var OwnElement = getWindow(node).Element;
    return node instanceof OwnElement || node instanceof Element;
  }

  function isHTMLElement$1(node) {
    var OwnElement = getWindow(node).HTMLElement;
    return node instanceof OwnElement || node instanceof HTMLElement;
  }

  function isShadowRoot(node) {
    // IE 11 has no ShadowRoot
    if (typeof ShadowRoot === 'undefined') {
      return false;
    }

    var OwnElement = getWindow(node).ShadowRoot;
    return node instanceof OwnElement || node instanceof ShadowRoot;
  }

  // and applies them to the HTMLElements such as popper and arrow

  function applyStyles(_ref) {
    var state = _ref.state;
    Object.keys(state.elements).forEach(function (name) {
      var style = state.styles[name] || {};
      var attributes = state.attributes[name] || {};
      var element = state.elements[name]; // arrow is optional + virtual elements

      if (!isHTMLElement$1(element) || !getNodeName(element)) {
        return;
      } // Flow doesn't support to extend this property, but it's the most
      // effective way to apply styles to an HTMLElement
      // $FlowFixMe[cannot-write]


      Object.assign(element.style, style);
      Object.keys(attributes).forEach(function (name) {
        var value = attributes[name];

        if (value === false) {
          element.removeAttribute(name);
        } else {
          element.setAttribute(name, value === true ? '' : value);
        }
      });
    });
  }

  function effect$2(_ref2) {
    var state = _ref2.state;
    var initialStyles = {
      popper: {
        position: state.options.strategy,
        left: '0',
        top: '0',
        margin: '0'
      },
      arrow: {
        position: 'absolute'
      },
      reference: {}
    };
    Object.assign(state.elements.popper.style, initialStyles.popper);
    state.styles = initialStyles;

    if (state.elements.arrow) {
      Object.assign(state.elements.arrow.style, initialStyles.arrow);
    }

    return function () {
      Object.keys(state.elements).forEach(function (name) {
        var element = state.elements[name];
        var attributes = state.attributes[name] || {};
        var styleProperties = Object.keys(state.styles.hasOwnProperty(name) ? state.styles[name] : initialStyles[name]); // Set all values to an empty string to unset them

        var style = styleProperties.reduce(function (style, property) {
          style[property] = '';
          return style;
        }, {}); // arrow is optional + virtual elements

        if (!isHTMLElement$1(element) || !getNodeName(element)) {
          return;
        }

        Object.assign(element.style, style);
        Object.keys(attributes).forEach(function (attribute) {
          element.removeAttribute(attribute);
        });
      });
    };
  } // eslint-disable-next-line import/no-unused-modules


  var applyStyles$1 = {
    name: 'applyStyles',
    enabled: true,
    phase: 'write',
    fn: applyStyles,
    effect: effect$2,
    requires: ['computeStyles']
  };

  function getBasePlacement(placement) {
    return placement.split('-')[0];
  }

  var max = Math.max;
  var min = Math.min;
  var round$1 = Math.round;

  function getUAString() {
    var uaData = navigator.userAgentData;

    if (uaData != null && uaData.brands && Array.isArray(uaData.brands)) {
      return uaData.brands.map(function (item) {
        return item.brand + "/" + item.version;
      }).join(' ');
    }

    return navigator.userAgent;
  }

  function isLayoutViewport() {
    return !/^((?!chrome|android).)*safari/i.test(getUAString());
  }

  function getBoundingClientRect(element, includeScale, isFixedStrategy) {
    if (includeScale === void 0) {
      includeScale = false;
    }

    if (isFixedStrategy === void 0) {
      isFixedStrategy = false;
    }

    var clientRect = element.getBoundingClientRect();
    var scaleX = 1;
    var scaleY = 1;

    if (includeScale && isHTMLElement$1(element)) {
      scaleX = element.offsetWidth > 0 ? round$1(clientRect.width) / element.offsetWidth || 1 : 1;
      scaleY = element.offsetHeight > 0 ? round$1(clientRect.height) / element.offsetHeight || 1 : 1;
    }

    var _ref = isElement(element) ? getWindow(element) : window,
        visualViewport = _ref.visualViewport;

    var addVisualOffsets = !isLayoutViewport() && isFixedStrategy;
    var x = (clientRect.left + (addVisualOffsets && visualViewport ? visualViewport.offsetLeft : 0)) / scaleX;
    var y = (clientRect.top + (addVisualOffsets && visualViewport ? visualViewport.offsetTop : 0)) / scaleY;
    var width = clientRect.width / scaleX;
    var height = clientRect.height / scaleY;
    return {
      width: width,
      height: height,
      top: y,
      right: x + width,
      bottom: y + height,
      left: x,
      x: x,
      y: y
    };
  }

  // means it doesn't take into account transforms.

  function getLayoutRect(element) {
    var clientRect = getBoundingClientRect(element); // Use the clientRect sizes if it's not been transformed.
    // Fixes https://github.com/popperjs/popper-core/issues/1223

    var width = element.offsetWidth;
    var height = element.offsetHeight;

    if (Math.abs(clientRect.width - width) <= 1) {
      width = clientRect.width;
    }

    if (Math.abs(clientRect.height - height) <= 1) {
      height = clientRect.height;
    }

    return {
      x: element.offsetLeft,
      y: element.offsetTop,
      width: width,
      height: height
    };
  }

  function contains(parent, child) {
    var rootNode = child.getRootNode && child.getRootNode(); // First, attempt with faster native method

    if (parent.contains(child)) {
      return true;
    } // then fallback to custom implementation with Shadow DOM support
    else if (rootNode && isShadowRoot(rootNode)) {
        var next = child;

        do {
          if (next && parent.isSameNode(next)) {
            return true;
          } // $FlowFixMe[prop-missing]: need a better way to handle this...


          next = next.parentNode || next.host;
        } while (next);
      } // Give up, the result is false


    return false;
  }

  function getComputedStyle(element) {
    return getWindow(element).getComputedStyle(element);
  }

  function isTableElement(element) {
    return ['table', 'td', 'th'].indexOf(getNodeName(element)) >= 0;
  }

  function getDocumentElement(element) {
    // $FlowFixMe[incompatible-return]: assume body is always available
    return ((isElement(element) ? element.ownerDocument : // $FlowFixMe[prop-missing]
    element.document) || window.document).documentElement;
  }

  function getParentNode(element) {
    if (getNodeName(element) === 'html') {
      return element;
    }

    return (// this is a quicker (but less type safe) way to save quite some bytes from the bundle
      // $FlowFixMe[incompatible-return]
      // $FlowFixMe[prop-missing]
      element.assignedSlot || // step into the shadow DOM of the parent of a slotted node
      element.parentNode || ( // DOM Element detected
      isShadowRoot(element) ? element.host : null) || // ShadowRoot detected
      // $FlowFixMe[incompatible-call]: HTMLElement is a Node
      getDocumentElement(element) // fallback

    );
  }

  function getTrueOffsetParent(element) {
    if (!isHTMLElement$1(element) || // https://github.com/popperjs/popper-core/issues/837
    getComputedStyle(element).position === 'fixed') {
      return null;
    }

    return element.offsetParent;
  } // `.offsetParent` reports `null` for fixed elements, while absolute elements
  // return the containing block


  function getContainingBlock(element) {
    var isFirefox = /firefox/i.test(getUAString());
    var isIE = /Trident/i.test(getUAString());

    if (isIE && isHTMLElement$1(element)) {
      // In IE 9, 10 and 11 fixed elements containing block is always established by the viewport
      var elementCss = getComputedStyle(element);

      if (elementCss.position === 'fixed') {
        return null;
      }
    }

    var currentNode = getParentNode(element);

    if (isShadowRoot(currentNode)) {
      currentNode = currentNode.host;
    }

    while (isHTMLElement$1(currentNode) && ['html', 'body'].indexOf(getNodeName(currentNode)) < 0) {
      var css = getComputedStyle(currentNode); // This is non-exhaustive but covers the most common CSS properties that
      // create a containing block.
      // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block

      if (css.transform !== 'none' || css.perspective !== 'none' || css.contain === 'paint' || ['transform', 'perspective'].indexOf(css.willChange) !== -1 || isFirefox && css.willChange === 'filter' || isFirefox && css.filter && css.filter !== 'none') {
        return currentNode;
      } else {
        currentNode = currentNode.parentNode;
      }
    }

    return null;
  } // Gets the closest ancestor positioned element. Handles some edge cases,
  // such as table ancestors and cross browser bugs.


  function getOffsetParent(element) {
    var window = getWindow(element);
    var offsetParent = getTrueOffsetParent(element);

    while (offsetParent && isTableElement(offsetParent) && getComputedStyle(offsetParent).position === 'static') {
      offsetParent = getTrueOffsetParent(offsetParent);
    }

    if (offsetParent && (getNodeName(offsetParent) === 'html' || getNodeName(offsetParent) === 'body' && getComputedStyle(offsetParent).position === 'static')) {
      return window;
    }

    return offsetParent || getContainingBlock(element) || window;
  }

  function getMainAxisFromPlacement(placement) {
    return ['top', 'bottom'].indexOf(placement) >= 0 ? 'x' : 'y';
  }

  function within(min$1, value, max$1) {
    return max(min$1, min(value, max$1));
  }
  function withinMaxClamp(min, value, max) {
    var v = within(min, value, max);
    return v > max ? max : v;
  }

  function getFreshSideObject() {
    return {
      top: 0,
      right: 0,
      bottom: 0,
      left: 0
    };
  }

  function mergePaddingObject(paddingObject) {
    return Object.assign({}, getFreshSideObject(), paddingObject);
  }

  function expandToHashMap(value, keys) {
    return keys.reduce(function (hashMap, key) {
      hashMap[key] = value;
      return hashMap;
    }, {});
  }

  var toPaddingObject = function toPaddingObject(padding, state) {
    padding = typeof padding === 'function' ? padding(Object.assign({}, state.rects, {
      placement: state.placement
    })) : padding;
    return mergePaddingObject(typeof padding !== 'number' ? padding : expandToHashMap(padding, basePlacements));
  };

  function arrow(_ref) {
    var _state$modifiersData$;

    var state = _ref.state,
        name = _ref.name,
        options = _ref.options;
    var arrowElement = state.elements.arrow;
    var popperOffsets = state.modifiersData.popperOffsets;
    var basePlacement = getBasePlacement(state.placement);
    var axis = getMainAxisFromPlacement(basePlacement);
    var isVertical = [left, right].indexOf(basePlacement) >= 0;
    var len = isVertical ? 'height' : 'width';

    if (!arrowElement || !popperOffsets) {
      return;
    }

    var paddingObject = toPaddingObject(options.padding, state);
    var arrowRect = getLayoutRect(arrowElement);
    var minProp = axis === 'y' ? top : left;
    var maxProp = axis === 'y' ? bottom : right;
    var endDiff = state.rects.reference[len] + state.rects.reference[axis] - popperOffsets[axis] - state.rects.popper[len];
    var startDiff = popperOffsets[axis] - state.rects.reference[axis];
    var arrowOffsetParent = getOffsetParent(arrowElement);
    var clientSize = arrowOffsetParent ? axis === 'y' ? arrowOffsetParent.clientHeight || 0 : arrowOffsetParent.clientWidth || 0 : 0;
    var centerToReference = endDiff / 2 - startDiff / 2; // Make sure the arrow doesn't overflow the popper if the center point is
    // outside of the popper bounds

    var min = paddingObject[minProp];
    var max = clientSize - arrowRect[len] - paddingObject[maxProp];
    var center = clientSize / 2 - arrowRect[len] / 2 + centerToReference;
    var offset = within(min, center, max); // Prevents breaking syntax highlighting...

    var axisProp = axis;
    state.modifiersData[name] = (_state$modifiersData$ = {}, _state$modifiersData$[axisProp] = offset, _state$modifiersData$.centerOffset = offset - center, _state$modifiersData$);
  }

  function effect$1(_ref2) {
    var state = _ref2.state,
        options = _ref2.options;
    var _options$element = options.element,
        arrowElement = _options$element === void 0 ? '[data-popper-arrow]' : _options$element;

    if (arrowElement == null) {
      return;
    } // CSS selector


    if (typeof arrowElement === 'string') {
      arrowElement = state.elements.popper.querySelector(arrowElement);

      if (!arrowElement) {
        return;
      }
    }

    if (!contains(state.elements.popper, arrowElement)) {
      return;
    }

    state.elements.arrow = arrowElement;
  } // eslint-disable-next-line import/no-unused-modules


  var arrow$1 = {
    name: 'arrow',
    enabled: true,
    phase: 'main',
    fn: arrow,
    effect: effect$1,
    requires: ['popperOffsets'],
    requiresIfExists: ['preventOverflow']
  };

  function getVariation(placement) {
    return placement.split('-')[1];
  }

  var unsetSides = {
    top: 'auto',
    right: 'auto',
    bottom: 'auto',
    left: 'auto'
  }; // Round the offsets to the nearest suitable subpixel based on the DPR.
  // Zooming can change the DPR, but it seems to report a value that will
  // cleanly divide the values into the appropriate subpixels.

  function roundOffsetsByDPR(_ref, win) {
    var x = _ref.x,
        y = _ref.y;
    var dpr = win.devicePixelRatio || 1;
    return {
      x: round$1(x * dpr) / dpr || 0,
      y: round$1(y * dpr) / dpr || 0
    };
  }

  function mapToStyles(_ref2) {
    var _Object$assign2;

    var popper = _ref2.popper,
        popperRect = _ref2.popperRect,
        placement = _ref2.placement,
        variation = _ref2.variation,
        offsets = _ref2.offsets,
        position = _ref2.position,
        gpuAcceleration = _ref2.gpuAcceleration,
        adaptive = _ref2.adaptive,
        roundOffsets = _ref2.roundOffsets,
        isFixed = _ref2.isFixed;
    var _offsets$x = offsets.x,
        x = _offsets$x === void 0 ? 0 : _offsets$x,
        _offsets$y = offsets.y,
        y = _offsets$y === void 0 ? 0 : _offsets$y;

    var _ref3 = typeof roundOffsets === 'function' ? roundOffsets({
      x: x,
      y: y
    }) : {
      x: x,
      y: y
    };

    x = _ref3.x;
    y = _ref3.y;
    var hasX = offsets.hasOwnProperty('x');
    var hasY = offsets.hasOwnProperty('y');
    var sideX = left;
    var sideY = top;
    var win = window;

    if (adaptive) {
      var offsetParent = getOffsetParent(popper);
      var heightProp = 'clientHeight';
      var widthProp = 'clientWidth';

      if (offsetParent === getWindow(popper)) {
        offsetParent = getDocumentElement(popper);

        if (getComputedStyle(offsetParent).position !== 'static' && position === 'absolute') {
          heightProp = 'scrollHeight';
          widthProp = 'scrollWidth';
        }
      } // $FlowFixMe[incompatible-cast]: force type refinement, we compare offsetParent with window above, but Flow doesn't detect it


      offsetParent = offsetParent;

      if (placement === top || (placement === left || placement === right) && variation === end) {
        sideY = bottom;
        var offsetY = isFixed && offsetParent === win && win.visualViewport ? win.visualViewport.height : // $FlowFixMe[prop-missing]
        offsetParent[heightProp];
        y -= offsetY - popperRect.height;
        y *= gpuAcceleration ? 1 : -1;
      }

      if (placement === left || (placement === top || placement === bottom) && variation === end) {
        sideX = right;
        var offsetX = isFixed && offsetParent === win && win.visualViewport ? win.visualViewport.width : // $FlowFixMe[prop-missing]
        offsetParent[widthProp];
        x -= offsetX - popperRect.width;
        x *= gpuAcceleration ? 1 : -1;
      }
    }

    var commonStyles = Object.assign({
      position: position
    }, adaptive && unsetSides);

    var _ref4 = roundOffsets === true ? roundOffsetsByDPR({
      x: x,
      y: y
    }, getWindow(popper)) : {
      x: x,
      y: y
    };

    x = _ref4.x;
    y = _ref4.y;

    if (gpuAcceleration) {
      var _Object$assign;

      return Object.assign({}, commonStyles, (_Object$assign = {}, _Object$assign[sideY] = hasY ? '0' : '', _Object$assign[sideX] = hasX ? '0' : '', _Object$assign.transform = (win.devicePixelRatio || 1) <= 1 ? "translate(" + x + "px, " + y + "px)" : "translate3d(" + x + "px, " + y + "px, 0)", _Object$assign));
    }

    return Object.assign({}, commonStyles, (_Object$assign2 = {}, _Object$assign2[sideY] = hasY ? y + "px" : '', _Object$assign2[sideX] = hasX ? x + "px" : '', _Object$assign2.transform = '', _Object$assign2));
  }

  function computeStyles(_ref5) {
    var state = _ref5.state,
        options = _ref5.options;
    var _options$gpuAccelerat = options.gpuAcceleration,
        gpuAcceleration = _options$gpuAccelerat === void 0 ? true : _options$gpuAccelerat,
        _options$adaptive = options.adaptive,
        adaptive = _options$adaptive === void 0 ? true : _options$adaptive,
        _options$roundOffsets = options.roundOffsets,
        roundOffsets = _options$roundOffsets === void 0 ? true : _options$roundOffsets;
    var commonStyles = {
      placement: getBasePlacement(state.placement),
      variation: getVariation(state.placement),
      popper: state.elements.popper,
      popperRect: state.rects.popper,
      gpuAcceleration: gpuAcceleration,
      isFixed: state.options.strategy === 'fixed'
    };

    if (state.modifiersData.popperOffsets != null) {
      state.styles.popper = Object.assign({}, state.styles.popper, mapToStyles(Object.assign({}, commonStyles, {
        offsets: state.modifiersData.popperOffsets,
        position: state.options.strategy,
        adaptive: adaptive,
        roundOffsets: roundOffsets
      })));
    }

    if (state.modifiersData.arrow != null) {
      state.styles.arrow = Object.assign({}, state.styles.arrow, mapToStyles(Object.assign({}, commonStyles, {
        offsets: state.modifiersData.arrow,
        position: 'absolute',
        adaptive: false,
        roundOffsets: roundOffsets
      })));
    }

    state.attributes.popper = Object.assign({}, state.attributes.popper, {
      'data-popper-placement': state.placement
    });
  } // eslint-disable-next-line import/no-unused-modules


  var computeStyles$1 = {
    name: 'computeStyles',
    enabled: true,
    phase: 'beforeWrite',
    fn: computeStyles,
    data: {}
  };

  var passive = {
    passive: true
  };

  function effect(_ref) {
    var state = _ref.state,
        instance = _ref.instance,
        options = _ref.options;
    var _options$scroll = options.scroll,
        scroll = _options$scroll === void 0 ? true : _options$scroll,
        _options$resize = options.resize,
        resize = _options$resize === void 0 ? true : _options$resize;
    var window = getWindow(state.elements.popper);
    var scrollParents = [].concat(state.scrollParents.reference, state.scrollParents.popper);

    if (scroll) {
      scrollParents.forEach(function (scrollParent) {
        scrollParent.addEventListener('scroll', instance.update, passive);
      });
    }

    if (resize) {
      window.addEventListener('resize', instance.update, passive);
    }

    return function () {
      if (scroll) {
        scrollParents.forEach(function (scrollParent) {
          scrollParent.removeEventListener('scroll', instance.update, passive);
        });
      }

      if (resize) {
        window.removeEventListener('resize', instance.update, passive);
      }
    };
  } // eslint-disable-next-line import/no-unused-modules


  var eventListeners = {
    name: 'eventListeners',
    enabled: true,
    phase: 'write',
    fn: function fn() {},
    effect: effect,
    data: {}
  };

  var hash$1 = {
    left: 'right',
    right: 'left',
    bottom: 'top',
    top: 'bottom'
  };
  function getOppositePlacement(placement) {
    return placement.replace(/left|right|bottom|top/g, function (matched) {
      return hash$1[matched];
    });
  }

  var hash = {
    start: 'end',
    end: 'start'
  };
  function getOppositeVariationPlacement(placement) {
    return placement.replace(/start|end/g, function (matched) {
      return hash[matched];
    });
  }

  function getWindowScroll(node) {
    var win = getWindow(node);
    var scrollLeft = win.pageXOffset;
    var scrollTop = win.pageYOffset;
    return {
      scrollLeft: scrollLeft,
      scrollTop: scrollTop
    };
  }

  function getWindowScrollBarX(element) {
    // If <html> has a CSS width greater than the viewport, then this will be
    // incorrect for RTL.
    // Popper 1 is broken in this case and never had a bug report so let's assume
    // it's not an issue. I don't think anyone ever specifies width on <html>
    // anyway.
    // Browsers where the left scrollbar doesn't cause an issue report `0` for
    // this (e.g. Edge 2019, IE11, Safari)
    return getBoundingClientRect(getDocumentElement(element)).left + getWindowScroll(element).scrollLeft;
  }

  function getViewportRect(element, strategy) {
    var win = getWindow(element);
    var html = getDocumentElement(element);
    var visualViewport = win.visualViewport;
    var width = html.clientWidth;
    var height = html.clientHeight;
    var x = 0;
    var y = 0;

    if (visualViewport) {
      width = visualViewport.width;
      height = visualViewport.height;
      var layoutViewport = isLayoutViewport();

      if (layoutViewport || !layoutViewport && strategy === 'fixed') {
        x = visualViewport.offsetLeft;
        y = visualViewport.offsetTop;
      }
    }

    return {
      width: width,
      height: height,
      x: x + getWindowScrollBarX(element),
      y: y
    };
  }

  // of the `<html>` and `<body>` rect bounds if horizontally scrollable

  function getDocumentRect(element) {
    var _element$ownerDocumen;

    var html = getDocumentElement(element);
    var winScroll = getWindowScroll(element);
    var body = (_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body;
    var width = max(html.scrollWidth, html.clientWidth, body ? body.scrollWidth : 0, body ? body.clientWidth : 0);
    var height = max(html.scrollHeight, html.clientHeight, body ? body.scrollHeight : 0, body ? body.clientHeight : 0);
    var x = -winScroll.scrollLeft + getWindowScrollBarX(element);
    var y = -winScroll.scrollTop;

    if (getComputedStyle(body || html).direction === 'rtl') {
      x += max(html.clientWidth, body ? body.clientWidth : 0) - width;
    }

    return {
      width: width,
      height: height,
      x: x,
      y: y
    };
  }

  function isScrollParent(element) {
    // Firefox wants us to check `-x` and `-y` variations as well
    var _getComputedStyle = getComputedStyle(element),
        overflow = _getComputedStyle.overflow,
        overflowX = _getComputedStyle.overflowX,
        overflowY = _getComputedStyle.overflowY;

    return /auto|scroll|overlay|hidden/.test(overflow + overflowY + overflowX);
  }

  function getScrollParent(node) {
    if (['html', 'body', '#document'].indexOf(getNodeName(node)) >= 0) {
      // $FlowFixMe[incompatible-return]: assume body is always available
      return node.ownerDocument.body;
    }

    if (isHTMLElement$1(node) && isScrollParent(node)) {
      return node;
    }

    return getScrollParent(getParentNode(node));
  }

  /*
  given a DOM element, return the list of all scroll parents, up the list of ancesors
  until we get to the top window object. This list is what we attach scroll listeners
  to, because if any of these parent elements scroll, we'll need to re-calculate the
  reference element's position.
  */

  function listScrollParents(element, list) {
    var _element$ownerDocumen;

    if (list === void 0) {
      list = [];
    }

    var scrollParent = getScrollParent(element);
    var isBody = scrollParent === ((_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body);
    var win = getWindow(scrollParent);
    var target = isBody ? [win].concat(win.visualViewport || [], isScrollParent(scrollParent) ? scrollParent : []) : scrollParent;
    var updatedList = list.concat(target);
    return isBody ? updatedList : // $FlowFixMe[incompatible-call]: isBody tells us target will be an HTMLElement here
    updatedList.concat(listScrollParents(getParentNode(target)));
  }

  function rectToClientRect(rect) {
    return Object.assign({}, rect, {
      left: rect.x,
      top: rect.y,
      right: rect.x + rect.width,
      bottom: rect.y + rect.height
    });
  }

  function getInnerBoundingClientRect(element, strategy) {
    var rect = getBoundingClientRect(element, false, strategy === 'fixed');
    rect.top = rect.top + element.clientTop;
    rect.left = rect.left + element.clientLeft;
    rect.bottom = rect.top + element.clientHeight;
    rect.right = rect.left + element.clientWidth;
    rect.width = element.clientWidth;
    rect.height = element.clientHeight;
    rect.x = rect.left;
    rect.y = rect.top;
    return rect;
  }

  function getClientRectFromMixedType(element, clippingParent, strategy) {
    return clippingParent === viewport ? rectToClientRect(getViewportRect(element, strategy)) : isElement(clippingParent) ? getInnerBoundingClientRect(clippingParent, strategy) : rectToClientRect(getDocumentRect(getDocumentElement(element)));
  } // A "clipping parent" is an overflowable container with the characteristic of
  // clipping (or hiding) overflowing elements with a position different from
  // `initial`


  function getClippingParents(element) {
    var clippingParents = listScrollParents(getParentNode(element));
    var canEscapeClipping = ['absolute', 'fixed'].indexOf(getComputedStyle(element).position) >= 0;
    var clipperElement = canEscapeClipping && isHTMLElement$1(element) ? getOffsetParent(element) : element;

    if (!isElement(clipperElement)) {
      return [];
    } // $FlowFixMe[incompatible-return]: https://github.com/facebook/flow/issues/1414


    return clippingParents.filter(function (clippingParent) {
      return isElement(clippingParent) && contains(clippingParent, clipperElement) && getNodeName(clippingParent) !== 'body';
    });
  } // Gets the maximum area that the element is visible in due to any number of
  // clipping parents


  function getClippingRect(element, boundary, rootBoundary, strategy) {
    var mainClippingParents = boundary === 'clippingParents' ? getClippingParents(element) : [].concat(boundary);
    var clippingParents = [].concat(mainClippingParents, [rootBoundary]);
    var firstClippingParent = clippingParents[0];
    var clippingRect = clippingParents.reduce(function (accRect, clippingParent) {
      var rect = getClientRectFromMixedType(element, clippingParent, strategy);
      accRect.top = max(rect.top, accRect.top);
      accRect.right = min(rect.right, accRect.right);
      accRect.bottom = min(rect.bottom, accRect.bottom);
      accRect.left = max(rect.left, accRect.left);
      return accRect;
    }, getClientRectFromMixedType(element, firstClippingParent, strategy));
    clippingRect.width = clippingRect.right - clippingRect.left;
    clippingRect.height = clippingRect.bottom - clippingRect.top;
    clippingRect.x = clippingRect.left;
    clippingRect.y = clippingRect.top;
    return clippingRect;
  }

  function computeOffsets(_ref) {
    var reference = _ref.reference,
        element = _ref.element,
        placement = _ref.placement;
    var basePlacement = placement ? getBasePlacement(placement) : null;
    var variation = placement ? getVariation(placement) : null;
    var commonX = reference.x + reference.width / 2 - element.width / 2;
    var commonY = reference.y + reference.height / 2 - element.height / 2;
    var offsets;

    switch (basePlacement) {
      case top:
        offsets = {
          x: commonX,
          y: reference.y - element.height
        };
        break;

      case bottom:
        offsets = {
          x: commonX,
          y: reference.y + reference.height
        };
        break;

      case right:
        offsets = {
          x: reference.x + reference.width,
          y: commonY
        };
        break;

      case left:
        offsets = {
          x: reference.x - element.width,
          y: commonY
        };
        break;

      default:
        offsets = {
          x: reference.x,
          y: reference.y
        };
    }

    var mainAxis = basePlacement ? getMainAxisFromPlacement(basePlacement) : null;

    if (mainAxis != null) {
      var len = mainAxis === 'y' ? 'height' : 'width';

      switch (variation) {
        case start:
          offsets[mainAxis] = offsets[mainAxis] - (reference[len] / 2 - element[len] / 2);
          break;

        case end:
          offsets[mainAxis] = offsets[mainAxis] + (reference[len] / 2 - element[len] / 2);
          break;
      }
    }

    return offsets;
  }

  function detectOverflow(state, options) {
    if (options === void 0) {
      options = {};
    }

    var _options = options,
        _options$placement = _options.placement,
        placement = _options$placement === void 0 ? state.placement : _options$placement,
        _options$strategy = _options.strategy,
        strategy = _options$strategy === void 0 ? state.strategy : _options$strategy,
        _options$boundary = _options.boundary,
        boundary = _options$boundary === void 0 ? clippingParents : _options$boundary,
        _options$rootBoundary = _options.rootBoundary,
        rootBoundary = _options$rootBoundary === void 0 ? viewport : _options$rootBoundary,
        _options$elementConte = _options.elementContext,
        elementContext = _options$elementConte === void 0 ? popper : _options$elementConte,
        _options$altBoundary = _options.altBoundary,
        altBoundary = _options$altBoundary === void 0 ? false : _options$altBoundary,
        _options$padding = _options.padding,
        padding = _options$padding === void 0 ? 0 : _options$padding;
    var paddingObject = mergePaddingObject(typeof padding !== 'number' ? padding : expandToHashMap(padding, basePlacements));
    var altContext = elementContext === popper ? reference : popper;
    var popperRect = state.rects.popper;
    var element = state.elements[altBoundary ? altContext : elementContext];
    var clippingClientRect = getClippingRect(isElement(element) ? element : element.contextElement || getDocumentElement(state.elements.popper), boundary, rootBoundary, strategy);
    var referenceClientRect = getBoundingClientRect(state.elements.reference);
    var popperOffsets = computeOffsets({
      reference: referenceClientRect,
      element: popperRect,
      strategy: 'absolute',
      placement: placement
    });
    var popperClientRect = rectToClientRect(Object.assign({}, popperRect, popperOffsets));
    var elementClientRect = elementContext === popper ? popperClientRect : referenceClientRect; // positive = overflowing the clipping rect
    // 0 or negative = within the clipping rect

    var overflowOffsets = {
      top: clippingClientRect.top - elementClientRect.top + paddingObject.top,
      bottom: elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom,
      left: clippingClientRect.left - elementClientRect.left + paddingObject.left,
      right: elementClientRect.right - clippingClientRect.right + paddingObject.right
    };
    var offsetData = state.modifiersData.offset; // Offsets can be applied only to the popper element

    if (elementContext === popper && offsetData) {
      var offset = offsetData[placement];
      Object.keys(overflowOffsets).forEach(function (key) {
        var multiply = [right, bottom].indexOf(key) >= 0 ? 1 : -1;
        var axis = [top, bottom].indexOf(key) >= 0 ? 'y' : 'x';
        overflowOffsets[key] += offset[axis] * multiply;
      });
    }

    return overflowOffsets;
  }

  function computeAutoPlacement(state, options) {
    if (options === void 0) {
      options = {};
    }

    var _options = options,
        placement = _options.placement,
        boundary = _options.boundary,
        rootBoundary = _options.rootBoundary,
        padding = _options.padding,
        flipVariations = _options.flipVariations,
        _options$allowedAutoP = _options.allowedAutoPlacements,
        allowedAutoPlacements = _options$allowedAutoP === void 0 ? placements : _options$allowedAutoP;
    var variation = getVariation(placement);
    var placements$1 = variation ? flipVariations ? variationPlacements : variationPlacements.filter(function (placement) {
      return getVariation(placement) === variation;
    }) : basePlacements;
    var allowedPlacements = placements$1.filter(function (placement) {
      return allowedAutoPlacements.indexOf(placement) >= 0;
    });

    if (allowedPlacements.length === 0) {
      allowedPlacements = placements$1;
    } // $FlowFixMe[incompatible-type]: Flow seems to have problems with two array unions...


    var overflows = allowedPlacements.reduce(function (acc, placement) {
      acc[placement] = detectOverflow(state, {
        placement: placement,
        boundary: boundary,
        rootBoundary: rootBoundary,
        padding: padding
      })[getBasePlacement(placement)];
      return acc;
    }, {});
    return Object.keys(overflows).sort(function (a, b) {
      return overflows[a] - overflows[b];
    });
  }

  function getExpandedFallbackPlacements(placement) {
    if (getBasePlacement(placement) === auto) {
      return [];
    }

    var oppositePlacement = getOppositePlacement(placement);
    return [getOppositeVariationPlacement(placement), oppositePlacement, getOppositeVariationPlacement(oppositePlacement)];
  }

  function flip(_ref) {
    var state = _ref.state,
        options = _ref.options,
        name = _ref.name;

    if (state.modifiersData[name]._skip) {
      return;
    }

    var _options$mainAxis = options.mainAxis,
        checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
        _options$altAxis = options.altAxis,
        checkAltAxis = _options$altAxis === void 0 ? true : _options$altAxis,
        specifiedFallbackPlacements = options.fallbackPlacements,
        padding = options.padding,
        boundary = options.boundary,
        rootBoundary = options.rootBoundary,
        altBoundary = options.altBoundary,
        _options$flipVariatio = options.flipVariations,
        flipVariations = _options$flipVariatio === void 0 ? true : _options$flipVariatio,
        allowedAutoPlacements = options.allowedAutoPlacements;
    var preferredPlacement = state.options.placement;
    var basePlacement = getBasePlacement(preferredPlacement);
    var isBasePlacement = basePlacement === preferredPlacement;
    var fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipVariations ? [getOppositePlacement(preferredPlacement)] : getExpandedFallbackPlacements(preferredPlacement));
    var placements = [preferredPlacement].concat(fallbackPlacements).reduce(function (acc, placement) {
      return acc.concat(getBasePlacement(placement) === auto ? computeAutoPlacement(state, {
        placement: placement,
        boundary: boundary,
        rootBoundary: rootBoundary,
        padding: padding,
        flipVariations: flipVariations,
        allowedAutoPlacements: allowedAutoPlacements
      }) : placement);
    }, []);
    var referenceRect = state.rects.reference;
    var popperRect = state.rects.popper;
    var checksMap = new Map();
    var makeFallbackChecks = true;
    var firstFittingPlacement = placements[0];

    for (var i = 0; i < placements.length; i++) {
      var placement = placements[i];

      var _basePlacement = getBasePlacement(placement);

      var isStartVariation = getVariation(placement) === start;
      var isVertical = [top, bottom].indexOf(_basePlacement) >= 0;
      var len = isVertical ? 'width' : 'height';
      var overflow = detectOverflow(state, {
        placement: placement,
        boundary: boundary,
        rootBoundary: rootBoundary,
        altBoundary: altBoundary,
        padding: padding
      });
      var mainVariationSide = isVertical ? isStartVariation ? right : left : isStartVariation ? bottom : top;

      if (referenceRect[len] > popperRect[len]) {
        mainVariationSide = getOppositePlacement(mainVariationSide);
      }

      var altVariationSide = getOppositePlacement(mainVariationSide);
      var checks = [];

      if (checkMainAxis) {
        checks.push(overflow[_basePlacement] <= 0);
      }

      if (checkAltAxis) {
        checks.push(overflow[mainVariationSide] <= 0, overflow[altVariationSide] <= 0);
      }

      if (checks.every(function (check) {
        return check;
      })) {
        firstFittingPlacement = placement;
        makeFallbackChecks = false;
        break;
      }

      checksMap.set(placement, checks);
    }

    if (makeFallbackChecks) {
      // `2` may be desired in some cases – research later
      var numberOfChecks = flipVariations ? 3 : 1;

      var _loop = function _loop(_i) {
        var fittingPlacement = placements.find(function (placement) {
          var checks = checksMap.get(placement);

          if (checks) {
            return checks.slice(0, _i).every(function (check) {
              return check;
            });
          }
        });

        if (fittingPlacement) {
          firstFittingPlacement = fittingPlacement;
          return "break";
        }
      };

      for (var _i = numberOfChecks; _i > 0; _i--) {
        var _ret = _loop(_i);

        if (_ret === "break") break;
      }
    }

    if (state.placement !== firstFittingPlacement) {
      state.modifiersData[name]._skip = true;
      state.placement = firstFittingPlacement;
      state.reset = true;
    }
  } // eslint-disable-next-line import/no-unused-modules


  var flip$1 = {
    name: 'flip',
    enabled: true,
    phase: 'main',
    fn: flip,
    requiresIfExists: ['offset'],
    data: {
      _skip: false
    }
  };

  function getSideOffsets(overflow, rect, preventedOffsets) {
    if (preventedOffsets === void 0) {
      preventedOffsets = {
        x: 0,
        y: 0
      };
    }

    return {
      top: overflow.top - rect.height - preventedOffsets.y,
      right: overflow.right - rect.width + preventedOffsets.x,
      bottom: overflow.bottom - rect.height + preventedOffsets.y,
      left: overflow.left - rect.width - preventedOffsets.x
    };
  }

  function isAnySideFullyClipped(overflow) {
    return [top, right, bottom, left].some(function (side) {
      return overflow[side] >= 0;
    });
  }

  function hide(_ref) {
    var state = _ref.state,
        name = _ref.name;
    var referenceRect = state.rects.reference;
    var popperRect = state.rects.popper;
    var preventedOffsets = state.modifiersData.preventOverflow;
    var referenceOverflow = detectOverflow(state, {
      elementContext: 'reference'
    });
    var popperAltOverflow = detectOverflow(state, {
      altBoundary: true
    });
    var referenceClippingOffsets = getSideOffsets(referenceOverflow, referenceRect);
    var popperEscapeOffsets = getSideOffsets(popperAltOverflow, popperRect, preventedOffsets);
    var isReferenceHidden = isAnySideFullyClipped(referenceClippingOffsets);
    var hasPopperEscaped = isAnySideFullyClipped(popperEscapeOffsets);
    state.modifiersData[name] = {
      referenceClippingOffsets: referenceClippingOffsets,
      popperEscapeOffsets: popperEscapeOffsets,
      isReferenceHidden: isReferenceHidden,
      hasPopperEscaped: hasPopperEscaped
    };
    state.attributes.popper = Object.assign({}, state.attributes.popper, {
      'data-popper-reference-hidden': isReferenceHidden,
      'data-popper-escaped': hasPopperEscaped
    });
  } // eslint-disable-next-line import/no-unused-modules


  var hide$1 = {
    name: 'hide',
    enabled: true,
    phase: 'main',
    requiresIfExists: ['preventOverflow'],
    fn: hide
  };

  function distanceAndSkiddingToXY(placement, rects, offset) {
    var basePlacement = getBasePlacement(placement);
    var invertDistance = [left, top].indexOf(basePlacement) >= 0 ? -1 : 1;

    var _ref = typeof offset === 'function' ? offset(Object.assign({}, rects, {
      placement: placement
    })) : offset,
        skidding = _ref[0],
        distance = _ref[1];

    skidding = skidding || 0;
    distance = (distance || 0) * invertDistance;
    return [left, right].indexOf(basePlacement) >= 0 ? {
      x: distance,
      y: skidding
    } : {
      x: skidding,
      y: distance
    };
  }

  function offset(_ref2) {
    var state = _ref2.state,
        options = _ref2.options,
        name = _ref2.name;
    var _options$offset = options.offset,
        offset = _options$offset === void 0 ? [0, 0] : _options$offset;
    var data = placements.reduce(function (acc, placement) {
      acc[placement] = distanceAndSkiddingToXY(placement, state.rects, offset);
      return acc;
    }, {});
    var _data$state$placement = data[state.placement],
        x = _data$state$placement.x,
        y = _data$state$placement.y;

    if (state.modifiersData.popperOffsets != null) {
      state.modifiersData.popperOffsets.x += x;
      state.modifiersData.popperOffsets.y += y;
    }

    state.modifiersData[name] = data;
  } // eslint-disable-next-line import/no-unused-modules


  var offset$1 = {
    name: 'offset',
    enabled: true,
    phase: 'main',
    requires: ['popperOffsets'],
    fn: offset
  };

  function popperOffsets(_ref) {
    var state = _ref.state,
        name = _ref.name;
    // Offsets are the actual position the popper needs to have to be
    // properly positioned near its reference element
    // This is the most basic placement, and will be adjusted by
    // the modifiers in the next step
    state.modifiersData[name] = computeOffsets({
      reference: state.rects.reference,
      element: state.rects.popper,
      strategy: 'absolute',
      placement: state.placement
    });
  } // eslint-disable-next-line import/no-unused-modules


  var popperOffsets$1 = {
    name: 'popperOffsets',
    enabled: true,
    phase: 'read',
    fn: popperOffsets,
    data: {}
  };

  function getAltAxis(axis) {
    return axis === 'x' ? 'y' : 'x';
  }

  function preventOverflow(_ref) {
    var state = _ref.state,
        options = _ref.options,
        name = _ref.name;
    var _options$mainAxis = options.mainAxis,
        checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
        _options$altAxis = options.altAxis,
        checkAltAxis = _options$altAxis === void 0 ? false : _options$altAxis,
        boundary = options.boundary,
        rootBoundary = options.rootBoundary,
        altBoundary = options.altBoundary,
        padding = options.padding,
        _options$tether = options.tether,
        tether = _options$tether === void 0 ? true : _options$tether,
        _options$tetherOffset = options.tetherOffset,
        tetherOffset = _options$tetherOffset === void 0 ? 0 : _options$tetherOffset;
    var overflow = detectOverflow(state, {
      boundary: boundary,
      rootBoundary: rootBoundary,
      padding: padding,
      altBoundary: altBoundary
    });
    var basePlacement = getBasePlacement(state.placement);
    var variation = getVariation(state.placement);
    var isBasePlacement = !variation;
    var mainAxis = getMainAxisFromPlacement(basePlacement);
    var altAxis = getAltAxis(mainAxis);
    var popperOffsets = state.modifiersData.popperOffsets;
    var referenceRect = state.rects.reference;
    var popperRect = state.rects.popper;
    var tetherOffsetValue = typeof tetherOffset === 'function' ? tetherOffset(Object.assign({}, state.rects, {
      placement: state.placement
    })) : tetherOffset;
    var normalizedTetherOffsetValue = typeof tetherOffsetValue === 'number' ? {
      mainAxis: tetherOffsetValue,
      altAxis: tetherOffsetValue
    } : Object.assign({
      mainAxis: 0,
      altAxis: 0
    }, tetherOffsetValue);
    var offsetModifierState = state.modifiersData.offset ? state.modifiersData.offset[state.placement] : null;
    var data = {
      x: 0,
      y: 0
    };

    if (!popperOffsets) {
      return;
    }

    if (checkMainAxis) {
      var _offsetModifierState$;

      var mainSide = mainAxis === 'y' ? top : left;
      var altSide = mainAxis === 'y' ? bottom : right;
      var len = mainAxis === 'y' ? 'height' : 'width';
      var offset = popperOffsets[mainAxis];
      var min$1 = offset + overflow[mainSide];
      var max$1 = offset - overflow[altSide];
      var additive = tether ? -popperRect[len] / 2 : 0;
      var minLen = variation === start ? referenceRect[len] : popperRect[len];
      var maxLen = variation === start ? -popperRect[len] : -referenceRect[len]; // We need to include the arrow in the calculation so the arrow doesn't go
      // outside the reference bounds

      var arrowElement = state.elements.arrow;
      var arrowRect = tether && arrowElement ? getLayoutRect(arrowElement) : {
        width: 0,
        height: 0
      };
      var arrowPaddingObject = state.modifiersData['arrow#persistent'] ? state.modifiersData['arrow#persistent'].padding : getFreshSideObject();
      var arrowPaddingMin = arrowPaddingObject[mainSide];
      var arrowPaddingMax = arrowPaddingObject[altSide]; // If the reference length is smaller than the arrow length, we don't want
      // to include its full size in the calculation. If the reference is small
      // and near the edge of a boundary, the popper can overflow even if the
      // reference is not overflowing as well (e.g. virtual elements with no
      // width or height)

      var arrowLen = within(0, referenceRect[len], arrowRect[len]);
      var minOffset = isBasePlacement ? referenceRect[len] / 2 - additive - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis : minLen - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis;
      var maxOffset = isBasePlacement ? -referenceRect[len] / 2 + additive + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis : maxLen + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis;
      var arrowOffsetParent = state.elements.arrow && getOffsetParent(state.elements.arrow);
      var clientOffset = arrowOffsetParent ? mainAxis === 'y' ? arrowOffsetParent.clientTop || 0 : arrowOffsetParent.clientLeft || 0 : 0;
      var offsetModifierValue = (_offsetModifierState$ = offsetModifierState == null ? void 0 : offsetModifierState[mainAxis]) != null ? _offsetModifierState$ : 0;
      var tetherMin = offset + minOffset - offsetModifierValue - clientOffset;
      var tetherMax = offset + maxOffset - offsetModifierValue;
      var preventedOffset = within(tether ? min(min$1, tetherMin) : min$1, offset, tether ? max(max$1, tetherMax) : max$1);
      popperOffsets[mainAxis] = preventedOffset;
      data[mainAxis] = preventedOffset - offset;
    }

    if (checkAltAxis) {
      var _offsetModifierState$2;

      var _mainSide = mainAxis === 'x' ? top : left;

      var _altSide = mainAxis === 'x' ? bottom : right;

      var _offset = popperOffsets[altAxis];

      var _len = altAxis === 'y' ? 'height' : 'width';

      var _min = _offset + overflow[_mainSide];

      var _max = _offset - overflow[_altSide];

      var isOriginSide = [top, left].indexOf(basePlacement) !== -1;

      var _offsetModifierValue = (_offsetModifierState$2 = offsetModifierState == null ? void 0 : offsetModifierState[altAxis]) != null ? _offsetModifierState$2 : 0;

      var _tetherMin = isOriginSide ? _min : _offset - referenceRect[_len] - popperRect[_len] - _offsetModifierValue + normalizedTetherOffsetValue.altAxis;

      var _tetherMax = isOriginSide ? _offset + referenceRect[_len] + popperRect[_len] - _offsetModifierValue - normalizedTetherOffsetValue.altAxis : _max;

      var _preventedOffset = tether && isOriginSide ? withinMaxClamp(_tetherMin, _offset, _tetherMax) : within(tether ? _tetherMin : _min, _offset, tether ? _tetherMax : _max);

      popperOffsets[altAxis] = _preventedOffset;
      data[altAxis] = _preventedOffset - _offset;
    }

    state.modifiersData[name] = data;
  } // eslint-disable-next-line import/no-unused-modules


  var preventOverflow$1 = {
    name: 'preventOverflow',
    enabled: true,
    phase: 'main',
    fn: preventOverflow,
    requiresIfExists: ['offset']
  };

  function getHTMLElementScroll(element) {
    return {
      scrollLeft: element.scrollLeft,
      scrollTop: element.scrollTop
    };
  }

  function getNodeScroll(node) {
    if (node === getWindow(node) || !isHTMLElement$1(node)) {
      return getWindowScroll(node);
    } else {
      return getHTMLElementScroll(node);
    }
  }

  function isElementScaled(element) {
    var rect = element.getBoundingClientRect();
    var scaleX = round$1(rect.width) / element.offsetWidth || 1;
    var scaleY = round$1(rect.height) / element.offsetHeight || 1;
    return scaleX !== 1 || scaleY !== 1;
  } // Returns the composite rect of an element relative to its offsetParent.
  // Composite means it takes into account transforms as well as layout.


  function getCompositeRect(elementOrVirtualElement, offsetParent, isFixed) {
    if (isFixed === void 0) {
      isFixed = false;
    }

    var isOffsetParentAnElement = isHTMLElement$1(offsetParent);
    var offsetParentIsScaled = isHTMLElement$1(offsetParent) && isElementScaled(offsetParent);
    var documentElement = getDocumentElement(offsetParent);
    var rect = getBoundingClientRect(elementOrVirtualElement, offsetParentIsScaled, isFixed);
    var scroll = {
      scrollLeft: 0,
      scrollTop: 0
    };
    var offsets = {
      x: 0,
      y: 0
    };

    if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
      if (getNodeName(offsetParent) !== 'body' || // https://github.com/popperjs/popper-core/issues/1078
      isScrollParent(documentElement)) {
        scroll = getNodeScroll(offsetParent);
      }

      if (isHTMLElement$1(offsetParent)) {
        offsets = getBoundingClientRect(offsetParent, true);
        offsets.x += offsetParent.clientLeft;
        offsets.y += offsetParent.clientTop;
      } else if (documentElement) {
        offsets.x = getWindowScrollBarX(documentElement);
      }
    }

    return {
      x: rect.left + scroll.scrollLeft - offsets.x,
      y: rect.top + scroll.scrollTop - offsets.y,
      width: rect.width,
      height: rect.height
    };
  }

  function order(modifiers) {
    var map = new Map();
    var visited = new Set();
    var result = [];
    modifiers.forEach(function (modifier) {
      map.set(modifier.name, modifier);
    }); // On visiting object, check for its dependencies and visit them recursively

    function sort(modifier) {
      visited.add(modifier.name);
      var requires = [].concat(modifier.requires || [], modifier.requiresIfExists || []);
      requires.forEach(function (dep) {
        if (!visited.has(dep)) {
          var depModifier = map.get(dep);

          if (depModifier) {
            sort(depModifier);
          }
        }
      });
      result.push(modifier);
    }

    modifiers.forEach(function (modifier) {
      if (!visited.has(modifier.name)) {
        // check for visited object
        sort(modifier);
      }
    });
    return result;
  }

  function orderModifiers(modifiers) {
    // order based on dependencies
    var orderedModifiers = order(modifiers); // order based on phase

    return modifierPhases.reduce(function (acc, phase) {
      return acc.concat(orderedModifiers.filter(function (modifier) {
        return modifier.phase === phase;
      }));
    }, []);
  }

  function debounce(fn) {
    var pending;
    return function () {
      if (!pending) {
        pending = new Promise(function (resolve) {
          Promise.resolve().then(function () {
            pending = undefined;
            resolve(fn());
          });
        });
      }

      return pending;
    };
  }

  function mergeByName(modifiers) {
    var merged = modifiers.reduce(function (merged, current) {
      var existing = merged[current.name];
      merged[current.name] = existing ? Object.assign({}, existing, current, {
        options: Object.assign({}, existing.options, current.options),
        data: Object.assign({}, existing.data, current.data)
      }) : current;
      return merged;
    }, {}); // IE11 does not support Object.values

    return Object.keys(merged).map(function (key) {
      return merged[key];
    });
  }

  var DEFAULT_OPTIONS = {
    placement: 'bottom',
    modifiers: [],
    strategy: 'absolute'
  };

  function areValidElements() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return !args.some(function (element) {
      return !(element && typeof element.getBoundingClientRect === 'function');
    });
  }

  function popperGenerator(generatorOptions) {
    if (generatorOptions === void 0) {
      generatorOptions = {};
    }

    var _generatorOptions = generatorOptions,
        _generatorOptions$def = _generatorOptions.defaultModifiers,
        defaultModifiers = _generatorOptions$def === void 0 ? [] : _generatorOptions$def,
        _generatorOptions$def2 = _generatorOptions.defaultOptions,
        defaultOptions = _generatorOptions$def2 === void 0 ? DEFAULT_OPTIONS : _generatorOptions$def2;
    return function createPopper(reference, popper, options) {
      if (options === void 0) {
        options = defaultOptions;
      }

      var state = {
        placement: 'bottom',
        orderedModifiers: [],
        options: Object.assign({}, DEFAULT_OPTIONS, defaultOptions),
        modifiersData: {},
        elements: {
          reference: reference,
          popper: popper
        },
        attributes: {},
        styles: {}
      };
      var effectCleanupFns = [];
      var isDestroyed = false;
      var instance = {
        state: state,
        setOptions: function setOptions(setOptionsAction) {
          var options = typeof setOptionsAction === 'function' ? setOptionsAction(state.options) : setOptionsAction;
          cleanupModifierEffects();
          state.options = Object.assign({}, defaultOptions, state.options, options);
          state.scrollParents = {
            reference: isElement(reference) ? listScrollParents(reference) : reference.contextElement ? listScrollParents(reference.contextElement) : [],
            popper: listScrollParents(popper)
          }; // Orders the modifiers based on their dependencies and `phase`
          // properties

          var orderedModifiers = orderModifiers(mergeByName([].concat(defaultModifiers, state.options.modifiers))); // Strip out disabled modifiers

          state.orderedModifiers = orderedModifiers.filter(function (m) {
            return m.enabled;
          });
          runModifierEffects();
          return instance.update();
        },
        // Sync update – it will always be executed, even if not necessary. This
        // is useful for low frequency updates where sync behavior simplifies the
        // logic.
        // For high frequency updates (e.g. `resize` and `scroll` events), always
        // prefer the async Popper#update method
        forceUpdate: function forceUpdate() {
          if (isDestroyed) {
            return;
          }

          var _state$elements = state.elements,
              reference = _state$elements.reference,
              popper = _state$elements.popper; // Don't proceed if `reference` or `popper` are not valid elements
          // anymore

          if (!areValidElements(reference, popper)) {
            return;
          } // Store the reference and popper rects to be read by modifiers


          state.rects = {
            reference: getCompositeRect(reference, getOffsetParent(popper), state.options.strategy === 'fixed'),
            popper: getLayoutRect(popper)
          }; // Modifiers have the ability to reset the current update cycle. The
          // most common use case for this is the `flip` modifier changing the
          // placement, which then needs to re-run all the modifiers, because the
          // logic was previously ran for the previous placement and is therefore
          // stale/incorrect

          state.reset = false;
          state.placement = state.options.placement; // On each update cycle, the `modifiersData` property for each modifier
          // is filled with the initial data specified by the modifier. This means
          // it doesn't persist and is fresh on each update.
          // To ensure persistent data, use `${name}#persistent`

          state.orderedModifiers.forEach(function (modifier) {
            return state.modifiersData[modifier.name] = Object.assign({}, modifier.data);
          });

          for (var index = 0; index < state.orderedModifiers.length; index++) {
            if (state.reset === true) {
              state.reset = false;
              index = -1;
              continue;
            }

            var _state$orderedModifie = state.orderedModifiers[index],
                fn = _state$orderedModifie.fn,
                _state$orderedModifie2 = _state$orderedModifie.options,
                _options = _state$orderedModifie2 === void 0 ? {} : _state$orderedModifie2,
                name = _state$orderedModifie.name;

            if (typeof fn === 'function') {
              state = fn({
                state: state,
                options: _options,
                name: name,
                instance: instance
              }) || state;
            }
          }
        },
        // Async and optimistically optimized update – it will not be executed if
        // not necessary (debounced to run at most once-per-tick)
        update: debounce(function () {
          return new Promise(function (resolve) {
            instance.forceUpdate();
            resolve(state);
          });
        }),
        destroy: function destroy() {
          cleanupModifierEffects();
          isDestroyed = true;
        }
      };

      if (!areValidElements(reference, popper)) {
        return instance;
      }

      instance.setOptions(options).then(function (state) {
        if (!isDestroyed && options.onFirstUpdate) {
          options.onFirstUpdate(state);
        }
      }); // Modifiers have the ability to execute arbitrary code before the first
      // update cycle runs. They will be executed in the same order as the update
      // cycle. This is useful when a modifier adds some persistent data that
      // other modifiers need to use, but the modifier is run after the dependent
      // one.

      function runModifierEffects() {
        state.orderedModifiers.forEach(function (_ref) {
          var name = _ref.name,
              _ref$options = _ref.options,
              options = _ref$options === void 0 ? {} : _ref$options,
              effect = _ref.effect;

          if (typeof effect === 'function') {
            var cleanupFn = effect({
              state: state,
              name: name,
              instance: instance,
              options: options
            });

            var noopFn = function noopFn() {};

            effectCleanupFns.push(cleanupFn || noopFn);
          }
        });
      }

      function cleanupModifierEffects() {
        effectCleanupFns.forEach(function (fn) {
          return fn();
        });
        effectCleanupFns = [];
      }

      return instance;
    };
  }

  var defaultModifiers = [eventListeners, popperOffsets$1, computeStyles$1, applyStyles$1, offset$1, flip$1, preventOverflow$1, arrow$1, hide$1];
  var createPopper = /*#__PURE__*/popperGenerator({
    defaultModifiers: defaultModifiers
  }); // eslint-disable-next-line import/no-unused-modules

  var COMPONENT_NAME = 'Popper';
  function getPopperUtilityClass(slot) {
    return generateUtilityClass(COMPONENT_NAME, slot);
  }
  generateUtilityClasses(COMPONENT_NAME, ['root']);

  function flipPlacement(placement, direction) {
    if (direction === 'ltr') {
      return placement;
    }
    switch (placement) {
      case 'bottom-end':
        return 'bottom-start';
      case 'bottom-start':
        return 'bottom-end';
      case 'top-end':
        return 'top-start';
      case 'top-start':
        return 'top-end';
      default:
        return placement;
    }
  }
  function resolveAnchorEl$1(anchorEl) {
    return typeof anchorEl === 'function' ? anchorEl() : anchorEl;
  }
  function isHTMLElement(element) {
    return element.nodeType !== undefined;
  }
  function isVirtualElement(element) {
    return !isHTMLElement(element);
  }
  var useUtilityClasses$1B = function useUtilityClasses() {
    var slots = {
      root: ['root']
    };
    return composeClasses(slots, useClassNamesOverride(getPopperUtilityClass));
  };
  var defaultPopperOptions = {};
  var PopperTooltip = /*#__PURE__*/React__namespace.forwardRef(function PopperTooltip(props, forwardedRef) {
    var _slots$root;
    var anchorEl = props.anchorEl,
      children = props.children,
      direction = props.direction,
      disablePortal = props.disablePortal,
      modifiers = props.modifiers,
      open = props.open,
      initialPlacement = props.placement,
      popperOptions = props.popperOptions,
      popperRefProp = props.popperRef,
      _props$slotProps = props.slotProps,
      slotProps = _props$slotProps === void 0 ? {} : _props$slotProps,
      _props$slots = props.slots,
      slots = _props$slots === void 0 ? {} : _props$slots,
      TransitionProps = props.TransitionProps;
      props.ownerState;
      var other = _objectWithoutProperties(props, ["anchorEl", "children", "direction", "disablePortal", "modifiers", "open", "placement", "popperOptions", "popperRef", "slotProps", "slots", "TransitionProps", "ownerState"]);
    var tooltipRef = React__namespace.useRef(null);
    var ownRef = useForkRef(tooltipRef, forwardedRef);
    var popperRef = React__namespace.useRef(null);
    var handlePopperRef = useForkRef(popperRef, popperRefProp);
    var handlePopperRefRef = React__namespace.useRef(handlePopperRef);
    useEnhancedEffect$1(function () {
      handlePopperRefRef.current = handlePopperRef;
    }, [handlePopperRef]);
    React__namespace.useImperativeHandle(popperRefProp, function () {
      return popperRef.current;
    }, []);
    var rtlPlacement = flipPlacement(initialPlacement, direction);
    /**
     * placement initialized from prop but can change during lifetime if modifiers.flip.
     * modifiers.flip is essentially a flip for controlled/uncontrolled behavior
     */
    var _React$useState = React__namespace.useState(rtlPlacement),
      placement = _React$useState[0],
      setPlacement = _React$useState[1];
    var _React$useState2 = React__namespace.useState(resolveAnchorEl$1(anchorEl)),
      resolvedAnchorElement = _React$useState2[0],
      setResolvedAnchorElement = _React$useState2[1];
    React__namespace.useEffect(function () {
      if (popperRef.current) {
        popperRef.current.forceUpdate();
      }
    });
    React__namespace.useEffect(function () {
      if (anchorEl) {
        setResolvedAnchorElement(resolveAnchorEl$1(anchorEl));
      }
    }, [anchorEl]);
    useEnhancedEffect$1(function () {
      if (!resolvedAnchorElement || !open) {
        return undefined;
      }
      var handlePopperUpdate = function handlePopperUpdate(data) {
        setPlacement(data.placement);
      };
      {
        if (resolvedAnchorElement && isHTMLElement(resolvedAnchorElement) && resolvedAnchorElement.nodeType === 1) {
          var box = resolvedAnchorElement.getBoundingClientRect();
          if (box.top === 0 && box.left === 0 && box.right === 0 && box.bottom === 0) {
            console.warn(['MUI: The `anchorEl` prop provided to the component is invalid.', 'The anchor element should be part of the document layout.', "Make sure the element is present in the document or that it's not display none."].join('\n'));
          }
        }
      }
      var popperModifiers = [{
        name: 'preventOverflow',
        options: {
          altBoundary: disablePortal
        }
      }, {
        name: 'flip',
        options: {
          altBoundary: disablePortal
        }
      }, {
        name: 'onUpdate',
        enabled: true,
        phase: 'afterWrite',
        fn: function fn(_ref) {
          var state = _ref.state;
          handlePopperUpdate(state);
        }
      }];
      if (modifiers != null) {
        popperModifiers = popperModifiers.concat(modifiers);
      }
      if (popperOptions && popperOptions.modifiers != null) {
        popperModifiers = popperModifiers.concat(popperOptions.modifiers);
      }
      var popper = createPopper(resolvedAnchorElement, tooltipRef.current, _extends({
        placement: rtlPlacement
      }, popperOptions, {
        modifiers: popperModifiers
      }));
      handlePopperRefRef.current(popper);
      return function () {
        popper.destroy();
        handlePopperRefRef.current(null);
      };
    }, [resolvedAnchorElement, disablePortal, modifiers, open, popperOptions, rtlPlacement]);
    var childProps = {
      placement: placement
    };
    if (TransitionProps !== null) {
      childProps.TransitionProps = TransitionProps;
    }
    var classes = useUtilityClasses$1B();
    var Root = (_slots$root = slots.root) != null ? _slots$root : 'div';
    var rootProps = useSlotProps({
      elementType: Root,
      externalSlotProps: slotProps.root,
      externalForwardedProps: other,
      additionalProps: {
        role: 'tooltip',
        ref: ownRef
      },
      ownerState: props,
      className: classes.root
    });
    return /*#__PURE__*/jsxRuntime_1(Root, _extends({}, rootProps, {
      children: typeof children === 'function' ? children(childProps) : children
    }));
  });

  /**
   * Poppers rely on the 3rd party library [Popper.js](https://popper.js.org/docs/v2/) for positioning.
   *
   * Demos:
   *
   * - [Popper](https://mui.com/base-ui/react-popper/)
   *
   * API:
   *
   * - [Popper API](https://mui.com/base-ui/react-popper/components-api/#popper)
   */
  var Popper$2 = /*#__PURE__*/React__namespace.forwardRef(function Popper(props, forwardedRef) {
    var anchorEl = props.anchorEl,
      children = props.children,
      containerProp = props.container,
      _props$direction = props.direction,
      direction = _props$direction === void 0 ? 'ltr' : _props$direction,
      _props$disablePortal = props.disablePortal,
      disablePortal = _props$disablePortal === void 0 ? false : _props$disablePortal,
      _props$keepMounted = props.keepMounted,
      keepMounted = _props$keepMounted === void 0 ? false : _props$keepMounted,
      modifiers = props.modifiers,
      open = props.open,
      _props$placement = props.placement,
      placement = _props$placement === void 0 ? 'bottom' : _props$placement,
      _props$popperOptions = props.popperOptions,
      popperOptions = _props$popperOptions === void 0 ? defaultPopperOptions : _props$popperOptions,
      popperRef = props.popperRef,
      style = props.style,
      _props$transition = props.transition,
      transition = _props$transition === void 0 ? false : _props$transition,
      _props$slotProps2 = props.slotProps,
      slotProps = _props$slotProps2 === void 0 ? {} : _props$slotProps2,
      _props$slots2 = props.slots,
      slots = _props$slots2 === void 0 ? {} : _props$slots2,
      other = _objectWithoutProperties(props, ["anchorEl", "children", "container", "direction", "disablePortal", "keepMounted", "modifiers", "open", "placement", "popperOptions", "popperRef", "style", "transition", "slotProps", "slots"]);
    var _React$useState3 = React__namespace.useState(true),
      exited = _React$useState3[0],
      setExited = _React$useState3[1];
    var handleEnter = function handleEnter() {
      setExited(false);
    };
    var handleExited = function handleExited() {
      setExited(true);
    };
    if (!keepMounted && !open && (!transition || exited)) {
      return null;
    }

    // If the container prop is provided, use that
    // If the anchorEl prop is provided, use its parent body element as the container
    // If neither are provided let the Modal take care of choosing the container
    var container;
    if (containerProp) {
      container = containerProp;
    } else if (anchorEl) {
      var resolvedAnchorEl = resolveAnchorEl$1(anchorEl);
      container = resolvedAnchorEl && isHTMLElement(resolvedAnchorEl) ? ownerDocument(resolvedAnchorEl).body : ownerDocument(null).body;
    }
    var display = !open && keepMounted && (!transition || exited) ? 'none' : undefined;
    var transitionProps = transition ? {
      "in": open,
      onEnter: handleEnter,
      onExited: handleExited
    } : undefined;
    return /*#__PURE__*/jsxRuntime_1(Portal, {
      disablePortal: disablePortal,
      container: container,
      children: /*#__PURE__*/jsxRuntime_1(PopperTooltip, _extends({
        anchorEl: anchorEl,
        direction: direction,
        disablePortal: disablePortal,
        modifiers: modifiers,
        ref: forwardedRef,
        open: transition ? !exited : open,
        placement: placement,
        popperOptions: popperOptions,
        popperRef: popperRef,
        slotProps: slotProps,
        slots: slots
      }, other, {
        style: _extends({
          // Prevents scroll issue, waiting for Popper.js to add this style once initiated.
          position: 'fixed',
          // Fix Popper.js display issue
          top: 0,
          left: 0,
          display: display
        }, style),
        TransitionProps: transitionProps,
        children: children
      }))
    });
  });
  Popper$2.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │ To update them, edit the TypeScript types and run `pnpm proptypes`. │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * An HTML element, [virtualElement](https://popper.js.org/docs/v2/virtual-elements/),
     * or a function that returns either.
     * It's used to set the position of the popper.
     * The return value will passed as the reference object of the Popper instance.
     */
    anchorEl: chainPropTypes(PropTypes.oneOfType([HTMLElementType, PropTypes.object, PropTypes.func]), function (props) {
      if (props.open) {
        var resolvedAnchorEl = resolveAnchorEl$1(props.anchorEl);
        if (resolvedAnchorEl && isHTMLElement(resolvedAnchorEl) && resolvedAnchorEl.nodeType === 1) {
          var box = resolvedAnchorEl.getBoundingClientRect();
          if (box.top === 0 && box.left === 0 && box.right === 0 && box.bottom === 0) {
            return new Error(['MUI: The `anchorEl` prop provided to the component is invalid.', 'The anchor element should be part of the document layout.', "Make sure the element is present in the document or that it's not display none."].join('\n'));
          }
        } else if (!resolvedAnchorEl || typeof resolvedAnchorEl.getBoundingClientRect !== 'function' || isVirtualElement(resolvedAnchorEl) && resolvedAnchorEl.contextElement != null && resolvedAnchorEl.contextElement.nodeType !== 1) {
          return new Error(['MUI: The `anchorEl` prop provided to the component is invalid.', 'It should be an HTML element instance or a virtualElement ', '(https://popper.js.org/docs/v2/virtual-elements/).'].join('\n'));
        }
      }
      return null;
    }),
    /**
     * Popper render function or node.
     */
    children: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.node, PropTypes.func]),
    /**
     * An HTML element or function that returns one.
     * The `container` will have the portal children appended to it.
     *
     * You can also provide a callback, which is called in a React layout effect.
     * This lets you set the container from a ref, and also makes server-side rendering possible.
     *
     * By default, it uses the body of the top-level document object,
     * so it's simply `document.body` most of the time.
     */
    container: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([HTMLElementType, PropTypes.func]),
    /**
     * Direction of the text.
     * @default 'ltr'
     */
    direction: PropTypes.oneOf(['ltr', 'rtl']),
    /**
     * The `children` will be under the DOM hierarchy of the parent component.
     * @default false
     */
    disablePortal: PropTypes.bool,
    /**
     * Always keep the children in the DOM.
     * This prop can be useful in SEO situation or
     * when you want to maximize the responsiveness of the Popper.
     * @default false
     */
    keepMounted: PropTypes.bool,
    /**
     * Popper.js is based on a "plugin-like" architecture,
     * most of its features are fully encapsulated "modifiers".
     *
     * A modifier is a function that is called each time Popper.js needs to
     * compute the position of the popper.
     * For this reason, modifiers should be very performant to avoid bottlenecks.
     * To learn how to create a modifier, [read the modifiers documentation](https://popper.js.org/docs/v2/modifiers/).
     */
    modifiers: PropTypes.arrayOf(PropTypes.shape({
      data: PropTypes.object,
      effect: PropTypes.func,
      enabled: PropTypes.bool,
      fn: PropTypes.func,
      name: PropTypes.any,
      options: PropTypes.object,
      phase: PropTypes.oneOf(['afterMain', 'afterRead', 'afterWrite', 'beforeMain', 'beforeRead', 'beforeWrite', 'main', 'read', 'write']),
      requires: PropTypes.arrayOf(PropTypes.string),
      requiresIfExists: PropTypes.arrayOf(PropTypes.string)
    })),
    /**
     * If `true`, the component is shown.
     */
    open: PropTypes.bool.isRequired,
    /**
     * Popper placement.
     * @default 'bottom'
     */
    placement: PropTypes.oneOf(['auto-end', 'auto-start', 'auto', 'bottom-end', 'bottom-start', 'bottom', 'left-end', 'left-start', 'left', 'right-end', 'right-start', 'right', 'top-end', 'top-start', 'top']),
    /**
     * Options provided to the [`Popper.js`](https://popper.js.org/docs/v2/constructors/#options) instance.
     * @default {}
     */
    popperOptions: PropTypes.shape({
      modifiers: PropTypes.array,
      onFirstUpdate: PropTypes.func,
      placement: PropTypes.oneOf(['auto-end', 'auto-start', 'auto', 'bottom-end', 'bottom-start', 'bottom', 'left-end', 'left-start', 'left', 'right-end', 'right-start', 'right', 'top-end', 'top-start', 'top']),
      strategy: PropTypes.oneOf(['absolute', 'fixed'])
    }),
    /**
     * A ref that points to the used popper instance.
     */
    popperRef: refType$1,
    /**
     * The props used for each slot inside the Popper.
     * @default {}
     */
    slotProps: PropTypes.shape({
      root: PropTypes.oneOfType([PropTypes.func, PropTypes.object])
    }),
    /**
     * The components used for each slot inside the Popper.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    slots: PropTypes.shape({
      root: PropTypes.elementType
    }),
    /**
     * Help supporting a react-transition-group/Transition component.
     * @default false
     */
    transition: PropTypes.bool
  } ;

  var INTENTIONAL_DRAG_COUNT_THRESHOLD = 2;
  function asc(a, b) {
    return a - b;
  }
  function findClosest(values, currentValue) {
    var _values$reduce;
    var _ref = (_values$reduce = values.reduce(function (acc, value, index) {
        var distance = Math.abs(currentValue - value);
        if (acc === null || distance < acc.distance || distance === acc.distance) {
          return {
            distance: distance,
            index: index
          };
        }
        return acc;
      }, null)) != null ? _values$reduce : {},
      closestIndex = _ref.index;
    return closestIndex;
  }
  function trackFinger(event, touchId) {
    // The event is TouchEvent
    if (touchId.current !== undefined && event.changedTouches) {
      var touchEvent = event;
      for (var i = 0; i < touchEvent.changedTouches.length; i += 1) {
        var touch = touchEvent.changedTouches[i];
        if (touch.identifier === touchId.current) {
          return {
            x: touch.clientX,
            y: touch.clientY
          };
        }
      }
      return false;
    }

    // The event is MouseEvent
    return {
      x: event.clientX,
      y: event.clientY
    };
  }
  function valueToPercent(value, min, max) {
    return (value - min) * 100 / (max - min);
  }
  function percentToValue(percent, min, max) {
    return (max - min) * percent + min;
  }
  function getDecimalPrecision$1(num) {
    // This handles the case when num is very small (0.00000001), js will turn this into 1e-8.
    // When num is bigger than 1 or less than -1 it won't get converted to this notation so it's fine.
    if (Math.abs(num) < 1) {
      var parts = num.toExponential().split('e-');
      var matissaDecimalPart = parts[0].split('.')[1];
      return (matissaDecimalPart ? matissaDecimalPart.length : 0) + parseInt(parts[1], 10);
    }
    var decimalPart = num.toString().split('.')[1];
    return decimalPart ? decimalPart.length : 0;
  }
  function roundValueToStep(value, step, min) {
    var nearest = Math.round((value - min) / step) * step + min;
    return Number(nearest.toFixed(getDecimalPrecision$1(step)));
  }
  function setValueIndex(_ref2) {
    var values = _ref2.values,
      newValue = _ref2.newValue,
      index = _ref2.index;
    var output = values.slice();
    output[index] = newValue;
    return output.sort(asc);
  }
  function focusThumb(_ref3) {
    var _sliderRef$current, _doc$activeElement;
    var sliderRef = _ref3.sliderRef,
      activeIndex = _ref3.activeIndex,
      setActive = _ref3.setActive;
    var doc = ownerDocument(sliderRef.current);
    if (!((_sliderRef$current = sliderRef.current) != null && _sliderRef$current.contains(doc.activeElement)) || Number(doc == null || (_doc$activeElement = doc.activeElement) == null ? void 0 : _doc$activeElement.getAttribute('data-index')) !== activeIndex) {
      var _sliderRef$current2;
      (_sliderRef$current2 = sliderRef.current) == null || _sliderRef$current2.querySelector("[type=\"range\"][data-index=\"".concat(activeIndex, "\"]")).focus();
    }
    if (setActive) {
      setActive(activeIndex);
    }
  }
  function areValuesEqual(newValue, oldValue) {
    if (typeof newValue === 'number' && typeof oldValue === 'number') {
      return newValue === oldValue;
    }
    if (_typeof(newValue) === 'object' && _typeof(oldValue) === 'object') {
      return areArraysEqual(newValue, oldValue);
    }
    return false;
  }
  var axisProps = {
    horizontal: {
      offset: function offset(percent) {
        return {
          left: "".concat(percent, "%")
        };
      },
      leap: function leap(percent) {
        return {
          width: "".concat(percent, "%")
        };
      }
    },
    'horizontal-reverse': {
      offset: function offset(percent) {
        return {
          right: "".concat(percent, "%")
        };
      },
      leap: function leap(percent) {
        return {
          width: "".concat(percent, "%")
        };
      }
    },
    vertical: {
      offset: function offset(percent) {
        return {
          bottom: "".concat(percent, "%")
        };
      },
      leap: function leap(percent) {
        return {
          height: "".concat(percent, "%")
        };
      }
    }
  };
  var Identity$1 = function Identity(x) {
    return x;
  };

  // TODO: remove support for Safari < 13.
  // https://caniuse.com/#search=touch-action
  //
  // Safari, on iOS, supports touch action since v13.
  // Over 80% of the iOS phones are compatible
  // in August 2020.
  // Utilizing the CSS.supports method to check if touch-action is supported.
  // Since CSS.supports is supported on all but Edge@12 and IE and touch-action
  // is supported on both Edge@12 and IE if CSS.supports is not available that means that
  // touch-action will be supported
  var cachedSupportsTouchActionNone;
  function doesSupportTouchActionNone() {
    if (cachedSupportsTouchActionNone === undefined) {
      if (typeof CSS !== 'undefined' && typeof CSS.supports === 'function') {
        cachedSupportsTouchActionNone = CSS.supports('touch-action', 'none');
      } else {
        cachedSupportsTouchActionNone = true;
      }
    }
    return cachedSupportsTouchActionNone;
  }
  /**
   *
   * Demos:
   *
   * - [Slider](https://mui.com/base-ui/react-slider/#hook)
   *
   * API:
   *
   * - [useSlider API](https://mui.com/base-ui/react-slider/hooks-api/#use-slider)
   */
  function useSlider(parameters) {
    var ariaLabelledby = parameters['aria-labelledby'],
      defaultValue = parameters.defaultValue,
      _parameters$disabled = parameters.disabled,
      disabled = _parameters$disabled === void 0 ? false : _parameters$disabled,
      _parameters$disableSw = parameters.disableSwap,
      disableSwap = _parameters$disableSw === void 0 ? false : _parameters$disableSw,
      _parameters$isRtl = parameters.isRtl,
      isRtl = _parameters$isRtl === void 0 ? false : _parameters$isRtl,
      _parameters$marks = parameters.marks,
      marksProp = _parameters$marks === void 0 ? false : _parameters$marks,
      _parameters$max = parameters.max,
      max = _parameters$max === void 0 ? 100 : _parameters$max,
      _parameters$min = parameters.min,
      min = _parameters$min === void 0 ? 0 : _parameters$min,
      name = parameters.name,
      onChange = parameters.onChange,
      onChangeCommitted = parameters.onChangeCommitted,
      _parameters$orientati = parameters.orientation,
      orientation = _parameters$orientati === void 0 ? 'horizontal' : _parameters$orientati,
      ref = parameters.rootRef,
      _parameters$scale = parameters.scale,
      scale = _parameters$scale === void 0 ? Identity$1 : _parameters$scale,
      _parameters$step = parameters.step,
      step = _parameters$step === void 0 ? 1 : _parameters$step,
      _parameters$shiftStep = parameters.shiftStep,
      shiftStep = _parameters$shiftStep === void 0 ? 10 : _parameters$shiftStep,
      tabIndex = parameters.tabIndex,
      valueProp = parameters.value;
    var touchId = React__namespace.useRef();
    // We can't use the :active browser pseudo-classes.
    // - The active state isn't triggered when clicking on the rail.
    // - The active state isn't transferred when inversing a range slider.
    var _React$useState = React__namespace.useState(-1),
      active = _React$useState[0],
      setActive = _React$useState[1];
    var _React$useState2 = React__namespace.useState(-1),
      open = _React$useState2[0],
      setOpen = _React$useState2[1];
    var _React$useState3 = React__namespace.useState(false),
      dragging = _React$useState3[0],
      setDragging = _React$useState3[1];
    var moveCount = React__namespace.useRef(0);
    var _useControlled = useControlled({
        controlled: valueProp,
        "default": defaultValue != null ? defaultValue : min,
        name: 'Slider'
      }),
      _useControlled2 = _slicedToArray(_useControlled, 2),
      valueDerived = _useControlled2[0],
      setValueState = _useControlled2[1];
    var handleChange = onChange && function (event, value, thumbIndex) {
      // Redefine target to allow name and value to be read.
      // This allows seamless integration with the most popular form libraries.
      // https://github.com/mui/material-ui/issues/13485#issuecomment-676048492
      // Clone the event to not override `target` of the original event.
      var nativeEvent = event.nativeEvent || event;
      // @ts-ignore The nativeEvent is function, not object
      var clonedEvent = new nativeEvent.constructor(nativeEvent.type, nativeEvent);
      Object.defineProperty(clonedEvent, 'target', {
        writable: true,
        value: {
          value: value,
          name: name
        }
      });
      onChange(clonedEvent, value, thumbIndex);
    };
    var range = Array.isArray(valueDerived);
    var values = range ? valueDerived.slice().sort(asc) : [valueDerived];
    values = values.map(function (value) {
      return value == null ? min : clamp(value, min, max);
    });
    var marks = marksProp === true && step !== null ? _toConsumableArray(Array(Math.floor((max - min) / step) + 1)).map(function (_, index) {
      return {
        value: min + step * index
      };
    }) : marksProp || [];
    var marksValues = marks.map(function (mark) {
      return mark.value;
    });
    var _useIsFocusVisible = useIsFocusVisible(),
      isFocusVisibleRef = _useIsFocusVisible.isFocusVisibleRef,
      handleBlurVisible = _useIsFocusVisible.onBlur,
      handleFocusVisible = _useIsFocusVisible.onFocus,
      focusVisibleRef = _useIsFocusVisible.ref;
    var _React$useState4 = React__namespace.useState(-1),
      focusedThumbIndex = _React$useState4[0],
      setFocusedThumbIndex = _React$useState4[1];
    var sliderRef = React__namespace.useRef();
    var handleFocusRef = useForkRef(focusVisibleRef, sliderRef);
    var handleRef = useForkRef(ref, handleFocusRef);
    var createHandleHiddenInputFocus = function createHandleHiddenInputFocus(otherHandlers) {
      return function (event) {
        var _otherHandlers$onFocu;
        var index = Number(event.currentTarget.getAttribute('data-index'));
        handleFocusVisible(event);
        if (isFocusVisibleRef.current === true) {
          setFocusedThumbIndex(index);
        }
        setOpen(index);
        otherHandlers == null || (_otherHandlers$onFocu = otherHandlers.onFocus) == null || _otherHandlers$onFocu.call(otherHandlers, event);
      };
    };
    var createHandleHiddenInputBlur = function createHandleHiddenInputBlur(otherHandlers) {
      return function (event) {
        var _otherHandlers$onBlur;
        handleBlurVisible(event);
        if (isFocusVisibleRef.current === false) {
          setFocusedThumbIndex(-1);
        }
        setOpen(-1);
        otherHandlers == null || (_otherHandlers$onBlur = otherHandlers.onBlur) == null || _otherHandlers$onBlur.call(otherHandlers, event);
      };
    };
    var changeValue = function changeValue(event, valueInput) {
      var index = Number(event.currentTarget.getAttribute('data-index'));
      var value = values[index];
      var marksIndex = marksValues.indexOf(value);
      var newValue = valueInput;
      if (marks && step == null) {
        var maxMarksValue = marksValues[marksValues.length - 1];
        if (newValue > maxMarksValue) {
          newValue = maxMarksValue;
        } else if (newValue < marksValues[0]) {
          newValue = marksValues[0];
        } else {
          newValue = newValue < value ? marksValues[marksIndex - 1] : marksValues[marksIndex + 1];
        }
      }
      newValue = clamp(newValue, min, max);
      if (range) {
        // Bound the new value to the thumb's neighbours.
        if (disableSwap) {
          newValue = clamp(newValue, values[index - 1] || -Infinity, values[index + 1] || Infinity);
        }
        var previousValue = newValue;
        newValue = setValueIndex({
          values: values,
          newValue: newValue,
          index: index
        });
        var activeIndex = index;

        // Potentially swap the index if needed.
        if (!disableSwap) {
          activeIndex = newValue.indexOf(previousValue);
        }
        focusThumb({
          sliderRef: sliderRef,
          activeIndex: activeIndex
        });
      }
      setValueState(newValue);
      setFocusedThumbIndex(index);
      if (handleChange && !areValuesEqual(newValue, valueDerived)) {
        handleChange(event, newValue, index);
      }
      if (onChangeCommitted) {
        onChangeCommitted(event, newValue);
      }
    };
    var createHandleHiddenInputKeyDown = function createHandleHiddenInputKeyDown(otherHandlers) {
      return function (event) {
        var _otherHandlers$onKeyD;
        // The Shift + Up/Down keyboard shortcuts for moving the slider makes sense to be supported
        // only if the step is defined. If the step is null, this means tha the marks are used for specifying the valid values.
        if (step !== null) {
          var index = Number(event.currentTarget.getAttribute('data-index'));
          var value = values[index];
          var newValue = null;
          if ((event.key === 'ArrowLeft' || event.key === 'ArrowDown') && event.shiftKey || event.key === 'PageDown') {
            newValue = Math.max(value - shiftStep, min);
          } else if ((event.key === 'ArrowRight' || event.key === 'ArrowUp') && event.shiftKey || event.key === 'PageUp') {
            newValue = Math.min(value + shiftStep, max);
          }
          if (newValue !== null) {
            changeValue(event, newValue);
            event.preventDefault();
          }
        }
        otherHandlers == null || (_otherHandlers$onKeyD = otherHandlers.onKeyDown) == null || _otherHandlers$onKeyD.call(otherHandlers, event);
      };
    };
    useEnhancedEffect$1(function () {
      if (disabled && sliderRef.current.contains(document.activeElement)) {
        var _document$activeEleme;
        // This is necessary because Firefox and Safari will keep focus
        // on a disabled element:
        // https://codesandbox.io/p/sandbox/mui-pr-22247-forked-h151h?file=/src/App.js
        // @ts-ignore
        (_document$activeEleme = document.activeElement) == null || _document$activeEleme.blur();
      }
    }, [disabled]);
    if (disabled && active !== -1) {
      setActive(-1);
    }
    if (disabled && focusedThumbIndex !== -1) {
      setFocusedThumbIndex(-1);
    }
    var createHandleHiddenInputChange = function createHandleHiddenInputChange(otherHandlers) {
      return function (event) {
        var _otherHandlers$onChan;
        (_otherHandlers$onChan = otherHandlers.onChange) == null || _otherHandlers$onChan.call(otherHandlers, event);
        // @ts-ignore
        changeValue(event, event.target.valueAsNumber);
      };
    };
    var previousIndex = React__namespace.useRef();
    var axis = orientation;
    if (isRtl && orientation === 'horizontal') {
      axis += '-reverse';
    }
    var getFingerNewValue = function getFingerNewValue(_ref4) {
      var finger = _ref4.finger,
        _ref4$move = _ref4.move,
        move = _ref4$move === void 0 ? false : _ref4$move;
      var slider = sliderRef.current;
      var _getBoundingClientRec = slider.getBoundingClientRect(),
        width = _getBoundingClientRec.width,
        height = _getBoundingClientRec.height,
        bottom = _getBoundingClientRec.bottom,
        left = _getBoundingClientRec.left;
      var percent;
      if (axis.indexOf('vertical') === 0) {
        percent = (bottom - finger.y) / height;
      } else {
        percent = (finger.x - left) / width;
      }
      if (axis.indexOf('-reverse') !== -1) {
        percent = 1 - percent;
      }
      var newValue;
      newValue = percentToValue(percent, min, max);
      if (step) {
        newValue = roundValueToStep(newValue, step, min);
      } else {
        var closestIndex = findClosest(marksValues, newValue);
        newValue = marksValues[closestIndex];
      }
      newValue = clamp(newValue, min, max);
      var activeIndex = 0;
      if (range) {
        if (!move) {
          activeIndex = findClosest(values, newValue);
        } else {
          activeIndex = previousIndex.current;
        }

        // Bound the new value to the thumb's neighbours.
        if (disableSwap) {
          newValue = clamp(newValue, values[activeIndex - 1] || -Infinity, values[activeIndex + 1] || Infinity);
        }
        var previousValue = newValue;
        newValue = setValueIndex({
          values: values,
          newValue: newValue,
          index: activeIndex
        });

        // Potentially swap the index if needed.
        if (!(disableSwap && move)) {
          activeIndex = newValue.indexOf(previousValue);
          previousIndex.current = activeIndex;
        }
      }
      return {
        newValue: newValue,
        activeIndex: activeIndex
      };
    };
    var handleTouchMove = useEventCallback(function (nativeEvent) {
      var finger = trackFinger(nativeEvent, touchId);
      if (!finger) {
        return;
      }
      moveCount.current += 1;

      // Cancel move in case some other element consumed a mouseup event and it was not fired.
      // @ts-ignore buttons doesn't not exists on touch event
      if (nativeEvent.type === 'mousemove' && nativeEvent.buttons === 0) {
        // eslint-disable-next-line @typescript-eslint/no-use-before-define
        handleTouchEnd(nativeEvent);
        return;
      }
      var _getFingerNewValue = getFingerNewValue({
          finger: finger,
          move: true
        }),
        newValue = _getFingerNewValue.newValue,
        activeIndex = _getFingerNewValue.activeIndex;
      focusThumb({
        sliderRef: sliderRef,
        activeIndex: activeIndex,
        setActive: setActive
      });
      setValueState(newValue);
      if (!dragging && moveCount.current > INTENTIONAL_DRAG_COUNT_THRESHOLD) {
        setDragging(true);
      }
      if (handleChange && !areValuesEqual(newValue, valueDerived)) {
        handleChange(nativeEvent, newValue, activeIndex);
      }
    });
    var handleTouchEnd = useEventCallback(function (nativeEvent) {
      var finger = trackFinger(nativeEvent, touchId);
      setDragging(false);
      if (!finger) {
        return;
      }
      var _getFingerNewValue2 = getFingerNewValue({
          finger: finger,
          move: true
        }),
        newValue = _getFingerNewValue2.newValue;
      setActive(-1);
      if (nativeEvent.type === 'touchend') {
        setOpen(-1);
      }
      if (onChangeCommitted) {
        onChangeCommitted(nativeEvent, newValue);
      }
      touchId.current = undefined;

      // eslint-disable-next-line @typescript-eslint/no-use-before-define
      stopListening();
    });
    var handleTouchStart = useEventCallback(function (nativeEvent) {
      if (disabled) {
        return;
      }
      // If touch-action: none; is not supported we need to prevent the scroll manually.
      if (!doesSupportTouchActionNone()) {
        nativeEvent.preventDefault();
      }
      var touch = nativeEvent.changedTouches[0];
      if (touch != null) {
        // A number that uniquely identifies the current finger in the touch session.
        touchId.current = touch.identifier;
      }
      var finger = trackFinger(nativeEvent, touchId);
      if (finger !== false) {
        var _getFingerNewValue3 = getFingerNewValue({
            finger: finger
          }),
          newValue = _getFingerNewValue3.newValue,
          activeIndex = _getFingerNewValue3.activeIndex;
        focusThumb({
          sliderRef: sliderRef,
          activeIndex: activeIndex,
          setActive: setActive
        });
        setValueState(newValue);
        if (handleChange && !areValuesEqual(newValue, valueDerived)) {
          handleChange(nativeEvent, newValue, activeIndex);
        }
      }
      moveCount.current = 0;
      var doc = ownerDocument(sliderRef.current);
      doc.addEventListener('touchmove', handleTouchMove, {
        passive: true
      });
      doc.addEventListener('touchend', handleTouchEnd, {
        passive: true
      });
    });
    var stopListening = React__namespace.useCallback(function () {
      var doc = ownerDocument(sliderRef.current);
      doc.removeEventListener('mousemove', handleTouchMove);
      doc.removeEventListener('mouseup', handleTouchEnd);
      doc.removeEventListener('touchmove', handleTouchMove);
      doc.removeEventListener('touchend', handleTouchEnd);
    }, [handleTouchEnd, handleTouchMove]);
    React__namespace.useEffect(function () {
      var slider = sliderRef.current;
      slider.addEventListener('touchstart', handleTouchStart, {
        passive: doesSupportTouchActionNone()
      });
      return function () {
        slider.removeEventListener('touchstart', handleTouchStart);
        stopListening();
      };
    }, [stopListening, handleTouchStart]);
    React__namespace.useEffect(function () {
      if (disabled) {
        stopListening();
      }
    }, [disabled, stopListening]);
    var createHandleMouseDown = function createHandleMouseDown(otherHandlers) {
      return function (event) {
        var _otherHandlers$onMous;
        (_otherHandlers$onMous = otherHandlers.onMouseDown) == null || _otherHandlers$onMous.call(otherHandlers, event);
        if (disabled) {
          return;
        }
        if (event.defaultPrevented) {
          return;
        }

        // Only handle left clicks
        if (event.button !== 0) {
          return;
        }

        // Avoid text selection
        event.preventDefault();
        var finger = trackFinger(event, touchId);
        if (finger !== false) {
          var _getFingerNewValue4 = getFingerNewValue({
              finger: finger
            }),
            newValue = _getFingerNewValue4.newValue,
            activeIndex = _getFingerNewValue4.activeIndex;
          focusThumb({
            sliderRef: sliderRef,
            activeIndex: activeIndex,
            setActive: setActive
          });
          setValueState(newValue);
          if (handleChange && !areValuesEqual(newValue, valueDerived)) {
            handleChange(event, newValue, activeIndex);
          }
        }
        moveCount.current = 0;
        var doc = ownerDocument(sliderRef.current);
        doc.addEventListener('mousemove', handleTouchMove, {
          passive: true
        });
        doc.addEventListener('mouseup', handleTouchEnd);
      };
    };
    var trackOffset = valueToPercent(range ? values[0] : min, min, max);
    var trackLeap = valueToPercent(values[values.length - 1], min, max) - trackOffset;
    var getRootProps = function getRootProps() {
      var externalProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var externalHandlers = extractEventHandlers(externalProps);
      var ownEventHandlers = {
        onMouseDown: createHandleMouseDown(externalHandlers || {})
      };
      var mergedEventHandlers = _extends({}, externalHandlers, ownEventHandlers);
      return _extends({}, externalProps, {
        ref: handleRef
      }, mergedEventHandlers);
    };
    var createHandleMouseOver = function createHandleMouseOver(otherHandlers) {
      return function (event) {
        var _otherHandlers$onMous2;
        (_otherHandlers$onMous2 = otherHandlers.onMouseOver) == null || _otherHandlers$onMous2.call(otherHandlers, event);
        var index = Number(event.currentTarget.getAttribute('data-index'));
        setOpen(index);
      };
    };
    var createHandleMouseLeave = function createHandleMouseLeave(otherHandlers) {
      return function (event) {
        var _otherHandlers$onMous3;
        (_otherHandlers$onMous3 = otherHandlers.onMouseLeave) == null || _otherHandlers$onMous3.call(otherHandlers, event);
        setOpen(-1);
      };
    };
    var getThumbProps = function getThumbProps() {
      var externalProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var externalHandlers = extractEventHandlers(externalProps);
      var ownEventHandlers = {
        onMouseOver: createHandleMouseOver(externalHandlers || {}),
        onMouseLeave: createHandleMouseLeave(externalHandlers || {})
      };
      return _extends({}, externalProps, externalHandlers, ownEventHandlers);
    };
    var getThumbStyle = function getThumbStyle(index) {
      return {
        // So the non active thumb doesn't show its label on hover.
        pointerEvents: active !== -1 && active !== index ? 'none' : undefined
      };
    };
    var getHiddenInputProps = function getHiddenInputProps() {
      var _parameters$step2;
      var externalProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var externalHandlers = extractEventHandlers(externalProps);
      var ownEventHandlers = {
        onChange: createHandleHiddenInputChange(externalHandlers || {}),
        onFocus: createHandleHiddenInputFocus(externalHandlers || {}),
        onBlur: createHandleHiddenInputBlur(externalHandlers || {}),
        onKeyDown: createHandleHiddenInputKeyDown(externalHandlers || {})
      };
      var mergedEventHandlers = _extends({}, externalHandlers, ownEventHandlers);
      return _extends({
        tabIndex: tabIndex,
        'aria-labelledby': ariaLabelledby,
        'aria-orientation': orientation,
        'aria-valuemax': scale(max),
        'aria-valuemin': scale(min),
        name: name,
        type: 'range',
        min: parameters.min,
        max: parameters.max,
        step: parameters.step === null && parameters.marks ? 'any' : (_parameters$step2 = parameters.step) != null ? _parameters$step2 : undefined,
        disabled: disabled
      }, externalProps, mergedEventHandlers, {
        style: _extends({}, visuallyHidden$1, {
          direction: isRtl ? 'rtl' : 'ltr',
          // So that VoiceOver's focus indicator matches the thumb's dimensions
          width: '100%',
          height: '100%'
        })
      });
    };
    return {
      active: active,
      axis: axis,
      axisProps: axisProps,
      dragging: dragging,
      focusedThumbIndex: focusedThumbIndex,
      getHiddenInputProps: getHiddenInputProps,
      getRootProps: getRootProps,
      getThumbProps: getThumbProps,
      marks: marks,
      open: open,
      range: range,
      rootRef: handleRef,
      trackLeap: trackLeap,
      trackOffset: trackOffset,
      values: values,
      getThumbStyle: getThumbStyle
    };
  }

  /**
   * The basic building block for creating custom snackbar.
   *
   * Demos:
   *
   * - [Snackbar](https://mui.com/base-ui/react-snackbar/#hook)
   *
   * API:
   *
   * - [useSnackbar API](https://mui.com/base-ui/react-snackbar/hooks-api/#use-snackbar)
   */
  function useSnackbar() {
    var parameters = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var _parameters$autoHideD = parameters.autoHideDuration,
      autoHideDuration = _parameters$autoHideD === void 0 ? null : _parameters$autoHideD,
      _parameters$disableWi = parameters.disableWindowBlurListener,
      disableWindowBlurListener = _parameters$disableWi === void 0 ? false : _parameters$disableWi,
      onClose = parameters.onClose,
      open = parameters.open,
      resumeHideDuration = parameters.resumeHideDuration;
    var timerAutoHide = useTimeout();
    React__namespace.useEffect(function () {
      if (!open) {
        return undefined;
      }

      /**
       * @param {KeyboardEvent} nativeEvent
       */
      function handleKeyDown(nativeEvent) {
        if (!nativeEvent.defaultPrevented) {
          // IE11, Edge (prior to using Blink?) use 'Esc'
          if (nativeEvent.key === 'Escape' || nativeEvent.key === 'Esc') {
            // not calling `preventDefault` since we don't know if people may ignore this event e.g. a permanently open snackbar
            onClose == null || onClose(nativeEvent, 'escapeKeyDown');
          }
        }
      }
      document.addEventListener('keydown', handleKeyDown);
      return function () {
        document.removeEventListener('keydown', handleKeyDown);
      };
    }, [open, onClose]);
    var handleClose = useEventCallback(function (event, reason) {
      onClose == null || onClose(event, reason);
    });
    var setAutoHideTimer = useEventCallback(function (autoHideDurationParam) {
      if (!onClose || autoHideDurationParam == null) {
        return;
      }
      timerAutoHide.start(autoHideDurationParam, function () {
        handleClose(null, 'timeout');
      });
    });
    React__namespace.useEffect(function () {
      if (open) {
        setAutoHideTimer(autoHideDuration);
      }
      return timerAutoHide.clear;
    }, [open, autoHideDuration, setAutoHideTimer, timerAutoHide]);
    var handleClickAway = function handleClickAway(event) {
      onClose == null || onClose(event, 'clickaway');
    };

    // Pause the timer when the user is interacting with the Snackbar
    // or when the user hide the window.
    var handlePause = timerAutoHide.clear;

    // Restart the timer when the user is no longer interacting with the Snackbar
    // or when the window is shown back.
    var handleResume = React__namespace.useCallback(function () {
      if (autoHideDuration != null) {
        setAutoHideTimer(resumeHideDuration != null ? resumeHideDuration : autoHideDuration * 0.5);
      }
    }, [autoHideDuration, resumeHideDuration, setAutoHideTimer]);
    var createHandleBlur = function createHandleBlur(otherHandlers) {
      return function (event) {
        var onBlurCallback = otherHandlers.onBlur;
        onBlurCallback == null || onBlurCallback(event);
        handleResume();
      };
    };
    var createHandleFocus = function createHandleFocus(otherHandlers) {
      return function (event) {
        var onFocusCallback = otherHandlers.onFocus;
        onFocusCallback == null || onFocusCallback(event);
        handlePause();
      };
    };
    var createMouseEnter = function createMouseEnter(otherHandlers) {
      return function (event) {
        var onMouseEnterCallback = otherHandlers.onMouseEnter;
        onMouseEnterCallback == null || onMouseEnterCallback(event);
        handlePause();
      };
    };
    var createMouseLeave = function createMouseLeave(otherHandlers) {
      return function (event) {
        var onMouseLeaveCallback = otherHandlers.onMouseLeave;
        onMouseLeaveCallback == null || onMouseLeaveCallback(event);
        handleResume();
      };
    };
    React__namespace.useEffect(function () {
      // TODO: window global should be refactored here
      if (!disableWindowBlurListener && open) {
        window.addEventListener('focus', handleResume);
        window.addEventListener('blur', handlePause);
        return function () {
          window.removeEventListener('focus', handleResume);
          window.removeEventListener('blur', handlePause);
        };
      }
      return undefined;
    }, [disableWindowBlurListener, open, handleResume, handlePause]);
    var getRootProps = function getRootProps() {
      var externalProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var externalEventHandlers = _extends({}, extractEventHandlers(parameters), extractEventHandlers(externalProps));
      return _extends({
        // ClickAwayListener adds an `onClick` prop which results in the alert not being announced.
        // See https://github.com/mui/material-ui/issues/29080
        role: 'presentation'
      }, externalProps, externalEventHandlers, {
        onBlur: createHandleBlur(externalEventHandlers),
        onFocus: createHandleFocus(externalEventHandlers),
        onMouseEnter: createMouseEnter(externalEventHandlers),
        onMouseLeave: createMouseLeave(externalEventHandlers)
      });
    };
    return {
      getRootProps: getRootProps,
      onClickAway: handleClickAway
    };
  }

  function getStyleValue(value) {
    return parseInt(value, 10) || 0;
  }
  var styles$4 = {
    shadow: {
      // Visibility needed to hide the extra text area on iPads
      visibility: 'hidden',
      // Remove from the content flow
      position: 'absolute',
      // Ignore the scrollbar width
      overflow: 'hidden',
      height: 0,
      top: 0,
      left: 0,
      // Create a new layer, increase the isolation of the computed values
      transform: 'translateZ(0)'
    }
  };
  function isEmpty$1(obj) {
    return obj === undefined || obj === null || Object.keys(obj).length === 0 || obj.outerHeightStyle === 0 && !obj.overflowing;
  }

  /**
   *
   * Demos:
   *
   * - [Textarea Autosize](https://mui.com/base-ui/react-textarea-autosize/)
   * - [Textarea Autosize](https://mui.com/material-ui/react-textarea-autosize/)
   *
   * API:
   *
   * - [TextareaAutosize API](https://mui.com/base-ui/react-textarea-autosize/components-api/#textarea-autosize)
   */
  var TextareaAutosize = /*#__PURE__*/React__namespace.forwardRef(function TextareaAutosize(props, forwardedRef) {
    var onChange = props.onChange,
      maxRows = props.maxRows,
      _props$minRows = props.minRows,
      minRows = _props$minRows === void 0 ? 1 : _props$minRows,
      style = props.style,
      value = props.value,
      other = _objectWithoutProperties(props, ["onChange", "maxRows", "minRows", "style", "value"]);
    var _React$useRef = React__namespace.useRef(value != null),
      isControlled = _React$useRef.current;
    var inputRef = React__namespace.useRef(null);
    var handleRef = useForkRef(forwardedRef, inputRef);
    var shadowRef = React__namespace.useRef(null);
    var calculateTextareaStyles = React__namespace.useCallback(function () {
      var input = inputRef.current;
      var containerWindow = ownerWindow(input);
      var computedStyle = containerWindow.getComputedStyle(input);

      // If input's width is shrunk and it's not visible, don't sync height.
      if (computedStyle.width === '0px') {
        return {
          outerHeightStyle: 0,
          overflowing: false
        };
      }
      var inputShallow = shadowRef.current;
      inputShallow.style.width = computedStyle.width;
      inputShallow.value = input.value || props.placeholder || 'x';
      if (inputShallow.value.slice(-1) === '\n') {
        // Certain fonts which overflow the line height will cause the textarea
        // to report a different scrollHeight depending on whether the last line
        // is empty. Make it non-empty to avoid this issue.
        inputShallow.value += ' ';
      }
      var boxSizing = computedStyle.boxSizing;
      var padding = getStyleValue(computedStyle.paddingBottom) + getStyleValue(computedStyle.paddingTop);
      var border = getStyleValue(computedStyle.borderBottomWidth) + getStyleValue(computedStyle.borderTopWidth);

      // The height of the inner content
      var innerHeight = inputShallow.scrollHeight;

      // Measure height of a textarea with a single row
      inputShallow.value = 'x';
      var singleRowHeight = inputShallow.scrollHeight;

      // The height of the outer content
      var outerHeight = innerHeight;
      if (minRows) {
        outerHeight = Math.max(Number(minRows) * singleRowHeight, outerHeight);
      }
      if (maxRows) {
        outerHeight = Math.min(Number(maxRows) * singleRowHeight, outerHeight);
      }
      outerHeight = Math.max(outerHeight, singleRowHeight);

      // Take the box sizing into account for applying this value as a style.
      var outerHeightStyle = outerHeight + (boxSizing === 'border-box' ? padding + border : 0);
      var overflowing = Math.abs(outerHeight - innerHeight) <= 1;
      return {
        outerHeightStyle: outerHeightStyle,
        overflowing: overflowing
      };
    }, [maxRows, minRows, props.placeholder]);
    var syncHeight = React__namespace.useCallback(function () {
      var textareaStyles = calculateTextareaStyles();
      if (isEmpty$1(textareaStyles)) {
        return;
      }
      var input = inputRef.current;
      input.style.height = "".concat(textareaStyles.outerHeightStyle, "px");
      input.style.overflow = textareaStyles.overflowing ? 'hidden' : '';
    }, [calculateTextareaStyles]);
    useEnhancedEffect$1(function () {
      var handleResize = function handleResize() {
        syncHeight();
      };
      // Workaround a "ResizeObserver loop completed with undelivered notifications" error
      // in test.
      // Note that we might need to use this logic in production per https://github.com/WICG/resize-observer/issues/38
      // Also see https://github.com/mui/mui-x/issues/8733
      var rAF;
      var debounceHandleResize = debounce$1(handleResize);
      var input = inputRef.current;
      var containerWindow = ownerWindow(input);
      containerWindow.addEventListener('resize', debounceHandleResize);
      var resizeObserver;
      if (typeof ResizeObserver !== 'undefined') {
        resizeObserver = new ResizeObserver(handleResize);
        resizeObserver.observe(input);
      }
      return function () {
        debounceHandleResize.clear();
        cancelAnimationFrame(rAF);
        containerWindow.removeEventListener('resize', debounceHandleResize);
        if (resizeObserver) {
          resizeObserver.disconnect();
        }
      };
    }, [calculateTextareaStyles, syncHeight]);
    useEnhancedEffect$1(function () {
      syncHeight();
    });
    var handleChange = function handleChange(event) {
      if (!isControlled) {
        syncHeight();
      }
      if (onChange) {
        onChange(event);
      }
    };
    return /*#__PURE__*/jsxRuntime_2(React__namespace.Fragment, {
      children: [/*#__PURE__*/jsxRuntime_1("textarea", _extends({
        value: value,
        onChange: handleChange,
        ref: handleRef
        // Apply the rows prop to get a "correct" first SSR paint
        ,
        rows: minRows,
        style: style
      }, other)), /*#__PURE__*/jsxRuntime_1("textarea", {
        "aria-hidden": true,
        className: props.className,
        readOnly: true,
        ref: shadowRef,
        tabIndex: -1,
        style: _extends({}, styles$4.shadow, style, {
          paddingTop: 0,
          paddingBottom: 0
        })
      })]
    });
  });
  TextareaAutosize.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │ To update them, edit the TypeScript types and run `pnpm proptypes`. │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * Maximum number of rows to display.
     */
    maxRows: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    /**
     * Minimum number of rows to display.
     * @default 1
     */
    minRows: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    /**
     * @ignore
     */
    onChange: PropTypes.func,
    /**
     * @ignore
     */
    placeholder: PropTypes.string,
    /**
     * @ignore
     */
    style: PropTypes.object,
    /**
     * @ignore
     */
    value: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.string), PropTypes.number, PropTypes.string])
  } ;

  // https://stackoverflow.com/questions/990904/remove-accents-diacritics-in-a-string-in-javascript
  // Give up on IE11 support for this feature
  function stripDiacritics(string) {
    return typeof string.normalize !== 'undefined' ? string.normalize('NFD').replace(/[\u0300-\u036f]/g, '') : string;
  }
  function createFilterOptions() {
    var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var _config$ignoreAccents = config.ignoreAccents,
      ignoreAccents = _config$ignoreAccents === void 0 ? true : _config$ignoreAccents,
      _config$ignoreCase = config.ignoreCase,
      ignoreCase = _config$ignoreCase === void 0 ? true : _config$ignoreCase,
      limit = config.limit,
      _config$matchFrom = config.matchFrom,
      matchFrom = _config$matchFrom === void 0 ? 'any' : _config$matchFrom,
      stringify = config.stringify,
      _config$trim = config.trim,
      trim = _config$trim === void 0 ? false : _config$trim;
    return function (options, _ref) {
      var inputValue = _ref.inputValue,
        getOptionLabel = _ref.getOptionLabel;
      var input = trim ? inputValue.trim() : inputValue;
      if (ignoreCase) {
        input = input.toLowerCase();
      }
      if (ignoreAccents) {
        input = stripDiacritics(input);
      }
      var filteredOptions = !input ? options : options.filter(function (option) {
        var candidate = (stringify || getOptionLabel)(option);
        if (ignoreCase) {
          candidate = candidate.toLowerCase();
        }
        if (ignoreAccents) {
          candidate = stripDiacritics(candidate);
        }
        return matchFrom === 'start' ? candidate.indexOf(input) === 0 : candidate.indexOf(input) > -1;
      });
      return typeof limit === 'number' ? filteredOptions.slice(0, limit) : filteredOptions;
    };
  }

  // To replace with .findIndex() once we stop IE11 support.
  function findIndex(array, comp) {
    for (var i = 0; i < array.length; i += 1) {
      if (comp(array[i])) {
        return i;
      }
    }
    return -1;
  }
  var defaultFilterOptions = createFilterOptions();

  // Number of options to jump in list box when `Page Up` and `Page Down` keys are used.
  var pageSize = 5;
  var defaultIsActiveElementInListbox = function defaultIsActiveElementInListbox(listboxRef) {
    var _listboxRef$current$p;
    return listboxRef.current !== null && ((_listboxRef$current$p = listboxRef.current.parentElement) == null ? void 0 : _listboxRef$current$p.contains(document.activeElement));
  };
  function useAutocomplete(props) {
    var _props$unstable_isAct = props.unstable_isActiveElementInListbox,
      unstable_isActiveElementInListbox = _props$unstable_isAct === void 0 ? defaultIsActiveElementInListbox : _props$unstable_isAct,
      _props$unstable_class = props.unstable_classNamePrefix,
      unstable_classNamePrefix = _props$unstable_class === void 0 ? 'Mui' : _props$unstable_class,
      _props$autoComplete = props.autoComplete,
      autoComplete = _props$autoComplete === void 0 ? false : _props$autoComplete,
      _props$autoHighlight = props.autoHighlight,
      autoHighlight = _props$autoHighlight === void 0 ? false : _props$autoHighlight,
      _props$autoSelect = props.autoSelect,
      autoSelect = _props$autoSelect === void 0 ? false : _props$autoSelect,
      _props$blurOnSelect = props.blurOnSelect,
      blurOnSelect = _props$blurOnSelect === void 0 ? false : _props$blurOnSelect,
      _props$clearOnBlur = props.clearOnBlur,
      clearOnBlur = _props$clearOnBlur === void 0 ? !props.freeSolo : _props$clearOnBlur,
      _props$clearOnEscape = props.clearOnEscape,
      clearOnEscape = _props$clearOnEscape === void 0 ? false : _props$clearOnEscape,
      _props$componentName = props.componentName,
      componentName = _props$componentName === void 0 ? 'useAutocomplete' : _props$componentName,
      _props$defaultValue = props.defaultValue,
      defaultValue = _props$defaultValue === void 0 ? props.multiple ? [] : null : _props$defaultValue,
      _props$disableClearab = props.disableClearable,
      disableClearable = _props$disableClearab === void 0 ? false : _props$disableClearab,
      _props$disableCloseOn = props.disableCloseOnSelect,
      disableCloseOnSelect = _props$disableCloseOn === void 0 ? false : _props$disableCloseOn,
      disabledProp = props.disabled,
      _props$disabledItemsF = props.disabledItemsFocusable,
      disabledItemsFocusable = _props$disabledItemsF === void 0 ? false : _props$disabledItemsF,
      _props$disableListWra = props.disableListWrap,
      disableListWrap = _props$disableListWra === void 0 ? false : _props$disableListWra,
      _props$filterOptions = props.filterOptions,
      filterOptions = _props$filterOptions === void 0 ? defaultFilterOptions : _props$filterOptions,
      _props$filterSelected = props.filterSelectedOptions,
      filterSelectedOptions = _props$filterSelected === void 0 ? false : _props$filterSelected,
      _props$freeSolo = props.freeSolo,
      freeSolo = _props$freeSolo === void 0 ? false : _props$freeSolo,
      getOptionDisabled = props.getOptionDisabled,
      getOptionKey = props.getOptionKey,
      _props$getOptionLabel = props.getOptionLabel,
      getOptionLabelProp = _props$getOptionLabel === void 0 ? function (option) {
        var _option$label;
        return (_option$label = option.label) != null ? _option$label : option;
      } : _props$getOptionLabel,
      groupBy = props.groupBy,
      _props$handleHomeEndK = props.handleHomeEndKeys,
      handleHomeEndKeys = _props$handleHomeEndK === void 0 ? !props.freeSolo : _props$handleHomeEndK,
      idProp = props.id,
      _props$includeInputIn = props.includeInputInList,
      includeInputInList = _props$includeInputIn === void 0 ? false : _props$includeInputIn,
      inputValueProp = props.inputValue,
      _props$isOptionEqualT = props.isOptionEqualToValue,
      isOptionEqualToValue = _props$isOptionEqualT === void 0 ? function (option, value) {
        return option === value;
      } : _props$isOptionEqualT,
      _props$multiple = props.multiple,
      multiple = _props$multiple === void 0 ? false : _props$multiple,
      onChange = props.onChange,
      onClose = props.onClose,
      onHighlightChange = props.onHighlightChange,
      onInputChange = props.onInputChange,
      onOpen = props.onOpen,
      openProp = props.open,
      _props$openOnFocus = props.openOnFocus,
      openOnFocus = _props$openOnFocus === void 0 ? false : _props$openOnFocus,
      options = props.options,
      _props$readOnly = props.readOnly,
      readOnly = _props$readOnly === void 0 ? false : _props$readOnly,
      _props$selectOnFocus = props.selectOnFocus,
      selectOnFocus = _props$selectOnFocus === void 0 ? !props.freeSolo : _props$selectOnFocus,
      valueProp = props.value;
    var id = useId(idProp);
    var getOptionLabel = getOptionLabelProp;
    getOptionLabel = function getOptionLabel(option) {
      var optionLabel = getOptionLabelProp(option);
      if (typeof optionLabel !== 'string') {
        {
          var erroneousReturn = optionLabel === undefined ? 'undefined' : "".concat(_typeof(optionLabel), " (").concat(optionLabel, ")");
          console.error("MUI: The `getOptionLabel` method of ".concat(componentName, " returned ").concat(erroneousReturn, " instead of a string for ").concat(JSON.stringify(option), "."));
        }
        return String(optionLabel);
      }
      return optionLabel;
    };
    var ignoreFocus = React__namespace.useRef(false);
    var firstFocus = React__namespace.useRef(true);
    var inputRef = React__namespace.useRef(null);
    var listboxRef = React__namespace.useRef(null);
    var _React$useState = React__namespace.useState(null),
      anchorEl = _React$useState[0],
      setAnchorEl = _React$useState[1];
    var _React$useState2 = React__namespace.useState(-1),
      focusedTag = _React$useState2[0],
      setFocusedTag = _React$useState2[1];
    var defaultHighlighted = autoHighlight ? 0 : -1;
    var highlightedIndexRef = React__namespace.useRef(defaultHighlighted);
    var _useControlled = useControlled({
        controlled: valueProp,
        "default": defaultValue,
        name: componentName
      }),
      _useControlled2 = _slicedToArray(_useControlled, 2),
      value = _useControlled2[0],
      setValueState = _useControlled2[1];
    var _useControlled3 = useControlled({
        controlled: inputValueProp,
        "default": '',
        name: componentName,
        state: 'inputValue'
      }),
      _useControlled4 = _slicedToArray(_useControlled3, 2),
      inputValue = _useControlled4[0],
      setInputValueState = _useControlled4[1];
    var _React$useState3 = React__namespace.useState(false),
      focused = _React$useState3[0],
      setFocused = _React$useState3[1];
    var resetInputValue = React__namespace.useCallback(function (event, newValue) {
      // retain current `inputValue` if new option isn't selected and `clearOnBlur` is false
      // When `multiple` is enabled, `newValue` is an array of all selected items including the newly selected item
      var isOptionSelected = multiple ? value.length < newValue.length : newValue !== null;
      if (!isOptionSelected && !clearOnBlur) {
        return;
      }
      var newInputValue;
      if (multiple) {
        newInputValue = '';
      } else if (newValue == null) {
        newInputValue = '';
      } else {
        var optionLabel = getOptionLabel(newValue);
        newInputValue = typeof optionLabel === 'string' ? optionLabel : '';
      }
      if (inputValue === newInputValue) {
        return;
      }
      setInputValueState(newInputValue);
      if (onInputChange) {
        onInputChange(event, newInputValue, 'reset');
      }
    }, [getOptionLabel, inputValue, multiple, onInputChange, setInputValueState, clearOnBlur, value]);
    var _useControlled5 = useControlled({
        controlled: openProp,
        "default": false,
        name: componentName,
        state: 'open'
      }),
      _useControlled6 = _slicedToArray(_useControlled5, 2),
      open = _useControlled6[0],
      setOpenState = _useControlled6[1];
    var _React$useState4 = React__namespace.useState(true),
      inputPristine = _React$useState4[0],
      setInputPristine = _React$useState4[1];
    var inputValueIsSelectedValue = !multiple && value != null && inputValue === getOptionLabel(value);
    var popupOpen = open && !readOnly;
    var filteredOptions = popupOpen ? filterOptions(options.filter(function (option) {
      if (filterSelectedOptions && (multiple ? value : [value]).some(function (value2) {
        return value2 !== null && isOptionEqualToValue(option, value2);
      })) {
        return false;
      }
      return true;
    }),
    // we use the empty string to manipulate `filterOptions` to not filter any options
    // i.e. the filter predicate always returns true
    {
      inputValue: inputValueIsSelectedValue && inputPristine ? '' : inputValue,
      getOptionLabel: getOptionLabel
    }) : [];
    var previousProps = usePreviousProps$1({
      filteredOptions: filteredOptions,
      value: value,
      inputValue: inputValue
    });
    React__namespace.useEffect(function () {
      var valueChange = value !== previousProps.value;
      if (focused && !valueChange) {
        return;
      }

      // Only reset the input's value when freeSolo if the component's value changes.
      if (freeSolo && !valueChange) {
        return;
      }
      resetInputValue(null, value);
    }, [value, resetInputValue, focused, previousProps.value, freeSolo]);
    var listboxAvailable = open && filteredOptions.length > 0 && !readOnly;
    {
      if (value !== null && !freeSolo && options.length > 0) {
        var missingValue = (multiple ? value : [value]).filter(function (value2) {
          return !options.some(function (option) {
            return isOptionEqualToValue(option, value2);
          });
        });
        if (missingValue.length > 0) {
          console.warn(["MUI: The value provided to ".concat(componentName, " is invalid."), "None of the options match with `".concat(missingValue.length > 1 ? JSON.stringify(missingValue) : JSON.stringify(missingValue[0]), "`."), 'You can use the `isOptionEqualToValue` prop to customize the equality test.'].join('\n'));
        }
      }
    }
    var focusTag = useEventCallback(function (tagToFocus) {
      if (tagToFocus === -1) {
        inputRef.current.focus();
      } else {
        anchorEl.querySelector("[data-tag-index=\"".concat(tagToFocus, "\"]")).focus();
      }
    });

    // Ensure the focusedTag is never inconsistent
    React__namespace.useEffect(function () {
      if (multiple && focusedTag > value.length - 1) {
        setFocusedTag(-1);
        focusTag(-1);
      }
    }, [value, multiple, focusedTag, focusTag]);
    function validOptionIndex(index, direction) {
      if (!listboxRef.current || index < 0 || index >= filteredOptions.length) {
        return -1;
      }
      var nextFocus = index;
      while (true) {
        var option = listboxRef.current.querySelector("[data-option-index=\"".concat(nextFocus, "\"]"));

        // Same logic as MenuList.js
        var nextFocusDisabled = disabledItemsFocusable ? false : !option || option.disabled || option.getAttribute('aria-disabled') === 'true';
        if (option && option.hasAttribute('tabindex') && !nextFocusDisabled) {
          // The next option is available
          return nextFocus;
        }

        // The next option is disabled, move to the next element.
        // with looped index
        if (direction === 'next') {
          nextFocus = (nextFocus + 1) % filteredOptions.length;
        } else {
          nextFocus = (nextFocus - 1 + filteredOptions.length) % filteredOptions.length;
        }

        // We end up with initial index, that means we don't have available options.
        // All of them are disabled
        if (nextFocus === index) {
          return -1;
        }
      }
    }
    var setHighlightedIndex = useEventCallback(function (_ref2) {
      var event = _ref2.event,
        index = _ref2.index,
        _ref2$reason = _ref2.reason,
        reason = _ref2$reason === void 0 ? 'auto' : _ref2$reason;
      highlightedIndexRef.current = index;

      // does the index exist?
      if (index === -1) {
        inputRef.current.removeAttribute('aria-activedescendant');
      } else {
        inputRef.current.setAttribute('aria-activedescendant', "".concat(id, "-option-").concat(index));
      }
      if (onHighlightChange) {
        onHighlightChange(event, index === -1 ? null : filteredOptions[index], reason);
      }
      if (!listboxRef.current) {
        return;
      }
      var prev = listboxRef.current.querySelector("[role=\"option\"].".concat(unstable_classNamePrefix, "-focused"));
      if (prev) {
        prev.classList.remove("".concat(unstable_classNamePrefix, "-focused"));
        prev.classList.remove("".concat(unstable_classNamePrefix, "-focusVisible"));
      }
      var listboxNode = listboxRef.current;
      if (listboxRef.current.getAttribute('role') !== 'listbox') {
        listboxNode = listboxRef.current.parentElement.querySelector('[role="listbox"]');
      }

      // "No results"
      if (!listboxNode) {
        return;
      }
      if (index === -1) {
        listboxNode.scrollTop = 0;
        return;
      }
      var option = listboxRef.current.querySelector("[data-option-index=\"".concat(index, "\"]"));
      if (!option) {
        return;
      }
      option.classList.add("".concat(unstable_classNamePrefix, "-focused"));
      if (reason === 'keyboard') {
        option.classList.add("".concat(unstable_classNamePrefix, "-focusVisible"));
      }

      // Scroll active descendant into view.
      // Logic copied from https://www.w3.org/WAI/content-assets/wai-aria-practices/patterns/combobox/examples/js/select-only.js
      // In case of mouse clicks and touch (in mobile devices) we avoid scrolling the element and keep both behaviors same.
      // Consider this API instead once it has a better browser support:
      // .scrollIntoView({ scrollMode: 'if-needed', block: 'nearest' });
      if (listboxNode.scrollHeight > listboxNode.clientHeight && reason !== 'mouse' && reason !== 'touch') {
        var element = option;
        var scrollBottom = listboxNode.clientHeight + listboxNode.scrollTop;
        var elementBottom = element.offsetTop + element.offsetHeight;
        if (elementBottom > scrollBottom) {
          listboxNode.scrollTop = elementBottom - listboxNode.clientHeight;
        } else if (element.offsetTop - element.offsetHeight * (groupBy ? 1.3 : 0) < listboxNode.scrollTop) {
          listboxNode.scrollTop = element.offsetTop - element.offsetHeight * (groupBy ? 1.3 : 0);
        }
      }
    });
    var changeHighlightedIndex = useEventCallback(function (_ref3) {
      var event = _ref3.event,
        diff = _ref3.diff,
        _ref3$direction = _ref3.direction,
        direction = _ref3$direction === void 0 ? 'next' : _ref3$direction,
        _ref3$reason = _ref3.reason,
        reason = _ref3$reason === void 0 ? 'auto' : _ref3$reason;
      if (!popupOpen) {
        return;
      }
      var getNextIndex = function getNextIndex() {
        var maxIndex = filteredOptions.length - 1;
        if (diff === 'reset') {
          return defaultHighlighted;
        }
        if (diff === 'start') {
          return 0;
        }
        if (diff === 'end') {
          return maxIndex;
        }
        var newIndex = highlightedIndexRef.current + diff;
        if (newIndex < 0) {
          if (newIndex === -1 && includeInputInList) {
            return -1;
          }
          if (disableListWrap && highlightedIndexRef.current !== -1 || Math.abs(diff) > 1) {
            return 0;
          }
          return maxIndex;
        }
        if (newIndex > maxIndex) {
          if (newIndex === maxIndex + 1 && includeInputInList) {
            return -1;
          }
          if (disableListWrap || Math.abs(diff) > 1) {
            return maxIndex;
          }
          return 0;
        }
        return newIndex;
      };
      var nextIndex = validOptionIndex(getNextIndex(), direction);
      setHighlightedIndex({
        index: nextIndex,
        reason: reason,
        event: event
      });

      // Sync the content of the input with the highlighted option.
      if (autoComplete && diff !== 'reset') {
        if (nextIndex === -1) {
          inputRef.current.value = inputValue;
        } else {
          var option = getOptionLabel(filteredOptions[nextIndex]);
          inputRef.current.value = option;

          // The portion of the selected suggestion that has not been typed by the user,
          // a completion string, appears inline after the input cursor in the textbox.
          var index = option.toLowerCase().indexOf(inputValue.toLowerCase());
          if (index === 0 && inputValue.length > 0) {
            inputRef.current.setSelectionRange(inputValue.length, option.length);
          }
        }
      }
    });
    var getPreviousHighlightedOptionIndex = function getPreviousHighlightedOptionIndex() {
      var isSameValue = function isSameValue(value1, value2) {
        var label1 = value1 ? getOptionLabel(value1) : '';
        var label2 = value2 ? getOptionLabel(value2) : '';
        return label1 === label2;
      };
      if (highlightedIndexRef.current !== -1 && previousProps.filteredOptions && previousProps.filteredOptions.length !== filteredOptions.length && previousProps.inputValue === inputValue && (multiple ? value.length === previousProps.value.length && previousProps.value.every(function (val, i) {
        return getOptionLabel(value[i]) === getOptionLabel(val);
      }) : isSameValue(previousProps.value, value))) {
        var previousHighlightedOption = previousProps.filteredOptions[highlightedIndexRef.current];
        if (previousHighlightedOption) {
          return findIndex(filteredOptions, function (option) {
            return getOptionLabel(option) === getOptionLabel(previousHighlightedOption);
          });
        }
      }
      return -1;
    };
    var syncHighlightedIndex = React__namespace.useCallback(function () {
      if (!popupOpen) {
        return;
      }

      // Check if the previously highlighted option still exists in the updated filtered options list and if the value and inputValue haven't changed
      // If it exists and the value and the inputValue haven't changed, just update its index, otherwise continue execution
      var previousHighlightedOptionIndex = getPreviousHighlightedOptionIndex();
      if (previousHighlightedOptionIndex !== -1) {
        highlightedIndexRef.current = previousHighlightedOptionIndex;
        return;
      }
      var valueItem = multiple ? value[0] : value;

      // The popup is empty, reset
      if (filteredOptions.length === 0 || valueItem == null) {
        changeHighlightedIndex({
          diff: 'reset'
        });
        return;
      }
      if (!listboxRef.current) {
        return;
      }

      // Synchronize the value with the highlighted index
      if (valueItem != null) {
        var currentOption = filteredOptions[highlightedIndexRef.current];

        // Keep the current highlighted index if possible
        if (multiple && currentOption && findIndex(value, function (val) {
          return isOptionEqualToValue(currentOption, val);
        }) !== -1) {
          return;
        }
        var itemIndex = findIndex(filteredOptions, function (optionItem) {
          return isOptionEqualToValue(optionItem, valueItem);
        });
        if (itemIndex === -1) {
          changeHighlightedIndex({
            diff: 'reset'
          });
        } else {
          setHighlightedIndex({
            index: itemIndex
          });
        }
        return;
      }

      // Prevent the highlighted index to leak outside the boundaries.
      if (highlightedIndexRef.current >= filteredOptions.length - 1) {
        setHighlightedIndex({
          index: filteredOptions.length - 1
        });
        return;
      }

      // Restore the focus to the previous index.
      setHighlightedIndex({
        index: highlightedIndexRef.current
      });
      // Ignore filteredOptions (and options, isOptionEqualToValue, getOptionLabel) not to break the scroll position
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [
    // Only sync the highlighted index when the option switch between empty and not
    filteredOptions.length,
    // Don't sync the highlighted index with the value when multiple
    // eslint-disable-next-line react-hooks/exhaustive-deps
    multiple ? false : value, filterSelectedOptions, changeHighlightedIndex, setHighlightedIndex, popupOpen, inputValue, multiple]);
    var handleListboxRef = useEventCallback(function (node) {
      setRef(listboxRef, node);
      if (!node) {
        return;
      }
      syncHighlightedIndex();
    });
    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__namespace.useEffect(function () {
        if (!inputRef.current || inputRef.current.nodeName !== 'INPUT') {
          if (inputRef.current && inputRef.current.nodeName === 'TEXTAREA') {
            console.warn(["A textarea element was provided to ".concat(componentName, " where input was expected."), "This is not a supported scenario but it may work under certain conditions.", "A textarea keyboard navigation may conflict with Autocomplete controls (for example enter and arrow keys).", "Make sure to test keyboard navigation and add custom event handlers if necessary."].join('\n'));
          } else {
            console.error(["MUI: Unable to find the input element. It was resolved to ".concat(inputRef.current, " while an HTMLInputElement was expected."), "Instead, ".concat(componentName, " expects an input element."), '', componentName === 'useAutocomplete' ? 'Make sure you have bound getInputProps correctly and that the normal ref/effect resolutions order is guaranteed.' : 'Make sure you have customized the input component correctly.'].join('\n'));
          }
        }
      }, [componentName]);
    }
    React__namespace.useEffect(function () {
      syncHighlightedIndex();
    }, [syncHighlightedIndex]);
    var handleOpen = function handleOpen(event) {
      if (open) {
        return;
      }
      setOpenState(true);
      setInputPristine(true);
      if (onOpen) {
        onOpen(event);
      }
    };
    var handleClose = function handleClose(event, reason) {
      if (!open) {
        return;
      }
      setOpenState(false);
      if (onClose) {
        onClose(event, reason);
      }
    };
    var handleValue = function handleValue(event, newValue, reason, details) {
      if (multiple) {
        if (value.length === newValue.length && value.every(function (val, i) {
          return val === newValue[i];
        })) {
          return;
        }
      } else if (value === newValue) {
        return;
      }
      if (onChange) {
        onChange(event, newValue, reason, details);
      }
      setValueState(newValue);
    };
    var isTouch = React__namespace.useRef(false);
    var selectNewValue = function selectNewValue(event, option) {
      var reasonProp = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'selectOption';
      var origin = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'options';
      var reason = reasonProp;
      var newValue = option;
      if (multiple) {
        newValue = Array.isArray(value) ? value.slice() : [];
        {
          var matches = newValue.filter(function (val) {
            return isOptionEqualToValue(option, val);
          });
          if (matches.length > 1) {
            console.error(["MUI: The `isOptionEqualToValue` method of ".concat(componentName, " does not handle the arguments correctly."), "The component expects a single value to match a given option but found ".concat(matches.length, " matches.")].join('\n'));
          }
        }
        var itemIndex = findIndex(newValue, function (valueItem) {
          return isOptionEqualToValue(option, valueItem);
        });
        if (itemIndex === -1) {
          newValue.push(option);
        } else if (origin !== 'freeSolo') {
          newValue.splice(itemIndex, 1);
          reason = 'removeOption';
        }
      }
      resetInputValue(event, newValue);
      handleValue(event, newValue, reason, {
        option: option
      });
      if (!disableCloseOnSelect && (!event || !event.ctrlKey && !event.metaKey)) {
        handleClose(event, reason);
      }
      if (blurOnSelect === true || blurOnSelect === 'touch' && isTouch.current || blurOnSelect === 'mouse' && !isTouch.current) {
        inputRef.current.blur();
      }
    };
    function validTagIndex(index, direction) {
      if (index === -1) {
        return -1;
      }
      var nextFocus = index;
      while (true) {
        // Out of range
        if (direction === 'next' && nextFocus === value.length || direction === 'previous' && nextFocus === -1) {
          return -1;
        }
        var option = anchorEl.querySelector("[data-tag-index=\"".concat(nextFocus, "\"]"));

        // Same logic as MenuList.js
        if (!option || !option.hasAttribute('tabindex') || option.disabled || option.getAttribute('aria-disabled') === 'true') {
          nextFocus += direction === 'next' ? 1 : -1;
        } else {
          return nextFocus;
        }
      }
    }
    var handleFocusTag = function handleFocusTag(event, direction) {
      if (!multiple) {
        return;
      }
      if (inputValue === '') {
        handleClose(event, 'toggleInput');
      }
      var nextTag = focusedTag;
      if (focusedTag === -1) {
        if (inputValue === '' && direction === 'previous') {
          nextTag = value.length - 1;
        }
      } else {
        nextTag += direction === 'next' ? 1 : -1;
        if (nextTag < 0) {
          nextTag = 0;
        }
        if (nextTag === value.length) {
          nextTag = -1;
        }
      }
      nextTag = validTagIndex(nextTag, direction);
      setFocusedTag(nextTag);
      focusTag(nextTag);
    };
    var handleClear = function handleClear(event) {
      ignoreFocus.current = true;
      setInputValueState('');
      if (onInputChange) {
        onInputChange(event, '', 'clear');
      }
      handleValue(event, multiple ? [] : null, 'clear');
    };
    var handleKeyDown = function handleKeyDown(other) {
      return function (event) {
        if (other.onKeyDown) {
          other.onKeyDown(event);
        }
        if (event.defaultMuiPrevented) {
          return;
        }
        if (focusedTag !== -1 && ['ArrowLeft', 'ArrowRight'].indexOf(event.key) === -1) {
          setFocusedTag(-1);
          focusTag(-1);
        }

        // Wait until IME is settled.
        if (event.which !== 229) {
          switch (event.key) {
            case 'Home':
              if (popupOpen && handleHomeEndKeys) {
                // Prevent scroll of the page
                event.preventDefault();
                changeHighlightedIndex({
                  diff: 'start',
                  direction: 'next',
                  reason: 'keyboard',
                  event: event
                });
              }
              break;
            case 'End':
              if (popupOpen && handleHomeEndKeys) {
                // Prevent scroll of the page
                event.preventDefault();
                changeHighlightedIndex({
                  diff: 'end',
                  direction: 'previous',
                  reason: 'keyboard',
                  event: event
                });
              }
              break;
            case 'PageUp':
              // Prevent scroll of the page
              event.preventDefault();
              changeHighlightedIndex({
                diff: -pageSize,
                direction: 'previous',
                reason: 'keyboard',
                event: event
              });
              handleOpen(event);
              break;
            case 'PageDown':
              // Prevent scroll of the page
              event.preventDefault();
              changeHighlightedIndex({
                diff: pageSize,
                direction: 'next',
                reason: 'keyboard',
                event: event
              });
              handleOpen(event);
              break;
            case 'ArrowDown':
              // Prevent cursor move
              event.preventDefault();
              changeHighlightedIndex({
                diff: 1,
                direction: 'next',
                reason: 'keyboard',
                event: event
              });
              handleOpen(event);
              break;
            case 'ArrowUp':
              // Prevent cursor move
              event.preventDefault();
              changeHighlightedIndex({
                diff: -1,
                direction: 'previous',
                reason: 'keyboard',
                event: event
              });
              handleOpen(event);
              break;
            case 'ArrowLeft':
              handleFocusTag(event, 'previous');
              break;
            case 'ArrowRight':
              handleFocusTag(event, 'next');
              break;
            case 'Enter':
              if (highlightedIndexRef.current !== -1 && popupOpen) {
                var option = filteredOptions[highlightedIndexRef.current];
                var disabled = getOptionDisabled ? getOptionDisabled(option) : false;

                // Avoid early form validation, let the end-users continue filling the form.
                event.preventDefault();
                if (disabled) {
                  return;
                }
                selectNewValue(event, option, 'selectOption');

                // Move the selection to the end.
                if (autoComplete) {
                  inputRef.current.setSelectionRange(inputRef.current.value.length, inputRef.current.value.length);
                }
              } else if (freeSolo && inputValue !== '' && inputValueIsSelectedValue === false) {
                if (multiple) {
                  // Allow people to add new values before they submit the form.
                  event.preventDefault();
                }
                selectNewValue(event, inputValue, 'createOption', 'freeSolo');
              }
              break;
            case 'Escape':
              if (popupOpen) {
                // Avoid Opera to exit fullscreen mode.
                event.preventDefault();
                // Avoid the Modal to handle the event.
                event.stopPropagation();
                handleClose(event, 'escape');
              } else if (clearOnEscape && (inputValue !== '' || multiple && value.length > 0)) {
                // Avoid Opera to exit fullscreen mode.
                event.preventDefault();
                // Avoid the Modal to handle the event.
                event.stopPropagation();
                handleClear(event);
              }
              break;
            case 'Backspace':
              // Remove the value on the left of the "cursor"
              if (multiple && !readOnly && inputValue === '' && value.length > 0) {
                var index = focusedTag === -1 ? value.length - 1 : focusedTag;
                var newValue = value.slice();
                newValue.splice(index, 1);
                handleValue(event, newValue, 'removeOption', {
                  option: value[index]
                });
              }
              break;
            case 'Delete':
              // Remove the value on the right of the "cursor"
              if (multiple && !readOnly && inputValue === '' && value.length > 0 && focusedTag !== -1) {
                var _index = focusedTag;
                var _newValue = value.slice();
                _newValue.splice(_index, 1);
                handleValue(event, _newValue, 'removeOption', {
                  option: value[_index]
                });
              }
              break;
          }
        }
      };
    };
    var handleFocus = function handleFocus(event) {
      setFocused(true);
      if (openOnFocus && !ignoreFocus.current) {
        handleOpen(event);
      }
    };
    var handleBlur = function handleBlur(event) {
      // Ignore the event when using the scrollbar with IE11
      if (unstable_isActiveElementInListbox(listboxRef)) {
        inputRef.current.focus();
        return;
      }
      setFocused(false);
      firstFocus.current = true;
      ignoreFocus.current = false;
      if (autoSelect && highlightedIndexRef.current !== -1 && popupOpen) {
        selectNewValue(event, filteredOptions[highlightedIndexRef.current], 'blur');
      } else if (autoSelect && freeSolo && inputValue !== '') {
        selectNewValue(event, inputValue, 'blur', 'freeSolo');
      } else if (clearOnBlur) {
        resetInputValue(event, value);
      }
      handleClose(event, 'blur');
    };
    var handleInputChange = function handleInputChange(event) {
      var newValue = event.target.value;
      if (inputValue !== newValue) {
        setInputValueState(newValue);
        setInputPristine(false);
        if (onInputChange) {
          onInputChange(event, newValue, 'input');
        }
      }
      if (newValue === '') {
        if (!disableClearable && !multiple) {
          handleValue(event, null, 'clear');
        }
      } else {
        handleOpen(event);
      }
    };
    var handleOptionMouseMove = function handleOptionMouseMove(event) {
      var index = Number(event.currentTarget.getAttribute('data-option-index'));
      if (highlightedIndexRef.current !== index) {
        setHighlightedIndex({
          event: event,
          index: index,
          reason: 'mouse'
        });
      }
    };
    var handleOptionTouchStart = function handleOptionTouchStart(event) {
      setHighlightedIndex({
        event: event,
        index: Number(event.currentTarget.getAttribute('data-option-index')),
        reason: 'touch'
      });
      isTouch.current = true;
    };
    var handleOptionClick = function handleOptionClick(event) {
      var index = Number(event.currentTarget.getAttribute('data-option-index'));
      selectNewValue(event, filteredOptions[index], 'selectOption');
      isTouch.current = false;
    };
    var handleTagDelete = function handleTagDelete(index) {
      return function (event) {
        var newValue = value.slice();
        newValue.splice(index, 1);
        handleValue(event, newValue, 'removeOption', {
          option: value[index]
        });
      };
    };
    var handlePopupIndicator = function handlePopupIndicator(event) {
      if (open) {
        handleClose(event, 'toggleInput');
      } else {
        handleOpen(event);
      }
    };

    // Prevent input blur when interacting with the combobox
    var handleMouseDown = function handleMouseDown(event) {
      // Prevent focusing the input if click is anywhere outside the Autocomplete
      if (!event.currentTarget.contains(event.target)) {
        return;
      }
      if (event.target.getAttribute('id') !== id) {
        event.preventDefault();
      }
    };

    // Focus the input when interacting with the combobox
    var handleClick = function handleClick(event) {
      // Prevent focusing the input if click is anywhere outside the Autocomplete
      if (!event.currentTarget.contains(event.target)) {
        return;
      }
      inputRef.current.focus();
      if (selectOnFocus && firstFocus.current && inputRef.current.selectionEnd - inputRef.current.selectionStart === 0) {
        inputRef.current.select();
      }
      firstFocus.current = false;
    };
    var handleInputMouseDown = function handleInputMouseDown(event) {
      if (!disabledProp && (inputValue === '' || !open)) {
        handlePopupIndicator(event);
      }
    };
    var dirty = freeSolo && inputValue.length > 0;
    dirty = dirty || (multiple ? value.length > 0 : value !== null);
    var groupedOptions = filteredOptions;
    if (groupBy) {
      // used to keep track of key and indexes in the result array
      var indexBy = new Map();
      var warn = false;
      groupedOptions = filteredOptions.reduce(function (acc, option, index) {
        var group = groupBy(option);
        if (acc.length > 0 && acc[acc.length - 1].group === group) {
          acc[acc.length - 1].options.push(option);
        } else {
          {
            if (indexBy.get(group) && !warn) {
              console.warn("MUI: The options provided combined with the `groupBy` method of ".concat(componentName, " returns duplicated headers."), 'You can solve the issue by sorting the options with the output of `groupBy`.');
              warn = true;
            }
            indexBy.set(group, true);
          }
          acc.push({
            key: index,
            index: index,
            group: group,
            options: [option]
          });
        }
        return acc;
      }, []);
    }
    if (disabledProp && focused) {
      handleBlur();
    }
    return {
      getRootProps: function getRootProps() {
        var other = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        return _extends({
          'aria-owns': listboxAvailable ? "".concat(id, "-listbox") : null
        }, other, {
          onKeyDown: handleKeyDown(other),
          onMouseDown: handleMouseDown,
          onClick: handleClick
        });
      },
      getInputLabelProps: function getInputLabelProps() {
        return {
          id: "".concat(id, "-label"),
          htmlFor: id
        };
      },
      getInputProps: function getInputProps() {
        return {
          id: id,
          value: inputValue,
          onBlur: handleBlur,
          onFocus: handleFocus,
          onChange: handleInputChange,
          onMouseDown: handleInputMouseDown,
          // if open then this is handled imperatively so don't let react override
          // only have an opinion about this when closed
          'aria-activedescendant': popupOpen ? '' : null,
          'aria-autocomplete': autoComplete ? 'both' : 'list',
          'aria-controls': listboxAvailable ? "".concat(id, "-listbox") : undefined,
          'aria-expanded': listboxAvailable,
          // Disable browser's suggestion that might overlap with the popup.
          // Handle autocomplete but not autofill.
          autoComplete: 'off',
          ref: inputRef,
          autoCapitalize: 'none',
          spellCheck: 'false',
          role: 'combobox',
          disabled: disabledProp
        };
      },
      getClearProps: function getClearProps() {
        return {
          tabIndex: -1,
          type: 'button',
          onClick: handleClear
        };
      },
      getPopupIndicatorProps: function getPopupIndicatorProps() {
        return {
          tabIndex: -1,
          type: 'button',
          onClick: handlePopupIndicator
        };
      },
      getTagProps: function getTagProps(_ref4) {
        var index = _ref4.index;
        return _extends({
          key: index,
          'data-tag-index': index,
          tabIndex: -1
        }, !readOnly && {
          onDelete: handleTagDelete(index)
        });
      },
      getListboxProps: function getListboxProps() {
        return {
          role: 'listbox',
          id: "".concat(id, "-listbox"),
          'aria-labelledby': "".concat(id, "-label"),
          ref: handleListboxRef,
          onMouseDown: function onMouseDown(event) {
            // Prevent blur
            event.preventDefault();
          }
        };
      },
      getOptionProps: function getOptionProps(_ref5) {
        var _getOptionKey;
        var index = _ref5.index,
          option = _ref5.option;
        var selected = (multiple ? value : [value]).some(function (value2) {
          return value2 != null && isOptionEqualToValue(option, value2);
        });
        var disabled = getOptionDisabled ? getOptionDisabled(option) : false;
        return {
          key: (_getOptionKey = getOptionKey == null ? void 0 : getOptionKey(option)) != null ? _getOptionKey : getOptionLabel(option),
          tabIndex: -1,
          role: 'option',
          id: "".concat(id, "-option-").concat(index),
          onMouseMove: handleOptionMouseMove,
          onClick: handleOptionClick,
          onTouchStart: handleOptionTouchStart,
          'data-option-index': index,
          'aria-disabled': disabled,
          'aria-selected': selected
        };
      },
      id: id,
      inputValue: inputValue,
      value: value,
      dirty: dirty,
      expanded: popupOpen && anchorEl,
      popupOpen: popupOpen,
      focused: focused || focusedTag !== -1,
      anchorEl: anchorEl,
      setAnchorEl: setAnchorEl,
      focusedTag: focusedTag,
      groupedOptions: groupedOptions
    };
  }

  var PopperRoot = styled$1(Popper$2, {
    name: 'MuiPopper',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.root;
    }
  })({});

  /**
   *
   * Demos:
   *
   * - [Autocomplete](https://mui.com/material-ui/react-autocomplete/)
   * - [Menu](https://mui.com/material-ui/react-menu/)
   * - [Popper](https://mui.com/material-ui/react-popper/)
   *
   * API:
   *
   * - [Popper API](https://mui.com/material-ui/api/popper/)
   */
  var Popper = /*#__PURE__*/React__namespace.forwardRef(function Popper(inProps, ref) {
    var _slots$root;
    var theme = useTheme$3();
    var props = useThemeProps$b({
      props: inProps,
      name: 'MuiPopper'
    });
    var anchorEl = props.anchorEl,
      component = props.component,
      components = props.components,
      componentsProps = props.componentsProps,
      container = props.container,
      disablePortal = props.disablePortal,
      keepMounted = props.keepMounted,
      modifiers = props.modifiers,
      open = props.open,
      placement = props.placement,
      popperOptions = props.popperOptions,
      popperRef = props.popperRef,
      transition = props.transition,
      slots = props.slots,
      slotProps = props.slotProps,
      other = _objectWithoutProperties(props, ["anchorEl", "component", "components", "componentsProps", "container", "disablePortal", "keepMounted", "modifiers", "open", "placement", "popperOptions", "popperRef", "transition", "slots", "slotProps"]);
    var RootComponent = (_slots$root = slots == null ? void 0 : slots.root) != null ? _slots$root : components == null ? void 0 : components.Root;
    var otherProps = _extends({
      anchorEl: anchorEl,
      container: container,
      disablePortal: disablePortal,
      keepMounted: keepMounted,
      modifiers: modifiers,
      open: open,
      placement: placement,
      popperOptions: popperOptions,
      popperRef: popperRef,
      transition: transition
    }, other);
    return /*#__PURE__*/jsxRuntime_1(PopperRoot, _extends({
      as: component,
      direction: theme == null ? void 0 : theme.direction,
      slots: {
        root: RootComponent
      },
      slotProps: slotProps != null ? slotProps : componentsProps
    }, otherProps, {
      ref: ref
    }));
  });
  Popper.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │ To update them, edit the TypeScript types and run `pnpm proptypes`. │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * An HTML element, [virtualElement](https://popper.js.org/docs/v2/virtual-elements/),
     * or a function that returns either.
     * It's used to set the position of the popper.
     * The return value will passed as the reference object of the Popper instance.
     */
    anchorEl: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([HTMLElementType, PropTypes.object, PropTypes.func]),
    /**
     * Popper render function or node.
     */
    children: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.node, PropTypes.func]),
    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,
    /**
     * The components used for each slot inside the Popper.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    components: PropTypes.shape({
      Root: PropTypes.elementType
    }),
    /**
     * The props used for each slot inside the Popper.
     * @default {}
     */
    componentsProps: PropTypes.shape({
      root: PropTypes.oneOfType([PropTypes.func, PropTypes.object])
    }),
    /**
     * An HTML element or function that returns one.
     * The `container` will have the portal children appended to it.
     *
     * You can also provide a callback, which is called in a React layout effect.
     * This lets you set the container from a ref, and also makes server-side rendering possible.
     *
     * By default, it uses the body of the top-level document object,
     * so it's simply `document.body` most of the time.
     */
    container: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([HTMLElementType, PropTypes.func]),
    /**
     * The `children` will be under the DOM hierarchy of the parent component.
     * @default false
     */
    disablePortal: PropTypes.bool,
    /**
     * Always keep the children in the DOM.
     * This prop can be useful in SEO situation or
     * when you want to maximize the responsiveness of the Popper.
     * @default false
     */
    keepMounted: PropTypes.bool,
    /**
     * Popper.js is based on a "plugin-like" architecture,
     * most of its features are fully encapsulated "modifiers".
     *
     * A modifier is a function that is called each time Popper.js needs to
     * compute the position of the popper.
     * For this reason, modifiers should be very performant to avoid bottlenecks.
     * To learn how to create a modifier, [read the modifiers documentation](https://popper.js.org/docs/v2/modifiers/).
     */
    modifiers: PropTypes.arrayOf(PropTypes.shape({
      data: PropTypes.object,
      effect: PropTypes.func,
      enabled: PropTypes.bool,
      fn: PropTypes.func,
      name: PropTypes.any,
      options: PropTypes.object,
      phase: PropTypes.oneOf(['afterMain', 'afterRead', 'afterWrite', 'beforeMain', 'beforeRead', 'beforeWrite', 'main', 'read', 'write']),
      requires: PropTypes.arrayOf(PropTypes.string),
      requiresIfExists: PropTypes.arrayOf(PropTypes.string)
    })),
    /**
     * If `true`, the component is shown.
     */
    open: PropTypes.bool.isRequired,
    /**
     * Popper placement.
     * @default 'bottom'
     */
    placement: PropTypes.oneOf(['auto-end', 'auto-start', 'auto', 'bottom-end', 'bottom-start', 'bottom', 'left-end', 'left-start', 'left', 'right-end', 'right-start', 'right', 'top-end', 'top-start', 'top']),
    /**
     * Options provided to the [`Popper.js`](https://popper.js.org/docs/v2/constructors/#options) instance.
     * @default {}
     */
    popperOptions: PropTypes.shape({
      modifiers: PropTypes.array,
      onFirstUpdate: PropTypes.func,
      placement: PropTypes.oneOf(['auto-end', 'auto-start', 'auto', 'bottom-end', 'bottom-start', 'bottom', 'left-end', 'left-start', 'left', 'right-end', 'right-start', 'right', 'top-end', 'top-start', 'top']),
      strategy: PropTypes.oneOf(['absolute', 'fixed'])
    }),
    /**
     * A ref that points to the used popper instance.
     */
    popperRef: refType$1,
    /**
     * The props used for each slot inside the Popper.
     * @default {}
     */
    slotProps: PropTypes.shape({
      root: PropTypes.oneOfType([PropTypes.func, PropTypes.object])
    }),
    /**
     * The components used for each slot inside the Popper.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    slots: PropTypes.shape({
      root: PropTypes.elementType
    }),
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
    /**
     * Help supporting a react-transition-group/Transition component.
     * @default false
     */
    transition: PropTypes.bool
  } ;
  var Popper$1 = Popper;

  function getListSubheaderUtilityClass(slot) {
    return generateUtilityClass$1('MuiListSubheader', slot);
  }
  var listSubheaderClasses = generateUtilityClasses$1('MuiListSubheader', ['root', 'colorPrimary', 'colorInherit', 'gutters', 'inset', 'sticky']);
  var listSubheaderClasses$1 = listSubheaderClasses;

  var useUtilityClasses$1A = function useUtilityClasses(ownerState) {
    var classes = ownerState.classes,
      color = ownerState.color,
      disableGutters = ownerState.disableGutters,
      inset = ownerState.inset,
      disableSticky = ownerState.disableSticky;
    var slots = {
      root: ['root', color !== 'default' && "color".concat(capitalize(color)), !disableGutters && 'gutters', inset && 'inset', !disableSticky && 'sticky']
    };
    return composeClasses(slots, getListSubheaderUtilityClass, classes);
  };
  var ListSubheaderRoot = styled$1('li', {
    name: 'MuiListSubheader',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      return [styles.root, ownerState.color !== 'default' && styles["color".concat(capitalize(ownerState.color))], !ownerState.disableGutters && styles.gutters, ownerState.inset && styles.inset, !ownerState.disableSticky && styles.sticky];
    }
  })(function (_ref) {
    var theme = _ref.theme,
      ownerState = _ref.ownerState;
    return _extends({
      boxSizing: 'border-box',
      lineHeight: '48px',
      listStyle: 'none',
      color: (theme.vars || theme).palette.text.secondary,
      fontFamily: theme.typography.fontFamily,
      fontWeight: theme.typography.fontWeightMedium,
      fontSize: theme.typography.pxToRem(14)
    }, ownerState.color === 'primary' && {
      color: (theme.vars || theme).palette.primary.main
    }, ownerState.color === 'inherit' && {
      color: 'inherit'
    }, !ownerState.disableGutters && {
      paddingLeft: 16,
      paddingRight: 16
    }, ownerState.inset && {
      paddingLeft: 72
    }, !ownerState.disableSticky && {
      position: 'sticky',
      top: 0,
      zIndex: 1,
      backgroundColor: (theme.vars || theme).palette.background.paper
    });
  });
  var ListSubheader = /*#__PURE__*/React__namespace.forwardRef(function ListSubheader(inProps, ref) {
    var props = useThemeProps$b({
      props: inProps,
      name: 'MuiListSubheader'
    });
    var className = props.className,
      _props$color = props.color,
      color = _props$color === void 0 ? 'default' : _props$color,
      _props$component = props.component,
      component = _props$component === void 0 ? 'li' : _props$component,
      _props$disableGutters = props.disableGutters,
      disableGutters = _props$disableGutters === void 0 ? false : _props$disableGutters,
      _props$disableSticky = props.disableSticky,
      disableSticky = _props$disableSticky === void 0 ? false : _props$disableSticky,
      _props$inset = props.inset,
      inset = _props$inset === void 0 ? false : _props$inset,
      other = _objectWithoutProperties(props, ["className", "color", "component", "disableGutters", "disableSticky", "inset"]);
    var ownerState = _extends({}, props, {
      color: color,
      component: component,
      disableGutters: disableGutters,
      disableSticky: disableSticky,
      inset: inset
    });
    var classes = useUtilityClasses$1A(ownerState);
    return /*#__PURE__*/jsxRuntime_1(ListSubheaderRoot, _extends({
      as: component,
      className: clsx(classes.root, className),
      ref: ref,
      ownerState: ownerState
    }, other));
  });
  ListSubheader.muiSkipListHighlight = true;
  ListSubheader.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The content of the component.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     * @default 'default'
     */
    color: PropTypes.oneOf(['default', 'inherit', 'primary']),
    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,
    /**
     * If `true`, the List Subheader will not have gutters.
     * @default false
     */
    disableGutters: PropTypes.bool,
    /**
     * If `true`, the List Subheader will not stick to the top during scroll.
     * @default false
     */
    disableSticky: PropTypes.bool,
    /**
     * If `true`, the List Subheader is indented.
     * @default false
     */
    inset: PropTypes.bool,
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var ListSubheader$1 = ListSubheader;

  var CancelIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z"
  }), 'Cancel');

  function getChipUtilityClass(slot) {
    return generateUtilityClass$1('MuiChip', slot);
  }
  var chipClasses = generateUtilityClasses$1('MuiChip', ['root', 'sizeSmall', 'sizeMedium', 'colorError', 'colorInfo', 'colorPrimary', 'colorSecondary', 'colorSuccess', 'colorWarning', 'disabled', 'clickable', 'clickableColorPrimary', 'clickableColorSecondary', 'deletable', 'deletableColorPrimary', 'deletableColorSecondary', 'outlined', 'filled', 'outlinedPrimary', 'outlinedSecondary', 'filledPrimary', 'filledSecondary', 'avatar', 'avatarSmall', 'avatarMedium', 'avatarColorPrimary', 'avatarColorSecondary', 'icon', 'iconSmall', 'iconMedium', 'iconColorPrimary', 'iconColorSecondary', 'label', 'labelSmall', 'labelMedium', 'deleteIcon', 'deleteIconSmall', 'deleteIconMedium', 'deleteIconColorPrimary', 'deleteIconColorSecondary', 'deleteIconOutlinedColorPrimary', 'deleteIconOutlinedColorSecondary', 'deleteIconFilledColorPrimary', 'deleteIconFilledColorSecondary', 'focusVisible']);
  var chipClasses$1 = chipClasses;

  var useUtilityClasses$1z = function useUtilityClasses(ownerState) {
    var classes = ownerState.classes,
      disabled = ownerState.disabled,
      size = ownerState.size,
      color = ownerState.color,
      iconColor = ownerState.iconColor,
      onDelete = ownerState.onDelete,
      clickable = ownerState.clickable,
      variant = ownerState.variant;
    var slots = {
      root: ['root', variant, disabled && 'disabled', "size".concat(capitalize(size)), "color".concat(capitalize(color)), clickable && 'clickable', clickable && "clickableColor".concat(capitalize(color)), onDelete && 'deletable', onDelete && "deletableColor".concat(capitalize(color)), "".concat(variant).concat(capitalize(color))],
      label: ['label', "label".concat(capitalize(size))],
      avatar: ['avatar', "avatar".concat(capitalize(size)), "avatarColor".concat(capitalize(color))],
      icon: ['icon', "icon".concat(capitalize(size)), "iconColor".concat(capitalize(iconColor))],
      deleteIcon: ['deleteIcon', "deleteIcon".concat(capitalize(size)), "deleteIconColor".concat(capitalize(color)), "deleteIcon".concat(capitalize(variant), "Color").concat(capitalize(color))]
    };
    return composeClasses(slots, getChipUtilityClass, classes);
  };
  var ChipRoot = styled$1('div', {
    name: 'MuiChip',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      var color = ownerState.color,
        iconColor = ownerState.iconColor,
        clickable = ownerState.clickable,
        onDelete = ownerState.onDelete,
        size = ownerState.size,
        variant = ownerState.variant;
      return [_defineProperty({}, "& .".concat(chipClasses$1.avatar), styles.avatar), _defineProperty({}, "& .".concat(chipClasses$1.avatar), styles["avatar".concat(capitalize(size))]), _defineProperty({}, "& .".concat(chipClasses$1.avatar), styles["avatarColor".concat(capitalize(color))]), _defineProperty({}, "& .".concat(chipClasses$1.icon), styles.icon), _defineProperty({}, "& .".concat(chipClasses$1.icon), styles["icon".concat(capitalize(size))]), _defineProperty({}, "& .".concat(chipClasses$1.icon), styles["iconColor".concat(capitalize(iconColor))]), _defineProperty({}, "& .".concat(chipClasses$1.deleteIcon), styles.deleteIcon), _defineProperty({}, "& .".concat(chipClasses$1.deleteIcon), styles["deleteIcon".concat(capitalize(size))]), _defineProperty({}, "& .".concat(chipClasses$1.deleteIcon), styles["deleteIconColor".concat(capitalize(color))]), _defineProperty({}, "& .".concat(chipClasses$1.deleteIcon), styles["deleteIcon".concat(capitalize(variant), "Color").concat(capitalize(color))]), styles.root, styles["size".concat(capitalize(size))], styles["color".concat(capitalize(color))], clickable && styles.clickable, clickable && color !== 'default' && styles["clickableColor".concat(capitalize(color), ")")], onDelete && styles.deletable, onDelete && color !== 'default' && styles["deletableColor".concat(capitalize(color))], styles[variant], styles["".concat(variant).concat(capitalize(color))]];
    }
  })(function (_ref11) {
    var theme = _ref11.theme,
      ownerState = _ref11.ownerState;
    var textColor = theme.palette.mode === 'light' ? theme.palette.grey[700] : theme.palette.grey[300];
    return _extends(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty({
      maxWidth: '100%',
      fontFamily: theme.typography.fontFamily,
      fontSize: theme.typography.pxToRem(13),
      display: 'inline-flex',
      alignItems: 'center',
      justifyContent: 'center',
      height: 32,
      color: (theme.vars || theme).palette.text.primary,
      backgroundColor: (theme.vars || theme).palette.action.selected,
      borderRadius: 32 / 2,
      whiteSpace: 'nowrap',
      transition: theme.transitions.create(['background-color', 'box-shadow']),
      // reset cursor explicitly in case ButtonBase is used
      cursor: 'unset',
      // We disable the focus ring for mouse, touch and keyboard users.
      outline: 0,
      textDecoration: 'none',
      border: 0,
      // Remove `button` border
      padding: 0,
      // Remove `button` padding
      verticalAlign: 'middle',
      boxSizing: 'border-box'
    }, "&.".concat(chipClasses$1.disabled), {
      opacity: (theme.vars || theme).palette.action.disabledOpacity,
      pointerEvents: 'none'
    }), "& .".concat(chipClasses$1.avatar), {
      marginLeft: 5,
      marginRight: -6,
      width: 24,
      height: 24,
      color: theme.vars ? theme.vars.palette.Chip.defaultAvatarColor : textColor,
      fontSize: theme.typography.pxToRem(12)
    }), "& .".concat(chipClasses$1.avatarColorPrimary), {
      color: (theme.vars || theme).palette.primary.contrastText,
      backgroundColor: (theme.vars || theme).palette.primary.dark
    }), "& .".concat(chipClasses$1.avatarColorSecondary), {
      color: (theme.vars || theme).palette.secondary.contrastText,
      backgroundColor: (theme.vars || theme).palette.secondary.dark
    }), "& .".concat(chipClasses$1.avatarSmall), {
      marginLeft: 4,
      marginRight: -4,
      width: 18,
      height: 18,
      fontSize: theme.typography.pxToRem(10)
    }), "& .".concat(chipClasses$1.icon), _extends({
      marginLeft: 5,
      marginRight: -6
    }, ownerState.size === 'small' && {
      fontSize: 18,
      marginLeft: 4,
      marginRight: -4
    }, ownerState.iconColor === ownerState.color && _extends({
      color: theme.vars ? theme.vars.palette.Chip.defaultIconColor : textColor
    }, ownerState.color !== 'default' && {
      color: 'inherit'
    }))), "& .".concat(chipClasses$1.deleteIcon), _extends({
      WebkitTapHighlightColor: 'transparent',
      color: theme.vars ? "rgba(".concat(theme.vars.palette.text.primaryChannel, " / 0.26)") : alpha(theme.palette.text.primary, 0.26),
      fontSize: 22,
      cursor: 'pointer',
      margin: '0 5px 0 -6px',
      '&:hover': {
        color: theme.vars ? "rgba(".concat(theme.vars.palette.text.primaryChannel, " / 0.4)") : alpha(theme.palette.text.primary, 0.4)
      }
    }, ownerState.size === 'small' && {
      fontSize: 16,
      marginRight: 4,
      marginLeft: -4
    }, ownerState.color !== 'default' && {
      color: theme.vars ? "rgba(".concat(theme.vars.palette[ownerState.color].contrastTextChannel, " / 0.7)") : alpha(theme.palette[ownerState.color].contrastText, 0.7),
      '&:hover, &:active': {
        color: (theme.vars || theme).palette[ownerState.color].contrastText
      }
    })), ownerState.size === 'small' && {
      height: 24
    }, ownerState.color !== 'default' && {
      backgroundColor: (theme.vars || theme).palette[ownerState.color].main,
      color: (theme.vars || theme).palette[ownerState.color].contrastText
    }, ownerState.onDelete && _defineProperty({}, "&.".concat(chipClasses$1.focusVisible), {
      backgroundColor: theme.vars ? "rgba(".concat(theme.vars.palette.action.selectedChannel, " / calc(").concat(theme.vars.palette.action.selectedOpacity, " + ").concat(theme.vars.palette.action.focusOpacity, "))") : alpha(theme.palette.action.selected, theme.palette.action.selectedOpacity + theme.palette.action.focusOpacity)
    }), ownerState.onDelete && ownerState.color !== 'default' && _defineProperty({}, "&.".concat(chipClasses$1.focusVisible), {
      backgroundColor: (theme.vars || theme).palette[ownerState.color].dark
    }));
  }, function (_ref14) {
    var theme = _ref14.theme,
      ownerState = _ref14.ownerState;
    return _extends({}, ownerState.clickable && _defineProperty(_defineProperty({
      userSelect: 'none',
      WebkitTapHighlightColor: 'transparent',
      cursor: 'pointer',
      '&:hover': {
        backgroundColor: theme.vars ? "rgba(".concat(theme.vars.palette.action.selectedChannel, " / calc(").concat(theme.vars.palette.action.selectedOpacity, " + ").concat(theme.vars.palette.action.hoverOpacity, "))") : alpha(theme.palette.action.selected, theme.palette.action.selectedOpacity + theme.palette.action.hoverOpacity)
      }
    }, "&.".concat(chipClasses$1.focusVisible), {
      backgroundColor: theme.vars ? "rgba(".concat(theme.vars.palette.action.selectedChannel, " / calc(").concat(theme.vars.palette.action.selectedOpacity, " + ").concat(theme.vars.palette.action.focusOpacity, "))") : alpha(theme.palette.action.selected, theme.palette.action.selectedOpacity + theme.palette.action.focusOpacity)
    }), '&:active', {
      boxShadow: (theme.vars || theme).shadows[1]
    }), ownerState.clickable && ownerState.color !== 'default' && _defineProperty({}, "&:hover, &.".concat(chipClasses$1.focusVisible), {
      backgroundColor: (theme.vars || theme).palette[ownerState.color].dark
    }));
  }, function (_ref17) {
    var theme = _ref17.theme,
      ownerState = _ref17.ownerState;
    return _extends({}, ownerState.variant === 'outlined' && _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty({
      backgroundColor: 'transparent',
      border: theme.vars ? "1px solid ".concat(theme.vars.palette.Chip.defaultBorder) : "1px solid ".concat(theme.palette.mode === 'light' ? theme.palette.grey[400] : theme.palette.grey[700])
    }, "&.".concat(chipClasses$1.clickable, ":hover"), {
      backgroundColor: (theme.vars || theme).palette.action.hover
    }), "&.".concat(chipClasses$1.focusVisible), {
      backgroundColor: (theme.vars || theme).palette.action.focus
    }), "& .".concat(chipClasses$1.avatar), {
      marginLeft: 4
    }), "& .".concat(chipClasses$1.avatarSmall), {
      marginLeft: 2
    }), "& .".concat(chipClasses$1.icon), {
      marginLeft: 4
    }), "& .".concat(chipClasses$1.iconSmall), {
      marginLeft: 2
    }), "& .".concat(chipClasses$1.deleteIcon), {
      marginRight: 5
    }), "& .".concat(chipClasses$1.deleteIconSmall), {
      marginRight: 3
    }), ownerState.variant === 'outlined' && ownerState.color !== 'default' && _defineProperty(_defineProperty(_defineProperty({
      color: (theme.vars || theme).palette[ownerState.color].main,
      border: "1px solid ".concat(theme.vars ? "rgba(".concat(theme.vars.palette[ownerState.color].mainChannel, " / 0.7)") : alpha(theme.palette[ownerState.color].main, 0.7))
    }, "&.".concat(chipClasses$1.clickable, ":hover"), {
      backgroundColor: theme.vars ? "rgba(".concat(theme.vars.palette[ownerState.color].mainChannel, " / ").concat(theme.vars.palette.action.hoverOpacity, ")") : alpha(theme.palette[ownerState.color].main, theme.palette.action.hoverOpacity)
    }), "&.".concat(chipClasses$1.focusVisible), {
      backgroundColor: theme.vars ? "rgba(".concat(theme.vars.palette[ownerState.color].mainChannel, " / ").concat(theme.vars.palette.action.focusOpacity, ")") : alpha(theme.palette[ownerState.color].main, theme.palette.action.focusOpacity)
    }), "& .".concat(chipClasses$1.deleteIcon), {
      color: theme.vars ? "rgba(".concat(theme.vars.palette[ownerState.color].mainChannel, " / 0.7)") : alpha(theme.palette[ownerState.color].main, 0.7),
      '&:hover, &:active': {
        color: (theme.vars || theme).palette[ownerState.color].main
      }
    }));
  });
  var ChipLabel = styled$1('span', {
    name: 'MuiChip',
    slot: 'Label',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      var size = ownerState.size;
      return [styles.label, styles["label".concat(capitalize(size))]];
    }
  })(function (_ref20) {
    var ownerState = _ref20.ownerState;
    return _extends({
      overflow: 'hidden',
      textOverflow: 'ellipsis',
      paddingLeft: 12,
      paddingRight: 12,
      whiteSpace: 'nowrap'
    }, ownerState.variant === 'outlined' && {
      paddingLeft: 11,
      paddingRight: 11
    }, ownerState.size === 'small' && {
      paddingLeft: 8,
      paddingRight: 8
    }, ownerState.size === 'small' && ownerState.variant === 'outlined' && {
      paddingLeft: 7,
      paddingRight: 7
    });
  });
  function isDeleteKeyboardEvent(keyboardEvent) {
    return keyboardEvent.key === 'Backspace' || keyboardEvent.key === 'Delete';
  }

  /**
   * Chips represent complex entities in small blocks, such as a contact.
   */
  var Chip = /*#__PURE__*/React__namespace.forwardRef(function Chip(inProps, ref) {
    var props = useThemeProps$b({
      props: inProps,
      name: 'MuiChip'
    });
    var avatarProp = props.avatar,
      className = props.className,
      clickableProp = props.clickable,
      _props$color = props.color,
      color = _props$color === void 0 ? 'default' : _props$color,
      ComponentProp = props.component,
      deleteIconProp = props.deleteIcon,
      _props$disabled = props.disabled,
      disabled = _props$disabled === void 0 ? false : _props$disabled,
      iconProp = props.icon,
      label = props.label,
      onClick = props.onClick,
      onDelete = props.onDelete,
      onKeyDown = props.onKeyDown,
      onKeyUp = props.onKeyUp,
      _props$size = props.size,
      size = _props$size === void 0 ? 'medium' : _props$size,
      _props$variant = props.variant,
      variant = _props$variant === void 0 ? 'filled' : _props$variant,
      tabIndex = props.tabIndex,
      _props$skipFocusWhenD = props.skipFocusWhenDisabled,
      skipFocusWhenDisabled = _props$skipFocusWhenD === void 0 ? false : _props$skipFocusWhenD,
      other = _objectWithoutProperties(props, ["avatar", "className", "clickable", "color", "component", "deleteIcon", "disabled", "icon", "label", "onClick", "onDelete", "onKeyDown", "onKeyUp", "size", "variant", "tabIndex", "skipFocusWhenDisabled"]);
    var chipRef = React__namespace.useRef(null);
    var handleRef = useForkRef(chipRef, ref);
    var handleDeleteIconClick = function handleDeleteIconClick(event) {
      // Stop the event from bubbling up to the `Chip`
      event.stopPropagation();
      if (onDelete) {
        onDelete(event);
      }
    };
    var handleKeyDown = function handleKeyDown(event) {
      // Ignore events from children of `Chip`.
      if (event.currentTarget === event.target && isDeleteKeyboardEvent(event)) {
        // Will be handled in keyUp, otherwise some browsers
        // might init navigation
        event.preventDefault();
      }
      if (onKeyDown) {
        onKeyDown(event);
      }
    };
    var handleKeyUp = function handleKeyUp(event) {
      // Ignore events from children of `Chip`.
      if (event.currentTarget === event.target) {
        if (onDelete && isDeleteKeyboardEvent(event)) {
          onDelete(event);
        } else if (event.key === 'Escape' && chipRef.current) {
          chipRef.current.blur();
        }
      }
      if (onKeyUp) {
        onKeyUp(event);
      }
    };
    var clickable = clickableProp !== false && onClick ? true : clickableProp;
    var component = clickable || onDelete ? ButtonBase$1 : ComponentProp || 'div';
    var ownerState = _extends({}, props, {
      component: component,
      disabled: disabled,
      size: size,
      color: color,
      iconColor: /*#__PURE__*/React__namespace.isValidElement(iconProp) ? iconProp.props.color || color : color,
      onDelete: !!onDelete,
      clickable: clickable,
      variant: variant
    });
    var classes = useUtilityClasses$1z(ownerState);
    var moreProps = component === ButtonBase$1 ? _extends({
      component: ComponentProp || 'div',
      focusVisibleClassName: classes.focusVisible
    }, onDelete && {
      disableRipple: true
    }) : {};
    var deleteIcon = null;
    if (onDelete) {
      deleteIcon = deleteIconProp && /*#__PURE__*/React__namespace.isValidElement(deleteIconProp) ? ( /*#__PURE__*/React__namespace.cloneElement(deleteIconProp, {
        className: clsx(deleteIconProp.props.className, classes.deleteIcon),
        onClick: handleDeleteIconClick
      })) : /*#__PURE__*/jsxRuntime_1(CancelIcon, {
        className: clsx(classes.deleteIcon),
        onClick: handleDeleteIconClick
      });
    }
    var avatar = null;
    if (avatarProp && /*#__PURE__*/React__namespace.isValidElement(avatarProp)) {
      avatar = /*#__PURE__*/React__namespace.cloneElement(avatarProp, {
        className: clsx(classes.avatar, avatarProp.props.className)
      });
    }
    var icon = null;
    if (iconProp && /*#__PURE__*/React__namespace.isValidElement(iconProp)) {
      icon = /*#__PURE__*/React__namespace.cloneElement(iconProp, {
        className: clsx(classes.icon, iconProp.props.className)
      });
    }
    {
      if (avatar && icon) {
        console.error('MUI: The Chip component can not handle the avatar ' + 'and the icon prop at the same time. Pick one.');
      }
    }
    return /*#__PURE__*/jsxRuntime_2(ChipRoot, _extends({
      as: component,
      className: clsx(classes.root, className),
      disabled: clickable && disabled ? true : undefined,
      onClick: onClick,
      onKeyDown: handleKeyDown,
      onKeyUp: handleKeyUp,
      ref: handleRef,
      tabIndex: skipFocusWhenDisabled && disabled ? -1 : tabIndex,
      ownerState: ownerState
    }, moreProps, other, {
      children: [avatar || icon, /*#__PURE__*/jsxRuntime_1(ChipLabel, {
        className: clsx(classes.label),
        ownerState: ownerState,
        children: label
      }), deleteIcon]
    }));
  });
  Chip.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The Avatar element to display.
     */
    avatar: PropTypes.element,
    /**
     * This prop isn't supported.
     * Use the `component` prop if you need to change the children structure.
     */
    children: unsupportedProp,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * If `true`, the chip will appear clickable, and will raise when pressed,
     * even if the onClick prop is not defined.
     * If `false`, the chip will not appear clickable, even if onClick prop is defined.
     * This can be used, for example,
     * along with the component prop to indicate an anchor Chip is clickable.
     * Note: this controls the UI and does not affect the onClick event.
     */
    clickable: PropTypes.bool,
    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#custom-colors).
     * @default 'default'
     */
    color: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['default', 'primary', 'secondary', 'error', 'info', 'success', 'warning']), PropTypes.string]),
    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,
    /**
     * Override the default delete icon element. Shown only if `onDelete` is set.
     */
    deleteIcon: PropTypes.element,
    /**
     * If `true`, the component is disabled.
     * @default false
     */
    disabled: PropTypes.bool,
    /**
     * Icon element.
     */
    icon: PropTypes.element,
    /**
     * The content of the component.
     */
    label: PropTypes.node,
    /**
     * @ignore
     */
    onClick: PropTypes.func,
    /**
     * Callback fired when the delete icon is clicked.
     * If set, the delete icon will be shown.
     */
    onDelete: PropTypes.func,
    /**
     * @ignore
     */
    onKeyDown: PropTypes.func,
    /**
     * @ignore
     */
    onKeyUp: PropTypes.func,
    /**
     * The size of the component.
     * @default 'medium'
     */
    size: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['medium', 'small']), PropTypes.string]),
    /**
     * If `true`, allows the disabled chip to escape focus.
     * If `false`, allows the disabled chip to receive focus.
     * @default false
     */
    skipFocusWhenDisabled: PropTypes.bool,
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
    /**
     * @ignore
     */
    tabIndex: PropTypes.number,
    /**
     * The variant to use.
     * @default 'filled'
     */
    variant: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['filled', 'outlined']), PropTypes.string])
  } ;
  var Chip$1 = Chip;

  function formControlState(_ref) {
    var props = _ref.props,
      states = _ref.states,
      muiFormControl = _ref.muiFormControl;
    return states.reduce(function (acc, state) {
      acc[state] = props[state];
      if (muiFormControl) {
        if (typeof props[state] === 'undefined') {
          acc[state] = muiFormControl[state];
        }
      }
      return acc;
    }, {});
  }

  /**
   * @ignore - internal component.
   */
  var FormControlContext = /*#__PURE__*/React__namespace.createContext(undefined);
  {
    FormControlContext.displayName = 'FormControlContext';
  }
  var FormControlContext$1 = FormControlContext;

  function useFormControl() {
    return React__namespace.useContext(FormControlContext$1);
  }

  function GlobalStyles(props) {
    return /*#__PURE__*/jsxRuntime_1(GlobalStyles$1, _extends({}, props, {
      defaultTheme: defaultTheme$3,
      themeId: THEME_ID
    }));
  }
  GlobalStyles.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The styles you want to apply globally.
     */
    styles: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.array, PropTypes.func, PropTypes.number, PropTypes.object, PropTypes.string, PropTypes.bool])
  } ;

  // Supports determination of isControlled().
  // Controlled input accepts its current value as a prop.
  //
  // @see https://facebook.github.io/react/docs/forms.html#controlled-components
  // @param value
  // @returns {boolean} true if string (including '') or number (including zero)
  function hasValue(value) {
    return value != null && !(Array.isArray(value) && value.length === 0);
  }

  // Determine if field is empty or filled.
  // Response determines if label is presented above field or as placeholder.
  //
  // @param obj
  // @param SSR
  // @returns {boolean} False when not present or empty string.
  //                    True when any number or string with length.
  function isFilled(obj) {
    var SSR = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    return obj && (hasValue(obj.value) && obj.value !== '' || SSR && hasValue(obj.defaultValue) && obj.defaultValue !== '');
  }

  // Determine if an Input is adorned on start.
  // It's corresponding to the left with LTR.
  //
  // @param obj
  // @returns {boolean} False when no adornments.
  //                    True when adorned at the start.
  function isAdornedStart(obj) {
    return obj.startAdornment;
  }

  function getInputBaseUtilityClass(slot) {
    return generateUtilityClass$1('MuiInputBase', slot);
  }
  var inputBaseClasses = generateUtilityClasses$1('MuiInputBase', ['root', 'formControl', 'focused', 'disabled', 'adornedStart', 'adornedEnd', 'error', 'sizeSmall', 'multiline', 'colorSecondary', 'fullWidth', 'hiddenLabel', 'readOnly', 'input', 'inputSizeSmall', 'inputMultiline', 'inputTypeSearch', 'inputAdornedStart', 'inputAdornedEnd', 'inputHiddenLabel']);
  var inputBaseClasses$1 = inputBaseClasses;

  var rootOverridesResolver = function rootOverridesResolver(props, styles) {
    var ownerState = props.ownerState;
    return [styles.root, ownerState.formControl && styles.formControl, ownerState.startAdornment && styles.adornedStart, ownerState.endAdornment && styles.adornedEnd, ownerState.error && styles.error, ownerState.size === 'small' && styles.sizeSmall, ownerState.multiline && styles.multiline, ownerState.color && styles["color".concat(capitalize(ownerState.color))], ownerState.fullWidth && styles.fullWidth, ownerState.hiddenLabel && styles.hiddenLabel];
  };
  var inputOverridesResolver = function inputOverridesResolver(props, styles) {
    var ownerState = props.ownerState;
    return [styles.input, ownerState.size === 'small' && styles.inputSizeSmall, ownerState.multiline && styles.inputMultiline, ownerState.type === 'search' && styles.inputTypeSearch, ownerState.startAdornment && styles.inputAdornedStart, ownerState.endAdornment && styles.inputAdornedEnd, ownerState.hiddenLabel && styles.inputHiddenLabel];
  };
  var useUtilityClasses$1y = function useUtilityClasses(ownerState) {
    var classes = ownerState.classes,
      color = ownerState.color,
      disabled = ownerState.disabled,
      error = ownerState.error,
      endAdornment = ownerState.endAdornment,
      focused = ownerState.focused,
      formControl = ownerState.formControl,
      fullWidth = ownerState.fullWidth,
      hiddenLabel = ownerState.hiddenLabel,
      multiline = ownerState.multiline,
      readOnly = ownerState.readOnly,
      size = ownerState.size,
      startAdornment = ownerState.startAdornment,
      type = ownerState.type;
    var slots = {
      root: ['root', "color".concat(capitalize(color)), disabled && 'disabled', error && 'error', fullWidth && 'fullWidth', focused && 'focused', formControl && 'formControl', size && size !== 'medium' && "size".concat(capitalize(size)), multiline && 'multiline', startAdornment && 'adornedStart', endAdornment && 'adornedEnd', hiddenLabel && 'hiddenLabel', readOnly && 'readOnly'],
      input: ['input', disabled && 'disabled', type === 'search' && 'inputTypeSearch', multiline && 'inputMultiline', size === 'small' && 'inputSizeSmall', hiddenLabel && 'inputHiddenLabel', startAdornment && 'inputAdornedStart', endAdornment && 'inputAdornedEnd', readOnly && 'readOnly']
    };
    return composeClasses(slots, getInputBaseUtilityClass, classes);
  };
  var InputBaseRoot = styled$1('div', {
    name: 'MuiInputBase',
    slot: 'Root',
    overridesResolver: rootOverridesResolver
  })(function (_ref) {
    var theme = _ref.theme,
      ownerState = _ref.ownerState;
    return _extends({}, theme.typography.body1, _defineProperty({
      color: (theme.vars || theme).palette.text.primary,
      lineHeight: '1.4375em',
      // 23px
      boxSizing: 'border-box',
      // Prevent padding issue with fullWidth.
      position: 'relative',
      cursor: 'text',
      display: 'inline-flex',
      alignItems: 'center'
    }, "&.".concat(inputBaseClasses$1.disabled), {
      color: (theme.vars || theme).palette.text.disabled,
      cursor: 'default'
    }), ownerState.multiline && _extends({
      padding: '4px 0 5px'
    }, ownerState.size === 'small' && {
      paddingTop: 1
    }), ownerState.fullWidth && {
      width: '100%'
    });
  });
  var InputBaseComponent = styled$1('input', {
    name: 'MuiInputBase',
    slot: 'Input',
    overridesResolver: inputOverridesResolver
  })(function (_ref2) {
    var theme = _ref2.theme,
      ownerState = _ref2.ownerState;
    var light = theme.palette.mode === 'light';
    var placeholder = _extends({
      color: 'currentColor'
    }, theme.vars ? {
      opacity: theme.vars.opacity.inputPlaceholder
    } : {
      opacity: light ? 0.42 : 0.5
    }, {
      transition: theme.transitions.create('opacity', {
        duration: theme.transitions.duration.shorter
      })
    });
    var placeholderHidden = {
      opacity: '0 !important'
    };
    var placeholderVisible = theme.vars ? {
      opacity: theme.vars.opacity.inputPlaceholder
    } : {
      opacity: light ? 0.42 : 0.5
    };
    return _extends(_defineProperty(_defineProperty(_defineProperty({
      font: 'inherit',
      letterSpacing: 'inherit',
      color: 'currentColor',
      padding: '4px 0 5px',
      border: 0,
      boxSizing: 'content-box',
      background: 'none',
      height: '1.4375em',
      // Reset 23pxthe native input line-height
      margin: 0,
      // Reset for Safari
      WebkitTapHighlightColor: 'transparent',
      display: 'block',
      // Make the flex item shrink with Firefox
      minWidth: 0,
      width: '100%',
      // Fix IE11 width issue
      animationName: 'mui-auto-fill-cancel',
      animationDuration: '10ms',
      '&::-webkit-input-placeholder': placeholder,
      '&::-moz-placeholder': placeholder,
      // Firefox 19+
      '&:-ms-input-placeholder': placeholder,
      // IE11
      '&::-ms-input-placeholder': placeholder,
      // Edge
      '&:focus': {
        outline: 0
      },
      // Reset Firefox invalid required input style
      '&:invalid': {
        boxShadow: 'none'
      },
      '&::-webkit-search-decoration': {
        // Remove the padding when type=search.
        WebkitAppearance: 'none'
      }
    }, "label[data-shrink=false] + .".concat(inputBaseClasses$1.formControl, " &"), {
      '&::-webkit-input-placeholder': placeholderHidden,
      '&::-moz-placeholder': placeholderHidden,
      // Firefox 19+
      '&:-ms-input-placeholder': placeholderHidden,
      // IE11
      '&::-ms-input-placeholder': placeholderHidden,
      // Edge
      '&:focus::-webkit-input-placeholder': placeholderVisible,
      '&:focus::-moz-placeholder': placeholderVisible,
      // Firefox 19+
      '&:focus:-ms-input-placeholder': placeholderVisible,
      // IE11
      '&:focus::-ms-input-placeholder': placeholderVisible // Edge
    }), "&.".concat(inputBaseClasses$1.disabled), {
      opacity: 1,
      // Reset iOS opacity
      WebkitTextFillColor: (theme.vars || theme).palette.text.disabled // Fix opacity Safari bug
    }), '&:-webkit-autofill', {
      animationDuration: '5000s',
      animationName: 'mui-auto-fill'
    }), ownerState.size === 'small' && {
      paddingTop: 1
    }, ownerState.multiline && {
      height: 'auto',
      resize: 'none',
      padding: 0,
      paddingTop: 0
    }, ownerState.type === 'search' && {
      // Improve type search style.
      MozAppearance: 'textfield'
    });
  });
  var inputGlobalStyles = /*#__PURE__*/jsxRuntime_1(GlobalStyles, {
    styles: {
      '@keyframes mui-auto-fill': {
        from: {
          display: 'block'
        }
      },
      '@keyframes mui-auto-fill-cancel': {
        from: {
          display: 'block'
        }
      }
    }
  });

  /**
   * `InputBase` contains as few styles as possible.
   * It aims to be a simple building block for creating an input.
   * It contains a load of style reset and some state logic.
   */
  var InputBase = /*#__PURE__*/React__namespace.forwardRef(function InputBase(inProps, ref) {
    var _slotProps$input;
    var props = useThemeProps$b({
      props: inProps,
      name: 'MuiInputBase'
    });
    var ariaDescribedby = props['aria-describedby'],
      autoComplete = props.autoComplete,
      autoFocus = props.autoFocus,
      className = props.className;
      props.color;
      var _props$components = props.components,
      components = _props$components === void 0 ? {} : _props$components,
      _props$componentsProp = props.componentsProps,
      componentsProps = _props$componentsProp === void 0 ? {} : _props$componentsProp,
      defaultValue = props.defaultValue,
      disabled = props.disabled,
      disableInjectingGlobalStyles = props.disableInjectingGlobalStyles,
      endAdornment = props.endAdornment;
      props.error;
      var _props$fullWidth = props.fullWidth,
      fullWidth = _props$fullWidth === void 0 ? false : _props$fullWidth,
      id = props.id,
      _props$inputComponent = props.inputComponent,
      inputComponent = _props$inputComponent === void 0 ? 'input' : _props$inputComponent,
      _props$inputProps = props.inputProps,
      inputPropsProp = _props$inputProps === void 0 ? {} : _props$inputProps,
      inputRefProp = props.inputRef;
      props.margin;
      var maxRows = props.maxRows,
      minRows = props.minRows,
      _props$multiline = props.multiline,
      multiline = _props$multiline === void 0 ? false : _props$multiline,
      name = props.name,
      onBlur = props.onBlur,
      onChange = props.onChange,
      onClick = props.onClick,
      onFocus = props.onFocus,
      onKeyDown = props.onKeyDown,
      onKeyUp = props.onKeyUp,
      placeholder = props.placeholder,
      readOnly = props.readOnly,
      renderSuffix = props.renderSuffix,
      rows = props.rows;
      props.size;
      var _props$slotProps = props.slotProps,
      slotProps = _props$slotProps === void 0 ? {} : _props$slotProps,
      _props$slots = props.slots,
      slots = _props$slots === void 0 ? {} : _props$slots,
      startAdornment = props.startAdornment,
      _props$type = props.type,
      type = _props$type === void 0 ? 'text' : _props$type,
      valueProp = props.value,
      other = _objectWithoutProperties(props, ["aria-describedby", "autoComplete", "autoFocus", "className", "color", "components", "componentsProps", "defaultValue", "disabled", "disableInjectingGlobalStyles", "endAdornment", "error", "fullWidth", "id", "inputComponent", "inputProps", "inputRef", "margin", "maxRows", "minRows", "multiline", "name", "onBlur", "onChange", "onClick", "onFocus", "onKeyDown", "onKeyUp", "placeholder", "readOnly", "renderSuffix", "rows", "size", "slotProps", "slots", "startAdornment", "type", "value"]);
    var value = inputPropsProp.value != null ? inputPropsProp.value : valueProp;
    var _React$useRef = React__namespace.useRef(value != null),
      isControlled = _React$useRef.current;
    var inputRef = React__namespace.useRef();
    var handleInputRefWarning = React__namespace.useCallback(function (instance) {
      {
        if (instance && instance.nodeName !== 'INPUT' && !instance.focus) {
          console.error(['MUI: You have provided a `inputComponent` to the input component', 'that does not correctly handle the `ref` prop.', 'Make sure the `ref` prop is called with a HTMLInputElement.'].join('\n'));
        }
      }
    }, []);
    var handleInputRef = useForkRef(inputRef, inputRefProp, inputPropsProp.ref, handleInputRefWarning);
    var _React$useState = React__namespace.useState(false),
      focused = _React$useState[0],
      setFocused = _React$useState[1];
    var muiFormControl = useFormControl();
    {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      React__namespace.useEffect(function () {
        if (muiFormControl) {
          return muiFormControl.registerEffect();
        }
        return undefined;
      }, [muiFormControl]);
    }
    var fcs = formControlState({
      props: props,
      muiFormControl: muiFormControl,
      states: ['color', 'disabled', 'error', 'hiddenLabel', 'size', 'required', 'filled']
    });
    fcs.focused = muiFormControl ? muiFormControl.focused : focused;

    // The blur won't fire when the disabled state is set on a focused input.
    // We need to book keep the focused state manually.
    React__namespace.useEffect(function () {
      if (!muiFormControl && disabled && focused) {
        setFocused(false);
        if (onBlur) {
          onBlur();
        }
      }
    }, [muiFormControl, disabled, focused, onBlur]);
    var onFilled = muiFormControl && muiFormControl.onFilled;
    var onEmpty = muiFormControl && muiFormControl.onEmpty;
    var checkDirty = React__namespace.useCallback(function (obj) {
      if (isFilled(obj)) {
        if (onFilled) {
          onFilled();
        }
      } else if (onEmpty) {
        onEmpty();
      }
    }, [onFilled, onEmpty]);
    useEnhancedEffect$1(function () {
      if (isControlled) {
        checkDirty({
          value: value
        });
      }
    }, [value, checkDirty, isControlled]);
    var handleFocus = function handleFocus(event) {
      // Fix a bug with IE11 where the focus/blur events are triggered
      // while the component is disabled.
      if (fcs.disabled) {
        event.stopPropagation();
        return;
      }
      if (onFocus) {
        onFocus(event);
      }
      if (inputPropsProp.onFocus) {
        inputPropsProp.onFocus(event);
      }
      if (muiFormControl && muiFormControl.onFocus) {
        muiFormControl.onFocus(event);
      } else {
        setFocused(true);
      }
    };
    var handleBlur = function handleBlur(event) {
      if (onBlur) {
        onBlur(event);
      }
      if (inputPropsProp.onBlur) {
        inputPropsProp.onBlur(event);
      }
      if (muiFormControl && muiFormControl.onBlur) {
        muiFormControl.onBlur(event);
      } else {
        setFocused(false);
      }
    };
    var handleChange = function handleChange(event) {
      if (!isControlled) {
        var element = event.target || inputRef.current;
        if (element == null) {
          throw new Error("MUI: Expected valid input target. Did you use a custom `inputComponent` and forget to forward refs? See https://mui.com/r/input-component-ref-interface for more info." );
        }
        checkDirty({
          value: element.value
        });
      }
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      if (inputPropsProp.onChange) {
        inputPropsProp.onChange.apply(inputPropsProp, [event].concat(args));
      }

      // Perform in the willUpdate
      if (onChange) {
        onChange.apply(void 0, [event].concat(args));
      }
    };

    // Check the input state on mount, in case it was filled by the user
    // or auto filled by the browser before the hydration (for SSR).
    React__namespace.useEffect(function () {
      checkDirty(inputRef.current);
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    var handleClick = function handleClick(event) {
      if (inputRef.current && event.currentTarget === event.target) {
        inputRef.current.focus();
      }
      if (onClick) {
        onClick(event);
      }
    };
    var InputComponent = inputComponent;
    var inputProps = inputPropsProp;
    if (multiline && InputComponent === 'input') {
      if (rows) {
        {
          if (minRows || maxRows) {
            console.warn('MUI: You can not use the `minRows` or `maxRows` props when the input `rows` prop is set.');
          }
        }
        inputProps = _extends({
          type: undefined,
          minRows: rows,
          maxRows: rows
        }, inputProps);
      } else {
        inputProps = _extends({
          type: undefined,
          maxRows: maxRows,
          minRows: minRows
        }, inputProps);
      }
      InputComponent = TextareaAutosize;
    }
    var handleAutoFill = function handleAutoFill(event) {
      // Provide a fake value as Chrome might not let you access it for security reasons.
      checkDirty(event.animationName === 'mui-auto-fill-cancel' ? inputRef.current : {
        value: 'x'
      });
    };
    React__namespace.useEffect(function () {
      if (muiFormControl) {
        muiFormControl.setAdornedStart(Boolean(startAdornment));
      }
    }, [muiFormControl, startAdornment]);
    var ownerState = _extends({}, props, {
      color: fcs.color || 'primary',
      disabled: fcs.disabled,
      endAdornment: endAdornment,
      error: fcs.error,
      focused: fcs.focused,
      formControl: muiFormControl,
      fullWidth: fullWidth,
      hiddenLabel: fcs.hiddenLabel,
      multiline: multiline,
      size: fcs.size,
      startAdornment: startAdornment,
      type: type
    });
    var classes = useUtilityClasses$1y(ownerState);
    var Root = slots.root || components.Root || InputBaseRoot;
    var rootProps = slotProps.root || componentsProps.root || {};
    var Input = slots.input || components.Input || InputBaseComponent;
    inputProps = _extends({}, inputProps, (_slotProps$input = slotProps.input) != null ? _slotProps$input : componentsProps.input);
    return /*#__PURE__*/jsxRuntime_2(React__namespace.Fragment, {
      children: [!disableInjectingGlobalStyles && inputGlobalStyles, /*#__PURE__*/jsxRuntime_2(Root, _extends({}, rootProps, !isHostComponent(Root) && {
        ownerState: _extends({}, ownerState, rootProps.ownerState)
      }, {
        ref: ref,
        onClick: handleClick
      }, other, {
        className: clsx(classes.root, rootProps.className, className, readOnly && 'MuiInputBase-readOnly'),
        children: [startAdornment, /*#__PURE__*/jsxRuntime_1(FormControlContext$1.Provider, {
          value: null,
          children: /*#__PURE__*/jsxRuntime_1(Input, _extends({
            ownerState: ownerState,
            "aria-invalid": fcs.error,
            "aria-describedby": ariaDescribedby,
            autoComplete: autoComplete,
            autoFocus: autoFocus,
            defaultValue: defaultValue,
            disabled: fcs.disabled,
            id: id,
            onAnimationStart: handleAutoFill,
            name: name,
            placeholder: placeholder,
            readOnly: readOnly,
            required: fcs.required,
            rows: rows,
            value: value,
            onKeyDown: onKeyDown,
            onKeyUp: onKeyUp,
            type: type
          }, inputProps, !isHostComponent(Input) && {
            as: InputComponent,
            ownerState: _extends({}, ownerState, inputProps.ownerState)
          }, {
            ref: handleInputRef,
            className: clsx(classes.input, inputProps.className, readOnly && 'MuiInputBase-readOnly'),
            onBlur: handleBlur,
            onChange: handleChange,
            onFocus: handleFocus
          }))
        }), endAdornment, renderSuffix ? renderSuffix(_extends({}, fcs, {
          startAdornment: startAdornment
        })) : null]
      }))]
    });
  });
  InputBase.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * @ignore
     */
    'aria-describedby': PropTypes.string,
    /**
     * This prop helps users to fill forms faster, especially on mobile devices.
     * The name can be confusing, as it's more like an autofill.
     * You can learn more about it [following the specification](https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill).
     */
    autoComplete: PropTypes.string,
    /**
     * If `true`, the `input` element is focused during the first mount.
     */
    autoFocus: PropTypes.bool,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#custom-colors).
     * The prop defaults to the value (`'primary'`) inherited from the parent FormControl component.
     */
    color: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['primary', 'secondary', 'error', 'info', 'success', 'warning']), PropTypes.string]),
    /**
     * The components used for each slot inside.
     *
     * This prop is an alias for the `slots` prop.
     * It's recommended to use the `slots` prop instead.
     *
     * @default {}
     */
    components: PropTypes.shape({
      Input: PropTypes.elementType,
      Root: PropTypes.elementType
    }),
    /**
     * The extra props for the slot components.
     * You can override the existing props or add new ones.
     *
     * This prop is an alias for the `slotProps` prop.
     * It's recommended to use the `slotProps` prop instead, as `componentsProps` will be deprecated in the future.
     *
     * @default {}
     */
    componentsProps: PropTypes.shape({
      input: PropTypes.object,
      root: PropTypes.object
    }),
    /**
     * The default value. Use when the component is not controlled.
     */
    defaultValue: PropTypes.any,
    /**
     * If `true`, the component is disabled.
     * The prop defaults to the value (`false`) inherited from the parent FormControl component.
     */
    disabled: PropTypes.bool,
    /**
     * If `true`, GlobalStyles for the auto-fill keyframes will not be injected/removed on mount/unmount. Make sure to inject them at the top of your application.
     * This option is intended to help with boosting the initial rendering performance if you are loading a big amount of Input components at once.
     * @default false
     */
    disableInjectingGlobalStyles: PropTypes.bool,
    /**
     * End `InputAdornment` for this component.
     */
    endAdornment: PropTypes.node,
    /**
     * If `true`, the `input` will indicate an error.
     * The prop defaults to the value (`false`) inherited from the parent FormControl component.
     */
    error: PropTypes.bool,
    /**
     * If `true`, the `input` will take up the full width of its container.
     * @default false
     */
    fullWidth: PropTypes.bool,
    /**
     * The id of the `input` element.
     */
    id: PropTypes.string,
    /**
     * The component used for the `input` element.
     * Either a string to use a HTML element or a component.
     * @default 'input'
     */
    inputComponent: elementTypeAcceptingRef$1,
    /**
     * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
     * @default {}
     */
    inputProps: PropTypes.object,
    /**
     * Pass a ref to the `input` element.
     */
    inputRef: refType$1,
    /**
     * If `dense`, will adjust vertical spacing. This is normally obtained via context from
     * FormControl.
     * The prop defaults to the value (`'none'`) inherited from the parent FormControl component.
     */
    margin: PropTypes.oneOf(['dense', 'none']),
    /**
     * Maximum number of rows to display when multiline option is set to true.
     */
    maxRows: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    /**
     * Minimum number of rows to display when multiline option is set to true.
     */
    minRows: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    /**
     * If `true`, a [TextareaAutosize](/material-ui/react-textarea-autosize/) element is rendered.
     * @default false
     */
    multiline: PropTypes.bool,
    /**
     * Name attribute of the `input` element.
     */
    name: PropTypes.string,
    /**
     * Callback fired when the `input` is blurred.
     *
     * Notice that the first argument (event) might be undefined.
     */
    onBlur: PropTypes.func,
    /**
     * Callback fired when the value is changed.
     *
     * @param {React.ChangeEvent<HTMLTextAreaElement | HTMLInputElement>} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value` (string).
     */
    onChange: PropTypes.func,
    /**
     * @ignore
     */
    onClick: PropTypes.func,
    /**
     * @ignore
     */
    onFocus: PropTypes.func,
    /**
     * Callback fired when the `input` doesn't satisfy its constraints.
     */
    onInvalid: PropTypes.func,
    /**
     * @ignore
     */
    onKeyDown: PropTypes.func,
    /**
     * @ignore
     */
    onKeyUp: PropTypes.func,
    /**
     * The short hint displayed in the `input` before the user enters a value.
     */
    placeholder: PropTypes.string,
    /**
     * It prevents the user from changing the value of the field
     * (not from interacting with the field).
     */
    readOnly: PropTypes.bool,
    /**
     * @ignore
     */
    renderSuffix: PropTypes.func,
    /**
     * If `true`, the `input` element is required.
     * The prop defaults to the value (`false`) inherited from the parent FormControl component.
     */
    required: PropTypes.bool,
    /**
     * Number of rows to display when multiline option is set to true.
     */
    rows: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    /**
     * The size of the component.
     */
    size: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['medium', 'small']), PropTypes.string]),
    /**
     * The extra props for the slot components.
     * You can override the existing props or add new ones.
     *
     * This prop is an alias for the `componentsProps` prop, which will be deprecated in the future.
     *
     * @default {}
     */
    slotProps: PropTypes.shape({
      input: PropTypes.object,
      root: PropTypes.object
    }),
    /**
     * The components used for each slot inside.
     *
     * This prop is an alias for the `components` prop, which will be deprecated in the future.
     *
     * @default {}
     */
    slots: PropTypes.shape({
      input: PropTypes.elementType,
      root: PropTypes.elementType
    }),
    /**
     * Start `InputAdornment` for this component.
     */
    startAdornment: PropTypes.node,
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
    /**
     * Type of the `input` element. It should be [a valid HTML5 input type](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Form_%3Cinput%3E_types).
     * @default 'text'
     */
    type: PropTypes.string,
    /**
     * The value of the `input` element, required for a controlled component.
     */
    value: PropTypes.any
  } ;
  var InputBase$1 = InputBase;

  function getInputUtilityClass(slot) {
    return generateUtilityClass$1('MuiInput', slot);
  }
  var inputClasses = _extends({}, inputBaseClasses$1, generateUtilityClasses$1('MuiInput', ['root', 'underline', 'input']));
  var inputClasses$1 = inputClasses;

  function getOutlinedInputUtilityClass(slot) {
    return generateUtilityClass$1('MuiOutlinedInput', slot);
  }
  var outlinedInputClasses = _extends({}, inputBaseClasses$1, generateUtilityClasses$1('MuiOutlinedInput', ['root', 'notchedOutline', 'input']));
  var outlinedInputClasses$1 = outlinedInputClasses;

  function getFilledInputUtilityClass(slot) {
    return generateUtilityClass$1('MuiFilledInput', slot);
  }
  var filledInputClasses = _extends({}, inputBaseClasses$1, generateUtilityClasses$1('MuiFilledInput', ['root', 'underline', 'input']));
  var filledInputClasses$1 = filledInputClasses;

  var ArrowDropDownIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M7 10l5 5 5-5z"
  }), 'ArrowDropDown');

  function getAutocompleteUtilityClass(slot) {
    return generateUtilityClass$1('MuiAutocomplete', slot);
  }
  var autocompleteClasses = generateUtilityClasses$1('MuiAutocomplete', ['root', 'expanded', 'fullWidth', 'focused', 'focusVisible', 'tag', 'tagSizeSmall', 'tagSizeMedium', 'hasPopupIcon', 'hasClearIcon', 'inputRoot', 'input', 'inputFocused', 'endAdornment', 'clearIndicator', 'popupIndicator', 'popupIndicatorOpen', 'popper', 'popperDisablePortal', 'paper', 'listbox', 'loading', 'noOptions', 'option', 'groupLabel', 'groupUl']);
  var autocompleteClasses$1 = autocompleteClasses;

  var _styled, _ClearIcon, _ArrowDropDownIcon;
  var useThemeProps$4 = createUseThemeProps();
  var useUtilityClasses$1x = function useUtilityClasses(ownerState) {
    var classes = ownerState.classes,
      disablePortal = ownerState.disablePortal,
      expanded = ownerState.expanded,
      focused = ownerState.focused,
      fullWidth = ownerState.fullWidth,
      hasClearIcon = ownerState.hasClearIcon,
      hasPopupIcon = ownerState.hasPopupIcon,
      inputFocused = ownerState.inputFocused,
      popupOpen = ownerState.popupOpen,
      size = ownerState.size;
    var slots = {
      root: ['root', expanded && 'expanded', focused && 'focused', fullWidth && 'fullWidth', hasClearIcon && 'hasClearIcon', hasPopupIcon && 'hasPopupIcon'],
      inputRoot: ['inputRoot'],
      input: ['input', inputFocused && 'inputFocused'],
      tag: ['tag', "tagSize".concat(capitalize(size))],
      endAdornment: ['endAdornment'],
      clearIndicator: ['clearIndicator'],
      popupIndicator: ['popupIndicator', popupOpen && 'popupIndicatorOpen'],
      popper: ['popper', disablePortal && 'popperDisablePortal'],
      paper: ['paper'],
      listbox: ['listbox'],
      loading: ['loading'],
      noOptions: ['noOptions'],
      option: ['option'],
      groupLabel: ['groupLabel'],
      groupUl: ['groupUl']
    };
    return composeClasses(slots, getAutocompleteUtilityClass, classes);
  };
  var AutocompleteRoot = styled$1('div', {
    name: 'MuiAutocomplete',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      var fullWidth = ownerState.fullWidth,
        hasClearIcon = ownerState.hasClearIcon,
        hasPopupIcon = ownerState.hasPopupIcon,
        inputFocused = ownerState.inputFocused,
        size = ownerState.size;
      return [_defineProperty({}, "& .".concat(autocompleteClasses$1.tag), styles.tag), _defineProperty({}, "& .".concat(autocompleteClasses$1.tag), styles["tagSize".concat(capitalize(size))]), _defineProperty({}, "& .".concat(autocompleteClasses$1.inputRoot), styles.inputRoot), _defineProperty({}, "& .".concat(autocompleteClasses$1.input), styles.input), _defineProperty({}, "& .".concat(autocompleteClasses$1.input), inputFocused && styles.inputFocused), styles.root, fullWidth && styles.fullWidth, hasPopupIcon && styles.hasPopupIcon, hasClearIcon && styles.hasClearIcon];
    }
  })((_styled = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_styled, "&.".concat(autocompleteClasses$1.focused, " .").concat(autocompleteClasses$1.clearIndicator), {
    visibility: 'visible'
  }), '@media (pointer: fine)', _defineProperty({}, "&:hover .".concat(autocompleteClasses$1.clearIndicator), {
    visibility: 'visible'
  })), "& .".concat(autocompleteClasses$1.tag), {
    margin: 3,
    maxWidth: 'calc(100% - 6px)'
  }), "& .".concat(autocompleteClasses$1.inputRoot), _defineProperty(_defineProperty(_defineProperty({
    flexWrap: 'wrap'
  }, ".".concat(autocompleteClasses$1.hasPopupIcon, "&, .").concat(autocompleteClasses$1.hasClearIcon, "&"), {
    paddingRight: 26 + 4
  }), ".".concat(autocompleteClasses$1.hasPopupIcon, ".").concat(autocompleteClasses$1.hasClearIcon, "&"), {
    paddingRight: 52 + 4
  }), "& .".concat(autocompleteClasses$1.input), {
    width: 0,
    minWidth: 30
  })), "& .".concat(inputClasses$1.root), {
    paddingBottom: 1,
    '& .MuiInput-input': {
      padding: '4px 4px 4px 0px'
    }
  }), "& .".concat(inputClasses$1.root, ".").concat(inputBaseClasses$1.sizeSmall), _defineProperty({}, "& .".concat(inputClasses$1.input), {
    padding: '2px 4px 3px 0'
  })), "& .".concat(outlinedInputClasses$1.root), _defineProperty(_defineProperty(_defineProperty(_defineProperty({
    padding: 9
  }, ".".concat(autocompleteClasses$1.hasPopupIcon, "&, .").concat(autocompleteClasses$1.hasClearIcon, "&"), {
    paddingRight: 26 + 4 + 9
  }), ".".concat(autocompleteClasses$1.hasPopupIcon, ".").concat(autocompleteClasses$1.hasClearIcon, "&"), {
    paddingRight: 52 + 4 + 9
  }), "& .".concat(autocompleteClasses$1.input), {
    padding: '7.5px 4px 7.5px 5px'
  }), "& .".concat(autocompleteClasses$1.endAdornment), {
    right: 9
  })), "& .".concat(outlinedInputClasses$1.root, ".").concat(inputBaseClasses$1.sizeSmall), _defineProperty({
    // Don't specify paddingRight, as it overrides the default value set when there is only
    // one of the popup or clear icon as the specificity is equal so the latter one wins
    paddingTop: 6,
    paddingBottom: 6,
    paddingLeft: 6
  }, "& .".concat(autocompleteClasses$1.input), {
    padding: '2.5px 4px 2.5px 8px'
  })), "& .".concat(filledInputClasses$1.root), _defineProperty(_defineProperty(_defineProperty(_defineProperty({
    paddingTop: 19,
    paddingLeft: 8
  }, ".".concat(autocompleteClasses$1.hasPopupIcon, "&, .").concat(autocompleteClasses$1.hasClearIcon, "&"), {
    paddingRight: 26 + 4 + 9
  }), ".".concat(autocompleteClasses$1.hasPopupIcon, ".").concat(autocompleteClasses$1.hasClearIcon, "&"), {
    paddingRight: 52 + 4 + 9
  }), "& .".concat(filledInputClasses$1.input), {
    padding: '7px 4px'
  }), "& .".concat(autocompleteClasses$1.endAdornment), {
    right: 9
  })), "& .".concat(filledInputClasses$1.root, ".").concat(inputBaseClasses$1.sizeSmall), _defineProperty({
    paddingBottom: 1
  }, "& .".concat(filledInputClasses$1.input), {
    padding: '2.5px 4px'
  })), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_styled, "& .".concat(inputBaseClasses$1.hiddenLabel), {
    paddingTop: 8
  }), "& .".concat(filledInputClasses$1.root, ".").concat(inputBaseClasses$1.hiddenLabel), _defineProperty({
    paddingTop: 0,
    paddingBottom: 0
  }, "& .".concat(autocompleteClasses$1.input), {
    paddingTop: 16,
    paddingBottom: 17
  })), "& .".concat(filledInputClasses$1.root, ".").concat(inputBaseClasses$1.hiddenLabel, ".").concat(inputBaseClasses$1.sizeSmall), _defineProperty({}, "& .".concat(autocompleteClasses$1.input), {
    paddingTop: 8,
    paddingBottom: 9
  })), "& .".concat(autocompleteClasses$1.input), {
    flexGrow: 1,
    textOverflow: 'ellipsis',
    opacity: 0
  }), "variants", [{
    props: {
      fullWidth: true
    },
    style: {
      width: '100%'
    }
  }, {
    props: {
      size: 'small'
    },
    style: _defineProperty({}, "& .".concat(autocompleteClasses$1.tag), {
      margin: 2,
      maxWidth: 'calc(100% - 4px)'
    })
  }, {
    props: {
      inputFocused: true
    },
    style: _defineProperty({}, "& .".concat(autocompleteClasses$1.input), {
      opacity: 1
    })
  }])));
  var AutocompleteEndAdornment = styled$1('div', {
    name: 'MuiAutocomplete',
    slot: 'EndAdornment',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.endAdornment;
    }
  })({
    // We use a position absolute to support wrapping tags.
    position: 'absolute',
    right: 0,
    top: '50%',
    transform: 'translate(0, -50%)'
  });
  var AutocompleteClearIndicator = styled$1(IconButton$1, {
    name: 'MuiAutocomplete',
    slot: 'ClearIndicator',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.clearIndicator;
    }
  })({
    marginRight: -2,
    padding: 4,
    visibility: 'hidden'
  });
  var AutocompletePopupIndicator = styled$1(IconButton$1, {
    name: 'MuiAutocomplete',
    slot: 'PopupIndicator',
    overridesResolver: function overridesResolver(_ref6, styles) {
      var ownerState = _ref6.ownerState;
      return _extends({}, styles.popupIndicator, ownerState.popupOpen && styles.popupIndicatorOpen);
    }
  })({
    padding: 2,
    marginRight: -2,
    variants: [{
      props: {
        popupOpen: true
      },
      style: {
        transform: 'rotate(180deg)'
      }
    }]
  });
  var AutocompletePopper = styled$1(Popper$1, {
    name: 'MuiAutocomplete',
    slot: 'Popper',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      return [_defineProperty({}, "& .".concat(autocompleteClasses$1.option), styles.option), styles.popper, ownerState.disablePortal && styles.popperDisablePortal];
    }
  })(function (_ref8) {
    var theme = _ref8.theme;
    return {
      zIndex: (theme.vars || theme).zIndex.modal,
      variants: [{
        props: {
          disablePortal: true
        },
        style: {
          position: 'absolute'
        }
      }]
    };
  });
  var AutocompletePaper = styled$1(Paper$1, {
    name: 'MuiAutocomplete',
    slot: 'Paper',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.paper;
    }
  })(function (_ref9) {
    var theme = _ref9.theme;
    return _extends({}, theme.typography.body1, {
      overflow: 'auto'
    });
  });
  var AutocompleteLoading = styled$1('div', {
    name: 'MuiAutocomplete',
    slot: 'Loading',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.loading;
    }
  })(function (_ref10) {
    var theme = _ref10.theme;
    return {
      color: (theme.vars || theme).palette.text.secondary,
      padding: '14px 16px'
    };
  });
  var AutocompleteNoOptions = styled$1('div', {
    name: 'MuiAutocomplete',
    slot: 'NoOptions',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.noOptions;
    }
  })(function (_ref11) {
    var theme = _ref11.theme;
    return {
      color: (theme.vars || theme).palette.text.secondary,
      padding: '14px 16px'
    };
  });
  var AutocompleteListbox = styled$1('div', {
    name: 'MuiAutocomplete',
    slot: 'Listbox',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.listbox;
    }
  })(function (_ref12) {
    var theme = _ref12.theme;
    return _defineProperty({
      listStyle: 'none',
      margin: 0,
      padding: '8px 0',
      maxHeight: '40vh',
      overflow: 'auto',
      position: 'relative'
    }, "& .".concat(autocompleteClasses$1.option), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty({
      minHeight: 48,
      display: 'flex',
      overflow: 'hidden',
      justifyContent: 'flex-start',
      alignItems: 'center',
      cursor: 'pointer',
      paddingTop: 6,
      boxSizing: 'border-box',
      outline: '0',
      WebkitTapHighlightColor: 'transparent',
      paddingBottom: 6,
      paddingLeft: 16,
      paddingRight: 16
    }, theme.breakpoints.up('sm'), {
      minHeight: 'auto'
    }), "&.".concat(autocompleteClasses$1.focused), {
      backgroundColor: (theme.vars || theme).palette.action.hover,
      // Reset on touch devices, it doesn't add specificity
      '@media (hover: none)': {
        backgroundColor: 'transparent'
      }
    }), '&[aria-disabled="true"]', {
      opacity: (theme.vars || theme).palette.action.disabledOpacity,
      pointerEvents: 'none'
    }), "&.".concat(autocompleteClasses$1.focusVisible), {
      backgroundColor: (theme.vars || theme).palette.action.focus
    }), '&[aria-selected="true"]', _defineProperty(_defineProperty({
      backgroundColor: theme.vars ? "rgba(".concat(theme.vars.palette.primary.mainChannel, " / ").concat(theme.vars.palette.action.selectedOpacity, ")") : alpha(theme.palette.primary.main, theme.palette.action.selectedOpacity)
    }, "&.".concat(autocompleteClasses$1.focused), {
      backgroundColor: theme.vars ? "rgba(".concat(theme.vars.palette.primary.mainChannel, " / calc(").concat(theme.vars.palette.action.selectedOpacity, " + ").concat(theme.vars.palette.action.hoverOpacity, "))") : alpha(theme.palette.primary.main, theme.palette.action.selectedOpacity + theme.palette.action.hoverOpacity),
      // Reset on touch devices, it doesn't add specificity
      '@media (hover: none)': {
        backgroundColor: (theme.vars || theme).palette.action.selected
      }
    }), "&.".concat(autocompleteClasses$1.focusVisible), {
      backgroundColor: theme.vars ? "rgba(".concat(theme.vars.palette.primary.mainChannel, " / calc(").concat(theme.vars.palette.action.selectedOpacity, " + ").concat(theme.vars.palette.action.focusOpacity, "))") : alpha(theme.palette.primary.main, theme.palette.action.selectedOpacity + theme.palette.action.focusOpacity)
    })));
  });
  var AutocompleteGroupLabel = styled$1(ListSubheader$1, {
    name: 'MuiAutocomplete',
    slot: 'GroupLabel',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.groupLabel;
    }
  })(function (_ref14) {
    var theme = _ref14.theme;
    return {
      backgroundColor: (theme.vars || theme).palette.background.paper,
      top: -8
    };
  });
  var AutocompleteGroupUl = styled$1('ul', {
    name: 'MuiAutocomplete',
    slot: 'GroupUl',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.groupUl;
    }
  })(_defineProperty({
    padding: 0
  }, "& .".concat(autocompleteClasses$1.option), {
    paddingLeft: 24
  }));
  var Autocomplete = /*#__PURE__*/React__namespace.forwardRef(function Autocomplete(inProps, ref) {
    var _slotProps$clearIndic, _slotProps$paper, _slotProps$popper, _slotProps$popupIndic;
    var props = useThemeProps$4({
      props: inProps,
      name: 'MuiAutocomplete'
    });

    /* eslint-disable @typescript-eslint/no-unused-vars */
    props.autoComplete;
      props.autoHighlight;
      props.autoSelect;
      props.blurOnSelect;
      var ChipProps = props.ChipProps,
      className = props.className,
      _props$clearIcon = props.clearIcon,
      clearIcon = _props$clearIcon === void 0 ? _ClearIcon || (_ClearIcon = /*#__PURE__*/jsxRuntime_1(ClearIcon, {
        fontSize: "small"
      })) : _props$clearIcon,
      _props$clearOnBlur = props.clearOnBlur;
      _props$clearOnBlur === void 0 ? !props.freeSolo : _props$clearOnBlur;
      props.clearOnEscape;
      var _props$clearText = props.clearText,
      clearText = _props$clearText === void 0 ? 'Clear' : _props$clearText,
      _props$closeText = props.closeText,
      closeText = _props$closeText === void 0 ? 'Close' : _props$closeText,
      _props$componentsProp = props.componentsProps,
      componentsProps = _props$componentsProp === void 0 ? {} : _props$componentsProp,
      _props$defaultValue = props.defaultValue;
      _props$defaultValue === void 0 ? props.multiple ? [] : null : _props$defaultValue;
      var _props$disableClearab = props.disableClearable,
      disableClearable = _props$disableClearab === void 0 ? false : _props$disableClearab;
      props.disableCloseOnSelect;
      var _props$disabled = props.disabled,
      disabled = _props$disabled === void 0 ? false : _props$disabled;
      props.disabledItemsFocusable;
      props.disableListWrap;
      var _props$disablePortal = props.disablePortal,
      disablePortal = _props$disablePortal === void 0 ? false : _props$disablePortal;
      props.filterOptions;
      props.filterSelectedOptions;
      var _props$forcePopupIcon = props.forcePopupIcon,
      forcePopupIcon = _props$forcePopupIcon === void 0 ? 'auto' : _props$forcePopupIcon,
      _props$freeSolo = props.freeSolo,
      freeSolo = _props$freeSolo === void 0 ? false : _props$freeSolo,
      _props$fullWidth = props.fullWidth,
      fullWidth = _props$fullWidth === void 0 ? false : _props$fullWidth,
      _props$getLimitTagsTe = props.getLimitTagsText,
      getLimitTagsText = _props$getLimitTagsTe === void 0 ? function (more) {
        return "+".concat(more);
      } : _props$getLimitTagsTe;
      props.getOptionDisabled;
      props.getOptionKey;
      var getOptionLabelProp = props.getOptionLabel;
      props.isOptionEqualToValue;
      var groupBy = props.groupBy,
      _props$handleHomeEndK = props.handleHomeEndKeys;
      _props$handleHomeEndK === void 0 ? !props.freeSolo : _props$handleHomeEndK;
      props.id;
      props.includeInputInList;
      props.inputValue;
      var _props$limitTags = props.limitTags,
      limitTags = _props$limitTags === void 0 ? -1 : _props$limitTags,
      _props$ListboxCompone = props.ListboxComponent,
      ListboxComponent = _props$ListboxCompone === void 0 ? 'ul' : _props$ListboxCompone,
      ListboxProps = props.ListboxProps,
      _props$loading = props.loading,
      loading = _props$loading === void 0 ? false : _props$loading,
      _props$loadingText = props.loadingText,
      loadingText = _props$loadingText === void 0 ? 'Loading…' : _props$loadingText,
      _props$multiple = props.multiple,
      multiple = _props$multiple === void 0 ? false : _props$multiple,
      _props$noOptionsText = props.noOptionsText,
      noOptionsText = _props$noOptionsText === void 0 ? 'No options' : _props$noOptionsText;
      props.onChange;
      props.onClose;
      props.onHighlightChange;
      props.onInputChange;
      props.onOpen;
      props.open;
      props.openOnFocus;
      var _props$openText = props.openText,
      openText = _props$openText === void 0 ? 'Open' : _props$openText;
      props.options;
      var _props$PaperComponent = props.PaperComponent,
      PaperComponent = _props$PaperComponent === void 0 ? Paper$1 : _props$PaperComponent,
      _props$PopperComponen = props.PopperComponent,
      PopperComponent = _props$PopperComponen === void 0 ? Popper$1 : _props$PopperComponen,
      _props$popupIcon = props.popupIcon,
      popupIcon = _props$popupIcon === void 0 ? _ArrowDropDownIcon || (_ArrowDropDownIcon = /*#__PURE__*/jsxRuntime_1(ArrowDropDownIcon, {})) : _props$popupIcon,
      _props$readOnly = props.readOnly,
      readOnly = _props$readOnly === void 0 ? false : _props$readOnly,
      renderGroupProp = props.renderGroup,
      renderInput = props.renderInput,
      renderOptionProp = props.renderOption,
      renderTags = props.renderTags,
      _props$selectOnFocus = props.selectOnFocus;
      _props$selectOnFocus === void 0 ? !props.freeSolo : _props$selectOnFocus;
      var _props$size = props.size,
      size = _props$size === void 0 ? 'medium' : _props$size,
      _props$slotProps = props.slotProps,
      slotProps = _props$slotProps === void 0 ? {} : _props$slotProps;
      props.value;
      var other = _objectWithoutProperties(props, ["autoComplete", "autoHighlight", "autoSelect", "blurOnSelect", "ChipProps", "className", "clearIcon", "clearOnBlur", "clearOnEscape", "clearText", "closeText", "componentsProps", "defaultValue", "disableClearable", "disableCloseOnSelect", "disabled", "disabledItemsFocusable", "disableListWrap", "disablePortal", "filterOptions", "filterSelectedOptions", "forcePopupIcon", "freeSolo", "fullWidth", "getLimitTagsText", "getOptionDisabled", "getOptionKey", "getOptionLabel", "isOptionEqualToValue", "groupBy", "handleHomeEndKeys", "id", "includeInputInList", "inputValue", "limitTags", "ListboxComponent", "ListboxProps", "loading", "loadingText", "multiple", "noOptionsText", "onChange", "onClose", "onHighlightChange", "onInputChange", "onOpen", "open", "openOnFocus", "openText", "options", "PaperComponent", "PopperComponent", "popupIcon", "readOnly", "renderGroup", "renderInput", "renderOption", "renderTags", "selectOnFocus", "size", "slotProps", "value"]);
    /* eslint-enable @typescript-eslint/no-unused-vars */
    var _useAutocomplete = useAutocomplete(_extends({}, props, {
        componentName: 'Autocomplete'
      })),
      getRootProps = _useAutocomplete.getRootProps,
      getInputProps = _useAutocomplete.getInputProps,
      getInputLabelProps = _useAutocomplete.getInputLabelProps,
      getPopupIndicatorProps = _useAutocomplete.getPopupIndicatorProps,
      getClearProps = _useAutocomplete.getClearProps,
      getTagProps = _useAutocomplete.getTagProps,
      getListboxProps = _useAutocomplete.getListboxProps,
      getOptionProps = _useAutocomplete.getOptionProps,
      value = _useAutocomplete.value,
      dirty = _useAutocomplete.dirty,
      expanded = _useAutocomplete.expanded,
      id = _useAutocomplete.id,
      popupOpen = _useAutocomplete.popupOpen,
      focused = _useAutocomplete.focused,
      focusedTag = _useAutocomplete.focusedTag,
      anchorEl = _useAutocomplete.anchorEl,
      setAnchorEl = _useAutocomplete.setAnchorEl,
      inputValue = _useAutocomplete.inputValue,
      groupedOptions = _useAutocomplete.groupedOptions;
    var hasClearIcon = !disableClearable && !disabled && dirty && !readOnly;
    var hasPopupIcon = (!freeSolo || forcePopupIcon === true) && forcePopupIcon !== false;
    var _getInputProps = getInputProps(),
      handleInputMouseDown = _getInputProps.onMouseDown;
    var _ref15 = ListboxProps != null ? ListboxProps : {},
      externalListboxRef = _ref15.ref;
    var _getListboxProps = getListboxProps(),
      listboxRef = _getListboxProps.ref,
      otherListboxProps = _objectWithoutProperties(_getListboxProps, ["ref"]);
    var combinedListboxRef = useForkRef(listboxRef, externalListboxRef);
    var defaultGetOptionLabel = function defaultGetOptionLabel(option) {
      var _option$label;
      return (_option$label = option.label) != null ? _option$label : option;
    };
    var getOptionLabel = getOptionLabelProp || defaultGetOptionLabel;

    // If you modify this, make sure to keep the `AutocompleteOwnerState` type in sync.
    var ownerState = _extends({}, props, {
      disablePortal: disablePortal,
      expanded: expanded,
      focused: focused,
      fullWidth: fullWidth,
      getOptionLabel: getOptionLabel,
      hasClearIcon: hasClearIcon,
      hasPopupIcon: hasPopupIcon,
      inputFocused: focusedTag === -1,
      popupOpen: popupOpen,
      size: size
    });
    var classes = useUtilityClasses$1x(ownerState);
    var startAdornment;
    if (multiple && value.length > 0) {
      var getCustomizedTagProps = function getCustomizedTagProps(params) {
        return _extends({
          className: classes.tag,
          disabled: disabled
        }, getTagProps(params));
      };
      if (renderTags) {
        startAdornment = renderTags(value, getCustomizedTagProps, ownerState);
      } else {
        startAdornment = value.map(function (option, index) {
          return /*#__PURE__*/jsxRuntime_1(Chip$1, _extends({
            label: getOptionLabel(option),
            size: size
          }, getCustomizedTagProps({
            index: index
          }), ChipProps));
        });
      }
    }
    if (limitTags > -1 && Array.isArray(startAdornment)) {
      var more = startAdornment.length - limitTags;
      if (!focused && more > 0) {
        startAdornment = startAdornment.splice(0, limitTags);
        startAdornment.push( /*#__PURE__*/jsxRuntime_1("span", {
          className: classes.tag,
          children: getLimitTagsText(more)
        }, startAdornment.length));
      }
    }
    var defaultRenderGroup = function defaultRenderGroup(params) {
      return /*#__PURE__*/jsxRuntime_2("li", {
        children: [/*#__PURE__*/jsxRuntime_1(AutocompleteGroupLabel, {
          className: classes.groupLabel,
          ownerState: ownerState,
          component: "div",
          children: params.group
        }), /*#__PURE__*/jsxRuntime_1(AutocompleteGroupUl, {
          className: classes.groupUl,
          ownerState: ownerState,
          children: params.children
        })]
      }, params.key);
    };
    var renderGroup = renderGroupProp || defaultRenderGroup;
    var defaultRenderOption = function defaultRenderOption(props2, option) {
      // Need to clearly apply key because of https://github.com/vercel/next.js/issues/55642
      return /*#__PURE__*/React.createElement("li", _extends({}, props2, {
        key: props2.key
      }), getOptionLabel(option));
    };
    var renderOption = renderOptionProp || defaultRenderOption;
    var renderListOption = function renderListOption(option, index) {
      var optionProps = getOptionProps({
        option: option,
        index: index
      });
      return renderOption(_extends({}, optionProps, {
        className: classes.option
      }), option, {
        selected: optionProps['aria-selected'],
        index: index,
        inputValue: inputValue
      }, ownerState);
    };
    var clearIndicatorSlotProps = (_slotProps$clearIndic = slotProps.clearIndicator) != null ? _slotProps$clearIndic : componentsProps.clearIndicator;
    var paperSlotProps = (_slotProps$paper = slotProps.paper) != null ? _slotProps$paper : componentsProps.paper;
    var popperSlotProps = (_slotProps$popper = slotProps.popper) != null ? _slotProps$popper : componentsProps.popper;
    var popupIndicatorSlotProps = (_slotProps$popupIndic = slotProps.popupIndicator) != null ? _slotProps$popupIndic : componentsProps.popupIndicator;
    var renderAutocompletePopperChildren = function renderAutocompletePopperChildren(children) {
      return /*#__PURE__*/jsxRuntime_1(AutocompletePopper, _extends({
        as: PopperComponent,
        disablePortal: disablePortal,
        style: {
          width: anchorEl ? anchorEl.clientWidth : null
        },
        ownerState: ownerState,
        role: "presentation",
        anchorEl: anchorEl,
        open: popupOpen
      }, popperSlotProps, {
        className: clsx(classes.popper, popperSlotProps == null ? void 0 : popperSlotProps.className),
        children: /*#__PURE__*/jsxRuntime_1(AutocompletePaper, _extends({
          ownerState: ownerState,
          as: PaperComponent
        }, paperSlotProps, {
          className: clsx(classes.paper, paperSlotProps == null ? void 0 : paperSlotProps.className),
          children: children
        }))
      }));
    };
    var autocompletePopper = null;
    if (!loading && groupedOptions.length > 0) {
      autocompletePopper = renderAutocompletePopperChildren( /*#__PURE__*/jsxRuntime_1(AutocompleteListbox, _extends({
        as: ListboxComponent,
        className: classes.listbox,
        ownerState: ownerState
      }, otherListboxProps, ListboxProps, {
        ref: combinedListboxRef,
        children: groupedOptions.map(function (option, index) {
          if (groupBy) {
            return renderGroup({
              key: option.key,
              group: option.group,
              children: option.options.map(function (option2, index2) {
                return renderListOption(option2, option.index + index2);
              })
            });
          }
          return renderListOption(option, index);
        })
      })));
    } else if (loading && groupedOptions.length === 0) {
      autocompletePopper = renderAutocompletePopperChildren( /*#__PURE__*/jsxRuntime_1(AutocompleteLoading, {
        className: classes.loading,
        ownerState: ownerState,
        children: loadingText
      }));
    } else if (groupedOptions.length === 0 && !freeSolo && !loading) {
      autocompletePopper = renderAutocompletePopperChildren( /*#__PURE__*/jsxRuntime_1(AutocompleteNoOptions, {
        className: classes.noOptions,
        ownerState: ownerState,
        role: "presentation",
        onMouseDown: function onMouseDown(event) {
          // Prevent input blur when interacting with the "no options" content
          event.preventDefault();
        },
        children: noOptionsText
      }));
    }
    return /*#__PURE__*/jsxRuntime_2(React__namespace.Fragment, {
      children: [/*#__PURE__*/jsxRuntime_1(AutocompleteRoot, _extends({
        ref: ref,
        className: clsx(classes.root, className),
        ownerState: ownerState
      }, getRootProps(other), {
        children: renderInput({
          id: id,
          disabled: disabled,
          fullWidth: true,
          size: size === 'small' ? 'small' : undefined,
          InputLabelProps: getInputLabelProps(),
          InputProps: _extends({
            ref: setAnchorEl,
            className: classes.inputRoot,
            startAdornment: startAdornment,
            onClick: function onClick(event) {
              if (event.target === event.currentTarget) {
                handleInputMouseDown(event);
              }
            }
          }, (hasClearIcon || hasPopupIcon) && {
            endAdornment: /*#__PURE__*/jsxRuntime_2(AutocompleteEndAdornment, {
              className: classes.endAdornment,
              ownerState: ownerState,
              children: [hasClearIcon ? /*#__PURE__*/jsxRuntime_1(AutocompleteClearIndicator, _extends({}, getClearProps(), {
                "aria-label": clearText,
                title: clearText,
                ownerState: ownerState
              }, clearIndicatorSlotProps, {
                className: clsx(classes.clearIndicator, clearIndicatorSlotProps == null ? void 0 : clearIndicatorSlotProps.className),
                children: clearIcon
              })) : null, hasPopupIcon ? /*#__PURE__*/jsxRuntime_1(AutocompletePopupIndicator, _extends({}, getPopupIndicatorProps(), {
                disabled: disabled,
                "aria-label": popupOpen ? closeText : openText,
                title: popupOpen ? closeText : openText,
                ownerState: ownerState
              }, popupIndicatorSlotProps, {
                className: clsx(classes.popupIndicator, popupIndicatorSlotProps == null ? void 0 : popupIndicatorSlotProps.className),
                children: popupIcon
              })) : null]
            })
          }),
          inputProps: _extends({
            className: classes.input,
            disabled: disabled,
            readOnly: readOnly
          }, getInputProps())
        })
      })), anchorEl ? autocompletePopper : null]
    });
  });
  Autocomplete.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * If `true`, the portion of the selected suggestion that the user hasn't typed,
     * known as the completion string, appears inline after the input cursor in the textbox.
     * The inline completion string is visually highlighted and has a selected state.
     * @default false
     */
    autoComplete: PropTypes.bool,
    /**
     * If `true`, the first option is automatically highlighted.
     * @default false
     */
    autoHighlight: PropTypes.bool,
    /**
     * If `true`, the selected option becomes the value of the input
     * when the Autocomplete loses focus unless the user chooses
     * a different option or changes the character string in the input.
     *
     * When using the `freeSolo` mode, the typed value will be the input value
     * if the Autocomplete loses focus without highlighting an option.
     * @default false
     */
    autoSelect: PropTypes.bool,
    /**
     * Control if the input should be blurred when an option is selected:
     *
     * - `false` the input is not blurred.
     * - `true` the input is always blurred.
     * - `touch` the input is blurred after a touch event.
     * - `mouse` the input is blurred after a mouse event.
     * @default false
     */
    blurOnSelect: PropTypes.oneOfType([PropTypes.oneOf(['mouse', 'touch']), PropTypes.bool]),
    /**
     * Props applied to the [`Chip`](/material-ui/api/chip/) element.
     */
    ChipProps: PropTypes.object,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The icon to display in place of the default clear icon.
     * @default <ClearIcon fontSize="small" />
     */
    clearIcon: PropTypes.node,
    /**
     * If `true`, the input's text is cleared on blur if no value is selected.
     *
     * Set it to `true` if you want to help the user enter a new value.
     * Set it to `false` if you want to help the user resume their search.
     * @default !props.freeSolo
     */
    clearOnBlur: PropTypes.bool,
    /**
     * If `true`, clear all values when the user presses escape and the popup is closed.
     * @default false
     */
    clearOnEscape: PropTypes.bool,
    /**
     * Override the default text for the *clear* icon button.
     *
     * For localization purposes, you can use the provided [translations](/material-ui/guides/localization/).
     * @default 'Clear'
     */
    clearText: PropTypes.string,
    /**
     * Override the default text for the *close popup* icon button.
     *
     * For localization purposes, you can use the provided [translations](/material-ui/guides/localization/).
     * @default 'Close'
     */
    closeText: PropTypes.string,
    /**
     * The props used for each slot inside.
     * @default {}
     */
    componentsProps: PropTypes.shape({
      clearIndicator: PropTypes.object,
      paper: PropTypes.object,
      popper: PropTypes.object,
      popupIndicator: PropTypes.object
    }),
    /**
     * The default value. Use when the component is not controlled.
     * @default props.multiple ? [] : null
     */
    defaultValue: chainPropTypes(PropTypes.any, function (props) {
      if (props.multiple && props.defaultValue !== undefined && !Array.isArray(props.defaultValue)) {
        return new Error(['MUI: The Autocomplete expects the `defaultValue` prop to be an array when `multiple={true}` or undefined.', "However, ".concat(props.defaultValue, " was provided.")].join('\n'));
      }
      return null;
    }),
    /**
     * If `true`, the input can't be cleared.
     * @default false
     */
    disableClearable: PropTypes.bool,
    /**
     * If `true`, the popup won't close when a value is selected.
     * @default false
     */
    disableCloseOnSelect: PropTypes.bool,
    /**
     * If `true`, the component is disabled.
     * @default false
     */
    disabled: PropTypes.bool,
    /**
     * If `true`, will allow focus on disabled items.
     * @default false
     */
    disabledItemsFocusable: PropTypes.bool,
    /**
     * If `true`, the list box in the popup will not wrap focus.
     * @default false
     */
    disableListWrap: PropTypes.bool,
    /**
     * If `true`, the `Popper` content will be under the DOM hierarchy of the parent component.
     * @default false
     */
    disablePortal: PropTypes.bool,
    /**
     * A function that determines the filtered options to be rendered on search.
     *
     * @default createFilterOptions()
     * @param {Value[]} options The options to render.
     * @param {object} state The state of the component.
     * @returns {Value[]}
     */
    filterOptions: PropTypes.func,
    /**
     * If `true`, hide the selected options from the list box.
     * @default false
     */
    filterSelectedOptions: PropTypes.bool,
    /**
     * Force the visibility display of the popup icon.
     * @default 'auto'
     */
    forcePopupIcon: PropTypes.oneOfType([PropTypes.oneOf(['auto']), PropTypes.bool]),
    /**
     * If `true`, the Autocomplete is free solo, meaning that the user input is not bound to provided options.
     * @default false
     */
    freeSolo: PropTypes.bool,
    /**
     * If `true`, the input will take up the full width of its container.
     * @default false
     */
    fullWidth: PropTypes.bool,
    /**
     * The label to display when the tags are truncated (`limitTags`).
     *
     * @param {number} more The number of truncated tags.
     * @returns {ReactNode}
     * @default (more) => `+${more}`
     */
    getLimitTagsText: PropTypes.func,
    /**
     * Used to determine the disabled state for a given option.
     *
     * @param {Value} option The option to test.
     * @returns {boolean}
     */
    getOptionDisabled: PropTypes.func,
    /**
     * Used to determine the key for a given option.
     * This can be useful when the labels of options are not unique (since labels are used as keys by default).
     *
     * @param {Value} option The option to get the key for.
     * @returns {string | number}
     */
    getOptionKey: PropTypes.func,
    /**
     * Used to determine the string value for a given option.
     * It's used to fill the input (and the list box options if `renderOption` is not provided).
     *
     * If used in free solo mode, it must accept both the type of the options and a string.
     *
     * @param {Value} option
     * @returns {string}
     * @default (option) => option.label ?? option
     */
    getOptionLabel: PropTypes.func,
    /**
     * If provided, the options will be grouped under the returned string.
     * The groupBy value is also used as the text for group headings when `renderGroup` is not provided.
     *
     * @param {Value} options The options to group.
     * @returns {string}
     */
    groupBy: PropTypes.func,
    /**
     * If `true`, the component handles the "Home" and "End" keys when the popup is open.
     * It should move focus to the first option and last option, respectively.
     * @default !props.freeSolo
     */
    handleHomeEndKeys: PropTypes.bool,
    /**
     * This prop is used to help implement the accessibility logic.
     * If you don't provide an id it will fall back to a randomly generated one.
     */
    id: PropTypes.string,
    /**
     * If `true`, the highlight can move to the input.
     * @default false
     */
    includeInputInList: PropTypes.bool,
    /**
     * The input value.
     */
    inputValue: PropTypes.string,
    /**
     * Used to determine if the option represents the given value.
     * Uses strict equality by default.
     * ⚠️ Both arguments need to be handled, an option can only match with one value.
     *
     * @param {Value} option The option to test.
     * @param {Value} value The value to test against.
     * @returns {boolean}
     */
    isOptionEqualToValue: PropTypes.func,
    /**
     * The maximum number of tags that will be visible when not focused.
     * Set `-1` to disable the limit.
     * @default -1
     */
    limitTags: integerPropType,
    /**
     * The component used to render the listbox.
     * @default 'ul'
     */
    ListboxComponent: PropTypes.elementType,
    /**
     * Props applied to the Listbox element.
     */
    ListboxProps: PropTypes.object,
    /**
     * If `true`, the component is in a loading state.
     * This shows the `loadingText` in place of suggestions (only if there are no suggestions to show, for example `options` are empty).
     * @default false
     */
    loading: PropTypes.bool,
    /**
     * Text to display when in a loading state.
     *
     * For localization purposes, you can use the provided [translations](/material-ui/guides/localization/).
     * @default 'Loading…'
     */
    loadingText: PropTypes.node,
    /**
     * If `true`, `value` must be an array and the menu will support multiple selections.
     * @default false
     */
    multiple: PropTypes.bool,
    /**
     * Text to display when there are no options.
     *
     * For localization purposes, you can use the provided [translations](/material-ui/guides/localization/).
     * @default 'No options'
     */
    noOptionsText: PropTypes.node,
    /**
     * Callback fired when the value changes.
     *
     * @param {React.SyntheticEvent} event The event source of the callback.
     * @param {Value|Value[]} value The new value of the component.
     * @param {string} reason One of "createOption", "selectOption", "removeOption", "blur" or "clear".
     * @param {string} [details]
     */
    onChange: PropTypes.func,
    /**
     * Callback fired when the popup requests to be closed.
     * Use in controlled mode (see open).
     *
     * @param {React.SyntheticEvent} event The event source of the callback.
     * @param {string} reason Can be: `"toggleInput"`, `"escape"`, `"selectOption"`, `"removeOption"`, `"blur"`.
     */
    onClose: PropTypes.func,
    /**
     * Callback fired when the highlight option changes.
     *
     * @param {React.SyntheticEvent} event The event source of the callback.
     * @param {Value} option The highlighted option.
     * @param {string} reason Can be: `"keyboard"`, `"auto"`, `"mouse"`, `"touch"`.
     */
    onHighlightChange: PropTypes.func,
    /**
     * Callback fired when the input value changes.
     *
     * @param {React.SyntheticEvent} event The event source of the callback.
     * @param {string} value The new value of the text input.
     * @param {string} reason Can be: `"input"` (user input), `"reset"` (programmatic change), `"clear"`.
     */
    onInputChange: PropTypes.func,
    /**
     * @ignore
     */
    onKeyDown: PropTypes.func,
    /**
     * Callback fired when the popup requests to be opened.
     * Use in controlled mode (see open).
     *
     * @param {React.SyntheticEvent} event The event source of the callback.
     */
    onOpen: PropTypes.func,
    /**
     * If `true`, the component is shown.
     */
    open: PropTypes.bool,
    /**
     * If `true`, the popup will open on input focus.
     * @default false
     */
    openOnFocus: PropTypes.bool,
    /**
     * Override the default text for the *open popup* icon button.
     *
     * For localization purposes, you can use the provided [translations](/material-ui/guides/localization/).
     * @default 'Open'
     */
    openText: PropTypes.string,
    /**
     * Array of options.
     */
    options: PropTypes.array.isRequired,
    /**
     * The component used to render the body of the popup.
     * @default Paper
     */
    PaperComponent: PropTypes.elementType,
    /**
     * The component used to position the popup.
     * @default Popper
     */
    PopperComponent: PropTypes.elementType,
    /**
     * The icon to display in place of the default popup icon.
     * @default <ArrowDropDownIcon />
     */
    popupIcon: PropTypes.node,
    /**
     * If `true`, the component becomes readonly. It is also supported for multiple tags where the tag cannot be deleted.
     * @default false
     */
    readOnly: PropTypes.bool,
    /**
     * Render the group.
     *
     * @param {AutocompleteRenderGroupParams} params The group to render.
     * @returns {ReactNode}
     */
    renderGroup: PropTypes.func,
    /**
     * Render the input.
     *
     * @param {object} params
     * @returns {ReactNode}
     */
    renderInput: PropTypes.func.isRequired,
    /**
     * Render the option, use `getOptionLabel` by default.
     *
     * @param {object} props The props to apply on the li element.
     * @param {Value} option The option to render.
     * @param {object} state The state of each option.
     * @param {object} ownerState The state of the Autocomplete component.
     * @returns {ReactNode}
     */
    renderOption: PropTypes.func,
    /**
     * Render the selected value.
     *
     * @param {Value[]} value The `value` provided to the component.
     * @param {function} getTagProps A tag props getter.
     * @param {object} ownerState The state of the Autocomplete component.
     * @returns {ReactNode}
     */
    renderTags: PropTypes.func,
    /**
     * If `true`, the input's text is selected on focus.
     * It helps the user clear the selected value.
     * @default !props.freeSolo
     */
    selectOnFocus: PropTypes.bool,
    /**
     * The size of the component.
     * @default 'medium'
     */
    size: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['small', 'medium']), PropTypes.string]),
    /**
     * The props used for each slot inside.
     * @default {}
     */
    slotProps: PropTypes.shape({
      clearIndicator: PropTypes.object,
      paper: PropTypes.object,
      popper: PropTypes.object,
      popupIndicator: PropTypes.object
    }),
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
    /**
     * The value of the autocomplete.
     *
     * The value must have reference equality with the option in order to be selected.
     * You can customize the equality behavior with the `isOptionEqualToValue` prop.
     */
    value: chainPropTypes(PropTypes.any, function (props) {
      if (props.multiple && props.value !== undefined && !Array.isArray(props.value)) {
        return new Error(['MUI: The Autocomplete expects the `value` prop to be an array when `multiple={true}` or undefined.', "However, ".concat(props.value, " was provided.")].join('\n'));
      }
      return null;
    })
  } ;
  var Autocomplete$1 = Autocomplete;

  var Person = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"
  }), 'Person');

  function getAvatarUtilityClass(slot) {
    return generateUtilityClass$1('MuiAvatar', slot);
  }
  var avatarClasses = generateUtilityClasses$1('MuiAvatar', ['root', 'colorDefault', 'circular', 'rounded', 'square', 'img', 'fallback']);
  var avatarClasses$1 = avatarClasses;

  var useThemeProps$3 = createUseThemeProps();
  var useUtilityClasses$1w = function useUtilityClasses(ownerState) {
    var classes = ownerState.classes,
      variant = ownerState.variant,
      colorDefault = ownerState.colorDefault;
    var slots = {
      root: ['root', variant, colorDefault && 'colorDefault'],
      img: ['img'],
      fallback: ['fallback']
    };
    return composeClasses(slots, getAvatarUtilityClass, classes);
  };
  var AvatarRoot = styled$1('div', {
    name: 'MuiAvatar',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      return [styles.root, styles[ownerState.variant], ownerState.colorDefault && styles.colorDefault];
    }
  })(function (_ref) {
    var theme = _ref.theme;
    return {
      position: 'relative',
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center',
      flexShrink: 0,
      width: 40,
      height: 40,
      fontFamily: theme.typography.fontFamily,
      fontSize: theme.typography.pxToRem(20),
      lineHeight: 1,
      borderRadius: '50%',
      overflow: 'hidden',
      userSelect: 'none',
      variants: [{
        props: {
          variant: 'rounded'
        },
        style: {
          borderRadius: (theme.vars || theme).shape.borderRadius
        }
      }, {
        props: {
          variant: 'square'
        },
        style: {
          borderRadius: 0
        }
      }, {
        props: {
          colorDefault: true
        },
        style: _extends({
          color: (theme.vars || theme).palette.background["default"]
        }, theme.vars ? {
          backgroundColor: theme.vars.palette.Avatar.defaultBg
        } : _extends({
          backgroundColor: theme.palette.grey[400]
        }, theme.applyStyles('dark', {
          backgroundColor: theme.palette.grey[600]
        })))
      }]
    };
  });
  var AvatarImg = styled$1('img', {
    name: 'MuiAvatar',
    slot: 'Img',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.img;
    }
  })({
    width: '100%',
    height: '100%',
    textAlign: 'center',
    // Handle non-square image. The property isn't supported by IE11.
    objectFit: 'cover',
    // Hide alt text.
    color: 'transparent',
    // Hide the image broken icon, only works on Chrome.
    textIndent: 10000
  });
  var AvatarFallback = styled$1(Person, {
    name: 'MuiAvatar',
    slot: 'Fallback',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.fallback;
    }
  })({
    width: '75%',
    height: '75%'
  });
  function useLoaded(_ref2) {
    var crossOrigin = _ref2.crossOrigin,
      referrerPolicy = _ref2.referrerPolicy,
      src = _ref2.src,
      srcSet = _ref2.srcSet;
    var _React$useState = React__namespace.useState(false),
      loaded = _React$useState[0],
      setLoaded = _React$useState[1];
    React__namespace.useEffect(function () {
      if (!src && !srcSet) {
        return undefined;
      }
      setLoaded(false);
      var active = true;
      var image = new Image();
      image.onload = function () {
        if (!active) {
          return;
        }
        setLoaded('loaded');
      };
      image.onerror = function () {
        if (!active) {
          return;
        }
        setLoaded('error');
      };
      image.crossOrigin = crossOrigin;
      image.referrerPolicy = referrerPolicy;
      image.src = src;
      if (srcSet) {
        image.srcset = srcSet;
      }
      return function () {
        active = false;
      };
    }, [crossOrigin, referrerPolicy, src, srcSet]);
    return loaded;
  }
  var Avatar = /*#__PURE__*/React__namespace.forwardRef(function Avatar(inProps, ref) {
    var props = useThemeProps$3({
      props: inProps,
      name: 'MuiAvatar'
    });
    var alt = props.alt,
      childrenProp = props.children,
      className = props.className,
      _props$component = props.component,
      component = _props$component === void 0 ? 'div' : _props$component,
      _props$slots = props.slots,
      slots = _props$slots === void 0 ? {} : _props$slots,
      _props$slotProps = props.slotProps,
      slotProps = _props$slotProps === void 0 ? {} : _props$slotProps,
      imgProps = props.imgProps,
      sizes = props.sizes,
      src = props.src,
      srcSet = props.srcSet,
      _props$variant = props.variant,
      variant = _props$variant === void 0 ? 'circular' : _props$variant,
      other = _objectWithoutProperties(props, ["alt", "children", "className", "component", "slots", "slotProps", "imgProps", "sizes", "src", "srcSet", "variant"]);
    var children = null;

    // Use a hook instead of onError on the img element to support server-side rendering.
    var loaded = useLoaded(_extends({}, imgProps, {
      src: src,
      srcSet: srcSet
    }));
    var hasImg = src || srcSet;
    var hasImgNotFailing = hasImg && loaded !== 'error';
    var ownerState = _extends({}, props, {
      colorDefault: !hasImgNotFailing,
      component: component,
      variant: variant
    });
    var classes = useUtilityClasses$1w(ownerState);
    var _useSlot = useSlot('img', {
        className: classes.img,
        elementType: AvatarImg,
        externalForwardedProps: {
          slots: slots,
          slotProps: {
            img: _extends({}, imgProps, slotProps.img)
          }
        },
        additionalProps: {
          alt: alt,
          src: src,
          srcSet: srcSet,
          sizes: sizes
        },
        ownerState: ownerState
      }),
      _useSlot2 = _slicedToArray(_useSlot, 2),
      ImgSlot = _useSlot2[0],
      imgSlotProps = _useSlot2[1];
    if (hasImgNotFailing) {
      children = /*#__PURE__*/jsxRuntime_1(ImgSlot, _extends({}, imgSlotProps));
      // We only render valid children, non valid children are rendered with a fallback
      // We consider that invalid children are all falsy values, except 0, which is valid.
    } else if (!!childrenProp || childrenProp === 0) {
      children = childrenProp;
    } else if (hasImg && alt) {
      children = alt[0];
    } else {
      children = /*#__PURE__*/jsxRuntime_1(AvatarFallback, {
        ownerState: ownerState,
        className: classes.fallback
      });
    }
    return /*#__PURE__*/jsxRuntime_1(AvatarRoot, _extends({
      as: component,
      ownerState: ownerState,
      className: clsx(classes.root, className),
      ref: ref
    }, other, {
      children: children
    }));
  });
  Avatar.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * Used in combination with `src` or `srcSet` to
     * provide an alt attribute for the rendered `img` element.
     */
    alt: PropTypes.string,
    /**
     * Used to render icon or text elements inside the Avatar if `src` is not set.
     * This can be an element, or just a string.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,
    /**
     * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/img#attributes) applied to the `img` element if the component is used to display an image.
     * It can be used to listen for the loading error event.
     * @deprecated Use `slotProps.img` instead. This prop will be removed in v7. [How to migrate](/material-ui/migration/migrating-from-deprecated-apis/).
     */
    imgProps: PropTypes.object,
    /**
     * The `sizes` attribute for the `img` element.
     */
    sizes: PropTypes.string,
    /**
     * The props used for each slot inside.
     * @default {}
     */
    slotProps: PropTypes.shape({
      img: PropTypes.oneOfType([PropTypes.func, PropTypes.object])
    }),
    /**
     * The components used for each slot inside.
     * @default {}
     */
    slots: PropTypes.shape({
      img: PropTypes.elementType
    }),
    /**
     * The `src` attribute for the `img` element.
     */
    src: PropTypes.string,
    /**
     * The `srcSet` attribute for the `img` element.
     * Use this attribute for responsive image display.
     */
    srcSet: PropTypes.string,
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
    /**
     * The shape of the avatar.
     * @default 'circular'
     */
    variant: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['circular', 'rounded', 'square']), PropTypes.string])
  } ;
  var Avatar$1 = Avatar;

  function getAvatarGroupUtilityClass(slot) {
    return generateUtilityClass$1('MuiAvatarGroup', slot);
  }
  var avatarGroupClasses = generateUtilityClasses$1('MuiAvatarGroup', ['root', 'avatar']);
  var avatarGroupClasses$1 = avatarGroupClasses;

  var SPACINGS$2 = {
    small: -16,
    medium: null
  };
  var useUtilityClasses$1v = function useUtilityClasses(ownerState) {
    var classes = ownerState.classes;
    var slots = {
      root: ['root'],
      avatar: ['avatar']
    };
    return composeClasses(slots, getAvatarGroupUtilityClass, classes);
  };
  var AvatarGroupRoot = styled$1('div', {
    name: 'MuiAvatarGroup',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      return _extends(_defineProperty({}, "& .".concat(avatarGroupClasses$1.avatar), styles.avatar), styles.root);
    }
  })(function (_ref) {
    var theme = _ref.theme,
      ownerState = _ref.ownerState;
    var marginValue = ownerState.spacing && SPACINGS$2[ownerState.spacing] !== undefined ? SPACINGS$2[ownerState.spacing] : -ownerState.spacing;
    return _defineProperty(_defineProperty(_defineProperty({}, "& .".concat(avatarClasses$1.root), {
      border: "2px solid ".concat((theme.vars || theme).palette.background["default"]),
      boxSizing: 'content-box',
      marginLeft: marginValue != null ? marginValue : -8,
      '&:last-child': {
        marginLeft: 0
      }
    }), "display", 'flex'), "flexDirection", 'row-reverse');
  });
  var AvatarGroup = /*#__PURE__*/React__namespace.forwardRef(function AvatarGroup(inProps, ref) {
    var _slotProps$additional;
    var props = useThemeProps$b({
      props: inProps,
      name: 'MuiAvatarGroup'
    });
    var childrenProp = props.children,
      className = props.className,
      _props$component = props.component,
      component = _props$component === void 0 ? 'div' : _props$component,
      _props$componentsProp = props.componentsProps,
      componentsProps = _props$componentsProp === void 0 ? {} : _props$componentsProp,
      _props$max = props.max,
      max = _props$max === void 0 ? 5 : _props$max,
      renderSurplus = props.renderSurplus,
      _props$slotProps = props.slotProps,
      slotProps = _props$slotProps === void 0 ? {} : _props$slotProps,
      _props$spacing = props.spacing,
      spacing = _props$spacing === void 0 ? 'medium' : _props$spacing,
      total = props.total,
      _props$variant = props.variant,
      variant = _props$variant === void 0 ? 'circular' : _props$variant,
      other = _objectWithoutProperties(props, ["children", "className", "component", "componentsProps", "max", "renderSurplus", "slotProps", "spacing", "total", "variant"]);
    var clampedMax = max < 2 ? 2 : max;
    var ownerState = _extends({}, props, {
      max: max,
      spacing: spacing,
      component: component,
      variant: variant
    });
    var classes = useUtilityClasses$1v(ownerState);
    var children = React__namespace.Children.toArray(childrenProp).filter(function (child) {
      {
        if (reactIs_2(child)) {
          console.error(["MUI: The AvatarGroup component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
        }
      }
      return /*#__PURE__*/React__namespace.isValidElement(child);
    });
    var totalAvatars = total || children.length;
    if (totalAvatars === clampedMax) {
      clampedMax += 1;
    }
    clampedMax = Math.min(totalAvatars + 1, clampedMax);
    var maxAvatars = Math.min(children.length, clampedMax - 1);
    var extraAvatars = Math.max(totalAvatars - clampedMax, totalAvatars - maxAvatars, 0);
    var extraAvatarsElement = renderSurplus ? renderSurplus(extraAvatars) : "+".concat(extraAvatars);
    var additionalAvatarSlotProps = (_slotProps$additional = slotProps.additionalAvatar) != null ? _slotProps$additional : componentsProps.additionalAvatar;
    return /*#__PURE__*/jsxRuntime_2(AvatarGroupRoot, _extends({
      as: component,
      ownerState: ownerState,
      className: clsx(classes.root, className),
      ref: ref
    }, other, {
      children: [extraAvatars ? /*#__PURE__*/jsxRuntime_1(Avatar$1, _extends({
        variant: variant
      }, additionalAvatarSlotProps, {
        className: clsx(classes.avatar, additionalAvatarSlotProps == null ? void 0 : additionalAvatarSlotProps.className),
        children: extraAvatarsElement
      })) : null, children.slice(0, maxAvatars).reverse().map(function (child) {
        return /*#__PURE__*/React__namespace.cloneElement(child, {
          className: clsx(child.props.className, classes.avatar),
          variant: child.props.variant || variant
        });
      })]
    }));
  });
  AvatarGroup.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The avatars to stack.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,
    /**
     * The extra props for the slot components.
     * You can override the existing props or add new ones.
     *
     * This prop is an alias for the `slotProps` prop.
     * It's recommended to use the `slotProps` prop instead, as `componentsProps` will be deprecated in the future.
     *
     * @default {}
     */
    componentsProps: PropTypes.shape({
      additionalAvatar: PropTypes.object
    }),
    /**
     * Max avatars to show before +x.
     * @default 5
     */
    max: chainPropTypes(PropTypes.number, function (props) {
      if (props.max < 2) {
        return new Error(['MUI: The prop `max` should be equal to 2 or above.', 'A value below is clamped to 2.'].join('\n'));
      }
      return null;
    }),
    /**
     * custom renderer of extraAvatars
     * @param {number} surplus number of extra avatars
     * @returns {React.ReactNode} custom element to display
     */
    renderSurplus: PropTypes.func,
    /**
     * The extra props for the slot components.
     * You can override the existing props or add new ones.
     *
     * This prop is an alias for the `componentsProps` prop, which will be deprecated in the future.
     *
     * @default {}
     */
    slotProps: PropTypes.shape({
      additionalAvatar: PropTypes.object
    }),
    /**
     * Spacing between avatars.
     * @default 'medium'
     */
    spacing: PropTypes.oneOfType([PropTypes.oneOf(['medium', 'small']), PropTypes.number]),
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
    /**
     * The total number of avatars. Used for calculating the number of extra avatars.
     * @default children.length
     */
    total: PropTypes.number,
    /**
     * The variant to use.
     * @default 'circular'
     */
    variant: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['circular', 'rounded', 'square']), PropTypes.string])
  } ;
  var AvatarGroup$1 = AvatarGroup;

  var styles$3 = {
    entering: {
      opacity: 1
    },
    entered: {
      opacity: 1
    }
  };

  /**
   * The Fade transition is used by the [Modal](/material-ui/react-modal/) component.
   * It uses [react-transition-group](https://github.com/reactjs/react-transition-group) internally.
   */
  var Fade = /*#__PURE__*/React__namespace.forwardRef(function Fade(props, ref) {
    var theme = useTheme();
    var defaultTimeout = {
      enter: theme.transitions.duration.enteringScreen,
      exit: theme.transitions.duration.leavingScreen
    };
    var addEndListener = props.addEndListener,
      _props$appear = props.appear,
      appear = _props$appear === void 0 ? true : _props$appear,
      _children = props.children,
      easing = props.easing,
      inProp = props["in"],
      onEnter = props.onEnter,
      onEntered = props.onEntered,
      onEntering = props.onEntering,
      onExit = props.onExit,
      onExited = props.onExited,
      onExiting = props.onExiting,
      style = props.style,
      _props$timeout = props.timeout,
      timeout = _props$timeout === void 0 ? defaultTimeout : _props$timeout,
      _props$TransitionComp = props.TransitionComponent,
      TransitionComponent = _props$TransitionComp === void 0 ? Transition$1 : _props$TransitionComp,
      other = _objectWithoutProperties(props, ["addEndListener", "appear", "children", "easing", "in", "onEnter", "onEntered", "onEntering", "onExit", "onExited", "onExiting", "style", "timeout", "TransitionComponent"]);
    var nodeRef = React__namespace.useRef(null);
    var handleRef = useForkRef(nodeRef, _children.ref, ref);
    var normalizedTransitionCallback = function normalizedTransitionCallback(callback) {
      return function (maybeIsAppearing) {
        if (callback) {
          var node = nodeRef.current;

          // onEnterXxx and onExitXxx callbacks have a different arguments.length value.
          if (maybeIsAppearing === undefined) {
            callback(node);
          } else {
            callback(node, maybeIsAppearing);
          }
        }
      };
    };
    var handleEntering = normalizedTransitionCallback(onEntering);
    var handleEnter = normalizedTransitionCallback(function (node, isAppearing) {
      reflow(node); // So the animation always start from the start.

      var transitionProps = getTransitionProps({
        style: style,
        timeout: timeout,
        easing: easing
      }, {
        mode: 'enter'
      });
      node.style.webkitTransition = theme.transitions.create('opacity', transitionProps);
      node.style.transition = theme.transitions.create('opacity', transitionProps);
      if (onEnter) {
        onEnter(node, isAppearing);
      }
    });
    var handleEntered = normalizedTransitionCallback(onEntered);
    var handleExiting = normalizedTransitionCallback(onExiting);
    var handleExit = normalizedTransitionCallback(function (node) {
      var transitionProps = getTransitionProps({
        style: style,
        timeout: timeout,
        easing: easing
      }, {
        mode: 'exit'
      });
      node.style.webkitTransition = theme.transitions.create('opacity', transitionProps);
      node.style.transition = theme.transitions.create('opacity', transitionProps);
      if (onExit) {
        onExit(node);
      }
    });
    var handleExited = normalizedTransitionCallback(onExited);
    var handleAddEndListener = function handleAddEndListener(next) {
      if (addEndListener) {
        // Old call signature before `react-transition-group` implemented `nodeRef`
        addEndListener(nodeRef.current, next);
      }
    };
    return /*#__PURE__*/jsxRuntime_1(TransitionComponent, _extends({
      appear: appear,
      "in": inProp,
      nodeRef: nodeRef ,
      onEnter: handleEnter,
      onEntered: handleEntered,
      onEntering: handleEntering,
      onExit: handleExit,
      onExited: handleExited,
      onExiting: handleExiting,
      addEndListener: handleAddEndListener,
      timeout: timeout
    }, other, {
      children: function children(state, childProps) {
        return /*#__PURE__*/React__namespace.cloneElement(_children, _extends({
          style: _extends({
            opacity: 0,
            visibility: state === 'exited' && !inProp ? 'hidden' : undefined
          }, styles$3[state], style, _children.props.style),
          ref: handleRef
        }, childProps));
      }
    }));
  });
  Fade.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * Add a custom transition end trigger. Called with the transitioning DOM
     * node and a done callback. Allows for more fine grained transition end
     * logic. Note: Timeouts are still used as a fallback if provided.
     */
    addEndListener: PropTypes.func,
    /**
     * Perform the enter transition when it first mounts if `in` is also `true`.
     * Set this to `false` to disable this behavior.
     * @default true
     */
    appear: PropTypes.bool,
    /**
     * A single child content element.
     */
    children: elementAcceptingRef$1.isRequired,
    /**
     * The transition timing function.
     * You may specify a single easing or a object containing enter and exit values.
     */
    easing: PropTypes.oneOfType([PropTypes.shape({
      enter: PropTypes.string,
      exit: PropTypes.string
    }), PropTypes.string]),
    /**
     * If `true`, the component will transition in.
     */
    "in": PropTypes.bool,
    /**
     * @ignore
     */
    onEnter: PropTypes.func,
    /**
     * @ignore
     */
    onEntered: PropTypes.func,
    /**
     * @ignore
     */
    onEntering: PropTypes.func,
    /**
     * @ignore
     */
    onExit: PropTypes.func,
    /**
     * @ignore
     */
    onExited: PropTypes.func,
    /**
     * @ignore
     */
    onExiting: PropTypes.func,
    /**
     * @ignore
     */
    style: PropTypes.object,
    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     * @default {
     *   enter: theme.transitions.duration.enteringScreen,
     *   exit: theme.transitions.duration.leavingScreen,
     * }
     */
    timeout: PropTypes.oneOfType([PropTypes.number, PropTypes.shape({
      appear: PropTypes.number,
      enter: PropTypes.number,
      exit: PropTypes.number
    })])
  } ;
  var Fade$1 = Fade;

  function getBackdropUtilityClass(slot) {
    return generateUtilityClass$1('MuiBackdrop', slot);
  }
  var backdropClasses = generateUtilityClasses$1('MuiBackdrop', ['root', 'invisible']);
  var backdropClasses$1 = backdropClasses;

  var useUtilityClasses$1u = function useUtilityClasses(ownerState) {
    var classes = ownerState.classes,
      invisible = ownerState.invisible;
    var slots = {
      root: ['root', invisible && 'invisible']
    };
    return composeClasses(slots, getBackdropUtilityClass, classes);
  };
  var BackdropRoot = styled$1('div', {
    name: 'MuiBackdrop',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      return [styles.root, ownerState.invisible && styles.invisible];
    }
  })(function (_ref) {
    var ownerState = _ref.ownerState;
    return _extends({
      position: 'fixed',
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center',
      right: 0,
      bottom: 0,
      top: 0,
      left: 0,
      backgroundColor: 'rgba(0, 0, 0, 0.5)',
      WebkitTapHighlightColor: 'transparent'
    }, ownerState.invisible && {
      backgroundColor: 'transparent'
    });
  });
  var Backdrop = /*#__PURE__*/React__namespace.forwardRef(function Backdrop(inProps, ref) {
    var _slotProps$root, _ref2, _slots$root;
    var props = useThemeProps$b({
      props: inProps,
      name: 'MuiBackdrop'
    });
    var children = props.children,
      className = props.className,
      _props$component = props.component,
      component = _props$component === void 0 ? 'div' : _props$component,
      _props$components = props.components,
      components = _props$components === void 0 ? {} : _props$components,
      _props$componentsProp = props.componentsProps,
      componentsProps = _props$componentsProp === void 0 ? {} : _props$componentsProp,
      _props$invisible = props.invisible,
      invisible = _props$invisible === void 0 ? false : _props$invisible,
      open = props.open,
      _props$slotProps = props.slotProps,
      slotProps = _props$slotProps === void 0 ? {} : _props$slotProps,
      _props$slots = props.slots,
      slots = _props$slots === void 0 ? {} : _props$slots,
      _props$TransitionComp = props.TransitionComponent,
      TransitionComponent = _props$TransitionComp === void 0 ? Fade$1 : _props$TransitionComp,
      transitionDuration = props.transitionDuration,
      other = _objectWithoutProperties(props, ["children", "className", "component", "components", "componentsProps", "invisible", "open", "slotProps", "slots", "TransitionComponent", "transitionDuration"]);
    var ownerState = _extends({}, props, {
      component: component,
      invisible: invisible
    });
    var classes = useUtilityClasses$1u(ownerState);
    var rootSlotProps = (_slotProps$root = slotProps.root) != null ? _slotProps$root : componentsProps.root;
    return /*#__PURE__*/jsxRuntime_1(TransitionComponent, _extends({
      "in": open,
      timeout: transitionDuration
    }, other, {
      children: /*#__PURE__*/jsxRuntime_1(BackdropRoot, _extends({
        "aria-hidden": true
      }, rootSlotProps, {
        as: (_ref2 = (_slots$root = slots.root) != null ? _slots$root : components.Root) != null ? _ref2 : component,
        className: clsx(classes.root, className, rootSlotProps == null ? void 0 : rootSlotProps.className),
        ownerState: _extends({}, ownerState, rootSlotProps == null ? void 0 : rootSlotProps.ownerState),
        classes: classes,
        ref: ref,
        children: children
      }))
    }));
  });
  Backdrop.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The content of the component.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,
    /**
     * The components used for each slot inside.
     *
     * This prop is an alias for the `slots` prop.
     * It's recommended to use the `slots` prop instead.
     *
     * @default {}
     */
    components: PropTypes.shape({
      Root: PropTypes.elementType
    }),
    /**
     * The extra props for the slot components.
     * You can override the existing props or add new ones.
     *
     * This prop is an alias for the `slotProps` prop.
     * It's recommended to use the `slotProps` prop instead, as `componentsProps` will be deprecated in the future.
     *
     * @default {}
     */
    componentsProps: PropTypes.shape({
      root: PropTypes.object
    }),
    /**
     * If `true`, the backdrop is invisible.
     * It can be used when rendering a popover or a custom select component.
     * @default false
     */
    invisible: PropTypes.bool,
    /**
     * If `true`, the component is shown.
     */
    open: PropTypes.bool.isRequired,
    /**
     * The extra props for the slot components.
     * You can override the existing props or add new ones.
     *
     * This prop is an alias for the `componentsProps` prop, which will be deprecated in the future.
     *
     * @default {}
     */
    slotProps: PropTypes.shape({
      root: PropTypes.object
    }),
    /**
     * The components used for each slot inside.
     *
     * This prop is an alias for the `components` prop, which will be deprecated in the future.
     *
     * @default {}
     */
    slots: PropTypes.shape({
      root: PropTypes.elementType
    }),
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
    /**
     * The component used for the transition.
     * [Follow this guide](/material-ui/transitions/#transitioncomponent-prop) to learn more about the requirements for this component.
     * @default Fade
     */
    TransitionComponent: PropTypes.elementType,
    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     */
    transitionDuration: PropTypes.oneOfType([PropTypes.number, PropTypes.shape({
      appear: PropTypes.number,
      enter: PropTypes.number,
      exit: PropTypes.number
    })])
  } ;
  var Backdrop$1 = Backdrop;

  function getBadgeUtilityClass(slot) {
    return generateUtilityClass$1('MuiBadge', slot);
  }
  var badgeClasses = generateUtilityClasses$1('MuiBadge', ['root', 'badge', 'dot', 'standard', 'anchorOriginTopRight', 'anchorOriginBottomRight', 'anchorOriginTopLeft', 'anchorOriginBottomLeft', 'invisible', 'colorError', 'colorInfo', 'colorPrimary', 'colorSecondary', 'colorSuccess', 'colorWarning', 'overlapRectangular', 'overlapCircular',
  // TODO: v6 remove the overlap value from these class keys
  'anchorOriginTopLeftCircular', 'anchorOriginTopLeftRectangular', 'anchorOriginTopRightCircular', 'anchorOriginTopRightRectangular', 'anchorOriginBottomLeftCircular', 'anchorOriginBottomLeftRectangular', 'anchorOriginBottomRightCircular', 'anchorOriginBottomRightRectangular']);
  var badgeClasses$1 = badgeClasses;

  var RADIUS_STANDARD = 10;
  var RADIUS_DOT = 4;
  var useThemeProps$2 = createUseThemeProps();
  var useUtilityClasses$1t = function useUtilityClasses(ownerState) {
    var color = ownerState.color,
      anchorOrigin = ownerState.anchorOrigin,
      invisible = ownerState.invisible,
      overlap = ownerState.overlap,
      variant = ownerState.variant,
      _ownerState$classes = ownerState.classes,
      classes = _ownerState$classes === void 0 ? {} : _ownerState$classes;
    var slots = {
      root: ['root'],
      badge: ['badge', variant, invisible && 'invisible', "anchorOrigin".concat(capitalize(anchorOrigin.vertical)).concat(capitalize(anchorOrigin.horizontal)), "anchorOrigin".concat(capitalize(anchorOrigin.vertical)).concat(capitalize(anchorOrigin.horizontal)).concat(capitalize(overlap)), "overlap".concat(capitalize(overlap)), color !== 'default' && "color".concat(capitalize(color))]
    };
    return composeClasses(slots, getBadgeUtilityClass, classes);
  };
  var BadgeRoot = styled$1('span', {
    name: 'MuiBadge',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.root;
    }
  })({
    position: 'relative',
    display: 'inline-flex',
    // For correct alignment with the text.
    verticalAlign: 'middle',
    flexShrink: 0
  });
  var BadgeBadge = styled$1('span', {
    name: 'MuiBadge',
    slot: 'Badge',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      return [styles.badge, styles[ownerState.variant], styles["anchorOrigin".concat(capitalize(ownerState.anchorOrigin.vertical)).concat(capitalize(ownerState.anchorOrigin.horizontal)).concat(capitalize(ownerState.overlap))], ownerState.color !== 'default' && styles["color".concat(capitalize(ownerState.color))], ownerState.invisible && styles.invisible];
    }
  })(function (_ref) {
    var _theme$vars;
    var theme = _ref.theme;
    return {
      display: 'flex',
      flexDirection: 'row',
      flexWrap: 'wrap',
      justifyContent: 'center',
      alignContent: 'center',
      alignItems: 'center',
      position: 'absolute',
      boxSizing: 'border-box',
      fontFamily: theme.typography.fontFamily,
      fontWeight: theme.typography.fontWeightMedium,
      fontSize: theme.typography.pxToRem(12),
      minWidth: RADIUS_STANDARD * 2,
      lineHeight: 1,
      padding: '0 6px',
      height: RADIUS_STANDARD * 2,
      borderRadius: RADIUS_STANDARD,
      zIndex: 1,
      // Render the badge on top of potential ripples.
      transition: theme.transitions.create('transform', {
        easing: theme.transitions.easing.easeInOut,
        duration: theme.transitions.duration.enteringScreen
      }),
      variants: [].concat(_toConsumableArray(Object.keys(((_theme$vars = theme.vars) != null ? _theme$vars : theme).palette).filter(function (key) {
        var _theme$vars2, _theme$vars3;
        return ((_theme$vars2 = theme.vars) != null ? _theme$vars2 : theme).palette[key].main && ((_theme$vars3 = theme.vars) != null ? _theme$vars3 : theme).palette[key].contrastText;
      }).map(function (color) {
        return {
          props: {
            color: color
          },
          style: {
            backgroundColor: (theme.vars || theme).palette[color].main,
            color: (theme.vars || theme).palette[color].contrastText
          }
        };
      })), [{
        props: {
          variant: 'dot'
        },
        style: {
          borderRadius: RADIUS_DOT,
          height: RADIUS_DOT * 2,
          minWidth: RADIUS_DOT * 2,
          padding: 0
        }
      }, {
        props: function props(_ref2) {
          var ownerState = _ref2.ownerState;
          return ownerState.anchorOrigin.vertical === 'top' && ownerState.anchorOrigin.horizontal === 'right' && ownerState.overlap === 'rectangular';
        },
        style: _defineProperty({
          top: 0,
          right: 0,
          transform: 'scale(1) translate(50%, -50%)',
          transformOrigin: '100% 0%'
        }, "&.".concat(badgeClasses$1.invisible), {
          transform: 'scale(0) translate(50%, -50%)'
        })
      }, {
        props: function props(_ref3) {
          var ownerState = _ref3.ownerState;
          return ownerState.anchorOrigin.vertical === 'bottom' && ownerState.anchorOrigin.horizontal === 'right' && ownerState.overlap === 'rectangular';
        },
        style: _defineProperty({
          bottom: 0,
          right: 0,
          transform: 'scale(1) translate(50%, 50%)',
          transformOrigin: '100% 100%'
        }, "&.".concat(badgeClasses$1.invisible), {
          transform: 'scale(0) translate(50%, 50%)'
        })
      }, {
        props: function props(_ref4) {
          var ownerState = _ref4.ownerState;
          return ownerState.anchorOrigin.vertical === 'top' && ownerState.anchorOrigin.horizontal === 'left' && ownerState.overlap === 'rectangular';
        },
        style: _defineProperty({
          top: 0,
          left: 0,
          transform: 'scale(1) translate(-50%, -50%)',
          transformOrigin: '0% 0%'
        }, "&.".concat(badgeClasses$1.invisible), {
          transform: 'scale(0) translate(-50%, -50%)'
        })
      }, {
        props: function props(_ref5) {
          var ownerState = _ref5.ownerState;
          return ownerState.anchorOrigin.vertical === 'bottom' && ownerState.anchorOrigin.horizontal === 'left' && ownerState.overlap === 'rectangular';
        },
        style: _defineProperty({
          bottom: 0,
          left: 0,
          transform: 'scale(1) translate(-50%, 50%)',
          transformOrigin: '0% 100%'
        }, "&.".concat(badgeClasses$1.invisible), {
          transform: 'scale(0) translate(-50%, 50%)'
        })
      }, {
        props: function props(_ref6) {
          var ownerState = _ref6.ownerState;
          return ownerState.anchorOrigin.vertical === 'top' && ownerState.anchorOrigin.horizontal === 'right' && ownerState.overlap === 'circular';
        },
        style: _defineProperty({
          top: '14%',
          right: '14%',
          transform: 'scale(1) translate(50%, -50%)',
          transformOrigin: '100% 0%'
        }, "&.".concat(badgeClasses$1.invisible), {
          transform: 'scale(0) translate(50%, -50%)'
        })
      }, {
        props: function props(_ref7) {
          var ownerState = _ref7.ownerState;
          return ownerState.anchorOrigin.vertical === 'bottom' && ownerState.anchorOrigin.horizontal === 'right' && ownerState.overlap === 'circular';
        },
        style: _defineProperty({
          bottom: '14%',
          right: '14%',
          transform: 'scale(1) translate(50%, 50%)',
          transformOrigin: '100% 100%'
        }, "&.".concat(badgeClasses$1.invisible), {
          transform: 'scale(0) translate(50%, 50%)'
        })
      }, {
        props: function props(_ref8) {
          var ownerState = _ref8.ownerState;
          return ownerState.anchorOrigin.vertical === 'top' && ownerState.anchorOrigin.horizontal === 'left' && ownerState.overlap === 'circular';
        },
        style: _defineProperty({
          top: '14%',
          left: '14%',
          transform: 'scale(1) translate(-50%, -50%)',
          transformOrigin: '0% 0%'
        }, "&.".concat(badgeClasses$1.invisible), {
          transform: 'scale(0) translate(-50%, -50%)'
        })
      }, {
        props: function props(_ref9) {
          var ownerState = _ref9.ownerState;
          return ownerState.anchorOrigin.vertical === 'bottom' && ownerState.anchorOrigin.horizontal === 'left' && ownerState.overlap === 'circular';
        },
        style: _defineProperty({
          bottom: '14%',
          left: '14%',
          transform: 'scale(1) translate(-50%, 50%)',
          transformOrigin: '0% 100%'
        }, "&.".concat(badgeClasses$1.invisible), {
          transform: 'scale(0) translate(-50%, 50%)'
        })
      }, {
        props: {
          invisible: true
        },
        style: {
          transition: theme.transitions.create('transform', {
            easing: theme.transitions.easing.easeInOut,
            duration: theme.transitions.duration.leavingScreen
          })
        }
      }])
    };
  });
  var Badge = /*#__PURE__*/React__namespace.forwardRef(function Badge(inProps, ref) {
    var _ref11, _slots$root, _ref12, _slots$badge, _slotProps$root, _slotProps$badge;
    var props = useThemeProps$2({
      props: inProps,
      name: 'MuiBadge'
    });
    var _props$anchorOrigin = props.anchorOrigin,
      anchorOriginProp = _props$anchorOrigin === void 0 ? {
        vertical: 'top',
        horizontal: 'right'
      } : _props$anchorOrigin,
      className = props.className;
      props.classes;
      var component = props.component,
      _props$components = props.components,
      components = _props$components === void 0 ? {} : _props$components,
      _props$componentsProp = props.componentsProps,
      componentsProps = _props$componentsProp === void 0 ? {} : _props$componentsProp,
      children = props.children,
      _props$overlap = props.overlap,
      overlapProp = _props$overlap === void 0 ? 'rectangular' : _props$overlap,
      _props$color = props.color,
      colorProp = _props$color === void 0 ? 'default' : _props$color,
      _props$invisible = props.invisible,
      invisibleProp = _props$invisible === void 0 ? false : _props$invisible,
      _props$max = props.max,
      maxProp = _props$max === void 0 ? 99 : _props$max,
      badgeContentProp = props.badgeContent,
      slots = props.slots,
      slotProps = props.slotProps,
      _props$showZero = props.showZero,
      showZero = _props$showZero === void 0 ? false : _props$showZero,
      _props$variant = props.variant,
      variantProp = _props$variant === void 0 ? 'standard' : _props$variant,
      other = _objectWithoutProperties(props, ["anchorOrigin", "className", "classes", "component", "components", "componentsProps", "children", "overlap", "color", "invisible", "max", "badgeContent", "slots", "slotProps", "showZero", "variant"]);
    var _useBadge = useBadge({
        max: maxProp,
        invisible: invisibleProp,
        badgeContent: badgeContentProp,
        showZero: showZero
      }),
      badgeContent = _useBadge.badgeContent,
      invisibleFromHook = _useBadge.invisible,
      max = _useBadge.max,
      displayValueFromHook = _useBadge.displayValue;
    var prevProps = usePreviousProps$1({
      anchorOrigin: anchorOriginProp,
      color: colorProp,
      overlap: overlapProp,
      variant: variantProp,
      badgeContent: badgeContentProp
    });
    var invisible = invisibleFromHook || badgeContent == null && variantProp !== 'dot';
    var _ref10 = invisible ? prevProps : props,
      _ref10$color = _ref10.color,
      color = _ref10$color === void 0 ? colorProp : _ref10$color,
      _ref10$overlap = _ref10.overlap,
      overlap = _ref10$overlap === void 0 ? overlapProp : _ref10$overlap,
      _ref10$anchorOrigin = _ref10.anchorOrigin,
      anchorOrigin = _ref10$anchorOrigin === void 0 ? anchorOriginProp : _ref10$anchorOrigin,
      _ref10$variant = _ref10.variant,
      variant = _ref10$variant === void 0 ? variantProp : _ref10$variant;
    var displayValue = variant !== 'dot' ? displayValueFromHook : undefined;
    var ownerState = _extends({}, props, {
      badgeContent: badgeContent,
      invisible: invisible,
      max: max,
      displayValue: displayValue,
      showZero: showZero,
      anchorOrigin: anchorOrigin,
      color: color,
      overlap: overlap,
      variant: variant
    });
    var classes = useUtilityClasses$1t(ownerState);

    // support both `slots` and `components` for backward compatibility
    var RootSlot = (_ref11 = (_slots$root = slots == null ? void 0 : slots.root) != null ? _slots$root : components.Root) != null ? _ref11 : BadgeRoot;
    var BadgeSlot = (_ref12 = (_slots$badge = slots == null ? void 0 : slots.badge) != null ? _slots$badge : components.Badge) != null ? _ref12 : BadgeBadge;
    var rootSlotProps = (_slotProps$root = slotProps == null ? void 0 : slotProps.root) != null ? _slotProps$root : componentsProps.root;
    var badgeSlotProps = (_slotProps$badge = slotProps == null ? void 0 : slotProps.badge) != null ? _slotProps$badge : componentsProps.badge;
    var rootProps = useSlotProps({
      elementType: RootSlot,
      externalSlotProps: rootSlotProps,
      externalForwardedProps: other,
      additionalProps: {
        ref: ref,
        as: component
      },
      ownerState: ownerState,
      className: clsx(rootSlotProps == null ? void 0 : rootSlotProps.className, classes.root, className)
    });
    var badgeProps = useSlotProps({
      elementType: BadgeSlot,
      externalSlotProps: badgeSlotProps,
      ownerState: ownerState,
      className: clsx(classes.badge, badgeSlotProps == null ? void 0 : badgeSlotProps.className)
    });
    return /*#__PURE__*/jsxRuntime_2(RootSlot, _extends({}, rootProps, {
      children: [children, /*#__PURE__*/jsxRuntime_1(BadgeSlot, _extends({}, badgeProps, {
        children: displayValue
      }))]
    }));
  });
  Badge.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The anchor of the badge.
     * @default {
     *   vertical: 'top',
     *   horizontal: 'right',
     * }
     */
    anchorOrigin: PropTypes.shape({
      horizontal: PropTypes.oneOf(['left', 'right']).isRequired,
      vertical: PropTypes.oneOf(['bottom', 'top']).isRequired
    }),
    /**
     * The content rendered within the badge.
     */
    badgeContent: PropTypes.node,
    /**
     * The badge will be added relative to this node.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The color of the component.
     * It supports both default and custom theme colors, which can be added as shown in the
     * [palette customization guide](https://mui.com/material-ui/customization/palette/#custom-colors).
     * @default 'default'
     */
    color: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['default', 'primary', 'secondary', 'error', 'info', 'success', 'warning']), PropTypes.string]),
    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,
    /**
     * The components used for each slot inside.
     *
     * This prop is an alias for the `slots` prop.
     * It's recommended to use the `slots` prop instead.
     *
     * @default {}
     */
    components: PropTypes.shape({
      Badge: PropTypes.elementType,
      Root: PropTypes.elementType
    }),
    /**
     * The extra props for the slot components.
     * You can override the existing props or add new ones.
     *
     * This prop is an alias for the `slotProps` prop.
     * It's recommended to use the `slotProps` prop instead, as `componentsProps` will be deprecated in the future.
     *
     * @default {}
     */
    componentsProps: PropTypes.shape({
      badge: PropTypes.oneOfType([PropTypes.func, PropTypes.object]),
      root: PropTypes.oneOfType([PropTypes.func, PropTypes.object])
    }),
    /**
     * If `true`, the badge is invisible.
     * @default false
     */
    invisible: PropTypes.bool,
    /**
     * Max count to show.
     * @default 99
     */
    max: PropTypes.number,
    /**
     * Wrapped shape the badge should overlap.
     * @default 'rectangular'
     */
    overlap: PropTypes.oneOf(['circular', 'rectangular']),
    /**
     * Controls whether the badge is hidden when `badgeContent` is zero.
     * @default false
     */
    showZero: PropTypes.bool,
    /**
     * The props used for each slot inside the Badge.
     * @default {}
     */
    slotProps: PropTypes.shape({
      badge: PropTypes.oneOfType([PropTypes.func, PropTypes.object]),
      root: PropTypes.oneOfType([PropTypes.func, PropTypes.object])
    }),
    /**
     * The components used for each slot inside the Badge.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    slots: PropTypes.shape({
      badge: PropTypes.elementType,
      root: PropTypes.elementType
    }),
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
    /**
     * The variant to use.
     * @default 'standard'
     */
    variant: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['dot', 'standard']), PropTypes.string])
  } ;
  var Badge$1 = Badge;

  function getBottomNavigationUtilityClass(slot) {
    return generateUtilityClass$1('MuiBottomNavigation', slot);
  }
  var bottomNavigationClasses = generateUtilityClasses$1('MuiBottomNavigation', ['root']);
  var bottomNavigationClasses$1 = bottomNavigationClasses;

  var useUtilityClasses$1s = function useUtilityClasses(ownerState) {
    var classes = ownerState.classes;
    var slots = {
      root: ['root']
    };
    return composeClasses(slots, getBottomNavigationUtilityClass, classes);
  };
  var BottomNavigationRoot = styled$1('div', {
    name: 'MuiBottomNavigation',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.root;
    }
  })(function (_ref) {
    var theme = _ref.theme;
    return {
      display: 'flex',
      justifyContent: 'center',
      height: 56,
      backgroundColor: (theme.vars || theme).palette.background.paper
    };
  });
  var BottomNavigation = /*#__PURE__*/React__namespace.forwardRef(function BottomNavigation(inProps, ref) {
    var props = useThemeProps$b({
      props: inProps,
      name: 'MuiBottomNavigation'
    });
    var children = props.children,
      className = props.className,
      _props$component = props.component,
      component = _props$component === void 0 ? 'div' : _props$component,
      onChange = props.onChange,
      _props$showLabels = props.showLabels,
      showLabels = _props$showLabels === void 0 ? false : _props$showLabels,
      value = props.value,
      other = _objectWithoutProperties(props, ["children", "className", "component", "onChange", "showLabels", "value"]);
    var ownerState = _extends({}, props, {
      component: component,
      showLabels: showLabels
    });
    var classes = useUtilityClasses$1s(ownerState);
    return /*#__PURE__*/jsxRuntime_1(BottomNavigationRoot, _extends({
      as: component,
      className: clsx(classes.root, className),
      ref: ref,
      ownerState: ownerState
    }, other, {
      children: React__namespace.Children.map(children, function (child, childIndex) {
        if (! /*#__PURE__*/React__namespace.isValidElement(child)) {
          return null;
        }
        {
          if (reactIs_2(child)) {
            console.error(["MUI: The BottomNavigation component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
          }
        }
        var childValue = child.props.value === undefined ? childIndex : child.props.value;
        return /*#__PURE__*/React__namespace.cloneElement(child, {
          selected: childValue === value,
          showLabel: child.props.showLabel !== undefined ? child.props.showLabel : showLabels,
          value: childValue,
          onChange: onChange
        });
      })
    }));
  });
  BottomNavigation.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The content of the component.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,
    /**
     * Callback fired when the value changes.
     *
     * @param {React.SyntheticEvent} event The event source of the callback. **Warning**: This is a generic event not a change event.
     * @param {any} value We default to the index of the child.
     */
    onChange: PropTypes.func,
    /**
     * If `true`, all `BottomNavigationAction`s will show their labels.
     * By default, only the selected `BottomNavigationAction` will show its label.
     * @default false
     */
    showLabels: PropTypes.bool,
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
    /**
     * The value of the currently selected `BottomNavigationAction`.
     */
    value: PropTypes.any
  } ;
  var BottomNavigation$1 = BottomNavigation;

  function getBottomNavigationActionUtilityClass(slot) {
    return generateUtilityClass$1('MuiBottomNavigationAction', slot);
  }
  var bottomNavigationActionClasses = generateUtilityClasses$1('MuiBottomNavigationAction', ['root', 'iconOnly', 'selected', 'label']);
  var bottomNavigationActionClasses$1 = bottomNavigationActionClasses;

  var useUtilityClasses$1r = function useUtilityClasses(ownerState) {
    var classes = ownerState.classes,
      showLabel = ownerState.showLabel,
      selected = ownerState.selected;
    var slots = {
      root: ['root', !showLabel && !selected && 'iconOnly', selected && 'selected'],
      label: ['label', !showLabel && !selected && 'iconOnly', selected && 'selected']
    };
    return composeClasses(slots, getBottomNavigationActionUtilityClass, classes);
  };
  var BottomNavigationActionRoot = styled$1(ButtonBase$1, {
    name: 'MuiBottomNavigationAction',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      var ownerState = props.ownerState;
      return [styles.root, !ownerState.showLabel && !ownerState.selected && styles.iconOnly];
    }
  })(function (_ref) {
    var theme = _ref.theme,
      ownerState = _ref.ownerState;
    return _extends({
      transition: theme.transitions.create(['color', 'padding-top'], {
        duration: theme.transitions.duration["short"]
      }),
      padding: '0px 12px',
      minWidth: 80,
      maxWidth: 168,
      color: (theme.vars || theme).palette.text.secondary,
      flexDirection: 'column',
      flex: '1'
    }, !ownerState.showLabel && !ownerState.selected && {
      paddingTop: 14
    }, !ownerState.showLabel && !ownerState.selected && !ownerState.label && {
      paddingTop: 0
    }, _defineProperty({}, "&.".concat(bottomNavigationActionClasses$1.selected), {
      color: (theme.vars || theme).palette.primary.main
    }));
  });
  var BottomNavigationActionLabel = styled$1('span', {
    name: 'MuiBottomNavigationAction',
    slot: 'Label',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.label;
    }
  })(function (_ref2) {
    var theme = _ref2.theme,
      ownerState = _ref2.ownerState;
    return _extends({
      fontFamily: theme.typography.fontFamily,
      fontSize: theme.typography.pxToRem(12),
      opacity: 1,
      transition: 'font-size 0.2s, opacity 0.2s',
      transitionDelay: '0.1s'
    }, !ownerState.showLabel && !ownerState.selected && {
      opacity: 0,
      transitionDelay: '0s'
    }, _defineProperty({}, "&.".concat(bottomNavigationActionClasses$1.selected), {
      fontSize: theme.typography.pxToRem(14)
    }));
  });
  var BottomNavigationAction = /*#__PURE__*/React__namespace.forwardRef(function BottomNavigationAction(inProps, ref) {
    var props = useThemeProps$b({
      props: inProps,
      name: 'MuiBottomNavigationAction'
    });
    var className = props.className,
      icon = props.icon,
      label = props.label,
      onChange = props.onChange,
      onClick = props.onClick;
      props.selected;
      props.showLabel;
      var value = props.value,
      other = _objectWithoutProperties(props, ["className", "icon", "label", "onChange", "onClick", "selected", "showLabel", "value"]);
    var ownerState = props;
    var classes = useUtilityClasses$1r(ownerState);
    var handleChange = function handleChange(event) {
      if (onChange) {
        onChange(event, value);
      }
      if (onClick) {
        onClick(event);
      }
    };
    return /*#__PURE__*/jsxRuntime_2(BottomNavigationActionRoot, _extends({
      ref: ref,
      className: clsx(classes.root, className),
      focusRipple: true,
      onClick: handleChange,
      ownerState: ownerState
    }, other, {
      children: [icon, /*#__PURE__*/jsxRuntime_1(BottomNavigationActionLabel, {
        className: classes.label,
        ownerState: ownerState,
        children: label
      })]
    }));
  });
  BottomNavigationAction.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * This prop isn't supported.
     * Use the `component` prop if you need to change the children structure.
     */
    children: unsupportedProp,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The icon to display.
     */
    icon: PropTypes.node,
    /**
     * The label element.
     */
    label: PropTypes.node,
    /**
     * @ignore
     */
    onChange: PropTypes.func,
    /**
     * @ignore
     */
    onClick: PropTypes.func,
    /**
     * If `true`, the `BottomNavigationAction` will show its label.
     * By default, only the selected `BottomNavigationAction`
     * inside `BottomNavigation` will show its label.
     *
     * The prop defaults to the value (`false`) inherited from the parent BottomNavigation component.
     */
    showLabel: PropTypes.bool,
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
    /**
     * You can provide your own value. Otherwise, we fallback to the child position index.
     */
    value: PropTypes.any
  } ;
  var BottomNavigationAction$1 = BottomNavigationAction;

  var boxClasses = generateUtilityClasses$1('MuiBox', ['root']);
  var boxClasses$1 = boxClasses;

  var defaultTheme = createTheme();
  var Box = createBox({
    themeId: THEME_ID,
    defaultTheme: defaultTheme,
    defaultClassName: boxClasses$1.root,
    generateClassName: ClassNameGenerator$1.generate
  });
  Box.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * @ignore
     */
    children: PropTypes.node,
    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var Box$1 = Box;

  var MoreHorizIcon = createSvgIcon( /*#__PURE__*/jsxRuntime_1("path", {
    d: "M6 10c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm12 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-6 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"
  }), 'MoreHoriz');

  var BreadcrumbCollapsedButton = styled$1(ButtonBase$1)(function (_ref) {
    var theme = _ref.theme;
    return _extends({
      display: 'flex',
      marginLeft: "calc(".concat(theme.spacing(1), " * 0.5)"),
      marginRight: "calc(".concat(theme.spacing(1), " * 0.5)")
    }, theme.palette.mode === 'light' ? {
      backgroundColor: theme.palette.grey[100],
      color: theme.palette.grey[700]
    } : {
      backgroundColor: theme.palette.grey[700],
      color: theme.palette.grey[100]
    }, {
      borderRadius: 2,
      '&:hover, &:focus': _extends({}, theme.palette.mode === 'light' ? {
        backgroundColor: theme.palette.grey[200]
      } : {
        backgroundColor: theme.palette.grey[600]
      }),
      '&:active': _extends({
        boxShadow: theme.shadows[0]
      }, theme.palette.mode === 'light' ? {
        backgroundColor: emphasize(theme.palette.grey[200], 0.12)
      } : {
        backgroundColor: emphasize(theme.palette.grey[600], 0.12)
      })
    });
  });
  var BreadcrumbCollapsedIcon = styled$1(MoreHorizIcon)({
    width: 24,
    height: 16
  });

  /**
   * @ignore - internal component.
   */
  function BreadcrumbCollapsed(props) {
    var _props$slots = props.slots,
      slots = _props$slots === void 0 ? {} : _props$slots,
      _props$slotProps = props.slotProps,
      slotProps = _props$slotProps === void 0 ? {} : _props$slotProps,
      otherProps = _objectWithoutProperties(props, ["slots", "slotProps"]);
    var ownerState = props;
    return /*#__PURE__*/jsxRuntime_1("li", {
      children: /*#__PURE__*/jsxRuntime_1(BreadcrumbCollapsedButton, _extends({
        focusRipple: true
      }, otherProps, {
        ownerState: ownerState,
        children: /*#__PURE__*/jsxRuntime_1(BreadcrumbCollapsedIcon, _extends({
          as: slots.CollapsedIcon,
          ownerState: ownerState
        }, slotProps.collapsedIcon))
      }))
    });
  }
  BreadcrumbCollapsed.propTypes = {
    /**
     * The props used for the CollapsedIcon slot.
     * @default {}
     */
    slotProps: PropTypes.shape({
      collapsedIcon: PropTypes.oneOfType([PropTypes.func, PropTypes.object])
    }),
    /**
     * The components used for each slot inside the BreadcumbCollapsed.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    slots: PropTypes.shape({
      CollapsedIcon: PropTypes.elementType
    }),
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.object
  } ;

  function getBreadcrumbsUtilityClass(slot) {
    return generateUtilityClass$1('MuiBreadcrumbs', slot);
  }
  var breadcrumbsClasses = generateUtilityClasses$1('MuiBreadcrumbs', ['root', 'ol', 'li', 'separator']);
  var breadcrumbsClasses$1 = breadcrumbsClasses;

  var useUtilityClasses$1q = function useUtilityClasses(ownerState) {
    var classes = ownerState.classes;
    var slots = {
      root: ['root'],
      li: ['li'],
      ol: ['ol'],
      separator: ['separator']
    };
    return composeClasses(slots, getBreadcrumbsUtilityClass, classes);
  };
  var BreadcrumbsRoot = styled$1(Typography$1, {
    name: 'MuiBreadcrumbs',
    slot: 'Root',
    overridesResolver: function overridesResolver(props, styles) {
      return [_defineProperty({}, "& .".concat(breadcrumbsClasses$1.li), styles.li), styles.root];
    }
  })({});
  var BreadcrumbsOl = styled$1('ol', {
    name: 'MuiBreadcrumbs',
    slot: 'Ol',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.ol;
    }
  })({
    display: 'flex',
    flexWrap: 'wrap',
    alignItems: 'center',
    padding: 0,
    margin: 0,
    listStyle: 'none'
  });
  var BreadcrumbsSeparator = styled$1('li', {
    name: 'MuiBreadcrumbs',
    slot: 'Separator',
    overridesResolver: function overridesResolver(props, styles) {
      return styles.separator;
    }
  })({
    display: 'flex',
    userSelect: 'none',
    marginLeft: 8,
    marginRight: 8
  });
  function insertSeparators(items, className, separator, ownerState) {
    return items.reduce(function (acc, current, index) {
      if (index < items.length - 1) {
        acc = acc.concat(current, /*#__PURE__*/jsxRuntime_1(BreadcrumbsSeparator, {
          "aria-hidden": true,
          className: className,
          ownerState: ownerState,
          children: separator
        }, "separator-".concat(index)));
      } else {
        acc.push(current);
      }
      return acc;
    }, []);
  }
  var Breadcrumbs = /*#__PURE__*/React__namespace.forwardRef(function Breadcrumbs(inProps, ref) {
    var props = useThemeProps$b({
      props: inProps,
      name: 'MuiBreadcrumbs'
    });
    var children = props.children,
      className = props.className,
      _props$component = props.component,
      component = _props$component === void 0 ? 'nav' : _props$component,
      _props$slots = props.slots,
      slots = _props$slots === void 0 ? {} : _props$slots,
      _props$slotProps = props.slotProps,
      slotProps = _props$slotProps === void 0 ? {} : _props$slotProps,
      _props$expandText = props.expandText,
      expandText = _props$expandText === void 0 ? 'Show path' : _props$expandText,
      _props$itemsAfterColl = props.itemsAfterCollapse,
      itemsAfterCollapse = _props$itemsAfterColl === void 0 ? 1 : _props$itemsAfterColl,
      _props$itemsBeforeCol = props.itemsBeforeCollapse,
      itemsBeforeCollapse = _props$itemsBeforeCol === void 0 ? 1 : _props$itemsBeforeCol,
      _props$maxItems = props.maxItems,
      maxItems = _props$maxItems === void 0 ? 8 : _props$maxItems,
      _props$separator = props.separator,
      separator = _props$separator === void 0 ? '/' : _props$separator,
      other = _objectWithoutProperties(props, ["children", "className", "component", "slots", "slotProps", "expandText", "itemsAfterCollapse", "itemsBeforeCollapse", "maxItems", "separator"]);
    var _React$useState = React__namespace.useState(false),
      expanded = _React$useState[0],
      setExpanded = _React$useState[1];
    var ownerState = _extends({}, props, {
      component: component,
      expanded: expanded,
      expandText: expandText,
      itemsAfterCollapse: itemsAfterCollapse,
      itemsBeforeCollapse: itemsBeforeCollapse,
      maxItems: maxItems,
      separator: separator
    });
    var classes = useUtilityClasses$1q(ownerState);
    var collapsedIconSlotProps = useSlotProps({
      elementType: slots.CollapsedIcon,
      externalSlotProps: slotProps.collapsedIcon,
      ownerState: ownerState
    });
    var listRef = React__namespace.useRef(null);
    var renderItemsBeforeAndAfter = function renderItemsBeforeAndAfter(allItems) {
      var handleClickExpand = function handleClickExpand() {
        setExpanded(true);

        // The clicked element received the focus but gets removed from the DOM.
        // Let's keep the focus in the component after expanding.
        // Moving it to the <ol> or <nav> does not cause any announcement in NVDA.
        // By moving it to some link/button at least we have some announcement.
        var focusable = listRef.current.querySelector('a[href],button,[tabindex]');
        if (focusable) {
          focusable.focus();
        }
      };

      // This defends against someone passing weird input, to ensure that if all
      // items would be shown anyway, we just show all items without the EllipsisItem
      if (itemsBeforeCollapse + itemsAfterCollapse >= allItems.length) {
        {
          console.error(['MUI: You have provided an invalid combination of props to the Breadcrumbs.', "itemsAfterCollapse={".concat(itemsAfterCollapse, "} + itemsBeforeCollapse={").concat(itemsBeforeCollapse, "} >= maxItems={").concat(maxItems, "}")].join('\n'));
        }
        return allItems;
      }
      return [].concat(_toConsumableArray(allItems.slice(0, itemsBeforeCollapse)), [/*#__PURE__*/jsxRuntime_1(BreadcrumbCollapsed, {
        "aria-label": expandText,
        slots: {
          CollapsedIcon: slots.CollapsedIcon
        },
        slotProps: {
          collapsedIcon: collapsedIconSlotProps
        },
        onClick: handleClickExpand
      }, "ellipsis")], _toConsumableArray(allItems.slice(allItems.length - itemsAfterCollapse, allItems.length)));
    };
    var allItems = React__namespace.Children.toArray(children).filter(function (child) {
      {
        if (reactIs_2(child)) {
          console.error(["MUI: The Breadcrumbs component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
        }
      }
      return /*#__PURE__*/React__namespace.isValidElement(child);
    }).map(function (child, index) {
      return /*#__PURE__*/jsxRuntime_1("li", {
        className: classes.li,
        children: child
      }, "child-".concat(index));
    });
    return /*#__PURE__*/jsxRuntime_1(BreadcrumbsRoot, _extends({
      ref: ref,
      component: component,
      color: "text.secondary",
      className: clsx(classes.root, className),
      ownerState: ownerState
    }, other, {
      children: /*#__PURE__*/jsxRuntime_1(BreadcrumbsOl, {
        className: classes.ol,
        ref: listRef,
        ownerState: ownerState,
        children: insertSeparators(expanded || maxItems && allItems.length <= maxItems ? allItems : renderItemsBeforeAndAfter(allItems), classes.separator, separator, ownerState)
      })
    }));
  });
  Breadcrumbs.propTypes /* remove-proptypes */ = {
    // ┌────────────────────────────── Warning ──────────────────────────────┐
    // │ These PropTypes are generated from the TypeScript type definitions. │
    // │    To update them, edit the d.ts file and run `pnpm proptypes`.     │
    // └─────────────────────────────────────────────────────────────────────┘
    /**
     * The content of the component.
     */
    children: PropTypes.node,
    /**
     * Override or extend the styles applied to the component.
     */
    classes: PropTypes.object,
    /**
     * @ignore
     */
    className: PropTypes.string,
    /**
     * The component used for the root node.
     * Either a string to use a HTML element or a component.
     */
    component: PropTypes.elementType,
    /**
     * Override the default label for the expand button.
     *
     * For localization purposes, you can use the provided [translations](/material-ui/guides/localization/).
     * @default 'Show path'
     */
    expandText: PropTypes.string,
    /**
     * If max items is exceeded, the number of items to show after the ellipsis.
     * @default 1
     */
    itemsAfterCollapse: integerPropType,
    /**
     * If max items is exceeded, the number of items to show before the ellipsis.
     * @default 1
     */
    itemsBeforeCollapse: integerPropType,
    /**
     * Specifies the maximum number of breadcrumbs to display. When there are more
     * than the maximum number, only the first `itemsBeforeCollapse` and last `itemsAfterCollapse`
     * will be shown, with an ellipsis in between.
     * @default 8
     */
    maxItems: integerPropType,
    /**
     * Custom separator node.
     * @default '/'
     */
    separator: PropTypes.node,
    /**
     * The props used for each slot inside the Breadcumb.
     * @default {}
     */
    slotProps: PropTypes.shape({
      collapsedIcon: PropTypes.oneOfType([PropTypes.func, PropTypes.object])
    }),
    /**
     * The components used for each slot inside the Breadcumb.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    slots: PropTypes.shape({
      CollapsedIcon: PropTypes.elementType
    }),
    /**
     * The system prop that allows defining system overrides as well as additional CSS styles.
     */
    sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
  } ;
  var Breadcrumbs$1 = Breadcrumbs;

  function getButtonUtilityClass(slot) {
    return generateUtilityClass$1('MuiButton', slot);
  }
  var buttonClasses = generateUtilityClasses$1('MuiButton', ['root', 'text', 'textInherit', 'textPrimary', 'textSecondary', 'textSuccess', 'textError', 'textInfo', 'textWarning', 'outlined', 'outlinedInherit', 'outlinedPrimary', 'outlinedSecondary', 'outlinedSuccess', 'outlinedError', 'outlinedInfo', 'outlinedWarning', 'contained', 'containedInherit', 'containedPrimary', 'containedSecondary', 'containedSuccess', 'containedError', 'containedInfo', 'containedWarning', 'disableElevation', 'focusVisible', 'disabled', 'colorInherit', 'colorPrimary', 'colorSecondary', 'colorSuccess', 'colorError', 'colorInfo', 'colorWarning', 'textSizeSmall', 'textSizeMedium', 'textSizeLarge', 'outlinedSizeSmall', 'outlinedSizeMedium', 'outlinedSizeLarge', 'containedSizeSmall', 'containedSizeMedium', 'containedSizeLarge', 'sizeMedium', 'sizeSmall', 'sizeLarge', 'fullWidth', 'startIcon', 'endIcon', 'icon', 'iconSizeSmall', 'iconSizeMedium', 'iconSizeLarge']);
  var buttonClasses$1 = buttonClasses;

  /**
   * @ignore - internal component.
   */
  var ButtonGroupContext = /*#__PURE__*/React__namespace.createContext({});
  {
    ButtonGroupContext.displayName = 'ButtonGroupContext';
  }
  var ButtonGroupContext$1 = ButtonGroupContext;

  /**
   * @ignore - internal component.
   */
  var ButtonGroupButtonContext = /*#__PURE__*/React__namespace.createContext(undefined);
  {
    ButtonGroupButtonContext.displayName = 'ButtonGroupButtonContext';
  }
  var ButtonGroupButtonContext$1 = ButtonGroupButtonContext;

  var useUtilityCl