import { Command } from '../command';
import { Hook, Hooks, PJSON, Topic } from '../interfaces';
import { ArchTypes, Config as IConfig, LoadOptions, PlatformTypes, VersionDetails } from '../interfaces/config';
import { Plugin as IPlugin, Options } from '../interfaces/plugin';
import { Theme } from '../interfaces/theme';
export declare class Config implements IConfig {
    options: Options;
    arch: ArchTypes;
    bin: string;
    binAliases?: string[];
    binPath?: string;
    cacheDir: string;
    channel: string;
    configDir: string;
    dataDir: string;
    debug: number;
    dirname: string;
    errlog: string;
    flexibleTaxonomy: boolean;
    home: string;
    name: string;
    npmRegistry?: string;
    nsisCustomization?: string;
    pjson: PJSON.CLI;
    platform: PlatformTypes;
    plugins: Map<string, IPlugin>;
    root: string;
    shell: string;
    theme?: Theme;
    topicSeparator: ' ' | ':';
    userAgent: string;
    userPJSON?: PJSON.User;
    valid: boolean;
    version: string;
    protected warned: boolean;
    windows: boolean;
    private _base;
    private _commandIDs;
    private _commands;
    private _topics;
    private commandPermutations;
    private pluginLoader;
    private rootPlugin;
    private topicPermutations;
    constructor(options: Options);
    static load(opts?: LoadOptions): Promise<Config>;
    static get rootPlugin(): IPlugin | undefined;
    get commandIDs(): string[];
    get commands(): Command.Loadable[];
    protected get isProd(): boolean;
    get topics(): Topic[];
    get versionDetails(): VersionDetails;
    protected dir(category: 'cache' | 'config' | 'data'): string;
    findCommand(id: string, opts: {
        must: true;
    }): Command.Loadable;
    findCommand(id: string, opts?: {
        must: boolean;
    }): Command.Loadable | undefined;
    /**
     * Find all command ids that include the provided command id.
     *
     * For example, if the command ids are:
     * - foo:bar:baz
     * - one:two:three
     *
     * `bar` would return `foo:bar:baz`
     *
     * @param partialCmdId string
     * @param argv string[] process.argv containing the flags and arguments provided by the user
     * @returns string[]
     */
    findMatches(partialCmdId: string, argv: string[]): Command.Loadable[];
    findTopic(id: string, opts: {
        must: true;
    }): Topic;
    findTopic(id: string, opts?: {
        must: boolean;
    }): Topic | undefined;
    /**
     * Returns an array of all command ids. If flexible taxonomy is enabled then all permutations will be appended to the array.
     * @returns string[]
     */
    getAllCommandIDs(): string[];
    /**
     * Returns an array of all commands. If flexible taxonomy is enabled then all permutations will be appended to the array.
     * @returns Command.Loadable[]
     */
    getAllCommands(): Command.Loadable[];
    getPluginsList(): IPlugin[];
    load(): Promise<void>;
    loadPluginsAndCommands(opts?: {
        force: boolean;
    }): Promise<void>;
    loadThemes(): Promise<{
        file: string | undefined;
        theme: Theme | undefined;
    }>;
    protected macosCacheDir(): string | undefined;
    runCommand<T = unknown>(id: string, argv?: string[], cachedCommand?: Command.Loadable | null): Promise<T>;
    runHook<T extends keyof Hooks>(event: T, opts: Hooks[T]['options'], timeout?: number, captureErrors?: boolean): Promise<Hook.Result<Hooks[T]['return']>>;
    s3Key(type: keyof PJSON.S3.Templates, ext?: '.tar.gz' | '.tar.xz' | IConfig.s3Key.Options, options?: IConfig.s3Key.Options): string;
    s3Url(key: string): string;
    scopedEnvVar(k: string): string | undefined;
    /**
     * this DOES NOT account for bin aliases, use scopedEnvVarKeys instead which will account for bin aliases
     * @param {string} k, the unscoped key you want to get the value for
     * @returns {string} returns the env var key
     */
    scopedEnvVarKey(k: string): string;
    /**
     * gets the scoped env var keys for a given key, including bin aliases
     * @param {string} k, the env key e.g. 'debug'
     * @returns {string[]} e.g. ['SF_DEBUG', 'SFDX_DEBUG']
     */
    scopedEnvVarKeys(k: string): string[];
    scopedEnvVarTrue(k: string): boolean;
    protected warn(err: {
        detail: string;
        name: string;
    } | Error | string, scope?: string): void;
    protected windowsHome(): string | undefined;
    protected windowsHomedriveHome(): string | undefined;
    protected windowsUserprofileHome(): string | undefined;
    protected _debug(): number;
    protected _shell(): string;
    /**
     * This method is responsible for locating the correct plugin to use for a named command id
     * It searches the {Config} registered commands to match either the raw command id or the command alias
     * It is possible that more than one command will be found. This is due the ability of two distinct plugins to
     * create the same command or command alias.
     *
     * In the case of more than one found command, the function will select the command based on the order in which
     * the plugin is included in the package.json `oclif.plugins` list. The command that occurs first in the list
     * is selected as the command to run.
     *
     * Commands can also be present from either an install or a link. When a command is one of these and a core plugin
     * is present, this function defers to the core plugin.
     *
     * If there is not a core plugin command present, this function will return the first
     * plugin as discovered (will not change the order)
     *
     * @param commands commands to determine the priority of
     * @returns command instance {Command.Loadable} or undefined
     */
    private determinePriority;
    private getCmdLookupId;
    private getTopicLookupId;
    /**
     * Insert legacy plugins
     *
     * Replace invalid CLI plugins (cli-engine plugins, mostly Heroku) loaded via `this.loadPlugins`
     * with oclif-compatible ones returned by @oclif/plugin-legacy init hook.
     *
     * @param plugins array of oclif-compatible plugins
     * @returns void
     */
    private insertLegacyPlugins;
    private isJitPluginCommand;
    private loadCommands;
    private loadTopics;
}
