import { Command, Interfaces } from '@oclif/core';
import Plugins from '../../plugins';
export default class PluginsInstall extends Command {
    static description: string;
    static usage: string;
    static examples: string[];
    static strict: boolean;
    static args: {
        plugin: import("@oclif/core/lib/interfaces/parser").Arg<string, Record<string, unknown>>;
    };
    static flags: {
        help: Interfaces.BooleanFlag<void>;
        verbose: Interfaces.BooleanFlag<boolean>;
        force: Interfaces.BooleanFlag<boolean>;
        jit: Interfaces.BooleanFlag<boolean>;
    };
    static aliases: string[];
    plugins: Plugins;
    flags: Interfaces.InferredFlags<typeof PluginsInstall.flags>;
    run(): Promise<void>;
    parsePlugin(input: string): Promise<{
        name: string;
        tag: string;
        type: 'npm';
    } | {
        url: string;
        type: 'repo';
    }>;
}
