import { Interfaces } from '@oclif/core';
import Yarn from './yarn';
export default class Plugins {
    config: Interfaces.Config;
    verbose: boolean;
    readonly yarn: Yarn;
    private readonly debug;
    constructor(config: Interfaces.Config);
    pjson(): Promise<Interfaces.PJSON.User>;
    list(): Promise<(Interfaces.PJSON.PluginTypes.User | Interfaces.PJSON.PluginTypes.Link)[]>;
    install(name: string, { tag, force }?: {
        tag?: string | undefined;
        force?: boolean | undefined;
    }): Promise<Interfaces.Config>;
    /**
     * If a yarn.lock or oclif.lock exists at the root, refresh dependencies by
     * rerunning yarn. If options.prod is true, only install production dependencies.
     *
     * As of v9 npm will always ignore the yarn.lock during `npm pack`]
     * (see https://github.com/npm/cli/issues/6738). To get around this plugins can
     * rename yarn.lock to oclif.lock before running `npm pack` using `oclif lock`.
     *
     * We still check for the existence of yarn.lock since it could be included if a plugin was
     * packed using yarn or v8 of npm. Plugins installed directly from a git url will also
     * have a yarn.lock.
     *
     * @param options {prod: boolean, all: boolean}
     * @param roots string[]
     * @returns Promise<void>
     */
    refresh(options: {
        prod: boolean;
        all: boolean;
    }, ...roots: string[]): Promise<void>;
    link(p: string, { install }: {
        install: boolean;
    }): Promise<void>;
    add(...plugins: Interfaces.PJSON.PluginTypes[]): Promise<void>;
    remove(name: string): Promise<void>;
    uninstall(name: string): Promise<void>;
    update(): Promise<void>;
    hasPlugin(name: string): Promise<Interfaces.PJSON.PluginTypes.Link | Interfaces.PJSON.User | boolean>;
    yarnNodeVersion(): Promise<string | undefined>;
    unfriendlyName(name: string): string | undefined;
    maybeUnfriendlyName(name: string): Promise<string>;
    friendlyName(name: string): string;
    private createPJSON;
    private get pjsonPath();
    private npmHasPackage;
    private savePJSON;
    private normalizePlugins;
    private isValidPlugin;
}
