import type { AnyAction, ActionCallback, Unsubscribe } from './actions/types';
import type { TransportDispatch, Dispatcher } from './client/types';
declare global {
    interface Window {
        MobileWebView?: {
            postMessage(message?: string): void;
        };
    }
}
export declare enum Context {
    Modal = "Modal",
    Main = "Main"
}
/**
 * @deprecated Not to be used, use `MessageEvent` instead.
 * @internal
 */
export interface HandlerData {
    data: AnyAction;
}
/**
 * @internal
 */
export interface MessageEvent<T = any> {
    origin: string;
    data: T;
    source?: any;
}
/**
 * @internal
 */
export interface HostFrame {
    addEventListener(type: 'message', listener: (event: MessageEvent) => any): void;
    postMessage(message: any, origin: string): void;
}
/**
 * @internal
 */
export interface FrameWindow {
    postMessage(message: any, origin: string): void;
    /**
     * Only needed when Web is loaded inside unframed mode on mobile
     */
    location?: {
        replace(url: string): void;
    };
}
/**
 * @internal
 */
export interface Frame {
    host: HostFrame | null;
    window: FrameWindow | null;
}
/**
 * @internal
 */
export declare type Handler = (event: MessageEvent) => void;
/**
 * @internal
 */
export interface MessageTransport {
    dispatch(message: TransportDispatch): void;
    hostFrame: HostFrame;
    localOrigin: string;
    subscribe(handler: Handler): () => void;
}
export interface ContextualMessageTransport extends MessageTransport {
    context: Context;
    frameWindow: FrameWindow | null;
    dispatch(message: any): void;
}
/**
 * Create a MessageTransport from a Frame.
 * @remarks
 * Used on the host-side to create a postMessage MessageTransport.
 * @beta
 */
export declare function fromFrame(frame: Frame, localOrigin: string, context: Context): ContextualMessageTransport;
/**
 * Create a MessageTransport from a parent window.
 * @remarks
 * Used on the client-side to create a postMessage MessageTransport.
 * @internalremarks
 * In unframed mode, message should be dispatched via MobileWebView.postMessage instead of postMessage.
 * @beta
 */
export declare function fromWindow(contentWindow: Window, localOrigin: string): MessageTransport;
/**
 * @internal
 */
export interface ActionListener {
    id?: string;
    callback(data: any): void;
}
/**
 * @internal
 */
export interface ActionListenersMap {
    [index: string]: ActionListener[];
}
/**
 * @internal
 */
export interface Subscribe {
    (callback: ActionCallback, id?: string): Unsubscribe;
    (eventNameSpace: string, callback: ActionCallback, id?: string): Unsubscribe;
}
/**
 * @internal
 */
export interface TransportListener {
    createSubscribeHandler(dispatcher?: Dispatcher): Subscribe;
    handleMessage(message: any): void;
    handleActionDispatch(action: AnyAction): boolean;
}
export declare function createTransportListener(): TransportListener;
