import { ClientApplication } from '../client/types';
import { ActionCallback, ActionSetInterface, ActionSubscription, Component, ErrorCallback, Unsubscribe } from './types';
export declare abstract class ActionSet implements ActionSetInterface {
    app: ClientApplication;
    type: string;
    group: string;
    readonly id: string;
    readonly defaultGroup: string;
    subgroups: string[];
    subscriptions: ActionSubscription[];
    constructor(app: ClientApplication, type: string, group: string, id?: string);
    set(..._: any[]): void;
    get component(): Component;
    updateSubscription(subscriptionToRemove: ActionSubscription, group: string, subgroups: string[]): Unsubscribe;
    error(callback: ErrorCallback): Unsubscribe;
    subscribe(eventName: string, callback: ActionCallback, component?: Component, currentIndex?: number): Unsubscribe;
    unsubscribe(resetOnly?: boolean): this;
}
export declare abstract class ActionSetWithChildren extends ActionSet {
    children: ActionSetChildAction[];
    unsubscribe(unsubscribeChildren?: boolean, resetParentOnly?: boolean): this;
    getChild(id: string): ActionSetChildAction | undefined;
    getChildIndex(id: string): number;
    getChildSubscriptions(id: string, eventType?: string): ActionSubscription[];
    addChild(child: ActionSetChildAction, group: string, subgroups: string[]): this;
    removeChild(id: string): this;
    subscribeToChild(child: ActionSetChildAction, eventName: string | string[], callback: (childData: any) => void): this;
    getUpdatedChildActions<A extends ActionSetChildAction>(newActions: A[], currentActions: A[]): A[] | undefined;
}
export declare function unsubscribeActions(subscriptions: ActionSubscription[], defaultGroup: string, reassign?: boolean): void;
export declare type ActionSetChildAction = ActionSet | ActionSetWithChildren;
