import { ClientApplication } from '../../client/types';
import { ActionSetWithChildren } from '../ActionSet';
import { ActionSetProps, Component, MetaAction } from '../types';
import { Button, Payload as ButtonPayload } from '../Button';
export declare enum Action {
    UPDATE = "UPDATE"
}
export interface Options {
    label: string;
    disabled?: boolean;
    buttons: Button[];
    plain?: boolean;
}
export interface Payload {
    readonly id: string;
    label: string;
    disabled?: boolean;
    buttons: ButtonPayload[];
    plain?: boolean;
}
export interface ButtonGroupUpdateAction extends MetaAction {
    readonly group: string;
    payload: Payload;
}
export declare type ButtonGroupAction = ButtonGroupUpdateAction | MetaAction;
export declare function update(group: string, component: Component, props: Payload): ButtonGroupUpdateAction;
export declare function isGroupedButton(options: ButtonGroup | object): options is ButtonGroup;
export declare function isGroupedButtonPayload(payload: Payload | object): payload is Payload;
export declare class ButtonGroup extends ActionSetWithChildren implements ActionSetProps<Options, Payload> {
    label: string;
    disabled: boolean;
    plain: boolean;
    buttonsOptions: Button[];
    buttons: ButtonPayload[];
    constructor(app: ClientApplication, options: Options);
    get options(): Options;
    get payload(): Payload;
    set(options: Partial<Options>, shouldUpdate?: boolean): this;
    dispatch(action: Action): this;
    updateButtons(newPayload: ButtonPayload): void;
    protected getSingleButton(button: Button): ButtonPayload;
    protected getButtons(buttonOptions?: Button[]): ButtonPayload[];
}
export declare function create(app: ClientApplication, options: Options): ButtonGroup;
